//    crm_expr_isolate  - isolate a variable (includes mem management)
//  Copyright 2001-2004  William S. Yerazunis, all rights reserved.
//  
//  This software is licensed to the public under the Free Software
//  Foundation's GNU GPL, version 2.1.  You may obtain a copy of the
//  GPL by visiting the Free Software Foundations web site at
//  www.fsf.org, and a copy is included in this distribution.  
//
//  Other licenses may be negotiated; contact the 
//  author for details.  
//
//  include some standard files
#include "crm114_sysincludes.h"

//  include any local crm114 configuration file
#include "crm114_config.h"

//  include the crm114 data structures file
#include "crm114_structs.h"

//  and include the routine declarations file
#include "crm114.h"

//    the command line argc, argv
extern int prog_argc;
extern char **prog_argv;

//    the auxilliary input buffer (for WINDOW input)
extern char *newinputbuf;

//    the globals used when we need a big buffer  - allocated once, used 
//    wherever needed.  These are sized to the same size as the data window.
extern char *inbuf;
extern char *outbuf;
extern char *tempbuf;


//           Allow creation of a temporary isolated variable;
//	   this lives in the same big buffer as the environ
//           args, the arg0 args, and the basic formatting args
//           (like :_nl:, :_ht:, :_bs:, etc).

int crm_expr_isolate (CSL_CELL *csl, ARGPARSE_BLOCK *apb)
{
  char temp_vars [MAX_VARNAME];
  long tvlen;
  long vn_start_here;
  long vstart;
  long vlen;
  long mc;
  long done;
  long vallen;
  
  if (user_trace)
    fprintf (stderr, "executing an ISOLATE statement\n");

  //    get the list of variable names
  //
  crm_get_pgm_arg (temp_vars, MAX_VARNAME, apb->p1start, apb->p1len); 
  tvlen = crm_nexpandvar (temp_vars, apb->p1len, MAX_VARNAME);
  if (tvlen == 0)
    {
      nonfatalerror( "This statement is missing the variable to isolate"
		     " so I'll just ignore the whole statement.", "");
    }

  if (internal_trace)
    fprintf (stderr, "  creating isolated vars: ***%s***\n", temp_vars);

  done = 0;
  mc = 0;

  //  Now, find the vars (space-delimited, doncha know) and make them
  //  isolated.
  //
  vstart = 0;
  vlen = 0;
  vn_start_here = 0;
  while (!done)
    {
      crm_nextword (temp_vars, tvlen, vn_start_here, &vstart, &vlen);
      vn_start_here = vstart + vlen + 1;
      if (vlen == 0) 
	{
	  done = 1;
	}
      else
	{
	  //        must make a copy of the varname.
	  char vname[MAX_VARNAME];
	  long vmidx;
	  memmove (vname, &(temp_vars[vstart]), vlen);
	  vname [vlen] = '\000';
	  if (vlen < 3)
	    {
	      nonfatalerror ("The variable you're asking me to ISOLATE "
			     " has an utterly bogus name.  I'll ignore"
			     " the rest of the statement", " ");
	      break;
	    };
	  if (strcmp (vname, ":_dw:") != 0)
	    {
	      vmidx = crm_vht_lookup (vht, vname, vlen);
	      //
	      //        get initial value - that's the slashed value.
	      crm_get_pgm_arg (tempbuf, data_window_size, 
			       apb->s1start, apb->s1len);
	      //
	      //     Now, there's these cases
	      //     not preexisting, no /value/ -  isolate, set to ""
	      //     not preexisting, with /value/ -isolate, set /val/ 
	      //     preexisting, with /value/ - isolate, set to /val/ 
	      //     preexisting _dw, no /value/ - isolate, set to dwval.
	      //     preexisting isolated, no /value/ - copy value.
	      //     preexisting isolated, with /value/ - alter /value/
	      //
	      //    not preexisting
	      if (vht[vmidx] == NULL)
		{
		  if (!apb->s1start)
		    {
		      // no slash value- set to ""
		      crm_set_temp_nvar (vname, "", 0);
		    }
		  else
		    {
		      //  has a /value/, use it.
		      vallen = crm_nexpandvar(tempbuf, apb->s1len, 
					      data_window_size - tdw->nchars);
		      crm_set_temp_nvar (vname, tempbuf, vallen);
		    };
		}
	      else
		//      it IS preexisting- is it isolated?
		{
		  if ( vht[vmidx]->valtxt != tdw->filetext )
		    {
		      //  it's not isolated.  Make it isolated
		      //
		      //   now, do we have a /value/, or do we use the
		      //   preexisting value?
		      if (!apb->s1start)
			{
			  //  nope, no /value/, use old value
			  strcpy (tempbuf, ":*");
			  strncat (tempbuf, vname, vlen);
			  vallen = 
			    crm_nexpandvar (tempbuf, vlen+2, 
					    data_window_size - tdw->nchars);
			}
		      else
			{
			  //  yes, statement has a /value/
			  vallen = 
			    crm_nexpandvar(tempbuf, apb->s1len, 
					   data_window_size - tdw->nchars);
			};
		      //   now we can clobber the vht slot contents
		      vht[vmidx]->valtxt = tdw->filetext;
		      //        add a separater for good luck.
		      memmove (&(tdw->filetext[tdw->nchars]), "\n", 1);
		      tdw->nchars++;
		      //       
		      //       and put the value in
		      vht[vmidx]->vstart = tdw->nchars;
		      vht[vmidx]->vlen   = vallen;
		      memmove (&tdw->filetext [tdw->nchars], 
			       tempbuf, vallen);
		      tdw->nchars = tdw->nchars + vallen;
		      tdw->filetext[tdw->nchars] = '\000';
		      //   
		      //        and add a separater for good luck.
		      tdw->filetext[tdw->nchars]= '\n';
		      tdw->nchars++;
		    }
		  else
		    {
		      //  the variable is preexisting, and already
		      //  in the tdw.  So, really all we have to do
		      //  is set up the /val/, and do an alter.
		      //  However, if there is no slash value, we
		      //  really need to copy.

		      if (apb->s1start)
			{
			  //  yes, statement has a /value/
			  //    get the /value/
			  vallen = 
			    crm_nexpandvar(tempbuf, apb->s1len, 
					   data_window_size - tdw->nchars);
			  //  
			  //   and ALTER the value
			  //
			  crm_destructive_alter_nvariable (vname, 
							   vlen,
							   tempbuf,
							   vallen);
			}
		      else
			{
			  //   It is preexisting, in isolation, but
			  //   we're isolating again.  So we need to
			  //   copy again.  
			  //   GROT GROT GROT someday we should check
			  //   to see if there are any other vars that
			  //   share this var's memory.  If not, there's
			  //   no need to make this copy.
			  strcpy (tempbuf, ":*");
			  strncat (tempbuf, vname, vlen);
			  vallen = crm_nexpandvar (tempbuf, vlen+2, 
						   data_window_size - tdw->nchars);
			  //    and put that value into a new place
			  //    in the TDW.
			  vht[vmidx]->valtxt = tdw->filetext;
			  //        add a separater for good luck.
			  tdw->filetext[tdw->nchars] = '\n';
			  tdw->nchars++;
			  //       
			  //       and put the value in
			  vht[vmidx]->vstart = tdw->nchars;
			  vht[vmidx]->vlen   = vallen;
			  memmove (&tdw->filetext [tdw->nchars], 
				   tempbuf, vallen);
			  tdw->nchars = tdw->nchars + vallen;
			  tdw->filetext[tdw->nchars] = '\000';
			  //   
			  //        and add a separater for good luck.
			  tdw->filetext[tdw->nchars] = '\n';
			  tdw->nchars++;
			};
		    };
		};
	    }
	  else
	    {
	      nonfatalerror ("You can't ISOLATE the :_dw: data window! ",
			     "We'll just ignore that for now");
	    };
	};
      vstart = vstart + vlen;
      if (temp_vars[vstart] == '\000'
	  || vstart >= tvlen )
	done = 1;
    };
  return (0);
};
