// Description:
//   Particle type base.
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef _ParticleType_hpp_
#define _ParticleType_hpp_

#include <string>
#include <ParticleInfo.hpp>

class ParticleType
{
public:
    ParticleType( const string &name, bool manage = true);
    virtual ~ParticleType();

    virtual void init( ParticleInfo *p) = 0;
    virtual bool update( ParticleInfo *p) = 0;
    virtual void draw( ParticleInfo *p) = 0;

    virtual void hit( ParticleInfo *p, int /*damage*/) { p->tod = 0; }

    const string& name( void){ return _name;}

protected:
    void updatePrevs( ParticleInfo *p);
    void interpolate( ParticleInfo *p, ParticleInfo &pi);

private:
    const string _name;
};

#endif
