// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2003 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// combat.h
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_COMBAT_H
#define _INCLUDE_COMBAT_H

#include "list.h"
#include "unit.h"
#include "map.h"
#include "game.h"

#include "window.h"
#include "button.h"

#include "mapview.h"

class Combat : public Node {
public:
  Combat( Unit *att, Unit *def );
  Combat( SDL_RWops *file, Game *game );
  int Save( SDL_RWops *file ) const;

  void CalcModifiers( const Map *map );
  class CombatWindow *Resolve( MapWindow *mapwin, View *view );

  Unit *c_att;       // attacker
  Unit *c_def;       // defender
  signed char aamod;
  signed char admod;
  signed char damod; // defender only gets terrain bonus for attacks
  signed char ddmod;
};


// window displaying the results of the fight
class CombatWindow : public Window {
public:
  CombatWindow( Combat *combat, MapWindow *mapwin, View *view );

  virtual void Draw( void );

  ButtonWidget *button;

private:
  void DrawState( void );

  MapWindow *mapwin;

  Unit *att;
  Unit *def;
  Point apos;
  Point dpos;
  short startgroup1;
  short startgroup2;

  Rect msgbar1;
  Rect msgbar2;
  Rect att_anchor;
  Rect def_anchor;
  Rect clock[2][6];
};

#endif	/* _INCLUDE_COMBAT_H */

