"
" Filename: cream-playpen.vim
" Experiments, things in flux or unresolved.
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2001-2006  Steve Hall
"
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
"
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"
" Description:
" Stuff in testing (Cream developer only)
"

if !exists("g:cream_dev")
	finish
endif

" Toggleable Invisbles {{{1

"function! MyInvisibles(which)
"
"    if a:which == 1
"        set nolist
"        return
"    else
"        set list
"    endif
"
"    " reset
"    set listchars=
"    execute "set listchars+=precedes:" . nr2char(95)
"    execute "set listchars+=extends:" . nr2char(95)
"
"    if a:which >= 2
"        execute "set listchars+=tab:" . nr2char(187) . '\ '
"    else
"        execute 'set listchars+=tab:\ \ '
"    endif
"    if a:which >= 3
"        execute "set listchars+=eol:" . nr2char(182)
"    endif
"    if a:which >= 4
"        execute "set listchars+=trail:" . nr2char(183)
"    endif
"
"endfunction
"imap <silent> <F4>             <C-o>:call MyInvisibles(1)<CR>
"imap <silent> <F4><F4>         <C-o>:call MyInvisibles(2)<CR>
"imap <silent> <F4><F4><F4>     <C-o>:call MyInvisibles(3)<CR>
"imap <silent> <F4><F4><F4><F4> <C-o>:call MyInvisibles(4)<CR>

" Cream_copy_char_above() {{{1
function! Cream_copy_char_above()
	" position correction
	if getline('.') == ""
		let col = 0
	else
		let col = col('.')
	endif

	let str = getline(line('.') - 1)
	let chr = matchstr(str, '.', col)
	execute "normal a" . chr
endfunction
imap <silent> <F12> <C-o>:call Cream_copy_char_above()<CR>


" col pos via statusline {{{1

"function! TestCow()
"    echo "col pos = " . b:cursor_i
"endfunction
"imap <silent> <F12> <C-o>:call TestCow()<CR>


" Hook testing {{{1
function! Cream_hook_open(fname)

	" tests
	let match = 0
	
	" TEST 1: extension is "COW"
	if fnamemodify(a:fname, ':e') =~ "COW"
		let match = 1
	endif
	
	" TEST 2: last four chars of filename is "_NEW"
	" strip extension
	let str = fnamemodify(a:fname, ':r')
	" test last four chars
	if strpart(str, strlen(str) - 4) == "_NEW"
		let match = 1
	endif

	" OTHER TESTS

	" no match
	if match == 0
		" quit and continue normal open
		return 0
	endif

	" match
	let n = confirm(
		\ "Restriction match. Open read-only?\n" .
		\ "\n", "Read-only\n&Cancel", 1, "Info")
	if n == 1
		call Cream_file_open_readonly(a:fname)
	endif
	" return -1 to stop normal open process
	return -1

endfunction

" Test optional argument quantity {{{1
function! Cream_testme(...)

	if a:0 > 0
		echo "a:0 = " . a:0
		if exists("a:1")
			echo "a:1 = " . a:1
		endif
		if exists("a:2")
			echo "a:2 = " . a:2
		endif
		if exists("a:3")
			echo "a:3 = " . a:3
		endif
	endif
endfunction

" Cream_source_self() {{{1
if !exists("*Cream_source_self")
	function! Cream_source_self(mode)
	" source the current file as a Vim script

		if &filetype != "vim"
			call confirm(
				\ "Can only source Vim files.\n" .
				\ "\n", "&Ok", 1, "Info")
			return
		endif

		silent! update

		let n = Cream_source(expand("%"))
		if n == 1
			echo "Source successful."
		else
			call confirm(
				\ "Source errored.\n" .
				\ "\n", "&Ok", 1, "Info")
		endif

		if a:mode == "v"
			normal gv
		endif

	endfunction
endif

" auto fileformat to unix (on Windows) {{{1
"function! Cream_fileformat_unix()
"" ensure buffers are always unix format
"    " get buffer number
"    let mybufnr = bufnr("%")
"    " only if buffer is unnamed and doesn't exist
"    if  bufname(mybufnr) == ""
"    \&& bufexists(mybufnr) == 1
"        " remember unmodified state
"        if getbufvar(mybufnr, "&modified") == 0
"            let mod = 1
"        endif
"        " set the fileformat to unix
"        set ff=unix
"        " recover unmodifed state
"        if exists("mod")
"            set nomodified
"        endif
"    endif
"endfunction
" NOTE: uncomment this to activate!
"autocmd VimEnter,BufEnter * call Cream_fileformat_unix()

" highlighting attribute removal {{{1
function! Highlight_remove_attr(attr)
" remove attribute from current color scheme
" see ":help attr-list" for terms accepted

	if  a:attr != "bold"
	\&& a:attr != "underline"
	\&& a:attr != "reverse"
	\&& a:attr != "inverse"
	\&& a:attr != "italic"
	\&& a:attr != "standout"
		echo "Invalid argument to Highlight_remove_attr()."
		return -1
	endif

	" get current highlight configuration
	redir @x
	silent! highlight
	redir END
	" open temp buffer
	new
	" paste in
	put x

	" convert to vim syntax (from Mkcolorscheme.vim,
	"   http://vim.sourceforge.net/scripts/script.php?script_id=85)
	" delete empty and links lines
	silent! g/^$\| links /d
	" remove the xxx's
	silent! %s/ xxx / /
	" add highlight commands
	silent! %s/^/highlight /
	" protect spaces in some font names
	silent! %s/font=\(.*\)/font='\1'/

	" substitute attribute with "NONE"
	execute 'silent! %s/' . a:attr . '\([\w,]*\)/NONE\1/geI'
	" yank entire buffer
	normal ggVG
	" copy
	normal "xy
	" run
	execute @x

	" remove temp buffer
	bwipeout!

endfunction


" :Buffers {{{1
function! Buffers()
" same output as :buffers except omits help, directories, and
" new unmodified buffers

	redir @x
	silent! buffers
	redir END
	let @x = @x . "\n"

	let buf = 1
	let str = ""
	while buf <= bufnr('$')
		if  bufexists(buf)
		\&& getbufvar(buf, "&buftype") != "help"
		\&& !isdirectory(bufname(buf))
		\&&	s:IsNewUnMod(buf) != 1
			let pos1    = match(@x, '\n\s\+' . buf . '[ u]')
			"let pos1str = matchstr(@x, '\n\s\+' . buf . '[ u]')
			let pos2    = match(@x, '\n', pos1 + 1)
			"let pos2str = matchstr(@x, '\n', pos1 + 1)
			let str = str . strpart(@x, pos1, pos2 - pos1)
		endif
		let buf = buf + 1
	endwhile

	echo ":Buffers" . str

endfunction

function! s:IsNewUnMod(buf)
	if  bufname(a:buf) == ""
	\&& getbufvar(a:buf, "&modified") == 0
	\&& bufexists(a:buf) == 1
		return 1
	endif
endfunction

command! Buffers call Buffers()

" Justify selection bug {{{1

"set insertmode
"imap <F12> <C-o>:call JustifyRight()<CR>
"function! JustifyRight()

"    " remember
"    let mytextwidth = &textwidth
"    let myexpandtab = &expandtab
"    " sets
"    set textwidth=70
"    set expandtab

"    " select inner paragraph
"    normal vip

"    " get range (marks "'<" and "'>" are scoped pre-function call,
"    " can't use!)
"    let myfirstline = line(".")
"    normal o
"    let mylastline = line(".")
"    normal o

"    " put first range value first (necessary?)
"    if mylastline < myfirstline
"        let tmp = myfirstline
"        let myfirstline = mylastline
"        let mylastline = tmp
"    endif

"    " right justify
"    execute "silent! " . myfirstline . "," . mylastline . "right"

"    "*** BROKEN:
"    "startinsert
"    "normal i
"    execute "normal \<Esc>"
"    "***

"    " restore
"    let &textwidth = mytextwidth
"    let &expandtab = myexpandtab

"endfunction


" Example: Why <C-l><Esc> is evil. {{{1

"function! MyFunction()
"
"    "-------- Test area ----------
"    "23456789012345678901234567890
"    "23456789012345678901234567890
"    "23456789012345678901234567890
"    "23456789012345678901234567890
"    "-------- Test area ----------
"
"    " insert "Cow"
"    normal iCow
"    " back up
"    normal hh
"    " scroll screen up one line
"    execute "normal \<C-e>"
"    " move cursor back down one
"    normal gj
"endfunction

" incorrect:
"nmap <F12>           :call MyFunction()<CR>
"imap <F12>      <C-l>:call MyFunction()<CR><Esc>

" correct:
"nmap <F12>           :call MyFunction()<CR>
"imap <F12> <C-o>:call MyFunction()<CR>


" Associate Mime Type With Windows Registry {{{1
"
" From: Ben Peterson, Dan Sharp on vim-dev@vim.org list
" Date: 2003-01-14, 11:00am
" RE: Associating extensions to Vim (was RE: Win32 improvement: ...)
"
" Description:
"
" associate/unassociated vim with the extension of the current file
" 	:associate %:e
" 	:noassociate %:e

function! s:Associate(ext, remove)
" Arguments:
"   ext      extension to associate
"   remove   1 to associate, 0 to remove
"
	if a:remove
		silent exec '!assoc ' . a:ext . '='
	else
		silent exec '!assoc ' . a:ext . '=OpenInVim'
		"silent !ftype OpenInVim=path\to\gvim "$*"
		execute "silent !ftype OpenInVim=" . $VIMRUNTIME . "\\gvim.exe" . "\"$*\""
	endif
endfunction

command! Associate call s:Associate('.' . expand("%:e"), 0)
command! DeAssociate call s:Associate('.' . expand("%:e"), 1)

command! -nargs=1 AssociateArg call s:Associate('.' . <args>, 0)
command! -nargs=1 DeAssociateArg call s:Associate('.' . <args>, 1)


" Remaining key maps {{{1

"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
" functional

function! TestCow(arg)
	call confirm(
		\ a:arg . "\n" .
		\ "\n", "&Ok", 1, "Info")
endfunction

"......................................................................
" Brackets
"......................................................................
" Minus/Equals
imap <silent> <C-->       <C-o>:call TestCow("C--")<CR>
imap <silent> <C-_>       <C-o>:call TestCow("C-_")<CR>
imap <silent> <M-->       <C-o>:call TestCow("M--")<CR>
"......................................................................
" Backslash/Bar
"......................................................................
" Enter
imap <silent> <S-CR>       <C-o>:call TestCow("S-CR")<CR>
"imap <silent> <C-CR>   <C-o>:call TestCow("C-CR")<CR>
imap <silent> <C-S-CR> <C-o>:call TestCow("C-S-CR")<CR>
"imap <silent> <S-Enter>    <C-o>:call TestCow("S-Enter")<CR>
"......................................................................
" Space
"......................................................................
" Arrows
imap <silent> <C-M-Right>    <C-o>:call TestCow("C-M-Right")<CR>
"......................................................................
" PageUp/Down
"imap <silent> <M-PageUp>  <C-o>:call TestCow("M-PageUp")<CR>
"imap <silent> <M-PageDown> <C-o>:call TestCow("M-PageDown")<CR>
"......................................................................
" Comma/Period
imap <silent> <M-<>       <C-o>:call TestCow("M-\<")<CR>
imap <silent> <M->>       <C-o>:call TestCow("M->")<CR>
"......................................................................
" Letters

"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
" non-functional
""......................................................................
"" Brackets
"imap <silent> <C-[>       <C-o>:call TestCow()<CR>
"imap <silent> <C-S-]>     <C-o>:call TestCow()<CR>
"imap <silent> <C-S-[>     <C-o>:call TestCow()<CR>
"imap <silent> <C-}>       <C-o>:call TestCow()<CR>
"imap <silent> <C-{>       <C-o>:call TestCow()<CR>
""......................................................................
"" Parenthesis
"imap <silent> <C-S-0>     <C-o>:call TestCow()<CR>
"imap <silent> <C-)>       <C-o>:call TestCow()<CR>
"imap <silent> <C-S-9>     <C-o>:call TestCow()<CR>
"imap <silent> <M-S-9>     <C-o>:call TestCow()<CR>
"imap <silent> <M-S-(>     <C-o>:call TestCow()<CR>
"imap <silent> <C-M-(>     <C-o>:call TestCow()<CR>
"imap <silent> <C-M-9>     <C-o>:call TestCow()<CR>
"imap <silent> <C-(>       <C-o>:call TestCow()<CR>
""......................................................................
"" Minus/Equals
"imap <silent> <C-=>       <C-o>:call TestCow()<CR>
"imap <silent> <C-+>       <C-o>:call TestCow()<CR>
"imap <silent> <C-S-=>     <C-o>:call TestCow()<CR>
""......................................................................
"" Backslash/Bar
"imap <silent> <C-Bar>  <C-o>:call TestCow()<CR>
"imap <silent> <C-S-\>     <C-o>:call TestCow()<CR>
"imap <silent> <C-\|>      <C-o>:call TestCow()<CR>
"imap <silent> <C-|>     <C-o>:call TestCow()<CR>
"imap <silent> |     <C-o>:call TestCow()<CR>
"imap <silent> <C-M-\>     <C-o>:call TestCow()<CR>
""......................................................................
"" Enter
"inoremap <silent> <C-m>    <C-o>:call TestCow("C-m")<CR>
"imap <silent> <S-Return>   <C-o>:call TestCow("S-Return")<CR>
"imap <silent> <M-Return>   <C-o>:call TestCow("M-Return")<CR>
"imap <silent> <M-S-Return> <C-o>:call TestCow("M-S-Return")<CR>
"imap <silent> <C-M-Return> <C-o>:call TestCow("C-M-Return")<CR>
"imap <silent> <M-Enter>    <C-o>:call TestCow("M-Enter")<CR>
"imap <silent> <M-S-Enter>  <C-o>:call TestCow("M-S-Enter")<CR>
"imap <silent> <C-M-Enter>  <C-o>:call TestCow("C-M-Enter")<CR>
"imap <silent> <M-CR>       <C-o>:call TestCow("M-CR")<CR>
"imap <silent> <M-S-CR>     <C-o>:call TestCow("M-S-CR")<CR>
"imap <silent> <C-M-CR>     <C-o>:call TestCow("C-M-CR")<CR>
""......................................................................
"" Space
"imap <silent> <C-M-Space>  <C-o>:call TestCow()<CR>
"imap <silent> <M-S-Space>  <C-o>:call TestCow()<CR>
""......................................................................
"" Letters
"imap <silent> <C-S-t>     <C-o>:call TestCow()<CR>
"imap <silent> <C-b>       <C-o>:call TestCow("\<C-b>")<CR>
"imap <silent> <C-t>       <C-o>:call TestCow("\<C-t>")<CR>

"imap <silent> <C-j>       <C-o>:call TestCow("C-j")<CR>

"imap <silent> <C-i>       <C-o>:echo "C-i"<CR>
"imap <silent> <Tab>       <C-r>=Tab()<CR>
"function! Tab()
"    return nr2char(9)
"endfunction


" what exactly is in [[:punct:]] {{{1

function! Cream_whatis(collection)
" see :help /collection
" use "call Cream_whatis('[[:punct:]]')" or the like

	let mycollection = ""
	let i = 0
	while i < 256
		if match(nr2char(i), a:collection) == 0
			let mycollection = mycollection . i . ":  " . nr2char(i) . "\t"
		endif
		if i % 10 == 0
			let mycollection = mycollection . "\n"
		endif
		let i = i + 1
	endwhile

	echo mycollection

endfunction

" Find the <SID> of a specific script {{{1

"function! GetSID(script_name)
"" retrieve vim <SID> for a specific script
"" Source: http://groups.yahoo.com/group/vim/message/34855
"" Author: Sylvain Viart <viart.sylvain (at) videotron.ca>
"" Date:   2002-12-01
"    let old_reg_r = @r
"    redir @r
"    silent scriptnames
"    redir END

"    let regex = substitute(a:script_name, '[/\\]', '.', 'g')
"    let regex = "\\s\\+[0-9]\\+:\\s*[^\n]*" . regex
"    let l = matchstr(@r, regex)
"    let sid = matchstr(l, '[0-9]\+')

"    let @r = old_reg_r
"    return sid
"endfunction


"" in the sourced script
"function! <SID>GetVar(varname)
"    execute "let v = s:" . a:varname
"    return v
"endfunction

"" and then when you want a variable:
"let sid = GetSID('golbal/var.vim')
"" call the script function with the specified argument
"execute "let v = \<SNR>" . sid . "_Getvar(" . varname . ")"



" Fold column indictations {{{1

"set foldcolumn=2
"highlight FoldColumn guifg=Blue guibg=White


" current line highlighting methods {{{1

".....................................................................
" attempt 1
""*** Broken (CursorHold event is not triggered in insertmode)
"highlight CurrentLine guibg=darkgrey guifg=white
"function! Cream_highlight_currentline()
"	set hlsearch
"	set updatetime=100
"    autocmd CursorHold * execute 'match CurrentLine /\%' . line('.') . 'l.*/'
"	"autocmd! CursorHold * let @/ = '\%' . line('.') . 'l.*'
"	"let @/ = '\%' . line('.') . 'l.*'
"	"execute '/\%' . line('.') . 'l.*'
"endfunction
""call Cream_highlight_currentline()
"
""autocmd! CursorHold * set hlsearch
""autocmd CursorHold * let @/ = '\%' . line('.') . 'l.*'

".....................................................................
" attempt 2

"" Vim plugin file
"" Description:
"" Maintainer:  Torrin <torrin@torrin.net>
"" Last Change: 2002 JUN 21
"" Version:     2
"
"" If we have already loaded this file, don't load it again.
"if exists("loaded_highlightline")
"   finish
"endif
"let loaded_highlightline=1
"
"" Save compatable options
"let s:save_cpo = &cpo
"set cpo&vim
"
"let linehighlighted=0
"
""map <F2> :call <SID>HighlightLine()<CR>
""map <F3> :call <SID>UnHighlightLine()<CR>
"imap <F12> <C-o>:call <SID>HighlightLine()<CR>
"imap <S-F12> <C-o>:call <SID>UnHighlightLine()<CR>
"
"function! s:HighlightLine()
""   execute "syntax keyword OneLine \"" . getline(".") . "\""
"   if g:linehighlighted == 1
"       call <SID>UnHighlightLine()
"   endif
"   execute "syntax match OneLine +" . substitute(getline("."),"[+\"]",".","g") . "+ oneline"
"   execute "highlight default link OneLine Visual"
"   let g:linehighlighted = 1
"endfunction
"
"function! s:UnHighlightLine()
"   if g:linehighlighted == 1
"      execute "syntax clear OneLine"
"      let g:linehighlighted = 0
"   endif
"endfunction
"
"let &cpo = s:save_cpo
"unlet s:save_cpo


".....................................................................
" attempt 3

"----------------------------------------------------------------------
" Highlight greater than 70 columns (from :help match)
""*** Broken
"highlight rightMargin guifg=White guibg=Blue
""234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890
""        ^10       ^20       ^30       ^40       ^50       ^60       ^70       ^80       ^90       ^100

"match rightMargin /\%>70v.*/
"match rightMargin /\%70v./
"syntax match rightMargin /\%>70v.*/
"match rightMargin /\(\%70v.\|\%90v.\)/

"" only the 70th
""match  rightMargin  /\%>70v/
"
":highlight rightMargin term=bold ctermfg=blue guifg=blue
":match rightMargin /.\%>72v/
":highlight col8 ctermbg=grey guibg=grey
":match col8 /\%<8v.\%>7v/
"


"".....................................................................
"" attempt 4
"function! Cream_highlight_currentline()

"" abort
"return

"    " clear previous
"    call Cream_colors_reset()
"    call Cream_colors()
"    syntax reset
"    highlight CurrentLine NONE
"    redraw!

"    highlight CurrentLine term=reverse ctermbg=0 ctermfg=14 gui=none guibg=#ffffaa
"    execute "syntax match CurrentLine '\\%" . line('.') . "l.*$'"

"endfunction


"".....................................................................
"" attempt 5
"function! Cream_highlight_currentline()
"" Source: http://vim.sourceforge.net/tips/tip.php?tip_id=421

"    execute "match CurrentLine /\\%" . line('.') . "l/"

"endfunction



" Draw directory structure or genealogy tree {{{1
function! Cream_DrawTree()

	let @x = "\n"
	let @x = @x . "Genealogy\n"
	let @x = @x . "---------\n"
	let @x = @x . "A NAME (b.       , d.       )\n"
	let @x = @x . "  +-a NAME (b.       , d.       )\n"
	let @x = @x . "  |   +-A NAME (b.       , d.       )\n"
	let @x = @x . "  |   |   +-a NAME (b.       , d.       )\n"
	let @x = @x . "  |   |   |   +-A NAME (b.       , d.       )\n"
	let @x = @x . "  |   |   |   |   +-a NAME (b.       , d.       )\n"
	let @x = @x . "  |   |   |   |\n"
	let @x = @x . "  |   |   |   +-B NAME (b.       , d.       )\n"
	let @x = @x . "  |   |   |\n"
	let @x = @x . "  |   |   +-b NAME (b.       , d.       )\n"
	let @x = @x . "  |   |\n"
	let @x = @x . "  |   +-B NAME (b.       , d.       )\n"
	let @x = @x . "  |\n"
	let @x = @x . "  +-b NAME (b.       , d.       )\n"
	let @x = @x . "\n"
	let @x = @x . "\n"
	let @x = @x . "Directories\n"
	let @x = @x . "-----------\n"
	let @x = @x . "[ROOT]\n"
	let @x = @x . "+-- [FOLDER]\n"
	let @x = @x . "|   +-- [FOLDER]\n"
	let @x = @x . "|   |   +-- [FOLDER]\n"
	let @x = @x . "|   |   |   +-- [FOLDER]\n"
	let @x = @x . "|   |   |   |   +-- file\n"
	let @x = @x . "|   |   |   |\n"
	let @x = @x . "|   |   |   +-- file\n"
	let @x = @x . "|   |   |\n"
	let @x = @x . "|   |   +-- file\n"
	let @x = @x . "|   |\n"
	let @x = @x . "|   +-- file\n"
	let @x = @x . "|\n"
	let @x = @x . "+-- file\n"
	let @x = @x . "\n"

	put x

endfunction
" 1}}}
" vim:foldmethod=marker
