"=====================================================================
" cream-email-formatter.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2001-2006  Steve Hall
" 
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
" 
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
" 
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"
"
" Description:
" Mail clients destroy proper formatting, this script puts them back.
"


" register as a Cream add-on
if exists("$CREAM")

	call Cream_addon_register(
	\ 'Email Prettyfier', 
	\ "Re-format email to \"proper\" form.", 
	\ "Re-format email to \"proper\" form. (Currently only expands compressed >>> to > > > .)", 
	\ '&Email Prettyfier', 
	\ 'call Cream_email_formatter()', 
	\ '<Nil>'
	\ )
endif

function! Cream_email_formatter()
" re-format email to "proper" form.

	" if filetype not Vim, quit
	if &filetype != "txt" &&
	\  &filetype != "mail" &&
	\  &filetype != ""
		call confirm(
			\ "Function designed only for text files. Please check this document's filetype.\n" .
			\ "\n", "&Ok", 1, "Info")
		return
	endif

	" fold all functions
	"" TODO:
	"" o a little regexp help here, please?
	"" o Combinations of spaces and > disrupt (regexp would fix?)
	"silent! %substitute/^>>>>>>>>>> /> > > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>>>/> > > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>> /> > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>>/> > > > > > > > > /gei
	"silent! %substitute/^>>>>>>>> /> > > > > > > > /gei
	"silent! %substitute/^>>>>>>>>/> > > > > > > > /gei
	"silent! %substitute/^>>>>>>> /> > > > > > > /gei
	"silent! %substitute/^>>>>>>>/> > > > > > > /gei
	"silent! %substitute/^>>>>>> /> > > > > > /gei
	"silent! %substitute/^>>>>>>/> > > > > > /gei
	"silent! %substitute/^>>>>> /> > > > > /gei
	"silent! %substitute/^>>>>>/> > > > > /gei
	"silent! %substitute/^>>>> /> > > > /gei
	"silent! %substitute/^>>>>/> > > > /gei
	"silent! %substitute/^>>> /> > > /gei
	"silent! %substitute/^>>>/> > > /gei
	"silent! %substitute/^>> /> > /gei
	"silent! %substitute/^>>/> > /gei
	"silent! %substitute/^>\([^ ]\)/> \1/gei

	let i = 0
	while i < 10
		" need spaces
		silent! %s/^[ >]*\zs\(>\) \@!/\1 /ge
		" but not too many!
		silent! %s/^[> ]*\zs\(>\)  \+/\1 /ge
		let i = i + 1
	endwhile

endfunction

