"======================================================================
"cream-spell-dict.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
"
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
"
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"

" Description:
"
" This file contains all language-specific spelling concerns beyond
" those of the word dictionaries.
"


function! Cream_spell_dict_lang_chars()
" return valid word characters of current language-encoding

	let str = ""
	if match(g:CREAM_SPELL_LANG, "dut") != -1
		" by Thijs Max <n.t.p.max (at) student.tudelft.nl> 2004-01-27
		if &encoding == "latin1"
			let str = str . 'a-zA-Z0-9&\-_ƒŸµÀÁÂÄÆÇÈÉÊËÌÍÎÏÒÓÔÖÙÚÛÜÝÞßàáâäæçèéêëìíîïòóôöùúûüýþÿ'
		else
			let str = str . 'a-zA-Z0-9&\-_'
		endif
	endif
	if match(g:CREAM_SPELL_LANG, "eng") != -1
		" by Steve Hall
		if &encoding == "latin1"
			let str = str . 'a-zA-Z0-9&\-_'
		else
			let str = str . 'a-zA-Z0-9&\-_'
		endif
	endif
	if match(g:CREAM_SPELL_LANG, "fre") != -1
		" from Christian Goebel <goebbe (at) yahoo.com> 2002-11-23
		if &encoding == "latin1"
			let str = str . 'a-zA-Z0-9&\-_ÁáÂâÄäÇçÈèÉéÊêËëÎîÏïÔôÖöÛûÀà'
		else
			let str = str . 'a-zA-Z0-9&\-_'
		endif
	endif
	if match(g:CREAM_SPELL_LANG, "ger") != -1
		" by Wolfgang Hommel
		if &encoding == "latin1"
			let str = str . 'a-zA-Z0-9&\-_äÄüÜöÖß'
		else
			let str = str . 'a-zA-Z0-9&\-_'
		endif
	endif
	if match(g:CREAM_SPELL_LANG, "spa") != -1
		" from Jose Alberto Suarez Lopez <bass (at) gentoo.org>
		if &encoding == "latin1"
			let str = str . 'a-zA-Z0-9&\-_ÁáÉéÍíÑñÓóÚúÜü'
		else
			let str = str . 'a-zA-Z0-9&\-_'
		endif
	endif

	" empty (basic dictionary)
	if str == ""
		let str = 'a-zA-Z0-9&\-_'
	endif
	return str

endfunction


function! Cream_spell_dict_lang_wordparts()
" Qualify prefixes or endings not in dictionaries. We do this to
" considerably reduce the number of (slow) multi-word matches we must
" make in the dictionaries.

" TODO: Don't these belong in the cream-spell-dict*_1.vim files?!

	" Abbreviations, Possessives, Etc.  For these to be recognized
	" properly, these contractions' word prior to the "'" has been
	" removed from the keyword dictionaries and moved here.
	" avoids a lot of useless matches!
	if match(g:CREAM_SPELL_LANG, "dut") != -1
		syntax match GoodWord "'s\>"
		syntax match GoodWord "s'\>"
		syntax match GoodWord "ex-"
	endif
	if match(g:CREAM_SPELL_LANG, "eng") != -1
		syntax match GoodWord "'s\>"
		syntax match GoodWord "ex-"
	endif
	if match(g:CREAM_SPELL_LANG, "ger") != -1
		syntax match GoodWord "'s\>"
		syntax match GoodWord "ex-"
	endif

endfunction


function! Cream_spell_dict_lang_punctcase()
" catch errant case problems across punctuation or non-word structures

	" ellipses
	"
	" TEST PRECINCT:
	" cow. bells
	" cow. Bells
	" cow.  bells
	" cow.  Bells
	" cow.   bells
	" cow.   Bells
	"
	" cow...bells
	" cow... bells
	" cow...  bells
	"
	" cow....bells
	" cow....Bells
	" cow.... bells
	" cow.... Bells
	" cow....  bells
	" cow....  Bells
	" END TEST PRECINCT:

	" non-capitalized word after ellipses...
	syntax match GoodWord "\.\.\. \{0,2}\l\@="
	" ...but not non-capitalized word after ellipses plus period
	syntax match BadWord "\.\.\.\. \{0,2}\l"

	" non-lowercased end of words (in order, as required)
	" * required: period/question mark/exclamation mark
	" * optional: end-quotes (allow nested)
	" * required: returns/return-linefeeds/tabs/spaces
	" * optional: begin-quote (allow nested)
	" * optional: begin punctuation
	" * required: lowercase letter
	"
	" TEST PRECINCT:
	" cow. "bells
	" cow. 'bells
	" cow. `bells
	" cow. «bells
	" END TEST PRECINCT:
	"

	" Dutch (Antoine J. Mechelynck, 2002-08-03)
	if match(g:CREAM_SPELL_LANG, "dut") != -1
		if &encoding == "latin1"
			syntax match BadWord "[\.?!][\"']*[\r\n\t ]\+[\"'`]*\l"
		endif
	endif
	" English (Steve Hall)
	if match(g:CREAM_SPELL_LANG, "eng") != -1
		syntax match BadWord "[\.?!][\"']*[\r\n\t ]\+[\"'`]*\l"
	endif
	" French ()
	if match(g:CREAM_SPELL_LANG, "fre") != -1
		syntax match BadWord "[\.?!][\"']*[\r\n\t ]\+[\"'`]*\l"
	endif
	" German (Wolfgang Hommel, 2002-11-23)
	if match(g:CREAM_SPELL_LANG, "ger") != -1
		if &encoding == "latin1"
			syntax match BadWord "[\.?!][\"'«]*[\r\n\t ]\+[\"'»]*\l"
		endif
	endif
	" Spanish ()
	if match(g:CREAM_SPELL_LANG, "spa") != -1
		if &encoding == "latin1"
			syntax match BadWord "[\.?!][\"']*[\r\n\t ]\+[\"'`]*[¡¿]\=\l"
		endif
	endif

endfunction

" vim:fileencoding=latin1
