#!/bin/sh
# we assume this runs at the top of a Cream file structure

echo

# argument (optional) must be single and a directory
if [[ -n $1 && ! -d $1 ]]; then
	echo "Single (optional) argument '$1' must be a directory"
	echo "for the installation of Cream. (Default '/usr'.)"
	exit 1
fi

# set $VIMRUNTIME (no trailing slash)
echo "Finding \$VIMRUNTIME..."
# using perl
if [ `which perl` ] ; then
	echo "  Trying perl method..."
	# 1. by Luc St-Louis
	vim --cmd 'echo $VIMRUNTIME' --cmd 'quit' 2> /tmp/creamVIMRUNTIME
	VIMRUNTIME=`perl -pe 's/\r\n//g' /tmp/creamVIMRUNTIME`
	rm -f /tmp/creamVIMRUNTIME
fi
# if failed, try basic bash
if [ ! -n "$VIMRUNTIME" -o "$VIMRUNTIME" == "" ] ; then
	echo "  Trying bash method..."
	# 2. by Jacob Lerner
	VIMRUNTIME=`vim -e -T dumb --cmd 'exe "set t_cm=\<C-M>"|echo $VIMRUNTIME|quit' | tr -d '\015' `
fi
# validate
if [ "$VIMRUNTIME" == "" ] ; then
	echo "  No value found, unable to continue. Quitting."
	exit 1
elif [ ! -d $VIMRUNTIME ] ; then
	echo "  Value found ($VIMRUNTIME) not a directory, unable to continue. Quitting."
	exit 1
else
	# value found
	echo "  Found:"
	echo "  $VIMRUNTIME"
fi

# set $PREFIX (distros that put sys files in own subdirectory --Felix Breuer)
if [[ -n $1 && -d $1 ]]; then
	# first argument (is directory validated above)
	PREFIX=$1
else
	PREFIX=/usr/local
fi

# set $HERE (from where we're copying)
HERE=`dirname $0`


# installation
echo
echo "Installing to..."
echo "  $VIMRUNTIME/cream"

# verify directories exist
echo "Verifying directories exist..."
echo "  $VIMRUNTIME/cream"
mkdir -p $VIMRUNTIME/cream
echo "  $VIMRUNTIME/cream/addons"
mkdir -p $VIMRUNTIME/cream/addons
echo "  $VIMRUNTIME/cream/bitmaps"
mkdir -p $VIMRUNTIME/cream/bitmaps
echo "  $VIMRUNTIME/cream/docs"
mkdir -p $VIMRUNTIME/cream/docs
echo "  $VIMRUNTIME/cream/docs-html"
mkdir -p $VIMRUNTIME/cream/docs-html
echo "  $VIMRUNTIME/cream/filetypes"
mkdir -p $VIMRUNTIME/cream/filetypes
echo "  $VIMRUNTIME/cream/help"
mkdir -p $VIMRUNTIME/cream/help
echo "  $VIMRUNTIME/cream/lang"
mkdir -p $VIMRUNTIME/cream/lang
echo "  $VIMRUNTIME/cream/spelldicts"
mkdir -p $VIMRUNTIME/cream/spelldicts

# copy runtime files
echo "Copying runtime files..."
echo "  $VIMRUNTIME/cream/creamrc"
cp -uf $HERE/creamrc $VIMRUNTIME/cream/
echo "  $VIMRUNTIME/cream/*.vim"
cp -uf $HERE/*.vim $VIMRUNTIME/cream/
#echo "  $VIMRUNTIME/cream/cream.png"
#cp -uf $HERE/cream.png $VIMRUNTIME/cream/
#echo "  $VIMRUNTIME/cream/cream.svg"
#cp -uf $HERE/cream.svg $VIMRUNTIME/cream/
#echo "  $VIMRUNTIME/cream/cream.ico"
#cp -uf $HERE/cream.ico $VIMRUNTIME/cream/
echo "  $VIMRUNTIME/cream/addons/*.vim"
cp -uf $HERE/addons/*.vim $VIMRUNTIME/cream/addons/
echo "  $VIMRUNTIME/cream/bitmaps/*.xpm"
cp -uf $HERE/bitmaps/*.xpm $VIMRUNTIME/cream/bitmaps/
#echo "  $VIMRUNTIME/cream/bitmaps/*.bmp"
#cp -uf $HERE/bitmaps/*.bmp $VIMRUNTIME/cream/bitmaps/
echo "  $VIMRUNTIME/cream/docs/*.txt"
cp -uf $HERE/docs/*.txt $VIMRUNTIME/cream/docs/
echo "  $VIMRUNTIME/cream/docs-html/*.html"
cp -uf $HERE/docs-html/*.html $VIMRUNTIME/cream/docs-html/
echo "  $VIMRUNTIME/cream/docs-html/*.css"
cp -uf $HERE/docs-html/*.css $VIMRUNTIME/cream/docs-html/
echo "  $VIMRUNTIME/cream/docs-html/*.png"
cp -uf $HERE/docs-html/*.png $VIMRUNTIME/cream/docs-html/
echo "  $VIMRUNTIME/cream/filetypes/*.vim"
cp -uf $HERE/filetypes/*.vim $VIMRUNTIME/cream/filetypes/
echo "  $VIMRUNTIME/cream/help/*.txt"
cp -uf $HERE/help/*.txt $VIMRUNTIME/cream/help/
echo "  $VIMRUNTIME/cream/lang/*.vim"
cp -uf $HERE/lang/*.vim $VIMRUNTIME/cream/lang/
echo "  $VIMRUNTIME/cream/spelldicts/cream-spell-dict-eng-s*.vim"
cp -uf $HERE/spelldicts/cream-spell-dict-eng-s*.vim $VIMRUNTIME/cream/spelldicts/
echo "  $VIMRUNTIME/cream/spelldicts/cream-spell-dict.vim"
cp -uf $HERE/spelldicts/cream-spell-dict.vim $VIMRUNTIME/cream/spelldicts/


# other system files

# copy command
echo "Copying shell command..."
echo "  $PREFIX/bin/cream"
mkdir -p $PREFIX/bin
cp -uf $HERE/cream $PREFIX/bin/

# copy menu entry
echo "Copying GNOME menu entry..."
echo "  $PREFIX/share/applications/cream.desktop"
mkdir -p $PREFIX/share/applications
cp -uf $HERE/cream.desktop $PREFIX/share/applications/

# copy icons
echo "Copying graphic icons..."
echo "  $PREFIX/share/icons"
mkdir -p $PREFIX/share/icons
cp -uf $HERE/cream.svg $PREFIX/share/icons/
cp -uf $HERE/cream.png $PREFIX/share/icons/


# cleanup old installations
echo "Cleaning up previous versions..."

# 0.33
if [ -e "/usr/bin/cream" ]; then
	rm -f /usr/bin/cream
fi
# 0.31
if [ -e "$VIMRUNTIME/cream/docs-html/love.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/love.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/hate.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/hate.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/background.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/background.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/goals.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/goals.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/screenshot-arabic1.png" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/screenshot-arabic1.png
fi
if [ -e "$VIMRUNTIME/cream/docs-html/devel.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/devel.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/creamlogo.png" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/creamlogo.png
fi
# 0.30
if [ -e "$VIMRUNTIME/cream/cream-filetype-c.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-c.vim
fi
if [ -e "$VIMRUNTIME/cream/cream-filetype-html.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-html.vim
fi
if [ -e "$VIMRUNTIME/cream/cream-filetype-txt.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-txt.vim
fi
if [ -e "$VIMRUNTIME/cream/cream-filetype-vim.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-vim.vim
fi
# earlier
if [ -e "$VIMRUNTIME/cream/docs-html/todo.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/todo.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/changelog.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/changelog.html
fi
if [ -e "$VIMRUNTIME/cream/docs-html/bugs.html" ]; then
	rm -f $VIMRUNTIME/cream/docs-html/bugs.html
fi


# finish
echo "Finished."
echo

