"=====================================================================
" cream-menu.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
" 
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
" 
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
" 
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"

function! Cream_menus()
" Creates each menu loader and calls it

	" Make sure the '<' and 'C' flags are not included in 'cpoptions', otherwise
	" <CR> would not be recognized.  See ":help 'cpoptions'".
	let cpo_save = &cpo
	set cpo&vim

	"+++ Cream: necessary for GTK (set also from vimrc, but not effective there)
	set guioptions+=M
	"+++

    "+++ Cream: GTK loads menus, even if you ask it not to!
    unmenu! *
    unmenu *
    "+++

	" load Cream menus
    call Cream_source($CREAM . "cream-menu-file.vim")
    call Cream_source($CREAM . "cream-menu-edit.vim")
    call Cream_source($CREAM . "cream-menu-insert.vim")
    call Cream_source($CREAM . "cream-menu-format.vim")
    call Cream_source($CREAM . "cream-menu-settings.vim")
    call Cream_source($CREAM . "cream-menu-tools.vim")
    call Cream_source($CREAM . "cream-menu-window.vim")
    call Cream_source($CREAM . "cream-menu-window-buffer.vim")
    call Cream_source($CREAM . "cream-menu-help.vim")
    call Cream_source($CREAM . "cream-menu-window.vim")

    call Cream_source($CREAM . "cream-menu-developer.vim")

    call Cream_source($CREAM . "cream-menu-toolbar.vim")
    call Cream_source($CREAM . "cream-menu-popup.vim")

    " restore
	let &cpo = cpo_save

endfunction
call Cream_menus()

