# cpushare buy client core API
# Copyright (C) 2005-2006  Andrea Arcangeli <andrea@cpushare.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# only version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, struct

# local
from cpushare.seccomp_gen import seccomp_gen_class
from cpushare.proto_const import *
from cpushare.exceptions import CompilationError

# estimate of the max number of seconds that the sell client
# will take to checkpoint and send its state back to us
checkpoint_sec = 10

seccomp_gen_hash = {}
def build_seccomp_gen_hash():
	_dir = os.readlink('cpushare_buy')
	if os.system('make CPUSHARE_CORE=`pwd` -C %s cpushare >/dev/null 2>&1' % _dir):
		raise CompilationError()

	x86 = seccomp_gen_hash['i686'] = seccomp_gen_class(os.path.join(_dir,
									'bytecode.i686'),
							   'i686')
	x86.heap_kbytes = 1
	x86.stack_kbytes = 1

	ppc = seccomp_gen_hash['ppc'] = seccomp_gen_class(os.path.join(_dir,
								       'bytecode.ppc'),
							  'ppc')
	ppc.heap_kbytes = 1
	ppc.stack_kbytes = 1
# build and prepare the bytecode at the first import
if not seccomp_gen_hash:
	build_seccomp_gen_hash()

class buy_state_machine_class(object):
	buy_api = '0.0.0'

	def __init__(self, protocol):
		self.protocol = protocol
		self.handler = self.stringReceived

	def start(self):
		self.protocol.sendString(PROTO_SECCOMP_FORWARD + 'ciao')

	def stringReceived(self, string):
		control = string[0]
		data = string[1:]

		if control == PROTO_SECCOMP_FORWARD:
			print self, repr(data)
			#self.protocol.sendString(PROTO_SECCOMP_SUCCESS)
		elif control == PROTO_SECCOMP_SIGNAL:
			print 'checkpoint starting'
		elif control == PROTO_LOG:
			print repr(data)
		else:
			if control == PROTO_SECCOMP_SUCCESS:
				pass
			elif control == PROTO_SECCOMP_FAILURE:
				status = struct.unpack('!i', data)[0]
				exit_code = status >> 8
				signal = status & 0xff
				_str = 'Seccomp failure: status %d, exit_code %d, signal %d.' % \
				       (status, exit_code, signal)
				print _str
			else:
				_str = 'Unknown buy api failure %d - %s' % (ord(control), repr(string))
				self.protocol.sendString(PROTO_SECCOMP_FAILURE + _str)
				print _str
			self.protocol.sendString(PROTO_SECCOMP_FAILURE)
			self.protocol.transport.loseConnection()

	def connectionLost(self):
		pass
