/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "cpufreqd.h"
#include "main.h"
#include "sys_check.h"

/* int select_pm_plugin
 * 
 * Check the existance of power interfaces trying
 * to call the check function for each plugin
 */



/* int find_cpufreq_interface(void)
 *
 * Checks whether we need to use the 2.4 or 2.5
 * cpufreq iterface and sets the has_sysfs bit
 * accordingly.
 *
 * Returns 0 on success, -1 otherwise
 */
int find_cpufreq_interface(general *configuration) {
  struct stat sb;
  int rc;
  
  /* try fisrt with the 2.4 series */
  rc = stat(CPUFREQ_PROC_INTERFACE, &sb);
  if (rc == 0) {
    cp_log(LOG_DEBUG, "find_cpufreq_interface(): found %s interface.\n", CPUFREQ_PROC_INTERFACE);
    configuration->has_sysfs = 0;
    return 0;
  }

  /* try with the 2.5 series */
  rc = stat(CPUFREQ_SYSFS_INTERFACE, &sb);
  if (rc == 0) {
    cp_log(LOG_DEBUG, "find_cpufreq_interface(): found %s interface.\n", CPUFREQ_SYSFS_INTERFACE);
    configuration->has_sysfs = 1;
    return 0;
  }
  
  cp_log(LOG_ERR, "find_cpufreq_interface(): no cpufreq interface found.\n");
  return -1;
    
}
