/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* function declaration */
int         main_loop               (void);
int         read_args               (int argc, char *argv[]);
int         write_cpufreqd_pid      (void);
int         clear_cpufreqd_pid      (void);
int         is_system_changed       (const sys_info *sys_now,
                                     const sys_info *sys_prev);
int         get_rule_hits           (const sys_info *si,
                                     const rule *r);
int         get_running_programs    (void);
int         free_running_programs   (void);
rule        *find_valid_rule        (const sys_info *si, rule *r);
int         set_policy              (profile *prof);
void        print_version           (const char *me);
void        print_help              (const char *me);
int         daemonize               (void);
void        close_libraries         (void);
int         load_libraries          (void);
void        reinit                  (void);
void        cp_log                  (const int prio, const char *fmt, ...);

/* signal handlers */
void        term_handler            (int signo);
void        int_handler             (int signo);
void        hup_handler             (int signo);
