/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set sw=2 sts=2 et cin: */
/*
 * This file is part of the MUSE Instrument Pipeline
 * Copyright (C) 2011-2014 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <muse.h>

/* maximum number of pixels around each test star to expect */
#define NMAX 2500

/* example stars from Peter's FORS2 data            *
 * (field of PG 1047 taken on Nov12 2002 in V-band) */
const float kStar1[][4] = {
  { 1294, 70, 33.935467, 2.413590 },
  { 1294, 71, 34.789745, 2.428638 },
  { 1294, 72, 34.623169, 2.425726 },
  { 1294, 73, 43.494362, 2.568078 },
  { 1294, 74, 32.678383, 2.390920 },
  { 1294, 75, 40.404892, 2.521207 },
  { 1294, 76, 40.264832, 2.519019 },
  { 1294, 77, 39.234470, 2.502747 },
  { 1294, 78, 35.426964, 2.439683 },
  { 1294, 79, 48.947594, 2.645044 },
  { 1294, 80, 36.664223, 2.460711 },
  { 1294, 81, 42.853355, 2.558563 },
  { 1294, 82, 29.235590, 2.325294 },
  { 1294, 83, 40.495205, 2.522615 },
  { 1294, 84, 39.301437, 2.503814 },
  { 1294, 85, 37.248417, 2.470455 },
  { 1294, 86, 36.256516, 2.453842 },
  { 1294, 87, 34.620998, 2.425688 },
  { 1294, 88, 38.406292, 2.489434 },
  { 1294, 89, 47.022430, 2.618643 },
  { 1294, 90, 36.831097, 2.463506 },
  { 1294, 91, 42.807060, 2.557872 },
  { 1294, 92, 38.887817, 2.497200 },
  { 1294, 93, 44.229073, 2.578855 },
  { 1294, 94, 38.083477, 2.484186 },
  { 1294, 95, 31.945330, 2.377398 },
  { 1294, 96, 37.765690, 2.478988 },
  { 1294, 97, 39.911728, 2.513478 },
  { 1294, 98, 47.008644, 2.618451 },
  { 1294, 99, 48.550194, 2.639658 },
  { 1294, 100, 37.603851, 2.476327 },
  { 1294, 101, 41.679310, 2.540857 },
  { 1294, 102, 30.501822, 2.350074 },
  { 1294, 103, 34.997467, 2.432255 },
  { 1294, 104, 38.520863, 2.491288 },
  { 1294, 105, 36.915436, 2.464915 },
  { 1294, 106, 37.211346, 2.469840 },
  { 1294, 107, 35.879303, 2.447434 },
  { 1294, 108, 44.527988, 2.583201 },
  { 1294, 109, 35.471867, 2.440456 },
  { 1294, 110, 56.774662, 2.744977 },
  { 1294, 111, 35.133015, 2.434607 },
  { 1294, 112, 38.983528, 2.498735 },
  { 1294, 113, 44.489426, 2.582642 },
  { 1294, 114, 34.872059, 2.430073 },
  { 1294, 115, 35.429966, 2.439735 },
  { 1294, 116, 41.217495, 2.533789 },
  { 1294, 117, 35.942585, 2.448513 },
  { 1294, 118, 42.286655, 2.550063 },
  { 1295, 70, 45.170803, 2.592474 },
  { 1295, 71, 33.394772, 2.403918 },
  { 1295, 72, 43.264599, 2.564680 },
  { 1295, 73, 38.433495, 2.489875 },
  { 1295, 74, 35.892040, 2.447651 },
  { 1295, 75, 31.486017, 2.368806 },
  { 1295, 76, 42.276764, 2.549913 },
  { 1295, 77, 34.544514, 2.424347 },
  { 1295, 78, 37.606144, 2.476365 },
  { 1295, 79, 44.921814, 2.588894 },
  { 1295, 80, 37.228897, 2.470131 },
  { 1295, 81, 34.884113, 2.430284 },
  { 1295, 82, 36.433620, 2.456833 },
  { 1295, 83, 37.840752, 2.480218 },
  { 1295, 84, 33.930439, 2.413500 },
  { 1295, 85, 32.044231, 2.379236 },
  { 1295, 86, 32.919678, 2.395322 },
  { 1295, 87, 31.995897, 2.378338 },
  { 1295, 88, 32.079788, 2.379895 },
  { 1295, 89, 43.937912, 2.574600 },
  { 1295, 90, 41.349270, 2.535811 },
  { 1295, 91, 34.441517, 2.422538 },
  { 1295, 92, 45.037563, 2.590560 },
  { 1295, 93, 35.751072, 2.445244 },
  { 1295, 94, 37.915028, 2.481435 },
  { 1295, 95, 47.735817, 2.628519 },
  { 1295, 96, 36.828449, 2.463462 },
  { 1295, 97, 39.041847, 2.499670 },
  { 1295, 98, 42.105331, 2.547324 },
  { 1295, 99, 29.649879, 2.333489 },
  { 1295, 100, 25.456171, 2.246199 },
  { 1295, 101, 28.199257, 2.304408 },
  { 1295, 102, 39.440353, 2.506024 },
  { 1295, 103, 37.314354, 2.471548 },
  { 1295, 104, 36.755165, 2.462235 },
  { 1295, 105, 45.117989, 2.591716 },
  { 1295, 106, 44.651440, 2.584990 },
  { 1295, 107, 38.281082, 2.487402 },
  { 1295, 108, 40.978268, 2.530104 },
  { 1295, 109, 45.122356, 2.591779 },
  { 1295, 110, 41.459293, 2.537497 },
  { 1295, 111, 36.087894, 2.450984 },
  { 1295, 112, 37.151531, 2.468847 },
  { 1295, 113, 47.029495, 2.618741 },
  { 1295, 114, 43.140327, 2.562836 },
  { 1295, 115, 37.465858, 2.474052 },
  { 1295, 116, 25.744482, 2.252532 },
  { 1295, 117, 39.865185, 2.512745 },
  { 1295, 118, 47.326107, 2.622860 },
  { 1296, 70, 43.788509, 2.572409 },
  { 1296, 71, 38.672028, 2.493729 },
  { 1296, 72, 39.243057, 2.502884 },
  { 1296, 73, 41.127140, 2.532399 },
  { 1296, 74, 35.090694, 2.433873 },
  { 1296, 75, 23.670084, 2.205718 },
  { 1296, 76, 38.769512, 2.495299 },
  { 1296, 77, 38.783558, 2.495525 },
  { 1296, 78, 29.638794, 2.333271 },
  { 1296, 79, 37.556751, 2.475552 },
  { 1296, 80, 31.200855, 2.363424 },
  { 1296, 81, 44.673588, 2.585310 },
  { 1296, 82, 33.058243, 2.397839 },
  { 1296, 83, 42.946392, 2.559951 },
  { 1296, 84, 50.623100, 2.667394 },
  { 1296, 85, 38.049549, 2.483633 },
  { 1296, 86, 33.266102, 2.401599 },
  { 1296, 87, 55.697914, 2.731868 },
  { 1296, 88, 29.573612, 2.331987 },
  { 1296, 89, 40.452721, 2.521953 },
  { 1296, 90, 32.389893, 2.385626 },
  { 1296, 91, 29.678101, 2.334044 },
  { 1296, 92, 33.180679, 2.400056 },
  { 1296, 93, 29.430315, 2.329157 },
  { 1296, 94, 38.506660, 2.491059 },
  { 1296, 95, 41.731419, 2.541650 },
  { 1296, 96, 38.397652, 2.489294 },
  { 1296, 97, 27.323290, 2.286300 },
  { 1296, 98, 35.595207, 2.442575 },
  { 1296, 99, 36.738918, 2.461963 },
  { 1296, 100, 38.637123, 2.493166 },
  { 1296, 101, 39.064735, 2.500036 },
  { 1296, 102, 43.393223, 2.566584 },
  { 1296, 103, 40.907715, 2.529014 },
  { 1296, 104, 31.801035, 2.374709 },
  { 1296, 105, 47.951675, 2.631485 },
  { 1296, 106, 29.473986, 2.330020 },
  { 1296, 107, 50.393375, 2.664363 },
  { 1296, 108, 37.492634, 2.474494 },
  { 1296, 109, 31.387032, 2.366942 },
  { 1296, 110, 41.554382, 2.538950 },
  { 1296, 111, 31.062017, 2.360790 },
  { 1296, 112, 32.381321, 2.385468 },
  { 1296, 113, 35.277420, 2.437105 },
  { 1296, 114, 44.539581, 2.583369 },
  { 1296, 115, 46.882210, 2.616688 },
  { 1296, 116, 41.042213, 2.531091 },
  { 1296, 117, 43.270454, 2.564767 },
  { 1296, 118, 31.057041, 2.360696 },
  { 1297, 70, 26.301905, 2.264628 },
  { 1297, 71, 42.747517, 2.556982 },
  { 1297, 72, 31.404959, 2.367280 },
  { 1297, 73, 40.054863, 2.515729 },
  { 1297, 74, 39.099663, 2.500594 },
  { 1297, 75, 42.898052, 2.559231 },
  { 1297, 76, 35.793350, 2.445967 },
  { 1297, 77, 43.096878, 2.562191 },
  { 1297, 78, 37.064018, 2.467392 },
  { 1297, 79, 44.546818, 2.583474 },
  { 1297, 80, 40.092098, 2.516313 },
  { 1297, 81, 36.896095, 2.464592 },
  { 1297, 82, 38.099361, 2.484445 },
  { 1297, 83, 31.640146, 2.371699 },
  { 1297, 84, 39.980049, 2.514553 },
  { 1297, 85, 39.151810, 2.501428 },
  { 1297, 86, 30.393167, 2.347978 },
  { 1297, 87, 31.359892, 2.366430 },
  { 1297, 88, 29.293051, 2.326436 },
  { 1297, 89, 43.451942, 2.567452 },
  { 1297, 90, 29.332529, 2.327220 },
  { 1297, 91, 36.776142, 2.462587 },
  { 1297, 92, 44.634178, 2.584740 },
  { 1297, 93, 32.602608, 2.389533 },
  { 1297, 94, 45.419319, 2.596033 },
  { 1297, 95, 33.222507, 2.400812 },
  { 1297, 96, 29.285929, 2.326295 },
  { 1297, 97, 42.251572, 2.549534 },
  { 1297, 98, 35.604809, 2.442739 },
  { 1297, 99, 39.672222, 2.509699 },
  { 1297, 100, 30.745422, 2.354752 },
  { 1297, 101, 39.637924, 2.509156 },
  { 1297, 102, 43.234280, 2.564230 },
  { 1297, 103, 40.716728, 2.526057 },
  { 1297, 104, 31.505621, 2.369174 },
  { 1297, 105, 38.024883, 2.483230 },
  { 1297, 106, 37.925621, 2.481608 },
  { 1297, 107, 41.736172, 2.541723 },
  { 1297, 108, 40.328262, 2.520011 },
  { 1297, 109, 36.089817, 2.451016 },
  { 1297, 110, 41.857632, 2.543570 },
  { 1297, 111, 34.858109, 2.429830 },
  { 1297, 112, 35.142124, 2.434765 },
  { 1297, 113, 36.286903, 2.454355 },
  { 1297, 114, 38.905346, 2.497482 },
  { 1297, 115, 29.852900, 2.337473 },
  { 1297, 116, 36.554115, 2.458862 },
  { 1297, 117, 42.232346, 2.549243 },
  { 1297, 118, 48.253483, 2.635616 },
  { 1298, 70, 36.373154, 2.455813 },
  { 1298, 71, 42.946472, 2.559952 },
  { 1298, 72, 38.976368, 2.498621 },
  { 1298, 73, 36.874096, 2.464225 },
  { 1298, 74, 30.474857, 2.349554 },
  { 1298, 75, 32.137287, 2.380961 },
  { 1298, 76, 33.788277, 2.410968 },
  { 1298, 77, 33.308723, 2.402368 },
  { 1298, 78, 33.932430, 2.413536 },
  { 1298, 79, 41.229618, 2.533975 },
  { 1298, 80, 30.679096, 2.353481 },
  { 1298, 81, 32.694668, 2.391218 },
  { 1298, 82, 40.742722, 2.526460 },
  { 1298, 83, 45.083267, 2.591217 },
  { 1298, 84, 39.839466, 2.512340 },
  { 1298, 85, 31.573036, 2.370441 },
  { 1298, 86, 33.122383, 2.399001 },
  { 1298, 87, 48.026047, 2.632505 },
  { 1298, 88, 36.175468, 2.452469 },
  { 1298, 89, 42.596069, 2.554715 },
  { 1298, 90, 31.108465, 2.361672 },
  { 1298, 91, 31.200891, 2.363425 },
  { 1298, 92, 32.850582, 2.394064 },
  { 1298, 93, 38.150703, 2.485282 },
  { 1298, 94, 42.115734, 2.547482 },
  { 1298, 95, 28.973976, 2.320075 },
  { 1298, 96, 40.948853, 2.529650 },
  { 1298, 97, 42.352299, 2.551052 },
  { 1298, 98, 44.498451, 2.582773 },
  { 1298, 99, 29.615286, 2.332808 },
  { 1298, 100, 40.824924, 2.527734 },
  { 1298, 101, 44.946682, 2.589252 },
  { 1298, 102, 35.452946, 2.440131 },
  { 1298, 103, 25.070398, 2.237640 },
  { 1298, 104, 41.690449, 2.541026 },
  { 1298, 105, 34.173626, 2.417813 },
  { 1298, 106, 40.501812, 2.522717 },
  { 1298, 107, 35.634922, 2.443256 },
  { 1298, 108, 36.723740, 2.461709 },
  { 1298, 109, 30.898756, 2.357682 },
  { 1298, 110, 36.577709, 2.459258 },
  { 1298, 111, 35.896729, 2.447731 },
  { 1298, 112, 40.434681, 2.521672 },
  { 1298, 113, 44.067356, 2.576495 },
  { 1298, 114, 32.886444, 2.394717 },
  { 1298, 115, 43.212795, 2.563912 },
  { 1298, 116, 39.507759, 2.507094 },
  { 1298, 117, 36.782806, 2.462698 },
  { 1298, 118, 32.223515, 2.382557 },
  { 1299, 70, 50.171577, 2.661426 },
  { 1299, 71, 31.803841, 2.374761 },
  { 1299, 72, 47.251102, 2.621821 },
  { 1299, 73, 33.547390, 2.406660 },
  { 1299, 74, 42.099251, 2.547232 },
  { 1299, 75, 46.962402, 2.617807 },
  { 1299, 76, 31.361767, 2.366465 },
  { 1299, 77, 37.800175, 2.479553 },
  { 1299, 78, 29.585390, 2.332219 },
  { 1299, 79, 49.151821, 2.647798 },
  { 1299, 80, 48.033436, 2.632606 },
  { 1299, 81, 41.614071, 2.539861 },
  { 1299, 82, 35.347324, 2.438311 },
  { 1299, 83, 35.155727, 2.435000 },
  { 1299, 84, 31.797283, 2.374639 },
  { 1299, 85, 34.899509, 2.430552 },
  { 1299, 86, 43.982761, 2.575257 },
  { 1299, 87, 41.204494, 2.533589 },
  { 1299, 88, 36.707100, 2.461430 },
  { 1299, 89, 51.151134, 2.674323 },
  { 1299, 90, 44.068089, 2.576505 },
  { 1299, 91, 38.303898, 2.487773 },
  { 1299, 92, 30.845669, 2.356669 },
  { 1299, 93, 32.278809, 2.383578 },
  { 1299, 94, 20.395508, 2.125121 },
  { 1299, 95, 45.841537, 2.602045 },
  { 1299, 96, 30.852011, 2.356790 },
  { 1299, 97, 34.418636, 2.422135 },
  { 1299, 98, 43.796398, 2.572525 },
  { 1299, 99, 31.578745, 2.370548 },
  { 1299, 100, 38.448296, 2.490114 },
  { 1299, 101, 34.109055, 2.416670 },
  { 1299, 102, 35.043278, 2.433051 },
  { 1299, 103, 26.208736, 2.262619 },
  { 1299, 104, 32.884289, 2.394678 },
  { 1299, 105, 39.478268, 2.506626 },
  { 1299, 106, 37.842438, 2.480246 },
  { 1299, 107, 41.751347, 2.541954 },
  { 1299, 108, 29.216135, 2.324908 },
  { 1299, 109, 31.708887, 2.372986 },
  { 1299, 110, 30.000063, 2.340348 },
  { 1299, 111, 44.618195, 2.584509 },
  { 1299, 112, 38.220726, 2.486421 },
  { 1299, 113, 35.708008, 2.444508 },
  { 1299, 114, 40.551743, 2.523494 },
  { 1299, 115, 32.009830, 2.378597 },
  { 1299, 116, 45.526196, 2.597558 },
  { 1299, 117, 33.916054, 2.413244 },
  { 1299, 118, 45.126545, 2.591839 },
  { 1300, 70, 43.799911, 2.572577 },
  { 1300, 71, 36.538731, 2.458603 },
  { 1300, 72, 33.731869, 2.409961 },
  { 1300, 73, 27.647503, 2.293052 },
  { 1300, 74, 35.796646, 2.446023 },
  { 1300, 75, 44.172970, 2.578037 },
  { 1300, 76, 28.951204, 2.319619 },
  { 1300, 77, 36.559608, 2.458954 },
  { 1300, 78, 30.691551, 2.353719 },
  { 1300, 79, 40.582981, 2.523980 },
  { 1300, 80, 41.460537, 2.537516 },
  { 1300, 81, 25.699467, 2.251547 },
  { 1300, 82, 38.824947, 2.496191 },
  { 1300, 83, 27.588400, 2.291826 },
  { 1300, 84, 46.257759, 2.607931 },
  { 1300, 85, 33.353466, 2.403174 },
  { 1300, 86, 35.053364, 2.433226 },
  { 1300, 87, 34.824211, 2.429240 },
  { 1300, 88, 43.619118, 2.569918 },
  { 1300, 89, 41.003624, 2.530495 },
  { 1300, 90, 54.231884, 2.713712 },
  { 1300, 91, 37.014854, 2.466573 },
  { 1300, 92, 38.774803, 2.495384 },
  { 1300, 93, 47.076759, 2.619399 },
  { 1300, 94, 36.739704, 2.461977 },
  { 1300, 95, 42.939602, 2.559850 },
  { 1300, 96, 38.941040, 2.498055 },
  { 1300, 97, 40.758240, 2.526701 },
  { 1300, 98, 35.571289, 2.442164 },
  { 1300, 99, 39.242577, 2.502876 },
  { 1300, 100, 41.827389, 2.543110 },
  { 1300, 101, 38.541981, 2.491630 },
  { 1300, 102, 39.436878, 2.505969 },
  { 1300, 103, 34.236526, 2.418925 },
  { 1300, 104, 42.464569, 2.552741 },
  { 1300, 105, 38.654236, 2.493442 },
  { 1300, 106, 38.355103, 2.488604 },
  { 1300, 107, 34.974972, 2.431864 },
  { 1300, 108, 52.915546, 2.697092 },
  { 1300, 109, 38.277187, 2.487339 },
  { 1300, 110, 29.637905, 2.333253 },
  { 1300, 111, 32.400360, 2.385819 },
  { 1300, 112, 30.079031, 2.341887 },
  { 1300, 113, 42.339149, 2.550853 },
  { 1300, 114, 25.268789, 2.242054 },
  { 1300, 115, 33.826904, 2.411657 },
  { 1300, 116, 39.581985, 2.508271 },
  { 1300, 117, 37.525848, 2.475042 },
  { 1300, 118, 47.501163, 2.625283 },
  { 1301, 70, 42.637756, 2.555339 },
  { 1301, 71, 34.169487, 2.417740 },
  { 1301, 72, 36.192448, 2.452757 },
  { 1301, 73, 43.614254, 2.569846 },
  { 1301, 74, 48.993656, 2.645666 },
  { 1301, 75, 47.832855, 2.629854 },
  { 1301, 76, 36.330296, 2.455089 },
  { 1301, 77, 38.898506, 2.497372 },
  { 1301, 78, 35.253235, 2.436687 },
  { 1301, 79, 38.687893, 2.493985 },
  { 1301, 80, 42.589527, 2.554616 },
  { 1301, 81, 29.750992, 2.335476 },
  { 1301, 82, 40.989269, 2.530274 },
  { 1301, 83, 28.909313, 2.318779 },
  { 1301, 84, 33.619869, 2.407959 },
  { 1301, 85, 34.840115, 2.429517 },
  { 1301, 86, 39.776794, 2.511351 },
  { 1301, 87, 42.389904, 2.551618 },
  { 1301, 88, 27.937719, 2.299047 },
  { 1301, 89, 37.994698, 2.482737 },
  { 1301, 90, 36.233459, 2.453451 },
  { 1301, 91, 33.704826, 2.409478 },
  { 1301, 92, 40.292034, 2.519444 },
  { 1301, 93, 47.763313, 2.628897 },
  { 1301, 94, 35.621792, 2.443031 },
  { 1301, 95, 37.893719, 2.481086 },
  { 1301, 96, 41.951420, 2.544993 },
  { 1301, 97, 48.964920, 2.645278 },
  { 1301, 98, 29.591263, 2.332335 },
  { 1301, 99, 40.126438, 2.516852 },
  { 1301, 100, 40.534904, 2.523232 },
  { 1301, 101, 39.533558, 2.507503 },
  { 1301, 102, 43.257164, 2.564570 },
  { 1301, 103, 45.249897, 2.593608 },
  { 1301, 104, 30.929916, 2.358276 },
  { 1301, 105, 41.603958, 2.539707 },
  { 1301, 106, 28.137966, 2.303155 },
  { 1301, 107, 37.781742, 2.479251 },
  { 1301, 108, 34.112118, 2.416725 },
  { 1301, 109, 50.032490, 2.659580 },
  { 1301, 110, 47.493637, 2.625179 },
  { 1301, 111, 30.161749, 2.343496 },
  { 1301, 112, 40.254948, 2.518865 },
  { 1301, 113, 46.411289, 2.610093 },
  { 1301, 114, 46.032772, 2.604754 },
  { 1301, 115, 46.144310, 2.606331 },
  { 1301, 116, 33.250015, 2.401309 },
  { 1301, 117, 40.155064, 2.517301 },
  { 1301, 118, 28.905590, 2.318705 },
  { 1302, 70, 40.258598, 2.518922 },
  { 1302, 71, 38.807693, 2.495913 },
  { 1302, 72, 35.276711, 2.437093 },
  { 1302, 73, 27.355087, 2.286965 },
  { 1302, 74, 31.651880, 2.371919 },
  { 1302, 75, 40.362923, 2.520552 },
  { 1302, 76, 33.343330, 2.402992 },
  { 1302, 77, 27.685783, 2.293846 },
  { 1302, 78, 33.003036, 2.396837 },
  { 1302, 79, 40.809032, 2.527488 },
  { 1302, 80, 31.971609, 2.377887 },
  { 1302, 81, 48.826611, 2.643408 },
  { 1302, 82, 32.121140, 2.380662 },
  { 1302, 83, 42.208691, 2.548886 },
  { 1302, 84, 33.838425, 2.411862 },
  { 1302, 85, 41.415241, 2.536822 },
  { 1302, 86, 33.591576, 2.407452 },
  { 1302, 87, 29.603241, 2.332571 },
  { 1302, 88, 37.141258, 2.468676 },
  { 1302, 89, 33.246380, 2.401243 },
  { 1302, 90, 41.193977, 2.533427 },
  { 1302, 91, 43.045471, 2.561426 },
  { 1302, 92, 26.865412, 2.276661 },
  { 1302, 93, 43.278957, 2.564893 },
  { 1302, 94, 36.047581, 2.450299 },
  { 1302, 95, 46.241493, 2.607702 },
  { 1302, 96, 37.248737, 2.470460 },
  { 1302, 97, 43.795422, 2.572510 },
  { 1302, 98, 33.963024, 2.414080 },
  { 1302, 99, 42.400860, 2.551783 },
  { 1302, 100, 37.836628, 2.480151 },
  { 1302, 101, 26.604235, 2.271107 },
  { 1302, 102, 35.652241, 2.443553 },
  { 1302, 103, 22.199465, 2.170629 },
  { 1302, 104, 36.743134, 2.462034 },
  { 1302, 105, 31.899698, 2.376548 },
  { 1302, 106, 31.077515, 2.361085 },
  { 1302, 107, 32.464844, 2.387005 },
  { 1302, 108, 34.001194, 2.414757 },
  { 1302, 109, 32.613251, 2.389728 },
  { 1302, 110, 32.613926, 2.389741 },
  { 1302, 111, 35.126102, 2.434487 },
  { 1302, 112, 52.548676, 2.692405 },
  { 1302, 113, 34.518665, 2.423893 },
  { 1302, 114, 25.161060, 2.239661 },
  { 1302, 115, 34.401886, 2.421841 },
  { 1302, 116, 47.556328, 2.626045 },
  { 1302, 117, 36.407768, 2.456397 },
  { 1302, 118, 33.463417, 2.405152 },
  { 1303, 70, 29.382324, 2.328207 },
  { 1303, 71, 35.326672, 2.437955 },
  { 1303, 72, 34.568199, 2.424762 },
  { 1303, 73, 39.572048, 2.508113 },
  { 1303, 74, 42.341049, 2.550882 },
  { 1303, 75, 32.820309, 2.393512 },
  { 1303, 76, 39.143517, 2.501295 },
  { 1303, 77, 44.933033, 2.589056 },
  { 1303, 78, 44.120571, 2.577272 },
  { 1303, 79, 36.400307, 2.456271 },
  { 1303, 80, 43.267223, 2.564719 },
  { 1303, 81, 23.384642, 2.199038 },
  { 1303, 82, 39.473381, 2.506548 },
  { 1303, 83, 33.804279, 2.411254 },
  { 1303, 84, 29.184568, 2.324279 },
  { 1303, 85, 37.378998, 2.472617 },
  { 1303, 86, 39.917072, 2.513562 },
  { 1303, 87, 44.761501, 2.586581 },
  { 1303, 88, 34.221745, 2.418664 },
  { 1303, 89, 46.302017, 2.608555 },
  { 1303, 90, 41.666122, 2.540655 },
  { 1303, 91, 38.717010, 2.494454 },
  { 1303, 92, 37.089668, 2.467819 },
  { 1303, 93, 38.356964, 2.488634 },
  { 1303, 94, 31.749777, 2.373751 },
  { 1303, 95, 31.826046, 2.375175 },
  { 1303, 96, 40.489147, 2.522520 },
  { 1303, 97, 43.577538, 2.569305 },
  { 1303, 98, 37.008999, 2.466476 },
  { 1303, 99, 41.291779, 2.534930 },
  { 1303, 100, 42.763691, 2.557224 },
  { 1303, 101, 42.372025, 2.551349 },
  { 1303, 102, 41.652115, 2.540442 },
  { 1303, 103, 48.191437, 2.634768 },
  { 1303, 104, 37.965977, 2.482268 },
  { 1303, 105, 40.052013, 2.515684 },
  { 1303, 106, 37.523525, 2.475004 },
  { 1303, 107, 31.224173, 2.363865 },
  { 1303, 108, 52.017605, 2.685577 },
  { 1303, 109, 29.186815, 2.324324 },
  { 1303, 110, 42.899017, 2.559245 },
  { 1303, 111, 28.648558, 2.313533 },
  { 1303, 112, 41.199589, 2.533514 },
  { 1303, 113, 43.769772, 2.572134 },
  { 1303, 114, 27.154545, 2.282762 },
  { 1303, 115, 26.334181, 2.265322 },
  { 1303, 116, 32.485153, 2.387378 },
  { 1303, 117, 38.442329, 2.490018 },
  { 1303, 118, 31.820871, 2.375079 },
  { 1304, 70, 38.205090, 2.486167 },
  { 1304, 71, 36.945980, 2.465425 },
  { 1304, 72, 38.067856, 2.483931 },
  { 1304, 73, 35.420567, 2.439573 },
  { 1304, 74, 38.408039, 2.489462 },
  { 1304, 75, 30.672613, 2.353356 },
  { 1304, 76, 32.554127, 2.388644 },
  { 1304, 77, 43.975140, 2.575146 },
  { 1304, 78, 34.701096, 2.427089 },
  { 1304, 79, 29.244907, 2.325480 },
  { 1304, 80, 34.183731, 2.417992 },
  { 1304, 81, 38.708637, 2.494319 },
  { 1304, 82, 37.929985, 2.481679 },
  { 1304, 83, 37.622730, 2.476638 },
  { 1304, 84, 39.588638, 2.508376 },
  { 1304, 85, 32.896801, 2.394906 },
  { 1304, 86, 33.210197, 2.400589 },
  { 1304, 87, 38.535591, 2.491526 },
  { 1304, 88, 37.533085, 2.475162 },
  { 1304, 89, 28.265190, 2.305754 },
  { 1304, 90, 46.727470, 2.614527 },
  { 1304, 91, 37.056145, 2.467261 },
  { 1304, 92, 34.634487, 2.425924 },
  { 1304, 93, 47.666969, 2.627571 },
  { 1304, 94, 31.595711, 2.370866 },
  { 1304, 95, 32.429909, 2.386363 },
  { 1304, 96, 44.904591, 2.588646 },
  { 1304, 97, 24.349298, 2.221374 },
  { 1304, 98, 40.709709, 2.525949 },
  { 1304, 99, 35.645008, 2.443429 },
  { 1304, 100, 38.180050, 2.485759 },
  { 1304, 101, 40.479958, 2.522377 },
  { 1304, 102, 35.581425, 2.442338 },
  { 1304, 103, 40.975792, 2.530066 },
  { 1304, 104, 41.218403, 2.533803 },
  { 1304, 105, 31.165483, 2.362754 },
  { 1304, 106, 45.618908, 2.598880 },
  { 1304, 107, 31.721476, 2.373222 },
  { 1304, 108, 41.030376, 2.530908 },
  { 1304, 109, 27.978535, 2.299886 },
  { 1304, 110, 33.298588, 2.402185 },
  { 1304, 111, 43.293690, 2.565111 },
  { 1304, 112, 37.431797, 2.473490 },
  { 1304, 113, 28.473700, 2.309995 },
  { 1304, 114, 38.661968, 2.493567 },
  { 1304, 115, 33.170879, 2.399879 },
  { 1304, 116, 25.268656, 2.242051 },
  { 1304, 117, 23.478411, 2.201239 },
  { 1304, 118, 36.288559, 2.454384 },
  { 1305, 70, 40.455227, 2.521992 },
  { 1305, 71, 37.791271, 2.479407 },
  { 1305, 72, 43.016933, 2.561002 },
  { 1305, 73, 41.803257, 2.542743 },
  { 1305, 74, 31.689425, 2.372622 },
  { 1305, 75, 46.355034, 2.609301 },
  { 1305, 76, 34.242958, 2.419039 },
  { 1305, 77, 34.436779, 2.422454 },
  { 1305, 78, 26.535603, 2.269641 },
  { 1305, 79, 30.318937, 2.346543 },
  { 1305, 80, 39.184883, 2.501956 },
  { 1305, 81, 46.007412, 2.604396 },
  { 1305, 82, 38.465363, 2.490391 },
  { 1305, 83, 39.518055, 2.507257 },
  { 1305, 84, 38.538498, 2.491573 },
  { 1305, 85, 43.933506, 2.574536 },
  { 1305, 86, 31.608660, 2.371109 },
  { 1305, 87, 41.505669, 2.538206 },
  { 1305, 88, 38.338024, 2.488327 },
  { 1305, 89, 31.734119, 2.373458 },
  { 1305, 90, 34.176586, 2.417866 },
  { 1305, 91, 38.752487, 2.495025 },
  { 1305, 92, 37.117146, 2.468276 },
  { 1305, 93, 36.480656, 2.457625 },
  { 1305, 94, 37.842442, 2.480246 },
  { 1305, 95, 33.611393, 2.407807 },
  { 1305, 96, 42.783012, 2.557513 },
  { 1305, 97, 50.475117, 2.665443 },
  { 1305, 98, 45.687565, 2.599857 },
  { 1305, 99, 41.031586, 2.530927 },
  { 1305, 100, 38.221725, 2.486438 },
  { 1305, 101, 38.347301, 2.488477 },
  { 1305, 102, 42.181671, 2.548478 },
  { 1305, 103, 42.965824, 2.560241 },
  { 1305, 104, 37.385014, 2.472717 },
  { 1305, 105, 37.551983, 2.475473 },
  { 1305, 106, 35.574329, 2.442217 },
  { 1305, 107, 34.816166, 2.429099 },
  { 1305, 108, 34.476288, 2.423149 },
  { 1305, 109, 36.534420, 2.458530 },
  { 1305, 110, 41.626949, 2.540058 },
  { 1305, 111, 35.117786, 2.434343 },
  { 1305, 112, 36.927132, 2.465111 },
  { 1305, 113, 48.657162, 2.641111 },
  { 1305, 114, 37.792522, 2.479428 },
  { 1305, 115, 39.298248, 2.503763 },
  { 1305, 116, 37.250000, 2.470481 },
  { 1305, 117, 34.324856, 2.420484 },
  { 1305, 118, 33.870911, 2.412441 },
  { 1306, 70, 32.072025, 2.379751 },
  { 1306, 71, 30.920984, 2.358106 },
  { 1306, 72, 45.525040, 2.597542 },
  { 1306, 73, 27.701252, 2.294166 },
  { 1306, 74, 37.797874, 2.479516 },
  { 1306, 75, 30.476397, 2.349584 },
  { 1306, 76, 33.302822, 2.402261 },
  { 1306, 77, 40.247822, 2.518753 },
  { 1306, 78, 30.171646, 2.343688 },
  { 1306, 79, 41.037319, 2.531015 },
  { 1306, 80, 36.517303, 2.458242 },
  { 1306, 81, 36.079212, 2.450836 },
  { 1306, 82, 47.458225, 2.624689 },
  { 1306, 83, 41.264568, 2.534512 },
  { 1306, 84, 41.386612, 2.536384 },
  { 1306, 85, 26.914558, 2.277702 },
  { 1306, 86, 40.859123, 2.528263 },
  { 1306, 87, 33.594658, 2.407507 },
  { 1306, 88, 43.185394, 2.563505 },
  { 1306, 89, 37.186501, 2.469428 },
  { 1306, 90, 42.942951, 2.559900 },
  { 1306, 91, 43.338692, 2.565777 },
  { 1306, 92, 44.789684, 2.586988 },
  { 1306, 93, 48.720764, 2.641974 },
  { 1306, 94, 34.010693, 2.414926 },
  { 1306, 95, 32.361671, 2.385106 },
  { 1306, 96, 44.110031, 2.577118 },
  { 1306, 97, 44.592075, 2.584130 },
  { 1306, 98, 40.553345, 2.523520 },
  { 1306, 99, 33.639954, 2.408318 },
  { 1306, 100, 30.157585, 2.343415 },
  { 1306, 101, 35.087078, 2.433811 },
  { 1306, 102, 30.620243, 2.352351 },
  { 1306, 103, 35.651566, 2.443541 },
  { 1306, 104, 38.969509, 2.498511 },
  { 1306, 105, 37.178112, 2.469289 },
  { 1306, 106, 41.964203, 2.545187 },
  { 1306, 107, 33.177956, 2.400006 },
  { 1306, 108, 43.988640, 2.575343 },
  { 1306, 109, 38.984615, 2.498753 },
  { 1306, 110, 36.972057, 2.465860 },
  { 1306, 111, 29.326344, 2.327097 },
  { 1306, 112, 33.634811, 2.408226 },
  { 1306, 113, 30.803089, 2.355855 },
  { 1306, 114, 35.573586, 2.442204 },
  { 1306, 115, 44.122837, 2.577305 },
  { 1306, 116, 34.908680, 2.430711 },
  { 1306, 117, 36.490089, 2.457784 },
  { 1306, 118, 31.186398, 2.363150 },
  { 1307, 70, 36.423500, 2.456662 },
  { 1307, 71, 34.653404, 2.426255 },
  { 1307, 72, 40.594658, 2.524162 },
  { 1307, 73, 37.853695, 2.480431 },
  { 1307, 74, 35.240421, 2.436466 },
  { 1307, 75, 57.416908, 2.752707 },
  { 1307, 76, 27.530510, 2.290623 },
  { 1307, 77, 47.886234, 2.630587 },
  { 1307, 78, 30.056190, 2.341442 },
  { 1307, 79, 49.609066, 2.653935 },
  { 1307, 80, 30.930004, 2.358278 },
  { 1307, 81, 46.591305, 2.612620 },
  { 1307, 82, 32.256874, 2.383173 },
  { 1307, 83, 33.221348, 2.400791 },
  { 1307, 84, 43.539616, 2.568746 },
  { 1307, 85, 38.799988, 2.495789 },
  { 1307, 86, 41.521263, 2.538444 },
  { 1307, 87, 48.376255, 2.637291 },
  { 1307, 88, 29.249252, 2.325566 },
  { 1307, 89, 45.484219, 2.596960 },
  { 1307, 90, 38.485107, 2.490710 },
  { 1307, 91, 45.426865, 2.596140 },
  { 1307, 92, 31.165766, 2.362759 },
  { 1307, 93, 35.120605, 2.434392 },
  { 1307, 94, 41.316452, 2.535308 },
  { 1307, 95, 41.125889, 2.532380 },
  { 1307, 96, 42.344189, 2.550930 },
  { 1307, 97, 48.311756, 2.636412 },
  { 1307, 98, 46.553730, 2.612093 },
  { 1307, 99, 37.746689, 2.478676 },
  { 1307, 100, 38.803356, 2.495843 },
  { 1307, 101, 47.062889, 2.619206 },
  { 1307, 102, 23.591187, 2.203877 },
  { 1307, 103, 48.890213, 2.644268 },
  { 1307, 104, 42.593811, 2.554681 },
  { 1307, 105, 37.809391, 2.479704 },
  { 1307, 106, 44.868999, 2.588133 },
  { 1307, 107, 36.019009, 2.449813 },
  { 1307, 108, 31.445101, 2.368036 },
  { 1307, 109, 37.637020, 2.476873 },
  { 1307, 110, 37.711090, 2.478091 },
  { 1307, 111, 33.878933, 2.412584 },
  { 1307, 112, 35.626865, 2.443118 },
  { 1307, 113, 32.868427, 2.394389 },
  { 1307, 114, 39.286156, 2.503571 },
  { 1307, 115, 42.164467, 2.548218 },
  { 1307, 116, 35.926632, 2.448241 },
  { 1307, 117, 43.739338, 2.571687 },
  { 1307, 118, 43.575676, 2.569278 },
  { 1308, 70, 42.645546, 2.555456 },
  { 1308, 71, 37.298717, 2.471289 },
  { 1308, 72, 42.815392, 2.557997 },
  { 1308, 73, 46.083748, 2.605475 },
  { 1308, 74, 32.900623, 2.394975 },
  { 1308, 75, 28.684584, 2.314260 },
  { 1308, 76, 34.155247, 2.417488 },
  { 1308, 77, 28.564016, 2.311824 },
  { 1308, 78, 41.495277, 2.538047 },
  { 1308, 79, 31.585819, 2.370681 },
  { 1308, 80, 42.810001, 2.557916 },
  { 1308, 81, 46.537121, 2.611860 },
  { 1308, 82, 35.802891, 2.446130 },
  { 1308, 83, 47.489296, 2.625119 },
  { 1308, 84, 34.056446, 2.415738 },
  { 1308, 85, 35.592365, 2.442526 },
  { 1308, 86, 46.909023, 2.617063 },
  { 1308, 87, 34.105186, 2.416602 },
  { 1308, 88, 49.877766, 2.657521 },
  { 1308, 89, 35.482212, 2.440634 },
  { 1308, 90, 53.448109, 2.703853 },
  { 1308, 91, 48.639843, 2.640876 },
  { 1308, 92, 39.648064, 2.509317 },
  { 1308, 93, 34.909229, 2.430721 },
  { 1308, 94, 30.355595, 2.347252 },
  { 1308, 95, 40.658997, 2.525162 },
  { 1308, 96, 52.151051, 2.687298 },
  { 1308, 97, 45.862518, 2.602343 },
  { 1308, 98, 39.807041, 2.511828 },
  { 1308, 99, 32.683147, 2.391008 },
  { 1308, 100, 36.643520, 2.460364 },
  { 1308, 101, 43.467552, 2.567682 },
  { 1308, 102, 31.913155, 2.376799 },
  { 1308, 103, 39.291927, 2.503663 },
  { 1308, 104, 43.372993, 2.566285 },
  { 1308, 105, 39.349934, 2.504586 },
  { 1308, 106, 39.091110, 2.500458 },
  { 1308, 107, 50.391270, 2.664335 },
  { 1308, 108, 48.724018, 2.642018 },
  { 1308, 109, 44.239025, 2.579000 },
  { 1308, 110, 33.179840, 2.400040 },
  { 1308, 111, 39.178551, 2.501855 },
  { 1308, 112, 36.923599, 2.465051 },
  { 1308, 113, 36.167511, 2.452334 },
  { 1308, 114, 39.330139, 2.504271 },
  { 1308, 115, 34.928780, 2.431061 },
  { 1308, 116, 43.374828, 2.566312 },
  { 1308, 117, 43.302963, 2.565248 },
  { 1308, 118, 32.093502, 2.380150 },
  { 1309, 70, 30.069166, 2.341695 },
  { 1309, 71, 30.476824, 2.349592 },
  { 1309, 72, 32.885330, 2.394697 },
  { 1309, 73, 35.970886, 2.448994 },
  { 1309, 74, 43.026966, 2.561151 },
  { 1309, 75, 39.326530, 2.504214 },
  { 1309, 76, 34.725994, 2.427525 },
  { 1309, 77, 51.653591, 2.680866 },
  { 1309, 78, 44.221352, 2.578743 },
  { 1309, 79, 29.470085, 2.329943 },
  { 1309, 80, 35.547695, 2.441759 },
  { 1309, 81, 39.184532, 2.501950 },
  { 1309, 82, 47.120239, 2.620003 },
  { 1309, 83, 47.050438, 2.619033 },
  { 1309, 84, 49.487545, 2.652308 },
  { 1309, 85, 39.838306, 2.512321 },
  { 1309, 86, 57.245827, 2.750654 },
  { 1309, 87, 43.537056, 2.568708 },
  { 1309, 88, 43.062378, 2.561678 },
  { 1309, 89, 37.078442, 2.467632 },
  { 1309, 90, 51.784218, 2.682559 },
  { 1309, 91, 46.716564, 2.614374 },
  { 1309, 92, 56.539471, 2.742129 },
  { 1309, 93, 50.457981, 2.665216 },
  { 1309, 94, 50.865631, 2.670583 },
  { 1309, 95, 45.078125, 2.591143 },
  { 1309, 96, 48.680950, 2.641434 },
  { 1309, 97, 51.239414, 2.675476 },
  { 1309, 98, 40.273022, 2.519147 },
  { 1309, 99, 51.224449, 2.675281 },
  { 1309, 100, 51.158424, 2.674418 },
  { 1309, 101, 30.645229, 2.352831 },
  { 1309, 102, 37.781738, 2.479251 },
  { 1309, 103, 46.290005, 2.608386 },
  { 1309, 104, 38.942238, 2.498074 },
  { 1309, 105, 51.472572, 2.678514 },
  { 1309, 106, 43.976570, 2.575167 },
  { 1309, 107, 36.993340, 2.466215 },
  { 1309, 108, 43.920643, 2.574347 },
  { 1309, 109, 43.449768, 2.567420 },
  { 1309, 110, 43.067318, 2.561751 },
  { 1309, 111, 45.710411, 2.600182 },
  { 1309, 112, 39.833572, 2.512247 },
  { 1309, 113, 39.403584, 2.505440 },
  { 1309, 114, 37.391148, 2.472818 },
  { 1309, 115, 30.927826, 2.358237 },
  { 1309, 116, 42.154224, 2.548064 },
  { 1309, 117, 37.153114, 2.468873 },
  { 1309, 118, 38.079117, 2.484115 },
  { 1310, 70, 34.139683, 2.417213 },
  { 1310, 71, 29.222923, 2.325043 },
  { 1310, 72, 23.364279, 2.198559 },
  { 1310, 73, 37.652546, 2.477129 },
  { 1310, 74, 43.023422, 2.561098 },
  { 1310, 75, 30.983286, 2.359293 },
  { 1310, 76, 35.677124, 2.443979 },
  { 1310, 77, 33.131252, 2.399161 },
  { 1310, 78, 39.564346, 2.507991 },
  { 1310, 79, 30.824278, 2.356260 },
  { 1310, 80, 29.630138, 2.333100 },
  { 1310, 81, 39.497677, 2.506934 },
  { 1310, 82, 48.234146, 2.635352 },
  { 1310, 83, 39.962830, 2.514282 },
  { 1310, 84, 39.097801, 2.500565 },
  { 1310, 85, 40.886368, 2.528684 },
  { 1310, 86, 33.941895, 2.413704 },
  { 1310, 87, 46.675678, 2.613802 },
  { 1310, 88, 43.289959, 2.565056 },
  { 1310, 89, 32.801292, 2.393166 },
  { 1310, 90, 28.736267, 2.315302 },
  { 1310, 91, 36.954067, 2.465560 },
  { 1310, 92, 50.967815, 2.671923 },
  { 1310, 93, 54.036251, 2.711261 },
  { 1310, 94, 51.804562, 2.682823 },
  { 1310, 95, 56.796032, 2.745235 },
  { 1310, 96, 51.145370, 2.674247 },
  { 1310, 97, 44.474957, 2.582432 },
  { 1310, 98, 40.240555, 2.518639 },
  { 1310, 99, 55.419064, 2.728442 },
  { 1310, 100, 34.812233, 2.429031 },
  { 1310, 101, 37.748596, 2.478707 },
  { 1310, 102, 55.006001, 2.723344 },
  { 1310, 103, 38.736851, 2.494773 },
  { 1310, 104, 37.969448, 2.482325 },
  { 1310, 105, 43.211113, 2.563887 },
  { 1310, 106, 57.618488, 2.755120 },
  { 1310, 107, 38.389912, 2.489168 },
  { 1310, 108, 37.671078, 2.477433 },
  { 1310, 109, 26.482277, 2.268500 },
  { 1310, 110, 45.812931, 2.601639 },
  { 1310, 111, 40.879753, 2.528582 },
  { 1310, 112, 52.222301, 2.688215 },
  { 1310, 113, 33.305008, 2.402301 },
  { 1310, 114, 43.763721, 2.572045 },
  { 1310, 115, 37.954002, 2.482072 },
  { 1310, 116, 41.784290, 2.542455 },
  { 1310, 117, 51.156872, 2.674398 },
  { 1310, 118, 45.987129, 2.604109 },
  { 1311, 70, 35.791340, 2.445933 },
  { 1311, 71, 39.926682, 2.513714 },
  { 1311, 72, 30.859438, 2.356932 },
  { 1311, 73, 40.647602, 2.524985 },
  { 1311, 74, 31.528078, 2.369596 },
  { 1311, 75, 39.188545, 2.502014 },
  { 1311, 76, 32.094219, 2.380163 },
  { 1311, 77, 40.306347, 2.519668 },
  { 1311, 78, 38.697746, 2.494143 },
  { 1311, 79, 36.262138, 2.453937 },
  { 1311, 80, 43.979389, 2.575208 },
  { 1311, 81, 32.319969, 2.384337 },
  { 1311, 82, 34.519154, 2.423902 },
  { 1311, 83, 32.870193, 2.394421 },
  { 1311, 84, 45.785370, 2.601248 },
  { 1311, 85, 36.614040, 2.459869 },
  { 1311, 86, 40.630089, 2.524713 },
  { 1311, 87, 46.970825, 2.617924 },
  { 1311, 88, 44.652454, 2.585005 },
  { 1311, 89, 46.758648, 2.614963 },
  { 1311, 90, 61.419060, 2.799470 },
  { 1311, 91, 55.724274, 2.732191 },
  { 1311, 92, 67.014755, 2.861163 },
  { 1311, 93, 68.812027, 2.880157 },
  { 1311, 94, 61.515820, 2.800572 },
  { 1311, 95, 62.154228, 2.807810 },
  { 1311, 96, 54.657387, 2.719019 },
  { 1311, 97, 55.099030, 2.724495 },
  { 1311, 98, 61.976665, 2.805802 },
  { 1311, 99, 62.798641, 2.815059 },
  { 1311, 100, 38.759018, 2.495130 },
  { 1311, 101, 40.066486, 2.515911 },
  { 1311, 102, 52.585949, 2.692883 },
  { 1311, 103, 41.877983, 2.543879 },
  { 1311, 104, 47.810776, 2.629550 },
  { 1311, 105, 33.538303, 2.406497 },
  { 1311, 106, 31.168257, 2.362806 },
  { 1311, 107, 39.324982, 2.504189 },
  { 1311, 108, 31.587072, 2.370704 },
  { 1311, 109, 41.958721, 2.545104 },
  { 1311, 110, 42.175587, 2.548386 },
  { 1311, 111, 37.143051, 2.468706 },
  { 1311, 112, 51.726116, 2.681807 },
  { 1311, 113, 44.302681, 2.579927 },
  { 1311, 114, 46.030628, 2.604724 },
  { 1311, 115, 36.533630, 2.458517 },
  { 1311, 116, 33.918575, 2.413289 },
  { 1311, 117, 40.712860, 2.525997 },
  { 1311, 118, 38.454288, 2.490211 },
  { 1312, 70, 32.193905, 2.382009 },
  { 1312, 71, 47.393959, 2.623800 },
  { 1312, 72, 37.532104, 2.475146 },
  { 1312, 73, 44.537376, 2.583338 },
  { 1312, 74, 49.033253, 2.646200 },
  { 1312, 75, 43.061874, 2.561670 },
  { 1312, 76, 45.084293, 2.591232 },
  { 1312, 77, 40.082607, 2.516164 },
  { 1312, 78, 45.395149, 2.595687 },
  { 1312, 79, 37.733059, 2.478452 },
  { 1312, 80, 44.693306, 2.585596 },
  { 1312, 81, 37.024879, 2.466740 },
  { 1312, 82, 46.735565, 2.614640 },
  { 1312, 83, 30.081463, 2.341934 },
  { 1312, 84, 41.796795, 2.542645 },
  { 1312, 85, 51.433872, 2.678011 },
  { 1312, 86, 37.335094, 2.471891 },
  { 1312, 87, 47.105934, 2.619805 },
  { 1312, 88, 60.451427, 2.788378 },
  { 1312, 89, 60.783909, 2.792204 },
  { 1312, 90, 61.519478, 2.800613 },
  { 1312, 91, 85.740585, 3.042963 },
  { 1312, 92, 73.500595, 2.928011 },
  { 1312, 93, 84.627167, 3.033035 },
  { 1312, 94, 90.290619, 3.082554 },
  { 1312, 95, 76.876701, 2.961070 },
  { 1312, 96, 75.833839, 2.950977 },
  { 1312, 97, 69.579498, 2.888154 },
  { 1312, 98, 74.934219, 2.942185 },
  { 1312, 99, 66.840355, 2.859300 },
  { 1312, 100, 64.857208, 2.837851 },
  { 1312, 101, 49.427925, 2.651509 },
  { 1312, 102, 51.735950, 2.681934 },
  { 1312, 103, 49.722595, 2.655452 },
  { 1312, 104, 38.706676, 2.494287 },
  { 1312, 105, 37.656208, 2.477189 },
  { 1312, 106, 53.990036, 2.710681 },
  { 1312, 107, 46.965687, 2.617852 },
  { 1312, 108, 37.745567, 2.478657 },
  { 1312, 109, 34.681934, 2.426754 },
  { 1312, 110, 36.021049, 2.449848 },
  { 1312, 111, 43.532711, 2.568644 },
  { 1312, 112, 34.183769, 2.417993 },
  { 1312, 113, 34.185993, 2.418032 },
  { 1312, 114, 34.097195, 2.416460 },
  { 1312, 115, 36.359673, 2.455585 },
  { 1312, 116, 35.548897, 2.441780 },
  { 1312, 117, 30.092890, 2.342157 },
  { 1312, 118, 35.065304, 2.433433 },
  { 1313, 70, 45.888374, 2.602709 },
  { 1313, 71, 41.394386, 2.536503 },
  { 1313, 72, 48.824406, 2.643378 },
  { 1313, 73, 44.371437, 2.580928 },
  { 1313, 74, 37.549316, 2.475429 },
  { 1313, 75, 53.190819, 2.700593 },
  { 1313, 76, 43.485485, 2.567947 },
  { 1313, 77, 39.931461, 2.513789 },
  { 1313, 78, 32.560619, 2.388764 },
  { 1313, 79, 35.718040, 2.444679 },
  { 1313, 80, 49.342091, 2.650357 },
  { 1313, 81, 48.418297, 2.637864 },
  { 1313, 82, 31.112055, 2.361740 },
  { 1313, 83, 34.045795, 2.415549 },
  { 1313, 84, 43.996105, 2.575453 },
  { 1313, 85, 46.122066, 2.606017 },
  { 1313, 86, 40.576656, 2.523882 },
  { 1313, 87, 51.308487, 2.676377 },
  { 1313, 88, 62.533531, 2.812084 },
  { 1313, 89, 60.501774, 2.788958 },
  { 1313, 90, 64.856476, 2.837843 },
  { 1313, 91, 84.073586, 3.028063 },
  { 1313, 92, 113.474953, 3.263811 },
  { 1313, 93, 108.873283, 3.230207 },
  { 1313, 94, 123.278145, 3.332127 },
  { 1313, 95, 137.531631, 3.424527 },
  { 1313, 96, 134.080490, 3.402839 },
  { 1313, 97, 104.522644, 3.197441 },
  { 1313, 98, 104.228851, 3.195192 },
  { 1313, 99, 80.981865, 2.999832 },
  { 1313, 100, 61.288700, 2.797983 },
  { 1313, 101, 59.078033, 2.772404 },
  { 1313, 102, 50.200565, 2.661811 },
  { 1313, 103, 49.446228, 2.651754 },
  { 1313, 104, 37.453186, 2.473843 },
  { 1313, 105, 48.405731, 2.637693 },
  { 1313, 106, 28.704866, 2.314669 },
  { 1313, 107, 45.016819, 2.590262 },
  { 1313, 108, 42.025234, 2.546112 },
  { 1313, 109, 45.209976, 2.593036 },
  { 1313, 110, 45.921219, 2.603175 },
  { 1313, 111, 36.263870, 2.453966 },
  { 1313, 112, 39.541103, 2.507623 },
  { 1313, 113, 26.365150, 2.265988 },
  { 1313, 114, 38.002857, 2.482870 },
  { 1313, 115, 29.825853, 2.336944 },
  { 1313, 116, 31.822138, 2.375102 },
  { 1313, 117, 25.247730, 2.241587 },
  { 1313, 118, 44.960964, 2.589458 },
  { 1314, 70, 36.478516, 2.457589 },
  { 1314, 71, 23.310820, 2.197300 },
  { 1314, 72, 38.405880, 2.489427 },
  { 1314, 73, 31.559381, 2.370184 },
  { 1314, 74, 38.667557, 2.493657 },
  { 1314, 75, 47.755520, 2.628790 },
  { 1314, 76, 38.006046, 2.482923 },
  { 1314, 77, 38.989784, 2.498836 },
  { 1314, 78, 31.176479, 2.362962 },
  { 1314, 79, 49.373985, 2.650785 },
  { 1314, 80, 50.926117, 2.671377 },
  { 1314, 81, 33.918358, 2.413285 },
  { 1314, 82, 39.942844, 2.513968 },
  { 1314, 83, 39.790634, 2.511570 },
  { 1314, 84, 26.432777, 2.267439 },
  { 1314, 85, 41.605305, 2.539728 },
  { 1314, 86, 48.672874, 2.641325 },
  { 1314, 87, 39.968609, 2.514373 },
  { 1314, 88, 66.467468, 2.855304 },
  { 1314, 89, 68.745956, 2.879465 },
  { 1314, 90, 82.424385, 3.013103 },
  { 1314, 91, 96.586975, 3.134943 },
  { 1314, 92, 139.162033, 3.434632 },
  { 1314, 93, 148.401794, 3.490276 },
  { 1314, 94, 152.994492, 3.516972 },
  { 1314, 95, 219.528870, 3.849221 },
  { 1314, 96, 175.551208, 3.639996 },
  { 1314, 97, 156.658844, 3.537844 },
  { 1314, 98, 145.312576, 3.471969 },
  { 1314, 99, 101.178505, 3.171554 },
  { 1314, 100, 83.394356, 3.021929 },
  { 1314, 101, 51.798084, 2.682739 },
  { 1314, 102, 51.496716, 2.678828 },
  { 1314, 103, 52.279739, 2.688954 },
  { 1314, 104, 34.761967, 2.428153 },
  { 1314, 105, 43.584778, 2.569412 },
  { 1314, 106, 45.272041, 2.593926 },
  { 1314, 107, 41.665043, 2.540639 },
  { 1314, 108, 40.454433, 2.521979 },
  { 1314, 109, 35.611698, 2.442858 },
  { 1314, 110, 43.410973, 2.566846 },
  { 1314, 111, 33.232727, 2.400996 },
  { 1314, 112, 36.098999, 2.451172 },
  { 1314, 113, 37.566376, 2.475710 },
  { 1314, 114, 30.784431, 2.355498 },
  { 1314, 115, 40.475899, 2.522314 },
  { 1314, 116, 35.788517, 2.445884 },
  { 1314, 117, 29.062843, 2.321852 },
  { 1314, 118, 36.917126, 2.464943 },
  { 1315, 70, 22.803652, 2.185250 },
  { 1315, 71, 31.026886, 2.360123 },
  { 1315, 72, 36.919182, 2.464978 },
  { 1315, 73, 38.221649, 2.486436 },
  { 1315, 74, 45.716412, 2.600267 },
  { 1315, 75, 33.153004, 2.399555 },
  { 1315, 76, 36.495022, 2.457867 },
  { 1315, 77, 35.362438, 2.438572 },
  { 1315, 78, 36.136890, 2.451815 },
  { 1315, 79, 34.735344, 2.427688 },
  { 1315, 80, 40.561638, 2.523649 },
  { 1315, 81, 37.656040, 2.477186 },
  { 1315, 82, 36.853497, 2.463881 },
  { 1315, 83, 52.202991, 2.687967 },
  { 1315, 84, 43.772774, 2.572178 },
  { 1315, 85, 46.507553, 2.611445 },
  { 1315, 86, 33.677807, 2.408995 },
  { 1315, 87, 59.148022, 2.773225 },
  { 1315, 88, 74.462547, 2.937545 },
  { 1315, 89, 79.404022, 2.985112 },
  { 1315, 90, 108.335419, 3.226210 },
  { 1315, 91, 157.697632, 3.543695 },
  { 1315, 92, 192.829239, 3.726432 },
  { 1315, 93, 270.915497, 4.057032 },
  { 1315, 94, 300.829376, 4.164665 },
  { 1315, 95, 329.455139, 4.260387 },
  { 1315, 96, 278.754608, 4.086067 },
  { 1315, 97, 258.081512, 4.008106 },
  { 1315, 98, 209.651352, 3.805173 },
  { 1315, 99, 141.840515, 3.451041 },
  { 1315, 100, 100.392723, 3.165378 },
  { 1315, 101, 60.797806, 2.792364 },
  { 1315, 102, 49.443928, 2.651724 },
  { 1315, 103, 59.762714, 2.780402 },
  { 1315, 104, 39.922958, 2.513655 },
  { 1315, 105, 44.394222, 2.581259 },
  { 1315, 106, 41.610859, 2.539813 },
  { 1315, 107, 30.208179, 2.344397 },
  { 1315, 108, 34.402203, 2.421846 },
  { 1315, 109, 37.776806, 2.479170 },
  { 1315, 110, 40.096508, 2.516382 },
  { 1315, 111, 36.839336, 2.463644 },
  { 1315, 112, 32.872929, 2.394471 },
  { 1315, 113, 37.601231, 2.476284 },
  { 1315, 114, 34.203636, 2.418344 },
  { 1315, 115, 37.760036, 2.478895 },
  { 1315, 116, 44.976742, 2.589685 },
  { 1315, 117, 37.179543, 2.469312 },
  { 1315, 118, 39.362682, 2.504789 },
  { 1316, 70, 55.401138, 2.728222 },
  { 1316, 71, 33.906403, 2.413073 },
  { 1316, 72, 35.638004, 2.443309 },
  { 1316, 73, 36.414360, 2.456508 },
  { 1316, 74, 38.394676, 2.489246 },
  { 1316, 75, 34.471844, 2.423071 },
  { 1316, 76, 40.807922, 2.527471 },
  { 1316, 77, 44.054878, 2.576312 },
  { 1316, 78, 39.006680, 2.499106 },
  { 1316, 79, 36.886059, 2.464425 },
  { 1316, 80, 54.457848, 2.716534 },
  { 1316, 81, 45.064453, 2.590947 },
  { 1316, 82, 43.428356, 2.567103 },
  { 1316, 83, 41.365505, 2.536060 },
  { 1316, 84, 51.593369, 2.680084 },
  { 1316, 85, 35.845467, 2.446857 },
  { 1316, 86, 59.171017, 2.773494 },
  { 1316, 87, 58.143833, 2.761378 },
  { 1316, 88, 69.036911, 2.882507 },
  { 1316, 89, 78.316620, 2.974839 },
  { 1316, 90, 132.530991, 3.392965 },
  { 1316, 91, 193.471481, 3.729531 },
  { 1316, 92, 283.492920, 4.103322 },
  { 1316, 93, 388.709045, 4.440237 },
  { 1316, 94, 499.650970, 4.727883 },
  { 1316, 95, 549.881042, 4.842473 },
  { 1316, 96, 559.470093, 4.863447 },
  { 1316, 97, 409.565887, 4.498637 },
  { 1316, 98, 291.568542, 4.132236 },
  { 1316, 99, 187.526382, 3.700544 },
  { 1316, 100, 134.093338, 3.402920 },
  { 1316, 101, 94.239838, 3.115721 },
  { 1316, 102, 61.519520, 2.800614 },
  { 1316, 103, 44.240448, 2.579021 },
  { 1316, 104, 52.606388, 2.693144 },
  { 1316, 105, 51.839123, 2.683270 },
  { 1316, 106, 39.554783, 2.507840 },
  { 1316, 107, 45.474903, 2.596827 },
  { 1316, 108, 50.324898, 2.663457 },
  { 1316, 109, 39.874180, 2.512887 },
  { 1316, 110, 48.360130, 2.637071 },
  { 1316, 111, 31.062019, 2.360790 },
  { 1316, 112, 30.696978, 2.353824 },
  { 1316, 113, 55.399822, 2.728206 },
  { 1316, 114, 33.632652, 2.408187 },
  { 1316, 115, 43.474522, 2.567785 },
  { 1316, 116, 32.527668, 2.388159 },
  { 1316, 117, 44.386337, 2.581145 },
  { 1316, 118, 27.420462, 2.288330 },
  { 1317, 70, 31.167744, 2.362797 },
  { 1317, 71, 34.536297, 2.424203 },
  { 1317, 72, 37.990971, 2.482676 },
  { 1317, 73, 29.428818, 2.329127 },
  { 1317, 74, 38.590889, 2.492420 },
  { 1317, 75, 33.992447, 2.414602 },
  { 1317, 76, 42.884544, 2.559029 },
  { 1317, 77, 38.447010, 2.490093 },
  { 1317, 78, 46.384560, 2.609717 },
  { 1317, 79, 40.372604, 2.520703 },
  { 1317, 80, 42.274734, 2.549883 },
  { 1317, 81, 28.015905, 2.300653 },
  { 1317, 82, 44.679970, 2.585403 },
  { 1317, 83, 34.433369, 2.422395 },
  { 1317, 84, 40.793411, 2.527246 },
  { 1317, 85, 56.730415, 2.744442 },
  { 1317, 86, 66.341278, 2.853947 },
  { 1317, 87, 55.439388, 2.728693 },
  { 1317, 88, 87.931442, 3.062217 },
  { 1317, 89, 97.728691, 3.144166 },
  { 1317, 90, 175.966675, 3.642148 },
  { 1317, 91, 274.228333, 4.069378 },
  { 1317, 92, 459.367828, 4.629564 },
  { 1317, 93, 628.433228, 5.006853 },
  { 1317, 94, 875.866699, 5.440133 },
  { 1317, 95, 919.657349, 5.506891 },
  { 1317, 96, 786.893188, 5.296378 },
  { 1317, 97, 564.019287, 4.873304 },
  { 1317, 98, 336.946625, 4.284403 },
  { 1317, 99, 223.057999, 3.864599 },
  { 1317, 100, 137.331924, 3.423284 },
  { 1317, 101, 99.718048, 3.160046 },
  { 1317, 102, 65.619171, 2.846149 },
  { 1317, 103, 45.090446, 2.591321 },
  { 1317, 104, 47.631557, 2.627082 },
  { 1317, 105, 44.754169, 2.586476 },
  { 1317, 106, 44.849396, 2.587850 },
  { 1317, 107, 40.843708, 2.528025 },
  { 1317, 108, 38.730160, 2.494665 },
  { 1317, 109, 35.017498, 2.432603 },
  { 1317, 110, 44.297676, 2.579855 },
  { 1317, 111, 52.412361, 2.690658 },
  { 1317, 112, 39.453072, 2.506226 },
  { 1317, 113, 35.038475, 2.432967 },
  { 1317, 114, 30.363562, 2.347406 },
  { 1317, 115, 47.788559, 2.629245 },
  { 1317, 116, 35.067104, 2.433464 },
  { 1317, 117, 35.203156, 2.435821 },
  { 1317, 118, 29.645678, 2.333406 },
  { 1318, 70, 32.435417, 2.386464 },
  { 1318, 71, 43.218197, 2.563992 },
  { 1318, 72, 24.609264, 2.227279 },
  { 1318, 73, 35.871185, 2.447296 },
  { 1318, 74, 47.286663, 2.622314 },
  { 1318, 75, 41.656219, 2.540504 },
  { 1318, 76, 34.751232, 2.427966 },
  { 1318, 77, 51.712303, 2.681628 },
  { 1318, 78, 47.744675, 2.628641 },
  { 1318, 79, 43.379131, 2.566375 },
  { 1318, 80, 46.079044, 2.605409 },
  { 1318, 81, 34.219322, 2.418621 },
  { 1318, 82, 45.841702, 2.602047 },
  { 1318, 83, 36.416908, 2.456551 },
  { 1318, 84, 39.180401, 2.501884 },
  { 1318, 85, 47.084476, 2.619506 },
  { 1318, 86, 59.859276, 2.781524 },
  { 1318, 87, 83.970131, 3.027131 },
  { 1318, 88, 85.270699, 3.038785 },
  { 1318, 89, 135.361557, 3.410938 },
  { 1318, 90, 222.491013, 3.862141 },
  { 1318, 91, 342.500275, 4.301949 },
  { 1318, 92, 624.542419, 4.999084 },
  { 1318, 93, 897.742493, 5.473788 },
  { 1318, 94, 1136.391602, 5.806067 },
  { 1318, 95, 1122.346680, 5.788043 },
  { 1318, 96, 953.828003, 5.557347 },
  { 1318, 97, 691.345337, 5.127714 },
  { 1318, 98, 411.278137, 4.503331 },
  { 1318, 99, 216.279663, 3.834899 },
  { 1318, 100, 134.406784, 3.404907 },
  { 1318, 101, 110.781746, 3.244270 },
  { 1318, 102, 67.328590, 2.864507 },
  { 1318, 103, 55.128510, 2.724859 },
  { 1318, 104, 40.631237, 2.524730 },
  { 1318, 105, 39.784298, 2.511470 },
  { 1318, 106, 48.793716, 2.642962 },
  { 1318, 107, 40.068825, 2.515948 },
  { 1318, 108, 47.750290, 2.628718 },
  { 1318, 109, 45.850571, 2.602173 },
  { 1318, 110, 40.126301, 2.516850 },
  { 1318, 111, 40.087704, 2.516244 },
  { 1318, 112, 34.296787, 2.419989 },
  { 1318, 113, 35.463104, 2.440305 },
  { 1318, 114, 36.993565, 2.466218 },
  { 1318, 115, 37.456062, 2.473891 },
  { 1318, 116, 40.605488, 2.524330 },
  { 1318, 117, 37.717575, 2.478198 },
  { 1318, 118, 39.260204, 2.503157 },
  { 1319, 70, 37.662731, 2.477296 },
  { 1319, 71, 48.959564, 2.645205 },
  { 1319, 72, 46.303593, 2.608577 },
  { 1319, 73, 46.792805, 2.615440 },
  { 1319, 74, 46.899620, 2.616931 },
  { 1319, 75, 32.963200, 2.396113 },
  { 1319, 76, 34.721859, 2.427453 },
  { 1319, 77, 27.918068, 2.298642 },
  { 1319, 78, 53.921879, 2.709825 },
  { 1319, 79, 27.628124, 2.292650 },
  { 1319, 80, 45.088047, 2.591286 },
  { 1319, 81, 34.260975, 2.419357 },
  { 1319, 82, 53.469997, 2.704130 },
  { 1319, 83, 40.473999, 2.522284 },
  { 1319, 84, 42.078907, 2.546925 },
  { 1319, 85, 57.610058, 2.755019 },
  { 1319, 86, 65.658821, 2.846579 },
  { 1319, 87, 79.522781, 2.986228 },
  { 1319, 88, 101.347122, 3.172874 },
  { 1319, 89, 130.347214, 3.378901 },
  { 1319, 90, 223.029053, 3.864474 },
  { 1319, 91, 395.281677, 4.458889 },
  { 1319, 92, 672.765076, 5.092908 },
  { 1319, 93, 1039.525146, 5.678175 },
  { 1319, 94, 1329.769897, 6.038709 },
  { 1319, 95, 1270.317627, 5.970051 },
  { 1319, 96, 987.630188, 5.605942 },
  { 1319, 97, 723.947388, 5.187126 },
  { 1319, 98, 420.009308, 4.527044 },
  { 1319, 99, 245.331863, 3.957660 },
  { 1319, 100, 135.817139, 3.413805 },
  { 1319, 101, 103.486336, 3.189486 },
  { 1319, 102, 47.348553, 2.623172 },
  { 1319, 103, 54.238873, 2.713799 },
  { 1319, 104, 49.929596, 2.658211 },
  { 1319, 105, 43.737251, 2.571656 },
  { 1319, 106, 34.936619, 2.431197 },
  { 1319, 107, 43.208126, 2.563843 },
  { 1319, 108, 47.041782, 2.618912 },
  { 1319, 109, 36.292923, 2.454457 },
  { 1319, 110, 36.361797, 2.455621 },
  { 1319, 111, 27.818527, 2.296590 },
  { 1319, 112, 39.849312, 2.512495 },
  { 1319, 113, 41.950909, 2.544986 },
  { 1319, 114, 41.618561, 2.539930 },
  { 1319, 115, 46.079567, 2.605416 },
  { 1319, 116, 44.925137, 2.588942 },
  { 1319, 117, 34.946041, 2.431361 },
  { 1319, 118, 52.053402, 2.686039 },
  { 1320, 70, 33.404785, 2.404098 },
  { 1320, 71, 39.646275, 2.509289 },
  { 1320, 72, 39.750656, 2.510938 },
  { 1320, 73, 38.325661, 2.488126 },
  { 1320, 74, 31.960978, 2.377689 },
  { 1320, 75, 32.474087, 2.387175 },
  { 1320, 76, 36.431656, 2.456800 },
  { 1320, 77, 38.933105, 2.497927 },
  { 1320, 78, 42.266407, 2.549757 },
  { 1320, 79, 30.173557, 2.343725 },
  { 1320, 80, 29.311954, 2.326812 },
  { 1320, 81, 38.495770, 2.490883 },
  { 1320, 82, 40.085995, 2.516217 },
  { 1320, 83, 35.420059, 2.439564 },
  { 1320, 84, 36.725136, 2.461732 },
  { 1320, 85, 56.169167, 2.737628 },
  { 1320, 86, 61.292362, 2.798025 },
  { 1320, 87, 66.452011, 2.855138 },
  { 1320, 88, 91.892776, 3.096138 },
  { 1320, 89, 139.542892, 3.436979 },
  { 1320, 90, 233.082230, 3.907305 },
  { 1320, 91, 406.362701, 4.489815 },
  { 1320, 92, 634.656372, 5.019202 },
  { 1320, 93, 950.291016, 5.552188 },
  { 1320, 94, 1103.213867, 5.763216 },
  { 1320, 95, 1041.865601, 5.681368 },
  { 1320, 96, 891.411316, 5.464111 },
  { 1320, 97, 572.360046, 4.891222 },
  { 1320, 98, 337.047119, 4.284722 },
  { 1320, 99, 238.122543, 3.928259 },
  { 1320, 100, 119.184219, 3.304111 },
  { 1320, 101, 100.630653, 3.167252 },
  { 1320, 102, 77.111664, 2.963330 },
  { 1320, 103, 58.822262, 2.769398 },
  { 1320, 104, 48.463680, 2.638482 },
  { 1320, 105, 50.099342, 2.660468 },
  { 1320, 106, 44.376240, 2.580998 },
  { 1320, 107, 42.317329, 2.550525 },
  { 1320, 108, 44.726852, 2.586081 },
  { 1320, 109, 47.006771, 2.618425 },
  { 1320, 110, 34.987843, 2.432088 },
  { 1320, 111, 42.238052, 2.549330 },
  { 1320, 112, 43.708923, 2.571239 },
  { 1320, 113, 43.811352, 2.572745 },
  { 1320, 114, 40.824348, 2.527725 },
  { 1320, 115, 45.254074, 2.593668 },
  { 1320, 116, 50.878479, 2.670752 },
  { 1320, 117, 37.560211, 2.475609 },
  { 1320, 118, 33.659882, 2.408675 },
  { 1321, 70, 36.006130, 2.449594 },
  { 1321, 71, 56.251945, 2.738636 },
  { 1321, 72, 34.910610, 2.430745 },
  { 1321, 73, 34.429230, 2.422322 },
  { 1321, 74, 26.847034, 2.276272 },
  { 1321, 75, 35.673615, 2.443919 },
  { 1321, 76, 37.323799, 2.471704 },
  { 1321, 77, 37.327480, 2.471765 },
  { 1321, 78, 34.130985, 2.417059 },
  { 1321, 79, 37.375759, 2.472564 },
  { 1321, 80, 34.496655, 2.423507 },
  { 1321, 81, 33.411335, 2.404216 },
  { 1321, 82, 39.005127, 2.499082 },
  { 1321, 83, 28.095757, 2.302291 },
  { 1321, 84, 49.527668, 2.652846 },
  { 1321, 85, 37.252865, 2.470529 },
  { 1321, 86, 53.652813, 2.706438 },
  { 1321, 87, 81.296944, 3.002746 },
  { 1321, 88, 85.598770, 3.041704 },
  { 1321, 89, 151.725006, 3.509654 },
  { 1321, 90, 209.599136, 3.804936 },
  { 1321, 91, 362.003143, 4.361924 },
  { 1321, 92, 532.874084, 4.804588 },
  { 1321, 93, 754.405334, 5.240843 },
  { 1321, 94, 900.682922, 5.478264 },
  { 1321, 95, 751.355896, 5.235539 },
  { 1321, 96, 618.202148, 4.986349 },
  { 1321, 97, 419.165283, 4.524768 },
  { 1321, 98, 284.803406, 4.108056 },
  { 1321, 99, 162.004456, 3.567646 },
  { 1321, 100, 126.831680, 3.355884 },
  { 1321, 101, 95.939240, 3.129674 },
  { 1321, 102, 67.530418, 2.866651 },
  { 1321, 103, 56.099232, 2.736776 },
  { 1321, 104, 56.214531, 2.738181 },
  { 1321, 105, 47.108192, 2.619836 },
  { 1321, 106, 47.406765, 2.623977 },
  { 1321, 107, 49.165482, 2.647982 },
  { 1321, 108, 42.104206, 2.547307 },
  { 1321, 109, 33.916557, 2.413254 },
  { 1321, 110, 42.345341, 2.550947 },
  { 1321, 111, 44.577099, 2.583913 },
  { 1321, 112, 60.607521, 2.790176 },
  { 1321, 113, 28.666265, 2.313890 },
  { 1321, 114, 45.839863, 2.602021 },
  { 1321, 115, 43.567108, 2.569151 },
  { 1321, 116, 30.506647, 2.350166 },
  { 1321, 117, 41.469265, 2.537649 },
  { 1321, 118, 36.964195, 2.465729 },
  { 1322, 70, 40.713924, 2.526014 },
  { 1322, 71, 46.870159, 2.616520 },
  { 1322, 72, 41.065723, 2.531453 },
  { 1322, 73, 35.134808, 2.434638 },
  { 1322, 74, 32.571659, 2.388966 },
  { 1322, 75, 57.571022, 2.754552 },
  { 1322, 76, 40.506805, 2.522795 },
  { 1322, 77, 49.303577, 2.649840 },
  { 1322, 78, 35.597572, 2.442616 },
  { 1322, 79, 34.648731, 2.426173 },
  { 1322, 80, 21.396255, 2.150723 },
  { 1322, 81, 47.285160, 2.622293 },
  { 1322, 82, 36.595009, 2.459549 },
  { 1322, 83, 52.213184, 2.688098 },
  { 1322, 84, 50.173897, 2.661457 },
  { 1322, 85, 53.693409, 2.706950 },
  { 1322, 86, 44.273975, 2.579509 },
  { 1322, 87, 60.137196, 2.784747 },
  { 1322, 88, 85.881706, 3.044214 },
  { 1322, 89, 116.309654, 3.284006 },
  { 1322, 90, 194.210526, 3.733088 },
  { 1322, 91, 243.337021, 3.949590 },
  { 1322, 92, 372.374908, 4.392837 },
  { 1322, 93, 539.737427, 4.819984 },
  { 1322, 94, 478.572479, 4.677211 },
  { 1322, 95, 497.265381, 4.722229 },
  { 1322, 96, 386.061523, 4.432657 },
  { 1322, 97, 296.054779, 4.148041 },
  { 1322, 98, 220.587082, 3.853852 },
  { 1322, 99, 149.837952, 3.498690 },
  { 1322, 100, 78.451256, 2.976117 },
  { 1322, 101, 85.649185, 3.042151 },
  { 1322, 102, 61.429497, 2.799589 },
  { 1322, 103, 53.810368, 2.708423 },
  { 1322, 104, 55.910412, 2.734470 },
  { 1322, 105, 48.820446, 2.643324 },
  { 1322, 106, 42.192051, 2.548635 },
  { 1322, 107, 44.813988, 2.587339 },
  { 1322, 108, 43.068958, 2.561776 },
  { 1322, 109, 30.467865, 2.349419 },
  { 1322, 110, 32.823620, 2.393573 },
  { 1322, 111, 35.427898, 2.439700 },
  { 1322, 112, 36.473423, 2.457503 },
  { 1322, 113, 41.524849, 2.538499 },
  { 1322, 114, 40.220413, 2.518324 },
  { 1322, 115, 41.866589, 2.543706 },
  { 1322, 116, 33.468025, 2.405235 },
  { 1322, 117, 49.210266, 2.648585 },
  { 1322, 118, 30.066427, 2.341642 },
  { 1323, 70, 24.612495, 2.227352 },
  { 1323, 71, 38.318287, 2.488007 },
  { 1323, 72, 36.778889, 2.462633 },
  { 1323, 73, 50.148026, 2.661114 },
  { 1323, 74, 34.348953, 2.420908 },
  { 1323, 75, 44.023628, 2.575855 },
  { 1323, 76, 40.103645, 2.516495 },
  { 1323, 77, 37.438217, 2.473596 },
  { 1323, 78, 39.329067, 2.504254 },
  { 1323, 79, 47.996769, 2.632104 },
  { 1323, 80, 31.217438, 2.363738 },
  { 1323, 81, 39.908997, 2.513435 },
  { 1323, 82, 34.280766, 2.419706 },
  { 1323, 83, 46.836121, 2.616045 },
  { 1323, 84, 41.885639, 2.543995 },
  { 1323, 85, 43.880608, 2.573761 },
  { 1323, 86, 53.105530, 2.699510 },
  { 1323, 87, 60.865471, 2.793140 },
  { 1323, 88, 73.934029, 2.932318 },
  { 1323, 89, 101.118553, 3.171084 },
  { 1323, 90, 118.025284, 3.296050 },
  { 1323, 91, 191.282990, 3.718939 },
  { 1323, 92, 233.214127, 3.907857 },
  { 1323, 93, 311.963501, 4.202676 },
  { 1323, 94, 263.725189, 4.029841 },
  { 1323, 95, 325.135834, 4.246354 },
  { 1323, 96, 250.658936, 3.978971 },
  { 1323, 97, 204.481598, 3.781495 },
  { 1323, 98, 148.884872, 3.493113 },
  { 1323, 99, 94.004669, 3.113776 },
  { 1323, 100, 81.898933, 3.008289 },
  { 1323, 101, 86.942184, 3.053568 },
  { 1323, 102, 58.053204, 2.760302 },
  { 1323, 103, 56.263008, 2.738771 },
  { 1323, 104, 51.462025, 2.678377 },
  { 1323, 105, 37.620075, 2.476594 },
  { 1323, 106, 42.553524, 2.554076 },
  { 1323, 107, 44.323795, 2.580235 },
  { 1323, 108, 27.015347, 2.279831 },
  { 1323, 109, 39.442665, 2.506061 },
  { 1323, 110, 39.397884, 2.505349 },
  { 1323, 111, 30.177927, 2.343810 },
  { 1323, 112, 34.399044, 2.421791 },
  { 1323, 113, 37.308277, 2.471447 },
  { 1323, 114, 34.599560, 2.425312 },
  { 1323, 115, 38.367386, 2.488803 },
  { 1323, 116, 33.642754, 2.408368 },
  { 1323, 117, 24.496449, 2.224722 },
  { 1323, 118, 39.071480, 2.500144 },
  { 1324, 70, 36.985558, 2.466085 },
  { 1324, 71, 33.476131, 2.405381 },
  { 1324, 72, 41.552727, 2.538925 },
  { 1324, 73, 31.836418, 2.375369 },
  { 1324, 74, 47.897045, 2.630735 },
  { 1324, 75, 41.939781, 2.544817 },
  { 1324, 76, 33.248428, 2.401280 },
  { 1324, 77, 38.678429, 2.493832 },
  { 1324, 78, 29.430531, 2.329161 },
  { 1324, 79, 33.305965, 2.402318 },
  { 1324, 80, 41.891983, 2.544091 },
  { 1324, 81, 27.636444, 2.292823 },
  { 1324, 82, 44.829109, 2.587558 },
  { 1324, 83, 42.822170, 2.558098 },
  { 1324, 84, 44.091049, 2.576841 },
  { 1324, 85, 40.744167, 2.526483 },
  { 1324, 86, 45.055439, 2.590817 },
  { 1324, 87, 48.600677, 2.640344 },
  { 1324, 88, 67.113548, 2.862217 },
  { 1324, 89, 75.266632, 2.945443 },
  { 1324, 90, 107.815971, 3.222336 },
  { 1324, 91, 127.518402, 3.360417 },
  { 1324, 92, 148.516205, 3.490949 },
  { 1324, 93, 169.004150, 3.605573 },
  { 1324, 94, 167.615768, 3.598145 },
  { 1324, 95, 172.011276, 3.621506 },
  { 1324, 96, 134.767670, 3.407191 },
  { 1324, 97, 137.494034, 3.424293 },
  { 1324, 98, 94.810089, 3.120424 },
  { 1324, 99, 100.888237, 3.169276 },
  { 1324, 100, 84.526993, 3.032137 },
  { 1324, 101, 62.286457, 2.809302 },
  { 1324, 102, 50.412689, 2.664618 },
  { 1324, 103, 53.181641, 2.700477 },
  { 1324, 104, 45.846493, 2.602115 },
  { 1324, 105, 51.910248, 2.684190 },
  { 1324, 106, 47.339470, 2.623046 },
  { 1324, 107, 38.956200, 2.498297 },
  { 1324, 108, 44.129475, 2.577402 },
  { 1324, 109, 30.535536, 2.350723 },
  { 1324, 110, 31.523161, 2.369504 },
  { 1324, 111, 36.043785, 2.450234 },
  { 1324, 112, 43.500835, 2.568174 },
  { 1324, 113, 44.777313, 2.586810 },
  { 1324, 114, 36.952740, 2.465538 },
  { 1324, 115, 45.089565, 2.591308 },
  { 1324, 116, 31.619022, 2.371303 },
  { 1324, 117, 37.158474, 2.468962 },
  { 1324, 118, 34.101334, 2.416534 },
  { 1325, 70, 40.305241, 2.519651 },
  { 1325, 71, 39.007805, 2.499124 },
  { 1325, 72, 39.239868, 2.502833 },
  { 1325, 73, 46.419434, 2.610207 },
  { 1325, 74, 30.565264, 2.351295 },
  { 1325, 75, 42.710819, 2.556433 },
  { 1325, 76, 32.021759, 2.378819 },
  { 1325, 77, 37.485462, 2.474376 },
  { 1325, 78, 65.524773, 2.845125 },
  { 1325, 79, 35.354652, 2.438437 },
  { 1325, 80, 47.402393, 2.623917 },
  { 1325, 81, 28.263201, 2.305713 },
  { 1325, 82, 41.615135, 2.539878 },
  { 1325, 83, 40.897755, 2.528861 },
  { 1325, 84, 41.790188, 2.542545 },
  { 1325, 85, 48.502129, 2.639005 },
  { 1325, 86, 45.082031, 2.591200 },
  { 1325, 87, 49.458099, 2.651913 },
  { 1325, 88, 49.567646, 2.653381 },
  { 1325, 89, 61.811195, 2.803927 },
  { 1325, 90, 67.873528, 2.870286 },
  { 1325, 91, 80.909683, 2.999163 },
  { 1325, 92, 99.466812, 3.158054 },
  { 1325, 93, 129.894836, 3.375965 },
  { 1325, 94, 110.444466, 3.241798 },
  { 1325, 95, 105.166992, 3.202358 },
  { 1325, 96, 107.004906, 3.216258 },
  { 1325, 97, 97.135406, 3.139384 },
  { 1325, 98, 89.261787, 3.073735 },
  { 1325, 99, 73.098526, 2.923999 },
  { 1325, 100, 54.916946, 2.722241 },
  { 1325, 101, 59.911297, 2.782128 },
  { 1325, 102, 47.511303, 2.625423 },
  { 1325, 103, 52.953213, 2.697572 },
  { 1325, 104, 42.844383, 2.558430 },
  { 1325, 105, 43.972485, 2.575107 },
  { 1325, 106, 37.909027, 2.481336 },
  { 1325, 107, 47.958187, 2.631575 },
  { 1325, 108, 36.578880, 2.459278 },
  { 1325, 109, 52.571781, 2.692701 },
  { 1325, 110, 38.670490, 2.493704 },
  { 1325, 111, 40.130581, 2.516917 },
  { 1325, 112, 39.854980, 2.512584 },
  { 1325, 113, 43.164989, 2.563202 },
  { 1325, 114, 35.681599, 2.444056 },
  { 1325, 115, 43.126060, 2.562624 },
  { 1325, 116, 41.208321, 2.533648 },
  { 1325, 117, 42.265682, 2.549746 },
  { 1325, 118, 43.489773, 2.568010 },
  { 1326, 70, 35.351177, 2.438378 },
  { 1326, 71, 37.208172, 2.469787 },
  { 1326, 72, 29.856768, 2.337549 },
  { 1326, 73, 33.970699, 2.414216 },
  { 1326, 74, 27.972464, 2.299761 },
  { 1326, 75, 33.607487, 2.407737 },
  { 1326, 76, 47.225742, 2.621469 },
  { 1326, 77, 21.091242, 2.143017 },
  { 1326, 78, 33.910748, 2.413150 },
  { 1326, 79, 44.784969, 2.586920 },
  { 1326, 80, 50.346699, 2.663746 },
  { 1326, 81, 40.609795, 2.524397 },
  { 1326, 82, 44.062805, 2.576428 },
  { 1326, 83, 39.725758, 2.510545 },
  { 1326, 84, 42.614613, 2.554993 },
  { 1326, 85, 53.896492, 2.709506 },
  { 1326, 86, 46.665546, 2.613660 },
  { 1326, 87, 41.643906, 2.540317 },
  { 1326, 88, 35.863930, 2.447172 },
  { 1326, 89, 47.671181, 2.627629 },
  { 1326, 90, 61.777451, 2.803545 },
  { 1326, 91, 73.223701, 2.925250 },
  { 1326, 92, 73.945847, 2.932436 },
  { 1326, 93, 76.438972, 2.956846 },
  { 1326, 94, 90.202965, 3.081805 },
  { 1326, 95, 78.458061, 2.976181 },
  { 1326, 96, 92.086563, 3.097769 },
  { 1326, 97, 73.541893, 2.928422 },
  { 1326, 98, 74.726494, 2.940144 },
  { 1326, 99, 71.494164, 2.907821 },
  { 1326, 100, 56.450592, 2.741051 },
  { 1326, 101, 49.805717, 2.656561 },
  { 1326, 102, 45.184650, 2.592673 },
  { 1326, 103, 34.305382, 2.420141 },
  { 1326, 104, 29.233772, 2.325258 },
  { 1326, 105, 41.900749, 2.544225 },
  { 1326, 106, 39.004848, 2.499077 },
  { 1326, 107, 38.161938, 2.485465 },
  { 1326, 108, 42.695412, 2.556203 },
  { 1326, 109, 45.869507, 2.602442 },
  { 1326, 110, 44.037853, 2.576063 },
  { 1326, 111, 49.944172, 2.658405 },
  { 1326, 112, 41.473766, 2.537718 },
  { 1326, 113, 43.658936, 2.570504 },
  { 1326, 114, 41.168736, 2.533039 },
  { 1326, 115, 30.606701, 2.352091 },
  { 1326, 116, 44.538006, 2.583347 },
  { 1326, 117, 38.571003, 2.492099 },
  { 1326, 118, 38.378738, 2.488987 },
  { 1327, 70, 37.645782, 2.477018 },
  { 1327, 71, 42.455437, 2.552603 },
  { 1327, 72, 32.457935, 2.386878 },
  { 1327, 73, 45.235397, 2.593400 },
  { 1327, 74, 27.802052, 2.296250 },
  { 1327, 75, 38.881367, 2.497097 },
  { 1327, 76, 42.492435, 2.553159 },
  { 1327, 77, 42.694717, 2.556192 },
  { 1327, 78, 39.180904, 2.501892 },
  { 1327, 79, 35.549236, 2.441786 },
  { 1327, 80, 41.042091, 2.531089 },
  { 1327, 81, 37.098354, 2.467963 },
  { 1327, 82, 37.720654, 2.478248 },
  { 1327, 83, 35.573132, 2.442196 },
  { 1327, 84, 44.493626, 2.582703 },
  { 1327, 85, 46.838058, 2.616072 },
  { 1327, 86, 40.444763, 2.521829 },
  { 1327, 87, 44.320026, 2.580180 },
  { 1327, 88, 48.018505, 2.632402 },
  { 1327, 89, 44.209785, 2.578574 },
  { 1327, 90, 55.420475, 2.728460 },
  { 1327, 91, 43.302406, 2.565240 },
  { 1327, 92, 54.663651, 2.719097 },
  { 1327, 93, 60.052147, 2.783762 },
  { 1327, 94, 66.122391, 2.851590 },
  { 1327, 95, 58.207367, 2.762132 },
  { 1327, 96, 65.242218, 2.842053 },
  { 1327, 97, 64.195023, 2.830579 },
  { 1327, 98, 67.652855, 2.867950 },
  { 1327, 99, 51.578918, 2.679897 },
  { 1327, 100, 40.109482, 2.516586 },
  { 1327, 101, 56.582951, 2.742656 },
  { 1327, 102, 46.948257, 2.617610 },
  { 1327, 103, 37.694698, 2.477822 },
  { 1327, 104, 42.169025, 2.548287 },
  { 1327, 105, 41.557495, 2.538998 },
  { 1327, 106, 42.707172, 2.556379 },
  { 1327, 107, 36.453289, 2.457164 },
  { 1327, 108, 39.160461, 2.501566 },
  { 1327, 109, 31.320593, 2.365688 },
  { 1327, 110, 37.668995, 2.477399 },
  { 1327, 111, 33.912792, 2.413187 },
  { 1327, 112, 39.820969, 2.512048 },
  { 1327, 113, 48.889572, 2.644259 },
  { 1327, 114, 34.531517, 2.424119 },
  { 1327, 115, 36.667809, 2.460771 },
  { 1327, 116, 42.341339, 2.550887 },
  { 1327, 117, 37.830215, 2.480046 },
  { 1327, 118, 32.423244, 2.386240 },
  { 1328, 70, 29.164501, 2.323880 },
  { 1328, 71, 50.590034, 2.666958 },
  { 1328, 72, 25.420813, 2.245419 },
  { 1328, 73, 32.330048, 2.384523 },
  { 1328, 74, 41.485485, 2.537897 },
  { 1328, 75, 27.794113, 2.296086 },
  { 1328, 76, 36.176449, 2.452486 },
  { 1328, 77, 49.675259, 2.654820 },
  { 1328, 78, 44.558208, 2.583640 },
  { 1328, 79, 36.293419, 2.454466 },
  { 1328, 80, 41.660706, 2.540573 },
  { 1328, 81, 51.727940, 2.681830 },
  { 1328, 82, 39.890923, 2.513151 },
  { 1328, 83, 46.670139, 2.613724 },
  { 1328, 84, 36.802372, 2.463026 },
  { 1328, 85, 48.159534, 2.634332 },
  { 1328, 86, 40.067039, 2.515920 },
  { 1328, 87, 35.526482, 2.441395 },
  { 1328, 88, 46.636330, 2.613251 },
  { 1328, 89, 51.757652, 2.682215 },
  { 1328, 90, 53.930077, 2.709928 },
  { 1328, 91, 44.140484, 2.577563 },
  { 1328, 92, 47.776569, 2.629080 },
  { 1328, 93, 49.236935, 2.648944 },
  { 1328, 94, 50.073177, 2.660120 },
  { 1328, 95, 54.217670, 2.713534 },
  { 1328, 96, 56.924889, 2.746791 },
  { 1328, 97, 50.649185, 2.667738 },
  { 1328, 98, 54.954117, 2.722702 },
  { 1328, 99, 49.372547, 2.650766 },
  { 1328, 100, 44.332626, 2.580363 },
  { 1328, 101, 38.486523, 2.490733 },
  { 1328, 102, 53.197140, 2.700673 },
  { 1328, 103, 35.945099, 2.448555 },
  { 1328, 104, 44.782509, 2.586885 },
  { 1328, 105, 27.972582, 2.299763 },
  { 1328, 106, 46.566895, 2.612278 },
  { 1328, 107, 41.333931, 2.535576 },
  { 1328, 108, 34.533936, 2.424161 },
  { 1328, 109, 44.938713, 2.589138 },
  { 1328, 110, 40.905933, 2.528987 },
  { 1328, 111, 40.603004, 2.524292 },
  { 1328, 112, 41.217834, 2.533794 },
  { 1328, 113, 40.515141, 2.522925 },
  { 1328, 114, 29.638357, 2.333262 },
  { 1328, 115, 29.848324, 2.337384 },
  { 1328, 116, 43.494549, 2.568081 },
  { 1328, 117, 29.645237, 2.333398 },
  { 1328, 118, 52.417358, 2.690722 },
  { 1329, 70, 39.871429, 2.512844 },
  { 1329, 71, 30.642134, 2.352772 },
  { 1329, 72, 42.972019, 2.560333 },
  { 1329, 73, 42.110748, 2.547406 },
  { 1329, 74, 35.191605, 2.435621 },
  { 1329, 75, 36.508137, 2.458088 },
  { 1329, 76, 40.296005, 2.519506 },
  { 1329, 77, 37.809280, 2.479703 },
  { 1329, 78, 38.647968, 2.493341 },
  { 1329, 79, 35.033466, 2.432881 },
  { 1329, 80, 43.817974, 2.572842 },
  { 1329, 81, 35.867958, 2.447241 },
  { 1329, 82, 35.582359, 2.442354 },
  { 1329, 83, 42.338318, 2.550841 },
  { 1329, 84, 33.920322, 2.413321 },
  { 1329, 85, 48.530731, 2.639394 },
  { 1329, 86, 34.239079, 2.418970 },
  { 1329, 87, 45.184853, 2.592676 },
  { 1329, 88, 48.143127, 2.634108 },
  { 1329, 89, 50.808044, 2.669827 },
  { 1329, 90, 48.318928, 2.636509 },
  { 1329, 91, 39.626114, 2.508970 },
  { 1329, 92, 53.790234, 2.708170 },
  { 1329, 93, 44.665386, 2.585192 },
  { 1329, 94, 50.624168, 2.667408 },
  { 1329, 95, 33.305981, 2.402318 },
  { 1329, 96, 45.638947, 2.599165 },
  { 1329, 97, 49.391270, 2.651017 },
  { 1329, 98, 46.693913, 2.614057 },
  { 1329, 99, 45.183693, 2.592659 },
  { 1329, 100, 43.577141, 2.569299 },
  { 1329, 101, 47.903721, 2.630827 },
  { 1329, 102, 36.055500, 2.450433 },
  { 1329, 103, 29.284475, 2.326266 },
  { 1329, 104, 56.000340, 2.735569 },
  { 1329, 105, 32.800720, 2.393155 },
  { 1329, 106, 47.213799, 2.621303 },
  { 1329, 107, 37.612900, 2.476476 },
  { 1329, 108, 40.733631, 2.526320 },
  { 1329, 109, 43.096481, 2.562185 },
  { 1329, 110, 33.908272, 2.413106 },
  { 1329, 111, 42.416447, 2.552017 },
  { 1329, 112, 37.629681, 2.476753 },
  { 1329, 113, 26.226019, 2.262992 },
  { 1329, 114, 33.779762, 2.410816 },
  { 1329, 115, 30.835728, 2.356479 },
  { 1329, 116, 32.238525, 2.382834 },
  { 1329, 117, 34.025417, 2.415188 },
  { 1329, 118, 42.454098, 2.552583 },
  { 1330, 70, 35.559776, 2.441967 },
  { 1330, 71, 36.822113, 2.463356 },
  { 1330, 72, 39.943649, 2.513981 },
  { 1330, 73, 41.317123, 2.535318 },
  { 1330, 74, 32.709229, 2.391484 },
  { 1330, 75, 38.048550, 2.483616 },
  { 1330, 76, 41.814941, 2.542921 },
  { 1330, 77, 27.012228, 2.279765 },
  { 1330, 78, 46.005619, 2.604370 },
  { 1330, 79, 45.948326, 2.603559 },
  { 1330, 80, 40.551006, 2.523483 },
  { 1330, 81, 26.341900, 2.265488 },
  { 1330, 82, 37.707680, 2.478035 },
  { 1330, 83, 48.561935, 2.639818 },
  { 1330, 84, 35.632828, 2.443220 },
  { 1330, 85, 33.431194, 2.404573 },
  { 1330, 86, 43.102093, 2.562268 },
  { 1330, 87, 35.313271, 2.437724 },
  { 1330, 88, 35.685055, 2.444115 },
  { 1330, 89, 39.833733, 2.512249 },
  { 1330, 90, 44.759102, 2.586547 },
  { 1330, 91, 40.337894, 2.520161 },
  { 1330, 92, 50.859707, 2.670505 },
  { 1330, 93, 52.196213, 2.687879 },
  { 1330, 94, 51.837502, 2.683249 },
  { 1330, 95, 46.259380, 2.607954 },
  { 1330, 96, 34.982723, 2.431999 },
  { 1330, 97, 38.517296, 2.491231 },
  { 1330, 98, 37.924904, 2.481596 },
  { 1330, 99, 40.759407, 2.526719 },
  { 1330, 100, 34.889946, 2.430385 },
  { 1330, 101, 50.268829, 2.662715 },
  { 1330, 102, 42.305332, 2.550344 },
  { 1330, 103, 37.804420, 2.479623 },
  { 1330, 104, 42.037983, 2.546305 },
  { 1330, 105, 46.825676, 2.615899 },
  { 1330, 106, 40.711781, 2.525981 },
  { 1330, 107, 42.780964, 2.557482 },
  { 1330, 108, 43.806236, 2.572670 },
  { 1330, 109, 39.506630, 2.507076 },
  { 1330, 110, 28.900547, 2.318604 },
  { 1330, 111, 45.779686, 2.601167 },
  { 1330, 112, 33.068371, 2.398022 },
  { 1330, 113, 41.570156, 2.539191 },
  { 1330, 114, 35.537685, 2.441587 },
  { 1330, 115, 38.766895, 2.495257 },
  { 1330, 116, 40.915424, 2.529134 },
  { 1330, 117, 41.984287, 2.545492 },
  { 1330, 118, 48.584660, 2.640127 },
  { 1331, 70, 32.992481, 2.396645 },
  { 1331, 71, 37.383522, 2.472692 },
  { 1331, 72, 40.273956, 2.519162 },
  { 1331, 73, 36.291840, 2.454439 },
  { 1331, 74, 49.151981, 2.647800 },
  { 1331, 75, 35.326290, 2.437948 },
  { 1331, 76, 34.306652, 2.420163 },
  { 1331, 77, 33.169212, 2.399848 },
  { 1331, 78, 28.971189, 2.320019 },
  { 1331, 79, 38.954380, 2.498268 },
  { 1331, 80, 48.319050, 2.636511 },
  { 1331, 81, 31.143547, 2.362338 },
  { 1331, 82, 21.381512, 2.150352 },
  { 1331, 83, 32.400082, 2.385814 },
  { 1331, 84, 42.915691, 2.559494 },
  { 1331, 85, 46.037830, 2.604826 },
  { 1331, 86, 41.254623, 2.534359 },
  { 1331, 87, 44.390709, 2.581208 },
  { 1331, 88, 46.937920, 2.617465 },
  { 1331, 89, 46.546593, 2.611993 },
  { 1331, 90, 40.961807, 2.529850 },
  { 1331, 91, 36.768353, 2.462456 },
  { 1331, 92, 45.955173, 2.603656 },
  { 1331, 93, 43.313580, 2.565406 },
  { 1331, 94, 33.707130, 2.409519 },
  { 1331, 95, 38.434574, 2.489892 },
  { 1331, 96, 40.426235, 2.521540 },
  { 1331, 97, 37.712948, 2.478122 },
  { 1331, 98, 27.770504, 2.295599 },
  { 1331, 99, 30.769537, 2.355213 },
  { 1331, 100, 35.446362, 2.440017 },
  { 1331, 101, 49.397232, 2.651097 },
  { 1331, 102, 46.957081, 2.617733 },
  { 1331, 103, 27.796082, 2.296127 },
  { 1331, 104, 40.277164, 2.519212 },
  { 1331, 105, 29.375942, 2.328080 },
  { 1331, 106, 39.157143, 2.501513 },
  { 1331, 107, 35.636017, 2.443275 },
  { 1331, 108, 39.067539, 2.500081 },
  { 1331, 109, 37.322136, 2.471677 },
  { 1331, 110, 34.610767, 2.425508 },
  { 1331, 111, 35.719452, 2.444704 },
  { 1331, 112, 29.887272, 2.338146 },
  { 1331, 113, 41.353577, 2.535877 },
  { 1331, 114, 42.621662, 2.555098 },
  { 1331, 115, 49.203274, 2.648491 },
  { 1331, 116, 41.540813, 2.538743 },
  { 1331, 117, 38.860126, 2.496756 },
  { 1331, 118, 37.011742, 2.466522 },
  { 1332, 70, 34.687412, 2.426850 },
  { 1332, 71, 34.377304, 2.421408 },
  { 1332, 72, 38.230736, 2.486584 },
  { 1332, 73, 52.609264, 2.693181 },
  { 1332, 74, 40.185974, 2.517785 },
  { 1332, 75, 38.912216, 2.497592 },
  { 1332, 76, 35.773418, 2.445626 },
  { 1332, 77, 39.797642, 2.511680 },
  { 1332, 78, 41.542709, 2.538772 },
  { 1332, 79, 35.250107, 2.436633 },
  { 1332, 80, 32.819389, 2.393496 },
  { 1332, 81, 51.608692, 2.680283 },
  { 1332, 82, 44.279205, 2.579586 },
  { 1332, 83, 33.612370, 2.407824 },
  { 1332, 84, 39.937492, 2.513884 },
  { 1332, 85, 29.773273, 2.335913 },
  { 1332, 86, 46.150917, 2.606424 },
  { 1332, 87, 29.276484, 2.326107 },
  { 1332, 88, 37.692886, 2.477792 },
  { 1332, 89, 48.697762, 2.641662 },
  { 1332, 90, 42.004536, 2.545799 },
  { 1332, 91, 35.842098, 2.446799 },
  { 1332, 92, 35.429295, 2.439724 },
  { 1332, 93, 47.311901, 2.622664 },
  { 1332, 94, 29.099108, 2.322576 },
  { 1332, 95, 44.661739, 2.585139 },
  { 1332, 96, 35.307682, 2.437627 },
  { 1332, 97, 51.851753, 2.683434 },
  { 1332, 98, 47.006378, 2.618419 },
  { 1332, 99, 42.658920, 2.555656 },
  { 1332, 100, 42.394283, 2.551684 },
  { 1332, 101, 43.304451, 2.565270 },
  { 1332, 102, 32.978374, 2.396389 },
  { 1332, 103, 33.735516, 2.410027 },
  { 1332, 104, 29.793282, 2.336305 },
  { 1332, 105, 32.306168, 2.384083 },
  { 1332, 106, 40.666512, 2.525278 },
  { 1332, 107, 36.302258, 2.454615 },
  { 1332, 108, 52.708603, 2.694452 },
  { 1332, 109, 37.176483, 2.469261 },
  { 1332, 110, 43.676918, 2.570769 },
  { 1332, 111, 34.256603, 2.419280 },
  { 1332, 112, 39.627213, 2.508987 },
  { 1332, 113, 41.129799, 2.532440 },
  { 1332, 114, 42.820911, 2.558079 },
  { 1332, 115, 34.168678, 2.417726 },
  { 1332, 116, 33.166206, 2.399794 },
  { 1332, 117, 38.109859, 2.484616 },
  { 1332, 118, 45.530987, 2.597627 },
  { 1333, 70, 24.717323, 2.229720 },
  { 1333, 71, 53.956036, 2.710254 },
  { 1333, 72, 37.849567, 2.480363 },
  { 1333, 73, 43.397385, 2.566646 },
  { 1333, 74, 42.218063, 2.549028 },
  { 1333, 75, 34.028057, 2.415234 },
  { 1333, 76, 30.103720, 2.342368 },
  { 1333, 77, 34.885468, 2.430307 },
  { 1333, 78, 31.384195, 2.366888 },
  { 1333, 79, 50.330856, 2.663536 },
  { 1333, 80, 34.391861, 2.421664 },
  { 1333, 81, 35.835266, 2.446683 },
  { 1333, 82, 41.660641, 2.540572 },
  { 1333, 83, 47.461674, 2.624737 },
  { 1333, 84, 38.732796, 2.494708 },
  { 1333, 85, 29.790693, 2.336255 },
  { 1333, 86, 41.669769, 2.540711 },
  { 1333, 87, 50.198219, 2.661779 },
  { 1333, 88, 32.641304, 2.390242 },
  { 1333, 89, 36.616337, 2.459907 },
  { 1333, 90, 41.708443, 2.541300 },
  { 1333, 91, 43.230946, 2.564181 },
  { 1333, 92, 35.853756, 2.446998 },
  { 1333, 93, 36.713982, 2.461545 },
  { 1333, 94, 37.240044, 2.470316 },
  { 1333, 95, 33.949867, 2.413846 },
  { 1333, 96, 32.712437, 2.391543 },
  { 1333, 97, 30.520741, 2.350438 },
  { 1333, 98, 39.765530, 2.511173 },
  { 1333, 99, 40.524818, 2.523076 },
  { 1333, 100, 38.902069, 2.497429 },
  { 1333, 101, 43.850777, 2.573323 },
  { 1333, 102, 36.613083, 2.459853 },
  { 1333, 103, 39.893539, 2.513192 },
  { 1333, 104, 34.575848, 2.424896 },
  { 1333, 105, 34.066788, 2.415921 },
  { 1333, 106, 38.895466, 2.497323 },
  { 1333, 107, 45.118183, 2.591719 },
  { 1333, 108, 33.251198, 2.401330 },
  { 1333, 109, 37.509396, 2.474771 },
  { 1333, 110, 39.700054, 2.510139 },
  { 1333, 111, 53.794415, 2.708222 },
  { 1333, 112, 25.021669, 2.236552 },
  { 1333, 113, 42.786762, 2.557569 },
  { 1333, 114, 45.160412, 2.592325 },
  { 1333, 115, 34.792801, 2.428691 },
  { 1333, 116, 44.640720, 2.584835 },
  { 1333, 117, 34.217228, 2.418584 },
  { 1333, 118, 36.398533, 2.456241 },
  { 1334, 70, 39.533154, 2.507497 },
  { 1334, 71, 38.194897, 2.486001 },
  { 1334, 72, 48.656490, 2.641102 },
  { 1334, 73, 45.106003, 2.591544 },
  { 1334, 74, 32.101315, 2.380295 },
  { 1334, 75, 41.953339, 2.545022 },
  { 1334, 76, 31.928947, 2.377093 },
  { 1334, 77, 34.877934, 2.430176 },
  { 1334, 78, 35.815388, 2.446343 },
  { 1334, 79, 38.071671, 2.483994 },
  { 1334, 80, 44.331470, 2.580347 },
  { 1334, 81, 32.800449, 2.393150 },
  { 1334, 82, 45.838860, 2.602007 },
  { 1334, 83, 34.741798, 2.427801 },
  { 1334, 84, 39.160301, 2.501563 },
  { 1334, 85, 37.882050, 2.480895 },
  { 1334, 86, 32.576508, 2.389055 },
  { 1334, 87, 30.999565, 2.359603 },
  { 1334, 88, 46.004650, 2.604357 },
  { 1334, 89, 27.298334, 2.285778 },
  { 1334, 90, 42.471321, 2.552842 },
  { 1334, 91, 38.335571, 2.488287 },
  { 1334, 92, 46.220234, 2.607402 },
  { 1334, 93, 38.865990, 2.496850 },
  { 1334, 94, 35.250969, 2.436648 },
  { 1334, 95, 39.000240, 2.499003 },
  { 1334, 96, 34.259533, 2.419331 },
  { 1334, 97, 41.742798, 2.541823 },
  { 1334, 98, 50.448807, 2.665095 },
  { 1334, 99, 50.267597, 2.662699 },
  { 1334, 100, 37.991463, 2.482684 },
  { 1334, 101, 35.617748, 2.442961 },
  { 1334, 102, 39.136681, 2.501186 },
  { 1334, 103, 33.864532, 2.412328 },
  { 1334, 104, 29.134745, 2.323287 },
  { 1334, 105, 35.721046, 2.444731 },
  { 1334, 106, 30.415308, 2.348405 },
  { 1334, 107, 35.125183, 2.434471 },
  { 1334, 108, 42.150700, 2.548010 },
  { 1334, 109, 32.822247, 2.393548 },
  { 1334, 110, 40.090717, 2.516292 },
  { 1334, 111, 42.353199, 2.551065 },
  { 1334, 112, 50.049492, 2.659806 },
  { 1334, 113, 41.675209, 2.540794 },
  { 1334, 114, 39.578934, 2.508222 },
  { 1334, 115, 37.705250, 2.477995 },
  { 1334, 116, 35.803715, 2.446144 },
  { 1334, 117, 43.867802, 2.573573 },
  { 1334, 118, 36.496307, 2.457889 },
  { 1335, 70, 46.116039, 2.605932 },
  { 1335, 71, 37.739986, 2.478566 },
  { 1335, 72, 34.349819, 2.420924 },
  { 1335, 73, 24.473181, 2.224194 },
  { 1335, 74, 52.423805, 2.690804 },
  { 1335, 75, 45.182476, 2.592642 },
  { 1335, 76, 41.719536, 2.541469 },
  { 1335, 77, 38.612541, 2.492769 },
  { 1335, 78, 43.024738, 2.561118 },
  { 1335, 79, 39.049210, 2.499787 },
  { 1335, 80, 34.459175, 2.422848 },
  { 1335, 81, 40.792236, 2.527228 },
  { 1335, 82, 44.280064, 2.579598 },
  { 1335, 83, 43.894390, 2.573963 },
  { 1335, 84, 37.591469, 2.476124 },
  { 1335, 85, 35.557941, 2.441935 },
  { 1335, 86, 42.910301, 2.559413 },
  { 1335, 87, 30.003971, 2.340425 },
  { 1335, 88, 38.716396, 2.494444 },
  { 1335, 89, 32.793674, 2.393027 },
  { 1335, 90, 41.630238, 2.540108 },
  { 1335, 91, 39.777775, 2.511367 },
  { 1335, 92, 44.994709, 2.589944 },
  { 1335, 93, 46.923042, 2.617258 },
  { 1335, 94, 42.226521, 2.549155 },
  { 1335, 95, 45.487740, 2.597010 },
  { 1335, 96, 42.099361, 2.547234 },
  { 1335, 97, 38.228188, 2.486543 },
  { 1335, 98, 34.873158, 2.430093 },
  { 1335, 99, 45.911770, 2.603041 },
  { 1335, 100, 43.697369, 2.571069 },
  { 1335, 101, 47.092419, 2.619617 },
  { 1335, 102, 34.574005, 2.424864 },
  { 1335, 103, 34.933968, 2.431151 },
  { 1335, 104, 27.172518, 2.283140 },
  { 1335, 105, 40.350903, 2.520364 },
  { 1335, 106, 40.162174, 2.517412 },
  { 1335, 107, 40.163845, 2.517438 },
  { 1335, 108, 29.562233, 2.331763 },
  { 1335, 109, 35.637012, 2.443292 },
  { 1335, 110, 47.078430, 2.619422 },
  { 1335, 111, 32.046295, 2.379274 },
  { 1335, 112, 40.480778, 2.522390 },
  { 1335, 113, 37.999332, 2.482813 },
  { 1335, 114, 35.935116, 2.448385 },
  { 1335, 115, 42.208504, 2.548883 },
  { 1335, 116, 36.240402, 2.453569 },
  { 1335, 117, 31.410223, 2.367379 },
  { 1335, 118, 39.732014, 2.510644 },
  { 1336, 70, 34.571037, 2.424812 },
  { 1336, 71, 47.592403, 2.626542 },
  { 1336, 72, 37.981979, 2.482529 },
  { 1336, 73, 33.624748, 2.408046 },
  { 1336, 74, 36.096188, 2.451124 },
  { 1336, 75, 33.416752, 2.404313 },
  { 1336, 76, 48.106182, 2.633602 },
  { 1336, 77, 37.489578, 2.474444 },
  { 1336, 78, 39.065182, 2.500043 },
  { 1336, 79, 32.913437, 2.395208 },
  { 1336, 80, 37.777016, 2.479173 },
  { 1336, 81, 48.855778, 2.643802 },
  { 1336, 82, 34.676506, 2.426660 },
  { 1336, 83, 33.840134, 2.411893 },
  { 1336, 84, 43.997280, 2.575470 },
  { 1336, 85, 31.911570, 2.376769 },
  { 1336, 86, 38.953804, 2.498259 },
  { 1336, 87, 39.063339, 2.500013 },
  { 1336, 88, 34.384277, 2.421531 },
  { 1336, 89, 46.340248, 2.609093 },
  { 1336, 90, 51.388363, 2.677418 },
  { 1336, 91, 39.728184, 2.510583 },
  { 1336, 92, 39.826077, 2.512129 },
  { 1336, 93, 40.155746, 2.517311 },
  { 1336, 94, 36.234146, 2.453463 },
  { 1336, 95, 45.559898, 2.598039 },
  { 1336, 96, 40.411930, 2.521317 },
  { 1336, 97, 47.136856, 2.620234 },
  { 1336, 98, 50.413853, 2.664634 },
  { 1336, 99, 50.890480, 2.670909 },
  { 1336, 100, 40.721470, 2.526131 },
  { 1336, 101, 50.985374, 2.672153 },
  { 1336, 102, 43.225838, 2.564105 },
  { 1336, 103, 43.040215, 2.561348 },
  { 1336, 104, 45.493923, 2.597098 },
  { 1336, 105, 39.136280, 2.501180 },
  { 1336, 106, 44.850163, 2.587861 },
  { 1336, 107, 31.138655, 2.362245 },
  { 1336, 108, 47.562798, 2.626134 },
  { 1336, 109, 30.282068, 2.345829 },
  { 1336, 110, 43.067059, 2.561747 },
  { 1336, 111, 23.495739, 2.201645 },
  { 1336, 112, 35.828129, 2.446561 },
  { 1336, 113, 36.647411, 2.460429 },
  { 1336, 114, 41.276875, 2.534701 },
  { 1336, 115, 34.385567, 2.421553 },
  { 1336, 116, 38.786972, 2.495580 },
  { 1336, 117, 39.134304, 2.501148 },
  { 1336, 118, 41.311157, 2.535227 },
  { 1337, 70, 34.782394, 2.428510 },
  { 1337, 71, 38.161804, 2.485463 },
  { 1337, 72, 41.151970, 2.532781 },
  { 1337, 73, 40.675331, 2.525415 },
  { 1337, 74, 39.839149, 2.512335 },
  { 1337, 75, 42.334541, 2.550784 },
  { 1337, 76, 24.914124, 2.234145 },
  { 1337, 77, 48.276310, 2.635928 },
  { 1337, 78, 45.179733, 2.592602 },
  { 1337, 79, 23.109350, 2.192537 },
  { 1337, 80, 32.055347, 2.379442 },
  { 1337, 81, 37.881191, 2.480881 },
  { 1337, 82, 40.373268, 2.520713 },
  { 1337, 83, 45.207092, 2.592995 },
  { 1337, 84, 44.027565, 2.575913 },
  { 1337, 85, 45.271854, 2.593923 },
  { 1337, 86, 36.987999, 2.466126 },
  { 1337, 87, 30.400118, 2.348112 },
  { 1337, 88, 43.517544, 2.568420 },
  { 1337, 89, 38.157433, 2.485391 },
  { 1337, 90, 37.274426, 2.470886 },
  { 1337, 91, 43.277973, 2.564878 },
  { 1337, 92, 32.283440, 2.383664 },
  { 1337, 93, 46.786335, 2.615350 },
  { 1337, 94, 37.174671, 2.469231 },
  { 1337, 95, 41.258835, 2.534424 },
  { 1337, 96, 44.631233, 2.584697 },
  { 1337, 97, 37.918209, 2.481487 },
  { 1337, 98, 41.093079, 2.531874 },
  { 1337, 99, 38.771786, 2.495336 },
  { 1337, 100, 39.961098, 2.514255 },
  { 1337, 101, 48.703682, 2.641742 },
  { 1337, 102, 29.666958, 2.333825 },
  { 1337, 103, 41.345551, 2.535754 },
  { 1337, 104, 43.749313, 2.571833 },
  { 1337, 105, 33.240025, 2.401128 },
  { 1337, 106, 33.890484, 2.412790 },
  { 1337, 107, 31.381960, 2.366846 },
  { 1337, 108, 36.212708, 2.453100 },
  { 1337, 109, 32.659611, 2.390577 },
  { 1337, 110, 41.941521, 2.544843 },
  { 1337, 111, 31.213572, 2.363665 },
  { 1337, 112, 42.259178, 2.549648 },
  { 1337, 113, 35.825523, 2.446517 },
  { 1337, 114, 35.839001, 2.446747 },
  { 1337, 115, 37.445869, 2.473722 },
  { 1337, 116, 30.825100, 2.356276 },
  { 1337, 117, 36.212807, 2.453102 },
  { 1337, 118, 38.117317, 2.484738 },
  { 1338, 70, 16.738237, 2.022681 },
  { 1338, 71, 31.507816, 2.369215 },
  { 1338, 72, 28.160873, 2.303624 },
  { 1338, 73, 34.551266, 2.424465 },
  { 1338, 74, 41.966148, 2.545217 },
  { 1338, 75, 26.735138, 2.273896 },
  { 1338, 76, 36.964367, 2.465732 },
  { 1338, 77, 39.931427, 2.513788 },
  { 1338, 78, 31.193521, 2.363285 },
  { 1338, 79, 28.318222, 2.306835 },
  { 1338, 80, 28.732315, 2.315222 },
  { 1338, 81, 40.617439, 2.524516 },
  { 1338, 82, 28.343294, 2.307345 },
  { 1338, 83, 40.089970, 2.516280 },
  { 1338, 84, 30.417566, 2.348449 },
  { 1338, 85, 31.113384, 2.361766 },
  { 1338, 86, 44.701649, 2.585716 },
  { 1338, 87, 38.484360, 2.490698 },
  { 1338, 88, 49.296295, 2.649742 },
  { 1338, 89, 35.089394, 2.433851 },
  { 1338, 90, 41.364220, 2.536041 },
  { 1338, 91, 34.283237, 2.419750 },
  { 1338, 92, 43.911789, 2.574218 },
  { 1338, 93, 38.852650, 2.496636 },
  { 1338, 94, 46.463482, 2.610826 },
  { 1338, 95, 29.802732, 2.336491 },
  { 1338, 96, 38.620693, 2.492901 },
  { 1338, 97, 35.353973, 2.438426 },
  { 1338, 98, 34.909264, 2.430721 },
  { 1338, 99, 33.227829, 2.400908 },
  { 1338, 100, 50.421207, 2.664731 },
  { 1338, 101, 38.975101, 2.498600 },
  { 1338, 102, 34.277035, 2.419640 },
  { 1338, 103, 35.897617, 2.447746 },
  { 1338, 104, 45.378582, 2.595450 },
  { 1338, 105, 36.659115, 2.460625 },
  { 1338, 106, 30.290993, 2.346002 },
  { 1338, 107, 39.480011, 2.506654 },
  { 1338, 108, 35.049030, 2.433151 },
  { 1338, 109, 49.386707, 2.650956 },
  { 1338, 110, 38.508053, 2.491081 },
  { 1338, 111, 21.785412, 2.160436 },
  { 1338, 112, 30.925474, 2.358191 },
  { 1338, 113, 32.566544, 2.388872 },
  { 1338, 114, 33.977325, 2.414334 },
  { 1338, 115, 32.948326, 2.395843 },
  { 1338, 116, 34.575104, 2.424883 },
  { 1338, 117, 34.331520, 2.420601 },
  { 1338, 118, 35.863617, 2.447166 },
  { 1339, 70, 44.933502, 2.589063 },
  { 1339, 71, 27.140104, 2.282459 },
  { 1339, 72, 33.167446, 2.399816 },
  { 1339, 73, 50.945381, 2.671629 },
  { 1339, 74, 40.019257, 2.515169 },
  { 1339, 75, 31.353540, 2.366310 },
  { 1339, 76, 36.720158, 2.461649 },
  { 1339, 77, 42.758492, 2.557146 },
  { 1339, 78, 40.404572, 2.521202 },
  { 1339, 79, 37.663761, 2.477313 },
  { 1339, 80, 41.333176, 2.535565 },
  { 1339, 81, 42.059185, 2.546626 },
  { 1339, 82, 48.375992, 2.637287 },
  { 1339, 83, 37.534317, 2.475182 },
  { 1339, 84, 44.465309, 2.582292 },
  { 1339, 85, 33.659061, 2.408660 },
  { 1339, 86, 27.661734, 2.293347 },
  { 1339, 87, 36.988785, 2.466139 },
  { 1339, 88, 37.580265, 2.475939 },
  { 1339, 89, 31.229685, 2.363970 },
  { 1339, 90, 38.163460, 2.485490 },
  { 1339, 91, 43.208336, 2.563846 },
  { 1339, 92, 39.354801, 2.504664 },
  { 1339, 93, 32.364552, 2.385159 },
  { 1339, 94, 40.043018, 2.515543 },
  { 1339, 95, 43.599487, 2.569628 },
  { 1339, 96, 31.587358, 2.370709 },
  { 1339, 97, 29.460014, 2.329744 },
  { 1339, 98, 42.383839, 2.551527 },
  { 1339, 99, 40.923458, 2.529258 },
  { 1339, 100, 41.723328, 2.541527 },
  { 1339, 101, 41.919312, 2.544506 },
  { 1339, 102, 25.206312, 2.240667 },
  { 1339, 103, 36.008011, 2.449626 },
  { 1339, 104, 32.975323, 2.396333 },
  { 1339, 105, 35.197994, 2.435732 },
  { 1339, 106, 32.061089, 2.379549 },
  { 1339, 107, 38.113537, 2.484676 },
  { 1339, 108, 44.118362, 2.577240 },
  { 1339, 109, 36.868565, 2.464133 },
  { 1339, 110, 46.798141, 2.615515 },
  { 1339, 111, 44.024895, 2.575874 },
  { 1339, 112, 40.893684, 2.528798 },
  { 1339, 113, 39.616337, 2.508815 },
  { 1339, 114, 35.157768, 2.435036 },
  { 1339, 115, 48.133797, 2.633980 },
  { 1339, 116, 41.623817, 2.540010 },
  { 1339, 117, 31.458115, 2.368281 },
  { 1339, 118, 52.085121, 2.686448 },
  { 1340, 70, 43.038406, 2.561321 },
  { 1340, 71, 37.027386, 2.466782 },
  { 1340, 72, 29.100229, 2.322598 },
  { 1340, 73, 27.354197, 2.286947 },
  { 1340, 74, 36.898335, 2.464630 },
  { 1340, 75, 33.982235, 2.414421 },
  { 1340, 76, 43.725288, 2.571480 },
  { 1340, 77, 35.513268, 2.441168 },
  { 1340, 78, 44.190868, 2.578298 },
  { 1340, 79, 36.382122, 2.455964 },
  { 1340, 80, 46.480232, 2.611061 },
  { 1340, 81, 25.568390, 2.248671 },
  { 1340, 82, 36.741905, 2.462013 },
  { 1340, 83, 30.415527, 2.348410 },
  { 1340, 84, 41.816212, 2.542940 },
  { 1340, 85, 25.445526, 2.245964 },
  { 1340, 86, 29.946430, 2.339302 },
  { 1340, 87, 38.713787, 2.494402 },
  { 1340, 88, 37.407280, 2.473085 },
  { 1340, 89, 50.952312, 2.671720 },
  { 1340, 90, 30.072113, 2.341753 },
  { 1340, 91, 34.084419, 2.416234 },
  { 1340, 92, 24.156628, 2.216966 },
  { 1340, 93, 48.489857, 2.638838 },
  { 1340, 94, 33.890759, 2.412794 },
  { 1340, 95, 30.343159, 2.347011 },
  { 1340, 96, 56.934589, 2.746907 },
  { 1340, 97, 29.447199, 2.329491 },
  { 1340, 98, 53.027733, 2.698521 },
  { 1340, 99, 24.670881, 2.228672 },
  { 1340, 100, 45.533661, 2.597665 },
  { 1340, 101, 26.992914, 2.279357 },
  { 1340, 102, 35.577457, 2.442270 },
  { 1340, 103, 29.615417, 2.332810 },
  { 1340, 104, 41.300541, 2.535064 },
  { 1340, 105, 45.100079, 2.591459 },
  { 1340, 106, 39.262714, 2.503197 },
  { 1340, 107, 47.007782, 2.618439 },
  { 1340, 108, 40.811985, 2.527534 },
  { 1340, 109, 39.925632, 2.513697 },
  { 1340, 110, 27.072931, 2.281045 },
  { 1340, 111, 37.122311, 2.468361 },
  { 1340, 112, 27.833942, 2.296908 },
  { 1340, 113, 31.754303, 2.373836 },
  { 1340, 114, 23.913960, 2.211377 },
  { 1340, 115, 39.970005, 2.514395 },
  { 1340, 116, 31.376558, 2.366744 },
  { 1340, 117, 34.780281, 2.428473 },
  { 1340, 118, 31.970194, 2.377860 },
  { 1341, 70, 46.263943, 2.608018 },
  { 1341, 71, 46.138409, 2.606247 },
  { 1341, 72, 35.370457, 2.438710 },
  { 1341, 73, 31.732550, 2.373429 },
  { 1341, 74, 32.431343, 2.386389 },
  { 1341, 75, 33.707775, 2.409531 },
  { 1341, 76, 32.487804, 2.387427 },
  { 1341, 77, 30.846518, 2.356685 },
  { 1341, 78, 44.616207, 2.584480 },
  { 1341, 79, 36.728378, 2.461787 },
  { 1341, 80, 45.482368, 2.596933 },
  { 1341, 81, 46.974415, 2.617974 },
  { 1341, 82, 43.265656, 2.564696 },
  { 1341, 83, 41.822216, 2.543032 },
  { 1341, 84, 40.138790, 2.517045 },
  { 1341, 85, 24.091637, 2.215474 },
  { 1341, 86, 37.812580, 2.479757 },
  { 1341, 87, 45.899826, 2.602872 },
  { 1341, 88, 37.535931, 2.475209 },
  { 1341, 89, 38.625641, 2.492981 },
  { 1341, 90, 37.611923, 2.476460 },
  { 1341, 91, 27.990499, 2.300132 },
  { 1341, 92, 39.483490, 2.506709 },
  { 1341, 93, 36.046154, 2.450274 },
  { 1341, 94, 42.373215, 2.551367 },
  { 1341, 95, 36.682125, 2.461011 },
  { 1341, 96, 38.263241, 2.487113 },
  { 1341, 97, 52.227585, 2.688283 },
  { 1341, 98, 30.577929, 2.351538 },
  { 1341, 99, 46.261154, 2.607979 },
  { 1341, 100, 43.224483, 2.564085 },
  { 1341, 101, 44.799335, 2.587128 },
  { 1341, 102, 36.406780, 2.456380 },
  { 1341, 103, 39.470806, 2.506507 },
  { 1341, 104, 39.438816, 2.505999 },
  { 1341, 105, 32.410969, 2.386014 },
  { 1341, 106, 39.043385, 2.499694 },
  { 1341, 107, 48.302078, 2.636280 },
  { 1341, 108, 35.452225, 2.440118 },
  { 1341, 109, 40.348919, 2.520333 },
  { 1341, 110, 42.947544, 2.559968 },
  { 1341, 111, 32.392105, 2.385667 },
  { 1341, 112, 51.980694, 2.685100 },
  { 1341, 113, 37.356907, 2.472252 },
  { 1341, 114, 33.384609, 2.403735 },
  { 1341, 115, 35.160477, 2.435082 },
  { 1341, 116, 33.008930, 2.396944 },
  { 1341, 117, 35.500233, 2.440944 },
  { 1341, 118, 37.301037, 2.471327 },
  { 1342, 70, 47.031002, 2.618762 },
  { 1342, 71, 32.942242, 2.395732 },
  { 1342, 72, 35.710316, 2.444547 },
  { 1342, 73, 32.730274, 2.391869 },
  { 1342, 74, 30.194668, 2.344135 },
  { 1342, 75, 28.308392, 2.306635 },
  { 1342, 76, 27.730639, 2.294774 },
  { 1342, 77, 42.147411, 2.547961 },
  { 1342, 78, 43.914455, 2.574257 },
  { 1342, 79, 44.842915, 2.587757 },
  { 1342, 80, 38.690853, 2.494032 },
  { 1342, 81, 46.956299, 2.617722 },
  { 1342, 82, 38.069920, 2.483965 },
  { 1342, 83, 35.829414, 2.446583 },
  { 1342, 84, 40.607845, 2.524367 },
  { 1342, 85, 32.136776, 2.380952 },
  { 1342, 86, 43.932224, 2.574517 },
  { 1342, 87, 35.891830, 2.447648 },
  { 1342, 88, 36.865070, 2.464074 },
  { 1342, 89, 33.024281, 2.397223 },
  { 1342, 90, 31.078167, 2.361097 },
  { 1342, 91, 31.538584, 2.369794 },
  { 1342, 92, 28.432913, 2.309167 },
  { 1342, 93, 35.737591, 2.445014 },
  { 1342, 94, 32.102226, 2.380311 },
  { 1342, 95, 38.839680, 2.496427 },
  { 1342, 96, 49.367561, 2.650699 },
  { 1342, 97, 36.550201, 2.458796 },
  { 1342, 98, 31.985100, 2.378137 },
  { 1342, 99, 37.964565, 2.482245 },
  { 1342, 100, 40.436481, 2.521700 },
  { 1342, 101, 27.879950, 2.297857 },
  { 1342, 102, 27.775995, 2.295712 },
  { 1342, 103, 48.199867, 2.634884 },
  { 1342, 104, 28.355299, 2.307590 },
  { 1342, 105, 29.674543, 2.333974 },
  { 1342, 106, 38.747650, 2.494947 },
  { 1342, 107, 33.385658, 2.403754 },
  { 1342, 108, 24.882774, 2.233442 },
  { 1342, 109, 37.501602, 2.474643 },
  { 1342, 110, 30.841513, 2.356589 },
  { 1342, 111, 51.271519, 2.675895 },
  { 1342, 112, 36.942139, 2.465361 },
  { 1342, 113, 36.247574, 2.453690 },
  { 1342, 114, 37.985836, 2.482592 },
  { 1342, 115, 28.466957, 2.309858 },
  { 1342, 116, 42.242298, 2.549393 },
  { 1342, 117, 35.175911, 2.435350 },
  { 1342, 118, 50.541698, 2.666321 },
  { 0., 0., 0., 0. }
};

const float kStar7[][4] = {
  { 297, 912, 33.171963, 2.399898 },
  { 297, 913, 45.432400, 2.596220 },
  { 297, 914, 25.584415, 2.249023 },
  { 297, 915, 36.816174, 2.463257 },
  { 297, 916, 42.935513, 2.559789 },
  { 297, 917, 52.843433, 2.696173 },
  { 297, 918, 48.145065, 2.634135 },
  { 297, 919, 34.409893, 2.421982 },
  { 297, 920, 41.873516, 2.543811 },
  { 297, 921, 32.885586, 2.394701 },
  { 297, 922, 40.800068, 2.527349 },
  { 297, 923, 38.589783, 2.492402 },
  { 297, 924, 46.695938, 2.614085 },
  { 297, 925, 47.106468, 2.619812 },
  { 297, 926, 33.357361, 2.403244 },
  { 297, 927, 30.609747, 2.352149 },
  { 297, 928, 38.577755, 2.492208 },
  { 297, 929, 36.691734, 2.461173 },
  { 297, 930, 41.386032, 2.536375 },
  { 297, 931, 32.484673, 2.387369 },
  { 297, 932, 52.360943, 2.689997 },
  { 297, 933, 38.389076, 2.489155 },
  { 297, 934, 46.733311, 2.614608 },
  { 297, 935, 31.275558, 2.364837 },
  { 297, 936, 38.497986, 2.490918 },
  { 297, 937, 36.944378, 2.465398 },
  { 297, 938, 34.159031, 2.417555 },
  { 297, 939, 37.483189, 2.474339 },
  { 297, 940, 36.672356, 2.460847 },
  { 297, 941, 34.836037, 2.429446 },
  { 297, 942, 33.145538, 2.399420 },
  { 298, 912, 28.124050, 2.302870 },
  { 298, 913, 36.391003, 2.456114 },
  { 298, 914, 31.537889, 2.369781 },
  { 298, 915, 39.267807, 2.503278 },
  { 298, 916, 30.940369, 2.358475 },
  { 298, 917, 43.635723, 2.570162 },
  { 298, 918, 40.563274, 2.523674 },
  { 298, 919, 48.565369, 2.639865 },
  { 298, 920, 36.602085, 2.459668 },
  { 298, 921, 31.286848, 2.365051 },
  { 298, 922, 39.617783, 2.508837 },
  { 298, 923, 44.841362, 2.587734 },
  { 298, 924, 37.630230, 2.476762 },
  { 298, 925, 39.152821, 2.501444 },
  { 298, 926, 31.865191, 2.375905 },
  { 298, 927, 41.705257, 2.541252 },
  { 298, 928, 31.918144, 2.376892 },
  { 298, 929, 49.501831, 2.652499 },
  { 298, 930, 32.771461, 2.392621 },
  { 298, 931, 48.207554, 2.634989 },
  { 298, 932, 45.977375, 2.603971 },
  { 298, 933, 31.848278, 2.375590 },
  { 298, 934, 38.283360, 2.487439 },
  { 298, 935, 40.225716, 2.518407 },
  { 298, 936, 38.533924, 2.491500 },
  { 298, 937, 40.069431, 2.515957 },
  { 298, 938, 42.258472, 2.549638 },
  { 298, 939, 30.113733, 2.342562 },
  { 298, 940, 37.366463, 2.472410 },
  { 298, 941, 33.955452, 2.413945 },
  { 298, 942, 36.015137, 2.449747 },
  { 299, 912, 30.310999, 2.346389 },
  { 299, 913, 26.403139, 2.266804 },
  { 299, 914, 37.978252, 2.482468 },
  { 299, 915, 41.076099, 2.531613 },
  { 299, 916, 30.684063, 2.353576 },
  { 299, 917, 46.583843, 2.612515 },
  { 299, 918, 41.011517, 2.530617 },
  { 299, 919, 24.958494, 2.235139 },
  { 299, 920, 39.903263, 2.513345 },
  { 299, 921, 36.549110, 2.458777 },
  { 299, 922, 39.375977, 2.505001 },
  { 299, 923, 42.492199, 2.553156 },
  { 299, 924, 29.824390, 2.336915 },
  { 299, 925, 37.299297, 2.471298 },
  { 299, 926, 36.817410, 2.463277 },
  { 299, 927, 31.518028, 2.369407 },
  { 299, 928, 32.671684, 2.390798 },
  { 299, 929, 43.277477, 2.564871 },
  { 299, 930, 41.272831, 2.534639 },
  { 299, 931, 37.852924, 2.480418 },
  { 299, 932, 41.292046, 2.534934 },
  { 299, 933, 48.181259, 2.634629 },
  { 299, 934, 38.885372, 2.497161 },
  { 299, 935, 29.386539, 2.328290 },
  { 299, 936, 40.485138, 2.522458 },
  { 299, 937, 32.369118, 2.385243 },
  { 299, 938, 43.532814, 2.568645 },
  { 299, 939, 41.082985, 2.531719 },
  { 299, 940, 44.483059, 2.582550 },
  { 299, 941, 23.976280, 2.212817 },
  { 299, 942, 33.961090, 2.414045 },
  { 300, 912, 38.304607, 2.487784 },
  { 300, 913, 43.605488, 2.569717 },
  { 300, 914, 39.008308, 2.499132 },
  { 300, 915, 27.328074, 2.286400 },
  { 300, 916, 30.232023, 2.344859 },
  { 300, 917, 39.648003, 2.509316 },
  { 300, 918, 42.207840, 2.548873 },
  { 300, 919, 53.375645, 2.702936 },
  { 300, 920, 34.637486, 2.425977 },
  { 300, 921, 45.474712, 2.596824 },
  { 300, 922, 47.621750, 2.626947 },
  { 300, 923, 43.374538, 2.566308 },
  { 300, 924, 39.034023, 2.499544 },
  { 300, 925, 40.306885, 2.519677 },
  { 300, 926, 44.714306, 2.585899 },
  { 300, 927, 38.248268, 2.486869 },
  { 300, 928, 30.929682, 2.358272 },
  { 300, 929, 32.787453, 2.392913 },
  { 300, 930, 32.827682, 2.393647 },
  { 300, 931, 50.716167, 2.668619 },
  { 300, 932, 50.504902, 2.665836 },
  { 300, 933, 30.841135, 2.356582 },
  { 300, 934, 27.279030, 2.285374 },
  { 300, 935, 29.906723, 2.338526 },
  { 300, 936, 31.226818, 2.363915 },
  { 300, 937, 29.150051, 2.323592 },
  { 300, 938, 33.414062, 2.404265 },
  { 300, 939, 40.021717, 2.515208 },
  { 300, 940, 42.723530, 2.556623 },
  { 300, 941, 32.004696, 2.378501 },
  { 300, 942, 30.770546, 2.355232 },
  { 301, 912, 39.681206, 2.509841 },
  { 301, 913, 46.544933, 2.611969 },
  { 301, 914, 45.054295, 2.590801 },
  { 301, 915, 37.301510, 2.471335 },
  { 301, 916, 34.674469, 2.426624 },
  { 301, 917, 37.970451, 2.482341 },
  { 301, 918, 32.870216, 2.394422 },
  { 301, 919, 36.900646, 2.464668 },
  { 301, 920, 36.987820, 2.466123 },
  { 301, 921, 38.703716, 2.494240 },
  { 301, 922, 34.792072, 2.428679 },
  { 301, 923, 30.013773, 2.340616 },
  { 301, 924, 37.969681, 2.482328 },
  { 301, 925, 46.426682, 2.610309 },
  { 301, 926, 48.224495, 2.635220 },
  { 301, 927, 47.174759, 2.620761 },
  { 301, 928, 42.982048, 2.560482 },
  { 301, 929, 36.542652, 2.458669 },
  { 301, 930, 40.211189, 2.518180 },
  { 301, 931, 37.533062, 2.475161 },
  { 301, 932, 41.673504, 2.540768 },
  { 301, 933, 30.831699, 2.356402 },
  { 301, 934, 44.247425, 2.579123 },
  { 301, 935, 31.103292, 2.361574 },
  { 301, 936, 45.841335, 2.602042 },
  { 301, 937, 28.290249, 2.306265 },
  { 301, 938, 50.162621, 2.661308 },
  { 301, 939, 36.122589, 2.451572 },
  { 301, 940, 28.119520, 2.302778 },
  { 301, 941, 48.089329, 2.633372 },
  { 301, 942, 28.572752, 2.312001 },
  { 302, 912, 34.537247, 2.424219 },
  { 302, 913, 44.128223, 2.577384 },
  { 302, 914, 31.476254, 2.368622 },
  { 302, 915, 40.835045, 2.527890 },
  { 302, 916, 37.445259, 2.473712 },
  { 302, 917, 38.499996, 2.490951 },
  { 302, 918, 36.957184, 2.465612 },
  { 302, 919, 31.278902, 2.364901 },
  { 302, 920, 31.398676, 2.367161 },
  { 302, 921, 25.999090, 2.258081 },
  { 302, 922, 46.669151, 2.613710 },
  { 302, 923, 42.864021, 2.558723 },
  { 302, 924, 39.398781, 2.505363 },
  { 302, 925, 30.390574, 2.347928 },
  { 302, 926, 52.471428, 2.691415 },
  { 302, 927, 37.500103, 2.474618 },
  { 302, 928, 38.390568, 2.489179 },
  { 302, 929, 35.242943, 2.436509 },
  { 302, 930, 45.102539, 2.591494 },
  { 302, 931, 37.595367, 2.476188 },
  { 302, 932, 32.174675, 2.381653 },
  { 302, 933, 42.896332, 2.559205 },
  { 302, 934, 47.019272, 2.618599 },
  { 302, 935, 39.936367, 2.513866 },
  { 302, 936, 40.656078, 2.525116 },
  { 302, 937, 32.359261, 2.385062 },
  { 302, 938, 44.269764, 2.579448 },
  { 302, 939, 32.667904, 2.390729 },
  { 302, 940, 32.936275, 2.395624 },
  { 302, 941, 39.912453, 2.513490 },
  { 302, 942, 41.420074, 2.536896 },
  { 303, 912, 44.345974, 2.580558 },
  { 303, 913, 35.054482, 2.433245 },
  { 303, 914, 43.201145, 2.563739 },
  { 303, 915, 37.641098, 2.476941 },
  { 303, 916, 36.641556, 2.460331 },
  { 303, 917, 32.344398, 2.384788 },
  { 303, 918, 35.556175, 2.441905 },
  { 303, 919, 40.329250, 2.520026 },
  { 303, 920, 49.444458, 2.651731 },
  { 303, 921, 48.389141, 2.637467 },
  { 303, 922, 48.919338, 2.644662 },
  { 303, 923, 37.549187, 2.475427 },
  { 303, 924, 41.612980, 2.539845 },
  { 303, 925, 44.517849, 2.583054 },
  { 303, 926, 37.393974, 2.472865 },
  { 303, 927, 41.230385, 2.533987 },
  { 303, 928, 51.491299, 2.678758 },
  { 303, 929, 44.935112, 2.589086 },
  { 303, 930, 36.694145, 2.461213 },
  { 303, 931, 35.435104, 2.439824 },
  { 303, 932, 34.991238, 2.432147 },
  { 303, 933, 53.175438, 2.700398 },
  { 303, 934, 54.856472, 2.721491 },
  { 303, 935, 51.433846, 2.678010 },
  { 303, 936, 40.914024, 2.529112 },
  { 303, 937, 35.504814, 2.441023 },
  { 303, 938, 35.055939, 2.433270 },
  { 303, 939, 45.018726, 2.590289 },
  { 303, 940, 29.274231, 2.326062 },
  { 303, 941, 42.599266, 2.554762 },
  { 303, 942, 34.685028, 2.426809 },
  { 304, 912, 37.947041, 2.481958 },
  { 304, 913, 46.180748, 2.606845 },
  { 304, 914, 41.818150, 2.542970 },
  { 304, 915, 43.853401, 2.573362 },
  { 304, 916, 45.038807, 2.590578 },
  { 304, 917, 36.020264, 2.449834 },
  { 304, 918, 35.750523, 2.445235 },
  { 304, 919, 34.611130, 2.425515 },
  { 304, 920, 39.168995, 2.501702 },
  { 304, 921, 36.182186, 2.452583 },
  { 304, 922, 45.860176, 2.602309 },
  { 304, 923, 42.747620, 2.556984 },
  { 304, 924, 47.633118, 2.627104 },
  { 304, 925, 45.523418, 2.597519 },
  { 304, 926, 48.280296, 2.635982 },
  { 304, 927, 49.867462, 2.657384 },
  { 304, 928, 38.963371, 2.498412 },
  { 304, 929, 48.141243, 2.634082 },
  { 304, 930, 54.268536, 2.714170 },
  { 304, 931, 34.122864, 2.416915 },
  { 304, 932, 48.460865, 2.638443 },
  { 304, 933, 46.792675, 2.615438 },
  { 304, 934, 35.497841, 2.440903 },
  { 304, 935, 42.554352, 2.554089 },
  { 304, 936, 37.129395, 2.468479 },
  { 304, 937, 33.768433, 2.410614 },
  { 304, 938, 45.974884, 2.603935 },
  { 304, 939, 40.874031, 2.528494 },
  { 304, 940, 24.165857, 2.217178 },
  { 304, 941, 35.001083, 2.432318 },
  { 304, 942, 41.505421, 2.538202 },
  { 305, 912, 38.144310, 2.485178 },
  { 305, 913, 38.433475, 2.489874 },
  { 305, 914, 40.224609, 2.518390 },
  { 305, 915, 29.115490, 2.322903 },
  { 305, 916, 31.438654, 2.367914 },
  { 305, 917, 41.988205, 2.545551 },
  { 305, 918, 29.249895, 2.325579 },
  { 305, 919, 37.403278, 2.473019 },
  { 305, 920, 51.458641, 2.678333 },
  { 305, 921, 35.382538, 2.438918 },
  { 305, 922, 44.103313, 2.577020 },
  { 305, 923, 40.112885, 2.516639 },
  { 305, 924, 49.951756, 2.658506 },
  { 305, 925, 55.595814, 2.730615 },
  { 305, 926, 56.067917, 2.736394 },
  { 305, 927, 42.674305, 2.555887 },
  { 305, 928, 55.046352, 2.723843 },
  { 305, 929, 59.201057, 2.773846 },
  { 305, 930, 56.595425, 2.742808 },
  { 305, 931, 42.668846, 2.555805 },
  { 305, 932, 60.101902, 2.784339 },
  { 305, 933, 47.095825, 2.619664 },
  { 305, 934, 42.099125, 2.547231 },
  { 305, 935, 49.246761, 2.649076 },
  { 305, 936, 46.493271, 2.611244 },
  { 305, 937, 31.940535, 2.377308 },
  { 305, 938, 52.686405, 2.694168 },
  { 305, 939, 29.887228, 2.338145 },
  { 305, 940, 42.308384, 2.550390 },
  { 305, 941, 32.706440, 2.391433 },
  { 305, 942, 38.993774, 2.498900 },
  { 306, 912, 34.118324, 2.416835 },
  { 306, 913, 32.945076, 2.395784 },
  { 306, 914, 23.540882, 2.202702 },
  { 306, 915, 31.583191, 2.370631 },
  { 306, 916, 35.977238, 2.449102 },
  { 306, 917, 45.356743, 2.595138 },
  { 306, 918, 40.781918, 2.527068 },
  { 306, 919, 41.923973, 2.544577 },
  { 306, 920, 32.907864, 2.395107 },
  { 306, 921, 46.965611, 2.617851 },
  { 306, 922, 44.916668, 2.588820 },
  { 306, 923, 46.686687, 2.613956 },
  { 306, 924, 64.293282, 2.831662 },
  { 306, 925, 52.796307, 2.695572 },
  { 306, 926, 57.587852, 2.754753 },
  { 306, 927, 63.275547, 2.820389 },
  { 306, 928, 63.805508, 2.826276 },
  { 306, 929, 68.749596, 2.879503 },
  { 306, 930, 79.030739, 2.981597 },
  { 306, 931, 54.383038, 2.715600 },
  { 306, 932, 55.029930, 2.723640 },
  { 306, 933, 59.244335, 2.774353 },
  { 306, 934, 39.136425, 2.501182 },
  { 306, 935, 42.400814, 2.551782 },
  { 306, 936, 46.271614, 2.608127 },
  { 306, 937, 37.286045, 2.471079 },
  { 306, 938, 34.897095, 2.430510 },
  { 306, 939, 52.998474, 2.698148 },
  { 306, 940, 43.530300, 2.568609 },
  { 306, 941, 43.009438, 2.560890 },
  { 306, 942, 32.532822, 2.388253 },
  { 307, 912, 41.319805, 2.535360 },
  { 307, 913, 35.335487, 2.438107 },
  { 307, 914, 38.594837, 2.492484 },
  { 307, 915, 42.045219, 2.546415 },
  { 307, 916, 38.326622, 2.488142 },
  { 307, 917, 39.892475, 2.513175 },
  { 307, 918, 47.731098, 2.628454 },
  { 307, 919, 45.020729, 2.590318 },
  { 307, 920, 49.496140, 2.652423 },
  { 307, 921, 56.574371, 2.742552 },
  { 307, 922, 60.864315, 2.793127 },
  { 307, 923, 71.922295, 2.912164 },
  { 307, 924, 59.714458, 2.779840 },
  { 307, 925, 66.927696, 2.860233 },
  { 307, 926, 84.406761, 3.031058 },
  { 307, 927, 80.921417, 2.999272 },
  { 307, 928, 87.897247, 3.061920 },
  { 307, 929, 92.666161, 3.102632 },
  { 307, 930, 83.636467, 3.024119 },
  { 307, 931, 69.441154, 2.886717 },
  { 307, 932, 70.004700, 2.892556 },
  { 307, 933, 54.144741, 2.712621 },
  { 307, 934, 42.818089, 2.558037 },
  { 307, 935, 36.965916, 2.465758 },
  { 307, 936, 46.046482, 2.604948 },
  { 307, 937, 42.029758, 2.546181 },
  { 307, 938, 51.769855, 2.682373 },
  { 307, 939, 48.015396, 2.632359 },
  { 307, 940, 28.930145, 2.319197 },
  { 307, 941, 43.498386, 2.568138 },
  { 307, 942, 30.430180, 2.348692 },
  { 308, 912, 46.154469, 2.606474 },
  { 308, 913, 53.360172, 2.702740 },
  { 308, 914, 41.349186, 2.535810 },
  { 308, 915, 30.237799, 2.344971 },
  { 308, 916, 35.646126, 2.443448 },
  { 308, 917, 39.367634, 2.504868 },
  { 308, 918, 35.040668, 2.433006 },
  { 308, 919, 37.362122, 2.472338 },
  { 308, 920, 42.122540, 2.547585 },
  { 308, 921, 53.925220, 2.709867 },
  { 308, 922, 64.112648, 2.829671 },
  { 308, 923, 51.173161, 2.674611 },
  { 308, 924, 77.342606, 2.965546 },
  { 308, 925, 86.881065, 3.053031 },
  { 308, 926, 125.452522, 3.346724 },
  { 308, 927, 121.219460, 3.318128 },
  { 308, 928, 145.677948, 3.474149 },
  { 308, 929, 118.170891, 3.297066 },
  { 308, 930, 101.025894, 3.170357 },
  { 308, 931, 96.939636, 3.137801 },
  { 308, 932, 79.874825, 2.989527 },
  { 308, 933, 63.064087, 2.818029 },
  { 308, 934, 62.840744, 2.815531 },
  { 308, 935, 50.602287, 2.667120 },
  { 308, 936, 26.612961, 2.271294 },
  { 308, 937, 39.436680, 2.505965 },
  { 308, 938, 37.097694, 2.467952 },
  { 308, 939, 45.558491, 2.598019 },
  { 308, 940, 44.530697, 2.583241 },
  { 308, 941, 42.776176, 2.557411 },
  { 308, 942, 40.776428, 2.526983 },
  { 309, 912, 41.868206, 2.543730 },
  { 309, 913, 39.857651, 2.512626 },
  { 309, 914, 47.992672, 2.632048 },
  { 309, 915, 35.076149, 2.433621 },
  { 309, 916, 36.238182, 2.453531 },
  { 309, 917, 47.058167, 2.619140 },
  { 309, 918, 39.967300, 2.514353 },
  { 309, 919, 37.324764, 2.471720 },
  { 309, 920, 50.718418, 2.668649 },
  { 309, 921, 55.124214, 2.724806 },
  { 309, 922, 67.670250, 2.868134 },
  { 309, 923, 74.230507, 2.935254 },
  { 309, 924, 118.042702, 3.296171 },
  { 309, 925, 127.680618, 3.361485 },
  { 309, 926, 188.700699, 3.706324 },
  { 309, 927, 210.713104, 3.809982 },
  { 309, 928, 217.554413, 3.840537 },
  { 309, 929, 202.084045, 3.770362 },
  { 309, 930, 136.950745, 3.420906 },
  { 309, 931, 113.896263, 3.266836 },
  { 309, 932, 102.826996, 3.184394 },
  { 309, 933, 64.837593, 2.837636 },
  { 309, 934, 57.880939, 2.758252 },
  { 309, 935, 56.932831, 2.746886 },
  { 309, 936, 46.368805, 2.609495 },
  { 309, 937, 40.582314, 2.523970 },
  { 309, 938, 42.284428, 2.550029 },
  { 309, 939, 40.142895, 2.517110 },
  { 309, 940, 43.330650, 2.565658 },
  { 309, 941, 36.123936, 2.451595 },
  { 309, 942, 36.133839, 2.451763 },
  { 310, 912, 42.805977, 2.557856 },
  { 310, 913, 29.915268, 2.338693 },
  { 310, 914, 36.027897, 2.449964 },
  { 310, 915, 31.293560, 2.365178 },
  { 310, 916, 36.359127, 2.455576 },
  { 310, 917, 45.746365, 2.600693 },
  { 310, 918, 41.807968, 2.542815 },
  { 310, 919, 46.273571, 2.608154 },
  { 310, 920, 54.151302, 2.712703 },
  { 310, 921, 57.056240, 2.748374 },
  { 310, 922, 77.867516, 2.970565 },
  { 310, 923, 108.144127, 3.224785 },
  { 310, 924, 158.021469, 3.545512 },
  { 310, 925, 213.178024, 3.821075 },
  { 310, 926, 309.368530, 4.193909 },
  { 310, 927, 356.395020, 4.344931 },
  { 310, 928, 371.144653, 4.389205 },
  { 310, 929, 335.202728, 4.278848 },
  { 310, 930, 237.740585, 3.926683 },
  { 310, 931, 183.837875, 3.682212 },
  { 310, 932, 125.329605, 3.345903 },
  { 310, 933, 82.972649, 3.018101 },
  { 310, 934, 64.741959, 2.836589 },
  { 310, 935, 63.189037, 2.819424 },
  { 310, 936, 54.442268, 2.716340 },
  { 310, 937, 36.027023, 2.449949 },
  { 310, 938, 42.442486, 2.552409 },
  { 310, 939, 45.374340, 2.595390 },
  { 310, 940, 40.304024, 2.519632 },
  { 310, 941, 40.611122, 2.524418 },
  { 310, 942, 41.173809, 2.533117 },
  { 311, 912, 36.130539, 2.451707 },
  { 311, 913, 32.243324, 2.382923 },
  { 311, 914, 24.110401, 2.215905 },
  { 311, 915, 41.080170, 2.531676 },
  { 311, 916, 41.193447, 2.533419 },
  { 311, 917, 30.962894, 2.358905 },
  { 311, 918, 50.654663, 2.667810 },
  { 311, 919, 40.192219, 2.517883 },
  { 311, 920, 60.829861, 2.792732 },
  { 311, 921, 62.927532, 2.816503 },
  { 311, 922, 91.082100, 3.089287 },
  { 311, 923, 128.406509, 3.366253 },
  { 311, 924, 176.516495, 3.644990 },
  { 311, 925, 277.212494, 4.080404 },
  { 311, 926, 425.783875, 4.542525 },
  { 311, 927, 579.013794, 4.905375 },
  { 311, 928, 603.361511, 4.956150 },
  { 311, 929, 523.734436, 4.783853 },
  { 311, 930, 386.431000, 4.433717 },
  { 311, 931, 232.588989, 3.905236 },
  { 311, 932, 140.659592, 3.443835 },
  { 311, 933, 110.121414, 3.239425 },
  { 311, 934, 85.685135, 3.042470 },
  { 311, 935, 61.739517, 2.803114 },
  { 311, 936, 58.052979, 2.760299 },
  { 311, 937, 49.468506, 2.652053 },
  { 311, 938, 36.156055, 2.452140 },
  { 311, 939, 43.754009, 2.571902 },
  { 311, 940, 38.696018, 2.494116 },
  { 311, 941, 44.998772, 2.590002 },
  { 311, 942, 46.313309, 2.608714 },
  { 312, 912, 28.535200, 2.311241 },
  { 312, 913, 37.194889, 2.469567 },
  { 312, 914, 43.188576, 2.563553 },
  { 312, 915, 43.368252, 2.566215 },
  { 312, 916, 37.744495, 2.478640 },
  { 312, 917, 42.803589, 2.557820 },
  { 312, 918, 43.404995, 2.566758 },
  { 312, 919, 52.933514, 2.697321 },
  { 312, 920, 52.135437, 2.687096 },
  { 312, 921, 62.961811, 2.816886 },
  { 312, 922, 86.917732, 3.053354 },
  { 312, 923, 139.371124, 3.435921 },
  { 312, 924, 246.005066, 3.960372 },
  { 312, 925, 371.798676, 4.391137 },
  { 312, 926, 569.596680, 4.885307 },
  { 312, 927, 768.351257, 5.264898 },
  { 312, 928, 755.705261, 5.243100 },
  { 312, 929, 665.096924, 5.078334 },
  { 312, 930, 476.167725, 4.671324 },
  { 312, 931, 281.207458, 4.095026 },
  { 312, 932, 161.066711, 3.562472 },
  { 312, 933, 130.995026, 3.383091 },
  { 312, 934, 72.355766, 2.916542 },
  { 312, 935, 68.415489, 2.875998 },
  { 312, 936, 54.578701, 2.718040 },
  { 312, 937, 44.874840, 2.588217 },
  { 312, 938, 45.305481, 2.594404 },
  { 312, 939, 34.685989, 2.426825 },
  { 312, 940, 47.568623, 2.626214 },
  { 312, 941, 30.719400, 2.354253 },
  { 312, 942, 42.286083, 2.550054 },
  { 313, 912, 46.053566, 2.605048 },
  { 313, 913, 38.114223, 2.484688 },
  { 313, 914, 40.754448, 2.526642 },
  { 313, 915, 41.621372, 2.539973 },
  { 313, 916, 39.408421, 2.505517 },
  { 313, 917, 49.769310, 2.656075 },
  { 313, 918, 42.682079, 2.556003 },
  { 313, 919, 48.053169, 2.632877 },
  { 313, 920, 44.226311, 2.578815 },
  { 313, 921, 73.190025, 2.924913 },
  { 313, 922, 88.720413, 3.069064 },
  { 313, 923, 153.764435, 3.521389 },
  { 313, 924, 262.563812, 4.025397 },
  { 313, 925, 446.577332, 4.596996 },
  { 313, 926, 665.207581, 5.078545 },
  { 313, 927, 749.717346, 5.232683 },
  { 313, 928, 808.467224, 5.332313 },
  { 313, 929, 704.154907, 5.151302 },
  { 313, 930, 441.075226, 4.582771 },
  { 313, 931, 275.558716, 4.074305 },
  { 313, 932, 184.734451, 3.686693 },
  { 313, 933, 122.406700, 3.326222 },
  { 313, 934, 91.488510, 3.092727 },
  { 313, 935, 67.867157, 2.870218 },
  { 313, 936, 57.278744, 2.751049 },
  { 313, 937, 50.936104, 2.671508 },
  { 313, 938, 45.820629, 2.601748 },
  { 313, 939, 46.753662, 2.614893 },
  { 313, 940, 45.071404, 2.591047 },
  { 313, 941, 35.113605, 2.434271 },
  { 313, 942, 35.676624, 2.443970 },
  { 314, 912, 43.358826, 2.566075 },
  { 314, 913, 37.076530, 2.467600 },
  { 314, 914, 32.983818, 2.396488 },
  { 314, 915, 31.601768, 2.370980 },
  { 314, 916, 38.906849, 2.497506 },
  { 314, 917, 46.917770, 2.617184 },
  { 314, 918, 44.607151, 2.584349 },
  { 314, 919, 49.495438, 2.652414 },
  { 314, 920, 64.598694, 2.835019 },
  { 314, 921, 74.194847, 2.934901 },
  { 314, 922, 105.097000, 3.201825 },
  { 314, 923, 159.095612, 3.551522 },
  { 314, 924, 269.626984, 4.052200 },
  { 314, 925, 418.237274, 4.522262 },
  { 314, 926, 565.294373, 4.876056 },
  { 314, 927, 715.700073, 5.172289 },
  { 314, 928, 710.141602, 5.162217 },
  { 314, 929, 539.007568, 4.818354 },
  { 314, 930, 361.614655, 4.360753 },
  { 314, 931, 257.279053, 4.004987 },
  { 314, 932, 171.206696, 3.617264 },
  { 314, 933, 97.409851, 3.141599 },
  { 314, 934, 94.768982, 3.120086 },
  { 314, 935, 63.394127, 2.821709 },
  { 314, 936, 59.720455, 2.779910 },
  { 314, 937, 35.564217, 2.442043 },
  { 314, 938, 33.575138, 2.407157 },
  { 314, 939, 33.126541, 2.399076 },
  { 314, 940, 32.833027, 2.393744 },
  { 314, 941, 39.004585, 2.499073 },
  { 314, 942, 35.528774, 2.441434 },
  { 315, 912, 36.035400, 2.450092 },
  { 315, 913, 44.151161, 2.577719 },
  { 315, 914, 35.606197, 2.442763 },
  { 315, 915, 39.917271, 2.513566 },
  { 315, 916, 35.767452, 2.445524 },
  { 315, 917, 39.372608, 2.504947 },
  { 315, 918, 48.265007, 2.635774 },
  { 315, 919, 52.608006, 2.693165 },
  { 315, 920, 53.031662, 2.698571 },
  { 315, 921, 77.221832, 2.964388 },
  { 315, 922, 86.182915, 3.046880 },
  { 315, 923, 147.187195, 3.483113 },
  { 315, 924, 221.003647, 3.855670 },
  { 315, 925, 324.028748, 4.242735 },
  { 315, 926, 453.000366, 4.613438 },
  { 315, 927, 543.919617, 4.829294 },
  { 315, 928, 516.619507, 4.767522 },
  { 315, 929, 424.028595, 4.537836 },
  { 315, 930, 324.026306, 4.242727 },
  { 315, 931, 208.583908, 3.800320 },
  { 315, 932, 153.999359, 3.522733 },
  { 315, 933, 94.804871, 3.120381 },
  { 315, 934, 82.765518, 3.016215 },
  { 315, 935, 65.805779, 2.848171 },
  { 315, 936, 47.437035, 2.624396 },
  { 315, 937, 55.165966, 2.725322 },
  { 315, 938, 49.553120, 2.653186 },
  { 315, 939, 46.621235, 2.613039 },
  { 315, 940, 43.657990, 2.570490 },
  { 315, 941, 36.273937, 2.454136 },
  { 315, 942, 36.039165, 2.450156 },
  { 316, 912, 50.720146, 2.668672 },
  { 316, 913, 35.262142, 2.436841 },
  { 316, 914, 36.177811, 2.452509 },
  { 316, 915, 40.658764, 2.525158 },
  { 316, 916, 45.493534, 2.597092 },
  { 316, 917, 44.117939, 2.577234 },
  { 316, 918, 37.863369, 2.480589 },
  { 316, 919, 48.233334, 2.635341 },
  { 316, 920, 49.450283, 2.651809 },
  { 316, 921, 53.780449, 2.708046 },
  { 316, 922, 100.233589, 3.164123 },
  { 316, 923, 104.441444, 3.196820 },
  { 316, 924, 162.247025, 3.568980 },
  { 316, 925, 236.206848, 3.920335 },
  { 316, 926, 291.221558, 4.131006 },
  { 316, 927, 350.584290, 4.327112 },
  { 316, 928, 338.530212, 4.289428 },
  { 316, 929, 281.067139, 4.094515 },
  { 316, 930, 237.198929, 3.924444 },
  { 316, 931, 171.634598, 3.619522 },
  { 316, 932, 126.859711, 3.356069 },
  { 316, 933, 90.397171, 3.083463 },
  { 316, 934, 64.151718, 2.830102 },
  { 316, 935, 60.937107, 2.793962 },
  { 316, 936, 38.424324, 2.489726 },
  { 316, 937, 49.687988, 2.654990 },
  { 316, 938, 49.385590, 2.650941 },
  { 316, 939, 45.106182, 2.591547 },
  { 316, 940, 43.682194, 2.570846 },
  { 316, 941, 44.377468, 2.581016 },
  { 316, 942, 43.411983, 2.566861 },
  { 317, 912, 45.462505, 2.596650 },
  { 317, 913, 38.031624, 2.483340 },
  { 317, 914, 34.497662, 2.423524 },
  { 317, 915, 43.852966, 2.573355 },
  { 317, 916, 34.434074, 2.422407 },
  { 317, 917, 42.419544, 2.552064 },
  { 317, 918, 37.183460, 2.469377 },
  { 317, 919, 42.616879, 2.555027 },
  { 317, 920, 57.959251, 2.759184 },
  { 317, 921, 64.482475, 2.833743 },
  { 317, 922, 54.325130, 2.714877 },
  { 317, 923, 91.206863, 3.090344 },
  { 317, 924, 114.238899, 3.269290 },
  { 317, 925, 155.139450, 3.529235 },
  { 317, 926, 172.306244, 3.623058 },
  { 317, 927, 224.575256, 3.871154 },
  { 317, 928, 219.315353, 3.848285 },
  { 317, 929, 169.853394, 3.610094 },
  { 317, 930, 176.965530, 3.647306 },
  { 317, 931, 137.676834, 3.425431 },
  { 317, 932, 107.056229, 3.216644 },
  { 317, 933, 71.178009, 2.904601 },
  { 317, 934, 58.816769, 2.769334 },
  { 317, 935, 63.581940, 2.823797 },
  { 317, 936, 61.036827, 2.795104 },
  { 317, 937, 44.138309, 2.577531 },
  { 317, 938, 44.499569, 2.582789 },
  { 317, 939, 39.934887, 2.513843 },
  { 317, 940, 55.979004, 2.735308 },
  { 317, 941, 43.038666, 2.561325 },
  { 317, 942, 49.597748, 2.653784 },
  { 318, 912, 26.809233, 2.275470 },
  { 318, 913, 35.021503, 2.432673 },
  { 318, 914, 34.893391, 2.430445 },
  { 318, 915, 30.682682, 2.353549 },
  { 318, 916, 48.959427, 2.645203 },
  { 318, 917, 46.542427, 2.611934 },
  { 318, 918, 44.085789, 2.576764 },
  { 318, 919, 51.970238, 2.684965 },
  { 318, 920, 53.064095, 2.698983 },
  { 318, 921, 45.635265, 2.599113 },
  { 318, 922, 67.141762, 2.862518 },
  { 318, 923, 67.381081, 2.865065 },
  { 318, 924, 95.559494, 3.126572 },
  { 318, 925, 120.191444, 3.311070 },
  { 318, 926, 123.940811, 3.336596 },
  { 318, 927, 131.703064, 3.387653 },
  { 318, 928, 131.831726, 3.388480 },
  { 318, 929, 136.488937, 3.418018 },
  { 318, 930, 107.603668, 3.220748 },
  { 318, 931, 97.460922, 3.142010 },
  { 318, 932, 71.380432, 2.906664 },
  { 318, 933, 68.057297, 2.872226 },
  { 318, 934, 54.641796, 2.718825 },
  { 318, 935, 60.171478, 2.785144 },
  { 318, 936, 49.022621, 2.646057 },
  { 318, 937, 46.550251, 2.612044 },
  { 318, 938, 41.104801, 2.532055 },
  { 318, 939, 49.228848, 2.648835 },
  { 318, 940, 48.464497, 2.638493 },
  { 318, 941, 63.858955, 2.826868 },
  { 318, 942, 47.027283, 2.618710 },
  { 319, 912, 37.840237, 2.480210 },
  { 319, 913, 46.875099, 2.616589 },
  { 319, 914, 33.200108, 2.400407 },
  { 319, 915, 42.410152, 2.551922 },
  { 319, 916, 35.872131, 2.447312 },
  { 319, 917, 56.706547, 2.744153 },
  { 319, 918, 44.212208, 2.578609 },
  { 319, 919, 60.283787, 2.786443 },
  { 319, 920, 40.987858, 2.530252 },
  { 319, 921, 52.554012, 2.692474 },
  { 319, 922, 52.065407, 2.686194 },
  { 319, 923, 67.501968, 2.866349 },
  { 319, 924, 71.441559, 2.907286 },
  { 319, 925, 76.246056, 2.954978 },
  { 319, 926, 77.038574, 2.962628 },
  { 319, 927, 98.078468, 3.146976 },
  { 319, 928, 79.785622, 2.988692 },
  { 319, 929, 82.015839, 3.009362 },
  { 319, 930, 78.827850, 2.979682 },
  { 319, 931, 74.933090, 2.942174 },
  { 319, 932, 63.038853, 2.817748 },
  { 319, 933, 60.269093, 2.786273 },
  { 319, 934, 49.878292, 2.657528 },
  { 319, 935, 42.642735, 2.555414 },
  { 319, 936, 42.465557, 2.552755 },
  { 319, 937, 53.302624, 2.702011 },
  { 319, 938, 52.233055, 2.688353 },
  { 319, 939, 55.825985, 2.733437 },
  { 319, 940, 41.832203, 2.543183 },
  { 319, 941, 56.686115, 2.743906 },
  { 319, 942, 61.180241, 2.796745 },
  { 320, 912, 47.708740, 2.628146 },
  { 320, 913, 32.083996, 2.379973 },
  { 320, 914, 29.369442, 2.327951 },
  { 320, 915, 36.806381, 2.463093 },
  { 320, 916, 32.866146, 2.394347 },
  { 320, 917, 36.454578, 2.457186 },
  { 320, 918, 43.667839, 2.570635 },
  { 320, 919, 41.407631, 2.536706 },
  { 320, 920, 58.953148, 2.770938 },
  { 320, 921, 46.371765, 2.609537 },
  { 320, 922, 42.051823, 2.546515 },
  { 320, 923, 51.320736, 2.676537 },
  { 320, 924, 69.395721, 2.886245 },
  { 320, 925, 60.359291, 2.787315 },
  { 320, 926, 60.616096, 2.790275 },
  { 320, 927, 55.611233, 2.730805 },
  { 320, 928, 61.716953, 2.802858 },
  { 320, 929, 72.900902, 2.922020 },
  { 320, 930, 58.704456, 2.768011 },
  { 320, 931, 53.599686, 2.705768 },
  { 320, 932, 59.032879, 2.771874 },
  { 320, 933, 55.373798, 2.727885 },
  { 320, 934, 52.990196, 2.698043 },
  { 320, 935, 46.620186, 2.613025 },
  { 320, 936, 41.634899, 2.540179 },
  { 320, 937, 44.279984, 2.579597 },
  { 320, 938, 54.690552, 2.719431 },
  { 320, 939, 46.368431, 2.609490 },
  { 320, 940, 69.528076, 2.887620 },
  { 320, 941, 67.357903, 2.864819 },
  { 320, 942, 82.324821, 3.012192 },
  { 321, 912, 41.872787, 2.543800 },
  { 321, 913, 35.159100, 2.435059 },
  { 321, 914, 34.500626, 2.423577 },
  { 321, 915, 34.822060, 2.429202 },
  { 321, 916, 45.759422, 2.600879 },
  { 321, 917, 33.365795, 2.403396 },
  { 321, 918, 39.431816, 2.505888 },
  { 321, 919, 42.703960, 2.556331 },
  { 321, 920, 50.085220, 2.660280 },
  { 321, 921, 39.322109, 2.504143 },
  { 321, 922, 43.444008, 2.567335 },
  { 321, 923, 40.303135, 2.519618 },
  { 321, 924, 48.310009, 2.636388 },
  { 321, 925, 48.190098, 2.634750 },
  { 321, 926, 53.559948, 2.705266 },
  { 321, 927, 59.879360, 2.781758 },
  { 321, 928, 71.346985, 2.906323 },
  { 321, 929, 54.358536, 2.715295 },
  { 321, 930, 44.145603, 2.577638 },
  { 321, 931, 44.222530, 2.578760 },
  { 321, 932, 52.654739, 2.693763 },
  { 321, 933, 33.763031, 2.410518 },
  { 321, 934, 39.035030, 2.499560 },
  { 321, 935, 48.732548, 2.642134 },
  { 321, 936, 53.514484, 2.704692 },
  { 321, 937, 54.457233, 2.716526 },
  { 321, 938, 46.745174, 2.614774 },
  { 321, 939, 47.092117, 2.619612 },
  { 321, 940, 55.249989, 2.726359 },
  { 321, 941, 93.530174, 3.109839 },
  { 321, 942, 115.847656, 3.280740 },
  { 322, 912, 38.238785, 2.486715 },
  { 322, 913, 31.233004, 2.364033 },
  { 322, 914, 46.848648, 2.616220 },
  { 322, 915, 39.569695, 2.508076 },
  { 322, 916, 33.403812, 2.404080 },
  { 322, 917, 32.564735, 2.388839 },
  { 322, 918, 36.767639, 2.462444 },
  { 322, 919, 43.428162, 2.567100 },
  { 322, 920, 35.410786, 2.439405 },
  { 322, 921, 30.538458, 2.350779 },
  { 322, 922, 51.241318, 2.675501 },
  { 322, 923, 42.158119, 2.548123 },
  { 322, 924, 55.808578, 2.733224 },
  { 322, 925, 55.490021, 2.729315 },
  { 322, 926, 58.496563, 2.765557 },
  { 322, 927, 38.698383, 2.494154 },
  { 322, 928, 44.958084, 2.589417 },
  { 322, 929, 42.942272, 2.559890 },
  { 322, 930, 57.002716, 2.747729 },
  { 322, 931, 51.995285, 2.685289 },
  { 322, 932, 43.550091, 2.568900 },
  { 322, 933, 40.678738, 2.525468 },
  { 322, 934, 42.299522, 2.550256 },
  { 322, 935, 48.695518, 2.641632 },
  { 322, 936, 36.646042, 2.460406 },
  { 322, 937, 48.776321, 2.642727 },
  { 322, 938, 45.386261, 2.595560 },
  { 322, 939, 52.506027, 2.691859 },
  { 322, 940, 68.616936, 2.878113 },
  { 322, 941, 108.374741, 3.226503 },
  { 322, 942, 121.446625, 3.319681 },
  { 323, 912, 40.276558, 2.519202 },
  { 323, 913, 39.806377, 2.511818 },
  { 323, 914, 39.517483, 2.507248 },
  { 323, 915, 50.504208, 2.665827 },
  { 323, 916, 42.496147, 2.553215 },
  { 323, 917, 38.972332, 2.498556 },
  { 323, 918, 40.976494, 2.530077 },
  { 323, 919, 28.053295, 2.301420 },
  { 323, 920, 38.901279, 2.497416 },
  { 323, 921, 48.423191, 2.637930 },
  { 323, 922, 41.809643, 2.542840 },
  { 323, 923, 41.481869, 2.537842 },
  { 323, 924, 42.274452, 2.549879 },
  { 323, 925, 51.771038, 2.682389 },
  { 323, 926, 47.869923, 2.630363 },
  { 323, 927, 54.857643, 2.721506 },
  { 323, 928, 43.554344, 2.568963 },
  { 323, 929, 35.564396, 2.442046 },
  { 323, 930, 40.491688, 2.522560 },
  { 323, 931, 45.417690, 2.596009 },
  { 323, 932, 38.272953, 2.487270 },
  { 323, 933, 42.906399, 2.559355 },
  { 323, 934, 43.099384, 2.562228 },
  { 323, 935, 46.893764, 2.616850 },
  { 323, 936, 40.855412, 2.528206 },
  { 323, 937, 48.174576, 2.634538 },
  { 323, 938, 52.499599, 2.691777 },
  { 323, 939, 57.281693, 2.751085 },
  { 323, 940, 68.317360, 2.874966 },
  { 323, 941, 99.357094, 3.157183 },
  { 323, 942, 124.859772, 3.342763 },
  { 324, 912, 29.419659, 2.328946 },
  { 324, 913, 29.662552, 2.333738 },
  { 324, 914, 39.746712, 2.510876 },
  { 324, 915, 37.213234, 2.469872 },
  { 324, 916, 42.094704, 2.547164 },
  { 324, 917, 34.053600, 2.415688 },
  { 324, 918, 34.777050, 2.428416 },
  { 324, 919, 39.262287, 2.503191 },
  { 324, 920, 42.549171, 2.554011 },
  { 324, 921, 32.164169, 2.381459 },
  { 324, 922, 47.687305, 2.627851 },
  { 324, 923, 47.306042, 2.622582 },
  { 324, 924, 42.757153, 2.557126 },
  { 324, 925, 42.549137, 2.554011 },
  { 324, 926, 43.682133, 2.570845 },
  { 324, 927, 41.365570, 2.536061 },
  { 324, 928, 46.277298, 2.608207 },
  { 324, 929, 39.342514, 2.504468 },
  { 324, 930, 47.452110, 2.624605 },
  { 324, 931, 54.360821, 2.715323 },
  { 324, 932, 45.493481, 2.597092 },
  { 324, 933, 36.912071, 2.464859 },
  { 324, 934, 39.105782, 2.500692 },
  { 324, 935, 32.054588, 2.379428 },
  { 324, 936, 46.223751, 2.607452 },
  { 324, 937, 47.053204, 2.619071 },
  { 324, 938, 37.516052, 2.474881 },
  { 324, 939, 53.782310, 2.708070 },
  { 324, 940, 61.607109, 2.801610 },
  { 324, 941, 91.238052, 3.090609 },
  { 324, 942, 105.983734, 3.208557 },
  { 325, 912, 47.490276, 2.625132 },
  { 325, 913, 35.574814, 2.442225 },
  { 325, 914, 36.393669, 2.456159 },
  { 325, 915, 35.655567, 2.443610 },
  { 325, 916, 34.546040, 2.424374 },
  { 325, 917, 37.287704, 2.471106 },
  { 325, 918, 36.905994, 2.464758 },
  { 325, 919, 41.271236, 2.534614 },
  { 325, 920, 33.715458, 2.409668 },
  { 325, 921, 52.940964, 2.697416 },
  { 325, 922, 44.191219, 2.578303 },
  { 325, 923, 33.339748, 2.402927 },
  { 325, 924, 41.010502, 2.530602 },
  { 325, 925, 41.480583, 2.537822 },
  { 325, 926, 31.407499, 2.367327 },
  { 325, 927, 40.258408, 2.518919 },
  { 325, 928, 36.092945, 2.451069 },
  { 325, 929, 48.446728, 2.638251 },
  { 325, 930, 45.838329, 2.602000 },
  { 325, 931, 44.922409, 2.588903 },
  { 325, 932, 33.834518, 2.411793 },
  { 325, 933, 36.754677, 2.462227 },
  { 325, 934, 38.607323, 2.492685 },
  { 325, 935, 46.790779, 2.615412 },
  { 325, 936, 42.561344, 2.554194 },
  { 325, 937, 50.256893, 2.662557 },
  { 325, 938, 42.334969, 2.550791 },
  { 325, 939, 54.450047, 2.716437 },
  { 325, 940, 65.377327, 2.843523 },
  { 325, 941, 65.646362, 2.846444 },
  { 325, 942, 81.371887, 3.003438 },
  { 326, 912, 35.322231, 2.437878 },
  { 326, 913, 47.083431, 2.619492 },
  { 326, 914, 37.845360, 2.480294 },
  { 326, 915, 33.873741, 2.412492 },
  { 326, 916, 38.378521, 2.488984 },
  { 326, 917, 39.435081, 2.505940 },
  { 326, 918, 41.899998, 2.544213 },
  { 326, 919, 38.421055, 2.489673 },
  { 326, 920, 29.913738, 2.338663 },
  { 326, 921, 46.269058, 2.608091 },
  { 326, 922, 35.109810, 2.434205 },
  { 326, 923, 38.645008, 2.493293 },
  { 326, 924, 26.644592, 2.271968 },
  { 326, 925, 43.629269, 2.570067 },
  { 326, 926, 49.295780, 2.649735 },
  { 326, 927, 39.118877, 2.500901 },
  { 326, 928, 41.193825, 2.533425 },
  { 326, 929, 45.814091, 2.601655 },
  { 326, 930, 37.326138, 2.471743 },
  { 326, 931, 33.872868, 2.412476 },
  { 326, 932, 35.097363, 2.433989 },
  { 326, 933, 40.633320, 2.524763 },
  { 326, 934, 38.129356, 2.484934 },
  { 326, 935, 40.966564, 2.529923 },
  { 326, 936, 42.035492, 2.546268 },
  { 326, 937, 34.187859, 2.418065 },
  { 326, 938, 37.163380, 2.469044 },
  { 326, 939, 43.218315, 2.563994 },
  { 326, 940, 53.587994, 2.705621 },
  { 326, 941, 59.644962, 2.779031 },
  { 326, 942, 67.822929, 2.869750 },
  { 327, 912, 41.321758, 2.535390 },
  { 327, 913, 35.179691, 2.435415 },
  { 327, 914, 34.267868, 2.419478 },
  { 327, 915, 30.321875, 2.346600 },
  { 327, 916, 31.196039, 2.363333 },
  { 327, 917, 40.694244, 2.525709 },
  { 327, 918, 35.366131, 2.438635 },
  { 327, 919, 35.881336, 2.447469 },
  { 327, 920, 32.360947, 2.385093 },
  { 327, 921, 45.196892, 2.592849 },
  { 327, 922, 31.685991, 2.372558 },
  { 327, 923, 51.114067, 2.673838 },
  { 327, 924, 38.120228, 2.484785 },
  { 327, 925, 43.626339, 2.570024 },
  { 327, 926, 28.460871, 2.309734 },
  { 327, 927, 30.332003, 2.346796 },
  { 327, 928, 36.085453, 2.450942 },
  { 327, 929, 41.141155, 2.532615 },
  { 327, 930, 32.586918, 2.389246 },
  { 327, 931, 36.296928, 2.454525 },
  { 327, 932, 44.180473, 2.578146 },
  { 327, 933, 38.718071, 2.494471 },
  { 327, 934, 31.516623, 2.369381 },
  { 327, 935, 35.422668, 2.439610 },
  { 327, 936, 50.355522, 2.663862 },
  { 327, 937, 48.817528, 2.643285 },
  { 327, 938, 39.137257, 2.501195 },
  { 327, 939, 28.540527, 2.311349 },
  { 327, 940, 39.082977, 2.500328 },
  { 327, 941, 50.824730, 2.670046 },
  { 327, 942, 52.382587, 2.690275 },
  { 0., 0., 0., 0. }
};

/* IRAF/artdata/mkobj generated Moffat                                   *
 * beta=2.7, center=19./19., circular                                    *
 *    mkobj Moffat1.fits obj=list ncol=38 nli=38 poiss- magz=15 beta=2.7 *
 *    mkobj Moffat2.fits obj=list ncol=38 nli=38 poiss+ magz=15 beta=2.7 *
 * (list contains "19 19 0.")                                            *
 *    listpix Moffat1.fits > Moffat1.ascii                               *
 *    listpix Moffat2.fits > Moffat2.ascii                               *
 * then in the shell                                                     *
 *    awk '{print sqrt($3)}' Moffat1.ascii > Moffat1_err.ascii           *
 *    paste Moffat2.ascii Moffat1_err.ascii                            \ *
 *       | awk '{printf("  { %2d, %2d, %.5e, %.4e },\n",$1,$2,$3,$4) }'\ *
 *       > Moffat1_werr.ascii                                            */
const float kMoffat1[][4] = {
  {  1,  1, 1.05366e+03, 3.1623e+01 },
  {  2,  1, 9.80720e+02, 3.1623e+01 },
  {  3,  1, 1.00859e+03, 3.1623e+01 },
  {  4,  1, 1.00026e+03, 3.1623e+01 },
  {  5,  1, 9.69252e+02, 3.1623e+01 },
  {  6,  1, 1.05848e+03, 3.1623e+01 },
  {  7,  1, 1.01643e+03, 3.1623e+01 },
  {  8,  1, 1.02640e+03, 3.1623e+01 },
  {  9,  1, 1.04228e+03, 3.1623e+01 },
  { 10,  1, 1.00988e+03, 3.1623e+01 },
  { 11,  1, 1.03362e+03, 3.1623e+01 },
  { 12,  1, 9.62650e+02, 3.1623e+01 },
  { 13,  1, 1.07802e+03, 3.1623e+01 },
  { 14,  1, 9.98294e+02, 3.1623e+01 },
  { 15,  1, 1.01622e+03, 3.1623e+01 },
  { 16,  1, 9.31389e+02, 3.1623e+01 },
  { 17,  1, 9.74821e+02, 3.1623e+01 },
  { 18,  1, 9.86267e+02, 3.1623e+01 },
  { 19,  1, 9.16446e+02, 3.1623e+01 },
  { 20,  1, 1.00835e+03, 3.1623e+01 },
  { 21,  1, 9.79013e+02, 3.1623e+01 },
  { 22,  1, 9.97962e+02, 3.1623e+01 },
  { 23,  1, 9.75318e+02, 3.1623e+01 },
  { 24,  1, 9.86602e+02, 3.1623e+01 },
  { 25,  1, 9.63035e+02, 3.1623e+01 },
  { 26,  1, 9.94686e+02, 3.1623e+01 },
  { 27,  1, 1.01834e+03, 3.1623e+01 },
  { 28,  1, 1.02398e+03, 3.1623e+01 },
  { 29,  1, 9.78720e+02, 3.1623e+01 },
  { 30,  1, 9.95742e+02, 3.1623e+01 },
  { 31,  1, 9.72952e+02, 3.1623e+01 },
  { 32,  1, 1.09561e+03, 3.1623e+01 },
  { 33,  1, 9.81755e+02, 3.1623e+01 },
  { 34,  1, 1.03260e+03, 3.1623e+01 },
  { 35,  1, 9.51711e+02, 3.1623e+01 },
  { 36,  1, 1.01726e+03, 3.1623e+01 },
  { 37,  1, 1.00107e+03, 3.1623e+01 },
  { 38,  1, 9.92261e+02, 3.1623e+01 },
  {  1,  2, 9.85658e+02, 3.1623e+01 },
  {  2,  2, 9.95785e+02, 3.1623e+01 },
  {  3,  2, 9.43724e+02, 3.1623e+01 },
  {  4,  2, 9.94722e+02, 3.1623e+01 },
  {  5,  2, 9.72021e+02, 3.1623e+01 },
  {  6,  2, 1.03976e+03, 3.1623e+01 },
  {  7,  2, 1.00067e+03, 3.1623e+01 },
  {  8,  2, 9.83598e+02, 3.1623e+01 },
  {  9,  2, 1.04341e+03, 3.1623e+01 },
  { 10,  2, 9.88801e+02, 3.1623e+01 },
  { 11,  2, 1.00522e+03, 3.1623e+01 },
  { 12,  2, 9.67483e+02, 3.1623e+01 },
  { 13,  2, 1.00032e+03, 3.1623e+01 },
  { 14,  2, 1.05220e+03, 3.1623e+01 },
  { 15,  2, 9.60710e+02, 3.1623e+01 },
  { 16,  2, 1.01269e+03, 3.1623e+01 },
  { 17,  2, 1.00906e+03, 3.1623e+01 },
  { 18,  2, 1.00423e+03, 3.1623e+01 },
  { 19,  2, 1.05038e+03, 3.1623e+01 },
  { 20,  2, 9.64642e+02, 3.1623e+01 },
  { 21,  2, 9.74053e+02, 3.1623e+01 },
  { 22,  2, 9.89315e+02, 3.1623e+01 },
  { 23,  2, 1.01900e+03, 3.1623e+01 },
  { 24,  2, 9.47559e+02, 3.1623e+01 },
  { 25,  2, 1.00540e+03, 3.1623e+01 },
  { 26,  2, 1.04138e+03, 3.1623e+01 },
  { 27,  2, 1.05603e+03, 3.1623e+01 },
  { 28,  2, 1.04553e+03, 3.1623e+01 },
  { 29,  2, 9.77871e+02, 3.1623e+01 },
  { 30,  2, 1.02876e+03, 3.1623e+01 },
  { 31,  2, 9.22728e+02, 3.1623e+01 },
  { 32,  2, 9.91470e+02, 3.1623e+01 },
  { 33,  2, 9.46012e+02, 3.1623e+01 },
  { 34,  2, 1.04926e+03, 3.1623e+01 },
  { 35,  2, 1.00254e+03, 3.1623e+01 },
  { 36,  2, 1.01106e+03, 3.1623e+01 },
  { 37,  2, 9.83152e+02, 3.1623e+01 },
  { 38,  2, 1.03766e+03, 3.1623e+01 },
  {  1,  3, 1.01825e+03, 3.1623e+01 },
  {  2,  3, 9.55458e+02, 3.1623e+01 },
  {  3,  3, 9.87425e+02, 3.1623e+01 },
  {  4,  3, 9.71793e+02, 3.1623e+01 },
  {  5,  3, 9.79910e+02, 3.1623e+01 },
  {  6,  3, 9.93831e+02, 3.1623e+01 },
  {  7,  3, 9.73216e+02, 3.1623e+01 },
  {  8,  3, 9.70395e+02, 3.1623e+01 },
  {  9,  3, 1.00746e+03, 3.1623e+01 },
  { 10,  3, 9.64635e+02, 3.1623e+01 },
  { 11,  3, 9.89868e+02, 3.1623e+01 },
  { 12,  3, 1.05513e+03, 3.1623e+01 },
  { 13,  3, 9.77980e+02, 3.1623e+01 },
  { 14,  3, 9.79169e+02, 3.1623e+01 },
  { 15,  3, 1.03786e+03, 3.1623e+01 },
  { 16,  3, 1.01475e+03, 3.1623e+01 },
  { 17,  3, 9.86115e+02, 3.1623e+01 },
  { 18,  3, 1.00838e+03, 3.1623e+01 },
  { 19,  3, 1.01097e+03, 3.1623e+01 },
  { 20,  3, 9.39281e+02, 3.1623e+01 },
  { 21,  3, 1.01031e+03, 3.1623e+01 },
  { 22,  3, 9.56728e+02, 3.1623e+01 },
  { 23,  3, 9.91326e+02, 3.1623e+01 },
  { 24,  3, 9.98888e+02, 3.1623e+01 },
  { 25,  3, 9.52088e+02, 3.1623e+01 },
  { 26,  3, 9.52714e+02, 3.1623e+01 },
  { 27,  3, 1.04529e+03, 3.1623e+01 },
  { 28,  3, 9.88625e+02, 3.1623e+01 },
  { 29,  3, 1.00958e+03, 3.1623e+01 },
  { 30,  3, 1.01772e+03, 3.1623e+01 },
  { 31,  3, 1.04399e+03, 3.1623e+01 },
  { 32,  3, 1.01360e+03, 3.1623e+01 },
  { 33,  3, 9.89088e+02, 3.1623e+01 },
  { 34,  3, 9.55742e+02, 3.1623e+01 },
  { 35,  3, 9.98090e+02, 3.1623e+01 },
  { 36,  3, 1.04201e+03, 3.1623e+01 },
  { 37,  3, 1.06600e+03, 3.1623e+01 },
  { 38,  3, 9.83027e+02, 3.1623e+01 },
  {  1,  4, 1.00933e+03, 3.1623e+01 },
  {  2,  4, 9.71262e+02, 3.1623e+01 },
  {  3,  4, 9.49529e+02, 3.1623e+01 },
  {  4,  4, 1.03586e+03, 3.1623e+01 },
  {  5,  4, 9.78152e+02, 3.1623e+01 },
  {  6,  4, 1.00666e+03, 3.1623e+01 },
  {  7,  4, 1.01039e+03, 3.1623e+01 },
  {  8,  4, 9.90854e+02, 3.1623e+01 },
  {  9,  4, 1.00746e+03, 3.1623e+01 },
  { 10,  4, 1.01481e+03, 3.1623e+01 },
  { 11,  4, 9.61526e+02, 3.1623e+01 },
  { 12,  4, 1.00908e+03, 3.1623e+01 },
  { 13,  4, 9.94305e+02, 3.1623e+01 },
  { 14,  4, 1.03143e+03, 3.1623e+01 },
  { 15,  4, 9.94428e+02, 3.1623e+01 },
  { 16,  4, 9.28046e+02, 3.1649e+01 },
  { 17,  4, 1.01471e+03, 3.1651e+01 },
  { 18,  4, 9.68082e+02, 3.1652e+01 },
  { 19,  4, 1.04572e+03, 3.1652e+01 },
  { 20,  4, 9.92043e+02, 3.1652e+01 },
  { 21,  4, 1.02048e+03, 3.1651e+01 },
  { 22,  4, 9.49887e+02, 3.1649e+01 },
  { 23,  4, 1.11252e+03, 3.1623e+01 },
  { 24,  4, 9.21885e+02, 3.1623e+01 },
  { 25,  4, 9.63549e+02, 3.1623e+01 },
  { 26,  4, 9.92015e+02, 3.1623e+01 },
  { 27,  4, 9.86208e+02, 3.1623e+01 },
  { 28,  4, 1.03373e+03, 3.1623e+01 },
  { 29,  4, 1.01884e+03, 3.1623e+01 },
  { 30,  4, 9.80314e+02, 3.1623e+01 },
  { 31,  4, 1.01780e+03, 3.1623e+01 },
  { 32,  4, 1.00757e+03, 3.1623e+01 },
  { 33,  4, 1.04986e+03, 3.1623e+01 },
  { 34,  4, 9.91044e+02, 3.1623e+01 },
  { 35,  4, 9.93060e+02, 3.1623e+01 },
  { 36,  4, 9.91833e+02, 3.1623e+01 },
  { 37,  4, 1.03422e+03, 3.1623e+01 },
  { 38,  4, 1.03048e+03, 3.1623e+01 },
  {  1,  5, 1.00251e+03, 3.1623e+01 },
  {  2,  5, 1.00638e+03, 3.1623e+01 },
  {  3,  5, 1.00024e+03, 3.1623e+01 },
  {  4,  5, 1.01461e+03, 3.1623e+01 },
  {  5,  5, 1.03064e+03, 3.1623e+01 },
  {  6,  5, 1.00106e+03, 3.1623e+01 },
  {  7,  5, 9.20163e+02, 3.1623e+01 },
  {  8,  5, 1.03037e+03, 3.1623e+01 },
  {  9,  5, 1.06515e+03, 3.1623e+01 },
  { 10,  5, 9.81489e+02, 3.1623e+01 },
  { 11,  5, 1.03357e+03, 3.1623e+01 },
  { 12,  5, 1.01129e+03, 3.1623e+01 },
  { 13,  5, 1.06373e+03, 3.1650e+01 },
  { 14,  5, 9.78012e+02, 3.1654e+01 },
  { 15,  5, 9.93450e+02, 3.1657e+01 },
  { 16,  5, 9.88719e+02, 3.1661e+01 },
  { 17,  5, 1.00147e+03, 3.1663e+01 },
  { 18,  5, 9.78831e+02, 3.1665e+01 },
  { 19,  5, 1.06859e+03, 3.1666e+01 },
  { 20,  5, 1.01013e+03, 3.1665e+01 },
  { 21,  5, 9.62998e+02, 3.1663e+01 },
  { 22,  5, 1.05211e+03, 3.1661e+01 },
  { 23,  5, 9.46110e+02, 3.1657e+01 },
  { 24,  5, 9.61683e+02, 3.1654e+01 },
  { 25,  5, 1.02939e+03, 3.1650e+01 },
  { 26,  5, 1.03495e+03, 3.1623e+01 },
  { 27,  5, 9.73967e+02, 3.1623e+01 },
  { 28,  5, 9.45431e+02, 3.1623e+01 },
  { 29,  5, 9.66666e+02, 3.1623e+01 },
  { 30,  5, 1.01168e+03, 3.1623e+01 },
  { 31,  5, 1.04406e+03, 3.1623e+01 },
  { 32,  5, 1.00065e+03, 3.1623e+01 },
  { 33,  5, 9.71222e+02, 3.1623e+01 },
  { 34,  5, 9.98381e+02, 3.1623e+01 },
  { 35,  5, 9.79509e+02, 3.1623e+01 },
  { 36,  5, 1.01139e+03, 3.1623e+01 },
  { 37,  5, 9.68995e+02, 3.1623e+01 },
  { 38,  5, 9.40168e+02, 3.1623e+01 },
  {  1,  6, 9.59406e+02, 3.1623e+01 },
  {  2,  6, 9.98749e+02, 3.1623e+01 },
  {  3,  6, 9.41591e+02, 3.1623e+01 },
  {  4,  6, 9.90204e+02, 3.1623e+01 },
  {  5,  6, 9.80861e+02, 3.1623e+01 },
  {  6,  6, 9.70550e+02, 3.1623e+01 },
  {  7,  6, 1.05425e+03, 3.1623e+01 },
  {  8,  6, 1.02324e+03, 3.1623e+01 },
  {  9,  6, 9.93245e+02, 3.1623e+01 },
  { 10,  6, 9.63235e+02, 3.1623e+01 },
  { 11,  6, 1.01925e+03, 3.1650e+01 },
  { 12,  6, 1.02837e+03, 3.1655e+01 },
  { 13,  6, 9.71343e+02, 3.1661e+01 },
  { 14,  6, 9.73531e+02, 3.1667e+01 },
  { 15,  6, 9.91393e+02, 3.1672e+01 },
  { 16,  6, 1.05680e+03, 3.1678e+01 },
  { 17,  6, 9.66332e+02, 3.1682e+01 },
  { 18,  6, 9.96022e+02, 3.1685e+01 },
  { 19,  6, 9.90578e+02, 3.1686e+01 },
  { 20,  6, 9.56271e+02, 3.1685e+01 },
  { 21,  6, 9.51178e+02, 3.1682e+01 },
  { 22,  6, 9.46319e+02, 3.1678e+01 },
  { 23,  6, 1.00788e+03, 3.1672e+01 },
  { 24,  6, 1.00712e+03, 3.1667e+01 },
  { 25,  6, 1.02239e+03, 3.1661e+01 },
  { 26,  6, 1.02640e+03, 3.1655e+01 },
  { 27,  6, 1.00441e+03, 3.1650e+01 },
  { 28,  6, 1.00445e+03, 3.1623e+01 },
  { 29,  6, 1.02848e+03, 3.1623e+01 },
  { 30,  6, 1.03600e+03, 3.1623e+01 },
  { 31,  6, 9.92599e+02, 3.1623e+01 },
  { 32,  6, 1.01419e+03, 3.1623e+01 },
  { 33,  6, 9.95792e+02, 3.1623e+01 },
  { 34,  6, 9.97134e+02, 3.1623e+01 },
  { 35,  6, 9.95298e+02, 3.1623e+01 },
  { 36,  6, 9.71395e+02, 3.1623e+01 },
  { 37,  6, 1.02356e+03, 3.1623e+01 },
  { 38,  6, 1.01709e+03, 3.1623e+01 },
  {  1,  7, 9.65053e+02, 3.1623e+01 },
  {  2,  7, 9.55051e+02, 3.1623e+01 },
  {  3,  7, 9.97280e+02, 3.1623e+01 },
  {  4,  7, 9.95004e+02, 3.1623e+01 },
  {  5,  7, 1.00092e+03, 3.1623e+01 },
  {  6,  7, 1.08697e+03, 3.1623e+01 },
  {  7,  7, 9.75723e+02, 3.1623e+01 },
  {  8,  7, 9.74893e+02, 3.1623e+01 },
  {  9,  7, 1.04989e+03, 3.1623e+01 },
  { 10,  7, 9.66224e+02, 3.1652e+01 },
  { 11,  7, 9.65579e+02, 3.1659e+01 },
  { 12,  7, 9.97129e+02, 3.1667e+01 },
  { 13,  7, 1.03398e+03, 3.1676e+01 },
  { 14,  7, 9.56563e+02, 3.1686e+01 },
  { 15,  7, 9.89294e+02, 3.1696e+01 },
  { 16,  7, 9.60342e+02, 3.1705e+01 },
  { 17,  7, 1.00114e+03, 3.1712e+01 },
  { 18,  7, 1.00472e+03, 3.1718e+01 },
  { 19,  7, 9.27037e+02, 3.1719e+01 },
  { 20,  7, 1.01527e+03, 3.1718e+01 },
  { 21,  7, 9.51314e+02, 3.1712e+01 },
  { 22,  7, 1.00425e+03, 3.1705e+01 },
  { 23,  7, 1.02921e+03, 3.1696e+01 },
  { 24,  7, 1.01492e+03, 3.1686e+01 },
  { 25,  7, 9.94786e+02, 3.1676e+01 },
  { 26,  7, 9.45300e+02, 3.1667e+01 },
  { 27,  7, 1.00081e+03, 3.1659e+01 },
  { 28,  7, 1.01840e+03, 3.1652e+01 },
  { 29,  7, 1.00631e+03, 3.1623e+01 },
  { 30,  7, 9.76163e+02, 3.1623e+01 },
  { 31,  7, 1.00406e+03, 3.1623e+01 },
  { 32,  7, 1.01280e+03, 3.1623e+01 },
  { 33,  7, 1.06673e+03, 3.1623e+01 },
  { 34,  7, 1.02657e+03, 3.1623e+01 },
  { 35,  7, 1.00363e+03, 3.1623e+01 },
  { 36,  7, 9.85545e+02, 3.1623e+01 },
  { 37,  7, 1.01571e+03, 3.1623e+01 },
  { 38,  7, 1.00760e+03, 3.1623e+01 },
  {  1,  8, 9.73663e+02, 3.1623e+01 },
  {  2,  8, 1.00614e+03, 3.1623e+01 },
  {  3,  8, 9.70781e+02, 3.1623e+01 },
  {  4,  8, 1.00654e+03, 3.1623e+01 },
  {  5,  8, 9.75347e+02, 3.1623e+01 },
  {  6,  8, 9.36856e+02, 3.1623e+01 },
  {  7,  8, 1.02400e+03, 3.1623e+01 },
  {  8,  8, 1.00161e+03, 3.1623e+01 },
  {  9,  8, 9.84125e+02, 3.1654e+01 },
  { 10,  8, 1.03043e+03, 3.1662e+01 },
  { 11,  8, 9.84611e+02, 3.1672e+01 },
  { 12,  8, 1.01312e+03, 3.1685e+01 },
  { 13,  8, 9.93235e+02, 3.1700e+01 },
  { 14,  8, 9.98759e+02, 3.1715e+01 },
  { 15,  8, 1.05932e+03, 3.1733e+01 },
  { 16,  8, 1.06395e+03, 3.1749e+01 },
  { 17,  8, 1.02695e+03, 3.1763e+01 },
  { 18,  8, 1.04058e+03, 3.1772e+01 },
  { 19,  8, 1.03856e+03, 3.1775e+01 },
  { 20,  8, 9.73830e+02, 3.1772e+01 },
  { 21,  8, 1.06411e+03, 3.1763e+01 },
  { 22,  8, 9.78893e+02, 3.1749e+01 },
  { 23,  8, 1.01132e+03, 3.1733e+01 },
  { 24,  8, 1.00762e+03, 3.1715e+01 },
  { 25,  8, 1.04823e+03, 3.1700e+01 },
  { 26,  8, 9.90298e+02, 3.1685e+01 },
  { 27,  8, 1.03889e+03, 3.1672e+01 },
  { 28,  8, 9.89431e+02, 3.1662e+01 },
  { 29,  8, 9.73062e+02, 3.1654e+01 },
  { 30,  8, 1.03968e+03, 3.1623e+01 },
  { 31,  8, 9.88182e+02, 3.1623e+01 },
  { 32,  8, 1.05340e+03, 3.1623e+01 },
  { 33,  8, 1.00520e+03, 3.1623e+01 },
  { 34,  8, 1.06313e+03, 3.1623e+01 },
  { 35,  8, 9.56569e+02, 3.1623e+01 },
  { 36,  8, 1.01311e+03, 3.1623e+01 },
  { 37,  8, 1.00139e+03, 3.1623e+01 },
  { 38,  8, 9.81347e+02, 3.1623e+01 },
  {  1,  9, 1.01150e+03, 3.1623e+01 },
  {  2,  9, 9.45967e+02, 3.1623e+01 },
  {  3,  9, 9.99056e+02, 3.1623e+01 },
  {  4,  9, 9.99732e+02, 3.1623e+01 },
  {  5,  9, 9.76796e+02, 3.1623e+01 },
  {  6,  9, 9.62514e+02, 3.1623e+01 },
  {  7,  9, 9.87254e+02, 3.1623e+01 },
  {  8,  9, 9.75261e+02, 3.1654e+01 },
  {  9,  9, 1.05784e+03, 3.1663e+01 },
  { 10,  9, 1.02398e+03, 3.1675e+01 },
  { 11,  9, 9.72272e+02, 3.1691e+01 },
  { 12,  9, 1.02771e+03, 3.1711e+01 },
  { 13,  9, 1.00025e+03, 3.1735e+01 },
  { 14,  9, 9.42616e+02, 3.1763e+01 },
  { 15,  9, 1.03947e+03, 3.1793e+01 },
  { 16,  9, 9.83491e+02, 3.1823e+01 },
  { 17,  9, 1.01758e+03, 3.1849e+01 },
  { 18,  9, 1.02553e+03, 3.1867e+01 },
  { 19,  9, 1.01195e+03, 3.1873e+01 },
  { 20,  9, 9.74899e+02, 3.1867e+01 },
  { 21,  9, 9.87655e+02, 3.1849e+01 },
  { 22,  9, 9.88392e+02, 3.1823e+01 },
  { 23,  9, 1.04023e+03, 3.1793e+01 },
  { 24,  9, 1.01907e+03, 3.1763e+01 },
  { 25,  9, 1.04368e+03, 3.1735e+01 },
  { 26,  9, 1.01782e+03, 3.1711e+01 },
  { 27,  9, 1.01349e+03, 3.1691e+01 },
  { 28,  9, 9.73292e+02, 3.1675e+01 },
  { 29,  9, 1.01367e+03, 3.1663e+01 },
  { 30,  9, 1.00925e+03, 3.1654e+01 },
  { 31,  9, 1.01598e+03, 3.1623e+01 },
  { 32,  9, 1.03210e+03, 3.1623e+01 },
  { 33,  9, 1.02658e+03, 3.1623e+01 },
  { 34,  9, 1.02480e+03, 3.1623e+01 },
  { 35,  9, 1.01651e+03, 3.1623e+01 },
  { 36,  9, 9.49018e+02, 3.1623e+01 },
  { 37,  9, 1.00064e+03, 3.1623e+01 },
  { 38,  9, 1.03124e+03, 3.1623e+01 },
  {  1, 10, 9.75107e+02, 3.1623e+01 },
  {  2, 10, 9.79347e+02, 3.1623e+01 },
  {  3, 10, 9.88188e+02, 3.1623e+01 },
  {  4, 10, 9.67930e+02, 3.1623e+01 },
  {  5, 10, 9.72670e+02, 3.1623e+01 },
  {  6, 10, 1.03132e+03, 3.1623e+01 },
  {  7, 10, 9.92108e+02, 3.1652e+01 },
  {  8, 10, 1.02731e+03, 3.1662e+01 },
  {  9, 10, 1.01677e+03, 3.1675e+01 },
  { 10, 10, 1.00301e+03, 3.1693e+01 },
  { 11, 10, 9.79762e+02, 3.1718e+01 },
  { 12, 10, 9.75181e+02, 3.1749e+01 },
  { 13, 10, 1.01479e+03, 3.1789e+01 },
  { 14, 10, 1.06444e+03, 3.1838e+01 },
  { 15, 10, 1.01398e+03, 3.1894e+01 },
  { 16, 10, 1.01684e+03, 3.1952e+01 },
  { 17, 10, 9.91867e+02, 3.2005e+01 },
  { 18, 10, 9.81783e+02, 3.2041e+01 },
  { 19, 10, 1.02914e+03, 3.2055e+01 },
  { 20, 10, 1.00158e+03, 3.2041e+01 },
  { 21, 10, 1.01338e+03, 3.2005e+01 },
  { 22, 10, 1.02210e+03, 3.1952e+01 },
  { 23, 10, 9.44783e+02, 3.1894e+01 },
  { 24, 10, 9.98964e+02, 3.1838e+01 },
  { 25, 10, 9.83188e+02, 3.1789e+01 },
  { 26, 10, 1.00952e+03, 3.1749e+01 },
  { 27, 10, 1.00127e+03, 3.1718e+01 },
  { 28, 10, 9.75215e+02, 3.1693e+01 },
  { 29, 10, 9.90025e+02, 3.1675e+01 },
  { 30, 10, 9.99252e+02, 3.1662e+01 },
  { 31, 10, 1.01368e+03, 3.1652e+01 },
  { 32, 10, 9.95400e+02, 3.1623e+01 },
  { 33, 10, 1.02702e+03, 3.1623e+01 },
  { 34, 10, 1.06712e+03, 3.1623e+01 },
  { 35, 10, 1.01926e+03, 3.1623e+01 },
  { 36, 10, 1.00684e+03, 3.1623e+01 },
  { 37, 10, 9.93998e+02, 3.1623e+01 },
  { 38, 10, 9.58852e+02, 3.1623e+01 },
  {  1, 11, 1.04044e+03, 3.1623e+01 },
  {  2, 11, 1.02427e+03, 3.1623e+01 },
  {  3, 11, 9.67688e+02, 3.1623e+01 },
  {  4, 11, 1.04892e+03, 3.1623e+01 },
  {  5, 11, 9.82289e+02, 3.1623e+01 },
  {  6, 11, 9.96420e+02, 3.1650e+01 },
  {  7, 11, 1.03122e+03, 3.1659e+01 },
  {  8, 11, 9.83491e+02, 3.1672e+01 },
  {  9, 11, 1.02991e+03, 3.1691e+01 },
  { 10, 11, 1.04083e+03, 3.1718e+01 },
  { 11, 11, 1.04342e+03, 3.1754e+01 },
  { 12, 11, 1.01811e+03, 3.1805e+01 },
  { 13, 11, 9.96845e+02, 3.1873e+01 },
  { 14, 11, 1.03344e+03, 3.1961e+01 },
  { 15, 11, 1.02728e+03, 3.2074e+01 },
  { 16, 11, 1.09286e+03, 3.2192e+01 },
  { 17, 11, 1.06522e+03, 3.2306e+01 },
  { 18, 11, 9.97589e+02, 3.2389e+01 },
  { 19, 11, 1.05054e+03, 3.2419e+01 },
  { 20, 11, 1.03598e+03, 3.2389e+01 },
  { 21, 11, 1.03755e+03, 3.2306e+01 },
  { 22, 11, 1.01061e+03, 3.2192e+01 },
  { 23, 11, 1.02348e+03, 3.2074e+01 },
  { 24, 11, 1.04470e+03, 3.1961e+01 },
  { 25, 11, 1.00811e+03, 3.1873e+01 },
  { 26, 11, 1.02033e+03, 3.1805e+01 },
  { 27, 11, 9.84214e+02, 3.1754e+01 },
  { 28, 11, 9.75399e+02, 3.1718e+01 },
  { 29, 11, 9.70039e+02, 3.1691e+01 },
  { 30, 11, 9.81401e+02, 3.1672e+01 },
  { 31, 11, 9.91381e+02, 3.1659e+01 },
  { 32, 11, 9.99700e+02, 3.1650e+01 },
  { 33, 11, 9.13746e+02, 3.1623e+01 },
  { 34, 11, 9.79316e+02, 3.1623e+01 },
  { 35, 11, 1.02034e+03, 3.1623e+01 },
  { 36, 11, 1.08147e+03, 3.1623e+01 },
  { 37, 11, 1.03753e+03, 3.1623e+01 },
  { 38, 11, 9.97205e+02, 3.1623e+01 },
  {  1, 12, 1.02906e+03, 3.1623e+01 },
  {  2, 12, 9.80797e+02, 3.1623e+01 },
  {  3, 12, 9.65776e+02, 3.1623e+01 },
  {  4, 12, 9.71394e+02, 3.1623e+01 },
  {  5, 12, 9.92795e+02, 3.1623e+01 },
  {  6, 12, 1.01701e+03, 3.1655e+01 },
  {  7, 12, 1.02193e+03, 3.1667e+01 },
  {  8, 12, 9.48284e+02, 3.1685e+01 },
  {  9, 12, 9.73344e+02, 3.1711e+01 },
  { 10, 12, 9.96870e+02, 3.1749e+01 },
  { 11, 12, 1.03810e+03, 3.1805e+01 },
  { 12, 12, 1.04080e+03, 3.1887e+01 },
  { 13, 12, 1.02787e+03, 3.2005e+01 },
  { 14, 12, 1.01457e+03, 3.2173e+01 },
  { 15, 12, 1.00559e+03, 3.2390e+01 },
  { 16, 12, 1.05571e+03, 3.2648e+01 },
  { 17, 12, 1.00867e+03, 3.2910e+01 },
  { 18, 12, 1.06921e+03, 3.3112e+01 },
  { 19, 12, 1.06756e+03, 3.3187e+01 },
  { 20, 12, 1.09330e+03, 3.3112e+01 },
  { 21, 12, 1.05208e+03, 3.2910e+01 },
  { 22, 12, 1.09207e+03, 3.2648e+01 },
  { 23, 12, 1.06053e+03, 3.2390e+01 },
  { 24, 12, 1.02256e+03, 3.2173e+01 },
  { 25, 12, 1.04954e+03, 3.2005e+01 },
  { 26, 12, 1.04185e+03, 3.1887e+01 },
  { 27, 12, 1.04418e+03, 3.1805e+01 },
  { 28, 12, 1.05135e+03, 3.1749e+01 },
  { 29, 12, 9.21197e+02, 3.1711e+01 },
  { 30, 12, 1.00396e+03, 3.1685e+01 },
  { 31, 12, 1.01055e+03, 3.1667e+01 },
  { 32, 12, 9.89712e+02, 3.1655e+01 },
  { 33, 12, 9.92044e+02, 3.1623e+01 },
  { 34, 12, 1.02742e+03, 3.1623e+01 },
  { 35, 12, 1.02233e+03, 3.1623e+01 },
  { 36, 12, 1.00643e+03, 3.1623e+01 },
  { 37, 12, 1.03810e+03, 3.1623e+01 },
  { 38, 12, 1.01928e+03, 3.1623e+01 },
  {  1, 13, 9.75950e+02, 3.1623e+01 },
  {  2, 13, 1.02373e+03, 3.1623e+01 },
  {  3, 13, 1.02690e+03, 3.1623e+01 },
  {  4, 13, 9.70481e+02, 3.1623e+01 },
  {  5, 13, 9.46113e+02, 3.1650e+01 },
  {  6, 13, 1.01263e+03, 3.1661e+01 },
  {  7, 13, 1.02883e+03, 3.1676e+01 },
  {  8, 13, 9.68113e+02, 3.1700e+01 },
  {  9, 13, 1.01147e+03, 3.1735e+01 },
  { 10, 13, 1.01630e+03, 3.1789e+01 },
  { 11, 13, 1.03246e+03, 3.1873e+01 },
  { 12, 13, 1.00639e+03, 3.2005e+01 },
  { 13, 13, 1.07995e+03, 3.2213e+01 },
  { 14, 13, 1.06830e+03, 3.2527e+01 },
  { 15, 13, 1.06485e+03, 3.2974e+01 },
  { 16, 13, 1.19160e+03, 3.3553e+01 },
  { 17, 13, 1.22480e+03, 3.4197e+01 },
  { 18, 13, 1.21106e+03, 3.4727e+01 },
  { 19, 13, 1.22535e+03, 3.4931e+01 },
  { 20, 13, 1.20677e+03, 3.4727e+01 },
  { 21, 13, 1.19098e+03, 3.4197e+01 },
  { 22, 13, 1.17942e+03, 3.3553e+01 },
  { 23, 13, 1.10711e+03, 3.2974e+01 },
  { 24, 13, 1.00834e+03, 3.2527e+01 },
  { 25, 13, 1.02961e+03, 3.2213e+01 },
  { 26, 13, 1.04166e+03, 3.2005e+01 },
  { 27, 13, 9.93849e+02, 3.1873e+01 },
  { 28, 13, 9.63960e+02, 3.1789e+01 },
  { 29, 13, 1.00952e+03, 3.1735e+01 },
  { 30, 13, 1.02980e+03, 3.1700e+01 },
  { 31, 13, 1.03745e+03, 3.1676e+01 },
  { 32, 13, 1.01016e+03, 3.1661e+01 },
  { 33, 13, 1.02043e+03, 3.1650e+01 },
  { 34, 13, 9.97452e+02, 3.1623e+01 },
  { 35, 13, 1.03910e+03, 3.1623e+01 },
  { 36, 13, 1.10110e+03, 3.1623e+01 },
  { 37, 13, 9.95857e+02, 3.1623e+01 },
  { 38, 13, 1.00406e+03, 3.1623e+01 },
  {  1, 14, 1.00783e+03, 3.1623e+01 },
  {  2, 14, 1.01615e+03, 3.1623e+01 },
  {  3, 14, 9.91679e+02, 3.1623e+01 },
  {  4, 14, 1.00655e+03, 3.1623e+01 },
  {  5, 14, 1.00677e+03, 3.1654e+01 },
  {  6, 14, 9.67408e+02, 3.1667e+01 },
  {  7, 14, 9.99663e+02, 3.1686e+01 },
  {  8, 14, 9.81928e+02, 3.1715e+01 },
  {  9, 14, 9.99624e+02, 3.1763e+01 },
  { 10, 14, 1.01623e+03, 3.1838e+01 },
  { 11, 14, 1.04930e+03, 3.1961e+01 },
  { 12, 14, 1.06260e+03, 3.2173e+01 },
  { 13, 14, 1.07837e+03, 3.2527e+01 },
  { 14, 14, 1.09451e+03, 3.3113e+01 },
  { 15, 14, 1.12128e+03, 3.4047e+01 },
  { 16, 14, 1.25846e+03, 3.5415e+01 },
  { 17, 14, 1.32962e+03, 3.7095e+01 },
  { 18, 14, 1.47342e+03, 3.8595e+01 },
  { 19, 14, 1.49597e+03, 3.9203e+01 },
  { 20, 14, 1.49359e+03, 3.8595e+01 },
  { 21, 14, 1.39327e+03, 3.7095e+01 },
  { 22, 14, 1.20103e+03, 3.5415e+01 },
  { 23, 14, 1.12389e+03, 3.4047e+01 },
  { 24, 14, 1.06076e+03, 3.3113e+01 },
  { 25, 14, 1.03040e+03, 3.2527e+01 },
  { 26, 14, 1.04648e+03, 3.2173e+01 },
  { 27, 14, 1.01922e+03, 3.1961e+01 },
  { 28, 14, 9.64045e+02, 3.1838e+01 },
  { 29, 14, 1.00364e+03, 3.1763e+01 },
  { 30, 14, 9.54606e+02, 3.1715e+01 },
  { 31, 14, 1.02130e+03, 3.1686e+01 },
  { 32, 14, 1.00084e+03, 3.1667e+01 },
  { 33, 14, 9.87825e+02, 3.1654e+01 },
  { 34, 14, 1.02822e+03, 3.1623e+01 },
  { 35, 14, 1.03307e+03, 3.1623e+01 },
  { 36, 14, 1.01768e+03, 3.1623e+01 },
  { 37, 14, 9.58054e+02, 3.1623e+01 },
  { 38, 14, 1.00322e+03, 3.1623e+01 },
  {  1, 15, 1.05171e+03, 3.1623e+01 },
  {  2, 15, 9.68861e+02, 3.1623e+01 },
  {  3, 15, 1.00814e+03, 3.1623e+01 },
  {  4, 15, 1.06429e+03, 3.1623e+01 },
  {  5, 15, 9.71514e+02, 3.1657e+01 },
  {  6, 15, 1.07324e+03, 3.1672e+01 },
  {  7, 15, 9.56787e+02, 3.1696e+01 },
  {  8, 15, 9.43357e+02, 3.1733e+01 },
  {  9, 15, 1.02216e+03, 3.1793e+01 },
  { 10, 15, 1.04029e+03, 3.1894e+01 },
  { 11, 15, 1.01873e+03, 3.2074e+01 },
  { 12, 15, 1.06062e+03, 3.2390e+01 },
  { 13, 15, 1.09388e+03, 3.2974e+01 },
  { 14, 15, 1.15086e+03, 3.4047e+01 },
  { 15, 15, 1.32655e+03, 3.5989e+01 },
  { 16, 15, 1.45900e+03, 3.9227e+01 },
  { 17, 15, 1.95952e+03, 4.3749e+01 },
  { 18, 15, 2.43064e+03, 4.8252e+01 },
  { 19, 15, 2.59773e+03, 5.0217e+01 },
  { 20, 15, 2.27346e+03, 4.8252e+01 },
  { 21, 15, 1.94318e+03, 4.3749e+01 },
  { 22, 15, 1.55663e+03, 3.9227e+01 },
  { 23, 15, 1.33300e+03, 3.5989e+01 },
  { 24, 15, 1.16813e+03, 3.4047e+01 },
  { 25, 15, 1.15591e+03, 3.2974e+01 },
  { 26, 15, 1.06262e+03, 3.2390e+01 },
  { 27, 15, 1.08233e+03, 3.2074e+01 },
  { 28, 15, 9.61977e+02, 3.1894e+01 },
  { 29, 15, 9.87663e+02, 3.1793e+01 },
  { 30, 15, 1.04999e+03, 3.1733e+01 },
  { 31, 15, 1.03902e+03, 3.1696e+01 },
  { 32, 15, 9.61583e+02, 3.1672e+01 },
  { 33, 15, 1.03726e+03, 3.1657e+01 },
  { 34, 15, 9.81816e+02, 3.1623e+01 },
  { 35, 15, 1.01400e+03, 3.1623e+01 },
  { 36, 15, 1.02615e+03, 3.1623e+01 },
  { 37, 15, 9.91908e+02, 3.1623e+01 },
  { 38, 15, 1.03171e+03, 3.1623e+01 },
  {  1, 16, 1.01217e+03, 3.1623e+01 },
  {  2, 16, 1.01061e+03, 3.1623e+01 },
  {  3, 16, 9.55311e+02, 3.1623e+01 },
  {  4, 16, 1.02684e+03, 3.1649e+01 },
  {  5, 16, 1.00756e+03, 3.1661e+01 },
  {  6, 16, 1.03637e+03, 3.1678e+01 },
  {  7, 16, 1.00017e+03, 3.1705e+01 },
  {  8, 16, 1.01804e+03, 3.1749e+01 },
  {  9, 16, 1.08091e+03, 3.1823e+01 },
  { 10, 16, 1.02705e+03, 3.1952e+01 },
  { 11, 16, 1.02255e+03, 3.2192e+01 },
  { 12, 16, 1.04837e+03, 3.2648e+01 },
  { 13, 16, 1.11165e+03, 3.3553e+01 },
  { 14, 16, 1.27279e+03, 3.5415e+01 },
  { 15, 16, 1.49962e+03, 3.9227e+01 },
  { 16, 16, 2.21094e+03, 4.6553e+01 },
  { 17, 16, 3.41664e+03, 5.8424e+01 },
  { 18, 16, 5.11274e+03, 7.1987e+01 },
  { 19, 16, 6.18356e+03, 7.8453e+01 },
  { 20, 16, 5.25710e+03, 7.1987e+01 },
  { 21, 16, 3.31292e+03, 5.8424e+01 },
  { 22, 16, 2.19709e+03, 4.6553e+01 },
  { 23, 16, 1.56694e+03, 3.9227e+01 },
  { 24, 16, 1.20829e+03, 3.5414e+01 },
  { 25, 16, 1.16164e+03, 3.3553e+01 },
  { 26, 16, 1.06995e+03, 3.2648e+01 },
  { 27, 16, 9.86572e+02, 3.2192e+01 },
  { 28, 16, 9.74590e+02, 3.1952e+01 },
  { 29, 16, 9.96302e+02, 3.1823e+01 },
  { 30, 16, 9.83693e+02, 3.1749e+01 },
  { 31, 16, 1.03272e+03, 3.1705e+01 },
  { 32, 16, 1.02250e+03, 3.1678e+01 },
  { 33, 16, 1.01124e+03, 3.1661e+01 },
  { 34, 16, 1.00747e+03, 3.1649e+01 },
  { 35, 16, 1.04950e+03, 3.1623e+01 },
  { 36, 16, 9.42029e+02, 3.1623e+01 },
  { 37, 16, 1.03392e+03, 3.1623e+01 },
  { 38, 16, 1.00213e+03, 3.1623e+01 },
  {  1, 17, 1.00034e+03, 3.1623e+01 },
  {  2, 17, 1.00267e+03, 3.1623e+01 },
  {  3, 17, 1.03566e+03, 3.1623e+01 },
  {  4, 17, 9.84503e+02, 3.1651e+01 },
  {  5, 17, 1.08587e+03, 3.1663e+01 },
  {  6, 17, 9.82115e+02, 3.1682e+01 },
  {  7, 17, 1.03517e+03, 3.1712e+01 },
  {  8, 17, 1.06443e+03, 3.1763e+01 },
  {  9, 17, 1.02199e+03, 3.1849e+01 },
  { 10, 17, 1.04373e+03, 3.2005e+01 },
  { 11, 17, 9.90138e+02, 3.2306e+01 },
  { 12, 17, 1.09010e+03, 3.2910e+01 },
  { 13, 17, 1.19721e+03, 3.4197e+01 },
  { 14, 17, 1.35548e+03, 3.7095e+01 },
  { 15, 17, 1.89524e+03, 4.3749e+01 },
  { 16, 17, 3.35090e+03, 5.8424e+01 },
  { 17, 17, 7.50606e+03, 8.6597e+01 },
  { 18, 17, 1.59049e+04, 1.2572e+02 },
  { 19, 17, 2.16568e+04, 1.4729e+02 },
  { 20, 17, 1.56122e+04, 1.2572e+02 },
  { 21, 17, 7.52309e+03, 8.6597e+01 },
  { 22, 17, 3.37495e+03, 5.8424e+01 },
  { 23, 17, 1.91293e+03, 4.3749e+01 },
  { 24, 17, 1.35280e+03, 3.7095e+01 },
  { 25, 17, 1.21491e+03, 3.4197e+01 },
  { 26, 17, 1.12304e+03, 3.2910e+01 },
  { 27, 17, 1.09461e+03, 3.2306e+01 },
  { 28, 17, 9.71554e+02, 3.2005e+01 },
  { 29, 17, 1.05786e+03, 3.1849e+01 },
  { 30, 17, 1.02458e+03, 3.1763e+01 },
  { 31, 17, 9.97912e+02, 3.1712e+01 },
  { 32, 17, 1.01219e+03, 3.1682e+01 },
  { 33, 17, 1.02355e+03, 3.1663e+01 },
  { 34, 17, 9.93825e+02, 3.1651e+01 },
  { 35, 17, 1.00790e+03, 3.1623e+01 },
  { 36, 17, 1.00305e+03, 3.1623e+01 },
  { 37, 17, 9.97221e+02, 3.1623e+01 },
  { 38, 17, 1.01533e+03, 3.1623e+01 },
  {  1, 18, 9.85903e+02, 3.1623e+01 },
  {  2, 18, 9.61033e+02, 3.1623e+01 },
  {  3, 18, 1.05784e+03, 3.1623e+01 },
  {  4, 18, 1.03042e+03, 3.1652e+01 },
  {  5, 18, 1.00432e+03, 3.1665e+01 },
  {  6, 18, 9.70222e+02, 3.1685e+01 },
  {  7, 18, 9.76843e+02, 3.1718e+01 },
  {  8, 18, 1.05367e+03, 3.1772e+01 },
  {  9, 18, 1.04172e+03, 3.1867e+01 },
  { 10, 18, 1.00568e+03, 3.2041e+01 },
  { 11, 18, 1.01071e+03, 3.2389e+01 },
  { 12, 18, 1.09852e+03, 3.3112e+01 },
  { 13, 18, 1.20773e+03, 3.4727e+01 },
  { 14, 18, 1.43199e+03, 3.8595e+01 },
  { 15, 18, 2.39572e+03, 4.8252e+01 },
  { 16, 18, 5.25011e+03, 7.1987e+01 },
  { 17, 18, 1.56734e+04, 1.2572e+02 },
  { 18, 18, 4.83465e+04, 2.1897e+02 },
  { 19, 18, 7.87516e+04, 2.8025e+02 },
  { 20, 18, 4.81722e+04, 2.1897e+02 },
  { 21, 18, 1.56798e+04, 1.2572e+02 },
  { 22, 18, 5.21880e+03, 7.1987e+01 },
  { 23, 18, 2.27262e+03, 4.8252e+01 },
  { 24, 18, 1.55171e+03, 3.8595e+01 },
  { 25, 18, 1.21723e+03, 3.4727e+01 },
  { 26, 18, 1.06283e+03, 3.3112e+01 },
  { 27, 18, 1.07661e+03, 3.2389e+01 },
  { 28, 18, 1.05412e+03, 3.2041e+01 },
  { 29, 18, 1.06717e+03, 3.1867e+01 },
  { 30, 18, 1.03720e+03, 3.1772e+01 },
  { 31, 18, 1.02697e+03, 3.1718e+01 },
  { 32, 18, 1.06430e+03, 3.1685e+01 },
  { 33, 18, 1.04150e+03, 3.1665e+01 },
  { 34, 18, 1.02012e+03, 3.1652e+01 },
  { 35, 18, 9.72127e+02, 3.1623e+01 },
  { 36, 18, 9.92295e+02, 3.1623e+01 },
  { 37, 18, 9.80241e+02, 3.1623e+01 },
  { 38, 18, 9.40112e+02, 3.1623e+01 },
  {  1, 19, 9.94110e+02, 3.1623e+01 },
  {  2, 19, 9.82672e+02, 3.1623e+01 },
  {  3, 19, 9.96757e+02, 3.1623e+01 },
  {  4, 19, 9.64596e+02, 3.1652e+01 },
  {  5, 19, 1.04570e+03, 3.1666e+01 },
  {  6, 19, 9.67998e+02, 3.1686e+01 },
  {  7, 19, 9.50136e+02, 3.1719e+01 },
  {  8, 19, 1.00829e+03, 3.1775e+01 },
  {  9, 19, 9.74511e+02, 3.1873e+01 },
  { 10, 19, 1.02069e+03, 3.2055e+01 },
  { 11, 19, 1.15525e+03, 3.2419e+01 },
  { 12, 19, 1.07554e+03, 3.3187e+01 },
  { 13, 19, 1.20045e+03, 3.4931e+01 },
  { 14, 19, 1.48763e+03, 3.9203e+01 },
  { 15, 19, 2.53019e+03, 5.0217e+01 },
  { 16, 19, 6.16310e+03, 7.8453e+01 },
  { 17, 19, 2.17700e+04, 1.4729e+02 },
  { 18, 19, 7.87397e+04, 2.8025e+02 },
  { 19, 19, 1.41160e+05, 3.7556e+02 },
  { 20, 19, 7.84123e+04, 2.8025e+02 },
  { 21, 19, 2.15020e+04, 1.4729e+02 },
  { 22, 19, 6.20348e+03, 7.8453e+01 },
  { 23, 19, 2.47270e+03, 5.0217e+01 },
  { 24, 19, 1.53436e+03, 3.9203e+01 },
  { 25, 19, 1.20164e+03, 3.4931e+01 },
  { 26, 19, 1.06615e+03, 3.3187e+01 },
  { 27, 19, 1.05394e+03, 3.2419e+01 },
  { 28, 19, 1.01728e+03, 3.2055e+01 },
  { 29, 19, 1.02395e+03, 3.1873e+01 },
  { 30, 19, 1.04749e+03, 3.1775e+01 },
  { 31, 19, 9.97814e+02, 3.1719e+01 },
  { 32, 19, 1.05414e+03, 3.1686e+01 },
  { 33, 19, 1.01451e+03, 3.1666e+01 },
  { 34, 19, 9.80127e+02, 3.1652e+01 },
  { 35, 19, 1.04091e+03, 3.1623e+01 },
  { 36, 19, 9.97406e+02, 3.1623e+01 },
  { 37, 19, 1.02330e+03, 3.1623e+01 },
  { 38, 19, 9.88783e+02, 3.1623e+01 },
  {  1, 20, 1.00099e+03, 3.1623e+01 },
  {  2, 20, 1.01597e+03, 3.1623e+01 },
  {  3, 20, 1.00908e+03, 3.1623e+01 },
  {  4, 20, 1.04369e+03, 3.1652e+01 },
  {  5, 20, 1.05301e+03, 3.1665e+01 },
  {  6, 20, 1.02056e+03, 3.1685e+01 },
  {  7, 20, 1.00798e+03, 3.1718e+01 },
  {  8, 20, 1.05603e+03, 3.1772e+01 },
  {  9, 20, 1.02412e+03, 3.1867e+01 },
  { 10, 20, 1.03430e+03, 3.2041e+01 },
  { 11, 20, 1.07935e+03, 3.2389e+01 },
  { 12, 20, 1.06561e+03, 3.3112e+01 },
  { 13, 20, 1.21639e+03, 3.4727e+01 },
  { 14, 20, 1.41103e+03, 3.8595e+01 },
  { 15, 20, 2.29826e+03, 4.8252e+01 },
  { 16, 20, 5.09050e+03, 7.1987e+01 },
  { 17, 20, 1.59753e+04, 1.2572e+02 },
  { 18, 20, 4.79509e+04, 2.1897e+02 },
  { 19, 20, 7.84076e+04, 2.8025e+02 },
  { 20, 20, 4.81999e+04, 2.1897e+02 },
  { 21, 20, 1.59230e+04, 1.2572e+02 },
  { 22, 20, 5.22938e+03, 7.1987e+01 },
  { 23, 20, 2.31928e+03, 4.8252e+01 },
  { 24, 20, 1.60549e+03, 3.8595e+01 },
  { 25, 20, 1.17038e+03, 3.4727e+01 },
  { 26, 20, 1.10249e+03, 3.3112e+01 },
  { 27, 20, 1.00277e+03, 3.2389e+01 },
  { 28, 20, 1.03041e+03, 3.2041e+01 },
  { 29, 20, 9.64527e+02, 3.1867e+01 },
  { 30, 20, 9.76224e+02, 3.1772e+01 },
  { 31, 20, 9.58853e+02, 3.1718e+01 },
  { 32, 20, 1.02438e+03, 3.1685e+01 },
  { 33, 20, 1.01178e+03, 3.1665e+01 },
  { 34, 20, 9.79744e+02, 3.1652e+01 },
  { 35, 20, 1.04624e+03, 3.1623e+01 },
  { 36, 20, 1.01033e+03, 3.1623e+01 },
  { 37, 20, 9.83818e+02, 3.1623e+01 },
  { 38, 20, 1.01934e+03, 3.1623e+01 },
  {  1, 21, 9.94818e+02, 3.1623e+01 },
  {  2, 21, 9.53438e+02, 3.1623e+01 },
  {  3, 21, 9.77859e+02, 3.1623e+01 },
  {  4, 21, 1.00560e+03, 3.1651e+01 },
  {  5, 21, 1.01324e+03, 3.1663e+01 },
  {  6, 21, 9.74737e+02, 3.1682e+01 },
  {  7, 21, 1.02513e+03, 3.1712e+01 },
  {  8, 21, 1.02699e+03, 3.1763e+01 },
  {  9, 21, 1.02122e+03, 3.1849e+01 },
  { 10, 21, 1.01933e+03, 3.2005e+01 },
  { 11, 21, 9.80726e+02, 3.2306e+01 },
  { 12, 21, 1.08415e+03, 3.2910e+01 },
  { 13, 21, 1.16779e+03, 3.4197e+01 },
  { 14, 21, 1.35714e+03, 3.7095e+01 },
  { 15, 21, 1.91073e+03, 4.3749e+01 },
  { 16, 21, 3.38295e+03, 5.8424e+01 },
  { 17, 21, 7.48872e+03, 8.6597e+01 },
  { 18, 21, 1.58747e+04, 1.2572e+02 },
  { 19, 21, 2.20411e+04, 1.4729e+02 },
  { 20, 21, 1.60692e+04, 1.2572e+02 },
  { 21, 21, 7.30709e+03, 8.6597e+01 },
  { 22, 21, 3.39633e+03, 5.8424e+01 },
  { 23, 21, 1.85064e+03, 4.3749e+01 },
  { 24, 21, 1.32381e+03, 3.7095e+01 },
  { 25, 21, 1.11802e+03, 3.4197e+01 },
  { 26, 21, 1.09051e+03, 3.2910e+01 },
  { 27, 21, 1.00186e+03, 3.2306e+01 },
  { 28, 21, 1.04616e+03, 3.2005e+01 },
  { 29, 21, 9.83954e+02, 3.1849e+01 },
  { 30, 21, 9.73630e+02, 3.1763e+01 },
  { 31, 21, 1.00850e+03, 3.1712e+01 },
  { 32, 21, 9.78397e+02, 3.1682e+01 },
  { 33, 21, 1.00449e+03, 3.1663e+01 },
  { 34, 21, 9.70367e+02, 3.1651e+01 },
  { 35, 21, 1.02961e+03, 3.1623e+01 },
  { 36, 21, 1.03783e+03, 3.1623e+01 },
  { 37, 21, 1.07117e+03, 3.1623e+01 },
  { 38, 21, 9.93414e+02, 3.1623e+01 },
  {  1, 22, 1.04797e+03, 3.1623e+01 },
  {  2, 22, 9.88318e+02, 3.1623e+01 },
  {  3, 22, 1.01238e+03, 3.1623e+01 },
  {  4, 22, 9.82534e+02, 3.1649e+01 },
  {  5, 22, 9.44979e+02, 3.1661e+01 },
  {  6, 22, 1.06079e+03, 3.1678e+01 },
  {  7, 22, 1.01006e+03, 3.1705e+01 },
  {  8, 22, 1.06676e+03, 3.1749e+01 },
  {  9, 22, 1.04477e+03, 3.1823e+01 },
  { 10, 22, 1.00474e+03, 3.1952e+01 },
  { 11, 22, 1.01816e+03, 3.2192e+01 },
  { 12, 22, 1.10509e+03, 3.2648e+01 },
  { 13, 22, 1.10415e+03, 3.3553e+01 },
  { 14, 22, 1.26737e+03, 3.5415e+01 },
  { 15, 22, 1.55096e+03, 3.9227e+01 },
  { 16, 22, 2.19303e+03, 4.6553e+01 },
  { 17, 22, 3.31397e+03, 5.8424e+01 },
  { 18, 22, 5.08418e+03, 7.1987e+01 },
  { 19, 22, 6.18876e+03, 7.8453e+01 },
  { 20, 22, 5.09826e+03, 7.1987e+01 },
  { 21, 22, 3.41139e+03, 5.8424e+01 },
  { 22, 22, 2.28673e+03, 4.6553e+01 },
  { 23, 22, 1.45966e+03, 3.9227e+01 },
  { 24, 22, 1.31644e+03, 3.5414e+01 },
  { 25, 22, 1.05093e+03, 3.3553e+01 },
  { 26, 22, 1.03659e+03, 3.2648e+01 },
  { 27, 22, 1.00498e+03, 3.2192e+01 },
  { 28, 22, 1.06795e+03, 3.1952e+01 },
  { 29, 22, 1.06221e+03, 3.1823e+01 },
  { 30, 22, 9.83785e+02, 3.1749e+01 },
  { 31, 22, 1.00636e+03, 3.1705e+01 },
  { 32, 22, 1.02468e+03, 3.1678e+01 },
  { 33, 22, 9.76521e+02, 3.1661e+01 },
  { 34, 22, 1.00414e+03, 3.1649e+01 },
  { 35, 22, 1.04106e+03, 3.1623e+01 },
  { 36, 22, 9.91903e+02, 3.1623e+01 },
  { 37, 22, 1.04806e+03, 3.1623e+01 },
  { 38, 22, 1.02334e+03, 3.1623e+01 },
  {  1, 23, 9.82258e+02, 3.1623e+01 },
  {  2, 23, 9.73443e+02, 3.1623e+01 },
  {  3, 23, 1.02634e+03, 3.1623e+01 },
  {  4, 23, 9.60852e+02, 3.1623e+01 },
  {  5, 23, 9.34996e+02, 3.1657e+01 },
  {  6, 23, 9.76903e+02, 3.1672e+01 },
  {  7, 23, 1.04372e+03, 3.1696e+01 },
  {  8, 23, 9.94942e+02, 3.1733e+01 },
  {  9, 23, 9.87612e+02, 3.1793e+01 },
  { 10, 23, 1.04588e+03, 3.1894e+01 },
  { 11, 23, 9.76720e+02, 3.2074e+01 },
  { 12, 23, 1.06107e+03, 3.2390e+01 },
  { 13, 23, 1.15103e+03, 3.2974e+01 },
  { 14, 23, 1.14053e+03, 3.4047e+01 },
  { 15, 23, 1.30126e+03, 3.5989e+01 },
  { 16, 23, 1.56384e+03, 3.9227e+01 },
  { 17, 23, 1.97120e+03, 4.3749e+01 },
  { 18, 23, 2.25830e+03, 4.8252e+01 },
  { 19, 23, 2.49664e+03, 5.0217e+01 },
  { 20, 23, 2.32692e+03, 4.8252e+01 },
  { 21, 23, 1.92092e+03, 4.3749e+01 },
  { 22, 23, 1.48986e+03, 3.9227e+01 },
  { 23, 23, 1.23462e+03, 3.5989e+01 },
  { 24, 23, 1.15740e+03, 3.4047e+01 },
  { 25, 23, 1.10317e+03, 3.2974e+01 },
  { 26, 23, 1.01826e+03, 3.2390e+01 },
  { 27, 23, 1.07458e+03, 3.2074e+01 },
  { 28, 23, 9.97387e+02, 3.1894e+01 },
  { 29, 23, 1.05106e+03, 3.1793e+01 },
  { 30, 23, 9.69131e+02, 3.1733e+01 },
  { 31, 23, 9.97326e+02, 3.1696e+01 },
  { 32, 23, 1.00693e+03, 3.1672e+01 },
  { 33, 23, 1.03309e+03, 3.1657e+01 },
  { 34, 23, 1.02295e+03, 3.1623e+01 },
  { 35, 23, 9.83104e+02, 3.1623e+01 },
  { 36, 23, 9.76576e+02, 3.1623e+01 },
  { 37, 23, 9.71478e+02, 3.1623e+01 },
  { 38, 23, 1.02703e+03, 3.1623e+01 },
  {  1, 24, 9.63289e+02, 3.1623e+01 },
  {  2, 24, 9.88623e+02, 3.1623e+01 },
  {  3, 24, 9.86679e+02, 3.1623e+01 },
  {  4, 24, 9.69670e+02, 3.1623e+01 },
  {  5, 24, 9.77021e+02, 3.1654e+01 },
  {  6, 24, 1.02196e+03, 3.1667e+01 },
  {  7, 24, 9.54644e+02, 3.1686e+01 },
  {  8, 24, 1.04736e+03, 3.1715e+01 },
  {  9, 24, 1.00249e+03, 3.1763e+01 },
  { 10, 24, 1.04990e+03, 3.1838e+01 },
  { 11, 24, 1.04301e+03, 3.1961e+01 },
  { 12, 24, 1.02697e+03, 3.2173e+01 },
  { 13, 24, 1.06976e+03, 3.2527e+01 },
  { 14, 24, 1.07195e+03, 3.3113e+01 },
  { 15, 24, 1.19759e+03, 3.4047e+01 },
  { 16, 24, 1.21750e+03, 3.5414e+01 },
  { 17, 24, 1.37007e+03, 3.7095e+01 },
  { 18, 24, 1.48350e+03, 3.8595e+01 },
  { 19, 24, 1.53338e+03, 3.9203e+01 },
  { 20, 24, 1.48861e+03, 3.8595e+01 },
  { 21, 24, 1.40048e+03, 3.7095e+01 },
  { 22, 24, 1.28330e+03, 3.5414e+01 },
  { 23, 24, 1.09854e+03, 3.4047e+01 },
  { 24, 24, 1.06860e+03, 3.3113e+01 },
  { 25, 24, 1.06534e+03, 3.2527e+01 },
  { 26, 24, 1.03096e+03, 3.2173e+01 },
  { 27, 24, 1.03963e+03, 3.1961e+01 },
  { 28, 24, 9.78038e+02, 3.1838e+01 },
  { 29, 24, 9.89755e+02, 3.1763e+01 },
  { 30, 24, 9.90081e+02, 3.1715e+01 },
  { 31, 24, 1.03772e+03, 3.1686e+01 },
  { 32, 24, 1.01260e+03, 3.1667e+01 },
  { 33, 24, 1.02562e+03, 3.1654e+01 },
  { 34, 24, 1.00688e+03, 3.1623e+01 },
  { 35, 24, 1.01682e+03, 3.1623e+01 },
  { 36, 24, 1.04576e+03, 3.1623e+01 },
  { 37, 24, 1.00049e+03, 3.1623e+01 },
  { 38, 24, 1.00598e+03, 3.1623e+01 },
  {  1, 25, 1.01779e+03, 3.1623e+01 },
  {  2, 25, 1.02055e+03, 3.1623e+01 },
  {  3, 25, 1.04199e+03, 3.1623e+01 },
  {  4, 25, 9.78082e+02, 3.1623e+01 },
  {  5, 25, 1.03668e+03, 3.1650e+01 },
  {  6, 25, 9.53300e+02, 3.1661e+01 },
  {  7, 25, 1.00775e+03, 3.1676e+01 },
  {  8, 25, 1.00941e+03, 3.1700e+01 },
  {  9, 25, 9.87876e+02, 3.1735e+01 },
  { 10, 25, 1.02169e+03, 3.1789e+01 },
  { 11, 25, 1.06133e+03, 3.1873e+01 },
  { 12, 25, 1.02552e+03, 3.2005e+01 },
  { 13, 25, 9.57358e+02, 3.2213e+01 },
  { 14, 25, 1.07547e+03, 3.2527e+01 },
  { 15, 25, 1.07707e+03, 3.2974e+01 },
  { 16, 25, 1.16458e+03, 3.3553e+01 },
  { 17, 25, 1.13764e+03, 3.4197e+01 },
  { 18, 25, 1.20823e+03, 3.4727e+01 },
  { 19, 25, 1.21783e+03, 3.4931e+01 },
  { 20, 25, 1.18158e+03, 3.4727e+01 },
  { 21, 25, 1.20466e+03, 3.4197e+01 },
  { 22, 25, 1.14789e+03, 3.3553e+01 },
  { 23, 25, 1.06933e+03, 3.2974e+01 },
  { 24, 25, 1.10460e+03, 3.2527e+01 },
  { 25, 25, 1.04494e+03, 3.2213e+01 },
  { 26, 25, 1.01862e+03, 3.2005e+01 },
  { 27, 25, 1.00138e+03, 3.1873e+01 },
  { 28, 25, 9.86238e+02, 3.1789e+01 },
  { 29, 25, 9.73326e+02, 3.1735e+01 },
  { 30, 25, 9.64666e+02, 3.1700e+01 },
  { 31, 25, 1.03946e+03, 3.1676e+01 },
  { 32, 25, 9.79668e+02, 3.1661e+01 },
  { 33, 25, 1.02869e+03, 3.1650e+01 },
  { 34, 25, 1.00491e+03, 3.1623e+01 },
  { 35, 25, 9.36961e+02, 3.1623e+01 },
  { 36, 25, 1.00185e+03, 3.1623e+01 },
  { 37, 25, 9.78760e+02, 3.1623e+01 },
  { 38, 25, 9.60534e+02, 3.1623e+01 },
  {  1, 26, 9.85981e+02, 3.1623e+01 },
  {  2, 26, 1.03824e+03, 3.1623e+01 },
  {  3, 26, 9.34504e+02, 3.1623e+01 },
  {  4, 26, 1.01632e+03, 3.1623e+01 },
  {  5, 26, 1.00913e+03, 3.1623e+01 },
  {  6, 26, 9.96607e+02, 3.1655e+01 },
  {  7, 26, 9.76098e+02, 3.1667e+01 },
  {  8, 26, 1.02633e+03, 3.1685e+01 },
  {  9, 26, 9.66951e+02, 3.1711e+01 },
  { 10, 26, 9.68070e+02, 3.1749e+01 },
  { 11, 26, 1.04684e+03, 3.1805e+01 },
  { 12, 26, 1.07561e+03, 3.1887e+01 },
  { 13, 26, 9.97465e+02, 3.2005e+01 },
  { 14, 26, 1.04974e+03, 3.2173e+01 },
  { 15, 26, 1.11424e+03, 3.2390e+01 },
  { 16, 26, 1.00057e+03, 3.2648e+01 },
  { 17, 26, 1.12638e+03, 3.2910e+01 },
  { 18, 26, 1.12980e+03, 3.3112e+01 },
  { 19, 26, 1.11574e+03, 3.3187e+01 },
  { 20, 26, 1.08324e+03, 3.3112e+01 },
  { 21, 26, 1.11174e+03, 3.2910e+01 },
  { 22, 26, 1.10052e+03, 3.2648e+01 },
  { 23, 26, 1.01108e+03, 3.2390e+01 },
  { 24, 26, 1.06442e+03, 3.2173e+01 },
  { 25, 26, 1.01291e+03, 3.2005e+01 },
  { 26, 26, 1.00254e+03, 3.1887e+01 },
  { 27, 26, 1.00735e+03, 3.1805e+01 },
  { 28, 26, 9.99965e+02, 3.1749e+01 },
  { 29, 26, 1.03337e+03, 3.1711e+01 },
  { 30, 26, 9.94899e+02, 3.1685e+01 },
  { 31, 26, 9.44027e+02, 3.1667e+01 },
  { 32, 26, 9.82909e+02, 3.1655e+01 },
  { 33, 26, 1.00990e+03, 3.1623e+01 },
  { 34, 26, 1.00347e+03, 3.1623e+01 },
  { 35, 26, 9.75798e+02, 3.1623e+01 },
  { 36, 26, 9.81000e+02, 3.1623e+01 },
  { 37, 26, 9.89716e+02, 3.1623e+01 },
  { 38, 26, 1.01401e+03, 3.1623e+01 },
  {  1, 27, 9.88880e+02, 3.1623e+01 },
  {  2, 27, 1.03373e+03, 3.1623e+01 },
  {  3, 27, 9.78274e+02, 3.1623e+01 },
  {  4, 27, 1.06782e+03, 3.1623e+01 },
  {  5, 27, 9.96508e+02, 3.1623e+01 },
  {  6, 27, 1.06271e+03, 3.1650e+01 },
  {  7, 27, 9.31225e+02, 3.1659e+01 },
  {  8, 27, 9.48178e+02, 3.1672e+01 },
  {  9, 27, 1.02363e+03, 3.1691e+01 },
  { 10, 27, 1.01691e+03, 3.1718e+01 },
  { 11, 27, 9.58676e+02, 3.1754e+01 },
  { 12, 27, 1.00368e+03, 3.1805e+01 },
  { 13, 27, 1.03744e+03, 3.1873e+01 },
  { 14, 27, 9.83122e+02, 3.1961e+01 },
  { 15, 27, 1.10125e+03, 3.2074e+01 },
  { 16, 27, 1.05789e+03, 3.2192e+01 },
  { 17, 27, 1.08141e+03, 3.2306e+01 },
  { 18, 27, 1.12784e+03, 3.2389e+01 },
  { 19, 27, 1.06400e+03, 3.2419e+01 },
  { 20, 27, 1.03756e+03, 3.2389e+01 },
  { 21, 27, 9.78530e+02, 3.2306e+01 },
  { 22, 27, 1.08536e+03, 3.2192e+01 },
  { 23, 27, 1.03185e+03, 3.2074e+01 },
  { 24, 27, 1.01340e+03, 3.1961e+01 },
  { 25, 27, 9.82784e+02, 3.1873e+01 },
  { 26, 27, 1.02487e+03, 3.1805e+01 },
  { 27, 27, 1.04214e+03, 3.1754e+01 },
  { 28, 27, 1.09702e+03, 3.1718e+01 },
  { 29, 27, 9.59571e+02, 3.1691e+01 },
  { 30, 27, 9.75591e+02, 3.1672e+01 },
  { 31, 27, 9.59105e+02, 3.1659e+01 },
  { 32, 27, 9.75904e+02, 3.1650e+01 },
  { 33, 27, 1.05503e+03, 3.1623e+01 },
  { 34, 27, 1.02704e+03, 3.1623e+01 },
  { 35, 27, 1.04273e+03, 3.1623e+01 },
  { 36, 27, 9.84717e+02, 3.1623e+01 },
  { 37, 27, 9.49873e+02, 3.1623e+01 },
  { 38, 27, 9.72080e+02, 3.1623e+01 },
  {  1, 28, 9.18508e+02, 3.1623e+01 },
  {  2, 28, 1.04312e+03, 3.1623e+01 },
  {  3, 28, 1.00936e+03, 3.1623e+01 },
  {  4, 28, 1.00684e+03, 3.1623e+01 },
  {  5, 28, 1.04258e+03, 3.1623e+01 },
  {  6, 28, 1.00157e+03, 3.1623e+01 },
  {  7, 28, 1.01744e+03, 3.1652e+01 },
  {  8, 28, 1.01833e+03, 3.1662e+01 },
  {  9, 28, 9.58586e+02, 3.1675e+01 },
  { 10, 28, 9.80850e+02, 3.1693e+01 },
  { 11, 28, 1.04402e+03, 3.1718e+01 },
  { 12, 28, 1.03793e+03, 3.1749e+01 },
  { 13, 28, 9.90732e+02, 3.1789e+01 },
  { 14, 28, 1.03340e+03, 3.1838e+01 },
  { 15, 28, 1.03035e+03, 3.1894e+01 },
  { 16, 28, 1.01532e+03, 3.1952e+01 },
  { 17, 28, 1.00266e+03, 3.2005e+01 },
  { 18, 28, 1.03323e+03, 3.2041e+01 },
  { 19, 28, 9.62869e+02, 3.2055e+01 },
  { 20, 28, 9.72653e+02, 3.2041e+01 },
  { 21, 28, 9.79664e+02, 3.2005e+01 },
  { 22, 28, 9.85959e+02, 3.1952e+01 },
  { 23, 28, 1.03644e+03, 3.1894e+01 },
  { 24, 28, 1.01621e+03, 3.1838e+01 },
  { 25, 28, 9.99428e+02, 3.1789e+01 },
  { 26, 28, 1.05317e+03, 3.1749e+01 },
  { 27, 28, 9.86384e+02, 3.1718e+01 },
  { 28, 28, 9.81733e+02, 3.1693e+01 },
  { 29, 28, 1.02105e+03, 3.1675e+01 },
  { 30, 28, 1.05011e+03, 3.1662e+01 },
  { 31, 28, 1.02484e+03, 3.1652e+01 },
  { 32, 28, 9.45713e+02, 3.1623e+01 },
  { 33, 28, 1.02635e+03, 3.1623e+01 },
  { 34, 28, 1.01038e+03, 3.1623e+01 },
  { 35, 28, 9.62821e+02, 3.1623e+01 },
  { 36, 28, 9.48676e+02, 3.1623e+01 },
  { 37, 28, 1.00110e+03, 3.1623e+01 },
  { 38, 28, 9.51722e+02, 3.1623e+01 },
  {  1, 29, 9.93754e+02, 3.1623e+01 },
  {  2, 29, 1.00527e+03, 3.1623e+01 },
  {  3, 29, 9.64684e+02, 3.1623e+01 },
  {  4, 29, 9.93208e+02, 3.1623e+01 },
  {  5, 29, 9.67595e+02, 3.1623e+01 },
  {  6, 29, 1.01587e+03, 3.1623e+01 },
  {  7, 29, 9.93351e+02, 3.1623e+01 },
  {  8, 29, 1.01911e+03, 3.1654e+01 },
  {  9, 29, 1.02449e+03, 3.1663e+01 },
  { 10, 29, 1.04516e+03, 3.1675e+01 },
  { 11, 29, 9.94607e+02, 3.1691e+01 },
  { 12, 29, 9.90091e+02, 3.1711e+01 },
  { 13, 29, 9.95110e+02, 3.1735e+01 },
  { 14, 29, 9.73319e+02, 3.1763e+01 },
  { 15, 29, 1.01057e+03, 3.1793e+01 },
  { 16, 29, 1.03699e+03, 3.1823e+01 },
  { 17, 29, 9.74441e+02, 3.1849e+01 },
  { 18, 29, 1.04127e+03, 3.1867e+01 },
  { 19, 29, 1.06935e+03, 3.1873e+01 },
  { 20, 29, 1.03971e+03, 3.1867e+01 },
  { 21, 29, 1.04405e+03, 3.1849e+01 },
  { 22, 29, 1.02393e+03, 3.1823e+01 },
  { 23, 29, 1.03064e+03, 3.1793e+01 },
  { 24, 29, 1.03481e+03, 3.1763e+01 },
  { 25, 29, 1.03062e+03, 3.1735e+01 },
  { 26, 29, 9.80443e+02, 3.1711e+01 },
  { 27, 29, 9.90707e+02, 3.1691e+01 },
  { 28, 29, 1.01094e+03, 3.1675e+01 },
  { 29, 29, 1.00517e+03, 3.1663e+01 },
  { 30, 29, 1.02991e+03, 3.1654e+01 },
  { 31, 29, 9.52751e+02, 3.1623e+01 },
  { 32, 29, 9.87888e+02, 3.1623e+01 },
  { 33, 29, 1.07128e+03, 3.1623e+01 },
  { 34, 29, 9.75270e+02, 3.1623e+01 },
  { 35, 29, 9.74682e+02, 3.1623e+01 },
  { 36, 29, 1.03334e+03, 3.1623e+01 },
  { 37, 29, 1.02595e+03, 3.1623e+01 },
  { 38, 29, 9.54683e+02, 3.1623e+01 },
  {  1, 30, 9.74000e+02, 3.1623e+01 },
  {  2, 30, 1.02082e+03, 3.1623e+01 },
  {  3, 30, 8.97353e+02, 3.1623e+01 },
  {  4, 30, 9.74442e+02, 3.1623e+01 },
  {  5, 30, 9.96662e+02, 3.1623e+01 },
  {  6, 30, 9.40371e+02, 3.1623e+01 },
  {  7, 30, 9.81418e+02, 3.1623e+01 },
  {  8, 30, 1.00673e+03, 3.1623e+01 },
  {  9, 30, 9.93945e+02, 3.1654e+01 },
  { 10, 30, 1.00900e+03, 3.1662e+01 },
  { 11, 30, 1.01323e+03, 3.1672e+01 },
  { 12, 30, 9.64739e+02, 3.1685e+01 },
  { 13, 30, 1.08314e+03, 3.1700e+01 },
  { 14, 30, 1.06815e+03, 3.1715e+01 },
  { 15, 30, 9.89799e+02, 3.1733e+01 },
  { 16, 30, 9.99372e+02, 3.1749e+01 },
  { 17, 30, 1.04038e+03, 3.1763e+01 },
  { 18, 30, 1.02634e+03, 3.1772e+01 },
  { 19, 30, 9.73936e+02, 3.1775e+01 },
  { 20, 30, 1.02613e+03, 3.1772e+01 },
  { 21, 30, 9.97257e+02, 3.1763e+01 },
  { 22, 30, 9.96789e+02, 3.1749e+01 },
  { 23, 30, 1.05728e+03, 3.1733e+01 },
  { 24, 30, 9.88083e+02, 3.1715e+01 },
  { 25, 30, 9.90574e+02, 3.1700e+01 },
  { 26, 30, 9.76648e+02, 3.1685e+01 },
  { 27, 30, 9.66557e+02, 3.1672e+01 },
  { 28, 30, 1.04779e+03, 3.1662e+01 },
  { 29, 30, 1.03315e+03, 3.1654e+01 },
  { 30, 30, 9.52390e+02, 3.1623e+01 },
  { 31, 30, 9.78543e+02, 3.1623e+01 },
  { 32, 30, 1.01499e+03, 3.1623e+01 },
  { 33, 30, 1.07578e+03, 3.1623e+01 },
  { 34, 30, 1.04644e+03, 3.1623e+01 },
  { 35, 30, 9.78429e+02, 3.1623e+01 },
  { 36, 30, 9.20051e+02, 3.1623e+01 },
  { 37, 30, 9.92745e+02, 3.1623e+01 },
  { 38, 30, 1.03481e+03, 3.1623e+01 },
  {  1, 31, 1.02186e+03, 3.1623e+01 },
  {  2, 31, 9.97901e+02, 3.1623e+01 },
  {  3, 31, 1.07555e+03, 3.1623e+01 },
  {  4, 31, 9.83444e+02, 3.1623e+01 },
  {  5, 31, 1.01376e+03, 3.1623e+01 },
  {  6, 31, 9.42284e+02, 3.1623e+01 },
  {  7, 31, 1.01015e+03, 3.1623e+01 },
  {  8, 31, 9.79127e+02, 3.1623e+01 },
  {  9, 31, 1.03222e+03, 3.1623e+01 },
  { 10, 31, 9.55066e+02, 3.1652e+01 },
  { 11, 31, 1.03210e+03, 3.1659e+01 },
  { 12, 31, 9.66414e+02, 3.1667e+01 },
  { 13, 31, 9.79809e+02, 3.1676e+01 },
  { 14, 31, 9.84206e+02, 3.1686e+01 },
  { 15, 31, 1.02601e+03, 3.1696e+01 },
  { 16, 31, 1.01970e+03, 3.1705e+01 },
  { 17, 31, 1.01056e+03, 3.1712e+01 },
  { 18, 31, 9.79269e+02, 3.1718e+01 },
  { 19, 31, 1.01043e+03, 3.1719e+01 },
  { 20, 31, 1.02334e+03, 3.1718e+01 },
  { 21, 31, 1.02734e+03, 3.1712e+01 },
  { 22, 31, 1.00304e+03, 3.1705e+01 },
  { 23, 31, 9.81210e+02, 3.1696e+01 },
  { 24, 31, 1.04661e+03, 3.1686e+01 },
  { 25, 31, 9.85538e+02, 3.1676e+01 },
  { 26, 31, 1.01064e+03, 3.1667e+01 },
  { 27, 31, 1.02737e+03, 3.1659e+01 },
  { 28, 31, 9.64950e+02, 3.1652e+01 },
  { 29, 31, 9.97645e+02, 3.1623e+01 },
  { 30, 31, 9.84877e+02, 3.1623e+01 },
  { 31, 31, 9.70469e+02, 3.1623e+01 },
  { 32, 31, 1.00934e+03, 3.1623e+01 },
  { 33, 31, 9.89463e+02, 3.1623e+01 },
  { 34, 31, 1.02742e+03, 3.1623e+01 },
  { 35, 31, 1.01158e+03, 3.1623e+01 },
  { 36, 31, 9.70441e+02, 3.1623e+01 },
  { 37, 31, 9.39053e+02, 3.1623e+01 },
  { 38, 31, 1.00176e+03, 3.1623e+01 },
  {  1, 32, 1.03401e+03, 3.1623e+01 },
  {  2, 32, 9.65257e+02, 3.1623e+01 },
  {  3, 32, 9.86292e+02, 3.1623e+01 },
  {  4, 32, 9.86409e+02, 3.1623e+01 },
  {  5, 32, 1.00330e+03, 3.1623e+01 },
  {  6, 32, 9.52828e+02, 3.1623e+01 },
  {  7, 32, 1.00078e+03, 3.1623e+01 },
  {  8, 32, 9.73379e+02, 3.1623e+01 },
  {  9, 32, 1.00231e+03, 3.1623e+01 },
  { 10, 32, 1.06759e+03, 3.1623e+01 },
  { 11, 32, 1.00384e+03, 3.1650e+01 },
  { 12, 32, 1.02682e+03, 3.1655e+01 },
  { 13, 32, 1.02552e+03, 3.1661e+01 },
  { 14, 32, 9.71364e+02, 3.1667e+01 },
  { 15, 32, 1.04154e+03, 3.1672e+01 },
  { 16, 32, 1.03076e+03, 3.1678e+01 },
  { 17, 32, 9.84450e+02, 3.1682e+01 },
  { 18, 32, 9.68453e+02, 3.1685e+01 },
  { 19, 32, 1.07108e+03, 3.1686e+01 },
  { 20, 32, 1.00789e+03, 3.1685e+01 },
  { 21, 32, 1.03289e+03, 3.1682e+01 },
  { 22, 32, 9.96024e+02, 3.1678e+01 },
  { 23, 32, 1.01030e+03, 3.1672e+01 },
  { 24, 32, 1.04213e+03, 3.1667e+01 },
  { 25, 32, 9.75564e+02, 3.1661e+01 },
  { 26, 32, 9.98499e+02, 3.1655e+01 },
  { 27, 32, 9.23757e+02, 3.1650e+01 },
  { 28, 32, 9.54232e+02, 3.1623e+01 },
  { 29, 32, 1.06617e+03, 3.1623e+01 },
  { 30, 32, 1.05956e+03, 3.1623e+01 },
  { 31, 32, 9.56983e+02, 3.1623e+01 },
  { 32, 32, 9.54407e+02, 3.1623e+01 },
  { 33, 32, 1.04082e+03, 3.1623e+01 },
  { 34, 32, 1.01128e+03, 3.1623e+01 },
  { 35, 32, 9.85876e+02, 3.1623e+01 },
  { 36, 32, 1.03823e+03, 3.1623e+01 },
  { 37, 32, 9.87326e+02, 3.1623e+01 },
  { 38, 32, 9.85122e+02, 3.1623e+01 },
  {  1, 33, 9.93271e+02, 3.1623e+01 },
  {  2, 33, 9.56743e+02, 3.1623e+01 },
  {  3, 33, 9.95758e+02, 3.1623e+01 },
  {  4, 33, 9.57621e+02, 3.1623e+01 },
  {  5, 33, 1.03694e+03, 3.1623e+01 },
  {  6, 33, 9.59435e+02, 3.1623e+01 },
  {  7, 33, 1.02494e+03, 3.1623e+01 },
  {  8, 33, 9.71703e+02, 3.1623e+01 },
  {  9, 33, 1.00255e+03, 3.1623e+01 },
  { 10, 33, 1.02105e+03, 3.1623e+01 },
  { 11, 33, 1.01836e+03, 3.1623e+01 },
  { 12, 33, 1.02707e+03, 3.1623e+01 },
  { 13, 33, 9.36955e+02, 3.1650e+01 },
  { 14, 33, 1.07656e+03, 3.1654e+01 },
  { 15, 33, 1.07353e+03, 3.1657e+01 },
  { 16, 33, 9.62270e+02, 3.1661e+01 },
  { 17, 33, 1.01819e+03, 3.1663e+01 },
  { 18, 33, 1.00336e+03, 3.1665e+01 },
  { 19, 33, 1.00331e+03, 3.1666e+01 },
  { 20, 33, 1.01803e+03, 3.1665e+01 },
  { 21, 33, 9.85667e+02, 3.1663e+01 },
  { 22, 33, 1.02502e+03, 3.1661e+01 },
  { 23, 33, 1.03034e+03, 3.1657e+01 },
  { 24, 33, 9.83419e+02, 3.1654e+01 },
  { 25, 33, 1.00589e+03, 3.1650e+01 },
  { 26, 33, 1.03246e+03, 3.1623e+01 },
  { 27, 33, 1.01475e+03, 3.1623e+01 },
  { 28, 33, 1.04267e+03, 3.1623e+01 },
  { 29, 33, 1.00688e+03, 3.1623e+01 },
  { 30, 33, 9.98257e+02, 3.1623e+01 },
  { 31, 33, 1.05703e+03, 3.1623e+01 },
  { 32, 33, 1.02850e+03, 3.1623e+01 },
  { 33, 33, 9.95827e+02, 3.1623e+01 },
  { 34, 33, 1.00606e+03, 3.1623e+01 },
  { 35, 33, 1.00603e+03, 3.1623e+01 },
  { 36, 33, 1.00237e+03, 3.1623e+01 },
  { 37, 33, 9.63689e+02, 3.1623e+01 },
  { 38, 33, 9.69664e+02, 3.1623e+01 },
  {  1, 34, 1.00896e+03, 3.1623e+01 },
  {  2, 34, 1.05417e+03, 3.1623e+01 },
  {  3, 34, 9.94590e+02, 3.1623e+01 },
  {  4, 34, 9.71798e+02, 3.1623e+01 },
  {  5, 34, 9.72699e+02, 3.1623e+01 },
  {  6, 34, 1.06169e+03, 3.1623e+01 },
  {  7, 34, 9.97418e+02, 3.1623e+01 },
  {  8, 34, 1.02699e+03, 3.1623e+01 },
  {  9, 34, 1.02638e+03, 3.1623e+01 },
  { 10, 34, 1.05422e+03, 3.1623e+01 },
  { 11, 34, 9.59737e+02, 3.1623e+01 },
  { 12, 34, 9.86119e+02, 3.1623e+01 },
  { 13, 34, 1.06998e+03, 3.1623e+01 },
  { 14, 34, 9.62161e+02, 3.1623e+01 },
  { 15, 34, 1.05307e+03, 3.1623e+01 },
  { 16, 34, 1.01391e+03, 3.1649e+01 },
  { 17, 34, 9.92802e+02, 3.1651e+01 },
  { 18, 34, 9.59396e+02, 3.1652e+01 },
  { 19, 34, 1.06592e+03, 3.1652e+01 },
  { 20, 34, 1.04455e+03, 3.1652e+01 },
  { 21, 34, 9.83191e+02, 3.1651e+01 },
  { 22, 34, 9.75423e+02, 3.1649e+01 },
  { 23, 34, 1.05304e+03, 3.1623e+01 },
  { 24, 34, 9.91010e+02, 3.1623e+01 },
  { 25, 34, 9.91565e+02, 3.1623e+01 },
  { 26, 34, 9.94239e+02, 3.1623e+01 },
  { 27, 34, 9.85047e+02, 3.1623e+01 },
  { 28, 34, 9.67598e+02, 3.1623e+01 },
  { 29, 34, 9.75804e+02, 3.1623e+01 },
  { 30, 34, 9.86413e+02, 3.1623e+01 },
  { 31, 34, 1.00408e+03, 3.1623e+01 },
  { 32, 34, 1.01106e+03, 3.1623e+01 },
  { 33, 34, 1.02130e+03, 3.1623e+01 },
  { 34, 34, 9.92253e+02, 3.1623e+01 },
  { 35, 34, 1.00982e+03, 3.1623e+01 },
  { 36, 34, 1.03626e+03, 3.1623e+01 },
  { 37, 34, 9.81514e+02, 3.1623e+01 },
  { 38, 34, 1.03155e+03, 3.1623e+01 },
  {  1, 35, 9.85339e+02, 3.1623e+01 },
  {  2, 35, 1.01903e+03, 3.1623e+01 },
  {  3, 35, 9.86449e+02, 3.1623e+01 },
  {  4, 35, 9.63913e+02, 3.1623e+01 },
  {  5, 35, 1.01200e+03, 3.1623e+01 },
  {  6, 35, 9.88208e+02, 3.1623e+01 },
  {  7, 35, 9.93781e+02, 3.1623e+01 },
  {  8, 35, 9.94064e+02, 3.1623e+01 },
  {  9, 35, 1.01190e+03, 3.1623e+01 },
  { 10, 35, 9.86749e+02, 3.1623e+01 },
  { 11, 35, 1.02044e+03, 3.1623e+01 },
  { 12, 35, 9.90417e+02, 3.1623e+01 },
  { 13, 35, 9.93160e+02, 3.1623e+01 },
  { 14, 35, 9.76649e+02, 3.1623e+01 },
  { 15, 35, 9.62480e+02, 3.1623e+01 },
  { 16, 35, 1.02056e+03, 3.1623e+01 },
  { 17, 35, 9.99136e+02, 3.1623e+01 },
  { 18, 35, 1.05561e+03, 3.1623e+01 },
  { 19, 35, 1.00402e+03, 3.1623e+01 },
  { 20, 35, 1.05968e+03, 3.1623e+01 },
  { 21, 35, 9.89741e+02, 3.1623e+01 },
  { 22, 35, 9.84024e+02, 3.1623e+01 },
  { 23, 35, 9.39221e+02, 3.1623e+01 },
  { 24, 35, 9.60005e+02, 3.1623e+01 },
  { 25, 35, 1.00602e+03, 3.1623e+01 },
  { 26, 35, 1.00832e+03, 3.1623e+01 },
  { 27, 35, 1.02130e+03, 3.1623e+01 },
  { 28, 35, 9.81331e+02, 3.1623e+01 },
  { 29, 35, 9.47486e+02, 3.1623e+01 },
  { 30, 35, 9.42567e+02, 3.1623e+01 },
  { 31, 35, 9.44038e+02, 3.1623e+01 },
  { 32, 35, 9.88663e+02, 3.1623e+01 },
  { 33, 35, 9.47465e+02, 3.1623e+01 },
  { 34, 35, 9.77427e+02, 3.1623e+01 },
  { 35, 35, 1.00261e+03, 3.1623e+01 },
  { 36, 35, 9.57546e+02, 3.1623e+01 },
  { 37, 35, 1.01907e+03, 3.1623e+01 },
  { 38, 35, 1.01009e+03, 3.1623e+01 },
  {  1, 36, 9.44303e+02, 3.1623e+01 },
  {  2, 36, 1.02972e+03, 3.1623e+01 },
  {  3, 36, 9.77852e+02, 3.1623e+01 },
  {  4, 36, 9.79285e+02, 3.1623e+01 },
  {  5, 36, 9.91455e+02, 3.1623e+01 },
  {  6, 36, 1.04834e+03, 3.1623e+01 },
  {  7, 36, 1.00960e+03, 3.1623e+01 },
  {  8, 36, 9.46190e+02, 3.1623e+01 },
  {  9, 36, 9.98824e+02, 3.1623e+01 },
  { 10, 36, 9.87070e+02, 3.1623e+01 },
  { 11, 36, 9.73035e+02, 3.1623e+01 },
  { 12, 36, 1.03702e+03, 3.1623e+01 },
  { 13, 36, 9.76557e+02, 3.1623e+01 },
  { 14, 36, 1.05262e+03, 3.1623e+01 },
  { 15, 36, 9.68715e+02, 3.1623e+01 },
  { 16, 36, 9.87750e+02, 3.1623e+01 },
  { 17, 36, 9.63838e+02, 3.1623e+01 },
  { 18, 36, 1.04744e+03, 3.1623e+01 },
  { 19, 36, 9.70146e+02, 3.1623e+01 },
  { 20, 36, 9.80114e+02, 3.1623e+01 },
  { 21, 36, 1.01524e+03, 3.1623e+01 },
  { 22, 36, 9.77226e+02, 3.1623e+01 },
  { 23, 36, 9.85747e+02, 3.1623e+01 },
  { 24, 36, 1.00455e+03, 3.1623e+01 },
  { 25, 36, 1.03772e+03, 3.1623e+01 },
  { 26, 36, 1.03622e+03, 3.1623e+01 },
  { 27, 36, 9.88819e+02, 3.1623e+01 },
  { 28, 36, 1.03427e+03, 3.1623e+01 },
  { 29, 36, 9.82113e+02, 3.1623e+01 },
  { 30, 36, 1.01752e+03, 3.1623e+01 },
  { 31, 36, 9.88185e+02, 3.1623e+01 },
  { 32, 36, 1.01554e+03, 3.1623e+01 },
  { 33, 36, 1.02950e+03, 3.1623e+01 },
  { 34, 36, 9.55736e+02, 3.1623e+01 },
  { 35, 36, 9.70257e+02, 3.1623e+01 },
  { 36, 36, 1.00662e+03, 3.1623e+01 },
  { 37, 36, 1.00549e+03, 3.1623e+01 },
  { 38, 36, 1.00411e+03, 3.1623e+01 },
  {  1, 37, 1.03933e+03, 3.1623e+01 },
  {  2, 37, 1.00275e+03, 3.1623e+01 },
  {  3, 37, 1.00606e+03, 3.1623e+01 },
  {  4, 37, 9.81845e+02, 3.1623e+01 },
  {  5, 37, 1.01269e+03, 3.1623e+01 },
  {  6, 37, 1.01373e+03, 3.1623e+01 },
  {  7, 37, 9.89032e+02, 3.1623e+01 },
  {  8, 37, 9.87370e+02, 3.1623e+01 },
  {  9, 37, 9.48123e+02, 3.1623e+01 },
  { 10, 37, 9.98350e+02, 3.1623e+01 },
  { 11, 37, 1.02312e+03, 3.1623e+01 },
  { 12, 37, 1.02106e+03, 3.1623e+01 },
  { 13, 37, 9.79555e+02, 3.1623e+01 },
  { 14, 37, 1.00581e+03, 3.1623e+01 },
  { 15, 37, 9.91414e+02, 3.1623e+01 },
  { 16, 37, 9.59784e+02, 3.1623e+01 },
  { 17, 37, 9.89401e+02, 3.1623e+01 },
  { 18, 37, 9.66659e+02, 3.1623e+01 },
  { 19, 37, 1.02378e+03, 3.1623e+01 },
  { 20, 37, 1.05985e+03, 3.1623e+01 },
  { 21, 37, 1.06593e+03, 3.1623e+01 },
  { 22, 37, 1.00626e+03, 3.1623e+01 },
  { 23, 37, 1.04812e+03, 3.1623e+01 },
  { 24, 37, 9.71505e+02, 3.1623e+01 },
  { 25, 37, 9.13525e+02, 3.1623e+01 },
  { 26, 37, 1.01755e+03, 3.1623e+01 },
  { 27, 37, 9.39351e+02, 3.1623e+01 },
  { 28, 37, 1.03409e+03, 3.1623e+01 },
  { 29, 37, 9.62957e+02, 3.1623e+01 },
  { 30, 37, 9.74328e+02, 3.1623e+01 },
  { 31, 37, 9.63213e+02, 3.1623e+01 },
  { 32, 37, 1.03221e+03, 3.1623e+01 },
  { 33, 37, 1.02401e+03, 3.1623e+01 },
  { 34, 37, 1.00889e+03, 3.1623e+01 },
  { 35, 37, 9.83577e+02, 3.1623e+01 },
  { 36, 37, 9.94689e+02, 3.1623e+01 },
  { 37, 37, 9.75049e+02, 3.1623e+01 },
  { 38, 37, 1.00574e+03, 3.1623e+01 },
  {  1, 38, 1.02001e+03, 3.1623e+01 },
  {  2, 38, 1.01628e+03, 3.1623e+01 },
  {  3, 38, 1.02988e+03, 3.1623e+01 },
  {  4, 38, 1.05146e+03, 3.1623e+01 },
  {  5, 38, 1.03080e+03, 3.1623e+01 },
  {  6, 38, 9.95620e+02, 3.1623e+01 },
  {  7, 38, 1.00289e+03, 3.1623e+01 },
  {  8, 38, 9.69364e+02, 3.1623e+01 },
  {  9, 38, 1.03945e+03, 3.1623e+01 },
  { 10, 38, 1.04798e+03, 3.1623e+01 },
  { 11, 38, 9.63468e+02, 3.1623e+01 },
  { 12, 38, 9.66043e+02, 3.1623e+01 },
  { 13, 38, 1.03109e+03, 3.1623e+01 },
  { 14, 38, 1.03496e+03, 3.1623e+01 },
  { 15, 38, 9.95275e+02, 3.1623e+01 },
  { 16, 38, 9.99430e+02, 3.1623e+01 },
  { 17, 38, 9.86622e+02, 3.1623e+01 },
  { 18, 38, 1.03151e+03, 3.1623e+01 },
  { 19, 38, 9.93277e+02, 3.1623e+01 },
  { 20, 38, 1.04052e+03, 3.1623e+01 },
  { 21, 38, 1.01201e+03, 3.1623e+01 },
  { 22, 38, 9.95184e+02, 3.1623e+01 },
  { 23, 38, 9.90204e+02, 3.1623e+01 },
  { 24, 38, 1.04245e+03, 3.1623e+01 },
  { 25, 38, 1.04032e+03, 3.1623e+01 },
  { 26, 38, 1.02106e+03, 3.1623e+01 },
  { 27, 38, 9.97902e+02, 3.1623e+01 },
  { 28, 38, 1.01447e+03, 3.1623e+01 },
  { 29, 38, 1.02405e+03, 3.1623e+01 },
  { 30, 38, 1.04714e+03, 3.1623e+01 },
  { 31, 38, 9.56192e+02, 3.1623e+01 },
  { 32, 38, 1.03731e+03, 3.1623e+01 },
  { 33, 38, 9.99138e+02, 3.1623e+01 },
  { 34, 38, 9.77620e+02, 3.1623e+01 },
  { 35, 38, 9.91539e+02, 3.1623e+01 },
  { 36, 38, 9.87474e+02, 3.1623e+01 },
  { 37, 38, 9.86457e+02, 3.1623e+01 },
  { 38, 38, 1.01683e+03, 3.1623e+01 },
  { 0., 0., 0., 0. }
};

/* three-peak Gaussian without background */
double g1(double x)
{
  return   10. / CPL_MATH_SQRT2PI / 0.5 * exp(-0.5 * pow((10. - x) / 0.5, 2))
       + 1000. / CPL_MATH_SQRT2PI / 0.5 * exp(-0.5 * pow((15. - x) / 0.5, 2))
       +  100. / CPL_MATH_SQRT2PI / 0.5 * exp(-0.5 * pow((25. - x) / 0.5, 2));
}

/* two-peak Gaussian with 2nd-order background */
double g2(double x)
{
  return 10. + 0.5 * x + 0.05 * x*x
       + 150. / CPL_MATH_SQRT2PI / 1. * exp(-0.5 * pow((12. - x) / 1., 2))
       + 250. / CPL_MATH_SQRT2PI / 1. * exp(-0.5 * pow((24. - x) / 1., 2));
}

void
gaussian_test_fill_vectors(double (*aF)(double), cpl_vector *aX, cpl_bivector *aY)
{
  cpl_vector *y = cpl_bivector_get_x(aY),
             *ye = cpl_bivector_get_y(aY);
  int i;
  for (i = 0; i < cpl_vector_get_size(aX); i++) {
    cpl_vector_set(aX, i, i+1);
    cpl_vector_set(y, i, aF(i+1));
    cpl_vector_set(ye, i, sqrt(aF(i+1)) + 1e-2); /* ~ photon noise plus read-out */
  }
} /* gaussian_test_fill_vectors() */

typedef struct {
  /* possible initial guess star parameters */
  const double xi, yi;
  /* expected output values, cross-checked with results from gnuplot and IRAF *
   * (all parameters with three different entries, for the 3 different tests) */
  const double bg[3], flux[3], xc[3], yc[3], alphax[3], alphay[3], beta[3], rho[3];
  /* maximum output tolerance at 1 sigma level */
  const double bge, fluxe, xce, yce, alphaxe, alphaye, betae, rhoe;
  /* expected upper limit of goodness of fit diagnostics */
  const double rms, chisq;
} moffat_fit_data_t;

/* set of expected values */
#define NEXPECTED 3
const moffat_fit_data_t kExpected[NEXPECTED] = {
  { 1319., 95.,
    {    36.378,     34.5,     34.5   }, /* bg      */
    { 51918.6,    57980.,   58570.    }, /* flux    */
    {  1318.9319,  1318.93,  1318.93  }, /* xc      */
    {    94.5131,    94.51,    94.50  }, /* yc      */
    {     4.193,      3.41,     3.65  }, /* alphax  */
    {     4.175,      3.39,     3.63  }, /* alphay  */
    {     2.398,      1.86,     1.95  }, /* beta    */
    {     0.120,      0.118,    0.134 }, /* rho     */
    /* upwards rounded, two-digit error values from the real test: */
     0.064, 990.,  0.0032, 0.0032,  0.022, 0.022,  0.015, 0.002,
     8.8, 8.2 },
  { 313., 928., /* the results of the third fit are very weird?! */
    {    37.369,     36.4,     29.2   }, /* bg      */
    { 32798.1,    34280.,   49800.    }, /* flux    */
    {   312.9275,   312.93,   312.89  }, /* xc      */
    {   927.6083,   927.61,   927.60  }, /* yc      */
    {     4.319,      4.00,     3.00  }, /* alphax  */
    {     4.292,      3.97,     2.97  }, /* alphay  */
    {     2.472,      2.22,     1.49  }, /* beta    */
    {     0.054,      0.054,    0.066 }, /* rho     */
     0.14, 1200.,   0.0046, 0.0046,  0.039, 0.039,  0.028, 0.003,
     11.7, 13.9 },
  {  19.,  19., /* none of the expected values are exactly matched... */
    {     991.3,        991.3,        962.    }, /*    1000.  bg     */
    { 1022860.,     1022860.,     1060000.    }, /* 1000692.  flux   */
    {      18.9989,      19.0010,      19.    }, /*      19.  xc     */
    {      19.0000,      19.0036,      19.    }, /*      19.  yc     */
    {       1.801,        1.801,        1.87  }, /*       2.  alphax */
    {       1.804,        1.804,        1.87  }, /*       2.  alphay */
    {       2.485,        2.485,        2.485 }, /*       2.7 beta   */
    {      -0.0014,      -0.002,       -0.002 }, /*       0.  rho    */
     0.92,  11000.,   0.0013, 0.0013,  0.006, 0.006,  0.008, 0.002,
     270., 3.0 }
};

static cpl_matrix *
moffat_fit_test_fill_data(const float aStar[][4],
                          cpl_vector **aVal, cpl_vector **aErr)
{
  cpl_matrix *pos = cpl_matrix_new(NMAX, 2);
  *aVal = cpl_vector_new(NMAX);
  *aErr = cpl_vector_new(NMAX);
#if 0
  cpl_msg_debug(__func__, "%"CPL_SIZE_FORMAT"x%"CPL_SIZE_FORMAT
                " %"CPL_SIZE_FORMAT" %"CPL_SIZE_FORMAT"",
                cpl_matrix_get_nrow(pos), cpl_matrix_get_ncol(pos),
                cpl_vector_get_size(*aVal), cpl_vector_get_size(*aErr));
#endif

  int i = -1;
  while (aStar[++i][0] > 0. && i < NMAX) {
    cpl_matrix_set(pos, i, 0, aStar[i][0]);
    cpl_matrix_set(pos, i, 1, aStar[i][1]);
    cpl_vector_set(*aVal, i, aStar[i][2]);
    cpl_vector_set(*aErr, i, aStar[i][3]);
  }
  cpl_matrix_set_size(pos, i, 2);
  cpl_vector_set_size(*aVal, i);
  cpl_vector_set_size(*aErr, i);
#if 0
  cpl_msg_debug(__func__, "%"CPL_SIZE_FORMAT"x%"CPL_SIZE_FORMAT
                " %"CPL_SIZE_FORMAT" %"CPL_SIZE_FORMAT"",
                cpl_matrix_get_nrow(pos), cpl_matrix_get_ncol(pos),
                cpl_vector_get_size(*aVal), cpl_vector_get_size(*aErr));
#endif

  return pos;
} /* moffat_fit_test_fill_data() */

static void
moffat_fit_test_check_params(cpl_array *aParams, moffat_fit_data_t aExpected,
                             unsigned char aSetIdx, double aSigma)
{
  const double *p = cpl_array_get_data_double_const(aParams);
  cpl_test(p[0] - aSigma * aExpected.bge < aExpected.bg[aSetIdx] &&
           p[0] + aSigma * aExpected.bge > aExpected.bg[aSetIdx]);
  cpl_test(p[1] - aSigma * aExpected.fluxe < aExpected.flux[aSetIdx] &&
           p[1] + aSigma * aExpected.fluxe > aExpected.flux[aSetIdx]);
  cpl_test(p[2] - aSigma * aExpected.xce < aExpected.xc[aSetIdx] &&
           p[2] + aSigma * aExpected.xce > aExpected.xc[aSetIdx]);
  cpl_test(p[3] - aSigma * aExpected.yce < aExpected.yc[aSetIdx] &&
           p[3] + aSigma * aExpected.yce > aExpected.yc[aSetIdx]);
  cpl_test(p[4] - aSigma * aExpected.alphaxe < aExpected.alphax[aSetIdx] &&
           p[4] + aSigma * aExpected.alphaxe > aExpected.alphax[aSetIdx]);
  cpl_test(p[5] - aSigma * aExpected.alphaye < aExpected.alphay[aSetIdx] &&
           p[5] + aSigma * aExpected.alphaye > aExpected.alphay[aSetIdx]);
  cpl_test(p[6] - aSigma * aExpected.betae < aExpected.beta[aSetIdx] &&
           p[6] + aSigma * aExpected.betae > aExpected.beta[aSetIdx]);
  cpl_test(p[7] - aSigma * aExpected.rhoe < aExpected.rho[aSetIdx] &&
           p[7] + aSigma * aExpected.rhoe > aExpected.rho[aSetIdx]);
} /* moffat_fit_test_check_params() */

static void
moffat_fit_test_check_perrs(cpl_array *perrs, double aRMS, double aChiSq,
                            moffat_fit_data_t aExpected)
{
  const double *e = cpl_array_get_data_double_const(perrs);
  cpl_test(e[0] < aExpected.bge);
  cpl_test(e[1] < aExpected.fluxe);
  cpl_test(e[2] < aExpected.xce);
  cpl_test(e[3] < aExpected.yce);
  cpl_test(e[4] < aExpected.alphaxe);
  cpl_test(e[5] < aExpected.alphaye);
  cpl_test(e[6] < aExpected.betae);
  cpl_test(e[7] < aExpected.rhoe);

  /* anything better than the upper limits of expected diagnostics is good */
  cpl_test(aRMS < aExpected.rms);
  cpl_test(aChiSq < aExpected.chisq);
} /* moffat_fit_test_check_perrs() */

/*----------------------------------------------------------------------------*/
/**
  @brief    Test program to check that fitting functions from the muse_utils
            work when called with the necessary data.

  This program explicitely tests
    muse_utils_image_fit_polynomial
    muse_utils_fit_multigauss_1d
    muse_utils_fit_moffat_2d
    muse_utils_pixtable_fit_line_gaussian
 */
/*----------------------------------------------------------------------------*/
int main(int argc, char **argv)
{
  UNUSED_ARGUMENTS(argc, argv);
  cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_DEBUG);

  /******************************************
   * Test muse_utils_image_fit_polynomial() *
   ******************************************/
  cpl_image *image = cpl_image_new(100, 100, CPL_TYPE_FLOAT);
  cpl_image_fill_noise_uniform(image, -5, 5);
  /* test with different polynomial orders */
  cpl_image *imfit0 = muse_utils_image_fit_polynomial(image, 0, 0),
            *imfit1 = muse_utils_image_fit_polynomial(image, 1, 1),
            *imfit2 = muse_utils_image_fit_polynomial(image, 2, 2),
            *imfit3 = muse_utils_image_fit_polynomial(image, 3, 3);
  /* check that the differences are not much greater than the original noise */
  cpl_test_image_abs(image, imfit0, 5.04);
  cpl_test_image_abs(image, imfit1, 5.13);
  cpl_test_image_abs(image, imfit2, 5.30);
  cpl_test_image_abs(image, imfit3, 5.43);
  cpl_image_delete(imfit0);
  cpl_image_delete(imfit1);
  cpl_image_delete(imfit2);
  cpl_image_delete(imfit3);
  /* failure cases */
  cpl_errorstate ps = cpl_errorstate_get();
  cpl_image *imfit = muse_utils_image_fit_polynomial(NULL, 0, 0);
  cpl_test(!cpl_errorstate_is_equal(ps) &&                      /* NULL input */
           cpl_error_get_code() == CPL_ERROR_NULL_INPUT);
  cpl_errorstate_set(ps);
  cpl_test_null(imfit);
  ps = cpl_errorstate_get();
  imfit = muse_utils_image_fit_polynomial(image, 105, 105);
  cpl_test(!cpl_errorstate_is_equal(ps) &&  /* too high orders for image size */
           cpl_error_get_code() == CPL_ERROR_DATA_NOT_FOUND);
  cpl_errorstate_set(ps);
  cpl_image_delete(image);
  image = cpl_image_new(100, 100, CPL_TYPE_FLOAT);
  cpl_image_reject_value(image, CPL_VALUE_ZERO);
  ps = cpl_errorstate_get();
  imfit = muse_utils_image_fit_polynomial(image, 5, 5);
  cpl_test(!cpl_errorstate_is_equal(ps) &&        /* all input pixels are bad */
           cpl_error_get_code() == CPL_ERROR_DATA_NOT_FOUND);
  cpl_errorstate_set(ps);
  cpl_image_delete(image);

  /***************************************
   * Test muse_utils_fit_multigauss_1d() *
   ***************************************/
#define NDATA 30
  cpl_vector *x = cpl_vector_new(NDATA),
             *y = cpl_vector_new(NDATA),
             *ye = cpl_vector_new(NDATA);
  cpl_bivector *by = cpl_bivector_wrap_vectors(y, ye);
  gaussian_test_fill_vectors(&g1, x, by);
#if 0
  printf("y bivector:\n");
  cpl_bivector_dump(by, stdout);
  fflush(stdout);
#endif

  cpl_vector *pcoeffs = cpl_vector_new(2); /* flat linear polynomial */
  cpl_vector_set(pcoeffs, 0, 0.); /* set correct coeffs */
  cpl_vector_set(pcoeffs, 1, 0.);
  double sigma = 0.4; /* set slightly wrong sigma */
  cpl_vector *centers = cpl_vector_new(3);
  cpl_vector_set(centers, 0, 10.); /* set correct estimates for centers */
  cpl_vector_set(centers, 1, 15.);
  cpl_vector_set(centers, 2, 25.);
  cpl_vector *fluxes = cpl_vector_new(3);
  cpl_vector_set(fluxes, 0, 1.); /* set wrong estimates for fluxes */
  cpl_vector_set(fluxes, 1, 1.);
  cpl_vector_set(fluxes, 2, 1.);
  double mse, rchisq;
  cpl_matrix *covariance;
  cpl_error_code rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, fluxes,
                                                   pcoeffs, &mse, &rchisq,
                                                   &covariance);
  printf("results 1 (rc = %d, %e, %e), sigma = %f\n  coefficients:\n",
         rc, mse, rchisq, sigma);
  cpl_vector_dump(pcoeffs, stdout);
  printf("  centers:\n");
  cpl_vector_dump(centers, stdout);
  printf("  fluxes:\n");
  cpl_vector_dump(fluxes, stdout);
  printf("  covariance:\n");
  cpl_matrix_dump(covariance, stdout);
  cpl_matrix_delete(covariance);
  fflush(stdout);
  cpl_test(rc == CPL_ERROR_NONE);
  /* XXX it should really recover the zero level much better, but       *
   *     starting with CPL 6.4 it does not even get to FLT_MIN any more */
  cpl_test(fabs(cpl_vector_get(pcoeffs, 0)) < 1e-24 &&
           fabs(cpl_vector_get(pcoeffs, 1)) < 1e-24);
  cpl_test(fabs(sigma - 0.5) < DBL_EPSILON);
  cpl_test(fabs(cpl_vector_get(centers, 0) - 10.) < DBL_EPSILON &&
           fabs(cpl_vector_get(centers, 1) - 15.) < DBL_EPSILON &&
           fabs(cpl_vector_get(centers, 2) - 25.) < DBL_EPSILON);
  cpl_test(fabs(cpl_vector_get(fluxes, 0) - 10.) < 100.*DBL_EPSILON &&
           fabs(cpl_vector_get(fluxes, 1) - 1000.) < 100.*DBL_EPSILON &&
           fabs(cpl_vector_get(fluxes, 2) - 100.) < 100.*DBL_EPSILON);
  cpl_vector_delete(pcoeffs);
  cpl_vector_delete(fluxes);
  /* next run */
  cpl_vector_set(centers, 0, 10.1); /* shift the centers a bit */
  cpl_vector_set(centers, 1, 14.8);
  cpl_vector_set(centers, 2, 25.5);
  /* no flux estimates and no polynomial */
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, NULL,
                                    NULL, &mse, &rchisq,
                                    &covariance);
  printf("results 2 (rc = %d, %e, %e), sigma = %f\n  centers:\n",
         rc, mse, rchisq, sigma);
  cpl_vector_dump(centers, stdout);
  printf("  covariance:\n");
  cpl_matrix_dump(covariance, stdout);
  cpl_matrix_delete(covariance);
  fflush(stdout);
  cpl_test(rc == CPL_ERROR_NONE);
  cpl_test(fabs(sigma - 0.5) < DBL_EPSILON);
  cpl_test(fabs(cpl_vector_get(centers, 0) - 10.) < DBL_EPSILON &&
           fabs(cpl_vector_get(centers, 1) - 15.) < DBL_EPSILON &&
           fabs(cpl_vector_get(centers, 2) - 25.) < DBL_EPSILON);
  /* no MSE, chi**2, no covariance matrix, should work just the same */
  sigma = 0.45; /* set slightly wrong sigma again */
  cpl_vector_set(centers, 0, 10.1); /* shift the centers a bit */
  cpl_vector_set(centers, 1, 14.8);
  cpl_vector_set(centers, 2, 25.3);
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, NULL,
                                    NULL, NULL, NULL, NULL);
  printf("results 3 (rc = %d), sigma = %f\n  centers:\n", rc, sigma);
  cpl_vector_dump(centers, stdout);
  fflush(stdout);
  cpl_test(rc == CPL_ERROR_NONE);
  cpl_test(fabs(sigma - 0.5) < 0.05);
  cpl_test(fabs(cpl_vector_get(centers, 0) - 10.) < DBL_EPSILON &&
           fabs(cpl_vector_get(centers, 1) - 15.) < DBL_EPSILON &&
           fabs(cpl_vector_get(centers, 2) - 25.) < DBL_EPSILON);
  cpl_vector_delete(centers);

  /* slightly more difficult problem but only two peaks */
  gaussian_test_fill_vectors(&g2, x, by);
#if 0
  printf("y bivector:\n");
  cpl_bivector_dump(by, stdout);
  fflush(stdout);
#endif
  pcoeffs = cpl_vector_new(2); /* mis-estimate 2nd-order background as 1st order */
  cpl_vector_set(pcoeffs, 0, 11.); /* set only slightly wrong coeffs */
  cpl_vector_set(pcoeffs, 1, 0.6);
  sigma = 0.9; /* set slightly wrong sigma */
  centers = cpl_vector_new(2);
  cpl_vector_set(centers, 0, 11.9); /* set slightly wrong estimates for centers */
  cpl_vector_set(centers, 1, 24.1);
  fluxes = cpl_vector_new(2);
  cpl_vector_set(fluxes, 0, 140.); /* set slightly wrong estimates for fluxes */
  cpl_vector_set(fluxes, 1, 260.);
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, fluxes,
                                    pcoeffs, &mse, &rchisq, NULL);
  cpl_test(rc == CPL_ERROR_NONE);
  printf("results 4 (rc = %d, %e, %e), sigma = %f\n  coefficients:\n",
         rc, mse, rchisq, sigma);
  cpl_vector_dump(pcoeffs, stdout);
  printf("  centers:\n");
  cpl_vector_dump(centers, stdout);
  printf("  fluxes:\n");
  cpl_vector_dump(fluxes, stdout);
  fflush(stdout);
  cpl_test_abs(cpl_vector_get(pcoeffs, 0), 5.00, 0.3);
  cpl_test_abs(cpl_vector_get(pcoeffs, 1), 1.95, 0.3);
  cpl_test(fabs(sigma - 1.) < 0.05);
  cpl_test(fabs(cpl_vector_get(centers, 0) - 12.) < 0.01 &&
           fabs(cpl_vector_get(centers, 1) - 24.) < 0.05);
  cpl_test(fabs(cpl_vector_get(fluxes, 0) - 150.) < 20. &&
           fabs(cpl_vector_get(fluxes, 1) - 250.) < 5.);
  /* test fixed sigma */
  sigma = -2.0; /* set badly wrong but negative (= fixed) sigma */
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, fluxes,
                                    pcoeffs, &mse, &rchisq, NULL);
  cpl_test(rc == CPL_ERROR_NONE);
  printf("results 5 (rc = %d, %e, %e), sigma = %f\n  coefficients:\n",
         rc, mse, rchisq, sigma);
  cpl_vector_dump(pcoeffs, stdout);
  printf("  centers:\n");
  cpl_vector_dump(centers, stdout);
  printf("  fluxes:\n");
  cpl_vector_dump(fluxes, stdout);
  fflush(stdout);
  cpl_test(sigma - 2.0 == 0.0);
  cpl_test_abs(cpl_vector_get(pcoeffs, 0), 5.00, 1.3);
  cpl_test_abs(cpl_vector_get(pcoeffs, 1), 1.95, 0.7);
  cpl_vector_delete(pcoeffs);

  /* test failure cases */
  /* non-equal parameter vector lengths */
  cpl_vector_set_size(fluxes, 3);
  ps = cpl_errorstate_get();
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, fluxes,
                                    pcoeffs, &mse, &rchisq, NULL);
  cpl_test(rc == CPL_ERROR_INCOMPATIBLE_INPUT);
  cpl_errorstate_set(ps);
  cpl_vector_delete(fluxes);
  /* non-equal data vector lengths */
  cpl_vector_set_size(x, NDATA + 1);
  ps = cpl_errorstate_get();
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, NULL,
                                    NULL, NULL, NULL, NULL);
  cpl_test(rc == CPL_ERROR_INCOMPATIBLE_INPUT);
  cpl_errorstate_set(ps);
  cpl_vector_set_size(x, NDATA);
  /* test NULL inputs */
  ps = cpl_errorstate_get();
  rc = muse_utils_fit_multigauss_1d(NULL, by, centers, &sigma, NULL,
                                    NULL, NULL, NULL, NULL);
  cpl_test(rc == CPL_ERROR_NULL_INPUT);
  cpl_errorstate_set(ps);
  rc = muse_utils_fit_multigauss_1d(x, NULL, centers, &sigma, NULL,
                                    NULL, NULL, NULL, NULL);
  cpl_test(rc == CPL_ERROR_NULL_INPUT);
  cpl_errorstate_set(ps);
  rc = muse_utils_fit_multigauss_1d(x, by, NULL, &sigma, NULL,
                                    NULL, NULL, NULL, NULL);
  cpl_test(rc == CPL_ERROR_NULL_INPUT);
  cpl_errorstate_set(ps);
  rc = muse_utils_fit_multigauss_1d(x, by, centers, NULL, NULL,
                                    NULL, NULL, NULL, NULL);
  cpl_test(rc == CPL_ERROR_NULL_INPUT);
  cpl_errorstate_set(ps);
  /* with y errors set to zero */
  ps = cpl_errorstate_get();
  cpl_vector_fill(cpl_bivector_get_y(by), -1.);
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, NULL,
                                    NULL, NULL, NULL, NULL);
  cpl_test(rc == CPL_ERROR_ILLEGAL_INPUT);
  cpl_errorstate_set(ps);
  cpl_bivector_delete(by);
  /* less points than parameters */
  cpl_vector_set_size(x, 4);
  by = cpl_bivector_wrap_vectors(cpl_vector_duplicate(x),
                                 cpl_vector_duplicate(x));
  ps = cpl_errorstate_get();
  rc = muse_utils_fit_multigauss_1d(x, by, centers, &sigma, NULL,
                                    NULL, NULL, &rchisq, NULL);
  cpl_test(rc == CPL_ERROR_ILLEGAL_INPUT);
  cpl_errorstate_set(ps);
  cpl_vector_delete(x);
  cpl_bivector_delete(by);
  cpl_vector_delete(centers);

  /***********************************
   * Test muse_utils_fit_moffat_2d() *
   ***********************************/
  int i;
  for (i = 0; i < NEXPECTED; i++) {
    cpl_msg_info(__func__, "________ Running test with star %d ________", i+1);
    cpl_vector *val, *err;
    const float (*star)[4] = i == 0
                           ? kStar1 : (i == 1 ? kStar7 : kMoffat1);
    cpl_matrix *pos = moffat_fit_test_fill_data(star, &val, &err);
    cpl_array *params = cpl_array_new(8, CPL_TYPE_DOUBLE),
              *perrs = cpl_array_new(8, CPL_TYPE_DOUBLE),
              *pflags = cpl_array_new(8, CPL_TYPE_INT);
    double rms = 0., chisq = 0.;

    cpl_array_set(params, 2, kExpected[i].xi);
    cpl_array_set(params, 3, kExpected[i].yi);
    cpl_msg_debug(__func__, "Serious test 1 follows (star %d)", i+1);
    rc = muse_utils_fit_moffat_2d(pos, val, err, params, perrs, pflags,
                                  &rms, &chisq);
    cpl_test(rc == CPL_ERROR_NONE);
#if 0
    cpl_array_dump(params, 0, 8, stdout);
    printf("rms = %f, chisq = %f, parameter errors:\n", rms, chisq);
    cpl_array_dump(perrs, 0, 8, stdout);
    fflush(stdout);
#endif

    /* check that the output parameters are within strict limits */
    moffat_fit_test_check_params(params, kExpected[i], 0, 0.2);
    /* check that output error information agrees */
    moffat_fit_test_check_perrs(perrs, rms, chisq, kExpected[i]);

    /* before deleting good inputs, check failure cases */
    if (i == 0) {
      cpl_errorstate prestate = cpl_errorstate_get();

      /* without any parameters */
      rc = muse_utils_fit_moffat_2d(NULL, NULL, NULL, NULL, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_NULL_INPUT);
      cpl_errorstate_set(prestate);

      /* without position array */
      rc = muse_utils_fit_moffat_2d(NULL, val, err, params, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_NULL_INPUT);
      cpl_errorstate_set(prestate);

      /* without value array */
      rc = muse_utils_fit_moffat_2d(pos, NULL, err, params, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_NULL_INPUT);
      cpl_errorstate_set(prestate);

      /* without parameter array */
      rc = muse_utils_fit_moffat_2d(pos, val, err, NULL, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_NULL_INPUT);
      cpl_errorstate_set(prestate);

      /* with unequal positions/values */
      cpl_matrix *pos2 = cpl_matrix_duplicate(pos);
      cpl_matrix_erase_rows(pos2, 10, NMAX);
#if 0
      cpl_msg_debug(__func__, ">>>>>>>>>>>> %"CPL_SIZE_FORMAT"%"CPL_SIZE_FORMAT
                    " %"CPL_SIZE_FORMAT" <<<<<<<<<<<<<<",
                    cpl_matrix_get_nrow(pos2), cpl_matrix_get_ncol(pos2),
                    cpl_vector_get_size(val));
#endif
      rc = muse_utils_fit_moffat_2d(pos2, val, NULL, params, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_INCOMPATIBLE_INPUT);
      cpl_errorstate_set(prestate);

      /* with unequal values/errors */
      cpl_vector *val2 = cpl_vector_duplicate(val);
      cpl_vector_set_size(val2, 10);
#if 0
      cpl_msg_debug(__func__, ">>>>>>>>>>>> %"CPL_SIZE_FORMAT", %"CPL_SIZE_FORMAT
                    " <<<<<<<<<<<<<<",
                    cpl_vector_get_size(val2), cpl_vector_get_size(err));
#endif
      rc = muse_utils_fit_moffat_2d(pos2, val2, err, params, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_INCOMPATIBLE_INPUT);
      cpl_errorstate_set(prestate);

      /* with too few positions */
      cpl_matrix_erase_rows(pos2, 7, NMAX);
      cpl_vector_set_size(val2, 7);
      cpl_vector *err2 = cpl_vector_duplicate(err);
      cpl_vector_set_size(err2, 7);
#if 0
      cpl_msg_debug(__func__, ">>>>>>>>>>>> %"CPL_SIZE_FORMAT"%"CPL_SIZE_FORMAT
                    " %"CPL_SIZE_FORMAT", %"CPL_SIZE_FORMAT" <<<<<<<<<<<<<<",
                    cpl_matrix_get_nrow(pos2), cpl_matrix_get_ncol(pos2),
                    cpl_vector_get_size(val2), cpl_vector_get_size(err2));
#endif
      rc = muse_utils_fit_moffat_2d(pos2, val2, err2, params, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_SINGULAR_MATRIX);
      cpl_errorstate_set(prestate);

      /* cleanup */
      cpl_matrix_delete(pos2);
      cpl_vector_delete(val2);
      cpl_vector_delete(err2);

      /* with wrong type for parameter array */
      rc = muse_utils_fit_moffat_2d(pos, val, err, pflags, NULL, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_INVALID_TYPE);
      cpl_errorstate_set(prestate);

      /* with wrong type for parameter errors array */
      rc = muse_utils_fit_moffat_2d(pos, val, err, params, pflags, NULL,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_INVALID_TYPE);
      cpl_errorstate_set(prestate);

      /* with wrong type for parameter flags array */
      rc = muse_utils_fit_moffat_2d(pos, val, err, params, NULL, perrs,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_INVALID_TYPE);
      cpl_errorstate_set(prestate);

      /* with only fixed parameters */
      cpl_array *pflags2 = cpl_array_new(8, CPL_TYPE_INT);
      cpl_array_fill_window_int(pflags2, 0, 8, 0);
      rc = muse_utils_fit_moffat_2d(pos, val, err, params, NULL, pflags2,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_ILLEGAL_INPUT);
      cpl_errorstate_set(prestate);

      /* with fixed parameter without corresponding first guess */
      cpl_array_fill_window_int(pflags2, 0, 8, 1); /* all free ...   */
      cpl_array_set_int(pflags2, 1, 0);            /* ... except one */
      cpl_array *params2 = cpl_array_new(8, CPL_TYPE_DOUBLE);
      rc = muse_utils_fit_moffat_2d(pos, val, err, params2, NULL, pflags2,
                                    NULL, NULL);
      cpl_test(rc == CPL_ERROR_ILLEGAL_INPUT);
      cpl_errorstate_set(prestate);

      /* cleanup again */
      cpl_array_delete(params2);
      cpl_array_delete(pflags2);

      /* flat profile */
      val2 = cpl_vector_new(cpl_vector_get_size(val));
      cpl_vector_fill(val2, 20.);
      cpl_array_fill_window_invalid(params, 0, 8);
      rc = muse_utils_fit_moffat_2d(pos, val2, err, params, NULL, NULL, NULL, NULL);
      cpl_test(rc == CPL_ERROR_NONE);
      cpl_errorstate_set(prestate);
#if 0
      cpl_array_dump(params, 0, 8, stdout);
      fflush(stdout);
#endif
      cpl_test(fabs(cpl_array_get_double(params, 0, NULL) - 20.) < DBL_EPSILON);
      cpl_test(cpl_array_get_double(params, 1, NULL) == 0.);
      cpl_vector_delete(val2);
    } /* if i == 0 */
    cpl_array_delete(params);
    cpl_array_delete(perrs);
    cpl_array_delete(pflags);

    /* test that we get similar results, if we don't *
     * pass initial position or the flags array      */
    params = cpl_array_new(8, CPL_TYPE_DOUBLE);
    cpl_msg_debug(__func__, "Serious test 2 follows (star %d)", i+1);
    rc = muse_utils_fit_moffat_2d(pos, val, err, params, NULL, NULL, NULL, NULL);
    cpl_test(rc == CPL_ERROR_NONE);
#if 0
    cpl_array_dump(params, 0, 8, stdout);
    fflush(stdout);
#endif
    moffat_fit_test_check_params(params, kExpected[i], 1, 1.);
    cpl_array_delete(params);

    /* test again the we get similar results, *
     * if we don't pass in error information  */
    params = cpl_array_new(8, CPL_TYPE_DOUBLE);
    cpl_msg_debug(__func__, "Serious test 3 follows (star %d)", i+1);
    rc = muse_utils_fit_moffat_2d(pos, val, NULL, params, NULL, NULL, NULL, NULL);
    cpl_test(rc == CPL_ERROR_NONE);
#if 0
    cpl_array_dump(params, 0, 8, stdout);
    fflush(stdout);
#endif
    /* here we can be more lenient on the accuracy */
    moffat_fit_test_check_params(params, kExpected[i], 2, 3.);
    cpl_array_delete(params);

    /* cleanup */
    cpl_matrix_delete(pos);
    cpl_vector_delete(val);
    cpl_vector_delete(err);
  } /* for i (all test stars) */

  /************************************************
   * Test muse_utils_pixtable_fit_line_gaussian() *
   ************************************************/
  muse_pixtable *pt = muse_pixtable_load(BASEFILENAME"_pixtable.fits");
  const double lref = 5577.339;
  ps = cpl_errorstate_get();
  double cen = muse_utils_pixtable_fit_line_gaussian(pt, lref, 5, 0.1, NULL, NULL),
         diff = lref - cen;
  cpl_test(cpl_errorstate_is_equal(ps));
  cpl_msg_debug(__func__, "cen = %f, d = %f", cen, diff);
  cpl_test_rel(diff, 1.25, 0.001); /* as precise as the reference lambda */
  /* correct the data for the shift and try again */
  cpl_table_add_scalar(pt->table, MUSE_PIXTABLE_LAMBDA, diff);
  cpl_array *fitvals = cpl_array_new(4, CPL_TYPE_DOUBLE),
            *fiterrs = cpl_array_new(4, CPL_TYPE_DOUBLE);
  ps = cpl_errorstate_get();
  cen = muse_utils_pixtable_fit_line_gaussian(pt, lref, 5, 0.1, fitvals, fiterrs);
  cpl_test(cpl_errorstate_is_equal(ps));
  diff = lref - cen;
  cpl_msg_debug(__func__, "cen = %f, d = %f", cen, diff);
  cpl_test_abs(diff, 0., 0.001); /* as precise as the reference lambda allows */
  /* check that the values and errors make sense, tested reference *
   * values using a fit in gnuplot on the same data which gave:    *
   *   A     = 3.86548  +/- 0.00387      (0.1001%)                 *
   *   B     = 0.025744 +/- 0.0001403    (0.5452%)                 *
   *   sigma = 1.22628  +/- 0.0009623    (0.07848%)                *
   *   x0    = 5577.34  +/- 0.001167     (2.092e-05%)              */
#if 0
  cpl_array_dump(fitvals, 0, 10, stdout);
  cpl_array_dump(fiterrs, 0, 10, stdout);
  fflush(stdout);
  muse_pixtable_restrict_wavelength(pt, 5570., 5585.);
  muse_pixtable_save(pt, "pt_test.fits");
#endif
  cpl_test_eq(cen, cpl_array_get_double(fitvals, 0, NULL)); /* center */
  cpl_test_rel(cpl_array_get_double(fitvals, 0, NULL), 5577.34, 0.001); /* xc */
  cpl_test_rel(cpl_array_get_double(fitvals, 1, NULL), 1.22628, 0.008); /* sigma */
  cpl_test_rel(cpl_array_get_double(fitvals, 2, NULL), 3.86548, 0.005); /* A */
  cpl_test_rel(cpl_array_get_double(fitvals, 3, NULL), 0.025744, 0.02); /* B */
  /* the CPL fit gives much higher error estimates than gnuplot... */
  cpl_test(cpl_array_get_double(fiterrs, 0, NULL) < 0.2); /* 1/5th of a pixel?!? */
  cpl_test(cpl_array_get_double(fiterrs, 1, NULL) < 0.2);
  cpl_test(cpl_array_get_double(fiterrs, 2, NULL) < 0.6);
  cpl_test(cpl_array_get_double(fiterrs, 3, NULL) < 0.03);
  cpl_array_delete(fitvals);
  cpl_array_delete(fiterrs);
  /* failure cases */
  ps = cpl_errorstate_get();
  cen = muse_utils_pixtable_fit_line_gaussian(NULL, lref, 5, 0.1, NULL, NULL);
  cpl_test(!cpl_errorstate_is_equal(ps) &&
           cpl_error_get_code() == CPL_ERROR_NULL_INPUT);
  cpl_errorstate_set(ps);
  cen = muse_utils_pixtable_fit_line_gaussian(pt, 12000., 5, 0.1, NULL, NULL);
  cpl_test(!cpl_errorstate_is_equal(ps) && /* wrong wavelength range */
           cpl_error_get_code() == CPL_ERROR_DATA_NOT_FOUND);
  cpl_errorstate_set(ps);
  cen = muse_utils_pixtable_fit_line_gaussian(pt, lref, 1e-5, 0.1, NULL, NULL);
  cpl_test(!cpl_errorstate_is_equal(ps) && /* too narrow wavelength range */
           cpl_error_get_code() == CPL_ERROR_DATA_NOT_FOUND);
  cpl_errorstate_set(ps);
  cpl_propertylist_delete(pt->header); /* create broken pixel table */
  pt->header = NULL;
  cen = muse_utils_pixtable_fit_line_gaussian(pt, lref, 5., 0.1, NULL, NULL);
  cpl_test(!cpl_errorstate_is_equal(ps)); /* failed resampling to spectrum */
  cpl_errorstate_set(ps);
  muse_pixtable_delete(pt);

  return cpl_test_end(0);
}
