/*
 * This file is part of the KMOS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef KMOS_PFITS_H
#define KMOS_PFITS_H

/*-----------------------------------------------------------------------------
   								Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
   								Functions prototypes
 -----------------------------------------------------------------------------*/

int kmos_pfits_get_naxis1(const cpl_propertylist *) ;
int kmos_pfits_get_naxis2(const cpl_propertylist *) ;
int kmos_pfits_get_naxis3(const cpl_propertylist *) ;
int kmos_pfits_get_ndit(const cpl_propertylist *) ;

double kmos_pfits_get_rotangle(const cpl_propertylist *) ;
double kmos_pfits_get_exptime(const cpl_propertylist *) ;

const char * kmos_pfits_get_tplid(const cpl_propertylist *) ;
const char * kmos_pfits_get_arcfile(const cpl_propertylist *) ;
const char * kmos_pfits_get_readmode(const cpl_propertylist *) ;

#endif
