/*
 * cpcieject.c
 *
 * Compact PCI Eject Daemon
 *
 *  Copyright (C) 2001 MontaVista Software Inc. <jpeters@mvista.com>
 *                                              <source@mvista.com>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
 *  AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL 
 *  THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

int SsdFd;

void
HandleSigIo(int sig)
{
	int Pid;

	switch (Pid = fork()) {
	case -1:
		perror("Cannot create a new process to shutdown system");
		exit(errno);
	case 0:
		execl("/sbin/halt", "halt", NULL);
	default:
		exit(0);
	}
}

main()
{
	int oflags;
	struct sigaction sa;

	/* Spawn the daemon */
	switch(fork()) {
	case -1:
		perror("Cannot spawn daemon");
		exit(1);
	case 0:
		/* This is the daemon */
		break;
	default:
		exit(0);
	}

	if ((SsdFd = open("/dev/cpcieject", O_RDONLY)) < 0) {
		perror("Could not open /dev/cpcieject");
		exit(errno);
	}

	fcntl(SsdFd, F_SETOWN, getpid());
	oflags = fcntl(SsdFd, F_GETFL);

	sa.sa_handler = HandleSigIo;
	sa.sa_flags = 0;
	sigemptyset(&sa.sa_mask);

	sigaction(SIGIO, &sa, NULL);

	fcntl(SsdFd, F_SETFL, oflags | FASYNC);

	pause();
}

