/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Gtk;
using GLib;
using Glade;
using Cowbell.Base;

using System.Threading;

namespace Cowbell.Gui
{
	public class ProgressWindow : GladeWindow
	{
		/* public properties */
		public Window Window {
			get { return window; }
		}

		public string Text {
			set {
				ProgressLabel.Markup = String.Format ("<i>{0}</i>",
			                                              GLib.Markup.EscapeText (value));
			}
		}

		/* public methods */
		public ProgressWindow () : base ("ProgressWindow.glade", "window")
		{
			progressbar.BarStyle = ProgressBarStyle.Continuous;
		}

		public void Pulse ()
		{
			progressbar.Pulse ();
		}

		public void Pulse (string text)
		{
			Text = text;
			Pulse ();
		}

		public int Run ()
		{
			return window.Run ();
		}

		public void Hide ()
		{
			window.Hide ();
		}

		/* private fields */
		[Glade.Widget] private Dialog window;
		[Glade.Widget] private ProgressBar progressbar;
		[Glade.Widget] private Label ProgressLabel;
	}
}
