/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using Gtk;
using System;
using Cowbell.Base;

namespace Cowbell.Gui
{
	public class PreferencesWindow : GladeWindow
	{
		/* public methods */
		public PreferencesWindow () : base ("PreferencesWindow.glade", "window")
		{
			PatternCombo.Changed += new EventHandler (OnPatternComboChanged);
			CloseButton.Clicked += new EventHandler (OnCloseButtonClicked);
			RenameCheckbox.Toggled += new EventHandler (OnRenameCheckboxToggled);

			RenameCheckbox.Active = Runtime.Preferences.RenameFiles;
			((Entry)PatternCombo.Child).Text = Runtime.Preferences.RenameFilesPattern;
			CoverImageCheckbox.Active = Runtime.Preferences.CacheCoverImage;
			PlaylistCheckbox.Active = Runtime.Preferences.ExportPlaylist;
		}

		public void Show ()
		{
			window.ShowAll ();
		}

		/* private fields */
		[Glade.Widget] Window window;
		[Glade.Widget] ToggleButton RenameCheckbox, CoverImageCheckbox, PlaylistCheckbox;
		[Glade.Widget] ComboBoxEntry PatternCombo;
		[Glade.Widget] Label PatternPreviewLabel;
		[Glade.Widget] Button CloseButton;

		/* private methods */
		private void OnRenameCheckboxToggled (object o, EventArgs args)
		{
			PatternPreviewLabel.Sensitive = RenameCheckbox.Active;
			PatternCombo.Sensitive = RenameCheckbox.Active;
		}

		private void OnCloseButtonClicked (object o, EventArgs args)
		{
			Runtime.Preferences.RenameFiles = RenameCheckbox.Active;
			Runtime.Preferences.RenameFilesPattern = ((Entry)PatternCombo.Child).Text;
			Runtime.Preferences.CacheCoverImage = CoverImageCheckbox.Active;
			Runtime.Preferences.ExportPlaylist = PlaylistCheckbox.Active;

			Runtime.Preferences.Save ();
			window.Destroy ();
		}

		private void OnPatternComboChanged (object o, EventArgs args)
		{
			string str = "";
			if (Runtime.Database.GlobalData != null && Runtime.Database.Count > 0
			    && Runtime.Database.GlobalData.Artist != "") {
				Song s = new Song ();

				s.Album = ((Song)Runtime.Database[0]).Album;
				s.Artist = ((Song)Runtime.Database[0]).Artist;
				s.Year = ((Song)Runtime.Database[0]).Year;
				s.Genre = ((Song)Runtime.Database[0]).Genre;
				s.Title = ((Song)Runtime.Database[0]).Title;
				s.TrackNumber = ((Song)Runtime.Database[0]).TrackNumber;

				str = FilenamePattern.Parse (s, ((Entry)PatternCombo.Child).Text);
			} else {
				str = FilenamePattern.Parse ((PatternCombo.Child as Entry).Text,
				                             Catalog.GetString ("Spiderwebs"), Catalog.GetString ("No Doubt"),
				                             Catalog.GetString ("Tragic Kingdom"), 1,
				                             Convert.ToUInt32 (DateTime.Now.Year),
				                             Catalog.GetString ("Ska"));
			}

			if (str != "") {
				str = String.Format (Catalog.GetString ("e.g., {0}.ogg"), str);
			}
			
			PatternPreviewLabel.Markup = String.Format ("<span style='italic' size='small'>{0}</span>",
			                                            GLib.Markup.EscapeText (str));
		}
	}
}
