/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Gtk;
using System.Diagnostics;
using Cowbell.Base;

namespace Cowbell.Gui
{
	public class AboutDialog : GladeWindow
	{
		/* public methods */
		public static void Create ()
		{
			new AboutDialog ();
		}

		public AboutDialog () : base ("AboutDialog.glade", "window")
		{
			/* AppName Version */
			AppName.Markup = String.Format (Catalog.GetString ("<span weight='bold' size='x-large'>{0} {1}</span>"),
			                                Globals.AppName, Globals.AppVersion);
			Image.Pixbuf = new Gdk.Pixbuf (null, "cowbell-48.png");
			
			window.Run ();
			window.Hide ();
		}

		/* private fields */
		[Glade.WidgetAttribute] Image Image;
		[Glade.WidgetAttribute] Label AppName;
		[Glade.WidgetAttribute] Dialog window;
	}
}
