/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.IO;
using System.Runtime.InteropServices;

namespace Cowbell.Base
{
	/* Stolen mostly from Mono.Posix.Catalog */
	public class Catalog
	{
		/* public methods */
		public static void Init ()
		{
			IntPtr package = Marshal.StringToHGlobalAuto ("cowbell");
			IntPtr localedir = Marshal.StringToHGlobalAuto (Globals.LocaleDir);
			IntPtr utf8 = Marshal.StringToHGlobalAuto ("UTF-8");
			BindTextDomain (package, localedir);
			BindTextDomainCodeset (package, utf8);
			TextDomain (package);
			Marshal.FreeHGlobal (package);
			Marshal.FreeHGlobal (localedir);
			Marshal.FreeHGlobal (utf8);
		}

		public static string GetString (string str)
		{
			string ret;
			IntPtr sing;

			sing = Marshal.StringToHGlobalAuto (str);
			ret = Marshal.PtrToStringAuto (Gettext (sing));

			Marshal.FreeHGlobal (sing);

			return ret;
		}
		
		public static string GetPluralString (string singular, string plural, int n)
		{
			string ret;
			IntPtr sing, plur;
		
			sing = Marshal.StringToHGlobalAuto (singular);
			plur = Marshal.StringToHGlobalAuto (plural);

			ret = Marshal.PtrToStringAnsi (NGettext (sing, plur, n));

			Marshal.FreeHGlobal (sing);
			Marshal.FreeHGlobal (plur);

			return ret;
		}

		/* private methods */
		[DllImport("libintl")]
		private static extern IntPtr bindtextdomain (IntPtr domainname, IntPtr dirname);

		[DllImport ("intl.dll", EntryPoint="bindtextdomain")]
		private static extern IntPtr bindtextdomain_win32 (IntPtr domainname, IntPtr dirname);

		private static void BindTextDomain (IntPtr domainname, IntPtr dirname)
		{
			if (Runtime.IsWindows) {
				bindtextdomain_win32 (domainname, dirname);
			} else {
				bindtextdomain (domainname, dirname);
			}
		}

		[DllImport("libintl")]
		private static extern IntPtr bind_textdomain_codeset (IntPtr domainname, IntPtr codeset);

		[DllImport ("intl.dll", EntryPoint="bind_textdomain_codeset")]
		private static extern IntPtr bind_textdomain_codeset_win32 (IntPtr domainname, IntPtr codeset);

		private static void BindTextDomainCodeset (IntPtr domainname, IntPtr codeset)
		{
			if (Runtime.IsWindows) {
				bind_textdomain_codeset_win32 (domainname, codeset);
			} else {
				bind_textdomain_codeset (domainname, codeset);
			}
		}

		[DllImport("libintl")]
		private static extern IntPtr textdomain (IntPtr domainname);

		[DllImport ("intl.dll", EntryPoint="textdomain")]
		private static extern IntPtr textdomain_win32 (IntPtr domainname);

		private static void TextDomain (IntPtr domainname)
		{
			if (Runtime.IsWindows) {
				textdomain_win32 (domainname);
			} else {
				textdomain (domainname);
			}
		}

		[DllImport("libintl")]
		private static extern IntPtr gettext (IntPtr msgid);

		[DllImport ("intl.dll", EntryPoint="gettext")]
		private static extern IntPtr gettext_win32 (IntPtr msgid);

		private static IntPtr Gettext (IntPtr msgid)
		{
			if (Runtime.IsWindows) {
				return gettext_win32 (msgid);
			} else {
				return gettext (msgid);
			}
		}

		[DllImport("libintl")]
		private static extern IntPtr ngettext (IntPtr msgid, IntPtr plural, Int32 n);

		[DllImport ("intl.dll", EntryPoint="gettext")]
		private static extern IntPtr ngettext_win32 (IntPtr msgid, IntPtr plural, Int32 n);

		private static IntPtr NGettext (IntPtr msgid, IntPtr plural, int n)
		{
			if (Runtime.IsWindows) {
				return ngettext_win32 (msgid, plural, n);
			} else {
				return ngettext (msgid, plural, n);
			}
		}
	}
}
