#!/bin/bash 
#
#   ConVirt   -  Copyright (c) 2008 Convirture Corp.
#   ======
#
# ConVirt is a Virtualization management tool with a graphical user
# interface that allows for performing the standard set of VM operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify various aspects of VM lifecycle management.
#
#
# This software is subject to the GNU General Public License, Version 2 (GPLv2)
# and for details, please consult it at:
#
#    http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
# 
#
# author : mkelkar@users.sourceforge.net
#

# parse the command line parameters
while getopts t:o:p:c:s:l: a
do case "$a" in
        t)      storage_type="$OPTARG";;
        o)      command="$OPTARG";;
        p)      usernameAndpassword="$OPTARG"
                ;;
        c)      mountParams="$OPTARG"
                
                ;;
        l)      logfilename="$OPTARG"
                ;;
	s)      script_loc="$OPTARG"
                ;;
        * )
          echo "$OPTARG"
          ;;
        esac
done

# source common files
source "$script_loc/storage_functions"

parse_field_values $mountParams 'server'
server=$value
parse_field_values $mountParams 'mount_point'
mountpoint=$value

check_prerequisite '' 'df'

echo "$command $storage_type $server " >>$logfilename

isRequiedParamPresent ${command} 'command'

case "$storage_type" in
  nfs )  
    case "$command" in

      GET_DISKS | GET_DISKS_SUMMARY ) output=`df --block-size=G | grep -v "Used" |  awk '{ if (NF == 1)  printf("%s ", $0); else print;}' |   grep -w ${server} | awk '{ if ($6 == "'${mountpoint}'") print; }' |  awk '{sub(/G/,"",$2); sub(/G/,"",$3); sub(/G/,"",$4); print "OUTPUT=OUTPUT|FILESYSTEM="$1"|SIZE="$2"|USED="$3"|AVAILABLE="$4"|MOUNT="$6""}'`
                  check_function_return_value "Unable to get stat:$output"
                  if [ "${output}" = "" ]; then
                    echo "ERROR:server name or mount point is incorrect"
                    exit 1
                  fi
                  echo $output
                #  ;; Fall through
      #GET_DISKS_SUMMARY)
                  total=0
                  output=`df --block-size=G | grep -v "Used" |  awk '{ if (NF == 1)  printf("%s ", $0); else print;}' |   grep -w ${server} | awk '{ if ($6 == "'${mountpoint}'") print; }' |  awk '{sub(/G/,"",$2); sub(/G/,"",$3); sub(/G/,"",$4); print "SUMMARY=SUMMARY|TOTAL="$2""}'`
                  echo $output
                  ;;
      DETACH ) 
                  ;;
      ATTACH ) 
               ;;
      * )
          echo "Usage: -t{nfs} -o{GET_DISKS|DETACH|ATTACH}"
          exit 1
          ;;
  esac
esac
