-- filename : char-def.lua
-- comment  : companion to char-def.tex (in ConTeXt)
-- author   : Hans Hagen, PRAGMA-ADE, Hasselt NL
-- copyright: PRAGMA ADE / ConTeXt Development Team
-- license  : see context related readme files

-- remark   : compact version

if not versions   then versions   = { } end versions['char-def'] = 1.001
if not characters then characters = { } end

characters.data = {
	[0x0000] = { unicodeslot=0x0000, category='cc', description='NULL' },
	[0x0001] = { unicodeslot=0x0001, category='cc', description='START OF HEADING' },
	[0x0002] = { unicodeslot=0x0002, category='cc', description='START OF TEXT' },
	[0x0003] = { unicodeslot=0x0003, category='cc', description='END OF TEXT' },
	[0x0004] = { unicodeslot=0x0004, category='cc', description='END OF TRANSMISSION' },
	[0x0005] = { unicodeslot=0x0005, category='cc', description='ENQUIRY' },
	[0x0006] = { unicodeslot=0x0006, category='cc', description='ACKNOWLEDGE' },
	[0x0007] = { unicodeslot=0x0007, category='cc', description='BELL' },
	[0x0008] = { unicodeslot=0x0008, category='cc', description='BACKSPACE' },
	[0x0009] = { unicodeslot=0x0009, category='cc', description='CHARACTER TABULATION' },
	[0x000A] = { unicodeslot=0x000A, category='cc', description='LINE FEED (LF)' },
	[0x000B] = { unicodeslot=0x000B, category='cc', description='LINE TABULATION' },
	[0x000C] = { unicodeslot=0x000C, category='cc', description='FORM FEED (FF)' },
	[0x000D] = { unicodeslot=0x000D, category='cc', description='CARRIAGE RETURN (CR)' },
	[0x000E] = { unicodeslot=0x000E, category='cc', description='SHIFT OUT' },
	[0x000F] = { unicodeslot=0x000F, category='cc', description='SHIFT IN' },
	[0x0010] = { unicodeslot=0x0010, category='cc', description='DATA LINK ESCAPE' },
	[0x0011] = { unicodeslot=0x0011, category='cc', description='DEVICE CONTROL ONE' },
	[0x0012] = { unicodeslot=0x0012, category='cc', description='DEVICE CONTROL TWO' },
	[0x0013] = { unicodeslot=0x0013, category='cc', description='DEVICE CONTROL THREE' },
	[0x0014] = { unicodeslot=0x0014, category='cc', description='DEVICE CONTROL FOUR' },
	[0x0015] = { unicodeslot=0x0015, category='cc', description='NEGATIVE ACKNOWLEDGE' },
	[0x0016] = { unicodeslot=0x0016, category='cc', description='SYNCHRONOUS IDLE' },
	[0x0017] = { unicodeslot=0x0017, category='cc', description='END OF TRANSMISSION BLOCK' },
	[0x0018] = { unicodeslot=0x0018, category='cc', description='CANCEL' },
	[0x0019] = { unicodeslot=0x0019, category='cc', description='END OF MEDIUM' },
	[0x001A] = { unicodeslot=0x001A, category='cc', description='SUBSTITUTE' },
	[0x001B] = { unicodeslot=0x001B, category='cc', description='ESCAPE' },
	[0x001C] = { unicodeslot=0x001C, category='cc', description='INFORMATION SEPARATOR FOUR' },
	[0x001D] = { unicodeslot=0x001D, category='cc', description='INFORMATION SEPARATOR THREE' },
	[0x001E] = { unicodeslot=0x001E, category='cc', description='INFORMATION SEPARATOR TWO' },
	[0x001F] = { unicodeslot=0x001F, category='cc', description='INFORMATION SEPARATOR ONE' },
	[0x0020] = { unicodeslot=0x0020, category='zs', adobename='space', description='SPACE' },
	[0x0021] = { unicodeslot=0x0021, category='po', adobename='exclam', description='EXCLAMATION MARK' },
	[0x0022] = { unicodeslot=0x0022, category='po', adobename='quotedbl', description='QUOTATION MARK' },
	[0x0023] = { unicodeslot=0x0023, category='po', adobename='numbersign', description='NUMBER SIGN' },
	[0x0024] = { unicodeslot=0x0024, category='sc', adobename='dollar', description='DOLLAR SIGN' },
	[0x0025] = { unicodeslot=0x0025, category='po', adobename='percent', contextname='percent', description='PERCENT SIGN' },
	[0x0026] = { unicodeslot=0x0026, category='po', adobename='ampersand', description='AMPERSAND' },
	[0x0027] = { unicodeslot=0x0027, category='po', adobename='quotesingle', description='APOSTROPHE' },
	[0x0028] = { unicodeslot=0x0028, category='ps', adobename='parenleft', description='LEFT PARENTHESIS' },
	[0x0029] = { unicodeslot=0x0029, category='pe', adobename='parenright', description='RIGHT PARENTHESIS' },
	[0x002A] = { unicodeslot=0x002A, category='po', adobename='asterisk', description='ASTERISK' },
	[0x002B] = { unicodeslot=0x002B, category='sm', adobename='plus', description='PLUS SIGN' },
	[0x002C] = { unicodeslot=0x002C, category='po', adobename='comma', description='COMMA' },
	[0x002D] = { unicodeslot=0x002D, category='pd', adobename='hyphen', description='HYPHEN-MINUS' },
	[0x002E] = { unicodeslot=0x002E, category='po', adobename='period', description='FULL STOP' },
	[0x002F] = { unicodeslot=0x002F, category='po', adobename='slash', description='SOLIDUS' },
	[0x0030] = { unicodeslot=0x0030, category='nd', adobename='zero', description='DIGIT ZERO' },
	[0x0031] = { unicodeslot=0x0031, category='nd', adobename='one', description='DIGIT ONE' },
	[0x0032] = { unicodeslot=0x0032, category='nd', adobename='two', description='DIGIT TWO' },
	[0x0033] = { unicodeslot=0x0033, category='nd', adobename='three', description='DIGIT THREE' },
	[0x0034] = { unicodeslot=0x0034, category='nd', adobename='four', description='DIGIT FOUR' },
	[0x0035] = { unicodeslot=0x0035, category='nd', adobename='five', description='DIGIT FIVE' },
	[0x0036] = { unicodeslot=0x0036, category='nd', adobename='six', description='DIGIT SIX' },
	[0x0037] = { unicodeslot=0x0037, category='nd', adobename='seven', description='DIGIT SEVEN' },
	[0x0038] = { unicodeslot=0x0038, category='nd', adobename='eight', description='DIGIT EIGHT' },
	[0x0039] = { unicodeslot=0x0039, category='nd', adobename='nine', description='DIGIT NINE' },
	[0x003A] = { unicodeslot=0x003A, category='po', adobename='colon', description='COLON' },
	[0x003B] = { unicodeslot=0x003B, category='po', adobename='semicolon', description='SEMICOLON' },
	[0x003C] = { unicodeslot=0x003C, category='sm', adobename='less', description='LESS-THAN SIGN' },
	[0x003D] = { unicodeslot=0x003D, category='sm', adobename='equal', description='EQUALS SIGN' },
	[0x003E] = { unicodeslot=0x003E, category='sm', adobename='greater', description='GREATER-THAN SIGN' },
	[0x003F] = { unicodeslot=0x003F, category='po', adobename='question', description='QUESTION MARK' },
	[0x0040] = { unicodeslot=0x0040, category='po', adobename='at', description='COMMERCIAL AT' },
	[0x0041] = { unicodeslot=0x0041, category='lu', adobename='A', description='LATIN CAPITAL LETTER A', lccode=0x0061 },
	[0x0042] = { unicodeslot=0x0042, category='lu', adobename='B', description='LATIN CAPITAL LETTER B', lccode=0x0062 },
	[0x0043] = { unicodeslot=0x0043, category='lu', adobename='C', description='LATIN CAPITAL LETTER C', lccode=0x0063 },
	[0x0044] = { unicodeslot=0x0044, category='lu', adobename='D', description='LATIN CAPITAL LETTER D', lccode=0x0064 },
	[0x0045] = { unicodeslot=0x0045, category='lu', adobename='E', description='LATIN CAPITAL LETTER E', lccode=0x0065 },
	[0x0046] = { unicodeslot=0x0046, category='lu', adobename='F', description='LATIN CAPITAL LETTER F', lccode=0x0066 },
	[0x0047] = { unicodeslot=0x0047, category='lu', adobename='G', description='LATIN CAPITAL LETTER G', lccode=0x0067 },
	[0x0048] = { unicodeslot=0x0048, category='lu', adobename='H', description='LATIN CAPITAL LETTER H', lccode=0x0068 },
	[0x0049] = { unicodeslot=0x0049, category='lu', adobename='I', description='LATIN CAPITAL LETTER I', lccode=0x0069 },
	[0x004A] = { unicodeslot=0x004A, category='lu', adobename='J', description='LATIN CAPITAL LETTER J', lccode=0x006A },
	[0x004B] = { unicodeslot=0x004B, category='lu', adobename='K', description='LATIN CAPITAL LETTER K', lccode=0x006B },
	[0x004C] = { unicodeslot=0x004C, category='lu', adobename='L', description='LATIN CAPITAL LETTER L', lccode=0x006C },
	[0x004D] = { unicodeslot=0x004D, category='lu', adobename='M', description='LATIN CAPITAL LETTER M', lccode=0x006D },
	[0x004E] = { unicodeslot=0x004E, category='lu', adobename='N', description='LATIN CAPITAL LETTER N', lccode=0x006E },
	[0x004F] = { unicodeslot=0x004F, category='lu', adobename='O', description='LATIN CAPITAL LETTER O', lccode=0x006F },
	[0x0050] = { unicodeslot=0x0050, category='lu', adobename='P', description='LATIN CAPITAL LETTER P', lccode=0x0070 },
	[0x0051] = { unicodeslot=0x0051, category='lu', adobename='Q', description='LATIN CAPITAL LETTER Q', lccode=0x0071 },
	[0x0052] = { unicodeslot=0x0052, category='lu', adobename='R', description='LATIN CAPITAL LETTER R', lccode=0x0072 },
	[0x0053] = { unicodeslot=0x0053, category='lu', adobename='S', description='LATIN CAPITAL LETTER S', lccode=0x0073 },
	[0x0054] = { unicodeslot=0x0054, category='lu', adobename='T', description='LATIN CAPITAL LETTER T', lccode=0x0074 },
	[0x0055] = { unicodeslot=0x0055, category='lu', adobename='U', description='LATIN CAPITAL LETTER U', lccode=0x0075 },
	[0x0056] = { unicodeslot=0x0056, category='lu', adobename='V', description='LATIN CAPITAL LETTER V', lccode=0x0076 },
	[0x0057] = { unicodeslot=0x0057, category='lu', adobename='W', description='LATIN CAPITAL LETTER W', lccode=0x0077 },
	[0x0058] = { unicodeslot=0x0058, category='lu', adobename='X', description='LATIN CAPITAL LETTER X', lccode=0x0078 },
	[0x0059] = { unicodeslot=0x0059, category='lu', adobename='Y', description='LATIN CAPITAL LETTER Y', lccode=0x0079 },
	[0x005A] = { unicodeslot=0x005A, category='lu', adobename='Z', description='LATIN CAPITAL LETTER Z', lccode=0x007A },
	[0x005B] = { unicodeslot=0x005B, category='ps', adobename='bracketleft', description='LEFT SQUARE BRACKET' },
	[0x005C] = { unicodeslot=0x005C, category='po', adobename='backslash', contextname='textbackslash', description='REVERSE SOLIDUS' },
	[0x005D] = { unicodeslot=0x005D, category='pe', adobename='bracketright', description='RIGHT SQUARE BRACKET' },
	[0x005E] = { unicodeslot=0x005E, category='sk', adobename='asciicircum', contextname='textasciicircum', description='CIRCUMFLEX ACCENT' },
	[0x005F] = { unicodeslot=0x005F, category='pc', adobename='underscore', contextname='textunderscore', description='LOW LINE' },
	[0x0060] = { unicodeslot=0x0060, category='sk', adobename='grave', contextname='textgrave', description='GRAVE ACCENT' },
	[0x0061] = { unicodeslot=0x0061, category='ll', adobename='a', description='LATIN SMALL LETTER A', uccode=0x0041 },
	[0x0062] = { unicodeslot=0x0062, category='ll', adobename='b', description='LATIN SMALL LETTER B', uccode=0x0042 },
	[0x0063] = { unicodeslot=0x0063, category='ll', adobename='c', description='LATIN SMALL LETTER C', uccode=0x0043 },
	[0x0064] = { unicodeslot=0x0064, category='ll', adobename='d', description='LATIN SMALL LETTER D', uccode=0x0044 },
	[0x0065] = { unicodeslot=0x0065, category='ll', adobename='e', description='LATIN SMALL LETTER E', uccode=0x0045 },
	[0x0066] = { unicodeslot=0x0066, category='ll', adobename='f', description='LATIN SMALL LETTER F', uccode=0x0046 },
	[0x0067] = { unicodeslot=0x0067, category='ll', adobename='g', description='LATIN SMALL LETTER G', uccode=0x0047 },
	[0x0068] = { unicodeslot=0x0068, category='ll', adobename='h', description='LATIN SMALL LETTER H', uccode=0x0048 },
	[0x0069] = { unicodeslot=0x0069, category='ll', adobename='i', description='LATIN SMALL LETTER I', uccode=0x0049 },
	[0x006A] = { unicodeslot=0x006A, category='ll', adobename='j', description='LATIN SMALL LETTER J', uccode=0x004A },
	[0x006B] = { unicodeslot=0x006B, category='ll', adobename='k', description='LATIN SMALL LETTER K', uccode=0x004B },
	[0x006C] = { unicodeslot=0x006C, category='ll', adobename='l', description='LATIN SMALL LETTER L', uccode=0x004C },
	[0x006D] = { unicodeslot=0x006D, category='ll', adobename='m', description='LATIN SMALL LETTER M', uccode=0x004D },
	[0x006E] = { unicodeslot=0x006E, category='ll', adobename='n', description='LATIN SMALL LETTER N', uccode=0x004E },
	[0x006F] = { unicodeslot=0x006F, category='ll', adobename='o', description='LATIN SMALL LETTER O', uccode=0x004F },
	[0x0070] = { unicodeslot=0x0070, category='ll', adobename='p', description='LATIN SMALL LETTER P', uccode=0x0050 },
	[0x0071] = { unicodeslot=0x0071, category='ll', adobename='q', description='LATIN SMALL LETTER Q', uccode=0x0051 },
	[0x0072] = { unicodeslot=0x0072, category='ll', adobename='r', description='LATIN SMALL LETTER R', uccode=0x0052 },
	[0x0073] = { unicodeslot=0x0073, category='ll', adobename='s', description='LATIN SMALL LETTER S', uccode=0x0053 },
	[0x0074] = { unicodeslot=0x0074, category='ll', adobename='t', description='LATIN SMALL LETTER T', uccode=0x0054 },
	[0x0075] = { unicodeslot=0x0075, category='ll', adobename='u', description='LATIN SMALL LETTER U', uccode=0x0055 },
	[0x0076] = { unicodeslot=0x0076, category='ll', adobename='v', description='LATIN SMALL LETTER V', uccode=0x0056 },
	[0x0077] = { unicodeslot=0x0077, category='ll', adobename='w', description='LATIN SMALL LETTER W', uccode=0x0057 },
	[0x0078] = { unicodeslot=0x0078, category='ll', adobename='x', description='LATIN SMALL LETTER X', uccode=0x0058 },
	[0x0079] = { unicodeslot=0x0079, category='ll', adobename='y', description='LATIN SMALL LETTER Y', uccode=0x0059 },
	[0x007A] = { unicodeslot=0x007A, category='ll', adobename='z', description='LATIN SMALL LETTER Z', uccode=0x005A },
	[0x007B] = { unicodeslot=0x007B, category='ps', adobename='braceleft', contextname='textbraceleft', description='LEFT CURLY BRACKET' },
	[0x007C] = { unicodeslot=0x007C, category='sm', adobename='bar', description='VERTICAL LINE' },
	[0x007D] = { unicodeslot=0x007D, category='pe', adobename='braceright', contextname='textbraceright', description='RIGHT CURLY BRACKET' },
	[0x007E] = { unicodeslot=0x007E, category='sm', adobename='asciitilde', contextname='textasciitilde', description='TILDE' },
	[0x007F] = { unicodeslot=0x007F, category='cc', description='DELETE' },
	[0x0080] = { unicodeslot=0x0080, category='cc' },
	[0x0081] = { unicodeslot=0x0081, category='cc' },
	[0x0082] = { unicodeslot=0x0082, category='cc', description='BREAK PERMITTED HERE' },
	[0x0083] = { unicodeslot=0x0083, category='cc', description='NO BREAK HERE' },
	[0x0084] = { unicodeslot=0x0084, category='cc' },
	[0x0085] = { unicodeslot=0x0085, category='cc', description='NEXT LINE (NEL)' },
	[0x0086] = { unicodeslot=0x0086, category='cc', description='START OF SELECTED AREA' },
	[0x0087] = { unicodeslot=0x0087, category='cc', description='END OF SELECTED AREA' },
	[0x0088] = { unicodeslot=0x0088, category='cc', description='CHARACTER TABULATION SET' },
	[0x0089] = { unicodeslot=0x0089, category='cc', description='CHARACTER TABULATION WITH JUSTIFICATION' },
	[0x008A] = { unicodeslot=0x008A, category='cc', description='LINE TABULATION SET' },
	[0x008B] = { unicodeslot=0x008B, category='cc', description='PARTIAL LINE FORWARD' },
	[0x008C] = { unicodeslot=0x008C, category='cc', description='PARTIAL LINE BACKWARD' },
	[0x008D] = { unicodeslot=0x008D, category='cc', description='REVERSE LINE FEED' },
	[0x008E] = { unicodeslot=0x008E, category='cc', description='SINGLE SHIFT TWO' },
	[0x008F] = { unicodeslot=0x008F, category='cc', description='SINGLE SHIFT THREE' },
	[0x0090] = { unicodeslot=0x0090, category='cc', description='DEVICE CONTROL STRING' },
	[0x0091] = { unicodeslot=0x0091, category='cc', description='PRIVATE USE ONE' },
	[0x0092] = { unicodeslot=0x0092, category='cc', description='PRIVATE USE TWO' },
	[0x0093] = { unicodeslot=0x0093, category='cc', description='SET TRANSMIT STATE' },
	[0x0094] = { unicodeslot=0x0094, category='cc', description='CANCEL CHARACTER' },
	[0x0095] = { unicodeslot=0x0095, category='cc', description='MESSAGE WAITING' },
	[0x0096] = { unicodeslot=0x0096, category='cc', description='START OF GUARDED AREA' },
	[0x0097] = { unicodeslot=0x0097, category='cc', description='END OF GUARDED AREA' },
	[0x0098] = { unicodeslot=0x0098, category='cc', description='START OF STRING' },
	[0x0099] = { unicodeslot=0x0099, category='cc' },
	[0x009A] = { unicodeslot=0x009A, category='cc', description='SINGLE CHARACTER INTRODUCER' },
	[0x009B] = { unicodeslot=0x009B, category='cc', description='CONTROL SEQUENCE INTRODUCER' },
	[0x009C] = { unicodeslot=0x009C, category='cc', description='STRING TERMINATOR' },
	[0x009D] = { unicodeslot=0x009D, category='cc', description='OPERATING SYSTEM COMMAND' },
	[0x009E] = { unicodeslot=0x009E, category='cc', description='PRIVACY MESSAGE' },
	[0x009F] = { unicodeslot=0x009F, category='cc', description='APPLICATION PROGRAM COMMAND' },
	[0x00A0] = { unicodeslot=0x00A0, category='zs', contextname='nonbreakablespace', description='NO-BREAK SPACE', specials={'nobreak',0x0020} },
	[0x00A1] = { unicodeslot=0x00A1, category='po', adobename='exclamdown', contextname='exclamdown', description='INVERTED EXCLAMATION MARK' },
	[0x00A2] = { unicodeslot=0x00A2, category='sc', adobename='cent', contextname='textcent', description='CENT SIGN' },
	[0x00A3] = { unicodeslot=0x00A3, category='sc', adobename='sterling', contextname='textsterling', description='POUND SIGN' },
	[0x00A4] = { unicodeslot=0x00A4, category='sc', adobename='currency', contextname='textcurrency', description='CURRENCY SIGN' },
	[0x00A5] = { unicodeslot=0x00A5, category='sc', adobename='yen', contextname='textyen', description='YEN SIGN' },
	[0x00A6] = { unicodeslot=0x00A6, category='so', adobename='brokenbar', contextname='textbrokenbar', description='BROKEN BAR' },
	[0x00A7] = { unicodeslot=0x00A7, category='so', adobename='section', contextname='sectionmark', description='SECTION SIGN' },
	[0x00A8] = { unicodeslot=0x00A8, category='sk', adobename='dieresis', contextname='textdiaeresis', description='DIAERESIS', specials={'compat',0x0020,0x0308} },
	[0x00A9] = { unicodeslot=0x00A9, category='so', adobename='copyright', contextname='copyright', description='COPYRIGHT SIGN' },
	[0x00AA] = { unicodeslot=0x00AA, category='ll', adobename='ordfeminine', contextname='ordfeminine', description='FEMININE ORDINAL INDICATOR', specials={'super',0x0061} },
	[0x00AB] = { unicodeslot=0x00AB, category='pi', adobename='guillemotleft', contextname='leftguillemot', description='LEFT-POINTING DOUBLE ANGLE QUOTATION MARK' },
	[0x00AC] = { unicodeslot=0x00AC, category='sm', adobename='logicalnot', contextname='textlognot', description='NOT SIGN' },
	[0x00AD] = { unicodeslot=0x00AD, category='cf', contextname='softhyphen', description='SOFT HYPHEN' },
	[0x00AE] = { unicodeslot=0x00AE, category='so', adobename='registered', contextname='registered', description='REGISTERED SIGN' },
	[0x00AF] = { unicodeslot=0x00AF, category='sk', adobename='macron', contextname='textmacron', description='MACRON', specials={'compat',0x0020,0x0304} },
	[0x00B0] = { unicodeslot=0x00B0, category='so', adobename='degree', contextname='textdegree', description='DEGREE SIGN' },
	[0x00B1] = { unicodeslot=0x00B1, category='sm', adobename='plusminus', contextname='textpm', description='PLUS-MINUS SIGN' },
	[0x00B2] = { unicodeslot=0x00B2, category='no', contextname='twosuperior', description='SUPERSCRIPT TWO', specials={'super',0x0032} },
	[0x00B3] = { unicodeslot=0x00B3, category='no', contextname='threesuperior', description='SUPERSCRIPT THREE', specials={'super',0x0033} },
	[0x00B4] = { unicodeslot=0x00B4, category='sk', adobename='acute', contextname='textacute', description='ACUTE ACCENT', specials={'compat',0x0020,0x0301} },
	[0x00B5] = { unicodeslot=0x00B5, category='ll', adobename='mu', contextname='textmu', description='MICRO SIGN', uccode=0x039C, specials={'compat',0x03BC} },
	[0x00B6] = { unicodeslot=0x00B6, category='so', adobename='paragraph', contextname='paragraphmark', description='PILCROW SIGN' },
	[0x00B7] = { unicodeslot=0x00B7, category='po', adobename='periodcentered', contextname='periodcentered', description='MIDDLE DOT' },
	[0x00B8] = { unicodeslot=0x00B8, category='sk', adobename='cedilla', contextname='textcedilla', description='CEDILLA', specials={'compat',0x0020,0x0327} },
	[0x00B9] = { unicodeslot=0x00B9, category='no', contextname='onesuperior', description='SUPERSCRIPT ONE', specials={'super',0x0031} },
	[0x00BA] = { unicodeslot=0x00BA, category='ll', adobename='ordmasculine', contextname='ordmasculine', description='MASCULINE ORDINAL INDICATOR', specials={'super',0x006F} },
	[0x00BB] = { unicodeslot=0x00BB, category='pf', adobename='guillemotright', contextname='rightguillemot', description='RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK' },
	[0x00BC] = { unicodeslot=0x00BC, category='no', adobename='onequarter', contextname='onequarter', description='VULGAR FRACTION ONE QUARTER', specials={'fraction',0x0031,0x2044,0x0034} },
	[0x00BD] = { unicodeslot=0x00BD, category='no', adobename='onehalf', contextname='onehalf', description='VULGAR FRACTION ONE HALF', specials={'fraction',0x0031,0x2044,0x0032} },
	[0x00BE] = { unicodeslot=0x00BE, category='no', adobename='threequarters', contextname='threequarter', description='VULGAR FRACTION THREE QUARTERS', specials={'fraction',0x0033,0x2044,0x0034} },
	[0x00BF] = { unicodeslot=0x00BF, category='po', adobename='questiondown', contextname='questiondown', description='INVERTED QUESTION MARK' },
	[0x00C0] = { unicodeslot=0x00C0, category='lu', adobename='Agrave', contextname='Agrave', description='LATIN CAPITAL LETTER A WITH GRAVE', shcode=0x0041, lccode=0x00E0, specials={'char',0x0041,0x0300} },
	[0x00C1] = { unicodeslot=0x00C1, category='lu', adobename='Aacute', contextname='Aacute', description='LATIN CAPITAL LETTER A WITH ACUTE', shcode=0x0041, lccode=0x00E1, specials={'char',0x0041,0x0301} },
	[0x00C2] = { unicodeslot=0x00C2, category='lu', adobename='Acircumflex', contextname='Acircumflex', description='LATIN CAPITAL LETTER A WITH CIRCUMFLEX', shcode=0x0041, lccode=0x00E2, specials={'char',0x0041,0x0302} },
	[0x00C3] = { unicodeslot=0x00C3, category='lu', adobename='Atilde', contextname='Atilde', description='LATIN CAPITAL LETTER A WITH TILDE', shcode=0x0041, lccode=0x00E3, specials={'char',0x0041,0x0303} },
	[0x00C4] = { unicodeslot=0x00C4, category='lu', adobename='Adieresis', contextname='Adiaeresis', description='LATIN CAPITAL LETTER A WITH DIAERESIS', shcode=0x0041, lccode=0x00E4, specials={'char',0x0041,0x0308} },
	[0x00C5] = { unicodeslot=0x00C5, category='lu', adobename='Aring', contextname='Aring', description='LATIN CAPITAL LETTER A WITH RING ABOVE', shcode=0x0041, lccode=0x00E5, specials={'char',0x0041,0x030A} },
	[0x00C6] = { unicodeslot=0x00C6, category='lu', adobename='AE', contextname='AEligature', description='LATIN CAPITAL LETTER AE', lccode=0x00E6 },
	[0x00C7] = { unicodeslot=0x00C7, category='lu', adobename='Ccedilla', contextname='Ccedilla', description='LATIN CAPITAL LETTER C WITH CEDILLA', shcode=0x0043, lccode=0x00E7, specials={'char',0x0043,0x0327} },
	[0x00C8] = { unicodeslot=0x00C8, category='lu', adobename='Egrave', contextname='Egrave', description='LATIN CAPITAL LETTER E WITH GRAVE', shcode=0x0045, lccode=0x00E8, specials={'char',0x0045,0x0300} },
	[0x00C9] = { unicodeslot=0x00C9, category='lu', adobename='Eacute', contextname='Eacute', description='LATIN CAPITAL LETTER E WITH ACUTE', shcode=0x0045, lccode=0x00E9, specials={'char',0x0045,0x0301} },
	[0x00CA] = { unicodeslot=0x00CA, category='lu', adobename='Ecircumflex', contextname='Ecircumflex', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX', shcode=0x0045, lccode=0x00EA, specials={'char',0x0045,0x0302} },
	[0x00CB] = { unicodeslot=0x00CB, category='lu', adobename='Edieresis', contextname='Ediaeresis', description='LATIN CAPITAL LETTER E WITH DIAERESIS', shcode=0x0045, lccode=0x00EB, specials={'char',0x0045,0x0308} },
	[0x00CC] = { unicodeslot=0x00CC, category='lu', adobename='Igrave', contextname='Igrave', description='LATIN CAPITAL LETTER I WITH GRAVE', shcode=0x0049, lccode=0x00EC, specials={'char',0x0049,0x0300} },
	[0x00CD] = { unicodeslot=0x00CD, category='lu', adobename='Iacute', contextname='Iacute', description='LATIN CAPITAL LETTER I WITH ACUTE', shcode=0x0049, lccode=0x00ED, specials={'char',0x0049,0x0301} },
	[0x00CE] = { unicodeslot=0x00CE, category='lu', adobename='Icircumflex', contextname='Icircumflex', description='LATIN CAPITAL LETTER I WITH CIRCUMFLEX', shcode=0x0049, lccode=0x00EE, specials={'char',0x0049,0x0302} },
	[0x00CF] = { unicodeslot=0x00CF, category='lu', adobename='Idieresis', contextname='Idiaeresis', description='LATIN CAPITAL LETTER I WITH DIAERESIS', shcode=0x0049, lccode=0x00EF, specials={'char',0x0049,0x0308} },
	[0x00D0] = { unicodeslot=0x00D0, category='lu', adobename='Eth', contextname='Eth', description='LATIN CAPITAL LETTER ETH', lccode=0x00F0 },
	[0x00D1] = { unicodeslot=0x00D1, category='lu', adobename='Ntilde', contextname='Ntilde', description='LATIN CAPITAL LETTER N WITH TILDE', shcode=0x004E, lccode=0x00F1, specials={'char',0x004E,0x0303} },
	[0x00D2] = { unicodeslot=0x00D2, category='lu', adobename='Ograve', contextname='Ograve', description='LATIN CAPITAL LETTER O WITH GRAVE', shcode=0x004F, lccode=0x00F2, specials={'char',0x004F,0x0300} },
	[0x00D3] = { unicodeslot=0x00D3, category='lu', adobename='Oacute', contextname='Oacute', description='LATIN CAPITAL LETTER O WITH ACUTE', shcode=0x004F, lccode=0x00F3, specials={'char',0x004F,0x0301} },
	[0x00D4] = { unicodeslot=0x00D4, category='lu', adobename='Ocircumflex', contextname='Ocircumflex', description='LATIN CAPITAL LETTER O WITH CIRCUMFLEX', shcode=0x004F, lccode=0x00F4, specials={'char',0x004F,0x0302} },
	[0x00D5] = { unicodeslot=0x00D5, category='lu', adobename='Otilde', contextname='Otilde', description='LATIN CAPITAL LETTER O WITH TILDE', shcode=0x004F, lccode=0x00F5, specials={'char',0x004F,0x0303} },
	[0x00D6] = { unicodeslot=0x00D6, category='lu', adobename='Odieresis', contextname='Odiaeresis', description='LATIN CAPITAL LETTER O WITH DIAERESIS', shcode=0x004F, lccode=0x00F6, specials={'char',0x004F,0x0308} },
	[0x00D7] = { unicodeslot=0x00D7, category='sm', adobename='multiply', contextname='textmultiply', description='MULTIPLICATION SIGN' },
	[0x00D8] = { unicodeslot=0x00D8, category='lu', adobename='Oslash', contextname='Ostroke', description='LATIN CAPITAL LETTER O WITH STROKE', shcode=0x004F, lccode=0x00F8 },
	[0x00D9] = { unicodeslot=0x00D9, category='lu', adobename='Ugrave', contextname='Ugrave', description='LATIN CAPITAL LETTER U WITH GRAVE', shcode=0x0055, lccode=0x00F9, specials={'char',0x0055,0x0300} },
	[0x00DA] = { unicodeslot=0x00DA, category='lu', adobename='Uacute', contextname='Uacute', description='LATIN CAPITAL LETTER U WITH ACUTE', shcode=0x0055, lccode=0x00FA, specials={'char',0x0055,0x0301} },
	[0x00DB] = { unicodeslot=0x00DB, category='lu', adobename='Ucircumflex', contextname='Ucircumflex', description='LATIN CAPITAL LETTER U WITH CIRCUMFLEX', shcode=0x0055, lccode=0x00FB, specials={'char',0x0055,0x0302} },
	[0x00DC] = { unicodeslot=0x00DC, category='lu', adobename='Udieresis', contextname='Udiaeresis', description='LATIN CAPITAL LETTER U WITH DIAERESIS', shcode=0x0055, lccode=0x00FC, specials={'char',0x0055,0x0308} },
	[0x00DD] = { unicodeslot=0x00DD, category='lu', adobename='Yacute', contextname='Yacute', description='LATIN CAPITAL LETTER Y WITH ACUTE', shcode=0x0059, lccode=0x00FD, specials={'char',0x0059,0x0301} },
	[0x00DE] = { unicodeslot=0x00DE, category='lu', adobename='Thorn', contextname='Thorn', description='LATIN CAPITAL LETTER THORN', lccode=0x00FE },
	[0x00DF] = { unicodeslot=0x00DF, category='ll', adobename='germandbls', contextname='ssharp', description='LATIN SMALL LETTER SHARP S' },
	[0x00E0] = { unicodeslot=0x00E0, category='ll', adobename='agrave', contextname='agrave', description='LATIN SMALL LETTER A WITH GRAVE', shcode=0x0061, uccode=0x00C0, specials={'char',0x0061,0x0300} },
	[0x00E1] = { unicodeslot=0x00E1, category='ll', adobename='aacute', contextname='aacute', description='LATIN SMALL LETTER A WITH ACUTE', shcode=0x0061, uccode=0x00C1, specials={'char',0x0061,0x0301} },
	[0x00E2] = { unicodeslot=0x00E2, category='ll', adobename='acircumflex', contextname='acircumflex', description='LATIN SMALL LETTER A WITH CIRCUMFLEX', shcode=0x0061, uccode=0x00C2, specials={'char',0x0061,0x0302} },
	[0x00E3] = { unicodeslot=0x00E3, category='ll', adobename='atilde', contextname='atilde', description='LATIN SMALL LETTER A WITH TILDE', shcode=0x0061, uccode=0x00C3, specials={'char',0x0061,0x0303} },
	[0x00E4] = { unicodeslot=0x00E4, category='ll', adobename='adieresis', contextname='adiaeresis', description='LATIN SMALL LETTER A WITH DIAERESIS', shcode=0x0061, uccode=0x00C4, specials={'char',0x0061,0x0308} },
	[0x00E5] = { unicodeslot=0x00E5, category='ll', adobename='aring', contextname='aring', description='LATIN SMALL LETTER A WITH RING ABOVE', shcode=0x0061, uccode=0x00C5, specials={'char',0x0061,0x030A} },
	[0x00E6] = { unicodeslot=0x00E6, category='ll', adobename='ae', contextname='aeligature', description='LATIN SMALL LETTER AE', uccode=0x00C6 },
	[0x00E7] = { unicodeslot=0x00E7, category='ll', adobename='ccedilla', contextname='ccedilla', description='LATIN SMALL LETTER C WITH CEDILLA', shcode=0x0063, uccode=0x00C7, specials={'char',0x0063,0x0327} },
	[0x00E8] = { unicodeslot=0x00E8, category='ll', adobename='egrave', contextname='egrave', description='LATIN SMALL LETTER E WITH GRAVE', shcode=0x0065, uccode=0x00C8, specials={'char',0x0065,0x0300} },
	[0x00E9] = { unicodeslot=0x00E9, category='ll', adobename='eacute', contextname='eacute', description='LATIN SMALL LETTER E WITH ACUTE', shcode=0x0065, uccode=0x00C9, specials={'char',0x0065,0x0301} },
	[0x00EA] = { unicodeslot=0x00EA, category='ll', adobename='ecircumflex', contextname='ecircumflex', description='LATIN SMALL LETTER E WITH CIRCUMFLEX', shcode=0x0065, uccode=0x00CA, specials={'char',0x0065,0x0302} },
	[0x00EB] = { unicodeslot=0x00EB, category='ll', adobename='edieresis', contextname='ediaeresis', description='LATIN SMALL LETTER E WITH DIAERESIS', shcode=0x0065, uccode=0x00CB, specials={'char',0x0065,0x0308} },
	[0x00EC] = { unicodeslot=0x00EC, category='ll', adobename='igrave', contextname='igrave', description='LATIN SMALL LETTER I WITH GRAVE', shcode=0x0069, uccode=0x00CC, specials={'char',0x0069,0x0300} },
	[0x00ED] = { unicodeslot=0x00ED, category='ll', adobename='iacute', contextname='iacute', description='LATIN SMALL LETTER I WITH ACUTE', shcode=0x0069, uccode=0x00CD, specials={'char',0x0069,0x0301} },
	[0x00EE] = { unicodeslot=0x00EE, category='ll', adobename='icircumflex', contextname='icircumflex', description='LATIN SMALL LETTER I WITH CIRCUMFLEX', shcode=0x0069, uccode=0x00CE, specials={'char',0x0069,0x0302} },
	[0x00EF] = { unicodeslot=0x00EF, category='ll', adobename='idieresis', contextname='idiaeresis', description='LATIN SMALL LETTER I WITH DIAERESIS', shcode=0x0069, uccode=0x00CF, specials={'char',0x0069,0x0308} },
	[0x00F0] = { unicodeslot=0x00F0, category='ll', adobename='eth', contextname='eth', description='LATIN SMALL LETTER ETH', uccode=0x00D0 },
	[0x00F1] = { unicodeslot=0x00F1, category='ll', adobename='ntilde', contextname='ntilde', description='LATIN SMALL LETTER N WITH TILDE', shcode=0x006E, uccode=0x00D1, specials={'char',0x006E,0x0303} },
	[0x00F2] = { unicodeslot=0x00F2, category='ll', adobename='ograve', contextname='ograve', description='LATIN SMALL LETTER O WITH GRAVE', shcode=0x006F, uccode=0x00D2, specials={'char',0x006F,0x0300} },
	[0x00F3] = { unicodeslot=0x00F3, category='ll', adobename='oacute', contextname='oacute', description='LATIN SMALL LETTER O WITH ACUTE', shcode=0x006F, uccode=0x00D3, specials={'char',0x006F,0x0301} },
	[0x00F4] = { unicodeslot=0x00F4, category='ll', adobename='ocircumflex', contextname='ocircumflex', description='LATIN SMALL LETTER O WITH CIRCUMFLEX', shcode=0x006F, uccode=0x00D4, specials={'char',0x006F,0x0302} },
	[0x00F5] = { unicodeslot=0x00F5, category='ll', adobename='otilde', contextname='otilde', description='LATIN SMALL LETTER O WITH TILDE', shcode=0x006F, uccode=0x00D5, specials={'char',0x006F,0x0303} },
	[0x00F6] = { unicodeslot=0x00F6, category='ll', adobename='odieresis', contextname='odiaeresis', description='LATIN SMALL LETTER O WITH DIAERESIS', shcode=0x006F, uccode=0x00D6, specials={'char',0x006F,0x0308} },
	[0x00F7] = { unicodeslot=0x00F7, category='sm', adobename='divide', contextname='textdiv', description='DIVISION SIGN' },
	[0x00F8] = { unicodeslot=0x00F8, category='ll', adobename='oslash', contextname='ostroke', description='LATIN SMALL LETTER O WITH STROKE', shcode=0x006F, uccode=0x00D8 },
	[0x00F9] = { unicodeslot=0x00F9, category='ll', adobename='ugrave', contextname='ugrave', description='LATIN SMALL LETTER U WITH GRAVE', shcode=0x0075, uccode=0x00D9, specials={'char',0x0075,0x0300} },
	[0x00FA] = { unicodeslot=0x00FA, category='ll', adobename='uacute', contextname='uacute', description='LATIN SMALL LETTER U WITH ACUTE', shcode=0x0075, uccode=0x00DA, specials={'char',0x0075,0x0301} },
	[0x00FB] = { unicodeslot=0x00FB, category='ll', adobename='ucircumflex', contextname='ucircumflex', description='LATIN SMALL LETTER U WITH CIRCUMFLEX', shcode=0x0075, uccode=0x00DB, specials={'char',0x0075,0x0302} },
	[0x00FC] = { unicodeslot=0x00FC, category='ll', adobename='udieresis', contextname='udiaeresis', description='LATIN SMALL LETTER U WITH DIAERESIS', shcode=0x0075, uccode=0x00DC, specials={'char',0x0075,0x0308} },
	[0x00FD] = { unicodeslot=0x00FD, category='ll', adobename='yacute', contextname='yacute', description='LATIN SMALL LETTER Y WITH ACUTE', shcode=0x0079, uccode=0x00DD, specials={'char',0x0079,0x0301} },
	[0x00FE] = { unicodeslot=0x00FE, category='ll', adobename='thorn', contextname='thorn', description='LATIN SMALL LETTER THORN', uccode=0x00DE },
	[0x00FF] = { unicodeslot=0x00FF, category='ll', adobename='ydieresis', contextname='ydiaeresis', description='LATIN SMALL LETTER Y WITH DIAERESIS', shcode=0x0079, uccode=0x0178, specials={'char',0x0079,0x0308} },
	[0x0100] = { unicodeslot=0x0100, category='lu', adobename='Amacron', contextname='Amacron', description='LATIN CAPITAL LETTER A WITH MACRON', shcode=0x0041, lccode=0x0101, specials={'char',0x0041,0x0304} },
	[0x0101] = { unicodeslot=0x0101, category='ll', adobename='amacron', contextname='amacron', description='LATIN SMALL LETTER A WITH MACRON', shcode=0x0061, uccode=0x0100, specials={'char',0x0061,0x0304} },
	[0x0102] = { unicodeslot=0x0102, category='lu', adobename='Abreve', contextname='Abreve', description='LATIN CAPITAL LETTER A WITH BREVE', shcode=0x0041, lccode=0x0103, specials={'char',0x0041,0x0306} },
	[0x0103] = { unicodeslot=0x0103, category='ll', adobename='abreve', contextname='abreve', description='LATIN SMALL LETTER A WITH BREVE', shcode=0x0061, uccode=0x0102, specials={'char',0x0061,0x0306} },
	[0x0104] = { unicodeslot=0x0104, category='lu', adobename='Aogonek', contextname='Aogonek', description='LATIN CAPITAL LETTER A WITH OGONEK', shcode=0x0041, lccode=0x0105, specials={'char',0x0041,0x0328} },
	[0x0105] = { unicodeslot=0x0105, category='ll', adobename='aogonek', contextname='aogonek', description='LATIN SMALL LETTER A WITH OGONEK', shcode=0x0061, uccode=0x0104, specials={'char',0x0061,0x0328} },
	[0x0106] = { unicodeslot=0x0106, category='lu', adobename='Cacute', contextname='Cacute', description='LATIN CAPITAL LETTER C WITH ACUTE', shcode=0x0043, lccode=0x0107, specials={'char',0x0043,0x0301} },
	[0x0107] = { unicodeslot=0x0107, category='ll', adobename='cacute', contextname='cacute', description='LATIN SMALL LETTER C WITH ACUTE', shcode=0x0063, uccode=0x0106, specials={'char',0x0063,0x0301} },
	[0x0108] = { unicodeslot=0x0108, category='lu', adobename='Ccircumflex', contextname='Ccircumflex', description='LATIN CAPITAL LETTER C WITH CIRCUMFLEX', shcode=0x0043, lccode=0x0109, specials={'char',0x0043,0x0302} },
	[0x0109] = { unicodeslot=0x0109, category='ll', adobename='ccircumflex', contextname='ccircumflex', description='LATIN SMALL LETTER C WITH CIRCUMFLEX', shcode=0x0063, uccode=0x0108, specials={'char',0x0063,0x0302} },
	[0x010A] = { unicodeslot=0x010A, category='lu', adobename='Cdotaccent', contextname='Cdotaccent', description='LATIN CAPITAL LETTER C WITH DOT ABOVE', shcode=0x0043, lccode=0x010B, specials={'char',0x0043,0x0307} },
	[0x010B] = { unicodeslot=0x010B, category='ll', adobename='cdotaccent', contextname='cdotaccent', description='LATIN SMALL LETTER C WITH DOT ABOVE', shcode=0x0063, uccode=0x010A, specials={'char',0x0063,0x0307} },
	[0x010C] = { unicodeslot=0x010C, category='lu', adobename='Ccaron', contextname='Ccaron', description='LATIN CAPITAL LETTER C WITH CARON', shcode=0x0043, lccode=0x010D, specials={'char',0x0043,0x030C} },
	[0x010D] = { unicodeslot=0x010D, category='ll', adobename='ccaron', contextname='ccaron', description='LATIN SMALL LETTER C WITH CARON', shcode=0x0063, uccode=0x010C, specials={'char',0x0063,0x030C} },
	[0x010E] = { unicodeslot=0x010E, category='lu', adobename='Dcaron', contextname='Dcaron', description='LATIN CAPITAL LETTER D WITH CARON', shcode=0x0044, lccode=0x010F, specials={'char',0x0044,0x030C} },
	[0x010F] = { unicodeslot=0x010F, category='ll', adobename='dcaron', contextname='dcaron', description='LATIN SMALL LETTER D WITH CARON', shcode=0x0064, uccode=0x010E, specials={'char',0x0064,0x030C} },
	[0x0110] = { unicodeslot=0x0110, category='lu', adobename='Dcroat', contextname='Dstroke', description='LATIN CAPITAL LETTER D WITH STROKE', shcode=0x0044, lccode=0x0111 },
	[0x0111] = { unicodeslot=0x0111, category='ll', adobename='dcroat', contextname='dstroke', description='LATIN SMALL LETTER D WITH STROKE', shcode=0x0064, uccode=0x0110 },
	[0x0112] = { unicodeslot=0x0112, category='lu', adobename='Emacron', contextname='Emacron', description='LATIN CAPITAL LETTER E WITH MACRON', shcode=0x0045, lccode=0x0113, specials={'char',0x0045,0x0304} },
	[0x0113] = { unicodeslot=0x0113, category='ll', adobename='emacron', contextname='emacron', description='LATIN SMALL LETTER E WITH MACRON', shcode=0x0065, uccode=0x0112, specials={'char',0x0065,0x0304} },
	[0x0114] = { unicodeslot=0x0114, category='lu', adobename='Ebreve', contextname='Ebreve', description='LATIN CAPITAL LETTER E WITH BREVE', shcode=0x0045, lccode=0x0115, specials={'char',0x0045,0x0306} },
	[0x0115] = { unicodeslot=0x0115, category='ll', adobename='ebreve', contextname='ebreve', description='LATIN SMALL LETTER E WITH BREVE', shcode=0x0065, uccode=0x0114, specials={'char',0x0065,0x0306} },
	[0x0116] = { unicodeslot=0x0116, category='lu', adobename='Edotaccent', contextname='Edotaccent', description='LATIN CAPITAL LETTER E WITH DOT ABOVE', shcode=0x0045, lccode=0x0117, specials={'char',0x0045,0x0307} },
	[0x0117] = { unicodeslot=0x0117, category='ll', adobename='edotaccent', contextname='edotaccent', description='LATIN SMALL LETTER E WITH DOT ABOVE', shcode=0x0065, uccode=0x0116, specials={'char',0x0065,0x0307} },
	[0x0118] = { unicodeslot=0x0118, category='lu', adobename='Eogonek', contextname='Eogonek', description='LATIN CAPITAL LETTER E WITH OGONEK', shcode=0x0045, lccode=0x0119, specials={'char',0x0045,0x0328} },
	[0x0119] = { unicodeslot=0x0119, category='ll', adobename='eogonek', contextname='eogonek', description='LATIN SMALL LETTER E WITH OGONEK', shcode=0x0065, uccode=0x0118, specials={'char',0x0065,0x0328} },
	[0x011A] = { unicodeslot=0x011A, category='lu', adobename='Ecaron', contextname='Ecaron', description='LATIN CAPITAL LETTER E WITH CARON', shcode=0x0045, lccode=0x011B, specials={'char',0x0045,0x030C} },
	[0x011B] = { unicodeslot=0x011B, category='ll', adobename='ecaron', contextname='ecaron', description='LATIN SMALL LETTER E WITH CARON', shcode=0x0065, uccode=0x011A, specials={'char',0x0065,0x030C} },
	[0x011C] = { unicodeslot=0x011C, category='lu', adobename='Gcircumflex', contextname='Gcircumflex', description='LATIN CAPITAL LETTER G WITH CIRCUMFLEX', shcode=0x0047, lccode=0x011D, specials={'char',0x0047,0x0302} },
	[0x011D] = { unicodeslot=0x011D, category='ll', adobename='gcircumflex', contextname='gcircumflex', description='LATIN SMALL LETTER G WITH CIRCUMFLEX', shcode=0x0067, uccode=0x011C, specials={'char',0x0067,0x0302} },
	[0x011E] = { unicodeslot=0x011E, category='lu', adobename='Gbreve', contextname='Gbreve', description='LATIN CAPITAL LETTER G WITH BREVE', shcode=0x0047, lccode=0x011F, specials={'char',0x0047,0x0306} },
	[0x011F] = { unicodeslot=0x011F, category='ll', adobename='gbreve', contextname='gbreve', description='LATIN SMALL LETTER G WITH BREVE', shcode=0x0067, uccode=0x011E, specials={'char',0x0067,0x0306} },
	[0x0120] = { unicodeslot=0x0120, category='lu', adobename='Gdotaccent', contextname='Gdotaccent', description='LATIN CAPITAL LETTER G WITH DOT ABOVE', shcode=0x0047, lccode=0x0121, specials={'char',0x0047,0x0307} },
	[0x0121] = { unicodeslot=0x0121, category='ll', adobename='gdotaccent', contextname='gdotaccent', description='LATIN SMALL LETTER G WITH DOT ABOVE', shcode=0x0067, uccode=0x0120, specials={'char',0x0067,0x0307} },
	[0x0122] = { unicodeslot=0x0122, category='lu', adobename='Gcommaaccent', contextname='Gcommaaccent', description='LATIN CAPITAL LETTER G WITH CEDILLA', shcode=0x0047, lccode=0x0123, specials={'char',0x0047,0x0327} },
	[0x0123] = { unicodeslot=0x0123, category='ll', adobename='gcommaaccent', contextname='gcommaaccent', description='LATIN SMALL LETTER G WITH CEDILLA', shcode=0x0067, uccode=0x0122, specials={'char',0x0067,0x0327} },
	[0x0124] = { unicodeslot=0x0124, category='lu', adobename='Hcircumflex', contextname='Hcircumflex', description='LATIN CAPITAL LETTER H WITH CIRCUMFLEX', shcode=0x0048, lccode=0x0125, specials={'char',0x0048,0x0302} },
	[0x0125] = { unicodeslot=0x0125, category='ll', adobename='hcircumflex', contextname='hcircumflex', description='LATIN SMALL LETTER H WITH CIRCUMFLEX', shcode=0x0068, uccode=0x0124, specials={'char',0x0068,0x0302} },
	[0x0126] = { unicodeslot=0x0126, category='lu', adobename='Hbar', contextname='Hstroke', description='LATIN CAPITAL LETTER H WITH STROKE', shcode=0x0048, lccode=0x0127 },
	[0x0127] = { unicodeslot=0x0127, category='ll', adobename='hbar', contextname='hstroke', description='LATIN SMALL LETTER H WITH STROKE', shcode=0x0068, uccode=0x0126 },
	[0x0128] = { unicodeslot=0x0128, category='lu', adobename='Itilde', contextname='Itilde', description='LATIN CAPITAL LETTER I WITH TILDE', shcode=0x0049, lccode=0x0129, specials={'char',0x0049,0x0303} },
	[0x0129] = { unicodeslot=0x0129, category='ll', adobename='itilde', contextname='itilde', description='LATIN SMALL LETTER I WITH TILDE', shcode=0x0069, uccode=0x0128, specials={'char',0x0069,0x0303} },
	[0x012A] = { unicodeslot=0x012A, category='lu', adobename='Imacron', contextname='Imacron', description='LATIN CAPITAL LETTER I WITH MACRON', shcode=0x0049, lccode=0x012B, specials={'char',0x0049,0x0304} },
	[0x012B] = { unicodeslot=0x012B, category='ll', adobename='imacron', contextname='imacron', description='LATIN SMALL LETTER I WITH MACRON', shcode=0x0069, uccode=0x012A, specials={'char',0x0069,0x0304} },
	[0x012C] = { unicodeslot=0x012C, category='lu', adobename='Ibreve', contextname='Ibreve', description='LATIN CAPITAL LETTER I WITH BREVE', shcode=0x0049, lccode=0x012D, specials={'char',0x0049,0x0306} },
	[0x012D] = { unicodeslot=0x012D, category='ll', adobename='ibreve', contextname='ibreve', description='LATIN SMALL LETTER I WITH BREVE', shcode=0x0069, uccode=0x012C, specials={'char',0x0069,0x0306} },
	[0x012E] = { unicodeslot=0x012E, category='lu', adobename='Iogonek', contextname='Iogonek', description='LATIN CAPITAL LETTER I WITH OGONEK', shcode=0x0049, lccode=0x012F, specials={'char',0x0049,0x0328} },
	[0x012F] = { unicodeslot=0x012F, category='ll', adobename='iogonek', contextname='iogonek', description='LATIN SMALL LETTER I WITH OGONEK', shcode=0x0069, uccode=0x012E, specials={'char',0x0069,0x0328} },
	[0x0130] = { unicodeslot=0x0130, category='lu', adobename='Idotaccent', contextname='Idotaccent', description='LATIN CAPITAL LETTER I WITH DOT ABOVE', shcode=0x0049, lccode=0x0069, specials={'char',0x0049,0x0307} },
	[0x0131] = { unicodeslot=0x0131, category='ll', adobename='dotlessi', contextname='dotlessi', description='LATIN SMALL LETTER DOTLESS I', uccode=0x0049 },
	[0x0132] = { unicodeslot=0x0132, category='lu', adobename='IJ', contextname='IJligature', description='LATIN CAPITAL LIGATURE IJ', lccode=0x0133, specials={'compat',0x0049,0x004A} },
	[0x0133] = { unicodeslot=0x0133, category='ll', adobename='ij', contextname='ijligature', description='LATIN SMALL LIGATURE IJ', uccode=0x0132, specials={'compat',0x0069,0x006A} },
	[0x0134] = { unicodeslot=0x0134, category='lu', adobename='Jcircumflex', contextname='Jcircumflex', description='LATIN CAPITAL LETTER J WITH CIRCUMFLEX', shcode=0x004A, lccode=0x0135, specials={'char',0x004A,0x0302} },
	[0x0135] = { unicodeslot=0x0135, category='ll', adobename='jcircumflex', contextname='jcircumflex', description='LATIN SMALL LETTER J WITH CIRCUMFLEX', shcode=0x006A, uccode=0x0134, specials={'char',0x006A,0x0302} },
	[0x0136] = { unicodeslot=0x0136, category='lu', adobename='Kcommaaccent', contextname='Kcommaaccent', description='LATIN CAPITAL LETTER K WITH CEDILLA', shcode=0x004B, lccode=0x0137, specials={'char',0x004B,0x0327} },
	[0x0137] = { unicodeslot=0x0137, category='ll', adobename='kcommaaccent', contextname='kcommaaccent', description='LATIN SMALL LETTER K WITH CEDILLA', shcode=0x006B, uccode=0x0136, specials={'char',0x006B,0x0327} },
	[0x0138] = { unicodeslot=0x0138, category='ll', adobename='kgreenlandic', contextname='kkra', description='LATIN SMALL LETTER KRA' },
	[0x0139] = { unicodeslot=0x0139, category='lu', adobename='Lacute', contextname='Lacute', description='LATIN CAPITAL LETTER L WITH ACUTE', shcode=0x004C, lccode=0x013A, specials={'char',0x004C,0x0301} },
	[0x013A] = { unicodeslot=0x013A, category='ll', adobename='lacute', contextname='lacute', description='LATIN SMALL LETTER L WITH ACUTE', shcode=0x006C, uccode=0x0139, specials={'char',0x006C,0x0301} },
	[0x013B] = { unicodeslot=0x013B, category='lu', adobename='Lcommaaccent', contextname='Lcommaaccent', description='LATIN CAPITAL LETTER L WITH CEDILLA', shcode=0x004C, lccode=0x013C, specials={'char',0x004C,0x0327} },
	[0x013C] = { unicodeslot=0x013C, category='ll', adobename='lcommaaccent', contextname='lcommaaccent', description='LATIN SMALL LETTER L WITH CEDILLA', shcode=0x006C, uccode=0x013B, specials={'char',0x006C,0x0327} },
	[0x013D] = { unicodeslot=0x013D, category='lu', adobename='Lcaron', contextname='Lcaron', description='LATIN CAPITAL LETTER L WITH CARON', shcode=0x004C, lccode=0x013E, specials={'char',0x004C,0x030C} },
	[0x013E] = { unicodeslot=0x013E, category='ll', adobename='lcaron', contextname='lcaron', description='LATIN SMALL LETTER L WITH CARON', shcode=0x006C, uccode=0x013D, specials={'char',0x006C,0x030C} },
	[0x013F] = { unicodeslot=0x013F, category='lu', adobename='Ldot', contextname='Ldotmiddle', description='LATIN CAPITAL LETTER L WITH MIDDLE DOT', shcode=0x004C, lccode=0x0140, specials={'compat',0x004C,0x00B7} },
	[0x0140] = { unicodeslot=0x0140, category='ll', adobename='ldot', contextname='ldotmiddle', description='LATIN SMALL LETTER L WITH MIDDLE DOT', shcode=0x006C, uccode=0x013F, specials={'compat',0x006C,0x00B7} },
	[0x0141] = { unicodeslot=0x0141, category='lu', adobename='Lslash', contextname='Lstroke', description='LATIN CAPITAL LETTER L WITH STROKE', shcode=0x004C, lccode=0x0142 },
	[0x0142] = { unicodeslot=0x0142, category='ll', adobename='lslash', contextname='lstroke', description='LATIN SMALL LETTER L WITH STROKE', shcode=0x006C, uccode=0x0141 },
	[0x0143] = { unicodeslot=0x0143, category='lu', adobename='Nacute', contextname='Nacute', description='LATIN CAPITAL LETTER N WITH ACUTE', shcode=0x004E, lccode=0x0144, specials={'char',0x004E,0x0301} },
	[0x0144] = { unicodeslot=0x0144, category='ll', adobename='nacute', contextname='nacute', description='LATIN SMALL LETTER N WITH ACUTE', shcode=0x006E, uccode=0x0143, specials={'char',0x006E,0x0301} },
	[0x0145] = { unicodeslot=0x0145, category='lu', adobename='Ncommaaccent', contextname='Ncommaaccent', description='LATIN CAPITAL LETTER N WITH CEDILLA', shcode=0x004E, lccode=0x0146, specials={'char',0x004E,0x0327} },
	[0x0146] = { unicodeslot=0x0146, category='ll', adobename='ncommaaccent', contextname='ncommaaccent', description='LATIN SMALL LETTER N WITH CEDILLA', shcode=0x006E, uccode=0x0145, specials={'char',0x006E,0x0327} },
	[0x0147] = { unicodeslot=0x0147, category='lu', adobename='Ncaron', contextname='Ncaron', description='LATIN CAPITAL LETTER N WITH CARON', shcode=0x004E, lccode=0x0148, specials={'char',0x004E,0x030C} },
	[0x0148] = { unicodeslot=0x0148, category='ll', adobename='ncaron', contextname='ncaron', description='LATIN SMALL LETTER N WITH CARON', shcode=0x006E, uccode=0x0147, specials={'char',0x006E,0x030C} },
	[0x0149] = { unicodeslot=0x0149, category='ll', adobename='napostrophe', contextname='napostrophe', description='LATIN SMALL LETTER N PRECEDED BY APOSTROPHE', specials={'compat',0x02BC,0x006E} },
	[0x014A] = { unicodeslot=0x014A, category='lu', adobename='Eng', contextname='Neng', description='LATIN CAPITAL LETTER ENG', lccode=0x014B },
	[0x014B] = { unicodeslot=0x014B, category='ll', adobename='eng', contextname='neng', description='LATIN SMALL LETTER ENG', uccode=0x014A },
	[0x014C] = { unicodeslot=0x014C, category='lu', adobename='Omacron', contextname='Omacron', description='LATIN CAPITAL LETTER O WITH MACRON', shcode=0x004F, lccode=0x014D, specials={'char',0x004F,0x0304} },
	[0x014D] = { unicodeslot=0x014D, category='ll', adobename='omacron', contextname='omacron', description='LATIN SMALL LETTER O WITH MACRON', shcode=0x006F, uccode=0x014C, specials={'char',0x006F,0x0304} },
	[0x014E] = { unicodeslot=0x014E, category='lu', adobename='Obreve', contextname='Obreve', description='LATIN CAPITAL LETTER O WITH BREVE', shcode=0x004F, lccode=0x014F, specials={'char',0x004F,0x0306} },
	[0x014F] = { unicodeslot=0x014F, category='ll', adobename='obreve', contextname='obreve', description='LATIN SMALL LETTER O WITH BREVE', shcode=0x006F, uccode=0x014E, specials={'char',0x006F,0x0306} },
	[0x0150] = { unicodeslot=0x0150, category='lu', adobename='Ohungarumlaut', contextname='Ohungarumlaut', description='LATIN CAPITAL LETTER O WITH DOUBLE ACUTE', shcode=0x004F, lccode=0x0151, specials={'char',0x004F,0x030B} },
	[0x0151] = { unicodeslot=0x0151, category='ll', adobename='ohungarumlaut', contextname='ohungarumlaut', description='LATIN SMALL LETTER O WITH DOUBLE ACUTE', shcode=0x006F, uccode=0x0150, specials={'char',0x006F,0x030B} },
	[0x0152] = { unicodeslot=0x0152, category='lu', adobename='OE', contextname='OEligature', description='LATIN CAPITAL LIGATURE OE', lccode=0x0153 },
	[0x0153] = { unicodeslot=0x0153, category='ll', adobename='oe', contextname='oeligature', description='LATIN SMALL LIGATURE OE', uccode=0x0152 },
	[0x0154] = { unicodeslot=0x0154, category='lu', adobename='Racute', contextname='Racute', description='LATIN CAPITAL LETTER R WITH ACUTE', shcode=0x0052, lccode=0x0155, specials={'char',0x0052,0x0301} },
	[0x0155] = { unicodeslot=0x0155, category='ll', adobename='racute', contextname='racute', description='LATIN SMALL LETTER R WITH ACUTE', shcode=0x0072, uccode=0x0154, specials={'char',0x0072,0x0301} },
	[0x0156] = { unicodeslot=0x0156, category='lu', adobename='Rcommaaccent', contextname='Rcommaaccent', description='LATIN CAPITAL LETTER R WITH CEDILLA', shcode=0x0052, lccode=0x0157, specials={'char',0x0052,0x0327} },
	[0x0157] = { unicodeslot=0x0157, category='ll', adobename='rcommaaccent', contextname='rcommaaccent', description='LATIN SMALL LETTER R WITH CEDILLA', shcode=0x0072, uccode=0x0156, specials={'char',0x0072,0x0327} },
	[0x0158] = { unicodeslot=0x0158, category='lu', adobename='Rcaron', contextname='Rcaron', description='LATIN CAPITAL LETTER R WITH CARON', shcode=0x0052, lccode=0x0159, specials={'char',0x0052,0x030C} },
	[0x0159] = { unicodeslot=0x0159, category='ll', adobename='rcaron', contextname='rcaron', description='LATIN SMALL LETTER R WITH CARON', shcode=0x0072, uccode=0x0158, specials={'char',0x0072,0x030C} },
	[0x015A] = { unicodeslot=0x015A, category='lu', adobename='Sacute', contextname='Sacute', description='LATIN CAPITAL LETTER S WITH ACUTE', shcode=0x0053, lccode=0x015B, specials={'char',0x0053,0x0301} },
	[0x015B] = { unicodeslot=0x015B, category='ll', adobename='sacute', contextname='sacute', description='LATIN SMALL LETTER S WITH ACUTE', shcode=0x0073, uccode=0x015A, specials={'char',0x0073,0x0301} },
	[0x015C] = { unicodeslot=0x015C, category='lu', adobename='Scircumflex', contextname='Scircumflex', description='LATIN CAPITAL LETTER S WITH CIRCUMFLEX', shcode=0x0053, lccode=0x015D, specials={'char',0x0053,0x0302} },
	[0x015D] = { unicodeslot=0x015D, category='ll', adobename='scircumflex', contextname='scircumflex', description='LATIN SMALL LETTER S WITH CIRCUMFLEX', shcode=0x0073, uccode=0x015C, specials={'char',0x0073,0x0302} },
	[0x015E] = { unicodeslot=0x015E, category='lu', adobename='Scedilla', contextname='Scedilla', description='LATIN CAPITAL LETTER S WITH CEDILLA', shcode=0x0053, lccode=0x015F, specials={'char',0x0053,0x0327} },
	[0x015F] = { unicodeslot=0x015F, category='ll', adobename='scedilla', contextname='scedilla', description='LATIN SMALL LETTER S WITH CEDILLA', shcode=0x0073, uccode=0x015E, specials={'char',0x0073,0x0327} },
	[0x0160] = { unicodeslot=0x0160, category='lu', adobename='Scaron', contextname='Scaron', description='LATIN CAPITAL LETTER S WITH CARON', shcode=0x0053, lccode=0x0161, specials={'char',0x0053,0x030C} },
	[0x0161] = { unicodeslot=0x0161, category='ll', adobename='scaron', contextname='scaron', description='LATIN SMALL LETTER S WITH CARON', shcode=0x0073, uccode=0x0160, specials={'char',0x0073,0x030C} },
	[0x0162] = { unicodeslot=0x0162, category='lu', adobename='Tcommaaccent', contextname='Tcedilla', description='LATIN CAPITAL LETTER T WITH CEDILLA', shcode=0x0054, lccode=0x0163, specials={'char',0x0054,0x0327} },
	[0x0163] = { unicodeslot=0x0163, category='ll', adobename='tcommaaccent', contextname='tcedilla', description='LATIN SMALL LETTER T WITH CEDILLA', shcode=0x0074, uccode=0x0162, specials={'char',0x0074,0x0327} },
	[0x0164] = { unicodeslot=0x0164, category='lu', adobename='Tcaron', contextname='Tcaron', description='LATIN CAPITAL LETTER T WITH CARON', shcode=0x0054, lccode=0x0165, specials={'char',0x0054,0x030C} },
	[0x0165] = { unicodeslot=0x0165, category='ll', adobename='tcaron', contextname='tcaron', description='LATIN SMALL LETTER T WITH CARON', shcode=0x0074, uccode=0x0164, specials={'char',0x0074,0x030C} },
	[0x0166] = { unicodeslot=0x0166, category='lu', adobename='Tbar', contextname='Tstroke', description='LATIN CAPITAL LETTER T WITH STROKE', shcode=0x0054, lccode=0x0167 },
	[0x0167] = { unicodeslot=0x0167, category='ll', adobename='tbar', contextname='tstroke', description='LATIN SMALL LETTER T WITH STROKE', shcode=0x0074, uccode=0x0166 },
	[0x0168] = { unicodeslot=0x0168, category='lu', adobename='Utilde', contextname='Utilde', description='LATIN CAPITAL LETTER U WITH TILDE', shcode=0x0055, lccode=0x0169, specials={'char',0x0055,0x0303} },
	[0x0169] = { unicodeslot=0x0169, category='ll', adobename='utilde', contextname='utilde', description='LATIN SMALL LETTER U WITH TILDE', shcode=0x0075, uccode=0x0168, specials={'char',0x0075,0x0303} },
	[0x016A] = { unicodeslot=0x016A, category='lu', adobename='Umacron', contextname='Umacron', description='LATIN CAPITAL LETTER U WITH MACRON', shcode=0x0055, lccode=0x016B, specials={'char',0x0055,0x0304} },
	[0x016B] = { unicodeslot=0x016B, category='ll', adobename='umacron', contextname='umacron', description='LATIN SMALL LETTER U WITH MACRON', shcode=0x0075, uccode=0x016A, specials={'char',0x0075,0x0304} },
	[0x016C] = { unicodeslot=0x016C, category='lu', adobename='Ubreve', contextname='Ubreve', description='LATIN CAPITAL LETTER U WITH BREVE', shcode=0x0055, lccode=0x016D, specials={'char',0x0055,0x0306} },
	[0x016D] = { unicodeslot=0x016D, category='ll', adobename='ubreve', contextname='ubreve', description='LATIN SMALL LETTER U WITH BREVE', shcode=0x0075, uccode=0x016C, specials={'char',0x0075,0x0306} },
	[0x016E] = { unicodeslot=0x016E, category='lu', adobename='Uring', contextname='Uring', description='LATIN CAPITAL LETTER U WITH RING ABOVE', shcode=0x0055, lccode=0x016F, specials={'char',0x0055,0x030A} },
	[0x016F] = { unicodeslot=0x016F, category='ll', adobename='uring', contextname='uring', description='LATIN SMALL LETTER U WITH RING ABOVE', shcode=0x0075, uccode=0x016E, specials={'char',0x0075,0x030A} },
	[0x0170] = { unicodeslot=0x0170, category='lu', adobename='Uhungarumlaut', contextname='Uhungarumlaut', description='LATIN CAPITAL LETTER U WITH DOUBLE ACUTE', shcode=0x0055, lccode=0x0171, specials={'char',0x0055,0x030B} },
	[0x0171] = { unicodeslot=0x0171, category='ll', adobename='uhungarumlaut', contextname='uhungarumlaut', description='LATIN SMALL LETTER U WITH DOUBLE ACUTE', shcode=0x0075, uccode=0x0170, specials={'char',0x0075,0x030B} },
	[0x0172] = { unicodeslot=0x0172, category='lu', adobename='Uogonek', contextname='Uogonek', description='LATIN CAPITAL LETTER U WITH OGONEK', shcode=0x0055, lccode=0x0173, specials={'char',0x0055,0x0328} },
	[0x0173] = { unicodeslot=0x0173, category='ll', adobename='uogonek', contextname='uogonek', description='LATIN SMALL LETTER U WITH OGONEK', shcode=0x0075, uccode=0x0172, specials={'char',0x0075,0x0328} },
	[0x0174] = { unicodeslot=0x0174, category='lu', adobename='Wcircumflex', contextname='Wcircumflex', description='LATIN CAPITAL LETTER W WITH CIRCUMFLEX', shcode=0x0057, lccode=0x0175, specials={'char',0x0057,0x0302} },
	[0x0175] = { unicodeslot=0x0175, category='ll', adobename='wcircumflex', contextname='wcircumflex', description='LATIN SMALL LETTER W WITH CIRCUMFLEX', shcode=0x0077, uccode=0x0174, specials={'char',0x0077,0x0302} },
	[0x0176] = { unicodeslot=0x0176, category='lu', adobename='Ycircumflex', contextname='Ycircumflex', description='LATIN CAPITAL LETTER Y WITH CIRCUMFLEX', shcode=0x0059, lccode=0x0177, specials={'char',0x0059,0x0302} },
	[0x0177] = { unicodeslot=0x0177, category='ll', adobename='ycircumflex', contextname='ycircumflex', description='LATIN SMALL LETTER Y WITH CIRCUMFLEX', shcode=0x0079, uccode=0x0176, specials={'char',0x0079,0x0302} },
	[0x0178] = { unicodeslot=0x0178, category='lu', adobename='Ydieresis', contextname='Ydiaeresis', description='LATIN CAPITAL LETTER Y WITH DIAERESIS', shcode=0x0059, lccode=0x00FF, specials={'char',0x0059,0x0308} },
	[0x0179] = { unicodeslot=0x0179, category='lu', adobename='Zacute', contextname='Zacute', description='LATIN CAPITAL LETTER Z WITH ACUTE', shcode=0x005A, lccode=0x017A, specials={'char',0x005A,0x0301} },
	[0x017A] = { unicodeslot=0x017A, category='ll', adobename='zacute', contextname='zacute', description='LATIN SMALL LETTER Z WITH ACUTE', shcode=0x007A, uccode=0x0179, specials={'char',0x007A,0x0301} },
	[0x017B] = { unicodeslot=0x017B, category='lu', adobename='Zdotaccent', contextname='Zdotaccent', description='LATIN CAPITAL LETTER Z WITH DOT ABOVE', shcode=0x005A, lccode=0x017C, specials={'char',0x005A,0x0307} },
	[0x017C] = { unicodeslot=0x017C, category='ll', adobename='zdotaccent', contextname='zdotaccent', description='LATIN SMALL LETTER Z WITH DOT ABOVE', shcode=0x007A, uccode=0x017B, specials={'char',0x007A,0x0307} },
	[0x017D] = { unicodeslot=0x017D, category='lu', adobename='Zcaron', contextname='Zcaron', description='LATIN CAPITAL LETTER Z WITH CARON', shcode=0x005A, lccode=0x017E, specials={'char',0x005A,0x030C} },
	[0x017E] = { unicodeslot=0x017E, category='ll', adobename='zcaron', contextname='zcaron', description='LATIN SMALL LETTER Z WITH CARON', shcode=0x007A, uccode=0x017D, specials={'char',0x007A,0x030C} },
	[0x017F] = { unicodeslot=0x017F, category='ll', adobename='longs', contextname='slong', description='LATIN SMALL LETTER LONG S', uccode=0x0053, specials={'compat',0x0073} },
	[0x0180] = { unicodeslot=0x0180, category='ll', contextname='bstroke', description='LATIN SMALL LETTER B WITH STROKE', shcode=0x0062, uccode=0x0243 },
	[0x0181] = { unicodeslot=0x0181, category='lu', contextname='Bhook', description='LATIN CAPITAL LETTER B WITH HOOK', shcode=0x0042, lccode=0x0253 },
	[0x0182] = { unicodeslot=0x0182, category='lu', description='LATIN CAPITAL LETTER B WITH TOPBAR', shcode=0x0042, lccode=0x0183 },
	[0x0183] = { unicodeslot=0x0183, category='ll', description='LATIN SMALL LETTER B WITH TOPBAR', shcode=0x0062, uccode=0x0182 },
	[0x0184] = { unicodeslot=0x0184, category='lu', description='LATIN CAPITAL LETTER TONE SIX', lccode=0x0185 },
	[0x0185] = { unicodeslot=0x0185, category='ll', description='LATIN SMALL LETTER TONE SIX', uccode=0x0184 },
	[0x0186] = { unicodeslot=0x0186, category='lu', description='LATIN CAPITAL LETTER OPEN O', lccode=0x0254 },
	[0x0187] = { unicodeslot=0x0187, category='lu', contextname='Chook', description='LATIN CAPITAL LETTER C WITH HOOK', shcode=0x0043, lccode=0x0188 },
	[0x0188] = { unicodeslot=0x0188, category='ll', contextname='chook', description='LATIN SMALL LETTER C WITH HOOK', shcode=0x0063, uccode=0x0187 },
	[0x0189] = { unicodeslot=0x0189, category='lu', contextname='Dafrican', description='LATIN CAPITAL LETTER AFRICAN D', lccode=0x0256 },
	[0x018A] = { unicodeslot=0x018A, category='lu', contextname='Dhook', description='LATIN CAPITAL LETTER D WITH HOOK', shcode=0x0044, lccode=0x0257 },
	[0x018B] = { unicodeslot=0x018B, category='lu', description='LATIN CAPITAL LETTER D WITH TOPBAR', shcode=0x0044, lccode=0x018C },
	[0x018C] = { unicodeslot=0x018C, category='ll', description='LATIN SMALL LETTER D WITH TOPBAR', shcode=0x0064, uccode=0x018B },
	[0x018D] = { unicodeslot=0x018D, category='ll', description='LATIN SMALL LETTER TURNED DELTA' },
	[0x018E] = { unicodeslot=0x018E, category='lu', description='LATIN CAPITAL LETTER REVERSED E', lccode=0x01DD },
	[0x018F] = { unicodeslot=0x018F, category='lu', contextname='Schwa', description='LATIN CAPITAL LETTER SCHWA', lccode=0x0259 },
	[0x0190] = { unicodeslot=0x0190, category='lu', description='LATIN CAPITAL LETTER OPEN E', lccode=0x025B },
	[0x0191] = { unicodeslot=0x0191, category='lu', contextname='Fhook', description='LATIN CAPITAL LETTER F WITH HOOK', shcode=0x0046, lccode=0x0192 },
	[0x0192] = { unicodeslot=0x0192, category='ll', adobename='florin', contextname='fhook', description='LATIN SMALL LETTER F WITH HOOK', shcode=0x0066, uccode=0x0191 },
	[0x0193] = { unicodeslot=0x0193, category='lu', contextname='Ghook', description='LATIN CAPITAL LETTER G WITH HOOK', shcode=0x0047, lccode=0x0260 },
	[0x0194] = { unicodeslot=0x0194, category='lu', description='LATIN CAPITAL LETTER GAMMA', lccode=0x0263 },
	[0x0195] = { unicodeslot=0x0195, category='ll', description='LATIN SMALL LETTER HV', uccode=0x01F6 },
	[0x0196] = { unicodeslot=0x0196, category='lu', description='LATIN CAPITAL LETTER IOTA', lccode=0x0269 },
	[0x0197] = { unicodeslot=0x0197, category='lu', contextname='Istroke', description='LATIN CAPITAL LETTER I WITH STROKE', shcode=0x0049, lccode=0x0268 },
	[0x0198] = { unicodeslot=0x0198, category='lu', contextname='Khook', description='LATIN CAPITAL LETTER K WITH HOOK', shcode=0x004B, lccode=0x0199 },
	[0x0199] = { unicodeslot=0x0199, category='ll', contextname='khook', description='LATIN SMALL LETTER K WITH HOOK', shcode=0x006B, uccode=0x0198 },
	[0x019A] = { unicodeslot=0x019A, category='ll', contextname='lbar', description='LATIN SMALL LETTER L WITH BAR', shcode=0x006C, uccode=0x023D },
	[0x019B] = { unicodeslot=0x019B, category='ll', description='LATIN SMALL LETTER LAMBDA WITH STROKE' },
	[0x019C] = { unicodeslot=0x019C, category='lu', description='LATIN CAPITAL LETTER TURNED M', lccode=0x026F },
	[0x019D] = { unicodeslot=0x019D, category='lu', description='LATIN CAPITAL LETTER N WITH LEFT HOOK', shcode=0x004E, lccode=0x0272 },
	[0x019E] = { unicodeslot=0x019E, category='ll', description='LATIN SMALL LETTER N WITH LONG RIGHT LEG', shcode=0x006E, uccode=0x0220 },
	[0x019F] = { unicodeslot=0x019F, category='lu', description='LATIN CAPITAL LETTER O WITH MIDDLE TILDE', shcode=0x004F, lccode=0x0275 },
	[0x01A0] = { unicodeslot=0x01A0, category='lu', adobename='Ohorn', contextname='Ohorn', description='LATIN CAPITAL LETTER O WITH HORN', shcode=0x004F, lccode=0x01A1, specials={'char',0x004F,0x031B} },
	[0x01A1] = { unicodeslot=0x01A1, category='ll', adobename='ohorn', contextname='ohorn', description='LATIN SMALL LETTER O WITH HORN', shcode=0x006F, uccode=0x01A0, specials={'char',0x006F,0x031B} },
	[0x01A2] = { unicodeslot=0x01A2, category='lu', description='LATIN CAPITAL LETTER OI', lccode=0x01A3 },
	[0x01A3] = { unicodeslot=0x01A3, category='ll', description='LATIN SMALL LETTER OI', uccode=0x01A2 },
	[0x01A4] = { unicodeslot=0x01A4, category='lu', contextname='Phook', description='LATIN CAPITAL LETTER P WITH HOOK', shcode=0x0050, lccode=0x01A5 },
	[0x01A5] = { unicodeslot=0x01A5, category='ll', contextname='phook', description='LATIN SMALL LETTER P WITH HOOK', shcode=0x0070, uccode=0x01A4 },
	[0x01A6] = { unicodeslot=0x01A6, category='lu', description='LATIN LETTER YR', lccode=0x0280 },
	[0x01A7] = { unicodeslot=0x01A7, category='lu', description='LATIN CAPITAL LETTER TONE TWO', lccode=0x01A8 },
	[0x01A8] = { unicodeslot=0x01A8, category='ll', description='LATIN SMALL LETTER TONE TWO', uccode=0x01A7 },
	[0x01A9] = { unicodeslot=0x01A9, category='lu', description='LATIN CAPITAL LETTER ESH', lccode=0x0283 },
	[0x01AA] = { unicodeslot=0x01AA, category='ll', description='LATIN LETTER REVERSED ESH LOOP' },
	[0x01AB] = { unicodeslot=0x01AB, category='ll', description='LATIN SMALL LETTER T WITH PALATAL HOOK', shcode=0x0074 },
	[0x01AC] = { unicodeslot=0x01AC, category='lu', contextname='Thook', description='LATIN CAPITAL LETTER T WITH HOOK', shcode=0x0054, lccode=0x01AD },
	[0x01AD] = { unicodeslot=0x01AD, category='ll', contextname='thook', description='LATIN SMALL LETTER T WITH HOOK', shcode=0x0074, uccode=0x01AC },
	[0x01AE] = { unicodeslot=0x01AE, category='lu', description='LATIN CAPITAL LETTER T WITH RETROFLEX HOOK', shcode=0x0054, lccode=0x0288 },
	[0x01AF] = { unicodeslot=0x01AF, category='lu', adobename='Uhorn', contextname='Uhorn', description='LATIN CAPITAL LETTER U WITH HORN', shcode=0x0055, lccode=0x01B0, specials={'char',0x0055,0x031B} },
	[0x01B0] = { unicodeslot=0x01B0, category='ll', adobename='uhorn', contextname='uhorn', description='LATIN SMALL LETTER U WITH HORN', shcode=0x0075, uccode=0x01AF, specials={'char',0x0075,0x031B} },
	[0x01B1] = { unicodeslot=0x01B1, category='lu', description='LATIN CAPITAL LETTER UPSILON', lccode=0x028A },
	[0x01B2] = { unicodeslot=0x01B2, category='lu', contextname='Uhook', description='LATIN CAPITAL LETTER V WITH HOOK', shcode=0x0056, lccode=0x028B },
	[0x01B3] = { unicodeslot=0x01B3, category='lu', contextname='Yhook', description='LATIN CAPITAL LETTER Y WITH HOOK', shcode=0x0059, lccode=0x01B4 },
	[0x01B4] = { unicodeslot=0x01B4, category='ll', contextname='yhook', description='LATIN SMALL LETTER Y WITH HOOK', shcode=0x0079, uccode=0x01B3 },
	[0x01B5] = { unicodeslot=0x01B5, category='lu', contextname='Zstroke', description='LATIN CAPITAL LETTER Z WITH STROKE', shcode=0x005A, lccode=0x01B6 },
	[0x01B6] = { unicodeslot=0x01B6, category='ll', contextname='zstroke', description='LATIN SMALL LETTER Z WITH STROKE', shcode=0x007A, uccode=0x01B5 },
	[0x01B7] = { unicodeslot=0x01B7, category='lu', description='LATIN CAPITAL LETTER EZH', lccode=0x0292 },
	[0x01B8] = { unicodeslot=0x01B8, category='lu', description='LATIN CAPITAL LETTER EZH REVERSED', lccode=0x01B9 },
	[0x01B9] = { unicodeslot=0x01B9, category='ll', description='LATIN SMALL LETTER EZH REVERSED', uccode=0x01B8 },
	[0x01BA] = { unicodeslot=0x01BA, category='ll', description='LATIN SMALL LETTER EZH WITH TAIL', shcode=0x0292 },
	[0x01BB] = { unicodeslot=0x01BB, category='lo', description='LATIN LETTER TWO WITH STROKE' },
	[0x01BC] = { unicodeslot=0x01BC, category='lu', description='LATIN CAPITAL LETTER TONE FIVE', lccode=0x01BD },
	[0x01BD] = { unicodeslot=0x01BD, category='ll', description='LATIN SMALL LETTER TONE FIVE', uccode=0x01BC },
	[0x01BE] = { unicodeslot=0x01BE, category='ll', description='LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE' },
	[0x01BF] = { unicodeslot=0x01BF, category='ll', description='LATIN LETTER WYNN', uccode=0x01F7 },
	[0x01C0] = { unicodeslot=0x01C0, category='lo', description='LATIN LETTER DENTAL CLICK' },
	[0x01C1] = { unicodeslot=0x01C1, category='lo', description='LATIN LETTER LATERAL CLICK' },
	[0x01C2] = { unicodeslot=0x01C2, category='lo', description='LATIN LETTER ALVEOLAR CLICK' },
	[0x01C3] = { unicodeslot=0x01C3, category='lo', description='LATIN LETTER RETROFLEX CLICK' },
	[0x01C4] = { unicodeslot=0x01C4, category='lu', contextname='DZcaronligature', description='LATIN CAPITAL LETTER DZ WITH CARON', shcode=0x01F1, uccode=0x01C5, lccode=0x01C6, specials={'compat',0x0044,0x017D} },
	[0x01C5] = { unicodeslot=0x01C5, category='lt', contextname='Dzcaronligature', description='LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON', shcode=0x01F2, uccode=0x01C4, lccode=0x01C6, specials={'compat',0x0044,0x017E} },
	[0x01C6] = { unicodeslot=0x01C6, category='ll', contextname='dzcaronligature', description='LATIN SMALL LETTER DZ WITH CARON', shcode=0x01F3, uccode=0x01C4, specials={'compat',0x0064,0x017E} },
	[0x01C7] = { unicodeslot=0x01C7, category='lu', contextname='LJligature', description='LATIN CAPITAL LETTER LJ', uccode=0x01C8, lccode=0x01C9, specials={'compat',0x004C,0x004A} },
	[0x01C8] = { unicodeslot=0x01C8, category='lt', contextname='Ljligature', description='LATIN CAPITAL LETTER L WITH SMALL LETTER J', shcode=0x004C, uccode=0x01C7, lccode=0x01C9, specials={'compat',0x004C,0x006A} },
	[0x01C9] = { unicodeslot=0x01C9, category='ll', contextname='ljligature', description='LATIN SMALL LETTER LJ', uccode=0x01C7, specials={'compat',0x006C,0x006A} },
	[0x01CA] = { unicodeslot=0x01CA, category='lu', contextname='NJligature', description='LATIN CAPITAL LETTER NJ', uccode=0x01CB, lccode=0x01CC, specials={'compat',0x004E,0x004A} },
	[0x01CB] = { unicodeslot=0x01CB, category='lt', contextname='Njligature', description='LATIN CAPITAL LETTER N WITH SMALL LETTER J', shcode=0x004E, uccode=0x01CA, lccode=0x01CC, specials={'compat',0x004E,0x006A} },
	[0x01CC] = { unicodeslot=0x01CC, category='ll', contextname='njligature', description='LATIN SMALL LETTER NJ', uccode=0x01CA, specials={'compat',0x006E,0x006A} },
	[0x01CD] = { unicodeslot=0x01CD, category='lu', contextname='Acaron', description='LATIN CAPITAL LETTER A WITH CARON', shcode=0x0041, lccode=0x01CE, specials={'char',0x0041,0x030C} },
	[0x01CE] = { unicodeslot=0x01CE, category='ll', contextname='acaron', description='LATIN SMALL LETTER A WITH CARON', shcode=0x0061, uccode=0x01CD, specials={'char',0x0061,0x030C} },
	[0x01CF] = { unicodeslot=0x01CF, category='lu', contextname='Icaron', description='LATIN CAPITAL LETTER I WITH CARON', shcode=0x0049, lccode=0x01D0, specials={'char',0x0049,0x030C} },
	[0x01D0] = { unicodeslot=0x01D0, category='ll', contextname='icaron', description='LATIN SMALL LETTER I WITH CARON', shcode=0x0069, uccode=0x01CF, specials={'char',0x0069,0x030C} },
	[0x01D1] = { unicodeslot=0x01D1, category='lu', contextname='Ocaron', description='LATIN CAPITAL LETTER O WITH CARON', shcode=0x004F, lccode=0x01D2, specials={'char',0x004F,0x030C} },
	[0x01D2] = { unicodeslot=0x01D2, category='ll', contextname='ocaron', description='LATIN SMALL LETTER O WITH CARON', shcode=0x006F, uccode=0x01D1, specials={'char',0x006F,0x030C} },
	[0x01D3] = { unicodeslot=0x01D3, category='lu', contextname='Ucaron', description='LATIN CAPITAL LETTER U WITH CARON', shcode=0x0055, lccode=0x01D4, specials={'char',0x0055,0x030C} },
	[0x01D4] = { unicodeslot=0x01D4, category='ll', contextname='ucaron', description='LATIN SMALL LETTER U WITH CARON', shcode=0x0075, uccode=0x01D3, specials={'char',0x0075,0x030C} },
	[0x01D5] = { unicodeslot=0x01D5, category='lu', contextname='Udiaeresismacron', description='LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON', shcode=0x0055, lccode=0x01D6, specials={'char',0x00DC,0x0304} },
	[0x01D6] = { unicodeslot=0x01D6, category='ll', contextname='udiaeresismacron', description='LATIN SMALL LETTER U WITH DIAERESIS AND MACRON', shcode=0x0075, uccode=0x01D5, specials={'char',0x00FC,0x0304} },
	[0x01D7] = { unicodeslot=0x01D7, category='lu', contextname='Udiaeresisacute', description='LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE', shcode=0x0055, lccode=0x01D8, specials={'char',0x00DC,0x0301} },
	[0x01D8] = { unicodeslot=0x01D8, category='ll', contextname='udiaeresisacute', description='LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE', shcode=0x0075, uccode=0x01D7, specials={'char',0x00FC,0x0301} },
	[0x01D9] = { unicodeslot=0x01D9, category='lu', contextname='Udiaeresiscaron', description='LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON', shcode=0x0055, lccode=0x01DA, specials={'char',0x00DC,0x030C} },
	[0x01DA] = { unicodeslot=0x01DA, category='ll', contextname='udiaeresiscaron', description='LATIN SMALL LETTER U WITH DIAERESIS AND CARON', shcode=0x0075, uccode=0x01D9, specials={'char',0x00FC,0x030C} },
	[0x01DB] = { unicodeslot=0x01DB, category='lu', contextname='Udiaeresisgrave', description='LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE', shcode=0x0055, lccode=0x01DC, specials={'char',0x00DC,0x0300} },
	[0x01DC] = { unicodeslot=0x01DC, category='ll', contextname='udiaeresisgrave', description='LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE', shcode=0x0075, uccode=0x01DB, specials={'char',0x00FC,0x0300} },
	[0x01DD] = { unicodeslot=0x01DD, category='ll', description='LATIN SMALL LETTER TURNED E', uccode=0x018E },
	[0x01DE] = { unicodeslot=0x01DE, category='lu', contextname='Adiaeresismacron', description='LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON', shcode=0x0041, lccode=0x01DF, specials={'char',0x00C4,0x0304} },
	[0x01DF] = { unicodeslot=0x01DF, category='ll', contextname='adiaeresismacron', description='LATIN SMALL LETTER A WITH DIAERESIS AND MACRON', shcode=0x0061, uccode=0x01DE, specials={'char',0x00E4,0x0304} },
	[0x01E0] = { unicodeslot=0x01E0, category='lu', contextname='Adotaccentmacron', description='LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON', shcode=0x0041, lccode=0x01E1, specials={'char',0x0226,0x0304} },
	[0x01E1] = { unicodeslot=0x01E1, category='ll', contextname='adotaccentmacron', description='LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON', shcode=0x0061, uccode=0x01E0, specials={'char',0x0227,0x0304} },
	[0x01E2] = { unicodeslot=0x01E2, category='lu', contextname='AEmacron', description='LATIN CAPITAL LETTER AE WITH MACRON', shcode=0x00C6, lccode=0x01E3, specials={'char',0x00C6,0x0304} },
	[0x01E3] = { unicodeslot=0x01E3, category='ll', contextname='aemacron', description='LATIN SMALL LETTER AE WITH MACRON', shcode=0x00E6, uccode=0x01E2, specials={'char',0x00E6,0x0304} },
	[0x01E4] = { unicodeslot=0x01E4, category='lu', contextname='Gstroke', description='LATIN CAPITAL LETTER G WITH STROKE', shcode=0x0047, lccode=0x01E5 },
	[0x01E5] = { unicodeslot=0x01E5, category='ll', contextname='gstroke', description='LATIN SMALL LETTER G WITH STROKE', shcode=0x0067, uccode=0x01E4 },
	[0x01E6] = { unicodeslot=0x01E6, category='lu', adobename='Gcaron', contextname='Gcaron', description='LATIN CAPITAL LETTER G WITH CARON', shcode=0x0047, lccode=0x01E7, specials={'char',0x0047,0x030C} },
	[0x01E7] = { unicodeslot=0x01E7, category='ll', adobename='gcaron', contextname='gcaron', description='LATIN SMALL LETTER G WITH CARON', shcode=0x0067, uccode=0x01E6, specials={'char',0x0067,0x030C} },
	[0x01E8] = { unicodeslot=0x01E8, category='lu', contextname='Kcaron', description='LATIN CAPITAL LETTER K WITH CARON', shcode=0x004B, lccode=0x01E9, specials={'char',0x004B,0x030C} },
	[0x01E9] = { unicodeslot=0x01E9, category='ll', contextname='kcaron', description='LATIN SMALL LETTER K WITH CARON', shcode=0x006B, uccode=0x01E8, specials={'char',0x006B,0x030C} },
	[0x01EA] = { unicodeslot=0x01EA, category='lu', contextname='Oogonek', description='LATIN CAPITAL LETTER O WITH OGONEK', shcode=0x004F, lccode=0x01EB, specials={'char',0x004F,0x0328} },
	[0x01EB] = { unicodeslot=0x01EB, category='ll', contextname='oogonek', description='LATIN SMALL LETTER O WITH OGONEK', shcode=0x006F, uccode=0x01EA, specials={'char',0x006F,0x0328} },
	[0x01EC] = { unicodeslot=0x01EC, category='lu', contextname='Oogonekmacron', description='LATIN CAPITAL LETTER O WITH OGONEK AND MACRON', shcode=0x004F, lccode=0x01ED, specials={'char',0x01EA,0x0304} },
	[0x01ED] = { unicodeslot=0x01ED, category='ll', contextname='oogonekmacron', description='LATIN SMALL LETTER O WITH OGONEK AND MACRON', shcode=0x006F, uccode=0x01EC, specials={'char',0x01EB,0x0304} },
	[0x01EE] = { unicodeslot=0x01EE, category='lu', description='LATIN CAPITAL LETTER EZH WITH CARON', shcode=0x01B7, lccode=0x01EF, specials={'char',0x01B7,0x030C} },
	[0x01EF] = { unicodeslot=0x01EF, category='ll', description='LATIN SMALL LETTER EZH WITH CARON', shcode=0x0292, uccode=0x01EE, specials={'char',0x0292,0x030C} },
	[0x01F0] = { unicodeslot=0x01F0, category='ll', contextname='jcaron', description='LATIN SMALL LETTER J WITH CARON', shcode=0x006A, specials={'char',0x006A,0x030C} },
	[0x01F1] = { unicodeslot=0x01F1, category='lu', contextname='DZligature', description='LATIN CAPITAL LETTER DZ', uccode=0x01F2, lccode=0x01F3, specials={'compat',0x0044,0x005A} },
	[0x01F2] = { unicodeslot=0x01F2, category='lt', contextname='Dzligature', description='LATIN CAPITAL LETTER D WITH SMALL LETTER Z', shcode=0x0044, uccode=0x01F1, lccode=0x01F3, specials={'compat',0x0044,0x007A} },
	[0x01F3] = { unicodeslot=0x01F3, category='ll', contextname='dzligature', description='LATIN SMALL LETTER DZ', uccode=0x01F1, specials={'compat',0x0064,0x007A} },
	[0x01F4] = { unicodeslot=0x01F4, category='lu', contextname='Gacute', description='LATIN CAPITAL LETTER G WITH ACUTE', shcode=0x0047, lccode=0x01F5, specials={'char',0x0047,0x0301} },
	[0x01F5] = { unicodeslot=0x01F5, category='ll', contextname='gacute', description='LATIN SMALL LETTER G WITH ACUTE', shcode=0x0067, uccode=0x01F4, specials={'char',0x0067,0x0301} },
	[0x01F6] = { unicodeslot=0x01F6, category='lu', description='LATIN CAPITAL LETTER HWAIR', lccode=0x0195 },
	[0x01F7] = { unicodeslot=0x01F7, category='lu', description='LATIN CAPITAL LETTER WYNN', lccode=0x01BF },
	[0x01F8] = { unicodeslot=0x01F8, category='lu', contextname='Ngrave', description='LATIN CAPITAL LETTER N WITH GRAVE', shcode=0x004E, lccode=0x01F9, specials={'char',0x004E,0x0300} },
	[0x01F9] = { unicodeslot=0x01F9, category='ll', contextname='ngrave', description='LATIN SMALL LETTER N WITH GRAVE', shcode=0x006E, uccode=0x01F8, specials={'char',0x006E,0x0300} },
	[0x01FA] = { unicodeslot=0x01FA, category='lu', adobename='Aringacute', contextname='Aringacute', description='LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE', shcode=0x0041, lccode=0x01FB, specials={'char',0x00C5,0x0301} },
	[0x01FB] = { unicodeslot=0x01FB, category='ll', adobename='aringacute', contextname='aringacute', description='LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE', shcode=0x0061, uccode=0x01FA, specials={'char',0x00E5,0x0301} },
	[0x01FC] = { unicodeslot=0x01FC, category='lu', adobename='AEacute', contextname='AEacute', description='LATIN CAPITAL LETTER AE WITH ACUTE', shcode=0x00C6, lccode=0x01FD, specials={'char',0x00C6,0x0301} },
	[0x01FD] = { unicodeslot=0x01FD, category='ll', adobename='aeacute', contextname='aeacute', description='LATIN SMALL LETTER AE WITH ACUTE', shcode=0x00E6, uccode=0x01FC, specials={'char',0x00E6,0x0301} },
	[0x01FE] = { unicodeslot=0x01FE, category='lu', adobename='Oslashacute', contextname='Ostrokeacute', description='LATIN CAPITAL LETTER O WITH STROKE AND ACUTE', shcode=0x004F, lccode=0x01FF, specials={'char',0x00D8,0x0301} },
	[0x01FF] = { unicodeslot=0x01FF, category='ll', adobename='oslashacute', contextname='ostrokeacute', description='LATIN SMALL LETTER O WITH STROKE AND ACUTE', shcode=0x006F, uccode=0x01FE, specials={'char',0x00F8,0x0301} },
	[0x0200] = { unicodeslot=0x0200, category='lu', contextname='Adoublegrave', description='LATIN CAPITAL LETTER A WITH DOUBLE GRAVE', shcode=0x0041, lccode=0x0201, specials={'char',0x0041,0x030F} },
	[0x0201] = { unicodeslot=0x0201, category='ll', contextname='adoublegrave', description='LATIN SMALL LETTER A WITH DOUBLE GRAVE', shcode=0x0061, uccode=0x0200, specials={'char',0x0061,0x030F} },
	[0x0202] = { unicodeslot=0x0202, category='lu', contextname='Ainvertedbreve', description='LATIN CAPITAL LETTER A WITH INVERTED BREVE', shcode=0x0041, lccode=0x0203, specials={'char',0x0041,0x0311} },
	[0x0203] = { unicodeslot=0x0203, category='ll', contextname='ainvertedbreve', description='LATIN SMALL LETTER A WITH INVERTED BREVE', shcode=0x0061, uccode=0x0202, specials={'char',0x0061,0x0311} },
	[0x0204] = { unicodeslot=0x0204, category='lu', contextname='Edoublegrave', description='LATIN CAPITAL LETTER E WITH DOUBLE GRAVE', shcode=0x0045, lccode=0x0205, specials={'char',0x0045,0x030F} },
	[0x0205] = { unicodeslot=0x0205, category='ll', contextname='edoublegrave', description='LATIN SMALL LETTER E WITH DOUBLE GRAVE', shcode=0x0065, uccode=0x0204, specials={'char',0x0065,0x030F} },
	[0x0206] = { unicodeslot=0x0206, category='lu', contextname='Einvertedbreve', description='LATIN CAPITAL LETTER E WITH INVERTED BREVE', shcode=0x0045, lccode=0x0207, specials={'char',0x0045,0x0311} },
	[0x0207] = { unicodeslot=0x0207, category='ll', contextname='einvertedbreve', description='LATIN SMALL LETTER E WITH INVERTED BREVE', shcode=0x0065, uccode=0x0206, specials={'char',0x0065,0x0311} },
	[0x0208] = { unicodeslot=0x0208, category='lu', contextname='Idoublegrave', description='LATIN CAPITAL LETTER I WITH DOUBLE GRAVE', shcode=0x0049, lccode=0x0209, specials={'char',0x0049,0x030F} },
	[0x0209] = { unicodeslot=0x0209, category='ll', contextname='idoublegrave', description='LATIN SMALL LETTER I WITH DOUBLE GRAVE', shcode=0x0069, uccode=0x0208, specials={'char',0x0069,0x030F} },
	[0x020A] = { unicodeslot=0x020A, category='lu', contextname='Iinvertedbreve', description='LATIN CAPITAL LETTER I WITH INVERTED BREVE', shcode=0x0049, lccode=0x020B, specials={'char',0x0049,0x0311} },
	[0x020B] = { unicodeslot=0x020B, category='ll', contextname='iinvertedbreve', description='LATIN SMALL LETTER I WITH INVERTED BREVE', shcode=0x0069, uccode=0x020A, specials={'char',0x0069,0x0311} },
	[0x020C] = { unicodeslot=0x020C, category='lu', contextname='Odoublegrave', description='LATIN CAPITAL LETTER O WITH DOUBLE GRAVE', shcode=0x004F, lccode=0x020D, specials={'char',0x004F,0x030F} },
	[0x020D] = { unicodeslot=0x020D, category='ll', contextname='odoublegrave', description='LATIN SMALL LETTER O WITH DOUBLE GRAVE', shcode=0x006F, uccode=0x020C, specials={'char',0x006F,0x030F} },
	[0x020E] = { unicodeslot=0x020E, category='lu', contextname='Oinvertedbreve', description='LATIN CAPITAL LETTER O WITH INVERTED BREVE', shcode=0x004F, lccode=0x020F, specials={'char',0x004F,0x0311} },
	[0x020F] = { unicodeslot=0x020F, category='ll', contextname='oinvertedbreve', description='LATIN SMALL LETTER O WITH INVERTED BREVE', shcode=0x006F, uccode=0x020E, specials={'char',0x006F,0x0311} },
	[0x0210] = { unicodeslot=0x0210, category='lu', contextname='Rdoublegrave', description='LATIN CAPITAL LETTER R WITH DOUBLE GRAVE', shcode=0x0052, lccode=0x0211, specials={'char',0x0052,0x030F} },
	[0x0211] = { unicodeslot=0x0211, category='ll', contextname='rdoublegrave', description='LATIN SMALL LETTER R WITH DOUBLE GRAVE', shcode=0x0072, uccode=0x0210, specials={'char',0x0072,0x030F} },
	[0x0212] = { unicodeslot=0x0212, category='lu', contextname='Rinvertedbreve', description='LATIN CAPITAL LETTER R WITH INVERTED BREVE', shcode=0x0052, lccode=0x0213, specials={'char',0x0052,0x0311} },
	[0x0213] = { unicodeslot=0x0213, category='ll', contextname='rinvertedbreve', description='LATIN SMALL LETTER R WITH INVERTED BREVE', shcode=0x0072, uccode=0x0212, specials={'char',0x0072,0x0311} },
	[0x0214] = { unicodeslot=0x0214, category='lu', contextname='Udoublegrave', description='LATIN CAPITAL LETTER U WITH DOUBLE GRAVE', shcode=0x0055, lccode=0x0215, specials={'char',0x0055,0x030F} },
	[0x0215] = { unicodeslot=0x0215, category='ll', contextname='udoublegrave', description='LATIN SMALL LETTER U WITH DOUBLE GRAVE', shcode=0x0075, uccode=0x0214, specials={'char',0x0075,0x030F} },
	[0x0216] = { unicodeslot=0x0216, category='lu', contextname='Uinvertedbreve', description='LATIN CAPITAL LETTER U WITH INVERTED BREVE', shcode=0x0055, lccode=0x0217, specials={'char',0x0055,0x0311} },
	[0x0217] = { unicodeslot=0x0217, category='ll', contextname='uinvertedbreve', description='LATIN SMALL LETTER U WITH INVERTED BREVE', shcode=0x0075, uccode=0x0216, specials={'char',0x0075,0x0311} },
	[0x0218] = { unicodeslot=0x0218, category='lu', adobename='Scommaaccent', contextname='Scommaaccent', description='LATIN CAPITAL LETTER S WITH COMMA BELOW', shcode=0x0053, lccode=0x0219, specials={'char',0x0053,0x0326} },
	[0x0219] = { unicodeslot=0x0219, category='ll', adobename='scommaaccent', contextname='scommaaccent', description='LATIN SMALL LETTER S WITH COMMA BELOW', shcode=0x0073, uccode=0x0218, specials={'char',0x0073,0x0326} },
	[0x021A] = { unicodeslot=0x021A, category='lu', contextname='Tcommaaccent', description='LATIN CAPITAL LETTER T WITH COMMA BELOW', shcode=0x0054, lccode=0x021B, specials={'char',0x0054,0x0326} },
	[0x021B] = { unicodeslot=0x021B, category='ll', contextname='tcommaaccent', description='LATIN SMALL LETTER T WITH COMMA BELOW', shcode=0x0074, uccode=0x021A, specials={'char',0x0074,0x0326} },
	[0x021C] = { unicodeslot=0x021C, category='lu', description='LATIN CAPITAL LETTER YOGH', lccode=0x021D },
	[0x021D] = { unicodeslot=0x021D, category='ll', description='LATIN SMALL LETTER YOGH', uccode=0x021C },
	[0x021E] = { unicodeslot=0x021E, category='lu', contextname='Hcaron', description='LATIN CAPITAL LETTER H WITH CARON', shcode=0x0048, lccode=0x021F, specials={'char',0x0048,0x030C} },
	[0x021F] = { unicodeslot=0x021F, category='ll', contextname='hcaron', description='LATIN SMALL LETTER H WITH CARON', shcode=0x0068, uccode=0x021E, specials={'char',0x0068,0x030C} },
	[0x0220] = { unicodeslot=0x0220, category='lu', description='LATIN CAPITAL LETTER N WITH LONG RIGHT LEG', shcode=0x004E, lccode=0x019E },
	[0x0221] = { unicodeslot=0x0221, category='ll', contextname='dcurl', description='LATIN SMALL LETTER D WITH CURL', shcode=0x0064 },
	[0x0222] = { unicodeslot=0x0222, category='lu', description='LATIN CAPITAL LETTER OU', lccode=0x0223 },
	[0x0223] = { unicodeslot=0x0223, category='ll', description='LATIN SMALL LETTER OU', uccode=0x0222 },
	[0x0224] = { unicodeslot=0x0224, category='lu', contextname='Zhook', description='LATIN CAPITAL LETTER Z WITH HOOK', shcode=0x005A, lccode=0x0225 },
	[0x0225] = { unicodeslot=0x0225, category='ll', contextname='zhook', description='LATIN SMALL LETTER Z WITH HOOK', shcode=0x007A, uccode=0x0224 },
	[0x0226] = { unicodeslot=0x0226, category='lu', contextname='Adotaccent', description='LATIN CAPITAL LETTER A WITH DOT ABOVE', shcode=0x0041, lccode=0x0227, specials={'char',0x0041,0x0307} },
	[0x0227] = { unicodeslot=0x0227, category='ll', contextname='adotaccent', description='LATIN SMALL LETTER A WITH DOT ABOVE', shcode=0x0061, uccode=0x0226, specials={'char',0x0061,0x0307} },
	[0x0228] = { unicodeslot=0x0228, category='lu', contextname='Ecedilla', description='LATIN CAPITAL LETTER E WITH CEDILLA', shcode=0x0045, lccode=0x0229, specials={'char',0x0045,0x0327} },
	[0x0229] = { unicodeslot=0x0229, category='ll', contextname='ecedilla', description='LATIN SMALL LETTER E WITH CEDILLA', shcode=0x0065, uccode=0x0228, specials={'char',0x0065,0x0327} },
	[0x022A] = { unicodeslot=0x022A, category='lu', contextname='Odiaeresismacron', description='LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON', shcode=0x004F, lccode=0x022B, specials={'char',0x00D6,0x0304} },
	[0x022B] = { unicodeslot=0x022B, category='ll', contextname='odiaeresismacron', description='LATIN SMALL LETTER O WITH DIAERESIS AND MACRON', shcode=0x006F, uccode=0x022A, specials={'char',0x00F6,0x0304} },
	[0x022C] = { unicodeslot=0x022C, category='lu', contextname='Otildemacron', description='LATIN CAPITAL LETTER O WITH TILDE AND MACRON', shcode=0x004F, lccode=0x022D, specials={'char',0x00D5,0x0304} },
	[0x022D] = { unicodeslot=0x022D, category='ll', contextname='otildemacron', description='LATIN SMALL LETTER O WITH TILDE AND MACRON', shcode=0x006F, uccode=0x022C, specials={'char',0x00F5,0x0304} },
	[0x022E] = { unicodeslot=0x022E, category='lu', contextname='Odotaccent', description='LATIN CAPITAL LETTER O WITH DOT ABOVE', shcode=0x004F, lccode=0x022F, specials={'char',0x004F,0x0307} },
	[0x022F] = { unicodeslot=0x022F, category='ll', contextname='odotaccent', description='LATIN SMALL LETTER O WITH DOT ABOVE', shcode=0x006F, uccode=0x022E, specials={'char',0x006F,0x0307} },
	[0x0230] = { unicodeslot=0x0230, category='lu', contextname='Odotaccentmacron', description='LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON', shcode=0x004F, lccode=0x0231, specials={'char',0x022E,0x0304} },
	[0x0231] = { unicodeslot=0x0231, category='ll', contextname='odotaccentmacron', description='LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON', shcode=0x006F, uccode=0x0230, specials={'char',0x022F,0x0304} },
	[0x0232] = { unicodeslot=0x0232, category='lu', contextname='Ymacron', description='LATIN CAPITAL LETTER Y WITH MACRON', shcode=0x0059, lccode=0x0233, specials={'char',0x0059,0x0304} },
	[0x0233] = { unicodeslot=0x0233, category='ll', contextname='ymacron', description='LATIN SMALL LETTER Y WITH MACRON', shcode=0x0079, uccode=0x0232, specials={'char',0x0079,0x0304} },
	[0x0234] = { unicodeslot=0x0234, category='ll', contextname='lcurl', description='LATIN SMALL LETTER L WITH CURL', shcode=0x006C },
	[0x0235] = { unicodeslot=0x0235, category='ll', contextname='ncurl', description='LATIN SMALL LETTER N WITH CURL', shcode=0x006E },
	[0x0236] = { unicodeslot=0x0236, category='ll', contextname='tcurl', description='LATIN SMALL LETTER T WITH CURL', shcode=0x0074 },
	[0x0237] = { unicodeslot=0x0237, category='ll', contextname='dotlessj', description='LATIN SMALL LETTER DOTLESS J' },
	[0x0238] = { unicodeslot=0x0238, category='ll', description='LATIN SMALL LETTER DB DIGRAPH' },
	[0x0239] = { unicodeslot=0x0239, category='ll', description='LATIN SMALL LETTER QP DIGRAPH' },
	[0x023A] = { unicodeslot=0x023A, category='lu', contextname='Astroke', description='LATIN CAPITAL LETTER A WITH STROKE', shcode=0x0041, lccode=0x2C65 },
	[0x023B] = { unicodeslot=0x023B, category='lu', contextname='Cstroke', description='LATIN CAPITAL LETTER C WITH STROKE', shcode=0x0043, lccode=0x023C },
	[0x023C] = { unicodeslot=0x023C, category='ll', contextname='cstroke', description='LATIN SMALL LETTER C WITH STROKE', shcode=0x0063, uccode=0x023B },
	[0x023D] = { unicodeslot=0x023D, category='lu', contextname='Lbar', description='LATIN CAPITAL LETTER L WITH BAR', shcode=0x004C, lccode=0x019A },
	[0x023E] = { unicodeslot=0x023E, category='lu', description='LATIN CAPITAL LETTER T WITH DIAGONAL STROKE', shcode=0x0054, lccode=0x2C66 },
	[0x023F] = { unicodeslot=0x023F, category='ll', description='LATIN SMALL LETTER S WITH SWASH TAIL', shcode=0x0073 },
	[0x0240] = { unicodeslot=0x0240, category='ll', description='LATIN SMALL LETTER Z WITH SWASH TAIL', shcode=0x007A },
	[0x0241] = { unicodeslot=0x0241, category='lu', description='LATIN CAPITAL LETTER GLOTTAL STOP', lccode=0x0242 },
	[0x0242] = { unicodeslot=0x0242, category='ll', description='LATIN SMALL LETTER GLOTTAL STOP', uccode=0x0241 },
	[0x0243] = { unicodeslot=0x0243, category='lu', description='LATIN CAPITAL LETTER B WITH STROKE', shcode=0x0042, lccode=0x0180 },
	[0x0244] = { unicodeslot=0x0244, category='lu', description='LATIN CAPITAL LETTER U BAR', lccode=0x0289 },
	[0x0245] = { unicodeslot=0x0245, category='lu', description='LATIN CAPITAL LETTER TURNED V', lccode=0x028C },
	[0x0246] = { unicodeslot=0x0246, category='lu', description='LATIN CAPITAL LETTER E WITH STROKE', shcode=0x0045, lccode=0x0247 },
	[0x0247] = { unicodeslot=0x0247, category='ll', description='LATIN SMALL LETTER E WITH STROKE', shcode=0x0065, uccode=0x0246 },
	[0x0248] = { unicodeslot=0x0248, category='lu', description='LATIN CAPITAL LETTER J WITH STROKE', shcode=0x004A, lccode=0x0249 },
	[0x0249] = { unicodeslot=0x0249, category='ll', description='LATIN SMALL LETTER J WITH STROKE', shcode=0x006A, uccode=0x0248 },
	[0x024A] = { unicodeslot=0x024A, category='lu', description='LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL', lccode=0x024B },
	[0x024B] = { unicodeslot=0x024B, category='ll', description='LATIN SMALL LETTER Q WITH HOOK TAIL', shcode=0x0071, uccode=0x024A },
	[0x024C] = { unicodeslot=0x024C, category='lu', description='LATIN CAPITAL LETTER R WITH STROKE', shcode=0x0052, lccode=0x024D },
	[0x024D] = { unicodeslot=0x024D, category='ll', description='LATIN SMALL LETTER R WITH STROKE', shcode=0x0072, uccode=0x024C },
	[0x024E] = { unicodeslot=0x024E, category='lu', description='LATIN CAPITAL LETTER Y WITH STROKE', shcode=0x0059, lccode=0x024F },
	[0x024F] = { unicodeslot=0x024F, category='ll', description='LATIN SMALL LETTER Y WITH STROKE', shcode=0x0079, uccode=0x024E },
	[0x0250] = { unicodeslot=0x0250, category='ll', description='LATIN SMALL LETTER TURNED A' },
	[0x0251] = { unicodeslot=0x0251, category='ll', description='LATIN SMALL LETTER ALPHA' },
	[0x0252] = { unicodeslot=0x0252, category='ll', description='LATIN SMALL LETTER TURNED ALPHA' },
	[0x0253] = { unicodeslot=0x0253, category='ll', contextname='bhook', description='LATIN SMALL LETTER B WITH HOOK', shcode=0x0062, uccode=0x0181 },
	[0x0254] = { unicodeslot=0x0254, category='ll', description='LATIN SMALL LETTER OPEN O', uccode=0x0186 },
	[0x0255] = { unicodeslot=0x0255, category='ll', contextname='ccurl', description='LATIN SMALL LETTER C WITH CURL', shcode=0x0063 },
	[0x0256] = { unicodeslot=0x0256, category='ll', contextname='dtail', description='LATIN SMALL LETTER D WITH TAIL', shcode=0x0064, uccode=0x0189 },
	[0x0257] = { unicodeslot=0x0257, category='ll', contextname='dhook', description='LATIN SMALL LETTER D WITH HOOK', shcode=0x0064, uccode=0x018A },
	[0x0258] = { unicodeslot=0x0258, category='ll', description='LATIN SMALL LETTER REVERSED E' },
	[0x0259] = { unicodeslot=0x0259, category='ll', contextname='schwa', description='LATIN SMALL LETTER SCHWA', uccode=0x018F },
	[0x025A] = { unicodeslot=0x025A, category='ll', contextname='schwahook', description='LATIN SMALL LETTER SCHWA WITH HOOK', shcode=0x0259 },
	[0x025B] = { unicodeslot=0x025B, category='ll', description='LATIN SMALL LETTER OPEN E', uccode=0x0190 },
	[0x025C] = { unicodeslot=0x025C, category='ll', description='LATIN SMALL LETTER REVERSED OPEN E' },
	[0x025D] = { unicodeslot=0x025D, category='ll', description='LATIN SMALL LETTER REVERSED OPEN E WITH HOOK' },
	[0x025E] = { unicodeslot=0x025E, category='ll', description='LATIN SMALL LETTER CLOSED REVERSED OPEN E' },
	[0x025F] = { unicodeslot=0x025F, category='ll', contextname='dotlessjstroke', description='LATIN SMALL LETTER DOTLESS J WITH STROKE' },
	[0x0260] = { unicodeslot=0x0260, category='ll', description='LATIN SMALL LETTER G WITH HOOK', shcode=0x0067, uccode=0x0193 },
	[0x0261] = { unicodeslot=0x0261, category='ll', description='LATIN SMALL LETTER SCRIPT G' },
	[0x0262] = { unicodeslot=0x0262, category='ll', description='LATIN LETTER SMALL CAPITAL G' },
	[0x0263] = { unicodeslot=0x0263, category='ll', description='LATIN SMALL LETTER GAMMA', uccode=0x0194 },
	[0x0264] = { unicodeslot=0x0264, category='ll', description='LATIN SMALL LETTER RAMS HORN' },
	[0x0265] = { unicodeslot=0x0265, category='ll', description='LATIN SMALL LETTER TURNED H' },
	[0x0266] = { unicodeslot=0x0266, category='ll', description='LATIN SMALL LETTER H WITH HOOK', shcode=0x0068 },
	[0x0267] = { unicodeslot=0x0267, category='ll', description='LATIN SMALL LETTER HENG WITH HOOK' },
	[0x0268] = { unicodeslot=0x0268, category='ll', description='LATIN SMALL LETTER I WITH STROKE', shcode=0x0069, uccode=0x0197 },
	[0x0269] = { unicodeslot=0x0269, category='ll', description='LATIN SMALL LETTER IOTA', uccode=0x0196 },
	[0x026A] = { unicodeslot=0x026A, category='ll', description='LATIN LETTER SMALL CAPITAL I' },
	[0x026B] = { unicodeslot=0x026B, category='ll', description='LATIN SMALL LETTER L WITH MIDDLE TILDE', shcode=0x006C, uccode=0x2C62 },
	[0x026C] = { unicodeslot=0x026C, category='ll', description='LATIN SMALL LETTER L WITH BELT', shcode=0x006C },
	[0x026D] = { unicodeslot=0x026D, category='ll', description='LATIN SMALL LETTER L WITH RETROFLEX HOOK', shcode=0x006C },
	[0x026E] = { unicodeslot=0x026E, category='ll', description='LATIN SMALL LETTER LEZH' },
	[0x026F] = { unicodeslot=0x026F, category='ll', description='LATIN SMALL LETTER TURNED M', uccode=0x019C },
	[0x0270] = { unicodeslot=0x0270, category='ll', description='LATIN SMALL LETTER TURNED M WITH LONG LEG' },
	[0x0271] = { unicodeslot=0x0271, category='ll', description='LATIN SMALL LETTER M WITH HOOK', shcode=0x006D },
	[0x0272] = { unicodeslot=0x0272, category='ll', description='LATIN SMALL LETTER N WITH LEFT HOOK', shcode=0x006E, uccode=0x019D },
	[0x0273] = { unicodeslot=0x0273, category='ll', description='LATIN SMALL LETTER N WITH RETROFLEX HOOK', shcode=0x006E },
	[0x0274] = { unicodeslot=0x0274, category='ll', description='LATIN LETTER SMALL CAPITAL N' },
	[0x0275] = { unicodeslot=0x0275, category='ll', description='LATIN SMALL LETTER BARRED O', uccode=0x019F },
	[0x0276] = { unicodeslot=0x0276, category='ll', description='LATIN LETTER SMALL CAPITAL OE' },
	[0x0277] = { unicodeslot=0x0277, category='ll', description='LATIN SMALL LETTER CLOSED OMEGA' },
	[0x0278] = { unicodeslot=0x0278, category='ll', description='LATIN SMALL LETTER PHI' },
	[0x0279] = { unicodeslot=0x0279, category='ll', description='LATIN SMALL LETTER TURNED R' },
	[0x027A] = { unicodeslot=0x027A, category='ll', description='LATIN SMALL LETTER TURNED R WITH LONG LEG' },
	[0x027B] = { unicodeslot=0x027B, category='ll', description='LATIN SMALL LETTER TURNED R WITH HOOK' },
	[0x027C] = { unicodeslot=0x027C, category='ll', description='LATIN SMALL LETTER R WITH LONG LEG', shcode=0x0072 },
	[0x027D] = { unicodeslot=0x027D, category='ll', description='LATIN SMALL LETTER R WITH TAIL', shcode=0x0072, uccode=0x2C64 },
	[0x027E] = { unicodeslot=0x027E, category='ll', description='LATIN SMALL LETTER R WITH FISHHOOK', shcode=0x0072 },
	[0x027F] = { unicodeslot=0x027F, category='ll', description='LATIN SMALL LETTER REVERSED R WITH FISHHOOK' },
	[0x0280] = { unicodeslot=0x0280, category='ll', description='LATIN LETTER SMALL CAPITAL R', uccode=0x01A6 },
	[0x0281] = { unicodeslot=0x0281, category='ll', description='LATIN LETTER SMALL CAPITAL INVERTED R' },
	[0x0282] = { unicodeslot=0x0282, category='ll', description='LATIN SMALL LETTER S WITH HOOK', shcode=0x0073 },
	[0x0283] = { unicodeslot=0x0283, category='ll', description='LATIN SMALL LETTER ESH', uccode=0x01A9 },
	[0x0284] = { unicodeslot=0x0284, category='ll', description='LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK' },
	[0x0285] = { unicodeslot=0x0285, category='ll', description='LATIN SMALL LETTER SQUAT REVERSED ESH' },
	[0x0286] = { unicodeslot=0x0286, category='ll', description='LATIN SMALL LETTER ESH WITH CURL', shcode=0x0283 },
	[0x0287] = { unicodeslot=0x0287, category='ll', description='LATIN SMALL LETTER TURNED T' },
	[0x0288] = { unicodeslot=0x0288, category='ll', description='LATIN SMALL LETTER T WITH RETROFLEX HOOK', shcode=0x0074, uccode=0x01AE },
	[0x0289] = { unicodeslot=0x0289, category='ll', description='LATIN SMALL LETTER U BAR', uccode=0x0244 },
	[0x028A] = { unicodeslot=0x028A, category='ll', description='LATIN SMALL LETTER UPSILON', uccode=0x01B1 },
	[0x028B] = { unicodeslot=0x028B, category='ll', description='LATIN SMALL LETTER V WITH HOOK', shcode=0x0076, uccode=0x01B2 },
	[0x028C] = { unicodeslot=0x028C, category='ll', description='LATIN SMALL LETTER TURNED V', uccode=0x0245 },
	[0x028D] = { unicodeslot=0x028D, category='ll', description='LATIN SMALL LETTER TURNED W' },
	[0x028E] = { unicodeslot=0x028E, category='ll', description='LATIN SMALL LETTER TURNED Y' },
	[0x028F] = { unicodeslot=0x028F, category='ll', description='LATIN LETTER SMALL CAPITAL Y' },
	[0x0290] = { unicodeslot=0x0290, category='ll', description='LATIN SMALL LETTER Z WITH RETROFLEX HOOK', shcode=0x007A },
	[0x0291] = { unicodeslot=0x0291, category='ll', description='LATIN SMALL LETTER Z WITH CURL', shcode=0x007A },
	[0x0292] = { unicodeslot=0x0292, category='ll', description='LATIN SMALL LETTER EZH', uccode=0x01B7 },
	[0x0293] = { unicodeslot=0x0293, category='ll', description='LATIN SMALL LETTER EZH WITH CURL', shcode=0x0292 },
	[0x0294] = { unicodeslot=0x0294, category='lo', description='LATIN LETTER GLOTTAL STOP' },
	[0x0295] = { unicodeslot=0x0295, category='ll', description='LATIN LETTER PHARYNGEAL VOICED FRICATIVE' },
	[0x0296] = { unicodeslot=0x0296, category='ll', description='LATIN LETTER INVERTED GLOTTAL STOP' },
	[0x0297] = { unicodeslot=0x0297, category='ll', description='LATIN LETTER STRETCHED C' },
	[0x0298] = { unicodeslot=0x0298, category='ll', description='LATIN LETTER BILABIAL CLICK' },
	[0x0299] = { unicodeslot=0x0299, category='ll', description='LATIN LETTER SMALL CAPITAL B' },
	[0x029A] = { unicodeslot=0x029A, category='ll', description='LATIN SMALL LETTER CLOSED OPEN E' },
	[0x029B] = { unicodeslot=0x029B, category='ll', description='LATIN LETTER SMALL CAPITAL G WITH HOOK' },
	[0x029C] = { unicodeslot=0x029C, category='ll', description='LATIN LETTER SMALL CAPITAL H' },
	[0x029D] = { unicodeslot=0x029D, category='ll', description='LATIN SMALL LETTER J WITH CROSSED-TAIL', shcode=0x006A },
	[0x029E] = { unicodeslot=0x029E, category='ll', description='LATIN SMALL LETTER TURNED K' },
	[0x029F] = { unicodeslot=0x029F, category='ll', description='LATIN LETTER SMALL CAPITAL L' },
	[0x02A0] = { unicodeslot=0x02A0, category='ll', description='LATIN SMALL LETTER Q WITH HOOK', shcode=0x0071 },
	[0x02A1] = { unicodeslot=0x02A1, category='ll', description='LATIN LETTER GLOTTAL STOP WITH STROKE' },
	[0x02A2] = { unicodeslot=0x02A2, category='ll', description='LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE' },
	[0x02A3] = { unicodeslot=0x02A3, category='ll', description='LATIN SMALL LETTER DZ DIGRAPH' },
	[0x02A4] = { unicodeslot=0x02A4, category='ll', description='LATIN SMALL LETTER DEZH DIGRAPH' },
	[0x02A5] = { unicodeslot=0x02A5, category='ll', description='LATIN SMALL LETTER DZ DIGRAPH WITH CURL' },
	[0x02A6] = { unicodeslot=0x02A6, category='ll', description='LATIN SMALL LETTER TS DIGRAPH' },
	[0x02A7] = { unicodeslot=0x02A7, category='ll', description='LATIN SMALL LETTER TESH DIGRAPH' },
	[0x02A8] = { unicodeslot=0x02A8, category='ll', description='LATIN SMALL LETTER TC DIGRAPH WITH CURL' },
	[0x02A9] = { unicodeslot=0x02A9, category='ll', description='LATIN SMALL LETTER FENG DIGRAPH' },
	[0x02AA] = { unicodeslot=0x02AA, category='ll', description='LATIN SMALL LETTER LS DIGRAPH' },
	[0x02AB] = { unicodeslot=0x02AB, category='ll', description='LATIN SMALL LETTER LZ DIGRAPH' },
	[0x02AC] = { unicodeslot=0x02AC, category='ll', description='LATIN LETTER BILABIAL PERCUSSIVE' },
	[0x02AD] = { unicodeslot=0x02AD, category='ll', description='LATIN LETTER BIDENTAL PERCUSSIVE' },
	[0x02AE] = { unicodeslot=0x02AE, category='ll', description='LATIN SMALL LETTER TURNED H WITH FISHHOOK' },
	[0x02AF] = { unicodeslot=0x02AF, category='ll', description='LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL' },
	[0x02B0] = { unicodeslot=0x02B0, category='lm', description='MODIFIER LETTER SMALL H', specials={'super',0x0068} },
	[0x02B1] = { unicodeslot=0x02B1, category='lm', description='MODIFIER LETTER SMALL H WITH HOOK', specials={'super',0x0266} },
	[0x02B2] = { unicodeslot=0x02B2, category='lm', description='MODIFIER LETTER SMALL J', specials={'super',0x006A} },
	[0x02B3] = { unicodeslot=0x02B3, category='lm', description='MODIFIER LETTER SMALL R', specials={'super',0x0072} },
	[0x02B4] = { unicodeslot=0x02B4, category='lm', description='MODIFIER LETTER SMALL TURNED R', specials={'super',0x0279} },
	[0x02B5] = { unicodeslot=0x02B5, category='lm', description='MODIFIER LETTER SMALL TURNED R WITH HOOK', specials={'super',0x027B} },
	[0x02B6] = { unicodeslot=0x02B6, category='lm', description='MODIFIER LETTER SMALL CAPITAL INVERTED R', specials={'super',0x0281} },
	[0x02B7] = { unicodeslot=0x02B7, category='lm', description='MODIFIER LETTER SMALL W', specials={'super',0x0077} },
	[0x02B8] = { unicodeslot=0x02B8, category='lm', description='MODIFIER LETTER SMALL Y', specials={'super',0x0079} },
	[0x02B9] = { unicodeslot=0x02B9, category='lm', description='MODIFIER LETTER PRIME' },
	[0x02BA] = { unicodeslot=0x02BA, category='lm', description='MODIFIER LETTER DOUBLE PRIME' },
	[0x02BB] = { unicodeslot=0x02BB, category='lm', description='MODIFIER LETTER TURNED COMMA' },
	[0x02BC] = { unicodeslot=0x02BC, category='lm', adobename='afii57929', description='MODIFIER LETTER APOSTROPHE' },
	[0x02BD] = { unicodeslot=0x02BD, category='lm', adobename='afii64937', description='MODIFIER LETTER REVERSED COMMA' },
	[0x02BE] = { unicodeslot=0x02BE, category='lm', description='MODIFIER LETTER RIGHT HALF RING' },
	[0x02BF] = { unicodeslot=0x02BF, category='lm', description='MODIFIER LETTER LEFT HALF RING' },
	[0x02C0] = { unicodeslot=0x02C0, category='lm', description='MODIFIER LETTER GLOTTAL STOP' },
	[0x02C1] = { unicodeslot=0x02C1, category='lm', description='MODIFIER LETTER REVERSED GLOTTAL STOP' },
	[0x02C2] = { unicodeslot=0x02C2, category='sk', description='MODIFIER LETTER LEFT ARROWHEAD' },
	[0x02C3] = { unicodeslot=0x02C3, category='sk', description='MODIFIER LETTER RIGHT ARROWHEAD' },
	[0x02C4] = { unicodeslot=0x02C4, category='sk', description='MODIFIER LETTER UP ARROWHEAD' },
	[0x02C5] = { unicodeslot=0x02C5, category='sk', description='MODIFIER LETTER DOWN ARROWHEAD' },
	[0x02C6] = { unicodeslot=0x02C6, category='lm', adobename='circumflex', contextname='textcircumflex', description='MODIFIER LETTER CIRCUMFLEX ACCENT' },
	[0x02C7] = { unicodeslot=0x02C7, category='lm', adobename='caron', contextname='textcaron', description='CARON' },
	[0x02C8] = { unicodeslot=0x02C8, category='lm', description='MODIFIER LETTER VERTICAL LINE' },
	[0x02C9] = { unicodeslot=0x02C9, category='lm', description='MODIFIER LETTER MACRON' },
	[0x02CA] = { unicodeslot=0x02CA, category='lm', description='MODIFIER LETTER ACUTE ACCENT' },
	[0x02CB] = { unicodeslot=0x02CB, category='lm', description='MODIFIER LETTER GRAVE ACCENT' },
	[0x02CC] = { unicodeslot=0x02CC, category='lm', description='MODIFIER LETTER LOW VERTICAL LINE' },
	[0x02CD] = { unicodeslot=0x02CD, category='lm', description='MODIFIER LETTER LOW MACRON' },
	[0x02CE] = { unicodeslot=0x02CE, category='lm', description='MODIFIER LETTER LOW GRAVE ACCENT' },
	[0x02CF] = { unicodeslot=0x02CF, category='lm', description='MODIFIER LETTER LOW ACUTE ACCENT' },
	[0x02D0] = { unicodeslot=0x02D0, category='lm', description='MODIFIER LETTER TRIANGULAR COLON' },
	[0x02D1] = { unicodeslot=0x02D1, category='lm', description='MODIFIER LETTER HALF TRIANGULAR COLON' },
	[0x02D2] = { unicodeslot=0x02D2, category='sk', description='MODIFIER LETTER CENTRED RIGHT HALF RING' },
	[0x02D3] = { unicodeslot=0x02D3, category='sk', description='MODIFIER LETTER CENTRED LEFT HALF RING' },
	[0x02D4] = { unicodeslot=0x02D4, category='sk', description='MODIFIER LETTER UP TACK' },
	[0x02D5] = { unicodeslot=0x02D5, category='sk', description='MODIFIER LETTER DOWN TACK' },
	[0x02D6] = { unicodeslot=0x02D6, category='sk', description='MODIFIER LETTER PLUS SIGN' },
	[0x02D7] = { unicodeslot=0x02D7, category='sk', description='MODIFIER LETTER MINUS SIGN' },
	[0x02D8] = { unicodeslot=0x02D8, category='sk', adobename='breve', contextname='textbreve', description='BREVE', specials={'compat',0x0020,0x0306} },
	[0x02D9] = { unicodeslot=0x02D9, category='sk', adobename='dotaccent', contextname='textdotaccent', description='DOT ABOVE', specials={'compat',0x0020,0x0307} },
	[0x02DA] = { unicodeslot=0x02DA, category='sk', adobename='ring', contextname='textring', description='RING ABOVE', specials={'compat',0x0020,0x030A} },
	[0x02DB] = { unicodeslot=0x02DB, category='sk', adobename='ogonek', contextname='textogonek', description='OGONEK', specials={'compat',0x0020,0x0328} },
	[0x02DC] = { unicodeslot=0x02DC, category='sk', adobename='tilde', contextname='texttilde', description='SMALL TILDE', specials={'compat',0x0020,0x0303} },
	[0x02DD] = { unicodeslot=0x02DD, category='sk', adobename='hungarumlaut', contextname='texthungarumlaut', description='DOUBLE ACUTE ACCENT', specials={'compat',0x0020,0x030B} },
	[0x02DE] = { unicodeslot=0x02DE, category='sk', description='MODIFIER LETTER RHOTIC HOOK' },
	[0x02DF] = { unicodeslot=0x02DF, category='sk', description='MODIFIER LETTER CROSS ACCENT' },
	[0x02E0] = { unicodeslot=0x02E0, category='lm', description='MODIFIER LETTER SMALL GAMMA', specials={'super',0x0263} },
	[0x02E1] = { unicodeslot=0x02E1, category='lm', description='MODIFIER LETTER SMALL L', specials={'super',0x006C} },
	[0x02E2] = { unicodeslot=0x02E2, category='lm', description='MODIFIER LETTER SMALL S', specials={'super',0x0073} },
	[0x02E3] = { unicodeslot=0x02E3, category='lm', description='MODIFIER LETTER SMALL X', specials={'super',0x0078} },
	[0x02E4] = { unicodeslot=0x02E4, category='lm', description='MODIFIER LETTER SMALL REVERSED GLOTTAL STOP', specials={'super',0x0295} },
	[0x02E5] = { unicodeslot=0x02E5, category='sk', description='MODIFIER LETTER EXTRA-HIGH TONE BAR' },
	[0x02E6] = { unicodeslot=0x02E6, category='sk', description='MODIFIER LETTER HIGH TONE BAR' },
	[0x02E7] = { unicodeslot=0x02E7, category='sk', description='MODIFIER LETTER MID TONE BAR' },
	[0x02E8] = { unicodeslot=0x02E8, category='sk', description='MODIFIER LETTER LOW TONE BAR' },
	[0x02E9] = { unicodeslot=0x02E9, category='sk', description='MODIFIER LETTER EXTRA-LOW TONE BAR' },
	[0x02EA] = { unicodeslot=0x02EA, category='sk', description='MODIFIER LETTER YIN DEPARTING TONE MARK' },
	[0x02EB] = { unicodeslot=0x02EB, category='sk', description='MODIFIER LETTER YANG DEPARTING TONE MARK' },
	[0x02EC] = { unicodeslot=0x02EC, category='sk', description='MODIFIER LETTER VOICING' },
	[0x02ED] = { unicodeslot=0x02ED, category='sk', description='MODIFIER LETTER UNASPIRATED' },
	[0x02EE] = { unicodeslot=0x02EE, category='lm', description='MODIFIER LETTER DOUBLE APOSTROPHE' },
	[0x02EF] = { unicodeslot=0x02EF, category='sk', description='MODIFIER LETTER LOW DOWN ARROWHEAD' },
	[0x02F0] = { unicodeslot=0x02F0, category='sk', description='MODIFIER LETTER LOW UP ARROWHEAD' },
	[0x02F1] = { unicodeslot=0x02F1, category='sk', description='MODIFIER LETTER LOW LEFT ARROWHEAD' },
	[0x02F2] = { unicodeslot=0x02F2, category='sk', description='MODIFIER LETTER LOW RIGHT ARROWHEAD' },
	[0x02F3] = { unicodeslot=0x02F3, category='sk', description='MODIFIER LETTER LOW RING' },
	[0x02F4] = { unicodeslot=0x02F4, category='sk', description='MODIFIER LETTER MIDDLE GRAVE ACCENT' },
	[0x02F5] = { unicodeslot=0x02F5, category='sk', description='MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT' },
	[0x02F6] = { unicodeslot=0x02F6, category='sk', description='MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT' },
	[0x02F7] = { unicodeslot=0x02F7, category='sk', description='MODIFIER LETTER LOW TILDE' },
	[0x02F8] = { unicodeslot=0x02F8, category='sk', description='MODIFIER LETTER RAISED COLON' },
	[0x02F9] = { unicodeslot=0x02F9, category='sk', description='MODIFIER LETTER BEGIN HIGH TONE' },
	[0x02FA] = { unicodeslot=0x02FA, category='sk', description='MODIFIER LETTER END HIGH TONE' },
	[0x02FB] = { unicodeslot=0x02FB, category='sk', description='MODIFIER LETTER BEGIN LOW TONE' },
	[0x02FC] = { unicodeslot=0x02FC, category='sk', description='MODIFIER LETTER END LOW TONE' },
	[0x02FD] = { unicodeslot=0x02FD, category='sk', description='MODIFIER LETTER SHELF' },
	[0x02FE] = { unicodeslot=0x02FE, category='sk', description='MODIFIER LETTER OPEN SHELF' },
	[0x02FF] = { unicodeslot=0x02FF, category='sk', description='MODIFIER LETTER LOW LEFT ARROW' },
	[0x0300] = { unicodeslot=0x0300, category='mn', adobename='gravecomb', description='COMBINING GRAVE ACCENT' },
	[0x0301] = { unicodeslot=0x0301, category='mn', adobename='acutecomb', description='COMBINING ACUTE ACCENT' },
	[0x0302] = { unicodeslot=0x0302, category='mn', description='COMBINING CIRCUMFLEX ACCENT' },
	[0x0303] = { unicodeslot=0x0303, category='mn', adobename='tildecomb', description='COMBINING TILDE' },
	[0x0304] = { unicodeslot=0x0304, category='mn', description='COMBINING MACRON' },
	[0x0305] = { unicodeslot=0x0305, category='mn', description='COMBINING OVERLINE' },
	[0x0306] = { unicodeslot=0x0306, category='mn', description='COMBINING BREVE' },
	[0x0307] = { unicodeslot=0x0307, category='mn', description='COMBINING DOT ABOVE' },
	[0x0308] = { unicodeslot=0x0308, category='mn', description='COMBINING DIAERESIS' },
	[0x0309] = { unicodeslot=0x0309, category='mn', adobename='hookabovecomb', description='COMBINING HOOK ABOVE' },
	[0x030A] = { unicodeslot=0x030A, category='mn', description='COMBINING RING ABOVE' },
	[0x030B] = { unicodeslot=0x030B, category='mn', description='COMBINING DOUBLE ACUTE ACCENT' },
	[0x030C] = { unicodeslot=0x030C, category='mn', description='COMBINING CARON' },
	[0x030D] = { unicodeslot=0x030D, category='mn', description='COMBINING VERTICAL LINE ABOVE' },
	[0x030E] = { unicodeslot=0x030E, category='mn', description='COMBINING DOUBLE VERTICAL LINE ABOVE' },
	[0x030F] = { unicodeslot=0x030F, category='mn', description='COMBINING DOUBLE GRAVE ACCENT' },
	[0x0310] = { unicodeslot=0x0310, category='mn', description='COMBINING CANDRABINDU' },
	[0x0311] = { unicodeslot=0x0311, category='mn', description='COMBINING INVERTED BREVE' },
	[0x0312] = { unicodeslot=0x0312, category='mn', description='COMBINING TURNED COMMA ABOVE' },
	[0x0313] = { unicodeslot=0x0313, category='mn', description='COMBINING COMMA ABOVE' },
	[0x0314] = { unicodeslot=0x0314, category='mn', description='COMBINING REVERSED COMMA ABOVE' },
	[0x0315] = { unicodeslot=0x0315, category='mn', description='COMBINING COMMA ABOVE RIGHT' },
	[0x0316] = { unicodeslot=0x0316, category='mn', description='COMBINING GRAVE ACCENT BELOW' },
	[0x0317] = { unicodeslot=0x0317, category='mn', description='COMBINING ACUTE ACCENT BELOW' },
	[0x0318] = { unicodeslot=0x0318, category='mn', description='COMBINING LEFT TACK BELOW' },
	[0x0319] = { unicodeslot=0x0319, category='mn', description='COMBINING RIGHT TACK BELOW' },
	[0x031A] = { unicodeslot=0x031A, category='mn', description='COMBINING LEFT ANGLE ABOVE' },
	[0x031B] = { unicodeslot=0x031B, category='mn', description='COMBINING HORN' },
	[0x031C] = { unicodeslot=0x031C, category='mn', description='COMBINING LEFT HALF RING BELOW' },
	[0x031D] = { unicodeslot=0x031D, category='mn', description='COMBINING UP TACK BELOW' },
	[0x031E] = { unicodeslot=0x031E, category='mn', description='COMBINING DOWN TACK BELOW' },
	[0x031F] = { unicodeslot=0x031F, category='mn', description='COMBINING PLUS SIGN BELOW' },
	[0x0320] = { unicodeslot=0x0320, category='mn', description='COMBINING MINUS SIGN BELOW' },
	[0x0321] = { unicodeslot=0x0321, category='mn', description='COMBINING PALATALIZED HOOK BELOW' },
	[0x0322] = { unicodeslot=0x0322, category='mn', description='COMBINING RETROFLEX HOOK BELOW' },
	[0x0323] = { unicodeslot=0x0323, category='mn', adobename='dotbelowcomb', description='COMBINING DOT BELOW' },
	[0x0324] = { unicodeslot=0x0324, category='mn', description='COMBINING DIAERESIS BELOW' },
	[0x0325] = { unicodeslot=0x0325, category='mn', description='COMBINING RING BELOW' },
	[0x0326] = { unicodeslot=0x0326, category='mn', description='COMBINING COMMA BELOW' },
	[0x0327] = { unicodeslot=0x0327, category='mn', description='COMBINING CEDILLA' },
	[0x0328] = { unicodeslot=0x0328, category='mn', description='COMBINING OGONEK' },
	[0x0329] = { unicodeslot=0x0329, category='mn', description='COMBINING VERTICAL LINE BELOW' },
	[0x032A] = { unicodeslot=0x032A, category='mn', description='COMBINING BRIDGE BELOW' },
	[0x032B] = { unicodeslot=0x032B, category='mn', description='COMBINING INVERTED DOUBLE ARCH BELOW' },
	[0x032C] = { unicodeslot=0x032C, category='mn', description='COMBINING CARON BELOW' },
	[0x032D] = { unicodeslot=0x032D, category='mn', description='COMBINING CIRCUMFLEX ACCENT BELOW' },
	[0x032E] = { unicodeslot=0x032E, category='mn', description='COMBINING BREVE BELOW' },
	[0x032F] = { unicodeslot=0x032F, category='mn', description='COMBINING INVERTED BREVE BELOW' },
	[0x0330] = { unicodeslot=0x0330, category='mn', description='COMBINING TILDE BELOW' },
	[0x0331] = { unicodeslot=0x0331, category='mn', description='COMBINING MACRON BELOW' },
	[0x0332] = { unicodeslot=0x0332, category='mn', description='COMBINING LOW LINE' },
	[0x0333] = { unicodeslot=0x0333, category='mn', description='COMBINING DOUBLE LOW LINE' },
	[0x0334] = { unicodeslot=0x0334, category='mn', description='COMBINING TILDE OVERLAY' },
	[0x0335] = { unicodeslot=0x0335, category='mn', description='COMBINING SHORT STROKE OVERLAY' },
	[0x0336] = { unicodeslot=0x0336, category='mn', description='COMBINING LONG STROKE OVERLAY' },
	[0x0337] = { unicodeslot=0x0337, category='mn', description='COMBINING SHORT SOLIDUS OVERLAY' },
	[0x0338] = { unicodeslot=0x0338, category='mn', description='COMBINING LONG SOLIDUS OVERLAY' },
	[0x0339] = { unicodeslot=0x0339, category='mn', description='COMBINING RIGHT HALF RING BELOW' },
	[0x033A] = { unicodeslot=0x033A, category='mn', description='COMBINING INVERTED BRIDGE BELOW' },
	[0x033B] = { unicodeslot=0x033B, category='mn', description='COMBINING SQUARE BELOW' },
	[0x033C] = { unicodeslot=0x033C, category='mn', description='COMBINING SEAGULL BELOW' },
	[0x033D] = { unicodeslot=0x033D, category='mn', description='COMBINING X ABOVE' },
	[0x033E] = { unicodeslot=0x033E, category='mn', description='COMBINING VERTICAL TILDE' },
	[0x033F] = { unicodeslot=0x033F, category='mn', description='COMBINING DOUBLE OVERLINE' },
	[0x0340] = { unicodeslot=0x0340, category='mn', description='COMBINING GRAVE TONE MARK', specials={'char',0x0300} },
	[0x0341] = { unicodeslot=0x0341, category='mn', description='COMBINING ACUTE TONE MARK', specials={'char',0x0301} },
	[0x0342] = { unicodeslot=0x0342, category='mn', description='COMBINING GREEK PERISPOMENI' },
	[0x0343] = { unicodeslot=0x0343, category='mn', description='COMBINING GREEK KORONIS', specials={'char',0x0313} },
	[0x0344] = { unicodeslot=0x0344, category='mn', description='COMBINING GREEK DIALYTIKA TONOS', specials={'char',0x0308,0x0301} },
	[0x0345] = { unicodeslot=0x0345, category='mn', description='COMBINING GREEK YPOGEGRAMMENI', uccode=0x0399 },
	[0x0346] = { unicodeslot=0x0346, category='mn', description='COMBINING BRIDGE ABOVE' },
	[0x0347] = { unicodeslot=0x0347, category='mn', description='COMBINING EQUALS SIGN BELOW' },
	[0x0348] = { unicodeslot=0x0348, category='mn', description='COMBINING DOUBLE VERTICAL LINE BELOW' },
	[0x0349] = { unicodeslot=0x0349, category='mn', description='COMBINING LEFT ANGLE BELOW' },
	[0x034A] = { unicodeslot=0x034A, category='mn', description='COMBINING NOT TILDE ABOVE' },
	[0x034B] = { unicodeslot=0x034B, category='mn', description='COMBINING HOMOTHETIC ABOVE' },
	[0x034C] = { unicodeslot=0x034C, category='mn', description='COMBINING ALMOST EQUAL TO ABOVE' },
	[0x034D] = { unicodeslot=0x034D, category='mn', description='COMBINING LEFT RIGHT ARROW BELOW' },
	[0x034E] = { unicodeslot=0x034E, category='mn', description='COMBINING UPWARDS ARROW BELOW' },
	[0x034F] = { unicodeslot=0x034F, category='mn', description='COMBINING GRAPHEME JOINER' },
	[0x0350] = { unicodeslot=0x0350, category='mn', description='COMBINING RIGHT ARROWHEAD ABOVE' },
	[0x0351] = { unicodeslot=0x0351, category='mn', description='COMBINING LEFT HALF RING ABOVE' },
	[0x0352] = { unicodeslot=0x0352, category='mn', description='COMBINING FERMATA' },
	[0x0353] = { unicodeslot=0x0353, category='mn', description='COMBINING X BELOW' },
	[0x0354] = { unicodeslot=0x0354, category='mn', description='COMBINING LEFT ARROWHEAD BELOW' },
	[0x0355] = { unicodeslot=0x0355, category='mn', description='COMBINING RIGHT ARROWHEAD BELOW' },
	[0x0356] = { unicodeslot=0x0356, category='mn', description='COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW' },
	[0x0357] = { unicodeslot=0x0357, category='mn', description='COMBINING RIGHT HALF RING ABOVE' },
	[0x0358] = { unicodeslot=0x0358, category='mn', description='COMBINING DOT ABOVE RIGHT' },
	[0x0359] = { unicodeslot=0x0359, category='mn', description='COMBINING ASTERISK BELOW' },
	[0x035A] = { unicodeslot=0x035A, category='mn', description='COMBINING DOUBLE RING BELOW' },
	[0x035B] = { unicodeslot=0x035B, category='mn', description='COMBINING ZIGZAG ABOVE' },
	[0x035C] = { unicodeslot=0x035C, category='mn', description='COMBINING DOUBLE BREVE BELOW' },
	[0x035D] = { unicodeslot=0x035D, category='mn', description='COMBINING DOUBLE BREVE' },
	[0x035E] = { unicodeslot=0x035E, category='mn', description='COMBINING DOUBLE MACRON' },
	[0x035F] = { unicodeslot=0x035F, category='mn', description='COMBINING DOUBLE MACRON BELOW' },
	[0x0360] = { unicodeslot=0x0360, category='mn', description='COMBINING DOUBLE TILDE' },
	[0x0361] = { unicodeslot=0x0361, category='mn', description='COMBINING DOUBLE INVERTED BREVE' },
	[0x0362] = { unicodeslot=0x0362, category='mn', description='COMBINING DOUBLE RIGHTWARDS ARROW BELOW' },
	[0x0363] = { unicodeslot=0x0363, category='mn', description='COMBINING LATIN SMALL LETTER A' },
	[0x0364] = { unicodeslot=0x0364, category='mn', description='COMBINING LATIN SMALL LETTER E' },
	[0x0365] = { unicodeslot=0x0365, category='mn', description='COMBINING LATIN SMALL LETTER I' },
	[0x0366] = { unicodeslot=0x0366, category='mn', description='COMBINING LATIN SMALL LETTER O' },
	[0x0367] = { unicodeslot=0x0367, category='mn', description='COMBINING LATIN SMALL LETTER U' },
	[0x0368] = { unicodeslot=0x0368, category='mn', description='COMBINING LATIN SMALL LETTER C' },
	[0x0369] = { unicodeslot=0x0369, category='mn', description='COMBINING LATIN SMALL LETTER D' },
	[0x036A] = { unicodeslot=0x036A, category='mn', description='COMBINING LATIN SMALL LETTER H' },
	[0x036B] = { unicodeslot=0x036B, category='mn', description='COMBINING LATIN SMALL LETTER M' },
	[0x036C] = { unicodeslot=0x036C, category='mn', description='COMBINING LATIN SMALL LETTER R' },
	[0x036D] = { unicodeslot=0x036D, category='mn', description='COMBINING LATIN SMALL LETTER T' },
	[0x036E] = { unicodeslot=0x036E, category='mn', description='COMBINING LATIN SMALL LETTER V' },
	[0x036F] = { unicodeslot=0x036F, category='mn', description='COMBINING LATIN SMALL LETTER X' },
	[0x0374] = { unicodeslot=0x0374, category='sk', description='GREEK NUMERAL SIGN', specials={'char',0x02B9} },
	[0x0375] = { unicodeslot=0x0375, category='sk', description='GREEK LOWER NUMERAL SIGN' },
	[0x037A] = { unicodeslot=0x037A, category='lm', description='GREEK YPOGEGRAMMENI', specials={'compat',0x0020,0x0345} },
	[0x037B] = { unicodeslot=0x037B, category='ll', description='GREEK SMALL REVERSED LUNATE SIGMA SYMBOL', uccode=0x03FD },
	[0x037C] = { unicodeslot=0x037C, category='ll', description='GREEK SMALL DOTTED LUNATE SIGMA SYMBOL', uccode=0x03FE },
	[0x037D] = { unicodeslot=0x037D, category='ll', description='GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL', uccode=0x03FF },
	[0x037E] = { unicodeslot=0x037E, category='po', description='GREEK QUESTION MARK', specials={'char',0x003B} },
	[0x0384] = { unicodeslot=0x0384, category='sk', adobename='tonos', contextname='greektonos', description='GREEK TONOS', specials={'compat',0x0020,0x0301} },
	[0x0385] = { unicodeslot=0x0385, category='sk', adobename='dieresistonos', contextname='greekdialytikatonos', description='GREEK DIALYTIKA TONOS', specials={'char',0x00A8,0x0301} },
	[0x0386] = { unicodeslot=0x0386, category='lu', adobename='Alphatonos', contextname='greekAlphatonos', description='GREEK CAPITAL LETTER ALPHA WITH TONOS', shcode=0x0391, lccode=0x03AC, specials={'char',0x0391,0x0301} },
	[0x0387] = { unicodeslot=0x0387, category='po', adobename='anoteleia', description='GREEK ANO TELEIA', specials={'char',0x00B7} },
	[0x0388] = { unicodeslot=0x0388, category='lu', adobename='Epsilontonos', contextname='greekEpsilontonos', description='GREEK CAPITAL LETTER EPSILON WITH TONOS', shcode=0x0395, lccode=0x03AD, specials={'char',0x0395,0x0301} },
	[0x0389] = { unicodeslot=0x0389, category='lu', adobename='Etatonos', contextname='greekEtatonos', description='GREEK CAPITAL LETTER ETA WITH TONOS', shcode=0x0397, lccode=0x03AE, specials={'char',0x0397,0x0301} },
	[0x038A] = { unicodeslot=0x038A, category='lu', adobename='Iotatonos', contextname='greekIotatonos', description='GREEK CAPITAL LETTER IOTA WITH TONOS', shcode=0x0399, lccode=0x03AF, specials={'char',0x0399,0x0301} },
	[0x038C] = { unicodeslot=0x038C, category='lu', adobename='Omicrontonos', contextname='greekOmicrontonos', description='GREEK CAPITAL LETTER OMICRON WITH TONOS', shcode=0x039F, lccode=0x03CC, specials={'char',0x039F,0x0301} },
	[0x038E] = { unicodeslot=0x038E, category='lu', adobename='Upsilontonos', contextname='greekUpsilontonos', description='GREEK CAPITAL LETTER UPSILON WITH TONOS', shcode=0x03A5, lccode=0x03CD, specials={'char',0x03A5,0x0301} },
	[0x038F] = { unicodeslot=0x038F, category='lu', adobename='Omegatonos', contextname='greekOmegatonos', description='GREEK CAPITAL LETTER OMEGA WITH TONOS', shcode=0x03A9, lccode=0x03CE, specials={'char',0x03A9,0x0301} },
	[0x0390] = { unicodeslot=0x0390, category='ll', adobename='iotadieresistonos', contextname='greekiotadialytikatonos', description='GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS', shcode=0x03B9, specials={'char',0x03CA,0x0301} },
	[0x0391] = { unicodeslot=0x0391, category='lu', adobename='Alpha', contextname='greekAlpha', description='GREEK CAPITAL LETTER ALPHA', lccode=0x03B1 },
	[0x0392] = { unicodeslot=0x0392, category='lu', adobename='Beta', contextname='greekBeta', description='GREEK CAPITAL LETTER BETA', lccode=0x03B2 },
	[0x0393] = { unicodeslot=0x0393, category='lu', adobename='Gamma', contextname='greekGamma', description='GREEK CAPITAL LETTER GAMMA', lccode=0x03B3 },
	[0x0394] = { unicodeslot=0x0394, category='lu', contextname='greekDelta', description='GREEK CAPITAL LETTER DELTA', lccode=0x03B4 },
	[0x0395] = { unicodeslot=0x0395, category='lu', adobename='Epsilon', contextname='greekEpsilon', description='GREEK CAPITAL LETTER EPSILON', lccode=0x03B5 },
	[0x0396] = { unicodeslot=0x0396, category='lu', adobename='Zeta', contextname='greekZeta', description='GREEK CAPITAL LETTER ZETA', lccode=0x03B6 },
	[0x0397] = { unicodeslot=0x0397, category='lu', adobename='Eta', contextname='greekEta', description='GREEK CAPITAL LETTER ETA', lccode=0x03B7 },
	[0x0398] = { unicodeslot=0x0398, category='lu', adobename='Theta', contextname='greekTheta', description='GREEK CAPITAL LETTER THETA', lccode=0x03B8 },
	[0x0399] = { unicodeslot=0x0399, category='lu', adobename='Iota', contextname='greekIota', description='GREEK CAPITAL LETTER IOTA', lccode=0x03B9 },
	[0x039A] = { unicodeslot=0x039A, category='lu', adobename='Kappa', contextname='greekKappa', description='GREEK CAPITAL LETTER KAPPA', lccode=0x03BA },
	[0x039B] = { unicodeslot=0x039B, category='lu', adobename='Lambda', contextname='greekLambda', description='GREEK CAPITAL LETTER LAMDA', lccode=0x03BB },
	[0x039C] = { unicodeslot=0x039C, category='lu', adobename='Mu', contextname='greekMu', description='GREEK CAPITAL LETTER MU', lccode=0x03BC },
	[0x039D] = { unicodeslot=0x039D, category='lu', adobename='Nu', contextname='greekNu', description='GREEK CAPITAL LETTER NU', lccode=0x03BD },
	[0x039E] = { unicodeslot=0x039E, category='lu', adobename='Xi', contextname='greekXi', description='GREEK CAPITAL LETTER XI', lccode=0x03BE },
	[0x039F] = { unicodeslot=0x039F, category='lu', adobename='Omicron', contextname='greekOmicron', description='GREEK CAPITAL LETTER OMICRON', lccode=0x03BF },
	[0x03A0] = { unicodeslot=0x03A0, category='lu', adobename='Pi', contextname='greekPi', description='GREEK CAPITAL LETTER PI', lccode=0x03C0 },
	[0x03A1] = { unicodeslot=0x03A1, category='lu', adobename='Rho', contextname='greekRho', description='GREEK CAPITAL LETTER RHO', lccode=0x03C1 },
	[0x03A3] = { unicodeslot=0x03A3, category='lu', adobename='Sigma', contextname='greekSigma', description='GREEK CAPITAL LETTER SIGMA', lccode=0x03C3 },
	[0x03A4] = { unicodeslot=0x03A4, category='lu', adobename='Tau', contextname='greekTau', description='GREEK CAPITAL LETTER TAU', lccode=0x03C4 },
	[0x03A5] = { unicodeslot=0x03A5, category='lu', adobename='Upsilon', contextname='greekUpsilon', description='GREEK CAPITAL LETTER UPSILON', lccode=0x03C5 },
	[0x03A6] = { unicodeslot=0x03A6, category='lu', adobename='Phi', contextname='greekPhi', description='GREEK CAPITAL LETTER PHI', lccode=0x03C6 },
	[0x03A7] = { unicodeslot=0x03A7, category='lu', adobename='Chi', contextname='greekChi', description='GREEK CAPITAL LETTER CHI', lccode=0x03C7 },
	[0x03A8] = { unicodeslot=0x03A8, category='lu', adobename='Psi', contextname='greekPsi', description='GREEK CAPITAL LETTER PSI', lccode=0x03C8 },
	[0x03A9] = { unicodeslot=0x03A9, category='lu', contextname='greekOmega', description='GREEK CAPITAL LETTER OMEGA', lccode=0x03C9 },
	[0x03AA] = { unicodeslot=0x03AA, category='lu', adobename='Iotadieresis', contextname='greekIotadialytika', description='GREEK CAPITAL LETTER IOTA WITH DIALYTIKA', shcode=0x0399, lccode=0x03CA, specials={'char',0x0399,0x0308} },
	[0x03AB] = { unicodeslot=0x03AB, category='lu', adobename='Upsilondieresis', contextname='greekUpsilondialytika', description='GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA', shcode=0x03A5, lccode=0x03CB, specials={'char',0x03A5,0x0308} },
	[0x03AC] = { unicodeslot=0x03AC, category='ll', adobename='alphatonos', contextname='greekalphatonos', description='GREEK SMALL LETTER ALPHA WITH TONOS', shcode=0x03B1, uccode=0x0386, specials={'char',0x03B1,0x0301} },
	[0x03AD] = { unicodeslot=0x03AD, category='ll', adobename='epsilontonos', contextname='greekepsilontonos', description='GREEK SMALL LETTER EPSILON WITH TONOS', shcode=0x03B5, uccode=0x0388, specials={'char',0x03B5,0x0301} },
	[0x03AE] = { unicodeslot=0x03AE, category='ll', adobename='etatonos', contextname='greeketatonos', description='GREEK SMALL LETTER ETA WITH TONOS', shcode=0x03B7, uccode=0x0389, specials={'char',0x03B7,0x0301} },
	[0x03AF] = { unicodeslot=0x03AF, category='ll', adobename='iotatonos', contextname='greekiotatonos', description='GREEK SMALL LETTER IOTA WITH TONOS', shcode=0x03B9, uccode=0x038A, specials={'char',0x03B9,0x0301} },
	[0x03B0] = { unicodeslot=0x03B0, category='ll', adobename='upsilondieresistonos', contextname='greekupsilondialytikatonos', description='GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS', shcode=0x03C5, specials={'char',0x03CB,0x0301} },
	[0x03B1] = { unicodeslot=0x03B1, category='ll', adobename='alpha', contextname='greekalpha', description='GREEK SMALL LETTER ALPHA', uccode=0x0391 },
	[0x03B2] = { unicodeslot=0x03B2, category='ll', adobename='beta', contextname='greekbeta', description='GREEK SMALL LETTER BETA', uccode=0x0392 },
	[0x03B3] = { unicodeslot=0x03B3, category='ll', adobename='gamma', contextname='greekgamma', description='GREEK SMALL LETTER GAMMA', uccode=0x0393 },
	[0x03B4] = { unicodeslot=0x03B4, category='ll', adobename='delta', contextname='greekdelta', description='GREEK SMALL LETTER DELTA', uccode=0x0394 },
	[0x03B5] = { unicodeslot=0x03B5, category='ll', adobename='epsilon', contextname='greekepsilon', description='GREEK SMALL LETTER EPSILON', uccode=0x0395 },
	[0x03B6] = { unicodeslot=0x03B6, category='ll', adobename='zeta', contextname='greekzeta', description='GREEK SMALL LETTER ZETA', uccode=0x0396 },
	[0x03B7] = { unicodeslot=0x03B7, category='ll', adobename='eta', contextname='greeketa', description='GREEK SMALL LETTER ETA', uccode=0x0397 },
	[0x03B8] = { unicodeslot=0x03B8, category='ll', adobename='theta', contextname='greektheta', description='GREEK SMALL LETTER THETA', uccode=0x0398 },
	[0x03B9] = { unicodeslot=0x03B9, category='ll', adobename='iota', contextname='greekiota', description='GREEK SMALL LETTER IOTA', uccode=0x0399 },
	[0x03BA] = { unicodeslot=0x03BA, category='ll', adobename='kappa', contextname='greekkappa', description='GREEK SMALL LETTER KAPPA', uccode=0x039A },
	[0x03BB] = { unicodeslot=0x03BB, category='ll', adobename='lambda', contextname='greeklambda', description='GREEK SMALL LETTER LAMDA', uccode=0x039B },
	[0x03BC] = { unicodeslot=0x03BC, category='ll', contextname='greekmu', description='GREEK SMALL LETTER MU', uccode=0x039C },
	[0x03BD] = { unicodeslot=0x03BD, category='ll', adobename='nu', contextname='greeknu', description='GREEK SMALL LETTER NU', uccode=0x039D },
	[0x03BE] = { unicodeslot=0x03BE, category='ll', adobename='xi', contextname='greekxi', description='GREEK SMALL LETTER XI', uccode=0x039E },
	[0x03BF] = { unicodeslot=0x03BF, category='ll', adobename='omicron', contextname='greekomicron', description='GREEK SMALL LETTER OMICRON', uccode=0x039F },
	[0x03C0] = { unicodeslot=0x03C0, category='ll', adobename='pi', contextname='greekpi', description='GREEK SMALL LETTER PI', uccode=0x03A0 },
	[0x03C1] = { unicodeslot=0x03C1, category='ll', adobename='rho', contextname='greekrho', description='GREEK SMALL LETTER RHO', uccode=0x03A1 },
	[0x03C2] = { unicodeslot=0x03C2, category='ll', adobename='sigma1', contextname='greekfinalsigma', description='GREEK SMALL LETTER FINAL SIGMA', uccode=0x03A3 },
	[0x03C3] = { unicodeslot=0x03C3, category='ll', adobename='sigma', contextname='greeksigma', description='GREEK SMALL LETTER SIGMA', uccode=0x03A3 },
	[0x03C4] = { unicodeslot=0x03C4, category='ll', adobename='tau', contextname='greektau', description='GREEK SMALL LETTER TAU', uccode=0x03A4 },
	[0x03C5] = { unicodeslot=0x03C5, category='ll', adobename='upsilon', contextname='greekupsilon', description='GREEK SMALL LETTER UPSILON', uccode=0x03A5 },
	[0x03C6] = { unicodeslot=0x03C6, category='ll', adobename='phi', contextname='greekphi', description='GREEK SMALL LETTER PHI', uccode=0x03A6 },
	[0x03C7] = { unicodeslot=0x03C7, category='ll', adobename='chi', contextname='greekchi', description='GREEK SMALL LETTER CHI', uccode=0x03A7 },
	[0x03C8] = { unicodeslot=0x03C8, category='ll', adobename='psi', contextname='greekpsi', description='GREEK SMALL LETTER PSI', uccode=0x03A8 },
	[0x03C9] = { unicodeslot=0x03C9, category='ll', adobename='omega', contextname='greekomega', description='GREEK SMALL LETTER OMEGA', uccode=0x03A9 },
	[0x03CA] = { unicodeslot=0x03CA, category='ll', adobename='iotadieresis', contextname='greekiotadialytika', description='GREEK SMALL LETTER IOTA WITH DIALYTIKA', shcode=0x03B9, uccode=0x03AA, specials={'char',0x03B9,0x0308} },
	[0x03CB] = { unicodeslot=0x03CB, category='ll', adobename='upsilondieresis', contextname='greekupsilondiaeresis', description='GREEK SMALL LETTER UPSILON WITH DIALYTIKA', shcode=0x03C5, uccode=0x03AB, specials={'char',0x03C5,0x0308} },
	[0x03CC] = { unicodeslot=0x03CC, category='ll', adobename='omicrontonos', contextname='greekomicrontonos', description='GREEK SMALL LETTER OMICRON WITH TONOS', shcode=0x03BF, uccode=0x038C, specials={'char',0x03BF,0x0301} },
	[0x03CD] = { unicodeslot=0x03CD, category='ll', adobename='upsilontonos', contextname='greekupsilontonos', description='GREEK SMALL LETTER UPSILON WITH TONOS', shcode=0x03C5, uccode=0x038E, specials={'char',0x03C5,0x0301} },
	[0x03CE] = { unicodeslot=0x03CE, category='ll', adobename='omegatonos', contextname='greekomegatonos', description='GREEK SMALL LETTER OMEGA WITH TONOS', shcode=0x03C9, uccode=0x038F, specials={'char',0x03C9,0x0301} },
	[0x03D0] = { unicodeslot=0x03D0, category='ll', description='GREEK BETA SYMBOL', uccode=0x0392, specials={'compat',0x03B2} },
	[0x03D1] = { unicodeslot=0x03D1, category='ll', adobename='theta1', contextname='greekthetaalt', description='GREEK THETA SYMBOL', uccode=0x0398, specials={'compat',0x03B8} },
	[0x03D2] = { unicodeslot=0x03D2, category='lu', adobename='Upsilon1', description='GREEK UPSILON WITH HOOK SYMBOL', specials={'compat',0x03A5} },
	[0x03D3] = { unicodeslot=0x03D3, category='lu', description='GREEK UPSILON WITH ACUTE AND HOOK SYMBOL', specials={'char',0x03D2,0x0301} },
	[0x03D4] = { unicodeslot=0x03D4, category='lu', description='GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL', specials={'char',0x03D2,0x0308} },
	[0x03D5] = { unicodeslot=0x03D5, category='ll', adobename='phi1', contextname='greekphialt', description='GREEK PHI SYMBOL', uccode=0x03A6, specials={'compat',0x03C6} },
	[0x03D6] = { unicodeslot=0x03D6, category='ll', adobename='omega1', contextname='greekpialt', description='GREEK PI SYMBOL', uccode=0x03A0, specials={'compat',0x03C0} },
	[0x03D7] = { unicodeslot=0x03D7, category='ll', description='GREEK KAI SYMBOL' },
	[0x03D8] = { unicodeslot=0x03D8, category='lu', description='GREEK LETTER ARCHAIC KOPPA', lccode=0x03D9 },
	[0x03D9] = { unicodeslot=0x03D9, category='ll', contextname='greekkoppa', description='GREEK SMALL LETTER ARCHAIC KOPPA', uccode=0x03D8 },
	[0x03DA] = { unicodeslot=0x03DA, category='lu', description='GREEK LETTER STIGMA', lccode=0x03DB },
	[0x03DB] = { unicodeslot=0x03DB, category='ll', contextname='greekstigma', description='GREEK SMALL LETTER STIGMA', uccode=0x03DA },
	[0x03DC] = { unicodeslot=0x03DC, category='lu', description='GREEK LETTER DIGAMMA', lccode=0x03DD },
	[0x03DD] = { unicodeslot=0x03DD, category='ll', contextname='greekdigamma', description='GREEK SMALL LETTER DIGAMMA', uccode=0x03DC },
	[0x03DE] = { unicodeslot=0x03DE, category='lu', description='GREEK LETTER KOPPA', lccode=0x03DF },
	[0x03DF] = { unicodeslot=0x03DF, category='ll', contextname='greeknumkoppa', description='GREEK SMALL LETTER KOPPA', uccode=0x03DE },
	[0x03E0] = { unicodeslot=0x03E0, category='lu', description='GREEK LETTER SAMPI', lccode=0x03E1 },
	[0x03E1] = { unicodeslot=0x03E1, category='ll', contextname='greeksampi', description='GREEK SMALL LETTER SAMPI', uccode=0x03E0 },
	[0x03E2] = { unicodeslot=0x03E2, category='lu', description='COPTIC CAPITAL LETTER SHEI', lccode=0x03E3 },
	[0x03E3] = { unicodeslot=0x03E3, category='ll', description='COPTIC SMALL LETTER SHEI', uccode=0x03E2 },
	[0x03E4] = { unicodeslot=0x03E4, category='lu', description='COPTIC CAPITAL LETTER FEI', lccode=0x03E5 },
	[0x03E5] = { unicodeslot=0x03E5, category='ll', description='COPTIC SMALL LETTER FEI', uccode=0x03E4 },
	[0x03E6] = { unicodeslot=0x03E6, category='lu', description='COPTIC CAPITAL LETTER KHEI', lccode=0x03E7 },
	[0x03E7] = { unicodeslot=0x03E7, category='ll', description='COPTIC SMALL LETTER KHEI', uccode=0x03E6 },
	[0x03E8] = { unicodeslot=0x03E8, category='lu', description='COPTIC CAPITAL LETTER HORI', lccode=0x03E9 },
	[0x03E9] = { unicodeslot=0x03E9, category='ll', description='COPTIC SMALL LETTER HORI', uccode=0x03E8 },
	[0x03EA] = { unicodeslot=0x03EA, category='lu', description='COPTIC CAPITAL LETTER GANGIA', lccode=0x03EB },
	[0x03EB] = { unicodeslot=0x03EB, category='ll', description='COPTIC SMALL LETTER GANGIA', uccode=0x03EA },
	[0x03EC] = { unicodeslot=0x03EC, category='lu', description='COPTIC CAPITAL LETTER SHIMA', lccode=0x03ED },
	[0x03ED] = { unicodeslot=0x03ED, category='ll', description='COPTIC SMALL LETTER SHIMA', uccode=0x03EC },
	[0x03EE] = { unicodeslot=0x03EE, category='lu', description='COPTIC CAPITAL LETTER DEI', lccode=0x03EF },
	[0x03EF] = { unicodeslot=0x03EF, category='ll', description='COPTIC SMALL LETTER DEI', uccode=0x03EE },
	[0x03F0] = { unicodeslot=0x03F0, category='ll', description='GREEK KAPPA SYMBOL', uccode=0x039A, specials={'compat',0x03BA} },
	[0x03F1] = { unicodeslot=0x03F1, category='ll', contextname='greekrhoalt', description='GREEK RHO SYMBOL', uccode=0x03A1, specials={'compat',0x03C1} },
	[0x03F2] = { unicodeslot=0x03F2, category='ll', contextname='greeksigmalunate', description='GREEK LUNATE SIGMA SYMBOL', uccode=0x03F9, specials={'compat',0x03C2} },
	[0x03F3] = { unicodeslot=0x03F3, category='ll', description='GREEK LETTER YOT' },
	[0x03F4] = { unicodeslot=0x03F4, category='lu', description='GREEK CAPITAL THETA SYMBOL', lccode=0x03B8, specials={'compat',0x0398} },
	[0x03F5] = { unicodeslot=0x03F5, category='ll', contextname='greekepsilonalt', description='GREEK LUNATE EPSILON SYMBOL', uccode=0x0395, specials={'compat',0x03B5} },
	[0x03F6] = { unicodeslot=0x03F6, category='sm', description='GREEK REVERSED LUNATE EPSILON SYMBOL' },
	[0x03F7] = { unicodeslot=0x03F7, category='lu', description='GREEK CAPITAL LETTER SHO', lccode=0x03F8 },
	[0x03F8] = { unicodeslot=0x03F8, category='ll', description='GREEK SMALL LETTER SHO', uccode=0x03F7 },
	[0x03F9] = { unicodeslot=0x03F9, category='lu', contextname='greekSigmalunate', description='GREEK CAPITAL LUNATE SIGMA SYMBOL', lccode=0x03F2, specials={'compat',0x03A3} },
	[0x03FA] = { unicodeslot=0x03FA, category='lu', description='GREEK CAPITAL LETTER SAN', lccode=0x03FB },
	[0x03FB] = { unicodeslot=0x03FB, category='ll', description='GREEK SMALL LETTER SAN', uccode=0x03FA },
	[0x03FC] = { unicodeslot=0x03FC, category='ll', description='GREEK RHO WITH STROKE SYMBOL' },
	[0x03FD] = { unicodeslot=0x03FD, category='lu', description='GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL', lccode=0x037B },
	[0x03FE] = { unicodeslot=0x03FE, category='lu', description='GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL', lccode=0x037C },
	[0x03FF] = { unicodeslot=0x03FF, category='lu', description='GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL', lccode=0x037D },
	[0x0400] = { unicodeslot=0x0400, category='lu', contextname='cyrillicEgrave', description='CYRILLIC CAPITAL LETTER IE WITH GRAVE', shcode=0x0415, lccode=0x0450, specials={'char',0x0415,0x0300} },
	[0x0401] = { unicodeslot=0x0401, category='lu', adobename='afii10023', contextname='cyrillicYO', description='CYRILLIC CAPITAL LETTER IO', lccode=0x0451, specials={'char',0x0415,0x0308} },
	[0x0402] = { unicodeslot=0x0402, category='lu', adobename='afii10051', contextname='cyrillicDJE', description='CYRILLIC CAPITAL LETTER DJE', lccode=0x0452 },
	[0x0403] = { unicodeslot=0x0403, category='lu', adobename='afii10052', contextname='cyrillicGJE', description='CYRILLIC CAPITAL LETTER GJE', lccode=0x0453, specials={'char',0x0413,0x0301} },
	[0x0404] = { unicodeslot=0x0404, category='lu', adobename='afii10053', contextname='cyrillicIE', description='CYRILLIC CAPITAL LETTER UKRAINIAN IE', lccode=0x0454 },
	[0x0405] = { unicodeslot=0x0405, category='lu', adobename='afii10054', contextname='cyrillicDZE', description='CYRILLIC CAPITAL LETTER DZE', lccode=0x0455 },
	[0x0406] = { unicodeslot=0x0406, category='lu', adobename='afii10055', contextname='cyrillicII', description='CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I', lccode=0x0456 },
	[0x0407] = { unicodeslot=0x0407, category='lu', adobename='afii10056', contextname='cyrillicYI', description='CYRILLIC CAPITAL LETTER YI', lccode=0x0457, specials={'char',0x0406,0x0308} },
	[0x0408] = { unicodeslot=0x0408, category='lu', adobename='afii10057', contextname='cyrillicJE', description='CYRILLIC CAPITAL LETTER JE', lccode=0x0458 },
	[0x0409] = { unicodeslot=0x0409, category='lu', adobename='afii10058', contextname='cyrillicLJE', description='CYRILLIC CAPITAL LETTER LJE', lccode=0x0459 },
	[0x040A] = { unicodeslot=0x040A, category='lu', adobename='afii10059', contextname='cyrillicNJE', description='CYRILLIC CAPITAL LETTER NJE', lccode=0x045A },
	[0x040B] = { unicodeslot=0x040B, category='lu', adobename='afii10060', contextname='cyrillicTSHE', description='CYRILLIC CAPITAL LETTER TSHE', lccode=0x045B },
	[0x040C] = { unicodeslot=0x040C, category='lu', adobename='afii10061', contextname='cyrillicKJE', description='CYRILLIC CAPITAL LETTER KJE', lccode=0x045C, specials={'char',0x041A,0x0301} },
	[0x040D] = { unicodeslot=0x040D, category='lu', contextname='cyrillicIgrave', description='CYRILLIC CAPITAL LETTER I WITH GRAVE', shcode=0x0418, lccode=0x045D, specials={'char',0x0418,0x0300} },
	[0x040E] = { unicodeslot=0x040E, category='lu', adobename='afii10062', contextname='cyrillicUSHRT', description='CYRILLIC CAPITAL LETTER SHORT U', lccode=0x045E, specials={'char',0x0423,0x0306} },
	[0x040F] = { unicodeslot=0x040F, category='lu', adobename='afii10145', contextname='cyrillicDZHE', description='CYRILLIC CAPITAL LETTER DZHE', lccode=0x045F },
	[0x0410] = { unicodeslot=0x0410, category='lu', adobename='afii10017', contextname='cyrillicA', description='CYRILLIC CAPITAL LETTER A', lccode=0x0430 },
	[0x0411] = { unicodeslot=0x0411, category='lu', adobename='afii10018', contextname='cyrillicB', description='CYRILLIC CAPITAL LETTER BE', lccode=0x0431 },
	[0x0412] = { unicodeslot=0x0412, category='lu', adobename='afii10019', contextname='cyrillicV', description='CYRILLIC CAPITAL LETTER VE', lccode=0x0432 },
	[0x0413] = { unicodeslot=0x0413, category='lu', adobename='afii10020', contextname='cyrillicG', description='CYRILLIC CAPITAL LETTER GHE', lccode=0x0433 },
	[0x0414] = { unicodeslot=0x0414, category='lu', adobename='afii10021', contextname='cyrillicD', description='CYRILLIC CAPITAL LETTER DE', lccode=0x0434 },
	[0x0415] = { unicodeslot=0x0415, category='lu', adobename='afii10022', contextname='cyrillicE', description='CYRILLIC CAPITAL LETTER IE', lccode=0x0435 },
	[0x0416] = { unicodeslot=0x0416, category='lu', adobename='afii10024', contextname='cyrillicZH', description='CYRILLIC CAPITAL LETTER ZHE', lccode=0x0436 },
	[0x0417] = { unicodeslot=0x0417, category='lu', adobename='afii10025', contextname='cyrillicZ', description='CYRILLIC CAPITAL LETTER ZE', lccode=0x0437 },
	[0x0418] = { unicodeslot=0x0418, category='lu', adobename='afii10026', contextname='cyrillicI', description='CYRILLIC CAPITAL LETTER I', lccode=0x0438 },
	[0x0419] = { unicodeslot=0x0419, category='lu', adobename='afii10027', contextname='cyrillicISHRT', description='CYRILLIC CAPITAL LETTER SHORT I', lccode=0x0439, specials={'char',0x0418,0x0306} },
	[0x041A] = { unicodeslot=0x041A, category='lu', adobename='afii10028', contextname='cyrillicK', description='CYRILLIC CAPITAL LETTER KA', lccode=0x043A },
	[0x041B] = { unicodeslot=0x041B, category='lu', adobename='afii10029', contextname='cyrillicL', description='CYRILLIC CAPITAL LETTER EL', lccode=0x043B },
	[0x041C] = { unicodeslot=0x041C, category='lu', adobename='afii10030', contextname='cyrillicM', description='CYRILLIC CAPITAL LETTER EM', lccode=0x043C },
	[0x041D] = { unicodeslot=0x041D, category='lu', adobename='afii10031', contextname='cyrillicN', description='CYRILLIC CAPITAL LETTER EN', lccode=0x043D },
	[0x041E] = { unicodeslot=0x041E, category='lu', adobename='afii10032', contextname='cyrillicO', description='CYRILLIC CAPITAL LETTER O', lccode=0x043E },
	[0x041F] = { unicodeslot=0x041F, category='lu', adobename='afii10033', contextname='cyrillicP', description='CYRILLIC CAPITAL LETTER PE', lccode=0x043F },
	[0x0420] = { unicodeslot=0x0420, category='lu', adobename='afii10034', contextname='cyrillicR', description='CYRILLIC CAPITAL LETTER ER', lccode=0x0440 },
	[0x0421] = { unicodeslot=0x0421, category='lu', adobename='afii10035', contextname='cyrillicS', description='CYRILLIC CAPITAL LETTER ES', lccode=0x0441 },
	[0x0422] = { unicodeslot=0x0422, category='lu', adobename='afii10036', contextname='cyrillicT', description='CYRILLIC CAPITAL LETTER TE', lccode=0x0442 },
	[0x0423] = { unicodeslot=0x0423, category='lu', adobename='afii10037', contextname='cyrillicU', description='CYRILLIC CAPITAL LETTER U', lccode=0x0443 },
	[0x0424] = { unicodeslot=0x0424, category='lu', adobename='afii10038', contextname='cyrillicF', description='CYRILLIC CAPITAL LETTER EF', lccode=0x0444 },
	[0x0425] = { unicodeslot=0x0425, category='lu', adobename='afii10039', contextname='cyrillicH', description='CYRILLIC CAPITAL LETTER HA', lccode=0x0445 },
	[0x0426] = { unicodeslot=0x0426, category='lu', adobename='afii10040', contextname='cyrillicC', description='CYRILLIC CAPITAL LETTER TSE', lccode=0x0446 },
	[0x0427] = { unicodeslot=0x0427, category='lu', adobename='afii10041', contextname='cyrillicCH', description='CYRILLIC CAPITAL LETTER CHE', lccode=0x0447 },
	[0x0428] = { unicodeslot=0x0428, category='lu', adobename='afii10042', contextname='cyrillicSH', description='CYRILLIC CAPITAL LETTER SHA', lccode=0x0448 },
	[0x0429] = { unicodeslot=0x0429, category='lu', adobename='afii10043', contextname='cyrillicSHCH', description='CYRILLIC CAPITAL LETTER SHCHA', lccode=0x0449 },
	[0x042A] = { unicodeslot=0x042A, category='lu', adobename='afii10044', contextname='cyrillicHRDSN', description='CYRILLIC CAPITAL LETTER HARD SIGN', lccode=0x044A },
	[0x042B] = { unicodeslot=0x042B, category='lu', adobename='afii10045', contextname='cyrillicERY', description='CYRILLIC CAPITAL LETTER YERU', lccode=0x044B },
	[0x042C] = { unicodeslot=0x042C, category='lu', adobename='afii10046', contextname='cyrillicSFTSN', description='CYRILLIC CAPITAL LETTER SOFT SIGN', lccode=0x044C },
	[0x042D] = { unicodeslot=0x042D, category='lu', adobename='afii10047', contextname='cyrillicEREV', description='CYRILLIC CAPITAL LETTER E', lccode=0x044D },
	[0x042E] = { unicodeslot=0x042E, category='lu', adobename='afii10048', contextname='cyrillicYU', description='CYRILLIC CAPITAL LETTER YU', lccode=0x044E },
	[0x042F] = { unicodeslot=0x042F, category='lu', adobename='afii10049', contextname='cyrillicYA', description='CYRILLIC CAPITAL LETTER YA', lccode=0x044F },
	[0x0430] = { unicodeslot=0x0430, category='ll', adobename='afii10065', contextname='cyrillica', description='CYRILLIC SMALL LETTER A', uccode=0x0410 },
	[0x0431] = { unicodeslot=0x0431, category='ll', adobename='afii10066', contextname='cyrillicb', description='CYRILLIC SMALL LETTER BE', uccode=0x0411 },
	[0x0432] = { unicodeslot=0x0432, category='ll', adobename='afii10067', contextname='cyrillicv', description='CYRILLIC SMALL LETTER VE', uccode=0x0412 },
	[0x0433] = { unicodeslot=0x0433, category='ll', adobename='afii10068', contextname='cyrillicg', description='CYRILLIC SMALL LETTER GHE', uccode=0x0413 },
	[0x0434] = { unicodeslot=0x0434, category='ll', adobename='afii10069', contextname='cyrillicd', description='CYRILLIC SMALL LETTER DE', uccode=0x0414 },
	[0x0435] = { unicodeslot=0x0435, category='ll', adobename='afii10070', contextname='cyrillice', description='CYRILLIC SMALL LETTER IE', uccode=0x0415 },
	[0x0436] = { unicodeslot=0x0436, category='ll', adobename='afii10072', contextname='cyrilliczh', description='CYRILLIC SMALL LETTER ZHE', uccode=0x0416 },
	[0x0437] = { unicodeslot=0x0437, category='ll', adobename='afii10073', contextname='cyrillicz', description='CYRILLIC SMALL LETTER ZE', uccode=0x0417 },
	[0x0438] = { unicodeslot=0x0438, category='ll', adobename='afii10074', contextname='cyrillici', description='CYRILLIC SMALL LETTER I', uccode=0x0418 },
	[0x0439] = { unicodeslot=0x0439, category='ll', adobename='afii10075', contextname='cyrillicishrt', description='CYRILLIC SMALL LETTER SHORT I', uccode=0x0419, specials={'char',0x0438,0x0306} },
	[0x043A] = { unicodeslot=0x043A, category='ll', adobename='afii10076', contextname='cyrillick', description='CYRILLIC SMALL LETTER KA', uccode=0x041A },
	[0x043B] = { unicodeslot=0x043B, category='ll', adobename='afii10077', contextname='cyrillicl', description='CYRILLIC SMALL LETTER EL', uccode=0x041B },
	[0x043C] = { unicodeslot=0x043C, category='ll', adobename='afii10078', contextname='cyrillicm', description='CYRILLIC SMALL LETTER EM', uccode=0x041C },
	[0x043D] = { unicodeslot=0x043D, category='ll', adobename='afii10079', contextname='cyrillicn', description='CYRILLIC SMALL LETTER EN', uccode=0x041D },
	[0x043E] = { unicodeslot=0x043E, category='ll', adobename='afii10080', contextname='cyrillico', description='CYRILLIC SMALL LETTER O', uccode=0x041E },
	[0x043F] = { unicodeslot=0x043F, category='ll', adobename='afii10081', contextname='cyrillicp', description='CYRILLIC SMALL LETTER PE', uccode=0x041F },
	[0x0440] = { unicodeslot=0x0440, category='ll', adobename='afii10082', contextname='cyrillicr', description='CYRILLIC SMALL LETTER ER', uccode=0x0420 },
	[0x0441] = { unicodeslot=0x0441, category='ll', adobename='afii10083', contextname='cyrillics', description='CYRILLIC SMALL LETTER ES', uccode=0x0421 },
	[0x0442] = { unicodeslot=0x0442, category='ll', adobename='afii10084', contextname='cyrillict', description='CYRILLIC SMALL LETTER TE', uccode=0x0422 },
	[0x0443] = { unicodeslot=0x0443, category='ll', adobename='afii10085', contextname='cyrillicu', description='CYRILLIC SMALL LETTER U', uccode=0x0423 },
	[0x0444] = { unicodeslot=0x0444, category='ll', adobename='afii10086', contextname='cyrillicf', description='CYRILLIC SMALL LETTER EF', uccode=0x0424 },
	[0x0445] = { unicodeslot=0x0445, category='ll', adobename='afii10087', contextname='cyrillich', description='CYRILLIC SMALL LETTER HA', uccode=0x0425 },
	[0x0446] = { unicodeslot=0x0446, category='ll', adobename='afii10088', contextname='cyrillicc', description='CYRILLIC SMALL LETTER TSE', uccode=0x0426 },
	[0x0447] = { unicodeslot=0x0447, category='ll', adobename='afii10089', contextname='cyrillicch', description='CYRILLIC SMALL LETTER CHE', uccode=0x0427 },
	[0x0448] = { unicodeslot=0x0448, category='ll', adobename='afii10090', contextname='cyrillicsh', description='CYRILLIC SMALL LETTER SHA', uccode=0x0428 },
	[0x0449] = { unicodeslot=0x0449, category='ll', adobename='afii10091', contextname='cyrillicshch', description='CYRILLIC SMALL LETTER SHCHA', uccode=0x0429 },
	[0x044A] = { unicodeslot=0x044A, category='ll', adobename='afii10092', contextname='cyrillichrdsn', description='CYRILLIC SMALL LETTER HARD SIGN', uccode=0x042A },
	[0x044B] = { unicodeslot=0x044B, category='ll', adobename='afii10093', contextname='cyrillicery', description='CYRILLIC SMALL LETTER YERU', uccode=0x042B },
	[0x044C] = { unicodeslot=0x044C, category='ll', adobename='afii10094', contextname='cyrillicsftsn', description='CYRILLIC SMALL LETTER SOFT SIGN', uccode=0x042C },
	[0x044D] = { unicodeslot=0x044D, category='ll', adobename='afii10095', contextname='cyrillicerev', description='CYRILLIC SMALL LETTER E', uccode=0x042D },
	[0x044E] = { unicodeslot=0x044E, category='ll', adobename='afii10096', contextname='cyrillicyu', description='CYRILLIC SMALL LETTER YU', uccode=0x042E },
	[0x044F] = { unicodeslot=0x044F, category='ll', adobename='afii10097', contextname='cyrillicya', description='CYRILLIC SMALL LETTER YA', uccode=0x042F },
	[0x0450] = { unicodeslot=0x0450, category='ll', contextname='cyrillicegrave', description='CYRILLIC SMALL LETTER IE WITH GRAVE', shcode=0x0435, uccode=0x0400, specials={'char',0x0435,0x0300} },
	[0x0451] = { unicodeslot=0x0451, category='ll', adobename='afii10071', contextname='cyrillicyo', description='CYRILLIC SMALL LETTER IO', uccode=0x0401, specials={'char',0x0435,0x0308} },
	[0x0452] = { unicodeslot=0x0452, category='ll', adobename='afii10099', contextname='cyrillicdje', description='CYRILLIC SMALL LETTER DJE', uccode=0x0402 },
	[0x0453] = { unicodeslot=0x0453, category='ll', adobename='afii10100', contextname='cyrillicgje', description='CYRILLIC SMALL LETTER GJE', uccode=0x0403, specials={'char',0x0433,0x0301} },
	[0x0454] = { unicodeslot=0x0454, category='ll', adobename='afii10101', contextname='cyrillicie', description='CYRILLIC SMALL LETTER UKRAINIAN IE', uccode=0x0404 },
	[0x0455] = { unicodeslot=0x0455, category='ll', adobename='afii10102', contextname='cyrillicdze', description='CYRILLIC SMALL LETTER DZE', uccode=0x0405 },
	[0x0456] = { unicodeslot=0x0456, category='ll', adobename='afii10103', contextname='cyrillicii', description='CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I', uccode=0x0406 },
	[0x0457] = { unicodeslot=0x0457, category='ll', adobename='afii10104', contextname='cyrillicyi', description='CYRILLIC SMALL LETTER YI', uccode=0x0407, specials={'char',0x0456,0x0308} },
	[0x0458] = { unicodeslot=0x0458, category='ll', adobename='afii10105', contextname='cyrillicje', description='CYRILLIC SMALL LETTER JE', uccode=0x0408 },
	[0x0459] = { unicodeslot=0x0459, category='ll', adobename='afii10106', contextname='cyrilliclje', description='CYRILLIC SMALL LETTER LJE', uccode=0x0409 },
	[0x045A] = { unicodeslot=0x045A, category='ll', adobename='afii10107', contextname='cyrillicnje', description='CYRILLIC SMALL LETTER NJE', uccode=0x040A },
	[0x045B] = { unicodeslot=0x045B, category='ll', adobename='afii10108', contextname='cyrillictshe', description='CYRILLIC SMALL LETTER TSHE', uccode=0x040B },
	[0x045C] = { unicodeslot=0x045C, category='ll', adobename='afii10109', contextname='cyrillickje', description='CYRILLIC SMALL LETTER KJE', uccode=0x040C, specials={'char',0x043A,0x0301} },
	[0x045D] = { unicodeslot=0x045D, category='ll', contextname='cyrillicigrave', description='CYRILLIC SMALL LETTER I WITH GRAVE', shcode=0x0438, uccode=0x040D, specials={'char',0x0438,0x0300} },
	[0x045E] = { unicodeslot=0x045E, category='ll', adobename='afii10110', contextname='cyrillicushrt', description='CYRILLIC SMALL LETTER SHORT U', uccode=0x040E, specials={'char',0x0443,0x0306} },
	[0x045F] = { unicodeslot=0x045F, category='ll', adobename='afii10193', contextname='cyrillicdzhe', description='CYRILLIC SMALL LETTER DZHE', uccode=0x040F },
	[0x0460] = { unicodeslot=0x0460, category='lu', contextname='cyrillicOMEGA', description='CYRILLIC CAPITAL LETTER OMEGA', lccode=0x0461 },
	[0x0461] = { unicodeslot=0x0461, category='ll', contextname='cyrillicomega', description='CYRILLIC SMALL LETTER OMEGA', uccode=0x0460 },
	[0x0462] = { unicodeslot=0x0462, category='lu', adobename='afii10146', contextname='cyrillicYAT', description='CYRILLIC CAPITAL LETTER YAT', lccode=0x0463 },
	[0x0463] = { unicodeslot=0x0463, category='ll', adobename='afii10194', contextname='cyrillicyat', description='CYRILLIC SMALL LETTER YAT', uccode=0x0462 },
	[0x0464] = { unicodeslot=0x0464, category='lu', contextname='cyrillicEiotified', description='CYRILLIC CAPITAL LETTER IOTIFIED E', lccode=0x0465 },
	[0x0465] = { unicodeslot=0x0465, category='ll', contextname='cyrilliceiotified', description='CYRILLIC SMALL LETTER IOTIFIED E', uccode=0x0464 },
	[0x0466] = { unicodeslot=0x0466, category='lu', contextname='cyrillicLITTLEYUS', description='CYRILLIC CAPITAL LETTER LITTLE YUS', lccode=0x0467 },
	[0x0467] = { unicodeslot=0x0467, category='ll', contextname='cyrilliclittleyus', description='CYRILLIC SMALL LETTER LITTLE YUS', uccode=0x0466 },
	[0x0468] = { unicodeslot=0x0468, category='lu', contextname='cyrillicLITTLEYUSiotified', description='CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS', lccode=0x0469 },
	[0x0469] = { unicodeslot=0x0469, category='ll', contextname='cyrilliclittleyusiotified', description='CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS', uccode=0x0468 },
	[0x046A] = { unicodeslot=0x046A, category='lu', contextname='cyrillicBIGYUS', description='CYRILLIC CAPITAL LETTER BIG YUS', lccode=0x046B },
	[0x046B] = { unicodeslot=0x046B, category='ll', contextname='cyrillicbigyus', description='CYRILLIC SMALL LETTER BIG YUS', uccode=0x046A },
	[0x046C] = { unicodeslot=0x046C, category='lu', contextname='cyrillicBIGYUSiotified', description='CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS', lccode=0x046D },
	[0x046D] = { unicodeslot=0x046D, category='ll', contextname='cyrillicbigyusiotified', description='CYRILLIC SMALL LETTER IOTIFIED BIG YUS', uccode=0x046C },
	[0x046E] = { unicodeslot=0x046E, category='lu', contextname='cyrillicKSI', description='CYRILLIC CAPITAL LETTER KSI', lccode=0x046F },
	[0x046F] = { unicodeslot=0x046F, category='ll', contextname='cyrillicksi', description='CYRILLIC SMALL LETTER KSI', uccode=0x046E },
	[0x0470] = { unicodeslot=0x0470, category='lu', contextname='cyrillicPSI', description='CYRILLIC CAPITAL LETTER PSI', lccode=0x0471 },
	[0x0471] = { unicodeslot=0x0471, category='ll', contextname='cyrillicpsi', description='CYRILLIC SMALL LETTER PSI', uccode=0x0470 },
	[0x0472] = { unicodeslot=0x0472, category='lu', adobename='afii10147', contextname='cyrillicFITA', description='CYRILLIC CAPITAL LETTER FITA', lccode=0x0473 },
	[0x0473] = { unicodeslot=0x0473, category='ll', adobename='afii10195', contextname='cyrillicfita', description='CYRILLIC SMALL LETTER FITA', uccode=0x0472 },
	[0x0474] = { unicodeslot=0x0474, category='lu', adobename='afii10148', contextname='cyrillicIZHITSA', description='CYRILLIC CAPITAL LETTER IZHITSA', lccode=0x0475 },
	[0x0475] = { unicodeslot=0x0475, category='ll', adobename='afii10196', contextname='cyrillicizhitsa', description='CYRILLIC SMALL LETTER IZHITSA', uccode=0x0474 },
	[0x0476] = { unicodeslot=0x0476, category='lu', contextname='cyrillicIZHITSAdoublegrave', description='CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT', shcode=0x0474, lccode=0x0477, specials={'char',0x0474,0x030F} },
	[0x0477] = { unicodeslot=0x0477, category='ll', contextname='cyrillicizhitsadoublegrave', description='CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT', shcode=0x0475, uccode=0x0476, specials={'char',0x0475,0x030F} },
	[0x0478] = { unicodeslot=0x0478, category='lu', contextname='cyrillicUK', description='CYRILLIC CAPITAL LETTER UK', lccode=0x0479 },
	[0x0479] = { unicodeslot=0x0479, category='ll', contextname='cyrillicuk', description='CYRILLIC SMALL LETTER UK', uccode=0x0478 },
	[0x047A] = { unicodeslot=0x047A, category='lu', contextname='cyrillicOMEGAround', description='CYRILLIC CAPITAL LETTER ROUND OMEGA', lccode=0x047B },
	[0x047B] = { unicodeslot=0x047B, category='ll', contextname='cyrillicomegaround', description='CYRILLIC SMALL LETTER ROUND OMEGA', uccode=0x047A },
	[0x047C] = { unicodeslot=0x047C, category='lu', contextname='cyrillicOMEGAtitlo', description='CYRILLIC CAPITAL LETTER OMEGA WITH TITLO', shcode=0x0460, lccode=0x047D },
	[0x047D] = { unicodeslot=0x047D, category='ll', contextname='cyrillicomegatitlo', description='CYRILLIC SMALL LETTER OMEGA WITH TITLO', shcode=0x0461, uccode=0x047C },
	[0x047E] = { unicodeslot=0x047E, category='lu', contextname='cyrillicOT', description='CYRILLIC CAPITAL LETTER OT', lccode=0x047F },
	[0x047F] = { unicodeslot=0x047F, category='ll', contextname='cyrillicot', description='CYRILLIC SMALL LETTER OT', uccode=0x047E },
	[0x0480] = { unicodeslot=0x0480, category='lu', contextname='cyrillicKOPPA', description='CYRILLIC CAPITAL LETTER KOPPA', lccode=0x0481 },
	[0x0481] = { unicodeslot=0x0481, category='ll', contextname='cyrillickoppa', description='CYRILLIC SMALL LETTER KOPPA', uccode=0x0480 },
	[0x0482] = { unicodeslot=0x0482, category='so', description='CYRILLIC THOUSANDS SIGN' },
	[0x0483] = { unicodeslot=0x0483, category='mn', contextname='cyrillicTITLO', description='COMBINING CYRILLIC TITLO' },
	[0x0484] = { unicodeslot=0x0484, category='mn', contextname='cyrillicPALATALIZATION', description='COMBINING CYRILLIC PALATALIZATION' },
	[0x0485] = { unicodeslot=0x0485, category='mn', contextname='cyrillicDASIAPNEUMATA', description='COMBINING CYRILLIC DASIA PNEUMATA' },
	[0x0486] = { unicodeslot=0x0486, category='mn', contextname='cyrillicPSILIPNEUMATA', description='COMBINING CYRILLIC PSILI PNEUMATA' },
	[0x0488] = { unicodeslot=0x0488, category='me', description='COMBINING CYRILLIC HUNDRED THOUSANDS SIGN' },
	[0x0489] = { unicodeslot=0x0489, category='me', description='COMBINING CYRILLIC MILLIONS SIGN' },
	[0x048A] = { unicodeslot=0x048A, category='lu', contextname='cyrillicISHRTtail', description='CYRILLIC CAPITAL LETTER SHORT I WITH TAIL', lccode=0x048B },
	[0x048B] = { unicodeslot=0x048B, category='ll', contextname='cyrillicishrttail', description='CYRILLIC SMALL LETTER SHORT I WITH TAIL', uccode=0x048A },
	[0x048C] = { unicodeslot=0x048C, category='lu', contextname='cyrillicSEMISOFT', description='CYRILLIC CAPITAL LETTER SEMISOFT SIGN', lccode=0x048D },
	[0x048D] = { unicodeslot=0x048D, category='ll', contextname='cyrillicsemisoft', description='CYRILLIC SMALL LETTER SEMISOFT SIGN', uccode=0x048C },
	[0x048E] = { unicodeslot=0x048E, category='lu', contextname='cyrillicERtick', description='CYRILLIC CAPITAL LETTER ER WITH TICK', shcode=0x0420, lccode=0x048F },
	[0x048F] = { unicodeslot=0x048F, category='ll', contextname='cyrillicertick', description='CYRILLIC SMALL LETTER ER WITH TICK', shcode=0x0440, uccode=0x048E },
	[0x0490] = { unicodeslot=0x0490, category='lu', adobename='afii10050', contextname='cyrillicGHEupturn', description='CYRILLIC CAPITAL LETTER GHE WITH UPTURN', shcode=0x0413, lccode=0x0491 },
	[0x0491] = { unicodeslot=0x0491, category='ll', adobename='afii10098', contextname='cyrillicgheupturn', description='CYRILLIC SMALL LETTER GHE WITH UPTURN', shcode=0x0433, uccode=0x0490 },
	[0x0492] = { unicodeslot=0x0492, category='lu', contextname='cyrillicGHEstroke', description='CYRILLIC CAPITAL LETTER GHE WITH STROKE', shcode=0x0413, lccode=0x0493 },
	[0x0493] = { unicodeslot=0x0493, category='ll', contextname='cyrillicghestroke', description='CYRILLIC SMALL LETTER GHE WITH STROKE', shcode=0x0433, uccode=0x0492 },
	[0x0494] = { unicodeslot=0x0494, category='lu', contextname='cyrillicGHEmidhook', description='CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK', shcode=0x0413, lccode=0x0495 },
	[0x0495] = { unicodeslot=0x0495, category='ll', contextname='cyrillicghemidhook', description='CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK', shcode=0x0433, uccode=0x0494 },
	[0x0496] = { unicodeslot=0x0496, category='lu', contextname='cyrillicZHEdescender', description='CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER', shcode=0x0416, lccode=0x0497 },
	[0x0497] = { unicodeslot=0x0497, category='ll', contextname='cyrilliczhedescender', description='CYRILLIC SMALL LETTER ZHE WITH DESCENDER', shcode=0x0436, uccode=0x0496 },
	[0x0498] = { unicodeslot=0x0498, category='lu', contextname='cyrillicZDSC', description='CYRILLIC CAPITAL LETTER ZE WITH DESCENDER', shcode=0x0417, lccode=0x0499 },
	[0x0499] = { unicodeslot=0x0499, category='ll', contextname='cyrilliczdsc', description='CYRILLIC SMALL LETTER ZE WITH DESCENDER', shcode=0x0437, uccode=0x0498 },
	[0x049A] = { unicodeslot=0x049A, category='lu', contextname='cyrillicKADC', description='CYRILLIC CAPITAL LETTER KA WITH DESCENDER', shcode=0x041A, lccode=0x049B },
	[0x049B] = { unicodeslot=0x049B, category='ll', contextname='cyrillickadc', description='CYRILLIC SMALL LETTER KA WITH DESCENDER', shcode=0x043A, uccode=0x049A },
	[0x049C] = { unicodeslot=0x049C, category='lu', contextname='cyrillicKAvertstroke', description='CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE', shcode=0x041A, lccode=0x049D },
	[0x049D] = { unicodeslot=0x049D, category='ll', contextname='cyrillickavertstroke', description='CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE', shcode=0x043A, uccode=0x049C },
	[0x049E] = { unicodeslot=0x049E, category='lu', contextname='cyrillicKAstroke', description='CYRILLIC CAPITAL LETTER KA WITH STROKE', shcode=0x041A, lccode=0x049F },
	[0x049F] = { unicodeslot=0x049F, category='ll', contextname='cyrillickastroke', description='CYRILLIC SMALL LETTER KA WITH STROKE', shcode=0x043A, uccode=0x049E },
	[0x04A0] = { unicodeslot=0x04A0, category='lu', contextname='cyrillicKAbashkir', description='CYRILLIC CAPITAL LETTER BASHKIR KA', lccode=0x04A1 },
	[0x04A1] = { unicodeslot=0x04A1, category='ll', contextname='cyrillickabashkir', description='CYRILLIC SMALL LETTER BASHKIR KA', uccode=0x04A0 },
	[0x04A2] = { unicodeslot=0x04A2, category='lu', contextname='cyrillicENDC', description='CYRILLIC CAPITAL LETTER EN WITH DESCENDER', shcode=0x041D, lccode=0x04A3 },
	[0x04A3] = { unicodeslot=0x04A3, category='ll', contextname='cyrillicendc', description='CYRILLIC SMALL LETTER EN WITH DESCENDER', shcode=0x043D, uccode=0x04A2 },
	[0x04A4] = { unicodeslot=0x04A4, category='lu', contextname='cyrillicENGHE', description='CYRILLIC CAPITAL LIGATURE EN GHE', lccode=0x04A5 },
	[0x04A5] = { unicodeslot=0x04A5, category='ll', contextname='cyrillicenghe', description='CYRILLIC SMALL LIGATURE EN GHE', uccode=0x04A4 },
	[0x04A6] = { unicodeslot=0x04A6, category='lu', contextname='cyrillicPEmidhook', description='CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK', shcode=0x041F, lccode=0x04A7 },
	[0x04A7] = { unicodeslot=0x04A7, category='ll', contextname='cyrillicpemidhook', description='CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK', shcode=0x043F, uccode=0x04A6 },
	[0x04A8] = { unicodeslot=0x04A8, category='lu', contextname='cyrillicHA', description='CYRILLIC CAPITAL LETTER ABKHASIAN HA', lccode=0x04A9 },
	[0x04A9] = { unicodeslot=0x04A9, category='ll', contextname='cyrillicha', description='CYRILLIC SMALL LETTER ABKHASIAN HA', uccode=0x04A8 },
	[0x04AA] = { unicodeslot=0x04AA, category='lu', contextname='cyrillicSDSC', description='CYRILLIC CAPITAL LETTER ES WITH DESCENDER', shcode=0x0421, lccode=0x04AB },
	[0x04AB] = { unicodeslot=0x04AB, category='ll', contextname='cyrillicsdsc', description='CYRILLIC SMALL LETTER ES WITH DESCENDER', shcode=0x0441, uccode=0x04AA },
	[0x04AC] = { unicodeslot=0x04AC, category='lu', contextname='cyrillicTEDC', description='CYRILLIC CAPITAL LETTER TE WITH DESCENDER', shcode=0x0422, lccode=0x04AD },
	[0x04AD] = { unicodeslot=0x04AD, category='ll', contextname='cyrillictedc', description='CYRILLIC SMALL LETTER TE WITH DESCENDER', shcode=0x0442, uccode=0x04AC },
	[0x04AE] = { unicodeslot=0x04AE, category='lu', contextname='cyrillicYstr', description='CYRILLIC CAPITAL LETTER STRAIGHT U', lccode=0x04AF },
	[0x04AF] = { unicodeslot=0x04AF, category='ll', contextname='cyrillicystr', description='CYRILLIC SMALL LETTER STRAIGHT U', uccode=0x04AE },
	[0x04B0] = { unicodeslot=0x04B0, category='lu', contextname='cyrillicYstrstroke', description='CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE', lccode=0x04B1 },
	[0x04B1] = { unicodeslot=0x04B1, category='ll', contextname='cyrillicystrstroke', description='CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE', uccode=0x04B0 },
	[0x04B2] = { unicodeslot=0x04B2, category='lu', contextname='cyrillicHADC', description='CYRILLIC CAPITAL LETTER HA WITH DESCENDER', shcode=0x0425, lccode=0x04B3 },
	[0x04B3] = { unicodeslot=0x04B3, category='ll', contextname='cyrillichadc', description='CYRILLIC SMALL LETTER HA WITH DESCENDER', shcode=0x0445, uccode=0x04B2 },
	[0x04B4] = { unicodeslot=0x04B4, category='lu', contextname='cyrillicTETSE', description='CYRILLIC CAPITAL LIGATURE TE TSE', lccode=0x04B5 },
	[0x04B5] = { unicodeslot=0x04B5, category='ll', contextname='cyrillictetse', description='CYRILLIC SMALL LIGATURE TE TSE', uccode=0x04B4 },
	[0x04B6] = { unicodeslot=0x04B6, category='lu', contextname='cyrillicCHEDC', description='CYRILLIC CAPITAL LETTER CHE WITH DESCENDER', shcode=0x0427, lccode=0x04B7 },
	[0x04B7] = { unicodeslot=0x04B7, category='ll', contextname='cyrillicchedc', description='CYRILLIC SMALL LETTER CHE WITH DESCENDER', shcode=0x0447, uccode=0x04B6 },
	[0x04B8] = { unicodeslot=0x04B8, category='lu', contextname='cyrillicCHEvertstroke', description='CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE', shcode=0x0427, lccode=0x04B9 },
	[0x04B9] = { unicodeslot=0x04B9, category='ll', contextname='cyrillicchevertstroke', description='CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE', shcode=0x0447, uccode=0x04B8 },
	[0x04BA] = { unicodeslot=0x04BA, category='lu', contextname='cyrillicSHHA', description='CYRILLIC CAPITAL LETTER SHHA', lccode=0x04BB },
	[0x04BB] = { unicodeslot=0x04BB, category='ll', contextname='cyrillicshha', description='CYRILLIC SMALL LETTER SHHA', uccode=0x04BA },
	[0x04BC] = { unicodeslot=0x04BC, category='lu', contextname='cyrillicCHEabkhasian', description='CYRILLIC CAPITAL LETTER ABKHASIAN CHE', lccode=0x04BD },
	[0x04BD] = { unicodeslot=0x04BD, category='ll', contextname='cyrilliccheabkhasian', description='CYRILLIC SMALL LETTER ABKHASIAN CHE', uccode=0x04BC },
	[0x04BE] = { unicodeslot=0x04BE, category='lu', contextname='cyrillicCHEDCabkhasian', description='CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER', lccode=0x04BF },
	[0x04BF] = { unicodeslot=0x04BF, category='ll', contextname='cyrillicchedcabkhasian', description='CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER', uccode=0x04BE },
	[0x04C0] = { unicodeslot=0x04C0, category='lu', contextname='cyrillicPALOCHKA', description='CYRILLIC LETTER PALOCHKA', lccode=0x04CF },
	[0x04C1] = { unicodeslot=0x04C1, category='lu', contextname='cyrillicZHEbreve', description='CYRILLIC CAPITAL LETTER ZHE WITH BREVE', shcode=0x0416, lccode=0x04C2, specials={'char',0x0416,0x0306} },
	[0x04C2] = { unicodeslot=0x04C2, category='ll', contextname='cyrilliczhebreve', description='CYRILLIC SMALL LETTER ZHE WITH BREVE', shcode=0x0436, uccode=0x04C1, specials={'char',0x0436,0x0306} },
	[0x04C3] = { unicodeslot=0x04C3, category='lu', contextname='cyrillicKAhook', description='CYRILLIC CAPITAL LETTER KA WITH HOOK', shcode=0x041A, lccode=0x04C4 },
	[0x04C4] = { unicodeslot=0x04C4, category='ll', contextname='cyrillickahook', description='CYRILLIC SMALL LETTER KA WITH HOOK', shcode=0x043A, uccode=0x04C3 },
	[0x04C5] = { unicodeslot=0x04C5, category='lu', contextname='cyrillicELtail', description='CYRILLIC CAPITAL LETTER EL WITH TAIL', shcode=0x041B, lccode=0x04C6 },
	[0x04C6] = { unicodeslot=0x04C6, category='ll', contextname='cyrilliceltail', description='CYRILLIC SMALL LETTER EL WITH TAIL', shcode=0x043B, uccode=0x04C5 },
	[0x04C7] = { unicodeslot=0x04C7, category='lu', contextname='cyrillicENhook', description='CYRILLIC CAPITAL LETTER EN WITH HOOK', shcode=0x041D, lccode=0x04C8 },
	[0x04C8] = { unicodeslot=0x04C8, category='ll', contextname='cyrillicenhook', description='CYRILLIC SMALL LETTER EN WITH HOOK', shcode=0x043D, uccode=0x04C7 },
	[0x04C9] = { unicodeslot=0x04C9, category='lu', contextname='cyrillicENtail', description='CYRILLIC CAPITAL LETTER EN WITH TAIL', shcode=0x041D, lccode=0x04CA },
	[0x04CA] = { unicodeslot=0x04CA, category='ll', contextname='cyrillicentail', description='CYRILLIC SMALL LETTER EN WITH TAIL', shcode=0x043D, uccode=0x04C9 },
	[0x04CB] = { unicodeslot=0x04CB, category='lu', contextname='cyrillicCHEkhakassian', description='CYRILLIC CAPITAL LETTER KHAKASSIAN CHE', lccode=0x04CC },
	[0x04CC] = { unicodeslot=0x04CC, category='ll', contextname='cyrillicchekhakassian', description='CYRILLIC SMALL LETTER KHAKASSIAN CHE', uccode=0x04CB },
	[0x04CD] = { unicodeslot=0x04CD, category='lu', contextname='cyrillicEMtail', description='CYRILLIC CAPITAL LETTER EM WITH TAIL', shcode=0x041C, lccode=0x04CE },
	[0x04CE] = { unicodeslot=0x04CE, category='ll', contextname='cyrillicemtail', description='CYRILLIC SMALL LETTER EM WITH TAIL', shcode=0x043C, uccode=0x04CD },
	[0x04CF] = { unicodeslot=0x04CF, category='ll', description='CYRILLIC SMALL LETTER PALOCHKA', uccode=0x04C0 },
	[0x04D0] = { unicodeslot=0x04D0, category='lu', contextname='cyrillicAbreve', description='CYRILLIC CAPITAL LETTER A WITH BREVE', shcode=0x0410, lccode=0x04D1, specials={'char',0x0410,0x0306} },
	[0x04D1] = { unicodeslot=0x04D1, category='ll', contextname='cyrillicabreve', description='CYRILLIC SMALL LETTER A WITH BREVE', shcode=0x0430, uccode=0x04D0, specials={'char',0x0430,0x0306} },
	[0x04D2] = { unicodeslot=0x04D2, category='lu', contextname='cyrillicAdiaeresis', description='CYRILLIC CAPITAL LETTER A WITH DIAERESIS', shcode=0x0410, lccode=0x04D3, specials={'char',0x0410,0x0308} },
	[0x04D3] = { unicodeslot=0x04D3, category='ll', contextname='cyrillicadiaeresis', description='CYRILLIC SMALL LETTER A WITH DIAERESIS', shcode=0x0430, uccode=0x04D2, specials={'char',0x0430,0x0308} },
	[0x04D4] = { unicodeslot=0x04D4, category='lu', contextname='cyrillicAE', description='CYRILLIC CAPITAL LIGATURE A IE', lccode=0x04D5 },
	[0x04D5] = { unicodeslot=0x04D5, category='ll', contextname='cyrillicae', description='CYRILLIC SMALL LIGATURE A IE', uccode=0x04D4 },
	[0x04D6] = { unicodeslot=0x04D6, category='lu', contextname='cyrillicEbreve', description='CYRILLIC CAPITAL LETTER IE WITH BREVE', shcode=0x0415, lccode=0x04D7, specials={'char',0x0415,0x0306} },
	[0x04D7] = { unicodeslot=0x04D7, category='ll', contextname='cyrillicebreve', description='CYRILLIC SMALL LETTER IE WITH BREVE', shcode=0x0435, uccode=0x04D6, specials={'char',0x0435,0x0306} },
	[0x04D8] = { unicodeslot=0x04D8, category='lu', contextname='cyrillicSCHWA', description='CYRILLIC CAPITAL LETTER SCHWA', lccode=0x04D9 },
	[0x04D9] = { unicodeslot=0x04D9, category='ll', adobename='afii10846', contextname='cyrillicschwa', description='CYRILLIC SMALL LETTER SCHWA', uccode=0x04D8 },
	[0x04DA] = { unicodeslot=0x04DA, category='lu', contextname='cyrillicSCHWAdiaeresis', description='CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS', shcode=0x04D8, lccode=0x04DB, specials={'char',0x04D8,0x0308} },
	[0x04DB] = { unicodeslot=0x04DB, category='ll', contextname='cyrillicschwadiaeresis', description='CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS', shcode=0x04D9, uccode=0x04DA, specials={'char',0x04D9,0x0308} },
	[0x04DC] = { unicodeslot=0x04DC, category='lu', contextname='cyrillicZHEdiaeresis', description='CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS', shcode=0x0416, lccode=0x04DD, specials={'char',0x0416,0x0308} },
	[0x04DD] = { unicodeslot=0x04DD, category='ll', contextname='cyrilliczhediaeresis', description='CYRILLIC SMALL LETTER ZHE WITH DIAERESIS', shcode=0x0436, uccode=0x04DC, specials={'char',0x0436,0x0308} },
	[0x04DE] = { unicodeslot=0x04DE, category='lu', contextname='cyrillicZEdiaeresis', description='CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS', shcode=0x0417, lccode=0x04DF, specials={'char',0x0417,0x0308} },
	[0x04DF] = { unicodeslot=0x04DF, category='ll', contextname='cyrilliczediaeresis', description='CYRILLIC SMALL LETTER ZE WITH DIAERESIS', shcode=0x0437, uccode=0x04DE, specials={'char',0x0437,0x0308} },
	[0x04E0] = { unicodeslot=0x04E0, category='lu', contextname='cyrillicDZEabkhasian', description='CYRILLIC CAPITAL LETTER ABKHASIAN DZE', lccode=0x04E1 },
	[0x04E1] = { unicodeslot=0x04E1, category='ll', contextname='cyrillicdzeabkhasian', description='CYRILLIC SMALL LETTER ABKHASIAN DZE', uccode=0x04E0 },
	[0x04E2] = { unicodeslot=0x04E2, category='lu', contextname='cyrillicImacron', description='CYRILLIC CAPITAL LETTER I WITH MACRON', shcode=0x0418, lccode=0x04E3, specials={'char',0x0418,0x0304} },
	[0x04E3] = { unicodeslot=0x04E3, category='ll', contextname='cyrillicimacron', description='CYRILLIC SMALL LETTER I WITH MACRON', shcode=0x0438, uccode=0x04E2, specials={'char',0x0438,0x0304} },
	[0x04E4] = { unicodeslot=0x04E4, category='lu', contextname='cyrillicIdiaeresis', description='CYRILLIC CAPITAL LETTER I WITH DIAERESIS', shcode=0x0418, lccode=0x04E5, specials={'char',0x0418,0x0308} },
	[0x04E5] = { unicodeslot=0x04E5, category='ll', contextname='cyrillicidiaeresis', description='CYRILLIC SMALL LETTER I WITH DIAERESIS', shcode=0x0438, uccode=0x04E4, specials={'char',0x0438,0x0308} },
	[0x04E6] = { unicodeslot=0x04E6, category='lu', contextname='cyrillicOdiaeresis', description='CYRILLIC CAPITAL LETTER O WITH DIAERESIS', shcode=0x041E, lccode=0x04E7, specials={'char',0x041E,0x0308} },
	[0x04E7] = { unicodeslot=0x04E7, category='ll', contextname='cyrillicodiaeresis', description='CYRILLIC SMALL LETTER O WITH DIAERESIS', shcode=0x043E, uccode=0x04E6, specials={'char',0x043E,0x0308} },
	[0x04E8] = { unicodeslot=0x04E8, category='lu', contextname='cyrillicObarred', description='CYRILLIC CAPITAL LETTER BARRED O', lccode=0x04E9 },
	[0x04E9] = { unicodeslot=0x04E9, category='ll', contextname='cyrillicobarred', description='CYRILLIC SMALL LETTER BARRED O', uccode=0x04E8 },
	[0x04EA] = { unicodeslot=0x04EA, category='lu', contextname='cyrillicObarreddiaeresis', description='CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS', lccode=0x04EB, specials={'char',0x04E8,0x0308} },
	[0x04EB] = { unicodeslot=0x04EB, category='ll', contextname='cyrillicobarreddiaeresis', description='CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS', uccode=0x04EA, specials={'char',0x04E9,0x0308} },
	[0x04EC] = { unicodeslot=0x04EC, category='lu', contextname='cyrillicEdiaeresis', description='CYRILLIC CAPITAL LETTER E WITH DIAERESIS', shcode=0x042D, lccode=0x04ED, specials={'char',0x042D,0x0308} },
	[0x04ED] = { unicodeslot=0x04ED, category='ll', contextname='cyrillicediaeresis', description='CYRILLIC SMALL LETTER E WITH DIAERESIS', shcode=0x044D, uccode=0x04EC, specials={'char',0x044D,0x0308} },
	[0x04EE] = { unicodeslot=0x04EE, category='lu', contextname='cyrillicUmacron', description='CYRILLIC CAPITAL LETTER U WITH MACRON', shcode=0x0423, lccode=0x04EF, specials={'char',0x0423,0x0304} },
	[0x04EF] = { unicodeslot=0x04EF, category='ll', contextname='cyrillicumacron', description='CYRILLIC SMALL LETTER U WITH MACRON', shcode=0x0443, uccode=0x04EE, specials={'char',0x0443,0x0304} },
	[0x04F0] = { unicodeslot=0x04F0, category='lu', contextname='cyrillicUdiaeresis', description='CYRILLIC CAPITAL LETTER U WITH DIAERESIS', shcode=0x0423, lccode=0x04F1, specials={'char',0x0423,0x0308} },
	[0x04F1] = { unicodeslot=0x04F1, category='ll', contextname='cyrillicudiaeresis', description='CYRILLIC SMALL LETTER U WITH DIAERESIS', shcode=0x0443, uccode=0x04F0, specials={'char',0x0443,0x0308} },
	[0x04F2] = { unicodeslot=0x04F2, category='lu', contextname='cyrillicUdoubleacute', description='CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE', shcode=0x0423, lccode=0x04F3, specials={'char',0x0423,0x030B} },
	[0x04F3] = { unicodeslot=0x04F3, category='ll', contextname='cyrillicudoubleacute', description='CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE', shcode=0x0443, uccode=0x04F2, specials={'char',0x0443,0x030B} },
	[0x04F4] = { unicodeslot=0x04F4, category='lu', contextname='cyrillicCHEdiaeresis', description='CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS', shcode=0x0427, lccode=0x04F5, specials={'char',0x0427,0x0308} },
	[0x04F5] = { unicodeslot=0x04F5, category='ll', contextname='cyrillicchediaeresis', description='CYRILLIC SMALL LETTER CHE WITH DIAERESIS', shcode=0x0447, uccode=0x04F4, specials={'char',0x0447,0x0308} },
	[0x04F6] = { unicodeslot=0x04F6, category='lu', description='CYRILLIC CAPITAL LETTER GHE WITH DESCENDER', shcode=0x0413, lccode=0x04F7 },
	[0x04F7] = { unicodeslot=0x04F7, category='ll', description='CYRILLIC SMALL LETTER GHE WITH DESCENDER', shcode=0x0433, uccode=0x04F6 },
	[0x04F8] = { unicodeslot=0x04F8, category='lu', contextname='cyrillicYERUdiaeresis', description='CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS', shcode=0x042B, lccode=0x04F9, specials={'char',0x042B,0x0308} },
	[0x04F9] = { unicodeslot=0x04F9, category='ll', contextname='cyrillicyerudiaeresis', description='CYRILLIC SMALL LETTER YERU WITH DIAERESIS', shcode=0x044B, uccode=0x04F8, specials={'char',0x044B,0x0308} },
	[0x04FA] = { unicodeslot=0x04FA, category='lu', description='CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK', shcode=0x0413, lccode=0x04FB },
	[0x04FB] = { unicodeslot=0x04FB, category='ll', description='CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK', shcode=0x0433, uccode=0x04FA },
	[0x04FC] = { unicodeslot=0x04FC, category='lu', description='CYRILLIC CAPITAL LETTER HA WITH HOOK', shcode=0x0425, lccode=0x04FD },
	[0x04FD] = { unicodeslot=0x04FD, category='ll', description='CYRILLIC SMALL LETTER HA WITH HOOK', shcode=0x0445, uccode=0x04FC },
	[0x04FE] = { unicodeslot=0x04FE, category='lu', description='CYRILLIC CAPITAL LETTER HA WITH STROKE', shcode=0x0425, lccode=0x04FF },
	[0x04FF] = { unicodeslot=0x04FF, category='ll', description='CYRILLIC SMALL LETTER HA WITH STROKE', shcode=0x0445, uccode=0x04FE },
	[0x0500] = { unicodeslot=0x0500, category='lu', description='CYRILLIC CAPITAL LETTER KOMI DE', lccode=0x0501 },
	[0x0501] = { unicodeslot=0x0501, category='ll', description='CYRILLIC SMALL LETTER KOMI DE', uccode=0x0500 },
	[0x0502] = { unicodeslot=0x0502, category='lu', description='CYRILLIC CAPITAL LETTER KOMI DJE', lccode=0x0503 },
	[0x0503] = { unicodeslot=0x0503, category='ll', description='CYRILLIC SMALL LETTER KOMI DJE', uccode=0x0502 },
	[0x0504] = { unicodeslot=0x0504, category='lu', description='CYRILLIC CAPITAL LETTER KOMI ZJE', lccode=0x0505 },
	[0x0505] = { unicodeslot=0x0505, category='ll', description='CYRILLIC SMALL LETTER KOMI ZJE', uccode=0x0504 },
	[0x0506] = { unicodeslot=0x0506, category='lu', description='CYRILLIC CAPITAL LETTER KOMI DZJE', lccode=0x0507 },
	[0x0507] = { unicodeslot=0x0507, category='ll', description='CYRILLIC SMALL LETTER KOMI DZJE', uccode=0x0506 },
	[0x0508] = { unicodeslot=0x0508, category='lu', description='CYRILLIC CAPITAL LETTER KOMI LJE', lccode=0x0509 },
	[0x0509] = { unicodeslot=0x0509, category='ll', description='CYRILLIC SMALL LETTER KOMI LJE', uccode=0x0508 },
	[0x050A] = { unicodeslot=0x050A, category='lu', description='CYRILLIC CAPITAL LETTER KOMI NJE', lccode=0x050B },
	[0x050B] = { unicodeslot=0x050B, category='ll', description='CYRILLIC SMALL LETTER KOMI NJE', uccode=0x050A },
	[0x050C] = { unicodeslot=0x050C, category='lu', description='CYRILLIC CAPITAL LETTER KOMI SJE', lccode=0x050D },
	[0x050D] = { unicodeslot=0x050D, category='ll', description='CYRILLIC SMALL LETTER KOMI SJE', uccode=0x050C },
	[0x050E] = { unicodeslot=0x050E, category='lu', description='CYRILLIC CAPITAL LETTER KOMI TJE', lccode=0x050F },
	[0x050F] = { unicodeslot=0x050F, category='ll', description='CYRILLIC SMALL LETTER KOMI TJE', uccode=0x050E },
	[0x0510] = { unicodeslot=0x0510, category='lu', description='CYRILLIC CAPITAL LETTER REVERSED ZE', lccode=0x0511 },
	[0x0511] = { unicodeslot=0x0511, category='ll', description='CYRILLIC SMALL LETTER REVERSED ZE', uccode=0x0510 },
	[0x0512] = { unicodeslot=0x0512, category='lu', description='CYRILLIC CAPITAL LETTER EL WITH HOOK', shcode=0x041B, lccode=0x0513 },
	[0x0513] = { unicodeslot=0x0513, category='ll', description='CYRILLIC SMALL LETTER EL WITH HOOK', shcode=0x043B, uccode=0x0512 },
	[0x0531] = { unicodeslot=0x0531, category='lu', description='ARMENIAN CAPITAL LETTER AYB', lccode=0x0561 },
	[0x0532] = { unicodeslot=0x0532, category='lu', description='ARMENIAN CAPITAL LETTER BEN', lccode=0x0562 },
	[0x0533] = { unicodeslot=0x0533, category='lu', description='ARMENIAN CAPITAL LETTER GIM', lccode=0x0563 },
	[0x0534] = { unicodeslot=0x0534, category='lu', description='ARMENIAN CAPITAL LETTER DA', lccode=0x0564 },
	[0x0535] = { unicodeslot=0x0535, category='lu', description='ARMENIAN CAPITAL LETTER ECH', lccode=0x0565 },
	[0x0536] = { unicodeslot=0x0536, category='lu', description='ARMENIAN CAPITAL LETTER ZA', lccode=0x0566 },
	[0x0537] = { unicodeslot=0x0537, category='lu', description='ARMENIAN CAPITAL LETTER EH', lccode=0x0567 },
	[0x0538] = { unicodeslot=0x0538, category='lu', description='ARMENIAN CAPITAL LETTER ET', lccode=0x0568 },
	[0x0539] = { unicodeslot=0x0539, category='lu', description='ARMENIAN CAPITAL LETTER TO', lccode=0x0569 },
	[0x053A] = { unicodeslot=0x053A, category='lu', description='ARMENIAN CAPITAL LETTER ZHE', lccode=0x056A },
	[0x053B] = { unicodeslot=0x053B, category='lu', description='ARMENIAN CAPITAL LETTER INI', lccode=0x056B },
	[0x053C] = { unicodeslot=0x053C, category='lu', description='ARMENIAN CAPITAL LETTER LIWN', lccode=0x056C },
	[0x053D] = { unicodeslot=0x053D, category='lu', description='ARMENIAN CAPITAL LETTER XEH', lccode=0x056D },
	[0x053E] = { unicodeslot=0x053E, category='lu', description='ARMENIAN CAPITAL LETTER CA', lccode=0x056E },
	[0x053F] = { unicodeslot=0x053F, category='lu', description='ARMENIAN CAPITAL LETTER KEN', lccode=0x056F },
	[0x0540] = { unicodeslot=0x0540, category='lu', description='ARMENIAN CAPITAL LETTER HO', lccode=0x0570 },
	[0x0541] = { unicodeslot=0x0541, category='lu', description='ARMENIAN CAPITAL LETTER JA', lccode=0x0571 },
	[0x0542] = { unicodeslot=0x0542, category='lu', description='ARMENIAN CAPITAL LETTER GHAD', lccode=0x0572 },
	[0x0543] = { unicodeslot=0x0543, category='lu', description='ARMENIAN CAPITAL LETTER CHEH', lccode=0x0573 },
	[0x0544] = { unicodeslot=0x0544, category='lu', description='ARMENIAN CAPITAL LETTER MEN', lccode=0x0574 },
	[0x0545] = { unicodeslot=0x0545, category='lu', description='ARMENIAN CAPITAL LETTER YI', lccode=0x0575 },
	[0x0546] = { unicodeslot=0x0546, category='lu', description='ARMENIAN CAPITAL LETTER NOW', lccode=0x0576 },
	[0x0547] = { unicodeslot=0x0547, category='lu', description='ARMENIAN CAPITAL LETTER SHA', lccode=0x0577 },
	[0x0548] = { unicodeslot=0x0548, category='lu', description='ARMENIAN CAPITAL LETTER VO', lccode=0x0578 },
	[0x0549] = { unicodeslot=0x0549, category='lu', description='ARMENIAN CAPITAL LETTER CHA', lccode=0x0579 },
	[0x054A] = { unicodeslot=0x054A, category='lu', description='ARMENIAN CAPITAL LETTER PEH', lccode=0x057A },
	[0x054B] = { unicodeslot=0x054B, category='lu', description='ARMENIAN CAPITAL LETTER JHEH', lccode=0x057B },
	[0x054C] = { unicodeslot=0x054C, category='lu', description='ARMENIAN CAPITAL LETTER RA', lccode=0x057C },
	[0x054D] = { unicodeslot=0x054D, category='lu', description='ARMENIAN CAPITAL LETTER SEH', lccode=0x057D },
	[0x054E] = { unicodeslot=0x054E, category='lu', description='ARMENIAN CAPITAL LETTER VEW', lccode=0x057E },
	[0x054F] = { unicodeslot=0x054F, category='lu', description='ARMENIAN CAPITAL LETTER TIWN', lccode=0x057F },
	[0x0550] = { unicodeslot=0x0550, category='lu', description='ARMENIAN CAPITAL LETTER REH', lccode=0x0580 },
	[0x0551] = { unicodeslot=0x0551, category='lu', description='ARMENIAN CAPITAL LETTER CO', lccode=0x0581 },
	[0x0552] = { unicodeslot=0x0552, category='lu', description='ARMENIAN CAPITAL LETTER YIWN', lccode=0x0582 },
	[0x0553] = { unicodeslot=0x0553, category='lu', description='ARMENIAN CAPITAL LETTER PIWR', lccode=0x0583 },
	[0x0554] = { unicodeslot=0x0554, category='lu', description='ARMENIAN CAPITAL LETTER KEH', lccode=0x0584 },
	[0x0555] = { unicodeslot=0x0555, category='lu', description='ARMENIAN CAPITAL LETTER OH', lccode=0x0585 },
	[0x0556] = { unicodeslot=0x0556, category='lu', description='ARMENIAN CAPITAL LETTER FEH', lccode=0x0586 },
	[0x0559] = { unicodeslot=0x0559, category='lm', description='ARMENIAN MODIFIER LETTER LEFT HALF RING' },
	[0x055A] = { unicodeslot=0x055A, category='po', description='ARMENIAN APOSTROPHE' },
	[0x055B] = { unicodeslot=0x055B, category='po', description='ARMENIAN EMPHASIS MARK' },
	[0x055C] = { unicodeslot=0x055C, category='po', description='ARMENIAN EXCLAMATION MARK' },
	[0x055D] = { unicodeslot=0x055D, category='po', description='ARMENIAN COMMA' },
	[0x055E] = { unicodeslot=0x055E, category='po', description='ARMENIAN QUESTION MARK' },
	[0x055F] = { unicodeslot=0x055F, category='po', description='ARMENIAN ABBREVIATION MARK' },
	[0x0561] = { unicodeslot=0x0561, category='ll', description='ARMENIAN SMALL LETTER AYB', uccode=0x0531 },
	[0x0562] = { unicodeslot=0x0562, category='ll', description='ARMENIAN SMALL LETTER BEN', uccode=0x0532 },
	[0x0563] = { unicodeslot=0x0563, category='ll', description='ARMENIAN SMALL LETTER GIM', uccode=0x0533 },
	[0x0564] = { unicodeslot=0x0564, category='ll', description='ARMENIAN SMALL LETTER DA', uccode=0x0534 },
	[0x0565] = { unicodeslot=0x0565, category='ll', description='ARMENIAN SMALL LETTER ECH', uccode=0x0535 },
	[0x0566] = { unicodeslot=0x0566, category='ll', description='ARMENIAN SMALL LETTER ZA', uccode=0x0536 },
	[0x0567] = { unicodeslot=0x0567, category='ll', description='ARMENIAN SMALL LETTER EH', uccode=0x0537 },
	[0x0568] = { unicodeslot=0x0568, category='ll', description='ARMENIAN SMALL LETTER ET', uccode=0x0538 },
	[0x0569] = { unicodeslot=0x0569, category='ll', description='ARMENIAN SMALL LETTER TO', uccode=0x0539 },
	[0x056A] = { unicodeslot=0x056A, category='ll', description='ARMENIAN SMALL LETTER ZHE', uccode=0x053A },
	[0x056B] = { unicodeslot=0x056B, category='ll', description='ARMENIAN SMALL LETTER INI', uccode=0x053B },
	[0x056C] = { unicodeslot=0x056C, category='ll', description='ARMENIAN SMALL LETTER LIWN', uccode=0x053C },
	[0x056D] = { unicodeslot=0x056D, category='ll', description='ARMENIAN SMALL LETTER XEH', uccode=0x053D },
	[0x056E] = { unicodeslot=0x056E, category='ll', description='ARMENIAN SMALL LETTER CA', uccode=0x053E },
	[0x056F] = { unicodeslot=0x056F, category='ll', description='ARMENIAN SMALL LETTER KEN', uccode=0x053F },
	[0x0570] = { unicodeslot=0x0570, category='ll', description='ARMENIAN SMALL LETTER HO', uccode=0x0540 },
	[0x0571] = { unicodeslot=0x0571, category='ll', description='ARMENIAN SMALL LETTER JA', uccode=0x0541 },
	[0x0572] = { unicodeslot=0x0572, category='ll', description='ARMENIAN SMALL LETTER GHAD', uccode=0x0542 },
	[0x0573] = { unicodeslot=0x0573, category='ll', description='ARMENIAN SMALL LETTER CHEH', uccode=0x0543 },
	[0x0574] = { unicodeslot=0x0574, category='ll', description='ARMENIAN SMALL LETTER MEN', uccode=0x0544 },
	[0x0575] = { unicodeslot=0x0575, category='ll', description='ARMENIAN SMALL LETTER YI', uccode=0x0545 },
	[0x0576] = { unicodeslot=0x0576, category='ll', description='ARMENIAN SMALL LETTER NOW', uccode=0x0546 },
	[0x0577] = { unicodeslot=0x0577, category='ll', description='ARMENIAN SMALL LETTER SHA', uccode=0x0547 },
	[0x0578] = { unicodeslot=0x0578, category='ll', description='ARMENIAN SMALL LETTER VO', uccode=0x0548 },
	[0x0579] = { unicodeslot=0x0579, category='ll', description='ARMENIAN SMALL LETTER CHA', uccode=0x0549 },
	[0x057A] = { unicodeslot=0x057A, category='ll', description='ARMENIAN SMALL LETTER PEH', uccode=0x054A },
	[0x057B] = { unicodeslot=0x057B, category='ll', description='ARMENIAN SMALL LETTER JHEH', uccode=0x054B },
	[0x057C] = { unicodeslot=0x057C, category='ll', description='ARMENIAN SMALL LETTER RA', uccode=0x054C },
	[0x057D] = { unicodeslot=0x057D, category='ll', description='ARMENIAN SMALL LETTER SEH', uccode=0x054D },
	[0x057E] = { unicodeslot=0x057E, category='ll', description='ARMENIAN SMALL LETTER VEW', uccode=0x054E },
	[0x057F] = { unicodeslot=0x057F, category='ll', description='ARMENIAN SMALL LETTER TIWN', uccode=0x054F },
	[0x0580] = { unicodeslot=0x0580, category='ll', description='ARMENIAN SMALL LETTER REH', uccode=0x0550 },
	[0x0581] = { unicodeslot=0x0581, category='ll', description='ARMENIAN SMALL LETTER CO', uccode=0x0551 },
	[0x0582] = { unicodeslot=0x0582, category='ll', description='ARMENIAN SMALL LETTER YIWN', uccode=0x0552 },
	[0x0583] = { unicodeslot=0x0583, category='ll', description='ARMENIAN SMALL LETTER PIWR', uccode=0x0553 },
	[0x0584] = { unicodeslot=0x0584, category='ll', description='ARMENIAN SMALL LETTER KEH', uccode=0x0554 },
	[0x0585] = { unicodeslot=0x0585, category='ll', description='ARMENIAN SMALL LETTER OH', uccode=0x0555 },
	[0x0586] = { unicodeslot=0x0586, category='ll', description='ARMENIAN SMALL LETTER FEH', uccode=0x0556 },
	[0x0587] = { unicodeslot=0x0587, category='ll', description='ARMENIAN SMALL LIGATURE ECH YIWN', specials={'compat',0x0565,0x0582} },
	[0x0589] = { unicodeslot=0x0589, category='po', description='ARMENIAN FULL STOP' },
	[0x058A] = { unicodeslot=0x058A, category='pd', description='ARMENIAN HYPHEN' },
	[0x0591] = { unicodeslot=0x0591, category='mn', description='HEBREW ACCENT ETNAHTA' },
	[0x0592] = { unicodeslot=0x0592, category='mn', description='HEBREW ACCENT SEGOL' },
	[0x0593] = { unicodeslot=0x0593, category='mn', description='HEBREW ACCENT SHALSHELET' },
	[0x0594] = { unicodeslot=0x0594, category='mn', description='HEBREW ACCENT ZAQEF QATAN' },
	[0x0595] = { unicodeslot=0x0595, category='mn', description='HEBREW ACCENT ZAQEF GADOL' },
	[0x0596] = { unicodeslot=0x0596, category='mn', description='HEBREW ACCENT TIPEHA' },
	[0x0597] = { unicodeslot=0x0597, category='mn', description='HEBREW ACCENT REVIA' },
	[0x0598] = { unicodeslot=0x0598, category='mn', description='HEBREW ACCENT ZARQA' },
	[0x0599] = { unicodeslot=0x0599, category='mn', description='HEBREW ACCENT PASHTA' },
	[0x059A] = { unicodeslot=0x059A, category='mn', description='HEBREW ACCENT YETIV' },
	[0x059B] = { unicodeslot=0x059B, category='mn', description='HEBREW ACCENT TEVIR' },
	[0x059C] = { unicodeslot=0x059C, category='mn', description='HEBREW ACCENT GERESH' },
	[0x059D] = { unicodeslot=0x059D, category='mn', description='HEBREW ACCENT GERESH MUQDAM' },
	[0x059E] = { unicodeslot=0x059E, category='mn', description='HEBREW ACCENT GERSHAYIM' },
	[0x059F] = { unicodeslot=0x059F, category='mn', description='HEBREW ACCENT QARNEY PARA' },
	[0x05A0] = { unicodeslot=0x05A0, category='mn', description='HEBREW ACCENT TELISHA GEDOLA' },
	[0x05A1] = { unicodeslot=0x05A1, category='mn', description='HEBREW ACCENT PAZER' },
	[0x05A2] = { unicodeslot=0x05A2, category='mn', description='HEBREW ACCENT ATNAH HAFUKH' },
	[0x05A3] = { unicodeslot=0x05A3, category='mn', description='HEBREW ACCENT MUNAH' },
	[0x05A4] = { unicodeslot=0x05A4, category='mn', description='HEBREW ACCENT MAHAPAKH' },
	[0x05A5] = { unicodeslot=0x05A5, category='mn', description='HEBREW ACCENT MERKHA' },
	[0x05A6] = { unicodeslot=0x05A6, category='mn', description='HEBREW ACCENT MERKHA KEFULA' },
	[0x05A7] = { unicodeslot=0x05A7, category='mn', description='HEBREW ACCENT DARGA' },
	[0x05A8] = { unicodeslot=0x05A8, category='mn', description='HEBREW ACCENT QADMA' },
	[0x05A9] = { unicodeslot=0x05A9, category='mn', description='HEBREW ACCENT TELISHA QETANA' },
	[0x05AA] = { unicodeslot=0x05AA, category='mn', description='HEBREW ACCENT YERAH BEN YOMO' },
	[0x05AB] = { unicodeslot=0x05AB, category='mn', description='HEBREW ACCENT OLE' },
	[0x05AC] = { unicodeslot=0x05AC, category='mn', description='HEBREW ACCENT ILUY' },
	[0x05AD] = { unicodeslot=0x05AD, category='mn', description='HEBREW ACCENT DEHI' },
	[0x05AE] = { unicodeslot=0x05AE, category='mn', description='HEBREW ACCENT ZINOR' },
	[0x05AF] = { unicodeslot=0x05AF, category='mn', description='HEBREW MARK MASORA CIRCLE' },
	[0x05B0] = { unicodeslot=0x05B0, category='mn', adobename='afii57799', description='HEBREW POINT SHEVA' },
	[0x05B1] = { unicodeslot=0x05B1, category='mn', adobename='afii57801', description='HEBREW POINT HATAF SEGOL' },
	[0x05B2] = { unicodeslot=0x05B2, category='mn', adobename='afii57800', description='HEBREW POINT HATAF PATAH' },
	[0x05B3] = { unicodeslot=0x05B3, category='mn', adobename='afii57802', description='HEBREW POINT HATAF QAMATS' },
	[0x05B4] = { unicodeslot=0x05B4, category='mn', adobename='afii57793', description='HEBREW POINT HIRIQ' },
	[0x05B5] = { unicodeslot=0x05B5, category='mn', adobename='afii57794', description='HEBREW POINT TSERE' },
	[0x05B6] = { unicodeslot=0x05B6, category='mn', adobename='afii57795', description='HEBREW POINT SEGOL' },
	[0x05B7] = { unicodeslot=0x05B7, category='mn', adobename='afii57798', description='HEBREW POINT PATAH' },
	[0x05B8] = { unicodeslot=0x05B8, category='mn', adobename='afii57797', description='HEBREW POINT QAMATS' },
	[0x05B9] = { unicodeslot=0x05B9, category='mn', adobename='afii57806', description='HEBREW POINT HOLAM' },
	[0x05BA] = { unicodeslot=0x05BA, category='mn', description='HEBREW POINT HOLAM HASER FOR VAV' },
	[0x05BB] = { unicodeslot=0x05BB, category='mn', adobename='afii57796', description='HEBREW POINT QUBUTS' },
	[0x05BC] = { unicodeslot=0x05BC, category='mn', adobename='afii57807', description='HEBREW POINT DAGESH OR MAPIQ' },
	[0x05BD] = { unicodeslot=0x05BD, category='mn', adobename='afii57839', description='HEBREW POINT METEG' },
	[0x05BE] = { unicodeslot=0x05BE, category='po', adobename='afii57645', description='HEBREW PUNCTUATION MAQAF' },
	[0x05BF] = { unicodeslot=0x05BF, category='mn', adobename='afii57841', description='HEBREW POINT RAFE' },
	[0x05C0] = { unicodeslot=0x05C0, category='po', adobename='afii57842', description='HEBREW PUNCTUATION PASEQ' },
	[0x05C1] = { unicodeslot=0x05C1, category='mn', adobename='afii57804', description='HEBREW POINT SHIN DOT' },
	[0x05C2] = { unicodeslot=0x05C2, category='mn', adobename='afii57803', description='HEBREW POINT SIN DOT' },
	[0x05C3] = { unicodeslot=0x05C3, category='po', adobename='afii57658', description='HEBREW PUNCTUATION SOF PASUQ' },
	[0x05C4] = { unicodeslot=0x05C4, category='mn', description='HEBREW MARK UPPER DOT' },
	[0x05C5] = { unicodeslot=0x05C5, category='mn', description='HEBREW MARK LOWER DOT' },
	[0x05C6] = { unicodeslot=0x05C6, category='po', description='HEBREW PUNCTUATION NUN HAFUKHA' },
	[0x05C7] = { unicodeslot=0x05C7, category='mn', description='HEBREW POINT QAMATS QATAN' },
	[0x05D0] = { unicodeslot=0x05D0, category='lo', adobename='afii57664', contextname='hebrewAlef', description='HEBREW LETTER ALEF' },
	[0x05D1] = { unicodeslot=0x05D1, category='lo', adobename='afii57665', contextname='hebrewBet', description='HEBREW LETTER BET' },
	[0x05D2] = { unicodeslot=0x05D2, category='lo', adobename='afii57666', contextname='hebrewGimel', description='HEBREW LETTER GIMEL' },
	[0x05D3] = { unicodeslot=0x05D3, category='lo', adobename='afii57667', contextname='hebrewDalet', description='HEBREW LETTER DALET' },
	[0x05D4] = { unicodeslot=0x05D4, category='lo', adobename='afii57668', contextname='hebrewHe', description='HEBREW LETTER HE' },
	[0x05D5] = { unicodeslot=0x05D5, category='lo', adobename='afii57669', contextname='hebrewVav', description='HEBREW LETTER VAV' },
	[0x05D6] = { unicodeslot=0x05D6, category='lo', adobename='afii57670', contextname='hebrewZayin', description='HEBREW LETTER ZAYIN' },
	[0x05D7] = { unicodeslot=0x05D7, category='lo', adobename='afii57671', contextname='hebrewHet', description='HEBREW LETTER HET' },
	[0x05D8] = { unicodeslot=0x05D8, category='lo', adobename='afii57672', contextname='hebrewTet', description='HEBREW LETTER TET' },
	[0x05D9] = { unicodeslot=0x05D9, category='lo', adobename='afii57673', contextname='hebrewYod', description='HEBREW LETTER YOD' },
	[0x05DA] = { unicodeslot=0x05DA, category='lo', adobename='afii57674', contextname='hebrewKaffinal', description='HEBREW LETTER FINAL KAF' },
	[0x05DB] = { unicodeslot=0x05DB, category='lo', adobename='afii57675', contextname='hebrewKaf', description='HEBREW LETTER KAF' },
	[0x05DC] = { unicodeslot=0x05DC, category='lo', adobename='afii57676', contextname='hebrewLamed', description='HEBREW LETTER LAMED' },
	[0x05DD] = { unicodeslot=0x05DD, category='lo', adobename='afii57677', contextname='hebrewMemfinal', description='HEBREW LETTER FINAL MEM' },
	[0x05DE] = { unicodeslot=0x05DE, category='lo', adobename='afii57678', contextname='hebrewMem', description='HEBREW LETTER MEM' },
	[0x05DF] = { unicodeslot=0x05DF, category='lo', adobename='afii57679', contextname='hebrewNunfinal', description='HEBREW LETTER FINAL NUN' },
	[0x05E0] = { unicodeslot=0x05E0, category='lo', adobename='afii57680', contextname='hebrewNun', description='HEBREW LETTER NUN' },
	[0x05E1] = { unicodeslot=0x05E1, category='lo', adobename='afii57681', contextname='hebrewSamekh', description='HEBREW LETTER SAMEKH' },
	[0x05E2] = { unicodeslot=0x05E2, category='lo', adobename='afii57682', contextname='hebrewAyin', description='HEBREW LETTER AYIN' },
	[0x05E3] = { unicodeslot=0x05E3, category='lo', adobename='afii57683', contextname='hebrewPefinal', description='HEBREW LETTER FINAL PE' },
	[0x05E4] = { unicodeslot=0x05E4, category='lo', adobename='afii57684', contextname='hebrewPe', description='HEBREW LETTER PE' },
	[0x05E5] = { unicodeslot=0x05E5, category='lo', adobename='afii57685', contextname='hebrewTsadifinal', description='HEBREW LETTER FINAL TSADI' },
	[0x05E6] = { unicodeslot=0x05E6, category='lo', adobename='afii57686', contextname='hebrewTsadi', description='HEBREW LETTER TSADI' },
	[0x05E7] = { unicodeslot=0x05E7, category='lo', adobename='afii57687', contextname='hebrewQof', description='HEBREW LETTER QOF' },
	[0x05E8] = { unicodeslot=0x05E8, category='lo', adobename='afii57688', contextname='hebrewResh', description='HEBREW LETTER RESH' },
	[0x05E9] = { unicodeslot=0x05E9, category='lo', adobename='afii57689', contextname='hebrewShin', description='HEBREW LETTER SHIN' },
	[0x05EA] = { unicodeslot=0x05EA, category='lo', adobename='afii57690', contextname='hebrewTav', description='HEBREW LETTER TAV' },
	[0x05F0] = { unicodeslot=0x05F0, category='lo', adobename='afii57716', description='HEBREW LIGATURE YIDDISH DOUBLE VAV' },
	[0x05F1] = { unicodeslot=0x05F1, category='lo', adobename='afii57717', description='HEBREW LIGATURE YIDDISH VAV YOD' },
	[0x05F2] = { unicodeslot=0x05F2, category='lo', adobename='afii57718', description='HEBREW LIGATURE YIDDISH DOUBLE YOD' },
	[0x05F3] = { unicodeslot=0x05F3, category='po', description='HEBREW PUNCTUATION GERESH' },
	[0x05F4] = { unicodeslot=0x05F4, category='po', description='HEBREW PUNCTUATION GERSHAYIM' },
	[0x0600] = { unicodeslot=0x0600, category='cf', description='ARABIC NUMBER SIGN' },
	[0x0601] = { unicodeslot=0x0601, category='cf', description='ARABIC SIGN SANAH' },
	[0x0602] = { unicodeslot=0x0602, category='cf', description='ARABIC FOOTNOTE MARKER' },
	[0x0603] = { unicodeslot=0x0603, category='cf', description='ARABIC SIGN SAFHA' },
	[0x060B] = { unicodeslot=0x060B, category='sc', description='AFGHANI SIGN' },
	[0x060C] = { unicodeslot=0x060C, category='po', adobename='afii57388', description='ARABIC COMMA' },
	[0x060D] = { unicodeslot=0x060D, category='po', description='ARABIC DATE SEPARATOR' },
	[0x060E] = { unicodeslot=0x060E, category='so', description='ARABIC POETIC VERSE SIGN' },
	[0x060F] = { unicodeslot=0x060F, category='so', description='ARABIC SIGN MISRA' },
	[0x0610] = { unicodeslot=0x0610, category='mn', description='ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM' },
	[0x0611] = { unicodeslot=0x0611, category='mn', description='ARABIC SIGN ALAYHE ASSALLAM' },
	[0x0612] = { unicodeslot=0x0612, category='mn', description='ARABIC SIGN RAHMATULLAH ALAYHE' },
	[0x0613] = { unicodeslot=0x0613, category='mn', description='ARABIC SIGN RADI ALLAHOU ANHU' },
	[0x0614] = { unicodeslot=0x0614, category='mn', description='ARABIC SIGN TAKHALLUS' },
	[0x0615] = { unicodeslot=0x0615, category='mn', description='ARABIC SMALL HIGH TAH' },
	[0x061B] = { unicodeslot=0x061B, category='po', adobename='afii57403', description='ARABIC SEMICOLON' },
	[0x061E] = { unicodeslot=0x061E, category='po', description='ARABIC TRIPLE DOT PUNCTUATION MARK' },
	[0x061F] = { unicodeslot=0x061F, category='po', adobename='afii57407', description='ARABIC QUESTION MARK' },
	[0x0621] = { unicodeslot=0x0621, category='lo', adobename='afii57409', description='ARABIC LETTER HAMZA' },
	[0x0622] = { unicodeslot=0x0622, category='lo', adobename='afii57410', description='ARABIC LETTER ALEF WITH MADDA ABOVE', shcode=0x0627, specials={'char',0x0627,0x0653} },
	[0x0623] = { unicodeslot=0x0623, category='lo', adobename='afii57411', description='ARABIC LETTER ALEF WITH HAMZA ABOVE', shcode=0x0627, specials={'char',0x0627,0x0654} },
	[0x0624] = { unicodeslot=0x0624, category='lo', adobename='afii57412', description='ARABIC LETTER WAW WITH HAMZA ABOVE', shcode=0x0648, specials={'char',0x0648,0x0654} },
	[0x0625] = { unicodeslot=0x0625, category='lo', adobename='afii57413', description='ARABIC LETTER ALEF WITH HAMZA BELOW', shcode=0x0627, specials={'char',0x0627,0x0655} },
	[0x0626] = { unicodeslot=0x0626, category='lo', adobename='afii57414', description='ARABIC LETTER YEH WITH HAMZA ABOVE', shcode=0x064A, specials={'char',0x064A,0x0654} },
	[0x0627] = { unicodeslot=0x0627, category='lo', adobename='afii57415', description='ARABIC LETTER ALEF' },
	[0x0628] = { unicodeslot=0x0628, category='lo', adobename='afii57416', description='ARABIC LETTER BEH' },
	[0x0629] = { unicodeslot=0x0629, category='lo', adobename='afii57417', description='ARABIC LETTER TEH MARBUTA' },
	[0x062A] = { unicodeslot=0x062A, category='lo', adobename='afii57418', description='ARABIC LETTER TEH' },
	[0x062B] = { unicodeslot=0x062B, category='lo', adobename='afii57419', description='ARABIC LETTER THEH' },
	[0x062C] = { unicodeslot=0x062C, category='lo', adobename='afii57420', description='ARABIC LETTER JEEM' },
	[0x062D] = { unicodeslot=0x062D, category='lo', adobename='afii57421', description='ARABIC LETTER HAH' },
	[0x062E] = { unicodeslot=0x062E, category='lo', adobename='afii57422', description='ARABIC LETTER KHAH' },
	[0x062F] = { unicodeslot=0x062F, category='lo', adobename='afii57423', description='ARABIC LETTER DAL' },
	[0x0630] = { unicodeslot=0x0630, category='lo', adobename='afii57424', description='ARABIC LETTER THAL' },
	[0x0631] = { unicodeslot=0x0631, category='lo', adobename='afii57425', description='ARABIC LETTER REH' },
	[0x0632] = { unicodeslot=0x0632, category='lo', adobename='afii57426', description='ARABIC LETTER ZAIN' },
	[0x0633] = { unicodeslot=0x0633, category='lo', adobename='afii57427', description='ARABIC LETTER SEEN' },
	[0x0634] = { unicodeslot=0x0634, category='lo', adobename='afii57428', description='ARABIC LETTER SHEEN' },
	[0x0635] = { unicodeslot=0x0635, category='lo', adobename='afii57429', description='ARABIC LETTER SAD' },
	[0x0636] = { unicodeslot=0x0636, category='lo', adobename='afii57430', description='ARABIC LETTER DAD' },
	[0x0637] = { unicodeslot=0x0637, category='lo', adobename='afii57431', description='ARABIC LETTER TAH' },
	[0x0638] = { unicodeslot=0x0638, category='lo', adobename='afii57432', description='ARABIC LETTER ZAH' },
	[0x0639] = { unicodeslot=0x0639, category='lo', adobename='afii57433', description='ARABIC LETTER AIN' },
	[0x063A] = { unicodeslot=0x063A, category='lo', adobename='afii57434', description='ARABIC LETTER GHAIN' },
	[0x0640] = { unicodeslot=0x0640, category='lm', adobename='afii57440', description='ARABIC TATWEEL' },
	[0x0641] = { unicodeslot=0x0641, category='lo', adobename='afii57441', description='ARABIC LETTER FEH' },
	[0x0642] = { unicodeslot=0x0642, category='lo', adobename='afii57442', description='ARABIC LETTER QAF' },
	[0x0643] = { unicodeslot=0x0643, category='lo', adobename='afii57443', description='ARABIC LETTER KAF' },
	[0x0644] = { unicodeslot=0x0644, category='lo', adobename='afii57444', description='ARABIC LETTER LAM' },
	[0x0645] = { unicodeslot=0x0645, category='lo', adobename='afii57445', description='ARABIC LETTER MEEM' },
	[0x0646] = { unicodeslot=0x0646, category='lo', adobename='afii57446', description='ARABIC LETTER NOON' },
	[0x0647] = { unicodeslot=0x0647, category='lo', adobename='afii57470', description='ARABIC LETTER HEH' },
	[0x0648] = { unicodeslot=0x0648, category='lo', adobename='afii57448', description='ARABIC LETTER WAW' },
	[0x0649] = { unicodeslot=0x0649, category='lo', adobename='afii57449', description='ARABIC LETTER ALEF MAKSURA' },
	[0x064A] = { unicodeslot=0x064A, category='lo', adobename='afii57450', description='ARABIC LETTER YEH' },
	[0x064B] = { unicodeslot=0x064B, category='mn', adobename='afii57451', description='ARABIC FATHATAN' },
	[0x064C] = { unicodeslot=0x064C, category='mn', adobename='afii57452', description='ARABIC DAMMATAN' },
	[0x064D] = { unicodeslot=0x064D, category='mn', adobename='afii57453', description='ARABIC KASRATAN' },
	[0x064E] = { unicodeslot=0x064E, category='mn', adobename='afii57454', description='ARABIC FATHA' },
	[0x064F] = { unicodeslot=0x064F, category='mn', adobename='afii57455', description='ARABIC DAMMA' },
	[0x0650] = { unicodeslot=0x0650, category='mn', adobename='afii57456', description='ARABIC KASRA' },
	[0x0651] = { unicodeslot=0x0651, category='mn', adobename='afii57457', description='ARABIC SHADDA' },
	[0x0652] = { unicodeslot=0x0652, category='mn', adobename='afii57458', description='ARABIC SUKUN' },
	[0x0653] = { unicodeslot=0x0653, category='mn', description='ARABIC MADDAH ABOVE' },
	[0x0654] = { unicodeslot=0x0654, category='mn', description='ARABIC HAMZA ABOVE' },
	[0x0655] = { unicodeslot=0x0655, category='mn', description='ARABIC HAMZA BELOW' },
	[0x0656] = { unicodeslot=0x0656, category='mn', description='ARABIC SUBSCRIPT ALEF' },
	[0x0657] = { unicodeslot=0x0657, category='mn', description='ARABIC INVERTED DAMMA' },
	[0x0658] = { unicodeslot=0x0658, category='mn', description='ARABIC MARK NOON GHUNNA' },
	[0x0659] = { unicodeslot=0x0659, category='mn', description='ARABIC ZWARAKAY' },
	[0x065A] = { unicodeslot=0x065A, category='mn', description='ARABIC VOWEL SIGN SMALL V ABOVE' },
	[0x065B] = { unicodeslot=0x065B, category='mn', description='ARABIC VOWEL SIGN INVERTED SMALL V ABOVE' },
	[0x065C] = { unicodeslot=0x065C, category='mn', description='ARABIC VOWEL SIGN DOT BELOW' },
	[0x065D] = { unicodeslot=0x065D, category='mn', description='ARABIC REVERSED DAMMA' },
	[0x065E] = { unicodeslot=0x065E, category='mn', description='ARABIC FATHA WITH TWO DOTS' },
	[0x0660] = { unicodeslot=0x0660, category='nd', adobename='afii57392', description='ARABIC-INDIC DIGIT ZERO' },
	[0x0661] = { unicodeslot=0x0661, category='nd', adobename='afii57393', description='ARABIC-INDIC DIGIT ONE' },
	[0x0662] = { unicodeslot=0x0662, category='nd', adobename='afii57394', description='ARABIC-INDIC DIGIT TWO' },
	[0x0663] = { unicodeslot=0x0663, category='nd', adobename='afii57395', description='ARABIC-INDIC DIGIT THREE' },
	[0x0664] = { unicodeslot=0x0664, category='nd', adobename='afii57396', description='ARABIC-INDIC DIGIT FOUR' },
	[0x0665] = { unicodeslot=0x0665, category='nd', adobename='afii57397', description='ARABIC-INDIC DIGIT FIVE' },
	[0x0666] = { unicodeslot=0x0666, category='nd', adobename='afii57398', description='ARABIC-INDIC DIGIT SIX' },
	[0x0667] = { unicodeslot=0x0667, category='nd', adobename='afii57399', description='ARABIC-INDIC DIGIT SEVEN' },
	[0x0668] = { unicodeslot=0x0668, category='nd', adobename='afii57400', description='ARABIC-INDIC DIGIT EIGHT' },
	[0x0669] = { unicodeslot=0x0669, category='nd', adobename='afii57401', description='ARABIC-INDIC DIGIT NINE' },
	[0x066A] = { unicodeslot=0x066A, category='po', adobename='afii57381', description='ARABIC PERCENT SIGN' },
	[0x066B] = { unicodeslot=0x066B, category='po', description='ARABIC DECIMAL SEPARATOR' },
	[0x066C] = { unicodeslot=0x066C, category='po', description='ARABIC THOUSANDS SEPARATOR' },
	[0x066D] = { unicodeslot=0x066D, category='po', adobename='afii63167', description='ARABIC FIVE POINTED STAR' },
	[0x066E] = { unicodeslot=0x066E, category='lo', description='ARABIC LETTER DOTLESS BEH' },
	[0x066F] = { unicodeslot=0x066F, category='lo', description='ARABIC LETTER DOTLESS QAF' },
	[0x0670] = { unicodeslot=0x0670, category='mn', description='ARABIC LETTER SUPERSCRIPT ALEF' },
	[0x0671] = { unicodeslot=0x0671, category='lo', description='ARABIC LETTER ALEF WASLA' },
	[0x0672] = { unicodeslot=0x0672, category='lo', description='ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE', shcode=0x0627 },
	[0x0673] = { unicodeslot=0x0673, category='lo', description='ARABIC LETTER ALEF WITH WAVY HAMZA BELOW', shcode=0x0627 },
	[0x0674] = { unicodeslot=0x0674, category='lo', description='ARABIC LETTER HIGH HAMZA' },
	[0x0675] = { unicodeslot=0x0675, category='lo', description='ARABIC LETTER HIGH HAMZA ALEF', specials={'compat',0x0627,0x0674} },
	[0x0676] = { unicodeslot=0x0676, category='lo', description='ARABIC LETTER HIGH HAMZA WAW', specials={'compat',0x0648,0x0674} },
	[0x0677] = { unicodeslot=0x0677, category='lo', description='ARABIC LETTER U WITH HAMZA ABOVE', shcode=0x06C7, specials={'compat',0x06C7,0x0674} },
	[0x0678] = { unicodeslot=0x0678, category='lo', description='ARABIC LETTER HIGH HAMZA YEH', specials={'compat',0x064A,0x0674} },
	[0x0679] = { unicodeslot=0x0679, category='lo', adobename='afii57511', description='ARABIC LETTER TTEH' },
	[0x067A] = { unicodeslot=0x067A, category='lo', description='ARABIC LETTER TTEHEH' },
	[0x067B] = { unicodeslot=0x067B, category='lo', description='ARABIC LETTER BEEH' },
	[0x067C] = { unicodeslot=0x067C, category='lo', description='ARABIC LETTER TEH WITH RING', shcode=0x062A },
	[0x067D] = { unicodeslot=0x067D, category='lo', description='ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS', shcode=0x062A },
	[0x067E] = { unicodeslot=0x067E, category='lo', adobename='afii57506', description='ARABIC LETTER PEH' },
	[0x067F] = { unicodeslot=0x067F, category='lo', description='ARABIC LETTER TEHEH' },
	[0x0680] = { unicodeslot=0x0680, category='lo', description='ARABIC LETTER BEHEH' },
	[0x0681] = { unicodeslot=0x0681, category='lo', description='ARABIC LETTER HAH WITH HAMZA ABOVE', shcode=0x062D },
	[0x0682] = { unicodeslot=0x0682, category='lo', description='ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE', shcode=0x062D },
	[0x0683] = { unicodeslot=0x0683, category='lo', description='ARABIC LETTER NYEH' },
	[0x0684] = { unicodeslot=0x0684, category='lo', description='ARABIC LETTER DYEH' },
	[0x0685] = { unicodeslot=0x0685, category='lo', description='ARABIC LETTER HAH WITH THREE DOTS ABOVE', shcode=0x062D },
	[0x0686] = { unicodeslot=0x0686, category='lo', adobename='afii57507', description='ARABIC LETTER TCHEH' },
	[0x0687] = { unicodeslot=0x0687, category='lo', description='ARABIC LETTER TCHEHEH' },
	[0x0688] = { unicodeslot=0x0688, category='lo', adobename='afii57512', description='ARABIC LETTER DDAL' },
	[0x0689] = { unicodeslot=0x0689, category='lo', description='ARABIC LETTER DAL WITH RING', shcode=0x062F },
	[0x068A] = { unicodeslot=0x068A, category='lo', description='ARABIC LETTER DAL WITH DOT BELOW', shcode=0x062F },
	[0x068B] = { unicodeslot=0x068B, category='lo', description='ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH', shcode=0x062F },
	[0x068C] = { unicodeslot=0x068C, category='lo', description='ARABIC LETTER DAHAL' },
	[0x068D] = { unicodeslot=0x068D, category='lo', description='ARABIC LETTER DDAHAL' },
	[0x068E] = { unicodeslot=0x068E, category='lo', description='ARABIC LETTER DUL' },
	[0x068F] = { unicodeslot=0x068F, category='lo', description='ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS', shcode=0x062F },
	[0x0690] = { unicodeslot=0x0690, category='lo', description='ARABIC LETTER DAL WITH FOUR DOTS ABOVE', shcode=0x062F },
	[0x0691] = { unicodeslot=0x0691, category='lo', adobename='afii57513', description='ARABIC LETTER RREH' },
	[0x0692] = { unicodeslot=0x0692, category='lo', description='ARABIC LETTER REH WITH SMALL V', shcode=0x0631 },
	[0x0693] = { unicodeslot=0x0693, category='lo', description='ARABIC LETTER REH WITH RING', shcode=0x0631 },
	[0x0694] = { unicodeslot=0x0694, category='lo', description='ARABIC LETTER REH WITH DOT BELOW', shcode=0x0631 },
	[0x0695] = { unicodeslot=0x0695, category='lo', description='ARABIC LETTER REH WITH SMALL V BELOW', shcode=0x0631 },
	[0x0696] = { unicodeslot=0x0696, category='lo', description='ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE', shcode=0x0631 },
	[0x0697] = { unicodeslot=0x0697, category='lo', description='ARABIC LETTER REH WITH TWO DOTS ABOVE', shcode=0x0631 },
	[0x0698] = { unicodeslot=0x0698, category='lo', adobename='afii57508', description='ARABIC LETTER JEH' },
	[0x0699] = { unicodeslot=0x0699, category='lo', description='ARABIC LETTER REH WITH FOUR DOTS ABOVE', shcode=0x0631 },
	[0x069A] = { unicodeslot=0x069A, category='lo', description='ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE', shcode=0x0633 },
	[0x069B] = { unicodeslot=0x069B, category='lo', description='ARABIC LETTER SEEN WITH THREE DOTS BELOW', shcode=0x0633 },
	[0x069C] = { unicodeslot=0x069C, category='lo', description='ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE', shcode=0x0633 },
	[0x069D] = { unicodeslot=0x069D, category='lo', description='ARABIC LETTER SAD WITH TWO DOTS BELOW', shcode=0x0635 },
	[0x069E] = { unicodeslot=0x069E, category='lo', description='ARABIC LETTER SAD WITH THREE DOTS ABOVE', shcode=0x0635 },
	[0x069F] = { unicodeslot=0x069F, category='lo', description='ARABIC LETTER TAH WITH THREE DOTS ABOVE', shcode=0x0637 },
	[0x06A0] = { unicodeslot=0x06A0, category='lo', description='ARABIC LETTER AIN WITH THREE DOTS ABOVE', shcode=0x0639 },
	[0x06A1] = { unicodeslot=0x06A1, category='lo', description='ARABIC LETTER DOTLESS FEH' },
	[0x06A2] = { unicodeslot=0x06A2, category='lo', description='ARABIC LETTER FEH WITH DOT MOVED BELOW', shcode=0x0641 },
	[0x06A3] = { unicodeslot=0x06A3, category='lo', description='ARABIC LETTER FEH WITH DOT BELOW', shcode=0x0641 },
	[0x06A4] = { unicodeslot=0x06A4, category='lo', adobename='afii57505', description='ARABIC LETTER VEH' },
	[0x06A5] = { unicodeslot=0x06A5, category='lo', description='ARABIC LETTER FEH WITH THREE DOTS BELOW', shcode=0x0641 },
	[0x06A6] = { unicodeslot=0x06A6, category='lo', description='ARABIC LETTER PEHEH' },
	[0x06A7] = { unicodeslot=0x06A7, category='lo', description='ARABIC LETTER QAF WITH DOT ABOVE', shcode=0x0642 },
	[0x06A8] = { unicodeslot=0x06A8, category='lo', description='ARABIC LETTER QAF WITH THREE DOTS ABOVE', shcode=0x0642 },
	[0x06A9] = { unicodeslot=0x06A9, category='lo', description='ARABIC LETTER KEHEH' },
	[0x06AA] = { unicodeslot=0x06AA, category='lo', description='ARABIC LETTER SWASH KAF' },
	[0x06AB] = { unicodeslot=0x06AB, category='lo', description='ARABIC LETTER KAF WITH RING', shcode=0x0643 },
	[0x06AC] = { unicodeslot=0x06AC, category='lo', description='ARABIC LETTER KAF WITH DOT ABOVE', shcode=0x0643 },
	[0x06AD] = { unicodeslot=0x06AD, category='lo', description='ARABIC LETTER NG' },
	[0x06AE] = { unicodeslot=0x06AE, category='lo', description='ARABIC LETTER KAF WITH THREE DOTS BELOW', shcode=0x0643 },
	[0x06AF] = { unicodeslot=0x06AF, category='lo', adobename='afii57509', description='ARABIC LETTER GAF' },
	[0x06B0] = { unicodeslot=0x06B0, category='lo', description='ARABIC LETTER GAF WITH RING', shcode=0x06AF },
	[0x06B1] = { unicodeslot=0x06B1, category='lo', description='ARABIC LETTER NGOEH' },
	[0x06B2] = { unicodeslot=0x06B2, category='lo', description='ARABIC LETTER GAF WITH TWO DOTS BELOW', shcode=0x06AF },
	[0x06B3] = { unicodeslot=0x06B3, category='lo', description='ARABIC LETTER GUEH' },
	[0x06B4] = { unicodeslot=0x06B4, category='lo', description='ARABIC LETTER GAF WITH THREE DOTS ABOVE', shcode=0x06AF },
	[0x06B5] = { unicodeslot=0x06B5, category='lo', description='ARABIC LETTER LAM WITH SMALL V', shcode=0x0644 },
	[0x06B6] = { unicodeslot=0x06B6, category='lo', description='ARABIC LETTER LAM WITH DOT ABOVE', shcode=0x0644 },
	[0x06B7] = { unicodeslot=0x06B7, category='lo', description='ARABIC LETTER LAM WITH THREE DOTS ABOVE', shcode=0x0644 },
	[0x06B8] = { unicodeslot=0x06B8, category='lo', description='ARABIC LETTER LAM WITH THREE DOTS BELOW', shcode=0x0644 },
	[0x06B9] = { unicodeslot=0x06B9, category='lo', description='ARABIC LETTER NOON WITH DOT BELOW', shcode=0x0646 },
	[0x06BA] = { unicodeslot=0x06BA, category='lo', adobename='afii57514', description='ARABIC LETTER NOON GHUNNA' },
	[0x06BB] = { unicodeslot=0x06BB, category='lo', description='ARABIC LETTER RNOON' },
	[0x06BC] = { unicodeslot=0x06BC, category='lo', description='ARABIC LETTER NOON WITH RING', shcode=0x0646 },
	[0x06BD] = { unicodeslot=0x06BD, category='lo', description='ARABIC LETTER NOON WITH THREE DOTS ABOVE', shcode=0x0646 },
	[0x06BE] = { unicodeslot=0x06BE, category='lo', description='ARABIC LETTER HEH DOACHASHMEE' },
	[0x06BF] = { unicodeslot=0x06BF, category='lo', description='ARABIC LETTER TCHEH WITH DOT ABOVE', shcode=0x0686 },
	[0x06C0] = { unicodeslot=0x06C0, category='lo', description='ARABIC LETTER HEH WITH YEH ABOVE', shcode=0x0647, specials={'char',0x06D5,0x0654} },
	[0x06C1] = { unicodeslot=0x06C1, category='lo', description='ARABIC LETTER HEH GOAL' },
	[0x06C2] = { unicodeslot=0x06C2, category='lo', description='ARABIC LETTER HEH GOAL WITH HAMZA ABOVE', specials={'char',0x06C1,0x0654} },
	[0x06C3] = { unicodeslot=0x06C3, category='lo', description='ARABIC LETTER TEH MARBUTA GOAL' },
	[0x06C4] = { unicodeslot=0x06C4, category='lo', description='ARABIC LETTER WAW WITH RING', shcode=0x0648 },
	[0x06C5] = { unicodeslot=0x06C5, category='lo', description='ARABIC LETTER KIRGHIZ OE' },
	[0x06C6] = { unicodeslot=0x06C6, category='lo', description='ARABIC LETTER OE' },
	[0x06C7] = { unicodeslot=0x06C7, category='lo', description='ARABIC LETTER U' },
	[0x06C8] = { unicodeslot=0x06C8, category='lo', description='ARABIC LETTER YU' },
	[0x06C9] = { unicodeslot=0x06C9, category='lo', description='ARABIC LETTER KIRGHIZ YU' },
	[0x06CA] = { unicodeslot=0x06CA, category='lo', description='ARABIC LETTER WAW WITH TWO DOTS ABOVE', shcode=0x0648 },
	[0x06CB] = { unicodeslot=0x06CB, category='lo', description='ARABIC LETTER VE' },
	[0x06CC] = { unicodeslot=0x06CC, category='lo', description='ARABIC LETTER FARSI YEH' },
	[0x06CD] = { unicodeslot=0x06CD, category='lo', description='ARABIC LETTER YEH WITH TAIL', shcode=0x064A },
	[0x06CE] = { unicodeslot=0x06CE, category='lo', description='ARABIC LETTER YEH WITH SMALL V', shcode=0x064A },
	[0x06CF] = { unicodeslot=0x06CF, category='lo', description='ARABIC LETTER WAW WITH DOT ABOVE', shcode=0x0648 },
	[0x06D0] = { unicodeslot=0x06D0, category='lo', description='ARABIC LETTER E' },
	[0x06D1] = { unicodeslot=0x06D1, category='lo', description='ARABIC LETTER YEH WITH THREE DOTS BELOW', shcode=0x064A },
	[0x06D2] = { unicodeslot=0x06D2, category='lo', adobename='afii57519', description='ARABIC LETTER YEH BARREE' },
	[0x06D3] = { unicodeslot=0x06D3, category='lo', description='ARABIC LETTER YEH BARREE WITH HAMZA ABOVE', specials={'char',0x06D2,0x0654} },
	[0x06D4] = { unicodeslot=0x06D4, category='po', description='ARABIC FULL STOP' },
	[0x06D5] = { unicodeslot=0x06D5, category='lo', adobename='afii57534', description='ARABIC LETTER AE' },
	[0x06D6] = { unicodeslot=0x06D6, category='mn', description='ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA' },
	[0x06D7] = { unicodeslot=0x06D7, category='mn', description='ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA' },
	[0x06D8] = { unicodeslot=0x06D8, category='mn', description='ARABIC SMALL HIGH MEEM INITIAL FORM' },
	[0x06D9] = { unicodeslot=0x06D9, category='mn', description='ARABIC SMALL HIGH LAM ALEF' },
	[0x06DA] = { unicodeslot=0x06DA, category='mn', description='ARABIC SMALL HIGH JEEM' },
	[0x06DB] = { unicodeslot=0x06DB, category='mn', description='ARABIC SMALL HIGH THREE DOTS' },
	[0x06DC] = { unicodeslot=0x06DC, category='mn', description='ARABIC SMALL HIGH SEEN' },
	[0x06DD] = { unicodeslot=0x06DD, category='cf', description='ARABIC END OF AYAH' },
	[0x06DE] = { unicodeslot=0x06DE, category='me', description='ARABIC START OF RUB EL HIZB' },
	[0x06DF] = { unicodeslot=0x06DF, category='mn', description='ARABIC SMALL HIGH ROUNDED ZERO' },
	[0x06E0] = { unicodeslot=0x06E0, category='mn', description='ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO' },
	[0x06E1] = { unicodeslot=0x06E1, category='mn', description='ARABIC SMALL HIGH DOTLESS HEAD OF KHAH' },
	[0x06E2] = { unicodeslot=0x06E2, category='mn', description='ARABIC SMALL HIGH MEEM ISOLATED FORM' },
	[0x06E3] = { unicodeslot=0x06E3, category='mn', description='ARABIC SMALL LOW SEEN' },
	[0x06E4] = { unicodeslot=0x06E4, category='mn', description='ARABIC SMALL HIGH MADDA' },
	[0x06E5] = { unicodeslot=0x06E5, category='lm', description='ARABIC SMALL WAW' },
	[0x06E6] = { unicodeslot=0x06E6, category='lm', description='ARABIC SMALL YEH' },
	[0x06E7] = { unicodeslot=0x06E7, category='mn', description='ARABIC SMALL HIGH YEH' },
	[0x06E8] = { unicodeslot=0x06E8, category='mn', description='ARABIC SMALL HIGH NOON' },
	[0x06E9] = { unicodeslot=0x06E9, category='so', description='ARABIC PLACE OF SAJDAH' },
	[0x06EA] = { unicodeslot=0x06EA, category='mn', description='ARABIC EMPTY CENTRE LOW STOP' },
	[0x06EB] = { unicodeslot=0x06EB, category='mn', description='ARABIC EMPTY CENTRE HIGH STOP' },
	[0x06EC] = { unicodeslot=0x06EC, category='mn', description='ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE' },
	[0x06ED] = { unicodeslot=0x06ED, category='mn', description='ARABIC SMALL LOW MEEM' },
	[0x06EE] = { unicodeslot=0x06EE, category='lo', description='ARABIC LETTER DAL WITH INVERTED V', shcode=0x062F },
	[0x06EF] = { unicodeslot=0x06EF, category='lo', description='ARABIC LETTER REH WITH INVERTED V', shcode=0x0631 },
	[0x06F0] = { unicodeslot=0x06F0, category='nd', description='EXTENDED ARABIC-INDIC DIGIT ZERO' },
	[0x06F1] = { unicodeslot=0x06F1, category='nd', description='EXTENDED ARABIC-INDIC DIGIT ONE' },
	[0x06F2] = { unicodeslot=0x06F2, category='nd', description='EXTENDED ARABIC-INDIC DIGIT TWO' },
	[0x06F3] = { unicodeslot=0x06F3, category='nd', description='EXTENDED ARABIC-INDIC DIGIT THREE' },
	[0x06F4] = { unicodeslot=0x06F4, category='nd', description='EXTENDED ARABIC-INDIC DIGIT FOUR' },
	[0x06F5] = { unicodeslot=0x06F5, category='nd', description='EXTENDED ARABIC-INDIC DIGIT FIVE' },
	[0x06F6] = { unicodeslot=0x06F6, category='nd', description='EXTENDED ARABIC-INDIC DIGIT SIX' },
	[0x06F7] = { unicodeslot=0x06F7, category='nd', description='EXTENDED ARABIC-INDIC DIGIT SEVEN' },
	[0x06F8] = { unicodeslot=0x06F8, category='nd', description='EXTENDED ARABIC-INDIC DIGIT EIGHT' },
	[0x06F9] = { unicodeslot=0x06F9, category='nd', description='EXTENDED ARABIC-INDIC DIGIT NINE' },
	[0x06FA] = { unicodeslot=0x06FA, category='lo', description='ARABIC LETTER SHEEN WITH DOT BELOW', shcode=0x0634 },
	[0x06FB] = { unicodeslot=0x06FB, category='lo', description='ARABIC LETTER DAD WITH DOT BELOW', shcode=0x0636 },
	[0x06FC] = { unicodeslot=0x06FC, category='lo', description='ARABIC LETTER GHAIN WITH DOT BELOW', shcode=0x063A },
	[0x06FD] = { unicodeslot=0x06FD, category='so', description='ARABIC SIGN SINDHI AMPERSAND' },
	[0x06FE] = { unicodeslot=0x06FE, category='so', description='ARABIC SIGN SINDHI POSTPOSITION MEN' },
	[0x06FF] = { unicodeslot=0x06FF, category='lo', description='ARABIC LETTER HEH WITH INVERTED V', shcode=0x0647 },
	[0x0700] = { unicodeslot=0x0700, category='po', description='SYRIAC END OF PARAGRAPH' },
	[0x0701] = { unicodeslot=0x0701, category='po', description='SYRIAC SUPRALINEAR FULL STOP' },
	[0x0702] = { unicodeslot=0x0702, category='po', description='SYRIAC SUBLINEAR FULL STOP' },
	[0x0703] = { unicodeslot=0x0703, category='po', description='SYRIAC SUPRALINEAR COLON' },
	[0x0704] = { unicodeslot=0x0704, category='po', description='SYRIAC SUBLINEAR COLON' },
	[0x0705] = { unicodeslot=0x0705, category='po', description='SYRIAC HORIZONTAL COLON' },
	[0x0706] = { unicodeslot=0x0706, category='po', description='SYRIAC COLON SKEWED LEFT' },
	[0x0707] = { unicodeslot=0x0707, category='po', description='SYRIAC COLON SKEWED RIGHT' },
	[0x0708] = { unicodeslot=0x0708, category='po', description='SYRIAC SUPRALINEAR COLON SKEWED LEFT' },
	[0x0709] = { unicodeslot=0x0709, category='po', description='SYRIAC SUBLINEAR COLON SKEWED RIGHT' },
	[0x070A] = { unicodeslot=0x070A, category='po', description='SYRIAC CONTRACTION' },
	[0x070B] = { unicodeslot=0x070B, category='po', description='SYRIAC HARKLEAN OBELUS' },
	[0x070C] = { unicodeslot=0x070C, category='po', description='SYRIAC HARKLEAN METOBELUS' },
	[0x070D] = { unicodeslot=0x070D, category='po', description='SYRIAC HARKLEAN ASTERISCUS' },
	[0x070F] = { unicodeslot=0x070F, category='cf', description='SYRIAC ABBREVIATION MARK' },
	[0x0710] = { unicodeslot=0x0710, category='lo', description='SYRIAC LETTER ALAPH' },
	[0x0711] = { unicodeslot=0x0711, category='mn', description='SYRIAC LETTER SUPERSCRIPT ALAPH' },
	[0x0712] = { unicodeslot=0x0712, category='lo', description='SYRIAC LETTER BETH' },
	[0x0713] = { unicodeslot=0x0713, category='lo', description='SYRIAC LETTER GAMAL' },
	[0x0714] = { unicodeslot=0x0714, category='lo', description='SYRIAC LETTER GAMAL GARSHUNI' },
	[0x0715] = { unicodeslot=0x0715, category='lo', description='SYRIAC LETTER DALATH' },
	[0x0716] = { unicodeslot=0x0716, category='lo', description='SYRIAC LETTER DOTLESS DALATH RISH' },
	[0x0717] = { unicodeslot=0x0717, category='lo', description='SYRIAC LETTER HE' },
	[0x0718] = { unicodeslot=0x0718, category='lo', description='SYRIAC LETTER WAW' },
	[0x0719] = { unicodeslot=0x0719, category='lo', description='SYRIAC LETTER ZAIN' },
	[0x071A] = { unicodeslot=0x071A, category='lo', description='SYRIAC LETTER HETH' },
	[0x071B] = { unicodeslot=0x071B, category='lo', description='SYRIAC LETTER TETH' },
	[0x071C] = { unicodeslot=0x071C, category='lo', description='SYRIAC LETTER TETH GARSHUNI' },
	[0x071D] = { unicodeslot=0x071D, category='lo', description='SYRIAC LETTER YUDH' },
	[0x071E] = { unicodeslot=0x071E, category='lo', description='SYRIAC LETTER YUDH HE' },
	[0x071F] = { unicodeslot=0x071F, category='lo', description='SYRIAC LETTER KAPH' },
	[0x0720] = { unicodeslot=0x0720, category='lo', description='SYRIAC LETTER LAMADH' },
	[0x0721] = { unicodeslot=0x0721, category='lo', description='SYRIAC LETTER MIM' },
	[0x0722] = { unicodeslot=0x0722, category='lo', description='SYRIAC LETTER NUN' },
	[0x0723] = { unicodeslot=0x0723, category='lo', description='SYRIAC LETTER SEMKATH' },
	[0x0724] = { unicodeslot=0x0724, category='lo', description='SYRIAC LETTER FINAL SEMKATH' },
	[0x0725] = { unicodeslot=0x0725, category='lo', description='SYRIAC LETTER E' },
	[0x0726] = { unicodeslot=0x0726, category='lo', description='SYRIAC LETTER PE' },
	[0x0727] = { unicodeslot=0x0727, category='lo', description='SYRIAC LETTER REVERSED PE' },
	[0x0728] = { unicodeslot=0x0728, category='lo', description='SYRIAC LETTER SADHE' },
	[0x0729] = { unicodeslot=0x0729, category='lo', description='SYRIAC LETTER QAPH' },
	[0x072A] = { unicodeslot=0x072A, category='lo', description='SYRIAC LETTER RISH' },
	[0x072B] = { unicodeslot=0x072B, category='lo', description='SYRIAC LETTER SHIN' },
	[0x072C] = { unicodeslot=0x072C, category='lo', description='SYRIAC LETTER TAW' },
	[0x072D] = { unicodeslot=0x072D, category='lo', description='SYRIAC LETTER PERSIAN BHETH' },
	[0x072E] = { unicodeslot=0x072E, category='lo', description='SYRIAC LETTER PERSIAN GHAMAL' },
	[0x072F] = { unicodeslot=0x072F, category='lo', description='SYRIAC LETTER PERSIAN DHALATH' },
	[0x0730] = { unicodeslot=0x0730, category='mn', description='SYRIAC PTHAHA ABOVE' },
	[0x0731] = { unicodeslot=0x0731, category='mn', description='SYRIAC PTHAHA BELOW' },
	[0x0732] = { unicodeslot=0x0732, category='mn', description='SYRIAC PTHAHA DOTTED' },
	[0x0733] = { unicodeslot=0x0733, category='mn', description='SYRIAC ZQAPHA ABOVE' },
	[0x0734] = { unicodeslot=0x0734, category='mn', description='SYRIAC ZQAPHA BELOW' },
	[0x0735] = { unicodeslot=0x0735, category='mn', description='SYRIAC ZQAPHA DOTTED' },
	[0x0736] = { unicodeslot=0x0736, category='mn', description='SYRIAC RBASA ABOVE' },
	[0x0737] = { unicodeslot=0x0737, category='mn', description='SYRIAC RBASA BELOW' },
	[0x0738] = { unicodeslot=0x0738, category='mn', description='SYRIAC DOTTED ZLAMA HORIZONTAL' },
	[0x0739] = { unicodeslot=0x0739, category='mn', description='SYRIAC DOTTED ZLAMA ANGULAR' },
	[0x073A] = { unicodeslot=0x073A, category='mn', description='SYRIAC HBASA ABOVE' },
	[0x073B] = { unicodeslot=0x073B, category='mn', description='SYRIAC HBASA BELOW' },
	[0x073C] = { unicodeslot=0x073C, category='mn', description='SYRIAC HBASA-ESASA DOTTED' },
	[0x073D] = { unicodeslot=0x073D, category='mn', description='SYRIAC ESASA ABOVE' },
	[0x073E] = { unicodeslot=0x073E, category='mn', description='SYRIAC ESASA BELOW' },
	[0x073F] = { unicodeslot=0x073F, category='mn', description='SYRIAC RWAHA' },
	[0x0740] = { unicodeslot=0x0740, category='mn', description='SYRIAC FEMININE DOT' },
	[0x0741] = { unicodeslot=0x0741, category='mn', description='SYRIAC QUSHSHAYA' },
	[0x0742] = { unicodeslot=0x0742, category='mn', description='SYRIAC RUKKAKHA' },
	[0x0743] = { unicodeslot=0x0743, category='mn', description='SYRIAC TWO VERTICAL DOTS ABOVE' },
	[0x0744] = { unicodeslot=0x0744, category='mn', description='SYRIAC TWO VERTICAL DOTS BELOW' },
	[0x0745] = { unicodeslot=0x0745, category='mn', description='SYRIAC THREE DOTS ABOVE' },
	[0x0746] = { unicodeslot=0x0746, category='mn', description='SYRIAC THREE DOTS BELOW' },
	[0x0747] = { unicodeslot=0x0747, category='mn', description='SYRIAC OBLIQUE LINE ABOVE' },
	[0x0748] = { unicodeslot=0x0748, category='mn', description='SYRIAC OBLIQUE LINE BELOW' },
	[0x0749] = { unicodeslot=0x0749, category='mn', description='SYRIAC MUSIC' },
	[0x074A] = { unicodeslot=0x074A, category='mn', description='SYRIAC BARREKH' },
	[0x074D] = { unicodeslot=0x074D, category='lo', description='SYRIAC LETTER SOGDIAN ZHAIN' },
	[0x074E] = { unicodeslot=0x074E, category='lo', description='SYRIAC LETTER SOGDIAN KHAPH' },
	[0x074F] = { unicodeslot=0x074F, category='lo', description='SYRIAC LETTER SOGDIAN FE' },
	[0x0750] = { unicodeslot=0x0750, category='lo', description='ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW', shcode=0x0628 },
	[0x0751] = { unicodeslot=0x0751, category='lo', description='ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE', shcode=0x0628 },
	[0x0752] = { unicodeslot=0x0752, category='lo', description='ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW', shcode=0x0628 },
	[0x0753] = { unicodeslot=0x0753, category='lo', description='ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE', shcode=0x0628 },
	[0x0754] = { unicodeslot=0x0754, category='lo', description='ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE', shcode=0x0628 },
	[0x0755] = { unicodeslot=0x0755, category='lo', description='ARABIC LETTER BEH WITH INVERTED SMALL V BELOW', shcode=0x0628 },
	[0x0756] = { unicodeslot=0x0756, category='lo', description='ARABIC LETTER BEH WITH SMALL V', shcode=0x0628 },
	[0x0757] = { unicodeslot=0x0757, category='lo', description='ARABIC LETTER HAH WITH TWO DOTS ABOVE', shcode=0x062D },
	[0x0758] = { unicodeslot=0x0758, category='lo', description='ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW', shcode=0x062D },
	[0x0759] = { unicodeslot=0x0759, category='lo', description='ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH', shcode=0x062F },
	[0x075A] = { unicodeslot=0x075A, category='lo', description='ARABIC LETTER DAL WITH INVERTED SMALL V BELOW', shcode=0x062F },
	[0x075B] = { unicodeslot=0x075B, category='lo', description='ARABIC LETTER REH WITH STROKE', shcode=0x0631 },
	[0x075C] = { unicodeslot=0x075C, category='lo', description='ARABIC LETTER SEEN WITH FOUR DOTS ABOVE', shcode=0x0633 },
	[0x075D] = { unicodeslot=0x075D, category='lo', description='ARABIC LETTER AIN WITH TWO DOTS ABOVE', shcode=0x0639 },
	[0x075E] = { unicodeslot=0x075E, category='lo', description='ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE', shcode=0x0639 },
	[0x075F] = { unicodeslot=0x075F, category='lo', description='ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE', shcode=0x0639 },
	[0x0760] = { unicodeslot=0x0760, category='lo', description='ARABIC LETTER FEH WITH TWO DOTS BELOW', shcode=0x0641 },
	[0x0761] = { unicodeslot=0x0761, category='lo', description='ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW', shcode=0x0641 },
	[0x0762] = { unicodeslot=0x0762, category='lo', description='ARABIC LETTER KEHEH WITH DOT ABOVE', shcode=0x06A9 },
	[0x0763] = { unicodeslot=0x0763, category='lo', description='ARABIC LETTER KEHEH WITH THREE DOTS ABOVE', shcode=0x06A9 },
	[0x0764] = { unicodeslot=0x0764, category='lo', description='ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW', shcode=0x06A9 },
	[0x0765] = { unicodeslot=0x0765, category='lo', description='ARABIC LETTER MEEM WITH DOT ABOVE', shcode=0x0645 },
	[0x0766] = { unicodeslot=0x0766, category='lo', description='ARABIC LETTER MEEM WITH DOT BELOW', shcode=0x0645 },
	[0x0767] = { unicodeslot=0x0767, category='lo', description='ARABIC LETTER NOON WITH TWO DOTS BELOW', shcode=0x0646 },
	[0x0768] = { unicodeslot=0x0768, category='lo', description='ARABIC LETTER NOON WITH SMALL TAH', shcode=0x0646 },
	[0x0769] = { unicodeslot=0x0769, category='lo', description='ARABIC LETTER NOON WITH SMALL V', shcode=0x0646 },
	[0x076A] = { unicodeslot=0x076A, category='lo', description='ARABIC LETTER LAM WITH BAR', shcode=0x0644 },
	[0x076B] = { unicodeslot=0x076B, category='lo', description='ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE', shcode=0x0631 },
	[0x076C] = { unicodeslot=0x076C, category='lo', description='ARABIC LETTER REH WITH HAMZA ABOVE', shcode=0x0631 },
	[0x076D] = { unicodeslot=0x076D, category='lo', description='ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE', shcode=0x0633 },
	[0x0780] = { unicodeslot=0x0780, category='lo', description='THAANA LETTER HAA' },
	[0x0781] = { unicodeslot=0x0781, category='lo', description='THAANA LETTER SHAVIYANI' },
	[0x0782] = { unicodeslot=0x0782, category='lo', description='THAANA LETTER NOONU' },
	[0x0783] = { unicodeslot=0x0783, category='lo', description='THAANA LETTER RAA' },
	[0x0784] = { unicodeslot=0x0784, category='lo', description='THAANA LETTER BAA' },
	[0x0785] = { unicodeslot=0x0785, category='lo', description='THAANA LETTER LHAVIYANI' },
	[0x0786] = { unicodeslot=0x0786, category='lo', description='THAANA LETTER KAAFU' },
	[0x0787] = { unicodeslot=0x0787, category='lo', description='THAANA LETTER ALIFU' },
	[0x0788] = { unicodeslot=0x0788, category='lo', description='THAANA LETTER VAAVU' },
	[0x0789] = { unicodeslot=0x0789, category='lo', description='THAANA LETTER MEEMU' },
	[0x078A] = { unicodeslot=0x078A, category='lo', description='THAANA LETTER FAAFU' },
	[0x078B] = { unicodeslot=0x078B, category='lo', description='THAANA LETTER DHAALU' },
	[0x078C] = { unicodeslot=0x078C, category='lo', description='THAANA LETTER THAA' },
	[0x078D] = { unicodeslot=0x078D, category='lo', description='THAANA LETTER LAAMU' },
	[0x078E] = { unicodeslot=0x078E, category='lo', description='THAANA LETTER GAAFU' },
	[0x078F] = { unicodeslot=0x078F, category='lo', description='THAANA LETTER GNAVIYANI' },
	[0x0790] = { unicodeslot=0x0790, category='lo', description='THAANA LETTER SEENU' },
	[0x0791] = { unicodeslot=0x0791, category='lo', description='THAANA LETTER DAVIYANI' },
	[0x0792] = { unicodeslot=0x0792, category='lo', description='THAANA LETTER ZAVIYANI' },
	[0x0793] = { unicodeslot=0x0793, category='lo', description='THAANA LETTER TAVIYANI' },
	[0x0794] = { unicodeslot=0x0794, category='lo', description='THAANA LETTER YAA' },
	[0x0795] = { unicodeslot=0x0795, category='lo', description='THAANA LETTER PAVIYANI' },
	[0x0796] = { unicodeslot=0x0796, category='lo', description='THAANA LETTER JAVIYANI' },
	[0x0797] = { unicodeslot=0x0797, category='lo', description='THAANA LETTER CHAVIYANI' },
	[0x0798] = { unicodeslot=0x0798, category='lo', description='THAANA LETTER TTAA' },
	[0x0799] = { unicodeslot=0x0799, category='lo', description='THAANA LETTER HHAA' },
	[0x079A] = { unicodeslot=0x079A, category='lo', description='THAANA LETTER KHAA' },
	[0x079B] = { unicodeslot=0x079B, category='lo', description='THAANA LETTER THAALU' },
	[0x079C] = { unicodeslot=0x079C, category='lo', description='THAANA LETTER ZAA' },
	[0x079D] = { unicodeslot=0x079D, category='lo', description='THAANA LETTER SHEENU' },
	[0x079E] = { unicodeslot=0x079E, category='lo', description='THAANA LETTER SAADHU' },
	[0x079F] = { unicodeslot=0x079F, category='lo', description='THAANA LETTER DAADHU' },
	[0x07A0] = { unicodeslot=0x07A0, category='lo', description='THAANA LETTER TO' },
	[0x07A1] = { unicodeslot=0x07A1, category='lo', description='THAANA LETTER ZO' },
	[0x07A2] = { unicodeslot=0x07A2, category='lo', description='THAANA LETTER AINU' },
	[0x07A3] = { unicodeslot=0x07A3, category='lo', description='THAANA LETTER GHAINU' },
	[0x07A4] = { unicodeslot=0x07A4, category='lo', description='THAANA LETTER QAAFU' },
	[0x07A5] = { unicodeslot=0x07A5, category='lo', description='THAANA LETTER WAAVU' },
	[0x07A6] = { unicodeslot=0x07A6, category='mn', description='THAANA ABAFILI' },
	[0x07A7] = { unicodeslot=0x07A7, category='mn', description='THAANA AABAAFILI' },
	[0x07A8] = { unicodeslot=0x07A8, category='mn', description='THAANA IBIFILI' },
	[0x07A9] = { unicodeslot=0x07A9, category='mn', description='THAANA EEBEEFILI' },
	[0x07AA] = { unicodeslot=0x07AA, category='mn', description='THAANA UBUFILI' },
	[0x07AB] = { unicodeslot=0x07AB, category='mn', description='THAANA OOBOOFILI' },
	[0x07AC] = { unicodeslot=0x07AC, category='mn', description='THAANA EBEFILI' },
	[0x07AD] = { unicodeslot=0x07AD, category='mn', description='THAANA EYBEYFILI' },
	[0x07AE] = { unicodeslot=0x07AE, category='mn', description='THAANA OBOFILI' },
	[0x07AF] = { unicodeslot=0x07AF, category='mn', description='THAANA OABOAFILI' },
	[0x07B0] = { unicodeslot=0x07B0, category='mn', description='THAANA SUKUN' },
	[0x07B1] = { unicodeslot=0x07B1, category='lo', description='THAANA LETTER NAA' },
	[0x07C0] = { unicodeslot=0x07C0, category='nd', description='NKO DIGIT ZERO' },
	[0x07C1] = { unicodeslot=0x07C1, category='nd', description='NKO DIGIT ONE' },
	[0x07C2] = { unicodeslot=0x07C2, category='nd', description='NKO DIGIT TWO' },
	[0x07C3] = { unicodeslot=0x07C3, category='nd', description='NKO DIGIT THREE' },
	[0x07C4] = { unicodeslot=0x07C4, category='nd', description='NKO DIGIT FOUR' },
	[0x07C5] = { unicodeslot=0x07C5, category='nd', description='NKO DIGIT FIVE' },
	[0x07C6] = { unicodeslot=0x07C6, category='nd', description='NKO DIGIT SIX' },
	[0x07C7] = { unicodeslot=0x07C7, category='nd', description='NKO DIGIT SEVEN' },
	[0x07C8] = { unicodeslot=0x07C8, category='nd', description='NKO DIGIT EIGHT' },
	[0x07C9] = { unicodeslot=0x07C9, category='nd', description='NKO DIGIT NINE' },
	[0x07CA] = { unicodeslot=0x07CA, category='lo', description='NKO LETTER A' },
	[0x07CB] = { unicodeslot=0x07CB, category='lo', description='NKO LETTER EE' },
	[0x07CC] = { unicodeslot=0x07CC, category='lo', description='NKO LETTER I' },
	[0x07CD] = { unicodeslot=0x07CD, category='lo', description='NKO LETTER E' },
	[0x07CE] = { unicodeslot=0x07CE, category='lo', description='NKO LETTER U' },
	[0x07CF] = { unicodeslot=0x07CF, category='lo', description='NKO LETTER OO' },
	[0x07D0] = { unicodeslot=0x07D0, category='lo', description='NKO LETTER O' },
	[0x07D1] = { unicodeslot=0x07D1, category='lo', description='NKO LETTER DAGBASINNA' },
	[0x07D2] = { unicodeslot=0x07D2, category='lo', description='NKO LETTER N' },
	[0x07D3] = { unicodeslot=0x07D3, category='lo', description='NKO LETTER BA' },
	[0x07D4] = { unicodeslot=0x07D4, category='lo', description='NKO LETTER PA' },
	[0x07D5] = { unicodeslot=0x07D5, category='lo', description='NKO LETTER TA' },
	[0x07D6] = { unicodeslot=0x07D6, category='lo', description='NKO LETTER JA' },
	[0x07D7] = { unicodeslot=0x07D7, category='lo', description='NKO LETTER CHA' },
	[0x07D8] = { unicodeslot=0x07D8, category='lo', description='NKO LETTER DA' },
	[0x07D9] = { unicodeslot=0x07D9, category='lo', description='NKO LETTER RA' },
	[0x07DA] = { unicodeslot=0x07DA, category='lo', description='NKO LETTER RRA' },
	[0x07DB] = { unicodeslot=0x07DB, category='lo', description='NKO LETTER SA' },
	[0x07DC] = { unicodeslot=0x07DC, category='lo', description='NKO LETTER GBA' },
	[0x07DD] = { unicodeslot=0x07DD, category='lo', description='NKO LETTER FA' },
	[0x07DE] = { unicodeslot=0x07DE, category='lo', description='NKO LETTER KA' },
	[0x07DF] = { unicodeslot=0x07DF, category='lo', description='NKO LETTER LA' },
	[0x07E0] = { unicodeslot=0x07E0, category='lo', description='NKO LETTER NA WOLOSO' },
	[0x07E1] = { unicodeslot=0x07E1, category='lo', description='NKO LETTER MA' },
	[0x07E2] = { unicodeslot=0x07E2, category='lo', description='NKO LETTER NYA' },
	[0x07E3] = { unicodeslot=0x07E3, category='lo', description='NKO LETTER NA' },
	[0x07E4] = { unicodeslot=0x07E4, category='lo', description='NKO LETTER HA' },
	[0x07E5] = { unicodeslot=0x07E5, category='lo', description='NKO LETTER WA' },
	[0x07E6] = { unicodeslot=0x07E6, category='lo', description='NKO LETTER YA' },
	[0x07E7] = { unicodeslot=0x07E7, category='lo', description='NKO LETTER NYA WOLOSO' },
	[0x07E8] = { unicodeslot=0x07E8, category='lo', description='NKO LETTER JONA JA' },
	[0x07E9] = { unicodeslot=0x07E9, category='lo', description='NKO LETTER JONA CHA' },
	[0x07EA] = { unicodeslot=0x07EA, category='lo', description='NKO LETTER JONA RA' },
	[0x07EB] = { unicodeslot=0x07EB, category='mn', description='NKO COMBINING SHORT HIGH TONE' },
	[0x07EC] = { unicodeslot=0x07EC, category='mn', description='NKO COMBINING SHORT LOW TONE' },
	[0x07ED] = { unicodeslot=0x07ED, category='mn', description='NKO COMBINING SHORT RISING TONE' },
	[0x07EE] = { unicodeslot=0x07EE, category='mn', description='NKO COMBINING LONG DESCENDING TONE' },
	[0x07EF] = { unicodeslot=0x07EF, category='mn', description='NKO COMBINING LONG HIGH TONE' },
	[0x07F0] = { unicodeslot=0x07F0, category='mn', description='NKO COMBINING LONG LOW TONE' },
	[0x07F1] = { unicodeslot=0x07F1, category='mn', description='NKO COMBINING LONG RISING TONE' },
	[0x07F2] = { unicodeslot=0x07F2, category='mn', description='NKO COMBINING NASALIZATION MARK' },
	[0x07F3] = { unicodeslot=0x07F3, category='mn', description='NKO COMBINING DOUBLE DOT ABOVE' },
	[0x07F4] = { unicodeslot=0x07F4, category='lm', description='NKO HIGH TONE APOSTROPHE' },
	[0x07F5] = { unicodeslot=0x07F5, category='lm', description='NKO LOW TONE APOSTROPHE' },
	[0x07F6] = { unicodeslot=0x07F6, category='so', description='NKO SYMBOL OO DENNEN' },
	[0x07F7] = { unicodeslot=0x07F7, category='po', description='NKO SYMBOL GBAKURUNEN' },
	[0x07F8] = { unicodeslot=0x07F8, category='po', description='NKO COMMA' },
	[0x07F9] = { unicodeslot=0x07F9, category='po', description='NKO EXCLAMATION MARK' },
	[0x07FA] = { unicodeslot=0x07FA, category='lm', description='NKO LAJANYALAN' },
	[0x0901] = { unicodeslot=0x0901, category='mn', description='DEVANAGARI SIGN CANDRABINDU' },
	[0x0902] = { unicodeslot=0x0902, category='mn', description='DEVANAGARI SIGN ANUSVARA' },
	[0x0903] = { unicodeslot=0x0903, category='mc', description='DEVANAGARI SIGN VISARGA' },
	[0x0904] = { unicodeslot=0x0904, category='lo', description='DEVANAGARI LETTER SHORT A' },
	[0x0905] = { unicodeslot=0x0905, category='lo', description='DEVANAGARI LETTER A' },
	[0x0906] = { unicodeslot=0x0906, category='lo', description='DEVANAGARI LETTER AA' },
	[0x0907] = { unicodeslot=0x0907, category='lo', description='DEVANAGARI LETTER I' },
	[0x0908] = { unicodeslot=0x0908, category='lo', description='DEVANAGARI LETTER II' },
	[0x0909] = { unicodeslot=0x0909, category='lo', description='DEVANAGARI LETTER U' },
	[0x090A] = { unicodeslot=0x090A, category='lo', description='DEVANAGARI LETTER UU' },
	[0x090B] = { unicodeslot=0x090B, category='lo', description='DEVANAGARI LETTER VOCALIC R' },
	[0x090C] = { unicodeslot=0x090C, category='lo', description='DEVANAGARI LETTER VOCALIC L' },
	[0x090D] = { unicodeslot=0x090D, category='lo', description='DEVANAGARI LETTER CANDRA E' },
	[0x090E] = { unicodeslot=0x090E, category='lo', description='DEVANAGARI LETTER SHORT E' },
	[0x090F] = { unicodeslot=0x090F, category='lo', description='DEVANAGARI LETTER E' },
	[0x0910] = { unicodeslot=0x0910, category='lo', description='DEVANAGARI LETTER AI' },
	[0x0911] = { unicodeslot=0x0911, category='lo', description='DEVANAGARI LETTER CANDRA O' },
	[0x0912] = { unicodeslot=0x0912, category='lo', description='DEVANAGARI LETTER SHORT O' },
	[0x0913] = { unicodeslot=0x0913, category='lo', description='DEVANAGARI LETTER O' },
	[0x0914] = { unicodeslot=0x0914, category='lo', description='DEVANAGARI LETTER AU' },
	[0x0915] = { unicodeslot=0x0915, category='lo', description='DEVANAGARI LETTER KA' },
	[0x0916] = { unicodeslot=0x0916, category='lo', description='DEVANAGARI LETTER KHA' },
	[0x0917] = { unicodeslot=0x0917, category='lo', description='DEVANAGARI LETTER GA' },
	[0x0918] = { unicodeslot=0x0918, category='lo', description='DEVANAGARI LETTER GHA' },
	[0x0919] = { unicodeslot=0x0919, category='lo', description='DEVANAGARI LETTER NGA' },
	[0x091A] = { unicodeslot=0x091A, category='lo', description='DEVANAGARI LETTER CA' },
	[0x091B] = { unicodeslot=0x091B, category='lo', description='DEVANAGARI LETTER CHA' },
	[0x091C] = { unicodeslot=0x091C, category='lo', description='DEVANAGARI LETTER JA' },
	[0x091D] = { unicodeslot=0x091D, category='lo', description='DEVANAGARI LETTER JHA' },
	[0x091E] = { unicodeslot=0x091E, category='lo', description='DEVANAGARI LETTER NYA' },
	[0x091F] = { unicodeslot=0x091F, category='lo', description='DEVANAGARI LETTER TTA' },
	[0x0920] = { unicodeslot=0x0920, category='lo', description='DEVANAGARI LETTER TTHA' },
	[0x0921] = { unicodeslot=0x0921, category='lo', description='DEVANAGARI LETTER DDA' },
	[0x0922] = { unicodeslot=0x0922, category='lo', description='DEVANAGARI LETTER DDHA' },
	[0x0923] = { unicodeslot=0x0923, category='lo', description='DEVANAGARI LETTER NNA' },
	[0x0924] = { unicodeslot=0x0924, category='lo', description='DEVANAGARI LETTER TA' },
	[0x0925] = { unicodeslot=0x0925, category='lo', description='DEVANAGARI LETTER THA' },
	[0x0926] = { unicodeslot=0x0926, category='lo', description='DEVANAGARI LETTER DA' },
	[0x0927] = { unicodeslot=0x0927, category='lo', description='DEVANAGARI LETTER DHA' },
	[0x0928] = { unicodeslot=0x0928, category='lo', description='DEVANAGARI LETTER NA' },
	[0x0929] = { unicodeslot=0x0929, category='lo', description='DEVANAGARI LETTER NNNA', specials={'char',0x0928,0x093C} },
	[0x092A] = { unicodeslot=0x092A, category='lo', description='DEVANAGARI LETTER PA' },
	[0x092B] = { unicodeslot=0x092B, category='lo', description='DEVANAGARI LETTER PHA' },
	[0x092C] = { unicodeslot=0x092C, category='lo', description='DEVANAGARI LETTER BA' },
	[0x092D] = { unicodeslot=0x092D, category='lo', description='DEVANAGARI LETTER BHA' },
	[0x092E] = { unicodeslot=0x092E, category='lo', description='DEVANAGARI LETTER MA' },
	[0x092F] = { unicodeslot=0x092F, category='lo', description='DEVANAGARI LETTER YA' },
	[0x0930] = { unicodeslot=0x0930, category='lo', description='DEVANAGARI LETTER RA' },
	[0x0931] = { unicodeslot=0x0931, category='lo', description='DEVANAGARI LETTER RRA', specials={'char',0x0930,0x093C} },
	[0x0932] = { unicodeslot=0x0932, category='lo', description='DEVANAGARI LETTER LA' },
	[0x0933] = { unicodeslot=0x0933, category='lo', description='DEVANAGARI LETTER LLA' },
	[0x0934] = { unicodeslot=0x0934, category='lo', description='DEVANAGARI LETTER LLLA', specials={'char',0x0933,0x093C} },
	[0x0935] = { unicodeslot=0x0935, category='lo', description='DEVANAGARI LETTER VA' },
	[0x0936] = { unicodeslot=0x0936, category='lo', description='DEVANAGARI LETTER SHA' },
	[0x0937] = { unicodeslot=0x0937, category='lo', description='DEVANAGARI LETTER SSA' },
	[0x0938] = { unicodeslot=0x0938, category='lo', description='DEVANAGARI LETTER SA' },
	[0x0939] = { unicodeslot=0x0939, category='lo', description='DEVANAGARI LETTER HA' },
	[0x093C] = { unicodeslot=0x093C, category='mn', description='DEVANAGARI SIGN NUKTA' },
	[0x093D] = { unicodeslot=0x093D, category='lo', description='DEVANAGARI SIGN AVAGRAHA' },
	[0x093E] = { unicodeslot=0x093E, category='mc', description='DEVANAGARI VOWEL SIGN AA' },
	[0x093F] = { unicodeslot=0x093F, category='mc', description='DEVANAGARI VOWEL SIGN I' },
	[0x0940] = { unicodeslot=0x0940, category='mc', description='DEVANAGARI VOWEL SIGN II' },
	[0x0941] = { unicodeslot=0x0941, category='mn', description='DEVANAGARI VOWEL SIGN U' },
	[0x0942] = { unicodeslot=0x0942, category='mn', description='DEVANAGARI VOWEL SIGN UU' },
	[0x0943] = { unicodeslot=0x0943, category='mn', description='DEVANAGARI VOWEL SIGN VOCALIC R' },
	[0x0944] = { unicodeslot=0x0944, category='mn', description='DEVANAGARI VOWEL SIGN VOCALIC RR' },
	[0x0945] = { unicodeslot=0x0945, category='mn', description='DEVANAGARI VOWEL SIGN CANDRA E' },
	[0x0946] = { unicodeslot=0x0946, category='mn', description='DEVANAGARI VOWEL SIGN SHORT E' },
	[0x0947] = { unicodeslot=0x0947, category='mn', description='DEVANAGARI VOWEL SIGN E' },
	[0x0948] = { unicodeslot=0x0948, category='mn', description='DEVANAGARI VOWEL SIGN AI' },
	[0x0949] = { unicodeslot=0x0949, category='mc', description='DEVANAGARI VOWEL SIGN CANDRA O' },
	[0x094A] = { unicodeslot=0x094A, category='mc', description='DEVANAGARI VOWEL SIGN SHORT O' },
	[0x094B] = { unicodeslot=0x094B, category='mc', description='DEVANAGARI VOWEL SIGN O' },
	[0x094C] = { unicodeslot=0x094C, category='mc', description='DEVANAGARI VOWEL SIGN AU' },
	[0x094D] = { unicodeslot=0x094D, category='mn', description='DEVANAGARI SIGN VIRAMA' },
	[0x0950] = { unicodeslot=0x0950, category='lo', description='DEVANAGARI OM' },
	[0x0951] = { unicodeslot=0x0951, category='mn', description='DEVANAGARI STRESS SIGN UDATTA' },
	[0x0952] = { unicodeslot=0x0952, category='mn', description='DEVANAGARI STRESS SIGN ANUDATTA' },
	[0x0953] = { unicodeslot=0x0953, category='mn', description='DEVANAGARI GRAVE ACCENT' },
	[0x0954] = { unicodeslot=0x0954, category='mn', description='DEVANAGARI ACUTE ACCENT' },
	[0x0958] = { unicodeslot=0x0958, category='lo', description='DEVANAGARI LETTER QA', specials={'char',0x0915,0x093C} },
	[0x0959] = { unicodeslot=0x0959, category='lo', description='DEVANAGARI LETTER KHHA', specials={'char',0x0916,0x093C} },
	[0x095A] = { unicodeslot=0x095A, category='lo', description='DEVANAGARI LETTER GHHA', specials={'char',0x0917,0x093C} },
	[0x095B] = { unicodeslot=0x095B, category='lo', description='DEVANAGARI LETTER ZA', specials={'char',0x091C,0x093C} },
	[0x095C] = { unicodeslot=0x095C, category='lo', description='DEVANAGARI LETTER DDDHA', specials={'char',0x0921,0x093C} },
	[0x095D] = { unicodeslot=0x095D, category='lo', description='DEVANAGARI LETTER RHA', specials={'char',0x0922,0x093C} },
	[0x095E] = { unicodeslot=0x095E, category='lo', description='DEVANAGARI LETTER FA', specials={'char',0x092B,0x093C} },
	[0x095F] = { unicodeslot=0x095F, category='lo', description='DEVANAGARI LETTER YYA', specials={'char',0x092F,0x093C} },
	[0x0960] = { unicodeslot=0x0960, category='lo', description='DEVANAGARI LETTER VOCALIC RR' },
	[0x0961] = { unicodeslot=0x0961, category='lo', description='DEVANAGARI LETTER VOCALIC LL' },
	[0x0962] = { unicodeslot=0x0962, category='mn', description='DEVANAGARI VOWEL SIGN VOCALIC L' },
	[0x0963] = { unicodeslot=0x0963, category='mn', description='DEVANAGARI VOWEL SIGN VOCALIC LL' },
	[0x0964] = { unicodeslot=0x0964, category='po', description='DEVANAGARI DANDA' },
	[0x0965] = { unicodeslot=0x0965, category='po', description='DEVANAGARI DOUBLE DANDA' },
	[0x0966] = { unicodeslot=0x0966, category='nd', description='DEVANAGARI DIGIT ZERO' },
	[0x0967] = { unicodeslot=0x0967, category='nd', description='DEVANAGARI DIGIT ONE' },
	[0x0968] = { unicodeslot=0x0968, category='nd', description='DEVANAGARI DIGIT TWO' },
	[0x0969] = { unicodeslot=0x0969, category='nd', description='DEVANAGARI DIGIT THREE' },
	[0x096A] = { unicodeslot=0x096A, category='nd', description='DEVANAGARI DIGIT FOUR' },
	[0x096B] = { unicodeslot=0x096B, category='nd', description='DEVANAGARI DIGIT FIVE' },
	[0x096C] = { unicodeslot=0x096C, category='nd', description='DEVANAGARI DIGIT SIX' },
	[0x096D] = { unicodeslot=0x096D, category='nd', description='DEVANAGARI DIGIT SEVEN' },
	[0x096E] = { unicodeslot=0x096E, category='nd', description='DEVANAGARI DIGIT EIGHT' },
	[0x096F] = { unicodeslot=0x096F, category='nd', description='DEVANAGARI DIGIT NINE' },
	[0x0970] = { unicodeslot=0x0970, category='po', description='DEVANAGARI ABBREVIATION SIGN' },
	[0x097B] = { unicodeslot=0x097B, category='lo', description='DEVANAGARI LETTER GGA' },
	[0x097C] = { unicodeslot=0x097C, category='lo', description='DEVANAGARI LETTER JJA' },
	[0x097D] = { unicodeslot=0x097D, category='lo', description='DEVANAGARI LETTER GLOTTAL STOP' },
	[0x097E] = { unicodeslot=0x097E, category='lo', description='DEVANAGARI LETTER DDDA' },
	[0x097F] = { unicodeslot=0x097F, category='lo', description='DEVANAGARI LETTER BBA' },
	[0x0981] = { unicodeslot=0x0981, category='mn', description='BENGALI SIGN CANDRABINDU' },
	[0x0982] = { unicodeslot=0x0982, category='mc', description='BENGALI SIGN ANUSVARA' },
	[0x0983] = { unicodeslot=0x0983, category='mc', description='BENGALI SIGN VISARGA' },
	[0x0985] = { unicodeslot=0x0985, category='lo', description='BENGALI LETTER A' },
	[0x0986] = { unicodeslot=0x0986, category='lo', description='BENGALI LETTER AA' },
	[0x0987] = { unicodeslot=0x0987, category='lo', description='BENGALI LETTER I' },
	[0x0988] = { unicodeslot=0x0988, category='lo', description='BENGALI LETTER II' },
	[0x0989] = { unicodeslot=0x0989, category='lo', description='BENGALI LETTER U' },
	[0x098A] = { unicodeslot=0x098A, category='lo', description='BENGALI LETTER UU' },
	[0x098B] = { unicodeslot=0x098B, category='lo', description='BENGALI LETTER VOCALIC R' },
	[0x098C] = { unicodeslot=0x098C, category='lo', description='BENGALI LETTER VOCALIC L' },
	[0x098F] = { unicodeslot=0x098F, category='lo', description='BENGALI LETTER E' },
	[0x0990] = { unicodeslot=0x0990, category='lo', description='BENGALI LETTER AI' },
	[0x0993] = { unicodeslot=0x0993, category='lo', description='BENGALI LETTER O' },
	[0x0994] = { unicodeslot=0x0994, category='lo', description='BENGALI LETTER AU' },
	[0x0995] = { unicodeslot=0x0995, category='lo', description='BENGALI LETTER KA' },
	[0x0996] = { unicodeslot=0x0996, category='lo', description='BENGALI LETTER KHA' },
	[0x0997] = { unicodeslot=0x0997, category='lo', description='BENGALI LETTER GA' },
	[0x0998] = { unicodeslot=0x0998, category='lo', description='BENGALI LETTER GHA' },
	[0x0999] = { unicodeslot=0x0999, category='lo', description='BENGALI LETTER NGA' },
	[0x099A] = { unicodeslot=0x099A, category='lo', description='BENGALI LETTER CA' },
	[0x099B] = { unicodeslot=0x099B, category='lo', description='BENGALI LETTER CHA' },
	[0x099C] = { unicodeslot=0x099C, category='lo', description='BENGALI LETTER JA' },
	[0x099D] = { unicodeslot=0x099D, category='lo', description='BENGALI LETTER JHA' },
	[0x099E] = { unicodeslot=0x099E, category='lo', description='BENGALI LETTER NYA' },
	[0x099F] = { unicodeslot=0x099F, category='lo', description='BENGALI LETTER TTA' },
	[0x09A0] = { unicodeslot=0x09A0, category='lo', description='BENGALI LETTER TTHA' },
	[0x09A1] = { unicodeslot=0x09A1, category='lo', description='BENGALI LETTER DDA' },
	[0x09A2] = { unicodeslot=0x09A2, category='lo', description='BENGALI LETTER DDHA' },
	[0x09A3] = { unicodeslot=0x09A3, category='lo', description='BENGALI LETTER NNA' },
	[0x09A4] = { unicodeslot=0x09A4, category='lo', description='BENGALI LETTER TA' },
	[0x09A5] = { unicodeslot=0x09A5, category='lo', description='BENGALI LETTER THA' },
	[0x09A6] = { unicodeslot=0x09A6, category='lo', description='BENGALI LETTER DA' },
	[0x09A7] = { unicodeslot=0x09A7, category='lo', description='BENGALI LETTER DHA' },
	[0x09A8] = { unicodeslot=0x09A8, category='lo', description='BENGALI LETTER NA' },
	[0x09AA] = { unicodeslot=0x09AA, category='lo', description='BENGALI LETTER PA' },
	[0x09AB] = { unicodeslot=0x09AB, category='lo', description='BENGALI LETTER PHA' },
	[0x09AC] = { unicodeslot=0x09AC, category='lo', description='BENGALI LETTER BA' },
	[0x09AD] = { unicodeslot=0x09AD, category='lo', description='BENGALI LETTER BHA' },
	[0x09AE] = { unicodeslot=0x09AE, category='lo', description='BENGALI LETTER MA' },
	[0x09AF] = { unicodeslot=0x09AF, category='lo', description='BENGALI LETTER YA' },
	[0x09B0] = { unicodeslot=0x09B0, category='lo', description='BENGALI LETTER RA' },
	[0x09B2] = { unicodeslot=0x09B2, category='lo', description='BENGALI LETTER LA' },
	[0x09B6] = { unicodeslot=0x09B6, category='lo', description='BENGALI LETTER SHA' },
	[0x09B7] = { unicodeslot=0x09B7, category='lo', description='BENGALI LETTER SSA' },
	[0x09B8] = { unicodeslot=0x09B8, category='lo', description='BENGALI LETTER SA' },
	[0x09B9] = { unicodeslot=0x09B9, category='lo', description='BENGALI LETTER HA' },
	[0x09BC] = { unicodeslot=0x09BC, category='mn', description='BENGALI SIGN NUKTA' },
	[0x09BD] = { unicodeslot=0x09BD, category='lo', description='BENGALI SIGN AVAGRAHA' },
	[0x09BE] = { unicodeslot=0x09BE, category='mc', description='BENGALI VOWEL SIGN AA' },
	[0x09BF] = { unicodeslot=0x09BF, category='mc', description='BENGALI VOWEL SIGN I' },
	[0x09C0] = { unicodeslot=0x09C0, category='mc', description='BENGALI VOWEL SIGN II' },
	[0x09C1] = { unicodeslot=0x09C1, category='mn', description='BENGALI VOWEL SIGN U' },
	[0x09C2] = { unicodeslot=0x09C2, category='mn', description='BENGALI VOWEL SIGN UU' },
	[0x09C3] = { unicodeslot=0x09C3, category='mn', description='BENGALI VOWEL SIGN VOCALIC R' },
	[0x09C4] = { unicodeslot=0x09C4, category='mn', description='BENGALI VOWEL SIGN VOCALIC RR' },
	[0x09C7] = { unicodeslot=0x09C7, category='mc', description='BENGALI VOWEL SIGN E' },
	[0x09C8] = { unicodeslot=0x09C8, category='mc', description='BENGALI VOWEL SIGN AI' },
	[0x09CB] = { unicodeslot=0x09CB, category='mc', description='BENGALI VOWEL SIGN O', specials={'char',0x09C7,0x09BE} },
	[0x09CC] = { unicodeslot=0x09CC, category='mc', description='BENGALI VOWEL SIGN AU', specials={'char',0x09C7,0x09D7} },
	[0x09CD] = { unicodeslot=0x09CD, category='mn', description='BENGALI SIGN VIRAMA' },
	[0x09CE] = { unicodeslot=0x09CE, category='lo', description='BENGALI LETTER KHANDA TA' },
	[0x09D7] = { unicodeslot=0x09D7, category='mc', description='BENGALI AU LENGTH MARK' },
	[0x09DC] = { unicodeslot=0x09DC, category='lo', description='BENGALI LETTER RRA', specials={'char',0x09A1,0x09BC} },
	[0x09DD] = { unicodeslot=0x09DD, category='lo', description='BENGALI LETTER RHA', specials={'char',0x09A2,0x09BC} },
	[0x09DF] = { unicodeslot=0x09DF, category='lo', description='BENGALI LETTER YYA', specials={'char',0x09AF,0x09BC} },
	[0x09E0] = { unicodeslot=0x09E0, category='lo', description='BENGALI LETTER VOCALIC RR' },
	[0x09E1] = { unicodeslot=0x09E1, category='lo', description='BENGALI LETTER VOCALIC LL' },
	[0x09E2] = { unicodeslot=0x09E2, category='mn', description='BENGALI VOWEL SIGN VOCALIC L' },
	[0x09E3] = { unicodeslot=0x09E3, category='mn', description='BENGALI VOWEL SIGN VOCALIC LL' },
	[0x09E6] = { unicodeslot=0x09E6, category='nd', description='BENGALI DIGIT ZERO' },
	[0x09E7] = { unicodeslot=0x09E7, category='nd', description='BENGALI DIGIT ONE' },
	[0x09E8] = { unicodeslot=0x09E8, category='nd', description='BENGALI DIGIT TWO' },
	[0x09E9] = { unicodeslot=0x09E9, category='nd', description='BENGALI DIGIT THREE' },
	[0x09EA] = { unicodeslot=0x09EA, category='nd', description='BENGALI DIGIT FOUR' },
	[0x09EB] = { unicodeslot=0x09EB, category='nd', description='BENGALI DIGIT FIVE' },
	[0x09EC] = { unicodeslot=0x09EC, category='nd', description='BENGALI DIGIT SIX' },
	[0x09ED] = { unicodeslot=0x09ED, category='nd', description='BENGALI DIGIT SEVEN' },
	[0x09EE] = { unicodeslot=0x09EE, category='nd', description='BENGALI DIGIT EIGHT' },
	[0x09EF] = { unicodeslot=0x09EF, category='nd', description='BENGALI DIGIT NINE' },
	[0x09F0] = { unicodeslot=0x09F0, category='lo', description='BENGALI LETTER RA WITH MIDDLE DIAGONAL', shcode=0x09B0 },
	[0x09F1] = { unicodeslot=0x09F1, category='lo', description='BENGALI LETTER RA WITH LOWER DIAGONAL', shcode=0x09B0 },
	[0x09F2] = { unicodeslot=0x09F2, category='sc', description='BENGALI RUPEE MARK' },
	[0x09F3] = { unicodeslot=0x09F3, category='sc', description='BENGALI RUPEE SIGN' },
	[0x09F4] = { unicodeslot=0x09F4, category='no', description='BENGALI CURRENCY NUMERATOR ONE' },
	[0x09F5] = { unicodeslot=0x09F5, category='no', description='BENGALI CURRENCY NUMERATOR TWO' },
	[0x09F6] = { unicodeslot=0x09F6, category='no', description='BENGALI CURRENCY NUMERATOR THREE' },
	[0x09F7] = { unicodeslot=0x09F7, category='no', description='BENGALI CURRENCY NUMERATOR FOUR' },
	[0x09F8] = { unicodeslot=0x09F8, category='no', description='BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR' },
	[0x09F9] = { unicodeslot=0x09F9, category='no', description='BENGALI CURRENCY DENOMINATOR SIXTEEN' },
	[0x09FA] = { unicodeslot=0x09FA, category='so', description='BENGALI ISSHAR' },
	[0x0A01] = { unicodeslot=0x0A01, category='mn', description='GURMUKHI SIGN ADAK BINDI' },
	[0x0A02] = { unicodeslot=0x0A02, category='mn', description='GURMUKHI SIGN BINDI' },
	[0x0A03] = { unicodeslot=0x0A03, category='mc', description='GURMUKHI SIGN VISARGA' },
	[0x0A05] = { unicodeslot=0x0A05, category='lo', description='GURMUKHI LETTER A' },
	[0x0A06] = { unicodeslot=0x0A06, category='lo', description='GURMUKHI LETTER AA' },
	[0x0A07] = { unicodeslot=0x0A07, category='lo', description='GURMUKHI LETTER I' },
	[0x0A08] = { unicodeslot=0x0A08, category='lo', description='GURMUKHI LETTER II' },
	[0x0A09] = { unicodeslot=0x0A09, category='lo', description='GURMUKHI LETTER U' },
	[0x0A0A] = { unicodeslot=0x0A0A, category='lo', description='GURMUKHI LETTER UU' },
	[0x0A0F] = { unicodeslot=0x0A0F, category='lo', description='GURMUKHI LETTER EE' },
	[0x0A10] = { unicodeslot=0x0A10, category='lo', description='GURMUKHI LETTER AI' },
	[0x0A13] = { unicodeslot=0x0A13, category='lo', description='GURMUKHI LETTER OO' },
	[0x0A14] = { unicodeslot=0x0A14, category='lo', description='GURMUKHI LETTER AU' },
	[0x0A15] = { unicodeslot=0x0A15, category='lo', description='GURMUKHI LETTER KA' },
	[0x0A16] = { unicodeslot=0x0A16, category='lo', description='GURMUKHI LETTER KHA' },
	[0x0A17] = { unicodeslot=0x0A17, category='lo', description='GURMUKHI LETTER GA' },
	[0x0A18] = { unicodeslot=0x0A18, category='lo', description='GURMUKHI LETTER GHA' },
	[0x0A19] = { unicodeslot=0x0A19, category='lo', description='GURMUKHI LETTER NGA' },
	[0x0A1A] = { unicodeslot=0x0A1A, category='lo', description='GURMUKHI LETTER CA' },
	[0x0A1B] = { unicodeslot=0x0A1B, category='lo', description='GURMUKHI LETTER CHA' },
	[0x0A1C] = { unicodeslot=0x0A1C, category='lo', description='GURMUKHI LETTER JA' },
	[0x0A1D] = { unicodeslot=0x0A1D, category='lo', description='GURMUKHI LETTER JHA' },
	[0x0A1E] = { unicodeslot=0x0A1E, category='lo', description='GURMUKHI LETTER NYA' },
	[0x0A1F] = { unicodeslot=0x0A1F, category='lo', description='GURMUKHI LETTER TTA' },
	[0x0A20] = { unicodeslot=0x0A20, category='lo', description='GURMUKHI LETTER TTHA' },
	[0x0A21] = { unicodeslot=0x0A21, category='lo', description='GURMUKHI LETTER DDA' },
	[0x0A22] = { unicodeslot=0x0A22, category='lo', description='GURMUKHI LETTER DDHA' },
	[0x0A23] = { unicodeslot=0x0A23, category='lo', description='GURMUKHI LETTER NNA' },
	[0x0A24] = { unicodeslot=0x0A24, category='lo', description='GURMUKHI LETTER TA' },
	[0x0A25] = { unicodeslot=0x0A25, category='lo', description='GURMUKHI LETTER THA' },
	[0x0A26] = { unicodeslot=0x0A26, category='lo', description='GURMUKHI LETTER DA' },
	[0x0A27] = { unicodeslot=0x0A27, category='lo', description='GURMUKHI LETTER DHA' },
	[0x0A28] = { unicodeslot=0x0A28, category='lo', description='GURMUKHI LETTER NA' },
	[0x0A2A] = { unicodeslot=0x0A2A, category='lo', description='GURMUKHI LETTER PA' },
	[0x0A2B] = { unicodeslot=0x0A2B, category='lo', description='GURMUKHI LETTER PHA' },
	[0x0A2C] = { unicodeslot=0x0A2C, category='lo', description='GURMUKHI LETTER BA' },
	[0x0A2D] = { unicodeslot=0x0A2D, category='lo', description='GURMUKHI LETTER BHA' },
	[0x0A2E] = { unicodeslot=0x0A2E, category='lo', description='GURMUKHI LETTER MA' },
	[0x0A2F] = { unicodeslot=0x0A2F, category='lo', description='GURMUKHI LETTER YA' },
	[0x0A30] = { unicodeslot=0x0A30, category='lo', description='GURMUKHI LETTER RA' },
	[0x0A32] = { unicodeslot=0x0A32, category='lo', description='GURMUKHI LETTER LA' },
	[0x0A33] = { unicodeslot=0x0A33, category='lo', description='GURMUKHI LETTER LLA', specials={'char',0x0A32,0x0A3C} },
	[0x0A35] = { unicodeslot=0x0A35, category='lo', description='GURMUKHI LETTER VA' },
	[0x0A36] = { unicodeslot=0x0A36, category='lo', description='GURMUKHI LETTER SHA', specials={'char',0x0A38,0x0A3C} },
	[0x0A38] = { unicodeslot=0x0A38, category='lo', description='GURMUKHI LETTER SA' },
	[0x0A39] = { unicodeslot=0x0A39, category='lo', description='GURMUKHI LETTER HA' },
	[0x0A3C] = { unicodeslot=0x0A3C, category='mn', description='GURMUKHI SIGN NUKTA' },
	[0x0A3E] = { unicodeslot=0x0A3E, category='mc', description='GURMUKHI VOWEL SIGN AA' },
	[0x0A3F] = { unicodeslot=0x0A3F, category='mc', description='GURMUKHI VOWEL SIGN I' },
	[0x0A40] = { unicodeslot=0x0A40, category='mc', description='GURMUKHI VOWEL SIGN II' },
	[0x0A41] = { unicodeslot=0x0A41, category='mn', description='GURMUKHI VOWEL SIGN U' },
	[0x0A42] = { unicodeslot=0x0A42, category='mn', description='GURMUKHI VOWEL SIGN UU' },
	[0x0A47] = { unicodeslot=0x0A47, category='mn', description='GURMUKHI VOWEL SIGN EE' },
	[0x0A48] = { unicodeslot=0x0A48, category='mn', description='GURMUKHI VOWEL SIGN AI' },
	[0x0A4B] = { unicodeslot=0x0A4B, category='mn', description='GURMUKHI VOWEL SIGN OO' },
	[0x0A4C] = { unicodeslot=0x0A4C, category='mn', description='GURMUKHI VOWEL SIGN AU' },
	[0x0A4D] = { unicodeslot=0x0A4D, category='mn', description='GURMUKHI SIGN VIRAMA' },
	[0x0A59] = { unicodeslot=0x0A59, category='lo', description='GURMUKHI LETTER KHHA', specials={'char',0x0A16,0x0A3C} },
	[0x0A5A] = { unicodeslot=0x0A5A, category='lo', description='GURMUKHI LETTER GHHA', specials={'char',0x0A17,0x0A3C} },
	[0x0A5B] = { unicodeslot=0x0A5B, category='lo', description='GURMUKHI LETTER ZA', specials={'char',0x0A1C,0x0A3C} },
	[0x0A5C] = { unicodeslot=0x0A5C, category='lo', description='GURMUKHI LETTER RRA' },
	[0x0A5E] = { unicodeslot=0x0A5E, category='lo', description='GURMUKHI LETTER FA', specials={'char',0x0A2B,0x0A3C} },
	[0x0A66] = { unicodeslot=0x0A66, category='nd', description='GURMUKHI DIGIT ZERO' },
	[0x0A67] = { unicodeslot=0x0A67, category='nd', description='GURMUKHI DIGIT ONE' },
	[0x0A68] = { unicodeslot=0x0A68, category='nd', description='GURMUKHI DIGIT TWO' },
	[0x0A69] = { unicodeslot=0x0A69, category='nd', description='GURMUKHI DIGIT THREE' },
	[0x0A6A] = { unicodeslot=0x0A6A, category='nd', description='GURMUKHI DIGIT FOUR' },
	[0x0A6B] = { unicodeslot=0x0A6B, category='nd', description='GURMUKHI DIGIT FIVE' },
	[0x0A6C] = { unicodeslot=0x0A6C, category='nd', description='GURMUKHI DIGIT SIX' },
	[0x0A6D] = { unicodeslot=0x0A6D, category='nd', description='GURMUKHI DIGIT SEVEN' },
	[0x0A6E] = { unicodeslot=0x0A6E, category='nd', description='GURMUKHI DIGIT EIGHT' },
	[0x0A6F] = { unicodeslot=0x0A6F, category='nd', description='GURMUKHI DIGIT NINE' },
	[0x0A70] = { unicodeslot=0x0A70, category='mn', description='GURMUKHI TIPPI' },
	[0x0A71] = { unicodeslot=0x0A71, category='mn', description='GURMUKHI ADDAK' },
	[0x0A72] = { unicodeslot=0x0A72, category='lo', description='GURMUKHI IRI' },
	[0x0A73] = { unicodeslot=0x0A73, category='lo', description='GURMUKHI URA' },
	[0x0A74] = { unicodeslot=0x0A74, category='lo', description='GURMUKHI EK ONKAR' },
	[0x0A81] = { unicodeslot=0x0A81, category='mn', description='GUJARATI SIGN CANDRABINDU' },
	[0x0A82] = { unicodeslot=0x0A82, category='mn', description='GUJARATI SIGN ANUSVARA' },
	[0x0A83] = { unicodeslot=0x0A83, category='mc', description='GUJARATI SIGN VISARGA' },
	[0x0A85] = { unicodeslot=0x0A85, category='lo', description='GUJARATI LETTER A' },
	[0x0A86] = { unicodeslot=0x0A86, category='lo', description='GUJARATI LETTER AA' },
	[0x0A87] = { unicodeslot=0x0A87, category='lo', description='GUJARATI LETTER I' },
	[0x0A88] = { unicodeslot=0x0A88, category='lo', description='GUJARATI LETTER II' },
	[0x0A89] = { unicodeslot=0x0A89, category='lo', description='GUJARATI LETTER U' },
	[0x0A8A] = { unicodeslot=0x0A8A, category='lo', description='GUJARATI LETTER UU' },
	[0x0A8B] = { unicodeslot=0x0A8B, category='lo', description='GUJARATI LETTER VOCALIC R' },
	[0x0A8C] = { unicodeslot=0x0A8C, category='lo', description='GUJARATI LETTER VOCALIC L' },
	[0x0A8D] = { unicodeslot=0x0A8D, category='lo', description='GUJARATI VOWEL CANDRA E' },
	[0x0A8F] = { unicodeslot=0x0A8F, category='lo', description='GUJARATI LETTER E' },
	[0x0A90] = { unicodeslot=0x0A90, category='lo', description='GUJARATI LETTER AI' },
	[0x0A91] = { unicodeslot=0x0A91, category='lo', description='GUJARATI VOWEL CANDRA O' },
	[0x0A93] = { unicodeslot=0x0A93, category='lo', description='GUJARATI LETTER O' },
	[0x0A94] = { unicodeslot=0x0A94, category='lo', description='GUJARATI LETTER AU' },
	[0x0A95] = { unicodeslot=0x0A95, category='lo', description='GUJARATI LETTER KA' },
	[0x0A96] = { unicodeslot=0x0A96, category='lo', description='GUJARATI LETTER KHA' },
	[0x0A97] = { unicodeslot=0x0A97, category='lo', description='GUJARATI LETTER GA' },
	[0x0A98] = { unicodeslot=0x0A98, category='lo', description='GUJARATI LETTER GHA' },
	[0x0A99] = { unicodeslot=0x0A99, category='lo', description='GUJARATI LETTER NGA' },
	[0x0A9A] = { unicodeslot=0x0A9A, category='lo', description='GUJARATI LETTER CA' },
	[0x0A9B] = { unicodeslot=0x0A9B, category='lo', description='GUJARATI LETTER CHA' },
	[0x0A9C] = { unicodeslot=0x0A9C, category='lo', description='GUJARATI LETTER JA' },
	[0x0A9D] = { unicodeslot=0x0A9D, category='lo', description='GUJARATI LETTER JHA' },
	[0x0A9E] = { unicodeslot=0x0A9E, category='lo', description='GUJARATI LETTER NYA' },
	[0x0A9F] = { unicodeslot=0x0A9F, category='lo', description='GUJARATI LETTER TTA' },
	[0x0AA0] = { unicodeslot=0x0AA0, category='lo', description='GUJARATI LETTER TTHA' },
	[0x0AA1] = { unicodeslot=0x0AA1, category='lo', description='GUJARATI LETTER DDA' },
	[0x0AA2] = { unicodeslot=0x0AA2, category='lo', description='GUJARATI LETTER DDHA' },
	[0x0AA3] = { unicodeslot=0x0AA3, category='lo', description='GUJARATI LETTER NNA' },
	[0x0AA4] = { unicodeslot=0x0AA4, category='lo', description='GUJARATI LETTER TA' },
	[0x0AA5] = { unicodeslot=0x0AA5, category='lo', description='GUJARATI LETTER THA' },
	[0x0AA6] = { unicodeslot=0x0AA6, category='lo', description='GUJARATI LETTER DA' },
	[0x0AA7] = { unicodeslot=0x0AA7, category='lo', description='GUJARATI LETTER DHA' },
	[0x0AA8] = { unicodeslot=0x0AA8, category='lo', description='GUJARATI LETTER NA' },
	[0x0AAA] = { unicodeslot=0x0AAA, category='lo', description='GUJARATI LETTER PA' },
	[0x0AAB] = { unicodeslot=0x0AAB, category='lo', description='GUJARATI LETTER PHA' },
	[0x0AAC] = { unicodeslot=0x0AAC, category='lo', description='GUJARATI LETTER BA' },
	[0x0AAD] = { unicodeslot=0x0AAD, category='lo', description='GUJARATI LETTER BHA' },
	[0x0AAE] = { unicodeslot=0x0AAE, category='lo', description='GUJARATI LETTER MA' },
	[0x0AAF] = { unicodeslot=0x0AAF, category='lo', description='GUJARATI LETTER YA' },
	[0x0AB0] = { unicodeslot=0x0AB0, category='lo', description='GUJARATI LETTER RA' },
	[0x0AB2] = { unicodeslot=0x0AB2, category='lo', description='GUJARATI LETTER LA' },
	[0x0AB3] = { unicodeslot=0x0AB3, category='lo', description='GUJARATI LETTER LLA' },
	[0x0AB5] = { unicodeslot=0x0AB5, category='lo', description='GUJARATI LETTER VA' },
	[0x0AB6] = { unicodeslot=0x0AB6, category='lo', description='GUJARATI LETTER SHA' },
	[0x0AB7] = { unicodeslot=0x0AB7, category='lo', description='GUJARATI LETTER SSA' },
	[0x0AB8] = { unicodeslot=0x0AB8, category='lo', description='GUJARATI LETTER SA' },
	[0x0AB9] = { unicodeslot=0x0AB9, category='lo', description='GUJARATI LETTER HA' },
	[0x0ABC] = { unicodeslot=0x0ABC, category='mn', description='GUJARATI SIGN NUKTA' },
	[0x0ABD] = { unicodeslot=0x0ABD, category='lo', description='GUJARATI SIGN AVAGRAHA' },
	[0x0ABE] = { unicodeslot=0x0ABE, category='mc', description='GUJARATI VOWEL SIGN AA' },
	[0x0ABF] = { unicodeslot=0x0ABF, category='mc', description='GUJARATI VOWEL SIGN I' },
	[0x0AC0] = { unicodeslot=0x0AC0, category='mc', description='GUJARATI VOWEL SIGN II' },
	[0x0AC1] = { unicodeslot=0x0AC1, category='mn', description='GUJARATI VOWEL SIGN U' },
	[0x0AC2] = { unicodeslot=0x0AC2, category='mn', description='GUJARATI VOWEL SIGN UU' },
	[0x0AC3] = { unicodeslot=0x0AC3, category='mn', description='GUJARATI VOWEL SIGN VOCALIC R' },
	[0x0AC4] = { unicodeslot=0x0AC4, category='mn', description='GUJARATI VOWEL SIGN VOCALIC RR' },
	[0x0AC5] = { unicodeslot=0x0AC5, category='mn', description='GUJARATI VOWEL SIGN CANDRA E' },
	[0x0AC7] = { unicodeslot=0x0AC7, category='mn', description='GUJARATI VOWEL SIGN E' },
	[0x0AC8] = { unicodeslot=0x0AC8, category='mn', description='GUJARATI VOWEL SIGN AI' },
	[0x0AC9] = { unicodeslot=0x0AC9, category='mc', description='GUJARATI VOWEL SIGN CANDRA O' },
	[0x0ACB] = { unicodeslot=0x0ACB, category='mc', description='GUJARATI VOWEL SIGN O' },
	[0x0ACC] = { unicodeslot=0x0ACC, category='mc', description='GUJARATI VOWEL SIGN AU' },
	[0x0ACD] = { unicodeslot=0x0ACD, category='mn', description='GUJARATI SIGN VIRAMA' },
	[0x0AD0] = { unicodeslot=0x0AD0, category='lo', description='GUJARATI OM' },
	[0x0AE0] = { unicodeslot=0x0AE0, category='lo', description='GUJARATI LETTER VOCALIC RR' },
	[0x0AE1] = { unicodeslot=0x0AE1, category='lo', description='GUJARATI LETTER VOCALIC LL' },
	[0x0AE2] = { unicodeslot=0x0AE2, category='mn', description='GUJARATI VOWEL SIGN VOCALIC L' },
	[0x0AE3] = { unicodeslot=0x0AE3, category='mn', description='GUJARATI VOWEL SIGN VOCALIC LL' },
	[0x0AE6] = { unicodeslot=0x0AE6, category='nd', description='GUJARATI DIGIT ZERO' },
	[0x0AE7] = { unicodeslot=0x0AE7, category='nd', description='GUJARATI DIGIT ONE' },
	[0x0AE8] = { unicodeslot=0x0AE8, category='nd', description='GUJARATI DIGIT TWO' },
	[0x0AE9] = { unicodeslot=0x0AE9, category='nd', description='GUJARATI DIGIT THREE' },
	[0x0AEA] = { unicodeslot=0x0AEA, category='nd', description='GUJARATI DIGIT FOUR' },
	[0x0AEB] = { unicodeslot=0x0AEB, category='nd', description='GUJARATI DIGIT FIVE' },
	[0x0AEC] = { unicodeslot=0x0AEC, category='nd', description='GUJARATI DIGIT SIX' },
	[0x0AED] = { unicodeslot=0x0AED, category='nd', description='GUJARATI DIGIT SEVEN' },
	[0x0AEE] = { unicodeslot=0x0AEE, category='nd', description='GUJARATI DIGIT EIGHT' },
	[0x0AEF] = { unicodeslot=0x0AEF, category='nd', description='GUJARATI DIGIT NINE' },
	[0x0AF1] = { unicodeslot=0x0AF1, category='sc', description='GUJARATI RUPEE SIGN' },
	[0x0B01] = { unicodeslot=0x0B01, category='mn', description='ORIYA SIGN CANDRABINDU' },
	[0x0B02] = { unicodeslot=0x0B02, category='mc', description='ORIYA SIGN ANUSVARA' },
	[0x0B03] = { unicodeslot=0x0B03, category='mc', description='ORIYA SIGN VISARGA' },
	[0x0B05] = { unicodeslot=0x0B05, category='lo', description='ORIYA LETTER A' },
	[0x0B06] = { unicodeslot=0x0B06, category='lo', description='ORIYA LETTER AA' },
	[0x0B07] = { unicodeslot=0x0B07, category='lo', description='ORIYA LETTER I' },
	[0x0B08] = { unicodeslot=0x0B08, category='lo', description='ORIYA LETTER II' },
	[0x0B09] = { unicodeslot=0x0B09, category='lo', description='ORIYA LETTER U' },
	[0x0B0A] = { unicodeslot=0x0B0A, category='lo', description='ORIYA LETTER UU' },
	[0x0B0B] = { unicodeslot=0x0B0B, category='lo', description='ORIYA LETTER VOCALIC R' },
	[0x0B0C] = { unicodeslot=0x0B0C, category='lo', description='ORIYA LETTER VOCALIC L' },
	[0x0B0F] = { unicodeslot=0x0B0F, category='lo', description='ORIYA LETTER E' },
	[0x0B10] = { unicodeslot=0x0B10, category='lo', description='ORIYA LETTER AI' },
	[0x0B13] = { unicodeslot=0x0B13, category='lo', description='ORIYA LETTER O' },
	[0x0B14] = { unicodeslot=0x0B14, category='lo', description='ORIYA LETTER AU' },
	[0x0B15] = { unicodeslot=0x0B15, category='lo', description='ORIYA LETTER KA' },
	[0x0B16] = { unicodeslot=0x0B16, category='lo', description='ORIYA LETTER KHA' },
	[0x0B17] = { unicodeslot=0x0B17, category='lo', description='ORIYA LETTER GA' },
	[0x0B18] = { unicodeslot=0x0B18, category='lo', description='ORIYA LETTER GHA' },
	[0x0B19] = { unicodeslot=0x0B19, category='lo', description='ORIYA LETTER NGA' },
	[0x0B1A] = { unicodeslot=0x0B1A, category='lo', description='ORIYA LETTER CA' },
	[0x0B1B] = { unicodeslot=0x0B1B, category='lo', description='ORIYA LETTER CHA' },
	[0x0B1C] = { unicodeslot=0x0B1C, category='lo', description='ORIYA LETTER JA' },
	[0x0B1D] = { unicodeslot=0x0B1D, category='lo', description='ORIYA LETTER JHA' },
	[0x0B1E] = { unicodeslot=0x0B1E, category='lo', description='ORIYA LETTER NYA' },
	[0x0B1F] = { unicodeslot=0x0B1F, category='lo', description='ORIYA LETTER TTA' },
	[0x0B20] = { unicodeslot=0x0B20, category='lo', description='ORIYA LETTER TTHA' },
	[0x0B21] = { unicodeslot=0x0B21, category='lo', description='ORIYA LETTER DDA' },
	[0x0B22] = { unicodeslot=0x0B22, category='lo', description='ORIYA LETTER DDHA' },
	[0x0B23] = { unicodeslot=0x0B23, category='lo', description='ORIYA LETTER NNA' },
	[0x0B24] = { unicodeslot=0x0B24, category='lo', description='ORIYA LETTER TA' },
	[0x0B25] = { unicodeslot=0x0B25, category='lo', description='ORIYA LETTER THA' },
	[0x0B26] = { unicodeslot=0x0B26, category='lo', description='ORIYA LETTER DA' },
	[0x0B27] = { unicodeslot=0x0B27, category='lo', description='ORIYA LETTER DHA' },
	[0x0B28] = { unicodeslot=0x0B28, category='lo', description='ORIYA LETTER NA' },
	[0x0B2A] = { unicodeslot=0x0B2A, category='lo', description='ORIYA LETTER PA' },
	[0x0B2B] = { unicodeslot=0x0B2B, category='lo', description='ORIYA LETTER PHA' },
	[0x0B2C] = { unicodeslot=0x0B2C, category='lo', description='ORIYA LETTER BA' },
	[0x0B2D] = { unicodeslot=0x0B2D, category='lo', description='ORIYA LETTER BHA' },
	[0x0B2E] = { unicodeslot=0x0B2E, category='lo', description='ORIYA LETTER MA' },
	[0x0B2F] = { unicodeslot=0x0B2F, category='lo', description='ORIYA LETTER YA' },
	[0x0B30] = { unicodeslot=0x0B30, category='lo', description='ORIYA LETTER RA' },
	[0x0B32] = { unicodeslot=0x0B32, category='lo', description='ORIYA LETTER LA' },
	[0x0B33] = { unicodeslot=0x0B33, category='lo', description='ORIYA LETTER LLA' },
	[0x0B35] = { unicodeslot=0x0B35, category='lo', description='ORIYA LETTER VA' },
	[0x0B36] = { unicodeslot=0x0B36, category='lo', description='ORIYA LETTER SHA' },
	[0x0B37] = { unicodeslot=0x0B37, category='lo', description='ORIYA LETTER SSA' },
	[0x0B38] = { unicodeslot=0x0B38, category='lo', description='ORIYA LETTER SA' },
	[0x0B39] = { unicodeslot=0x0B39, category='lo', description='ORIYA LETTER HA' },
	[0x0B3C] = { unicodeslot=0x0B3C, category='mn', description='ORIYA SIGN NUKTA' },
	[0x0B3D] = { unicodeslot=0x0B3D, category='lo', description='ORIYA SIGN AVAGRAHA' },
	[0x0B3E] = { unicodeslot=0x0B3E, category='mc', description='ORIYA VOWEL SIGN AA' },
	[0x0B3F] = { unicodeslot=0x0B3F, category='mn', description='ORIYA VOWEL SIGN I' },
	[0x0B40] = { unicodeslot=0x0B40, category='mc', description='ORIYA VOWEL SIGN II' },
	[0x0B41] = { unicodeslot=0x0B41, category='mn', description='ORIYA VOWEL SIGN U' },
	[0x0B42] = { unicodeslot=0x0B42, category='mn', description='ORIYA VOWEL SIGN UU' },
	[0x0B43] = { unicodeslot=0x0B43, category='mn', description='ORIYA VOWEL SIGN VOCALIC R' },
	[0x0B47] = { unicodeslot=0x0B47, category='mc', description='ORIYA VOWEL SIGN E' },
	[0x0B48] = { unicodeslot=0x0B48, category='mc', description='ORIYA VOWEL SIGN AI', specials={'char',0x0B47,0x0B56} },
	[0x0B4B] = { unicodeslot=0x0B4B, category='mc', description='ORIYA VOWEL SIGN O', specials={'char',0x0B47,0x0B3E} },
	[0x0B4C] = { unicodeslot=0x0B4C, category='mc', description='ORIYA VOWEL SIGN AU', specials={'char',0x0B47,0x0B57} },
	[0x0B4D] = { unicodeslot=0x0B4D, category='mn', description='ORIYA SIGN VIRAMA' },
	[0x0B56] = { unicodeslot=0x0B56, category='mn', description='ORIYA AI LENGTH MARK' },
	[0x0B57] = { unicodeslot=0x0B57, category='mc', description='ORIYA AU LENGTH MARK' },
	[0x0B5C] = { unicodeslot=0x0B5C, category='lo', description='ORIYA LETTER RRA', specials={'char',0x0B21,0x0B3C} },
	[0x0B5D] = { unicodeslot=0x0B5D, category='lo', description='ORIYA LETTER RHA', specials={'char',0x0B22,0x0B3C} },
	[0x0B5F] = { unicodeslot=0x0B5F, category='lo', description='ORIYA LETTER YYA' },
	[0x0B60] = { unicodeslot=0x0B60, category='lo', description='ORIYA LETTER VOCALIC RR' },
	[0x0B61] = { unicodeslot=0x0B61, category='lo', description='ORIYA LETTER VOCALIC LL' },
	[0x0B66] = { unicodeslot=0x0B66, category='nd', description='ORIYA DIGIT ZERO' },
	[0x0B67] = { unicodeslot=0x0B67, category='nd', description='ORIYA DIGIT ONE' },
	[0x0B68] = { unicodeslot=0x0B68, category='nd', description='ORIYA DIGIT TWO' },
	[0x0B69] = { unicodeslot=0x0B69, category='nd', description='ORIYA DIGIT THREE' },
	[0x0B6A] = { unicodeslot=0x0B6A, category='nd', description='ORIYA DIGIT FOUR' },
	[0x0B6B] = { unicodeslot=0x0B6B, category='nd', description='ORIYA DIGIT FIVE' },
	[0x0B6C] = { unicodeslot=0x0B6C, category='nd', description='ORIYA DIGIT SIX' },
	[0x0B6D] = { unicodeslot=0x0B6D, category='nd', description='ORIYA DIGIT SEVEN' },
	[0x0B6E] = { unicodeslot=0x0B6E, category='nd', description='ORIYA DIGIT EIGHT' },
	[0x0B6F] = { unicodeslot=0x0B6F, category='nd', description='ORIYA DIGIT NINE' },
	[0x0B70] = { unicodeslot=0x0B70, category='so', description='ORIYA ISSHAR' },
	[0x0B71] = { unicodeslot=0x0B71, category='lo', description='ORIYA LETTER WA' },
	[0x0B82] = { unicodeslot=0x0B82, category='mn', description='TAMIL SIGN ANUSVARA' },
	[0x0B83] = { unicodeslot=0x0B83, category='lo', description='TAMIL SIGN VISARGA' },
	[0x0B85] = { unicodeslot=0x0B85, category='lo', description='TAMIL LETTER A' },
	[0x0B86] = { unicodeslot=0x0B86, category='lo', description='TAMIL LETTER AA' },
	[0x0B87] = { unicodeslot=0x0B87, category='lo', description='TAMIL LETTER I' },
	[0x0B88] = { unicodeslot=0x0B88, category='lo', description='TAMIL LETTER II' },
	[0x0B89] = { unicodeslot=0x0B89, category='lo', description='TAMIL LETTER U' },
	[0x0B8A] = { unicodeslot=0x0B8A, category='lo', description='TAMIL LETTER UU' },
	[0x0B8E] = { unicodeslot=0x0B8E, category='lo', description='TAMIL LETTER E' },
	[0x0B8F] = { unicodeslot=0x0B8F, category='lo', description='TAMIL LETTER EE' },
	[0x0B90] = { unicodeslot=0x0B90, category='lo', description='TAMIL LETTER AI' },
	[0x0B92] = { unicodeslot=0x0B92, category='lo', description='TAMIL LETTER O' },
	[0x0B93] = { unicodeslot=0x0B93, category='lo', description='TAMIL LETTER OO' },
	[0x0B94] = { unicodeslot=0x0B94, category='lo', description='TAMIL LETTER AU', specials={'char',0x0B92,0x0BD7} },
	[0x0B95] = { unicodeslot=0x0B95, category='lo', description='TAMIL LETTER KA' },
	[0x0B99] = { unicodeslot=0x0B99, category='lo', description='TAMIL LETTER NGA' },
	[0x0B9A] = { unicodeslot=0x0B9A, category='lo', description='TAMIL LETTER CA' },
	[0x0B9C] = { unicodeslot=0x0B9C, category='lo', description='TAMIL LETTER JA' },
	[0x0B9E] = { unicodeslot=0x0B9E, category='lo', description='TAMIL LETTER NYA' },
	[0x0B9F] = { unicodeslot=0x0B9F, category='lo', description='TAMIL LETTER TTA' },
	[0x0BA3] = { unicodeslot=0x0BA3, category='lo', description='TAMIL LETTER NNA' },
	[0x0BA4] = { unicodeslot=0x0BA4, category='lo', description='TAMIL LETTER TA' },
	[0x0BA8] = { unicodeslot=0x0BA8, category='lo', description='TAMIL LETTER NA' },
	[0x0BA9] = { unicodeslot=0x0BA9, category='lo', description='TAMIL LETTER NNNA' },
	[0x0BAA] = { unicodeslot=0x0BAA, category='lo', description='TAMIL LETTER PA' },
	[0x0BAE] = { unicodeslot=0x0BAE, category='lo', description='TAMIL LETTER MA' },
	[0x0BAF] = { unicodeslot=0x0BAF, category='lo', description='TAMIL LETTER YA' },
	[0x0BB0] = { unicodeslot=0x0BB0, category='lo', description='TAMIL LETTER RA' },
	[0x0BB1] = { unicodeslot=0x0BB1, category='lo', description='TAMIL LETTER RRA' },
	[0x0BB2] = { unicodeslot=0x0BB2, category='lo', description='TAMIL LETTER LA' },
	[0x0BB3] = { unicodeslot=0x0BB3, category='lo', description='TAMIL LETTER LLA' },
	[0x0BB4] = { unicodeslot=0x0BB4, category='lo', description='TAMIL LETTER LLLA' },
	[0x0BB5] = { unicodeslot=0x0BB5, category='lo', description='TAMIL LETTER VA' },
	[0x0BB6] = { unicodeslot=0x0BB6, category='lo', description='TAMIL LETTER SHA' },
	[0x0BB7] = { unicodeslot=0x0BB7, category='lo', description='TAMIL LETTER SSA' },
	[0x0BB8] = { unicodeslot=0x0BB8, category='lo', description='TAMIL LETTER SA' },
	[0x0BB9] = { unicodeslot=0x0BB9, category='lo', description='TAMIL LETTER HA' },
	[0x0BBE] = { unicodeslot=0x0BBE, category='mc', description='TAMIL VOWEL SIGN AA' },
	[0x0BBF] = { unicodeslot=0x0BBF, category='mc', description='TAMIL VOWEL SIGN I' },
	[0x0BC0] = { unicodeslot=0x0BC0, category='mn', description='TAMIL VOWEL SIGN II' },
	[0x0BC1] = { unicodeslot=0x0BC1, category='mc', description='TAMIL VOWEL SIGN U' },
	[0x0BC2] = { unicodeslot=0x0BC2, category='mc', description='TAMIL VOWEL SIGN UU' },
	[0x0BC6] = { unicodeslot=0x0BC6, category='mc', description='TAMIL VOWEL SIGN E' },
	[0x0BC7] = { unicodeslot=0x0BC7, category='mc', description='TAMIL VOWEL SIGN EE' },
	[0x0BC8] = { unicodeslot=0x0BC8, category='mc', description='TAMIL VOWEL SIGN AI' },
	[0x0BCA] = { unicodeslot=0x0BCA, category='mc', description='TAMIL VOWEL SIGN O', specials={'char',0x0BC6,0x0BBE} },
	[0x0BCB] = { unicodeslot=0x0BCB, category='mc', description='TAMIL VOWEL SIGN OO', specials={'char',0x0BC7,0x0BBE} },
	[0x0BCC] = { unicodeslot=0x0BCC, category='mc', description='TAMIL VOWEL SIGN AU', specials={'char',0x0BC6,0x0BD7} },
	[0x0BCD] = { unicodeslot=0x0BCD, category='mn', description='TAMIL SIGN VIRAMA' },
	[0x0BD7] = { unicodeslot=0x0BD7, category='mc', description='TAMIL AU LENGTH MARK' },
	[0x0BE6] = { unicodeslot=0x0BE6, category='nd', description='TAMIL DIGIT ZERO' },
	[0x0BE7] = { unicodeslot=0x0BE7, category='nd', description='TAMIL DIGIT ONE' },
	[0x0BE8] = { unicodeslot=0x0BE8, category='nd', description='TAMIL DIGIT TWO' },
	[0x0BE9] = { unicodeslot=0x0BE9, category='nd', description='TAMIL DIGIT THREE' },
	[0x0BEA] = { unicodeslot=0x0BEA, category='nd', description='TAMIL DIGIT FOUR' },
	[0x0BEB] = { unicodeslot=0x0BEB, category='nd', description='TAMIL DIGIT FIVE' },
	[0x0BEC] = { unicodeslot=0x0BEC, category='nd', description='TAMIL DIGIT SIX' },
	[0x0BED] = { unicodeslot=0x0BED, category='nd', description='TAMIL DIGIT SEVEN' },
	[0x0BEE] = { unicodeslot=0x0BEE, category='nd', description='TAMIL DIGIT EIGHT' },
	[0x0BEF] = { unicodeslot=0x0BEF, category='nd', description='TAMIL DIGIT NINE' },
	[0x0BF0] = { unicodeslot=0x0BF0, category='no', description='TAMIL NUMBER TEN' },
	[0x0BF1] = { unicodeslot=0x0BF1, category='no', description='TAMIL NUMBER ONE HUNDRED' },
	[0x0BF2] = { unicodeslot=0x0BF2, category='no', description='TAMIL NUMBER ONE THOUSAND' },
	[0x0BF3] = { unicodeslot=0x0BF3, category='so', description='TAMIL DAY SIGN' },
	[0x0BF4] = { unicodeslot=0x0BF4, category='so', description='TAMIL MONTH SIGN' },
	[0x0BF5] = { unicodeslot=0x0BF5, category='so', description='TAMIL YEAR SIGN' },
	[0x0BF6] = { unicodeslot=0x0BF6, category='so', description='TAMIL DEBIT SIGN' },
	[0x0BF7] = { unicodeslot=0x0BF7, category='so', description='TAMIL CREDIT SIGN' },
	[0x0BF8] = { unicodeslot=0x0BF8, category='so', description='TAMIL AS ABOVE SIGN' },
	[0x0BF9] = { unicodeslot=0x0BF9, category='sc', description='TAMIL RUPEE SIGN' },
	[0x0BFA] = { unicodeslot=0x0BFA, category='so', description='TAMIL NUMBER SIGN' },
	[0x0C01] = { unicodeslot=0x0C01, category='mc', description='TELUGU SIGN CANDRABINDU' },
	[0x0C02] = { unicodeslot=0x0C02, category='mc', description='TELUGU SIGN ANUSVARA' },
	[0x0C03] = { unicodeslot=0x0C03, category='mc', description='TELUGU SIGN VISARGA' },
	[0x0C05] = { unicodeslot=0x0C05, category='lo', description='TELUGU LETTER A' },
	[0x0C06] = { unicodeslot=0x0C06, category='lo', description='TELUGU LETTER AA' },
	[0x0C07] = { unicodeslot=0x0C07, category='lo', description='TELUGU LETTER I' },
	[0x0C08] = { unicodeslot=0x0C08, category='lo', description='TELUGU LETTER II' },
	[0x0C09] = { unicodeslot=0x0C09, category='lo', description='TELUGU LETTER U' },
	[0x0C0A] = { unicodeslot=0x0C0A, category='lo', description='TELUGU LETTER UU' },
	[0x0C0B] = { unicodeslot=0x0C0B, category='lo', description='TELUGU LETTER VOCALIC R' },
	[0x0C0C] = { unicodeslot=0x0C0C, category='lo', description='TELUGU LETTER VOCALIC L' },
	[0x0C0E] = { unicodeslot=0x0C0E, category='lo', description='TELUGU LETTER E' },
	[0x0C0F] = { unicodeslot=0x0C0F, category='lo', description='TELUGU LETTER EE' },
	[0x0C10] = { unicodeslot=0x0C10, category='lo', description='TELUGU LETTER AI' },
	[0x0C12] = { unicodeslot=0x0C12, category='lo', description='TELUGU LETTER O' },
	[0x0C13] = { unicodeslot=0x0C13, category='lo', description='TELUGU LETTER OO' },
	[0x0C14] = { unicodeslot=0x0C14, category='lo', description='TELUGU LETTER AU' },
	[0x0C15] = { unicodeslot=0x0C15, category='lo', description='TELUGU LETTER KA' },
	[0x0C16] = { unicodeslot=0x0C16, category='lo', description='TELUGU LETTER KHA' },
	[0x0C17] = { unicodeslot=0x0C17, category='lo', description='TELUGU LETTER GA' },
	[0x0C18] = { unicodeslot=0x0C18, category='lo', description='TELUGU LETTER GHA' },
	[0x0C19] = { unicodeslot=0x0C19, category='lo', description='TELUGU LETTER NGA' },
	[0x0C1A] = { unicodeslot=0x0C1A, category='lo', description='TELUGU LETTER CA' },
	[0x0C1B] = { unicodeslot=0x0C1B, category='lo', description='TELUGU LETTER CHA' },
	[0x0C1C] = { unicodeslot=0x0C1C, category='lo', description='TELUGU LETTER JA' },
	[0x0C1D] = { unicodeslot=0x0C1D, category='lo', description='TELUGU LETTER JHA' },
	[0x0C1E] = { unicodeslot=0x0C1E, category='lo', description='TELUGU LETTER NYA' },
	[0x0C1F] = { unicodeslot=0x0C1F, category='lo', description='TELUGU LETTER TTA' },
	[0x0C20] = { unicodeslot=0x0C20, category='lo', description='TELUGU LETTER TTHA' },
	[0x0C21] = { unicodeslot=0x0C21, category='lo', description='TELUGU LETTER DDA' },
	[0x0C22] = { unicodeslot=0x0C22, category='lo', description='TELUGU LETTER DDHA' },
	[0x0C23] = { unicodeslot=0x0C23, category='lo', description='TELUGU LETTER NNA' },
	[0x0C24] = { unicodeslot=0x0C24, category='lo', description='TELUGU LETTER TA' },
	[0x0C25] = { unicodeslot=0x0C25, category='lo', description='TELUGU LETTER THA' },
	[0x0C26] = { unicodeslot=0x0C26, category='lo', description='TELUGU LETTER DA' },
	[0x0C27] = { unicodeslot=0x0C27, category='lo', description='TELUGU LETTER DHA' },
	[0x0C28] = { unicodeslot=0x0C28, category='lo', description='TELUGU LETTER NA' },
	[0x0C2A] = { unicodeslot=0x0C2A, category='lo', description='TELUGU LETTER PA' },
	[0x0C2B] = { unicodeslot=0x0C2B, category='lo', description='TELUGU LETTER PHA' },
	[0x0C2C] = { unicodeslot=0x0C2C, category='lo', description='TELUGU LETTER BA' },
	[0x0C2D] = { unicodeslot=0x0C2D, category='lo', description='TELUGU LETTER BHA' },
	[0x0C2E] = { unicodeslot=0x0C2E, category='lo', description='TELUGU LETTER MA' },
	[0x0C2F] = { unicodeslot=0x0C2F, category='lo', description='TELUGU LETTER YA' },
	[0x0C30] = { unicodeslot=0x0C30, category='lo', description='TELUGU LETTER RA' },
	[0x0C31] = { unicodeslot=0x0C31, category='lo', description='TELUGU LETTER RRA' },
	[0x0C32] = { unicodeslot=0x0C32, category='lo', description='TELUGU LETTER LA' },
	[0x0C33] = { unicodeslot=0x0C33, category='lo', description='TELUGU LETTER LLA' },
	[0x0C35] = { unicodeslot=0x0C35, category='lo', description='TELUGU LETTER VA' },
	[0x0C36] = { unicodeslot=0x0C36, category='lo', description='TELUGU LETTER SHA' },
	[0x0C37] = { unicodeslot=0x0C37, category='lo', description='TELUGU LETTER SSA' },
	[0x0C38] = { unicodeslot=0x0C38, category='lo', description='TELUGU LETTER SA' },
	[0x0C39] = { unicodeslot=0x0C39, category='lo', description='TELUGU LETTER HA' },
	[0x0C3E] = { unicodeslot=0x0C3E, category='mn', description='TELUGU VOWEL SIGN AA' },
	[0x0C3F] = { unicodeslot=0x0C3F, category='mn', description='TELUGU VOWEL SIGN I' },
	[0x0C40] = { unicodeslot=0x0C40, category='mn', description='TELUGU VOWEL SIGN II' },
	[0x0C41] = { unicodeslot=0x0C41, category='mc', description='TELUGU VOWEL SIGN U' },
	[0x0C42] = { unicodeslot=0x0C42, category='mc', description='TELUGU VOWEL SIGN UU' },
	[0x0C43] = { unicodeslot=0x0C43, category='mc', description='TELUGU VOWEL SIGN VOCALIC R' },
	[0x0C44] = { unicodeslot=0x0C44, category='mc', description='TELUGU VOWEL SIGN VOCALIC RR' },
	[0x0C46] = { unicodeslot=0x0C46, category='mn', description='TELUGU VOWEL SIGN E' },
	[0x0C47] = { unicodeslot=0x0C47, category='mn', description='TELUGU VOWEL SIGN EE' },
	[0x0C48] = { unicodeslot=0x0C48, category='mn', description='TELUGU VOWEL SIGN AI', specials={'char',0x0C46,0x0C56} },
	[0x0C4A] = { unicodeslot=0x0C4A, category='mn', description='TELUGU VOWEL SIGN O' },
	[0x0C4B] = { unicodeslot=0x0C4B, category='mn', description='TELUGU VOWEL SIGN OO' },
	[0x0C4C] = { unicodeslot=0x0C4C, category='mn', description='TELUGU VOWEL SIGN AU' },
	[0x0C4D] = { unicodeslot=0x0C4D, category='mn', description='TELUGU SIGN VIRAMA' },
	[0x0C55] = { unicodeslot=0x0C55, category='mn', description='TELUGU LENGTH MARK' },
	[0x0C56] = { unicodeslot=0x0C56, category='mn', description='TELUGU AI LENGTH MARK' },
	[0x0C60] = { unicodeslot=0x0C60, category='lo', description='TELUGU LETTER VOCALIC RR' },
	[0x0C61] = { unicodeslot=0x0C61, category='lo', description='TELUGU LETTER VOCALIC LL' },
	[0x0C66] = { unicodeslot=0x0C66, category='nd', description='TELUGU DIGIT ZERO' },
	[0x0C67] = { unicodeslot=0x0C67, category='nd', description='TELUGU DIGIT ONE' },
	[0x0C68] = { unicodeslot=0x0C68, category='nd', description='TELUGU DIGIT TWO' },
	[0x0C69] = { unicodeslot=0x0C69, category='nd', description='TELUGU DIGIT THREE' },
	[0x0C6A] = { unicodeslot=0x0C6A, category='nd', description='TELUGU DIGIT FOUR' },
	[0x0C6B] = { unicodeslot=0x0C6B, category='nd', description='TELUGU DIGIT FIVE' },
	[0x0C6C] = { unicodeslot=0x0C6C, category='nd', description='TELUGU DIGIT SIX' },
	[0x0C6D] = { unicodeslot=0x0C6D, category='nd', description='TELUGU DIGIT SEVEN' },
	[0x0C6E] = { unicodeslot=0x0C6E, category='nd', description='TELUGU DIGIT EIGHT' },
	[0x0C6F] = { unicodeslot=0x0C6F, category='nd', description='TELUGU DIGIT NINE' },
	[0x0C82] = { unicodeslot=0x0C82, category='mc', description='KANNADA SIGN ANUSVARA' },
	[0x0C83] = { unicodeslot=0x0C83, category='mc', description='KANNADA SIGN VISARGA' },
	[0x0C85] = { unicodeslot=0x0C85, category='lo', description='KANNADA LETTER A' },
	[0x0C86] = { unicodeslot=0x0C86, category='lo', description='KANNADA LETTER AA' },
	[0x0C87] = { unicodeslot=0x0C87, category='lo', description='KANNADA LETTER I' },
	[0x0C88] = { unicodeslot=0x0C88, category='lo', description='KANNADA LETTER II' },
	[0x0C89] = { unicodeslot=0x0C89, category='lo', description='KANNADA LETTER U' },
	[0x0C8A] = { unicodeslot=0x0C8A, category='lo', description='KANNADA LETTER UU' },
	[0x0C8B] = { unicodeslot=0x0C8B, category='lo', description='KANNADA LETTER VOCALIC R' },
	[0x0C8C] = { unicodeslot=0x0C8C, category='lo', description='KANNADA LETTER VOCALIC L' },
	[0x0C8E] = { unicodeslot=0x0C8E, category='lo', description='KANNADA LETTER E' },
	[0x0C8F] = { unicodeslot=0x0C8F, category='lo', description='KANNADA LETTER EE' },
	[0x0C90] = { unicodeslot=0x0C90, category='lo', description='KANNADA LETTER AI' },
	[0x0C92] = { unicodeslot=0x0C92, category='lo', description='KANNADA LETTER O' },
	[0x0C93] = { unicodeslot=0x0C93, category='lo', description='KANNADA LETTER OO' },
	[0x0C94] = { unicodeslot=0x0C94, category='lo', description='KANNADA LETTER AU' },
	[0x0C95] = { unicodeslot=0x0C95, category='lo', description='KANNADA LETTER KA' },
	[0x0C96] = { unicodeslot=0x0C96, category='lo', description='KANNADA LETTER KHA' },
	[0x0C97] = { unicodeslot=0x0C97, category='lo', description='KANNADA LETTER GA' },
	[0x0C98] = { unicodeslot=0x0C98, category='lo', description='KANNADA LETTER GHA' },
	[0x0C99] = { unicodeslot=0x0C99, category='lo', description='KANNADA LETTER NGA' },
	[0x0C9A] = { unicodeslot=0x0C9A, category='lo', description='KANNADA LETTER CA' },
	[0x0C9B] = { unicodeslot=0x0C9B, category='lo', description='KANNADA LETTER CHA' },
	[0x0C9C] = { unicodeslot=0x0C9C, category='lo', description='KANNADA LETTER JA' },
	[0x0C9D] = { unicodeslot=0x0C9D, category='lo', description='KANNADA LETTER JHA' },
	[0x0C9E] = { unicodeslot=0x0C9E, category='lo', description='KANNADA LETTER NYA' },
	[0x0C9F] = { unicodeslot=0x0C9F, category='lo', description='KANNADA LETTER TTA' },
	[0x0CA0] = { unicodeslot=0x0CA0, category='lo', description='KANNADA LETTER TTHA' },
	[0x0CA1] = { unicodeslot=0x0CA1, category='lo', description='KANNADA LETTER DDA' },
	[0x0CA2] = { unicodeslot=0x0CA2, category='lo', description='KANNADA LETTER DDHA' },
	[0x0CA3] = { unicodeslot=0x0CA3, category='lo', description='KANNADA LETTER NNA' },
	[0x0CA4] = { unicodeslot=0x0CA4, category='lo', description='KANNADA LETTER TA' },
	[0x0CA5] = { unicodeslot=0x0CA5, category='lo', description='KANNADA LETTER THA' },
	[0x0CA6] = { unicodeslot=0x0CA6, category='lo', description='KANNADA LETTER DA' },
	[0x0CA7] = { unicodeslot=0x0CA7, category='lo', description='KANNADA LETTER DHA' },
	[0x0CA8] = { unicodeslot=0x0CA8, category='lo', description='KANNADA LETTER NA' },
	[0x0CAA] = { unicodeslot=0x0CAA, category='lo', description='KANNADA LETTER PA' },
	[0x0CAB] = { unicodeslot=0x0CAB, category='lo', description='KANNADA LETTER PHA' },
	[0x0CAC] = { unicodeslot=0x0CAC, category='lo', description='KANNADA LETTER BA' },
	[0x0CAD] = { unicodeslot=0x0CAD, category='lo', description='KANNADA LETTER BHA' },
	[0x0CAE] = { unicodeslot=0x0CAE, category='lo', description='KANNADA LETTER MA' },
	[0x0CAF] = { unicodeslot=0x0CAF, category='lo', description='KANNADA LETTER YA' },
	[0x0CB0] = { unicodeslot=0x0CB0, category='lo', description='KANNADA LETTER RA' },
	[0x0CB1] = { unicodeslot=0x0CB1, category='lo', description='KANNADA LETTER RRA' },
	[0x0CB2] = { unicodeslot=0x0CB2, category='lo', description='KANNADA LETTER LA' },
	[0x0CB3] = { unicodeslot=0x0CB3, category='lo', description='KANNADA LETTER LLA' },
	[0x0CB5] = { unicodeslot=0x0CB5, category='lo', description='KANNADA LETTER VA' },
	[0x0CB6] = { unicodeslot=0x0CB6, category='lo', description='KANNADA LETTER SHA' },
	[0x0CB7] = { unicodeslot=0x0CB7, category='lo', description='KANNADA LETTER SSA' },
	[0x0CB8] = { unicodeslot=0x0CB8, category='lo', description='KANNADA LETTER SA' },
	[0x0CB9] = { unicodeslot=0x0CB9, category='lo', description='KANNADA LETTER HA' },
	[0x0CBC] = { unicodeslot=0x0CBC, category='mn', description='KANNADA SIGN NUKTA' },
	[0x0CBD] = { unicodeslot=0x0CBD, category='lo', description='KANNADA SIGN AVAGRAHA' },
	[0x0CBE] = { unicodeslot=0x0CBE, category='mc', description='KANNADA VOWEL SIGN AA' },
	[0x0CBF] = { unicodeslot=0x0CBF, category='mn', description='KANNADA VOWEL SIGN I' },
	[0x0CC0] = { unicodeslot=0x0CC0, category='mc', description='KANNADA VOWEL SIGN II', specials={'char',0x0CBF,0x0CD5} },
	[0x0CC1] = { unicodeslot=0x0CC1, category='mc', description='KANNADA VOWEL SIGN U' },
	[0x0CC2] = { unicodeslot=0x0CC2, category='mc', description='KANNADA VOWEL SIGN UU' },
	[0x0CC3] = { unicodeslot=0x0CC3, category='mc', description='KANNADA VOWEL SIGN VOCALIC R' },
	[0x0CC4] = { unicodeslot=0x0CC4, category='mc', description='KANNADA VOWEL SIGN VOCALIC RR' },
	[0x0CC6] = { unicodeslot=0x0CC6, category='mn', description='KANNADA VOWEL SIGN E' },
	[0x0CC7] = { unicodeslot=0x0CC7, category='mc', description='KANNADA VOWEL SIGN EE', specials={'char',0x0CC6,0x0CD5} },
	[0x0CC8] = { unicodeslot=0x0CC8, category='mc', description='KANNADA VOWEL SIGN AI', specials={'char',0x0CC6,0x0CD6} },
	[0x0CCA] = { unicodeslot=0x0CCA, category='mc', description='KANNADA VOWEL SIGN O', specials={'char',0x0CC6,0x0CC2} },
	[0x0CCB] = { unicodeslot=0x0CCB, category='mc', description='KANNADA VOWEL SIGN OO', specials={'char',0x0CCA,0x0CD5} },
	[0x0CCC] = { unicodeslot=0x0CCC, category='mn', description='KANNADA VOWEL SIGN AU' },
	[0x0CCD] = { unicodeslot=0x0CCD, category='mn', description='KANNADA SIGN VIRAMA' },
	[0x0CD5] = { unicodeslot=0x0CD5, category='mc', description='KANNADA LENGTH MARK' },
	[0x0CD6] = { unicodeslot=0x0CD6, category='mc', description='KANNADA AI LENGTH MARK' },
	[0x0CDE] = { unicodeslot=0x0CDE, category='lo', description='KANNADA LETTER FA' },
	[0x0CE0] = { unicodeslot=0x0CE0, category='lo', description='KANNADA LETTER VOCALIC RR' },
	[0x0CE1] = { unicodeslot=0x0CE1, category='lo', description='KANNADA LETTER VOCALIC LL' },
	[0x0CE2] = { unicodeslot=0x0CE2, category='mn', description='KANNADA VOWEL SIGN VOCALIC L' },
	[0x0CE3] = { unicodeslot=0x0CE3, category='mn', description='KANNADA VOWEL SIGN VOCALIC LL' },
	[0x0CE6] = { unicodeslot=0x0CE6, category='nd', description='KANNADA DIGIT ZERO' },
	[0x0CE7] = { unicodeslot=0x0CE7, category='nd', description='KANNADA DIGIT ONE' },
	[0x0CE8] = { unicodeslot=0x0CE8, category='nd', description='KANNADA DIGIT TWO' },
	[0x0CE9] = { unicodeslot=0x0CE9, category='nd', description='KANNADA DIGIT THREE' },
	[0x0CEA] = { unicodeslot=0x0CEA, category='nd', description='KANNADA DIGIT FOUR' },
	[0x0CEB] = { unicodeslot=0x0CEB, category='nd', description='KANNADA DIGIT FIVE' },
	[0x0CEC] = { unicodeslot=0x0CEC, category='nd', description='KANNADA DIGIT SIX' },
	[0x0CED] = { unicodeslot=0x0CED, category='nd', description='KANNADA DIGIT SEVEN' },
	[0x0CEE] = { unicodeslot=0x0CEE, category='nd', description='KANNADA DIGIT EIGHT' },
	[0x0CEF] = { unicodeslot=0x0CEF, category='nd', description='KANNADA DIGIT NINE' },
	[0x0CF1] = { unicodeslot=0x0CF1, category='so', description='KANNADA SIGN JIHVAMULIYA' },
	[0x0CF2] = { unicodeslot=0x0CF2, category='so', description='KANNADA SIGN UPADHMANIYA' },
	[0x0D02] = { unicodeslot=0x0D02, category='mc', description='MALAYALAM SIGN ANUSVARA' },
	[0x0D03] = { unicodeslot=0x0D03, category='mc', description='MALAYALAM SIGN VISARGA' },
	[0x0D05] = { unicodeslot=0x0D05, category='lo', description='MALAYALAM LETTER A' },
	[0x0D06] = { unicodeslot=0x0D06, category='lo', description='MALAYALAM LETTER AA' },
	[0x0D07] = { unicodeslot=0x0D07, category='lo', description='MALAYALAM LETTER I' },
	[0x0D08] = { unicodeslot=0x0D08, category='lo', description='MALAYALAM LETTER II' },
	[0x0D09] = { unicodeslot=0x0D09, category='lo', description='MALAYALAM LETTER U' },
	[0x0D0A] = { unicodeslot=0x0D0A, category='lo', description='MALAYALAM LETTER UU' },
	[0x0D0B] = { unicodeslot=0x0D0B, category='lo', description='MALAYALAM LETTER VOCALIC R' },
	[0x0D0C] = { unicodeslot=0x0D0C, category='lo', description='MALAYALAM LETTER VOCALIC L' },
	[0x0D0E] = { unicodeslot=0x0D0E, category='lo', description='MALAYALAM LETTER E' },
	[0x0D0F] = { unicodeslot=0x0D0F, category='lo', description='MALAYALAM LETTER EE' },
	[0x0D10] = { unicodeslot=0x0D10, category='lo', description='MALAYALAM LETTER AI' },
	[0x0D12] = { unicodeslot=0x0D12, category='lo', description='MALAYALAM LETTER O' },
	[0x0D13] = { unicodeslot=0x0D13, category='lo', description='MALAYALAM LETTER OO' },
	[0x0D14] = { unicodeslot=0x0D14, category='lo', description='MALAYALAM LETTER AU' },
	[0x0D15] = { unicodeslot=0x0D15, category='lo', description='MALAYALAM LETTER KA' },
	[0x0D16] = { unicodeslot=0x0D16, category='lo', description='MALAYALAM LETTER KHA' },
	[0x0D17] = { unicodeslot=0x0D17, category='lo', description='MALAYALAM LETTER GA' },
	[0x0D18] = { unicodeslot=0x0D18, category='lo', description='MALAYALAM LETTER GHA' },
	[0x0D19] = { unicodeslot=0x0D19, category='lo', description='MALAYALAM LETTER NGA' },
	[0x0D1A] = { unicodeslot=0x0D1A, category='lo', description='MALAYALAM LETTER CA' },
	[0x0D1B] = { unicodeslot=0x0D1B, category='lo', description='MALAYALAM LETTER CHA' },
	[0x0D1C] = { unicodeslot=0x0D1C, category='lo', description='MALAYALAM LETTER JA' },
	[0x0D1D] = { unicodeslot=0x0D1D, category='lo', description='MALAYALAM LETTER JHA' },
	[0x0D1E] = { unicodeslot=0x0D1E, category='lo', description='MALAYALAM LETTER NYA' },
	[0x0D1F] = { unicodeslot=0x0D1F, category='lo', description='MALAYALAM LETTER TTA' },
	[0x0D20] = { unicodeslot=0x0D20, category='lo', description='MALAYALAM LETTER TTHA' },
	[0x0D21] = { unicodeslot=0x0D21, category='lo', description='MALAYALAM LETTER DDA' },
	[0x0D22] = { unicodeslot=0x0D22, category='lo', description='MALAYALAM LETTER DDHA' },
	[0x0D23] = { unicodeslot=0x0D23, category='lo', description='MALAYALAM LETTER NNA' },
	[0x0D24] = { unicodeslot=0x0D24, category='lo', description='MALAYALAM LETTER TA' },
	[0x0D25] = { unicodeslot=0x0D25, category='lo', description='MALAYALAM LETTER THA' },
	[0x0D26] = { unicodeslot=0x0D26, category='lo', description='MALAYALAM LETTER DA' },
	[0x0D27] = { unicodeslot=0x0D27, category='lo', description='MALAYALAM LETTER DHA' },
	[0x0D28] = { unicodeslot=0x0D28, category='lo', description='MALAYALAM LETTER NA' },
	[0x0D2A] = { unicodeslot=0x0D2A, category='lo', description='MALAYALAM LETTER PA' },
	[0x0D2B] = { unicodeslot=0x0D2B, category='lo', description='MALAYALAM LETTER PHA' },
	[0x0D2C] = { unicodeslot=0x0D2C, category='lo', description='MALAYALAM LETTER BA' },
	[0x0D2D] = { unicodeslot=0x0D2D, category='lo', description='MALAYALAM LETTER BHA' },
	[0x0D2E] = { unicodeslot=0x0D2E, category='lo', description='MALAYALAM LETTER MA' },
	[0x0D2F] = { unicodeslot=0x0D2F, category='lo', description='MALAYALAM LETTER YA' },
	[0x0D30] = { unicodeslot=0x0D30, category='lo', description='MALAYALAM LETTER RA' },
	[0x0D31] = { unicodeslot=0x0D31, category='lo', description='MALAYALAM LETTER RRA' },
	[0x0D32] = { unicodeslot=0x0D32, category='lo', description='MALAYALAM LETTER LA' },
	[0x0D33] = { unicodeslot=0x0D33, category='lo', description='MALAYALAM LETTER LLA' },
	[0x0D34] = { unicodeslot=0x0D34, category='lo', description='MALAYALAM LETTER LLLA' },
	[0x0D35] = { unicodeslot=0x0D35, category='lo', description='MALAYALAM LETTER VA' },
	[0x0D36] = { unicodeslot=0x0D36, category='lo', description='MALAYALAM LETTER SHA' },
	[0x0D37] = { unicodeslot=0x0D37, category='lo', description='MALAYALAM LETTER SSA' },
	[0x0D38] = { unicodeslot=0x0D38, category='lo', description='MALAYALAM LETTER SA' },
	[0x0D39] = { unicodeslot=0x0D39, category='lo', description='MALAYALAM LETTER HA' },
	[0x0D3E] = { unicodeslot=0x0D3E, category='mc', description='MALAYALAM VOWEL SIGN AA' },
	[0x0D3F] = { unicodeslot=0x0D3F, category='mc', description='MALAYALAM VOWEL SIGN I' },
	[0x0D40] = { unicodeslot=0x0D40, category='mc', description='MALAYALAM VOWEL SIGN II' },
	[0x0D41] = { unicodeslot=0x0D41, category='mn', description='MALAYALAM VOWEL SIGN U' },
	[0x0D42] = { unicodeslot=0x0D42, category='mn', description='MALAYALAM VOWEL SIGN UU' },
	[0x0D43] = { unicodeslot=0x0D43, category='mn', description='MALAYALAM VOWEL SIGN VOCALIC R' },
	[0x0D46] = { unicodeslot=0x0D46, category='mc', description='MALAYALAM VOWEL SIGN E' },
	[0x0D47] = { unicodeslot=0x0D47, category='mc', description='MALAYALAM VOWEL SIGN EE' },
	[0x0D48] = { unicodeslot=0x0D48, category='mc', description='MALAYALAM VOWEL SIGN AI' },
	[0x0D4A] = { unicodeslot=0x0D4A, category='mc', description='MALAYALAM VOWEL SIGN O', specials={'char',0x0D46,0x0D3E} },
	[0x0D4B] = { unicodeslot=0x0D4B, category='mc', description='MALAYALAM VOWEL SIGN OO', specials={'char',0x0D47,0x0D3E} },
	[0x0D4C] = { unicodeslot=0x0D4C, category='mc', description='MALAYALAM VOWEL SIGN AU', specials={'char',0x0D46,0x0D57} },
	[0x0D4D] = { unicodeslot=0x0D4D, category='mn', description='MALAYALAM SIGN VIRAMA' },
	[0x0D57] = { unicodeslot=0x0D57, category='mc', description='MALAYALAM AU LENGTH MARK' },
	[0x0D60] = { unicodeslot=0x0D60, category='lo', description='MALAYALAM LETTER VOCALIC RR' },
	[0x0D61] = { unicodeslot=0x0D61, category='lo', description='MALAYALAM LETTER VOCALIC LL' },
	[0x0D66] = { unicodeslot=0x0D66, category='nd', description='MALAYALAM DIGIT ZERO' },
	[0x0D67] = { unicodeslot=0x0D67, category='nd', description='MALAYALAM DIGIT ONE' },
	[0x0D68] = { unicodeslot=0x0D68, category='nd', description='MALAYALAM DIGIT TWO' },
	[0x0D69] = { unicodeslot=0x0D69, category='nd', description='MALAYALAM DIGIT THREE' },
	[0x0D6A] = { unicodeslot=0x0D6A, category='nd', description='MALAYALAM DIGIT FOUR' },
	[0x0D6B] = { unicodeslot=0x0D6B, category='nd', description='MALAYALAM DIGIT FIVE' },
	[0x0D6C] = { unicodeslot=0x0D6C, category='nd', description='MALAYALAM DIGIT SIX' },
	[0x0D6D] = { unicodeslot=0x0D6D, category='nd', description='MALAYALAM DIGIT SEVEN' },
	[0x0D6E] = { unicodeslot=0x0D6E, category='nd', description='MALAYALAM DIGIT EIGHT' },
	[0x0D6F] = { unicodeslot=0x0D6F, category='nd', description='MALAYALAM DIGIT NINE' },
	[0x0D82] = { unicodeslot=0x0D82, category='mc', description='SINHALA SIGN ANUSVARAYA' },
	[0x0D83] = { unicodeslot=0x0D83, category='mc', description='SINHALA SIGN VISARGAYA' },
	[0x0D85] = { unicodeslot=0x0D85, category='lo', description='SINHALA LETTER AYANNA' },
	[0x0D86] = { unicodeslot=0x0D86, category='lo', description='SINHALA LETTER AAYANNA' },
	[0x0D87] = { unicodeslot=0x0D87, category='lo', description='SINHALA LETTER AEYANNA' },
	[0x0D88] = { unicodeslot=0x0D88, category='lo', description='SINHALA LETTER AEEYANNA' },
	[0x0D89] = { unicodeslot=0x0D89, category='lo', description='SINHALA LETTER IYANNA' },
	[0x0D8A] = { unicodeslot=0x0D8A, category='lo', description='SINHALA LETTER IIYANNA' },
	[0x0D8B] = { unicodeslot=0x0D8B, category='lo', description='SINHALA LETTER UYANNA' },
	[0x0D8C] = { unicodeslot=0x0D8C, category='lo', description='SINHALA LETTER UUYANNA' },
	[0x0D8D] = { unicodeslot=0x0D8D, category='lo', description='SINHALA LETTER IRUYANNA' },
	[0x0D8E] = { unicodeslot=0x0D8E, category='lo', description='SINHALA LETTER IRUUYANNA' },
	[0x0D8F] = { unicodeslot=0x0D8F, category='lo', description='SINHALA LETTER ILUYANNA' },
	[0x0D90] = { unicodeslot=0x0D90, category='lo', description='SINHALA LETTER ILUUYANNA' },
	[0x0D91] = { unicodeslot=0x0D91, category='lo', description='SINHALA LETTER EYANNA' },
	[0x0D92] = { unicodeslot=0x0D92, category='lo', description='SINHALA LETTER EEYANNA' },
	[0x0D93] = { unicodeslot=0x0D93, category='lo', description='SINHALA LETTER AIYANNA' },
	[0x0D94] = { unicodeslot=0x0D94, category='lo', description='SINHALA LETTER OYANNA' },
	[0x0D95] = { unicodeslot=0x0D95, category='lo', description='SINHALA LETTER OOYANNA' },
	[0x0D96] = { unicodeslot=0x0D96, category='lo', description='SINHALA LETTER AUYANNA' },
	[0x0D9A] = { unicodeslot=0x0D9A, category='lo', description='SINHALA LETTER ALPAPRAANA KAYANNA' },
	[0x0D9B] = { unicodeslot=0x0D9B, category='lo', description='SINHALA LETTER MAHAAPRAANA KAYANNA' },
	[0x0D9C] = { unicodeslot=0x0D9C, category='lo', description='SINHALA LETTER ALPAPRAANA GAYANNA' },
	[0x0D9D] = { unicodeslot=0x0D9D, category='lo', description='SINHALA LETTER MAHAAPRAANA GAYANNA' },
	[0x0D9E] = { unicodeslot=0x0D9E, category='lo', description='SINHALA LETTER KANTAJA NAASIKYAYA' },
	[0x0D9F] = { unicodeslot=0x0D9F, category='lo', description='SINHALA LETTER SANYAKA GAYANNA' },
	[0x0DA0] = { unicodeslot=0x0DA0, category='lo', description='SINHALA LETTER ALPAPRAANA CAYANNA' },
	[0x0DA1] = { unicodeslot=0x0DA1, category='lo', description='SINHALA LETTER MAHAAPRAANA CAYANNA' },
	[0x0DA2] = { unicodeslot=0x0DA2, category='lo', description='SINHALA LETTER ALPAPRAANA JAYANNA' },
	[0x0DA3] = { unicodeslot=0x0DA3, category='lo', description='SINHALA LETTER MAHAAPRAANA JAYANNA' },
	[0x0DA4] = { unicodeslot=0x0DA4, category='lo', description='SINHALA LETTER TAALUJA NAASIKYAYA' },
	[0x0DA5] = { unicodeslot=0x0DA5, category='lo', description='SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA' },
	[0x0DA6] = { unicodeslot=0x0DA6, category='lo', description='SINHALA LETTER SANYAKA JAYANNA' },
	[0x0DA7] = { unicodeslot=0x0DA7, category='lo', description='SINHALA LETTER ALPAPRAANA TTAYANNA' },
	[0x0DA8] = { unicodeslot=0x0DA8, category='lo', description='SINHALA LETTER MAHAAPRAANA TTAYANNA' },
	[0x0DA9] = { unicodeslot=0x0DA9, category='lo', description='SINHALA LETTER ALPAPRAANA DDAYANNA' },
	[0x0DAA] = { unicodeslot=0x0DAA, category='lo', description='SINHALA LETTER MAHAAPRAANA DDAYANNA' },
	[0x0DAB] = { unicodeslot=0x0DAB, category='lo', description='SINHALA LETTER MUURDHAJA NAYANNA' },
	[0x0DAC] = { unicodeslot=0x0DAC, category='lo', description='SINHALA LETTER SANYAKA DDAYANNA' },
	[0x0DAD] = { unicodeslot=0x0DAD, category='lo', description='SINHALA LETTER ALPAPRAANA TAYANNA' },
	[0x0DAE] = { unicodeslot=0x0DAE, category='lo', description='SINHALA LETTER MAHAAPRAANA TAYANNA' },
	[0x0DAF] = { unicodeslot=0x0DAF, category='lo', description='SINHALA LETTER ALPAPRAANA DAYANNA' },
	[0x0DB0] = { unicodeslot=0x0DB0, category='lo', description='SINHALA LETTER MAHAAPRAANA DAYANNA' },
	[0x0DB1] = { unicodeslot=0x0DB1, category='lo', description='SINHALA LETTER DANTAJA NAYANNA' },
	[0x0DB3] = { unicodeslot=0x0DB3, category='lo', description='SINHALA LETTER SANYAKA DAYANNA' },
	[0x0DB4] = { unicodeslot=0x0DB4, category='lo', description='SINHALA LETTER ALPAPRAANA PAYANNA' },
	[0x0DB5] = { unicodeslot=0x0DB5, category='lo', description='SINHALA LETTER MAHAAPRAANA PAYANNA' },
	[0x0DB6] = { unicodeslot=0x0DB6, category='lo', description='SINHALA LETTER ALPAPRAANA BAYANNA' },
	[0x0DB7] = { unicodeslot=0x0DB7, category='lo', description='SINHALA LETTER MAHAAPRAANA BAYANNA' },
	[0x0DB8] = { unicodeslot=0x0DB8, category='lo', description='SINHALA LETTER MAYANNA' },
	[0x0DB9] = { unicodeslot=0x0DB9, category='lo', description='SINHALA LETTER AMBA BAYANNA' },
	[0x0DBA] = { unicodeslot=0x0DBA, category='lo', description='SINHALA LETTER YAYANNA' },
	[0x0DBB] = { unicodeslot=0x0DBB, category='lo', description='SINHALA LETTER RAYANNA' },
	[0x0DBD] = { unicodeslot=0x0DBD, category='lo', description='SINHALA LETTER DANTAJA LAYANNA' },
	[0x0DC0] = { unicodeslot=0x0DC0, category='lo', description='SINHALA LETTER VAYANNA' },
	[0x0DC1] = { unicodeslot=0x0DC1, category='lo', description='SINHALA LETTER TAALUJA SAYANNA' },
	[0x0DC2] = { unicodeslot=0x0DC2, category='lo', description='SINHALA LETTER MUURDHAJA SAYANNA' },
	[0x0DC3] = { unicodeslot=0x0DC3, category='lo', description='SINHALA LETTER DANTAJA SAYANNA' },
	[0x0DC4] = { unicodeslot=0x0DC4, category='lo', description='SINHALA LETTER HAYANNA' },
	[0x0DC5] = { unicodeslot=0x0DC5, category='lo', description='SINHALA LETTER MUURDHAJA LAYANNA' },
	[0x0DC6] = { unicodeslot=0x0DC6, category='lo', description='SINHALA LETTER FAYANNA' },
	[0x0DCA] = { unicodeslot=0x0DCA, category='mn', description='SINHALA SIGN AL-LAKUNA' },
	[0x0DCF] = { unicodeslot=0x0DCF, category='mc', description='SINHALA VOWEL SIGN AELA-PILLA' },
	[0x0DD0] = { unicodeslot=0x0DD0, category='mc', description='SINHALA VOWEL SIGN KETTI AEDA-PILLA' },
	[0x0DD1] = { unicodeslot=0x0DD1, category='mc', description='SINHALA VOWEL SIGN DIGA AEDA-PILLA' },
	[0x0DD2] = { unicodeslot=0x0DD2, category='mn', description='SINHALA VOWEL SIGN KETTI IS-PILLA' },
	[0x0DD3] = { unicodeslot=0x0DD3, category='mn', description='SINHALA VOWEL SIGN DIGA IS-PILLA' },
	[0x0DD4] = { unicodeslot=0x0DD4, category='mn', description='SINHALA VOWEL SIGN KETTI PAA-PILLA' },
	[0x0DD6] = { unicodeslot=0x0DD6, category='mn', description='SINHALA VOWEL SIGN DIGA PAA-PILLA' },
	[0x0DD8] = { unicodeslot=0x0DD8, category='mc', description='SINHALA VOWEL SIGN GAETTA-PILLA' },
	[0x0DD9] = { unicodeslot=0x0DD9, category='mc', description='SINHALA VOWEL SIGN KOMBUVA' },
	[0x0DDA] = { unicodeslot=0x0DDA, category='mc', description='SINHALA VOWEL SIGN DIGA KOMBUVA', specials={'char',0x0DD9,0x0DCA} },
	[0x0DDB] = { unicodeslot=0x0DDB, category='mc', description='SINHALA VOWEL SIGN KOMBU DEKA' },
	[0x0DDC] = { unicodeslot=0x0DDC, category='mc', description='SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA', specials={'char',0x0DD9,0x0DCF} },
	[0x0DDD] = { unicodeslot=0x0DDD, category='mc', description='SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA', specials={'char',0x0DDC,0x0DCA} },
	[0x0DDE] = { unicodeslot=0x0DDE, category='mc', description='SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA', specials={'char',0x0DD9,0x0DDF} },
	[0x0DDF] = { unicodeslot=0x0DDF, category='mc', description='SINHALA VOWEL SIGN GAYANUKITTA' },
	[0x0DF2] = { unicodeslot=0x0DF2, category='mc', description='SINHALA VOWEL SIGN DIGA GAETTA-PILLA' },
	[0x0DF3] = { unicodeslot=0x0DF3, category='mc', description='SINHALA VOWEL SIGN DIGA GAYANUKITTA' },
	[0x0DF4] = { unicodeslot=0x0DF4, category='po', description='SINHALA PUNCTUATION KUNDDALIYA' },
	[0x0E01] = { unicodeslot=0x0E01, category='lo', description='THAI CHARACTER KO KAI' },
	[0x0E02] = { unicodeslot=0x0E02, category='lo', description='THAI CHARACTER KHO KHAI' },
	[0x0E03] = { unicodeslot=0x0E03, category='lo', description='THAI CHARACTER KHO KHUAT' },
	[0x0E04] = { unicodeslot=0x0E04, category='lo', description='THAI CHARACTER KHO KHWAI' },
	[0x0E05] = { unicodeslot=0x0E05, category='lo', description='THAI CHARACTER KHO KHON' },
	[0x0E06] = { unicodeslot=0x0E06, category='lo', description='THAI CHARACTER KHO RAKHANG' },
	[0x0E07] = { unicodeslot=0x0E07, category='lo', description='THAI CHARACTER NGO NGU' },
	[0x0E08] = { unicodeslot=0x0E08, category='lo', description='THAI CHARACTER CHO CHAN' },
	[0x0E09] = { unicodeslot=0x0E09, category='lo', description='THAI CHARACTER CHO CHING' },
	[0x0E0A] = { unicodeslot=0x0E0A, category='lo', description='THAI CHARACTER CHO CHANG' },
	[0x0E0B] = { unicodeslot=0x0E0B, category='lo', description='THAI CHARACTER SO SO' },
	[0x0E0C] = { unicodeslot=0x0E0C, category='lo', description='THAI CHARACTER CHO CHOE' },
	[0x0E0D] = { unicodeslot=0x0E0D, category='lo', description='THAI CHARACTER YO YING' },
	[0x0E0E] = { unicodeslot=0x0E0E, category='lo', description='THAI CHARACTER DO CHADA' },
	[0x0E0F] = { unicodeslot=0x0E0F, category='lo', description='THAI CHARACTER TO PATAK' },
	[0x0E10] = { unicodeslot=0x0E10, category='lo', description='THAI CHARACTER THO THAN' },
	[0x0E11] = { unicodeslot=0x0E11, category='lo', description='THAI CHARACTER THO NANGMONTHO' },
	[0x0E12] = { unicodeslot=0x0E12, category='lo', description='THAI CHARACTER THO PHUTHAO' },
	[0x0E13] = { unicodeslot=0x0E13, category='lo', description='THAI CHARACTER NO NEN' },
	[0x0E14] = { unicodeslot=0x0E14, category='lo', description='THAI CHARACTER DO DEK' },
	[0x0E15] = { unicodeslot=0x0E15, category='lo', description='THAI CHARACTER TO TAO' },
	[0x0E16] = { unicodeslot=0x0E16, category='lo', description='THAI CHARACTER THO THUNG' },
	[0x0E17] = { unicodeslot=0x0E17, category='lo', description='THAI CHARACTER THO THAHAN' },
	[0x0E18] = { unicodeslot=0x0E18, category='lo', description='THAI CHARACTER THO THONG' },
	[0x0E19] = { unicodeslot=0x0E19, category='lo', description='THAI CHARACTER NO NU' },
	[0x0E1A] = { unicodeslot=0x0E1A, category='lo', description='THAI CHARACTER BO BAIMAI' },
	[0x0E1B] = { unicodeslot=0x0E1B, category='lo', description='THAI CHARACTER PO PLA' },
	[0x0E1C] = { unicodeslot=0x0E1C, category='lo', description='THAI CHARACTER PHO PHUNG' },
	[0x0E1D] = { unicodeslot=0x0E1D, category='lo', description='THAI CHARACTER FO FA' },
	[0x0E1E] = { unicodeslot=0x0E1E, category='lo', description='THAI CHARACTER PHO PHAN' },
	[0x0E1F] = { unicodeslot=0x0E1F, category='lo', description='THAI CHARACTER FO FAN' },
	[0x0E20] = { unicodeslot=0x0E20, category='lo', description='THAI CHARACTER PHO SAMPHAO' },
	[0x0E21] = { unicodeslot=0x0E21, category='lo', description='THAI CHARACTER MO MA' },
	[0x0E22] = { unicodeslot=0x0E22, category='lo', description='THAI CHARACTER YO YAK' },
	[0x0E23] = { unicodeslot=0x0E23, category='lo', description='THAI CHARACTER RO RUA' },
	[0x0E24] = { unicodeslot=0x0E24, category='lo', description='THAI CHARACTER RU' },
	[0x0E25] = { unicodeslot=0x0E25, category='lo', description='THAI CHARACTER LO LING' },
	[0x0E26] = { unicodeslot=0x0E26, category='lo', description='THAI CHARACTER LU' },
	[0x0E27] = { unicodeslot=0x0E27, category='lo', description='THAI CHARACTER WO WAEN' },
	[0x0E28] = { unicodeslot=0x0E28, category='lo', description='THAI CHARACTER SO SALA' },
	[0x0E29] = { unicodeslot=0x0E29, category='lo', description='THAI CHARACTER SO RUSI' },
	[0x0E2A] = { unicodeslot=0x0E2A, category='lo', description='THAI CHARACTER SO SUA' },
	[0x0E2B] = { unicodeslot=0x0E2B, category='lo', description='THAI CHARACTER HO HIP' },
	[0x0E2C] = { unicodeslot=0x0E2C, category='lo', description='THAI CHARACTER LO CHULA' },
	[0x0E2D] = { unicodeslot=0x0E2D, category='lo', description='THAI CHARACTER O ANG' },
	[0x0E2E] = { unicodeslot=0x0E2E, category='lo', description='THAI CHARACTER HO NOKHUK' },
	[0x0E2F] = { unicodeslot=0x0E2F, category='lo', description='THAI CHARACTER PAIYANNOI' },
	[0x0E30] = { unicodeslot=0x0E30, category='lo', description='THAI CHARACTER SARA A' },
	[0x0E31] = { unicodeslot=0x0E31, category='mn', description='THAI CHARACTER MAI HAN-AKAT' },
	[0x0E32] = { unicodeslot=0x0E32, category='lo', description='THAI CHARACTER SARA AA' },
	[0x0E33] = { unicodeslot=0x0E33, category='lo', description='THAI CHARACTER SARA AM', specials={'compat',0x0E4D,0x0E32} },
	[0x0E34] = { unicodeslot=0x0E34, category='mn', description='THAI CHARACTER SARA I' },
	[0x0E35] = { unicodeslot=0x0E35, category='mn', description='THAI CHARACTER SARA II' },
	[0x0E36] = { unicodeslot=0x0E36, category='mn', description='THAI CHARACTER SARA UE' },
	[0x0E37] = { unicodeslot=0x0E37, category='mn', description='THAI CHARACTER SARA UEE' },
	[0x0E38] = { unicodeslot=0x0E38, category='mn', description='THAI CHARACTER SARA U' },
	[0x0E39] = { unicodeslot=0x0E39, category='mn', description='THAI CHARACTER SARA UU' },
	[0x0E3A] = { unicodeslot=0x0E3A, category='mn', description='THAI CHARACTER PHINTHU' },
	[0x0E3F] = { unicodeslot=0x0E3F, category='sc', description='THAI CURRENCY SYMBOL BAHT' },
	[0x0E40] = { unicodeslot=0x0E40, category='lo', description='THAI CHARACTER SARA E' },
	[0x0E41] = { unicodeslot=0x0E41, category='lo', description='THAI CHARACTER SARA AE' },
	[0x0E42] = { unicodeslot=0x0E42, category='lo', description='THAI CHARACTER SARA O' },
	[0x0E43] = { unicodeslot=0x0E43, category='lo', description='THAI CHARACTER SARA AI MAIMUAN' },
	[0x0E44] = { unicodeslot=0x0E44, category='lo', description='THAI CHARACTER SARA AI MAIMALAI' },
	[0x0E45] = { unicodeslot=0x0E45, category='lo', description='THAI CHARACTER LAKKHANGYAO' },
	[0x0E46] = { unicodeslot=0x0E46, category='lm', description='THAI CHARACTER MAIYAMOK' },
	[0x0E47] = { unicodeslot=0x0E47, category='mn', description='THAI CHARACTER MAITAIKHU' },
	[0x0E48] = { unicodeslot=0x0E48, category='mn', description='THAI CHARACTER MAI EK' },
	[0x0E49] = { unicodeslot=0x0E49, category='mn', description='THAI CHARACTER MAI THO' },
	[0x0E4A] = { unicodeslot=0x0E4A, category='mn', description='THAI CHARACTER MAI TRI' },
	[0x0E4B] = { unicodeslot=0x0E4B, category='mn', description='THAI CHARACTER MAI CHATTAWA' },
	[0x0E4C] = { unicodeslot=0x0E4C, category='mn', description='THAI CHARACTER THANTHAKHAT' },
	[0x0E4D] = { unicodeslot=0x0E4D, category='mn', description='THAI CHARACTER NIKHAHIT' },
	[0x0E4E] = { unicodeslot=0x0E4E, category='mn', description='THAI CHARACTER YAMAKKAN' },
	[0x0E4F] = { unicodeslot=0x0E4F, category='po', description='THAI CHARACTER FONGMAN' },
	[0x0E50] = { unicodeslot=0x0E50, category='nd', description='THAI DIGIT ZERO' },
	[0x0E51] = { unicodeslot=0x0E51, category='nd', description='THAI DIGIT ONE' },
	[0x0E52] = { unicodeslot=0x0E52, category='nd', description='THAI DIGIT TWO' },
	[0x0E53] = { unicodeslot=0x0E53, category='nd', description='THAI DIGIT THREE' },
	[0x0E54] = { unicodeslot=0x0E54, category='nd', description='THAI DIGIT FOUR' },
	[0x0E55] = { unicodeslot=0x0E55, category='nd', description='THAI DIGIT FIVE' },
	[0x0E56] = { unicodeslot=0x0E56, category='nd', description='THAI DIGIT SIX' },
	[0x0E57] = { unicodeslot=0x0E57, category='nd', description='THAI DIGIT SEVEN' },
	[0x0E58] = { unicodeslot=0x0E58, category='nd', description='THAI DIGIT EIGHT' },
	[0x0E59] = { unicodeslot=0x0E59, category='nd', description='THAI DIGIT NINE' },
	[0x0E5A] = { unicodeslot=0x0E5A, category='po', description='THAI CHARACTER ANGKHANKHU' },
	[0x0E5B] = { unicodeslot=0x0E5B, category='po', description='THAI CHARACTER KHOMUT' },
	[0x0E81] = { unicodeslot=0x0E81, category='lo', description='LAO LETTER KO' },
	[0x0E82] = { unicodeslot=0x0E82, category='lo', description='LAO LETTER KHO SUNG' },
	[0x0E84] = { unicodeslot=0x0E84, category='lo', description='LAO LETTER KHO TAM' },
	[0x0E87] = { unicodeslot=0x0E87, category='lo', description='LAO LETTER NGO' },
	[0x0E88] = { unicodeslot=0x0E88, category='lo', description='LAO LETTER CO' },
	[0x0E8A] = { unicodeslot=0x0E8A, category='lo', description='LAO LETTER SO TAM' },
	[0x0E8D] = { unicodeslot=0x0E8D, category='lo', description='LAO LETTER NYO' },
	[0x0E94] = { unicodeslot=0x0E94, category='lo', description='LAO LETTER DO' },
	[0x0E95] = { unicodeslot=0x0E95, category='lo', description='LAO LETTER TO' },
	[0x0E96] = { unicodeslot=0x0E96, category='lo', description='LAO LETTER THO SUNG' },
	[0x0E97] = { unicodeslot=0x0E97, category='lo', description='LAO LETTER THO TAM' },
	[0x0E99] = { unicodeslot=0x0E99, category='lo', description='LAO LETTER NO' },
	[0x0E9A] = { unicodeslot=0x0E9A, category='lo', description='LAO LETTER BO' },
	[0x0E9B] = { unicodeslot=0x0E9B, category='lo', description='LAO LETTER PO' },
	[0x0E9C] = { unicodeslot=0x0E9C, category='lo', description='LAO LETTER PHO SUNG' },
	[0x0E9D] = { unicodeslot=0x0E9D, category='lo', description='LAO LETTER FO TAM' },
	[0x0E9E] = { unicodeslot=0x0E9E, category='lo', description='LAO LETTER PHO TAM' },
	[0x0E9F] = { unicodeslot=0x0E9F, category='lo', description='LAO LETTER FO SUNG' },
	[0x0EA1] = { unicodeslot=0x0EA1, category='lo', description='LAO LETTER MO' },
	[0x0EA2] = { unicodeslot=0x0EA2, category='lo', description='LAO LETTER YO' },
	[0x0EA3] = { unicodeslot=0x0EA3, category='lo', description='LAO LETTER LO LING' },
	[0x0EA5] = { unicodeslot=0x0EA5, category='lo', description='LAO LETTER LO LOOT' },
	[0x0EA7] = { unicodeslot=0x0EA7, category='lo', description='LAO LETTER WO' },
	[0x0EAA] = { unicodeslot=0x0EAA, category='lo', description='LAO LETTER SO SUNG' },
	[0x0EAB] = { unicodeslot=0x0EAB, category='lo', description='LAO LETTER HO SUNG' },
	[0x0EAD] = { unicodeslot=0x0EAD, category='lo', description='LAO LETTER O' },
	[0x0EAE] = { unicodeslot=0x0EAE, category='lo', description='LAO LETTER HO TAM' },
	[0x0EAF] = { unicodeslot=0x0EAF, category='lo', description='LAO ELLIPSIS' },
	[0x0EB0] = { unicodeslot=0x0EB0, category='lo', description='LAO VOWEL SIGN A' },
	[0x0EB1] = { unicodeslot=0x0EB1, category='mn', description='LAO VOWEL SIGN MAI KAN' },
	[0x0EB2] = { unicodeslot=0x0EB2, category='lo', description='LAO VOWEL SIGN AA' },
	[0x0EB3] = { unicodeslot=0x0EB3, category='lo', description='LAO VOWEL SIGN AM', specials={'compat',0x0ECD,0x0EB2} },
	[0x0EB4] = { unicodeslot=0x0EB4, category='mn', description='LAO VOWEL SIGN I' },
	[0x0EB5] = { unicodeslot=0x0EB5, category='mn', description='LAO VOWEL SIGN II' },
	[0x0EB6] = { unicodeslot=0x0EB6, category='mn', description='LAO VOWEL SIGN Y' },
	[0x0EB7] = { unicodeslot=0x0EB7, category='mn', description='LAO VOWEL SIGN YY' },
	[0x0EB8] = { unicodeslot=0x0EB8, category='mn', description='LAO VOWEL SIGN U' },
	[0x0EB9] = { unicodeslot=0x0EB9, category='mn', description='LAO VOWEL SIGN UU' },
	[0x0EBB] = { unicodeslot=0x0EBB, category='mn', description='LAO VOWEL SIGN MAI KON' },
	[0x0EBC] = { unicodeslot=0x0EBC, category='mn', description='LAO SEMIVOWEL SIGN LO' },
	[0x0EBD] = { unicodeslot=0x0EBD, category='lo', description='LAO SEMIVOWEL SIGN NYO' },
	[0x0EC0] = { unicodeslot=0x0EC0, category='lo', description='LAO VOWEL SIGN E' },
	[0x0EC1] = { unicodeslot=0x0EC1, category='lo', description='LAO VOWEL SIGN EI' },
	[0x0EC2] = { unicodeslot=0x0EC2, category='lo', description='LAO VOWEL SIGN O' },
	[0x0EC3] = { unicodeslot=0x0EC3, category='lo', description='LAO VOWEL SIGN AY' },
	[0x0EC4] = { unicodeslot=0x0EC4, category='lo', description='LAO VOWEL SIGN AI' },
	[0x0EC6] = { unicodeslot=0x0EC6, category='lm', description='LAO KO LA' },
	[0x0EC8] = { unicodeslot=0x0EC8, category='mn', description='LAO TONE MAI EK' },
	[0x0EC9] = { unicodeslot=0x0EC9, category='mn', description='LAO TONE MAI THO' },
	[0x0ECA] = { unicodeslot=0x0ECA, category='mn', description='LAO TONE MAI TI' },
	[0x0ECB] = { unicodeslot=0x0ECB, category='mn', description='LAO TONE MAI CATAWA' },
	[0x0ECC] = { unicodeslot=0x0ECC, category='mn', description='LAO CANCELLATION MARK' },
	[0x0ECD] = { unicodeslot=0x0ECD, category='mn', description='LAO NIGGAHITA' },
	[0x0ED0] = { unicodeslot=0x0ED0, category='nd', description='LAO DIGIT ZERO' },
	[0x0ED1] = { unicodeslot=0x0ED1, category='nd', description='LAO DIGIT ONE' },
	[0x0ED2] = { unicodeslot=0x0ED2, category='nd', description='LAO DIGIT TWO' },
	[0x0ED3] = { unicodeslot=0x0ED3, category='nd', description='LAO DIGIT THREE' },
	[0x0ED4] = { unicodeslot=0x0ED4, category='nd', description='LAO DIGIT FOUR' },
	[0x0ED5] = { unicodeslot=0x0ED5, category='nd', description='LAO DIGIT FIVE' },
	[0x0ED6] = { unicodeslot=0x0ED6, category='nd', description='LAO DIGIT SIX' },
	[0x0ED7] = { unicodeslot=0x0ED7, category='nd', description='LAO DIGIT SEVEN' },
	[0x0ED8] = { unicodeslot=0x0ED8, category='nd', description='LAO DIGIT EIGHT' },
	[0x0ED9] = { unicodeslot=0x0ED9, category='nd', description='LAO DIGIT NINE' },
	[0x0EDC] = { unicodeslot=0x0EDC, category='lo', description='LAO HO NO', specials={'compat',0x0EAB,0x0E99} },
	[0x0EDD] = { unicodeslot=0x0EDD, category='lo', description='LAO HO MO', specials={'compat',0x0EAB,0x0EA1} },
	[0x0F00] = { unicodeslot=0x0F00, category='lo', description='TIBETAN SYLLABLE OM' },
	[0x0F01] = { unicodeslot=0x0F01, category='so', description='TIBETAN MARK GTER YIG MGO TRUNCATED A' },
	[0x0F02] = { unicodeslot=0x0F02, category='so', description='TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA' },
	[0x0F03] = { unicodeslot=0x0F03, category='so', description='TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA' },
	[0x0F04] = { unicodeslot=0x0F04, category='po', description='TIBETAN MARK INITIAL YIG MGO MDUN MA' },
	[0x0F05] = { unicodeslot=0x0F05, category='po', description='TIBETAN MARK CLOSING YIG MGO SGAB MA' },
	[0x0F06] = { unicodeslot=0x0F06, category='po', description='TIBETAN MARK CARET YIG MGO PHUR SHAD MA' },
	[0x0F07] = { unicodeslot=0x0F07, category='po', description='TIBETAN MARK YIG MGO TSHEG SHAD MA' },
	[0x0F08] = { unicodeslot=0x0F08, category='po', description='TIBETAN MARK SBRUL SHAD' },
	[0x0F09] = { unicodeslot=0x0F09, category='po', description='TIBETAN MARK BSKUR YIG MGO' },
	[0x0F0A] = { unicodeslot=0x0F0A, category='po', description='TIBETAN MARK BKA- SHOG YIG MGO' },
	[0x0F0B] = { unicodeslot=0x0F0B, category='po', description='TIBETAN MARK INTERSYLLABIC TSHEG' },
	[0x0F0C] = { unicodeslot=0x0F0C, category='po', description='TIBETAN MARK DELIMITER TSHEG BSTAR', specials={'nobreak',0x0F0B} },
	[0x0F0D] = { unicodeslot=0x0F0D, category='po', description='TIBETAN MARK SHAD' },
	[0x0F0E] = { unicodeslot=0x0F0E, category='po', description='TIBETAN MARK NYIS SHAD' },
	[0x0F0F] = { unicodeslot=0x0F0F, category='po', description='TIBETAN MARK TSHEG SHAD' },
	[0x0F10] = { unicodeslot=0x0F10, category='po', description='TIBETAN MARK NYIS TSHEG SHAD' },
	[0x0F11] = { unicodeslot=0x0F11, category='po', description='TIBETAN MARK RIN CHEN SPUNGS SHAD' },
	[0x0F12] = { unicodeslot=0x0F12, category='po', description='TIBETAN MARK RGYA GRAM SHAD' },
	[0x0F13] = { unicodeslot=0x0F13, category='so', description='TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN' },
	[0x0F14] = { unicodeslot=0x0F14, category='so', description='TIBETAN MARK GTER TSHEG' },
	[0x0F15] = { unicodeslot=0x0F15, category='so', description='TIBETAN LOGOTYPE SIGN CHAD RTAGS' },
	[0x0F16] = { unicodeslot=0x0F16, category='so', description='TIBETAN LOGOTYPE SIGN LHAG RTAGS' },
	[0x0F17] = { unicodeslot=0x0F17, category='so', description='TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS' },
	[0x0F18] = { unicodeslot=0x0F18, category='mn', description='TIBETAN ASTROLOGICAL SIGN -KHYUD PA' },
	[0x0F19] = { unicodeslot=0x0F19, category='mn', description='TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS' },
	[0x0F1A] = { unicodeslot=0x0F1A, category='so', description='TIBETAN SIGN RDEL DKAR GCIG' },
	[0x0F1B] = { unicodeslot=0x0F1B, category='so', description='TIBETAN SIGN RDEL DKAR GNYIS' },
	[0x0F1C] = { unicodeslot=0x0F1C, category='so', description='TIBETAN SIGN RDEL DKAR GSUM' },
	[0x0F1D] = { unicodeslot=0x0F1D, category='so', description='TIBETAN SIGN RDEL NAG GCIG' },
	[0x0F1E] = { unicodeslot=0x0F1E, category='so', description='TIBETAN SIGN RDEL NAG GNYIS' },
	[0x0F1F] = { unicodeslot=0x0F1F, category='so', description='TIBETAN SIGN RDEL DKAR RDEL NAG' },
	[0x0F20] = { unicodeslot=0x0F20, category='nd', description='TIBETAN DIGIT ZERO' },
	[0x0F21] = { unicodeslot=0x0F21, category='nd', description='TIBETAN DIGIT ONE' },
	[0x0F22] = { unicodeslot=0x0F22, category='nd', description='TIBETAN DIGIT TWO' },
	[0x0F23] = { unicodeslot=0x0F23, category='nd', description='TIBETAN DIGIT THREE' },
	[0x0F24] = { unicodeslot=0x0F24, category='nd', description='TIBETAN DIGIT FOUR' },
	[0x0F25] = { unicodeslot=0x0F25, category='nd', description='TIBETAN DIGIT FIVE' },
	[0x0F26] = { unicodeslot=0x0F26, category='nd', description='TIBETAN DIGIT SIX' },
	[0x0F27] = { unicodeslot=0x0F27, category='nd', description='TIBETAN DIGIT SEVEN' },
	[0x0F28] = { unicodeslot=0x0F28, category='nd', description='TIBETAN DIGIT EIGHT' },
	[0x0F29] = { unicodeslot=0x0F29, category='nd', description='TIBETAN DIGIT NINE' },
	[0x0F2A] = { unicodeslot=0x0F2A, category='no', description='TIBETAN DIGIT HALF ONE' },
	[0x0F2B] = { unicodeslot=0x0F2B, category='no', description='TIBETAN DIGIT HALF TWO' },
	[0x0F2C] = { unicodeslot=0x0F2C, category='no', description='TIBETAN DIGIT HALF THREE' },
	[0x0F2D] = { unicodeslot=0x0F2D, category='no', description='TIBETAN DIGIT HALF FOUR' },
	[0x0F2E] = { unicodeslot=0x0F2E, category='no', description='TIBETAN DIGIT HALF FIVE' },
	[0x0F2F] = { unicodeslot=0x0F2F, category='no', description='TIBETAN DIGIT HALF SIX' },
	[0x0F30] = { unicodeslot=0x0F30, category='no', description='TIBETAN DIGIT HALF SEVEN' },
	[0x0F31] = { unicodeslot=0x0F31, category='no', description='TIBETAN DIGIT HALF EIGHT' },
	[0x0F32] = { unicodeslot=0x0F32, category='no', description='TIBETAN DIGIT HALF NINE' },
	[0x0F33] = { unicodeslot=0x0F33, category='no', description='TIBETAN DIGIT HALF ZERO' },
	[0x0F34] = { unicodeslot=0x0F34, category='so', description='TIBETAN MARK BSDUS RTAGS' },
	[0x0F35] = { unicodeslot=0x0F35, category='mn', description='TIBETAN MARK NGAS BZUNG NYI ZLA' },
	[0x0F36] = { unicodeslot=0x0F36, category='so', description='TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN' },
	[0x0F37] = { unicodeslot=0x0F37, category='mn', description='TIBETAN MARK NGAS BZUNG SGOR RTAGS' },
	[0x0F38] = { unicodeslot=0x0F38, category='so', description='TIBETAN MARK CHE MGO' },
	[0x0F39] = { unicodeslot=0x0F39, category='mn', description='TIBETAN MARK TSA -PHRU' },
	[0x0F3A] = { unicodeslot=0x0F3A, category='ps', description='TIBETAN MARK GUG RTAGS GYON' },
	[0x0F3B] = { unicodeslot=0x0F3B, category='pe', description='TIBETAN MARK GUG RTAGS GYAS' },
	[0x0F3C] = { unicodeslot=0x0F3C, category='ps', description='TIBETAN MARK ANG KHANG GYON' },
	[0x0F3D] = { unicodeslot=0x0F3D, category='pe', description='TIBETAN MARK ANG KHANG GYAS' },
	[0x0F3E] = { unicodeslot=0x0F3E, category='mc', description='TIBETAN SIGN YAR TSHES' },
	[0x0F3F] = { unicodeslot=0x0F3F, category='mc', description='TIBETAN SIGN MAR TSHES' },
	[0x0F40] = { unicodeslot=0x0F40, category='lo', description='TIBETAN LETTER KA' },
	[0x0F41] = { unicodeslot=0x0F41, category='lo', description='TIBETAN LETTER KHA' },
	[0x0F42] = { unicodeslot=0x0F42, category='lo', description='TIBETAN LETTER GA' },
	[0x0F43] = { unicodeslot=0x0F43, category='lo', description='TIBETAN LETTER GHA', specials={'char',0x0F42,0x0FB7} },
	[0x0F44] = { unicodeslot=0x0F44, category='lo', description='TIBETAN LETTER NGA' },
	[0x0F45] = { unicodeslot=0x0F45, category='lo', description='TIBETAN LETTER CA' },
	[0x0F46] = { unicodeslot=0x0F46, category='lo', description='TIBETAN LETTER CHA' },
	[0x0F47] = { unicodeslot=0x0F47, category='lo', description='TIBETAN LETTER JA' },
	[0x0F49] = { unicodeslot=0x0F49, category='lo', description='TIBETAN LETTER NYA' },
	[0x0F4A] = { unicodeslot=0x0F4A, category='lo', description='TIBETAN LETTER TTA' },
	[0x0F4B] = { unicodeslot=0x0F4B, category='lo', description='TIBETAN LETTER TTHA' },
	[0x0F4C] = { unicodeslot=0x0F4C, category='lo', description='TIBETAN LETTER DDA' },
	[0x0F4D] = { unicodeslot=0x0F4D, category='lo', description='TIBETAN LETTER DDHA', specials={'char',0x0F4C,0x0FB7} },
	[0x0F4E] = { unicodeslot=0x0F4E, category='lo', description='TIBETAN LETTER NNA' },
	[0x0F4F] = { unicodeslot=0x0F4F, category='lo', description='TIBETAN LETTER TA' },
	[0x0F50] = { unicodeslot=0x0F50, category='lo', description='TIBETAN LETTER THA' },
	[0x0F51] = { unicodeslot=0x0F51, category='lo', description='TIBETAN LETTER DA' },
	[0x0F52] = { unicodeslot=0x0F52, category='lo', description='TIBETAN LETTER DHA', specials={'char',0x0F51,0x0FB7} },
	[0x0F53] = { unicodeslot=0x0F53, category='lo', description='TIBETAN LETTER NA' },
	[0x0F54] = { unicodeslot=0x0F54, category='lo', description='TIBETAN LETTER PA' },
	[0x0F55] = { unicodeslot=0x0F55, category='lo', description='TIBETAN LETTER PHA' },
	[0x0F56] = { unicodeslot=0x0F56, category='lo', description='TIBETAN LETTER BA' },
	[0x0F57] = { unicodeslot=0x0F57, category='lo', description='TIBETAN LETTER BHA', specials={'char',0x0F56,0x0FB7} },
	[0x0F58] = { unicodeslot=0x0F58, category='lo', description='TIBETAN LETTER MA' },
	[0x0F59] = { unicodeslot=0x0F59, category='lo', description='TIBETAN LETTER TSA' },
	[0x0F5A] = { unicodeslot=0x0F5A, category='lo', description='TIBETAN LETTER TSHA' },
	[0x0F5B] = { unicodeslot=0x0F5B, category='lo', description='TIBETAN LETTER DZA' },
	[0x0F5C] = { unicodeslot=0x0F5C, category='lo', description='TIBETAN LETTER DZHA', specials={'char',0x0F5B,0x0FB7} },
	[0x0F5D] = { unicodeslot=0x0F5D, category='lo', description='TIBETAN LETTER WA' },
	[0x0F5E] = { unicodeslot=0x0F5E, category='lo', description='TIBETAN LETTER ZHA' },
	[0x0F5F] = { unicodeslot=0x0F5F, category='lo', description='TIBETAN LETTER ZA' },
	[0x0F60] = { unicodeslot=0x0F60, category='lo', description='TIBETAN LETTER -A' },
	[0x0F61] = { unicodeslot=0x0F61, category='lo', description='TIBETAN LETTER YA' },
	[0x0F62] = { unicodeslot=0x0F62, category='lo', description='TIBETAN LETTER RA' },
	[0x0F63] = { unicodeslot=0x0F63, category='lo', description='TIBETAN LETTER LA' },
	[0x0F64] = { unicodeslot=0x0F64, category='lo', description='TIBETAN LETTER SHA' },
	[0x0F65] = { unicodeslot=0x0F65, category='lo', description='TIBETAN LETTER SSA' },
	[0x0F66] = { unicodeslot=0x0F66, category='lo', description='TIBETAN LETTER SA' },
	[0x0F67] = { unicodeslot=0x0F67, category='lo', description='TIBETAN LETTER HA' },
	[0x0F68] = { unicodeslot=0x0F68, category='lo', description='TIBETAN LETTER A' },
	[0x0F69] = { unicodeslot=0x0F69, category='lo', description='TIBETAN LETTER KSSA', specials={'char',0x0F40,0x0FB5} },
	[0x0F6A] = { unicodeslot=0x0F6A, category='lo', description='TIBETAN LETTER FIXED-FORM RA' },
	[0x0F71] = { unicodeslot=0x0F71, category='mn', description='TIBETAN VOWEL SIGN AA' },
	[0x0F72] = { unicodeslot=0x0F72, category='mn', description='TIBETAN VOWEL SIGN I' },
	[0x0F73] = { unicodeslot=0x0F73, category='mn', description='TIBETAN VOWEL SIGN II', specials={'char',0x0F71,0x0F72} },
	[0x0F74] = { unicodeslot=0x0F74, category='mn', description='TIBETAN VOWEL SIGN U' },
	[0x0F75] = { unicodeslot=0x0F75, category='mn', description='TIBETAN VOWEL SIGN UU', specials={'char',0x0F71,0x0F74} },
	[0x0F76] = { unicodeslot=0x0F76, category='mn', description='TIBETAN VOWEL SIGN VOCALIC R', specials={'char',0x0FB2,0x0F80} },
	[0x0F77] = { unicodeslot=0x0F77, category='mn', description='TIBETAN VOWEL SIGN VOCALIC RR', specials={'compat',0x0FB2,0x0F81} },
	[0x0F78] = { unicodeslot=0x0F78, category='mn', description='TIBETAN VOWEL SIGN VOCALIC L', specials={'char',0x0FB3,0x0F80} },
	[0x0F79] = { unicodeslot=0x0F79, category='mn', description='TIBETAN VOWEL SIGN VOCALIC LL', specials={'compat',0x0FB3,0x0F81} },
	[0x0F7A] = { unicodeslot=0x0F7A, category='mn', description='TIBETAN VOWEL SIGN E' },
	[0x0F7B] = { unicodeslot=0x0F7B, category='mn', description='TIBETAN VOWEL SIGN EE' },
	[0x0F7C] = { unicodeslot=0x0F7C, category='mn', description='TIBETAN VOWEL SIGN O' },
	[0x0F7D] = { unicodeslot=0x0F7D, category='mn', description='TIBETAN VOWEL SIGN OO' },
	[0x0F7E] = { unicodeslot=0x0F7E, category='mn', description='TIBETAN SIGN RJES SU NGA RO' },
	[0x0F7F] = { unicodeslot=0x0F7F, category='mc', description='TIBETAN SIGN RNAM BCAD' },
	[0x0F80] = { unicodeslot=0x0F80, category='mn', description='TIBETAN VOWEL SIGN REVERSED I' },
	[0x0F81] = { unicodeslot=0x0F81, category='mn', description='TIBETAN VOWEL SIGN REVERSED II', specials={'char',0x0F71,0x0F80} },
	[0x0F82] = { unicodeslot=0x0F82, category='mn', description='TIBETAN SIGN NYI ZLA NAA DA' },
	[0x0F83] = { unicodeslot=0x0F83, category='mn', description='TIBETAN SIGN SNA LDAN' },
	[0x0F84] = { unicodeslot=0x0F84, category='mn', description='TIBETAN MARK HALANTA' },
	[0x0F85] = { unicodeslot=0x0F85, category='po', description='TIBETAN MARK PALUTA' },
	[0x0F86] = { unicodeslot=0x0F86, category='mn', description='TIBETAN SIGN LCI RTAGS' },
	[0x0F87] = { unicodeslot=0x0F87, category='mn', description='TIBETAN SIGN YANG RTAGS' },
	[0x0F88] = { unicodeslot=0x0F88, category='lo', description='TIBETAN SIGN LCE TSA CAN' },
	[0x0F89] = { unicodeslot=0x0F89, category='lo', description='TIBETAN SIGN MCHU CAN' },
	[0x0F8A] = { unicodeslot=0x0F8A, category='lo', description='TIBETAN SIGN GRU CAN RGYINGS' },
	[0x0F8B] = { unicodeslot=0x0F8B, category='lo', description='TIBETAN SIGN GRU MED RGYINGS' },
	[0x0F90] = { unicodeslot=0x0F90, category='mn', description='TIBETAN SUBJOINED LETTER KA' },
	[0x0F91] = { unicodeslot=0x0F91, category='mn', description='TIBETAN SUBJOINED LETTER KHA' },
	[0x0F92] = { unicodeslot=0x0F92, category='mn', description='TIBETAN SUBJOINED LETTER GA' },
	[0x0F93] = { unicodeslot=0x0F93, category='mn', description='TIBETAN SUBJOINED LETTER GHA', specials={'char',0x0F92,0x0FB7} },
	[0x0F94] = { unicodeslot=0x0F94, category='mn', description='TIBETAN SUBJOINED LETTER NGA' },
	[0x0F95] = { unicodeslot=0x0F95, category='mn', description='TIBETAN SUBJOINED LETTER CA' },
	[0x0F96] = { unicodeslot=0x0F96, category='mn', description='TIBETAN SUBJOINED LETTER CHA' },
	[0x0F97] = { unicodeslot=0x0F97, category='mn', description='TIBETAN SUBJOINED LETTER JA' },
	[0x0F99] = { unicodeslot=0x0F99, category='mn', description='TIBETAN SUBJOINED LETTER NYA' },
	[0x0F9A] = { unicodeslot=0x0F9A, category='mn', description='TIBETAN SUBJOINED LETTER TTA' },
	[0x0F9B] = { unicodeslot=0x0F9B, category='mn', description='TIBETAN SUBJOINED LETTER TTHA' },
	[0x0F9C] = { unicodeslot=0x0F9C, category='mn', description='TIBETAN SUBJOINED LETTER DDA' },
	[0x0F9D] = { unicodeslot=0x0F9D, category='mn', description='TIBETAN SUBJOINED LETTER DDHA', specials={'char',0x0F9C,0x0FB7} },
	[0x0F9E] = { unicodeslot=0x0F9E, category='mn', description='TIBETAN SUBJOINED LETTER NNA' },
	[0x0F9F] = { unicodeslot=0x0F9F, category='mn', description='TIBETAN SUBJOINED LETTER TA' },
	[0x0FA0] = { unicodeslot=0x0FA0, category='mn', description='TIBETAN SUBJOINED LETTER THA' },
	[0x0FA1] = { unicodeslot=0x0FA1, category='mn', description='TIBETAN SUBJOINED LETTER DA' },
	[0x0FA2] = { unicodeslot=0x0FA2, category='mn', description='TIBETAN SUBJOINED LETTER DHA', specials={'char',0x0FA1,0x0FB7} },
	[0x0FA3] = { unicodeslot=0x0FA3, category='mn', description='TIBETAN SUBJOINED LETTER NA' },
	[0x0FA4] = { unicodeslot=0x0FA4, category='mn', description='TIBETAN SUBJOINED LETTER PA' },
	[0x0FA5] = { unicodeslot=0x0FA5, category='mn', description='TIBETAN SUBJOINED LETTER PHA' },
	[0x0FA6] = { unicodeslot=0x0FA6, category='mn', description='TIBETAN SUBJOINED LETTER BA' },
	[0x0FA7] = { unicodeslot=0x0FA7, category='mn', description='TIBETAN SUBJOINED LETTER BHA', specials={'char',0x0FA6,0x0FB7} },
	[0x0FA8] = { unicodeslot=0x0FA8, category='mn', description='TIBETAN SUBJOINED LETTER MA' },
	[0x0FA9] = { unicodeslot=0x0FA9, category='mn', description='TIBETAN SUBJOINED LETTER TSA' },
	[0x0FAA] = { unicodeslot=0x0FAA, category='mn', description='TIBETAN SUBJOINED LETTER TSHA' },
	[0x0FAB] = { unicodeslot=0x0FAB, category='mn', description='TIBETAN SUBJOINED LETTER DZA' },
	[0x0FAC] = { unicodeslot=0x0FAC, category='mn', description='TIBETAN SUBJOINED LETTER DZHA', specials={'char',0x0FAB,0x0FB7} },
	[0x0FAD] = { unicodeslot=0x0FAD, category='mn', description='TIBETAN SUBJOINED LETTER WA' },
	[0x0FAE] = { unicodeslot=0x0FAE, category='mn', description='TIBETAN SUBJOINED LETTER ZHA' },
	[0x0FAF] = { unicodeslot=0x0FAF, category='mn', description='TIBETAN SUBJOINED LETTER ZA' },
	[0x0FB0] = { unicodeslot=0x0FB0, category='mn', description='TIBETAN SUBJOINED LETTER -A' },
	[0x0FB1] = { unicodeslot=0x0FB1, category='mn', description='TIBETAN SUBJOINED LETTER YA' },
	[0x0FB2] = { unicodeslot=0x0FB2, category='mn', description='TIBETAN SUBJOINED LETTER RA' },
	[0x0FB3] = { unicodeslot=0x0FB3, category='mn', description='TIBETAN SUBJOINED LETTER LA' },
	[0x0FB4] = { unicodeslot=0x0FB4, category='mn', description='TIBETAN SUBJOINED LETTER SHA' },
	[0x0FB5] = { unicodeslot=0x0FB5, category='mn', description='TIBETAN SUBJOINED LETTER SSA' },
	[0x0FB6] = { unicodeslot=0x0FB6, category='mn', description='TIBETAN SUBJOINED LETTER SA' },
	[0x0FB7] = { unicodeslot=0x0FB7, category='mn', description='TIBETAN SUBJOINED LETTER HA' },
	[0x0FB8] = { unicodeslot=0x0FB8, category='mn', description='TIBETAN SUBJOINED LETTER A' },
	[0x0FB9] = { unicodeslot=0x0FB9, category='mn', description='TIBETAN SUBJOINED LETTER KSSA', specials={'char',0x0F90,0x0FB5} },
	[0x0FBA] = { unicodeslot=0x0FBA, category='mn', description='TIBETAN SUBJOINED LETTER FIXED-FORM WA' },
	[0x0FBB] = { unicodeslot=0x0FBB, category='mn', description='TIBETAN SUBJOINED LETTER FIXED-FORM YA' },
	[0x0FBC] = { unicodeslot=0x0FBC, category='mn', description='TIBETAN SUBJOINED LETTER FIXED-FORM RA' },
	[0x0FBE] = { unicodeslot=0x0FBE, category='so', description='TIBETAN KU RU KHA' },
	[0x0FBF] = { unicodeslot=0x0FBF, category='so', description='TIBETAN KU RU KHA BZHI MIG CAN' },
	[0x0FC0] = { unicodeslot=0x0FC0, category='so', description='TIBETAN CANTILLATION SIGN HEAVY BEAT' },
	[0x0FC1] = { unicodeslot=0x0FC1, category='so', description='TIBETAN CANTILLATION SIGN LIGHT BEAT' },
	[0x0FC2] = { unicodeslot=0x0FC2, category='so', description='TIBETAN CANTILLATION SIGN CANG TE-U' },
	[0x0FC3] = { unicodeslot=0x0FC3, category='so', description='TIBETAN CANTILLATION SIGN SBUB -CHAL' },
	[0x0FC4] = { unicodeslot=0x0FC4, category='so', description='TIBETAN SYMBOL DRIL BU' },
	[0x0FC5] = { unicodeslot=0x0FC5, category='so', description='TIBETAN SYMBOL RDO RJE' },
	[0x0FC6] = { unicodeslot=0x0FC6, category='mn', description='TIBETAN SYMBOL PADMA GDAN' },
	[0x0FC7] = { unicodeslot=0x0FC7, category='so', description='TIBETAN SYMBOL RDO RJE RGYA GRAM' },
	[0x0FC8] = { unicodeslot=0x0FC8, category='so', description='TIBETAN SYMBOL PHUR PA' },
	[0x0FC9] = { unicodeslot=0x0FC9, category='so', description='TIBETAN SYMBOL NOR BU' },
	[0x0FCA] = { unicodeslot=0x0FCA, category='so', description='TIBETAN SYMBOL NOR BU NYIS -KHYIL' },
	[0x0FCB] = { unicodeslot=0x0FCB, category='so', description='TIBETAN SYMBOL NOR BU GSUM -KHYIL' },
	[0x0FCC] = { unicodeslot=0x0FCC, category='so', description='TIBETAN SYMBOL NOR BU BZHI -KHYIL' },
	[0x0FCF] = { unicodeslot=0x0FCF, category='so', description='TIBETAN SIGN RDEL NAG GSUM' },
	[0x0FD0] = { unicodeslot=0x0FD0, category='po', description='TIBETAN MARK BSKA- SHOG GI MGO RGYAN' },
	[0x0FD1] = { unicodeslot=0x0FD1, category='po', description='TIBETAN MARK MNYAM YIG GI MGO RGYAN' },
	[0x1000] = { unicodeslot=0x1000, category='lo', description='MYANMAR LETTER KA' },
	[0x1001] = { unicodeslot=0x1001, category='lo', description='MYANMAR LETTER KHA' },
	[0x1002] = { unicodeslot=0x1002, category='lo', description='MYANMAR LETTER GA' },
	[0x1003] = { unicodeslot=0x1003, category='lo', description='MYANMAR LETTER GHA' },
	[0x1004] = { unicodeslot=0x1004, category='lo', description='MYANMAR LETTER NGA' },
	[0x1005] = { unicodeslot=0x1005, category='lo', description='MYANMAR LETTER CA' },
	[0x1006] = { unicodeslot=0x1006, category='lo', description='MYANMAR LETTER CHA' },
	[0x1007] = { unicodeslot=0x1007, category='lo', description='MYANMAR LETTER JA' },
	[0x1008] = { unicodeslot=0x1008, category='lo', description='MYANMAR LETTER JHA' },
	[0x1009] = { unicodeslot=0x1009, category='lo', description='MYANMAR LETTER NYA' },
	[0x100A] = { unicodeslot=0x100A, category='lo', description='MYANMAR LETTER NNYA' },
	[0x100B] = { unicodeslot=0x100B, category='lo', description='MYANMAR LETTER TTA' },
	[0x100C] = { unicodeslot=0x100C, category='lo', description='MYANMAR LETTER TTHA' },
	[0x100D] = { unicodeslot=0x100D, category='lo', description='MYANMAR LETTER DDA' },
	[0x100E] = { unicodeslot=0x100E, category='lo', description='MYANMAR LETTER DDHA' },
	[0x100F] = { unicodeslot=0x100F, category='lo', description='MYANMAR LETTER NNA' },
	[0x1010] = { unicodeslot=0x1010, category='lo', description='MYANMAR LETTER TA' },
	[0x1011] = { unicodeslot=0x1011, category='lo', description='MYANMAR LETTER THA' },
	[0x1012] = { unicodeslot=0x1012, category='lo', description='MYANMAR LETTER DA' },
	[0x1013] = { unicodeslot=0x1013, category='lo', description='MYANMAR LETTER DHA' },
	[0x1014] = { unicodeslot=0x1014, category='lo', description='MYANMAR LETTER NA' },
	[0x1015] = { unicodeslot=0x1015, category='lo', description='MYANMAR LETTER PA' },
	[0x1016] = { unicodeslot=0x1016, category='lo', description='MYANMAR LETTER PHA' },
	[0x1017] = { unicodeslot=0x1017, category='lo', description='MYANMAR LETTER BA' },
	[0x1018] = { unicodeslot=0x1018, category='lo', description='MYANMAR LETTER BHA' },
	[0x1019] = { unicodeslot=0x1019, category='lo', description='MYANMAR LETTER MA' },
	[0x101A] = { unicodeslot=0x101A, category='lo', description='MYANMAR LETTER YA' },
	[0x101B] = { unicodeslot=0x101B, category='lo', description='MYANMAR LETTER RA' },
	[0x101C] = { unicodeslot=0x101C, category='lo', description='MYANMAR LETTER LA' },
	[0x101D] = { unicodeslot=0x101D, category='lo', description='MYANMAR LETTER WA' },
	[0x101E] = { unicodeslot=0x101E, category='lo', description='MYANMAR LETTER SA' },
	[0x101F] = { unicodeslot=0x101F, category='lo', description='MYANMAR LETTER HA' },
	[0x1020] = { unicodeslot=0x1020, category='lo', description='MYANMAR LETTER LLA' },
	[0x1021] = { unicodeslot=0x1021, category='lo', description='MYANMAR LETTER A' },
	[0x1023] = { unicodeslot=0x1023, category='lo', description='MYANMAR LETTER I' },
	[0x1024] = { unicodeslot=0x1024, category='lo', description='MYANMAR LETTER II' },
	[0x1025] = { unicodeslot=0x1025, category='lo', description='MYANMAR LETTER U' },
	[0x1026] = { unicodeslot=0x1026, category='lo', description='MYANMAR LETTER UU', specials={'char',0x1025,0x102E} },
	[0x1027] = { unicodeslot=0x1027, category='lo', description='MYANMAR LETTER E' },
	[0x1029] = { unicodeslot=0x1029, category='lo', description='MYANMAR LETTER O' },
	[0x102A] = { unicodeslot=0x102A, category='lo', description='MYANMAR LETTER AU' },
	[0x102C] = { unicodeslot=0x102C, category='mc', description='MYANMAR VOWEL SIGN AA' },
	[0x102D] = { unicodeslot=0x102D, category='mn', description='MYANMAR VOWEL SIGN I' },
	[0x102E] = { unicodeslot=0x102E, category='mn', description='MYANMAR VOWEL SIGN II' },
	[0x102F] = { unicodeslot=0x102F, category='mn', description='MYANMAR VOWEL SIGN U' },
	[0x1030] = { unicodeslot=0x1030, category='mn', description='MYANMAR VOWEL SIGN UU' },
	[0x1031] = { unicodeslot=0x1031, category='mc', description='MYANMAR VOWEL SIGN E' },
	[0x1032] = { unicodeslot=0x1032, category='mn', description='MYANMAR VOWEL SIGN AI' },
	[0x1036] = { unicodeslot=0x1036, category='mn', description='MYANMAR SIGN ANUSVARA' },
	[0x1037] = { unicodeslot=0x1037, category='mn', description='MYANMAR SIGN DOT BELOW' },
	[0x1038] = { unicodeslot=0x1038, category='mc', description='MYANMAR SIGN VISARGA' },
	[0x1039] = { unicodeslot=0x1039, category='mn', description='MYANMAR SIGN VIRAMA' },
	[0x1040] = { unicodeslot=0x1040, category='nd', description='MYANMAR DIGIT ZERO' },
	[0x1041] = { unicodeslot=0x1041, category='nd', description='MYANMAR DIGIT ONE' },
	[0x1042] = { unicodeslot=0x1042, category='nd', description='MYANMAR DIGIT TWO' },
	[0x1043] = { unicodeslot=0x1043, category='nd', description='MYANMAR DIGIT THREE' },
	[0x1044] = { unicodeslot=0x1044, category='nd', description='MYANMAR DIGIT FOUR' },
	[0x1045] = { unicodeslot=0x1045, category='nd', description='MYANMAR DIGIT FIVE' },
	[0x1046] = { unicodeslot=0x1046, category='nd', description='MYANMAR DIGIT SIX' },
	[0x1047] = { unicodeslot=0x1047, category='nd', description='MYANMAR DIGIT SEVEN' },
	[0x1048] = { unicodeslot=0x1048, category='nd', description='MYANMAR DIGIT EIGHT' },
	[0x1049] = { unicodeslot=0x1049, category='nd', description='MYANMAR DIGIT NINE' },
	[0x104A] = { unicodeslot=0x104A, category='po', description='MYANMAR SIGN LITTLE SECTION' },
	[0x104B] = { unicodeslot=0x104B, category='po', description='MYANMAR SIGN SECTION' },
	[0x104C] = { unicodeslot=0x104C, category='po', description='MYANMAR SYMBOL LOCATIVE' },
	[0x104D] = { unicodeslot=0x104D, category='po', description='MYANMAR SYMBOL COMPLETED' },
	[0x104E] = { unicodeslot=0x104E, category='po', description='MYANMAR SYMBOL AFOREMENTIONED' },
	[0x104F] = { unicodeslot=0x104F, category='po', description='MYANMAR SYMBOL GENITIVE' },
	[0x1050] = { unicodeslot=0x1050, category='lo', description='MYANMAR LETTER SHA' },
	[0x1051] = { unicodeslot=0x1051, category='lo', description='MYANMAR LETTER SSA' },
	[0x1052] = { unicodeslot=0x1052, category='lo', description='MYANMAR LETTER VOCALIC R' },
	[0x1053] = { unicodeslot=0x1053, category='lo', description='MYANMAR LETTER VOCALIC RR' },
	[0x1054] = { unicodeslot=0x1054, category='lo', description='MYANMAR LETTER VOCALIC L' },
	[0x1055] = { unicodeslot=0x1055, category='lo', description='MYANMAR LETTER VOCALIC LL' },
	[0x1056] = { unicodeslot=0x1056, category='mc', description='MYANMAR VOWEL SIGN VOCALIC R' },
	[0x1057] = { unicodeslot=0x1057, category='mc', description='MYANMAR VOWEL SIGN VOCALIC RR' },
	[0x1058] = { unicodeslot=0x1058, category='mn', description='MYANMAR VOWEL SIGN VOCALIC L' },
	[0x1059] = { unicodeslot=0x1059, category='mn', description='MYANMAR VOWEL SIGN VOCALIC LL' },
	[0x10A0] = { unicodeslot=0x10A0, category='lu', description='GEORGIAN CAPITAL LETTER AN', lccode=0x2D00 },
	[0x10A1] = { unicodeslot=0x10A1, category='lu', description='GEORGIAN CAPITAL LETTER BAN', lccode=0x2D01 },
	[0x10A2] = { unicodeslot=0x10A2, category='lu', description='GEORGIAN CAPITAL LETTER GAN', lccode=0x2D02 },
	[0x10A3] = { unicodeslot=0x10A3, category='lu', description='GEORGIAN CAPITAL LETTER DON', lccode=0x2D03 },
	[0x10A4] = { unicodeslot=0x10A4, category='lu', description='GEORGIAN CAPITAL LETTER EN', lccode=0x2D04 },
	[0x10A5] = { unicodeslot=0x10A5, category='lu', description='GEORGIAN CAPITAL LETTER VIN', lccode=0x2D05 },
	[0x10A6] = { unicodeslot=0x10A6, category='lu', description='GEORGIAN CAPITAL LETTER ZEN', lccode=0x2D06 },
	[0x10A7] = { unicodeslot=0x10A7, category='lu', description='GEORGIAN CAPITAL LETTER TAN', lccode=0x2D07 },
	[0x10A8] = { unicodeslot=0x10A8, category='lu', description='GEORGIAN CAPITAL LETTER IN', lccode=0x2D08 },
	[0x10A9] = { unicodeslot=0x10A9, category='lu', description='GEORGIAN CAPITAL LETTER KAN', lccode=0x2D09 },
	[0x10AA] = { unicodeslot=0x10AA, category='lu', description='GEORGIAN CAPITAL LETTER LAS', lccode=0x2D0A },
	[0x10AB] = { unicodeslot=0x10AB, category='lu', description='GEORGIAN CAPITAL LETTER MAN', lccode=0x2D0B },
	[0x10AC] = { unicodeslot=0x10AC, category='lu', description='GEORGIAN CAPITAL LETTER NAR', lccode=0x2D0C },
	[0x10AD] = { unicodeslot=0x10AD, category='lu', description='GEORGIAN CAPITAL LETTER ON', lccode=0x2D0D },
	[0x10AE] = { unicodeslot=0x10AE, category='lu', description='GEORGIAN CAPITAL LETTER PAR', lccode=0x2D0E },
	[0x10AF] = { unicodeslot=0x10AF, category='lu', description='GEORGIAN CAPITAL LETTER ZHAR', lccode=0x2D0F },
	[0x10B0] = { unicodeslot=0x10B0, category='lu', description='GEORGIAN CAPITAL LETTER RAE', lccode=0x2D10 },
	[0x10B1] = { unicodeslot=0x10B1, category='lu', description='GEORGIAN CAPITAL LETTER SAN', lccode=0x2D11 },
	[0x10B2] = { unicodeslot=0x10B2, category='lu', description='GEORGIAN CAPITAL LETTER TAR', lccode=0x2D12 },
	[0x10B3] = { unicodeslot=0x10B3, category='lu', description='GEORGIAN CAPITAL LETTER UN', lccode=0x2D13 },
	[0x10B4] = { unicodeslot=0x10B4, category='lu', description='GEORGIAN CAPITAL LETTER PHAR', lccode=0x2D14 },
	[0x10B5] = { unicodeslot=0x10B5, category='lu', description='GEORGIAN CAPITAL LETTER KHAR', lccode=0x2D15 },
	[0x10B6] = { unicodeslot=0x10B6, category='lu', description='GEORGIAN CAPITAL LETTER GHAN', lccode=0x2D16 },
	[0x10B7] = { unicodeslot=0x10B7, category='lu', description='GEORGIAN CAPITAL LETTER QAR', lccode=0x2D17 },
	[0x10B8] = { unicodeslot=0x10B8, category='lu', description='GEORGIAN CAPITAL LETTER SHIN', lccode=0x2D18 },
	[0x10B9] = { unicodeslot=0x10B9, category='lu', description='GEORGIAN CAPITAL LETTER CHIN', lccode=0x2D19 },
	[0x10BA] = { unicodeslot=0x10BA, category='lu', description='GEORGIAN CAPITAL LETTER CAN', lccode=0x2D1A },
	[0x10BB] = { unicodeslot=0x10BB, category='lu', description='GEORGIAN CAPITAL LETTER JIL', lccode=0x2D1B },
	[0x10BC] = { unicodeslot=0x10BC, category='lu', description='GEORGIAN CAPITAL LETTER CIL', lccode=0x2D1C },
	[0x10BD] = { unicodeslot=0x10BD, category='lu', description='GEORGIAN CAPITAL LETTER CHAR', lccode=0x2D1D },
	[0x10BE] = { unicodeslot=0x10BE, category='lu', description='GEORGIAN CAPITAL LETTER XAN', lccode=0x2D1E },
	[0x10BF] = { unicodeslot=0x10BF, category='lu', description='GEORGIAN CAPITAL LETTER JHAN', lccode=0x2D1F },
	[0x10C0] = { unicodeslot=0x10C0, category='lu', description='GEORGIAN CAPITAL LETTER HAE', lccode=0x2D20 },
	[0x10C1] = { unicodeslot=0x10C1, category='lu', description='GEORGIAN CAPITAL LETTER HE', lccode=0x2D21 },
	[0x10C2] = { unicodeslot=0x10C2, category='lu', description='GEORGIAN CAPITAL LETTER HIE', lccode=0x2D22 },
	[0x10C3] = { unicodeslot=0x10C3, category='lu', description='GEORGIAN CAPITAL LETTER WE', lccode=0x2D23 },
	[0x10C4] = { unicodeslot=0x10C4, category='lu', description='GEORGIAN CAPITAL LETTER HAR', lccode=0x2D24 },
	[0x10C5] = { unicodeslot=0x10C5, category='lu', description='GEORGIAN CAPITAL LETTER HOE', lccode=0x2D25 },
	[0x10D0] = { unicodeslot=0x10D0, category='lo', description='GEORGIAN LETTER AN' },
	[0x10D1] = { unicodeslot=0x10D1, category='lo', description='GEORGIAN LETTER BAN' },
	[0x10D2] = { unicodeslot=0x10D2, category='lo', description='GEORGIAN LETTER GAN' },
	[0x10D3] = { unicodeslot=0x10D3, category='lo', description='GEORGIAN LETTER DON' },
	[0x10D4] = { unicodeslot=0x10D4, category='lo', description='GEORGIAN LETTER EN' },
	[0x10D5] = { unicodeslot=0x10D5, category='lo', description='GEORGIAN LETTER VIN' },
	[0x10D6] = { unicodeslot=0x10D6, category='lo', description='GEORGIAN LETTER ZEN' },
	[0x10D7] = { unicodeslot=0x10D7, category='lo', description='GEORGIAN LETTER TAN' },
	[0x10D8] = { unicodeslot=0x10D8, category='lo', description='GEORGIAN LETTER IN' },
	[0x10D9] = { unicodeslot=0x10D9, category='lo', description='GEORGIAN LETTER KAN' },
	[0x10DA] = { unicodeslot=0x10DA, category='lo', description='GEORGIAN LETTER LAS' },
	[0x10DB] = { unicodeslot=0x10DB, category='lo', description='GEORGIAN LETTER MAN' },
	[0x10DC] = { unicodeslot=0x10DC, category='lo', description='GEORGIAN LETTER NAR' },
	[0x10DD] = { unicodeslot=0x10DD, category='lo', description='GEORGIAN LETTER ON' },
	[0x10DE] = { unicodeslot=0x10DE, category='lo', description='GEORGIAN LETTER PAR' },
	[0x10DF] = { unicodeslot=0x10DF, category='lo', description='GEORGIAN LETTER ZHAR' },
	[0x10E0] = { unicodeslot=0x10E0, category='lo', description='GEORGIAN LETTER RAE' },
	[0x10E1] = { unicodeslot=0x10E1, category='lo', description='GEORGIAN LETTER SAN' },
	[0x10E2] = { unicodeslot=0x10E2, category='lo', description='GEORGIAN LETTER TAR' },
	[0x10E3] = { unicodeslot=0x10E3, category='lo', description='GEORGIAN LETTER UN' },
	[0x10E4] = { unicodeslot=0x10E4, category='lo', description='GEORGIAN LETTER PHAR' },
	[0x10E5] = { unicodeslot=0x10E5, category='lo', description='GEORGIAN LETTER KHAR' },
	[0x10E6] = { unicodeslot=0x10E6, category='lo', description='GEORGIAN LETTER GHAN' },
	[0x10E7] = { unicodeslot=0x10E7, category='lo', description='GEORGIAN LETTER QAR' },
	[0x10E8] = { unicodeslot=0x10E8, category='lo', description='GEORGIAN LETTER SHIN' },
	[0x10E9] = { unicodeslot=0x10E9, category='lo', description='GEORGIAN LETTER CHIN' },
	[0x10EA] = { unicodeslot=0x10EA, category='lo', description='GEORGIAN LETTER CAN' },
	[0x10EB] = { unicodeslot=0x10EB, category='lo', description='GEORGIAN LETTER JIL' },
	[0x10EC] = { unicodeslot=0x10EC, category='lo', description='GEORGIAN LETTER CIL' },
	[0x10ED] = { unicodeslot=0x10ED, category='lo', description='GEORGIAN LETTER CHAR' },
	[0x10EE] = { unicodeslot=0x10EE, category='lo', description='GEORGIAN LETTER XAN' },
	[0x10EF] = { unicodeslot=0x10EF, category='lo', description='GEORGIAN LETTER JHAN' },
	[0x10F0] = { unicodeslot=0x10F0, category='lo', description='GEORGIAN LETTER HAE' },
	[0x10F1] = { unicodeslot=0x10F1, category='lo', description='GEORGIAN LETTER HE' },
	[0x10F2] = { unicodeslot=0x10F2, category='lo', description='GEORGIAN LETTER HIE' },
	[0x10F3] = { unicodeslot=0x10F3, category='lo', description='GEORGIAN LETTER WE' },
	[0x10F4] = { unicodeslot=0x10F4, category='lo', description='GEORGIAN LETTER HAR' },
	[0x10F5] = { unicodeslot=0x10F5, category='lo', description='GEORGIAN LETTER HOE' },
	[0x10F6] = { unicodeslot=0x10F6, category='lo', description='GEORGIAN LETTER FI' },
	[0x10F7] = { unicodeslot=0x10F7, category='lo', description='GEORGIAN LETTER YN' },
	[0x10F8] = { unicodeslot=0x10F8, category='lo', description='GEORGIAN LETTER ELIFI' },
	[0x10F9] = { unicodeslot=0x10F9, category='lo', description='GEORGIAN LETTER TURNED GAN' },
	[0x10FA] = { unicodeslot=0x10FA, category='lo', description='GEORGIAN LETTER AIN' },
	[0x10FB] = { unicodeslot=0x10FB, category='po', description='GEORGIAN PARAGRAPH SEPARATOR' },
	[0x10FC] = { unicodeslot=0x10FC, category='lm', description='MODIFIER LETTER GEORGIAN NAR', specials={'super',0x10DC} },
	[0x1100] = { unicodeslot=0x1100, category='lo', description='HANGUL CHOSEONG KIYEOK' },
	[0x1101] = { unicodeslot=0x1101, category='lo', description='HANGUL CHOSEONG SSANGKIYEOK' },
	[0x1102] = { unicodeslot=0x1102, category='lo', description='HANGUL CHOSEONG NIEUN' },
	[0x1103] = { unicodeslot=0x1103, category='lo', description='HANGUL CHOSEONG TIKEUT' },
	[0x1104] = { unicodeslot=0x1104, category='lo', description='HANGUL CHOSEONG SSANGTIKEUT' },
	[0x1105] = { unicodeslot=0x1105, category='lo', description='HANGUL CHOSEONG RIEUL' },
	[0x1106] = { unicodeslot=0x1106, category='lo', description='HANGUL CHOSEONG MIEUM' },
	[0x1107] = { unicodeslot=0x1107, category='lo', description='HANGUL CHOSEONG PIEUP' },
	[0x1108] = { unicodeslot=0x1108, category='lo', description='HANGUL CHOSEONG SSANGPIEUP' },
	[0x1109] = { unicodeslot=0x1109, category='lo', description='HANGUL CHOSEONG SIOS' },
	[0x110A] = { unicodeslot=0x110A, category='lo', description='HANGUL CHOSEONG SSANGSIOS' },
	[0x110B] = { unicodeslot=0x110B, category='lo', description='HANGUL CHOSEONG IEUNG' },
	[0x110C] = { unicodeslot=0x110C, category='lo', description='HANGUL CHOSEONG CIEUC' },
	[0x110D] = { unicodeslot=0x110D, category='lo', description='HANGUL CHOSEONG SSANGCIEUC' },
	[0x110E] = { unicodeslot=0x110E, category='lo', description='HANGUL CHOSEONG CHIEUCH' },
	[0x110F] = { unicodeslot=0x110F, category='lo', description='HANGUL CHOSEONG KHIEUKH' },
	[0x1110] = { unicodeslot=0x1110, category='lo', description='HANGUL CHOSEONG THIEUTH' },
	[0x1111] = { unicodeslot=0x1111, category='lo', description='HANGUL CHOSEONG PHIEUPH' },
	[0x1112] = { unicodeslot=0x1112, category='lo', description='HANGUL CHOSEONG HIEUH' },
	[0x1113] = { unicodeslot=0x1113, category='lo', description='HANGUL CHOSEONG NIEUN-KIYEOK' },
	[0x1114] = { unicodeslot=0x1114, category='lo', description='HANGUL CHOSEONG SSANGNIEUN' },
	[0x1115] = { unicodeslot=0x1115, category='lo', description='HANGUL CHOSEONG NIEUN-TIKEUT' },
	[0x1116] = { unicodeslot=0x1116, category='lo', description='HANGUL CHOSEONG NIEUN-PIEUP' },
	[0x1117] = { unicodeslot=0x1117, category='lo', description='HANGUL CHOSEONG TIKEUT-KIYEOK' },
	[0x1118] = { unicodeslot=0x1118, category='lo', description='HANGUL CHOSEONG RIEUL-NIEUN' },
	[0x1119] = { unicodeslot=0x1119, category='lo', description='HANGUL CHOSEONG SSANGRIEUL' },
	[0x111A] = { unicodeslot=0x111A, category='lo', description='HANGUL CHOSEONG RIEUL-HIEUH' },
	[0x111B] = { unicodeslot=0x111B, category='lo', description='HANGUL CHOSEONG KAPYEOUNRIEUL' },
	[0x111C] = { unicodeslot=0x111C, category='lo', description='HANGUL CHOSEONG MIEUM-PIEUP' },
	[0x111D] = { unicodeslot=0x111D, category='lo', description='HANGUL CHOSEONG KAPYEOUNMIEUM' },
	[0x111E] = { unicodeslot=0x111E, category='lo', description='HANGUL CHOSEONG PIEUP-KIYEOK' },
	[0x111F] = { unicodeslot=0x111F, category='lo', description='HANGUL CHOSEONG PIEUP-NIEUN' },
	[0x1120] = { unicodeslot=0x1120, category='lo', description='HANGUL CHOSEONG PIEUP-TIKEUT' },
	[0x1121] = { unicodeslot=0x1121, category='lo', description='HANGUL CHOSEONG PIEUP-SIOS' },
	[0x1122] = { unicodeslot=0x1122, category='lo', description='HANGUL CHOSEONG PIEUP-SIOS-KIYEOK' },
	[0x1123] = { unicodeslot=0x1123, category='lo', description='HANGUL CHOSEONG PIEUP-SIOS-TIKEUT' },
	[0x1124] = { unicodeslot=0x1124, category='lo', description='HANGUL CHOSEONG PIEUP-SIOS-PIEUP' },
	[0x1125] = { unicodeslot=0x1125, category='lo', description='HANGUL CHOSEONG PIEUP-SSANGSIOS' },
	[0x1126] = { unicodeslot=0x1126, category='lo', description='HANGUL CHOSEONG PIEUP-SIOS-CIEUC' },
	[0x1127] = { unicodeslot=0x1127, category='lo', description='HANGUL CHOSEONG PIEUP-CIEUC' },
	[0x1128] = { unicodeslot=0x1128, category='lo', description='HANGUL CHOSEONG PIEUP-CHIEUCH' },
	[0x1129] = { unicodeslot=0x1129, category='lo', description='HANGUL CHOSEONG PIEUP-THIEUTH' },
	[0x112A] = { unicodeslot=0x112A, category='lo', description='HANGUL CHOSEONG PIEUP-PHIEUPH' },
	[0x112B] = { unicodeslot=0x112B, category='lo', description='HANGUL CHOSEONG KAPYEOUNPIEUP' },
	[0x112C] = { unicodeslot=0x112C, category='lo', description='HANGUL CHOSEONG KAPYEOUNSSANGPIEUP' },
	[0x112D] = { unicodeslot=0x112D, category='lo', description='HANGUL CHOSEONG SIOS-KIYEOK' },
	[0x112E] = { unicodeslot=0x112E, category='lo', description='HANGUL CHOSEONG SIOS-NIEUN' },
	[0x112F] = { unicodeslot=0x112F, category='lo', description='HANGUL CHOSEONG SIOS-TIKEUT' },
	[0x1130] = { unicodeslot=0x1130, category='lo', description='HANGUL CHOSEONG SIOS-RIEUL' },
	[0x1131] = { unicodeslot=0x1131, category='lo', description='HANGUL CHOSEONG SIOS-MIEUM' },
	[0x1132] = { unicodeslot=0x1132, category='lo', description='HANGUL CHOSEONG SIOS-PIEUP' },
	[0x1133] = { unicodeslot=0x1133, category='lo', description='HANGUL CHOSEONG SIOS-PIEUP-KIYEOK' },
	[0x1134] = { unicodeslot=0x1134, category='lo', description='HANGUL CHOSEONG SIOS-SSANGSIOS' },
	[0x1135] = { unicodeslot=0x1135, category='lo', description='HANGUL CHOSEONG SIOS-IEUNG' },
	[0x1136] = { unicodeslot=0x1136, category='lo', description='HANGUL CHOSEONG SIOS-CIEUC' },
	[0x1137] = { unicodeslot=0x1137, category='lo', description='HANGUL CHOSEONG SIOS-CHIEUCH' },
	[0x1138] = { unicodeslot=0x1138, category='lo', description='HANGUL CHOSEONG SIOS-KHIEUKH' },
	[0x1139] = { unicodeslot=0x1139, category='lo', description='HANGUL CHOSEONG SIOS-THIEUTH' },
	[0x113A] = { unicodeslot=0x113A, category='lo', description='HANGUL CHOSEONG SIOS-PHIEUPH' },
	[0x113B] = { unicodeslot=0x113B, category='lo', description='HANGUL CHOSEONG SIOS-HIEUH' },
	[0x113C] = { unicodeslot=0x113C, category='lo', description='HANGUL CHOSEONG CHITUEUMSIOS' },
	[0x113D] = { unicodeslot=0x113D, category='lo', description='HANGUL CHOSEONG CHITUEUMSSANGSIOS' },
	[0x113E] = { unicodeslot=0x113E, category='lo', description='HANGUL CHOSEONG CEONGCHIEUMSIOS' },
	[0x113F] = { unicodeslot=0x113F, category='lo', description='HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS' },
	[0x1140] = { unicodeslot=0x1140, category='lo', description='HANGUL CHOSEONG PANSIOS' },
	[0x1141] = { unicodeslot=0x1141, category='lo', description='HANGUL CHOSEONG IEUNG-KIYEOK' },
	[0x1142] = { unicodeslot=0x1142, category='lo', description='HANGUL CHOSEONG IEUNG-TIKEUT' },
	[0x1143] = { unicodeslot=0x1143, category='lo', description='HANGUL CHOSEONG IEUNG-MIEUM' },
	[0x1144] = { unicodeslot=0x1144, category='lo', description='HANGUL CHOSEONG IEUNG-PIEUP' },
	[0x1145] = { unicodeslot=0x1145, category='lo', description='HANGUL CHOSEONG IEUNG-SIOS' },
	[0x1146] = { unicodeslot=0x1146, category='lo', description='HANGUL CHOSEONG IEUNG-PANSIOS' },
	[0x1147] = { unicodeslot=0x1147, category='lo', description='HANGUL CHOSEONG SSANGIEUNG' },
	[0x1148] = { unicodeslot=0x1148, category='lo', description='HANGUL CHOSEONG IEUNG-CIEUC' },
	[0x1149] = { unicodeslot=0x1149, category='lo', description='HANGUL CHOSEONG IEUNG-CHIEUCH' },
	[0x114A] = { unicodeslot=0x114A, category='lo', description='HANGUL CHOSEONG IEUNG-THIEUTH' },
	[0x114B] = { unicodeslot=0x114B, category='lo', description='HANGUL CHOSEONG IEUNG-PHIEUPH' },
	[0x114C] = { unicodeslot=0x114C, category='lo', description='HANGUL CHOSEONG YESIEUNG' },
	[0x114D] = { unicodeslot=0x114D, category='lo', description='HANGUL CHOSEONG CIEUC-IEUNG' },
	[0x114E] = { unicodeslot=0x114E, category='lo', description='HANGUL CHOSEONG CHITUEUMCIEUC' },
	[0x114F] = { unicodeslot=0x114F, category='lo', description='HANGUL CHOSEONG CHITUEUMSSANGCIEUC' },
	[0x1150] = { unicodeslot=0x1150, category='lo', description='HANGUL CHOSEONG CEONGCHIEUMCIEUC' },
	[0x1151] = { unicodeslot=0x1151, category='lo', description='HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC' },
	[0x1152] = { unicodeslot=0x1152, category='lo', description='HANGUL CHOSEONG CHIEUCH-KHIEUKH' },
	[0x1153] = { unicodeslot=0x1153, category='lo', description='HANGUL CHOSEONG CHIEUCH-HIEUH' },
	[0x1154] = { unicodeslot=0x1154, category='lo', description='HANGUL CHOSEONG CHITUEUMCHIEUCH' },
	[0x1155] = { unicodeslot=0x1155, category='lo', description='HANGUL CHOSEONG CEONGCHIEUMCHIEUCH' },
	[0x1156] = { unicodeslot=0x1156, category='lo', description='HANGUL CHOSEONG PHIEUPH-PIEUP' },
	[0x1157] = { unicodeslot=0x1157, category='lo', description='HANGUL CHOSEONG KAPYEOUNPHIEUPH' },
	[0x1158] = { unicodeslot=0x1158, category='lo', description='HANGUL CHOSEONG SSANGHIEUH' },
	[0x1159] = { unicodeslot=0x1159, category='lo', description='HANGUL CHOSEONG YEORINHIEUH' },
	[0x115F] = { unicodeslot=0x115F, category='lo', description='HANGUL CHOSEONG FILLER' },
	[0x1160] = { unicodeslot=0x1160, category='lo', description='HANGUL JUNGSEONG FILLER' },
	[0x1161] = { unicodeslot=0x1161, category='lo', description='HANGUL JUNGSEONG A' },
	[0x1162] = { unicodeslot=0x1162, category='lo', description='HANGUL JUNGSEONG AE' },
	[0x1163] = { unicodeslot=0x1163, category='lo', description='HANGUL JUNGSEONG YA' },
	[0x1164] = { unicodeslot=0x1164, category='lo', description='HANGUL JUNGSEONG YAE' },
	[0x1165] = { unicodeslot=0x1165, category='lo', description='HANGUL JUNGSEONG EO' },
	[0x1166] = { unicodeslot=0x1166, category='lo', description='HANGUL JUNGSEONG E' },
	[0x1167] = { unicodeslot=0x1167, category='lo', description='HANGUL JUNGSEONG YEO' },
	[0x1168] = { unicodeslot=0x1168, category='lo', description='HANGUL JUNGSEONG YE' },
	[0x1169] = { unicodeslot=0x1169, category='lo', description='HANGUL JUNGSEONG O' },
	[0x116A] = { unicodeslot=0x116A, category='lo', description='HANGUL JUNGSEONG WA' },
	[0x116B] = { unicodeslot=0x116B, category='lo', description='HANGUL JUNGSEONG WAE' },
	[0x116C] = { unicodeslot=0x116C, category='lo', description='HANGUL JUNGSEONG OE' },
	[0x116D] = { unicodeslot=0x116D, category='lo', description='HANGUL JUNGSEONG YO' },
	[0x116E] = { unicodeslot=0x116E, category='lo', description='HANGUL JUNGSEONG U' },
	[0x116F] = { unicodeslot=0x116F, category='lo', description='HANGUL JUNGSEONG WEO' },
	[0x1170] = { unicodeslot=0x1170, category='lo', description='HANGUL JUNGSEONG WE' },
	[0x1171] = { unicodeslot=0x1171, category='lo', description='HANGUL JUNGSEONG WI' },
	[0x1172] = { unicodeslot=0x1172, category='lo', description='HANGUL JUNGSEONG YU' },
	[0x1173] = { unicodeslot=0x1173, category='lo', description='HANGUL JUNGSEONG EU' },
	[0x1174] = { unicodeslot=0x1174, category='lo', description='HANGUL JUNGSEONG YI' },
	[0x1175] = { unicodeslot=0x1175, category='lo', description='HANGUL JUNGSEONG I' },
	[0x1176] = { unicodeslot=0x1176, category='lo', description='HANGUL JUNGSEONG A-O' },
	[0x1177] = { unicodeslot=0x1177, category='lo', description='HANGUL JUNGSEONG A-U' },
	[0x1178] = { unicodeslot=0x1178, category='lo', description='HANGUL JUNGSEONG YA-O' },
	[0x1179] = { unicodeslot=0x1179, category='lo', description='HANGUL JUNGSEONG YA-YO' },
	[0x117A] = { unicodeslot=0x117A, category='lo', description='HANGUL JUNGSEONG EO-O' },
	[0x117B] = { unicodeslot=0x117B, category='lo', description='HANGUL JUNGSEONG EO-U' },
	[0x117C] = { unicodeslot=0x117C, category='lo', description='HANGUL JUNGSEONG EO-EU' },
	[0x117D] = { unicodeslot=0x117D, category='lo', description='HANGUL JUNGSEONG YEO-O' },
	[0x117E] = { unicodeslot=0x117E, category='lo', description='HANGUL JUNGSEONG YEO-U' },
	[0x117F] = { unicodeslot=0x117F, category='lo', description='HANGUL JUNGSEONG O-EO' },
	[0x1180] = { unicodeslot=0x1180, category='lo', description='HANGUL JUNGSEONG O-E' },
	[0x1181] = { unicodeslot=0x1181, category='lo', description='HANGUL JUNGSEONG O-YE' },
	[0x1182] = { unicodeslot=0x1182, category='lo', description='HANGUL JUNGSEONG O-O' },
	[0x1183] = { unicodeslot=0x1183, category='lo', description='HANGUL JUNGSEONG O-U' },
	[0x1184] = { unicodeslot=0x1184, category='lo', description='HANGUL JUNGSEONG YO-YA' },
	[0x1185] = { unicodeslot=0x1185, category='lo', description='HANGUL JUNGSEONG YO-YAE' },
	[0x1186] = { unicodeslot=0x1186, category='lo', description='HANGUL JUNGSEONG YO-YEO' },
	[0x1187] = { unicodeslot=0x1187, category='lo', description='HANGUL JUNGSEONG YO-O' },
	[0x1188] = { unicodeslot=0x1188, category='lo', description='HANGUL JUNGSEONG YO-I' },
	[0x1189] = { unicodeslot=0x1189, category='lo', description='HANGUL JUNGSEONG U-A' },
	[0x118A] = { unicodeslot=0x118A, category='lo', description='HANGUL JUNGSEONG U-AE' },
	[0x118B] = { unicodeslot=0x118B, category='lo', description='HANGUL JUNGSEONG U-EO-EU' },
	[0x118C] = { unicodeslot=0x118C, category='lo', description='HANGUL JUNGSEONG U-YE' },
	[0x118D] = { unicodeslot=0x118D, category='lo', description='HANGUL JUNGSEONG U-U' },
	[0x118E] = { unicodeslot=0x118E, category='lo', description='HANGUL JUNGSEONG YU-A' },
	[0x118F] = { unicodeslot=0x118F, category='lo', description='HANGUL JUNGSEONG YU-EO' },
	[0x1190] = { unicodeslot=0x1190, category='lo', description='HANGUL JUNGSEONG YU-E' },
	[0x1191] = { unicodeslot=0x1191, category='lo', description='HANGUL JUNGSEONG YU-YEO' },
	[0x1192] = { unicodeslot=0x1192, category='lo', description='HANGUL JUNGSEONG YU-YE' },
	[0x1193] = { unicodeslot=0x1193, category='lo', description='HANGUL JUNGSEONG YU-U' },
	[0x1194] = { unicodeslot=0x1194, category='lo', description='HANGUL JUNGSEONG YU-I' },
	[0x1195] = { unicodeslot=0x1195, category='lo', description='HANGUL JUNGSEONG EU-U' },
	[0x1196] = { unicodeslot=0x1196, category='lo', description='HANGUL JUNGSEONG EU-EU' },
	[0x1197] = { unicodeslot=0x1197, category='lo', description='HANGUL JUNGSEONG YI-U' },
	[0x1198] = { unicodeslot=0x1198, category='lo', description='HANGUL JUNGSEONG I-A' },
	[0x1199] = { unicodeslot=0x1199, category='lo', description='HANGUL JUNGSEONG I-YA' },
	[0x119A] = { unicodeslot=0x119A, category='lo', description='HANGUL JUNGSEONG I-O' },
	[0x119B] = { unicodeslot=0x119B, category='lo', description='HANGUL JUNGSEONG I-U' },
	[0x119C] = { unicodeslot=0x119C, category='lo', description='HANGUL JUNGSEONG I-EU' },
	[0x119D] = { unicodeslot=0x119D, category='lo', description='HANGUL JUNGSEONG I-ARAEA' },
	[0x119E] = { unicodeslot=0x119E, category='lo', description='HANGUL JUNGSEONG ARAEA' },
	[0x119F] = { unicodeslot=0x119F, category='lo', description='HANGUL JUNGSEONG ARAEA-EO' },
	[0x11A0] = { unicodeslot=0x11A0, category='lo', description='HANGUL JUNGSEONG ARAEA-U' },
	[0x11A1] = { unicodeslot=0x11A1, category='lo', description='HANGUL JUNGSEONG ARAEA-I' },
	[0x11A2] = { unicodeslot=0x11A2, category='lo', description='HANGUL JUNGSEONG SSANGARAEA' },
	[0x11A8] = { unicodeslot=0x11A8, category='lo', description='HANGUL JONGSEONG KIYEOK' },
	[0x11A9] = { unicodeslot=0x11A9, category='lo', description='HANGUL JONGSEONG SSANGKIYEOK' },
	[0x11AA] = { unicodeslot=0x11AA, category='lo', description='HANGUL JONGSEONG KIYEOK-SIOS' },
	[0x11AB] = { unicodeslot=0x11AB, category='lo', description='HANGUL JONGSEONG NIEUN' },
	[0x11AC] = { unicodeslot=0x11AC, category='lo', description='HANGUL JONGSEONG NIEUN-CIEUC' },
	[0x11AD] = { unicodeslot=0x11AD, category='lo', description='HANGUL JONGSEONG NIEUN-HIEUH' },
	[0x11AE] = { unicodeslot=0x11AE, category='lo', description='HANGUL JONGSEONG TIKEUT' },
	[0x11AF] = { unicodeslot=0x11AF, category='lo', description='HANGUL JONGSEONG RIEUL' },
	[0x11B0] = { unicodeslot=0x11B0, category='lo', description='HANGUL JONGSEONG RIEUL-KIYEOK' },
	[0x11B1] = { unicodeslot=0x11B1, category='lo', description='HANGUL JONGSEONG RIEUL-MIEUM' },
	[0x11B2] = { unicodeslot=0x11B2, category='lo', description='HANGUL JONGSEONG RIEUL-PIEUP' },
	[0x11B3] = { unicodeslot=0x11B3, category='lo', description='HANGUL JONGSEONG RIEUL-SIOS' },
	[0x11B4] = { unicodeslot=0x11B4, category='lo', description='HANGUL JONGSEONG RIEUL-THIEUTH' },
	[0x11B5] = { unicodeslot=0x11B5, category='lo', description='HANGUL JONGSEONG RIEUL-PHIEUPH' },
	[0x11B6] = { unicodeslot=0x11B6, category='lo', description='HANGUL JONGSEONG RIEUL-HIEUH' },
	[0x11B7] = { unicodeslot=0x11B7, category='lo', description='HANGUL JONGSEONG MIEUM' },
	[0x11B8] = { unicodeslot=0x11B8, category='lo', description='HANGUL JONGSEONG PIEUP' },
	[0x11B9] = { unicodeslot=0x11B9, category='lo', description='HANGUL JONGSEONG PIEUP-SIOS' },
	[0x11BA] = { unicodeslot=0x11BA, category='lo', description='HANGUL JONGSEONG SIOS' },
	[0x11BB] = { unicodeslot=0x11BB, category='lo', description='HANGUL JONGSEONG SSANGSIOS' },
	[0x11BC] = { unicodeslot=0x11BC, category='lo', description='HANGUL JONGSEONG IEUNG' },
	[0x11BD] = { unicodeslot=0x11BD, category='lo', description='HANGUL JONGSEONG CIEUC' },
	[0x11BE] = { unicodeslot=0x11BE, category='lo', description='HANGUL JONGSEONG CHIEUCH' },
	[0x11BF] = { unicodeslot=0x11BF, category='lo', description='HANGUL JONGSEONG KHIEUKH' },
	[0x11C0] = { unicodeslot=0x11C0, category='lo', description='HANGUL JONGSEONG THIEUTH' },
	[0x11C1] = { unicodeslot=0x11C1, category='lo', description='HANGUL JONGSEONG PHIEUPH' },
	[0x11C2] = { unicodeslot=0x11C2, category='lo', description='HANGUL JONGSEONG HIEUH' },
	[0x11C3] = { unicodeslot=0x11C3, category='lo', description='HANGUL JONGSEONG KIYEOK-RIEUL' },
	[0x11C4] = { unicodeslot=0x11C4, category='lo', description='HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK' },
	[0x11C5] = { unicodeslot=0x11C5, category='lo', description='HANGUL JONGSEONG NIEUN-KIYEOK' },
	[0x11C6] = { unicodeslot=0x11C6, category='lo', description='HANGUL JONGSEONG NIEUN-TIKEUT' },
	[0x11C7] = { unicodeslot=0x11C7, category='lo', description='HANGUL JONGSEONG NIEUN-SIOS' },
	[0x11C8] = { unicodeslot=0x11C8, category='lo', description='HANGUL JONGSEONG NIEUN-PANSIOS' },
	[0x11C9] = { unicodeslot=0x11C9, category='lo', description='HANGUL JONGSEONG NIEUN-THIEUTH' },
	[0x11CA] = { unicodeslot=0x11CA, category='lo', description='HANGUL JONGSEONG TIKEUT-KIYEOK' },
	[0x11CB] = { unicodeslot=0x11CB, category='lo', description='HANGUL JONGSEONG TIKEUT-RIEUL' },
	[0x11CC] = { unicodeslot=0x11CC, category='lo', description='HANGUL JONGSEONG RIEUL-KIYEOK-SIOS' },
	[0x11CD] = { unicodeslot=0x11CD, category='lo', description='HANGUL JONGSEONG RIEUL-NIEUN' },
	[0x11CE] = { unicodeslot=0x11CE, category='lo', description='HANGUL JONGSEONG RIEUL-TIKEUT' },
	[0x11CF] = { unicodeslot=0x11CF, category='lo', description='HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH' },
	[0x11D0] = { unicodeslot=0x11D0, category='lo', description='HANGUL JONGSEONG SSANGRIEUL' },
	[0x11D1] = { unicodeslot=0x11D1, category='lo', description='HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK' },
	[0x11D2] = { unicodeslot=0x11D2, category='lo', description='HANGUL JONGSEONG RIEUL-MIEUM-SIOS' },
	[0x11D3] = { unicodeslot=0x11D3, category='lo', description='HANGUL JONGSEONG RIEUL-PIEUP-SIOS' },
	[0x11D4] = { unicodeslot=0x11D4, category='lo', description='HANGUL JONGSEONG RIEUL-PIEUP-HIEUH' },
	[0x11D5] = { unicodeslot=0x11D5, category='lo', description='HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP' },
	[0x11D6] = { unicodeslot=0x11D6, category='lo', description='HANGUL JONGSEONG RIEUL-SSANGSIOS' },
	[0x11D7] = { unicodeslot=0x11D7, category='lo', description='HANGUL JONGSEONG RIEUL-PANSIOS' },
	[0x11D8] = { unicodeslot=0x11D8, category='lo', description='HANGUL JONGSEONG RIEUL-KHIEUKH' },
	[0x11D9] = { unicodeslot=0x11D9, category='lo', description='HANGUL JONGSEONG RIEUL-YEORINHIEUH' },
	[0x11DA] = { unicodeslot=0x11DA, category='lo', description='HANGUL JONGSEONG MIEUM-KIYEOK' },
	[0x11DB] = { unicodeslot=0x11DB, category='lo', description='HANGUL JONGSEONG MIEUM-RIEUL' },
	[0x11DC] = { unicodeslot=0x11DC, category='lo', description='HANGUL JONGSEONG MIEUM-PIEUP' },
	[0x11DD] = { unicodeslot=0x11DD, category='lo', description='HANGUL JONGSEONG MIEUM-SIOS' },
	[0x11DE] = { unicodeslot=0x11DE, category='lo', description='HANGUL JONGSEONG MIEUM-SSANGSIOS' },
	[0x11DF] = { unicodeslot=0x11DF, category='lo', description='HANGUL JONGSEONG MIEUM-PANSIOS' },
	[0x11E0] = { unicodeslot=0x11E0, category='lo', description='HANGUL JONGSEONG MIEUM-CHIEUCH' },
	[0x11E1] = { unicodeslot=0x11E1, category='lo', description='HANGUL JONGSEONG MIEUM-HIEUH' },
	[0x11E2] = { unicodeslot=0x11E2, category='lo', description='HANGUL JONGSEONG KAPYEOUNMIEUM' },
	[0x11E3] = { unicodeslot=0x11E3, category='lo', description='HANGUL JONGSEONG PIEUP-RIEUL' },
	[0x11E4] = { unicodeslot=0x11E4, category='lo', description='HANGUL JONGSEONG PIEUP-PHIEUPH' },
	[0x11E5] = { unicodeslot=0x11E5, category='lo', description='HANGUL JONGSEONG PIEUP-HIEUH' },
	[0x11E6] = { unicodeslot=0x11E6, category='lo', description='HANGUL JONGSEONG KAPYEOUNPIEUP' },
	[0x11E7] = { unicodeslot=0x11E7, category='lo', description='HANGUL JONGSEONG SIOS-KIYEOK' },
	[0x11E8] = { unicodeslot=0x11E8, category='lo', description='HANGUL JONGSEONG SIOS-TIKEUT' },
	[0x11E9] = { unicodeslot=0x11E9, category='lo', description='HANGUL JONGSEONG SIOS-RIEUL' },
	[0x11EA] = { unicodeslot=0x11EA, category='lo', description='HANGUL JONGSEONG SIOS-PIEUP' },
	[0x11EB] = { unicodeslot=0x11EB, category='lo', description='HANGUL JONGSEONG PANSIOS' },
	[0x11EC] = { unicodeslot=0x11EC, category='lo', description='HANGUL JONGSEONG IEUNG-KIYEOK' },
	[0x11ED] = { unicodeslot=0x11ED, category='lo', description='HANGUL JONGSEONG IEUNG-SSANGKIYEOK' },
	[0x11EE] = { unicodeslot=0x11EE, category='lo', description='HANGUL JONGSEONG SSANGIEUNG' },
	[0x11EF] = { unicodeslot=0x11EF, category='lo', description='HANGUL JONGSEONG IEUNG-KHIEUKH' },
	[0x11F0] = { unicodeslot=0x11F0, category='lo', description='HANGUL JONGSEONG YESIEUNG' },
	[0x11F1] = { unicodeslot=0x11F1, category='lo', description='HANGUL JONGSEONG YESIEUNG-SIOS' },
	[0x11F2] = { unicodeslot=0x11F2, category='lo', description='HANGUL JONGSEONG YESIEUNG-PANSIOS' },
	[0x11F3] = { unicodeslot=0x11F3, category='lo', description='HANGUL JONGSEONG PHIEUPH-PIEUP' },
	[0x11F4] = { unicodeslot=0x11F4, category='lo', description='HANGUL JONGSEONG KAPYEOUNPHIEUPH' },
	[0x11F5] = { unicodeslot=0x11F5, category='lo', description='HANGUL JONGSEONG HIEUH-NIEUN' },
	[0x11F6] = { unicodeslot=0x11F6, category='lo', description='HANGUL JONGSEONG HIEUH-RIEUL' },
	[0x11F7] = { unicodeslot=0x11F7, category='lo', description='HANGUL JONGSEONG HIEUH-MIEUM' },
	[0x11F8] = { unicodeslot=0x11F8, category='lo', description='HANGUL JONGSEONG HIEUH-PIEUP' },
	[0x11F9] = { unicodeslot=0x11F9, category='lo', description='HANGUL JONGSEONG YEORINHIEUH' },
	[0x1200] = { unicodeslot=0x1200, category='lo', description='ETHIOPIC SYLLABLE HA' },
	[0x1201] = { unicodeslot=0x1201, category='lo', description='ETHIOPIC SYLLABLE HU' },
	[0x1202] = { unicodeslot=0x1202, category='lo', description='ETHIOPIC SYLLABLE HI' },
	[0x1203] = { unicodeslot=0x1203, category='lo', description='ETHIOPIC SYLLABLE HAA' },
	[0x1204] = { unicodeslot=0x1204, category='lo', description='ETHIOPIC SYLLABLE HEE' },
	[0x1205] = { unicodeslot=0x1205, category='lo', description='ETHIOPIC SYLLABLE HE' },
	[0x1206] = { unicodeslot=0x1206, category='lo', description='ETHIOPIC SYLLABLE HO' },
	[0x1207] = { unicodeslot=0x1207, category='lo', description='ETHIOPIC SYLLABLE HOA' },
	[0x1208] = { unicodeslot=0x1208, category='lo', description='ETHIOPIC SYLLABLE LA' },
	[0x1209] = { unicodeslot=0x1209, category='lo', description='ETHIOPIC SYLLABLE LU' },
	[0x120A] = { unicodeslot=0x120A, category='lo', description='ETHIOPIC SYLLABLE LI' },
	[0x120B] = { unicodeslot=0x120B, category='lo', description='ETHIOPIC SYLLABLE LAA' },
	[0x120C] = { unicodeslot=0x120C, category='lo', description='ETHIOPIC SYLLABLE LEE' },
	[0x120D] = { unicodeslot=0x120D, category='lo', description='ETHIOPIC SYLLABLE LE' },
	[0x120E] = { unicodeslot=0x120E, category='lo', description='ETHIOPIC SYLLABLE LO' },
	[0x120F] = { unicodeslot=0x120F, category='lo', description='ETHIOPIC SYLLABLE LWA' },
	[0x1210] = { unicodeslot=0x1210, category='lo', description='ETHIOPIC SYLLABLE HHA' },
	[0x1211] = { unicodeslot=0x1211, category='lo', description='ETHIOPIC SYLLABLE HHU' },
	[0x1212] = { unicodeslot=0x1212, category='lo', description='ETHIOPIC SYLLABLE HHI' },
	[0x1213] = { unicodeslot=0x1213, category='lo', description='ETHIOPIC SYLLABLE HHAA' },
	[0x1214] = { unicodeslot=0x1214, category='lo', description='ETHIOPIC SYLLABLE HHEE' },
	[0x1215] = { unicodeslot=0x1215, category='lo', description='ETHIOPIC SYLLABLE HHE' },
	[0x1216] = { unicodeslot=0x1216, category='lo', description='ETHIOPIC SYLLABLE HHO' },
	[0x1217] = { unicodeslot=0x1217, category='lo', description='ETHIOPIC SYLLABLE HHWA' },
	[0x1218] = { unicodeslot=0x1218, category='lo', description='ETHIOPIC SYLLABLE MA' },
	[0x1219] = { unicodeslot=0x1219, category='lo', description='ETHIOPIC SYLLABLE MU' },
	[0x121A] = { unicodeslot=0x121A, category='lo', description='ETHIOPIC SYLLABLE MI' },
	[0x121B] = { unicodeslot=0x121B, category='lo', description='ETHIOPIC SYLLABLE MAA' },
	[0x121C] = { unicodeslot=0x121C, category='lo', description='ETHIOPIC SYLLABLE MEE' },
	[0x121D] = { unicodeslot=0x121D, category='lo', description='ETHIOPIC SYLLABLE ME' },
	[0x121E] = { unicodeslot=0x121E, category='lo', description='ETHIOPIC SYLLABLE MO' },
	[0x121F] = { unicodeslot=0x121F, category='lo', description='ETHIOPIC SYLLABLE MWA' },
	[0x1220] = { unicodeslot=0x1220, category='lo', description='ETHIOPIC SYLLABLE SZA' },
	[0x1221] = { unicodeslot=0x1221, category='lo', description='ETHIOPIC SYLLABLE SZU' },
	[0x1222] = { unicodeslot=0x1222, category='lo', description='ETHIOPIC SYLLABLE SZI' },
	[0x1223] = { unicodeslot=0x1223, category='lo', description='ETHIOPIC SYLLABLE SZAA' },
	[0x1224] = { unicodeslot=0x1224, category='lo', description='ETHIOPIC SYLLABLE SZEE' },
	[0x1225] = { unicodeslot=0x1225, category='lo', description='ETHIOPIC SYLLABLE SZE' },
	[0x1226] = { unicodeslot=0x1226, category='lo', description='ETHIOPIC SYLLABLE SZO' },
	[0x1227] = { unicodeslot=0x1227, category='lo', description='ETHIOPIC SYLLABLE SZWA' },
	[0x1228] = { unicodeslot=0x1228, category='lo', description='ETHIOPIC SYLLABLE RA' },
	[0x1229] = { unicodeslot=0x1229, category='lo', description='ETHIOPIC SYLLABLE RU' },
	[0x122A] = { unicodeslot=0x122A, category='lo', description='ETHIOPIC SYLLABLE RI' },
	[0x122B] = { unicodeslot=0x122B, category='lo', description='ETHIOPIC SYLLABLE RAA' },
	[0x122C] = { unicodeslot=0x122C, category='lo', description='ETHIOPIC SYLLABLE REE' },
	[0x122D] = { unicodeslot=0x122D, category='lo', description='ETHIOPIC SYLLABLE RE' },
	[0x122E] = { unicodeslot=0x122E, category='lo', description='ETHIOPIC SYLLABLE RO' },
	[0x122F] = { unicodeslot=0x122F, category='lo', description='ETHIOPIC SYLLABLE RWA' },
	[0x1230] = { unicodeslot=0x1230, category='lo', description='ETHIOPIC SYLLABLE SA' },
	[0x1231] = { unicodeslot=0x1231, category='lo', description='ETHIOPIC SYLLABLE SU' },
	[0x1232] = { unicodeslot=0x1232, category='lo', description='ETHIOPIC SYLLABLE SI' },
	[0x1233] = { unicodeslot=0x1233, category='lo', description='ETHIOPIC SYLLABLE SAA' },
	[0x1234] = { unicodeslot=0x1234, category='lo', description='ETHIOPIC SYLLABLE SEE' },
	[0x1235] = { unicodeslot=0x1235, category='lo', description='ETHIOPIC SYLLABLE SE' },
	[0x1236] = { unicodeslot=0x1236, category='lo', description='ETHIOPIC SYLLABLE SO' },
	[0x1237] = { unicodeslot=0x1237, category='lo', description='ETHIOPIC SYLLABLE SWA' },
	[0x1238] = { unicodeslot=0x1238, category='lo', description='ETHIOPIC SYLLABLE SHA' },
	[0x1239] = { unicodeslot=0x1239, category='lo', description='ETHIOPIC SYLLABLE SHU' },
	[0x123A] = { unicodeslot=0x123A, category='lo', description='ETHIOPIC SYLLABLE SHI' },
	[0x123B] = { unicodeslot=0x123B, category='lo', description='ETHIOPIC SYLLABLE SHAA' },
	[0x123C] = { unicodeslot=0x123C, category='lo', description='ETHIOPIC SYLLABLE SHEE' },
	[0x123D] = { unicodeslot=0x123D, category='lo', description='ETHIOPIC SYLLABLE SHE' },
	[0x123E] = { unicodeslot=0x123E, category='lo', description='ETHIOPIC SYLLABLE SHO' },
	[0x123F] = { unicodeslot=0x123F, category='lo', description='ETHIOPIC SYLLABLE SHWA' },
	[0x1240] = { unicodeslot=0x1240, category='lo', description='ETHIOPIC SYLLABLE QA' },
	[0x1241] = { unicodeslot=0x1241, category='lo', description='ETHIOPIC SYLLABLE QU' },
	[0x1242] = { unicodeslot=0x1242, category='lo', description='ETHIOPIC SYLLABLE QI' },
	[0x1243] = { unicodeslot=0x1243, category='lo', description='ETHIOPIC SYLLABLE QAA' },
	[0x1244] = { unicodeslot=0x1244, category='lo', description='ETHIOPIC SYLLABLE QEE' },
	[0x1245] = { unicodeslot=0x1245, category='lo', description='ETHIOPIC SYLLABLE QE' },
	[0x1246] = { unicodeslot=0x1246, category='lo', description='ETHIOPIC SYLLABLE QO' },
	[0x1247] = { unicodeslot=0x1247, category='lo', description='ETHIOPIC SYLLABLE QOA' },
	[0x1248] = { unicodeslot=0x1248, category='lo', description='ETHIOPIC SYLLABLE QWA' },
	[0x124A] = { unicodeslot=0x124A, category='lo', description='ETHIOPIC SYLLABLE QWI' },
	[0x124B] = { unicodeslot=0x124B, category='lo', description='ETHIOPIC SYLLABLE QWAA' },
	[0x124C] = { unicodeslot=0x124C, category='lo', description='ETHIOPIC SYLLABLE QWEE' },
	[0x124D] = { unicodeslot=0x124D, category='lo', description='ETHIOPIC SYLLABLE QWE' },
	[0x1250] = { unicodeslot=0x1250, category='lo', description='ETHIOPIC SYLLABLE QHA' },
	[0x1251] = { unicodeslot=0x1251, category='lo', description='ETHIOPIC SYLLABLE QHU' },
	[0x1252] = { unicodeslot=0x1252, category='lo', description='ETHIOPIC SYLLABLE QHI' },
	[0x1253] = { unicodeslot=0x1253, category='lo', description='ETHIOPIC SYLLABLE QHAA' },
	[0x1254] = { unicodeslot=0x1254, category='lo', description='ETHIOPIC SYLLABLE QHEE' },
	[0x1255] = { unicodeslot=0x1255, category='lo', description='ETHIOPIC SYLLABLE QHE' },
	[0x1256] = { unicodeslot=0x1256, category='lo', description='ETHIOPIC SYLLABLE QHO' },
	[0x1258] = { unicodeslot=0x1258, category='lo', description='ETHIOPIC SYLLABLE QHWA' },
	[0x125A] = { unicodeslot=0x125A, category='lo', description='ETHIOPIC SYLLABLE QHWI' },
	[0x125B] = { unicodeslot=0x125B, category='lo', description='ETHIOPIC SYLLABLE QHWAA' },
	[0x125C] = { unicodeslot=0x125C, category='lo', description='ETHIOPIC SYLLABLE QHWEE' },
	[0x125D] = { unicodeslot=0x125D, category='lo', description='ETHIOPIC SYLLABLE QHWE' },
	[0x1260] = { unicodeslot=0x1260, category='lo', description='ETHIOPIC SYLLABLE BA' },
	[0x1261] = { unicodeslot=0x1261, category='lo', description='ETHIOPIC SYLLABLE BU' },
	[0x1262] = { unicodeslot=0x1262, category='lo', description='ETHIOPIC SYLLABLE BI' },
	[0x1263] = { unicodeslot=0x1263, category='lo', description='ETHIOPIC SYLLABLE BAA' },
	[0x1264] = { unicodeslot=0x1264, category='lo', description='ETHIOPIC SYLLABLE BEE' },
	[0x1265] = { unicodeslot=0x1265, category='lo', description='ETHIOPIC SYLLABLE BE' },
	[0x1266] = { unicodeslot=0x1266, category='lo', description='ETHIOPIC SYLLABLE BO' },
	[0x1267] = { unicodeslot=0x1267, category='lo', description='ETHIOPIC SYLLABLE BWA' },
	[0x1268] = { unicodeslot=0x1268, category='lo', description='ETHIOPIC SYLLABLE VA' },
	[0x1269] = { unicodeslot=0x1269, category='lo', description='ETHIOPIC SYLLABLE VU' },
	[0x126A] = { unicodeslot=0x126A, category='lo', description='ETHIOPIC SYLLABLE VI' },
	[0x126B] = { unicodeslot=0x126B, category='lo', description='ETHIOPIC SYLLABLE VAA' },
	[0x126C] = { unicodeslot=0x126C, category='lo', description='ETHIOPIC SYLLABLE VEE' },
	[0x126D] = { unicodeslot=0x126D, category='lo', description='ETHIOPIC SYLLABLE VE' },
	[0x126E] = { unicodeslot=0x126E, category='lo', description='ETHIOPIC SYLLABLE VO' },
	[0x126F] = { unicodeslot=0x126F, category='lo', description='ETHIOPIC SYLLABLE VWA' },
	[0x1270] = { unicodeslot=0x1270, category='lo', description='ETHIOPIC SYLLABLE TA' },
	[0x1271] = { unicodeslot=0x1271, category='lo', description='ETHIOPIC SYLLABLE TU' },
	[0x1272] = { unicodeslot=0x1272, category='lo', description='ETHIOPIC SYLLABLE TI' },
	[0x1273] = { unicodeslot=0x1273, category='lo', description='ETHIOPIC SYLLABLE TAA' },
	[0x1274] = { unicodeslot=0x1274, category='lo', description='ETHIOPIC SYLLABLE TEE' },
	[0x1275] = { unicodeslot=0x1275, category='lo', description='ETHIOPIC SYLLABLE TE' },
	[0x1276] = { unicodeslot=0x1276, category='lo', description='ETHIOPIC SYLLABLE TO' },
	[0x1277] = { unicodeslot=0x1277, category='lo', description='ETHIOPIC SYLLABLE TWA' },
	[0x1278] = { unicodeslot=0x1278, category='lo', description='ETHIOPIC SYLLABLE CA' },
	[0x1279] = { unicodeslot=0x1279, category='lo', description='ETHIOPIC SYLLABLE CU' },
	[0x127A] = { unicodeslot=0x127A, category='lo', description='ETHIOPIC SYLLABLE CI' },
	[0x127B] = { unicodeslot=0x127B, category='lo', description='ETHIOPIC SYLLABLE CAA' },
	[0x127C] = { unicodeslot=0x127C, category='lo', description='ETHIOPIC SYLLABLE CEE' },
	[0x127D] = { unicodeslot=0x127D, category='lo', description='ETHIOPIC SYLLABLE CE' },
	[0x127E] = { unicodeslot=0x127E, category='lo', description='ETHIOPIC SYLLABLE CO' },
	[0x127F] = { unicodeslot=0x127F, category='lo', description='ETHIOPIC SYLLABLE CWA' },
	[0x1280] = { unicodeslot=0x1280, category='lo', description='ETHIOPIC SYLLABLE XA' },
	[0x1281] = { unicodeslot=0x1281, category='lo', description='ETHIOPIC SYLLABLE XU' },
	[0x1282] = { unicodeslot=0x1282, category='lo', description='ETHIOPIC SYLLABLE XI' },
	[0x1283] = { unicodeslot=0x1283, category='lo', description='ETHIOPIC SYLLABLE XAA' },
	[0x1284] = { unicodeslot=0x1284, category='lo', description='ETHIOPIC SYLLABLE XEE' },
	[0x1285] = { unicodeslot=0x1285, category='lo', description='ETHIOPIC SYLLABLE XE' },
	[0x1286] = { unicodeslot=0x1286, category='lo', description='ETHIOPIC SYLLABLE XO' },
	[0x1287] = { unicodeslot=0x1287, category='lo', description='ETHIOPIC SYLLABLE XOA' },
	[0x1288] = { unicodeslot=0x1288, category='lo', description='ETHIOPIC SYLLABLE XWA' },
	[0x128A] = { unicodeslot=0x128A, category='lo', description='ETHIOPIC SYLLABLE XWI' },
	[0x128B] = { unicodeslot=0x128B, category='lo', description='ETHIOPIC SYLLABLE XWAA' },
	[0x128C] = { unicodeslot=0x128C, category='lo', description='ETHIOPIC SYLLABLE XWEE' },
	[0x128D] = { unicodeslot=0x128D, category='lo', description='ETHIOPIC SYLLABLE XWE' },
	[0x1290] = { unicodeslot=0x1290, category='lo', description='ETHIOPIC SYLLABLE NA' },
	[0x1291] = { unicodeslot=0x1291, category='lo', description='ETHIOPIC SYLLABLE NU' },
	[0x1292] = { unicodeslot=0x1292, category='lo', description='ETHIOPIC SYLLABLE NI' },
	[0x1293] = { unicodeslot=0x1293, category='lo', description='ETHIOPIC SYLLABLE NAA' },
	[0x1294] = { unicodeslot=0x1294, category='lo', description='ETHIOPIC SYLLABLE NEE' },
	[0x1295] = { unicodeslot=0x1295, category='lo', description='ETHIOPIC SYLLABLE NE' },
	[0x1296] = { unicodeslot=0x1296, category='lo', description='ETHIOPIC SYLLABLE NO' },
	[0x1297] = { unicodeslot=0x1297, category='lo', description='ETHIOPIC SYLLABLE NWA' },
	[0x1298] = { unicodeslot=0x1298, category='lo', description='ETHIOPIC SYLLABLE NYA' },
	[0x1299] = { unicodeslot=0x1299, category='lo', description='ETHIOPIC SYLLABLE NYU' },
	[0x129A] = { unicodeslot=0x129A, category='lo', description='ETHIOPIC SYLLABLE NYI' },
	[0x129B] = { unicodeslot=0x129B, category='lo', description='ETHIOPIC SYLLABLE NYAA' },
	[0x129C] = { unicodeslot=0x129C, category='lo', description='ETHIOPIC SYLLABLE NYEE' },
	[0x129D] = { unicodeslot=0x129D, category='lo', description='ETHIOPIC SYLLABLE NYE' },
	[0x129E] = { unicodeslot=0x129E, category='lo', description='ETHIOPIC SYLLABLE NYO' },
	[0x129F] = { unicodeslot=0x129F, category='lo', description='ETHIOPIC SYLLABLE NYWA' },
	[0x12A0] = { unicodeslot=0x12A0, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL A' },
	[0x12A1] = { unicodeslot=0x12A1, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL U' },
	[0x12A2] = { unicodeslot=0x12A2, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL I' },
	[0x12A3] = { unicodeslot=0x12A3, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL AA' },
	[0x12A4] = { unicodeslot=0x12A4, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL EE' },
	[0x12A5] = { unicodeslot=0x12A5, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL E' },
	[0x12A6] = { unicodeslot=0x12A6, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL O' },
	[0x12A7] = { unicodeslot=0x12A7, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL WA' },
	[0x12A8] = { unicodeslot=0x12A8, category='lo', description='ETHIOPIC SYLLABLE KA' },
	[0x12A9] = { unicodeslot=0x12A9, category='lo', description='ETHIOPIC SYLLABLE KU' },
	[0x12AA] = { unicodeslot=0x12AA, category='lo', description='ETHIOPIC SYLLABLE KI' },
	[0x12AB] = { unicodeslot=0x12AB, category='lo', description='ETHIOPIC SYLLABLE KAA' },
	[0x12AC] = { unicodeslot=0x12AC, category='lo', description='ETHIOPIC SYLLABLE KEE' },
	[0x12AD] = { unicodeslot=0x12AD, category='lo', description='ETHIOPIC SYLLABLE KE' },
	[0x12AE] = { unicodeslot=0x12AE, category='lo', description='ETHIOPIC SYLLABLE KO' },
	[0x12AF] = { unicodeslot=0x12AF, category='lo', description='ETHIOPIC SYLLABLE KOA' },
	[0x12B0] = { unicodeslot=0x12B0, category='lo', description='ETHIOPIC SYLLABLE KWA' },
	[0x12B2] = { unicodeslot=0x12B2, category='lo', description='ETHIOPIC SYLLABLE KWI' },
	[0x12B3] = { unicodeslot=0x12B3, category='lo', description='ETHIOPIC SYLLABLE KWAA' },
	[0x12B4] = { unicodeslot=0x12B4, category='lo', description='ETHIOPIC SYLLABLE KWEE' },
	[0x12B5] = { unicodeslot=0x12B5, category='lo', description='ETHIOPIC SYLLABLE KWE' },
	[0x12B8] = { unicodeslot=0x12B8, category='lo', description='ETHIOPIC SYLLABLE KXA' },
	[0x12B9] = { unicodeslot=0x12B9, category='lo', description='ETHIOPIC SYLLABLE KXU' },
	[0x12BA] = { unicodeslot=0x12BA, category='lo', description='ETHIOPIC SYLLABLE KXI' },
	[0x12BB] = { unicodeslot=0x12BB, category='lo', description='ETHIOPIC SYLLABLE KXAA' },
	[0x12BC] = { unicodeslot=0x12BC, category='lo', description='ETHIOPIC SYLLABLE KXEE' },
	[0x12BD] = { unicodeslot=0x12BD, category='lo', description='ETHIOPIC SYLLABLE KXE' },
	[0x12BE] = { unicodeslot=0x12BE, category='lo', description='ETHIOPIC SYLLABLE KXO' },
	[0x12C0] = { unicodeslot=0x12C0, category='lo', description='ETHIOPIC SYLLABLE KXWA' },
	[0x12C2] = { unicodeslot=0x12C2, category='lo', description='ETHIOPIC SYLLABLE KXWI' },
	[0x12C3] = { unicodeslot=0x12C3, category='lo', description='ETHIOPIC SYLLABLE KXWAA' },
	[0x12C4] = { unicodeslot=0x12C4, category='lo', description='ETHIOPIC SYLLABLE KXWEE' },
	[0x12C5] = { unicodeslot=0x12C5, category='lo', description='ETHIOPIC SYLLABLE KXWE' },
	[0x12C8] = { unicodeslot=0x12C8, category='lo', description='ETHIOPIC SYLLABLE WA' },
	[0x12C9] = { unicodeslot=0x12C9, category='lo', description='ETHIOPIC SYLLABLE WU' },
	[0x12CA] = { unicodeslot=0x12CA, category='lo', description='ETHIOPIC SYLLABLE WI' },
	[0x12CB] = { unicodeslot=0x12CB, category='lo', description='ETHIOPIC SYLLABLE WAA' },
	[0x12CC] = { unicodeslot=0x12CC, category='lo', description='ETHIOPIC SYLLABLE WEE' },
	[0x12CD] = { unicodeslot=0x12CD, category='lo', description='ETHIOPIC SYLLABLE WE' },
	[0x12CE] = { unicodeslot=0x12CE, category='lo', description='ETHIOPIC SYLLABLE WO' },
	[0x12CF] = { unicodeslot=0x12CF, category='lo', description='ETHIOPIC SYLLABLE WOA' },
	[0x12D0] = { unicodeslot=0x12D0, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL A' },
	[0x12D1] = { unicodeslot=0x12D1, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL U' },
	[0x12D2] = { unicodeslot=0x12D2, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL I' },
	[0x12D3] = { unicodeslot=0x12D3, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL AA' },
	[0x12D4] = { unicodeslot=0x12D4, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL EE' },
	[0x12D5] = { unicodeslot=0x12D5, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL E' },
	[0x12D6] = { unicodeslot=0x12D6, category='lo', description='ETHIOPIC SYLLABLE PHARYNGEAL O' },
	[0x12D8] = { unicodeslot=0x12D8, category='lo', description='ETHIOPIC SYLLABLE ZA' },
	[0x12D9] = { unicodeslot=0x12D9, category='lo', description='ETHIOPIC SYLLABLE ZU' },
	[0x12DA] = { unicodeslot=0x12DA, category='lo', description='ETHIOPIC SYLLABLE ZI' },
	[0x12DB] = { unicodeslot=0x12DB, category='lo', description='ETHIOPIC SYLLABLE ZAA' },
	[0x12DC] = { unicodeslot=0x12DC, category='lo', description='ETHIOPIC SYLLABLE ZEE' },
	[0x12DD] = { unicodeslot=0x12DD, category='lo', description='ETHIOPIC SYLLABLE ZE' },
	[0x12DE] = { unicodeslot=0x12DE, category='lo', description='ETHIOPIC SYLLABLE ZO' },
	[0x12DF] = { unicodeslot=0x12DF, category='lo', description='ETHIOPIC SYLLABLE ZWA' },
	[0x12E0] = { unicodeslot=0x12E0, category='lo', description='ETHIOPIC SYLLABLE ZHA' },
	[0x12E1] = { unicodeslot=0x12E1, category='lo', description='ETHIOPIC SYLLABLE ZHU' },
	[0x12E2] = { unicodeslot=0x12E2, category='lo', description='ETHIOPIC SYLLABLE ZHI' },
	[0x12E3] = { unicodeslot=0x12E3, category='lo', description='ETHIOPIC SYLLABLE ZHAA' },
	[0x12E4] = { unicodeslot=0x12E4, category='lo', description='ETHIOPIC SYLLABLE ZHEE' },
	[0x12E5] = { unicodeslot=0x12E5, category='lo', description='ETHIOPIC SYLLABLE ZHE' },
	[0x12E6] = { unicodeslot=0x12E6, category='lo', description='ETHIOPIC SYLLABLE ZHO' },
	[0x12E7] = { unicodeslot=0x12E7, category='lo', description='ETHIOPIC SYLLABLE ZHWA' },
	[0x12E8] = { unicodeslot=0x12E8, category='lo', description='ETHIOPIC SYLLABLE YA' },
	[0x12E9] = { unicodeslot=0x12E9, category='lo', description='ETHIOPIC SYLLABLE YU' },
	[0x12EA] = { unicodeslot=0x12EA, category='lo', description='ETHIOPIC SYLLABLE YI' },
	[0x12EB] = { unicodeslot=0x12EB, category='lo', description='ETHIOPIC SYLLABLE YAA' },
	[0x12EC] = { unicodeslot=0x12EC, category='lo', description='ETHIOPIC SYLLABLE YEE' },
	[0x12ED] = { unicodeslot=0x12ED, category='lo', description='ETHIOPIC SYLLABLE YE' },
	[0x12EE] = { unicodeslot=0x12EE, category='lo', description='ETHIOPIC SYLLABLE YO' },
	[0x12EF] = { unicodeslot=0x12EF, category='lo', description='ETHIOPIC SYLLABLE YOA' },
	[0x12F0] = { unicodeslot=0x12F0, category='lo', description='ETHIOPIC SYLLABLE DA' },
	[0x12F1] = { unicodeslot=0x12F1, category='lo', description='ETHIOPIC SYLLABLE DU' },
	[0x12F2] = { unicodeslot=0x12F2, category='lo', description='ETHIOPIC SYLLABLE DI' },
	[0x12F3] = { unicodeslot=0x12F3, category='lo', description='ETHIOPIC SYLLABLE DAA' },
	[0x12F4] = { unicodeslot=0x12F4, category='lo', description='ETHIOPIC SYLLABLE DEE' },
	[0x12F5] = { unicodeslot=0x12F5, category='lo', description='ETHIOPIC SYLLABLE DE' },
	[0x12F6] = { unicodeslot=0x12F6, category='lo', description='ETHIOPIC SYLLABLE DO' },
	[0x12F7] = { unicodeslot=0x12F7, category='lo', description='ETHIOPIC SYLLABLE DWA' },
	[0x12F8] = { unicodeslot=0x12F8, category='lo', description='ETHIOPIC SYLLABLE DDA' },
	[0x12F9] = { unicodeslot=0x12F9, category='lo', description='ETHIOPIC SYLLABLE DDU' },
	[0x12FA] = { unicodeslot=0x12FA, category='lo', description='ETHIOPIC SYLLABLE DDI' },
	[0x12FB] = { unicodeslot=0x12FB, category='lo', description='ETHIOPIC SYLLABLE DDAA' },
	[0x12FC] = { unicodeslot=0x12FC, category='lo', description='ETHIOPIC SYLLABLE DDEE' },
	[0x12FD] = { unicodeslot=0x12FD, category='lo', description='ETHIOPIC SYLLABLE DDE' },
	[0x12FE] = { unicodeslot=0x12FE, category='lo', description='ETHIOPIC SYLLABLE DDO' },
	[0x12FF] = { unicodeslot=0x12FF, category='lo', description='ETHIOPIC SYLLABLE DDWA' },
	[0x1300] = { unicodeslot=0x1300, category='lo', description='ETHIOPIC SYLLABLE JA' },
	[0x1301] = { unicodeslot=0x1301, category='lo', description='ETHIOPIC SYLLABLE JU' },
	[0x1302] = { unicodeslot=0x1302, category='lo', description='ETHIOPIC SYLLABLE JI' },
	[0x1303] = { unicodeslot=0x1303, category='lo', description='ETHIOPIC SYLLABLE JAA' },
	[0x1304] = { unicodeslot=0x1304, category='lo', description='ETHIOPIC SYLLABLE JEE' },
	[0x1305] = { unicodeslot=0x1305, category='lo', description='ETHIOPIC SYLLABLE JE' },
	[0x1306] = { unicodeslot=0x1306, category='lo', description='ETHIOPIC SYLLABLE JO' },
	[0x1307] = { unicodeslot=0x1307, category='lo', description='ETHIOPIC SYLLABLE JWA' },
	[0x1308] = { unicodeslot=0x1308, category='lo', description='ETHIOPIC SYLLABLE GA' },
	[0x1309] = { unicodeslot=0x1309, category='lo', description='ETHIOPIC SYLLABLE GU' },
	[0x130A] = { unicodeslot=0x130A, category='lo', description='ETHIOPIC SYLLABLE GI' },
	[0x130B] = { unicodeslot=0x130B, category='lo', description='ETHIOPIC SYLLABLE GAA' },
	[0x130C] = { unicodeslot=0x130C, category='lo', description='ETHIOPIC SYLLABLE GEE' },
	[0x130D] = { unicodeslot=0x130D, category='lo', description='ETHIOPIC SYLLABLE GE' },
	[0x130E] = { unicodeslot=0x130E, category='lo', description='ETHIOPIC SYLLABLE GO' },
	[0x130F] = { unicodeslot=0x130F, category='lo', description='ETHIOPIC SYLLABLE GOA' },
	[0x1310] = { unicodeslot=0x1310, category='lo', description='ETHIOPIC SYLLABLE GWA' },
	[0x1312] = { unicodeslot=0x1312, category='lo', description='ETHIOPIC SYLLABLE GWI' },
	[0x1313] = { unicodeslot=0x1313, category='lo', description='ETHIOPIC SYLLABLE GWAA' },
	[0x1314] = { unicodeslot=0x1314, category='lo', description='ETHIOPIC SYLLABLE GWEE' },
	[0x1315] = { unicodeslot=0x1315, category='lo', description='ETHIOPIC SYLLABLE GWE' },
	[0x1318] = { unicodeslot=0x1318, category='lo', description='ETHIOPIC SYLLABLE GGA' },
	[0x1319] = { unicodeslot=0x1319, category='lo', description='ETHIOPIC SYLLABLE GGU' },
	[0x131A] = { unicodeslot=0x131A, category='lo', description='ETHIOPIC SYLLABLE GGI' },
	[0x131B] = { unicodeslot=0x131B, category='lo', description='ETHIOPIC SYLLABLE GGAA' },
	[0x131C] = { unicodeslot=0x131C, category='lo', description='ETHIOPIC SYLLABLE GGEE' },
	[0x131D] = { unicodeslot=0x131D, category='lo', description='ETHIOPIC SYLLABLE GGE' },
	[0x131E] = { unicodeslot=0x131E, category='lo', description='ETHIOPIC SYLLABLE GGO' },
	[0x131F] = { unicodeslot=0x131F, category='lo', description='ETHIOPIC SYLLABLE GGWAA' },
	[0x1320] = { unicodeslot=0x1320, category='lo', description='ETHIOPIC SYLLABLE THA' },
	[0x1321] = { unicodeslot=0x1321, category='lo', description='ETHIOPIC SYLLABLE THU' },
	[0x1322] = { unicodeslot=0x1322, category='lo', description='ETHIOPIC SYLLABLE THI' },
	[0x1323] = { unicodeslot=0x1323, category='lo', description='ETHIOPIC SYLLABLE THAA' },
	[0x1324] = { unicodeslot=0x1324, category='lo', description='ETHIOPIC SYLLABLE THEE' },
	[0x1325] = { unicodeslot=0x1325, category='lo', description='ETHIOPIC SYLLABLE THE' },
	[0x1326] = { unicodeslot=0x1326, category='lo', description='ETHIOPIC SYLLABLE THO' },
	[0x1327] = { unicodeslot=0x1327, category='lo', description='ETHIOPIC SYLLABLE THWA' },
	[0x1328] = { unicodeslot=0x1328, category='lo', description='ETHIOPIC SYLLABLE CHA' },
	[0x1329] = { unicodeslot=0x1329, category='lo', description='ETHIOPIC SYLLABLE CHU' },
	[0x132A] = { unicodeslot=0x132A, category='lo', description='ETHIOPIC SYLLABLE CHI' },
	[0x132B] = { unicodeslot=0x132B, category='lo', description='ETHIOPIC SYLLABLE CHAA' },
	[0x132C] = { unicodeslot=0x132C, category='lo', description='ETHIOPIC SYLLABLE CHEE' },
	[0x132D] = { unicodeslot=0x132D, category='lo', description='ETHIOPIC SYLLABLE CHE' },
	[0x132E] = { unicodeslot=0x132E, category='lo', description='ETHIOPIC SYLLABLE CHO' },
	[0x132F] = { unicodeslot=0x132F, category='lo', description='ETHIOPIC SYLLABLE CHWA' },
	[0x1330] = { unicodeslot=0x1330, category='lo', description='ETHIOPIC SYLLABLE PHA' },
	[0x1331] = { unicodeslot=0x1331, category='lo', description='ETHIOPIC SYLLABLE PHU' },
	[0x1332] = { unicodeslot=0x1332, category='lo', description='ETHIOPIC SYLLABLE PHI' },
	[0x1333] = { unicodeslot=0x1333, category='lo', description='ETHIOPIC SYLLABLE PHAA' },
	[0x1334] = { unicodeslot=0x1334, category='lo', description='ETHIOPIC SYLLABLE PHEE' },
	[0x1335] = { unicodeslot=0x1335, category='lo', description='ETHIOPIC SYLLABLE PHE' },
	[0x1336] = { unicodeslot=0x1336, category='lo', description='ETHIOPIC SYLLABLE PHO' },
	[0x1337] = { unicodeslot=0x1337, category='lo', description='ETHIOPIC SYLLABLE PHWA' },
	[0x1338] = { unicodeslot=0x1338, category='lo', description='ETHIOPIC SYLLABLE TSA' },
	[0x1339] = { unicodeslot=0x1339, category='lo', description='ETHIOPIC SYLLABLE TSU' },
	[0x133A] = { unicodeslot=0x133A, category='lo', description='ETHIOPIC SYLLABLE TSI' },
	[0x133B] = { unicodeslot=0x133B, category='lo', description='ETHIOPIC SYLLABLE TSAA' },
	[0x133C] = { unicodeslot=0x133C, category='lo', description='ETHIOPIC SYLLABLE TSEE' },
	[0x133D] = { unicodeslot=0x133D, category='lo', description='ETHIOPIC SYLLABLE TSE' },
	[0x133E] = { unicodeslot=0x133E, category='lo', description='ETHIOPIC SYLLABLE TSO' },
	[0x133F] = { unicodeslot=0x133F, category='lo', description='ETHIOPIC SYLLABLE TSWA' },
	[0x1340] = { unicodeslot=0x1340, category='lo', description='ETHIOPIC SYLLABLE TZA' },
	[0x1341] = { unicodeslot=0x1341, category='lo', description='ETHIOPIC SYLLABLE TZU' },
	[0x1342] = { unicodeslot=0x1342, category='lo', description='ETHIOPIC SYLLABLE TZI' },
	[0x1343] = { unicodeslot=0x1343, category='lo', description='ETHIOPIC SYLLABLE TZAA' },
	[0x1344] = { unicodeslot=0x1344, category='lo', description='ETHIOPIC SYLLABLE TZEE' },
	[0x1345] = { unicodeslot=0x1345, category='lo', description='ETHIOPIC SYLLABLE TZE' },
	[0x1346] = { unicodeslot=0x1346, category='lo', description='ETHIOPIC SYLLABLE TZO' },
	[0x1347] = { unicodeslot=0x1347, category='lo', description='ETHIOPIC SYLLABLE TZOA' },
	[0x1348] = { unicodeslot=0x1348, category='lo', description='ETHIOPIC SYLLABLE FA' },
	[0x1349] = { unicodeslot=0x1349, category='lo', description='ETHIOPIC SYLLABLE FU' },
	[0x134A] = { unicodeslot=0x134A, category='lo', description='ETHIOPIC SYLLABLE FI' },
	[0x134B] = { unicodeslot=0x134B, category='lo', description='ETHIOPIC SYLLABLE FAA' },
	[0x134C] = { unicodeslot=0x134C, category='lo', description='ETHIOPIC SYLLABLE FEE' },
	[0x134D] = { unicodeslot=0x134D, category='lo', description='ETHIOPIC SYLLABLE FE' },
	[0x134E] = { unicodeslot=0x134E, category='lo', description='ETHIOPIC SYLLABLE FO' },
	[0x134F] = { unicodeslot=0x134F, category='lo', description='ETHIOPIC SYLLABLE FWA' },
	[0x1350] = { unicodeslot=0x1350, category='lo', description='ETHIOPIC SYLLABLE PA' },
	[0x1351] = { unicodeslot=0x1351, category='lo', description='ETHIOPIC SYLLABLE PU' },
	[0x1352] = { unicodeslot=0x1352, category='lo', description='ETHIOPIC SYLLABLE PI' },
	[0x1353] = { unicodeslot=0x1353, category='lo', description='ETHIOPIC SYLLABLE PAA' },
	[0x1354] = { unicodeslot=0x1354, category='lo', description='ETHIOPIC SYLLABLE PEE' },
	[0x1355] = { unicodeslot=0x1355, category='lo', description='ETHIOPIC SYLLABLE PE' },
	[0x1356] = { unicodeslot=0x1356, category='lo', description='ETHIOPIC SYLLABLE PO' },
	[0x1357] = { unicodeslot=0x1357, category='lo', description='ETHIOPIC SYLLABLE PWA' },
	[0x1358] = { unicodeslot=0x1358, category='lo', description='ETHIOPIC SYLLABLE RYA' },
	[0x1359] = { unicodeslot=0x1359, category='lo', description='ETHIOPIC SYLLABLE MYA' },
	[0x135A] = { unicodeslot=0x135A, category='lo', description='ETHIOPIC SYLLABLE FYA' },
	[0x135F] = { unicodeslot=0x135F, category='mn', description='ETHIOPIC COMBINING GEMINATION MARK' },
	[0x1360] = { unicodeslot=0x1360, category='so', description='ETHIOPIC SECTION MARK' },
	[0x1361] = { unicodeslot=0x1361, category='po', description='ETHIOPIC WORDSPACE' },
	[0x1362] = { unicodeslot=0x1362, category='po', description='ETHIOPIC FULL STOP' },
	[0x1363] = { unicodeslot=0x1363, category='po', description='ETHIOPIC COMMA' },
	[0x1364] = { unicodeslot=0x1364, category='po', description='ETHIOPIC SEMICOLON' },
	[0x1365] = { unicodeslot=0x1365, category='po', description='ETHIOPIC COLON' },
	[0x1366] = { unicodeslot=0x1366, category='po', description='ETHIOPIC PREFACE COLON' },
	[0x1367] = { unicodeslot=0x1367, category='po', description='ETHIOPIC QUESTION MARK' },
	[0x1368] = { unicodeslot=0x1368, category='po', description='ETHIOPIC PARAGRAPH SEPARATOR' },
	[0x1369] = { unicodeslot=0x1369, category='no', description='ETHIOPIC DIGIT ONE' },
	[0x136A] = { unicodeslot=0x136A, category='no', description='ETHIOPIC DIGIT TWO' },
	[0x136B] = { unicodeslot=0x136B, category='no', description='ETHIOPIC DIGIT THREE' },
	[0x136C] = { unicodeslot=0x136C, category='no', description='ETHIOPIC DIGIT FOUR' },
	[0x136D] = { unicodeslot=0x136D, category='no', description='ETHIOPIC DIGIT FIVE' },
	[0x136E] = { unicodeslot=0x136E, category='no', description='ETHIOPIC DIGIT SIX' },
	[0x136F] = { unicodeslot=0x136F, category='no', description='ETHIOPIC DIGIT SEVEN' },
	[0x1370] = { unicodeslot=0x1370, category='no', description='ETHIOPIC DIGIT EIGHT' },
	[0x1371] = { unicodeslot=0x1371, category='no', description='ETHIOPIC DIGIT NINE' },
	[0x1372] = { unicodeslot=0x1372, category='no', description='ETHIOPIC NUMBER TEN' },
	[0x1373] = { unicodeslot=0x1373, category='no', description='ETHIOPIC NUMBER TWENTY' },
	[0x1374] = { unicodeslot=0x1374, category='no', description='ETHIOPIC NUMBER THIRTY' },
	[0x1375] = { unicodeslot=0x1375, category='no', description='ETHIOPIC NUMBER FORTY' },
	[0x1376] = { unicodeslot=0x1376, category='no', description='ETHIOPIC NUMBER FIFTY' },
	[0x1377] = { unicodeslot=0x1377, category='no', description='ETHIOPIC NUMBER SIXTY' },
	[0x1378] = { unicodeslot=0x1378, category='no', description='ETHIOPIC NUMBER SEVENTY' },
	[0x1379] = { unicodeslot=0x1379, category='no', description='ETHIOPIC NUMBER EIGHTY' },
	[0x137A] = { unicodeslot=0x137A, category='no', description='ETHIOPIC NUMBER NINETY' },
	[0x137B] = { unicodeslot=0x137B, category='no', description='ETHIOPIC NUMBER HUNDRED' },
	[0x137C] = { unicodeslot=0x137C, category='no', description='ETHIOPIC NUMBER TEN THOUSAND' },
	[0x1380] = { unicodeslot=0x1380, category='lo', description='ETHIOPIC SYLLABLE SEBATBEIT MWA' },
	[0x1381] = { unicodeslot=0x1381, category='lo', description='ETHIOPIC SYLLABLE MWI' },
	[0x1382] = { unicodeslot=0x1382, category='lo', description='ETHIOPIC SYLLABLE MWEE' },
	[0x1383] = { unicodeslot=0x1383, category='lo', description='ETHIOPIC SYLLABLE MWE' },
	[0x1384] = { unicodeslot=0x1384, category='lo', description='ETHIOPIC SYLLABLE SEBATBEIT BWA' },
	[0x1385] = { unicodeslot=0x1385, category='lo', description='ETHIOPIC SYLLABLE BWI' },
	[0x1386] = { unicodeslot=0x1386, category='lo', description='ETHIOPIC SYLLABLE BWEE' },
	[0x1387] = { unicodeslot=0x1387, category='lo', description='ETHIOPIC SYLLABLE BWE' },
	[0x1388] = { unicodeslot=0x1388, category='lo', description='ETHIOPIC SYLLABLE SEBATBEIT FWA' },
	[0x1389] = { unicodeslot=0x1389, category='lo', description='ETHIOPIC SYLLABLE FWI' },
	[0x138A] = { unicodeslot=0x138A, category='lo', description='ETHIOPIC SYLLABLE FWEE' },
	[0x138B] = { unicodeslot=0x138B, category='lo', description='ETHIOPIC SYLLABLE FWE' },
	[0x138C] = { unicodeslot=0x138C, category='lo', description='ETHIOPIC SYLLABLE SEBATBEIT PWA' },
	[0x138D] = { unicodeslot=0x138D, category='lo', description='ETHIOPIC SYLLABLE PWI' },
	[0x138E] = { unicodeslot=0x138E, category='lo', description='ETHIOPIC SYLLABLE PWEE' },
	[0x138F] = { unicodeslot=0x138F, category='lo', description='ETHIOPIC SYLLABLE PWE' },
	[0x1390] = { unicodeslot=0x1390, category='so', description='ETHIOPIC TONAL MARK YIZET' },
	[0x1391] = { unicodeslot=0x1391, category='so', description='ETHIOPIC TONAL MARK DERET' },
	[0x1392] = { unicodeslot=0x1392, category='so', description='ETHIOPIC TONAL MARK RIKRIK' },
	[0x1393] = { unicodeslot=0x1393, category='so', description='ETHIOPIC TONAL MARK SHORT RIKRIK' },
	[0x1394] = { unicodeslot=0x1394, category='so', description='ETHIOPIC TONAL MARK DIFAT' },
	[0x1395] = { unicodeslot=0x1395, category='so', description='ETHIOPIC TONAL MARK KENAT' },
	[0x1396] = { unicodeslot=0x1396, category='so', description='ETHIOPIC TONAL MARK CHIRET' },
	[0x1397] = { unicodeslot=0x1397, category='so', description='ETHIOPIC TONAL MARK HIDET' },
	[0x1398] = { unicodeslot=0x1398, category='so', description='ETHIOPIC TONAL MARK DERET-HIDET' },
	[0x1399] = { unicodeslot=0x1399, category='so', description='ETHIOPIC TONAL MARK KURT' },
	[0x13A0] = { unicodeslot=0x13A0, category='lo', description='CHEROKEE LETTER A' },
	[0x13A1] = { unicodeslot=0x13A1, category='lo', description='CHEROKEE LETTER E' },
	[0x13A2] = { unicodeslot=0x13A2, category='lo', description='CHEROKEE LETTER I' },
	[0x13A3] = { unicodeslot=0x13A3, category='lo', description='CHEROKEE LETTER O' },
	[0x13A4] = { unicodeslot=0x13A4, category='lo', description='CHEROKEE LETTER U' },
	[0x13A5] = { unicodeslot=0x13A5, category='lo', description='CHEROKEE LETTER V' },
	[0x13A6] = { unicodeslot=0x13A6, category='lo', description='CHEROKEE LETTER GA' },
	[0x13A7] = { unicodeslot=0x13A7, category='lo', description='CHEROKEE LETTER KA' },
	[0x13A8] = { unicodeslot=0x13A8, category='lo', description='CHEROKEE LETTER GE' },
	[0x13A9] = { unicodeslot=0x13A9, category='lo', description='CHEROKEE LETTER GI' },
	[0x13AA] = { unicodeslot=0x13AA, category='lo', description='CHEROKEE LETTER GO' },
	[0x13AB] = { unicodeslot=0x13AB, category='lo', description='CHEROKEE LETTER GU' },
	[0x13AC] = { unicodeslot=0x13AC, category='lo', description='CHEROKEE LETTER GV' },
	[0x13AD] = { unicodeslot=0x13AD, category='lo', description='CHEROKEE LETTER HA' },
	[0x13AE] = { unicodeslot=0x13AE, category='lo', description='CHEROKEE LETTER HE' },
	[0x13AF] = { unicodeslot=0x13AF, category='lo', description='CHEROKEE LETTER HI' },
	[0x13B0] = { unicodeslot=0x13B0, category='lo', description='CHEROKEE LETTER HO' },
	[0x13B1] = { unicodeslot=0x13B1, category='lo', description='CHEROKEE LETTER HU' },
	[0x13B2] = { unicodeslot=0x13B2, category='lo', description='CHEROKEE LETTER HV' },
	[0x13B3] = { unicodeslot=0x13B3, category='lo', description='CHEROKEE LETTER LA' },
	[0x13B4] = { unicodeslot=0x13B4, category='lo', description='CHEROKEE LETTER LE' },
	[0x13B5] = { unicodeslot=0x13B5, category='lo', description='CHEROKEE LETTER LI' },
	[0x13B6] = { unicodeslot=0x13B6, category='lo', description='CHEROKEE LETTER LO' },
	[0x13B7] = { unicodeslot=0x13B7, category='lo', description='CHEROKEE LETTER LU' },
	[0x13B8] = { unicodeslot=0x13B8, category='lo', description='CHEROKEE LETTER LV' },
	[0x13B9] = { unicodeslot=0x13B9, category='lo', description='CHEROKEE LETTER MA' },
	[0x13BA] = { unicodeslot=0x13BA, category='lo', description='CHEROKEE LETTER ME' },
	[0x13BB] = { unicodeslot=0x13BB, category='lo', description='CHEROKEE LETTER MI' },
	[0x13BC] = { unicodeslot=0x13BC, category='lo', description='CHEROKEE LETTER MO' },
	[0x13BD] = { unicodeslot=0x13BD, category='lo', description='CHEROKEE LETTER MU' },
	[0x13BE] = { unicodeslot=0x13BE, category='lo', description='CHEROKEE LETTER NA' },
	[0x13BF] = { unicodeslot=0x13BF, category='lo', description='CHEROKEE LETTER HNA' },
	[0x13C0] = { unicodeslot=0x13C0, category='lo', description='CHEROKEE LETTER NAH' },
	[0x13C1] = { unicodeslot=0x13C1, category='lo', description='CHEROKEE LETTER NE' },
	[0x13C2] = { unicodeslot=0x13C2, category='lo', description='CHEROKEE LETTER NI' },
	[0x13C3] = { unicodeslot=0x13C3, category='lo', description='CHEROKEE LETTER NO' },
	[0x13C4] = { unicodeslot=0x13C4, category='lo', description='CHEROKEE LETTER NU' },
	[0x13C5] = { unicodeslot=0x13C5, category='lo', description='CHEROKEE LETTER NV' },
	[0x13C6] = { unicodeslot=0x13C6, category='lo', description='CHEROKEE LETTER QUA' },
	[0x13C7] = { unicodeslot=0x13C7, category='lo', description='CHEROKEE LETTER QUE' },
	[0x13C8] = { unicodeslot=0x13C8, category='lo', description='CHEROKEE LETTER QUI' },
	[0x13C9] = { unicodeslot=0x13C9, category='lo', description='CHEROKEE LETTER QUO' },
	[0x13CA] = { unicodeslot=0x13CA, category='lo', description='CHEROKEE LETTER QUU' },
	[0x13CB] = { unicodeslot=0x13CB, category='lo', description='CHEROKEE LETTER QUV' },
	[0x13CC] = { unicodeslot=0x13CC, category='lo', description='CHEROKEE LETTER SA' },
	[0x13CD] = { unicodeslot=0x13CD, category='lo', description='CHEROKEE LETTER S' },
	[0x13CE] = { unicodeslot=0x13CE, category='lo', description='CHEROKEE LETTER SE' },
	[0x13CF] = { unicodeslot=0x13CF, category='lo', description='CHEROKEE LETTER SI' },
	[0x13D0] = { unicodeslot=0x13D0, category='lo', description='CHEROKEE LETTER SO' },
	[0x13D1] = { unicodeslot=0x13D1, category='lo', description='CHEROKEE LETTER SU' },
	[0x13D2] = { unicodeslot=0x13D2, category='lo', description='CHEROKEE LETTER SV' },
	[0x13D3] = { unicodeslot=0x13D3, category='lo', description='CHEROKEE LETTER DA' },
	[0x13D4] = { unicodeslot=0x13D4, category='lo', description='CHEROKEE LETTER TA' },
	[0x13D5] = { unicodeslot=0x13D5, category='lo', description='CHEROKEE LETTER DE' },
	[0x13D6] = { unicodeslot=0x13D6, category='lo', description='CHEROKEE LETTER TE' },
	[0x13D7] = { unicodeslot=0x13D7, category='lo', description='CHEROKEE LETTER DI' },
	[0x13D8] = { unicodeslot=0x13D8, category='lo', description='CHEROKEE LETTER TI' },
	[0x13D9] = { unicodeslot=0x13D9, category='lo', description='CHEROKEE LETTER DO' },
	[0x13DA] = { unicodeslot=0x13DA, category='lo', description='CHEROKEE LETTER DU' },
	[0x13DB] = { unicodeslot=0x13DB, category='lo', description='CHEROKEE LETTER DV' },
	[0x13DC] = { unicodeslot=0x13DC, category='lo', description='CHEROKEE LETTER DLA' },
	[0x13DD] = { unicodeslot=0x13DD, category='lo', description='CHEROKEE LETTER TLA' },
	[0x13DE] = { unicodeslot=0x13DE, category='lo', description='CHEROKEE LETTER TLE' },
	[0x13DF] = { unicodeslot=0x13DF, category='lo', description='CHEROKEE LETTER TLI' },
	[0x13E0] = { unicodeslot=0x13E0, category='lo', description='CHEROKEE LETTER TLO' },
	[0x13E1] = { unicodeslot=0x13E1, category='lo', description='CHEROKEE LETTER TLU' },
	[0x13E2] = { unicodeslot=0x13E2, category='lo', description='CHEROKEE LETTER TLV' },
	[0x13E3] = { unicodeslot=0x13E3, category='lo', description='CHEROKEE LETTER TSA' },
	[0x13E4] = { unicodeslot=0x13E4, category='lo', description='CHEROKEE LETTER TSE' },
	[0x13E5] = { unicodeslot=0x13E5, category='lo', description='CHEROKEE LETTER TSI' },
	[0x13E6] = { unicodeslot=0x13E6, category='lo', description='CHEROKEE LETTER TSO' },
	[0x13E7] = { unicodeslot=0x13E7, category='lo', description='CHEROKEE LETTER TSU' },
	[0x13E8] = { unicodeslot=0x13E8, category='lo', description='CHEROKEE LETTER TSV' },
	[0x13E9] = { unicodeslot=0x13E9, category='lo', description='CHEROKEE LETTER WA' },
	[0x13EA] = { unicodeslot=0x13EA, category='lo', description='CHEROKEE LETTER WE' },
	[0x13EB] = { unicodeslot=0x13EB, category='lo', description='CHEROKEE LETTER WI' },
	[0x13EC] = { unicodeslot=0x13EC, category='lo', description='CHEROKEE LETTER WO' },
	[0x13ED] = { unicodeslot=0x13ED, category='lo', description='CHEROKEE LETTER WU' },
	[0x13EE] = { unicodeslot=0x13EE, category='lo', description='CHEROKEE LETTER WV' },
	[0x13EF] = { unicodeslot=0x13EF, category='lo', description='CHEROKEE LETTER YA' },
	[0x13F0] = { unicodeslot=0x13F0, category='lo', description='CHEROKEE LETTER YE' },
	[0x13F1] = { unicodeslot=0x13F1, category='lo', description='CHEROKEE LETTER YI' },
	[0x13F2] = { unicodeslot=0x13F2, category='lo', description='CHEROKEE LETTER YO' },
	[0x13F3] = { unicodeslot=0x13F3, category='lo', description='CHEROKEE LETTER YU' },
	[0x13F4] = { unicodeslot=0x13F4, category='lo', description='CHEROKEE LETTER YV' },
	[0x1401] = { unicodeslot=0x1401, category='lo', description='CANADIAN SYLLABICS E' },
	[0x1402] = { unicodeslot=0x1402, category='lo', description='CANADIAN SYLLABICS AAI' },
	[0x1403] = { unicodeslot=0x1403, category='lo', description='CANADIAN SYLLABICS I' },
	[0x1404] = { unicodeslot=0x1404, category='lo', description='CANADIAN SYLLABICS II' },
	[0x1405] = { unicodeslot=0x1405, category='lo', description='CANADIAN SYLLABICS O' },
	[0x1406] = { unicodeslot=0x1406, category='lo', description='CANADIAN SYLLABICS OO' },
	[0x1407] = { unicodeslot=0x1407, category='lo', description='CANADIAN SYLLABICS Y-CREE OO' },
	[0x1408] = { unicodeslot=0x1408, category='lo', description='CANADIAN SYLLABICS CARRIER EE' },
	[0x1409] = { unicodeslot=0x1409, category='lo', description='CANADIAN SYLLABICS CARRIER I' },
	[0x140A] = { unicodeslot=0x140A, category='lo', description='CANADIAN SYLLABICS A' },
	[0x140B] = { unicodeslot=0x140B, category='lo', description='CANADIAN SYLLABICS AA' },
	[0x140C] = { unicodeslot=0x140C, category='lo', description='CANADIAN SYLLABICS WE' },
	[0x140D] = { unicodeslot=0x140D, category='lo', description='CANADIAN SYLLABICS WEST-CREE WE' },
	[0x140E] = { unicodeslot=0x140E, category='lo', description='CANADIAN SYLLABICS WI' },
	[0x140F] = { unicodeslot=0x140F, category='lo', description='CANADIAN SYLLABICS WEST-CREE WI' },
	[0x1410] = { unicodeslot=0x1410, category='lo', description='CANADIAN SYLLABICS WII' },
	[0x1411] = { unicodeslot=0x1411, category='lo', description='CANADIAN SYLLABICS WEST-CREE WII' },
	[0x1412] = { unicodeslot=0x1412, category='lo', description='CANADIAN SYLLABICS WO' },
	[0x1413] = { unicodeslot=0x1413, category='lo', description='CANADIAN SYLLABICS WEST-CREE WO' },
	[0x1414] = { unicodeslot=0x1414, category='lo', description='CANADIAN SYLLABICS WOO' },
	[0x1415] = { unicodeslot=0x1415, category='lo', description='CANADIAN SYLLABICS WEST-CREE WOO' },
	[0x1416] = { unicodeslot=0x1416, category='lo', description='CANADIAN SYLLABICS NASKAPI WOO' },
	[0x1417] = { unicodeslot=0x1417, category='lo', description='CANADIAN SYLLABICS WA' },
	[0x1418] = { unicodeslot=0x1418, category='lo', description='CANADIAN SYLLABICS WEST-CREE WA' },
	[0x1419] = { unicodeslot=0x1419, category='lo', description='CANADIAN SYLLABICS WAA' },
	[0x141A] = { unicodeslot=0x141A, category='lo', description='CANADIAN SYLLABICS WEST-CREE WAA' },
	[0x141B] = { unicodeslot=0x141B, category='lo', description='CANADIAN SYLLABICS NASKAPI WAA' },
	[0x141C] = { unicodeslot=0x141C, category='lo', description='CANADIAN SYLLABICS AI' },
	[0x141D] = { unicodeslot=0x141D, category='lo', description='CANADIAN SYLLABICS Y-CREE W' },
	[0x141E] = { unicodeslot=0x141E, category='lo', description='CANADIAN SYLLABICS GLOTTAL STOP' },
	[0x141F] = { unicodeslot=0x141F, category='lo', description='CANADIAN SYLLABICS FINAL ACUTE' },
	[0x1420] = { unicodeslot=0x1420, category='lo', description='CANADIAN SYLLABICS FINAL GRAVE' },
	[0x1421] = { unicodeslot=0x1421, category='lo', description='CANADIAN SYLLABICS FINAL BOTTOM HALF RING' },
	[0x1422] = { unicodeslot=0x1422, category='lo', description='CANADIAN SYLLABICS FINAL TOP HALF RING' },
	[0x1423] = { unicodeslot=0x1423, category='lo', description='CANADIAN SYLLABICS FINAL RIGHT HALF RING' },
	[0x1424] = { unicodeslot=0x1424, category='lo', description='CANADIAN SYLLABICS FINAL RING' },
	[0x1425] = { unicodeslot=0x1425, category='lo', description='CANADIAN SYLLABICS FINAL DOUBLE ACUTE' },
	[0x1426] = { unicodeslot=0x1426, category='lo', description='CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES' },
	[0x1427] = { unicodeslot=0x1427, category='lo', description='CANADIAN SYLLABICS FINAL MIDDLE DOT' },
	[0x1428] = { unicodeslot=0x1428, category='lo', description='CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE' },
	[0x1429] = { unicodeslot=0x1429, category='lo', description='CANADIAN SYLLABICS FINAL PLUS' },
	[0x142A] = { unicodeslot=0x142A, category='lo', description='CANADIAN SYLLABICS FINAL DOWN TACK' },
	[0x142B] = { unicodeslot=0x142B, category='lo', description='CANADIAN SYLLABICS EN' },
	[0x142C] = { unicodeslot=0x142C, category='lo', description='CANADIAN SYLLABICS IN' },
	[0x142D] = { unicodeslot=0x142D, category='lo', description='CANADIAN SYLLABICS ON' },
	[0x142E] = { unicodeslot=0x142E, category='lo', description='CANADIAN SYLLABICS AN' },
	[0x142F] = { unicodeslot=0x142F, category='lo', description='CANADIAN SYLLABICS PE' },
	[0x1430] = { unicodeslot=0x1430, category='lo', description='CANADIAN SYLLABICS PAAI' },
	[0x1431] = { unicodeslot=0x1431, category='lo', description='CANADIAN SYLLABICS PI' },
	[0x1432] = { unicodeslot=0x1432, category='lo', description='CANADIAN SYLLABICS PII' },
	[0x1433] = { unicodeslot=0x1433, category='lo', description='CANADIAN SYLLABICS PO' },
	[0x1434] = { unicodeslot=0x1434, category='lo', description='CANADIAN SYLLABICS POO' },
	[0x1435] = { unicodeslot=0x1435, category='lo', description='CANADIAN SYLLABICS Y-CREE POO' },
	[0x1436] = { unicodeslot=0x1436, category='lo', description='CANADIAN SYLLABICS CARRIER HEE' },
	[0x1437] = { unicodeslot=0x1437, category='lo', description='CANADIAN SYLLABICS CARRIER HI' },
	[0x1438] = { unicodeslot=0x1438, category='lo', description='CANADIAN SYLLABICS PA' },
	[0x1439] = { unicodeslot=0x1439, category='lo', description='CANADIAN SYLLABICS PAA' },
	[0x143A] = { unicodeslot=0x143A, category='lo', description='CANADIAN SYLLABICS PWE' },
	[0x143B] = { unicodeslot=0x143B, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWE' },
	[0x143C] = { unicodeslot=0x143C, category='lo', description='CANADIAN SYLLABICS PWI' },
	[0x143D] = { unicodeslot=0x143D, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWI' },
	[0x143E] = { unicodeslot=0x143E, category='lo', description='CANADIAN SYLLABICS PWII' },
	[0x143F] = { unicodeslot=0x143F, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWII' },
	[0x1440] = { unicodeslot=0x1440, category='lo', description='CANADIAN SYLLABICS PWO' },
	[0x1441] = { unicodeslot=0x1441, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWO' },
	[0x1442] = { unicodeslot=0x1442, category='lo', description='CANADIAN SYLLABICS PWOO' },
	[0x1443] = { unicodeslot=0x1443, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWOO' },
	[0x1444] = { unicodeslot=0x1444, category='lo', description='CANADIAN SYLLABICS PWA' },
	[0x1445] = { unicodeslot=0x1445, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWA' },
	[0x1446] = { unicodeslot=0x1446, category='lo', description='CANADIAN SYLLABICS PWAA' },
	[0x1447] = { unicodeslot=0x1447, category='lo', description='CANADIAN SYLLABICS WEST-CREE PWAA' },
	[0x1448] = { unicodeslot=0x1448, category='lo', description='CANADIAN SYLLABICS Y-CREE PWAA' },
	[0x1449] = { unicodeslot=0x1449, category='lo', description='CANADIAN SYLLABICS P' },
	[0x144A] = { unicodeslot=0x144A, category='lo', description='CANADIAN SYLLABICS WEST-CREE P' },
	[0x144B] = { unicodeslot=0x144B, category='lo', description='CANADIAN SYLLABICS CARRIER H' },
	[0x144C] = { unicodeslot=0x144C, category='lo', description='CANADIAN SYLLABICS TE' },
	[0x144D] = { unicodeslot=0x144D, category='lo', description='CANADIAN SYLLABICS TAAI' },
	[0x144E] = { unicodeslot=0x144E, category='lo', description='CANADIAN SYLLABICS TI' },
	[0x144F] = { unicodeslot=0x144F, category='lo', description='CANADIAN SYLLABICS TII' },
	[0x1450] = { unicodeslot=0x1450, category='lo', description='CANADIAN SYLLABICS TO' },
	[0x1451] = { unicodeslot=0x1451, category='lo', description='CANADIAN SYLLABICS TOO' },
	[0x1452] = { unicodeslot=0x1452, category='lo', description='CANADIAN SYLLABICS Y-CREE TOO' },
	[0x1453] = { unicodeslot=0x1453, category='lo', description='CANADIAN SYLLABICS CARRIER DEE' },
	[0x1454] = { unicodeslot=0x1454, category='lo', description='CANADIAN SYLLABICS CARRIER DI' },
	[0x1455] = { unicodeslot=0x1455, category='lo', description='CANADIAN SYLLABICS TA' },
	[0x1456] = { unicodeslot=0x1456, category='lo', description='CANADIAN SYLLABICS TAA' },
	[0x1457] = { unicodeslot=0x1457, category='lo', description='CANADIAN SYLLABICS TWE' },
	[0x1458] = { unicodeslot=0x1458, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWE' },
	[0x1459] = { unicodeslot=0x1459, category='lo', description='CANADIAN SYLLABICS TWI' },
	[0x145A] = { unicodeslot=0x145A, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWI' },
	[0x145B] = { unicodeslot=0x145B, category='lo', description='CANADIAN SYLLABICS TWII' },
	[0x145C] = { unicodeslot=0x145C, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWII' },
	[0x145D] = { unicodeslot=0x145D, category='lo', description='CANADIAN SYLLABICS TWO' },
	[0x145E] = { unicodeslot=0x145E, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWO' },
	[0x145F] = { unicodeslot=0x145F, category='lo', description='CANADIAN SYLLABICS TWOO' },
	[0x1460] = { unicodeslot=0x1460, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWOO' },
	[0x1461] = { unicodeslot=0x1461, category='lo', description='CANADIAN SYLLABICS TWA' },
	[0x1462] = { unicodeslot=0x1462, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWA' },
	[0x1463] = { unicodeslot=0x1463, category='lo', description='CANADIAN SYLLABICS TWAA' },
	[0x1464] = { unicodeslot=0x1464, category='lo', description='CANADIAN SYLLABICS WEST-CREE TWAA' },
	[0x1465] = { unicodeslot=0x1465, category='lo', description='CANADIAN SYLLABICS NASKAPI TWAA' },
	[0x1466] = { unicodeslot=0x1466, category='lo', description='CANADIAN SYLLABICS T' },
	[0x1467] = { unicodeslot=0x1467, category='lo', description='CANADIAN SYLLABICS TTE' },
	[0x1468] = { unicodeslot=0x1468, category='lo', description='CANADIAN SYLLABICS TTI' },
	[0x1469] = { unicodeslot=0x1469, category='lo', description='CANADIAN SYLLABICS TTO' },
	[0x146A] = { unicodeslot=0x146A, category='lo', description='CANADIAN SYLLABICS TTA' },
	[0x146B] = { unicodeslot=0x146B, category='lo', description='CANADIAN SYLLABICS KE' },
	[0x146C] = { unicodeslot=0x146C, category='lo', description='CANADIAN SYLLABICS KAAI' },
	[0x146D] = { unicodeslot=0x146D, category='lo', description='CANADIAN SYLLABICS KI' },
	[0x146E] = { unicodeslot=0x146E, category='lo', description='CANADIAN SYLLABICS KII' },
	[0x146F] = { unicodeslot=0x146F, category='lo', description='CANADIAN SYLLABICS KO' },
	[0x1470] = { unicodeslot=0x1470, category='lo', description='CANADIAN SYLLABICS KOO' },
	[0x1471] = { unicodeslot=0x1471, category='lo', description='CANADIAN SYLLABICS Y-CREE KOO' },
	[0x1472] = { unicodeslot=0x1472, category='lo', description='CANADIAN SYLLABICS KA' },
	[0x1473] = { unicodeslot=0x1473, category='lo', description='CANADIAN SYLLABICS KAA' },
	[0x1474] = { unicodeslot=0x1474, category='lo', description='CANADIAN SYLLABICS KWE' },
	[0x1475] = { unicodeslot=0x1475, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWE' },
	[0x1476] = { unicodeslot=0x1476, category='lo', description='CANADIAN SYLLABICS KWI' },
	[0x1477] = { unicodeslot=0x1477, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWI' },
	[0x1478] = { unicodeslot=0x1478, category='lo', description='CANADIAN SYLLABICS KWII' },
	[0x1479] = { unicodeslot=0x1479, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWII' },
	[0x147A] = { unicodeslot=0x147A, category='lo', description='CANADIAN SYLLABICS KWO' },
	[0x147B] = { unicodeslot=0x147B, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWO' },
	[0x147C] = { unicodeslot=0x147C, category='lo', description='CANADIAN SYLLABICS KWOO' },
	[0x147D] = { unicodeslot=0x147D, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWOO' },
	[0x147E] = { unicodeslot=0x147E, category='lo', description='CANADIAN SYLLABICS KWA' },
	[0x147F] = { unicodeslot=0x147F, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWA' },
	[0x1480] = { unicodeslot=0x1480, category='lo', description='CANADIAN SYLLABICS KWAA' },
	[0x1481] = { unicodeslot=0x1481, category='lo', description='CANADIAN SYLLABICS WEST-CREE KWAA' },
	[0x1482] = { unicodeslot=0x1482, category='lo', description='CANADIAN SYLLABICS NASKAPI KWAA' },
	[0x1483] = { unicodeslot=0x1483, category='lo', description='CANADIAN SYLLABICS K' },
	[0x1484] = { unicodeslot=0x1484, category='lo', description='CANADIAN SYLLABICS KW' },
	[0x1485] = { unicodeslot=0x1485, category='lo', description='CANADIAN SYLLABICS SOUTH-SLAVEY KEH' },
	[0x1486] = { unicodeslot=0x1486, category='lo', description='CANADIAN SYLLABICS SOUTH-SLAVEY KIH' },
	[0x1487] = { unicodeslot=0x1487, category='lo', description='CANADIAN SYLLABICS SOUTH-SLAVEY KOH' },
	[0x1488] = { unicodeslot=0x1488, category='lo', description='CANADIAN SYLLABICS SOUTH-SLAVEY KAH' },
	[0x1489] = { unicodeslot=0x1489, category='lo', description='CANADIAN SYLLABICS CE' },
	[0x148A] = { unicodeslot=0x148A, category='lo', description='CANADIAN SYLLABICS CAAI' },
	[0x148B] = { unicodeslot=0x148B, category='lo', description='CANADIAN SYLLABICS CI' },
	[0x148C] = { unicodeslot=0x148C, category='lo', description='CANADIAN SYLLABICS CII' },
	[0x148D] = { unicodeslot=0x148D, category='lo', description='CANADIAN SYLLABICS CO' },
	[0x148E] = { unicodeslot=0x148E, category='lo', description='CANADIAN SYLLABICS COO' },
	[0x148F] = { unicodeslot=0x148F, category='lo', description='CANADIAN SYLLABICS Y-CREE COO' },
	[0x1490] = { unicodeslot=0x1490, category='lo', description='CANADIAN SYLLABICS CA' },
	[0x1491] = { unicodeslot=0x1491, category='lo', description='CANADIAN SYLLABICS CAA' },
	[0x1492] = { unicodeslot=0x1492, category='lo', description='CANADIAN SYLLABICS CWE' },
	[0x1493] = { unicodeslot=0x1493, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWE' },
	[0x1494] = { unicodeslot=0x1494, category='lo', description='CANADIAN SYLLABICS CWI' },
	[0x1495] = { unicodeslot=0x1495, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWI' },
	[0x1496] = { unicodeslot=0x1496, category='lo', description='CANADIAN SYLLABICS CWII' },
	[0x1497] = { unicodeslot=0x1497, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWII' },
	[0x1498] = { unicodeslot=0x1498, category='lo', description='CANADIAN SYLLABICS CWO' },
	[0x1499] = { unicodeslot=0x1499, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWO' },
	[0x149A] = { unicodeslot=0x149A, category='lo', description='CANADIAN SYLLABICS CWOO' },
	[0x149B] = { unicodeslot=0x149B, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWOO' },
	[0x149C] = { unicodeslot=0x149C, category='lo', description='CANADIAN SYLLABICS CWA' },
	[0x149D] = { unicodeslot=0x149D, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWA' },
	[0x149E] = { unicodeslot=0x149E, category='lo', description='CANADIAN SYLLABICS CWAA' },
	[0x149F] = { unicodeslot=0x149F, category='lo', description='CANADIAN SYLLABICS WEST-CREE CWAA' },
	[0x14A0] = { unicodeslot=0x14A0, category='lo', description='CANADIAN SYLLABICS NASKAPI CWAA' },
	[0x14A1] = { unicodeslot=0x14A1, category='lo', description='CANADIAN SYLLABICS C' },
	[0x14A2] = { unicodeslot=0x14A2, category='lo', description='CANADIAN SYLLABICS SAYISI TH' },
	[0x14A3] = { unicodeslot=0x14A3, category='lo', description='CANADIAN SYLLABICS ME' },
	[0x14A4] = { unicodeslot=0x14A4, category='lo', description='CANADIAN SYLLABICS MAAI' },
	[0x14A5] = { unicodeslot=0x14A5, category='lo', description='CANADIAN SYLLABICS MI' },
	[0x14A6] = { unicodeslot=0x14A6, category='lo', description='CANADIAN SYLLABICS MII' },
	[0x14A7] = { unicodeslot=0x14A7, category='lo', description='CANADIAN SYLLABICS MO' },
	[0x14A8] = { unicodeslot=0x14A8, category='lo', description='CANADIAN SYLLABICS MOO' },
	[0x14A9] = { unicodeslot=0x14A9, category='lo', description='CANADIAN SYLLABICS Y-CREE MOO' },
	[0x14AA] = { unicodeslot=0x14AA, category='lo', description='CANADIAN SYLLABICS MA' },
	[0x14AB] = { unicodeslot=0x14AB, category='lo', description='CANADIAN SYLLABICS MAA' },
	[0x14AC] = { unicodeslot=0x14AC, category='lo', description='CANADIAN SYLLABICS MWE' },
	[0x14AD] = { unicodeslot=0x14AD, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWE' },
	[0x14AE] = { unicodeslot=0x14AE, category='lo', description='CANADIAN SYLLABICS MWI' },
	[0x14AF] = { unicodeslot=0x14AF, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWI' },
	[0x14B0] = { unicodeslot=0x14B0, category='lo', description='CANADIAN SYLLABICS MWII' },
	[0x14B1] = { unicodeslot=0x14B1, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWII' },
	[0x14B2] = { unicodeslot=0x14B2, category='lo', description='CANADIAN SYLLABICS MWO' },
	[0x14B3] = { unicodeslot=0x14B3, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWO' },
	[0x14B4] = { unicodeslot=0x14B4, category='lo', description='CANADIAN SYLLABICS MWOO' },
	[0x14B5] = { unicodeslot=0x14B5, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWOO' },
	[0x14B6] = { unicodeslot=0x14B6, category='lo', description='CANADIAN SYLLABICS MWA' },
	[0x14B7] = { unicodeslot=0x14B7, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWA' },
	[0x14B8] = { unicodeslot=0x14B8, category='lo', description='CANADIAN SYLLABICS MWAA' },
	[0x14B9] = { unicodeslot=0x14B9, category='lo', description='CANADIAN SYLLABICS WEST-CREE MWAA' },
	[0x14BA] = { unicodeslot=0x14BA, category='lo', description='CANADIAN SYLLABICS NASKAPI MWAA' },
	[0x14BB] = { unicodeslot=0x14BB, category='lo', description='CANADIAN SYLLABICS M' },
	[0x14BC] = { unicodeslot=0x14BC, category='lo', description='CANADIAN SYLLABICS WEST-CREE M' },
	[0x14BD] = { unicodeslot=0x14BD, category='lo', description='CANADIAN SYLLABICS MH' },
	[0x14BE] = { unicodeslot=0x14BE, category='lo', description='CANADIAN SYLLABICS ATHAPASCAN M' },
	[0x14BF] = { unicodeslot=0x14BF, category='lo', description='CANADIAN SYLLABICS SAYISI M' },
	[0x14C0] = { unicodeslot=0x14C0, category='lo', description='CANADIAN SYLLABICS NE' },
	[0x14C1] = { unicodeslot=0x14C1, category='lo', description='CANADIAN SYLLABICS NAAI' },
	[0x14C2] = { unicodeslot=0x14C2, category='lo', description='CANADIAN SYLLABICS NI' },
	[0x14C3] = { unicodeslot=0x14C3, category='lo', description='CANADIAN SYLLABICS NII' },
	[0x14C4] = { unicodeslot=0x14C4, category='lo', description='CANADIAN SYLLABICS NO' },
	[0x14C5] = { unicodeslot=0x14C5, category='lo', description='CANADIAN SYLLABICS NOO' },
	[0x14C6] = { unicodeslot=0x14C6, category='lo', description='CANADIAN SYLLABICS Y-CREE NOO' },
	[0x14C7] = { unicodeslot=0x14C7, category='lo', description='CANADIAN SYLLABICS NA' },
	[0x14C8] = { unicodeslot=0x14C8, category='lo', description='CANADIAN SYLLABICS NAA' },
	[0x14C9] = { unicodeslot=0x14C9, category='lo', description='CANADIAN SYLLABICS NWE' },
	[0x14CA] = { unicodeslot=0x14CA, category='lo', description='CANADIAN SYLLABICS WEST-CREE NWE' },
	[0x14CB] = { unicodeslot=0x14CB, category='lo', description='CANADIAN SYLLABICS NWA' },
	[0x14CC] = { unicodeslot=0x14CC, category='lo', description='CANADIAN SYLLABICS WEST-CREE NWA' },
	[0x14CD] = { unicodeslot=0x14CD, category='lo', description='CANADIAN SYLLABICS NWAA' },
	[0x14CE] = { unicodeslot=0x14CE, category='lo', description='CANADIAN SYLLABICS WEST-CREE NWAA' },
	[0x14CF] = { unicodeslot=0x14CF, category='lo', description='CANADIAN SYLLABICS NASKAPI NWAA' },
	[0x14D0] = { unicodeslot=0x14D0, category='lo', description='CANADIAN SYLLABICS N' },
	[0x14D1] = { unicodeslot=0x14D1, category='lo', description='CANADIAN SYLLABICS CARRIER NG' },
	[0x14D2] = { unicodeslot=0x14D2, category='lo', description='CANADIAN SYLLABICS NH' },
	[0x14D3] = { unicodeslot=0x14D3, category='lo', description='CANADIAN SYLLABICS LE' },
	[0x14D4] = { unicodeslot=0x14D4, category='lo', description='CANADIAN SYLLABICS LAAI' },
	[0x14D5] = { unicodeslot=0x14D5, category='lo', description='CANADIAN SYLLABICS LI' },
	[0x14D6] = { unicodeslot=0x14D6, category='lo', description='CANADIAN SYLLABICS LII' },
	[0x14D7] = { unicodeslot=0x14D7, category='lo', description='CANADIAN SYLLABICS LO' },
	[0x14D8] = { unicodeslot=0x14D8, category='lo', description='CANADIAN SYLLABICS LOO' },
	[0x14D9] = { unicodeslot=0x14D9, category='lo', description='CANADIAN SYLLABICS Y-CREE LOO' },
	[0x14DA] = { unicodeslot=0x14DA, category='lo', description='CANADIAN SYLLABICS LA' },
	[0x14DB] = { unicodeslot=0x14DB, category='lo', description='CANADIAN SYLLABICS LAA' },
	[0x14DC] = { unicodeslot=0x14DC, category='lo', description='CANADIAN SYLLABICS LWE' },
	[0x14DD] = { unicodeslot=0x14DD, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWE' },
	[0x14DE] = { unicodeslot=0x14DE, category='lo', description='CANADIAN SYLLABICS LWI' },
	[0x14DF] = { unicodeslot=0x14DF, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWI' },
	[0x14E0] = { unicodeslot=0x14E0, category='lo', description='CANADIAN SYLLABICS LWII' },
	[0x14E1] = { unicodeslot=0x14E1, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWII' },
	[0x14E2] = { unicodeslot=0x14E2, category='lo', description='CANADIAN SYLLABICS LWO' },
	[0x14E3] = { unicodeslot=0x14E3, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWO' },
	[0x14E4] = { unicodeslot=0x14E4, category='lo', description='CANADIAN SYLLABICS LWOO' },
	[0x14E5] = { unicodeslot=0x14E5, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWOO' },
	[0x14E6] = { unicodeslot=0x14E6, category='lo', description='CANADIAN SYLLABICS LWA' },
	[0x14E7] = { unicodeslot=0x14E7, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWA' },
	[0x14E8] = { unicodeslot=0x14E8, category='lo', description='CANADIAN SYLLABICS LWAA' },
	[0x14E9] = { unicodeslot=0x14E9, category='lo', description='CANADIAN SYLLABICS WEST-CREE LWAA' },
	[0x14EA] = { unicodeslot=0x14EA, category='lo', description='CANADIAN SYLLABICS L' },
	[0x14EB] = { unicodeslot=0x14EB, category='lo', description='CANADIAN SYLLABICS WEST-CREE L' },
	[0x14EC] = { unicodeslot=0x14EC, category='lo', description='CANADIAN SYLLABICS MEDIAL L' },
	[0x14ED] = { unicodeslot=0x14ED, category='lo', description='CANADIAN SYLLABICS SE' },
	[0x14EE] = { unicodeslot=0x14EE, category='lo', description='CANADIAN SYLLABICS SAAI' },
	[0x14EF] = { unicodeslot=0x14EF, category='lo', description='CANADIAN SYLLABICS SI' },
	[0x14F0] = { unicodeslot=0x14F0, category='lo', description='CANADIAN SYLLABICS SII' },
	[0x14F1] = { unicodeslot=0x14F1, category='lo', description='CANADIAN SYLLABICS SO' },
	[0x14F2] = { unicodeslot=0x14F2, category='lo', description='CANADIAN SYLLABICS SOO' },
	[0x14F3] = { unicodeslot=0x14F3, category='lo', description='CANADIAN SYLLABICS Y-CREE SOO' },
	[0x14F4] = { unicodeslot=0x14F4, category='lo', description='CANADIAN SYLLABICS SA' },
	[0x14F5] = { unicodeslot=0x14F5, category='lo', description='CANADIAN SYLLABICS SAA' },
	[0x14F6] = { unicodeslot=0x14F6, category='lo', description='CANADIAN SYLLABICS SWE' },
	[0x14F7] = { unicodeslot=0x14F7, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWE' },
	[0x14F8] = { unicodeslot=0x14F8, category='lo', description='CANADIAN SYLLABICS SWI' },
	[0x14F9] = { unicodeslot=0x14F9, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWI' },
	[0x14FA] = { unicodeslot=0x14FA, category='lo', description='CANADIAN SYLLABICS SWII' },
	[0x14FB] = { unicodeslot=0x14FB, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWII' },
	[0x14FC] = { unicodeslot=0x14FC, category='lo', description='CANADIAN SYLLABICS SWO' },
	[0x14FD] = { unicodeslot=0x14FD, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWO' },
	[0x14FE] = { unicodeslot=0x14FE, category='lo', description='CANADIAN SYLLABICS SWOO' },
	[0x14FF] = { unicodeslot=0x14FF, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWOO' },
	[0x1500] = { unicodeslot=0x1500, category='lo', description='CANADIAN SYLLABICS SWA' },
	[0x1501] = { unicodeslot=0x1501, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWA' },
	[0x1502] = { unicodeslot=0x1502, category='lo', description='CANADIAN SYLLABICS SWAA' },
	[0x1503] = { unicodeslot=0x1503, category='lo', description='CANADIAN SYLLABICS WEST-CREE SWAA' },
	[0x1504] = { unicodeslot=0x1504, category='lo', description='CANADIAN SYLLABICS NASKAPI SWAA' },
	[0x1505] = { unicodeslot=0x1505, category='lo', description='CANADIAN SYLLABICS S' },
	[0x1506] = { unicodeslot=0x1506, category='lo', description='CANADIAN SYLLABICS ATHAPASCAN S' },
	[0x1507] = { unicodeslot=0x1507, category='lo', description='CANADIAN SYLLABICS SW' },
	[0x1508] = { unicodeslot=0x1508, category='lo', description='CANADIAN SYLLABICS BLACKFOOT S' },
	[0x1509] = { unicodeslot=0x1509, category='lo', description='CANADIAN SYLLABICS MOOSE-CREE SK' },
	[0x150A] = { unicodeslot=0x150A, category='lo', description='CANADIAN SYLLABICS NASKAPI SKW' },
	[0x150B] = { unicodeslot=0x150B, category='lo', description='CANADIAN SYLLABICS NASKAPI S-W' },
	[0x150C] = { unicodeslot=0x150C, category='lo', description='CANADIAN SYLLABICS NASKAPI SPWA' },
	[0x150D] = { unicodeslot=0x150D, category='lo', description='CANADIAN SYLLABICS NASKAPI STWA' },
	[0x150E] = { unicodeslot=0x150E, category='lo', description='CANADIAN SYLLABICS NASKAPI SKWA' },
	[0x150F] = { unicodeslot=0x150F, category='lo', description='CANADIAN SYLLABICS NASKAPI SCWA' },
	[0x1510] = { unicodeslot=0x1510, category='lo', description='CANADIAN SYLLABICS SHE' },
	[0x1511] = { unicodeslot=0x1511, category='lo', description='CANADIAN SYLLABICS SHI' },
	[0x1512] = { unicodeslot=0x1512, category='lo', description='CANADIAN SYLLABICS SHII' },
	[0x1513] = { unicodeslot=0x1513, category='lo', description='CANADIAN SYLLABICS SHO' },
	[0x1514] = { unicodeslot=0x1514, category='lo', description='CANADIAN SYLLABICS SHOO' },
	[0x1515] = { unicodeslot=0x1515, category='lo', description='CANADIAN SYLLABICS SHA' },
	[0x1516] = { unicodeslot=0x1516, category='lo', description='CANADIAN SYLLABICS SHAA' },
	[0x1517] = { unicodeslot=0x1517, category='lo', description='CANADIAN SYLLABICS SHWE' },
	[0x1518] = { unicodeslot=0x1518, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWE' },
	[0x1519] = { unicodeslot=0x1519, category='lo', description='CANADIAN SYLLABICS SHWI' },
	[0x151A] = { unicodeslot=0x151A, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWI' },
	[0x151B] = { unicodeslot=0x151B, category='lo', description='CANADIAN SYLLABICS SHWII' },
	[0x151C] = { unicodeslot=0x151C, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWII' },
	[0x151D] = { unicodeslot=0x151D, category='lo', description='CANADIAN SYLLABICS SHWO' },
	[0x151E] = { unicodeslot=0x151E, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWO' },
	[0x151F] = { unicodeslot=0x151F, category='lo', description='CANADIAN SYLLABICS SHWOO' },
	[0x1520] = { unicodeslot=0x1520, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWOO' },
	[0x1521] = { unicodeslot=0x1521, category='lo', description='CANADIAN SYLLABICS SHWA' },
	[0x1522] = { unicodeslot=0x1522, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWA' },
	[0x1523] = { unicodeslot=0x1523, category='lo', description='CANADIAN SYLLABICS SHWAA' },
	[0x1524] = { unicodeslot=0x1524, category='lo', description='CANADIAN SYLLABICS WEST-CREE SHWAA' },
	[0x1525] = { unicodeslot=0x1525, category='lo', description='CANADIAN SYLLABICS SH' },
	[0x1526] = { unicodeslot=0x1526, category='lo', description='CANADIAN SYLLABICS YE' },
	[0x1527] = { unicodeslot=0x1527, category='lo', description='CANADIAN SYLLABICS YAAI' },
	[0x1528] = { unicodeslot=0x1528, category='lo', description='CANADIAN SYLLABICS YI' },
	[0x1529] = { unicodeslot=0x1529, category='lo', description='CANADIAN SYLLABICS YII' },
	[0x152A] = { unicodeslot=0x152A, category='lo', description='CANADIAN SYLLABICS YO' },
	[0x152B] = { unicodeslot=0x152B, category='lo', description='CANADIAN SYLLABICS YOO' },
	[0x152C] = { unicodeslot=0x152C, category='lo', description='CANADIAN SYLLABICS Y-CREE YOO' },
	[0x152D] = { unicodeslot=0x152D, category='lo', description='CANADIAN SYLLABICS YA' },
	[0x152E] = { unicodeslot=0x152E, category='lo', description='CANADIAN SYLLABICS YAA' },
	[0x152F] = { unicodeslot=0x152F, category='lo', description='CANADIAN SYLLABICS YWE' },
	[0x1530] = { unicodeslot=0x1530, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWE' },
	[0x1531] = { unicodeslot=0x1531, category='lo', description='CANADIAN SYLLABICS YWI' },
	[0x1532] = { unicodeslot=0x1532, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWI' },
	[0x1533] = { unicodeslot=0x1533, category='lo', description='CANADIAN SYLLABICS YWII' },
	[0x1534] = { unicodeslot=0x1534, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWII' },
	[0x1535] = { unicodeslot=0x1535, category='lo', description='CANADIAN SYLLABICS YWO' },
	[0x1536] = { unicodeslot=0x1536, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWO' },
	[0x1537] = { unicodeslot=0x1537, category='lo', description='CANADIAN SYLLABICS YWOO' },
	[0x1538] = { unicodeslot=0x1538, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWOO' },
	[0x1539] = { unicodeslot=0x1539, category='lo', description='CANADIAN SYLLABICS YWA' },
	[0x153A] = { unicodeslot=0x153A, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWA' },
	[0x153B] = { unicodeslot=0x153B, category='lo', description='CANADIAN SYLLABICS YWAA' },
	[0x153C] = { unicodeslot=0x153C, category='lo', description='CANADIAN SYLLABICS WEST-CREE YWAA' },
	[0x153D] = { unicodeslot=0x153D, category='lo', description='CANADIAN SYLLABICS NASKAPI YWAA' },
	[0x153E] = { unicodeslot=0x153E, category='lo', description='CANADIAN SYLLABICS Y' },
	[0x153F] = { unicodeslot=0x153F, category='lo', description='CANADIAN SYLLABICS BIBLE-CREE Y' },
	[0x1540] = { unicodeslot=0x1540, category='lo', description='CANADIAN SYLLABICS WEST-CREE Y' },
	[0x1541] = { unicodeslot=0x1541, category='lo', description='CANADIAN SYLLABICS SAYISI YI' },
	[0x1542] = { unicodeslot=0x1542, category='lo', description='CANADIAN SYLLABICS RE' },
	[0x1543] = { unicodeslot=0x1543, category='lo', description='CANADIAN SYLLABICS R-CREE RE' },
	[0x1544] = { unicodeslot=0x1544, category='lo', description='CANADIAN SYLLABICS WEST-CREE LE' },
	[0x1545] = { unicodeslot=0x1545, category='lo', description='CANADIAN SYLLABICS RAAI' },
	[0x1546] = { unicodeslot=0x1546, category='lo', description='CANADIAN SYLLABICS RI' },
	[0x1547] = { unicodeslot=0x1547, category='lo', description='CANADIAN SYLLABICS RII' },
	[0x1548] = { unicodeslot=0x1548, category='lo', description='CANADIAN SYLLABICS RO' },
	[0x1549] = { unicodeslot=0x1549, category='lo', description='CANADIAN SYLLABICS ROO' },
	[0x154A] = { unicodeslot=0x154A, category='lo', description='CANADIAN SYLLABICS WEST-CREE LO' },
	[0x154B] = { unicodeslot=0x154B, category='lo', description='CANADIAN SYLLABICS RA' },
	[0x154C] = { unicodeslot=0x154C, category='lo', description='CANADIAN SYLLABICS RAA' },
	[0x154D] = { unicodeslot=0x154D, category='lo', description='CANADIAN SYLLABICS WEST-CREE LA' },
	[0x154E] = { unicodeslot=0x154E, category='lo', description='CANADIAN SYLLABICS RWAA' },
	[0x154F] = { unicodeslot=0x154F, category='lo', description='CANADIAN SYLLABICS WEST-CREE RWAA' },
	[0x1550] = { unicodeslot=0x1550, category='lo', description='CANADIAN SYLLABICS R' },
	[0x1551] = { unicodeslot=0x1551, category='lo', description='CANADIAN SYLLABICS WEST-CREE R' },
	[0x1552] = { unicodeslot=0x1552, category='lo', description='CANADIAN SYLLABICS MEDIAL R' },
	[0x1553] = { unicodeslot=0x1553, category='lo', description='CANADIAN SYLLABICS FE' },
	[0x1554] = { unicodeslot=0x1554, category='lo', description='CANADIAN SYLLABICS FAAI' },
	[0x1555] = { unicodeslot=0x1555, category='lo', description='CANADIAN SYLLABICS FI' },
	[0x1556] = { unicodeslot=0x1556, category='lo', description='CANADIAN SYLLABICS FII' },
	[0x1557] = { unicodeslot=0x1557, category='lo', description='CANADIAN SYLLABICS FO' },
	[0x1558] = { unicodeslot=0x1558, category='lo', description='CANADIAN SYLLABICS FOO' },
	[0x1559] = { unicodeslot=0x1559, category='lo', description='CANADIAN SYLLABICS FA' },
	[0x155A] = { unicodeslot=0x155A, category='lo', description='CANADIAN SYLLABICS FAA' },
	[0x155B] = { unicodeslot=0x155B, category='lo', description='CANADIAN SYLLABICS FWAA' },
	[0x155C] = { unicodeslot=0x155C, category='lo', description='CANADIAN SYLLABICS WEST-CREE FWAA' },
	[0x155D] = { unicodeslot=0x155D, category='lo', description='CANADIAN SYLLABICS F' },
	[0x155E] = { unicodeslot=0x155E, category='lo', description='CANADIAN SYLLABICS THE' },
	[0x155F] = { unicodeslot=0x155F, category='lo', description='CANADIAN SYLLABICS N-CREE THE' },
	[0x1560] = { unicodeslot=0x1560, category='lo', description='CANADIAN SYLLABICS THI' },
	[0x1561] = { unicodeslot=0x1561, category='lo', description='CANADIAN SYLLABICS N-CREE THI' },
	[0x1562] = { unicodeslot=0x1562, category='lo', description='CANADIAN SYLLABICS THII' },
	[0x1563] = { unicodeslot=0x1563, category='lo', description='CANADIAN SYLLABICS N-CREE THII' },
	[0x1564] = { unicodeslot=0x1564, category='lo', description='CANADIAN SYLLABICS THO' },
	[0x1565] = { unicodeslot=0x1565, category='lo', description='CANADIAN SYLLABICS THOO' },
	[0x1566] = { unicodeslot=0x1566, category='lo', description='CANADIAN SYLLABICS THA' },
	[0x1567] = { unicodeslot=0x1567, category='lo', description='CANADIAN SYLLABICS THAA' },
	[0x1568] = { unicodeslot=0x1568, category='lo', description='CANADIAN SYLLABICS THWAA' },
	[0x1569] = { unicodeslot=0x1569, category='lo', description='CANADIAN SYLLABICS WEST-CREE THWAA' },
	[0x156A] = { unicodeslot=0x156A, category='lo', description='CANADIAN SYLLABICS TH' },
	[0x156B] = { unicodeslot=0x156B, category='lo', description='CANADIAN SYLLABICS TTHE' },
	[0x156C] = { unicodeslot=0x156C, category='lo', description='CANADIAN SYLLABICS TTHI' },
	[0x156D] = { unicodeslot=0x156D, category='lo', description='CANADIAN SYLLABICS TTHO' },
	[0x156E] = { unicodeslot=0x156E, category='lo', description='CANADIAN SYLLABICS TTHA' },
	[0x156F] = { unicodeslot=0x156F, category='lo', description='CANADIAN SYLLABICS TTH' },
	[0x1570] = { unicodeslot=0x1570, category='lo', description='CANADIAN SYLLABICS TYE' },
	[0x1571] = { unicodeslot=0x1571, category='lo', description='CANADIAN SYLLABICS TYI' },
	[0x1572] = { unicodeslot=0x1572, category='lo', description='CANADIAN SYLLABICS TYO' },
	[0x1573] = { unicodeslot=0x1573, category='lo', description='CANADIAN SYLLABICS TYA' },
	[0x1574] = { unicodeslot=0x1574, category='lo', description='CANADIAN SYLLABICS NUNAVIK HE' },
	[0x1575] = { unicodeslot=0x1575, category='lo', description='CANADIAN SYLLABICS NUNAVIK HI' },
	[0x1576] = { unicodeslot=0x1576, category='lo', description='CANADIAN SYLLABICS NUNAVIK HII' },
	[0x1577] = { unicodeslot=0x1577, category='lo', description='CANADIAN SYLLABICS NUNAVIK HO' },
	[0x1578] = { unicodeslot=0x1578, category='lo', description='CANADIAN SYLLABICS NUNAVIK HOO' },
	[0x1579] = { unicodeslot=0x1579, category='lo', description='CANADIAN SYLLABICS NUNAVIK HA' },
	[0x157A] = { unicodeslot=0x157A, category='lo', description='CANADIAN SYLLABICS NUNAVIK HAA' },
	[0x157B] = { unicodeslot=0x157B, category='lo', description='CANADIAN SYLLABICS NUNAVIK H' },
	[0x157C] = { unicodeslot=0x157C, category='lo', description='CANADIAN SYLLABICS NUNAVUT H' },
	[0x157D] = { unicodeslot=0x157D, category='lo', description='CANADIAN SYLLABICS HK' },
	[0x157E] = { unicodeslot=0x157E, category='lo', description='CANADIAN SYLLABICS QAAI' },
	[0x157F] = { unicodeslot=0x157F, category='lo', description='CANADIAN SYLLABICS QI' },
	[0x1580] = { unicodeslot=0x1580, category='lo', description='CANADIAN SYLLABICS QII' },
	[0x1581] = { unicodeslot=0x1581, category='lo', description='CANADIAN SYLLABICS QO' },
	[0x1582] = { unicodeslot=0x1582, category='lo', description='CANADIAN SYLLABICS QOO' },
	[0x1583] = { unicodeslot=0x1583, category='lo', description='CANADIAN SYLLABICS QA' },
	[0x1584] = { unicodeslot=0x1584, category='lo', description='CANADIAN SYLLABICS QAA' },
	[0x1585] = { unicodeslot=0x1585, category='lo', description='CANADIAN SYLLABICS Q' },
	[0x1586] = { unicodeslot=0x1586, category='lo', description='CANADIAN SYLLABICS TLHE' },
	[0x1587] = { unicodeslot=0x1587, category='lo', description='CANADIAN SYLLABICS TLHI' },
	[0x1588] = { unicodeslot=0x1588, category='lo', description='CANADIAN SYLLABICS TLHO' },
	[0x1589] = { unicodeslot=0x1589, category='lo', description='CANADIAN SYLLABICS TLHA' },
	[0x158A] = { unicodeslot=0x158A, category='lo', description='CANADIAN SYLLABICS WEST-CREE RE' },
	[0x158B] = { unicodeslot=0x158B, category='lo', description='CANADIAN SYLLABICS WEST-CREE RI' },
	[0x158C] = { unicodeslot=0x158C, category='lo', description='CANADIAN SYLLABICS WEST-CREE RO' },
	[0x158D] = { unicodeslot=0x158D, category='lo', description='CANADIAN SYLLABICS WEST-CREE RA' },
	[0x158E] = { unicodeslot=0x158E, category='lo', description='CANADIAN SYLLABICS NGAAI' },
	[0x158F] = { unicodeslot=0x158F, category='lo', description='CANADIAN SYLLABICS NGI' },
	[0x1590] = { unicodeslot=0x1590, category='lo', description='CANADIAN SYLLABICS NGII' },
	[0x1591] = { unicodeslot=0x1591, category='lo', description='CANADIAN SYLLABICS NGO' },
	[0x1592] = { unicodeslot=0x1592, category='lo', description='CANADIAN SYLLABICS NGOO' },
	[0x1593] = { unicodeslot=0x1593, category='lo', description='CANADIAN SYLLABICS NGA' },
	[0x1594] = { unicodeslot=0x1594, category='lo', description='CANADIAN SYLLABICS NGAA' },
	[0x1595] = { unicodeslot=0x1595, category='lo', description='CANADIAN SYLLABICS NG' },
	[0x1596] = { unicodeslot=0x1596, category='lo', description='CANADIAN SYLLABICS NNG' },
	[0x1597] = { unicodeslot=0x1597, category='lo', description='CANADIAN SYLLABICS SAYISI SHE' },
	[0x1598] = { unicodeslot=0x1598, category='lo', description='CANADIAN SYLLABICS SAYISI SHI' },
	[0x1599] = { unicodeslot=0x1599, category='lo', description='CANADIAN SYLLABICS SAYISI SHO' },
	[0x159A] = { unicodeslot=0x159A, category='lo', description='CANADIAN SYLLABICS SAYISI SHA' },
	[0x159B] = { unicodeslot=0x159B, category='lo', description='CANADIAN SYLLABICS WOODS-CREE THE' },
	[0x159C] = { unicodeslot=0x159C, category='lo', description='CANADIAN SYLLABICS WOODS-CREE THI' },
	[0x159D] = { unicodeslot=0x159D, category='lo', description='CANADIAN SYLLABICS WOODS-CREE THO' },
	[0x159E] = { unicodeslot=0x159E, category='lo', description='CANADIAN SYLLABICS WOODS-CREE THA' },
	[0x159F] = { unicodeslot=0x159F, category='lo', description='CANADIAN SYLLABICS WOODS-CREE TH' },
	[0x15A0] = { unicodeslot=0x15A0, category='lo', description='CANADIAN SYLLABICS LHI' },
	[0x15A1] = { unicodeslot=0x15A1, category='lo', description='CANADIAN SYLLABICS LHII' },
	[0x15A2] = { unicodeslot=0x15A2, category='lo', description='CANADIAN SYLLABICS LHO' },
	[0x15A3] = { unicodeslot=0x15A3, category='lo', description='CANADIAN SYLLABICS LHOO' },
	[0x15A4] = { unicodeslot=0x15A4, category='lo', description='CANADIAN SYLLABICS LHA' },
	[0x15A5] = { unicodeslot=0x15A5, category='lo', description='CANADIAN SYLLABICS LHAA' },
	[0x15A6] = { unicodeslot=0x15A6, category='lo', description='CANADIAN SYLLABICS LH' },
	[0x15A7] = { unicodeslot=0x15A7, category='lo', description='CANADIAN SYLLABICS TH-CREE THE' },
	[0x15A8] = { unicodeslot=0x15A8, category='lo', description='CANADIAN SYLLABICS TH-CREE THI' },
	[0x15A9] = { unicodeslot=0x15A9, category='lo', description='CANADIAN SYLLABICS TH-CREE THII' },
	[0x15AA] = { unicodeslot=0x15AA, category='lo', description='CANADIAN SYLLABICS TH-CREE THO' },
	[0x15AB] = { unicodeslot=0x15AB, category='lo', description='CANADIAN SYLLABICS TH-CREE THOO' },
	[0x15AC] = { unicodeslot=0x15AC, category='lo', description='CANADIAN SYLLABICS TH-CREE THA' },
	[0x15AD] = { unicodeslot=0x15AD, category='lo', description='CANADIAN SYLLABICS TH-CREE THAA' },
	[0x15AE] = { unicodeslot=0x15AE, category='lo', description='CANADIAN SYLLABICS TH-CREE TH' },
	[0x15AF] = { unicodeslot=0x15AF, category='lo', description='CANADIAN SYLLABICS AIVILIK B' },
	[0x15B0] = { unicodeslot=0x15B0, category='lo', description='CANADIAN SYLLABICS BLACKFOOT E' },
	[0x15B1] = { unicodeslot=0x15B1, category='lo', description='CANADIAN SYLLABICS BLACKFOOT I' },
	[0x15B2] = { unicodeslot=0x15B2, category='lo', description='CANADIAN SYLLABICS BLACKFOOT O' },
	[0x15B3] = { unicodeslot=0x15B3, category='lo', description='CANADIAN SYLLABICS BLACKFOOT A' },
	[0x15B4] = { unicodeslot=0x15B4, category='lo', description='CANADIAN SYLLABICS BLACKFOOT WE' },
	[0x15B5] = { unicodeslot=0x15B5, category='lo', description='CANADIAN SYLLABICS BLACKFOOT WI' },
	[0x15B6] = { unicodeslot=0x15B6, category='lo', description='CANADIAN SYLLABICS BLACKFOOT WO' },
	[0x15B7] = { unicodeslot=0x15B7, category='lo', description='CANADIAN SYLLABICS BLACKFOOT WA' },
	[0x15B8] = { unicodeslot=0x15B8, category='lo', description='CANADIAN SYLLABICS BLACKFOOT NE' },
	[0x15B9] = { unicodeslot=0x15B9, category='lo', description='CANADIAN SYLLABICS BLACKFOOT NI' },
	[0x15BA] = { unicodeslot=0x15BA, category='lo', description='CANADIAN SYLLABICS BLACKFOOT NO' },
	[0x15BB] = { unicodeslot=0x15BB, category='lo', description='CANADIAN SYLLABICS BLACKFOOT NA' },
	[0x15BC] = { unicodeslot=0x15BC, category='lo', description='CANADIAN SYLLABICS BLACKFOOT KE' },
	[0x15BD] = { unicodeslot=0x15BD, category='lo', description='CANADIAN SYLLABICS BLACKFOOT KI' },
	[0x15BE] = { unicodeslot=0x15BE, category='lo', description='CANADIAN SYLLABICS BLACKFOOT KO' },
	[0x15BF] = { unicodeslot=0x15BF, category='lo', description='CANADIAN SYLLABICS BLACKFOOT KA' },
	[0x15C0] = { unicodeslot=0x15C0, category='lo', description='CANADIAN SYLLABICS SAYISI HE' },
	[0x15C1] = { unicodeslot=0x15C1, category='lo', description='CANADIAN SYLLABICS SAYISI HI' },
	[0x15C2] = { unicodeslot=0x15C2, category='lo', description='CANADIAN SYLLABICS SAYISI HO' },
	[0x15C3] = { unicodeslot=0x15C3, category='lo', description='CANADIAN SYLLABICS SAYISI HA' },
	[0x15C4] = { unicodeslot=0x15C4, category='lo', description='CANADIAN SYLLABICS CARRIER GHU' },
	[0x15C5] = { unicodeslot=0x15C5, category='lo', description='CANADIAN SYLLABICS CARRIER GHO' },
	[0x15C6] = { unicodeslot=0x15C6, category='lo', description='CANADIAN SYLLABICS CARRIER GHE' },
	[0x15C7] = { unicodeslot=0x15C7, category='lo', description='CANADIAN SYLLABICS CARRIER GHEE' },
	[0x15C8] = { unicodeslot=0x15C8, category='lo', description='CANADIAN SYLLABICS CARRIER GHI' },
	[0x15C9] = { unicodeslot=0x15C9, category='lo', description='CANADIAN SYLLABICS CARRIER GHA' },
	[0x15CA] = { unicodeslot=0x15CA, category='lo', description='CANADIAN SYLLABICS CARRIER RU' },
	[0x15CB] = { unicodeslot=0x15CB, category='lo', description='CANADIAN SYLLABICS CARRIER RO' },
	[0x15CC] = { unicodeslot=0x15CC, category='lo', description='CANADIAN SYLLABICS CARRIER RE' },
	[0x15CD] = { unicodeslot=0x15CD, category='lo', description='CANADIAN SYLLABICS CARRIER REE' },
	[0x15CE] = { unicodeslot=0x15CE, category='lo', description='CANADIAN SYLLABICS CARRIER RI' },
	[0x15CF] = { unicodeslot=0x15CF, category='lo', description='CANADIAN SYLLABICS CARRIER RA' },
	[0x15D0] = { unicodeslot=0x15D0, category='lo', description='CANADIAN SYLLABICS CARRIER WU' },
	[0x15D1] = { unicodeslot=0x15D1, category='lo', description='CANADIAN SYLLABICS CARRIER WO' },
	[0x15D2] = { unicodeslot=0x15D2, category='lo', description='CANADIAN SYLLABICS CARRIER WE' },
	[0x15D3] = { unicodeslot=0x15D3, category='lo', description='CANADIAN SYLLABICS CARRIER WEE' },
	[0x15D4] = { unicodeslot=0x15D4, category='lo', description='CANADIAN SYLLABICS CARRIER WI' },
	[0x15D5] = { unicodeslot=0x15D5, category='lo', description='CANADIAN SYLLABICS CARRIER WA' },
	[0x15D6] = { unicodeslot=0x15D6, category='lo', description='CANADIAN SYLLABICS CARRIER HWU' },
	[0x15D7] = { unicodeslot=0x15D7, category='lo', description='CANADIAN SYLLABICS CARRIER HWO' },
	[0x15D8] = { unicodeslot=0x15D8, category='lo', description='CANADIAN SYLLABICS CARRIER HWE' },
	[0x15D9] = { unicodeslot=0x15D9, category='lo', description='CANADIAN SYLLABICS CARRIER HWEE' },
	[0x15DA] = { unicodeslot=0x15DA, category='lo', description='CANADIAN SYLLABICS CARRIER HWI' },
	[0x15DB] = { unicodeslot=0x15DB, category='lo', description='CANADIAN SYLLABICS CARRIER HWA' },
	[0x15DC] = { unicodeslot=0x15DC, category='lo', description='CANADIAN SYLLABICS CARRIER THU' },
	[0x15DD] = { unicodeslot=0x15DD, category='lo', description='CANADIAN SYLLABICS CARRIER THO' },
	[0x15DE] = { unicodeslot=0x15DE, category='lo', description='CANADIAN SYLLABICS CARRIER THE' },
	[0x15DF] = { unicodeslot=0x15DF, category='lo', description='CANADIAN SYLLABICS CARRIER THEE' },
	[0x15E0] = { unicodeslot=0x15E0, category='lo', description='CANADIAN SYLLABICS CARRIER THI' },
	[0x15E1] = { unicodeslot=0x15E1, category='lo', description='CANADIAN SYLLABICS CARRIER THA' },
	[0x15E2] = { unicodeslot=0x15E2, category='lo', description='CANADIAN SYLLABICS CARRIER TTU' },
	[0x15E3] = { unicodeslot=0x15E3, category='lo', description='CANADIAN SYLLABICS CARRIER TTO' },
	[0x15E4] = { unicodeslot=0x15E4, category='lo', description='CANADIAN SYLLABICS CARRIER TTE' },
	[0x15E5] = { unicodeslot=0x15E5, category='lo', description='CANADIAN SYLLABICS CARRIER TTEE' },
	[0x15E6] = { unicodeslot=0x15E6, category='lo', description='CANADIAN SYLLABICS CARRIER TTI' },
	[0x15E7] = { unicodeslot=0x15E7, category='lo', description='CANADIAN SYLLABICS CARRIER TTA' },
	[0x15E8] = { unicodeslot=0x15E8, category='lo', description='CANADIAN SYLLABICS CARRIER PU' },
	[0x15E9] = { unicodeslot=0x15E9, category='lo', description='CANADIAN SYLLABICS CARRIER PO' },
	[0x15EA] = { unicodeslot=0x15EA, category='lo', description='CANADIAN SYLLABICS CARRIER PE' },
	[0x15EB] = { unicodeslot=0x15EB, category='lo', description='CANADIAN SYLLABICS CARRIER PEE' },
	[0x15EC] = { unicodeslot=0x15EC, category='lo', description='CANADIAN SYLLABICS CARRIER PI' },
	[0x15ED] = { unicodeslot=0x15ED, category='lo', description='CANADIAN SYLLABICS CARRIER PA' },
	[0x15EE] = { unicodeslot=0x15EE, category='lo', description='CANADIAN SYLLABICS CARRIER P' },
	[0x15EF] = { unicodeslot=0x15EF, category='lo', description='CANADIAN SYLLABICS CARRIER GU' },
	[0x15F0] = { unicodeslot=0x15F0, category='lo', description='CANADIAN SYLLABICS CARRIER GO' },
	[0x15F1] = { unicodeslot=0x15F1, category='lo', description='CANADIAN SYLLABICS CARRIER GE' },
	[0x15F2] = { unicodeslot=0x15F2, category='lo', description='CANADIAN SYLLABICS CARRIER GEE' },
	[0x15F3] = { unicodeslot=0x15F3, category='lo', description='CANADIAN SYLLABICS CARRIER GI' },
	[0x15F4] = { unicodeslot=0x15F4, category='lo', description='CANADIAN SYLLABICS CARRIER GA' },
	[0x15F5] = { unicodeslot=0x15F5, category='lo', description='CANADIAN SYLLABICS CARRIER KHU' },
	[0x15F6] = { unicodeslot=0x15F6, category='lo', description='CANADIAN SYLLABICS CARRIER KHO' },
	[0x15F7] = { unicodeslot=0x15F7, category='lo', description='CANADIAN SYLLABICS CARRIER KHE' },
	[0x15F8] = { unicodeslot=0x15F8, category='lo', description='CANADIAN SYLLABICS CARRIER KHEE' },
	[0x15F9] = { unicodeslot=0x15F9, category='lo', description='CANADIAN SYLLABICS CARRIER KHI' },
	[0x15FA] = { unicodeslot=0x15FA, category='lo', description='CANADIAN SYLLABICS CARRIER KHA' },
	[0x15FB] = { unicodeslot=0x15FB, category='lo', description='CANADIAN SYLLABICS CARRIER KKU' },
	[0x15FC] = { unicodeslot=0x15FC, category='lo', description='CANADIAN SYLLABICS CARRIER KKO' },
	[0x15FD] = { unicodeslot=0x15FD, category='lo', description='CANADIAN SYLLABICS CARRIER KKE' },
	[0x15FE] = { unicodeslot=0x15FE, category='lo', description='CANADIAN SYLLABICS CARRIER KKEE' },
	[0x15FF] = { unicodeslot=0x15FF, category='lo', description='CANADIAN SYLLABICS CARRIER KKI' },
	[0x1600] = { unicodeslot=0x1600, category='lo', description='CANADIAN SYLLABICS CARRIER KKA' },
	[0x1601] = { unicodeslot=0x1601, category='lo', description='CANADIAN SYLLABICS CARRIER KK' },
	[0x1602] = { unicodeslot=0x1602, category='lo', description='CANADIAN SYLLABICS CARRIER NU' },
	[0x1603] = { unicodeslot=0x1603, category='lo', description='CANADIAN SYLLABICS CARRIER NO' },
	[0x1604] = { unicodeslot=0x1604, category='lo', description='CANADIAN SYLLABICS CARRIER NE' },
	[0x1605] = { unicodeslot=0x1605, category='lo', description='CANADIAN SYLLABICS CARRIER NEE' },
	[0x1606] = { unicodeslot=0x1606, category='lo', description='CANADIAN SYLLABICS CARRIER NI' },
	[0x1607] = { unicodeslot=0x1607, category='lo', description='CANADIAN SYLLABICS CARRIER NA' },
	[0x1608] = { unicodeslot=0x1608, category='lo', description='CANADIAN SYLLABICS CARRIER MU' },
	[0x1609] = { unicodeslot=0x1609, category='lo', description='CANADIAN SYLLABICS CARRIER MO' },
	[0x160A] = { unicodeslot=0x160A, category='lo', description='CANADIAN SYLLABICS CARRIER ME' },
	[0x160B] = { unicodeslot=0x160B, category='lo', description='CANADIAN SYLLABICS CARRIER MEE' },
	[0x160C] = { unicodeslot=0x160C, category='lo', description='CANADIAN SYLLABICS CARRIER MI' },
	[0x160D] = { unicodeslot=0x160D, category='lo', description='CANADIAN SYLLABICS CARRIER MA' },
	[0x160E] = { unicodeslot=0x160E, category='lo', description='CANADIAN SYLLABICS CARRIER YU' },
	[0x160F] = { unicodeslot=0x160F, category='lo', description='CANADIAN SYLLABICS CARRIER YO' },
	[0x1610] = { unicodeslot=0x1610, category='lo', description='CANADIAN SYLLABICS CARRIER YE' },
	[0x1611] = { unicodeslot=0x1611, category='lo', description='CANADIAN SYLLABICS CARRIER YEE' },
	[0x1612] = { unicodeslot=0x1612, category='lo', description='CANADIAN SYLLABICS CARRIER YI' },
	[0x1613] = { unicodeslot=0x1613, category='lo', description='CANADIAN SYLLABICS CARRIER YA' },
	[0x1614] = { unicodeslot=0x1614, category='lo', description='CANADIAN SYLLABICS CARRIER JU' },
	[0x1615] = { unicodeslot=0x1615, category='lo', description='CANADIAN SYLLABICS SAYISI JU' },
	[0x1616] = { unicodeslot=0x1616, category='lo', description='CANADIAN SYLLABICS CARRIER JO' },
	[0x1617] = { unicodeslot=0x1617, category='lo', description='CANADIAN SYLLABICS CARRIER JE' },
	[0x1618] = { unicodeslot=0x1618, category='lo', description='CANADIAN SYLLABICS CARRIER JEE' },
	[0x1619] = { unicodeslot=0x1619, category='lo', description='CANADIAN SYLLABICS CARRIER JI' },
	[0x161A] = { unicodeslot=0x161A, category='lo', description='CANADIAN SYLLABICS SAYISI JI' },
	[0x161B] = { unicodeslot=0x161B, category='lo', description='CANADIAN SYLLABICS CARRIER JA' },
	[0x161C] = { unicodeslot=0x161C, category='lo', description='CANADIAN SYLLABICS CARRIER JJU' },
	[0x161D] = { unicodeslot=0x161D, category='lo', description='CANADIAN SYLLABICS CARRIER JJO' },
	[0x161E] = { unicodeslot=0x161E, category='lo', description='CANADIAN SYLLABICS CARRIER JJE' },
	[0x161F] = { unicodeslot=0x161F, category='lo', description='CANADIAN SYLLABICS CARRIER JJEE' },
	[0x1620] = { unicodeslot=0x1620, category='lo', description='CANADIAN SYLLABICS CARRIER JJI' },
	[0x1621] = { unicodeslot=0x1621, category='lo', description='CANADIAN SYLLABICS CARRIER JJA' },
	[0x1622] = { unicodeslot=0x1622, category='lo', description='CANADIAN SYLLABICS CARRIER LU' },
	[0x1623] = { unicodeslot=0x1623, category='lo', description='CANADIAN SYLLABICS CARRIER LO' },
	[0x1624] = { unicodeslot=0x1624, category='lo', description='CANADIAN SYLLABICS CARRIER LE' },
	[0x1625] = { unicodeslot=0x1625, category='lo', description='CANADIAN SYLLABICS CARRIER LEE' },
	[0x1626] = { unicodeslot=0x1626, category='lo', description='CANADIAN SYLLABICS CARRIER LI' },
	[0x1627] = { unicodeslot=0x1627, category='lo', description='CANADIAN SYLLABICS CARRIER LA' },
	[0x1628] = { unicodeslot=0x1628, category='lo', description='CANADIAN SYLLABICS CARRIER DLU' },
	[0x1629] = { unicodeslot=0x1629, category='lo', description='CANADIAN SYLLABICS CARRIER DLO' },
	[0x162A] = { unicodeslot=0x162A, category='lo', description='CANADIAN SYLLABICS CARRIER DLE' },
	[0x162B] = { unicodeslot=0x162B, category='lo', description='CANADIAN SYLLABICS CARRIER DLEE' },
	[0x162C] = { unicodeslot=0x162C, category='lo', description='CANADIAN SYLLABICS CARRIER DLI' },
	[0x162D] = { unicodeslot=0x162D, category='lo', description='CANADIAN SYLLABICS CARRIER DLA' },
	[0x162E] = { unicodeslot=0x162E, category='lo', description='CANADIAN SYLLABICS CARRIER LHU' },
	[0x162F] = { unicodeslot=0x162F, category='lo', description='CANADIAN SYLLABICS CARRIER LHO' },
	[0x1630] = { unicodeslot=0x1630, category='lo', description='CANADIAN SYLLABICS CARRIER LHE' },
	[0x1631] = { unicodeslot=0x1631, category='lo', description='CANADIAN SYLLABICS CARRIER LHEE' },
	[0x1632] = { unicodeslot=0x1632, category='lo', description='CANADIAN SYLLABICS CARRIER LHI' },
	[0x1633] = { unicodeslot=0x1633, category='lo', description='CANADIAN SYLLABICS CARRIER LHA' },
	[0x1634] = { unicodeslot=0x1634, category='lo', description='CANADIAN SYLLABICS CARRIER TLHU' },
	[0x1635] = { unicodeslot=0x1635, category='lo', description='CANADIAN SYLLABICS CARRIER TLHO' },
	[0x1636] = { unicodeslot=0x1636, category='lo', description='CANADIAN SYLLABICS CARRIER TLHE' },
	[0x1637] = { unicodeslot=0x1637, category='lo', description='CANADIAN SYLLABICS CARRIER TLHEE' },
	[0x1638] = { unicodeslot=0x1638, category='lo', description='CANADIAN SYLLABICS CARRIER TLHI' },
	[0x1639] = { unicodeslot=0x1639, category='lo', description='CANADIAN SYLLABICS CARRIER TLHA' },
	[0x163A] = { unicodeslot=0x163A, category='lo', description='CANADIAN SYLLABICS CARRIER TLU' },
	[0x163B] = { unicodeslot=0x163B, category='lo', description='CANADIAN SYLLABICS CARRIER TLO' },
	[0x163C] = { unicodeslot=0x163C, category='lo', description='CANADIAN SYLLABICS CARRIER TLE' },
	[0x163D] = { unicodeslot=0x163D, category='lo', description='CANADIAN SYLLABICS CARRIER TLEE' },
	[0x163E] = { unicodeslot=0x163E, category='lo', description='CANADIAN SYLLABICS CARRIER TLI' },
	[0x163F] = { unicodeslot=0x163F, category='lo', description='CANADIAN SYLLABICS CARRIER TLA' },
	[0x1640] = { unicodeslot=0x1640, category='lo', description='CANADIAN SYLLABICS CARRIER ZU' },
	[0x1641] = { unicodeslot=0x1641, category='lo', description='CANADIAN SYLLABICS CARRIER ZO' },
	[0x1642] = { unicodeslot=0x1642, category='lo', description='CANADIAN SYLLABICS CARRIER ZE' },
	[0x1643] = { unicodeslot=0x1643, category='lo', description='CANADIAN SYLLABICS CARRIER ZEE' },
	[0x1644] = { unicodeslot=0x1644, category='lo', description='CANADIAN SYLLABICS CARRIER ZI' },
	[0x1645] = { unicodeslot=0x1645, category='lo', description='CANADIAN SYLLABICS CARRIER ZA' },
	[0x1646] = { unicodeslot=0x1646, category='lo', description='CANADIAN SYLLABICS CARRIER Z' },
	[0x1647] = { unicodeslot=0x1647, category='lo', description='CANADIAN SYLLABICS CARRIER INITIAL Z' },
	[0x1648] = { unicodeslot=0x1648, category='lo', description='CANADIAN SYLLABICS CARRIER DZU' },
	[0x1649] = { unicodeslot=0x1649, category='lo', description='CANADIAN SYLLABICS CARRIER DZO' },
	[0x164A] = { unicodeslot=0x164A, category='lo', description='CANADIAN SYLLABICS CARRIER DZE' },
	[0x164B] = { unicodeslot=0x164B, category='lo', description='CANADIAN SYLLABICS CARRIER DZEE' },
	[0x164C] = { unicodeslot=0x164C, category='lo', description='CANADIAN SYLLABICS CARRIER DZI' },
	[0x164D] = { unicodeslot=0x164D, category='lo', description='CANADIAN SYLLABICS CARRIER DZA' },
	[0x164E] = { unicodeslot=0x164E, category='lo', description='CANADIAN SYLLABICS CARRIER SU' },
	[0x164F] = { unicodeslot=0x164F, category='lo', description='CANADIAN SYLLABICS CARRIER SO' },
	[0x1650] = { unicodeslot=0x1650, category='lo', description='CANADIAN SYLLABICS CARRIER SE' },
	[0x1651] = { unicodeslot=0x1651, category='lo', description='CANADIAN SYLLABICS CARRIER SEE' },
	[0x1652] = { unicodeslot=0x1652, category='lo', description='CANADIAN SYLLABICS CARRIER SI' },
	[0x1653] = { unicodeslot=0x1653, category='lo', description='CANADIAN SYLLABICS CARRIER SA' },
	[0x1654] = { unicodeslot=0x1654, category='lo', description='CANADIAN SYLLABICS CARRIER SHU' },
	[0x1655] = { unicodeslot=0x1655, category='lo', description='CANADIAN SYLLABICS CARRIER SHO' },
	[0x1656] = { unicodeslot=0x1656, category='lo', description='CANADIAN SYLLABICS CARRIER SHE' },
	[0x1657] = { unicodeslot=0x1657, category='lo', description='CANADIAN SYLLABICS CARRIER SHEE' },
	[0x1658] = { unicodeslot=0x1658, category='lo', description='CANADIAN SYLLABICS CARRIER SHI' },
	[0x1659] = { unicodeslot=0x1659, category='lo', description='CANADIAN SYLLABICS CARRIER SHA' },
	[0x165A] = { unicodeslot=0x165A, category='lo', description='CANADIAN SYLLABICS CARRIER SH' },
	[0x165B] = { unicodeslot=0x165B, category='lo', description='CANADIAN SYLLABICS CARRIER TSU' },
	[0x165C] = { unicodeslot=0x165C, category='lo', description='CANADIAN SYLLABICS CARRIER TSO' },
	[0x165D] = { unicodeslot=0x165D, category='lo', description='CANADIAN SYLLABICS CARRIER TSE' },
	[0x165E] = { unicodeslot=0x165E, category='lo', description='CANADIAN SYLLABICS CARRIER TSEE' },
	[0x165F] = { unicodeslot=0x165F, category='lo', description='CANADIAN SYLLABICS CARRIER TSI' },
	[0x1660] = { unicodeslot=0x1660, category='lo', description='CANADIAN SYLLABICS CARRIER TSA' },
	[0x1661] = { unicodeslot=0x1661, category='lo', description='CANADIAN SYLLABICS CARRIER CHU' },
	[0x1662] = { unicodeslot=0x1662, category='lo', description='CANADIAN SYLLABICS CARRIER CHO' },
	[0x1663] = { unicodeslot=0x1663, category='lo', description='CANADIAN SYLLABICS CARRIER CHE' },
	[0x1664] = { unicodeslot=0x1664, category='lo', description='CANADIAN SYLLABICS CARRIER CHEE' },
	[0x1665] = { unicodeslot=0x1665, category='lo', description='CANADIAN SYLLABICS CARRIER CHI' },
	[0x1666] = { unicodeslot=0x1666, category='lo', description='CANADIAN SYLLABICS CARRIER CHA' },
	[0x1667] = { unicodeslot=0x1667, category='lo', description='CANADIAN SYLLABICS CARRIER TTSU' },
	[0x1668] = { unicodeslot=0x1668, category='lo', description='CANADIAN SYLLABICS CARRIER TTSO' },
	[0x1669] = { unicodeslot=0x1669, category='lo', description='CANADIAN SYLLABICS CARRIER TTSE' },
	[0x166A] = { unicodeslot=0x166A, category='lo', description='CANADIAN SYLLABICS CARRIER TTSEE' },
	[0x166B] = { unicodeslot=0x166B, category='lo', description='CANADIAN SYLLABICS CARRIER TTSI' },
	[0x166C] = { unicodeslot=0x166C, category='lo', description='CANADIAN SYLLABICS CARRIER TTSA' },
	[0x166D] = { unicodeslot=0x166D, category='po', description='CANADIAN SYLLABICS CHI SIGN' },
	[0x166E] = { unicodeslot=0x166E, category='po', description='CANADIAN SYLLABICS FULL STOP' },
	[0x166F] = { unicodeslot=0x166F, category='lo', description='CANADIAN SYLLABICS QAI' },
	[0x1670] = { unicodeslot=0x1670, category='lo', description='CANADIAN SYLLABICS NGAI' },
	[0x1671] = { unicodeslot=0x1671, category='lo', description='CANADIAN SYLLABICS NNGI' },
	[0x1672] = { unicodeslot=0x1672, category='lo', description='CANADIAN SYLLABICS NNGII' },
	[0x1673] = { unicodeslot=0x1673, category='lo', description='CANADIAN SYLLABICS NNGO' },
	[0x1674] = { unicodeslot=0x1674, category='lo', description='CANADIAN SYLLABICS NNGOO' },
	[0x1675] = { unicodeslot=0x1675, category='lo', description='CANADIAN SYLLABICS NNGA' },
	[0x1676] = { unicodeslot=0x1676, category='lo', description='CANADIAN SYLLABICS NNGAA' },
	[0x1680] = { unicodeslot=0x1680, category='zs', description='OGHAM SPACE MARK' },
	[0x1681] = { unicodeslot=0x1681, category='lo', description='OGHAM LETTER BEITH' },
	[0x1682] = { unicodeslot=0x1682, category='lo', description='OGHAM LETTER LUIS' },
	[0x1683] = { unicodeslot=0x1683, category='lo', description='OGHAM LETTER FEARN' },
	[0x1684] = { unicodeslot=0x1684, category='lo', description='OGHAM LETTER SAIL' },
	[0x1685] = { unicodeslot=0x1685, category='lo', description='OGHAM LETTER NION' },
	[0x1686] = { unicodeslot=0x1686, category='lo', description='OGHAM LETTER UATH' },
	[0x1687] = { unicodeslot=0x1687, category='lo', description='OGHAM LETTER DAIR' },
	[0x1688] = { unicodeslot=0x1688, category='lo', description='OGHAM LETTER TINNE' },
	[0x1689] = { unicodeslot=0x1689, category='lo', description='OGHAM LETTER COLL' },
	[0x168A] = { unicodeslot=0x168A, category='lo', description='OGHAM LETTER CEIRT' },
	[0x168B] = { unicodeslot=0x168B, category='lo', description='OGHAM LETTER MUIN' },
	[0x168C] = { unicodeslot=0x168C, category='lo', description='OGHAM LETTER GORT' },
	[0x168D] = { unicodeslot=0x168D, category='lo', description='OGHAM LETTER NGEADAL' },
	[0x168E] = { unicodeslot=0x168E, category='lo', description='OGHAM LETTER STRAIF' },
	[0x168F] = { unicodeslot=0x168F, category='lo', description='OGHAM LETTER RUIS' },
	[0x1690] = { unicodeslot=0x1690, category='lo', description='OGHAM LETTER AILM' },
	[0x1691] = { unicodeslot=0x1691, category='lo', description='OGHAM LETTER ONN' },
	[0x1692] = { unicodeslot=0x1692, category='lo', description='OGHAM LETTER UR' },
	[0x1693] = { unicodeslot=0x1693, category='lo', description='OGHAM LETTER EADHADH' },
	[0x1694] = { unicodeslot=0x1694, category='lo', description='OGHAM LETTER IODHADH' },
	[0x1695] = { unicodeslot=0x1695, category='lo', description='OGHAM LETTER EABHADH' },
	[0x1696] = { unicodeslot=0x1696, category='lo', description='OGHAM LETTER OR' },
	[0x1697] = { unicodeslot=0x1697, category='lo', description='OGHAM LETTER UILLEANN' },
	[0x1698] = { unicodeslot=0x1698, category='lo', description='OGHAM LETTER IFIN' },
	[0x1699] = { unicodeslot=0x1699, category='lo', description='OGHAM LETTER EAMHANCHOLL' },
	[0x169A] = { unicodeslot=0x169A, category='lo', description='OGHAM LETTER PEITH' },
	[0x169B] = { unicodeslot=0x169B, category='ps', description='OGHAM FEATHER MARK' },
	[0x169C] = { unicodeslot=0x169C, category='pe', description='OGHAM REVERSED FEATHER MARK' },
	[0x16A0] = { unicodeslot=0x16A0, category='lo', description='RUNIC LETTER FEHU FEOH FE F' },
	[0x16A1] = { unicodeslot=0x16A1, category='lo', description='RUNIC LETTER V' },
	[0x16A2] = { unicodeslot=0x16A2, category='lo', description='RUNIC LETTER URUZ UR U' },
	[0x16A3] = { unicodeslot=0x16A3, category='lo', description='RUNIC LETTER YR' },
	[0x16A4] = { unicodeslot=0x16A4, category='lo', description='RUNIC LETTER Y' },
	[0x16A5] = { unicodeslot=0x16A5, category='lo', description='RUNIC LETTER W' },
	[0x16A6] = { unicodeslot=0x16A6, category='lo', description='RUNIC LETTER THURISAZ THURS THORN' },
	[0x16A7] = { unicodeslot=0x16A7, category='lo', description='RUNIC LETTER ETH' },
	[0x16A8] = { unicodeslot=0x16A8, category='lo', description='RUNIC LETTER ANSUZ A' },
	[0x16A9] = { unicodeslot=0x16A9, category='lo', description='RUNIC LETTER OS O' },
	[0x16AA] = { unicodeslot=0x16AA, category='lo', description='RUNIC LETTER AC A' },
	[0x16AB] = { unicodeslot=0x16AB, category='lo', description='RUNIC LETTER AESC' },
	[0x16AC] = { unicodeslot=0x16AC, category='lo', description='RUNIC LETTER LONG-BRANCH-OSS O' },
	[0x16AD] = { unicodeslot=0x16AD, category='lo', description='RUNIC LETTER SHORT-TWIG-OSS O' },
	[0x16AE] = { unicodeslot=0x16AE, category='lo', description='RUNIC LETTER O' },
	[0x16AF] = { unicodeslot=0x16AF, category='lo', description='RUNIC LETTER OE' },
	[0x16B0] = { unicodeslot=0x16B0, category='lo', description='RUNIC LETTER ON' },
	[0x16B1] = { unicodeslot=0x16B1, category='lo', description='RUNIC LETTER RAIDO RAD REID R' },
	[0x16B2] = { unicodeslot=0x16B2, category='lo', description='RUNIC LETTER KAUNA' },
	[0x16B3] = { unicodeslot=0x16B3, category='lo', description='RUNIC LETTER CEN' },
	[0x16B4] = { unicodeslot=0x16B4, category='lo', description='RUNIC LETTER KAUN K' },
	[0x16B5] = { unicodeslot=0x16B5, category='lo', description='RUNIC LETTER G' },
	[0x16B6] = { unicodeslot=0x16B6, category='lo', description='RUNIC LETTER ENG' },
	[0x16B7] = { unicodeslot=0x16B7, category='lo', description='RUNIC LETTER GEBO GYFU G' },
	[0x16B8] = { unicodeslot=0x16B8, category='lo', description='RUNIC LETTER GAR' },
	[0x16B9] = { unicodeslot=0x16B9, category='lo', description='RUNIC LETTER WUNJO WYNN W' },
	[0x16BA] = { unicodeslot=0x16BA, category='lo', description='RUNIC LETTER HAGLAZ H' },
	[0x16BB] = { unicodeslot=0x16BB, category='lo', description='RUNIC LETTER HAEGL H' },
	[0x16BC] = { unicodeslot=0x16BC, category='lo', description='RUNIC LETTER LONG-BRANCH-HAGALL H' },
	[0x16BD] = { unicodeslot=0x16BD, category='lo', description='RUNIC LETTER SHORT-TWIG-HAGALL H' },
	[0x16BE] = { unicodeslot=0x16BE, category='lo', description='RUNIC LETTER NAUDIZ NYD NAUD N' },
	[0x16BF] = { unicodeslot=0x16BF, category='lo', description='RUNIC LETTER SHORT-TWIG-NAUD N' },
	[0x16C0] = { unicodeslot=0x16C0, category='lo', description='RUNIC LETTER DOTTED-N' },
	[0x16C1] = { unicodeslot=0x16C1, category='lo', description='RUNIC LETTER ISAZ IS ISS I' },
	[0x16C2] = { unicodeslot=0x16C2, category='lo', description='RUNIC LETTER E' },
	[0x16C3] = { unicodeslot=0x16C3, category='lo', description='RUNIC LETTER JERAN J' },
	[0x16C4] = { unicodeslot=0x16C4, category='lo', description='RUNIC LETTER GER' },
	[0x16C5] = { unicodeslot=0x16C5, category='lo', description='RUNIC LETTER LONG-BRANCH-AR AE' },
	[0x16C6] = { unicodeslot=0x16C6, category='lo', description='RUNIC LETTER SHORT-TWIG-AR A' },
	[0x16C7] = { unicodeslot=0x16C7, category='lo', description='RUNIC LETTER IWAZ EOH' },
	[0x16C8] = { unicodeslot=0x16C8, category='lo', description='RUNIC LETTER PERTHO PEORTH P' },
	[0x16C9] = { unicodeslot=0x16C9, category='lo', description='RUNIC LETTER ALGIZ EOLHX' },
	[0x16CA] = { unicodeslot=0x16CA, category='lo', description='RUNIC LETTER SOWILO S' },
	[0x16CB] = { unicodeslot=0x16CB, category='lo', description='RUNIC LETTER SIGEL LONG-BRANCH-SOL S' },
	[0x16CC] = { unicodeslot=0x16CC, category='lo', description='RUNIC LETTER SHORT-TWIG-SOL S' },
	[0x16CD] = { unicodeslot=0x16CD, category='lo', description='RUNIC LETTER C' },
	[0x16CE] = { unicodeslot=0x16CE, category='lo', description='RUNIC LETTER Z' },
	[0x16CF] = { unicodeslot=0x16CF, category='lo', description='RUNIC LETTER TIWAZ TIR TYR T' },
	[0x16D0] = { unicodeslot=0x16D0, category='lo', description='RUNIC LETTER SHORT-TWIG-TYR T' },
	[0x16D1] = { unicodeslot=0x16D1, category='lo', description='RUNIC LETTER D' },
	[0x16D2] = { unicodeslot=0x16D2, category='lo', description='RUNIC LETTER BERKANAN BEORC BJARKAN B' },
	[0x16D3] = { unicodeslot=0x16D3, category='lo', description='RUNIC LETTER SHORT-TWIG-BJARKAN B' },
	[0x16D4] = { unicodeslot=0x16D4, category='lo', description='RUNIC LETTER DOTTED-P' },
	[0x16D5] = { unicodeslot=0x16D5, category='lo', description='RUNIC LETTER OPEN-P' },
	[0x16D6] = { unicodeslot=0x16D6, category='lo', description='RUNIC LETTER EHWAZ EH E' },
	[0x16D7] = { unicodeslot=0x16D7, category='lo', description='RUNIC LETTER MANNAZ MAN M' },
	[0x16D8] = { unicodeslot=0x16D8, category='lo', description='RUNIC LETTER LONG-BRANCH-MADR M' },
	[0x16D9] = { unicodeslot=0x16D9, category='lo', description='RUNIC LETTER SHORT-TWIG-MADR M' },
	[0x16DA] = { unicodeslot=0x16DA, category='lo', description='RUNIC LETTER LAUKAZ LAGU LOGR L' },
	[0x16DB] = { unicodeslot=0x16DB, category='lo', description='RUNIC LETTER DOTTED-L' },
	[0x16DC] = { unicodeslot=0x16DC, category='lo', description='RUNIC LETTER INGWAZ' },
	[0x16DD] = { unicodeslot=0x16DD, category='lo', description='RUNIC LETTER ING' },
	[0x16DE] = { unicodeslot=0x16DE, category='lo', description='RUNIC LETTER DAGAZ DAEG D' },
	[0x16DF] = { unicodeslot=0x16DF, category='lo', description='RUNIC LETTER OTHALAN ETHEL O' },
	[0x16E0] = { unicodeslot=0x16E0, category='lo', description='RUNIC LETTER EAR' },
	[0x16E1] = { unicodeslot=0x16E1, category='lo', description='RUNIC LETTER IOR' },
	[0x16E2] = { unicodeslot=0x16E2, category='lo', description='RUNIC LETTER CWEORTH' },
	[0x16E3] = { unicodeslot=0x16E3, category='lo', description='RUNIC LETTER CALC' },
	[0x16E4] = { unicodeslot=0x16E4, category='lo', description='RUNIC LETTER CEALC' },
	[0x16E5] = { unicodeslot=0x16E5, category='lo', description='RUNIC LETTER STAN' },
	[0x16E6] = { unicodeslot=0x16E6, category='lo', description='RUNIC LETTER LONG-BRANCH-YR' },
	[0x16E7] = { unicodeslot=0x16E7, category='lo', description='RUNIC LETTER SHORT-TWIG-YR' },
	[0x16E8] = { unicodeslot=0x16E8, category='lo', description='RUNIC LETTER ICELANDIC-YR' },
	[0x16E9] = { unicodeslot=0x16E9, category='lo', description='RUNIC LETTER Q' },
	[0x16EA] = { unicodeslot=0x16EA, category='lo', description='RUNIC LETTER X' },
	[0x16EB] = { unicodeslot=0x16EB, category='po', description='RUNIC SINGLE PUNCTUATION' },
	[0x16EC] = { unicodeslot=0x16EC, category='po', description='RUNIC MULTIPLE PUNCTUATION' },
	[0x16ED] = { unicodeslot=0x16ED, category='po', description='RUNIC CROSS PUNCTUATION' },
	[0x16EE] = { unicodeslot=0x16EE, category='nl', description='RUNIC ARLAUG SYMBOL' },
	[0x16EF] = { unicodeslot=0x16EF, category='nl', description='RUNIC TVIMADUR SYMBOL' },
	[0x16F0] = { unicodeslot=0x16F0, category='nl', description='RUNIC BELGTHOR SYMBOL' },
	[0x1700] = { unicodeslot=0x1700, category='lo', description='TAGALOG LETTER A' },
	[0x1701] = { unicodeslot=0x1701, category='lo', description='TAGALOG LETTER I' },
	[0x1702] = { unicodeslot=0x1702, category='lo', description='TAGALOG LETTER U' },
	[0x1703] = { unicodeslot=0x1703, category='lo', description='TAGALOG LETTER KA' },
	[0x1704] = { unicodeslot=0x1704, category='lo', description='TAGALOG LETTER GA' },
	[0x1705] = { unicodeslot=0x1705, category='lo', description='TAGALOG LETTER NGA' },
	[0x1706] = { unicodeslot=0x1706, category='lo', description='TAGALOG LETTER TA' },
	[0x1707] = { unicodeslot=0x1707, category='lo', description='TAGALOG LETTER DA' },
	[0x1708] = { unicodeslot=0x1708, category='lo', description='TAGALOG LETTER NA' },
	[0x1709] = { unicodeslot=0x1709, category='lo', description='TAGALOG LETTER PA' },
	[0x170A] = { unicodeslot=0x170A, category='lo', description='TAGALOG LETTER BA' },
	[0x170B] = { unicodeslot=0x170B, category='lo', description='TAGALOG LETTER MA' },
	[0x170C] = { unicodeslot=0x170C, category='lo', description='TAGALOG LETTER YA' },
	[0x170E] = { unicodeslot=0x170E, category='lo', description='TAGALOG LETTER LA' },
	[0x170F] = { unicodeslot=0x170F, category='lo', description='TAGALOG LETTER WA' },
	[0x1710] = { unicodeslot=0x1710, category='lo', description='TAGALOG LETTER SA' },
	[0x1711] = { unicodeslot=0x1711, category='lo', description='TAGALOG LETTER HA' },
	[0x1712] = { unicodeslot=0x1712, category='mn', description='TAGALOG VOWEL SIGN I' },
	[0x1713] = { unicodeslot=0x1713, category='mn', description='TAGALOG VOWEL SIGN U' },
	[0x1714] = { unicodeslot=0x1714, category='mn', description='TAGALOG SIGN VIRAMA' },
	[0x1720] = { unicodeslot=0x1720, category='lo', description='HANUNOO LETTER A' },
	[0x1721] = { unicodeslot=0x1721, category='lo', description='HANUNOO LETTER I' },
	[0x1722] = { unicodeslot=0x1722, category='lo', description='HANUNOO LETTER U' },
	[0x1723] = { unicodeslot=0x1723, category='lo', description='HANUNOO LETTER KA' },
	[0x1724] = { unicodeslot=0x1724, category='lo', description='HANUNOO LETTER GA' },
	[0x1725] = { unicodeslot=0x1725, category='lo', description='HANUNOO LETTER NGA' },
	[0x1726] = { unicodeslot=0x1726, category='lo', description='HANUNOO LETTER TA' },
	[0x1727] = { unicodeslot=0x1727, category='lo', description='HANUNOO LETTER DA' },
	[0x1728] = { unicodeslot=0x1728, category='lo', description='HANUNOO LETTER NA' },
	[0x1729] = { unicodeslot=0x1729, category='lo', description='HANUNOO LETTER PA' },
	[0x172A] = { unicodeslot=0x172A, category='lo', description='HANUNOO LETTER BA' },
	[0x172B] = { unicodeslot=0x172B, category='lo', description='HANUNOO LETTER MA' },
	[0x172C] = { unicodeslot=0x172C, category='lo', description='HANUNOO LETTER YA' },
	[0x172D] = { unicodeslot=0x172D, category='lo', description='HANUNOO LETTER RA' },
	[0x172E] = { unicodeslot=0x172E, category='lo', description='HANUNOO LETTER LA' },
	[0x172F] = { unicodeslot=0x172F, category='lo', description='HANUNOO LETTER WA' },
	[0x1730] = { unicodeslot=0x1730, category='lo', description='HANUNOO LETTER SA' },
	[0x1731] = { unicodeslot=0x1731, category='lo', description='HANUNOO LETTER HA' },
	[0x1732] = { unicodeslot=0x1732, category='mn', description='HANUNOO VOWEL SIGN I' },
	[0x1733] = { unicodeslot=0x1733, category='mn', description='HANUNOO VOWEL SIGN U' },
	[0x1734] = { unicodeslot=0x1734, category='mn', description='HANUNOO SIGN PAMUDPOD' },
	[0x1735] = { unicodeslot=0x1735, category='po', description='PHILIPPINE SINGLE PUNCTUATION' },
	[0x1736] = { unicodeslot=0x1736, category='po', description='PHILIPPINE DOUBLE PUNCTUATION' },
	[0x1740] = { unicodeslot=0x1740, category='lo', description='BUHID LETTER A' },
	[0x1741] = { unicodeslot=0x1741, category='lo', description='BUHID LETTER I' },
	[0x1742] = { unicodeslot=0x1742, category='lo', description='BUHID LETTER U' },
	[0x1743] = { unicodeslot=0x1743, category='lo', description='BUHID LETTER KA' },
	[0x1744] = { unicodeslot=0x1744, category='lo', description='BUHID LETTER GA' },
	[0x1745] = { unicodeslot=0x1745, category='lo', description='BUHID LETTER NGA' },
	[0x1746] = { unicodeslot=0x1746, category='lo', description='BUHID LETTER TA' },
	[0x1747] = { unicodeslot=0x1747, category='lo', description='BUHID LETTER DA' },
	[0x1748] = { unicodeslot=0x1748, category='lo', description='BUHID LETTER NA' },
	[0x1749] = { unicodeslot=0x1749, category='lo', description='BUHID LETTER PA' },
	[0x174A] = { unicodeslot=0x174A, category='lo', description='BUHID LETTER BA' },
	[0x174B] = { unicodeslot=0x174B, category='lo', description='BUHID LETTER MA' },
	[0x174C] = { unicodeslot=0x174C, category='lo', description='BUHID LETTER YA' },
	[0x174D] = { unicodeslot=0x174D, category='lo', description='BUHID LETTER RA' },
	[0x174E] = { unicodeslot=0x174E, category='lo', description='BUHID LETTER LA' },
	[0x174F] = { unicodeslot=0x174F, category='lo', description='BUHID LETTER WA' },
	[0x1750] = { unicodeslot=0x1750, category='lo', description='BUHID LETTER SA' },
	[0x1751] = { unicodeslot=0x1751, category='lo', description='BUHID LETTER HA' },
	[0x1752] = { unicodeslot=0x1752, category='mn', description='BUHID VOWEL SIGN I' },
	[0x1753] = { unicodeslot=0x1753, category='mn', description='BUHID VOWEL SIGN U' },
	[0x1760] = { unicodeslot=0x1760, category='lo', description='TAGBANWA LETTER A' },
	[0x1761] = { unicodeslot=0x1761, category='lo', description='TAGBANWA LETTER I' },
	[0x1762] = { unicodeslot=0x1762, category='lo', description='TAGBANWA LETTER U' },
	[0x1763] = { unicodeslot=0x1763, category='lo', description='TAGBANWA LETTER KA' },
	[0x1764] = { unicodeslot=0x1764, category='lo', description='TAGBANWA LETTER GA' },
	[0x1765] = { unicodeslot=0x1765, category='lo', description='TAGBANWA LETTER NGA' },
	[0x1766] = { unicodeslot=0x1766, category='lo', description='TAGBANWA LETTER TA' },
	[0x1767] = { unicodeslot=0x1767, category='lo', description='TAGBANWA LETTER DA' },
	[0x1768] = { unicodeslot=0x1768, category='lo', description='TAGBANWA LETTER NA' },
	[0x1769] = { unicodeslot=0x1769, category='lo', description='TAGBANWA LETTER PA' },
	[0x176A] = { unicodeslot=0x176A, category='lo', description='TAGBANWA LETTER BA' },
	[0x176B] = { unicodeslot=0x176B, category='lo', description='TAGBANWA LETTER MA' },
	[0x176C] = { unicodeslot=0x176C, category='lo', description='TAGBANWA LETTER YA' },
	[0x176E] = { unicodeslot=0x176E, category='lo', description='TAGBANWA LETTER LA' },
	[0x176F] = { unicodeslot=0x176F, category='lo', description='TAGBANWA LETTER WA' },
	[0x1770] = { unicodeslot=0x1770, category='lo', description='TAGBANWA LETTER SA' },
	[0x1772] = { unicodeslot=0x1772, category='mn', description='TAGBANWA VOWEL SIGN I' },
	[0x1773] = { unicodeslot=0x1773, category='mn', description='TAGBANWA VOWEL SIGN U' },
	[0x1780] = { unicodeslot=0x1780, category='lo', description='KHMER LETTER KA' },
	[0x1781] = { unicodeslot=0x1781, category='lo', description='KHMER LETTER KHA' },
	[0x1782] = { unicodeslot=0x1782, category='lo', description='KHMER LETTER KO' },
	[0x1783] = { unicodeslot=0x1783, category='lo', description='KHMER LETTER KHO' },
	[0x1784] = { unicodeslot=0x1784, category='lo', description='KHMER LETTER NGO' },
	[0x1785] = { unicodeslot=0x1785, category='lo', description='KHMER LETTER CA' },
	[0x1786] = { unicodeslot=0x1786, category='lo', description='KHMER LETTER CHA' },
	[0x1787] = { unicodeslot=0x1787, category='lo', description='KHMER LETTER CO' },
	[0x1788] = { unicodeslot=0x1788, category='lo', description='KHMER LETTER CHO' },
	[0x1789] = { unicodeslot=0x1789, category='lo', description='KHMER LETTER NYO' },
	[0x178A] = { unicodeslot=0x178A, category='lo', description='KHMER LETTER DA' },
	[0x178B] = { unicodeslot=0x178B, category='lo', description='KHMER LETTER TTHA' },
	[0x178C] = { unicodeslot=0x178C, category='lo', description='KHMER LETTER DO' },
	[0x178D] = { unicodeslot=0x178D, category='lo', description='KHMER LETTER TTHO' },
	[0x178E] = { unicodeslot=0x178E, category='lo', description='KHMER LETTER NNO' },
	[0x178F] = { unicodeslot=0x178F, category='lo', description='KHMER LETTER TA' },
	[0x1790] = { unicodeslot=0x1790, category='lo', description='KHMER LETTER THA' },
	[0x1791] = { unicodeslot=0x1791, category='lo', description='KHMER LETTER TO' },
	[0x1792] = { unicodeslot=0x1792, category='lo', description='KHMER LETTER THO' },
	[0x1793] = { unicodeslot=0x1793, category='lo', description='KHMER LETTER NO' },
	[0x1794] = { unicodeslot=0x1794, category='lo', description='KHMER LETTER BA' },
	[0x1795] = { unicodeslot=0x1795, category='lo', description='KHMER LETTER PHA' },
	[0x1796] = { unicodeslot=0x1796, category='lo', description='KHMER LETTER PO' },
	[0x1797] = { unicodeslot=0x1797, category='lo', description='KHMER LETTER PHO' },
	[0x1798] = { unicodeslot=0x1798, category='lo', description='KHMER LETTER MO' },
	[0x1799] = { unicodeslot=0x1799, category='lo', description='KHMER LETTER YO' },
	[0x179A] = { unicodeslot=0x179A, category='lo', description='KHMER LETTER RO' },
	[0x179B] = { unicodeslot=0x179B, category='lo', description='KHMER LETTER LO' },
	[0x179C] = { unicodeslot=0x179C, category='lo', description='KHMER LETTER VO' },
	[0x179D] = { unicodeslot=0x179D, category='lo', description='KHMER LETTER SHA' },
	[0x179E] = { unicodeslot=0x179E, category='lo', description='KHMER LETTER SSO' },
	[0x179F] = { unicodeslot=0x179F, category='lo', description='KHMER LETTER SA' },
	[0x17A0] = { unicodeslot=0x17A0, category='lo', description='KHMER LETTER HA' },
	[0x17A1] = { unicodeslot=0x17A1, category='lo', description='KHMER LETTER LA' },
	[0x17A2] = { unicodeslot=0x17A2, category='lo', description='KHMER LETTER QA' },
	[0x17A3] = { unicodeslot=0x17A3, category='lo', description='KHMER INDEPENDENT VOWEL QAQ' },
	[0x17A4] = { unicodeslot=0x17A4, category='lo', description='KHMER INDEPENDENT VOWEL QAA' },
	[0x17A5] = { unicodeslot=0x17A5, category='lo', description='KHMER INDEPENDENT VOWEL QI' },
	[0x17A6] = { unicodeslot=0x17A6, category='lo', description='KHMER INDEPENDENT VOWEL QII' },
	[0x17A7] = { unicodeslot=0x17A7, category='lo', description='KHMER INDEPENDENT VOWEL QU' },
	[0x17A8] = { unicodeslot=0x17A8, category='lo', description='KHMER INDEPENDENT VOWEL QUK' },
	[0x17A9] = { unicodeslot=0x17A9, category='lo', description='KHMER INDEPENDENT VOWEL QUU' },
	[0x17AA] = { unicodeslot=0x17AA, category='lo', description='KHMER INDEPENDENT VOWEL QUUV' },
	[0x17AB] = { unicodeslot=0x17AB, category='lo', description='KHMER INDEPENDENT VOWEL RY' },
	[0x17AC] = { unicodeslot=0x17AC, category='lo', description='KHMER INDEPENDENT VOWEL RYY' },
	[0x17AD] = { unicodeslot=0x17AD, category='lo', description='KHMER INDEPENDENT VOWEL LY' },
	[0x17AE] = { unicodeslot=0x17AE, category='lo', description='KHMER INDEPENDENT VOWEL LYY' },
	[0x17AF] = { unicodeslot=0x17AF, category='lo', description='KHMER INDEPENDENT VOWEL QE' },
	[0x17B0] = { unicodeslot=0x17B0, category='lo', description='KHMER INDEPENDENT VOWEL QAI' },
	[0x17B1] = { unicodeslot=0x17B1, category='lo', description='KHMER INDEPENDENT VOWEL QOO TYPE ONE' },
	[0x17B2] = { unicodeslot=0x17B2, category='lo', description='KHMER INDEPENDENT VOWEL QOO TYPE TWO' },
	[0x17B3] = { unicodeslot=0x17B3, category='lo', description='KHMER INDEPENDENT VOWEL QAU' },
	[0x17B4] = { unicodeslot=0x17B4, category='cf', description='KHMER VOWEL INHERENT AQ' },
	[0x17B5] = { unicodeslot=0x17B5, category='cf', description='KHMER VOWEL INHERENT AA' },
	[0x17B6] = { unicodeslot=0x17B6, category='mc', description='KHMER VOWEL SIGN AA' },
	[0x17B7] = { unicodeslot=0x17B7, category='mn', description='KHMER VOWEL SIGN I' },
	[0x17B8] = { unicodeslot=0x17B8, category='mn', description='KHMER VOWEL SIGN II' },
	[0x17B9] = { unicodeslot=0x17B9, category='mn', description='KHMER VOWEL SIGN Y' },
	[0x17BA] = { unicodeslot=0x17BA, category='mn', description='KHMER VOWEL SIGN YY' },
	[0x17BB] = { unicodeslot=0x17BB, category='mn', description='KHMER VOWEL SIGN U' },
	[0x17BC] = { unicodeslot=0x17BC, category='mn', description='KHMER VOWEL SIGN UU' },
	[0x17BD] = { unicodeslot=0x17BD, category='mn', description='KHMER VOWEL SIGN UA' },
	[0x17BE] = { unicodeslot=0x17BE, category='mc', description='KHMER VOWEL SIGN OE' },
	[0x17BF] = { unicodeslot=0x17BF, category='mc', description='KHMER VOWEL SIGN YA' },
	[0x17C0] = { unicodeslot=0x17C0, category='mc', description='KHMER VOWEL SIGN IE' },
	[0x17C1] = { unicodeslot=0x17C1, category='mc', description='KHMER VOWEL SIGN E' },
	[0x17C2] = { unicodeslot=0x17C2, category='mc', description='KHMER VOWEL SIGN AE' },
	[0x17C3] = { unicodeslot=0x17C3, category='mc', description='KHMER VOWEL SIGN AI' },
	[0x17C4] = { unicodeslot=0x17C4, category='mc', description='KHMER VOWEL SIGN OO' },
	[0x17C5] = { unicodeslot=0x17C5, category='mc', description='KHMER VOWEL SIGN AU' },
	[0x17C6] = { unicodeslot=0x17C6, category='mn', description='KHMER SIGN NIKAHIT' },
	[0x17C7] = { unicodeslot=0x17C7, category='mc', description='KHMER SIGN REAHMUK' },
	[0x17C8] = { unicodeslot=0x17C8, category='mc', description='KHMER SIGN YUUKALEAPINTU' },
	[0x17C9] = { unicodeslot=0x17C9, category='mn', description='KHMER SIGN MUUSIKATOAN' },
	[0x17CA] = { unicodeslot=0x17CA, category='mn', description='KHMER SIGN TRIISAP' },
	[0x17CB] = { unicodeslot=0x17CB, category='mn', description='KHMER SIGN BANTOC' },
	[0x17CC] = { unicodeslot=0x17CC, category='mn', description='KHMER SIGN ROBAT' },
	[0x17CD] = { unicodeslot=0x17CD, category='mn', description='KHMER SIGN TOANDAKHIAT' },
	[0x17CE] = { unicodeslot=0x17CE, category='mn', description='KHMER SIGN KAKABAT' },
	[0x17CF] = { unicodeslot=0x17CF, category='mn', description='KHMER SIGN AHSDA' },
	[0x17D0] = { unicodeslot=0x17D0, category='mn', description='KHMER SIGN SAMYOK SANNYA' },
	[0x17D1] = { unicodeslot=0x17D1, category='mn', description='KHMER SIGN VIRIAM' },
	[0x17D2] = { unicodeslot=0x17D2, category='mn', description='KHMER SIGN COENG' },
	[0x17D3] = { unicodeslot=0x17D3, category='mn', description='KHMER SIGN BATHAMASAT' },
	[0x17D4] = { unicodeslot=0x17D4, category='po', description='KHMER SIGN KHAN' },
	[0x17D5] = { unicodeslot=0x17D5, category='po', description='KHMER SIGN BARIYOOSAN' },
	[0x17D6] = { unicodeslot=0x17D6, category='po', description='KHMER SIGN CAMNUC PII KUUH' },
	[0x17D7] = { unicodeslot=0x17D7, category='lm', description='KHMER SIGN LEK TOO' },
	[0x17D8] = { unicodeslot=0x17D8, category='po', description='KHMER SIGN BEYYAL' },
	[0x17D9] = { unicodeslot=0x17D9, category='po', description='KHMER SIGN PHNAEK MUAN' },
	[0x17DA] = { unicodeslot=0x17DA, category='po', description='KHMER SIGN KOOMUUT' },
	[0x17DB] = { unicodeslot=0x17DB, category='sc', description='KHMER CURRENCY SYMBOL RIEL' },
	[0x17DC] = { unicodeslot=0x17DC, category='lo', description='KHMER SIGN AVAKRAHASANYA' },
	[0x17DD] = { unicodeslot=0x17DD, category='mn', description='KHMER SIGN ATTHACAN' },
	[0x17E0] = { unicodeslot=0x17E0, category='nd', description='KHMER DIGIT ZERO' },
	[0x17E1] = { unicodeslot=0x17E1, category='nd', description='KHMER DIGIT ONE' },
	[0x17E2] = { unicodeslot=0x17E2, category='nd', description='KHMER DIGIT TWO' },
	[0x17E3] = { unicodeslot=0x17E3, category='nd', description='KHMER DIGIT THREE' },
	[0x17E4] = { unicodeslot=0x17E4, category='nd', description='KHMER DIGIT FOUR' },
	[0x17E5] = { unicodeslot=0x17E5, category='nd', description='KHMER DIGIT FIVE' },
	[0x17E6] = { unicodeslot=0x17E6, category='nd', description='KHMER DIGIT SIX' },
	[0x17E7] = { unicodeslot=0x17E7, category='nd', description='KHMER DIGIT SEVEN' },
	[0x17E8] = { unicodeslot=0x17E8, category='nd', description='KHMER DIGIT EIGHT' },
	[0x17E9] = { unicodeslot=0x17E9, category='nd', description='KHMER DIGIT NINE' },
	[0x17F0] = { unicodeslot=0x17F0, category='no', description='KHMER SYMBOL LEK ATTAK SON' },
	[0x17F1] = { unicodeslot=0x17F1, category='no', description='KHMER SYMBOL LEK ATTAK MUOY' },
	[0x17F2] = { unicodeslot=0x17F2, category='no', description='KHMER SYMBOL LEK ATTAK PII' },
	[0x17F3] = { unicodeslot=0x17F3, category='no', description='KHMER SYMBOL LEK ATTAK BEI' },
	[0x17F4] = { unicodeslot=0x17F4, category='no', description='KHMER SYMBOL LEK ATTAK BUON' },
	[0x17F5] = { unicodeslot=0x17F5, category='no', description='KHMER SYMBOL LEK ATTAK PRAM' },
	[0x17F6] = { unicodeslot=0x17F6, category='no', description='KHMER SYMBOL LEK ATTAK PRAM-MUOY' },
	[0x17F7] = { unicodeslot=0x17F7, category='no', description='KHMER SYMBOL LEK ATTAK PRAM-PII' },
	[0x17F8] = { unicodeslot=0x17F8, category='no', description='KHMER SYMBOL LEK ATTAK PRAM-BEI' },
	[0x17F9] = { unicodeslot=0x17F9, category='no', description='KHMER SYMBOL LEK ATTAK PRAM-BUON' },
	[0x1800] = { unicodeslot=0x1800, category='po', description='MONGOLIAN BIRGA' },
	[0x1801] = { unicodeslot=0x1801, category='po', description='MONGOLIAN ELLIPSIS' },
	[0x1802] = { unicodeslot=0x1802, category='po', description='MONGOLIAN COMMA' },
	[0x1803] = { unicodeslot=0x1803, category='po', description='MONGOLIAN FULL STOP' },
	[0x1804] = { unicodeslot=0x1804, category='po', description='MONGOLIAN COLON' },
	[0x1805] = { unicodeslot=0x1805, category='po', description='MONGOLIAN FOUR DOTS' },
	[0x1806] = { unicodeslot=0x1806, category='pd', description='MONGOLIAN TODO SOFT HYPHEN' },
	[0x1807] = { unicodeslot=0x1807, category='po', description='MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER' },
	[0x1808] = { unicodeslot=0x1808, category='po', description='MONGOLIAN MANCHU COMMA' },
	[0x1809] = { unicodeslot=0x1809, category='po', description='MONGOLIAN MANCHU FULL STOP' },
	[0x180A] = { unicodeslot=0x180A, category='po', description='MONGOLIAN NIRUGU' },
	[0x180B] = { unicodeslot=0x180B, category='mn', description='MONGOLIAN FREE VARIATION SELECTOR ONE' },
	[0x180C] = { unicodeslot=0x180C, category='mn', description='MONGOLIAN FREE VARIATION SELECTOR TWO' },
	[0x180D] = { unicodeslot=0x180D, category='mn', description='MONGOLIAN FREE VARIATION SELECTOR THREE' },
	[0x180E] = { unicodeslot=0x180E, category='zs', description='MONGOLIAN VOWEL SEPARATOR' },
	[0x1810] = { unicodeslot=0x1810, category='nd', description='MONGOLIAN DIGIT ZERO' },
	[0x1811] = { unicodeslot=0x1811, category='nd', description='MONGOLIAN DIGIT ONE' },
	[0x1812] = { unicodeslot=0x1812, category='nd', description='MONGOLIAN DIGIT TWO' },
	[0x1813] = { unicodeslot=0x1813, category='nd', description='MONGOLIAN DIGIT THREE' },
	[0x1814] = { unicodeslot=0x1814, category='nd', description='MONGOLIAN DIGIT FOUR' },
	[0x1815] = { unicodeslot=0x1815, category='nd', description='MONGOLIAN DIGIT FIVE' },
	[0x1816] = { unicodeslot=0x1816, category='nd', description='MONGOLIAN DIGIT SIX' },
	[0x1817] = { unicodeslot=0x1817, category='nd', description='MONGOLIAN DIGIT SEVEN' },
	[0x1818] = { unicodeslot=0x1818, category='nd', description='MONGOLIAN DIGIT EIGHT' },
	[0x1819] = { unicodeslot=0x1819, category='nd', description='MONGOLIAN DIGIT NINE' },
	[0x1820] = { unicodeslot=0x1820, category='lo', description='MONGOLIAN LETTER A' },
	[0x1821] = { unicodeslot=0x1821, category='lo', description='MONGOLIAN LETTER E' },
	[0x1822] = { unicodeslot=0x1822, category='lo', description='MONGOLIAN LETTER I' },
	[0x1823] = { unicodeslot=0x1823, category='lo', description='MONGOLIAN LETTER O' },
	[0x1824] = { unicodeslot=0x1824, category='lo', description='MONGOLIAN LETTER U' },
	[0x1825] = { unicodeslot=0x1825, category='lo', description='MONGOLIAN LETTER OE' },
	[0x1826] = { unicodeslot=0x1826, category='lo', description='MONGOLIAN LETTER UE' },
	[0x1827] = { unicodeslot=0x1827, category='lo', description='MONGOLIAN LETTER EE' },
	[0x1828] = { unicodeslot=0x1828, category='lo', description='MONGOLIAN LETTER NA' },
	[0x1829] = { unicodeslot=0x1829, category='lo', description='MONGOLIAN LETTER ANG' },
	[0x182A] = { unicodeslot=0x182A, category='lo', description='MONGOLIAN LETTER BA' },
	[0x182B] = { unicodeslot=0x182B, category='lo', description='MONGOLIAN LETTER PA' },
	[0x182C] = { unicodeslot=0x182C, category='lo', description='MONGOLIAN LETTER QA' },
	[0x182D] = { unicodeslot=0x182D, category='lo', description='MONGOLIAN LETTER GA' },
	[0x182E] = { unicodeslot=0x182E, category='lo', description='MONGOLIAN LETTER MA' },
	[0x182F] = { unicodeslot=0x182F, category='lo', description='MONGOLIAN LETTER LA' },
	[0x1830] = { unicodeslot=0x1830, category='lo', description='MONGOLIAN LETTER SA' },
	[0x1831] = { unicodeslot=0x1831, category='lo', description='MONGOLIAN LETTER SHA' },
	[0x1832] = { unicodeslot=0x1832, category='lo', description='MONGOLIAN LETTER TA' },
	[0x1833] = { unicodeslot=0x1833, category='lo', description='MONGOLIAN LETTER DA' },
	[0x1834] = { unicodeslot=0x1834, category='lo', description='MONGOLIAN LETTER CHA' },
	[0x1835] = { unicodeslot=0x1835, category='lo', description='MONGOLIAN LETTER JA' },
	[0x1836] = { unicodeslot=0x1836, category='lo', description='MONGOLIAN LETTER YA' },
	[0x1837] = { unicodeslot=0x1837, category='lo', description='MONGOLIAN LETTER RA' },
	[0x1838] = { unicodeslot=0x1838, category='lo', description='MONGOLIAN LETTER WA' },
	[0x1839] = { unicodeslot=0x1839, category='lo', description='MONGOLIAN LETTER FA' },
	[0x183A] = { unicodeslot=0x183A, category='lo', description='MONGOLIAN LETTER KA' },
	[0x183B] = { unicodeslot=0x183B, category='lo', description='MONGOLIAN LETTER KHA' },
	[0x183C] = { unicodeslot=0x183C, category='lo', description='MONGOLIAN LETTER TSA' },
	[0x183D] = { unicodeslot=0x183D, category='lo', description='MONGOLIAN LETTER ZA' },
	[0x183E] = { unicodeslot=0x183E, category='lo', description='MONGOLIAN LETTER HAA' },
	[0x183F] = { unicodeslot=0x183F, category='lo', description='MONGOLIAN LETTER ZRA' },
	[0x1840] = { unicodeslot=0x1840, category='lo', description='MONGOLIAN LETTER LHA' },
	[0x1841] = { unicodeslot=0x1841, category='lo', description='MONGOLIAN LETTER ZHI' },
	[0x1842] = { unicodeslot=0x1842, category='lo', description='MONGOLIAN LETTER CHI' },
	[0x1843] = { unicodeslot=0x1843, category='lm', description='MONGOLIAN LETTER TODO LONG VOWEL SIGN' },
	[0x1844] = { unicodeslot=0x1844, category='lo', description='MONGOLIAN LETTER TODO E' },
	[0x1845] = { unicodeslot=0x1845, category='lo', description='MONGOLIAN LETTER TODO I' },
	[0x1846] = { unicodeslot=0x1846, category='lo', description='MONGOLIAN LETTER TODO O' },
	[0x1847] = { unicodeslot=0x1847, category='lo', description='MONGOLIAN LETTER TODO U' },
	[0x1848] = { unicodeslot=0x1848, category='lo', description='MONGOLIAN LETTER TODO OE' },
	[0x1849] = { unicodeslot=0x1849, category='lo', description='MONGOLIAN LETTER TODO UE' },
	[0x184A] = { unicodeslot=0x184A, category='lo', description='MONGOLIAN LETTER TODO ANG' },
	[0x184B] = { unicodeslot=0x184B, category='lo', description='MONGOLIAN LETTER TODO BA' },
	[0x184C] = { unicodeslot=0x184C, category='lo', description='MONGOLIAN LETTER TODO PA' },
	[0x184D] = { unicodeslot=0x184D, category='lo', description='MONGOLIAN LETTER TODO QA' },
	[0x184E] = { unicodeslot=0x184E, category='lo', description='MONGOLIAN LETTER TODO GA' },
	[0x184F] = { unicodeslot=0x184F, category='lo', description='MONGOLIAN LETTER TODO MA' },
	[0x1850] = { unicodeslot=0x1850, category='lo', description='MONGOLIAN LETTER TODO TA' },
	[0x1851] = { unicodeslot=0x1851, category='lo', description='MONGOLIAN LETTER TODO DA' },
	[0x1852] = { unicodeslot=0x1852, category='lo', description='MONGOLIAN LETTER TODO CHA' },
	[0x1853] = { unicodeslot=0x1853, category='lo', description='MONGOLIAN LETTER TODO JA' },
	[0x1854] = { unicodeslot=0x1854, category='lo', description='MONGOLIAN LETTER TODO TSA' },
	[0x1855] = { unicodeslot=0x1855, category='lo', description='MONGOLIAN LETTER TODO YA' },
	[0x1856] = { unicodeslot=0x1856, category='lo', description='MONGOLIAN LETTER TODO WA' },
	[0x1857] = { unicodeslot=0x1857, category='lo', description='MONGOLIAN LETTER TODO KA' },
	[0x1858] = { unicodeslot=0x1858, category='lo', description='MONGOLIAN LETTER TODO GAA' },
	[0x1859] = { unicodeslot=0x1859, category='lo', description='MONGOLIAN LETTER TODO HAA' },
	[0x185A] = { unicodeslot=0x185A, category='lo', description='MONGOLIAN LETTER TODO JIA' },
	[0x185B] = { unicodeslot=0x185B, category='lo', description='MONGOLIAN LETTER TODO NIA' },
	[0x185C] = { unicodeslot=0x185C, category='lo', description='MONGOLIAN LETTER TODO DZA' },
	[0x185D] = { unicodeslot=0x185D, category='lo', description='MONGOLIAN LETTER SIBE E' },
	[0x185E] = { unicodeslot=0x185E, category='lo', description='MONGOLIAN LETTER SIBE I' },
	[0x185F] = { unicodeslot=0x185F, category='lo', description='MONGOLIAN LETTER SIBE IY' },
	[0x1860] = { unicodeslot=0x1860, category='lo', description='MONGOLIAN LETTER SIBE UE' },
	[0x1861] = { unicodeslot=0x1861, category='lo', description='MONGOLIAN LETTER SIBE U' },
	[0x1862] = { unicodeslot=0x1862, category='lo', description='MONGOLIAN LETTER SIBE ANG' },
	[0x1863] = { unicodeslot=0x1863, category='lo', description='MONGOLIAN LETTER SIBE KA' },
	[0x1864] = { unicodeslot=0x1864, category='lo', description='MONGOLIAN LETTER SIBE GA' },
	[0x1865] = { unicodeslot=0x1865, category='lo', description='MONGOLIAN LETTER SIBE HA' },
	[0x1866] = { unicodeslot=0x1866, category='lo', description='MONGOLIAN LETTER SIBE PA' },
	[0x1867] = { unicodeslot=0x1867, category='lo', description='MONGOLIAN LETTER SIBE SHA' },
	[0x1868] = { unicodeslot=0x1868, category='lo', description='MONGOLIAN LETTER SIBE TA' },
	[0x1869] = { unicodeslot=0x1869, category='lo', description='MONGOLIAN LETTER SIBE DA' },
	[0x186A] = { unicodeslot=0x186A, category='lo', description='MONGOLIAN LETTER SIBE JA' },
	[0x186B] = { unicodeslot=0x186B, category='lo', description='MONGOLIAN LETTER SIBE FA' },
	[0x186C] = { unicodeslot=0x186C, category='lo', description='MONGOLIAN LETTER SIBE GAA' },
	[0x186D] = { unicodeslot=0x186D, category='lo', description='MONGOLIAN LETTER SIBE HAA' },
	[0x186E] = { unicodeslot=0x186E, category='lo', description='MONGOLIAN LETTER SIBE TSA' },
	[0x186F] = { unicodeslot=0x186F, category='lo', description='MONGOLIAN LETTER SIBE ZA' },
	[0x1870] = { unicodeslot=0x1870, category='lo', description='MONGOLIAN LETTER SIBE RAA' },
	[0x1871] = { unicodeslot=0x1871, category='lo', description='MONGOLIAN LETTER SIBE CHA' },
	[0x1872] = { unicodeslot=0x1872, category='lo', description='MONGOLIAN LETTER SIBE ZHA' },
	[0x1873] = { unicodeslot=0x1873, category='lo', description='MONGOLIAN LETTER MANCHU I' },
	[0x1874] = { unicodeslot=0x1874, category='lo', description='MONGOLIAN LETTER MANCHU KA' },
	[0x1875] = { unicodeslot=0x1875, category='lo', description='MONGOLIAN LETTER MANCHU RA' },
	[0x1876] = { unicodeslot=0x1876, category='lo', description='MONGOLIAN LETTER MANCHU FA' },
	[0x1877] = { unicodeslot=0x1877, category='lo', description='MONGOLIAN LETTER MANCHU ZHA' },
	[0x1880] = { unicodeslot=0x1880, category='lo', description='MONGOLIAN LETTER ALI GALI ANUSVARA ONE' },
	[0x1881] = { unicodeslot=0x1881, category='lo', description='MONGOLIAN LETTER ALI GALI VISARGA ONE' },
	[0x1882] = { unicodeslot=0x1882, category='lo', description='MONGOLIAN LETTER ALI GALI DAMARU' },
	[0x1883] = { unicodeslot=0x1883, category='lo', description='MONGOLIAN LETTER ALI GALI UBADAMA' },
	[0x1884] = { unicodeslot=0x1884, category='lo', description='MONGOLIAN LETTER ALI GALI INVERTED UBADAMA' },
	[0x1885] = { unicodeslot=0x1885, category='lo', description='MONGOLIAN LETTER ALI GALI BALUDA' },
	[0x1886] = { unicodeslot=0x1886, category='lo', description='MONGOLIAN LETTER ALI GALI THREE BALUDA' },
	[0x1887] = { unicodeslot=0x1887, category='lo', description='MONGOLIAN LETTER ALI GALI A' },
	[0x1888] = { unicodeslot=0x1888, category='lo', description='MONGOLIAN LETTER ALI GALI I' },
	[0x1889] = { unicodeslot=0x1889, category='lo', description='MONGOLIAN LETTER ALI GALI KA' },
	[0x188A] = { unicodeslot=0x188A, category='lo', description='MONGOLIAN LETTER ALI GALI NGA' },
	[0x188B] = { unicodeslot=0x188B, category='lo', description='MONGOLIAN LETTER ALI GALI CA' },
	[0x188C] = { unicodeslot=0x188C, category='lo', description='MONGOLIAN LETTER ALI GALI TTA' },
	[0x188D] = { unicodeslot=0x188D, category='lo', description='MONGOLIAN LETTER ALI GALI TTHA' },
	[0x188E] = { unicodeslot=0x188E, category='lo', description='MONGOLIAN LETTER ALI GALI DDA' },
	[0x188F] = { unicodeslot=0x188F, category='lo', description='MONGOLIAN LETTER ALI GALI NNA' },
	[0x1890] = { unicodeslot=0x1890, category='lo', description='MONGOLIAN LETTER ALI GALI TA' },
	[0x1891] = { unicodeslot=0x1891, category='lo', description='MONGOLIAN LETTER ALI GALI DA' },
	[0x1892] = { unicodeslot=0x1892, category='lo', description='MONGOLIAN LETTER ALI GALI PA' },
	[0x1893] = { unicodeslot=0x1893, category='lo', description='MONGOLIAN LETTER ALI GALI PHA' },
	[0x1894] = { unicodeslot=0x1894, category='lo', description='MONGOLIAN LETTER ALI GALI SSA' },
	[0x1895] = { unicodeslot=0x1895, category='lo', description='MONGOLIAN LETTER ALI GALI ZHA' },
	[0x1896] = { unicodeslot=0x1896, category='lo', description='MONGOLIAN LETTER ALI GALI ZA' },
	[0x1897] = { unicodeslot=0x1897, category='lo', description='MONGOLIAN LETTER ALI GALI AH' },
	[0x1898] = { unicodeslot=0x1898, category='lo', description='MONGOLIAN LETTER TODO ALI GALI TA' },
	[0x1899] = { unicodeslot=0x1899, category='lo', description='MONGOLIAN LETTER TODO ALI GALI ZHA' },
	[0x189A] = { unicodeslot=0x189A, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI GHA' },
	[0x189B] = { unicodeslot=0x189B, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI NGA' },
	[0x189C] = { unicodeslot=0x189C, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI CA' },
	[0x189D] = { unicodeslot=0x189D, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI JHA' },
	[0x189E] = { unicodeslot=0x189E, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI TTA' },
	[0x189F] = { unicodeslot=0x189F, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI DDHA' },
	[0x18A0] = { unicodeslot=0x18A0, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI TA' },
	[0x18A1] = { unicodeslot=0x18A1, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI DHA' },
	[0x18A2] = { unicodeslot=0x18A2, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI SSA' },
	[0x18A3] = { unicodeslot=0x18A3, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI CYA' },
	[0x18A4] = { unicodeslot=0x18A4, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI ZHA' },
	[0x18A5] = { unicodeslot=0x18A5, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI ZA' },
	[0x18A6] = { unicodeslot=0x18A6, category='lo', description='MONGOLIAN LETTER ALI GALI HALF U' },
	[0x18A7] = { unicodeslot=0x18A7, category='lo', description='MONGOLIAN LETTER ALI GALI HALF YA' },
	[0x18A8] = { unicodeslot=0x18A8, category='lo', description='MONGOLIAN LETTER MANCHU ALI GALI BHA' },
	[0x18A9] = { unicodeslot=0x18A9, category='mn', description='MONGOLIAN LETTER ALI GALI DAGALGA' },
	[0x1900] = { unicodeslot=0x1900, category='lo', description='LIMBU VOWEL-CARRIER LETTER' },
	[0x1901] = { unicodeslot=0x1901, category='lo', description='LIMBU LETTER KA' },
	[0x1902] = { unicodeslot=0x1902, category='lo', description='LIMBU LETTER KHA' },
	[0x1903] = { unicodeslot=0x1903, category='lo', description='LIMBU LETTER GA' },
	[0x1904] = { unicodeslot=0x1904, category='lo', description='LIMBU LETTER GHA' },
	[0x1905] = { unicodeslot=0x1905, category='lo', description='LIMBU LETTER NGA' },
	[0x1906] = { unicodeslot=0x1906, category='lo', description='LIMBU LETTER CA' },
	[0x1907] = { unicodeslot=0x1907, category='lo', description='LIMBU LETTER CHA' },
	[0x1908] = { unicodeslot=0x1908, category='lo', description='LIMBU LETTER JA' },
	[0x1909] = { unicodeslot=0x1909, category='lo', description='LIMBU LETTER JHA' },
	[0x190A] = { unicodeslot=0x190A, category='lo', description='LIMBU LETTER YAN' },
	[0x190B] = { unicodeslot=0x190B, category='lo', description='LIMBU LETTER TA' },
	[0x190C] = { unicodeslot=0x190C, category='lo', description='LIMBU LETTER THA' },
	[0x190D] = { unicodeslot=0x190D, category='lo', description='LIMBU LETTER DA' },
	[0x190E] = { unicodeslot=0x190E, category='lo', description='LIMBU LETTER DHA' },
	[0x190F] = { unicodeslot=0x190F, category='lo', description='LIMBU LETTER NA' },
	[0x1910] = { unicodeslot=0x1910, category='lo', description='LIMBU LETTER PA' },
	[0x1911] = { unicodeslot=0x1911, category='lo', description='LIMBU LETTER PHA' },
	[0x1912] = { unicodeslot=0x1912, category='lo', description='LIMBU LETTER BA' },
	[0x1913] = { unicodeslot=0x1913, category='lo', description='LIMBU LETTER BHA' },
	[0x1914] = { unicodeslot=0x1914, category='lo', description='LIMBU LETTER MA' },
	[0x1915] = { unicodeslot=0x1915, category='lo', description='LIMBU LETTER YA' },
	[0x1916] = { unicodeslot=0x1916, category='lo', description='LIMBU LETTER RA' },
	[0x1917] = { unicodeslot=0x1917, category='lo', description='LIMBU LETTER LA' },
	[0x1918] = { unicodeslot=0x1918, category='lo', description='LIMBU LETTER WA' },
	[0x1919] = { unicodeslot=0x1919, category='lo', description='LIMBU LETTER SHA' },
	[0x191A] = { unicodeslot=0x191A, category='lo', description='LIMBU LETTER SSA' },
	[0x191B] = { unicodeslot=0x191B, category='lo', description='LIMBU LETTER SA' },
	[0x191C] = { unicodeslot=0x191C, category='lo', description='LIMBU LETTER HA' },
	[0x1920] = { unicodeslot=0x1920, category='mn', description='LIMBU VOWEL SIGN A' },
	[0x1921] = { unicodeslot=0x1921, category='mn', description='LIMBU VOWEL SIGN I' },
	[0x1922] = { unicodeslot=0x1922, category='mn', description='LIMBU VOWEL SIGN U' },
	[0x1923] = { unicodeslot=0x1923, category='mc', description='LIMBU VOWEL SIGN EE' },
	[0x1924] = { unicodeslot=0x1924, category='mc', description='LIMBU VOWEL SIGN AI' },
	[0x1925] = { unicodeslot=0x1925, category='mc', description='LIMBU VOWEL SIGN OO' },
	[0x1926] = { unicodeslot=0x1926, category='mc', description='LIMBU VOWEL SIGN AU' },
	[0x1927] = { unicodeslot=0x1927, category='mn', description='LIMBU VOWEL SIGN E' },
	[0x1928] = { unicodeslot=0x1928, category='mn', description='LIMBU VOWEL SIGN O' },
	[0x1929] = { unicodeslot=0x1929, category='mc', description='LIMBU SUBJOINED LETTER YA' },
	[0x192A] = { unicodeslot=0x192A, category='mc', description='LIMBU SUBJOINED LETTER RA' },
	[0x192B] = { unicodeslot=0x192B, category='mc', description='LIMBU SUBJOINED LETTER WA' },
	[0x1930] = { unicodeslot=0x1930, category='mc', description='LIMBU SMALL LETTER KA' },
	[0x1931] = { unicodeslot=0x1931, category='mc', description='LIMBU SMALL LETTER NGA' },
	[0x1932] = { unicodeslot=0x1932, category='mn', description='LIMBU SMALL LETTER ANUSVARA' },
	[0x1933] = { unicodeslot=0x1933, category='mc', description='LIMBU SMALL LETTER TA' },
	[0x1934] = { unicodeslot=0x1934, category='mc', description='LIMBU SMALL LETTER NA' },
	[0x1935] = { unicodeslot=0x1935, category='mc', description='LIMBU SMALL LETTER PA' },
	[0x1936] = { unicodeslot=0x1936, category='mc', description='LIMBU SMALL LETTER MA' },
	[0x1937] = { unicodeslot=0x1937, category='mc', description='LIMBU SMALL LETTER RA' },
	[0x1938] = { unicodeslot=0x1938, category='mc', description='LIMBU SMALL LETTER LA' },
	[0x1939] = { unicodeslot=0x1939, category='mn', description='LIMBU SIGN MUKPHRENG' },
	[0x193A] = { unicodeslot=0x193A, category='mn', description='LIMBU SIGN KEMPHRENG' },
	[0x193B] = { unicodeslot=0x193B, category='mn', description='LIMBU SIGN SA-I' },
	[0x1940] = { unicodeslot=0x1940, category='so', description='LIMBU SIGN LOO' },
	[0x1944] = { unicodeslot=0x1944, category='po', description='LIMBU EXCLAMATION MARK' },
	[0x1945] = { unicodeslot=0x1945, category='po', description='LIMBU QUESTION MARK' },
	[0x1946] = { unicodeslot=0x1946, category='nd', description='LIMBU DIGIT ZERO' },
	[0x1947] = { unicodeslot=0x1947, category='nd', description='LIMBU DIGIT ONE' },
	[0x1948] = { unicodeslot=0x1948, category='nd', description='LIMBU DIGIT TWO' },
	[0x1949] = { unicodeslot=0x1949, category='nd', description='LIMBU DIGIT THREE' },
	[0x194A] = { unicodeslot=0x194A, category='nd', description='LIMBU DIGIT FOUR' },
	[0x194B] = { unicodeslot=0x194B, category='nd', description='LIMBU DIGIT FIVE' },
	[0x194C] = { unicodeslot=0x194C, category='nd', description='LIMBU DIGIT SIX' },
	[0x194D] = { unicodeslot=0x194D, category='nd', description='LIMBU DIGIT SEVEN' },
	[0x194E] = { unicodeslot=0x194E, category='nd', description='LIMBU DIGIT EIGHT' },
	[0x194F] = { unicodeslot=0x194F, category='nd', description='LIMBU DIGIT NINE' },
	[0x1950] = { unicodeslot=0x1950, category='lo', description='TAI LE LETTER KA' },
	[0x1951] = { unicodeslot=0x1951, category='lo', description='TAI LE LETTER XA' },
	[0x1952] = { unicodeslot=0x1952, category='lo', description='TAI LE LETTER NGA' },
	[0x1953] = { unicodeslot=0x1953, category='lo', description='TAI LE LETTER TSA' },
	[0x1954] = { unicodeslot=0x1954, category='lo', description='TAI LE LETTER SA' },
	[0x1955] = { unicodeslot=0x1955, category='lo', description='TAI LE LETTER YA' },
	[0x1956] = { unicodeslot=0x1956, category='lo', description='TAI LE LETTER TA' },
	[0x1957] = { unicodeslot=0x1957, category='lo', description='TAI LE LETTER THA' },
	[0x1958] = { unicodeslot=0x1958, category='lo', description='TAI LE LETTER LA' },
	[0x1959] = { unicodeslot=0x1959, category='lo', description='TAI LE LETTER PA' },
	[0x195A] = { unicodeslot=0x195A, category='lo', description='TAI LE LETTER PHA' },
	[0x195B] = { unicodeslot=0x195B, category='lo', description='TAI LE LETTER MA' },
	[0x195C] = { unicodeslot=0x195C, category='lo', description='TAI LE LETTER FA' },
	[0x195D] = { unicodeslot=0x195D, category='lo', description='TAI LE LETTER VA' },
	[0x195E] = { unicodeslot=0x195E, category='lo', description='TAI LE LETTER HA' },
	[0x195F] = { unicodeslot=0x195F, category='lo', description='TAI LE LETTER QA' },
	[0x1960] = { unicodeslot=0x1960, category='lo', description='TAI LE LETTER KHA' },
	[0x1961] = { unicodeslot=0x1961, category='lo', description='TAI LE LETTER TSHA' },
	[0x1962] = { unicodeslot=0x1962, category='lo', description='TAI LE LETTER NA' },
	[0x1963] = { unicodeslot=0x1963, category='lo', description='TAI LE LETTER A' },
	[0x1964] = { unicodeslot=0x1964, category='lo', description='TAI LE LETTER I' },
	[0x1965] = { unicodeslot=0x1965, category='lo', description='TAI LE LETTER EE' },
	[0x1966] = { unicodeslot=0x1966, category='lo', description='TAI LE LETTER EH' },
	[0x1967] = { unicodeslot=0x1967, category='lo', description='TAI LE LETTER U' },
	[0x1968] = { unicodeslot=0x1968, category='lo', description='TAI LE LETTER OO' },
	[0x1969] = { unicodeslot=0x1969, category='lo', description='TAI LE LETTER O' },
	[0x196A] = { unicodeslot=0x196A, category='lo', description='TAI LE LETTER UE' },
	[0x196B] = { unicodeslot=0x196B, category='lo', description='TAI LE LETTER E' },
	[0x196C] = { unicodeslot=0x196C, category='lo', description='TAI LE LETTER AUE' },
	[0x196D] = { unicodeslot=0x196D, category='lo', description='TAI LE LETTER AI' },
	[0x1970] = { unicodeslot=0x1970, category='lo', description='TAI LE LETTER TONE-2' },
	[0x1971] = { unicodeslot=0x1971, category='lo', description='TAI LE LETTER TONE-3' },
	[0x1972] = { unicodeslot=0x1972, category='lo', description='TAI LE LETTER TONE-4' },
	[0x1973] = { unicodeslot=0x1973, category='lo', description='TAI LE LETTER TONE-5' },
	[0x1974] = { unicodeslot=0x1974, category='lo', description='TAI LE LETTER TONE-6' },
	[0x1980] = { unicodeslot=0x1980, category='lo', description='NEW TAI LUE LETTER HIGH QA' },
	[0x1981] = { unicodeslot=0x1981, category='lo', description='NEW TAI LUE LETTER LOW QA' },
	[0x1982] = { unicodeslot=0x1982, category='lo', description='NEW TAI LUE LETTER HIGH KA' },
	[0x1983] = { unicodeslot=0x1983, category='lo', description='NEW TAI LUE LETTER HIGH XA' },
	[0x1984] = { unicodeslot=0x1984, category='lo', description='NEW TAI LUE LETTER HIGH NGA' },
	[0x1985] = { unicodeslot=0x1985, category='lo', description='NEW TAI LUE LETTER LOW KA' },
	[0x1986] = { unicodeslot=0x1986, category='lo', description='NEW TAI LUE LETTER LOW XA' },
	[0x1987] = { unicodeslot=0x1987, category='lo', description='NEW TAI LUE LETTER LOW NGA' },
	[0x1988] = { unicodeslot=0x1988, category='lo', description='NEW TAI LUE LETTER HIGH TSA' },
	[0x1989] = { unicodeslot=0x1989, category='lo', description='NEW TAI LUE LETTER HIGH SA' },
	[0x198A] = { unicodeslot=0x198A, category='lo', description='NEW TAI LUE LETTER HIGH YA' },
	[0x198B] = { unicodeslot=0x198B, category='lo', description='NEW TAI LUE LETTER LOW TSA' },
	[0x198C] = { unicodeslot=0x198C, category='lo', description='NEW TAI LUE LETTER LOW SA' },
	[0x198D] = { unicodeslot=0x198D, category='lo', description='NEW TAI LUE LETTER LOW YA' },
	[0x198E] = { unicodeslot=0x198E, category='lo', description='NEW TAI LUE LETTER HIGH TA' },
	[0x198F] = { unicodeslot=0x198F, category='lo', description='NEW TAI LUE LETTER HIGH THA' },
	[0x1990] = { unicodeslot=0x1990, category='lo', description='NEW TAI LUE LETTER HIGH NA' },
	[0x1991] = { unicodeslot=0x1991, category='lo', description='NEW TAI LUE LETTER LOW TA' },
	[0x1992] = { unicodeslot=0x1992, category='lo', description='NEW TAI LUE LETTER LOW THA' },
	[0x1993] = { unicodeslot=0x1993, category='lo', description='NEW TAI LUE LETTER LOW NA' },
	[0x1994] = { unicodeslot=0x1994, category='lo', description='NEW TAI LUE LETTER HIGH PA' },
	[0x1995] = { unicodeslot=0x1995, category='lo', description='NEW TAI LUE LETTER HIGH PHA' },
	[0x1996] = { unicodeslot=0x1996, category='lo', description='NEW TAI LUE LETTER HIGH MA' },
	[0x1997] = { unicodeslot=0x1997, category='lo', description='NEW TAI LUE LETTER LOW PA' },
	[0x1998] = { unicodeslot=0x1998, category='lo', description='NEW TAI LUE LETTER LOW PHA' },
	[0x1999] = { unicodeslot=0x1999, category='lo', description='NEW TAI LUE LETTER LOW MA' },
	[0x199A] = { unicodeslot=0x199A, category='lo', description='NEW TAI LUE LETTER HIGH FA' },
	[0x199B] = { unicodeslot=0x199B, category='lo', description='NEW TAI LUE LETTER HIGH VA' },
	[0x199C] = { unicodeslot=0x199C, category='lo', description='NEW TAI LUE LETTER HIGH LA' },
	[0x199D] = { unicodeslot=0x199D, category='lo', description='NEW TAI LUE LETTER LOW FA' },
	[0x199E] = { unicodeslot=0x199E, category='lo', description='NEW TAI LUE LETTER LOW VA' },
	[0x199F] = { unicodeslot=0x199F, category='lo', description='NEW TAI LUE LETTER LOW LA' },
	[0x19A0] = { unicodeslot=0x19A0, category='lo', description='NEW TAI LUE LETTER HIGH HA' },
	[0x19A1] = { unicodeslot=0x19A1, category='lo', description='NEW TAI LUE LETTER HIGH DA' },
	[0x19A2] = { unicodeslot=0x19A2, category='lo', description='NEW TAI LUE LETTER HIGH BA' },
	[0x19A3] = { unicodeslot=0x19A3, category='lo', description='NEW TAI LUE LETTER LOW HA' },
	[0x19A4] = { unicodeslot=0x19A4, category='lo', description='NEW TAI LUE LETTER LOW DA' },
	[0x19A5] = { unicodeslot=0x19A5, category='lo', description='NEW TAI LUE LETTER LOW BA' },
	[0x19A6] = { unicodeslot=0x19A6, category='lo', description='NEW TAI LUE LETTER HIGH KVA' },
	[0x19A7] = { unicodeslot=0x19A7, category='lo', description='NEW TAI LUE LETTER HIGH XVA' },
	[0x19A8] = { unicodeslot=0x19A8, category='lo', description='NEW TAI LUE LETTER LOW KVA' },
	[0x19A9] = { unicodeslot=0x19A9, category='lo', description='NEW TAI LUE LETTER LOW XVA' },
	[0x19B0] = { unicodeslot=0x19B0, category='mc', description='NEW TAI LUE VOWEL SIGN VOWEL SHORTENER' },
	[0x19B1] = { unicodeslot=0x19B1, category='mc', description='NEW TAI LUE VOWEL SIGN AA' },
	[0x19B2] = { unicodeslot=0x19B2, category='mc', description='NEW TAI LUE VOWEL SIGN II' },
	[0x19B3] = { unicodeslot=0x19B3, category='mc', description='NEW TAI LUE VOWEL SIGN U' },
	[0x19B4] = { unicodeslot=0x19B4, category='mc', description='NEW TAI LUE VOWEL SIGN UU' },
	[0x19B5] = { unicodeslot=0x19B5, category='mc', description='NEW TAI LUE VOWEL SIGN E' },
	[0x19B6] = { unicodeslot=0x19B6, category='mc', description='NEW TAI LUE VOWEL SIGN AE' },
	[0x19B7] = { unicodeslot=0x19B7, category='mc', description='NEW TAI LUE VOWEL SIGN O' },
	[0x19B8] = { unicodeslot=0x19B8, category='mc', description='NEW TAI LUE VOWEL SIGN OA' },
	[0x19B9] = { unicodeslot=0x19B9, category='mc', description='NEW TAI LUE VOWEL SIGN UE' },
	[0x19BA] = { unicodeslot=0x19BA, category='mc', description='NEW TAI LUE VOWEL SIGN AY' },
	[0x19BB] = { unicodeslot=0x19BB, category='mc', description='NEW TAI LUE VOWEL SIGN AAY' },
	[0x19BC] = { unicodeslot=0x19BC, category='mc', description='NEW TAI LUE VOWEL SIGN UY' },
	[0x19BD] = { unicodeslot=0x19BD, category='mc', description='NEW TAI LUE VOWEL SIGN OY' },
	[0x19BE] = { unicodeslot=0x19BE, category='mc', description='NEW TAI LUE VOWEL SIGN OAY' },
	[0x19BF] = { unicodeslot=0x19BF, category='mc', description='NEW TAI LUE VOWEL SIGN UEY' },
	[0x19C0] = { unicodeslot=0x19C0, category='mc', description='NEW TAI LUE VOWEL SIGN IY' },
	[0x19C1] = { unicodeslot=0x19C1, category='lo', description='NEW TAI LUE LETTER FINAL V' },
	[0x19C2] = { unicodeslot=0x19C2, category='lo', description='NEW TAI LUE LETTER FINAL NG' },
	[0x19C3] = { unicodeslot=0x19C3, category='lo', description='NEW TAI LUE LETTER FINAL N' },
	[0x19C4] = { unicodeslot=0x19C4, category='lo', description='NEW TAI LUE LETTER FINAL M' },
	[0x19C5] = { unicodeslot=0x19C5, category='lo', description='NEW TAI LUE LETTER FINAL K' },
	[0x19C6] = { unicodeslot=0x19C6, category='lo', description='NEW TAI LUE LETTER FINAL D' },
	[0x19C7] = { unicodeslot=0x19C7, category='lo', description='NEW TAI LUE LETTER FINAL B' },
	[0x19C8] = { unicodeslot=0x19C8, category='mc', description='NEW TAI LUE TONE MARK-1' },
	[0x19C9] = { unicodeslot=0x19C9, category='mc', description='NEW TAI LUE TONE MARK-2' },
	[0x19D0] = { unicodeslot=0x19D0, category='nd', description='NEW TAI LUE DIGIT ZERO' },
	[0x19D1] = { unicodeslot=0x19D1, category='nd', description='NEW TAI LUE DIGIT ONE' },
	[0x19D2] = { unicodeslot=0x19D2, category='nd', description='NEW TAI LUE DIGIT TWO' },
	[0x19D3] = { unicodeslot=0x19D3, category='nd', description='NEW TAI LUE DIGIT THREE' },
	[0x19D4] = { unicodeslot=0x19D4, category='nd', description='NEW TAI LUE DIGIT FOUR' },
	[0x19D5] = { unicodeslot=0x19D5, category='nd', description='NEW TAI LUE DIGIT FIVE' },
	[0x19D6] = { unicodeslot=0x19D6, category='nd', description='NEW TAI LUE DIGIT SIX' },
	[0x19D7] = { unicodeslot=0x19D7, category='nd', description='NEW TAI LUE DIGIT SEVEN' },
	[0x19D8] = { unicodeslot=0x19D8, category='nd', description='NEW TAI LUE DIGIT EIGHT' },
	[0x19D9] = { unicodeslot=0x19D9, category='nd', description='NEW TAI LUE DIGIT NINE' },
	[0x19DE] = { unicodeslot=0x19DE, category='po', description='NEW TAI LUE SIGN LAE' },
	[0x19DF] = { unicodeslot=0x19DF, category='po', description='NEW TAI LUE SIGN LAEV' },
	[0x19E0] = { unicodeslot=0x19E0, category='so', description='KHMER SYMBOL PATHAMASAT' },
	[0x19E1] = { unicodeslot=0x19E1, category='so', description='KHMER SYMBOL MUOY KOET' },
	[0x19E2] = { unicodeslot=0x19E2, category='so', description='KHMER SYMBOL PII KOET' },
	[0x19E3] = { unicodeslot=0x19E3, category='so', description='KHMER SYMBOL BEI KOET' },
	[0x19E4] = { unicodeslot=0x19E4, category='so', description='KHMER SYMBOL BUON KOET' },
	[0x19E5] = { unicodeslot=0x19E5, category='so', description='KHMER SYMBOL PRAM KOET' },
	[0x19E6] = { unicodeslot=0x19E6, category='so', description='KHMER SYMBOL PRAM-MUOY KOET' },
	[0x19E7] = { unicodeslot=0x19E7, category='so', description='KHMER SYMBOL PRAM-PII KOET' },
	[0x19E8] = { unicodeslot=0x19E8, category='so', description='KHMER SYMBOL PRAM-BEI KOET' },
	[0x19E9] = { unicodeslot=0x19E9, category='so', description='KHMER SYMBOL PRAM-BUON KOET' },
	[0x19EA] = { unicodeslot=0x19EA, category='so', description='KHMER SYMBOL DAP KOET' },
	[0x19EB] = { unicodeslot=0x19EB, category='so', description='KHMER SYMBOL DAP-MUOY KOET' },
	[0x19EC] = { unicodeslot=0x19EC, category='so', description='KHMER SYMBOL DAP-PII KOET' },
	[0x19ED] = { unicodeslot=0x19ED, category='so', description='KHMER SYMBOL DAP-BEI KOET' },
	[0x19EE] = { unicodeslot=0x19EE, category='so', description='KHMER SYMBOL DAP-BUON KOET' },
	[0x19EF] = { unicodeslot=0x19EF, category='so', description='KHMER SYMBOL DAP-PRAM KOET' },
	[0x19F0] = { unicodeslot=0x19F0, category='so', description='KHMER SYMBOL TUTEYASAT' },
	[0x19F1] = { unicodeslot=0x19F1, category='so', description='KHMER SYMBOL MUOY ROC' },
	[0x19F2] = { unicodeslot=0x19F2, category='so', description='KHMER SYMBOL PII ROC' },
	[0x19F3] = { unicodeslot=0x19F3, category='so', description='KHMER SYMBOL BEI ROC' },
	[0x19F4] = { unicodeslot=0x19F4, category='so', description='KHMER SYMBOL BUON ROC' },
	[0x19F5] = { unicodeslot=0x19F5, category='so', description='KHMER SYMBOL PRAM ROC' },
	[0x19F6] = { unicodeslot=0x19F6, category='so', description='KHMER SYMBOL PRAM-MUOY ROC' },
	[0x19F7] = { unicodeslot=0x19F7, category='so', description='KHMER SYMBOL PRAM-PII ROC' },
	[0x19F8] = { unicodeslot=0x19F8, category='so', description='KHMER SYMBOL PRAM-BEI ROC' },
	[0x19F9] = { unicodeslot=0x19F9, category='so', description='KHMER SYMBOL PRAM-BUON ROC' },
	[0x19FA] = { unicodeslot=0x19FA, category='so', description='KHMER SYMBOL DAP ROC' },
	[0x19FB] = { unicodeslot=0x19FB, category='so', description='KHMER SYMBOL DAP-MUOY ROC' },
	[0x19FC] = { unicodeslot=0x19FC, category='so', description='KHMER SYMBOL DAP-PII ROC' },
	[0x19FD] = { unicodeslot=0x19FD, category='so', description='KHMER SYMBOL DAP-BEI ROC' },
	[0x19FE] = { unicodeslot=0x19FE, category='so', description='KHMER SYMBOL DAP-BUON ROC' },
	[0x19FF] = { unicodeslot=0x19FF, category='so', description='KHMER SYMBOL DAP-PRAM ROC' },
	[0x1A00] = { unicodeslot=0x1A00, category='lo', description='BUGINESE LETTER KA' },
	[0x1A01] = { unicodeslot=0x1A01, category='lo', description='BUGINESE LETTER GA' },
	[0x1A02] = { unicodeslot=0x1A02, category='lo', description='BUGINESE LETTER NGA' },
	[0x1A03] = { unicodeslot=0x1A03, category='lo', description='BUGINESE LETTER NGKA' },
	[0x1A04] = { unicodeslot=0x1A04, category='lo', description='BUGINESE LETTER PA' },
	[0x1A05] = { unicodeslot=0x1A05, category='lo', description='BUGINESE LETTER BA' },
	[0x1A06] = { unicodeslot=0x1A06, category='lo', description='BUGINESE LETTER MA' },
	[0x1A07] = { unicodeslot=0x1A07, category='lo', description='BUGINESE LETTER MPA' },
	[0x1A08] = { unicodeslot=0x1A08, category='lo', description='BUGINESE LETTER TA' },
	[0x1A09] = { unicodeslot=0x1A09, category='lo', description='BUGINESE LETTER DA' },
	[0x1A0A] = { unicodeslot=0x1A0A, category='lo', description='BUGINESE LETTER NA' },
	[0x1A0B] = { unicodeslot=0x1A0B, category='lo', description='BUGINESE LETTER NRA' },
	[0x1A0C] = { unicodeslot=0x1A0C, category='lo', description='BUGINESE LETTER CA' },
	[0x1A0D] = { unicodeslot=0x1A0D, category='lo', description='BUGINESE LETTER JA' },
	[0x1A0E] = { unicodeslot=0x1A0E, category='lo', description='BUGINESE LETTER NYA' },
	[0x1A0F] = { unicodeslot=0x1A0F, category='lo', description='BUGINESE LETTER NYCA' },
	[0x1A10] = { unicodeslot=0x1A10, category='lo', description='BUGINESE LETTER YA' },
	[0x1A11] = { unicodeslot=0x1A11, category='lo', description='BUGINESE LETTER RA' },
	[0x1A12] = { unicodeslot=0x1A12, category='lo', description='BUGINESE LETTER LA' },
	[0x1A13] = { unicodeslot=0x1A13, category='lo', description='BUGINESE LETTER VA' },
	[0x1A14] = { unicodeslot=0x1A14, category='lo', description='BUGINESE LETTER SA' },
	[0x1A15] = { unicodeslot=0x1A15, category='lo', description='BUGINESE LETTER A' },
	[0x1A16] = { unicodeslot=0x1A16, category='lo', description='BUGINESE LETTER HA' },
	[0x1A17] = { unicodeslot=0x1A17, category='mn', description='BUGINESE VOWEL SIGN I' },
	[0x1A18] = { unicodeslot=0x1A18, category='mn', description='BUGINESE VOWEL SIGN U' },
	[0x1A19] = { unicodeslot=0x1A19, category='mc', description='BUGINESE VOWEL SIGN E' },
	[0x1A1A] = { unicodeslot=0x1A1A, category='mc', description='BUGINESE VOWEL SIGN O' },
	[0x1A1B] = { unicodeslot=0x1A1B, category='mc', description='BUGINESE VOWEL SIGN AE' },
	[0x1A1E] = { unicodeslot=0x1A1E, category='po', description='BUGINESE PALLAWA' },
	[0x1A1F] = { unicodeslot=0x1A1F, category='po', description='BUGINESE END OF SECTION' },
	[0x1B00] = { unicodeslot=0x1B00, category='mn', description='BALINESE SIGN ULU RICEM' },
	[0x1B01] = { unicodeslot=0x1B01, category='mn', description='BALINESE SIGN ULU CANDRA' },
	[0x1B02] = { unicodeslot=0x1B02, category='mn', description='BALINESE SIGN CECEK' },
	[0x1B03] = { unicodeslot=0x1B03, category='mn', description='BALINESE SIGN SURANG' },
	[0x1B04] = { unicodeslot=0x1B04, category='mc', description='BALINESE SIGN BISAH' },
	[0x1B05] = { unicodeslot=0x1B05, category='lo', description='BALINESE LETTER AKARA' },
	[0x1B06] = { unicodeslot=0x1B06, category='lo', description='BALINESE LETTER AKARA TEDUNG', specials={'char',0x1B05,0x1B35} },
	[0x1B07] = { unicodeslot=0x1B07, category='lo', description='BALINESE LETTER IKARA' },
	[0x1B08] = { unicodeslot=0x1B08, category='lo', description='BALINESE LETTER IKARA TEDUNG', specials={'char',0x1B07,0x1B35} },
	[0x1B09] = { unicodeslot=0x1B09, category='lo', description='BALINESE LETTER UKARA' },
	[0x1B0A] = { unicodeslot=0x1B0A, category='lo', description='BALINESE LETTER UKARA TEDUNG', specials={'char',0x1B09,0x1B35} },
	[0x1B0B] = { unicodeslot=0x1B0B, category='lo', description='BALINESE LETTER RA REPA' },
	[0x1B0C] = { unicodeslot=0x1B0C, category='lo', description='BALINESE LETTER RA REPA TEDUNG', specials={'char',0x1B0B,0x1B35} },
	[0x1B0D] = { unicodeslot=0x1B0D, category='lo', description='BALINESE LETTER LA LENGA' },
	[0x1B0E] = { unicodeslot=0x1B0E, category='lo', description='BALINESE LETTER LA LENGA TEDUNG', specials={'char',0x1B0D,0x1B35} },
	[0x1B0F] = { unicodeslot=0x1B0F, category='lo', description='BALINESE LETTER EKARA' },
	[0x1B10] = { unicodeslot=0x1B10, category='lo', description='BALINESE LETTER AIKARA' },
	[0x1B11] = { unicodeslot=0x1B11, category='lo', description='BALINESE LETTER OKARA' },
	[0x1B12] = { unicodeslot=0x1B12, category='lo', description='BALINESE LETTER OKARA TEDUNG', specials={'char',0x1B11,0x1B35} },
	[0x1B13] = { unicodeslot=0x1B13, category='lo', description='BALINESE LETTER KA' },
	[0x1B14] = { unicodeslot=0x1B14, category='lo', description='BALINESE LETTER KA MAHAPRANA' },
	[0x1B15] = { unicodeslot=0x1B15, category='lo', description='BALINESE LETTER GA' },
	[0x1B16] = { unicodeslot=0x1B16, category='lo', description='BALINESE LETTER GA GORA' },
	[0x1B17] = { unicodeslot=0x1B17, category='lo', description='BALINESE LETTER NGA' },
	[0x1B18] = { unicodeslot=0x1B18, category='lo', description='BALINESE LETTER CA' },
	[0x1B19] = { unicodeslot=0x1B19, category='lo', description='BALINESE LETTER CA LACA' },
	[0x1B1A] = { unicodeslot=0x1B1A, category='lo', description='BALINESE LETTER JA' },
	[0x1B1B] = { unicodeslot=0x1B1B, category='lo', description='BALINESE LETTER JA JERA' },
	[0x1B1C] = { unicodeslot=0x1B1C, category='lo', description='BALINESE LETTER NYA' },
	[0x1B1D] = { unicodeslot=0x1B1D, category='lo', description='BALINESE LETTER TA LATIK' },
	[0x1B1E] = { unicodeslot=0x1B1E, category='lo', description='BALINESE LETTER TA MURDA MAHAPRANA' },
	[0x1B1F] = { unicodeslot=0x1B1F, category='lo', description='BALINESE LETTER DA MURDA ALPAPRANA' },
	[0x1B20] = { unicodeslot=0x1B20, category='lo', description='BALINESE LETTER DA MURDA MAHAPRANA' },
	[0x1B21] = { unicodeslot=0x1B21, category='lo', description='BALINESE LETTER NA RAMBAT' },
	[0x1B22] = { unicodeslot=0x1B22, category='lo', description='BALINESE LETTER TA' },
	[0x1B23] = { unicodeslot=0x1B23, category='lo', description='BALINESE LETTER TA TAWA' },
	[0x1B24] = { unicodeslot=0x1B24, category='lo', description='BALINESE LETTER DA' },
	[0x1B25] = { unicodeslot=0x1B25, category='lo', description='BALINESE LETTER DA MADU' },
	[0x1B26] = { unicodeslot=0x1B26, category='lo', description='BALINESE LETTER NA' },
	[0x1B27] = { unicodeslot=0x1B27, category='lo', description='BALINESE LETTER PA' },
	[0x1B28] = { unicodeslot=0x1B28, category='lo', description='BALINESE LETTER PA KAPAL' },
	[0x1B29] = { unicodeslot=0x1B29, category='lo', description='BALINESE LETTER BA' },
	[0x1B2A] = { unicodeslot=0x1B2A, category='lo', description='BALINESE LETTER BA KEMBANG' },
	[0x1B2B] = { unicodeslot=0x1B2B, category='lo', description='BALINESE LETTER MA' },
	[0x1B2C] = { unicodeslot=0x1B2C, category='lo', description='BALINESE LETTER YA' },
	[0x1B2D] = { unicodeslot=0x1B2D, category='lo', description='BALINESE LETTER RA' },
	[0x1B2E] = { unicodeslot=0x1B2E, category='lo', description='BALINESE LETTER LA' },
	[0x1B2F] = { unicodeslot=0x1B2F, category='lo', description='BALINESE LETTER WA' },
	[0x1B30] = { unicodeslot=0x1B30, category='lo', description='BALINESE LETTER SA SAGA' },
	[0x1B31] = { unicodeslot=0x1B31, category='lo', description='BALINESE LETTER SA SAPA' },
	[0x1B32] = { unicodeslot=0x1B32, category='lo', description='BALINESE LETTER SA' },
	[0x1B33] = { unicodeslot=0x1B33, category='lo', description='BALINESE LETTER HA' },
	[0x1B34] = { unicodeslot=0x1B34, category='mn', description='BALINESE SIGN REREKAN' },
	[0x1B35] = { unicodeslot=0x1B35, category='mc', description='BALINESE VOWEL SIGN TEDUNG' },
	[0x1B36] = { unicodeslot=0x1B36, category='mn', description='BALINESE VOWEL SIGN ULU' },
	[0x1B37] = { unicodeslot=0x1B37, category='mn', description='BALINESE VOWEL SIGN ULU SARI' },
	[0x1B38] = { unicodeslot=0x1B38, category='mn', description='BALINESE VOWEL SIGN SUKU' },
	[0x1B39] = { unicodeslot=0x1B39, category='mn', description='BALINESE VOWEL SIGN SUKU ILUT' },
	[0x1B3A] = { unicodeslot=0x1B3A, category='mn', description='BALINESE VOWEL SIGN RA REPA' },
	[0x1B3B] = { unicodeslot=0x1B3B, category='mc', description='BALINESE VOWEL SIGN RA REPA TEDUNG', specials={'char',0x1B3A,0x1B35} },
	[0x1B3C] = { unicodeslot=0x1B3C, category='mn', description='BALINESE VOWEL SIGN LA LENGA' },
	[0x1B3D] = { unicodeslot=0x1B3D, category='mc', description='BALINESE VOWEL SIGN LA LENGA TEDUNG', specials={'char',0x1B3C,0x1B35} },
	[0x1B3E] = { unicodeslot=0x1B3E, category='mc', description='BALINESE VOWEL SIGN TALING' },
	[0x1B3F] = { unicodeslot=0x1B3F, category='mc', description='BALINESE VOWEL SIGN TALING REPA' },
	[0x1B40] = { unicodeslot=0x1B40, category='mc', description='BALINESE VOWEL SIGN TALING TEDUNG', specials={'char',0x1B3E,0x1B35} },
	[0x1B41] = { unicodeslot=0x1B41, category='mc', description='BALINESE VOWEL SIGN TALING REPA TEDUNG', specials={'char',0x1B3F,0x1B35} },
	[0x1B42] = { unicodeslot=0x1B42, category='mn', description='BALINESE VOWEL SIGN PEPET' },
	[0x1B43] = { unicodeslot=0x1B43, category='mc', description='BALINESE VOWEL SIGN PEPET TEDUNG', specials={'char',0x1B42,0x1B35} },
	[0x1B44] = { unicodeslot=0x1B44, category='mc', description='BALINESE ADEG ADEG' },
	[0x1B45] = { unicodeslot=0x1B45, category='lo', description='BALINESE LETTER KAF SASAK' },
	[0x1B46] = { unicodeslot=0x1B46, category='lo', description='BALINESE LETTER KHOT SASAK' },
	[0x1B47] = { unicodeslot=0x1B47, category='lo', description='BALINESE LETTER TZIR SASAK' },
	[0x1B48] = { unicodeslot=0x1B48, category='lo', description='BALINESE LETTER EF SASAK' },
	[0x1B49] = { unicodeslot=0x1B49, category='lo', description='BALINESE LETTER VE SASAK' },
	[0x1B4A] = { unicodeslot=0x1B4A, category='lo', description='BALINESE LETTER ZAL SASAK' },
	[0x1B4B] = { unicodeslot=0x1B4B, category='lo', description='BALINESE LETTER ASYURA SASAK' },
	[0x1B50] = { unicodeslot=0x1B50, category='nd', description='BALINESE DIGIT ZERO' },
	[0x1B51] = { unicodeslot=0x1B51, category='nd', description='BALINESE DIGIT ONE' },
	[0x1B52] = { unicodeslot=0x1B52, category='nd', description='BALINESE DIGIT TWO' },
	[0x1B53] = { unicodeslot=0x1B53, category='nd', description='BALINESE DIGIT THREE' },
	[0x1B54] = { unicodeslot=0x1B54, category='nd', description='BALINESE DIGIT FOUR' },
	[0x1B55] = { unicodeslot=0x1B55, category='nd', description='BALINESE DIGIT FIVE' },
	[0x1B56] = { unicodeslot=0x1B56, category='nd', description='BALINESE DIGIT SIX' },
	[0x1B57] = { unicodeslot=0x1B57, category='nd', description='BALINESE DIGIT SEVEN' },
	[0x1B58] = { unicodeslot=0x1B58, category='nd', description='BALINESE DIGIT EIGHT' },
	[0x1B59] = { unicodeslot=0x1B59, category='nd', description='BALINESE DIGIT NINE' },
	[0x1B5A] = { unicodeslot=0x1B5A, category='po', description='BALINESE PANTI' },
	[0x1B5B] = { unicodeslot=0x1B5B, category='po', description='BALINESE PAMADA' },
	[0x1B5C] = { unicodeslot=0x1B5C, category='po', description='BALINESE WINDU' },
	[0x1B5D] = { unicodeslot=0x1B5D, category='po', description='BALINESE CARIK PAMUNGKAH' },
	[0x1B5E] = { unicodeslot=0x1B5E, category='po', description='BALINESE CARIK SIKI' },
	[0x1B5F] = { unicodeslot=0x1B5F, category='po', description='BALINESE CARIK PAREREN' },
	[0x1B60] = { unicodeslot=0x1B60, category='po', description='BALINESE PAMENENG' },
	[0x1B61] = { unicodeslot=0x1B61, category='so', description='BALINESE MUSICAL SYMBOL DONG' },
	[0x1B62] = { unicodeslot=0x1B62, category='so', description='BALINESE MUSICAL SYMBOL DENG' },
	[0x1B63] = { unicodeslot=0x1B63, category='so', description='BALINESE MUSICAL SYMBOL DUNG' },
	[0x1B64] = { unicodeslot=0x1B64, category='so', description='BALINESE MUSICAL SYMBOL DANG' },
	[0x1B65] = { unicodeslot=0x1B65, category='so', description='BALINESE MUSICAL SYMBOL DANG SURANG' },
	[0x1B66] = { unicodeslot=0x1B66, category='so', description='BALINESE MUSICAL SYMBOL DING' },
	[0x1B67] = { unicodeslot=0x1B67, category='so', description='BALINESE MUSICAL SYMBOL DAENG' },
	[0x1B68] = { unicodeslot=0x1B68, category='so', description='BALINESE MUSICAL SYMBOL DEUNG' },
	[0x1B69] = { unicodeslot=0x1B69, category='so', description='BALINESE MUSICAL SYMBOL DAING' },
	[0x1B6A] = { unicodeslot=0x1B6A, category='so', description='BALINESE MUSICAL SYMBOL DANG GEDE' },
	[0x1B6B] = { unicodeslot=0x1B6B, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING TEGEH' },
	[0x1B6C] = { unicodeslot=0x1B6C, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING ENDEP' },
	[0x1B6D] = { unicodeslot=0x1B6D, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING KEMPUL' },
	[0x1B6E] = { unicodeslot=0x1B6E, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING KEMPLI' },
	[0x1B6F] = { unicodeslot=0x1B6F, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING JEGOGAN' },
	[0x1B70] = { unicodeslot=0x1B70, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN' },
	[0x1B71] = { unicodeslot=0x1B71, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN' },
	[0x1B72] = { unicodeslot=0x1B72, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING BENDE' },
	[0x1B73] = { unicodeslot=0x1B73, category='mn', description='BALINESE MUSICAL SYMBOL COMBINING GONG' },
	[0x1B74] = { unicodeslot=0x1B74, category='so', description='BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG' },
	[0x1B75] = { unicodeslot=0x1B75, category='so', description='BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG' },
	[0x1B76] = { unicodeslot=0x1B76, category='so', description='BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK' },
	[0x1B77] = { unicodeslot=0x1B77, category='so', description='BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK' },
	[0x1B78] = { unicodeslot=0x1B78, category='so', description='BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG' },
	[0x1B79] = { unicodeslot=0x1B79, category='so', description='BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG' },
	[0x1B7A] = { unicodeslot=0x1B7A, category='so', description='BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK' },
	[0x1B7B] = { unicodeslot=0x1B7B, category='so', description='BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK' },
	[0x1B7C] = { unicodeslot=0x1B7C, category='so', description='BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING' },
	[0x1D00] = { unicodeslot=0x1D00, category='ll', description='LATIN LETTER SMALL CAPITAL A' },
	[0x1D01] = { unicodeslot=0x1D01, category='ll', description='LATIN LETTER SMALL CAPITAL AE' },
	[0x1D02] = { unicodeslot=0x1D02, category='ll', description='LATIN SMALL LETTER TURNED AE' },
	[0x1D03] = { unicodeslot=0x1D03, category='ll', description='LATIN LETTER SMALL CAPITAL BARRED B' },
	[0x1D04] = { unicodeslot=0x1D04, category='ll', description='LATIN LETTER SMALL CAPITAL C' },
	[0x1D05] = { unicodeslot=0x1D05, category='ll', description='LATIN LETTER SMALL CAPITAL D' },
	[0x1D06] = { unicodeslot=0x1D06, category='ll', description='LATIN LETTER SMALL CAPITAL ETH' },
	[0x1D07] = { unicodeslot=0x1D07, category='ll', description='LATIN LETTER SMALL CAPITAL E' },
	[0x1D08] = { unicodeslot=0x1D08, category='ll', description='LATIN SMALL LETTER TURNED OPEN E' },
	[0x1D09] = { unicodeslot=0x1D09, category='ll', description='LATIN SMALL LETTER TURNED I' },
	[0x1D0A] = { unicodeslot=0x1D0A, category='ll', description='LATIN LETTER SMALL CAPITAL J' },
	[0x1D0B] = { unicodeslot=0x1D0B, category='ll', description='LATIN LETTER SMALL CAPITAL K' },
	[0x1D0C] = { unicodeslot=0x1D0C, category='ll', description='LATIN LETTER SMALL CAPITAL L WITH STROKE' },
	[0x1D0D] = { unicodeslot=0x1D0D, category='ll', description='LATIN LETTER SMALL CAPITAL M' },
	[0x1D0E] = { unicodeslot=0x1D0E, category='ll', description='LATIN LETTER SMALL CAPITAL REVERSED N' },
	[0x1D0F] = { unicodeslot=0x1D0F, category='ll', description='LATIN LETTER SMALL CAPITAL O' },
	[0x1D10] = { unicodeslot=0x1D10, category='ll', description='LATIN LETTER SMALL CAPITAL OPEN O' },
	[0x1D11] = { unicodeslot=0x1D11, category='ll', description='LATIN SMALL LETTER SIDEWAYS O' },
	[0x1D12] = { unicodeslot=0x1D12, category='ll', description='LATIN SMALL LETTER SIDEWAYS OPEN O' },
	[0x1D13] = { unicodeslot=0x1D13, category='ll', description='LATIN SMALL LETTER SIDEWAYS O WITH STROKE' },
	[0x1D14] = { unicodeslot=0x1D14, category='ll', description='LATIN SMALL LETTER TURNED OE' },
	[0x1D15] = { unicodeslot=0x1D15, category='ll', description='LATIN LETTER SMALL CAPITAL OU' },
	[0x1D16] = { unicodeslot=0x1D16, category='ll', description='LATIN SMALL LETTER TOP HALF O' },
	[0x1D17] = { unicodeslot=0x1D17, category='ll', description='LATIN SMALL LETTER BOTTOM HALF O' },
	[0x1D18] = { unicodeslot=0x1D18, category='ll', description='LATIN LETTER SMALL CAPITAL P' },
	[0x1D19] = { unicodeslot=0x1D19, category='ll', description='LATIN LETTER SMALL CAPITAL REVERSED R' },
	[0x1D1A] = { unicodeslot=0x1D1A, category='ll', description='LATIN LETTER SMALL CAPITAL TURNED R' },
	[0x1D1B] = { unicodeslot=0x1D1B, category='ll', description='LATIN LETTER SMALL CAPITAL T' },
	[0x1D1C] = { unicodeslot=0x1D1C, category='ll', description='LATIN LETTER SMALL CAPITAL U' },
	[0x1D1D] = { unicodeslot=0x1D1D, category='ll', description='LATIN SMALL LETTER SIDEWAYS U' },
	[0x1D1E] = { unicodeslot=0x1D1E, category='ll', description='LATIN SMALL LETTER SIDEWAYS DIAERESIZED U' },
	[0x1D1F] = { unicodeslot=0x1D1F, category='ll', description='LATIN SMALL LETTER SIDEWAYS TURNED M' },
	[0x1D20] = { unicodeslot=0x1D20, category='ll', description='LATIN LETTER SMALL CAPITAL V' },
	[0x1D21] = { unicodeslot=0x1D21, category='ll', description='LATIN LETTER SMALL CAPITAL W' },
	[0x1D22] = { unicodeslot=0x1D22, category='ll', description='LATIN LETTER SMALL CAPITAL Z' },
	[0x1D23] = { unicodeslot=0x1D23, category='ll', description='LATIN LETTER SMALL CAPITAL EZH' },
	[0x1D24] = { unicodeslot=0x1D24, category='ll', description='LATIN LETTER VOICED LARYNGEAL SPIRANT' },
	[0x1D25] = { unicodeslot=0x1D25, category='ll', description='LATIN LETTER AIN' },
	[0x1D26] = { unicodeslot=0x1D26, category='ll', description='GREEK LETTER SMALL CAPITAL GAMMA' },
	[0x1D27] = { unicodeslot=0x1D27, category='ll', description='GREEK LETTER SMALL CAPITAL LAMDA' },
	[0x1D28] = { unicodeslot=0x1D28, category='ll', description='GREEK LETTER SMALL CAPITAL PI' },
	[0x1D29] = { unicodeslot=0x1D29, category='ll', description='GREEK LETTER SMALL CAPITAL RHO' },
	[0x1D2A] = { unicodeslot=0x1D2A, category='ll', description='GREEK LETTER SMALL CAPITAL PSI' },
	[0x1D2B] = { unicodeslot=0x1D2B, category='ll', description='CYRILLIC LETTER SMALL CAPITAL EL' },
	[0x1D2C] = { unicodeslot=0x1D2C, category='lm', description='MODIFIER LETTER CAPITAL A', specials={'super',0x0041} },
	[0x1D2D] = { unicodeslot=0x1D2D, category='lm', description='MODIFIER LETTER CAPITAL AE', specials={'super',0x00C6} },
	[0x1D2E] = { unicodeslot=0x1D2E, category='lm', description='MODIFIER LETTER CAPITAL B', specials={'super',0x0042} },
	[0x1D2F] = { unicodeslot=0x1D2F, category='lm', description='MODIFIER LETTER CAPITAL BARRED B' },
	[0x1D30] = { unicodeslot=0x1D30, category='lm', description='MODIFIER LETTER CAPITAL D', specials={'super',0x0044} },
	[0x1D31] = { unicodeslot=0x1D31, category='lm', description='MODIFIER LETTER CAPITAL E', specials={'super',0x0045} },
	[0x1D32] = { unicodeslot=0x1D32, category='lm', description='MODIFIER LETTER CAPITAL REVERSED E', specials={'super',0x018E} },
	[0x1D33] = { unicodeslot=0x1D33, category='lm', description='MODIFIER LETTER CAPITAL G', specials={'super',0x0047} },
	[0x1D34] = { unicodeslot=0x1D34, category='lm', description='MODIFIER LETTER CAPITAL H', specials={'super',0x0048} },
	[0x1D35] = { unicodeslot=0x1D35, category='lm', description='MODIFIER LETTER CAPITAL I', specials={'super',0x0049} },
	[0x1D36] = { unicodeslot=0x1D36, category='lm', description='MODIFIER LETTER CAPITAL J', specials={'super',0x004A} },
	[0x1D37] = { unicodeslot=0x1D37, category='lm', description='MODIFIER LETTER CAPITAL K', specials={'super',0x004B} },
	[0x1D38] = { unicodeslot=0x1D38, category='lm', description='MODIFIER LETTER CAPITAL L', specials={'super',0x004C} },
	[0x1D39] = { unicodeslot=0x1D39, category='lm', description='MODIFIER LETTER CAPITAL M', specials={'super',0x004D} },
	[0x1D3A] = { unicodeslot=0x1D3A, category='lm', description='MODIFIER LETTER CAPITAL N', specials={'super',0x004E} },
	[0x1D3B] = { unicodeslot=0x1D3B, category='lm', description='MODIFIER LETTER CAPITAL REVERSED N' },
	[0x1D3C] = { unicodeslot=0x1D3C, category='lm', description='MODIFIER LETTER CAPITAL O', specials={'super',0x004F} },
	[0x1D3D] = { unicodeslot=0x1D3D, category='lm', description='MODIFIER LETTER CAPITAL OU', specials={'super',0x0222} },
	[0x1D3E] = { unicodeslot=0x1D3E, category='lm', description='MODIFIER LETTER CAPITAL P', specials={'super',0x0050} },
	[0x1D3F] = { unicodeslot=0x1D3F, category='lm', description='MODIFIER LETTER CAPITAL R', specials={'super',0x0052} },
	[0x1D40] = { unicodeslot=0x1D40, category='lm', description='MODIFIER LETTER CAPITAL T', specials={'super',0x0054} },
	[0x1D41] = { unicodeslot=0x1D41, category='lm', description='MODIFIER LETTER CAPITAL U', specials={'super',0x0055} },
	[0x1D42] = { unicodeslot=0x1D42, category='lm', description='MODIFIER LETTER CAPITAL W', specials={'super',0x0057} },
	[0x1D43] = { unicodeslot=0x1D43, category='lm', description='MODIFIER LETTER SMALL A', specials={'super',0x0061} },
	[0x1D44] = { unicodeslot=0x1D44, category='lm', description='MODIFIER LETTER SMALL TURNED A', specials={'super',0x0250} },
	[0x1D45] = { unicodeslot=0x1D45, category='lm', description='MODIFIER LETTER SMALL ALPHA', specials={'super',0x0251} },
	[0x1D46] = { unicodeslot=0x1D46, category='lm', description='MODIFIER LETTER SMALL TURNED AE', specials={'super',0x1D02} },
	[0x1D47] = { unicodeslot=0x1D47, category='lm', description='MODIFIER LETTER SMALL B', specials={'super',0x0062} },
	[0x1D48] = { unicodeslot=0x1D48, category='lm', description='MODIFIER LETTER SMALL D', specials={'super',0x0064} },
	[0x1D49] = { unicodeslot=0x1D49, category='lm', description='MODIFIER LETTER SMALL E', specials={'super',0x0065} },
	[0x1D4A] = { unicodeslot=0x1D4A, category='lm', description='MODIFIER LETTER SMALL SCHWA', specials={'super',0x0259} },
	[0x1D4B] = { unicodeslot=0x1D4B, category='lm', description='MODIFIER LETTER SMALL OPEN E', specials={'super',0x025B} },
	[0x1D4C] = { unicodeslot=0x1D4C, category='lm', description='MODIFIER LETTER SMALL TURNED OPEN E', specials={'super',0x025C} },
	[0x1D4D] = { unicodeslot=0x1D4D, category='lm', description='MODIFIER LETTER SMALL G', specials={'super',0x0067} },
	[0x1D4E] = { unicodeslot=0x1D4E, category='lm', description='MODIFIER LETTER SMALL TURNED I' },
	[0x1D4F] = { unicodeslot=0x1D4F, category='lm', description='MODIFIER LETTER SMALL K', specials={'super',0x006B} },
	[0x1D50] = { unicodeslot=0x1D50, category='lm', description='MODIFIER LETTER SMALL M', specials={'super',0x006D} },
	[0x1D51] = { unicodeslot=0x1D51, category='lm', description='MODIFIER LETTER SMALL ENG', specials={'super',0x014B} },
	[0x1D52] = { unicodeslot=0x1D52, category='lm', description='MODIFIER LETTER SMALL O', specials={'super',0x006F} },
	[0x1D53] = { unicodeslot=0x1D53, category='lm', description='MODIFIER LETTER SMALL OPEN O', specials={'super',0x0254} },
	[0x1D54] = { unicodeslot=0x1D54, category='lm', description='MODIFIER LETTER SMALL TOP HALF O', specials={'super',0x1D16} },
	[0x1D55] = { unicodeslot=0x1D55, category='lm', description='MODIFIER LETTER SMALL BOTTOM HALF O', specials={'super',0x1D17} },
	[0x1D56] = { unicodeslot=0x1D56, category='lm', description='MODIFIER LETTER SMALL P', specials={'super',0x0070} },
	[0x1D57] = { unicodeslot=0x1D57, category='lm', description='MODIFIER LETTER SMALL T', specials={'super',0x0074} },
	[0x1D58] = { unicodeslot=0x1D58, category='lm', description='MODIFIER LETTER SMALL U', specials={'super',0x0075} },
	[0x1D59] = { unicodeslot=0x1D59, category='lm', description='MODIFIER LETTER SMALL SIDEWAYS U', specials={'super',0x1D1D} },
	[0x1D5A] = { unicodeslot=0x1D5A, category='lm', description='MODIFIER LETTER SMALL TURNED M', specials={'super',0x026F} },
	[0x1D5B] = { unicodeslot=0x1D5B, category='lm', description='MODIFIER LETTER SMALL V', specials={'super',0x0076} },
	[0x1D5C] = { unicodeslot=0x1D5C, category='lm', description='MODIFIER LETTER SMALL AIN', specials={'super',0x1D25} },
	[0x1D5D] = { unicodeslot=0x1D5D, category='lm', description='MODIFIER LETTER SMALL BETA', specials={'super',0x03B2} },
	[0x1D5E] = { unicodeslot=0x1D5E, category='lm', description='MODIFIER LETTER SMALL GREEK GAMMA', specials={'super',0x03B3} },
	[0x1D5F] = { unicodeslot=0x1D5F, category='lm', description='MODIFIER LETTER SMALL DELTA', specials={'super',0x03B4} },
	[0x1D60] = { unicodeslot=0x1D60, category='lm', description='MODIFIER LETTER SMALL GREEK PHI', specials={'super',0x03C6} },
	[0x1D61] = { unicodeslot=0x1D61, category='lm', description='MODIFIER LETTER SMALL CHI', specials={'super',0x03C7} },
	[0x1D62] = { unicodeslot=0x1D62, category='ll', description='LATIN SUBSCRIPT SMALL LETTER I', specials={'sub',0x0069} },
	[0x1D63] = { unicodeslot=0x1D63, category='ll', description='LATIN SUBSCRIPT SMALL LETTER R', specials={'sub',0x0072} },
	[0x1D64] = { unicodeslot=0x1D64, category='ll', description='LATIN SUBSCRIPT SMALL LETTER U', specials={'sub',0x0075} },
	[0x1D65] = { unicodeslot=0x1D65, category='ll', description='LATIN SUBSCRIPT SMALL LETTER V', specials={'sub',0x0076} },
	[0x1D66] = { unicodeslot=0x1D66, category='ll', description='GREEK SUBSCRIPT SMALL LETTER BETA', specials={'sub',0x03B2} },
	[0x1D67] = { unicodeslot=0x1D67, category='ll', description='GREEK SUBSCRIPT SMALL LETTER GAMMA', specials={'sub',0x03B3} },
	[0x1D68] = { unicodeslot=0x1D68, category='ll', description='GREEK SUBSCRIPT SMALL LETTER RHO', specials={'sub',0x03C1} },
	[0x1D69] = { unicodeslot=0x1D69, category='ll', description='GREEK SUBSCRIPT SMALL LETTER PHI', specials={'sub',0x03C6} },
	[0x1D6A] = { unicodeslot=0x1D6A, category='ll', description='GREEK SUBSCRIPT SMALL LETTER CHI', specials={'sub',0x03C7} },
	[0x1D6B] = { unicodeslot=0x1D6B, category='ll', description='LATIN SMALL LETTER UE' },
	[0x1D6C] = { unicodeslot=0x1D6C, category='ll', description='LATIN SMALL LETTER B WITH MIDDLE TILDE', shcode=0x0062 },
	[0x1D6D] = { unicodeslot=0x1D6D, category='ll', description='LATIN SMALL LETTER D WITH MIDDLE TILDE', shcode=0x0064 },
	[0x1D6E] = { unicodeslot=0x1D6E, category='ll', description='LATIN SMALL LETTER F WITH MIDDLE TILDE', shcode=0x0066 },
	[0x1D6F] = { unicodeslot=0x1D6F, category='ll', description='LATIN SMALL LETTER M WITH MIDDLE TILDE', shcode=0x006D },
	[0x1D70] = { unicodeslot=0x1D70, category='ll', description='LATIN SMALL LETTER N WITH MIDDLE TILDE', shcode=0x006E },
	[0x1D71] = { unicodeslot=0x1D71, category='ll', description='LATIN SMALL LETTER P WITH MIDDLE TILDE', shcode=0x0070 },
	[0x1D72] = { unicodeslot=0x1D72, category='ll', description='LATIN SMALL LETTER R WITH MIDDLE TILDE', shcode=0x0072 },
	[0x1D73] = { unicodeslot=0x1D73, category='ll', description='LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE', shcode=0x0072 },
	[0x1D74] = { unicodeslot=0x1D74, category='ll', description='LATIN SMALL LETTER S WITH MIDDLE TILDE', shcode=0x0073 },
	[0x1D75] = { unicodeslot=0x1D75, category='ll', description='LATIN SMALL LETTER T WITH MIDDLE TILDE', shcode=0x0074 },
	[0x1D76] = { unicodeslot=0x1D76, category='ll', description='LATIN SMALL LETTER Z WITH MIDDLE TILDE', shcode=0x007A },
	[0x1D77] = { unicodeslot=0x1D77, category='ll', description='LATIN SMALL LETTER TURNED G' },
	[0x1D78] = { unicodeslot=0x1D78, category='lm', description='MODIFIER LETTER CYRILLIC EN', specials={'super',0x043D} },
	[0x1D79] = { unicodeslot=0x1D79, category='ll', description='LATIN SMALL LETTER INSULAR G' },
	[0x1D7A] = { unicodeslot=0x1D7A, category='ll', description='LATIN SMALL LETTER TH WITH STRIKETHROUGH' },
	[0x1D7B] = { unicodeslot=0x1D7B, category='ll', description='LATIN SMALL CAPITAL LETTER I WITH STROKE' },
	[0x1D7C] = { unicodeslot=0x1D7C, category='ll', description='LATIN SMALL LETTER IOTA WITH STROKE', shcode=0x0269 },
	[0x1D7D] = { unicodeslot=0x1D7D, category='ll', description='LATIN SMALL LETTER P WITH STROKE', shcode=0x0070, uccode=0x2C63 },
	[0x1D7E] = { unicodeslot=0x1D7E, category='ll', description='LATIN SMALL CAPITAL LETTER U WITH STROKE' },
	[0x1D7F] = { unicodeslot=0x1D7F, category='ll', description='LATIN SMALL LETTER UPSILON WITH STROKE', shcode=0x028A },
	[0x1D80] = { unicodeslot=0x1D80, category='ll', description='LATIN SMALL LETTER B WITH PALATAL HOOK', shcode=0x0062 },
	[0x1D81] = { unicodeslot=0x1D81, category='ll', description='LATIN SMALL LETTER D WITH PALATAL HOOK', shcode=0x0064 },
	[0x1D82] = { unicodeslot=0x1D82, category='ll', description='LATIN SMALL LETTER F WITH PALATAL HOOK', shcode=0x0066 },
	[0x1D83] = { unicodeslot=0x1D83, category='ll', description='LATIN SMALL LETTER G WITH PALATAL HOOK', shcode=0x0067 },
	[0x1D84] = { unicodeslot=0x1D84, category='ll', description='LATIN SMALL LETTER K WITH PALATAL HOOK', shcode=0x006B },
	[0x1D85] = { unicodeslot=0x1D85, category='ll', description='LATIN SMALL LETTER L WITH PALATAL HOOK', shcode=0x006C },
	[0x1D86] = { unicodeslot=0x1D86, category='ll', description='LATIN SMALL LETTER M WITH PALATAL HOOK', shcode=0x006D },
	[0x1D87] = { unicodeslot=0x1D87, category='ll', description='LATIN SMALL LETTER N WITH PALATAL HOOK', shcode=0x006E },
	[0x1D88] = { unicodeslot=0x1D88, category='ll', description='LATIN SMALL LETTER P WITH PALATAL HOOK', shcode=0x0070 },
	[0x1D89] = { unicodeslot=0x1D89, category='ll', description='LATIN SMALL LETTER R WITH PALATAL HOOK', shcode=0x0072 },
	[0x1D8A] = { unicodeslot=0x1D8A, category='ll', description='LATIN SMALL LETTER S WITH PALATAL HOOK', shcode=0x0073 },
	[0x1D8B] = { unicodeslot=0x1D8B, category='ll', description='LATIN SMALL LETTER ESH WITH PALATAL HOOK', shcode=0x0283 },
	[0x1D8C] = { unicodeslot=0x1D8C, category='ll', description='LATIN SMALL LETTER V WITH PALATAL HOOK', shcode=0x0076 },
	[0x1D8D] = { unicodeslot=0x1D8D, category='ll', description='LATIN SMALL LETTER X WITH PALATAL HOOK', shcode=0x0078 },
	[0x1D8E] = { unicodeslot=0x1D8E, category='ll', description='LATIN SMALL LETTER Z WITH PALATAL HOOK', shcode=0x007A },
	[0x1D8F] = { unicodeslot=0x1D8F, category='ll', description='LATIN SMALL LETTER A WITH RETROFLEX HOOK', shcode=0x0061 },
	[0x1D90] = { unicodeslot=0x1D90, category='ll', description='LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK', shcode=0x0251 },
	[0x1D91] = { unicodeslot=0x1D91, category='ll', description='LATIN SMALL LETTER D WITH HOOK AND TAIL', shcode=0x0064 },
	[0x1D92] = { unicodeslot=0x1D92, category='ll', description='LATIN SMALL LETTER E WITH RETROFLEX HOOK', shcode=0x0065 },
	[0x1D93] = { unicodeslot=0x1D93, category='ll', description='LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK' },
	[0x1D94] = { unicodeslot=0x1D94, category='ll', description='LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK' },
	[0x1D95] = { unicodeslot=0x1D95, category='ll', description='LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK', shcode=0x0259 },
	[0x1D96] = { unicodeslot=0x1D96, category='ll', description='LATIN SMALL LETTER I WITH RETROFLEX HOOK', shcode=0x0069 },
	[0x1D97] = { unicodeslot=0x1D97, category='ll', description='LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK' },
	[0x1D98] = { unicodeslot=0x1D98, category='ll', description='LATIN SMALL LETTER ESH WITH RETROFLEX HOOK', shcode=0x0283 },
	[0x1D99] = { unicodeslot=0x1D99, category='ll', description='LATIN SMALL LETTER U WITH RETROFLEX HOOK', shcode=0x0075 },
	[0x1D9A] = { unicodeslot=0x1D9A, category='ll', description='LATIN SMALL LETTER EZH WITH RETROFLEX HOOK', shcode=0x0292 },
	[0x1D9B] = { unicodeslot=0x1D9B, category='lm', description='MODIFIER LETTER SMALL TURNED ALPHA', specials={'super',0x0252} },
	[0x1D9C] = { unicodeslot=0x1D9C, category='lm', description='MODIFIER LETTER SMALL C', specials={'super',0x0063} },
	[0x1D9D] = { unicodeslot=0x1D9D, category='lm', description='MODIFIER LETTER SMALL C WITH CURL', specials={'super',0x0255} },
	[0x1D9E] = { unicodeslot=0x1D9E, category='lm', description='MODIFIER LETTER SMALL ETH', specials={'super',0x00F0} },
	[0x1D9F] = { unicodeslot=0x1D9F, category='lm', description='MODIFIER LETTER SMALL REVERSED OPEN E', specials={'super',0x025C} },
	[0x1DA0] = { unicodeslot=0x1DA0, category='lm', description='MODIFIER LETTER SMALL F', specials={'super',0x0066} },
	[0x1DA1] = { unicodeslot=0x1DA1, category='lm', description='MODIFIER LETTER SMALL DOTLESS J WITH STROKE', specials={'super',0x025F} },
	[0x1DA2] = { unicodeslot=0x1DA2, category='lm', description='MODIFIER LETTER SMALL SCRIPT G', specials={'super',0x0261} },
	[0x1DA3] = { unicodeslot=0x1DA3, category='lm', description='MODIFIER LETTER SMALL TURNED H', specials={'super',0x0265} },
	[0x1DA4] = { unicodeslot=0x1DA4, category='lm', description='MODIFIER LETTER SMALL I WITH STROKE', specials={'super',0x0268} },
	[0x1DA5] = { unicodeslot=0x1DA5, category='lm', description='MODIFIER LETTER SMALL IOTA', specials={'super',0x0269} },
	[0x1DA6] = { unicodeslot=0x1DA6, category='lm', description='MODIFIER LETTER SMALL CAPITAL I', specials={'super',0x026A} },
	[0x1DA7] = { unicodeslot=0x1DA7, category='lm', description='MODIFIER LETTER SMALL CAPITAL I WITH STROKE', specials={'super',0x1D7B} },
	[0x1DA8] = { unicodeslot=0x1DA8, category='lm', description='MODIFIER LETTER SMALL J WITH CROSSED-TAIL', specials={'super',0x029D} },
	[0x1DA9] = { unicodeslot=0x1DA9, category='lm', description='MODIFIER LETTER SMALL L WITH RETROFLEX HOOK', specials={'super',0x026D} },
	[0x1DAA] = { unicodeslot=0x1DAA, category='lm', description='MODIFIER LETTER SMALL L WITH PALATAL HOOK', specials={'super',0x1D85} },
	[0x1DAB] = { unicodeslot=0x1DAB, category='lm', description='MODIFIER LETTER SMALL CAPITAL L', specials={'super',0x029F} },
	[0x1DAC] = { unicodeslot=0x1DAC, category='lm', description='MODIFIER LETTER SMALL M WITH HOOK', specials={'super',0x0271} },
	[0x1DAD] = { unicodeslot=0x1DAD, category='lm', description='MODIFIER LETTER SMALL TURNED M WITH LONG LEG', specials={'super',0x0270} },
	[0x1DAE] = { unicodeslot=0x1DAE, category='lm', description='MODIFIER LETTER SMALL N WITH LEFT HOOK', specials={'super',0x0272} },
	[0x1DAF] = { unicodeslot=0x1DAF, category='lm', description='MODIFIER LETTER SMALL N WITH RETROFLEX HOOK', specials={'super',0x0273} },
	[0x1DB0] = { unicodeslot=0x1DB0, category='lm', description='MODIFIER LETTER SMALL CAPITAL N', specials={'super',0x0274} },
	[0x1DB1] = { unicodeslot=0x1DB1, category='lm', description='MODIFIER LETTER SMALL BARRED O', specials={'super',0x0275} },
	[0x1DB2] = { unicodeslot=0x1DB2, category='lm', description='MODIFIER LETTER SMALL PHI', specials={'super',0x0278} },
	[0x1DB3] = { unicodeslot=0x1DB3, category='lm', description='MODIFIER LETTER SMALL S WITH HOOK', specials={'super',0x0282} },
	[0x1DB4] = { unicodeslot=0x1DB4, category='lm', description='MODIFIER LETTER SMALL ESH', specials={'super',0x0283} },
	[0x1DB5] = { unicodeslot=0x1DB5, category='lm', description='MODIFIER LETTER SMALL T WITH PALATAL HOOK', specials={'super',0x01AB} },
	[0x1DB6] = { unicodeslot=0x1DB6, category='lm', description='MODIFIER LETTER SMALL U BAR', specials={'super',0x0289} },
	[0x1DB7] = { unicodeslot=0x1DB7, category='lm', description='MODIFIER LETTER SMALL UPSILON', specials={'super',0x028A} },
	[0x1DB8] = { unicodeslot=0x1DB8, category='lm', description='MODIFIER LETTER SMALL CAPITAL U', specials={'super',0x1D1C} },
	[0x1DB9] = { unicodeslot=0x1DB9, category='lm', description='MODIFIER LETTER SMALL V WITH HOOK', specials={'super',0x028B} },
	[0x1DBA] = { unicodeslot=0x1DBA, category='lm', description='MODIFIER LETTER SMALL TURNED V', specials={'super',0x028C} },
	[0x1DBB] = { unicodeslot=0x1DBB, category='lm', description='MODIFIER LETTER SMALL Z', specials={'super',0x007A} },
	[0x1DBC] = { unicodeslot=0x1DBC, category='lm', description='MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK', specials={'super',0x0290} },
	[0x1DBD] = { unicodeslot=0x1DBD, category='lm', description='MODIFIER LETTER SMALL Z WITH CURL', specials={'super',0x0291} },
	[0x1DBE] = { unicodeslot=0x1DBE, category='lm', description='MODIFIER LETTER SMALL EZH', specials={'super',0x0292} },
	[0x1DBF] = { unicodeslot=0x1DBF, category='lm', description='MODIFIER LETTER SMALL THETA', specials={'super',0x03B8} },
	[0x1DC0] = { unicodeslot=0x1DC0, category='mn', description='COMBINING DOTTED GRAVE ACCENT' },
	[0x1DC1] = { unicodeslot=0x1DC1, category='mn', description='COMBINING DOTTED ACUTE ACCENT' },
	[0x1DC2] = { unicodeslot=0x1DC2, category='mn', description='COMBINING SNAKE BELOW' },
	[0x1DC3] = { unicodeslot=0x1DC3, category='mn', description='COMBINING SUSPENSION MARK' },
	[0x1DC4] = { unicodeslot=0x1DC4, category='mn', description='COMBINING MACRON-ACUTE' },
	[0x1DC5] = { unicodeslot=0x1DC5, category='mn', description='COMBINING GRAVE-MACRON' },
	[0x1DC6] = { unicodeslot=0x1DC6, category='mn', description='COMBINING MACRON-GRAVE' },
	[0x1DC7] = { unicodeslot=0x1DC7, category='mn', description='COMBINING ACUTE-MACRON' },
	[0x1DC8] = { unicodeslot=0x1DC8, category='mn', description='COMBINING GRAVE-ACUTE-GRAVE' },
	[0x1DC9] = { unicodeslot=0x1DC9, category='mn', description='COMBINING ACUTE-GRAVE-ACUTE' },
	[0x1DCA] = { unicodeslot=0x1DCA, category='mn', description='COMBINING LATIN SMALL LETTER R BELOW' },
	[0x1DFE] = { unicodeslot=0x1DFE, category='mn', description='COMBINING LEFT ARROWHEAD ABOVE' },
	[0x1DFF] = { unicodeslot=0x1DFF, category='mn', description='COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW' },
	[0x1E00] = { unicodeslot=0x1E00, category='lu', description='LATIN CAPITAL LETTER A WITH RING BELOW', shcode=0x0041, lccode=0x1E01, specials={'char',0x0041,0x0325} },
	[0x1E01] = { unicodeslot=0x1E01, category='ll', description='LATIN SMALL LETTER A WITH RING BELOW', shcode=0x0061, uccode=0x1E00, specials={'char',0x0061,0x0325} },
	[0x1E02] = { unicodeslot=0x1E02, category='lu', description='LATIN CAPITAL LETTER B WITH DOT ABOVE', shcode=0x0042, lccode=0x1E03, specials={'char',0x0042,0x0307} },
	[0x1E03] = { unicodeslot=0x1E03, category='ll', description='LATIN SMALL LETTER B WITH DOT ABOVE', shcode=0x0062, uccode=0x1E02, specials={'char',0x0062,0x0307} },
	[0x1E04] = { unicodeslot=0x1E04, category='lu', description='LATIN CAPITAL LETTER B WITH DOT BELOW', shcode=0x0042, lccode=0x1E05, specials={'char',0x0042,0x0323} },
	[0x1E05] = { unicodeslot=0x1E05, category='ll', description='LATIN SMALL LETTER B WITH DOT BELOW', shcode=0x0062, uccode=0x1E04, specials={'char',0x0062,0x0323} },
	[0x1E06] = { unicodeslot=0x1E06, category='lu', description='LATIN CAPITAL LETTER B WITH LINE BELOW', shcode=0x0042, lccode=0x1E07, specials={'char',0x0042,0x0331} },
	[0x1E07] = { unicodeslot=0x1E07, category='ll', description='LATIN SMALL LETTER B WITH LINE BELOW', shcode=0x0062, uccode=0x1E06, specials={'char',0x0062,0x0331} },
	[0x1E08] = { unicodeslot=0x1E08, category='lu', description='LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE', shcode=0x0043, lccode=0x1E09, specials={'char',0x00C7,0x0301} },
	[0x1E09] = { unicodeslot=0x1E09, category='ll', description='LATIN SMALL LETTER C WITH CEDILLA AND ACUTE', shcode=0x0063, uccode=0x1E08, specials={'char',0x00E7,0x0301} },
	[0x1E0A] = { unicodeslot=0x1E0A, category='lu', description='LATIN CAPITAL LETTER D WITH DOT ABOVE', shcode=0x0044, lccode=0x1E0B, specials={'char',0x0044,0x0307} },
	[0x1E0B] = { unicodeslot=0x1E0B, category='ll', description='LATIN SMALL LETTER D WITH DOT ABOVE', shcode=0x0064, uccode=0x1E0A, specials={'char',0x0064,0x0307} },
	[0x1E0C] = { unicodeslot=0x1E0C, category='lu', description='LATIN CAPITAL LETTER D WITH DOT BELOW', shcode=0x0044, lccode=0x1E0D, specials={'char',0x0044,0x0323} },
	[0x1E0D] = { unicodeslot=0x1E0D, category='ll', description='LATIN SMALL LETTER D WITH DOT BELOW', shcode=0x0064, uccode=0x1E0C, specials={'char',0x0064,0x0323} },
	[0x1E0E] = { unicodeslot=0x1E0E, category='lu', description='LATIN CAPITAL LETTER D WITH LINE BELOW', shcode=0x0044, lccode=0x1E0F, specials={'char',0x0044,0x0331} },
	[0x1E0F] = { unicodeslot=0x1E0F, category='ll', description='LATIN SMALL LETTER D WITH LINE BELOW', shcode=0x0064, uccode=0x1E0E, specials={'char',0x0064,0x0331} },
	[0x1E10] = { unicodeslot=0x1E10, category='lu', description='LATIN CAPITAL LETTER D WITH CEDILLA', shcode=0x0044, lccode=0x1E11, specials={'char',0x0044,0x0327} },
	[0x1E11] = { unicodeslot=0x1E11, category='ll', description='LATIN SMALL LETTER D WITH CEDILLA', shcode=0x0064, uccode=0x1E10, specials={'char',0x0064,0x0327} },
	[0x1E12] = { unicodeslot=0x1E12, category='lu', description='LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW', shcode=0x0044, lccode=0x1E13, specials={'char',0x0044,0x032D} },
	[0x1E13] = { unicodeslot=0x1E13, category='ll', description='LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW', shcode=0x0064, uccode=0x1E12, specials={'char',0x0064,0x032D} },
	[0x1E14] = { unicodeslot=0x1E14, category='lu', description='LATIN CAPITAL LETTER E WITH MACRON AND GRAVE', shcode=0x0045, lccode=0x1E15, specials={'char',0x0112,0x0300} },
	[0x1E15] = { unicodeslot=0x1E15, category='ll', description='LATIN SMALL LETTER E WITH MACRON AND GRAVE', shcode=0x0065, uccode=0x1E14, specials={'char',0x0113,0x0300} },
	[0x1E16] = { unicodeslot=0x1E16, category='lu', description='LATIN CAPITAL LETTER E WITH MACRON AND ACUTE', shcode=0x0045, lccode=0x1E17, specials={'char',0x0112,0x0301} },
	[0x1E17] = { unicodeslot=0x1E17, category='ll', description='LATIN SMALL LETTER E WITH MACRON AND ACUTE', shcode=0x0065, uccode=0x1E16, specials={'char',0x0113,0x0301} },
	[0x1E18] = { unicodeslot=0x1E18, category='lu', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW', shcode=0x0045, lccode=0x1E19, specials={'char',0x0045,0x032D} },
	[0x1E19] = { unicodeslot=0x1E19, category='ll', description='LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW', shcode=0x0065, uccode=0x1E18, specials={'char',0x0065,0x032D} },
	[0x1E1A] = { unicodeslot=0x1E1A, category='lu', description='LATIN CAPITAL LETTER E WITH TILDE BELOW', shcode=0x0045, lccode=0x1E1B, specials={'char',0x0045,0x0330} },
	[0x1E1B] = { unicodeslot=0x1E1B, category='ll', description='LATIN SMALL LETTER E WITH TILDE BELOW', shcode=0x0065, uccode=0x1E1A, specials={'char',0x0065,0x0330} },
	[0x1E1C] = { unicodeslot=0x1E1C, category='lu', description='LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE', shcode=0x0045, lccode=0x1E1D, specials={'char',0x0228,0x0306} },
	[0x1E1D] = { unicodeslot=0x1E1D, category='ll', description='LATIN SMALL LETTER E WITH CEDILLA AND BREVE', shcode=0x0065, uccode=0x1E1C, specials={'char',0x0229,0x0306} },
	[0x1E1E] = { unicodeslot=0x1E1E, category='lu', description='LATIN CAPITAL LETTER F WITH DOT ABOVE', shcode=0x0046, lccode=0x1E1F, specials={'char',0x0046,0x0307} },
	[0x1E1F] = { unicodeslot=0x1E1F, category='ll', description='LATIN SMALL LETTER F WITH DOT ABOVE', shcode=0x0066, uccode=0x1E1E, specials={'char',0x0066,0x0307} },
	[0x1E20] = { unicodeslot=0x1E20, category='lu', description='LATIN CAPITAL LETTER G WITH MACRON', shcode=0x0047, lccode=0x1E21, specials={'char',0x0047,0x0304} },
	[0x1E21] = { unicodeslot=0x1E21, category='ll', description='LATIN SMALL LETTER G WITH MACRON', shcode=0x0067, uccode=0x1E20, specials={'char',0x0067,0x0304} },
	[0x1E22] = { unicodeslot=0x1E22, category='lu', description='LATIN CAPITAL LETTER H WITH DOT ABOVE', shcode=0x0048, lccode=0x1E23, specials={'char',0x0048,0x0307} },
	[0x1E23] = { unicodeslot=0x1E23, category='ll', description='LATIN SMALL LETTER H WITH DOT ABOVE', shcode=0x0068, uccode=0x1E22, specials={'char',0x0068,0x0307} },
	[0x1E24] = { unicodeslot=0x1E24, category='lu', description='LATIN CAPITAL LETTER H WITH DOT BELOW', shcode=0x0048, lccode=0x1E25, specials={'char',0x0048,0x0323} },
	[0x1E25] = { unicodeslot=0x1E25, category='ll', description='LATIN SMALL LETTER H WITH DOT BELOW', shcode=0x0068, uccode=0x1E24, specials={'char',0x0068,0x0323} },
	[0x1E26] = { unicodeslot=0x1E26, category='lu', description='LATIN CAPITAL LETTER H WITH DIAERESIS', shcode=0x0048, lccode=0x1E27, specials={'char',0x0048,0x0308} },
	[0x1E27] = { unicodeslot=0x1E27, category='ll', description='LATIN SMALL LETTER H WITH DIAERESIS', shcode=0x0068, uccode=0x1E26, specials={'char',0x0068,0x0308} },
	[0x1E28] = { unicodeslot=0x1E28, category='lu', description='LATIN CAPITAL LETTER H WITH CEDILLA', shcode=0x0048, lccode=0x1E29, specials={'char',0x0048,0x0327} },
	[0x1E29] = { unicodeslot=0x1E29, category='ll', description='LATIN SMALL LETTER H WITH CEDILLA', shcode=0x0068, uccode=0x1E28, specials={'char',0x0068,0x0327} },
	[0x1E2A] = { unicodeslot=0x1E2A, category='lu', description='LATIN CAPITAL LETTER H WITH BREVE BELOW', shcode=0x0048, lccode=0x1E2B, specials={'char',0x0048,0x032E} },
	[0x1E2B] = { unicodeslot=0x1E2B, category='ll', description='LATIN SMALL LETTER H WITH BREVE BELOW', shcode=0x0068, uccode=0x1E2A, specials={'char',0x0068,0x032E} },
	[0x1E2C] = { unicodeslot=0x1E2C, category='lu', description='LATIN CAPITAL LETTER I WITH TILDE BELOW', shcode=0x0049, lccode=0x1E2D, specials={'char',0x0049,0x0330} },
	[0x1E2D] = { unicodeslot=0x1E2D, category='ll', description='LATIN SMALL LETTER I WITH TILDE BELOW', shcode=0x0069, uccode=0x1E2C, specials={'char',0x0069,0x0330} },
	[0x1E2E] = { unicodeslot=0x1E2E, category='lu', description='LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE', shcode=0x0049, lccode=0x1E2F, specials={'char',0x00CF,0x0301} },
	[0x1E2F] = { unicodeslot=0x1E2F, category='ll', description='LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE', shcode=0x0069, uccode=0x1E2E, specials={'char',0x00EF,0x0301} },
	[0x1E30] = { unicodeslot=0x1E30, category='lu', description='LATIN CAPITAL LETTER K WITH ACUTE', shcode=0x004B, lccode=0x1E31, specials={'char',0x004B,0x0301} },
	[0x1E31] = { unicodeslot=0x1E31, category='ll', description='LATIN SMALL LETTER K WITH ACUTE', shcode=0x006B, uccode=0x1E30, specials={'char',0x006B,0x0301} },
	[0x1E32] = { unicodeslot=0x1E32, category='lu', description='LATIN CAPITAL LETTER K WITH DOT BELOW', shcode=0x004B, lccode=0x1E33, specials={'char',0x004B,0x0323} },
	[0x1E33] = { unicodeslot=0x1E33, category='ll', description='LATIN SMALL LETTER K WITH DOT BELOW', shcode=0x006B, uccode=0x1E32, specials={'char',0x006B,0x0323} },
	[0x1E34] = { unicodeslot=0x1E34, category='lu', description='LATIN CAPITAL LETTER K WITH LINE BELOW', shcode=0x004B, lccode=0x1E35, specials={'char',0x004B,0x0331} },
	[0x1E35] = { unicodeslot=0x1E35, category='ll', description='LATIN SMALL LETTER K WITH LINE BELOW', shcode=0x006B, uccode=0x1E34, specials={'char',0x006B,0x0331} },
	[0x1E36] = { unicodeslot=0x1E36, category='lu', description='LATIN CAPITAL LETTER L WITH DOT BELOW', shcode=0x004C, lccode=0x1E37, specials={'char',0x004C,0x0323} },
	[0x1E37] = { unicodeslot=0x1E37, category='ll', description='LATIN SMALL LETTER L WITH DOT BELOW', shcode=0x006C, uccode=0x1E36, specials={'char',0x006C,0x0323} },
	[0x1E38] = { unicodeslot=0x1E38, category='lu', description='LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON', shcode=0x004C, lccode=0x1E39, specials={'char',0x1E36,0x0304} },
	[0x1E39] = { unicodeslot=0x1E39, category='ll', description='LATIN SMALL LETTER L WITH DOT BELOW AND MACRON', shcode=0x006C, uccode=0x1E38, specials={'char',0x1E37,0x0304} },
	[0x1E3A] = { unicodeslot=0x1E3A, category='lu', description='LATIN CAPITAL LETTER L WITH LINE BELOW', shcode=0x004C, lccode=0x1E3B, specials={'char',0x004C,0x0331} },
	[0x1E3B] = { unicodeslot=0x1E3B, category='ll', description='LATIN SMALL LETTER L WITH LINE BELOW', shcode=0x006C, uccode=0x1E3A, specials={'char',0x006C,0x0331} },
	[0x1E3C] = { unicodeslot=0x1E3C, category='lu', description='LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW', shcode=0x004C, lccode=0x1E3D, specials={'char',0x004C,0x032D} },
	[0x1E3D] = { unicodeslot=0x1E3D, category='ll', description='LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW', shcode=0x006C, uccode=0x1E3C, specials={'char',0x006C,0x032D} },
	[0x1E3E] = { unicodeslot=0x1E3E, category='lu', description='LATIN CAPITAL LETTER M WITH ACUTE', shcode=0x004D, lccode=0x1E3F, specials={'char',0x004D,0x0301} },
	[0x1E3F] = { unicodeslot=0x1E3F, category='ll', description='LATIN SMALL LETTER M WITH ACUTE', shcode=0x006D, uccode=0x1E3E, specials={'char',0x006D,0x0301} },
	[0x1E40] = { unicodeslot=0x1E40, category='lu', description='LATIN CAPITAL LETTER M WITH DOT ABOVE', shcode=0x004D, lccode=0x1E41, specials={'char',0x004D,0x0307} },
	[0x1E41] = { unicodeslot=0x1E41, category='ll', description='LATIN SMALL LETTER M WITH DOT ABOVE', shcode=0x006D, uccode=0x1E40, specials={'char',0x006D,0x0307} },
	[0x1E42] = { unicodeslot=0x1E42, category='lu', description='LATIN CAPITAL LETTER M WITH DOT BELOW', shcode=0x004D, lccode=0x1E43, specials={'char',0x004D,0x0323} },
	[0x1E43] = { unicodeslot=0x1E43, category='ll', description='LATIN SMALL LETTER M WITH DOT BELOW', shcode=0x006D, uccode=0x1E42, specials={'char',0x006D,0x0323} },
	[0x1E44] = { unicodeslot=0x1E44, category='lu', description='LATIN CAPITAL LETTER N WITH DOT ABOVE', shcode=0x004E, lccode=0x1E45, specials={'char',0x004E,0x0307} },
	[0x1E45] = { unicodeslot=0x1E45, category='ll', description='LATIN SMALL LETTER N WITH DOT ABOVE', shcode=0x006E, uccode=0x1E44, specials={'char',0x006E,0x0307} },
	[0x1E46] = { unicodeslot=0x1E46, category='lu', description='LATIN CAPITAL LETTER N WITH DOT BELOW', shcode=0x004E, lccode=0x1E47, specials={'char',0x004E,0x0323} },
	[0x1E47] = { unicodeslot=0x1E47, category='ll', description='LATIN SMALL LETTER N WITH DOT BELOW', shcode=0x006E, uccode=0x1E46, specials={'char',0x006E,0x0323} },
	[0x1E48] = { unicodeslot=0x1E48, category='lu', description='LATIN CAPITAL LETTER N WITH LINE BELOW', shcode=0x004E, lccode=0x1E49, specials={'char',0x004E,0x0331} },
	[0x1E49] = { unicodeslot=0x1E49, category='ll', description='LATIN SMALL LETTER N WITH LINE BELOW', shcode=0x006E, uccode=0x1E48, specials={'char',0x006E,0x0331} },
	[0x1E4A] = { unicodeslot=0x1E4A, category='lu', description='LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW', shcode=0x004E, lccode=0x1E4B, specials={'char',0x004E,0x032D} },
	[0x1E4B] = { unicodeslot=0x1E4B, category='ll', description='LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW', shcode=0x006E, uccode=0x1E4A, specials={'char',0x006E,0x032D} },
	[0x1E4C] = { unicodeslot=0x1E4C, category='lu', description='LATIN CAPITAL LETTER O WITH TILDE AND ACUTE', shcode=0x004F, lccode=0x1E4D, specials={'char',0x00D5,0x0301} },
	[0x1E4D] = { unicodeslot=0x1E4D, category='ll', description='LATIN SMALL LETTER O WITH TILDE AND ACUTE', shcode=0x006F, uccode=0x1E4C, specials={'char',0x00F5,0x0301} },
	[0x1E4E] = { unicodeslot=0x1E4E, category='lu', description='LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS', shcode=0x004F, lccode=0x1E4F, specials={'char',0x00D5,0x0308} },
	[0x1E4F] = { unicodeslot=0x1E4F, category='ll', description='LATIN SMALL LETTER O WITH TILDE AND DIAERESIS', shcode=0x006F, uccode=0x1E4E, specials={'char',0x00F5,0x0308} },
	[0x1E50] = { unicodeslot=0x1E50, category='lu', description='LATIN CAPITAL LETTER O WITH MACRON AND GRAVE', shcode=0x004F, lccode=0x1E51, specials={'char',0x014C,0x0300} },
	[0x1E51] = { unicodeslot=0x1E51, category='ll', description='LATIN SMALL LETTER O WITH MACRON AND GRAVE', shcode=0x006F, uccode=0x1E50, specials={'char',0x014D,0x0300} },
	[0x1E52] = { unicodeslot=0x1E52, category='lu', description='LATIN CAPITAL LETTER O WITH MACRON AND ACUTE', shcode=0x004F, lccode=0x1E53, specials={'char',0x014C,0x0301} },
	[0x1E53] = { unicodeslot=0x1E53, category='ll', description='LATIN SMALL LETTER O WITH MACRON AND ACUTE', shcode=0x006F, uccode=0x1E52, specials={'char',0x014D,0x0301} },
	[0x1E54] = { unicodeslot=0x1E54, category='lu', description='LATIN CAPITAL LETTER P WITH ACUTE', shcode=0x0050, lccode=0x1E55, specials={'char',0x0050,0x0301} },
	[0x1E55] = { unicodeslot=0x1E55, category='ll', description='LATIN SMALL LETTER P WITH ACUTE', shcode=0x0070, uccode=0x1E54, specials={'char',0x0070,0x0301} },
	[0x1E56] = { unicodeslot=0x1E56, category='lu', description='LATIN CAPITAL LETTER P WITH DOT ABOVE', shcode=0x0050, lccode=0x1E57, specials={'char',0x0050,0x0307} },
	[0x1E57] = { unicodeslot=0x1E57, category='ll', description='LATIN SMALL LETTER P WITH DOT ABOVE', shcode=0x0070, uccode=0x1E56, specials={'char',0x0070,0x0307} },
	[0x1E58] = { unicodeslot=0x1E58, category='lu', description='LATIN CAPITAL LETTER R WITH DOT ABOVE', shcode=0x0052, lccode=0x1E59, specials={'char',0x0052,0x0307} },
	[0x1E59] = { unicodeslot=0x1E59, category='ll', description='LATIN SMALL LETTER R WITH DOT ABOVE', shcode=0x0072, uccode=0x1E58, specials={'char',0x0072,0x0307} },
	[0x1E5A] = { unicodeslot=0x1E5A, category='lu', description='LATIN CAPITAL LETTER R WITH DOT BELOW', shcode=0x0052, lccode=0x1E5B, specials={'char',0x0052,0x0323} },
	[0x1E5B] = { unicodeslot=0x1E5B, category='ll', description='LATIN SMALL LETTER R WITH DOT BELOW', shcode=0x0072, uccode=0x1E5A, specials={'char',0x0072,0x0323} },
	[0x1E5C] = { unicodeslot=0x1E5C, category='lu', description='LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON', shcode=0x0052, lccode=0x1E5D, specials={'char',0x1E5A,0x0304} },
	[0x1E5D] = { unicodeslot=0x1E5D, category='ll', description='LATIN SMALL LETTER R WITH DOT BELOW AND MACRON', shcode=0x0072, uccode=0x1E5C, specials={'char',0x1E5B,0x0304} },
	[0x1E5E] = { unicodeslot=0x1E5E, category='lu', description='LATIN CAPITAL LETTER R WITH LINE BELOW', shcode=0x0052, lccode=0x1E5F, specials={'char',0x0052,0x0331} },
	[0x1E5F] = { unicodeslot=0x1E5F, category='ll', description='LATIN SMALL LETTER R WITH LINE BELOW', shcode=0x0072, uccode=0x1E5E, specials={'char',0x0072,0x0331} },
	[0x1E60] = { unicodeslot=0x1E60, category='lu', description='LATIN CAPITAL LETTER S WITH DOT ABOVE', shcode=0x0053, lccode=0x1E61, specials={'char',0x0053,0x0307} },
	[0x1E61] = { unicodeslot=0x1E61, category='ll', description='LATIN SMALL LETTER S WITH DOT ABOVE', shcode=0x0073, uccode=0x1E60, specials={'char',0x0073,0x0307} },
	[0x1E62] = { unicodeslot=0x1E62, category='lu', description='LATIN CAPITAL LETTER S WITH DOT BELOW', shcode=0x0053, lccode=0x1E63, specials={'char',0x0053,0x0323} },
	[0x1E63] = { unicodeslot=0x1E63, category='ll', description='LATIN SMALL LETTER S WITH DOT BELOW', shcode=0x0073, uccode=0x1E62, specials={'char',0x0073,0x0323} },
	[0x1E64] = { unicodeslot=0x1E64, category='lu', description='LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE', shcode=0x0053, lccode=0x1E65, specials={'char',0x015A,0x0307} },
	[0x1E65] = { unicodeslot=0x1E65, category='ll', description='LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE', shcode=0x0073, uccode=0x1E64, specials={'char',0x015B,0x0307} },
	[0x1E66] = { unicodeslot=0x1E66, category='lu', description='LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE', shcode=0x0053, lccode=0x1E67, specials={'char',0x0160,0x0307} },
	[0x1E67] = { unicodeslot=0x1E67, category='ll', description='LATIN SMALL LETTER S WITH CARON AND DOT ABOVE', shcode=0x0073, uccode=0x1E66, specials={'char',0x0161,0x0307} },
	[0x1E68] = { unicodeslot=0x1E68, category='lu', description='LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE', shcode=0x0053, lccode=0x1E69, specials={'char',0x1E62,0x0307} },
	[0x1E69] = { unicodeslot=0x1E69, category='ll', description='LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE', shcode=0x0073, uccode=0x1E68, specials={'char',0x1E63,0x0307} },
	[0x1E6A] = { unicodeslot=0x1E6A, category='lu', description='LATIN CAPITAL LETTER T WITH DOT ABOVE', shcode=0x0054, lccode=0x1E6B, specials={'char',0x0054,0x0307} },
	[0x1E6B] = { unicodeslot=0x1E6B, category='ll', description='LATIN SMALL LETTER T WITH DOT ABOVE', shcode=0x0074, uccode=0x1E6A, specials={'char',0x0074,0x0307} },
	[0x1E6C] = { unicodeslot=0x1E6C, category='lu', description='LATIN CAPITAL LETTER T WITH DOT BELOW', shcode=0x0054, lccode=0x1E6D, specials={'char',0x0054,0x0323} },
	[0x1E6D] = { unicodeslot=0x1E6D, category='ll', description='LATIN SMALL LETTER T WITH DOT BELOW', shcode=0x0074, uccode=0x1E6C, specials={'char',0x0074,0x0323} },
	[0x1E6E] = { unicodeslot=0x1E6E, category='lu', description='LATIN CAPITAL LETTER T WITH LINE BELOW', shcode=0x0054, lccode=0x1E6F, specials={'char',0x0054,0x0331} },
	[0x1E6F] = { unicodeslot=0x1E6F, category='ll', description='LATIN SMALL LETTER T WITH LINE BELOW', shcode=0x0074, uccode=0x1E6E, specials={'char',0x0074,0x0331} },
	[0x1E70] = { unicodeslot=0x1E70, category='lu', description='LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW', shcode=0x0054, lccode=0x1E71, specials={'char',0x0054,0x032D} },
	[0x1E71] = { unicodeslot=0x1E71, category='ll', description='LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW', shcode=0x0074, uccode=0x1E70, specials={'char',0x0074,0x032D} },
	[0x1E72] = { unicodeslot=0x1E72, category='lu', description='LATIN CAPITAL LETTER U WITH DIAERESIS BELOW', shcode=0x0055, lccode=0x1E73, specials={'char',0x0055,0x0324} },
	[0x1E73] = { unicodeslot=0x1E73, category='ll', description='LATIN SMALL LETTER U WITH DIAERESIS BELOW', shcode=0x0075, uccode=0x1E72, specials={'char',0x0075,0x0324} },
	[0x1E74] = { unicodeslot=0x1E74, category='lu', description='LATIN CAPITAL LETTER U WITH TILDE BELOW', shcode=0x0055, lccode=0x1E75, specials={'char',0x0055,0x0330} },
	[0x1E75] = { unicodeslot=0x1E75, category='ll', description='LATIN SMALL LETTER U WITH TILDE BELOW', shcode=0x0075, uccode=0x1E74, specials={'char',0x0075,0x0330} },
	[0x1E76] = { unicodeslot=0x1E76, category='lu', description='LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW', shcode=0x0055, lccode=0x1E77, specials={'char',0x0055,0x032D} },
	[0x1E77] = { unicodeslot=0x1E77, category='ll', description='LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW', shcode=0x0075, uccode=0x1E76, specials={'char',0x0075,0x032D} },
	[0x1E78] = { unicodeslot=0x1E78, category='lu', description='LATIN CAPITAL LETTER U WITH TILDE AND ACUTE', shcode=0x0055, lccode=0x1E79, specials={'char',0x0168,0x0301} },
	[0x1E79] = { unicodeslot=0x1E79, category='ll', description='LATIN SMALL LETTER U WITH TILDE AND ACUTE', shcode=0x0075, uccode=0x1E78, specials={'char',0x0169,0x0301} },
	[0x1E7A] = { unicodeslot=0x1E7A, category='lu', description='LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS', shcode=0x0055, lccode=0x1E7B, specials={'char',0x016A,0x0308} },
	[0x1E7B] = { unicodeslot=0x1E7B, category='ll', description='LATIN SMALL LETTER U WITH MACRON AND DIAERESIS', shcode=0x0075, uccode=0x1E7A, specials={'char',0x016B,0x0308} },
	[0x1E7C] = { unicodeslot=0x1E7C, category='lu', description='LATIN CAPITAL LETTER V WITH TILDE', shcode=0x0056, lccode=0x1E7D, specials={'char',0x0056,0x0303} },
	[0x1E7D] = { unicodeslot=0x1E7D, category='ll', description='LATIN SMALL LETTER V WITH TILDE', shcode=0x0076, uccode=0x1E7C, specials={'char',0x0076,0x0303} },
	[0x1E7E] = { unicodeslot=0x1E7E, category='lu', description='LATIN CAPITAL LETTER V WITH DOT BELOW', shcode=0x0056, lccode=0x1E7F, specials={'char',0x0056,0x0323} },
	[0x1E7F] = { unicodeslot=0x1E7F, category='ll', description='LATIN SMALL LETTER V WITH DOT BELOW', shcode=0x0076, uccode=0x1E7E, specials={'char',0x0076,0x0323} },
	[0x1E80] = { unicodeslot=0x1E80, category='lu', adobename='Wgrave', description='LATIN CAPITAL LETTER W WITH GRAVE', shcode=0x0057, lccode=0x1E81, specials={'char',0x0057,0x0300} },
	[0x1E81] = { unicodeslot=0x1E81, category='ll', adobename='wgrave', description='LATIN SMALL LETTER W WITH GRAVE', shcode=0x0077, uccode=0x1E80, specials={'char',0x0077,0x0300} },
	[0x1E82] = { unicodeslot=0x1E82, category='lu', adobename='Wacute', description='LATIN CAPITAL LETTER W WITH ACUTE', shcode=0x0057, lccode=0x1E83, specials={'char',0x0057,0x0301} },
	[0x1E83] = { unicodeslot=0x1E83, category='ll', adobename='wacute', description='LATIN SMALL LETTER W WITH ACUTE', shcode=0x0077, uccode=0x1E82, specials={'char',0x0077,0x0301} },
	[0x1E84] = { unicodeslot=0x1E84, category='lu', adobename='Wdieresis', description='LATIN CAPITAL LETTER W WITH DIAERESIS', shcode=0x0057, lccode=0x1E85, specials={'char',0x0057,0x0308} },
	[0x1E85] = { unicodeslot=0x1E85, category='ll', adobename='wdieresis', description='LATIN SMALL LETTER W WITH DIAERESIS', shcode=0x0077, uccode=0x1E84, specials={'char',0x0077,0x0308} },
	[0x1E86] = { unicodeslot=0x1E86, category='lu', description='LATIN CAPITAL LETTER W WITH DOT ABOVE', shcode=0x0057, lccode=0x1E87, specials={'char',0x0057,0x0307} },
	[0x1E87] = { unicodeslot=0x1E87, category='ll', description='LATIN SMALL LETTER W WITH DOT ABOVE', shcode=0x0077, uccode=0x1E86, specials={'char',0x0077,0x0307} },
	[0x1E88] = { unicodeslot=0x1E88, category='lu', description='LATIN CAPITAL LETTER W WITH DOT BELOW', shcode=0x0057, lccode=0x1E89, specials={'char',0x0057,0x0323} },
	[0x1E89] = { unicodeslot=0x1E89, category='ll', description='LATIN SMALL LETTER W WITH DOT BELOW', shcode=0x0077, uccode=0x1E88, specials={'char',0x0077,0x0323} },
	[0x1E8A] = { unicodeslot=0x1E8A, category='lu', description='LATIN CAPITAL LETTER X WITH DOT ABOVE', shcode=0x0058, lccode=0x1E8B, specials={'char',0x0058,0x0307} },
	[0x1E8B] = { unicodeslot=0x1E8B, category='ll', description='LATIN SMALL LETTER X WITH DOT ABOVE', shcode=0x0078, uccode=0x1E8A, specials={'char',0x0078,0x0307} },
	[0x1E8C] = { unicodeslot=0x1E8C, category='lu', description='LATIN CAPITAL LETTER X WITH DIAERESIS', shcode=0x0058, lccode=0x1E8D, specials={'char',0x0058,0x0308} },
	[0x1E8D] = { unicodeslot=0x1E8D, category='ll', description='LATIN SMALL LETTER X WITH DIAERESIS', shcode=0x0078, uccode=0x1E8C, specials={'char',0x0078,0x0308} },
	[0x1E8E] = { unicodeslot=0x1E8E, category='lu', description='LATIN CAPITAL LETTER Y WITH DOT ABOVE', shcode=0x0059, lccode=0x1E8F, specials={'char',0x0059,0x0307} },
	[0x1E8F] = { unicodeslot=0x1E8F, category='ll', description='LATIN SMALL LETTER Y WITH DOT ABOVE', shcode=0x0079, uccode=0x1E8E, specials={'char',0x0079,0x0307} },
	[0x1E90] = { unicodeslot=0x1E90, category='lu', description='LATIN CAPITAL LETTER Z WITH CIRCUMFLEX', shcode=0x005A, lccode=0x1E91, specials={'char',0x005A,0x0302} },
	[0x1E91] = { unicodeslot=0x1E91, category='ll', description='LATIN SMALL LETTER Z WITH CIRCUMFLEX', shcode=0x007A, uccode=0x1E90, specials={'char',0x007A,0x0302} },
	[0x1E92] = { unicodeslot=0x1E92, category='lu', description='LATIN CAPITAL LETTER Z WITH DOT BELOW', shcode=0x005A, lccode=0x1E93, specials={'char',0x005A,0x0323} },
	[0x1E93] = { unicodeslot=0x1E93, category='ll', description='LATIN SMALL LETTER Z WITH DOT BELOW', shcode=0x007A, uccode=0x1E92, specials={'char',0x007A,0x0323} },
	[0x1E94] = { unicodeslot=0x1E94, category='lu', description='LATIN CAPITAL LETTER Z WITH LINE BELOW', shcode=0x005A, lccode=0x1E95, specials={'char',0x005A,0x0331} },
	[0x1E95] = { unicodeslot=0x1E95, category='ll', description='LATIN SMALL LETTER Z WITH LINE BELOW', shcode=0x007A, uccode=0x1E94, specials={'char',0x007A,0x0331} },
	[0x1E96] = { unicodeslot=0x1E96, category='ll', description='LATIN SMALL LETTER H WITH LINE BELOW', shcode=0x0068, specials={'char',0x0068,0x0331} },
	[0x1E97] = { unicodeslot=0x1E97, category='ll', description='LATIN SMALL LETTER T WITH DIAERESIS', shcode=0x0074, specials={'char',0x0074,0x0308} },
	[0x1E98] = { unicodeslot=0x1E98, category='ll', description='LATIN SMALL LETTER W WITH RING ABOVE', shcode=0x0077, specials={'char',0x0077,0x030A} },
	[0x1E99] = { unicodeslot=0x1E99, category='ll', description='LATIN SMALL LETTER Y WITH RING ABOVE', shcode=0x0079, specials={'char',0x0079,0x030A} },
	[0x1E9A] = { unicodeslot=0x1E9A, category='ll', description='LATIN SMALL LETTER A WITH RIGHT HALF RING', shcode=0x0061, specials={'compat',0x0061,0x02BE} },
	[0x1E9B] = { unicodeslot=0x1E9B, category='ll', description='LATIN SMALL LETTER LONG S WITH DOT ABOVE', uccode=0x1E60, specials={'char',0x017F,0x0307} },
	[0x1EA0] = { unicodeslot=0x1EA0, category='lu', contextname='Adotbelow', description='LATIN CAPITAL LETTER A WITH DOT BELOW', shcode=0x0041, lccode=0x1EA1, specials={'char',0x0041,0x0323} },
	[0x1EA1] = { unicodeslot=0x1EA1, category='ll', contextname='adotbelow', description='LATIN SMALL LETTER A WITH DOT BELOW', shcode=0x0061, uccode=0x1EA0, specials={'char',0x0061,0x0323} },
	[0x1EA2] = { unicodeslot=0x1EA2, category='lu', contextname='Ahook', description='LATIN CAPITAL LETTER A WITH HOOK ABOVE', shcode=0x0041, lccode=0x1EA3, specials={'char',0x0041,0x0309} },
	[0x1EA3] = { unicodeslot=0x1EA3, category='ll', contextname='ahook', description='LATIN SMALL LETTER A WITH HOOK ABOVE', shcode=0x0061, uccode=0x1EA2, specials={'char',0x0061,0x0309} },
	[0x1EA4] = { unicodeslot=0x1EA4, category='lu', contextname='Acircumflexacute', description='LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE', shcode=0x0041, lccode=0x1EA5, specials={'char',0x00C2,0x0301} },
	[0x1EA5] = { unicodeslot=0x1EA5, category='ll', contextname='acircumflexacute', description='LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE', shcode=0x0061, uccode=0x1EA4, specials={'char',0x00E2,0x0301} },
	[0x1EA6] = { unicodeslot=0x1EA6, category='lu', contextname='Acircumflexgrave', description='LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE', shcode=0x0041, lccode=0x1EA7, specials={'char',0x00C2,0x0300} },
	[0x1EA7] = { unicodeslot=0x1EA7, category='ll', contextname='acircumflexgrave', description='LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE', shcode=0x0061, uccode=0x1EA6, specials={'char',0x00E2,0x0300} },
	[0x1EA8] = { unicodeslot=0x1EA8, category='lu', contextname='Acircumflexhook', description='LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE', shcode=0x0041, lccode=0x1EA9, specials={'char',0x00C2,0x0309} },
	[0x1EA9] = { unicodeslot=0x1EA9, category='ll', contextname='acircumflexhook', description='LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE', shcode=0x0061, uccode=0x1EA8, specials={'char',0x00E2,0x0309} },
	[0x1EAA] = { unicodeslot=0x1EAA, category='lu', contextname='Acircumflextilde', description='LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE', shcode=0x0041, lccode=0x1EAB, specials={'char',0x00C2,0x0303} },
	[0x1EAB] = { unicodeslot=0x1EAB, category='ll', contextname='acircumflextilde', description='LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE', shcode=0x0061, uccode=0x1EAA, specials={'char',0x00E2,0x0303} },
	[0x1EAC] = { unicodeslot=0x1EAC, category='lu', contextname='Acircumflexdotbelow', description='LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW', shcode=0x0041, lccode=0x1EAD, specials={'char',0x1EA0,0x0302} },
	[0x1EAD] = { unicodeslot=0x1EAD, category='ll', contextname='acircumflexdotbelow', description='LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW', shcode=0x0061, uccode=0x1EAC, specials={'char',0x1EA1,0x0302} },
	[0x1EAE] = { unicodeslot=0x1EAE, category='lu', contextname='Abreveacute', description='LATIN CAPITAL LETTER A WITH BREVE AND ACUTE', shcode=0x0041, lccode=0x1EAF, specials={'char',0x0102,0x0301} },
	[0x1EAF] = { unicodeslot=0x1EAF, category='ll', contextname='abreveacute', description='LATIN SMALL LETTER A WITH BREVE AND ACUTE', shcode=0x0061, uccode=0x1EAE, specials={'char',0x0103,0x0301} },
	[0x1EB0] = { unicodeslot=0x1EB0, category='lu', contextname='Abrevegrave', description='LATIN CAPITAL LETTER A WITH BREVE AND GRAVE', shcode=0x0041, lccode=0x1EB1, specials={'char',0x0102,0x0300} },
	[0x1EB1] = { unicodeslot=0x1EB1, category='ll', contextname='abrevegrave', description='LATIN SMALL LETTER A WITH BREVE AND GRAVE', shcode=0x0061, uccode=0x1EB0, specials={'char',0x0103,0x0300} },
	[0x1EB2] = { unicodeslot=0x1EB2, category='lu', contextname='Abrevehook', description='LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE', shcode=0x0041, lccode=0x1EB3, specials={'char',0x0102,0x0309} },
	[0x1EB3] = { unicodeslot=0x1EB3, category='ll', contextname='abrevehook', description='LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE', shcode=0x0061, uccode=0x1EB2, specials={'char',0x0103,0x0309} },
	[0x1EB4] = { unicodeslot=0x1EB4, category='lu', contextname='Abrevetilde', description='LATIN CAPITAL LETTER A WITH BREVE AND TILDE', shcode=0x0041, lccode=0x1EB5, specials={'char',0x0102,0x0303} },
	[0x1EB5] = { unicodeslot=0x1EB5, category='ll', contextname='abrevetilde', description='LATIN SMALL LETTER A WITH BREVE AND TILDE', shcode=0x0061, uccode=0x1EB4, specials={'char',0x0103,0x0303} },
	[0x1EB6] = { unicodeslot=0x1EB6, category='lu', contextname='Abrevedotbelow', description='LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW', shcode=0x0041, lccode=0x1EB7, specials={'char',0x1EA0,0x0306} },
	[0x1EB7] = { unicodeslot=0x1EB7, category='ll', contextname='abrevedotbelow', description='LATIN SMALL LETTER A WITH BREVE AND DOT BELOW', shcode=0x0061, uccode=0x1EB6, specials={'char',0x1EA1,0x0306} },
	[0x1EB8] = { unicodeslot=0x1EB8, category='lu', contextname='Edotbelow', description='LATIN CAPITAL LETTER E WITH DOT BELOW', shcode=0x0045, lccode=0x1EB9, specials={'char',0x0045,0x0323} },
	[0x1EB9] = { unicodeslot=0x1EB9, category='ll', contextname='edotbelow', description='LATIN SMALL LETTER E WITH DOT BELOW', shcode=0x0065, uccode=0x1EB8, specials={'char',0x0065,0x0323} },
	[0x1EBA] = { unicodeslot=0x1EBA, category='lu', contextname='Ehook', description='LATIN CAPITAL LETTER E WITH HOOK ABOVE', shcode=0x0045, lccode=0x1EBB, specials={'char',0x0045,0x0309} },
	[0x1EBB] = { unicodeslot=0x1EBB, category='ll', contextname='ehook', description='LATIN SMALL LETTER E WITH HOOK ABOVE', shcode=0x0065, uccode=0x1EBA, specials={'char',0x0065,0x0309} },
	[0x1EBC] = { unicodeslot=0x1EBC, category='lu', contextname='Etilde', description='LATIN CAPITAL LETTER E WITH TILDE', shcode=0x0045, lccode=0x1EBD, specials={'char',0x0045,0x0303} },
	[0x1EBD] = { unicodeslot=0x1EBD, category='ll', contextname='etilde', description='LATIN SMALL LETTER E WITH TILDE', shcode=0x0065, uccode=0x1EBC, specials={'char',0x0065,0x0303} },
	[0x1EBE] = { unicodeslot=0x1EBE, category='lu', contextname='Ecircumflexacute', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE', shcode=0x0045, lccode=0x1EBF, specials={'char',0x00CA,0x0301} },
	[0x1EBF] = { unicodeslot=0x1EBF, category='ll', contextname='ecircumflexacute', description='LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE', shcode=0x0065, uccode=0x1EBE, specials={'char',0x00EA,0x0301} },
	[0x1EC0] = { unicodeslot=0x1EC0, category='lu', contextname='Ecircumflexgrave', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE', shcode=0x0045, lccode=0x1EC1, specials={'char',0x00CA,0x0300} },
	[0x1EC1] = { unicodeslot=0x1EC1, category='ll', contextname='ecircumflexgrave', description='LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE', shcode=0x0065, uccode=0x1EC0, specials={'char',0x00EA,0x0300} },
	[0x1EC2] = { unicodeslot=0x1EC2, category='lu', contextname='Ecircumflexhook', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE', shcode=0x0045, lccode=0x1EC3, specials={'char',0x00CA,0x0309} },
	[0x1EC3] = { unicodeslot=0x1EC3, category='ll', contextname='ecircumflexhook', description='LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE', shcode=0x0065, uccode=0x1EC2, specials={'char',0x00EA,0x0309} },
	[0x1EC4] = { unicodeslot=0x1EC4, category='lu', contextname='Ecircumflextilde', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE', shcode=0x0045, lccode=0x1EC5, specials={'char',0x00CA,0x0303} },
	[0x1EC5] = { unicodeslot=0x1EC5, category='ll', contextname='ecircumflextilde', description='LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE', shcode=0x0065, uccode=0x1EC4, specials={'char',0x00EA,0x0303} },
	[0x1EC6] = { unicodeslot=0x1EC6, category='lu', contextname='Ecircumflexdotbelow', description='LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW', shcode=0x0045, lccode=0x1EC7, specials={'char',0x1EB8,0x0302} },
	[0x1EC7] = { unicodeslot=0x1EC7, category='ll', contextname='ecircumflexdotbelow', description='LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW', shcode=0x0065, uccode=0x1EC6, specials={'char',0x1EB9,0x0302} },
	[0x1EC8] = { unicodeslot=0x1EC8, category='lu', contextname='Ihook', description='LATIN CAPITAL LETTER I WITH HOOK ABOVE', shcode=0x0049, lccode=0x1EC9, specials={'char',0x0049,0x0309} },
	[0x1EC9] = { unicodeslot=0x1EC9, category='ll', contextname='ihook', description='LATIN SMALL LETTER I WITH HOOK ABOVE', shcode=0x0069, uccode=0x1EC8, specials={'char',0x0069,0x0309} },
	[0x1ECA] = { unicodeslot=0x1ECA, category='lu', contextname='Idotbelow', description='LATIN CAPITAL LETTER I WITH DOT BELOW', shcode=0x0049, lccode=0x1ECB, specials={'char',0x0049,0x0323} },
	[0x1ECB] = { unicodeslot=0x1ECB, category='ll', contextname='idotbelow', description='LATIN SMALL LETTER I WITH DOT BELOW', shcode=0x0069, uccode=0x1ECA, specials={'char',0x0069,0x0323} },
	[0x1ECC] = { unicodeslot=0x1ECC, category='lu', contextname='Odotbelow', description='LATIN CAPITAL LETTER O WITH DOT BELOW', shcode=0x004F, lccode=0x1ECD, specials={'char',0x004F,0x0323} },
	[0x1ECD] = { unicodeslot=0x1ECD, category='ll', contextname='odotbelow', description='LATIN SMALL LETTER O WITH DOT BELOW', shcode=0x006F, uccode=0x1ECC, specials={'char',0x006F,0x0323} },
	[0x1ECE] = { unicodeslot=0x1ECE, category='lu', contextname='Ohook', description='LATIN CAPITAL LETTER O WITH HOOK ABOVE', shcode=0x004F, lccode=0x1ECF, specials={'char',0x004F,0x0309} },
	[0x1ECF] = { unicodeslot=0x1ECF, category='ll', contextname='ohook', description='LATIN SMALL LETTER O WITH HOOK ABOVE', shcode=0x006F, uccode=0x1ECE, specials={'char',0x006F,0x0309} },
	[0x1ED0] = { unicodeslot=0x1ED0, category='lu', contextname='Ocircumflexacute', description='LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE', shcode=0x004F, lccode=0x1ED1, specials={'char',0x00D4,0x0301} },
	[0x1ED1] = { unicodeslot=0x1ED1, category='ll', contextname='ocircumflexacute', description='LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE', shcode=0x006F, uccode=0x1ED0, specials={'char',0x00F4,0x0301} },
	[0x1ED2] = { unicodeslot=0x1ED2, category='lu', contextname='Ocircumflexgrave', description='LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE', shcode=0x004F, lccode=0x1ED3, specials={'char',0x00D4,0x0300} },
	[0x1ED3] = { unicodeslot=0x1ED3, category='ll', contextname='ocircumflexgrave', description='LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE', shcode=0x006F, uccode=0x1ED2, specials={'char',0x00F4,0x0300} },
	[0x1ED4] = { unicodeslot=0x1ED4, category='lu', contextname='Ocircumflexhook', description='LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE', shcode=0x004F, lccode=0x1ED5, specials={'char',0x00D4,0x0309} },
	[0x1ED5] = { unicodeslot=0x1ED5, category='ll', contextname='ocircumflexhook', description='LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE', shcode=0x006F, uccode=0x1ED4, specials={'char',0x00F4,0x0309} },
	[0x1ED6] = { unicodeslot=0x1ED6, category='lu', contextname='Ocircumflextilde', description='LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE', shcode=0x004F, lccode=0x1ED7, specials={'char',0x00D4,0x0303} },
	[0x1ED7] = { unicodeslot=0x1ED7, category='ll', contextname='ocircumflextilde', description='LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE', shcode=0x006F, uccode=0x1ED6, specials={'char',0x00F4,0x0303} },
	[0x1ED8] = { unicodeslot=0x1ED8, category='lu', contextname='Ocircumflexdotbelow', description='LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW', shcode=0x004F, lccode=0x1ED9, specials={'char',0x1ECC,0x0302} },
	[0x1ED9] = { unicodeslot=0x1ED9, category='ll', contextname='ocircumflexdotbelow', description='LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW', shcode=0x006F, uccode=0x1ED8, specials={'char',0x1ECD,0x0302} },
	[0x1EDA] = { unicodeslot=0x1EDA, category='lu', contextname='Ohornacute', description='LATIN CAPITAL LETTER O WITH HORN AND ACUTE', shcode=0x004F, lccode=0x1EDB, specials={'char',0x01A0,0x0301} },
	[0x1EDB] = { unicodeslot=0x1EDB, category='ll', contextname='ohornacute', description='LATIN SMALL LETTER O WITH HORN AND ACUTE', shcode=0x006F, uccode=0x1EDA, specials={'char',0x01A1,0x0301} },
	[0x1EDC] = { unicodeslot=0x1EDC, category='lu', contextname='Ohorngrave', description='LATIN CAPITAL LETTER O WITH HORN AND GRAVE', shcode=0x004F, lccode=0x1EDD, specials={'char',0x01A0,0x0300} },
	[0x1EDD] = { unicodeslot=0x1EDD, category='ll', contextname='ohorngrave', description='LATIN SMALL LETTER O WITH HORN AND GRAVE', shcode=0x006F, uccode=0x1EDC, specials={'char',0x01A1,0x0300} },
	[0x1EDE] = { unicodeslot=0x1EDE, category='lu', contextname='Ohornhook', description='LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE', shcode=0x004F, lccode=0x1EDF, specials={'char',0x01A0,0x0309} },
	[0x1EDF] = { unicodeslot=0x1EDF, category='ll', contextname='ohornhook', description='LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE', shcode=0x006F, uccode=0x1EDE, specials={'char',0x01A1,0x0309} },
	[0x1EE0] = { unicodeslot=0x1EE0, category='lu', contextname='Ohorntilde', description='LATIN CAPITAL LETTER O WITH HORN AND TILDE', shcode=0x004F, lccode=0x1EE1, specials={'char',0x01A0,0x0303} },
	[0x1EE1] = { unicodeslot=0x1EE1, category='ll', contextname='ohorntilde', description='LATIN SMALL LETTER O WITH HORN AND TILDE', shcode=0x006F, uccode=0x1EE0, specials={'char',0x01A1,0x0303} },
	[0x1EE2] = { unicodeslot=0x1EE2, category='lu', contextname='Ohorndotbelow', description='LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW', shcode=0x004F, lccode=0x1EE3, specials={'char',0x01A0,0x0323} },
	[0x1EE3] = { unicodeslot=0x1EE3, category='ll', contextname='ohorndotbelow', description='LATIN SMALL LETTER O WITH HORN AND DOT BELOW', shcode=0x006F, uccode=0x1EE2, specials={'char',0x01A1,0x0323} },
	[0x1EE4] = { unicodeslot=0x1EE4, category='lu', contextname='Udotbelow', description='LATIN CAPITAL LETTER U WITH DOT BELOW', shcode=0x0055, lccode=0x1EE5, specials={'char',0x0055,0x0323} },
	[0x1EE5] = { unicodeslot=0x1EE5, category='ll', contextname='udotbelow', description='LATIN SMALL LETTER U WITH DOT BELOW', shcode=0x0075, uccode=0x1EE4, specials={'char',0x0075,0x0323} },
	[0x1EE6] = { unicodeslot=0x1EE6, category='lu', contextname='Uhook', description='LATIN CAPITAL LETTER U WITH HOOK ABOVE', shcode=0x0055, lccode=0x1EE7, specials={'char',0x0055,0x0309} },
	[0x1EE7] = { unicodeslot=0x1EE7, category='ll', contextname='uhook', description='LATIN SMALL LETTER U WITH HOOK ABOVE', shcode=0x0075, uccode=0x1EE6, specials={'char',0x0075,0x0309} },
	[0x1EE8] = { unicodeslot=0x1EE8, category='lu', contextname='Uhornacute', description='LATIN CAPITAL LETTER U WITH HORN AND ACUTE', shcode=0x0055, lccode=0x1EE9, specials={'char',0x01AF,0x0301} },
	[0x1EE9] = { unicodeslot=0x1EE9, category='ll', contextname='uhornacute', description='LATIN SMALL LETTER U WITH HORN AND ACUTE', shcode=0x0075, uccode=0x1EE8, specials={'char',0x01B0,0x0301} },
	[0x1EEA] = { unicodeslot=0x1EEA, category='lu', contextname='Uhorngrave', description='LATIN CAPITAL LETTER U WITH HORN AND GRAVE', shcode=0x0055, lccode=0x1EEB, specials={'char',0x01AF,0x0300} },
	[0x1EEB] = { unicodeslot=0x1EEB, category='ll', contextname='uhorngrave', description='LATIN SMALL LETTER U WITH HORN AND GRAVE', shcode=0x0075, uccode=0x1EEA, specials={'char',0x01B0,0x0300} },
	[0x1EEC] = { unicodeslot=0x1EEC, category='lu', contextname='Uhornhook', description='LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE', shcode=0x0055, lccode=0x1EED, specials={'char',0x01AF,0x0309} },
	[0x1EED] = { unicodeslot=0x1EED, category='ll', contextname='uhornhook', description='LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE', shcode=0x0075, uccode=0x1EEC, specials={'char',0x01B0,0x0309} },
	[0x1EEE] = { unicodeslot=0x1EEE, category='lu', contextname='Uhorntilde', description='LATIN CAPITAL LETTER U WITH HORN AND TILDE', shcode=0x0055, lccode=0x1EEF, specials={'char',0x01AF,0x0303} },
	[0x1EEF] = { unicodeslot=0x1EEF, category='ll', contextname='uhorntilde', description='LATIN SMALL LETTER U WITH HORN AND TILDE', shcode=0x0075, uccode=0x1EEE, specials={'char',0x01B0,0x0303} },
	[0x1EF0] = { unicodeslot=0x1EF0, category='lu', contextname='Uhorndotbelow', description='LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW', shcode=0x0055, lccode=0x1EF1, specials={'char',0x01AF,0x0323} },
	[0x1EF1] = { unicodeslot=0x1EF1, category='ll', contextname='uhorndotbelow', description='LATIN SMALL LETTER U WITH HORN AND DOT BELOW', shcode=0x0075, uccode=0x1EF0, specials={'char',0x01B0,0x0323} },
	[0x1EF2] = { unicodeslot=0x1EF2, category='lu', adobename='Ygrave', contextname='Ygrave', description='LATIN CAPITAL LETTER Y WITH GRAVE', shcode=0x0059, lccode=0x1EF3, specials={'char',0x0059,0x0300} },
	[0x1EF3] = { unicodeslot=0x1EF3, category='ll', adobename='ygrave', contextname='ygrave', description='LATIN SMALL LETTER Y WITH GRAVE', shcode=0x0079, uccode=0x1EF2, specials={'char',0x0079,0x0300} },
	[0x1EF4] = { unicodeslot=0x1EF4, category='lu', contextname='Ydotbelow', description='LATIN CAPITAL LETTER Y WITH DOT BELOW', shcode=0x0059, lccode=0x1EF5, specials={'char',0x0059,0x0323} },
	[0x1EF5] = { unicodeslot=0x1EF5, category='ll', contextname='ydotbelow', description='LATIN SMALL LETTER Y WITH DOT BELOW', shcode=0x0079, uccode=0x1EF4, specials={'char',0x0079,0x0323} },
	[0x1EF6] = { unicodeslot=0x1EF6, category='lu', contextname='Yhook', description='LATIN CAPITAL LETTER Y WITH HOOK ABOVE', shcode=0x0059, lccode=0x1EF7, specials={'char',0x0059,0x0309} },
	[0x1EF7] = { unicodeslot=0x1EF7, category='ll', contextname='yhook', description='LATIN SMALL LETTER Y WITH HOOK ABOVE', shcode=0x0079, uccode=0x1EF6, specials={'char',0x0079,0x0309} },
	[0x1EF8] = { unicodeslot=0x1EF8, category='lu', contextname='Ytilde', description='LATIN CAPITAL LETTER Y WITH TILDE', shcode=0x0059, lccode=0x1EF9, specials={'char',0x0059,0x0303} },
	[0x1EF9] = { unicodeslot=0x1EF9, category='ll', contextname='ytilde', description='LATIN SMALL LETTER Y WITH TILDE', shcode=0x0079, uccode=0x1EF8, specials={'char',0x0079,0x0303} },
	[0x1F00] = { unicodeslot=0x1F00, category='ll', contextname='greekalphapsili', description='GREEK SMALL LETTER ALPHA WITH PSILI', shcode=0x03B1, uccode=0x1F08, specials={'char',0x03B1,0x0313} },
	[0x1F01] = { unicodeslot=0x1F01, category='ll', contextname='greekalphadasia', description='GREEK SMALL LETTER ALPHA WITH DASIA', shcode=0x03B1, uccode=0x1F09, specials={'char',0x03B1,0x0314} },
	[0x1F02] = { unicodeslot=0x1F02, category='ll', contextname='greekalphapsilivaria', description='GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA', shcode=0x03B1, uccode=0x1F0A, specials={'char',0x1F00,0x0300} },
	[0x1F03] = { unicodeslot=0x1F03, category='ll', contextname='greekalphadasiavaria', description='GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA', shcode=0x03B1, uccode=0x1F0B, specials={'char',0x1F01,0x0300} },
	[0x1F04] = { unicodeslot=0x1F04, category='ll', contextname='greekalphapsilitonos', description='GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA', shcode=0x03B1, uccode=0x1F0C, specials={'char',0x1F00,0x0301} },
	[0x1F05] = { unicodeslot=0x1F05, category='ll', contextname='greekalphadasiatonos', description='GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA', shcode=0x03B1, uccode=0x1F0D, specials={'char',0x1F01,0x0301} },
	[0x1F06] = { unicodeslot=0x1F06, category='ll', contextname='greekalphapsiliperispomeni', description='GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI', shcode=0x03B1, uccode=0x1F0E, specials={'char',0x1F00,0x0342} },
	[0x1F07] = { unicodeslot=0x1F07, category='ll', contextname='greekalphadasiaperispomeni', description='GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI', shcode=0x03B1, uccode=0x1F0F, specials={'char',0x1F01,0x0342} },
	[0x1F08] = { unicodeslot=0x1F08, category='lu', contextname='greekAlphapsili', description='GREEK CAPITAL LETTER ALPHA WITH PSILI', shcode=0x0391, lccode=0x1F00, specials={'char',0x0391,0x0313} },
	[0x1F09] = { unicodeslot=0x1F09, category='lu', contextname='greekAlphadasia', description='GREEK CAPITAL LETTER ALPHA WITH DASIA', shcode=0x0391, lccode=0x1F01, specials={'char',0x0391,0x0314} },
	[0x1F0A] = { unicodeslot=0x1F0A, category='lu', contextname='greekAlphapsilivaria', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA', shcode=0x0391, lccode=0x1F02, specials={'char',0x1F08,0x0300} },
	[0x1F0B] = { unicodeslot=0x1F0B, category='lu', contextname='greekAlphadasiavaria', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA', shcode=0x0391, lccode=0x1F03, specials={'char',0x1F09,0x0300} },
	[0x1F0C] = { unicodeslot=0x1F0C, category='lu', contextname='greekAlphapsilitonos', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA', shcode=0x0391, lccode=0x1F04, specials={'char',0x1F08,0x0301} },
	[0x1F0D] = { unicodeslot=0x1F0D, category='lu', contextname='greekAlphadasiatonos', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA', shcode=0x0391, lccode=0x1F05, specials={'char',0x1F09,0x0301} },
	[0x1F0E] = { unicodeslot=0x1F0E, category='lu', contextname='greekAlphapsiliperispomeni', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI', shcode=0x0391, lccode=0x1F06, specials={'char',0x1F08,0x0342} },
	[0x1F0F] = { unicodeslot=0x1F0F, category='lu', contextname='greekAlphadasiaperispomeni', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI', shcode=0x0391, lccode=0x1F07, specials={'char',0x1F09,0x0342} },
	[0x1F10] = { unicodeslot=0x1F10, category='ll', contextname='greekepsilonpsili', description='GREEK SMALL LETTER EPSILON WITH PSILI', shcode=0x03B5, uccode=0x1F18, specials={'char',0x03B5,0x0313} },
	[0x1F11] = { unicodeslot=0x1F11, category='ll', contextname='greekepsilondasia', description='GREEK SMALL LETTER EPSILON WITH DASIA', shcode=0x03B5, uccode=0x1F19, specials={'char',0x03B5,0x0314} },
	[0x1F12] = { unicodeslot=0x1F12, category='ll', contextname='greekepsilonpsilivaria', description='GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA', shcode=0x03B5, uccode=0x1F1A, specials={'char',0x1F10,0x0300} },
	[0x1F13] = { unicodeslot=0x1F13, category='ll', contextname='greekepsilondasiavaria', description='GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA', shcode=0x03B5, uccode=0x1F1B, specials={'char',0x1F11,0x0300} },
	[0x1F14] = { unicodeslot=0x1F14, category='ll', contextname='greekepsilonpsilitonos', description='GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA', shcode=0x03B5, uccode=0x1F1C, specials={'char',0x1F10,0x0301} },
	[0x1F15] = { unicodeslot=0x1F15, category='ll', contextname='greekepsilondasiatonos', description='GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA', shcode=0x03B5, uccode=0x1F1D, specials={'char',0x1F11,0x0301} },
	[0x1F18] = { unicodeslot=0x1F18, category='lu', contextname='greekEpsilonpsili', description='GREEK CAPITAL LETTER EPSILON WITH PSILI', shcode=0x0395, lccode=0x1F10, specials={'char',0x0395,0x0313} },
	[0x1F19] = { unicodeslot=0x1F19, category='lu', contextname='greekEpsilondasia', description='GREEK CAPITAL LETTER EPSILON WITH DASIA', shcode=0x0395, lccode=0x1F11, specials={'char',0x0395,0x0314} },
	[0x1F1A] = { unicodeslot=0x1F1A, category='lu', contextname='greekEpsilonpsilivaria', description='GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA', shcode=0x0395, lccode=0x1F12, specials={'char',0x1F18,0x0300} },
	[0x1F1B] = { unicodeslot=0x1F1B, category='lu', contextname='greekEpsilondasiavaria', description='GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA', shcode=0x0395, lccode=0x1F13, specials={'char',0x1F19,0x0300} },
	[0x1F1C] = { unicodeslot=0x1F1C, category='lu', contextname='greekEpsilonpsilitonos', description='GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA', shcode=0x0395, lccode=0x1F14, specials={'char',0x1F18,0x0301} },
	[0x1F1D] = { unicodeslot=0x1F1D, category='lu', contextname='greekEpsilondasiatonos', description='GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA', shcode=0x0395, lccode=0x1F15, specials={'char',0x1F19,0x0301} },
	[0x1F20] = { unicodeslot=0x1F20, category='ll', contextname='greeketapsili', description='GREEK SMALL LETTER ETA WITH PSILI', shcode=0x03B7, uccode=0x1F28, specials={'char',0x03B7,0x0313} },
	[0x1F21] = { unicodeslot=0x1F21, category='ll', contextname='greeketadasia', description='GREEK SMALL LETTER ETA WITH DASIA', shcode=0x03B7, uccode=0x1F29, specials={'char',0x03B7,0x0314} },
	[0x1F22] = { unicodeslot=0x1F22, category='ll', contextname='greeketapsilivaria', description='GREEK SMALL LETTER ETA WITH PSILI AND VARIA', shcode=0x03B7, uccode=0x1F2A, specials={'char',0x1F20,0x0300} },
	[0x1F23] = { unicodeslot=0x1F23, category='ll', contextname='greeketadasiavaria', description='GREEK SMALL LETTER ETA WITH DASIA AND VARIA', shcode=0x03B7, uccode=0x1F2B, specials={'char',0x1F21,0x0300} },
	[0x1F24] = { unicodeslot=0x1F24, category='ll', contextname='greeketapsilitonos', description='GREEK SMALL LETTER ETA WITH PSILI AND OXIA', shcode=0x03B7, uccode=0x1F2C, specials={'char',0x1F20,0x0301} },
	[0x1F25] = { unicodeslot=0x1F25, category='ll', contextname='greeketadasiatonos', description='GREEK SMALL LETTER ETA WITH DASIA AND OXIA', shcode=0x03B7, uccode=0x1F2D, specials={'char',0x1F21,0x0301} },
	[0x1F26] = { unicodeslot=0x1F26, category='ll', contextname='greeketapsiliperispomeni', description='GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI', shcode=0x03B7, uccode=0x1F2E, specials={'char',0x1F20,0x0342} },
	[0x1F27] = { unicodeslot=0x1F27, category='ll', contextname='greeketadasiaperispomeni', description='GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI', shcode=0x03B7, uccode=0x1F2F, specials={'char',0x1F21,0x0342} },
	[0x1F28] = { unicodeslot=0x1F28, category='lu', contextname='greekEtapsili', description='GREEK CAPITAL LETTER ETA WITH PSILI', shcode=0x0397, lccode=0x1F20, specials={'char',0x0397,0x0313} },
	[0x1F29] = { unicodeslot=0x1F29, category='lu', contextname='greekEtadasia', description='GREEK CAPITAL LETTER ETA WITH DASIA', shcode=0x0397, lccode=0x1F21, specials={'char',0x0397,0x0314} },
	[0x1F2A] = { unicodeslot=0x1F2A, category='lu', contextname='greekEtapsilivaria', description='GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA', shcode=0x0397, lccode=0x1F22, specials={'char',0x1F28,0x0300} },
	[0x1F2B] = { unicodeslot=0x1F2B, category='lu', contextname='greekEtadasiavaria', description='GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA', shcode=0x0397, lccode=0x1F23, specials={'char',0x1F29,0x0300} },
	[0x1F2C] = { unicodeslot=0x1F2C, category='lu', contextname='greekEtapsilitonos', description='GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA', shcode=0x0397, lccode=0x1F24, specials={'char',0x1F28,0x0301} },
	[0x1F2D] = { unicodeslot=0x1F2D, category='lu', contextname='greekEtadasiatonos', description='GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA', shcode=0x0397, lccode=0x1F25, specials={'char',0x1F29,0x0301} },
	[0x1F2E] = { unicodeslot=0x1F2E, category='lu', contextname='greekEtapsiliperispomeni', description='GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI', shcode=0x0397, lccode=0x1F26, specials={'char',0x1F28,0x0342} },
	[0x1F2F] = { unicodeslot=0x1F2F, category='lu', contextname='greekEtadasiaperispomeni', description='GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI', shcode=0x0397, lccode=0x1F27, specials={'char',0x1F29,0x0342} },
	[0x1F30] = { unicodeslot=0x1F30, category='ll', contextname='greekiotapsili', description='GREEK SMALL LETTER IOTA WITH PSILI', shcode=0x03B9, uccode=0x1F38, specials={'char',0x03B9,0x0313} },
	[0x1F31] = { unicodeslot=0x1F31, category='ll', contextname='greekiotadasia', description='GREEK SMALL LETTER IOTA WITH DASIA', shcode=0x03B9, uccode=0x1F39, specials={'char',0x03B9,0x0314} },
	[0x1F32] = { unicodeslot=0x1F32, category='ll', contextname='greekiotapsilivaria', description='GREEK SMALL LETTER IOTA WITH PSILI AND VARIA', shcode=0x03B9, uccode=0x1F3A, specials={'char',0x1F30,0x0300} },
	[0x1F33] = { unicodeslot=0x1F33, category='ll', contextname='greekiotadasiavaria', description='GREEK SMALL LETTER IOTA WITH DASIA AND VARIA', shcode=0x03B9, uccode=0x1F3B, specials={'char',0x1F31,0x0300} },
	[0x1F34] = { unicodeslot=0x1F34, category='ll', contextname='greekiotapsilitonos', description='GREEK SMALL LETTER IOTA WITH PSILI AND OXIA', shcode=0x03B9, uccode=0x1F3C, specials={'char',0x1F30,0x0301} },
	[0x1F35] = { unicodeslot=0x1F35, category='ll', contextname='greekiotadasiatonos', description='GREEK SMALL LETTER IOTA WITH DASIA AND OXIA', shcode=0x03B9, uccode=0x1F3D, specials={'char',0x1F31,0x0301} },
	[0x1F36] = { unicodeslot=0x1F36, category='ll', contextname='greekiotapsiliperispomeni', description='GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI', shcode=0x03B9, uccode=0x1F3E, specials={'char',0x1F30,0x0342} },
	[0x1F37] = { unicodeslot=0x1F37, category='ll', contextname='greekiotadasiaperispomeni', description='GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI', shcode=0x03B9, uccode=0x1F3F, specials={'char',0x1F31,0x0342} },
	[0x1F38] = { unicodeslot=0x1F38, category='lu', contextname='greekIotapsili', description='GREEK CAPITAL LETTER IOTA WITH PSILI', shcode=0x0399, lccode=0x1F30, specials={'char',0x0399,0x0313} },
	[0x1F39] = { unicodeslot=0x1F39, category='lu', contextname='greekIotadasia', description='GREEK CAPITAL LETTER IOTA WITH DASIA', shcode=0x0399, lccode=0x1F31, specials={'char',0x0399,0x0314} },
	[0x1F3A] = { unicodeslot=0x1F3A, category='lu', contextname='greekIotapsilivaria', description='GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA', shcode=0x0399, lccode=0x1F32, specials={'char',0x1F38,0x0300} },
	[0x1F3B] = { unicodeslot=0x1F3B, category='lu', contextname='greekIotadasiavaria', description='GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA', shcode=0x0399, lccode=0x1F33, specials={'char',0x1F39,0x0300} },
	[0x1F3C] = { unicodeslot=0x1F3C, category='lu', contextname='greekIotapsilitonos', description='GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA', shcode=0x0399, lccode=0x1F34, specials={'char',0x1F38,0x0301} },
	[0x1F3D] = { unicodeslot=0x1F3D, category='lu', contextname='greekIotadasiatonos', description='GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA', shcode=0x0399, lccode=0x1F35, specials={'char',0x1F39,0x0301} },
	[0x1F3E] = { unicodeslot=0x1F3E, category='lu', contextname='greekIotapsiliperispomeni', description='GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI', shcode=0x0399, lccode=0x1F36, specials={'char',0x1F38,0x0342} },
	[0x1F3F] = { unicodeslot=0x1F3F, category='lu', contextname='greekIotadasiaperispomeni', description='GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI', shcode=0x0399, lccode=0x1F37, specials={'char',0x1F39,0x0342} },
	[0x1F40] = { unicodeslot=0x1F40, category='ll', contextname='greekomicronpsili', description='GREEK SMALL LETTER OMICRON WITH PSILI', shcode=0x03BF, uccode=0x1F48, specials={'char',0x03BF,0x0313} },
	[0x1F41] = { unicodeslot=0x1F41, category='ll', contextname='greekomicrondasia', description='GREEK SMALL LETTER OMICRON WITH DASIA', shcode=0x03BF, uccode=0x1F49, specials={'char',0x03BF,0x0314} },
	[0x1F42] = { unicodeslot=0x1F42, category='ll', contextname='greekomicronpsilivaria', description='GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA', shcode=0x03BF, uccode=0x1F4A, specials={'char',0x1F40,0x0300} },
	[0x1F43] = { unicodeslot=0x1F43, category='ll', contextname='greekomicrondasiavaria', description='GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA', shcode=0x03BF, uccode=0x1F4B, specials={'char',0x1F41,0x0300} },
	[0x1F44] = { unicodeslot=0x1F44, category='ll', contextname='greekomicronpsilitonos', description='GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA', shcode=0x03BF, uccode=0x1F4C, specials={'char',0x1F40,0x0301} },
	[0x1F45] = { unicodeslot=0x1F45, category='ll', contextname='greekomicrondasiatonos', description='GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA', shcode=0x03BF, uccode=0x1F4D, specials={'char',0x1F41,0x0301} },
	[0x1F48] = { unicodeslot=0x1F48, category='lu', contextname='greekOmicronpsili', description='GREEK CAPITAL LETTER OMICRON WITH PSILI', shcode=0x039F, lccode=0x1F40, specials={'char',0x039F,0x0313} },
	[0x1F49] = { unicodeslot=0x1F49, category='lu', contextname='greekOmicrondasia', description='GREEK CAPITAL LETTER OMICRON WITH DASIA', shcode=0x039F, lccode=0x1F41, specials={'char',0x039F,0x0314} },
	[0x1F4A] = { unicodeslot=0x1F4A, category='lu', contextname='greekOmicronpsilivaria', description='GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA', shcode=0x039F, lccode=0x1F42, specials={'char',0x1F48,0x0300} },
	[0x1F4B] = { unicodeslot=0x1F4B, category='lu', contextname='greekOmicrondasiavaria', description='GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA', shcode=0x039F, lccode=0x1F43, specials={'char',0x1F49,0x0300} },
	[0x1F4C] = { unicodeslot=0x1F4C, category='lu', contextname='greekOmicronpsilitonos', description='GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA', shcode=0x039F, lccode=0x1F44, specials={'char',0x1F48,0x0301} },
	[0x1F4D] = { unicodeslot=0x1F4D, category='lu', contextname='greekOmicrondasiatonos', description='GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA', shcode=0x039F, lccode=0x1F45, specials={'char',0x1F49,0x0301} },
	[0x1F50] = { unicodeslot=0x1F50, category='ll', contextname='greekupsilonpsili', description='GREEK SMALL LETTER UPSILON WITH PSILI', shcode=0x03C5, specials={'char',0x03C5,0x0313} },
	[0x1F51] = { unicodeslot=0x1F51, category='ll', contextname='greekupsilondasia', description='GREEK SMALL LETTER UPSILON WITH DASIA', shcode=0x03C5, uccode=0x1F59, specials={'char',0x03C5,0x0314} },
	[0x1F52] = { unicodeslot=0x1F52, category='ll', contextname='greekupsilonpsilivaria', description='GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA', shcode=0x03C5, specials={'char',0x1F50,0x0300} },
	[0x1F53] = { unicodeslot=0x1F53, category='ll', contextname='greekupsilondasiavaria', description='GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA', shcode=0x03C5, uccode=0x1F5B, specials={'char',0x1F51,0x0300} },
	[0x1F54] = { unicodeslot=0x1F54, category='ll', contextname='greekupsilonpsilitonos', description='GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA', shcode=0x03C5, specials={'char',0x1F50,0x0301} },
	[0x1F55] = { unicodeslot=0x1F55, category='ll', contextname='greekupsilondasiatonos', description='GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA', shcode=0x03C5, uccode=0x1F5D, specials={'char',0x1F51,0x0301} },
	[0x1F56] = { unicodeslot=0x1F56, category='ll', contextname='greekupsilonpsiliperispomeni', description='GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI', shcode=0x03C5, specials={'char',0x1F50,0x0342} },
	[0x1F57] = { unicodeslot=0x1F57, category='ll', contextname='greekupsilondasiaperispomeni', description='GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI', shcode=0x03C5, uccode=0x1F5F, specials={'char',0x1F51,0x0342} },
	[0x1F59] = { unicodeslot=0x1F59, category='lu', contextname='greekUpsilondasia', description='GREEK CAPITAL LETTER UPSILON WITH DASIA', shcode=0x03A5, lccode=0x1F51, specials={'char',0x03A5,0x0314} },
	[0x1F5B] = { unicodeslot=0x1F5B, category='lu', contextname='greekUpsilondasiavaria', description='GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA', shcode=0x03A5, lccode=0x1F53, specials={'char',0x1F59,0x0300} },
	[0x1F5D] = { unicodeslot=0x1F5D, category='lu', contextname='greekUpsilondasiatonos', description='GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA', shcode=0x03A5, lccode=0x1F55, specials={'char',0x1F59,0x0301} },
	[0x1F5F] = { unicodeslot=0x1F5F, category='lu', contextname='greekUpsilondasiaperispomeni', description='GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI', shcode=0x03A5, lccode=0x1F57, specials={'char',0x1F59,0x0342} },
	[0x1F60] = { unicodeslot=0x1F60, category='ll', contextname='greekomegapsili', description='GREEK SMALL LETTER OMEGA WITH PSILI', shcode=0x03C9, uccode=0x1F68, specials={'char',0x03C9,0x0313} },
	[0x1F61] = { unicodeslot=0x1F61, category='ll', contextname='greekomegadasia', description='GREEK SMALL LETTER OMEGA WITH DASIA', shcode=0x03C9, uccode=0x1F69, specials={'char',0x03C9,0x0314} },
	[0x1F62] = { unicodeslot=0x1F62, category='ll', contextname='greekomegapsilivaria', description='GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA', shcode=0x03C9, uccode=0x1F6A, specials={'char',0x1F60,0x0300} },
	[0x1F63] = { unicodeslot=0x1F63, category='ll', contextname='greekomegadasiavaria', description='GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA', shcode=0x03C9, uccode=0x1F6B, specials={'char',0x1F61,0x0300} },
	[0x1F64] = { unicodeslot=0x1F64, category='ll', contextname='greekomegapsilitonos', description='GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA', shcode=0x03C9, uccode=0x1F6C, specials={'char',0x1F60,0x0301} },
	[0x1F65] = { unicodeslot=0x1F65, category='ll', contextname='greekomegadasiatonos', description='GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA', shcode=0x03C9, uccode=0x1F6D, specials={'char',0x1F61,0x0301} },
	[0x1F66] = { unicodeslot=0x1F66, category='ll', contextname='greekomegapsiliperispomeni', description='GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI', shcode=0x03C9, uccode=0x1F6E, specials={'char',0x1F60,0x0342} },
	[0x1F67] = { unicodeslot=0x1F67, category='ll', contextname='greekomegadasiaperispomeni', description='GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI', shcode=0x03C9, uccode=0x1F6F, specials={'char',0x1F61,0x0342} },
	[0x1F68] = { unicodeslot=0x1F68, category='lu', contextname='greekOmegapsili', description='GREEK CAPITAL LETTER OMEGA WITH PSILI', shcode=0x03A9, lccode=0x1F60, specials={'char',0x03A9,0x0313} },
	[0x1F69] = { unicodeslot=0x1F69, category='lu', contextname='greekOmegadasia', description='GREEK CAPITAL LETTER OMEGA WITH DASIA', shcode=0x03A9, lccode=0x1F61, specials={'char',0x03A9,0x0314} },
	[0x1F6A] = { unicodeslot=0x1F6A, category='lu', contextname='greekOmegapsilivaria', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA', shcode=0x03A9, lccode=0x1F62, specials={'char',0x1F68,0x0300} },
	[0x1F6B] = { unicodeslot=0x1F6B, category='lu', contextname='greekOmegadasiavaria', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA', shcode=0x03A9, lccode=0x1F63, specials={'char',0x1F69,0x0300} },
	[0x1F6C] = { unicodeslot=0x1F6C, category='lu', contextname='greekOmegapsilitonos', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA', shcode=0x03A9, lccode=0x1F64, specials={'char',0x1F68,0x0301} },
	[0x1F6D] = { unicodeslot=0x1F6D, category='lu', contextname='greekOmegadasiatonos', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA', shcode=0x03A9, lccode=0x1F65, specials={'char',0x1F69,0x0301} },
	[0x1F6E] = { unicodeslot=0x1F6E, category='lu', contextname='greekOmegapsiliperispomeni', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI', shcode=0x03A9, lccode=0x1F66, specials={'char',0x1F68,0x0342} },
	[0x1F6F] = { unicodeslot=0x1F6F, category='lu', contextname='greekOmegadasiaperispomeni', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI', shcode=0x03A9, lccode=0x1F67, specials={'char',0x1F69,0x0342} },
	[0x1F70] = { unicodeslot=0x1F70, category='ll', contextname='greekalphavaria', description='GREEK SMALL LETTER ALPHA WITH VARIA', shcode=0x03B1, uccode=0x1FBA, specials={'char',0x03B1,0x0300} },
	[0x1F71] = { unicodeslot=0x1F71, category='ll', contextname='greekalphaoxia', description='GREEK SMALL LETTER ALPHA WITH OXIA', shcode=0x03B1, uccode=0x1FBB, specials={'char',0x03AC} },
	[0x1F72] = { unicodeslot=0x1F72, category='ll', contextname='greekepsilonvaria', description='GREEK SMALL LETTER EPSILON WITH VARIA', shcode=0x03B5, uccode=0x1FC8, specials={'char',0x03B5,0x0300} },
	[0x1F73] = { unicodeslot=0x1F73, category='ll', contextname='greekepsilonoxia', description='GREEK SMALL LETTER EPSILON WITH OXIA', shcode=0x03B5, uccode=0x1FC9, specials={'char',0x03AD} },
	[0x1F74] = { unicodeslot=0x1F74, category='ll', contextname='greeketavaria', description='GREEK SMALL LETTER ETA WITH VARIA', shcode=0x03B7, uccode=0x1FCA, specials={'char',0x03B7,0x0300} },
	[0x1F75] = { unicodeslot=0x1F75, category='ll', contextname='greeketaoxia', description='GREEK SMALL LETTER ETA WITH OXIA', shcode=0x03B7, uccode=0x1FCB, specials={'char',0x03AE} },
	[0x1F76] = { unicodeslot=0x1F76, category='ll', contextname='greekiotavaria', description='GREEK SMALL LETTER IOTA WITH VARIA', shcode=0x03B9, uccode=0x1FDA, specials={'char',0x03B9,0x0300} },
	[0x1F77] = { unicodeslot=0x1F77, category='ll', contextname='greekiotaoxia', description='GREEK SMALL LETTER IOTA WITH OXIA', shcode=0x03B9, uccode=0x1FDB, specials={'char',0x03AF} },
	[0x1F78] = { unicodeslot=0x1F78, category='ll', contextname='greekomicronvaria', description='GREEK SMALL LETTER OMICRON WITH VARIA', shcode=0x03BF, uccode=0x1FF8, specials={'char',0x03BF,0x0300} },
	[0x1F79] = { unicodeslot=0x1F79, category='ll', contextname='greekomicronoxia', description='GREEK SMALL LETTER OMICRON WITH OXIA', shcode=0x03BF, uccode=0x1FF9, specials={'char',0x03CC} },
	[0x1F7A] = { unicodeslot=0x1F7A, category='ll', contextname='greekupsilonvaria', description='GREEK SMALL LETTER UPSILON WITH VARIA', shcode=0x03C5, uccode=0x1FEA, specials={'char',0x03C5,0x0300} },
	[0x1F7B] = { unicodeslot=0x1F7B, category='ll', contextname='greekupsilonoxia', description='GREEK SMALL LETTER UPSILON WITH OXIA', shcode=0x03C5, uccode=0x1FEB, specials={'char',0x03CD} },
	[0x1F7C] = { unicodeslot=0x1F7C, category='ll', contextname='greekomegavaria', description='GREEK SMALL LETTER OMEGA WITH VARIA', shcode=0x03C9, uccode=0x1FFA, specials={'char',0x03C9,0x0300} },
	[0x1F7D] = { unicodeslot=0x1F7D, category='ll', contextname='greekomegaoxia', description='GREEK SMALL LETTER OMEGA WITH OXIA', shcode=0x03C9, uccode=0x1FFB, specials={'char',0x03CE} },
	[0x1F80] = { unicodeslot=0x1F80, category='ll', contextname='greekalphaiotasubpsili', description='GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F88, specials={'char',0x1F00,0x0345} },
	[0x1F81] = { unicodeslot=0x1F81, category='ll', contextname='greekalphaiotasubdasia', description='GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F89, specials={'char',0x1F01,0x0345} },
	[0x1F82] = { unicodeslot=0x1F82, category='ll', contextname='greekalphaiotasubpsilivaria', description='GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F8A, specials={'char',0x1F02,0x0345} },
	[0x1F83] = { unicodeslot=0x1F83, category='ll', contextname='greekalphaiotasubdasiavaria', description='GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F8B, specials={'char',0x1F03,0x0345} },
	[0x1F84] = { unicodeslot=0x1F84, category='ll', contextname='greekalphaiotasubpsilitonos', description='GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F8C, specials={'char',0x1F04,0x0345} },
	[0x1F85] = { unicodeslot=0x1F85, category='ll', contextname='greekalphaiotasubdasiatonos', description='GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F8D, specials={'char',0x1F05,0x0345} },
	[0x1F86] = { unicodeslot=0x1F86, category='ll', contextname='greekalphaiotasubpsiliperispomeni', description='GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F8E, specials={'char',0x1F06,0x0345} },
	[0x1F87] = { unicodeslot=0x1F87, category='ll', contextname='greekalphaiotasubdasiaperispomeni', description='GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1F8F, specials={'char',0x1F07,0x0345} },
	[0x1F88] = { unicodeslot=0x1F88, category='lt', contextname='greekAlphaiotasubpsili', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F80, specials={'char',0x1F08,0x0345} },
	[0x1F89] = { unicodeslot=0x1F89, category='lt', contextname='greekAlphaiotasubdasia', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F81, specials={'char',0x1F09,0x0345} },
	[0x1F8A] = { unicodeslot=0x1F8A, category='lt', contextname='greekAlphaiotasubpsilivaria', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F82, specials={'char',0x1F0A,0x0345} },
	[0x1F8B] = { unicodeslot=0x1F8B, category='lt', contextname='greekAlphaiotasubdasiavaria', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F83, specials={'char',0x1F0B,0x0345} },
	[0x1F8C] = { unicodeslot=0x1F8C, category='lt', contextname='greekAlphaiotasubpsilitonos', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F84, specials={'char',0x1F0C,0x0345} },
	[0x1F8D] = { unicodeslot=0x1F8D, category='lt', contextname='greekAlphaiotasubdasiatonos', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F85, specials={'char',0x1F0D,0x0345} },
	[0x1F8E] = { unicodeslot=0x1F8E, category='lt', contextname='greekAlphaiotasubpsiliperispomeni', description='GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F86, specials={'char',0x1F0E,0x0345} },
	[0x1F8F] = { unicodeslot=0x1F8F, category='lt', contextname='greekAlphaiotasubdasiaperispomeni', description='GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI', shcode=0x0391, lccode=0x1F87, specials={'char',0x1F0F,0x0345} },
	[0x1F90] = { unicodeslot=0x1F90, category='ll', contextname='greeketaiotasubpsili', description='GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F98, specials={'char',0x1F20,0x0345} },
	[0x1F91] = { unicodeslot=0x1F91, category='ll', contextname='greeketaiotasubdasia', description='GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F99, specials={'char',0x1F21,0x0345} },
	[0x1F92] = { unicodeslot=0x1F92, category='ll', contextname='greeketaiotasubpsilivaria', description='GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F9A, specials={'char',0x1F22,0x0345} },
	[0x1F93] = { unicodeslot=0x1F93, category='ll', contextname='greeketaiotasubdasiavaria', description='GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F9B, specials={'char',0x1F23,0x0345} },
	[0x1F94] = { unicodeslot=0x1F94, category='ll', contextname='greeketaiotasubpsilitonos', description='GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F9C, specials={'char',0x1F24,0x0345} },
	[0x1F95] = { unicodeslot=0x1F95, category='ll', contextname='greeketaiotasubdasiatonos', description='GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F9D, specials={'char',0x1F25,0x0345} },
	[0x1F96] = { unicodeslot=0x1F96, category='ll', contextname='greeketaiotasubpsiliperispomeni', description='GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F9E, specials={'char',0x1F26,0x0345} },
	[0x1F97] = { unicodeslot=0x1F97, category='ll', contextname='greeketaiotasubdasiaperispomeni', description='GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1F9F, specials={'char',0x1F27,0x0345} },
	[0x1F98] = { unicodeslot=0x1F98, category='lt', contextname='greekEtaiotasubpsili', description='GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F90, specials={'char',0x1F28,0x0345} },
	[0x1F99] = { unicodeslot=0x1F99, category='lt', contextname='greekEtaiotasubdasia', description='GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F91, specials={'char',0x1F29,0x0345} },
	[0x1F9A] = { unicodeslot=0x1F9A, category='lt', contextname='greekEtaiotasubpsilivaria', description='GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F92, specials={'char',0x1F2A,0x0345} },
	[0x1F9B] = { unicodeslot=0x1F9B, category='lt', contextname='greekEtaiotasubdasiavaria', description='GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F93, specials={'char',0x1F2B,0x0345} },
	[0x1F9C] = { unicodeslot=0x1F9C, category='lt', contextname='greekEtaiotasubpsilitonos', description='GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F94, specials={'char',0x1F2C,0x0345} },
	[0x1F9D] = { unicodeslot=0x1F9D, category='lt', contextname='greekEtaiotasubdasiatonos', description='GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F95, specials={'char',0x1F2D,0x0345} },
	[0x1F9E] = { unicodeslot=0x1F9E, category='lt', contextname='greekEtaiotasubpsiliperispomeni', description='GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F96, specials={'char',0x1F2E,0x0345} },
	[0x1F9F] = { unicodeslot=0x1F9F, category='lt', contextname='greekEtaiotasubdasiaperispomeni', description='GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI', shcode=0x0397, lccode=0x1F97, specials={'char',0x1F2F,0x0345} },
	[0x1FA0] = { unicodeslot=0x1FA0, category='ll', contextname='greekomegaiotasubpsili', description='GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FA8, specials={'char',0x1F60,0x0345} },
	[0x1FA1] = { unicodeslot=0x1FA1, category='ll', contextname='greekomegaiotasubdasia', description='GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FA9, specials={'char',0x1F61,0x0345} },
	[0x1FA2] = { unicodeslot=0x1FA2, category='ll', contextname='greekomegaiotasubpsilivaria', description='GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FAA, specials={'char',0x1F62,0x0345} },
	[0x1FA3] = { unicodeslot=0x1FA3, category='ll', contextname='greekomegaiotasubdasiavaria', description='GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FAB, specials={'char',0x1F63,0x0345} },
	[0x1FA4] = { unicodeslot=0x1FA4, category='ll', contextname='greekomegaiotasubpsilitonos', description='GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FAC, specials={'char',0x1F64,0x0345} },
	[0x1FA5] = { unicodeslot=0x1FA5, category='ll', contextname='greekomegaiotasubdasiatonos', description='GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FAD, specials={'char',0x1F65,0x0345} },
	[0x1FA6] = { unicodeslot=0x1FA6, category='ll', contextname='greekomegaiotasubpsiliperispomeni', description='GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FAE, specials={'char',0x1F66,0x0345} },
	[0x1FA7] = { unicodeslot=0x1FA7, category='ll', contextname='greekomegaiotasubdasiaperispomeni', description='GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FAF, specials={'char',0x1F67,0x0345} },
	[0x1FA8] = { unicodeslot=0x1FA8, category='lt', contextname='greekOmegaiotasubpsili', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA0, specials={'char',0x1F68,0x0345} },
	[0x1FA9] = { unicodeslot=0x1FA9, category='lt', contextname='greekOmegaiotasubdasia', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA1, specials={'char',0x1F69,0x0345} },
	[0x1FAA] = { unicodeslot=0x1FAA, category='lt', contextname='greekOmegaiotasubpsilivaria', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA2, specials={'char',0x1F6A,0x0345} },
	[0x1FAB] = { unicodeslot=0x1FAB, category='lt', contextname='greekOmegaiotasubdasiavaria', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA3, specials={'char',0x1F6B,0x0345} },
	[0x1FAC] = { unicodeslot=0x1FAC, category='lt', contextname='greekOmegaiotasubpsilitonos', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA4, specials={'char',0x1F6C,0x0345} },
	[0x1FAD] = { unicodeslot=0x1FAD, category='lt', contextname='greekOmegaiotasubdasiatonos', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA5, specials={'char',0x1F6D,0x0345} },
	[0x1FAE] = { unicodeslot=0x1FAE, category='lt', contextname='greekOmegaiotasubpsiliperispomeni', description='GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA6, specials={'char',0x1F6E,0x0345} },
	[0x1FAF] = { unicodeslot=0x1FAF, category='lt', contextname='greekOmegaiotasubdasiaperispomeni', description='GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FA7, specials={'char',0x1F6F,0x0345} },
	[0x1FB0] = { unicodeslot=0x1FB0, category='ll', contextname='greekalphavrachy', description='GREEK SMALL LETTER ALPHA WITH VRACHY', shcode=0x03B1, uccode=0x1FB8, specials={'char',0x03B1,0x0306} },
	[0x1FB1] = { unicodeslot=0x1FB1, category='ll', contextname='greekalphamacron', description='GREEK SMALL LETTER ALPHA WITH MACRON', shcode=0x03B1, uccode=0x1FB9, specials={'char',0x03B1,0x0304} },
	[0x1FB2] = { unicodeslot=0x1FB2, category='ll', contextname='greekalphaiotasubvaria', description='GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI', shcode=0x03B1, specials={'char',0x1F70,0x0345} },
	[0x1FB3] = { unicodeslot=0x1FB3, category='ll', contextname='greekalphaiotasub', description='GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI', shcode=0x03B1, uccode=0x1FBC, specials={'char',0x03B1,0x0345} },
	[0x1FB4] = { unicodeslot=0x1FB4, category='ll', contextname='greekalphaiotasubtonos', description='GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI', shcode=0x03B1, specials={'char',0x03AC,0x0345} },
	[0x1FB6] = { unicodeslot=0x1FB6, category='ll', contextname='greekalphaperispomeni', description='GREEK SMALL LETTER ALPHA WITH PERISPOMENI', shcode=0x03B1, specials={'char',0x03B1,0x0342} },
	[0x1FB7] = { unicodeslot=0x1FB7, category='ll', contextname='greekalphaiotasubperispomeni', description='GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03B1, specials={'char',0x1FB6,0x0345} },
	[0x1FB8] = { unicodeslot=0x1FB8, category='lu', contextname='greekAlphavrachy', description='GREEK CAPITAL LETTER ALPHA WITH VRACHY', shcode=0x0391, lccode=0x1FB0, specials={'char',0x0391,0x0306} },
	[0x1FB9] = { unicodeslot=0x1FB9, category='lu', contextname='greekAlphamacron', description='GREEK CAPITAL LETTER ALPHA WITH MACRON', shcode=0x0391, lccode=0x1FB1, specials={'char',0x0391,0x0304} },
	[0x1FBA] = { unicodeslot=0x1FBA, category='lu', contextname='greekAlphavaria', description='GREEK CAPITAL LETTER ALPHA WITH VARIA', shcode=0x0391, lccode=0x1F70, specials={'char',0x0391,0x0300} },
	[0x1FBB] = { unicodeslot=0x1FBB, category='lu', contextname='greekAlphatonos', description='GREEK CAPITAL LETTER ALPHA WITH OXIA', shcode=0x0391, lccode=0x1F71, specials={'char',0x0386} },
	[0x1FBC] = { unicodeslot=0x1FBC, category='lt', contextname='greekAlphaiotasub', description='GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI', shcode=0x0391, lccode=0x1FB3, specials={'char',0x0391,0x0345} },
	[0x1FBD] = { unicodeslot=0x1FBD, category='sk', contextname='greekCoronis', description='GREEK KORONIS', specials={'compat',0x0020,0x0313} },
	[0x1FBE] = { unicodeslot=0x1FBE, category='ll', contextname='greekprosgegrammeni', description='GREEK PROSGEGRAMMENI', uccode=0x0399, specials={'char',0x03B9} },
	[0x1FBF] = { unicodeslot=0x1FBF, category='sk', contextname='greekpsili', description='GREEK PSILI', specials={'compat',0x0020,0x0313} },
	[0x1FC0] = { unicodeslot=0x1FC0, category='sk', contextname='greekperispomeni', description='GREEK PERISPOMENI', specials={'compat',0x0020,0x0342} },
	[0x1FC1] = { unicodeslot=0x1FC1, category='sk', contextname='greekdialytikaperispomeni', description='GREEK DIALYTIKA AND PERISPOMENI', specials={'char',0x00A8,0x0342} },
	[0x1FC2] = { unicodeslot=0x1FC2, category='ll', contextname='greeketaiotasubvaria', description='GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI', shcode=0x03B7, specials={'char',0x1F74,0x0345} },
	[0x1FC3] = { unicodeslot=0x1FC3, category='ll', contextname='greeketaiotasub', description='GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI', shcode=0x03B7, uccode=0x1FCC, specials={'char',0x03B7,0x0345} },
	[0x1FC4] = { unicodeslot=0x1FC4, category='ll', contextname='greeketaiotasubtonos', description='GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI', shcode=0x03B7, specials={'char',0x03AE,0x0345} },
	[0x1FC6] = { unicodeslot=0x1FC6, category='ll', contextname='greeketaperispomeni', description='GREEK SMALL LETTER ETA WITH PERISPOMENI', shcode=0x03B7, specials={'char',0x03B7,0x0342} },
	[0x1FC7] = { unicodeslot=0x1FC7, category='ll', contextname='greeketaiotasubperispomeni', description='GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03B7, specials={'char',0x1FC6,0x0345} },
	[0x1FC8] = { unicodeslot=0x1FC8, category='lu', contextname='greekEpsilonvaria', description='GREEK CAPITAL LETTER EPSILON WITH VARIA', shcode=0x0395, lccode=0x1F72, specials={'char',0x0395,0x0300} },
	[0x1FC9] = { unicodeslot=0x1FC9, category='lu', contextname='greekEpsilontonos', description='GREEK CAPITAL LETTER EPSILON WITH OXIA', shcode=0x0395, lccode=0x1F73, specials={'char',0x0388} },
	[0x1FCA] = { unicodeslot=0x1FCA, category='lu', contextname='greekEtavaria', description='GREEK CAPITAL LETTER ETA WITH VARIA', shcode=0x0397, lccode=0x1F74, specials={'char',0x0397,0x0300} },
	[0x1FCB] = { unicodeslot=0x1FCB, category='lu', contextname='greekEtatonos', description='GREEK CAPITAL LETTER ETA WITH OXIA', shcode=0x0397, lccode=0x1F75, specials={'char',0x0389} },
	[0x1FCC] = { unicodeslot=0x1FCC, category='lt', contextname='greekEtaiotasub', description='GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI', shcode=0x0397, lccode=0x1FC3, specials={'char',0x0397,0x0345} },
	[0x1FCD] = { unicodeslot=0x1FCD, category='sk', contextname='greekpsilivaria', description='GREEK PSILI AND VARIA', specials={'char',0x1FBF,0x0300} },
	[0x1FCE] = { unicodeslot=0x1FCE, category='sk', contextname='greekpsilitonos', description='GREEK PSILI AND OXIA', specials={'char',0x1FBF,0x0301} },
	[0x1FCF] = { unicodeslot=0x1FCF, category='sk', contextname='greekpsiliperispomeni', description='GREEK PSILI AND PERISPOMENI', specials={'char',0x1FBF,0x0342} },
	[0x1FD0] = { unicodeslot=0x1FD0, category='ll', contextname='greekiotavrachy', description='GREEK SMALL LETTER IOTA WITH VRACHY', shcode=0x03B9, uccode=0x1FD8, specials={'char',0x03B9,0x0306} },
	[0x1FD1] = { unicodeslot=0x1FD1, category='ll', contextname='greekiotamacron', description='GREEK SMALL LETTER IOTA WITH MACRON', shcode=0x03B9, uccode=0x1FD9, specials={'char',0x03B9,0x0304} },
	[0x1FD2] = { unicodeslot=0x1FD2, category='ll', contextname='greekiotadialytikavaria', description='GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA', shcode=0x03B9, specials={'char',0x03CA,0x0300} },
	[0x1FD3] = { unicodeslot=0x1FD3, category='ll', contextname='greekiotadialytikatonos', description='GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA', shcode=0x03B9, specials={'char',0x0390} },
	[0x1FD6] = { unicodeslot=0x1FD6, category='ll', contextname='greekiotaperispomeni', description='GREEK SMALL LETTER IOTA WITH PERISPOMENI', shcode=0x03B9, specials={'char',0x03B9,0x0342} },
	[0x1FD7] = { unicodeslot=0x1FD7, category='ll', contextname='greekiotadialytikaperispomeni', description='GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI', shcode=0x03B9, specials={'char',0x03CA,0x0342} },
	[0x1FD8] = { unicodeslot=0x1FD8, category='lu', contextname='greekIotavrachy', description='GREEK CAPITAL LETTER IOTA WITH VRACHY', shcode=0x0399, lccode=0x1FD0, specials={'char',0x0399,0x0306} },
	[0x1FD9] = { unicodeslot=0x1FD9, category='lu', contextname='greekIotamacron', description='GREEK CAPITAL LETTER IOTA WITH MACRON', shcode=0x0399, lccode=0x1FD1, specials={'char',0x0399,0x0304} },
	[0x1FDA] = { unicodeslot=0x1FDA, category='lu', contextname='greekIotavaria', description='GREEK CAPITAL LETTER IOTA WITH VARIA', shcode=0x0399, lccode=0x1F76, specials={'char',0x0399,0x0300} },
	[0x1FDB] = { unicodeslot=0x1FDB, category='lu', contextname='greekIotatonos', description='GREEK CAPITAL LETTER IOTA WITH OXIA', shcode=0x0399, lccode=0x1F77, specials={'char',0x038A} },
	[0x1FDD] = { unicodeslot=0x1FDD, category='sk', contextname='greekdasiavaria', description='GREEK DASIA AND VARIA', specials={'char',0x1FFE,0x0300} },
	[0x1FDE] = { unicodeslot=0x1FDE, category='sk', contextname='greekdasiatonos', description='GREEK DASIA AND OXIA', specials={'char',0x1FFE,0x0301} },
	[0x1FDF] = { unicodeslot=0x1FDF, category='sk', contextname='greekdasiaperispomeni', description='GREEK DASIA AND PERISPOMENI', specials={'char',0x1FFE,0x0342} },
	[0x1FE0] = { unicodeslot=0x1FE0, category='ll', contextname='greekupsilonvrachy', description='GREEK SMALL LETTER UPSILON WITH VRACHY', shcode=0x03C5, uccode=0x1FE8, specials={'char',0x03C5,0x0306} },
	[0x1FE1] = { unicodeslot=0x1FE1, category='ll', contextname='greekupsilonmacron', description='GREEK SMALL LETTER UPSILON WITH MACRON', shcode=0x03C5, uccode=0x1FE9, specials={'char',0x03C5,0x0304} },
	[0x1FE2] = { unicodeslot=0x1FE2, category='ll', contextname='greekupsilondialytikavaria', description='GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA', shcode=0x03C5, specials={'char',0x03CB,0x0300} },
	[0x1FE3] = { unicodeslot=0x1FE3, category='ll', contextname='greekupsilondialytikatonos', description='GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA', shcode=0x03C5, specials={'char',0x03B0} },
	[0x1FE4] = { unicodeslot=0x1FE4, category='ll', contextname='greekrhopsili', description='GREEK SMALL LETTER RHO WITH PSILI', shcode=0x03C1, specials={'char',0x03C1,0x0313} },
	[0x1FE5] = { unicodeslot=0x1FE5, category='ll', contextname='greekrhodasia', description='GREEK SMALL LETTER RHO WITH DASIA', shcode=0x03C1, uccode=0x1FEC, specials={'char',0x03C1,0x0314} },
	[0x1FE6] = { unicodeslot=0x1FE6, category='ll', contextname='greekupsilonperispomeni', description='GREEK SMALL LETTER UPSILON WITH PERISPOMENI', shcode=0x03C5, specials={'char',0x03C5,0x0342} },
	[0x1FE7] = { unicodeslot=0x1FE7, category='ll', contextname='greekupsilondialytikaperispomeni', description='GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI', shcode=0x03C5, specials={'char',0x03CB,0x0342} },
	[0x1FE8] = { unicodeslot=0x1FE8, category='lu', contextname='greekUpsilonvrachy', description='GREEK CAPITAL LETTER UPSILON WITH VRACHY', shcode=0x03A5, lccode=0x1FE0, specials={'char',0x03A5,0x0306} },
	[0x1FE9] = { unicodeslot=0x1FE9, category='lu', contextname='greekUpsilonmacron', description='GREEK CAPITAL LETTER UPSILON WITH MACRON', shcode=0x03A5, lccode=0x1FE1, specials={'char',0x03A5,0x0304} },
	[0x1FEA] = { unicodeslot=0x1FEA, category='lu', contextname='greekUpsilonvaria', description='GREEK CAPITAL LETTER UPSILON WITH VARIA', shcode=0x03A5, lccode=0x1F7A, specials={'char',0x03A5,0x0300} },
	[0x1FEB] = { unicodeslot=0x1FEB, category='lu', contextname='greekUpsilontonos', description='GREEK CAPITAL LETTER UPSILON WITH OXIA', shcode=0x03A5, lccode=0x1F7B, specials={'char',0x038E} },
	[0x1FEC] = { unicodeslot=0x1FEC, category='lu', contextname='greekRhodasia', description='GREEK CAPITAL LETTER RHO WITH DASIA', shcode=0x03A1, lccode=0x1FE5, specials={'char',0x03A1,0x0314} },
	[0x1FED] = { unicodeslot=0x1FED, category='sk', contextname='greekdialytikavaria', description='GREEK DIALYTIKA AND VARIA', specials={'char',0x00A8,0x0300} },
	[0x1FEE] = { unicodeslot=0x1FEE, category='sk', contextname='greekdialytikatonos', description='GREEK DIALYTIKA AND OXIA', specials={'char',0x0385} },
	[0x1FEF] = { unicodeslot=0x1FEF, category='sk', contextname='greekvaria', description='GREEK VARIA', specials={'char',0x0060} },
	[0x1FF2] = { unicodeslot=0x1FF2, category='ll', contextname='greekomegaiotasubvaria', description='GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI', shcode=0x03C9, specials={'char',0x1F7C,0x0345} },
	[0x1FF3] = { unicodeslot=0x1FF3, category='ll', contextname='greekomegaiotasub', description='GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI', shcode=0x03C9, uccode=0x1FFC, specials={'char',0x03C9,0x0345} },
	[0x1FF4] = { unicodeslot=0x1FF4, category='ll', contextname='greekomegaiotasubtonos', description='GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI', shcode=0x03C9, specials={'char',0x03CE,0x0345} },
	[0x1FF6] = { unicodeslot=0x1FF6, category='ll', contextname='greekomegaperispomeni', description='GREEK SMALL LETTER OMEGA WITH PERISPOMENI', shcode=0x03C9, specials={'char',0x03C9,0x0342} },
	[0x1FF7] = { unicodeslot=0x1FF7, category='ll', contextname='greekomegaiotasubperispomeni', description='GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI', shcode=0x03C9, specials={'char',0x1FF6,0x0345} },
	[0x1FF8] = { unicodeslot=0x1FF8, category='lu', contextname='greekOmicronvaria', description='GREEK CAPITAL LETTER OMICRON WITH VARIA', shcode=0x039F, lccode=0x1F78, specials={'char',0x039F,0x0300} },
	[0x1FF9] = { unicodeslot=0x1FF9, category='lu', contextname='greekOmicrontonos', description='GREEK CAPITAL LETTER OMICRON WITH OXIA', shcode=0x039F, lccode=0x1F79, specials={'char',0x038C} },
	[0x1FFA] = { unicodeslot=0x1FFA, category='lu', contextname='greekOmegavaria', description='GREEK CAPITAL LETTER OMEGA WITH VARIA', shcode=0x03A9, lccode=0x1F7C, specials={'char',0x03A9,0x0300} },
	[0x1FFB] = { unicodeslot=0x1FFB, category='lu', contextname='greekOmegatonos', description='GREEK CAPITAL LETTER OMEGA WITH OXIA', shcode=0x03A9, lccode=0x1F7D, specials={'char',0x038F} },
	[0x1FFC] = { unicodeslot=0x1FFC, category='lt', contextname='greekOmegaiotasub', description='GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI', shcode=0x03A9, lccode=0x1FF3, specials={'char',0x03A9,0x0345} },
	[0x1FFD] = { unicodeslot=0x1FFD, category='sk', contextname='greekoxia', description='GREEK OXIA', specials={'char',0x00B4} },
	[0x1FFE] = { unicodeslot=0x1FFE, category='sk', contextname='greekdasia', description='GREEK DASIA', specials={'compat',0x0020,0x0314} },
	[0x2000] = { unicodeslot=0x2000, category='zs', description='EN QUAD', specials={'char',0x2002} },
	[0x2001] = { unicodeslot=0x2001, category='zs', description='EM QUAD', specials={'char',0x2003} },
	[0x2002] = { unicodeslot=0x2002, category='zs', description='EN SPACE', specials={'compat',0x0020} },
	[0x2003] = { unicodeslot=0x2003, category='zs', description='EM SPACE', specials={'compat',0x0020} },
	[0x2004] = { unicodeslot=0x2004, category='zs', description='THREE-PER-EM SPACE', specials={'compat',0x0020} },
	[0x2005] = { unicodeslot=0x2005, category='zs', description='FOUR-PER-EM SPACE', specials={'compat',0x0020} },
	[0x2006] = { unicodeslot=0x2006, category='zs', description='SIX-PER-EM SPACE', specials={'compat',0x0020} },
	[0x2007] = { unicodeslot=0x2007, category='zs', description='FIGURE SPACE', specials={'nobreak',0x0020} },
	[0x2008] = { unicodeslot=0x2008, category='zs', description='PUNCTUATION SPACE', specials={'compat',0x0020} },
	[0x2009] = { unicodeslot=0x2009, category='zs', description='THIN SPACE', specials={'compat',0x0020} },
	[0x200A] = { unicodeslot=0x200A, category='zs', description='HAIR SPACE', specials={'compat',0x0020} },
	[0x200B] = { unicodeslot=0x200B, category='cf', description='ZERO WIDTH SPACE' },
	[0x200C] = { unicodeslot=0x200C, category='cf', adobename='afii61664', description='ZERO WIDTH NON-JOINER' },
	[0x200D] = { unicodeslot=0x200D, category='cf', adobename='afii301', description='ZERO WIDTH JOINER' },
	[0x200E] = { unicodeslot=0x200E, category='cf', adobename='afii299', description='LEFT-TO-RIGHT MARK' },
	[0x200F] = { unicodeslot=0x200F, category='cf', adobename='afii300', description='RIGHT-TO-LEFT MARK' },
	[0x2010] = { unicodeslot=0x2010, category='pd', description='HYPHEN' },
	[0x2011] = { unicodeslot=0x2011, category='pd', description='NON-BREAKING HYPHEN', specials={'nobreak',0x2010} },
	[0x2012] = { unicodeslot=0x2012, category='pd', adobename='figuredash', contextname='textminus', description='FIGURE DASH' },
	[0x2013] = { unicodeslot=0x2013, category='pd', adobename='endash', contextname='endash', description='EN DASH' },
	[0x2014] = { unicodeslot=0x2014, category='pd', adobename='emdash', contextname='emdash', description='EM DASH' },
	[0x2015] = { unicodeslot=0x2015, category='pd', adobename='afii00208', contextname='texthorizontalbar', description='HORIZONTAL BAR' },
	[0x2016] = { unicodeslot=0x2016, category='po', description='DOUBLE VERTICAL LINE' },
	[0x2017] = { unicodeslot=0x2017, category='po', adobename='underscoredbl', description='DOUBLE LOW LINE', specials={'compat',0x0020,0x0333} },
	[0x2018] = { unicodeslot=0x2018, category='pi', adobename='quoteleft', contextname='quoteleft', description='LEFT SINGLE QUOTATION MARK' },
	[0x2019] = { unicodeslot=0x2019, category='pf', adobename='quoteright', contextname='quoteright', description='RIGHT SINGLE QUOTATION MARK' },
	[0x201A] = { unicodeslot=0x201A, category='ps', adobename='quotesinglbase', contextname='quotesinglebase', description='SINGLE LOW-9 QUOTATION MARK' },
	[0x201B] = { unicodeslot=0x201B, category='pi', adobename='quotereversed', description='SINGLE HIGH-REVERSED-9 QUOTATION MARK' },
	[0x201C] = { unicodeslot=0x201C, category='pi', adobename='quotedblleft', contextname='quotedblleft', description='LEFT DOUBLE QUOTATION MARK' },
	[0x201D] = { unicodeslot=0x201D, category='pf', adobename='quotedblright', contextname='quotedblright', description='RIGHT DOUBLE QUOTATION MARK' },
	[0x201E] = { unicodeslot=0x201E, category='ps', adobename='quotedblbase', contextname='quotedblbase', description='DOUBLE LOW-9 QUOTATION MARK' },
	[0x201F] = { unicodeslot=0x201F, category='pi', description='DOUBLE HIGH-REVERSED-9 QUOTATION MARK' },
	[0x2020] = { unicodeslot=0x2020, category='po', adobename='dagger', contextname='textdag', description='DAGGER' },
	[0x2021] = { unicodeslot=0x2021, category='po', adobename='daggerdbl', contextname='textddag', description='DOUBLE DAGGER' },
	[0x2022] = { unicodeslot=0x2022, category='po', adobename='bullet', contextname='textbullet', description='BULLET' },
	[0x2023] = { unicodeslot=0x2023, category='po', description='TRIANGULAR BULLET' },
	[0x2024] = { unicodeslot=0x2024, category='po', adobename='onedotenleader', description='ONE DOT LEADER', specials={'compat',0x002E} },
	[0x2025] = { unicodeslot=0x2025, category='po', adobename='twodotenleader', description='TWO DOT LEADER', specials={'compat',0x002E,0x002E} },
	[0x2026] = { unicodeslot=0x2026, category='po', adobename='ellipsis', contextname='textellipsis', description='HORIZONTAL ELLIPSIS', specials={'compat',0x002E,0x002E,0x002E} },
	[0x2027] = { unicodeslot=0x2027, category='po', description='HYPHENATION POINT' },
	[0x2028] = { unicodeslot=0x2028, category='zl', description='LINE SEPARATOR' },
	[0x2029] = { unicodeslot=0x2029, category='zp', description='PARAGRAPH SEPARATOR' },
	[0x202A] = { unicodeslot=0x202A, category='cf', description='LEFT-TO-RIGHT EMBEDDING' },
	[0x202B] = { unicodeslot=0x202B, category='cf', description='RIGHT-TO-LEFT EMBEDDING' },
	[0x202C] = { unicodeslot=0x202C, category='cf', adobename='afii61573', description='POP DIRECTIONAL FORMATTING' },
	[0x202D] = { unicodeslot=0x202D, category='cf', adobename='afii61574', description='LEFT-TO-RIGHT OVERRIDE' },
	[0x202E] = { unicodeslot=0x202E, category='cf', adobename='afii61575', description='RIGHT-TO-LEFT OVERRIDE' },
	[0x202F] = { unicodeslot=0x202F, category='zs', description='NARROW NO-BREAK SPACE', specials={'nobreak',0x0020} },
	[0x2030] = { unicodeslot=0x2030, category='po', adobename='perthousand', contextname='perthousand', description='PER MILLE SIGN' },
	[0x2031] = { unicodeslot=0x2031, category='po', description='PER TEN THOUSAND SIGN' },
	[0x2032] = { unicodeslot=0x2032, category='po', adobename='minute', description='PRIME' },
	[0x2033] = { unicodeslot=0x2033, category='po', adobename='second', description='DOUBLE PRIME', specials={'compat',0x2032,0x2032} },
	[0x2034] = { unicodeslot=0x2034, category='po', description='TRIPLE PRIME', specials={'compat',0x2032,0x2032,0x2032} },
	[0x2035] = { unicodeslot=0x2035, category='po', description='REVERSED PRIME' },
	[0x2036] = { unicodeslot=0x2036, category='po', description='REVERSED DOUBLE PRIME', specials={'compat',0x2035,0x2035} },
	[0x2037] = { unicodeslot=0x2037, category='po', description='REVERSED TRIPLE PRIME', specials={'compat',0x2035,0x2035,0x2035} },
	[0x2038] = { unicodeslot=0x2038, category='po', description='CARET' },
	[0x2039] = { unicodeslot=0x2039, category='pi', adobename='guilsinglleft', contextname='guilsingleleft', description='SINGLE LEFT-POINTING ANGLE QUOTATION MARK' },
	[0x203A] = { unicodeslot=0x203A, category='pf', adobename='guilsinglright', contextname='guilsingleright', description='SINGLE RIGHT-POINTING ANGLE QUOTATION MARK' },
	[0x203B] = { unicodeslot=0x203B, category='po', description='REFERENCE MARK' },
	[0x203C] = { unicodeslot=0x203C, category='po', adobename='exclamdbl', description='DOUBLE EXCLAMATION MARK', specials={'compat',0x0021,0x0021} },
	[0x203D] = { unicodeslot=0x203D, category='po', description='INTERROBANG' },
	[0x203E] = { unicodeslot=0x203E, category='po', description='OVERLINE', specials={'compat',0x0020,0x0305} },
	[0x203F] = { unicodeslot=0x203F, category='pc', description='UNDERTIE' },
	[0x2040] = { unicodeslot=0x2040, category='pc', description='CHARACTER TIE' },
	[0x2041] = { unicodeslot=0x2041, category='po', description='CARET INSERTION POINT' },
	[0x2042] = { unicodeslot=0x2042, category='po', description='ASTERISM' },
	[0x2043] = { unicodeslot=0x2043, category='po', description='HYPHEN BULLET' },
	[0x2044] = { unicodeslot=0x2044, category='sm', adobename='fraction', description='FRACTION SLASH' },
	[0x2045] = { unicodeslot=0x2045, category='ps', description='LEFT SQUARE BRACKET WITH QUILL' },
	[0x2046] = { unicodeslot=0x2046, category='pe', description='RIGHT SQUARE BRACKET WITH QUILL' },
	[0x2047] = { unicodeslot=0x2047, category='po', description='DOUBLE QUESTION MARK', specials={'compat',0x003F,0x003F} },
	[0x2048] = { unicodeslot=0x2048, category='po', description='QUESTION EXCLAMATION MARK', specials={'compat',0x003F,0x0021} },
	[0x2049] = { unicodeslot=0x2049, category='po', description='EXCLAMATION QUESTION MARK', specials={'compat',0x0021,0x003F} },
	[0x204A] = { unicodeslot=0x204A, category='po', description='TIRONIAN SIGN ET' },
	[0x204B] = { unicodeslot=0x204B, category='po', description='REVERSED PILCROW SIGN' },
	[0x204C] = { unicodeslot=0x204C, category='po', description='BLACK LEFTWARDS BULLET' },
	[0x204D] = { unicodeslot=0x204D, category='po', description='BLACK RIGHTWARDS BULLET' },
	[0x204E] = { unicodeslot=0x204E, category='po', description='LOW ASTERISK' },
	[0x204F] = { unicodeslot=0x204F, category='po', description='REVERSED SEMICOLON' },
	[0x2050] = { unicodeslot=0x2050, category='po', description='CLOSE UP' },
	[0x2051] = { unicodeslot=0x2051, category='po', description='TWO ASTERISKS ALIGNED VERTICALLY' },
	[0x2052] = { unicodeslot=0x2052, category='sm', description='COMMERCIAL MINUS SIGN' },
	[0x2053] = { unicodeslot=0x2053, category='po', description='SWUNG DASH' },
	[0x2054] = { unicodeslot=0x2054, category='pc', description='INVERTED UNDERTIE' },
	[0x2055] = { unicodeslot=0x2055, category='po', description='FLOWER PUNCTUATION MARK' },
	[0x2056] = { unicodeslot=0x2056, category='po', description='THREE DOT PUNCTUATION' },
	[0x2057] = { unicodeslot=0x2057, category='po', description='QUADRUPLE PRIME', specials={'compat',0x2032,0x2032,0x2032,0x2032} },
	[0x2058] = { unicodeslot=0x2058, category='po', description='FOUR DOT PUNCTUATION' },
	[0x2059] = { unicodeslot=0x2059, category='po', description='FIVE DOT PUNCTUATION' },
	[0x205A] = { unicodeslot=0x205A, category='po', description='TWO DOT PUNCTUATION' },
	[0x205B] = { unicodeslot=0x205B, category='po', description='FOUR DOT MARK' },
	[0x205C] = { unicodeslot=0x205C, category='po', description='DOTTED CROSS' },
	[0x205D] = { unicodeslot=0x205D, category='po', description='TRICOLON' },
	[0x205E] = { unicodeslot=0x205E, category='po', description='VERTICAL FOUR DOTS' },
	[0x205F] = { unicodeslot=0x205F, category='zs', description='MEDIUM MATHEMATICAL SPACE', specials={'compat',0x0020} },
	[0x2060] = { unicodeslot=0x2060, category='cf', description='WORD JOINER' },
	[0x2061] = { unicodeslot=0x2061, category='cf', description='FUNCTION APPLICATION' },
	[0x2062] = { unicodeslot=0x2062, category='cf', description='INVISIBLE TIMES' },
	[0x2063] = { unicodeslot=0x2063, category='cf', description='INVISIBLE SEPARATOR' },
	[0x206A] = { unicodeslot=0x206A, category='cf', description='INHIBIT SYMMETRIC SWAPPING' },
	[0x206B] = { unicodeslot=0x206B, category='cf', description='ACTIVATE SYMMETRIC SWAPPING' },
	[0x206C] = { unicodeslot=0x206C, category='cf', description='INHIBIT ARABIC FORM SHAPING' },
	[0x206D] = { unicodeslot=0x206D, category='cf', description='ACTIVATE ARABIC FORM SHAPING' },
	[0x206E] = { unicodeslot=0x206E, category='cf', description='NATIONAL DIGIT SHAPES' },
	[0x206F] = { unicodeslot=0x206F, category='cf', description='NOMINAL DIGIT SHAPES' },
	[0x2070] = { unicodeslot=0x2070, category='no', description='SUPERSCRIPT ZERO', specials={'super',0x0030} },
	[0x2071] = { unicodeslot=0x2071, category='ll', description='SUPERSCRIPT LATIN SMALL LETTER I', specials={'super',0x0069} },
	[0x2074] = { unicodeslot=0x2074, category='no', description='SUPERSCRIPT FOUR', specials={'super',0x0034} },
	[0x2075] = { unicodeslot=0x2075, category='no', description='SUPERSCRIPT FIVE', specials={'super',0x0035} },
	[0x2076] = { unicodeslot=0x2076, category='no', description='SUPERSCRIPT SIX', specials={'super',0x0036} },
	[0x2077] = { unicodeslot=0x2077, category='no', description='SUPERSCRIPT SEVEN', specials={'super',0x0037} },
	[0x2078] = { unicodeslot=0x2078, category='no', description='SUPERSCRIPT EIGHT', specials={'super',0x0038} },
	[0x2079] = { unicodeslot=0x2079, category='no', description='SUPERSCRIPT NINE', specials={'super',0x0039} },
	[0x207A] = { unicodeslot=0x207A, category='sm', description='SUPERSCRIPT PLUS SIGN', specials={'super',0x002B} },
	[0x207B] = { unicodeslot=0x207B, category='sm', description='SUPERSCRIPT MINUS', specials={'super',0x2212} },
	[0x207C] = { unicodeslot=0x207C, category='sm', description='SUPERSCRIPT EQUALS SIGN', specials={'super',0x003D} },
	[0x207D] = { unicodeslot=0x207D, category='ps', description='SUPERSCRIPT LEFT PARENTHESIS', specials={'super',0x0028} },
	[0x207E] = { unicodeslot=0x207E, category='pe', description='SUPERSCRIPT RIGHT PARENTHESIS', specials={'super',0x0029} },
	[0x207F] = { unicodeslot=0x207F, category='ll', description='SUPERSCRIPT LATIN SMALL LETTER N', specials={'super',0x006E} },
	[0x2080] = { unicodeslot=0x2080, category='no', description='SUBSCRIPT ZERO', specials={'sub',0x0030} },
	[0x2081] = { unicodeslot=0x2081, category='no', description='SUBSCRIPT ONE', specials={'sub',0x0031} },
	[0x2082] = { unicodeslot=0x2082, category='no', description='SUBSCRIPT TWO', specials={'sub',0x0032} },
	[0x2083] = { unicodeslot=0x2083, category='no', description='SUBSCRIPT THREE', specials={'sub',0x0033} },
	[0x2084] = { unicodeslot=0x2084, category='no', description='SUBSCRIPT FOUR', specials={'sub',0x0034} },
	[0x2085] = { unicodeslot=0x2085, category='no', description='SUBSCRIPT FIVE', specials={'sub',0x0035} },
	[0x2086] = { unicodeslot=0x2086, category='no', description='SUBSCRIPT SIX', specials={'sub',0x0036} },
	[0x2087] = { unicodeslot=0x2087, category='no', description='SUBSCRIPT SEVEN', specials={'sub',0x0037} },
	[0x2088] = { unicodeslot=0x2088, category='no', description='SUBSCRIPT EIGHT', specials={'sub',0x0038} },
	[0x2089] = { unicodeslot=0x2089, category='no', description='SUBSCRIPT NINE', specials={'sub',0x0039} },
	[0x208A] = { unicodeslot=0x208A, category='sm', description='SUBSCRIPT PLUS SIGN', specials={'sub',0x002B} },
	[0x208B] = { unicodeslot=0x208B, category='sm', description='SUBSCRIPT MINUS', specials={'sub',0x2212} },
	[0x208C] = { unicodeslot=0x208C, category='sm', description='SUBSCRIPT EQUALS SIGN', specials={'sub',0x003D} },
	[0x208D] = { unicodeslot=0x208D, category='ps', description='SUBSCRIPT LEFT PARENTHESIS', specials={'sub',0x0028} },
	[0x208E] = { unicodeslot=0x208E, category='pe', description='SUBSCRIPT RIGHT PARENTHESIS', specials={'sub',0x0029} },
	[0x2090] = { unicodeslot=0x2090, category='lm', description='LATIN SUBSCRIPT SMALL LETTER A', specials={'sub',0x0061} },
	[0x2091] = { unicodeslot=0x2091, category='lm', description='LATIN SUBSCRIPT SMALL LETTER E', specials={'sub',0x0065} },
	[0x2092] = { unicodeslot=0x2092, category='lm', description='LATIN SUBSCRIPT SMALL LETTER O', specials={'sub',0x006F} },
	[0x2093] = { unicodeslot=0x2093, category='lm', description='LATIN SUBSCRIPT SMALL LETTER X', specials={'sub',0x0078} },
	[0x2094] = { unicodeslot=0x2094, category='lm', description='LATIN SUBSCRIPT SMALL LETTER SCHWA', specials={'sub',0x0259} },
	[0x20A0] = { unicodeslot=0x20A0, category='sc', description='EURO-CURRENCY SIGN' },
	[0x20A1] = { unicodeslot=0x20A1, category='sc', adobename='colonmonetary', description='COLON SIGN' },
	[0x20A2] = { unicodeslot=0x20A2, category='sc', description='CRUZEIRO SIGN' },
	[0x20A3] = { unicodeslot=0x20A3, category='sc', adobename='franc', description='FRENCH FRANC SIGN' },
	[0x20A4] = { unicodeslot=0x20A4, category='sc', adobename='lira', description='LIRA SIGN' },
	[0x20A5] = { unicodeslot=0x20A5, category='sc', description='MILL SIGN' },
	[0x20A6] = { unicodeslot=0x20A6, category='sc', description='NAIRA SIGN' },
	[0x20A7] = { unicodeslot=0x20A7, category='sc', adobename='peseta', description='PESETA SIGN' },
	[0x20A8] = { unicodeslot=0x20A8, category='sc', description='RUPEE SIGN', specials={'compat',0x0052,0x0073} },
	[0x20A9] = { unicodeslot=0x20A9, category='sc', description='WON SIGN' },
	[0x20AA] = { unicodeslot=0x20AA, category='sc', adobename='afii57636', description='NEW SHEQEL SIGN' },
	[0x20AB] = { unicodeslot=0x20AB, category='sc', adobename='dong', contextname='textdong', description='DONG SIGN' },
	[0x20AC] = { unicodeslot=0x20AC, category='sc', adobename='Euro', contextname='texteuro', description='EURO SIGN' },
	[0x20AD] = { unicodeslot=0x20AD, category='sc', description='KIP SIGN' },
	[0x20AE] = { unicodeslot=0x20AE, category='sc', description='TUGRIK SIGN' },
	[0x20AF] = { unicodeslot=0x20AF, category='sc', description='DRACHMA SIGN' },
	[0x20B0] = { unicodeslot=0x20B0, category='sc', description='GERMAN PENNY SIGN' },
	[0x20B1] = { unicodeslot=0x20B1, category='sc', description='PESO SIGN' },
	[0x20B2] = { unicodeslot=0x20B2, category='sc', description='GUARANI SIGN' },
	[0x20B3] = { unicodeslot=0x20B3, category='sc', description='AUSTRAL SIGN' },
	[0x20B4] = { unicodeslot=0x20B4, category='sc', description='HRYVNIA SIGN' },
	[0x20B5] = { unicodeslot=0x20B5, category='sc', description='CEDI SIGN' },
	[0x20D0] = { unicodeslot=0x20D0, category='mn', description='COMBINING LEFT HARPOON ABOVE' },
	[0x20D1] = { unicodeslot=0x20D1, category='mn', description='COMBINING RIGHT HARPOON ABOVE' },
	[0x20D2] = { unicodeslot=0x20D2, category='mn', description='COMBINING LONG VERTICAL LINE OVERLAY' },
	[0x20D3] = { unicodeslot=0x20D3, category='mn', description='COMBINING SHORT VERTICAL LINE OVERLAY' },
	[0x20D4] = { unicodeslot=0x20D4, category='mn', description='COMBINING ANTICLOCKWISE ARROW ABOVE' },
	[0x20D5] = { unicodeslot=0x20D5, category='mn', description='COMBINING CLOCKWISE ARROW ABOVE' },
	[0x20D6] = { unicodeslot=0x20D6, category='mn', description='COMBINING LEFT ARROW ABOVE' },
	[0x20D7] = { unicodeslot=0x20D7, category='mn', description='COMBINING RIGHT ARROW ABOVE' },
	[0x20D8] = { unicodeslot=0x20D8, category='mn', description='COMBINING RING OVERLAY' },
	[0x20D9] = { unicodeslot=0x20D9, category='mn', description='COMBINING CLOCKWISE RING OVERLAY' },
	[0x20DA] = { unicodeslot=0x20DA, category='mn', description='COMBINING ANTICLOCKWISE RING OVERLAY' },
	[0x20DB] = { unicodeslot=0x20DB, category='mn', description='COMBINING THREE DOTS ABOVE' },
	[0x20DC] = { unicodeslot=0x20DC, category='mn', description='COMBINING FOUR DOTS ABOVE' },
	[0x20DD] = { unicodeslot=0x20DD, category='me', description='COMBINING ENCLOSING CIRCLE' },
	[0x20DE] = { unicodeslot=0x20DE, category='me', description='COMBINING ENCLOSING SQUARE' },
	[0x20DF] = { unicodeslot=0x20DF, category='me', description='COMBINING ENCLOSING DIAMOND' },
	[0x20E0] = { unicodeslot=0x20E0, category='me', description='COMBINING ENCLOSING CIRCLE BACKSLASH' },
	[0x20E1] = { unicodeslot=0x20E1, category='mn', description='COMBINING LEFT RIGHT ARROW ABOVE' },
	[0x20E2] = { unicodeslot=0x20E2, category='me', description='COMBINING ENCLOSING SCREEN' },
	[0x20E3] = { unicodeslot=0x20E3, category='me', description='COMBINING ENCLOSING KEYCAP' },
	[0x20E4] = { unicodeslot=0x20E4, category='me', description='COMBINING ENCLOSING UPWARD POINTING TRIANGLE' },
	[0x20E5] = { unicodeslot=0x20E5, category='mn', description='COMBINING REVERSE SOLIDUS OVERLAY' },
	[0x20E6] = { unicodeslot=0x20E6, category='mn', description='COMBINING DOUBLE VERTICAL STROKE OVERLAY' },
	[0x20E7] = { unicodeslot=0x20E7, category='mn', description='COMBINING ANNUITY SYMBOL' },
	[0x20E8] = { unicodeslot=0x20E8, category='mn', description='COMBINING TRIPLE UNDERDOT' },
	[0x20E9] = { unicodeslot=0x20E9, category='mn', description='COMBINING WIDE BRIDGE ABOVE' },
	[0x20EA] = { unicodeslot=0x20EA, category='mn', description='COMBINING LEFTWARDS ARROW OVERLAY' },
	[0x20EB] = { unicodeslot=0x20EB, category='mn', description='COMBINING LONG DOUBLE SOLIDUS OVERLAY' },
	[0x20EC] = { unicodeslot=0x20EC, category='mn', description='COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS' },
	[0x20ED] = { unicodeslot=0x20ED, category='mn', description='COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS' },
	[0x20EE] = { unicodeslot=0x20EE, category='mn', description='COMBINING LEFT ARROW BELOW' },
	[0x20EF] = { unicodeslot=0x20EF, category='mn', description='COMBINING RIGHT ARROW BELOW' },
	[0x2100] = { unicodeslot=0x2100, category='so', description='ACCOUNT OF', specials={'compat',0x0061,0x002F,0x0063} },
	[0x2101] = { unicodeslot=0x2101, category='so', description='ADDRESSED TO THE SUBJECT', specials={'compat',0x0061,0x002F,0x0073} },
	[0x2102] = { unicodeslot=0x2102, category='lu', description='DOUBLE-STRUCK CAPITAL C', specials={'font',0x0043} },
	[0x2103] = { unicodeslot=0x2103, category='so', description='DEGREE CELSIUS', specials={'compat',0x00B0,0x0043} },
	[0x2104] = { unicodeslot=0x2104, category='so', description='CENTRE LINE SYMBOL' },
	[0x2105] = { unicodeslot=0x2105, category='so', adobename='afii61248', description='CARE OF', specials={'compat',0x0063,0x002F,0x006F} },
	[0x2106] = { unicodeslot=0x2106, category='so', description='CADA UNA', specials={'compat',0x0063,0x002F,0x0075} },
	[0x2107] = { unicodeslot=0x2107, category='lu', description='EULER CONSTANT', specials={'compat',0x0190} },
	[0x2108] = { unicodeslot=0x2108, category='so', description='SCRUPLE' },
	[0x2109] = { unicodeslot=0x2109, category='so', description='DEGREE FAHRENHEIT', specials={'compat',0x00B0,0x0046} },
	[0x210A] = { unicodeslot=0x210A, category='ll', description='SCRIPT SMALL G', specials={'font',0x0067} },
	[0x210B] = { unicodeslot=0x210B, category='lu', description='SCRIPT CAPITAL H', specials={'font',0x0048} },
	[0x210C] = { unicodeslot=0x210C, category='lu', description='BLACK-LETTER CAPITAL H', specials={'font',0x0048} },
	[0x210D] = { unicodeslot=0x210D, category='lu', description='DOUBLE-STRUCK CAPITAL H', specials={'font',0x0048} },
	[0x210E] = { unicodeslot=0x210E, category='ll', description='PLANCK CONSTANT', specials={'font',0x0068} },
	[0x210F] = { unicodeslot=0x210F, category='ll', description='PLANCK CONSTANT OVER TWO PI', specials={'font',0x0127} },
	[0x2110] = { unicodeslot=0x2110, category='lu', description='SCRIPT CAPITAL I', specials={'font',0x0049} },
	[0x2111] = { unicodeslot=0x2111, category='lu', adobename='Ifraktur', description='BLACK-LETTER CAPITAL I', specials={'font',0x0049} },
	[0x2112] = { unicodeslot=0x2112, category='lu', description='SCRIPT CAPITAL L', specials={'font',0x004C} },
	[0x2113] = { unicodeslot=0x2113, category='ll', adobename='afii61289', description='SCRIPT SMALL L', specials={'font',0x006C} },
	[0x2114] = { unicodeslot=0x2114, category='so', description='L B BAR SYMBOL' },
	[0x2115] = { unicodeslot=0x2115, category='lu', description='DOUBLE-STRUCK CAPITAL N', specials={'font',0x004E} },
	[0x2116] = { unicodeslot=0x2116, category='so', adobename='afii61352', contextname='textnumero', description='NUMERO SIGN', specials={'compat',0x004E,0x006F} },
	[0x2117] = { unicodeslot=0x2117, category='so', description='SOUND RECORDING COPYRIGHT' },
	[0x2118] = { unicodeslot=0x2118, category='so', adobename='weierstrass', description='SCRIPT CAPITAL P' },
	[0x2119] = { unicodeslot=0x2119, category='lu', description='DOUBLE-STRUCK CAPITAL P', specials={'font',0x0050} },
	[0x211A] = { unicodeslot=0x211A, category='lu', description='DOUBLE-STRUCK CAPITAL Q', specials={'font',0x0051} },
	[0x211B] = { unicodeslot=0x211B, category='lu', description='SCRIPT CAPITAL R', specials={'font',0x0052} },
	[0x211C] = { unicodeslot=0x211C, category='lu', adobename='Rfraktur', description='BLACK-LETTER CAPITAL R', specials={'font',0x0052} },
	[0x211D] = { unicodeslot=0x211D, category='lu', description='DOUBLE-STRUCK CAPITAL R', specials={'font',0x0052} },
	[0x211E] = { unicodeslot=0x211E, category='so', adobename='prescription', description='PRESCRIPTION TAKE' },
	[0x211F] = { unicodeslot=0x211F, category='so', description='RESPONSE' },
	[0x2120] = { unicodeslot=0x2120, category='so', description='SERVICE MARK', specials={'super',0x0053,0x004D} },
	[0x2121] = { unicodeslot=0x2121, category='so', description='TELEPHONE SIGN', specials={'compat',0x0054,0x0045,0x004C} },
	[0x2122] = { unicodeslot=0x2122, category='so', adobename='trademark', contextname='trademark', description='TRADE MARK SIGN', specials={'super',0x0054,0x004D} },
	[0x2123] = { unicodeslot=0x2123, category='so', description='VERSICLE' },
	[0x2124] = { unicodeslot=0x2124, category='lu', description='DOUBLE-STRUCK CAPITAL Z', specials={'font',0x005A} },
	[0x2125] = { unicodeslot=0x2125, category='so', description='OUNCE SIGN' },
	[0x2126] = { unicodeslot=0x2126, category='lu', adobename='Omega', description='OHM SIGN', lccode=0x03C9, specials={'char',0x03A9} },
	[0x2127] = { unicodeslot=0x2127, category='so', description='INVERTED OHM SIGN' },
	[0x2128] = { unicodeslot=0x2128, category='lu', description='BLACK-LETTER CAPITAL Z', specials={'font',0x005A} },
	[0x2129] = { unicodeslot=0x2129, category='so', description='TURNED GREEK SMALL LETTER IOTA' },
	[0x212A] = { unicodeslot=0x212A, category='lu', description='KELVIN SIGN', lccode=0x006B, specials={'char',0x004B} },
	[0x212B] = { unicodeslot=0x212B, category='lu', description='ANGSTROM SIGN', lccode=0x00E5, specials={'char',0x00C5} },
	[0x212C] = { unicodeslot=0x212C, category='lu', description='SCRIPT CAPITAL B', specials={'font',0x0042} },
	[0x212D] = { unicodeslot=0x212D, category='lu', description='BLACK-LETTER CAPITAL C', specials={'font',0x0043} },
	[0x212E] = { unicodeslot=0x212E, category='so', adobename='estimated', description='ESTIMATED SYMBOL' },
	[0x212F] = { unicodeslot=0x212F, category='ll', description='SCRIPT SMALL E', specials={'font',0x0065} },
	[0x2130] = { unicodeslot=0x2130, category='lu', description='SCRIPT CAPITAL E', specials={'font',0x0045} },
	[0x2131] = { unicodeslot=0x2131, category='lu', description='SCRIPT CAPITAL F', specials={'font',0x0046} },
	[0x2132] = { unicodeslot=0x2132, category='lu', description='TURNED CAPITAL F', lccode=0x214E },
	[0x2133] = { unicodeslot=0x2133, category='lu', description='SCRIPT CAPITAL M', specials={'font',0x004D} },
	[0x2134] = { unicodeslot=0x2134, category='ll', description='SCRIPT SMALL O', specials={'font',0x006F} },
	[0x2135] = { unicodeslot=0x2135, category='lo', adobename='aleph', description='ALEF SYMBOL', specials={'compat',0x05D0} },
	[0x2136] = { unicodeslot=0x2136, category='lo', description='BET SYMBOL', specials={'compat',0x05D1} },
	[0x2137] = { unicodeslot=0x2137, category='lo', description='GIMEL SYMBOL', specials={'compat',0x05D2} },
	[0x2138] = { unicodeslot=0x2138, category='lo', description='DALET SYMBOL', specials={'compat',0x05D3} },
	[0x2139] = { unicodeslot=0x2139, category='ll', description='INFORMATION SOURCE', specials={'font',0x0069} },
	[0x213A] = { unicodeslot=0x213A, category='so', description='ROTATED CAPITAL Q' },
	[0x213B] = { unicodeslot=0x213B, category='so', description='FACSIMILE SIGN', specials={'compat',0x0046,0x0041,0x0058} },
	[0x213C] = { unicodeslot=0x213C, category='ll', description='DOUBLE-STRUCK SMALL PI', specials={'font',0x03C0} },
	[0x213D] = { unicodeslot=0x213D, category='ll', description='DOUBLE-STRUCK SMALL GAMMA', specials={'font',0x03B3} },
	[0x213E] = { unicodeslot=0x213E, category='lu', description='DOUBLE-STRUCK CAPITAL GAMMA', specials={'font',0x0393} },
	[0x213F] = { unicodeslot=0x213F, category='lu', description='DOUBLE-STRUCK CAPITAL PI', specials={'font',0x03A0} },
	[0x2140] = { unicodeslot=0x2140, category='sm', description='DOUBLE-STRUCK N-ARY SUMMATION', specials={'font',0x2211} },
	[0x2141] = { unicodeslot=0x2141, category='sm', description='TURNED SANS-SERIF CAPITAL G' },
	[0x2142] = { unicodeslot=0x2142, category='sm', description='TURNED SANS-SERIF CAPITAL L' },
	[0x2143] = { unicodeslot=0x2143, category='sm', description='REVERSED SANS-SERIF CAPITAL L' },
	[0x2144] = { unicodeslot=0x2144, category='sm', description='TURNED SANS-SERIF CAPITAL Y' },
	[0x2145] = { unicodeslot=0x2145, category='lu', description='DOUBLE-STRUCK ITALIC CAPITAL D', specials={'font',0x0044} },
	[0x2146] = { unicodeslot=0x2146, category='ll', description='DOUBLE-STRUCK ITALIC SMALL D', specials={'font',0x0064} },
	[0x2147] = { unicodeslot=0x2147, category='ll', description='DOUBLE-STRUCK ITALIC SMALL E', specials={'font',0x0065} },
	[0x2148] = { unicodeslot=0x2148, category='ll', description='DOUBLE-STRUCK ITALIC SMALL I', specials={'font',0x0069} },
	[0x2149] = { unicodeslot=0x2149, category='ll', description='DOUBLE-STRUCK ITALIC SMALL J', specials={'font',0x006A} },
	[0x214A] = { unicodeslot=0x214A, category='so', description='PROPERTY LINE' },
	[0x214B] = { unicodeslot=0x214B, category='sm', description='TURNED AMPERSAND' },
	[0x214C] = { unicodeslot=0x214C, category='so', description='PER SIGN' },
	[0x214D] = { unicodeslot=0x214D, category='so', description='AKTIESELSKAB' },
	[0x214E] = { unicodeslot=0x214E, category='ll', description='TURNED SMALL F', uccode=0x2132 },
	[0x2153] = { unicodeslot=0x2153, category='no', adobename='onethird', contextname='onethird', description='VULGAR FRACTION ONE THIRD', specials={'fraction',0x0031,0x2044,0x0033} },
	[0x2154] = { unicodeslot=0x2154, category='no', adobename='twothirds', contextname='twothirds', description='VULGAR FRACTION TWO THIRDS', specials={'fraction',0x0032,0x2044,0x0033} },
	[0x2155] = { unicodeslot=0x2155, category='no', contextname='onefifth', description='VULGAR FRACTION ONE FIFTH', specials={'fraction',0x0031,0x2044,0x0035} },
	[0x2156] = { unicodeslot=0x2156, category='no', contextname='twofifths', description='VULGAR FRACTION TWO FIFTHS', specials={'fraction',0x0032,0x2044,0x0035} },
	[0x2157] = { unicodeslot=0x2157, category='no', contextname='threefifths', description='VULGAR FRACTION THREE FIFTHS', specials={'fraction',0x0033,0x2044,0x0035} },
	[0x2158] = { unicodeslot=0x2158, category='no', contextname='fourfifths', description='VULGAR FRACTION FOUR FIFTHS', specials={'fraction',0x0034,0x2044,0x0035} },
	[0x2159] = { unicodeslot=0x2159, category='no', contextname='onesixth', description='VULGAR FRACTION ONE SIXTH', specials={'fraction',0x0031,0x2044,0x0036} },
	[0x215A] = { unicodeslot=0x215A, category='no', contextname='fivesixths', description='VULGAR FRACTION FIVE SIXTHS', specials={'fraction',0x0035,0x2044,0x0036} },
	[0x215B] = { unicodeslot=0x215B, category='no', adobename='oneeighth', contextname='oneeighth', description='VULGAR FRACTION ONE EIGHTH', specials={'fraction',0x0031,0x2044,0x0038} },
	[0x215C] = { unicodeslot=0x215C, category='no', adobename='threeeighths', contextname='threeeighths', description='VULGAR FRACTION THREE EIGHTHS', specials={'fraction',0x0033,0x2044,0x0038} },
	[0x215D] = { unicodeslot=0x215D, category='no', adobename='fiveeighths', contextname='fiveeighths', description='VULGAR FRACTION FIVE EIGHTHS', specials={'fraction',0x0035,0x2044,0x0038} },
	[0x215E] = { unicodeslot=0x215E, category='no', adobename='seveneighths', contextname='seveneighths', description='VULGAR FRACTION SEVEN EIGHTHS', specials={'fraction',0x0037,0x2044,0x0038} },
	[0x215F] = { unicodeslot=0x215F, category='no', description='FRACTION NUMERATOR ONE', specials={'fraction',0x0031,0x2044} },
	[0x2160] = { unicodeslot=0x2160, category='nl', contextname='romanI', description='ROMAN NUMERAL ONE', lccode=0x2170, specials={'compat',0x0049} },
	[0x2161] = { unicodeslot=0x2161, category='nl', contextname='romanII', description='ROMAN NUMERAL TWO', lccode=0x2171, specials={'compat',0x0049,0x0049} },
	[0x2162] = { unicodeslot=0x2162, category='nl', contextname='romanIII', description='ROMAN NUMERAL THREE', lccode=0x2172, specials={'compat',0x0049,0x0049,0x0049} },
	[0x2163] = { unicodeslot=0x2163, category='nl', contextname='romanIV', description='ROMAN NUMERAL FOUR', lccode=0x2173, specials={'compat',0x0049,0x0056} },
	[0x2164] = { unicodeslot=0x2164, category='nl', contextname='romanV', description='ROMAN NUMERAL FIVE', lccode=0x2174, specials={'compat',0x0056} },
	[0x2165] = { unicodeslot=0x2165, category='nl', contextname='romanVI', description='ROMAN NUMERAL SIX', lccode=0x2175, specials={'compat',0x0056,0x0049} },
	[0x2166] = { unicodeslot=0x2166, category='nl', contextname='romanVII', description='ROMAN NUMERAL SEVEN', lccode=0x2176, specials={'compat',0x0056,0x0049,0x0049} },
	[0x2167] = { unicodeslot=0x2167, category='nl', contextname='romanVIII', description='ROMAN NUMERAL EIGHT', lccode=0x2177, specials={'compat',0x0056,0x0049,0x0049,0x0049} },
	[0x2168] = { unicodeslot=0x2168, category='nl', contextname='romanIX', description='ROMAN NUMERAL NINE', lccode=0x2178, specials={'compat',0x0049,0x0058} },
	[0x2169] = { unicodeslot=0x2169, category='nl', contextname='romanX', description='ROMAN NUMERAL TEN', lccode=0x2179, specials={'compat',0x0058} },
	[0x216A] = { unicodeslot=0x216A, category='nl', contextname='romanXI', description='ROMAN NUMERAL ELEVEN', lccode=0x217A, specials={'compat',0x0058,0x0049} },
	[0x216B] = { unicodeslot=0x216B, category='nl', contextname='romanXII', description='ROMAN NUMERAL TWELVE', lccode=0x217B, specials={'compat',0x0058,0x0049,0x0049} },
	[0x216C] = { unicodeslot=0x216C, category='nl', contextname='romanL', description='ROMAN NUMERAL FIFTY', lccode=0x217C, specials={'compat',0x004C} },
	[0x216D] = { unicodeslot=0x216D, category='nl', contextname='romanC', description='ROMAN NUMERAL ONE HUNDRED', lccode=0x217D, specials={'compat',0x0043} },
	[0x216E] = { unicodeslot=0x216E, category='nl', contextname='romanD', description='ROMAN NUMERAL FIVE HUNDRED', lccode=0x217E, specials={'compat',0x0044} },
	[0x216F] = { unicodeslot=0x216F, category='nl', contextname='romanM', description='ROMAN NUMERAL ONE THOUSAND', lccode=0x217F, specials={'compat',0x004D} },
	[0x2170] = { unicodeslot=0x2170, category='nl', contextname='romani', description='SMALL ROMAN NUMERAL ONE', uccode=0x2160, specials={'compat',0x0069} },
	[0x2171] = { unicodeslot=0x2171, category='nl', contextname='romanii', description='SMALL ROMAN NUMERAL TWO', uccode=0x2161, specials={'compat',0x0069,0x0069} },
	[0x2172] = { unicodeslot=0x2172, category='nl', contextname='romaniii', description='SMALL ROMAN NUMERAL THREE', uccode=0x2162, specials={'compat',0x0069,0x0069,0x0069} },
	[0x2173] = { unicodeslot=0x2173, category='nl', contextname='romaniv', description='SMALL ROMAN NUMERAL FOUR', uccode=0x2163, specials={'compat',0x0069,0x0076} },
	[0x2174] = { unicodeslot=0x2174, category='nl', contextname='romanv', description='SMALL ROMAN NUMERAL FIVE', uccode=0x2164, specials={'compat',0x0076} },
	[0x2175] = { unicodeslot=0x2175, category='nl', contextname='romanvi', description='SMALL ROMAN NUMERAL SIX', uccode=0x2165, specials={'compat',0x0076,0x0069} },
	[0x2176] = { unicodeslot=0x2176, category='nl', contextname='romanvii', description='SMALL ROMAN NUMERAL SEVEN', uccode=0x2166, specials={'compat',0x0076,0x0069,0x0069} },
	[0x2177] = { unicodeslot=0x2177, category='nl', contextname='romanviii', description='SMALL ROMAN NUMERAL EIGHT', uccode=0x2167, specials={'compat',0x0076,0x0069,0x0069,0x0069} },
	[0x2178] = { unicodeslot=0x2178, category='nl', contextname='romanix', description='SMALL ROMAN NUMERAL NINE', uccode=0x2168, specials={'compat',0x0069,0x0078} },
	[0x2179] = { unicodeslot=0x2179, category='nl', contextname='romanx', description='SMALL ROMAN NUMERAL TEN', uccode=0x2169, specials={'compat',0x0078} },
	[0x217A] = { unicodeslot=0x217A, category='nl', contextname='romanxi', description='SMALL ROMAN NUMERAL ELEVEN', uccode=0x216A, specials={'compat',0x0078,0x0069} },
	[0x217B] = { unicodeslot=0x217B, category='nl', contextname='romanxii', description='SMALL ROMAN NUMERAL TWELVE', uccode=0x216B, specials={'compat',0x0078,0x0069,0x0069} },
	[0x217C] = { unicodeslot=0x217C, category='nl', contextname='romanl', description='SMALL ROMAN NUMERAL FIFTY', uccode=0x216C, specials={'compat',0x006C} },
	[0x217D] = { unicodeslot=0x217D, category='nl', contextname='romanc', description='SMALL ROMAN NUMERAL ONE HUNDRED', uccode=0x216D, specials={'compat',0x0063} },
	[0x217E] = { unicodeslot=0x217E, category='nl', contextname='romand', description='SMALL ROMAN NUMERAL FIVE HUNDRED', uccode=0x216E, specials={'compat',0x0064} },
	[0x217F] = { unicodeslot=0x217F, category='nl', contextname='romanm', description='SMALL ROMAN NUMERAL ONE THOUSAND', uccode=0x216F, specials={'compat',0x006D} },
	[0x2180] = { unicodeslot=0x2180, category='nl', description='ROMAN NUMERAL ONE THOUSAND C D' },
	[0x2181] = { unicodeslot=0x2181, category='nl', description='ROMAN NUMERAL FIVE THOUSAND' },
	[0x2182] = { unicodeslot=0x2182, category='nl', description='ROMAN NUMERAL TEN THOUSAND' },
	[0x2183] = { unicodeslot=0x2183, category='lu', description='ROMAN NUMERAL REVERSED ONE HUNDRED', lccode=0x2184 },
	[0x2184] = { unicodeslot=0x2184, category='ll', description='LATIN SMALL LETTER REVERSED C', uccode=0x2183 },
	[0x2190] = { unicodeslot=0x2190, category='sm', adobename='arrowleft', description='LEFTWARDS ARROW' },
	[0x2191] = { unicodeslot=0x2191, category='sm', adobename='arrowup', description='UPWARDS ARROW' },
	[0x2192] = { unicodeslot=0x2192, category='sm', adobename='arrowright', description='RIGHTWARDS ARROW' },
	[0x2193] = { unicodeslot=0x2193, category='sm', adobename='arrowdown', description='DOWNWARDS ARROW' },
	[0x2194] = { unicodeslot=0x2194, category='sm', adobename='arrowboth', description='LEFT RIGHT ARROW' },
	[0x2195] = { unicodeslot=0x2195, category='so', adobename='arrowupdn', description='UP DOWN ARROW' },
	[0x2196] = { unicodeslot=0x2196, category='so', description='NORTH WEST ARROW' },
	[0x2197] = { unicodeslot=0x2197, category='so', description='NORTH EAST ARROW' },
	[0x2198] = { unicodeslot=0x2198, category='so', description='SOUTH EAST ARROW' },
	[0x2199] = { unicodeslot=0x2199, category='so', description='SOUTH WEST ARROW' },
	[0x219A] = { unicodeslot=0x219A, category='sm', description='LEFTWARDS ARROW WITH STROKE', specials={'char',0x2190,0x0338} },
	[0x219B] = { unicodeslot=0x219B, category='sm', description='RIGHTWARDS ARROW WITH STROKE', specials={'char',0x2192,0x0338} },
	[0x219C] = { unicodeslot=0x219C, category='so', description='LEFTWARDS WAVE ARROW' },
	[0x219D] = { unicodeslot=0x219D, category='so', description='RIGHTWARDS WAVE ARROW' },
	[0x219E] = { unicodeslot=0x219E, category='so', description='LEFTWARDS TWO HEADED ARROW' },
	[0x219F] = { unicodeslot=0x219F, category='so', description='UPWARDS TWO HEADED ARROW' },
	[0x21A0] = { unicodeslot=0x21A0, category='sm', description='RIGHTWARDS TWO HEADED ARROW' },
	[0x21A1] = { unicodeslot=0x21A1, category='so', description='DOWNWARDS TWO HEADED ARROW' },
	[0x21A2] = { unicodeslot=0x21A2, category='so', description='LEFTWARDS ARROW WITH TAIL' },
	[0x21A3] = { unicodeslot=0x21A3, category='sm', description='RIGHTWARDS ARROW WITH TAIL' },
	[0x21A4] = { unicodeslot=0x21A4, category='so', description='LEFTWARDS ARROW FROM BAR' },
	[0x21A5] = { unicodeslot=0x21A5, category='so', description='UPWARDS ARROW FROM BAR' },
	[0x21A6] = { unicodeslot=0x21A6, category='sm', description='RIGHTWARDS ARROW FROM BAR' },
	[0x21A7] = { unicodeslot=0x21A7, category='so', description='DOWNWARDS ARROW FROM BAR' },
	[0x21A8] = { unicodeslot=0x21A8, category='so', adobename='arrowupdnbse', description='UP DOWN ARROW WITH BASE' },
	[0x21A9] = { unicodeslot=0x21A9, category='so', description='LEFTWARDS ARROW WITH HOOK' },
	[0x21AA] = { unicodeslot=0x21AA, category='so', description='RIGHTWARDS ARROW WITH HOOK' },
	[0x21AB] = { unicodeslot=0x21AB, category='so', description='LEFTWARDS ARROW WITH LOOP' },
	[0x21AC] = { unicodeslot=0x21AC, category='so', description='RIGHTWARDS ARROW WITH LOOP' },
	[0x21AD] = { unicodeslot=0x21AD, category='so', description='LEFT RIGHT WAVE ARROW' },
	[0x21AE] = { unicodeslot=0x21AE, category='sm', description='LEFT RIGHT ARROW WITH STROKE', specials={'char',0x2194,0x0338} },
	[0x21AF] = { unicodeslot=0x21AF, category='so', description='DOWNWARDS ZIGZAG ARROW' },
	[0x21B0] = { unicodeslot=0x21B0, category='so', description='UPWARDS ARROW WITH TIP LEFTWARDS' },
	[0x21B1] = { unicodeslot=0x21B1, category='so', description='UPWARDS ARROW WITH TIP RIGHTWARDS' },
	[0x21B2] = { unicodeslot=0x21B2, category='so', description='DOWNWARDS ARROW WITH TIP LEFTWARDS' },
	[0x21B3] = { unicodeslot=0x21B3, category='so', description='DOWNWARDS ARROW WITH TIP RIGHTWARDS' },
	[0x21B4] = { unicodeslot=0x21B4, category='so', description='RIGHTWARDS ARROW WITH CORNER DOWNWARDS' },
	[0x21B5] = { unicodeslot=0x21B5, category='so', adobename='carriagereturn', description='DOWNWARDS ARROW WITH CORNER LEFTWARDS' },
	[0x21B6] = { unicodeslot=0x21B6, category='so', description='ANTICLOCKWISE TOP SEMICIRCLE ARROW' },
	[0x21B7] = { unicodeslot=0x21B7, category='so', description='CLOCKWISE TOP SEMICIRCLE ARROW' },
	[0x21B8] = { unicodeslot=0x21B8, category='so', description='NORTH WEST ARROW TO LONG BAR' },
	[0x21B9] = { unicodeslot=0x21B9, category='so', description='LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR' },
	[0x21BA] = { unicodeslot=0x21BA, category='so', description='ANTICLOCKWISE OPEN CIRCLE ARROW' },
	[0x21BB] = { unicodeslot=0x21BB, category='so', description='CLOCKWISE OPEN CIRCLE ARROW' },
	[0x21BC] = { unicodeslot=0x21BC, category='so', description='LEFTWARDS HARPOON WITH BARB UPWARDS' },
	[0x21BD] = { unicodeslot=0x21BD, category='so', description='LEFTWARDS HARPOON WITH BARB DOWNWARDS' },
	[0x21BE] = { unicodeslot=0x21BE, category='so', description='UPWARDS HARPOON WITH BARB RIGHTWARDS' },
	[0x21BF] = { unicodeslot=0x21BF, category='so', description='UPWARDS HARPOON WITH BARB LEFTWARDS' },
	[0x21C0] = { unicodeslot=0x21C0, category='so', description='RIGHTWARDS HARPOON WITH BARB UPWARDS' },
	[0x21C1] = { unicodeslot=0x21C1, category='so', description='RIGHTWARDS HARPOON WITH BARB DOWNWARDS' },
	[0x21C2] = { unicodeslot=0x21C2, category='so', description='DOWNWARDS HARPOON WITH BARB RIGHTWARDS' },
	[0x21C3] = { unicodeslot=0x21C3, category='so', description='DOWNWARDS HARPOON WITH BARB LEFTWARDS' },
	[0x21C4] = { unicodeslot=0x21C4, category='so', description='RIGHTWARDS ARROW OVER LEFTWARDS ARROW' },
	[0x21C5] = { unicodeslot=0x21C5, category='so', description='UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW' },
	[0x21C6] = { unicodeslot=0x21C6, category='so', description='LEFTWARDS ARROW OVER RIGHTWARDS ARROW' },
	[0x21C7] = { unicodeslot=0x21C7, category='so', description='LEFTWARDS PAIRED ARROWS' },
	[0x21C8] = { unicodeslot=0x21C8, category='so', description='UPWARDS PAIRED ARROWS' },
	[0x21C9] = { unicodeslot=0x21C9, category='so', description='RIGHTWARDS PAIRED ARROWS' },
	[0x21CA] = { unicodeslot=0x21CA, category='so', description='DOWNWARDS PAIRED ARROWS' },
	[0x21CB] = { unicodeslot=0x21CB, category='so', description='LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON' },
	[0x21CC] = { unicodeslot=0x21CC, category='so', description='RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON' },
	[0x21CD] = { unicodeslot=0x21CD, category='so', description='LEFTWARDS DOUBLE ARROW WITH STROKE', specials={'char',0x21D0,0x0338} },
	[0x21CE] = { unicodeslot=0x21CE, category='sm', description='LEFT RIGHT DOUBLE ARROW WITH STROKE', specials={'char',0x21D4,0x0338} },
	[0x21CF] = { unicodeslot=0x21CF, category='sm', description='RIGHTWARDS DOUBLE ARROW WITH STROKE', specials={'char',0x21D2,0x0338} },
	[0x21D0] = { unicodeslot=0x21D0, category='so', adobename='arrowdblleft', description='LEFTWARDS DOUBLE ARROW' },
	[0x21D1] = { unicodeslot=0x21D1, category='so', adobename='arrowdblup', description='UPWARDS DOUBLE ARROW' },
	[0x21D2] = { unicodeslot=0x21D2, category='sm', adobename='arrowdblright', description='RIGHTWARDS DOUBLE ARROW' },
	[0x21D3] = { unicodeslot=0x21D3, category='so', adobename='arrowdbldown', description='DOWNWARDS DOUBLE ARROW' },
	[0x21D4] = { unicodeslot=0x21D4, category='sm', adobename='arrowdblboth', description='LEFT RIGHT DOUBLE ARROW' },
	[0x21D5] = { unicodeslot=0x21D5, category='so', description='UP DOWN DOUBLE ARROW' },
	[0x21D6] = { unicodeslot=0x21D6, category='so', description='NORTH WEST DOUBLE ARROW' },
	[0x21D7] = { unicodeslot=0x21D7, category='so', description='NORTH EAST DOUBLE ARROW' },
	[0x21D8] = { unicodeslot=0x21D8, category='so', description='SOUTH EAST DOUBLE ARROW' },
	[0x21D9] = { unicodeslot=0x21D9, category='so', description='SOUTH WEST DOUBLE ARROW' },
	[0x21DA] = { unicodeslot=0x21DA, category='so', description='LEFTWARDS TRIPLE ARROW' },
	[0x21DB] = { unicodeslot=0x21DB, category='so', description='RIGHTWARDS TRIPLE ARROW' },
	[0x21DC] = { unicodeslot=0x21DC, category='so', description='LEFTWARDS SQUIGGLE ARROW' },
	[0x21DD] = { unicodeslot=0x21DD, category='so', description='RIGHTWARDS SQUIGGLE ARROW' },
	[0x21DE] = { unicodeslot=0x21DE, category='so', description='UPWARDS ARROW WITH DOUBLE STROKE' },
	[0x21DF] = { unicodeslot=0x21DF, category='so', description='DOWNWARDS ARROW WITH DOUBLE STROKE' },
	[0x21E0] = { unicodeslot=0x21E0, category='so', description='LEFTWARDS DASHED ARROW' },
	[0x21E1] = { unicodeslot=0x21E1, category='so', description='UPWARDS DASHED ARROW' },
	[0x21E2] = { unicodeslot=0x21E2, category='so', description='RIGHTWARDS DASHED ARROW' },
	[0x21E3] = { unicodeslot=0x21E3, category='so', description='DOWNWARDS DASHED ARROW' },
	[0x21E4] = { unicodeslot=0x21E4, category='so', description='LEFTWARDS ARROW TO BAR' },
	[0x21E5] = { unicodeslot=0x21E5, category='so', description='RIGHTWARDS ARROW TO BAR' },
	[0x21E6] = { unicodeslot=0x21E6, category='so', description='LEFTWARDS WHITE ARROW' },
	[0x21E7] = { unicodeslot=0x21E7, category='so', description='UPWARDS WHITE ARROW' },
	[0x21E8] = { unicodeslot=0x21E8, category='so', description='RIGHTWARDS WHITE ARROW' },
	[0x21E9] = { unicodeslot=0x21E9, category='so', description='DOWNWARDS WHITE ARROW' },
	[0x21EA] = { unicodeslot=0x21EA, category='so', description='UPWARDS WHITE ARROW FROM BAR' },
	[0x21EB] = { unicodeslot=0x21EB, category='so', description='UPWARDS WHITE ARROW ON PEDESTAL' },
	[0x21EC] = { unicodeslot=0x21EC, category='so', description='UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR' },
	[0x21ED] = { unicodeslot=0x21ED, category='so', description='UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR' },
	[0x21EE] = { unicodeslot=0x21EE, category='so', description='UPWARDS WHITE DOUBLE ARROW' },
	[0x21EF] = { unicodeslot=0x21EF, category='so', description='UPWARDS WHITE DOUBLE ARROW ON PEDESTAL' },
	[0x21F0] = { unicodeslot=0x21F0, category='so', description='RIGHTWARDS WHITE ARROW FROM WALL' },
	[0x21F1] = { unicodeslot=0x21F1, category='so', description='NORTH WEST ARROW TO CORNER' },
	[0x21F2] = { unicodeslot=0x21F2, category='so', description='SOUTH EAST ARROW TO CORNER' },
	[0x21F3] = { unicodeslot=0x21F3, category='so', description='UP DOWN WHITE ARROW' },
	[0x21F4] = { unicodeslot=0x21F4, category='sm', description='RIGHT ARROW WITH SMALL CIRCLE' },
	[0x21F5] = { unicodeslot=0x21F5, category='sm', description='DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW' },
	[0x21F6] = { unicodeslot=0x21F6, category='sm', description='THREE RIGHTWARDS ARROWS' },
	[0x21F7] = { unicodeslot=0x21F7, category='sm', description='LEFTWARDS ARROW WITH VERTICAL STROKE' },
	[0x21F8] = { unicodeslot=0x21F8, category='sm', description='RIGHTWARDS ARROW WITH VERTICAL STROKE' },
	[0x21F9] = { unicodeslot=0x21F9, category='sm', description='LEFT RIGHT ARROW WITH VERTICAL STROKE' },
	[0x21FA] = { unicodeslot=0x21FA, category='sm', description='LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE' },
	[0x21FB] = { unicodeslot=0x21FB, category='sm', description='RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE' },
	[0x21FC] = { unicodeslot=0x21FC, category='sm', description='LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE' },
	[0x21FD] = { unicodeslot=0x21FD, category='sm', description='LEFTWARDS OPEN-HEADED ARROW' },
	[0x21FE] = { unicodeslot=0x21FE, category='sm', description='RIGHTWARDS OPEN-HEADED ARROW' },
	[0x21FF] = { unicodeslot=0x21FF, category='sm', description='LEFT RIGHT OPEN-HEADED ARROW' },
	[0x2200] = { unicodeslot=0x2200, category='sm', adobename='universal', description='FOR ALL' },
	[0x2201] = { unicodeslot=0x2201, category='sm', description='COMPLEMENT' },
	[0x2202] = { unicodeslot=0x2202, category='sm', adobename='partialdiff', description='PARTIAL DIFFERENTIAL' },
	[0x2203] = { unicodeslot=0x2203, category='sm', adobename='existential', description='THERE EXISTS' },
	[0x2204] = { unicodeslot=0x2204, category='sm', description='THERE DOES NOT EXIST', specials={'char',0x2203,0x0338} },
	[0x2205] = { unicodeslot=0x2205, category='sm', adobename='emptyset', description='EMPTY SET' },
	[0x2206] = { unicodeslot=0x2206, category='sm', adobename='Delta', description='INCREMENT' },
	[0x2207] = { unicodeslot=0x2207, category='sm', adobename='gradient', description='NABLA' },
	[0x2208] = { unicodeslot=0x2208, category='sm', adobename='element', description='ELEMENT OF' },
	[0x2209] = { unicodeslot=0x2209, category='sm', adobename='notelement', description='NOT AN ELEMENT OF', specials={'char',0x2208,0x0338} },
	[0x220A] = { unicodeslot=0x220A, category='sm', description='SMALL ELEMENT OF' },
	[0x220B] = { unicodeslot=0x220B, category='sm', adobename='suchthat', description='CONTAINS AS MEMBER' },
	[0x220C] = { unicodeslot=0x220C, category='sm', description='DOES NOT CONTAIN AS MEMBER', specials={'char',0x220B,0x0338} },
	[0x220D] = { unicodeslot=0x220D, category='sm', description='SMALL CONTAINS AS MEMBER' },
	[0x220E] = { unicodeslot=0x220E, category='sm', description='END OF PROOF' },
	[0x220F] = { unicodeslot=0x220F, category='sm', adobename='product', description='N-ARY PRODUCT' },
	[0x2210] = { unicodeslot=0x2210, category='sm', description='N-ARY COPRODUCT' },
	[0x2211] = { unicodeslot=0x2211, category='sm', adobename='summation', description='N-ARY SUMMATION' },
	[0x2212] = { unicodeslot=0x2212, category='sm', adobename='minus', description='MINUS SIGN' },
	[0x2213] = { unicodeslot=0x2213, category='sm', description='MINUS-OR-PLUS SIGN' },
	[0x2214] = { unicodeslot=0x2214, category='sm', description='DOT PLUS' },
	[0x2215] = { unicodeslot=0x2215, category='sm', description='DIVISION SLASH' },
	[0x2216] = { unicodeslot=0x2216, category='sm', description='SET MINUS' },
	[0x2217] = { unicodeslot=0x2217, category='sm', adobename='asteriskmath', description='ASTERISK OPERATOR' },
	[0x2218] = { unicodeslot=0x2218, category='sm', description='RING OPERATOR' },
	[0x2219] = { unicodeslot=0x2219, category='sm', description='BULLET OPERATOR' },
	[0x221A] = { unicodeslot=0x221A, category='sm', adobename='radical', description='SQUARE ROOT' },
	[0x221B] = { unicodeslot=0x221B, category='sm', description='CUBE ROOT' },
	[0x221C] = { unicodeslot=0x221C, category='sm', description='FOURTH ROOT' },
	[0x221D] = { unicodeslot=0x221D, category='sm', adobename='proportional', description='PROPORTIONAL TO' },
	[0x221E] = { unicodeslot=0x221E, category='sm', adobename='infinity', description='INFINITY' },
	[0x221F] = { unicodeslot=0x221F, category='sm', adobename='orthogonal', description='RIGHT ANGLE' },
	[0x2220] = { unicodeslot=0x2220, category='sm', adobename='angle', description='ANGLE' },
	[0x2221] = { unicodeslot=0x2221, category='sm', description='MEASURED ANGLE' },
	[0x2222] = { unicodeslot=0x2222, category='sm', description='SPHERICAL ANGLE' },
	[0x2223] = { unicodeslot=0x2223, category='sm', description='DIVIDES' },
	[0x2224] = { unicodeslot=0x2224, category='sm', description='DOES NOT DIVIDE', specials={'char',0x2223,0x0338} },
	[0x2225] = { unicodeslot=0x2225, category='sm', description='PARALLEL TO' },
	[0x2226] = { unicodeslot=0x2226, category='sm', description='NOT PARALLEL TO', specials={'char',0x2225,0x0338} },
	[0x2227] = { unicodeslot=0x2227, category='sm', adobename='logicaland', description='LOGICAL AND' },
	[0x2228] = { unicodeslot=0x2228, category='sm', adobename='logicalor', description='LOGICAL OR' },
	[0x2229] = { unicodeslot=0x2229, category='sm', adobename='intersection', description='INTERSECTION' },
	[0x222A] = { unicodeslot=0x222A, category='sm', adobename='union', description='UNION' },
	[0x222B] = { unicodeslot=0x222B, category='sm', adobename='integral', description='INTEGRAL' },
	[0x222C] = { unicodeslot=0x222C, category='sm', description='DOUBLE INTEGRAL', specials={'compat',0x222B,0x222B} },
	[0x222D] = { unicodeslot=0x222D, category='sm', description='TRIPLE INTEGRAL', specials={'compat',0x222B,0x222B,0x222B} },
	[0x222E] = { unicodeslot=0x222E, category='sm', description='CONTOUR INTEGRAL' },
	[0x222F] = { unicodeslot=0x222F, category='sm', description='SURFACE INTEGRAL', specials={'compat',0x222E,0x222E} },
	[0x2230] = { unicodeslot=0x2230, category='sm', description='VOLUME INTEGRAL', specials={'compat',0x222E,0x222E,0x222E} },
	[0x2231] = { unicodeslot=0x2231, category='sm', description='CLOCKWISE INTEGRAL' },
	[0x2232] = { unicodeslot=0x2232, category='sm', description='CLOCKWISE CONTOUR INTEGRAL' },
	[0x2233] = { unicodeslot=0x2233, category='sm', description='ANTICLOCKWISE CONTOUR INTEGRAL' },
	[0x2234] = { unicodeslot=0x2234, category='sm', adobename='therefore', description='THEREFORE' },
	[0x2235] = { unicodeslot=0x2235, category='sm', description='BECAUSE' },
	[0x2236] = { unicodeslot=0x2236, category='sm', description='RATIO' },
	[0x2237] = { unicodeslot=0x2237, category='sm', description='PROPORTION' },
	[0x2238] = { unicodeslot=0x2238, category='sm', description='DOT MINUS' },
	[0x2239] = { unicodeslot=0x2239, category='sm', description='EXCESS' },
	[0x223A] = { unicodeslot=0x223A, category='sm', description='GEOMETRIC PROPORTION' },
	[0x223B] = { unicodeslot=0x223B, category='sm', description='HOMOTHETIC' },
	[0x223C] = { unicodeslot=0x223C, category='sm', adobename='similar', description='TILDE OPERATOR' },
	[0x223D] = { unicodeslot=0x223D, category='sm', description='REVERSED TILDE' },
	[0x223E] = { unicodeslot=0x223E, category='sm', description='INVERTED LAZY S' },
	[0x223F] = { unicodeslot=0x223F, category='sm', description='SINE WAVE' },
	[0x2240] = { unicodeslot=0x2240, category='sm', description='WREATH PRODUCT' },
	[0x2241] = { unicodeslot=0x2241, category='sm', description='NOT TILDE', specials={'char',0x223C,0x0338} },
	[0x2242] = { unicodeslot=0x2242, category='sm', description='MINUS TILDE' },
	[0x2243] = { unicodeslot=0x2243, category='sm', description='ASYMPTOTICALLY EQUAL TO' },
	[0x2244] = { unicodeslot=0x2244, category='sm', description='NOT ASYMPTOTICALLY EQUAL TO', specials={'char',0x2243,0x0338} },
	[0x2245] = { unicodeslot=0x2245, category='sm', adobename='congruent', description='APPROXIMATELY EQUAL TO' },
	[0x2246] = { unicodeslot=0x2246, category='sm', description='APPROXIMATELY BUT NOT ACTUALLY EQUAL TO' },
	[0x2247] = { unicodeslot=0x2247, category='sm', description='NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO', specials={'char',0x2245,0x0338} },
	[0x2248] = { unicodeslot=0x2248, category='sm', adobename='approxequal', description='ALMOST EQUAL TO' },
	[0x2249] = { unicodeslot=0x2249, category='sm', description='NOT ALMOST EQUAL TO', specials={'char',0x2248,0x0338} },
	[0x224A] = { unicodeslot=0x224A, category='sm', description='ALMOST EQUAL OR EQUAL TO' },
	[0x224B] = { unicodeslot=0x224B, category='sm', description='TRIPLE TILDE' },
	[0x224C] = { unicodeslot=0x224C, category='sm', description='ALL EQUAL TO' },
	[0x224D] = { unicodeslot=0x224D, category='sm', description='EQUIVALENT TO' },
	[0x224E] = { unicodeslot=0x224E, category='sm', description='GEOMETRICALLY EQUIVALENT TO' },
	[0x224F] = { unicodeslot=0x224F, category='sm', description='DIFFERENCE BETWEEN' },
	[0x2250] = { unicodeslot=0x2250, category='sm', description='APPROACHES THE LIMIT' },
	[0x2251] = { unicodeslot=0x2251, category='sm', description='GEOMETRICALLY EQUAL TO' },
	[0x2252] = { unicodeslot=0x2252, category='sm', description='APPROXIMATELY EQUAL TO OR THE IMAGE OF' },
	[0x2253] = { unicodeslot=0x2253, category='sm', description='IMAGE OF OR APPROXIMATELY EQUAL TO' },
	[0x2254] = { unicodeslot=0x2254, category='sm', description='COLON EQUALS' },
	[0x2255] = { unicodeslot=0x2255, category='sm', description='EQUALS COLON' },
	[0x2256] = { unicodeslot=0x2256, category='sm', description='RING IN EQUAL TO' },
	[0x2257] = { unicodeslot=0x2257, category='sm', description='RING EQUAL TO' },
	[0x2258] = { unicodeslot=0x2258, category='sm', description='CORRESPONDS TO' },
	[0x2259] = { unicodeslot=0x2259, category='sm', description='ESTIMATES' },
	[0x225A] = { unicodeslot=0x225A, category='sm', description='EQUIANGULAR TO' },
	[0x225B] = { unicodeslot=0x225B, category='sm', description='STAR EQUALS' },
	[0x225C] = { unicodeslot=0x225C, category='sm', description='DELTA EQUAL TO' },
	[0x225D] = { unicodeslot=0x225D, category='sm', description='EQUAL TO BY DEFINITION' },
	[0x225E] = { unicodeslot=0x225E, category='sm', description='MEASURED BY' },
	[0x225F] = { unicodeslot=0x225F, category='sm', description='QUESTIONED EQUAL TO' },
	[0x2260] = { unicodeslot=0x2260, category='sm', adobename='notequal', description='NOT EQUAL TO', specials={'char',0x003D,0x0338} },
	[0x2261] = { unicodeslot=0x2261, category='sm', adobename='equivalence', description='IDENTICAL TO' },
	[0x2262] = { unicodeslot=0x2262, category='sm', description='NOT IDENTICAL TO', specials={'char',0x2261,0x0338} },
	[0x2263] = { unicodeslot=0x2263, category='sm', description='STRICTLY EQUIVALENT TO' },
	[0x2264] = { unicodeslot=0x2264, category='sm', adobename='lessequal', description='LESS-THAN OR EQUAL TO' },
	[0x2265] = { unicodeslot=0x2265, category='sm', adobename='greaterequal', description='GREATER-THAN OR EQUAL TO' },
	[0x2266] = { unicodeslot=0x2266, category='sm', description='LESS-THAN OVER EQUAL TO' },
	[0x2267] = { unicodeslot=0x2267, category='sm', description='GREATER-THAN OVER EQUAL TO' },
	[0x2268] = { unicodeslot=0x2268, category='sm', description='LESS-THAN BUT NOT EQUAL TO' },
	[0x2269] = { unicodeslot=0x2269, category='sm', description='GREATER-THAN BUT NOT EQUAL TO' },
	[0x226A] = { unicodeslot=0x226A, category='sm', description='MUCH LESS-THAN' },
	[0x226B] = { unicodeslot=0x226B, category='sm', description='MUCH GREATER-THAN' },
	[0x226C] = { unicodeslot=0x226C, category='sm', description='BETWEEN' },
	[0x226D] = { unicodeslot=0x226D, category='sm', description='NOT EQUIVALENT TO', specials={'char',0x224D,0x0338} },
	[0x226E] = { unicodeslot=0x226E, category='sm', description='NOT LESS-THAN', specials={'char',0x003C,0x0338} },
	[0x226F] = { unicodeslot=0x226F, category='sm', description='NOT GREATER-THAN', specials={'char',0x003E,0x0338} },
	[0x2270] = { unicodeslot=0x2270, category='sm', description='NEITHER LESS-THAN NOR EQUAL TO', specials={'char',0x2264,0x0338} },
	[0x2271] = { unicodeslot=0x2271, category='sm', description='NEITHER GREATER-THAN NOR EQUAL TO', specials={'char',0x2265,0x0338} },
	[0x2272] = { unicodeslot=0x2272, category='sm', description='LESS-THAN OR EQUIVALENT TO' },
	[0x2273] = { unicodeslot=0x2273, category='sm', description='GREATER-THAN OR EQUIVALENT TO' },
	[0x2274] = { unicodeslot=0x2274, category='sm', description='NEITHER LESS-THAN NOR EQUIVALENT TO', specials={'char',0x2272,0x0338} },
	[0x2275] = { unicodeslot=0x2275, category='sm', description='NEITHER GREATER-THAN NOR EQUIVALENT TO', specials={'char',0x2273,0x0338} },
	[0x2276] = { unicodeslot=0x2276, category='sm', description='LESS-THAN OR GREATER-THAN' },
	[0x2277] = { unicodeslot=0x2277, category='sm', description='GREATER-THAN OR LESS-THAN' },
	[0x2278] = { unicodeslot=0x2278, category='sm', description='NEITHER LESS-THAN NOR GREATER-THAN', specials={'char',0x2276,0x0338} },
	[0x2279] = { unicodeslot=0x2279, category='sm', description='NEITHER GREATER-THAN NOR LESS-THAN', specials={'char',0x2277,0x0338} },
	[0x227A] = { unicodeslot=0x227A, category='sm', description='PRECEDES' },
	[0x227B] = { unicodeslot=0x227B, category='sm', description='SUCCEEDS' },
	[0x227C] = { unicodeslot=0x227C, category='sm', description='PRECEDES OR EQUAL TO' },
	[0x227D] = { unicodeslot=0x227D, category='sm', description='SUCCEEDS OR EQUAL TO' },
	[0x227E] = { unicodeslot=0x227E, category='sm', description='PRECEDES OR EQUIVALENT TO' },
	[0x227F] = { unicodeslot=0x227F, category='sm', description='SUCCEEDS OR EQUIVALENT TO' },
	[0x2280] = { unicodeslot=0x2280, category='sm', description='DOES NOT PRECEDE', specials={'char',0x227A,0x0338} },
	[0x2281] = { unicodeslot=0x2281, category='sm', description='DOES NOT SUCCEED', specials={'char',0x227B,0x0338} },
	[0x2282] = { unicodeslot=0x2282, category='sm', adobename='propersubset', description='SUBSET OF' },
	[0x2283] = { unicodeslot=0x2283, category='sm', adobename='propersuperset', description='SUPERSET OF' },
	[0x2284] = { unicodeslot=0x2284, category='sm', adobename='notsubset', description='NOT A SUBSET OF', specials={'char',0x2282,0x0338} },
	[0x2285] = { unicodeslot=0x2285, category='sm', description='NOT A SUPERSET OF', specials={'char',0x2283,0x0338} },
	[0x2286] = { unicodeslot=0x2286, category='sm', adobename='reflexsubset', description='SUBSET OF OR EQUAL TO' },
	[0x2287] = { unicodeslot=0x2287, category='sm', adobename='reflexsuperset', description='SUPERSET OF OR EQUAL TO' },
	[0x2288] = { unicodeslot=0x2288, category='sm', description='NEITHER A SUBSET OF NOR EQUAL TO', specials={'char',0x2286,0x0338} },
	[0x2289] = { unicodeslot=0x2289, category='sm', description='NEITHER A SUPERSET OF NOR EQUAL TO', specials={'char',0x2287,0x0338} },
	[0x228A] = { unicodeslot=0x228A, category='sm', description='SUBSET OF WITH NOT EQUAL TO' },
	[0x228B] = { unicodeslot=0x228B, category='sm', description='SUPERSET OF WITH NOT EQUAL TO' },
	[0x228C] = { unicodeslot=0x228C, category='sm', description='MULTISET' },
	[0x228D] = { unicodeslot=0x228D, category='sm', description='MULTISET MULTIPLICATION' },
	[0x228E] = { unicodeslot=0x228E, category='sm', description='MULTISET UNION' },
	[0x228F] = { unicodeslot=0x228F, category='sm', description='SQUARE IMAGE OF' },
	[0x2290] = { unicodeslot=0x2290, category='sm', description='SQUARE ORIGINAL OF' },
	[0x2291] = { unicodeslot=0x2291, category='sm', description='SQUARE IMAGE OF OR EQUAL TO' },
	[0x2292] = { unicodeslot=0x2292, category='sm', description='SQUARE ORIGINAL OF OR EQUAL TO' },
	[0x2293] = { unicodeslot=0x2293, category='sm', description='SQUARE CAP' },
	[0x2294] = { unicodeslot=0x2294, category='sm', description='SQUARE CUP' },
	[0x2295] = { unicodeslot=0x2295, category='sm', adobename='circleplus', description='CIRCLED PLUS' },
	[0x2296] = { unicodeslot=0x2296, category='sm', description='CIRCLED MINUS' },
	[0x2297] = { unicodeslot=0x2297, category='sm', adobename='circlemultiply', description='CIRCLED TIMES' },
	[0x2298] = { unicodeslot=0x2298, category='sm', description='CIRCLED DIVISION SLASH' },
	[0x2299] = { unicodeslot=0x2299, category='sm', description='CIRCLED DOT OPERATOR' },
	[0x229A] = { unicodeslot=0x229A, category='sm', description='CIRCLED RING OPERATOR' },
	[0x229B] = { unicodeslot=0x229B, category='sm', description='CIRCLED ASTERISK OPERATOR' },
	[0x229C] = { unicodeslot=0x229C, category='sm', description='CIRCLED EQUALS' },
	[0x229D] = { unicodeslot=0x229D, category='sm', description='CIRCLED DASH' },
	[0x229E] = { unicodeslot=0x229E, category='sm', description='SQUARED PLUS' },
	[0x229F] = { unicodeslot=0x229F, category='sm', description='SQUARED MINUS' },
	[0x22A0] = { unicodeslot=0x22A0, category='sm', description='SQUARED TIMES' },
	[0x22A1] = { unicodeslot=0x22A1, category='sm', description='SQUARED DOT OPERATOR' },
	[0x22A2] = { unicodeslot=0x22A2, category='sm', description='RIGHT TACK' },
	[0x22A3] = { unicodeslot=0x22A3, category='sm', description='LEFT TACK' },
	[0x22A4] = { unicodeslot=0x22A4, category='sm', description='DOWN TACK' },
	[0x22A5] = { unicodeslot=0x22A5, category='sm', adobename='perpendicular', description='UP TACK' },
	[0x22A6] = { unicodeslot=0x22A6, category='sm', description='ASSERTION' },
	[0x22A7] = { unicodeslot=0x22A7, category='sm', description='MODELS' },
	[0x22A8] = { unicodeslot=0x22A8, category='sm', description='TRUE' },
	[0x22A9] = { unicodeslot=0x22A9, category='sm', description='FORCES' },
	[0x22AA] = { unicodeslot=0x22AA, category='sm', description='TRIPLE VERTICAL BAR RIGHT TURNSTILE' },
	[0x22AB] = { unicodeslot=0x22AB, category='sm', description='DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE' },
	[0x22AC] = { unicodeslot=0x22AC, category='sm', description='DOES NOT PROVE', specials={'char',0x22A2,0x0338} },
	[0x22AD] = { unicodeslot=0x22AD, category='sm', description='NOT TRUE', specials={'char',0x22A8,0x0338} },
	[0x22AE] = { unicodeslot=0x22AE, category='sm', description='DOES NOT FORCE', specials={'char',0x22A9,0x0338} },
	[0x22AF] = { unicodeslot=0x22AF, category='sm', description='NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE', specials={'char',0x22AB,0x0338} },
	[0x22B0] = { unicodeslot=0x22B0, category='sm', description='PRECEDES UNDER RELATION' },
	[0x22B1] = { unicodeslot=0x22B1, category='sm', description='SUCCEEDS UNDER RELATION' },
	[0x22B2] = { unicodeslot=0x22B2, category='sm', description='NORMAL SUBGROUP OF' },
	[0x22B3] = { unicodeslot=0x22B3, category='sm', description='CONTAINS AS NORMAL SUBGROUP' },
	[0x22B4] = { unicodeslot=0x22B4, category='sm', description='NORMAL SUBGROUP OF OR EQUAL TO' },
	[0x22B5] = { unicodeslot=0x22B5, category='sm', description='CONTAINS AS NORMAL SUBGROUP OR EQUAL TO' },
	[0x22B6] = { unicodeslot=0x22B6, category='sm', description='ORIGINAL OF' },
	[0x22B7] = { unicodeslot=0x22B7, category='sm', description='IMAGE OF' },
	[0x22B8] = { unicodeslot=0x22B8, category='sm', description='MULTIMAP' },
	[0x22B9] = { unicodeslot=0x22B9, category='sm', description='HERMITIAN CONJUGATE MATRIX' },
	[0x22BA] = { unicodeslot=0x22BA, category='sm', description='INTERCALATE' },
	[0x22BB] = { unicodeslot=0x22BB, category='sm', description='XOR' },
	[0x22BC] = { unicodeslot=0x22BC, category='sm', description='NAND' },
	[0x22BD] = { unicodeslot=0x22BD, category='sm', description='NOR' },
	[0x22BE] = { unicodeslot=0x22BE, category='sm', description='RIGHT ANGLE WITH ARC' },
	[0x22BF] = { unicodeslot=0x22BF, category='sm', description='RIGHT TRIANGLE' },
	[0x22C0] = { unicodeslot=0x22C0, category='sm', description='N-ARY LOGICAL AND' },
	[0x22C1] = { unicodeslot=0x22C1, category='sm', description='N-ARY LOGICAL OR' },
	[0x22C2] = { unicodeslot=0x22C2, category='sm', description='N-ARY INTERSECTION' },
	[0x22C3] = { unicodeslot=0x22C3, category='sm', description='N-ARY UNION' },
	[0x22C4] = { unicodeslot=0x22C4, category='sm', description='DIAMOND OPERATOR' },
	[0x22C5] = { unicodeslot=0x22C5, category='sm', adobename='dotmath', description='DOT OPERATOR' },
	[0x22C6] = { unicodeslot=0x22C6, category='sm', description='STAR OPERATOR' },
	[0x22C7] = { unicodeslot=0x22C7, category='sm', description='DIVISION TIMES' },
	[0x22C8] = { unicodeslot=0x22C8, category='sm', description='BOWTIE' },
	[0x22C9] = { unicodeslot=0x22C9, category='sm', description='LEFT NORMAL FACTOR SEMIDIRECT PRODUCT' },
	[0x22CA] = { unicodeslot=0x22CA, category='sm', description='RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT' },
	[0x22CB] = { unicodeslot=0x22CB, category='sm', description='LEFT SEMIDIRECT PRODUCT' },
	[0x22CC] = { unicodeslot=0x22CC, category='sm', description='RIGHT SEMIDIRECT PRODUCT' },
	[0x22CD] = { unicodeslot=0x22CD, category='sm', description='REVERSED TILDE EQUALS' },
	[0x22CE] = { unicodeslot=0x22CE, category='sm', description='CURLY LOGICAL OR' },
	[0x22CF] = { unicodeslot=0x22CF, category='sm', description='CURLY LOGICAL AND' },
	[0x22D0] = { unicodeslot=0x22D0, category='sm', description='DOUBLE SUBSET' },
	[0x22D1] = { unicodeslot=0x22D1, category='sm', description='DOUBLE SUPERSET' },
	[0x22D2] = { unicodeslot=0x22D2, category='sm', description='DOUBLE INTERSECTION' },
	[0x22D3] = { unicodeslot=0x22D3, category='sm', description='DOUBLE UNION' },
	[0x22D4] = { unicodeslot=0x22D4, category='sm', description='PITCHFORK' },
	[0x22D5] = { unicodeslot=0x22D5, category='sm', description='EQUAL AND PARALLEL TO' },
	[0x22D6] = { unicodeslot=0x22D6, category='sm', description='LESS-THAN WITH DOT' },
	[0x22D7] = { unicodeslot=0x22D7, category='sm', description='GREATER-THAN WITH DOT' },
	[0x22D8] = { unicodeslot=0x22D8, category='sm', description='VERY MUCH LESS-THAN' },
	[0x22D9] = { unicodeslot=0x22D9, category='sm', description='VERY MUCH GREATER-THAN' },
	[0x22DA] = { unicodeslot=0x22DA, category='sm', description='LESS-THAN EQUAL TO OR GREATER-THAN' },
	[0x22DB] = { unicodeslot=0x22DB, category='sm', description='GREATER-THAN EQUAL TO OR LESS-THAN' },
	[0x22DC] = { unicodeslot=0x22DC, category='sm', description='EQUAL TO OR LESS-THAN' },
	[0x22DD] = { unicodeslot=0x22DD, category='sm', description='EQUAL TO OR GREATER-THAN' },
	[0x22DE] = { unicodeslot=0x22DE, category='sm', description='EQUAL TO OR PRECEDES' },
	[0x22DF] = { unicodeslot=0x22DF, category='sm', description='EQUAL TO OR SUCCEEDS' },
	[0x22E0] = { unicodeslot=0x22E0, category='sm', description='DOES NOT PRECEDE OR EQUAL', specials={'char',0x227C,0x0338} },
	[0x22E1] = { unicodeslot=0x22E1, category='sm', description='DOES NOT SUCCEED OR EQUAL', specials={'char',0x227D,0x0338} },
	[0x22E2] = { unicodeslot=0x22E2, category='sm', description='NOT SQUARE IMAGE OF OR EQUAL TO', specials={'char',0x2291,0x0338} },
	[0x22E3] = { unicodeslot=0x22E3, category='sm', description='NOT SQUARE ORIGINAL OF OR EQUAL TO', specials={'char',0x2292,0x0338} },
	[0x22E4] = { unicodeslot=0x22E4, category='sm', description='SQUARE IMAGE OF OR NOT EQUAL TO' },
	[0x22E5] = { unicodeslot=0x22E5, category='sm', description='SQUARE ORIGINAL OF OR NOT EQUAL TO' },
	[0x22E6] = { unicodeslot=0x22E6, category='sm', description='LESS-THAN BUT NOT EQUIVALENT TO' },
	[0x22E7] = { unicodeslot=0x22E7, category='sm', description='GREATER-THAN BUT NOT EQUIVALENT TO' },
	[0x22E8] = { unicodeslot=0x22E8, category='sm', description='PRECEDES BUT NOT EQUIVALENT TO' },
	[0x22E9] = { unicodeslot=0x22E9, category='sm', description='SUCCEEDS BUT NOT EQUIVALENT TO' },
	[0x22EA] = { unicodeslot=0x22EA, category='sm', description='NOT NORMAL SUBGROUP OF', specials={'char',0x22B2,0x0338} },
	[0x22EB] = { unicodeslot=0x22EB, category='sm', description='DOES NOT CONTAIN AS NORMAL SUBGROUP', specials={'char',0x22B3,0x0338} },
	[0x22EC] = { unicodeslot=0x22EC, category='sm', description='NOT NORMAL SUBGROUP OF OR EQUAL TO', specials={'char',0x22B4,0x0338} },
	[0x22ED] = { unicodeslot=0x22ED, category='sm', description='DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL', specials={'char',0x22B5,0x0338} },
	[0x22EE] = { unicodeslot=0x22EE, category='sm', description='VERTICAL ELLIPSIS' },
	[0x22EF] = { unicodeslot=0x22EF, category='sm', description='MIDLINE HORIZONTAL ELLIPSIS' },
	[0x22F0] = { unicodeslot=0x22F0, category='sm', description='UP RIGHT DIAGONAL ELLIPSIS' },
	[0x22F1] = { unicodeslot=0x22F1, category='sm', description='DOWN RIGHT DIAGONAL ELLIPSIS' },
	[0x22F2] = { unicodeslot=0x22F2, category='sm', description='ELEMENT OF WITH LONG HORIZONTAL STROKE' },
	[0x22F3] = { unicodeslot=0x22F3, category='sm', description='ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE' },
	[0x22F4] = { unicodeslot=0x22F4, category='sm', description='SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE' },
	[0x22F5] = { unicodeslot=0x22F5, category='sm', description='ELEMENT OF WITH DOT ABOVE' },
	[0x22F6] = { unicodeslot=0x22F6, category='sm', description='ELEMENT OF WITH OVERBAR' },
	[0x22F7] = { unicodeslot=0x22F7, category='sm', description='SMALL ELEMENT OF WITH OVERBAR' },
	[0x22F8] = { unicodeslot=0x22F8, category='sm', description='ELEMENT OF WITH UNDERBAR' },
	[0x22F9] = { unicodeslot=0x22F9, category='sm', description='ELEMENT OF WITH TWO HORIZONTAL STROKES' },
	[0x22FA] = { unicodeslot=0x22FA, category='sm', description='CONTAINS WITH LONG HORIZONTAL STROKE' },
	[0x22FB] = { unicodeslot=0x22FB, category='sm', description='CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE' },
	[0x22FC] = { unicodeslot=0x22FC, category='sm', description='SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE' },
	[0x22FD] = { unicodeslot=0x22FD, category='sm', description='CONTAINS WITH OVERBAR' },
	[0x22FE] = { unicodeslot=0x22FE, category='sm', description='SMALL CONTAINS WITH OVERBAR' },
	[0x22FF] = { unicodeslot=0x22FF, category='sm', description='Z NOTATION BAG MEMBERSHIP' },
	[0x2300] = { unicodeslot=0x2300, category='so', description='DIAMETER SIGN' },
	[0x2301] = { unicodeslot=0x2301, category='so', description='ELECTRIC ARROW' },
	[0x2302] = { unicodeslot=0x2302, category='so', adobename='house', description='HOUSE' },
	[0x2303] = { unicodeslot=0x2303, category='so', description='UP ARROWHEAD' },
	[0x2304] = { unicodeslot=0x2304, category='so', description='DOWN ARROWHEAD' },
	[0x2305] = { unicodeslot=0x2305, category='so', description='PROJECTIVE' },
	[0x2306] = { unicodeslot=0x2306, category='so', description='PERSPECTIVE' },
	[0x2307] = { unicodeslot=0x2307, category='so', description='WAVY LINE' },
	[0x2308] = { unicodeslot=0x2308, category='sm', description='LEFT CEILING' },
	[0x2309] = { unicodeslot=0x2309, category='sm', description='RIGHT CEILING' },
	[0x230A] = { unicodeslot=0x230A, category='sm', description='LEFT FLOOR' },
	[0x230B] = { unicodeslot=0x230B, category='sm', description='RIGHT FLOOR' },
	[0x230C] = { unicodeslot=0x230C, category='so', description='BOTTOM RIGHT CROP' },
	[0x230D] = { unicodeslot=0x230D, category='so', description='BOTTOM LEFT CROP' },
	[0x230E] = { unicodeslot=0x230E, category='so', description='TOP RIGHT CROP' },
	[0x230F] = { unicodeslot=0x230F, category='so', description='TOP LEFT CROP' },
	[0x2310] = { unicodeslot=0x2310, category='so', adobename='revlogicalnot', description='REVERSED NOT SIGN' },
	[0x2311] = { unicodeslot=0x2311, category='so', description='SQUARE LOZENGE' },
	[0x2312] = { unicodeslot=0x2312, category='so', description='ARC' },
	[0x2313] = { unicodeslot=0x2313, category='so', description='SEGMENT' },
	[0x2314] = { unicodeslot=0x2314, category='so', description='SECTOR' },
	[0x2315] = { unicodeslot=0x2315, category='so', description='TELEPHONE RECORDER' },
	[0x2316] = { unicodeslot=0x2316, category='so', description='POSITION INDICATOR' },
	[0x2317] = { unicodeslot=0x2317, category='so', description='VIEWDATA SQUARE' },
	[0x2318] = { unicodeslot=0x2318, category='so', description='PLACE OF INTEREST SIGN' },
	[0x2319] = { unicodeslot=0x2319, category='so', description='TURNED NOT SIGN' },
	[0x231A] = { unicodeslot=0x231A, category='so', description='WATCH' },
	[0x231B] = { unicodeslot=0x231B, category='so', description='HOURGLASS' },
	[0x231C] = { unicodeslot=0x231C, category='so', description='TOP LEFT CORNER' },
	[0x231D] = { unicodeslot=0x231D, category='so', description='TOP RIGHT CORNER' },
	[0x231E] = { unicodeslot=0x231E, category='so', description='BOTTOM LEFT CORNER' },
	[0x231F] = { unicodeslot=0x231F, category='so', description='BOTTOM RIGHT CORNER' },
	[0x2320] = { unicodeslot=0x2320, category='sm', adobename='integraltp', description='TOP HALF INTEGRAL' },
	[0x2321] = { unicodeslot=0x2321, category='sm', adobename='integralbt', description='BOTTOM HALF INTEGRAL' },
	[0x2322] = { unicodeslot=0x2322, category='so', description='FROWN' },
	[0x2323] = { unicodeslot=0x2323, category='so', description='SMILE' },
	[0x2324] = { unicodeslot=0x2324, category='so', description='UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS' },
	[0x2325] = { unicodeslot=0x2325, category='so', description='OPTION KEY' },
	[0x2326] = { unicodeslot=0x2326, category='so', description='ERASE TO THE RIGHT' },
	[0x2327] = { unicodeslot=0x2327, category='so', description='X IN A RECTANGLE BOX' },
	[0x2328] = { unicodeslot=0x2328, category='so', description='KEYBOARD' },
	[0x2329] = { unicodeslot=0x2329, category='ps', adobename='angleleft', description='LEFT-POINTING ANGLE BRACKET', specials={'char',0x3008} },
	[0x232A] = { unicodeslot=0x232A, category='pe', adobename='angleright', description='RIGHT-POINTING ANGLE BRACKET', specials={'char',0x3009} },
	[0x232B] = { unicodeslot=0x232B, category='so', description='ERASE TO THE LEFT' },
	[0x232C] = { unicodeslot=0x232C, category='so', description='BENZENE RING' },
	[0x232D] = { unicodeslot=0x232D, category='so', description='CYLINDRICITY' },
	[0x232E] = { unicodeslot=0x232E, category='so', description='ALL AROUND-PROFILE' },
	[0x232F] = { unicodeslot=0x232F, category='so', description='SYMMETRY' },
	[0x2330] = { unicodeslot=0x2330, category='so', description='TOTAL RUNOUT' },
	[0x2331] = { unicodeslot=0x2331, category='so', description='DIMENSION ORIGIN' },
	[0x2332] = { unicodeslot=0x2332, category='so', description='CONICAL TAPER' },
	[0x2333] = { unicodeslot=0x2333, category='so', description='SLOPE' },
	[0x2334] = { unicodeslot=0x2334, category='so', description='COUNTERBORE' },
	[0x2335] = { unicodeslot=0x2335, category='so', description='COUNTERSINK' },
	[0x2336] = { unicodeslot=0x2336, category='so', description='APL FUNCTIONAL SYMBOL I-BEAM' },
	[0x2337] = { unicodeslot=0x2337, category='so', description='APL FUNCTIONAL SYMBOL SQUISH QUAD' },
	[0x2338] = { unicodeslot=0x2338, category='so', description='APL FUNCTIONAL SYMBOL QUAD EQUAL' },
	[0x2339] = { unicodeslot=0x2339, category='so', description='APL FUNCTIONAL SYMBOL QUAD DIVIDE' },
	[0x233A] = { unicodeslot=0x233A, category='so', description='APL FUNCTIONAL SYMBOL QUAD DIAMOND' },
	[0x233B] = { unicodeslot=0x233B, category='so', description='APL FUNCTIONAL SYMBOL QUAD JOT' },
	[0x233C] = { unicodeslot=0x233C, category='so', description='APL FUNCTIONAL SYMBOL QUAD CIRCLE' },
	[0x233D] = { unicodeslot=0x233D, category='so', description='APL FUNCTIONAL SYMBOL CIRCLE STILE' },
	[0x233E] = { unicodeslot=0x233E, category='so', description='APL FUNCTIONAL SYMBOL CIRCLE JOT' },
	[0x233F] = { unicodeslot=0x233F, category='so', description='APL FUNCTIONAL SYMBOL SLASH BAR' },
	[0x2340] = { unicodeslot=0x2340, category='so', description='APL FUNCTIONAL SYMBOL BACKSLASH BAR' },
	[0x2341] = { unicodeslot=0x2341, category='so', description='APL FUNCTIONAL SYMBOL QUAD SLASH' },
	[0x2342] = { unicodeslot=0x2342, category='so', description='APL FUNCTIONAL SYMBOL QUAD BACKSLASH' },
	[0x2343] = { unicodeslot=0x2343, category='so', description='APL FUNCTIONAL SYMBOL QUAD LESS-THAN' },
	[0x2344] = { unicodeslot=0x2344, category='so', description='APL FUNCTIONAL SYMBOL QUAD GREATER-THAN' },
	[0x2345] = { unicodeslot=0x2345, category='so', description='APL FUNCTIONAL SYMBOL LEFTWARDS VANE' },
	[0x2346] = { unicodeslot=0x2346, category='so', description='APL FUNCTIONAL SYMBOL RIGHTWARDS VANE' },
	[0x2347] = { unicodeslot=0x2347, category='so', description='APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW' },
	[0x2348] = { unicodeslot=0x2348, category='so', description='APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW' },
	[0x2349] = { unicodeslot=0x2349, category='so', description='APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH' },
	[0x234A] = { unicodeslot=0x234A, category='so', description='APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR' },
	[0x234B] = { unicodeslot=0x234B, category='so', description='APL FUNCTIONAL SYMBOL DELTA STILE' },
	[0x234C] = { unicodeslot=0x234C, category='so', description='APL FUNCTIONAL SYMBOL QUAD DOWN CARET' },
	[0x234D] = { unicodeslot=0x234D, category='so', description='APL FUNCTIONAL SYMBOL QUAD DELTA' },
	[0x234E] = { unicodeslot=0x234E, category='so', description='APL FUNCTIONAL SYMBOL DOWN TACK JOT' },
	[0x234F] = { unicodeslot=0x234F, category='so', description='APL FUNCTIONAL SYMBOL UPWARDS VANE' },
	[0x2350] = { unicodeslot=0x2350, category='so', description='APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW' },
	[0x2351] = { unicodeslot=0x2351, category='so', description='APL FUNCTIONAL SYMBOL UP TACK OVERBAR' },
	[0x2352] = { unicodeslot=0x2352, category='so', description='APL FUNCTIONAL SYMBOL DEL STILE' },
	[0x2353] = { unicodeslot=0x2353, category='so', description='APL FUNCTIONAL SYMBOL QUAD UP CARET' },
	[0x2354] = { unicodeslot=0x2354, category='so', description='APL FUNCTIONAL SYMBOL QUAD DEL' },
	[0x2355] = { unicodeslot=0x2355, category='so', description='APL FUNCTIONAL SYMBOL UP TACK JOT' },
	[0x2356] = { unicodeslot=0x2356, category='so', description='APL FUNCTIONAL SYMBOL DOWNWARDS VANE' },
	[0x2357] = { unicodeslot=0x2357, category='so', description='APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW' },
	[0x2358] = { unicodeslot=0x2358, category='so', description='APL FUNCTIONAL SYMBOL QUOTE UNDERBAR' },
	[0x2359] = { unicodeslot=0x2359, category='so', description='APL FUNCTIONAL SYMBOL DELTA UNDERBAR' },
	[0x235A] = { unicodeslot=0x235A, category='so', description='APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR' },
	[0x235B] = { unicodeslot=0x235B, category='so', description='APL FUNCTIONAL SYMBOL JOT UNDERBAR' },
	[0x235C] = { unicodeslot=0x235C, category='so', description='APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR' },
	[0x235D] = { unicodeslot=0x235D, category='so', description='APL FUNCTIONAL SYMBOL UP SHOE JOT' },
	[0x235E] = { unicodeslot=0x235E, category='so', description='APL FUNCTIONAL SYMBOL QUOTE QUAD' },
	[0x235F] = { unicodeslot=0x235F, category='so', description='APL FUNCTIONAL SYMBOL CIRCLE STAR' },
	[0x2360] = { unicodeslot=0x2360, category='so', description='APL FUNCTIONAL SYMBOL QUAD COLON' },
	[0x2361] = { unicodeslot=0x2361, category='so', description='APL FUNCTIONAL SYMBOL UP TACK DIAERESIS' },
	[0x2362] = { unicodeslot=0x2362, category='so', description='APL FUNCTIONAL SYMBOL DEL DIAERESIS' },
	[0x2363] = { unicodeslot=0x2363, category='so', description='APL FUNCTIONAL SYMBOL STAR DIAERESIS' },
	[0x2364] = { unicodeslot=0x2364, category='so', description='APL FUNCTIONAL SYMBOL JOT DIAERESIS' },
	[0x2365] = { unicodeslot=0x2365, category='so', description='APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS' },
	[0x2366] = { unicodeslot=0x2366, category='so', description='APL FUNCTIONAL SYMBOL DOWN SHOE STILE' },
	[0x2367] = { unicodeslot=0x2367, category='so', description='APL FUNCTIONAL SYMBOL LEFT SHOE STILE' },
	[0x2368] = { unicodeslot=0x2368, category='so', description='APL FUNCTIONAL SYMBOL TILDE DIAERESIS' },
	[0x2369] = { unicodeslot=0x2369, category='so', description='APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS' },
	[0x236A] = { unicodeslot=0x236A, category='so', description='APL FUNCTIONAL SYMBOL COMMA BAR' },
	[0x236B] = { unicodeslot=0x236B, category='so', description='APL FUNCTIONAL SYMBOL DEL TILDE' },
	[0x236C] = { unicodeslot=0x236C, category='so', description='APL FUNCTIONAL SYMBOL ZILDE' },
	[0x236D] = { unicodeslot=0x236D, category='so', description='APL FUNCTIONAL SYMBOL STILE TILDE' },
	[0x236E] = { unicodeslot=0x236E, category='so', description='APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR' },
	[0x236F] = { unicodeslot=0x236F, category='so', description='APL FUNCTIONAL SYMBOL QUAD NOT EQUAL' },
	[0x2370] = { unicodeslot=0x2370, category='so', description='APL FUNCTIONAL SYMBOL QUAD QUESTION' },
	[0x2371] = { unicodeslot=0x2371, category='so', description='APL FUNCTIONAL SYMBOL DOWN CARET TILDE' },
	[0x2372] = { unicodeslot=0x2372, category='so', description='APL FUNCTIONAL SYMBOL UP CARET TILDE' },
	[0x2373] = { unicodeslot=0x2373, category='so', description='APL FUNCTIONAL SYMBOL IOTA' },
	[0x2374] = { unicodeslot=0x2374, category='so', description='APL FUNCTIONAL SYMBOL RHO' },
	[0x2375] = { unicodeslot=0x2375, category='so', description='APL FUNCTIONAL SYMBOL OMEGA' },
	[0x2376] = { unicodeslot=0x2376, category='so', description='APL FUNCTIONAL SYMBOL ALPHA UNDERBAR' },
	[0x2377] = { unicodeslot=0x2377, category='so', description='APL FUNCTIONAL SYMBOL EPSILON UNDERBAR' },
	[0x2378] = { unicodeslot=0x2378, category='so', description='APL FUNCTIONAL SYMBOL IOTA UNDERBAR' },
	[0x2379] = { unicodeslot=0x2379, category='so', description='APL FUNCTIONAL SYMBOL OMEGA UNDERBAR' },
	[0x237A] = { unicodeslot=0x237A, category='so', description='APL FUNCTIONAL SYMBOL ALPHA' },
	[0x237B] = { unicodeslot=0x237B, category='so', description='NOT CHECK MARK' },
	[0x237C] = { unicodeslot=0x237C, category='sm', description='RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW' },
	[0x237D] = { unicodeslot=0x237D, category='so', description='SHOULDERED OPEN BOX' },
	[0x237E] = { unicodeslot=0x237E, category='so', description='BELL SYMBOL' },
	[0x237F] = { unicodeslot=0x237F, category='so', description='VERTICAL LINE WITH MIDDLE DOT' },
	[0x2380] = { unicodeslot=0x2380, category='so', description='INSERTION SYMBOL' },
	[0x2381] = { unicodeslot=0x2381, category='so', description='CONTINUOUS UNDERLINE SYMBOL' },
	[0x2382] = { unicodeslot=0x2382, category='so', description='DISCONTINUOUS UNDERLINE SYMBOL' },
	[0x2383] = { unicodeslot=0x2383, category='so', description='EMPHASIS SYMBOL' },
	[0x2384] = { unicodeslot=0x2384, category='so', description='COMPOSITION SYMBOL' },
	[0x2385] = { unicodeslot=0x2385, category='so', description='WHITE SQUARE WITH CENTRE VERTICAL LINE' },
	[0x2386] = { unicodeslot=0x2386, category='so', description='ENTER SYMBOL' },
	[0x2387] = { unicodeslot=0x2387, category='so', description='ALTERNATIVE KEY SYMBOL' },
	[0x2388] = { unicodeslot=0x2388, category='so', description='HELM SYMBOL' },
	[0x2389] = { unicodeslot=0x2389, category='so', description='CIRCLED HORIZONTAL BAR WITH NOTCH' },
	[0x238A] = { unicodeslot=0x238A, category='so', description='CIRCLED TRIANGLE DOWN' },
	[0x238B] = { unicodeslot=0x238B, category='so', description='BROKEN CIRCLE WITH NORTHWEST ARROW' },
	[0x238C] = { unicodeslot=0x238C, category='so', description='UNDO SYMBOL' },
	[0x238D] = { unicodeslot=0x238D, category='so', description='MONOSTABLE SYMBOL' },
	[0x238E] = { unicodeslot=0x238E, category='so', description='HYSTERESIS SYMBOL' },
	[0x238F] = { unicodeslot=0x238F, category='so', description='OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL' },
	[0x2390] = { unicodeslot=0x2390, category='so', description='OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL' },
	[0x2391] = { unicodeslot=0x2391, category='so', description='PASSIVE-PULL-DOWN-OUTPUT SYMBOL' },
	[0x2392] = { unicodeslot=0x2392, category='so', description='PASSIVE-PULL-UP-OUTPUT SYMBOL' },
	[0x2393] = { unicodeslot=0x2393, category='so', description='DIRECT CURRENT SYMBOL FORM TWO' },
	[0x2394] = { unicodeslot=0x2394, category='so', description='SOFTWARE-FUNCTION SYMBOL' },
	[0x2395] = { unicodeslot=0x2395, category='so', description='APL FUNCTIONAL SYMBOL QUAD' },
	[0x2396] = { unicodeslot=0x2396, category='so', description='DECIMAL SEPARATOR KEY SYMBOL' },
	[0x2397] = { unicodeslot=0x2397, category='so', description='PREVIOUS PAGE' },
	[0x2398] = { unicodeslot=0x2398, category='so', description='NEXT PAGE' },
	[0x2399] = { unicodeslot=0x2399, category='so', description='PRINT SCREEN SYMBOL' },
	[0x239A] = { unicodeslot=0x239A, category='so', description='CLEAR SCREEN SYMBOL' },
	[0x239B] = { unicodeslot=0x239B, category='sm', description='LEFT PARENTHESIS UPPER HOOK' },
	[0x239C] = { unicodeslot=0x239C, category='sm', description='LEFT PARENTHESIS EXTENSION' },
	[0x239D] = { unicodeslot=0x239D, category='sm', description='LEFT PARENTHESIS LOWER HOOK' },
	[0x239E] = { unicodeslot=0x239E, category='sm', description='RIGHT PARENTHESIS UPPER HOOK' },
	[0x239F] = { unicodeslot=0x239F, category='sm', description='RIGHT PARENTHESIS EXTENSION' },
	[0x23A0] = { unicodeslot=0x23A0, category='sm', description='RIGHT PARENTHESIS LOWER HOOK' },
	[0x23A1] = { unicodeslot=0x23A1, category='sm', description='LEFT SQUARE BRACKET UPPER CORNER' },
	[0x23A2] = { unicodeslot=0x23A2, category='sm', description='LEFT SQUARE BRACKET EXTENSION' },
	[0x23A3] = { unicodeslot=0x23A3, category='sm', description='LEFT SQUARE BRACKET LOWER CORNER' },
	[0x23A4] = { unicodeslot=0x23A4, category='sm', description='RIGHT SQUARE BRACKET UPPER CORNER' },
	[0x23A5] = { unicodeslot=0x23A5, category='sm', description='RIGHT SQUARE BRACKET EXTENSION' },
	[0x23A6] = { unicodeslot=0x23A6, category='sm', description='RIGHT SQUARE BRACKET LOWER CORNER' },
	[0x23A7] = { unicodeslot=0x23A7, category='sm', description='LEFT CURLY BRACKET UPPER HOOK' },
	[0x23A8] = { unicodeslot=0x23A8, category='sm', description='LEFT CURLY BRACKET MIDDLE PIECE' },
	[0x23A9] = { unicodeslot=0x23A9, category='sm', description='LEFT CURLY BRACKET LOWER HOOK' },
	[0x23AA] = { unicodeslot=0x23AA, category='sm', description='CURLY BRACKET EXTENSION' },
	[0x23AB] = { unicodeslot=0x23AB, category='sm', description='RIGHT CURLY BRACKET UPPER HOOK' },
	[0x23AC] = { unicodeslot=0x23AC, category='sm', description='RIGHT CURLY BRACKET MIDDLE PIECE' },
	[0x23AD] = { unicodeslot=0x23AD, category='sm', description='RIGHT CURLY BRACKET LOWER HOOK' },
	[0x23AE] = { unicodeslot=0x23AE, category='sm', description='INTEGRAL EXTENSION' },
	[0x23AF] = { unicodeslot=0x23AF, category='sm', description='HORIZONTAL LINE EXTENSION' },
	[0x23B0] = { unicodeslot=0x23B0, category='sm', description='UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION' },
	[0x23B1] = { unicodeslot=0x23B1, category='sm', description='UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION' },
	[0x23B2] = { unicodeslot=0x23B2, category='sm', description='SUMMATION TOP' },
	[0x23B3] = { unicodeslot=0x23B3, category='sm', description='SUMMATION BOTTOM' },
	[0x23B4] = { unicodeslot=0x23B4, category='so', description='TOP SQUARE BRACKET' },
	[0x23B5] = { unicodeslot=0x23B5, category='so', description='BOTTOM SQUARE BRACKET' },
	[0x23B6] = { unicodeslot=0x23B6, category='so', description='BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET' },
	[0x23B7] = { unicodeslot=0x23B7, category='so', description='RADICAL SYMBOL BOTTOM' },
	[0x23B8] = { unicodeslot=0x23B8, category='so', description='LEFT VERTICAL BOX LINE' },
	[0x23B9] = { unicodeslot=0x23B9, category='so', description='RIGHT VERTICAL BOX LINE' },
	[0x23BA] = { unicodeslot=0x23BA, category='so', description='HORIZONTAL SCAN LINE-1' },
	[0x23BB] = { unicodeslot=0x23BB, category='so', description='HORIZONTAL SCAN LINE-3' },
	[0x23BC] = { unicodeslot=0x23BC, category='so', description='HORIZONTAL SCAN LINE-7' },
	[0x23BD] = { unicodeslot=0x23BD, category='so', description='HORIZONTAL SCAN LINE-9' },
	[0x23BE] = { unicodeslot=0x23BE, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT' },
	[0x23BF] = { unicodeslot=0x23BF, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT' },
	[0x23C0] = { unicodeslot=0x23C0, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE' },
	[0x23C1] = { unicodeslot=0x23C1, category='so', description='DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE' },
	[0x23C2] = { unicodeslot=0x23C2, category='so', description='DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE' },
	[0x23C3] = { unicodeslot=0x23C3, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE' },
	[0x23C4] = { unicodeslot=0x23C4, category='so', description='DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE' },
	[0x23C5] = { unicodeslot=0x23C5, category='so', description='DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE' },
	[0x23C6] = { unicodeslot=0x23C6, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE' },
	[0x23C7] = { unicodeslot=0x23C7, category='so', description='DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE' },
	[0x23C8] = { unicodeslot=0x23C8, category='so', description='DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE' },
	[0x23C9] = { unicodeslot=0x23C9, category='so', description='DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL' },
	[0x23CA] = { unicodeslot=0x23CA, category='so', description='DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL' },
	[0x23CB] = { unicodeslot=0x23CB, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT' },
	[0x23CC] = { unicodeslot=0x23CC, category='so', description='DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT' },
	[0x23CD] = { unicodeslot=0x23CD, category='so', description='SQUARE FOOT' },
	[0x23CE] = { unicodeslot=0x23CE, category='so', description='RETURN SYMBOL' },
	[0x23CF] = { unicodeslot=0x23CF, category='so', description='EJECT SYMBOL' },
	[0x23D0] = { unicodeslot=0x23D0, category='so', description='VERTICAL LINE EXTENSION' },
	[0x23D1] = { unicodeslot=0x23D1, category='so', description='METRICAL BREVE' },
	[0x23D2] = { unicodeslot=0x23D2, category='so', description='METRICAL LONG OVER SHORT' },
	[0x23D3] = { unicodeslot=0x23D3, category='so', description='METRICAL SHORT OVER LONG' },
	[0x23D4] = { unicodeslot=0x23D4, category='so', description='METRICAL LONG OVER TWO SHORTS' },
	[0x23D5] = { unicodeslot=0x23D5, category='so', description='METRICAL TWO SHORTS OVER LONG' },
	[0x23D6] = { unicodeslot=0x23D6, category='so', description='METRICAL TWO SHORTS JOINED' },
	[0x23D7] = { unicodeslot=0x23D7, category='so', description='METRICAL TRISEME' },
	[0x23D8] = { unicodeslot=0x23D8, category='so', description='METRICAL TETRASEME' },
	[0x23D9] = { unicodeslot=0x23D9, category='so', description='METRICAL PENTASEME' },
	[0x23DA] = { unicodeslot=0x23DA, category='so', description='EARTH GROUND' },
	[0x23DB] = { unicodeslot=0x23DB, category='so', description='FUSE' },
	[0x23DC] = { unicodeslot=0x23DC, category='sm', description='TOP PARENTHESIS' },
	[0x23DD] = { unicodeslot=0x23DD, category='sm', description='BOTTOM PARENTHESIS' },
	[0x23DE] = { unicodeslot=0x23DE, category='sm', description='TOP CURLY BRACKET' },
	[0x23DF] = { unicodeslot=0x23DF, category='sm', description='BOTTOM CURLY BRACKET' },
	[0x23E0] = { unicodeslot=0x23E0, category='sm', description='TOP TORTOISE SHELL BRACKET' },
	[0x23E1] = { unicodeslot=0x23E1, category='sm', description='BOTTOM TORTOISE SHELL BRACKET' },
	[0x23E2] = { unicodeslot=0x23E2, category='so', description='WHITE TRAPEZIUM' },
	[0x23E3] = { unicodeslot=0x23E3, category='so', description='BENZENE RING WITH CIRCLE' },
	[0x23E4] = { unicodeslot=0x23E4, category='so', description='STRAIGHTNESS' },
	[0x23E5] = { unicodeslot=0x23E5, category='so', description='FLATNESS' },
	[0x23E6] = { unicodeslot=0x23E6, category='so', description='AC CURRENT' },
	[0x23E7] = { unicodeslot=0x23E7, category='so', description='ELECTRICAL INTERSECTION' },
	[0x2400] = { unicodeslot=0x2400, category='so', description='SYMBOL FOR NULL' },
	[0x2401] = { unicodeslot=0x2401, category='so', description='SYMBOL FOR START OF HEADING' },
	[0x2402] = { unicodeslot=0x2402, category='so', description='SYMBOL FOR START OF TEXT' },
	[0x2403] = { unicodeslot=0x2403, category='so', description='SYMBOL FOR END OF TEXT' },
	[0x2404] = { unicodeslot=0x2404, category='so', description='SYMBOL FOR END OF TRANSMISSION' },
	[0x2405] = { unicodeslot=0x2405, category='so', description='SYMBOL FOR ENQUIRY' },
	[0x2406] = { unicodeslot=0x2406, category='so', description='SYMBOL FOR ACKNOWLEDGE' },
	[0x2407] = { unicodeslot=0x2407, category='so', description='SYMBOL FOR BELL' },
	[0x2408] = { unicodeslot=0x2408, category='so', description='SYMBOL FOR BACKSPACE' },
	[0x2409] = { unicodeslot=0x2409, category='so', description='SYMBOL FOR HORIZONTAL TABULATION' },
	[0x240A] = { unicodeslot=0x240A, category='so', description='SYMBOL FOR LINE FEED' },
	[0x240B] = { unicodeslot=0x240B, category='so', description='SYMBOL FOR VERTICAL TABULATION' },
	[0x240C] = { unicodeslot=0x240C, category='so', description='SYMBOL FOR FORM FEED' },
	[0x240D] = { unicodeslot=0x240D, category='so', description='SYMBOL FOR CARRIAGE RETURN' },
	[0x240E] = { unicodeslot=0x240E, category='so', description='SYMBOL FOR SHIFT OUT' },
	[0x240F] = { unicodeslot=0x240F, category='so', description='SYMBOL FOR SHIFT IN' },
	[0x2410] = { unicodeslot=0x2410, category='so', description='SYMBOL FOR DATA LINK ESCAPE' },
	[0x2411] = { unicodeslot=0x2411, category='so', description='SYMBOL FOR DEVICE CONTROL ONE' },
	[0x2412] = { unicodeslot=0x2412, category='so', description='SYMBOL FOR DEVICE CONTROL TWO' },
	[0x2413] = { unicodeslot=0x2413, category='so', description='SYMBOL FOR DEVICE CONTROL THREE' },
	[0x2414] = { unicodeslot=0x2414, category='so', description='SYMBOL FOR DEVICE CONTROL FOUR' },
	[0x2415] = { unicodeslot=0x2415, category='so', description='SYMBOL FOR NEGATIVE ACKNOWLEDGE' },
	[0x2416] = { unicodeslot=0x2416, category='so', description='SYMBOL FOR SYNCHRONOUS IDLE' },
	[0x2417] = { unicodeslot=0x2417, category='so', description='SYMBOL FOR END OF TRANSMISSION BLOCK' },
	[0x2418] = { unicodeslot=0x2418, category='so', description='SYMBOL FOR CANCEL' },
	[0x2419] = { unicodeslot=0x2419, category='so', description='SYMBOL FOR END OF MEDIUM' },
	[0x241A] = { unicodeslot=0x241A, category='so', description='SYMBOL FOR SUBSTITUTE' },
	[0x241B] = { unicodeslot=0x241B, category='so', description='SYMBOL FOR ESCAPE' },
	[0x241C] = { unicodeslot=0x241C, category='so', description='SYMBOL FOR FILE SEPARATOR' },
	[0x241D] = { unicodeslot=0x241D, category='so', description='SYMBOL FOR GROUP SEPARATOR' },
	[0x241E] = { unicodeslot=0x241E, category='so', description='SYMBOL FOR RECORD SEPARATOR' },
	[0x241F] = { unicodeslot=0x241F, category='so', description='SYMBOL FOR UNIT SEPARATOR' },
	[0x2420] = { unicodeslot=0x2420, category='so', description='SYMBOL FOR SPACE' },
	[0x2421] = { unicodeslot=0x2421, category='so', description='SYMBOL FOR DELETE' },
	[0x2422] = { unicodeslot=0x2422, category='so', description='BLANK SYMBOL' },
	[0x2423] = { unicodeslot=0x2423, category='so', description='OPEN BOX' },
	[0x2424] = { unicodeslot=0x2424, category='so', description='SYMBOL FOR NEWLINE' },
	[0x2425] = { unicodeslot=0x2425, category='so', description='SYMBOL FOR DELETE FORM TWO' },
	[0x2426] = { unicodeslot=0x2426, category='so', description='SYMBOL FOR SUBSTITUTE FORM TWO' },
	[0x2440] = { unicodeslot=0x2440, category='so', description='OCR HOOK' },
	[0x2441] = { unicodeslot=0x2441, category='so', description='OCR CHAIR' },
	[0x2442] = { unicodeslot=0x2442, category='so', description='OCR FORK' },
	[0x2443] = { unicodeslot=0x2443, category='so', description='OCR INVERTED FORK' },
	[0x2444] = { unicodeslot=0x2444, category='so', description='OCR BELT BUCKLE' },
	[0x2445] = { unicodeslot=0x2445, category='so', description='OCR BOW TIE' },
	[0x2446] = { unicodeslot=0x2446, category='so', description='OCR BRANCH BANK IDENTIFICATION' },
	[0x2447] = { unicodeslot=0x2447, category='so', description='OCR AMOUNT OF CHECK' },
	[0x2448] = { unicodeslot=0x2448, category='so', description='OCR DASH' },
	[0x2449] = { unicodeslot=0x2449, category='so', description='OCR CUSTOMER ACCOUNT NUMBER' },
	[0x244A] = { unicodeslot=0x244A, category='so', description='OCR DOUBLE BACKSLASH' },
	[0x2460] = { unicodeslot=0x2460, category='no', description='CIRCLED DIGIT ONE', specials={'circle',0x0031} },
	[0x2461] = { unicodeslot=0x2461, category='no', description='CIRCLED DIGIT TWO', specials={'circle',0x0032} },
	[0x2462] = { unicodeslot=0x2462, category='no', description='CIRCLED DIGIT THREE', specials={'circle',0x0033} },
	[0x2463] = { unicodeslot=0x2463, category='no', description='CIRCLED DIGIT FOUR', specials={'circle',0x0034} },
	[0x2464] = { unicodeslot=0x2464, category='no', description='CIRCLED DIGIT FIVE', specials={'circle',0x0035} },
	[0x2465] = { unicodeslot=0x2465, category='no', description='CIRCLED DIGIT SIX', specials={'circle',0x0036} },
	[0x2466] = { unicodeslot=0x2466, category='no', description='CIRCLED DIGIT SEVEN', specials={'circle',0x0037} },
	[0x2467] = { unicodeslot=0x2467, category='no', description='CIRCLED DIGIT EIGHT', specials={'circle',0x0038} },
	[0x2468] = { unicodeslot=0x2468, category='no', description='CIRCLED DIGIT NINE', specials={'circle',0x0039} },
	[0x2469] = { unicodeslot=0x2469, category='no', description='CIRCLED NUMBER TEN', specials={'circle',0x0031,0x0030} },
	[0x246A] = { unicodeslot=0x246A, category='no', description='CIRCLED NUMBER ELEVEN', specials={'circle',0x0031,0x0031} },
	[0x246B] = { unicodeslot=0x246B, category='no', description='CIRCLED NUMBER TWELVE', specials={'circle',0x0031,0x0032} },
	[0x246C] = { unicodeslot=0x246C, category='no', description='CIRCLED NUMBER THIRTEEN', specials={'circle',0x0031,0x0033} },
	[0x246D] = { unicodeslot=0x246D, category='no', description='CIRCLED NUMBER FOURTEEN', specials={'circle',0x0031,0x0034} },
	[0x246E] = { unicodeslot=0x246E, category='no', description='CIRCLED NUMBER FIFTEEN', specials={'circle',0x0031,0x0035} },
	[0x246F] = { unicodeslot=0x246F, category='no', description='CIRCLED NUMBER SIXTEEN', specials={'circle',0x0031,0x0036} },
	[0x2470] = { unicodeslot=0x2470, category='no', description='CIRCLED NUMBER SEVENTEEN', specials={'circle',0x0031,0x0037} },
	[0x2471] = { unicodeslot=0x2471, category='no', description='CIRCLED NUMBER EIGHTEEN', specials={'circle',0x0031,0x0038} },
	[0x2472] = { unicodeslot=0x2472, category='no', description='CIRCLED NUMBER NINETEEN', specials={'circle',0x0031,0x0039} },
	[0x2473] = { unicodeslot=0x2473, category='no', description='CIRCLED NUMBER TWENTY', specials={'circle',0x0032,0x0030} },
	[0x2474] = { unicodeslot=0x2474, category='no', description='PARENTHESIZED DIGIT ONE', specials={'compat',0x0028,0x0031,0x0029} },
	[0x2475] = { unicodeslot=0x2475, category='no', description='PARENTHESIZED DIGIT TWO', specials={'compat',0x0028,0x0032,0x0029} },
	[0x2476] = { unicodeslot=0x2476, category='no', description='PARENTHESIZED DIGIT THREE', specials={'compat',0x0028,0x0033,0x0029} },
	[0x2477] = { unicodeslot=0x2477, category='no', description='PARENTHESIZED DIGIT FOUR', specials={'compat',0x0028,0x0034,0x0029} },
	[0x2478] = { unicodeslot=0x2478, category='no', description='PARENTHESIZED DIGIT FIVE', specials={'compat',0x0028,0x0035,0x0029} },
	[0x2479] = { unicodeslot=0x2479, category='no', description='PARENTHESIZED DIGIT SIX', specials={'compat',0x0028,0x0036,0x0029} },
	[0x247A] = { unicodeslot=0x247A, category='no', description='PARENTHESIZED DIGIT SEVEN', specials={'compat',0x0028,0x0037,0x0029} },
	[0x247B] = { unicodeslot=0x247B, category='no', description='PARENTHESIZED DIGIT EIGHT', specials={'compat',0x0028,0x0038,0x0029} },
	[0x247C] = { unicodeslot=0x247C, category='no', description='PARENTHESIZED DIGIT NINE', specials={'compat',0x0028,0x0039,0x0029} },
	[0x247D] = { unicodeslot=0x247D, category='no', description='PARENTHESIZED NUMBER TEN', specials={'compat',0x0028,0x0031,0x0030,0x0029} },
	[0x247E] = { unicodeslot=0x247E, category='no', description='PARENTHESIZED NUMBER ELEVEN', specials={'compat',0x0028,0x0031,0x0031,0x0029} },
	[0x247F] = { unicodeslot=0x247F, category='no', description='PARENTHESIZED NUMBER TWELVE', specials={'compat',0x0028,0x0031,0x0032,0x0029} },
	[0x2480] = { unicodeslot=0x2480, category='no', description='PARENTHESIZED NUMBER THIRTEEN', specials={'compat',0x0028,0x0031,0x0033,0x0029} },
	[0x2481] = { unicodeslot=0x2481, category='no', description='PARENTHESIZED NUMBER FOURTEEN', specials={'compat',0x0028,0x0031,0x0034,0x0029} },
	[0x2482] = { unicodeslot=0x2482, category='no', description='PARENTHESIZED NUMBER FIFTEEN', specials={'compat',0x0028,0x0031,0x0035,0x0029} },
	[0x2483] = { unicodeslot=0x2483, category='no', description='PARENTHESIZED NUMBER SIXTEEN', specials={'compat',0x0028,0x0031,0x0036,0x0029} },
	[0x2484] = { unicodeslot=0x2484, category='no', description='PARENTHESIZED NUMBER SEVENTEEN', specials={'compat',0x0028,0x0031,0x0037,0x0029} },
	[0x2485] = { unicodeslot=0x2485, category='no', description='PARENTHESIZED NUMBER EIGHTEEN', specials={'compat',0x0028,0x0031,0x0038,0x0029} },
	[0x2486] = { unicodeslot=0x2486, category='no', description='PARENTHESIZED NUMBER NINETEEN', specials={'compat',0x0028,0x0031,0x0039,0x0029} },
	[0x2487] = { unicodeslot=0x2487, category='no', description='PARENTHESIZED NUMBER TWENTY', specials={'compat',0x0028,0x0032,0x0030,0x0029} },
	[0x2488] = { unicodeslot=0x2488, category='no', description='DIGIT ONE FULL STOP', specials={'compat',0x0031,0x002E} },
	[0x2489] = { unicodeslot=0x2489, category='no', description='DIGIT TWO FULL STOP', specials={'compat',0x0032,0x002E} },
	[0x248A] = { unicodeslot=0x248A, category='no', description='DIGIT THREE FULL STOP', specials={'compat',0x0033,0x002E} },
	[0x248B] = { unicodeslot=0x248B, category='no', description='DIGIT FOUR FULL STOP', specials={'compat',0x0034,0x002E} },
	[0x248C] = { unicodeslot=0x248C, category='no', description='DIGIT FIVE FULL STOP', specials={'compat',0x0035,0x002E} },
	[0x248D] = { unicodeslot=0x248D, category='no', description='DIGIT SIX FULL STOP', specials={'compat',0x0036,0x002E} },
	[0x248E] = { unicodeslot=0x248E, category='no', description='DIGIT SEVEN FULL STOP', specials={'compat',0x0037,0x002E} },
	[0x248F] = { unicodeslot=0x248F, category='no', description='DIGIT EIGHT FULL STOP', specials={'compat',0x0038,0x002E} },
	[0x2490] = { unicodeslot=0x2490, category='no', description='DIGIT NINE FULL STOP', specials={'compat',0x0039,0x002E} },
	[0x2491] = { unicodeslot=0x2491, category='no', description='NUMBER TEN FULL STOP', specials={'compat',0x0031,0x0030,0x002E} },
	[0x2492] = { unicodeslot=0x2492, category='no', description='NUMBER ELEVEN FULL STOP', specials={'compat',0x0031,0x0031,0x002E} },
	[0x2493] = { unicodeslot=0x2493, category='no', description='NUMBER TWELVE FULL STOP', specials={'compat',0x0031,0x0032,0x002E} },
	[0x2494] = { unicodeslot=0x2494, category='no', description='NUMBER THIRTEEN FULL STOP', specials={'compat',0x0031,0x0033,0x002E} },
	[0x2495] = { unicodeslot=0x2495, category='no', description='NUMBER FOURTEEN FULL STOP', specials={'compat',0x0031,0x0034,0x002E} },
	[0x2496] = { unicodeslot=0x2496, category='no', description='NUMBER FIFTEEN FULL STOP', specials={'compat',0x0031,0x0035,0x002E} },
	[0x2497] = { unicodeslot=0x2497, category='no', description='NUMBER SIXTEEN FULL STOP', specials={'compat',0x0031,0x0036,0x002E} },
	[0x2498] = { unicodeslot=0x2498, category='no', description='NUMBER SEVENTEEN FULL STOP', specials={'compat',0x0031,0x0037,0x002E} },
	[0x2499] = { unicodeslot=0x2499, category='no', description='NUMBER EIGHTEEN FULL STOP', specials={'compat',0x0031,0x0038,0x002E} },
	[0x249A] = { unicodeslot=0x249A, category='no', description='NUMBER NINETEEN FULL STOP', specials={'compat',0x0031,0x0039,0x002E} },
	[0x249B] = { unicodeslot=0x249B, category='no', description='NUMBER TWENTY FULL STOP', specials={'compat',0x0032,0x0030,0x002E} },
	[0x249C] = { unicodeslot=0x249C, category='so', description='PARENTHESIZED LATIN SMALL LETTER A', specials={'compat',0x0028,0x0061,0x0029} },
	[0x249D] = { unicodeslot=0x249D, category='so', description='PARENTHESIZED LATIN SMALL LETTER B', specials={'compat',0x0028,0x0062,0x0029} },
	[0x249E] = { unicodeslot=0x249E, category='so', description='PARENTHESIZED LATIN SMALL LETTER C', specials={'compat',0x0028,0x0063,0x0029} },
	[0x249F] = { unicodeslot=0x249F, category='so', description='PARENTHESIZED LATIN SMALL LETTER D', specials={'compat',0x0028,0x0064,0x0029} },
	[0x24A0] = { unicodeslot=0x24A0, category='so', description='PARENTHESIZED LATIN SMALL LETTER E', specials={'compat',0x0028,0x0065,0x0029} },
	[0x24A1] = { unicodeslot=0x24A1, category='so', description='PARENTHESIZED LATIN SMALL LETTER F', specials={'compat',0x0028,0x0066,0x0029} },
	[0x24A2] = { unicodeslot=0x24A2, category='so', description='PARENTHESIZED LATIN SMALL LETTER G', specials={'compat',0x0028,0x0067,0x0029} },
	[0x24A3] = { unicodeslot=0x24A3, category='so', description='PARENTHESIZED LATIN SMALL LETTER H', specials={'compat',0x0028,0x0068,0x0029} },
	[0x24A4] = { unicodeslot=0x24A4, category='so', description='PARENTHESIZED LATIN SMALL LETTER I', specials={'compat',0x0028,0x0069,0x0029} },
	[0x24A5] = { unicodeslot=0x24A5, category='so', description='PARENTHESIZED LATIN SMALL LETTER J', specials={'compat',0x0028,0x006A,0x0029} },
	[0x24A6] = { unicodeslot=0x24A6, category='so', description='PARENTHESIZED LATIN SMALL LETTER K', specials={'compat',0x0028,0x006B,0x0029} },
	[0x24A7] = { unicodeslot=0x24A7, category='so', description='PARENTHESIZED LATIN SMALL LETTER L', specials={'compat',0x0028,0x006C,0x0029} },
	[0x24A8] = { unicodeslot=0x24A8, category='so', description='PARENTHESIZED LATIN SMALL LETTER M', specials={'compat',0x0028,0x006D,0x0029} },
	[0x24A9] = { unicodeslot=0x24A9, category='so', description='PARENTHESIZED LATIN SMALL LETTER N', specials={'compat',0x0028,0x006E,0x0029} },
	[0x24AA] = { unicodeslot=0x24AA, category='so', description='PARENTHESIZED LATIN SMALL LETTER O', specials={'compat',0x0028,0x006F,0x0029} },
	[0x24AB] = { unicodeslot=0x24AB, category='so', description='PARENTHESIZED LATIN SMALL LETTER P', specials={'compat',0x0028,0x0070,0x0029} },
	[0x24AC] = { unicodeslot=0x24AC, category='so', description='PARENTHESIZED LATIN SMALL LETTER Q', specials={'compat',0x0028,0x0071,0x0029} },
	[0x24AD] = { unicodeslot=0x24AD, category='so', description='PARENTHESIZED LATIN SMALL LETTER R', specials={'compat',0x0028,0x0072,0x0029} },
	[0x24AE] = { unicodeslot=0x24AE, category='so', description='PARENTHESIZED LATIN SMALL LETTER S', specials={'compat',0x0028,0x0073,0x0029} },
	[0x24AF] = { unicodeslot=0x24AF, category='so', description='PARENTHESIZED LATIN SMALL LETTER T', specials={'compat',0x0028,0x0074,0x0029} },
	[0x24B0] = { unicodeslot=0x24B0, category='so', description='PARENTHESIZED LATIN SMALL LETTER U', specials={'compat',0x0028,0x0075,0x0029} },
	[0x24B1] = { unicodeslot=0x24B1, category='so', description='PARENTHESIZED LATIN SMALL LETTER V', specials={'compat',0x0028,0x0076,0x0029} },
	[0x24B2] = { unicodeslot=0x24B2, category='so', description='PARENTHESIZED LATIN SMALL LETTER W', specials={'compat',0x0028,0x0077,0x0029} },
	[0x24B3] = { unicodeslot=0x24B3, category='so', description='PARENTHESIZED LATIN SMALL LETTER X', specials={'compat',0x0028,0x0078,0x0029} },
	[0x24B4] = { unicodeslot=0x24B4, category='so', description='PARENTHESIZED LATIN SMALL LETTER Y', specials={'compat',0x0028,0x0079,0x0029} },
	[0x24B5] = { unicodeslot=0x24B5, category='so', description='PARENTHESIZED LATIN SMALL LETTER Z', specials={'compat',0x0028,0x007A,0x0029} },
	[0x24B6] = { unicodeslot=0x24B6, category='so', description='CIRCLED LATIN CAPITAL LETTER A', lccode=0x24D0, specials={'circle',0x0041} },
	[0x24B7] = { unicodeslot=0x24B7, category='so', description='CIRCLED LATIN CAPITAL LETTER B', lccode=0x24D1, specials={'circle',0x0042} },
	[0x24B8] = { unicodeslot=0x24B8, category='so', description='CIRCLED LATIN CAPITAL LETTER C', lccode=0x24D2, specials={'circle',0x0043} },
	[0x24B9] = { unicodeslot=0x24B9, category='so', description='CIRCLED LATIN CAPITAL LETTER D', lccode=0x24D3, specials={'circle',0x0044} },
	[0x24BA] = { unicodeslot=0x24BA, category='so', description='CIRCLED LATIN CAPITAL LETTER E', lccode=0x24D4, specials={'circle',0x0045} },
	[0x24BB] = { unicodeslot=0x24BB, category='so', description='CIRCLED LATIN CAPITAL LETTER F', lccode=0x24D5, specials={'circle',0x0046} },
	[0x24BC] = { unicodeslot=0x24BC, category='so', description='CIRCLED LATIN CAPITAL LETTER G', lccode=0x24D6, specials={'circle',0x0047} },
	[0x24BD] = { unicodeslot=0x24BD, category='so', description='CIRCLED LATIN CAPITAL LETTER H', lccode=0x24D7, specials={'circle',0x0048} },
	[0x24BE] = { unicodeslot=0x24BE, category='so', description='CIRCLED LATIN CAPITAL LETTER I', lccode=0x24D8, specials={'circle',0x0049} },
	[0x24BF] = { unicodeslot=0x24BF, category='so', description='CIRCLED LATIN CAPITAL LETTER J', lccode=0x24D9, specials={'circle',0x004A} },
	[0x24C0] = { unicodeslot=0x24C0, category='so', description='CIRCLED LATIN CAPITAL LETTER K', lccode=0x24DA, specials={'circle',0x004B} },
	[0x24C1] = { unicodeslot=0x24C1, category='so', description='CIRCLED LATIN CAPITAL LETTER L', lccode=0x24DB, specials={'circle',0x004C} },
	[0x24C2] = { unicodeslot=0x24C2, category='so', description='CIRCLED LATIN CAPITAL LETTER M', lccode=0x24DC, specials={'circle',0x004D} },
	[0x24C3] = { unicodeslot=0x24C3, category='so', description='CIRCLED LATIN CAPITAL LETTER N', lccode=0x24DD, specials={'circle',0x004E} },
	[0x24C4] = { unicodeslot=0x24C4, category='so', description='CIRCLED LATIN CAPITAL LETTER O', lccode=0x24DE, specials={'circle',0x004F} },
	[0x24C5] = { unicodeslot=0x24C5, category='so', description='CIRCLED LATIN CAPITAL LETTER P', lccode=0x24DF, specials={'circle',0x0050} },
	[0x24C6] = { unicodeslot=0x24C6, category='so', description='CIRCLED LATIN CAPITAL LETTER Q', lccode=0x24E0, specials={'circle',0x0051} },
	[0x24C7] = { unicodeslot=0x24C7, category='so', description='CIRCLED LATIN CAPITAL LETTER R', lccode=0x24E1, specials={'circle',0x0052} },
	[0x24C8] = { unicodeslot=0x24C8, category='so', description='CIRCLED LATIN CAPITAL LETTER S', lccode=0x24E2, specials={'circle',0x0053} },
	[0x24C9] = { unicodeslot=0x24C9, category='so', description='CIRCLED LATIN CAPITAL LETTER T', lccode=0x24E3, specials={'circle',0x0054} },
	[0x24CA] = { unicodeslot=0x24CA, category='so', description='CIRCLED LATIN CAPITAL LETTER U', lccode=0x24E4, specials={'circle',0x0055} },
	[0x24CB] = { unicodeslot=0x24CB, category='so', description='CIRCLED LATIN CAPITAL LETTER V', lccode=0x24E5, specials={'circle',0x0056} },
	[0x24CC] = { unicodeslot=0x24CC, category='so', description='CIRCLED LATIN CAPITAL LETTER W', lccode=0x24E6, specials={'circle',0x0057} },
	[0x24CD] = { unicodeslot=0x24CD, category='so', description='CIRCLED LATIN CAPITAL LETTER X', lccode=0x24E7, specials={'circle',0x0058} },
	[0x24CE] = { unicodeslot=0x24CE, category='so', description='CIRCLED LATIN CAPITAL LETTER Y', lccode=0x24E8, specials={'circle',0x0059} },
	[0x24CF] = { unicodeslot=0x24CF, category='so', description='CIRCLED LATIN CAPITAL LETTER Z', lccode=0x24E9, specials={'circle',0x005A} },
	[0x24D0] = { unicodeslot=0x24D0, category='so', description='CIRCLED LATIN SMALL LETTER A', uccode=0x24B6, specials={'circle',0x0061} },
	[0x24D1] = { unicodeslot=0x24D1, category='so', description='CIRCLED LATIN SMALL LETTER B', uccode=0x24B7, specials={'circle',0x0062} },
	[0x24D2] = { unicodeslot=0x24D2, category='so', description='CIRCLED LATIN SMALL LETTER C', uccode=0x24B8, specials={'circle',0x0063} },
	[0x24D3] = { unicodeslot=0x24D3, category='so', description='CIRCLED LATIN SMALL LETTER D', uccode=0x24B9, specials={'circle',0x0064} },
	[0x24D4] = { unicodeslot=0x24D4, category='so', description='CIRCLED LATIN SMALL LETTER E', uccode=0x24BA, specials={'circle',0x0065} },
	[0x24D5] = { unicodeslot=0x24D5, category='so', description='CIRCLED LATIN SMALL LETTER F', uccode=0x24BB, specials={'circle',0x0066} },
	[0x24D6] = { unicodeslot=0x24D6, category='so', description='CIRCLED LATIN SMALL LETTER G', uccode=0x24BC, specials={'circle',0x0067} },
	[0x24D7] = { unicodeslot=0x24D7, category='so', description='CIRCLED LATIN SMALL LETTER H', uccode=0x24BD, specials={'circle',0x0068} },
	[0x24D8] = { unicodeslot=0x24D8, category='so', description='CIRCLED LATIN SMALL LETTER I', uccode=0x24BE, specials={'circle',0x0069} },
	[0x24D9] = { unicodeslot=0x24D9, category='so', description='CIRCLED LATIN SMALL LETTER J', uccode=0x24BF, specials={'circle',0x006A} },
	[0x24DA] = { unicodeslot=0x24DA, category='so', description='CIRCLED LATIN SMALL LETTER K', uccode=0x24C0, specials={'circle',0x006B} },
	[0x24DB] = { unicodeslot=0x24DB, category='so', description='CIRCLED LATIN SMALL LETTER L', uccode=0x24C1, specials={'circle',0x006C} },
	[0x24DC] = { unicodeslot=0x24DC, category='so', description='CIRCLED LATIN SMALL LETTER M', uccode=0x24C2, specials={'circle',0x006D} },
	[0x24DD] = { unicodeslot=0x24DD, category='so', description='CIRCLED LATIN SMALL LETTER N', uccode=0x24C3, specials={'circle',0x006E} },
	[0x24DE] = { unicodeslot=0x24DE, category='so', description='CIRCLED LATIN SMALL LETTER O', uccode=0x24C4, specials={'circle',0x006F} },
	[0x24DF] = { unicodeslot=0x24DF, category='so', description='CIRCLED LATIN SMALL LETTER P', uccode=0x24C5, specials={'circle',0x0070} },
	[0x24E0] = { unicodeslot=0x24E0, category='so', description='CIRCLED LATIN SMALL LETTER Q', uccode=0x24C6, specials={'circle',0x0071} },
	[0x24E1] = { unicodeslot=0x24E1, category='so', description='CIRCLED LATIN SMALL LETTER R', uccode=0x24C7, specials={'circle',0x0072} },
	[0x24E2] = { unicodeslot=0x24E2, category='so', description='CIRCLED LATIN SMALL LETTER S', uccode=0x24C8, specials={'circle',0x0073} },
	[0x24E3] = { unicodeslot=0x24E3, category='so', description='CIRCLED LATIN SMALL LETTER T', uccode=0x24C9, specials={'circle',0x0074} },
	[0x24E4] = { unicodeslot=0x24E4, category='so', description='CIRCLED LATIN SMALL LETTER U', uccode=0x24CA, specials={'circle',0x0075} },
	[0x24E5] = { unicodeslot=0x24E5, category='so', description='CIRCLED LATIN SMALL LETTER V', uccode=0x24CB, specials={'circle',0x0076} },
	[0x24E6] = { unicodeslot=0x24E6, category='so', description='CIRCLED LATIN SMALL LETTER W', uccode=0x24CC, specials={'circle',0x0077} },
	[0x24E7] = { unicodeslot=0x24E7, category='so', description='CIRCLED LATIN SMALL LETTER X', uccode=0x24CD, specials={'circle',0x0078} },
	[0x24E8] = { unicodeslot=0x24E8, category='so', description='CIRCLED LATIN SMALL LETTER Y', uccode=0x24CE, specials={'circle',0x0079} },
	[0x24E9] = { unicodeslot=0x24E9, category='so', description='CIRCLED LATIN SMALL LETTER Z', uccode=0x24CF, specials={'circle',0x007A} },
	[0x24EA] = { unicodeslot=0x24EA, category='no', description='CIRCLED DIGIT ZERO', specials={'circle',0x0030} },
	[0x24EB] = { unicodeslot=0x24EB, category='no', description='NEGATIVE CIRCLED NUMBER ELEVEN' },
	[0x24EC] = { unicodeslot=0x24EC, category='no', description='NEGATIVE CIRCLED NUMBER TWELVE' },
	[0x24ED] = { unicodeslot=0x24ED, category='no', description='NEGATIVE CIRCLED NUMBER THIRTEEN' },
	[0x24EE] = { unicodeslot=0x24EE, category='no', description='NEGATIVE CIRCLED NUMBER FOURTEEN' },
	[0x24EF] = { unicodeslot=0x24EF, category='no', description='NEGATIVE CIRCLED NUMBER FIFTEEN' },
	[0x24F0] = { unicodeslot=0x24F0, category='no', description='NEGATIVE CIRCLED NUMBER SIXTEEN' },
	[0x24F1] = { unicodeslot=0x24F1, category='no', description='NEGATIVE CIRCLED NUMBER SEVENTEEN' },
	[0x24F2] = { unicodeslot=0x24F2, category='no', description='NEGATIVE CIRCLED NUMBER EIGHTEEN' },
	[0x24F3] = { unicodeslot=0x24F3, category='no', description='NEGATIVE CIRCLED NUMBER NINETEEN' },
	[0x24F4] = { unicodeslot=0x24F4, category='no', description='NEGATIVE CIRCLED NUMBER TWENTY' },
	[0x24F5] = { unicodeslot=0x24F5, category='no', description='DOUBLE CIRCLED DIGIT ONE' },
	[0x24F6] = { unicodeslot=0x24F6, category='no', description='DOUBLE CIRCLED DIGIT TWO' },
	[0x24F7] = { unicodeslot=0x24F7, category='no', description='DOUBLE CIRCLED DIGIT THREE' },
	[0x24F8] = { unicodeslot=0x24F8, category='no', description='DOUBLE CIRCLED DIGIT FOUR' },
	[0x24F9] = { unicodeslot=0x24F9, category='no', description='DOUBLE CIRCLED DIGIT FIVE' },
	[0x24FA] = { unicodeslot=0x24FA, category='no', description='DOUBLE CIRCLED DIGIT SIX' },
	[0x24FB] = { unicodeslot=0x24FB, category='no', description='DOUBLE CIRCLED DIGIT SEVEN' },
	[0x24FC] = { unicodeslot=0x24FC, category='no', description='DOUBLE CIRCLED DIGIT EIGHT' },
	[0x24FD] = { unicodeslot=0x24FD, category='no', description='DOUBLE CIRCLED DIGIT NINE' },
	[0x24FE] = { unicodeslot=0x24FE, category='no', description='DOUBLE CIRCLED NUMBER TEN' },
	[0x24FF] = { unicodeslot=0x24FF, category='no', description='NEGATIVE CIRCLED DIGIT ZERO' },
	[0x2500] = { unicodeslot=0x2500, category='so', adobename='SF100000', description='BOX DRAWINGS LIGHT HORIZONTAL' },
	[0x2501] = { unicodeslot=0x2501, category='so', description='BOX DRAWINGS HEAVY HORIZONTAL' },
	[0x2502] = { unicodeslot=0x2502, category='so', adobename='SF110000', description='BOX DRAWINGS LIGHT VERTICAL' },
	[0x2503] = { unicodeslot=0x2503, category='so', description='BOX DRAWINGS HEAVY VERTICAL' },
	[0x2504] = { unicodeslot=0x2504, category='so', description='BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL' },
	[0x2505] = { unicodeslot=0x2505, category='so', description='BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL' },
	[0x2506] = { unicodeslot=0x2506, category='so', description='BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL' },
	[0x2507] = { unicodeslot=0x2507, category='so', description='BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL' },
	[0x2508] = { unicodeslot=0x2508, category='so', description='BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL' },
	[0x2509] = { unicodeslot=0x2509, category='so', description='BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL' },
	[0x250A] = { unicodeslot=0x250A, category='so', description='BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL' },
	[0x250B] = { unicodeslot=0x250B, category='so', description='BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL' },
	[0x250C] = { unicodeslot=0x250C, category='so', adobename='SF010000', description='BOX DRAWINGS LIGHT DOWN AND RIGHT' },
	[0x250D] = { unicodeslot=0x250D, category='so', description='BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY' },
	[0x250E] = { unicodeslot=0x250E, category='so', description='BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT' },
	[0x250F] = { unicodeslot=0x250F, category='so', description='BOX DRAWINGS HEAVY DOWN AND RIGHT' },
	[0x2510] = { unicodeslot=0x2510, category='so', adobename='SF030000', description='BOX DRAWINGS LIGHT DOWN AND LEFT' },
	[0x2511] = { unicodeslot=0x2511, category='so', description='BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY' },
	[0x2512] = { unicodeslot=0x2512, category='so', description='BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT' },
	[0x2513] = { unicodeslot=0x2513, category='so', description='BOX DRAWINGS HEAVY DOWN AND LEFT' },
	[0x2514] = { unicodeslot=0x2514, category='so', adobename='SF020000', description='BOX DRAWINGS LIGHT UP AND RIGHT' },
	[0x2515] = { unicodeslot=0x2515, category='so', description='BOX DRAWINGS UP LIGHT AND RIGHT HEAVY' },
	[0x2516] = { unicodeslot=0x2516, category='so', description='BOX DRAWINGS UP HEAVY AND RIGHT LIGHT' },
	[0x2517] = { unicodeslot=0x2517, category='so', description='BOX DRAWINGS HEAVY UP AND RIGHT' },
	[0x2518] = { unicodeslot=0x2518, category='so', adobename='SF040000', description='BOX DRAWINGS LIGHT UP AND LEFT' },
	[0x2519] = { unicodeslot=0x2519, category='so', description='BOX DRAWINGS UP LIGHT AND LEFT HEAVY' },
	[0x251A] = { unicodeslot=0x251A, category='so', description='BOX DRAWINGS UP HEAVY AND LEFT LIGHT' },
	[0x251B] = { unicodeslot=0x251B, category='so', description='BOX DRAWINGS HEAVY UP AND LEFT' },
	[0x251C] = { unicodeslot=0x251C, category='so', adobename='SF080000', description='BOX DRAWINGS LIGHT VERTICAL AND RIGHT' },
	[0x251D] = { unicodeslot=0x251D, category='so', description='BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY' },
	[0x251E] = { unicodeslot=0x251E, category='so', description='BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT' },
	[0x251F] = { unicodeslot=0x251F, category='so', description='BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT' },
	[0x2520] = { unicodeslot=0x2520, category='so', description='BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT' },
	[0x2521] = { unicodeslot=0x2521, category='so', description='BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY' },
	[0x2522] = { unicodeslot=0x2522, category='so', description='BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY' },
	[0x2523] = { unicodeslot=0x2523, category='so', description='BOX DRAWINGS HEAVY VERTICAL AND RIGHT' },
	[0x2524] = { unicodeslot=0x2524, category='so', adobename='SF090000', description='BOX DRAWINGS LIGHT VERTICAL AND LEFT' },
	[0x2525] = { unicodeslot=0x2525, category='so', description='BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY' },
	[0x2526] = { unicodeslot=0x2526, category='so', description='BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT' },
	[0x2527] = { unicodeslot=0x2527, category='so', description='BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT' },
	[0x2528] = { unicodeslot=0x2528, category='so', description='BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT' },
	[0x2529] = { unicodeslot=0x2529, category='so', description='BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY' },
	[0x252A] = { unicodeslot=0x252A, category='so', description='BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY' },
	[0x252B] = { unicodeslot=0x252B, category='so', description='BOX DRAWINGS HEAVY VERTICAL AND LEFT' },
	[0x252C] = { unicodeslot=0x252C, category='so', adobename='SF060000', description='BOX DRAWINGS LIGHT DOWN AND HORIZONTAL' },
	[0x252D] = { unicodeslot=0x252D, category='so', description='BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT' },
	[0x252E] = { unicodeslot=0x252E, category='so', description='BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT' },
	[0x252F] = { unicodeslot=0x252F, category='so', description='BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY' },
	[0x2530] = { unicodeslot=0x2530, category='so', description='BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT' },
	[0x2531] = { unicodeslot=0x2531, category='so', description='BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY' },
	[0x2532] = { unicodeslot=0x2532, category='so', description='BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY' },
	[0x2533] = { unicodeslot=0x2533, category='so', description='BOX DRAWINGS HEAVY DOWN AND HORIZONTAL' },
	[0x2534] = { unicodeslot=0x2534, category='so', adobename='SF070000', description='BOX DRAWINGS LIGHT UP AND HORIZONTAL' },
	[0x2535] = { unicodeslot=0x2535, category='so', description='BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT' },
	[0x2536] = { unicodeslot=0x2536, category='so', description='BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT' },
	[0x2537] = { unicodeslot=0x2537, category='so', description='BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY' },
	[0x2538] = { unicodeslot=0x2538, category='so', description='BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT' },
	[0x2539] = { unicodeslot=0x2539, category='so', description='BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY' },
	[0x253A] = { unicodeslot=0x253A, category='so', description='BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY' },
	[0x253B] = { unicodeslot=0x253B, category='so', description='BOX DRAWINGS HEAVY UP AND HORIZONTAL' },
	[0x253C] = { unicodeslot=0x253C, category='so', adobename='SF050000', description='BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL' },
	[0x253D] = { unicodeslot=0x253D, category='so', description='BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT' },
	[0x253E] = { unicodeslot=0x253E, category='so', description='BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT' },
	[0x253F] = { unicodeslot=0x253F, category='so', description='BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY' },
	[0x2540] = { unicodeslot=0x2540, category='so', description='BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT' },
	[0x2541] = { unicodeslot=0x2541, category='so', description='BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT' },
	[0x2542] = { unicodeslot=0x2542, category='so', description='BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT' },
	[0x2543] = { unicodeslot=0x2543, category='so', description='BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT' },
	[0x2544] = { unicodeslot=0x2544, category='so', description='BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT' },
	[0x2545] = { unicodeslot=0x2545, category='so', description='BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT' },
	[0x2546] = { unicodeslot=0x2546, category='so', description='BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT' },
	[0x2547] = { unicodeslot=0x2547, category='so', description='BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY' },
	[0x2548] = { unicodeslot=0x2548, category='so', description='BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY' },
	[0x2549] = { unicodeslot=0x2549, category='so', description='BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY' },
	[0x254A] = { unicodeslot=0x254A, category='so', description='BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY' },
	[0x254B] = { unicodeslot=0x254B, category='so', description='BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL' },
	[0x254C] = { unicodeslot=0x254C, category='so', description='BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL' },
	[0x254D] = { unicodeslot=0x254D, category='so', description='BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL' },
	[0x254E] = { unicodeslot=0x254E, category='so', description='BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL' },
	[0x254F] = { unicodeslot=0x254F, category='so', description='BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL' },
	[0x2550] = { unicodeslot=0x2550, category='so', adobename='SF430000', description='BOX DRAWINGS DOUBLE HORIZONTAL' },
	[0x2551] = { unicodeslot=0x2551, category='so', adobename='SF240000', description='BOX DRAWINGS DOUBLE VERTICAL' },
	[0x2552] = { unicodeslot=0x2552, category='so', adobename='SF510000', description='BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE' },
	[0x2553] = { unicodeslot=0x2553, category='so', adobename='SF520000', description='BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE' },
	[0x2554] = { unicodeslot=0x2554, category='so', adobename='SF390000', description='BOX DRAWINGS DOUBLE DOWN AND RIGHT' },
	[0x2555] = { unicodeslot=0x2555, category='so', adobename='SF220000', description='BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE' },
	[0x2556] = { unicodeslot=0x2556, category='so', adobename='SF210000', description='BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE' },
	[0x2557] = { unicodeslot=0x2557, category='so', adobename='SF250000', description='BOX DRAWINGS DOUBLE DOWN AND LEFT' },
	[0x2558] = { unicodeslot=0x2558, category='so', adobename='SF500000', description='BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE' },
	[0x2559] = { unicodeslot=0x2559, category='so', adobename='SF490000', description='BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE' },
	[0x255A] = { unicodeslot=0x255A, category='so', adobename='SF380000', description='BOX DRAWINGS DOUBLE UP AND RIGHT' },
	[0x255B] = { unicodeslot=0x255B, category='so', adobename='SF280000', description='BOX DRAWINGS UP SINGLE AND LEFT DOUBLE' },
	[0x255C] = { unicodeslot=0x255C, category='so', adobename='SF270000', description='BOX DRAWINGS UP DOUBLE AND LEFT SINGLE' },
	[0x255D] = { unicodeslot=0x255D, category='so', adobename='SF260000', description='BOX DRAWINGS DOUBLE UP AND LEFT' },
	[0x255E] = { unicodeslot=0x255E, category='so', adobename='SF360000', description='BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE' },
	[0x255F] = { unicodeslot=0x255F, category='so', adobename='SF370000', description='BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE' },
	[0x2560] = { unicodeslot=0x2560, category='so', adobename='SF420000', description='BOX DRAWINGS DOUBLE VERTICAL AND RIGHT' },
	[0x2561] = { unicodeslot=0x2561, category='so', adobename='SF190000', description='BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE' },
	[0x2562] = { unicodeslot=0x2562, category='so', adobename='SF200000', description='BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE' },
	[0x2563] = { unicodeslot=0x2563, category='so', adobename='SF230000', description='BOX DRAWINGS DOUBLE VERTICAL AND LEFT' },
	[0x2564] = { unicodeslot=0x2564, category='so', adobename='SF470000', description='BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE' },
	[0x2565] = { unicodeslot=0x2565, category='so', adobename='SF480000', description='BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE' },
	[0x2566] = { unicodeslot=0x2566, category='so', adobename='SF410000', description='BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL' },
	[0x2567] = { unicodeslot=0x2567, category='so', adobename='SF450000', description='BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE' },
	[0x2568] = { unicodeslot=0x2568, category='so', adobename='SF460000', description='BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE' },
	[0x2569] = { unicodeslot=0x2569, category='so', adobename='SF400000', description='BOX DRAWINGS DOUBLE UP AND HORIZONTAL' },
	[0x256A] = { unicodeslot=0x256A, category='so', adobename='SF540000', description='BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE' },
	[0x256B] = { unicodeslot=0x256B, category='so', adobename='SF530000', description='BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE' },
	[0x256C] = { unicodeslot=0x256C, category='so', adobename='SF440000', description='BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL' },
	[0x256D] = { unicodeslot=0x256D, category='so', description='BOX DRAWINGS LIGHT ARC DOWN AND RIGHT' },
	[0x256E] = { unicodeslot=0x256E, category='so', description='BOX DRAWINGS LIGHT ARC DOWN AND LEFT' },
	[0x256F] = { unicodeslot=0x256F, category='so', description='BOX DRAWINGS LIGHT ARC UP AND LEFT' },
	[0x2570] = { unicodeslot=0x2570, category='so', description='BOX DRAWINGS LIGHT ARC UP AND RIGHT' },
	[0x2571] = { unicodeslot=0x2571, category='so', description='BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT' },
	[0x2572] = { unicodeslot=0x2572, category='so', description='BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT' },
	[0x2573] = { unicodeslot=0x2573, category='so', description='BOX DRAWINGS LIGHT DIAGONAL CROSS' },
	[0x2574] = { unicodeslot=0x2574, category='so', description='BOX DRAWINGS LIGHT LEFT' },
	[0x2575] = { unicodeslot=0x2575, category='so', description='BOX DRAWINGS LIGHT UP' },
	[0x2576] = { unicodeslot=0x2576, category='so', description='BOX DRAWINGS LIGHT RIGHT' },
	[0x2577] = { unicodeslot=0x2577, category='so', description='BOX DRAWINGS LIGHT DOWN' },
	[0x2578] = { unicodeslot=0x2578, category='so', description='BOX DRAWINGS HEAVY LEFT' },
	[0x2579] = { unicodeslot=0x2579, category='so', description='BOX DRAWINGS HEAVY UP' },
	[0x257A] = { unicodeslot=0x257A, category='so', description='BOX DRAWINGS HEAVY RIGHT' },
	[0x257B] = { unicodeslot=0x257B, category='so', description='BOX DRAWINGS HEAVY DOWN' },
	[0x257C] = { unicodeslot=0x257C, category='so', description='BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT' },
	[0x257D] = { unicodeslot=0x257D, category='so', description='BOX DRAWINGS LIGHT UP AND HEAVY DOWN' },
	[0x257E] = { unicodeslot=0x257E, category='so', description='BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT' },
	[0x257F] = { unicodeslot=0x257F, category='so', description='BOX DRAWINGS HEAVY UP AND LIGHT DOWN' },
	[0x2580] = { unicodeslot=0x2580, category='so', adobename='upblock', description='UPPER HALF BLOCK' },
	[0x2581] = { unicodeslot=0x2581, category='so', description='LOWER ONE EIGHTH BLOCK' },
	[0x2582] = { unicodeslot=0x2582, category='so', description='LOWER ONE QUARTER BLOCK' },
	[0x2583] = { unicodeslot=0x2583, category='so', description='LOWER THREE EIGHTHS BLOCK' },
	[0x2584] = { unicodeslot=0x2584, category='so', adobename='dnblock', description='LOWER HALF BLOCK' },
	[0x2585] = { unicodeslot=0x2585, category='so', description='LOWER FIVE EIGHTHS BLOCK' },
	[0x2586] = { unicodeslot=0x2586, category='so', description='LOWER THREE QUARTERS BLOCK' },
	[0x2587] = { unicodeslot=0x2587, category='so', description='LOWER SEVEN EIGHTHS BLOCK' },
	[0x2588] = { unicodeslot=0x2588, category='so', adobename='block', description='FULL BLOCK' },
	[0x2589] = { unicodeslot=0x2589, category='so', description='LEFT SEVEN EIGHTHS BLOCK' },
	[0x258A] = { unicodeslot=0x258A, category='so', description='LEFT THREE QUARTERS BLOCK' },
	[0x258B] = { unicodeslot=0x258B, category='so', description='LEFT FIVE EIGHTHS BLOCK' },
	[0x258C] = { unicodeslot=0x258C, category='so', adobename='lfblock', description='LEFT HALF BLOCK' },
	[0x258D] = { unicodeslot=0x258D, category='so', description='LEFT THREE EIGHTHS BLOCK' },
	[0x258E] = { unicodeslot=0x258E, category='so', description='LEFT ONE QUARTER BLOCK' },
	[0x258F] = { unicodeslot=0x258F, category='so', description='LEFT ONE EIGHTH BLOCK' },
	[0x2590] = { unicodeslot=0x2590, category='so', adobename='rtblock', description='RIGHT HALF BLOCK' },
	[0x2591] = { unicodeslot=0x2591, category='so', adobename='ltshade', description='LIGHT SHADE' },
	[0x2592] = { unicodeslot=0x2592, category='so', adobename='shade', description='MEDIUM SHADE' },
	[0x2593] = { unicodeslot=0x2593, category='so', adobename='dkshade', description='DARK SHADE' },
	[0x2594] = { unicodeslot=0x2594, category='so', description='UPPER ONE EIGHTH BLOCK' },
	[0x2595] = { unicodeslot=0x2595, category='so', description='RIGHT ONE EIGHTH BLOCK' },
	[0x2596] = { unicodeslot=0x2596, category='so', description='QUADRANT LOWER LEFT' },
	[0x2597] = { unicodeslot=0x2597, category='so', description='QUADRANT LOWER RIGHT' },
	[0x2598] = { unicodeslot=0x2598, category='so', description='QUADRANT UPPER LEFT' },
	[0x2599] = { unicodeslot=0x2599, category='so', description='QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT' },
	[0x259A] = { unicodeslot=0x259A, category='so', description='QUADRANT UPPER LEFT AND LOWER RIGHT' },
	[0x259B] = { unicodeslot=0x259B, category='so', description='QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT' },
	[0x259C] = { unicodeslot=0x259C, category='so', description='QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT' },
	[0x259D] = { unicodeslot=0x259D, category='so', description='QUADRANT UPPER RIGHT' },
	[0x259E] = { unicodeslot=0x259E, category='so', description='QUADRANT UPPER RIGHT AND LOWER LEFT' },
	[0x259F] = { unicodeslot=0x259F, category='so', description='QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT' },
	[0x25A0] = { unicodeslot=0x25A0, category='so', adobename='filledbox', description='BLACK SQUARE' },
	[0x25A1] = { unicodeslot=0x25A1, category='so', adobename='H22073', description='WHITE SQUARE' },
	[0x25A2] = { unicodeslot=0x25A2, category='so', description='WHITE SQUARE WITH ROUNDED CORNERS' },
	[0x25A3] = { unicodeslot=0x25A3, category='so', description='WHITE SQUARE CONTAINING BLACK SMALL SQUARE' },
	[0x25A4] = { unicodeslot=0x25A4, category='so', description='SQUARE WITH HORIZONTAL FILL' },
	[0x25A5] = { unicodeslot=0x25A5, category='so', description='SQUARE WITH VERTICAL FILL' },
	[0x25A6] = { unicodeslot=0x25A6, category='so', description='SQUARE WITH ORTHOGONAL CROSSHATCH FILL' },
	[0x25A7] = { unicodeslot=0x25A7, category='so', description='SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL' },
	[0x25A8] = { unicodeslot=0x25A8, category='so', description='SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL' },
	[0x25A9] = { unicodeslot=0x25A9, category='so', description='SQUARE WITH DIAGONAL CROSSHATCH FILL' },
	[0x25AA] = { unicodeslot=0x25AA, category='so', adobename='H18543', description='BLACK SMALL SQUARE' },
	[0x25AB] = { unicodeslot=0x25AB, category='so', adobename='H18551', description='WHITE SMALL SQUARE' },
	[0x25AC] = { unicodeslot=0x25AC, category='so', adobename='filledrect', description='BLACK RECTANGLE' },
	[0x25AD] = { unicodeslot=0x25AD, category='so', description='WHITE RECTANGLE' },
	[0x25AE] = { unicodeslot=0x25AE, category='so', description='BLACK VERTICAL RECTANGLE' },
	[0x25AF] = { unicodeslot=0x25AF, category='so', description='WHITE VERTICAL RECTANGLE' },
	[0x25B0] = { unicodeslot=0x25B0, category='so', description='BLACK PARALLELOGRAM' },
	[0x25B1] = { unicodeslot=0x25B1, category='so', description='WHITE PARALLELOGRAM' },
	[0x25B2] = { unicodeslot=0x25B2, category='so', adobename='triagup', description='BLACK UP-POINTING TRIANGLE' },
	[0x25B3] = { unicodeslot=0x25B3, category='so', description='WHITE UP-POINTING TRIANGLE' },
	[0x25B4] = { unicodeslot=0x25B4, category='so', description='BLACK UP-POINTING SMALL TRIANGLE' },
	[0x25B5] = { unicodeslot=0x25B5, category='so', description='WHITE UP-POINTING SMALL TRIANGLE' },
	[0x25B6] = { unicodeslot=0x25B6, category='so', description='BLACK RIGHT-POINTING TRIANGLE' },
	[0x25B7] = { unicodeslot=0x25B7, category='sm', description='WHITE RIGHT-POINTING TRIANGLE' },
	[0x25B8] = { unicodeslot=0x25B8, category='so', description='BLACK RIGHT-POINTING SMALL TRIANGLE' },
	[0x25B9] = { unicodeslot=0x25B9, category='so', description='WHITE RIGHT-POINTING SMALL TRIANGLE' },
	[0x25BA] = { unicodeslot=0x25BA, category='so', adobename='triagrt', description='BLACK RIGHT-POINTING POINTER' },
	[0x25BB] = { unicodeslot=0x25BB, category='so', description='WHITE RIGHT-POINTING POINTER' },
	[0x25BC] = { unicodeslot=0x25BC, category='so', adobename='triagdn', description='BLACK DOWN-POINTING TRIANGLE' },
	[0x25BD] = { unicodeslot=0x25BD, category='so', description='WHITE DOWN-POINTING TRIANGLE' },
	[0x25BE] = { unicodeslot=0x25BE, category='so', description='BLACK DOWN-POINTING SMALL TRIANGLE' },
	[0x25BF] = { unicodeslot=0x25BF, category='so', description='WHITE DOWN-POINTING SMALL TRIANGLE' },
	[0x25C0] = { unicodeslot=0x25C0, category='so', description='BLACK LEFT-POINTING TRIANGLE' },
	[0x25C1] = { unicodeslot=0x25C1, category='sm', description='WHITE LEFT-POINTING TRIANGLE' },
	[0x25C2] = { unicodeslot=0x25C2, category='so', description='BLACK LEFT-POINTING SMALL TRIANGLE' },
	[0x25C3] = { unicodeslot=0x25C3, category='so', description='WHITE LEFT-POINTING SMALL TRIANGLE' },
	[0x25C4] = { unicodeslot=0x25C4, category='so', adobename='triaglf', description='BLACK LEFT-POINTING POINTER' },
	[0x25C5] = { unicodeslot=0x25C5, category='so', description='WHITE LEFT-POINTING POINTER' },
	[0x25C6] = { unicodeslot=0x25C6, category='so', description='BLACK DIAMOND' },
	[0x25C7] = { unicodeslot=0x25C7, category='so', description='WHITE DIAMOND' },
	[0x25C8] = { unicodeslot=0x25C8, category='so', description='WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND' },
	[0x25C9] = { unicodeslot=0x25C9, category='so', description='FISHEYE' },
	[0x25CA] = { unicodeslot=0x25CA, category='so', adobename='lozenge', description='LOZENGE' },
	[0x25CB] = { unicodeslot=0x25CB, category='so', adobename='circle', description='WHITE CIRCLE' },
	[0x25CC] = { unicodeslot=0x25CC, category='so', description='DOTTED CIRCLE' },
	[0x25CD] = { unicodeslot=0x25CD, category='so', description='CIRCLE WITH VERTICAL FILL' },
	[0x25CE] = { unicodeslot=0x25CE, category='so', description='BULLSEYE' },
	[0x25CF] = { unicodeslot=0x25CF, category='so', adobename='H18533', description='BLACK CIRCLE' },
	[0x25D0] = { unicodeslot=0x25D0, category='so', description='CIRCLE WITH LEFT HALF BLACK' },
	[0x25D1] = { unicodeslot=0x25D1, category='so', description='CIRCLE WITH RIGHT HALF BLACK' },
	[0x25D2] = { unicodeslot=0x25D2, category='so', description='CIRCLE WITH LOWER HALF BLACK' },
	[0x25D3] = { unicodeslot=0x25D3, category='so', description='CIRCLE WITH UPPER HALF BLACK' },
	[0x25D4] = { unicodeslot=0x25D4, category='so', description='CIRCLE WITH UPPER RIGHT QUADRANT BLACK' },
	[0x25D5] = { unicodeslot=0x25D5, category='so', description='CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK' },
	[0x25D6] = { unicodeslot=0x25D6, category='so', description='LEFT HALF BLACK CIRCLE' },
	[0x25D7] = { unicodeslot=0x25D7, category='so', description='RIGHT HALF BLACK CIRCLE' },
	[0x25D8] = { unicodeslot=0x25D8, category='so', adobename='invbullet', description='INVERSE BULLET' },
	[0x25D9] = { unicodeslot=0x25D9, category='so', adobename='invcircle', description='INVERSE WHITE CIRCLE' },
	[0x25DA] = { unicodeslot=0x25DA, category='so', description='UPPER HALF INVERSE WHITE CIRCLE' },
	[0x25DB] = { unicodeslot=0x25DB, category='so', description='LOWER HALF INVERSE WHITE CIRCLE' },
	[0x25DC] = { unicodeslot=0x25DC, category='so', description='UPPER LEFT QUADRANT CIRCULAR ARC' },
	[0x25DD] = { unicodeslot=0x25DD, category='so', description='UPPER RIGHT QUADRANT CIRCULAR ARC' },
	[0x25DE] = { unicodeslot=0x25DE, category='so', description='LOWER RIGHT QUADRANT CIRCULAR ARC' },
	[0x25DF] = { unicodeslot=0x25DF, category='so', description='LOWER LEFT QUADRANT CIRCULAR ARC' },
	[0x25E0] = { unicodeslot=0x25E0, category='so', description='UPPER HALF CIRCLE' },
	[0x25E1] = { unicodeslot=0x25E1, category='so', description='LOWER HALF CIRCLE' },
	[0x25E2] = { unicodeslot=0x25E2, category='so', description='BLACK LOWER RIGHT TRIANGLE' },
	[0x25E3] = { unicodeslot=0x25E3, category='so', description='BLACK LOWER LEFT TRIANGLE' },
	[0x25E4] = { unicodeslot=0x25E4, category='so', description='BLACK UPPER LEFT TRIANGLE' },
	[0x25E5] = { unicodeslot=0x25E5, category='so', description='BLACK UPPER RIGHT TRIANGLE' },
	[0x25E6] = { unicodeslot=0x25E6, category='so', adobename='openbullet', description='WHITE BULLET' },
	[0x25E7] = { unicodeslot=0x25E7, category='so', description='SQUARE WITH LEFT HALF BLACK' },
	[0x25E8] = { unicodeslot=0x25E8, category='so', description='SQUARE WITH RIGHT HALF BLACK' },
	[0x25E9] = { unicodeslot=0x25E9, category='so', description='SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK' },
	[0x25EA] = { unicodeslot=0x25EA, category='so', description='SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK' },
	[0x25EB] = { unicodeslot=0x25EB, category='so', description='WHITE SQUARE WITH VERTICAL BISECTING LINE' },
	[0x25EC] = { unicodeslot=0x25EC, category='so', description='WHITE UP-POINTING TRIANGLE WITH DOT' },
	[0x25ED] = { unicodeslot=0x25ED, category='so', description='UP-POINTING TRIANGLE WITH LEFT HALF BLACK' },
	[0x25EE] = { unicodeslot=0x25EE, category='so', description='UP-POINTING TRIANGLE WITH RIGHT HALF BLACK' },
	[0x25EF] = { unicodeslot=0x25EF, category='so', description='LARGE CIRCLE' },
	[0x25F0] = { unicodeslot=0x25F0, category='so', description='WHITE SQUARE WITH UPPER LEFT QUADRANT' },
	[0x25F1] = { unicodeslot=0x25F1, category='so', description='WHITE SQUARE WITH LOWER LEFT QUADRANT' },
	[0x25F2] = { unicodeslot=0x25F2, category='so', description='WHITE SQUARE WITH LOWER RIGHT QUADRANT' },
	[0x25F3] = { unicodeslot=0x25F3, category='so', description='WHITE SQUARE WITH UPPER RIGHT QUADRANT' },
	[0x25F4] = { unicodeslot=0x25F4, category='so', description='WHITE CIRCLE WITH UPPER LEFT QUADRANT' },
	[0x25F5] = { unicodeslot=0x25F5, category='so', description='WHITE CIRCLE WITH LOWER LEFT QUADRANT' },
	[0x25F6] = { unicodeslot=0x25F6, category='so', description='WHITE CIRCLE WITH LOWER RIGHT QUADRANT' },
	[0x25F7] = { unicodeslot=0x25F7, category='so', description='WHITE CIRCLE WITH UPPER RIGHT QUADRANT' },
	[0x25F8] = { unicodeslot=0x25F8, category='sm', description='UPPER LEFT TRIANGLE' },
	[0x25F9] = { unicodeslot=0x25F9, category='sm', description='UPPER RIGHT TRIANGLE' },
	[0x25FA] = { unicodeslot=0x25FA, category='sm', description='LOWER LEFT TRIANGLE' },
	[0x25FB] = { unicodeslot=0x25FB, category='sm', description='WHITE MEDIUM SQUARE' },
	[0x25FC] = { unicodeslot=0x25FC, category='sm', description='BLACK MEDIUM SQUARE' },
	[0x25FD] = { unicodeslot=0x25FD, category='sm', description='WHITE MEDIUM SMALL SQUARE' },
	[0x25FE] = { unicodeslot=0x25FE, category='sm', description='BLACK MEDIUM SMALL SQUARE' },
	[0x25FF] = { unicodeslot=0x25FF, category='sm', description='LOWER RIGHT TRIANGLE' },
	[0x2600] = { unicodeslot=0x2600, category='so', description='BLACK SUN WITH RAYS' },
	[0x2601] = { unicodeslot=0x2601, category='so', description='CLOUD' },
	[0x2602] = { unicodeslot=0x2602, category='so', description='UMBRELLA' },
	[0x2603] = { unicodeslot=0x2603, category='so', description='SNOWMAN' },
	[0x2604] = { unicodeslot=0x2604, category='so', description='COMET' },
	[0x2605] = { unicodeslot=0x2605, category='so', description='BLACK STAR' },
	[0x2606] = { unicodeslot=0x2606, category='so', description='WHITE STAR' },
	[0x2607] = { unicodeslot=0x2607, category='so', description='LIGHTNING' },
	[0x2608] = { unicodeslot=0x2608, category='so', description='THUNDERSTORM' },
	[0x2609] = { unicodeslot=0x2609, category='so', description='SUN' },
	[0x260A] = { unicodeslot=0x260A, category='so', description='ASCENDING NODE' },
	[0x260B] = { unicodeslot=0x260B, category='so', description='DESCENDING NODE' },
	[0x260C] = { unicodeslot=0x260C, category='so', description='CONJUNCTION' },
	[0x260D] = { unicodeslot=0x260D, category='so', description='OPPOSITION' },
	[0x260E] = { unicodeslot=0x260E, category='so', description='BLACK TELEPHONE' },
	[0x260F] = { unicodeslot=0x260F, category='so', description='WHITE TELEPHONE' },
	[0x2610] = { unicodeslot=0x2610, category='so', description='BALLOT BOX' },
	[0x2611] = { unicodeslot=0x2611, category='so', description='BALLOT BOX WITH CHECK' },
	[0x2612] = { unicodeslot=0x2612, category='so', description='BALLOT BOX WITH X' },
	[0x2613] = { unicodeslot=0x2613, category='so', description='SALTIRE' },
	[0x2614] = { unicodeslot=0x2614, category='so', description='UMBRELLA WITH RAIN DROPS' },
	[0x2615] = { unicodeslot=0x2615, category='so', description='HOT BEVERAGE' },
	[0x2616] = { unicodeslot=0x2616, category='so', description='WHITE SHOGI PIECE' },
	[0x2617] = { unicodeslot=0x2617, category='so', description='BLACK SHOGI PIECE' },
	[0x2618] = { unicodeslot=0x2618, category='so', description='SHAMROCK' },
	[0x2619] = { unicodeslot=0x2619, category='so', description='REVERSED ROTATED FLORAL HEART BULLET' },
	[0x261A] = { unicodeslot=0x261A, category='so', description='BLACK LEFT POINTING INDEX' },
	[0x261B] = { unicodeslot=0x261B, category='so', description='BLACK RIGHT POINTING INDEX' },
	[0x261C] = { unicodeslot=0x261C, category='so', description='WHITE LEFT POINTING INDEX' },
	[0x261D] = { unicodeslot=0x261D, category='so', description='WHITE UP POINTING INDEX' },
	[0x261E] = { unicodeslot=0x261E, category='so', description='WHITE RIGHT POINTING INDEX' },
	[0x261F] = { unicodeslot=0x261F, category='so', description='WHITE DOWN POINTING INDEX' },
	[0x2620] = { unicodeslot=0x2620, category='so', description='SKULL AND CROSSBONES' },
	[0x2621] = { unicodeslot=0x2621, category='so', description='CAUTION SIGN' },
	[0x2622] = { unicodeslot=0x2622, category='so', description='RADIOACTIVE SIGN' },
	[0x2623] = { unicodeslot=0x2623, category='so', description='BIOHAZARD SIGN' },
	[0x2624] = { unicodeslot=0x2624, category='so', description='CADUCEUS' },
	[0x2625] = { unicodeslot=0x2625, category='so', description='ANKH' },
	[0x2626] = { unicodeslot=0x2626, category='so', description='ORTHODOX CROSS' },
	[0x2627] = { unicodeslot=0x2627, category='so', description='CHI RHO' },
	[0x2628] = { unicodeslot=0x2628, category='so', description='CROSS OF LORRAINE' },
	[0x2629] = { unicodeslot=0x2629, category='so', description='CROSS OF JERUSALEM' },
	[0x262A] = { unicodeslot=0x262A, category='so', description='STAR AND CRESCENT' },
	[0x262B] = { unicodeslot=0x262B, category='so', description='FARSI SYMBOL' },
	[0x262C] = { unicodeslot=0x262C, category='so', description='ADI SHAKTI' },
	[0x262D] = { unicodeslot=0x262D, category='so', description='HAMMER AND SICKLE' },
	[0x262E] = { unicodeslot=0x262E, category='so', description='PEACE SYMBOL' },
	[0x262F] = { unicodeslot=0x262F, category='so', description='YIN YANG' },
	[0x2630] = { unicodeslot=0x2630, category='so', description='TRIGRAM FOR HEAVEN' },
	[0x2631] = { unicodeslot=0x2631, category='so', description='TRIGRAM FOR LAKE' },
	[0x2632] = { unicodeslot=0x2632, category='so', description='TRIGRAM FOR FIRE' },
	[0x2633] = { unicodeslot=0x2633, category='so', description='TRIGRAM FOR THUNDER' },
	[0x2634] = { unicodeslot=0x2634, category='so', description='TRIGRAM FOR WIND' },
	[0x2635] = { unicodeslot=0x2635, category='so', description='TRIGRAM FOR WATER' },
	[0x2636] = { unicodeslot=0x2636, category='so', description='TRIGRAM FOR MOUNTAIN' },
	[0x2637] = { unicodeslot=0x2637, category='so', description='TRIGRAM FOR EARTH' },
	[0x2638] = { unicodeslot=0x2638, category='so', description='WHEEL OF DHARMA' },
	[0x2639] = { unicodeslot=0x2639, category='so', description='WHITE FROWNING FACE' },
	[0x263A] = { unicodeslot=0x263A, category='so', adobename='smileface', description='WHITE SMILING FACE' },
	[0x263B] = { unicodeslot=0x263B, category='so', adobename='invsmileface', description='BLACK SMILING FACE' },
	[0x263C] = { unicodeslot=0x263C, category='so', adobename='sun', description='WHITE SUN WITH RAYS' },
	[0x263D] = { unicodeslot=0x263D, category='so', description='FIRST QUARTER MOON' },
	[0x263E] = { unicodeslot=0x263E, category='so', description='LAST QUARTER MOON' },
	[0x263F] = { unicodeslot=0x263F, category='so', description='MERCURY' },
	[0x2640] = { unicodeslot=0x2640, category='so', adobename='female', description='FEMALE SIGN' },
	[0x2641] = { unicodeslot=0x2641, category='so', description='EARTH' },
	[0x2642] = { unicodeslot=0x2642, category='so', adobename='male', description='MALE SIGN' },
	[0x2643] = { unicodeslot=0x2643, category='so', description='JUPITER' },
	[0x2644] = { unicodeslot=0x2644, category='so', description='SATURN' },
	[0x2645] = { unicodeslot=0x2645, category='so', description='URANUS' },
	[0x2646] = { unicodeslot=0x2646, category='so', description='NEPTUNE' },
	[0x2647] = { unicodeslot=0x2647, category='so', description='PLUTO' },
	[0x2648] = { unicodeslot=0x2648, category='so', description='ARIES' },
	[0x2649] = { unicodeslot=0x2649, category='so', description='TAURUS' },
	[0x264A] = { unicodeslot=0x264A, category='so', description='GEMINI' },
	[0x264B] = { unicodeslot=0x264B, category='so', description='CANCER' },
	[0x264C] = { unicodeslot=0x264C, category='so', description='LEO' },
	[0x264D] = { unicodeslot=0x264D, category='so', description='VIRGO' },
	[0x264E] = { unicodeslot=0x264E, category='so', description='LIBRA' },
	[0x264F] = { unicodeslot=0x264F, category='so', description='SCORPIUS' },
	[0x2650] = { unicodeslot=0x2650, category='so', description='SAGITTARIUS' },
	[0x2651] = { unicodeslot=0x2651, category='so', description='CAPRICORN' },
	[0x2652] = { unicodeslot=0x2652, category='so', description='AQUARIUS' },
	[0x2653] = { unicodeslot=0x2653, category='so', description='PISCES' },
	[0x2654] = { unicodeslot=0x2654, category='so', description='WHITE CHESS KING' },
	[0x2655] = { unicodeslot=0x2655, category='so', description='WHITE CHESS QUEEN' },
	[0x2656] = { unicodeslot=0x2656, category='so', description='WHITE CHESS ROOK' },
	[0x2657] = { unicodeslot=0x2657, category='so', description='WHITE CHESS BISHOP' },
	[0x2658] = { unicodeslot=0x2658, category='so', description='WHITE CHESS KNIGHT' },
	[0x2659] = { unicodeslot=0x2659, category='so', description='WHITE CHESS PAWN' },
	[0x265A] = { unicodeslot=0x265A, category='so', description='BLACK CHESS KING' },
	[0x265B] = { unicodeslot=0x265B, category='so', description='BLACK CHESS QUEEN' },
	[0x265C] = { unicodeslot=0x265C, category='so', description='BLACK CHESS ROOK' },
	[0x265D] = { unicodeslot=0x265D, category='so', description='BLACK CHESS BISHOP' },
	[0x265E] = { unicodeslot=0x265E, category='so', description='BLACK CHESS KNIGHT' },
	[0x265F] = { unicodeslot=0x265F, category='so', description='BLACK CHESS PAWN' },
	[0x2660] = { unicodeslot=0x2660, category='so', adobename='spade', description='BLACK SPADE SUIT' },
	[0x2661] = { unicodeslot=0x2661, category='so', description='WHITE HEART SUIT' },
	[0x2662] = { unicodeslot=0x2662, category='so', description='WHITE DIAMOND SUIT' },
	[0x2663] = { unicodeslot=0x2663, category='so', adobename='club', description='BLACK CLUB SUIT' },
	[0x2664] = { unicodeslot=0x2664, category='so', description='WHITE SPADE SUIT' },
	[0x2665] = { unicodeslot=0x2665, category='so', adobename='heart', description='BLACK HEART SUIT' },
	[0x2666] = { unicodeslot=0x2666, category='so', adobename='diamond', description='BLACK DIAMOND SUIT' },
	[0x2667] = { unicodeslot=0x2667, category='so', description='WHITE CLUB SUIT' },
	[0x2668] = { unicodeslot=0x2668, category='so', description='HOT SPRINGS' },
	[0x2669] = { unicodeslot=0x2669, category='so', description='QUARTER NOTE' },
	[0x266A] = { unicodeslot=0x266A, category='so', adobename='musicalnote', description='EIGHTH NOTE' },
	[0x266B] = { unicodeslot=0x266B, category='so', adobename='musicalnotedbl', description='BEAMED EIGHTH NOTES' },
	[0x266C] = { unicodeslot=0x266C, category='so', description='BEAMED SIXTEENTH NOTES' },
	[0x266D] = { unicodeslot=0x266D, category='so', description='MUSIC FLAT SIGN' },
	[0x266E] = { unicodeslot=0x266E, category='so', description='MUSIC NATURAL SIGN' },
	[0x266F] = { unicodeslot=0x266F, category='sm', description='MUSIC SHARP SIGN' },
	[0x2670] = { unicodeslot=0x2670, category='so', description='WEST SYRIAC CROSS' },
	[0x2671] = { unicodeslot=0x2671, category='so', description='EAST SYRIAC CROSS' },
	[0x2672] = { unicodeslot=0x2672, category='so', description='UNIVERSAL RECYCLING SYMBOL' },
	[0x2673] = { unicodeslot=0x2673, category='so', description='RECYCLING SYMBOL FOR TYPE-1 PLASTICS' },
	[0x2674] = { unicodeslot=0x2674, category='so', description='RECYCLING SYMBOL FOR TYPE-2 PLASTICS' },
	[0x2675] = { unicodeslot=0x2675, category='so', description='RECYCLING SYMBOL FOR TYPE-3 PLASTICS' },
	[0x2676] = { unicodeslot=0x2676, category='so', description='RECYCLING SYMBOL FOR TYPE-4 PLASTICS' },
	[0x2677] = { unicodeslot=0x2677, category='so', description='RECYCLING SYMBOL FOR TYPE-5 PLASTICS' },
	[0x2678] = { unicodeslot=0x2678, category='so', description='RECYCLING SYMBOL FOR TYPE-6 PLASTICS' },
	[0x2679] = { unicodeslot=0x2679, category='so', description='RECYCLING SYMBOL FOR TYPE-7 PLASTICS' },
	[0x267A] = { unicodeslot=0x267A, category='so', description='RECYCLING SYMBOL FOR GENERIC MATERIALS' },
	[0x267B] = { unicodeslot=0x267B, category='so', description='BLACK UNIVERSAL RECYCLING SYMBOL' },
	[0x267C] = { unicodeslot=0x267C, category='so', description='RECYCLED PAPER SYMBOL' },
	[0x267D] = { unicodeslot=0x267D, category='so', description='PARTIALLY-RECYCLED PAPER SYMBOL' },
	[0x267E] = { unicodeslot=0x267E, category='so', description='PERMANENT PAPER SIGN' },
	[0x267F] = { unicodeslot=0x267F, category='so', description='WHEELCHAIR SYMBOL' },
	[0x2680] = { unicodeslot=0x2680, category='so', description='DIE FACE-1' },
	[0x2681] = { unicodeslot=0x2681, category='so', description='DIE FACE-2' },
	[0x2682] = { unicodeslot=0x2682, category='so', description='DIE FACE-3' },
	[0x2683] = { unicodeslot=0x2683, category='so', description='DIE FACE-4' },
	[0x2684] = { unicodeslot=0x2684, category='so', description='DIE FACE-5' },
	[0x2685] = { unicodeslot=0x2685, category='so', description='DIE FACE-6' },
	[0x2686] = { unicodeslot=0x2686, category='so', description='WHITE CIRCLE WITH DOT RIGHT' },
	[0x2687] = { unicodeslot=0x2687, category='so', description='WHITE CIRCLE WITH TWO DOTS' },
	[0x2688] = { unicodeslot=0x2688, category='so', description='BLACK CIRCLE WITH WHITE DOT RIGHT' },
	[0x2689] = { unicodeslot=0x2689, category='so', description='BLACK CIRCLE WITH TWO WHITE DOTS' },
	[0x268A] = { unicodeslot=0x268A, category='so', description='MONOGRAM FOR YANG' },
	[0x268B] = { unicodeslot=0x268B, category='so', description='MONOGRAM FOR YIN' },
	[0x268C] = { unicodeslot=0x268C, category='so', description='DIGRAM FOR GREATER YANG' },
	[0x268D] = { unicodeslot=0x268D, category='so', description='DIGRAM FOR LESSER YIN' },
	[0x268E] = { unicodeslot=0x268E, category='so', description='DIGRAM FOR LESSER YANG' },
	[0x268F] = { unicodeslot=0x268F, category='so', description='DIGRAM FOR GREATER YIN' },
	[0x2690] = { unicodeslot=0x2690, category='so', description='WHITE FLAG' },
	[0x2691] = { unicodeslot=0x2691, category='so', description='BLACK FLAG' },
	[0x2692] = { unicodeslot=0x2692, category='so', description='HAMMER AND PICK' },
	[0x2693] = { unicodeslot=0x2693, category='so', description='ANCHOR' },
	[0x2694] = { unicodeslot=0x2694, category='so', description='CROSSED SWORDS' },
	[0x2695] = { unicodeslot=0x2695, category='so', description='STAFF OF AESCULAPIUS' },
	[0x2696] = { unicodeslot=0x2696, category='so', description='SCALES' },
	[0x2697] = { unicodeslot=0x2697, category='so', description='ALEMBIC' },
	[0x2698] = { unicodeslot=0x2698, category='so', description='FLOWER' },
	[0x2699] = { unicodeslot=0x2699, category='so', description='GEAR' },
	[0x269A] = { unicodeslot=0x269A, category='so', description='STAFF OF HERMES' },
	[0x269B] = { unicodeslot=0x269B, category='so', description='ATOM SYMBOL' },
	[0x269C] = { unicodeslot=0x269C, category='so', description='FLEUR-DE-LIS' },
	[0x26A0] = { unicodeslot=0x26A0, category='so', description='WARNING SIGN' },
	[0x26A1] = { unicodeslot=0x26A1, category='so', description='HIGH VOLTAGE SIGN' },
	[0x26A2] = { unicodeslot=0x26A2, category='so', description='DOUBLED FEMALE SIGN' },
	[0x26A3] = { unicodeslot=0x26A3, category='so', description='DOUBLED MALE SIGN' },
	[0x26A4] = { unicodeslot=0x26A4, category='so', description='INTERLOCKED FEMALE AND MALE SIGN' },
	[0x26A5] = { unicodeslot=0x26A5, category='so', description='MALE AND FEMALE SIGN' },
	[0x26A6] = { unicodeslot=0x26A6, category='so', description='MALE WITH STROKE SIGN' },
	[0x26A7] = { unicodeslot=0x26A7, category='so', description='MALE WITH STROKE AND MALE AND FEMALE SIGN' },
	[0x26A8] = { unicodeslot=0x26A8, category='so', description='VERTICAL MALE WITH STROKE SIGN' },
	[0x26A9] = { unicodeslot=0x26A9, category='so', description='HORIZONTAL MALE WITH STROKE SIGN' },
	[0x26AA] = { unicodeslot=0x26AA, category='so', description='MEDIUM WHITE CIRCLE' },
	[0x26AB] = { unicodeslot=0x26AB, category='so', description='MEDIUM BLACK CIRCLE' },
	[0x26AC] = { unicodeslot=0x26AC, category='so', description='MEDIUM SMALL WHITE CIRCLE' },
	[0x26AD] = { unicodeslot=0x26AD, category='so', description='MARRIAGE SYMBOL' },
	[0x26AE] = { unicodeslot=0x26AE, category='so', description='DIVORCE SYMBOL' },
	[0x26AF] = { unicodeslot=0x26AF, category='so', description='UNMARRIED PARTNERSHIP SYMBOL' },
	[0x26B0] = { unicodeslot=0x26B0, category='so', description='COFFIN' },
	[0x26B1] = { unicodeslot=0x26B1, category='so', description='FUNERAL URN' },
	[0x26B2] = { unicodeslot=0x26B2, category='so', description='NEUTER' },
	[0x2701] = { unicodeslot=0x2701, category='so', description='UPPER BLADE SCISSORS' },
	[0x2702] = { unicodeslot=0x2702, category='so', description='BLACK SCISSORS' },
	[0x2703] = { unicodeslot=0x2703, category='so', description='LOWER BLADE SCISSORS' },
	[0x2704] = { unicodeslot=0x2704, category='so', description='WHITE SCISSORS' },
	[0x2706] = { unicodeslot=0x2706, category='so', description='TELEPHONE LOCATION SIGN' },
	[0x2707] = { unicodeslot=0x2707, category='so', description='TAPE DRIVE' },
	[0x2708] = { unicodeslot=0x2708, category='so', description='AIRPLANE' },
	[0x2709] = { unicodeslot=0x2709, category='so', description='ENVELOPE' },
	[0x270C] = { unicodeslot=0x270C, category='so', description='VICTORY HAND' },
	[0x270D] = { unicodeslot=0x270D, category='so', description='WRITING HAND' },
	[0x270E] = { unicodeslot=0x270E, category='so', description='LOWER RIGHT PENCIL' },
	[0x270F] = { unicodeslot=0x270F, category='so', description='PENCIL' },
	[0x2710] = { unicodeslot=0x2710, category='so', description='UPPER RIGHT PENCIL' },
	[0x2711] = { unicodeslot=0x2711, category='so', description='WHITE NIB' },
	[0x2712] = { unicodeslot=0x2712, category='so', description='BLACK NIB' },
	[0x2713] = { unicodeslot=0x2713, category='so', description='CHECK MARK' },
	[0x2714] = { unicodeslot=0x2714, category='so', description='HEAVY CHECK MARK' },
	[0x2715] = { unicodeslot=0x2715, category='so', description='MULTIPLICATION X' },
	[0x2716] = { unicodeslot=0x2716, category='so', description='HEAVY MULTIPLICATION X' },
	[0x2717] = { unicodeslot=0x2717, category='so', description='BALLOT X' },
	[0x2718] = { unicodeslot=0x2718, category='so', description='HEAVY BALLOT X' },
	[0x2719] = { unicodeslot=0x2719, category='so', description='OUTLINED GREEK CROSS' },
	[0x271A] = { unicodeslot=0x271A, category='so', description='HEAVY GREEK CROSS' },
	[0x271B] = { unicodeslot=0x271B, category='so', description='OPEN CENTRE CROSS' },
	[0x271C] = { unicodeslot=0x271C, category='so', description='HEAVY OPEN CENTRE CROSS' },
	[0x271D] = { unicodeslot=0x271D, category='so', description='LATIN CROSS' },
	[0x271E] = { unicodeslot=0x271E, category='so', description='SHADOWED WHITE LATIN CROSS' },
	[0x271F] = { unicodeslot=0x271F, category='so', description='OUTLINED LATIN CROSS' },
	[0x2720] = { unicodeslot=0x2720, category='so', description='MALTESE CROSS' },
	[0x2721] = { unicodeslot=0x2721, category='so', description='STAR OF DAVID' },
	[0x2722] = { unicodeslot=0x2722, category='so', description='FOUR TEARDROP-SPOKED ASTERISK' },
	[0x2723] = { unicodeslot=0x2723, category='so', description='FOUR BALLOON-SPOKED ASTERISK' },
	[0x2724] = { unicodeslot=0x2724, category='so', description='HEAVY FOUR BALLOON-SPOKED ASTERISK' },
	[0x2725] = { unicodeslot=0x2725, category='so', description='FOUR CLUB-SPOKED ASTERISK' },
	[0x2726] = { unicodeslot=0x2726, category='so', description='BLACK FOUR POINTED STAR' },
	[0x2727] = { unicodeslot=0x2727, category='so', description='WHITE FOUR POINTED STAR' },
	[0x2729] = { unicodeslot=0x2729, category='so', description='STRESS OUTLINED WHITE STAR' },
	[0x272A] = { unicodeslot=0x272A, category='so', description='CIRCLED WHITE STAR' },
	[0x272B] = { unicodeslot=0x272B, category='so', description='OPEN CENTRE BLACK STAR' },
	[0x272C] = { unicodeslot=0x272C, category='so', description='BLACK CENTRE WHITE STAR' },
	[0x272D] = { unicodeslot=0x272D, category='so', description='OUTLINED BLACK STAR' },
	[0x272E] = { unicodeslot=0x272E, category='so', description='HEAVY OUTLINED BLACK STAR' },
	[0x272F] = { unicodeslot=0x272F, category='so', description='PINWHEEL STAR' },
	[0x2730] = { unicodeslot=0x2730, category='so', description='SHADOWED WHITE STAR' },
	[0x2731] = { unicodeslot=0x2731, category='so', description='HEAVY ASTERISK' },
	[0x2732] = { unicodeslot=0x2732, category='so', description='OPEN CENTRE ASTERISK' },
	[0x2733] = { unicodeslot=0x2733, category='so', description='EIGHT SPOKED ASTERISK' },
	[0x2734] = { unicodeslot=0x2734, category='so', description='EIGHT POINTED BLACK STAR' },
	[0x2735] = { unicodeslot=0x2735, category='so', description='EIGHT POINTED PINWHEEL STAR' },
	[0x2736] = { unicodeslot=0x2736, category='so', description='SIX POINTED BLACK STAR' },
	[0x2737] = { unicodeslot=0x2737, category='so', description='EIGHT POINTED RECTILINEAR BLACK STAR' },
	[0x2738] = { unicodeslot=0x2738, category='so', description='HEAVY EIGHT POINTED RECTILINEAR BLACK STAR' },
	[0x2739] = { unicodeslot=0x2739, category='so', description='TWELVE POINTED BLACK STAR' },
	[0x273A] = { unicodeslot=0x273A, category='so', description='SIXTEEN POINTED ASTERISK' },
	[0x273B] = { unicodeslot=0x273B, category='so', description='TEARDROP-SPOKED ASTERISK' },
	[0x273C] = { unicodeslot=0x273C, category='so', description='OPEN CENTRE TEARDROP-SPOKED ASTERISK' },
	[0x273D] = { unicodeslot=0x273D, category='so', description='HEAVY TEARDROP-SPOKED ASTERISK' },
	[0x273E] = { unicodeslot=0x273E, category='so', description='SIX PETALLED BLACK AND WHITE FLORETTE' },
	[0x273F] = { unicodeslot=0x273F, category='so', description='BLACK FLORETTE' },
	[0x2740] = { unicodeslot=0x2740, category='so', description='WHITE FLORETTE' },
	[0x2741] = { unicodeslot=0x2741, category='so', description='EIGHT PETALLED OUTLINED BLACK FLORETTE' },
	[0x2742] = { unicodeslot=0x2742, category='so', description='CIRCLED OPEN CENTRE EIGHT POINTED STAR' },
	[0x2743] = { unicodeslot=0x2743, category='so', description='HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK' },
	[0x2744] = { unicodeslot=0x2744, category='so', description='SNOWFLAKE' },
	[0x2745] = { unicodeslot=0x2745, category='so', description='TIGHT TRIFOLIATE SNOWFLAKE' },
	[0x2746] = { unicodeslot=0x2746, category='so', description='HEAVY CHEVRON SNOWFLAKE' },
	[0x2747] = { unicodeslot=0x2747, category='so', description='SPARKLE' },
	[0x2748] = { unicodeslot=0x2748, category='so', description='HEAVY SPARKLE' },
	[0x2749] = { unicodeslot=0x2749, category='so', description='BALLOON-SPOKED ASTERISK' },
	[0x274A] = { unicodeslot=0x274A, category='so', description='EIGHT TEARDROP-SPOKED PROPELLER ASTERISK' },
	[0x274B] = { unicodeslot=0x274B, category='so', description='HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK' },
	[0x274D] = { unicodeslot=0x274D, category='so', description='SHADOWED WHITE CIRCLE' },
	[0x274F] = { unicodeslot=0x274F, category='so', description='LOWER RIGHT DROP-SHADOWED WHITE SQUARE' },
	[0x2750] = { unicodeslot=0x2750, category='so', description='UPPER RIGHT DROP-SHADOWED WHITE SQUARE' },
	[0x2751] = { unicodeslot=0x2751, category='so', description='LOWER RIGHT SHADOWED WHITE SQUARE' },
	[0x2752] = { unicodeslot=0x2752, category='so', description='UPPER RIGHT SHADOWED WHITE SQUARE' },
	[0x2756] = { unicodeslot=0x2756, category='so', description='BLACK DIAMOND MINUS WHITE X' },
	[0x2758] = { unicodeslot=0x2758, category='so', description='LIGHT VERTICAL BAR' },
	[0x2759] = { unicodeslot=0x2759, category='so', description='MEDIUM VERTICAL BAR' },
	[0x275A] = { unicodeslot=0x275A, category='so', description='HEAVY VERTICAL BAR' },
	[0x275B] = { unicodeslot=0x275B, category='so', description='HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT' },
	[0x275C] = { unicodeslot=0x275C, category='so', description='HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT' },
	[0x275D] = { unicodeslot=0x275D, category='so', description='HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT' },
	[0x275E] = { unicodeslot=0x275E, category='so', description='HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT' },
	[0x2761] = { unicodeslot=0x2761, category='so', description='CURVED STEM PARAGRAPH SIGN ORNAMENT' },
	[0x2762] = { unicodeslot=0x2762, category='so', description='HEAVY EXCLAMATION MARK ORNAMENT' },
	[0x2763] = { unicodeslot=0x2763, category='so', description='HEAVY HEART EXCLAMATION MARK ORNAMENT' },
	[0x2764] = { unicodeslot=0x2764, category='so', description='HEAVY BLACK HEART' },
	[0x2765] = { unicodeslot=0x2765, category='so', description='ROTATED HEAVY BLACK HEART BULLET' },
	[0x2766] = { unicodeslot=0x2766, category='so', description='FLORAL HEART' },
	[0x2767] = { unicodeslot=0x2767, category='so', description='ROTATED FLORAL HEART BULLET' },
	[0x2768] = { unicodeslot=0x2768, category='ps', description='MEDIUM LEFT PARENTHESIS ORNAMENT' },
	[0x2769] = { unicodeslot=0x2769, category='pe', description='MEDIUM RIGHT PARENTHESIS ORNAMENT' },
	[0x276A] = { unicodeslot=0x276A, category='ps', description='MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT' },
	[0x276B] = { unicodeslot=0x276B, category='pe', description='MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT' },
	[0x276C] = { unicodeslot=0x276C, category='ps', description='MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT' },
	[0x276D] = { unicodeslot=0x276D, category='pe', description='MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT' },
	[0x276E] = { unicodeslot=0x276E, category='ps', description='HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT' },
	[0x276F] = { unicodeslot=0x276F, category='pe', description='HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT' },
	[0x2770] = { unicodeslot=0x2770, category='ps', description='HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT' },
	[0x2771] = { unicodeslot=0x2771, category='pe', description='HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT' },
	[0x2772] = { unicodeslot=0x2772, category='ps', description='LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT' },
	[0x2773] = { unicodeslot=0x2773, category='pe', description='LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT' },
	[0x2774] = { unicodeslot=0x2774, category='ps', description='MEDIUM LEFT CURLY BRACKET ORNAMENT' },
	[0x2775] = { unicodeslot=0x2775, category='pe', description='MEDIUM RIGHT CURLY BRACKET ORNAMENT' },
	[0x2776] = { unicodeslot=0x2776, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT ONE' },
	[0x2777] = { unicodeslot=0x2777, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT TWO' },
	[0x2778] = { unicodeslot=0x2778, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT THREE' },
	[0x2779] = { unicodeslot=0x2779, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT FOUR' },
	[0x277A] = { unicodeslot=0x277A, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT FIVE' },
	[0x277B] = { unicodeslot=0x277B, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT SIX' },
	[0x277C] = { unicodeslot=0x277C, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT SEVEN' },
	[0x277D] = { unicodeslot=0x277D, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT EIGHT' },
	[0x277E] = { unicodeslot=0x277E, category='no', description='DINGBAT NEGATIVE CIRCLED DIGIT NINE' },
	[0x277F] = { unicodeslot=0x277F, category='no', description='DINGBAT NEGATIVE CIRCLED NUMBER TEN' },
	[0x2780] = { unicodeslot=0x2780, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT ONE' },
	[0x2781] = { unicodeslot=0x2781, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT TWO' },
	[0x2782] = { unicodeslot=0x2782, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT THREE' },
	[0x2783] = { unicodeslot=0x2783, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT FOUR' },
	[0x2784] = { unicodeslot=0x2784, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT FIVE' },
	[0x2785] = { unicodeslot=0x2785, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT SIX' },
	[0x2786] = { unicodeslot=0x2786, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN' },
	[0x2787] = { unicodeslot=0x2787, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT' },
	[0x2788] = { unicodeslot=0x2788, category='no', description='DINGBAT CIRCLED SANS-SERIF DIGIT NINE' },
	[0x2789] = { unicodeslot=0x2789, category='no', description='DINGBAT CIRCLED SANS-SERIF NUMBER TEN' },
	[0x278A] = { unicodeslot=0x278A, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE' },
	[0x278B] = { unicodeslot=0x278B, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO' },
	[0x278C] = { unicodeslot=0x278C, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE' },
	[0x278D] = { unicodeslot=0x278D, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR' },
	[0x278E] = { unicodeslot=0x278E, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE' },
	[0x278F] = { unicodeslot=0x278F, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX' },
	[0x2790] = { unicodeslot=0x2790, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN' },
	[0x2791] = { unicodeslot=0x2791, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT' },
	[0x2792] = { unicodeslot=0x2792, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE' },
	[0x2793] = { unicodeslot=0x2793, category='no', description='DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN' },
	[0x2794] = { unicodeslot=0x2794, category='so', description='HEAVY WIDE-HEADED RIGHTWARDS ARROW' },
	[0x2798] = { unicodeslot=0x2798, category='so', description='HEAVY SOUTH EAST ARROW' },
	[0x2799] = { unicodeslot=0x2799, category='so', description='HEAVY RIGHTWARDS ARROW' },
	[0x279A] = { unicodeslot=0x279A, category='so', description='HEAVY NORTH EAST ARROW' },
	[0x279B] = { unicodeslot=0x279B, category='so', description='DRAFTING POINT RIGHTWARDS ARROW' },
	[0x279C] = { unicodeslot=0x279C, category='so', description='HEAVY ROUND-TIPPED RIGHTWARDS ARROW' },
	[0x279D] = { unicodeslot=0x279D, category='so', description='TRIANGLE-HEADED RIGHTWARDS ARROW' },
	[0x279E] = { unicodeslot=0x279E, category='so', description='HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW' },
	[0x279F] = { unicodeslot=0x279F, category='so', description='DASHED TRIANGLE-HEADED RIGHTWARDS ARROW' },
	[0x27A0] = { unicodeslot=0x27A0, category='so', description='HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW' },
	[0x27A1] = { unicodeslot=0x27A1, category='so', description='BLACK RIGHTWARDS ARROW' },
	[0x27A2] = { unicodeslot=0x27A2, category='so', description='THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD' },
	[0x27A3] = { unicodeslot=0x27A3, category='so', description='THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD' },
	[0x27A4] = { unicodeslot=0x27A4, category='so', description='BLACK RIGHTWARDS ARROWHEAD' },
	[0x27A5] = { unicodeslot=0x27A5, category='so', description='HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW' },
	[0x27A6] = { unicodeslot=0x27A6, category='so', description='HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW' },
	[0x27A7] = { unicodeslot=0x27A7, category='so', description='SQUAT BLACK RIGHTWARDS ARROW' },
	[0x27A8] = { unicodeslot=0x27A8, category='so', description='HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW' },
	[0x27A9] = { unicodeslot=0x27A9, category='so', description='RIGHT-SHADED WHITE RIGHTWARDS ARROW' },
	[0x27AA] = { unicodeslot=0x27AA, category='so', description='LEFT-SHADED WHITE RIGHTWARDS ARROW' },
	[0x27AB] = { unicodeslot=0x27AB, category='so', description='BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW' },
	[0x27AC] = { unicodeslot=0x27AC, category='so', description='FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW' },
	[0x27AD] = { unicodeslot=0x27AD, category='so', description='HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW' },
	[0x27AE] = { unicodeslot=0x27AE, category='so', description='HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW' },
	[0x27AF] = { unicodeslot=0x27AF, category='so', description='NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW' },
	[0x27B1] = { unicodeslot=0x27B1, category='so', description='NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW' },
	[0x27B2] = { unicodeslot=0x27B2, category='so', description='CIRCLED HEAVY WHITE RIGHTWARDS ARROW' },
	[0x27B3] = { unicodeslot=0x27B3, category='so', description='WHITE-FEATHERED RIGHTWARDS ARROW' },
	[0x27B4] = { unicodeslot=0x27B4, category='so', description='BLACK-FEATHERED SOUTH EAST ARROW' },
	[0x27B5] = { unicodeslot=0x27B5, category='so', description='BLACK-FEATHERED RIGHTWARDS ARROW' },
	[0x27B6] = { unicodeslot=0x27B6, category='so', description='BLACK-FEATHERED NORTH EAST ARROW' },
	[0x27B7] = { unicodeslot=0x27B7, category='so', description='HEAVY BLACK-FEATHERED SOUTH EAST ARROW' },
	[0x27B8] = { unicodeslot=0x27B8, category='so', description='HEAVY BLACK-FEATHERED RIGHTWARDS ARROW' },
	[0x27B9] = { unicodeslot=0x27B9, category='so', description='HEAVY BLACK-FEATHERED NORTH EAST ARROW' },
	[0x27BA] = { unicodeslot=0x27BA, category='so', description='TEARDROP-BARBED RIGHTWARDS ARROW' },
	[0x27BB] = { unicodeslot=0x27BB, category='so', description='HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW' },
	[0x27BC] = { unicodeslot=0x27BC, category='so', description='WEDGE-TAILED RIGHTWARDS ARROW' },
	[0x27BD] = { unicodeslot=0x27BD, category='so', description='HEAVY WEDGE-TAILED RIGHTWARDS ARROW' },
	[0x27BE] = { unicodeslot=0x27BE, category='so', description='OPEN-OUTLINED RIGHTWARDS ARROW' },
	[0x27C0] = { unicodeslot=0x27C0, category='sm', description='THREE DIMENSIONAL ANGLE' },
	[0x27C1] = { unicodeslot=0x27C1, category='sm', description='WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE' },
	[0x27C2] = { unicodeslot=0x27C2, category='sm', description='PERPENDICULAR' },
	[0x27C3] = { unicodeslot=0x27C3, category='sm', description='OPEN SUBSET' },
	[0x27C4] = { unicodeslot=0x27C4, category='sm', description='OPEN SUPERSET' },
	[0x27C5] = { unicodeslot=0x27C5, category='ps', description='LEFT S-SHAPED BAG DELIMITER' },
	[0x27C6] = { unicodeslot=0x27C6, category='pe', description='RIGHT S-SHAPED BAG DELIMITER' },
	[0x27C7] = { unicodeslot=0x27C7, category='sm', description='OR WITH DOT INSIDE' },
	[0x27C8] = { unicodeslot=0x27C8, category='sm', description='REVERSE SOLIDUS PRECEDING SUBSET' },
	[0x27C9] = { unicodeslot=0x27C9, category='sm', description='SUPERSET PRECEDING SOLIDUS' },
	[0x27CA] = { unicodeslot=0x27CA, category='sm', description='VERTICAL BAR WITH HORIZONTAL STROKE' },
	[0x27D0] = { unicodeslot=0x27D0, category='sm', description='WHITE DIAMOND WITH CENTRED DOT' },
	[0x27D1] = { unicodeslot=0x27D1, category='sm', description='AND WITH DOT' },
	[0x27D2] = { unicodeslot=0x27D2, category='sm', description='ELEMENT OF OPENING UPWARDS' },
	[0x27D3] = { unicodeslot=0x27D3, category='sm', description='LOWER RIGHT CORNER WITH DOT' },
	[0x27D4] = { unicodeslot=0x27D4, category='sm', description='UPPER LEFT CORNER WITH DOT' },
	[0x27D5] = { unicodeslot=0x27D5, category='sm', description='LEFT OUTER JOIN' },
	[0x27D6] = { unicodeslot=0x27D6, category='sm', description='RIGHT OUTER JOIN' },
	[0x27D7] = { unicodeslot=0x27D7, category='sm', description='FULL OUTER JOIN' },
	[0x27D8] = { unicodeslot=0x27D8, category='sm', description='LARGE UP TACK' },
	[0x27D9] = { unicodeslot=0x27D9, category='sm', description='LARGE DOWN TACK' },
	[0x27DA] = { unicodeslot=0x27DA, category='sm', description='LEFT AND RIGHT DOUBLE TURNSTILE' },
	[0x27DB] = { unicodeslot=0x27DB, category='sm', description='LEFT AND RIGHT TACK' },
	[0x27DC] = { unicodeslot=0x27DC, category='sm', description='LEFT MULTIMAP' },
	[0x27DD] = { unicodeslot=0x27DD, category='sm', description='LONG RIGHT TACK' },
	[0x27DE] = { unicodeslot=0x27DE, category='sm', description='LONG LEFT TACK' },
	[0x27DF] = { unicodeslot=0x27DF, category='sm', description='UP TACK WITH CIRCLE ABOVE' },
	[0x27E0] = { unicodeslot=0x27E0, category='sm', description='LOZENGE DIVIDED BY HORIZONTAL RULE' },
	[0x27E1] = { unicodeslot=0x27E1, category='sm', description='WHITE CONCAVE-SIDED DIAMOND' },
	[0x27E2] = { unicodeslot=0x27E2, category='sm', description='WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK' },
	[0x27E3] = { unicodeslot=0x27E3, category='sm', description='WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK' },
	[0x27E4] = { unicodeslot=0x27E4, category='sm', description='WHITE SQUARE WITH LEFTWARDS TICK' },
	[0x27E5] = { unicodeslot=0x27E5, category='sm', description='WHITE SQUARE WITH RIGHTWARDS TICK' },
	[0x27E6] = { unicodeslot=0x27E6, category='ps', description='MATHEMATICAL LEFT WHITE SQUARE BRACKET' },
	[0x27E7] = { unicodeslot=0x27E7, category='pe', description='MATHEMATICAL RIGHT WHITE SQUARE BRACKET' },
	[0x27E8] = { unicodeslot=0x27E8, category='ps', description='MATHEMATICAL LEFT ANGLE BRACKET' },
	[0x27E9] = { unicodeslot=0x27E9, category='pe', description='MATHEMATICAL RIGHT ANGLE BRACKET' },
	[0x27EA] = { unicodeslot=0x27EA, category='ps', description='MATHEMATICAL LEFT DOUBLE ANGLE BRACKET' },
	[0x27EB] = { unicodeslot=0x27EB, category='pe', description='MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET' },
	[0x27F0] = { unicodeslot=0x27F0, category='sm', description='UPWARDS QUADRUPLE ARROW' },
	[0x27F1] = { unicodeslot=0x27F1, category='sm', description='DOWNWARDS QUADRUPLE ARROW' },
	[0x27F2] = { unicodeslot=0x27F2, category='sm', description='ANTICLOCKWISE GAPPED CIRCLE ARROW' },
	[0x27F3] = { unicodeslot=0x27F3, category='sm', description='CLOCKWISE GAPPED CIRCLE ARROW' },
	[0x27F4] = { unicodeslot=0x27F4, category='sm', description='RIGHT ARROW WITH CIRCLED PLUS' },
	[0x27F5] = { unicodeslot=0x27F5, category='sm', description='LONG LEFTWARDS ARROW' },
	[0x27F6] = { unicodeslot=0x27F6, category='sm', description='LONG RIGHTWARDS ARROW' },
	[0x27F7] = { unicodeslot=0x27F7, category='sm', description='LONG LEFT RIGHT ARROW' },
	[0x27F8] = { unicodeslot=0x27F8, category='sm', description='LONG LEFTWARDS DOUBLE ARROW' },
	[0x27F9] = { unicodeslot=0x27F9, category='sm', description='LONG RIGHTWARDS DOUBLE ARROW' },
	[0x27FA] = { unicodeslot=0x27FA, category='sm', description='LONG LEFT RIGHT DOUBLE ARROW' },
	[0x27FB] = { unicodeslot=0x27FB, category='sm', description='LONG LEFTWARDS ARROW FROM BAR' },
	[0x27FC] = { unicodeslot=0x27FC, category='sm', description='LONG RIGHTWARDS ARROW FROM BAR' },
	[0x27FD] = { unicodeslot=0x27FD, category='sm', description='LONG LEFTWARDS DOUBLE ARROW FROM BAR' },
	[0x27FE] = { unicodeslot=0x27FE, category='sm', description='LONG RIGHTWARDS DOUBLE ARROW FROM BAR' },
	[0x27FF] = { unicodeslot=0x27FF, category='sm', description='LONG RIGHTWARDS SQUIGGLE ARROW' },
	[0x2800] = { unicodeslot=0x2800, category='so', description='BRAILLE PATTERN BLANK' },
	[0x2801] = { unicodeslot=0x2801, category='so', description='BRAILLE PATTERN DOTS-1' },
	[0x2802] = { unicodeslot=0x2802, category='so', description='BRAILLE PATTERN DOTS-2' },
	[0x2803] = { unicodeslot=0x2803, category='so', description='BRAILLE PATTERN DOTS-12' },
	[0x2804] = { unicodeslot=0x2804, category='so', description='BRAILLE PATTERN DOTS-3' },
	[0x2805] = { unicodeslot=0x2805, category='so', description='BRAILLE PATTERN DOTS-13' },
	[0x2806] = { unicodeslot=0x2806, category='so', description='BRAILLE PATTERN DOTS-23' },
	[0x2807] = { unicodeslot=0x2807, category='so', description='BRAILLE PATTERN DOTS-123' },
	[0x2808] = { unicodeslot=0x2808, category='so', description='BRAILLE PATTERN DOTS-4' },
	[0x2809] = { unicodeslot=0x2809, category='so', description='BRAILLE PATTERN DOTS-14' },
	[0x280A] = { unicodeslot=0x280A, category='so', description='BRAILLE PATTERN DOTS-24' },
	[0x280B] = { unicodeslot=0x280B, category='so', description='BRAILLE PATTERN DOTS-124' },
	[0x280C] = { unicodeslot=0x280C, category='so', description='BRAILLE PATTERN DOTS-34' },
	[0x280D] = { unicodeslot=0x280D, category='so', description='BRAILLE PATTERN DOTS-134' },
	[0x280E] = { unicodeslot=0x280E, category='so', description='BRAILLE PATTERN DOTS-234' },
	[0x280F] = { unicodeslot=0x280F, category='so', description='BRAILLE PATTERN DOTS-1234' },
	[0x2810] = { unicodeslot=0x2810, category='so', description='BRAILLE PATTERN DOTS-5' },
	[0x2811] = { unicodeslot=0x2811, category='so', description='BRAILLE PATTERN DOTS-15' },
	[0x2812] = { unicodeslot=0x2812, category='so', description='BRAILLE PATTERN DOTS-25' },
	[0x2813] = { unicodeslot=0x2813, category='so', description='BRAILLE PATTERN DOTS-125' },
	[0x2814] = { unicodeslot=0x2814, category='so', description='BRAILLE PATTERN DOTS-35' },
	[0x2815] = { unicodeslot=0x2815, category='so', description='BRAILLE PATTERN DOTS-135' },
	[0x2816] = { unicodeslot=0x2816, category='so', description='BRAILLE PATTERN DOTS-235' },
	[0x2817] = { unicodeslot=0x2817, category='so', description='BRAILLE PATTERN DOTS-1235' },
	[0x2818] = { unicodeslot=0x2818, category='so', description='BRAILLE PATTERN DOTS-45' },
	[0x2819] = { unicodeslot=0x2819, category='so', description='BRAILLE PATTERN DOTS-145' },
	[0x281A] = { unicodeslot=0x281A, category='so', description='BRAILLE PATTERN DOTS-245' },
	[0x281B] = { unicodeslot=0x281B, category='so', description='BRAILLE PATTERN DOTS-1245' },
	[0x281C] = { unicodeslot=0x281C, category='so', description='BRAILLE PATTERN DOTS-345' },
	[0x281D] = { unicodeslot=0x281D, category='so', description='BRAILLE PATTERN DOTS-1345' },
	[0x281E] = { unicodeslot=0x281E, category='so', description='BRAILLE PATTERN DOTS-2345' },
	[0x281F] = { unicodeslot=0x281F, category='so', description='BRAILLE PATTERN DOTS-12345' },
	[0x2820] = { unicodeslot=0x2820, category='so', description='BRAILLE PATTERN DOTS-6' },
	[0x2821] = { unicodeslot=0x2821, category='so', description='BRAILLE PATTERN DOTS-16' },
	[0x2822] = { unicodeslot=0x2822, category='so', description='BRAILLE PATTERN DOTS-26' },
	[0x2823] = { unicodeslot=0x2823, category='so', description='BRAILLE PATTERN DOTS-126' },
	[0x2824] = { unicodeslot=0x2824, category='so', description='BRAILLE PATTERN DOTS-36' },
	[0x2825] = { unicodeslot=0x2825, category='so', description='BRAILLE PATTERN DOTS-136' },
	[0x2826] = { unicodeslot=0x2826, category='so', description='BRAILLE PATTERN DOTS-236' },
	[0x2827] = { unicodeslot=0x2827, category='so', description='BRAILLE PATTERN DOTS-1236' },
	[0x2828] = { unicodeslot=0x2828, category='so', description='BRAILLE PATTERN DOTS-46' },
	[0x2829] = { unicodeslot=0x2829, category='so', description='BRAILLE PATTERN DOTS-146' },
	[0x282A] = { unicodeslot=0x282A, category='so', description='BRAILLE PATTERN DOTS-246' },
	[0x282B] = { unicodeslot=0x282B, category='so', description='BRAILLE PATTERN DOTS-1246' },
	[0x282C] = { unicodeslot=0x282C, category='so', description='BRAILLE PATTERN DOTS-346' },
	[0x282D] = { unicodeslot=0x282D, category='so', description='BRAILLE PATTERN DOTS-1346' },
	[0x282E] = { unicodeslot=0x282E, category='so', description='BRAILLE PATTERN DOTS-2346' },
	[0x282F] = { unicodeslot=0x282F, category='so', description='BRAILLE PATTERN DOTS-12346' },
	[0x2830] = { unicodeslot=0x2830, category='so', description='BRAILLE PATTERN DOTS-56' },
	[0x2831] = { unicodeslot=0x2831, category='so', description='BRAILLE PATTERN DOTS-156' },
	[0x2832] = { unicodeslot=0x2832, category='so', description='BRAILLE PATTERN DOTS-256' },
	[0x2833] = { unicodeslot=0x2833, category='so', description='BRAILLE PATTERN DOTS-1256' },
	[0x2834] = { unicodeslot=0x2834, category='so', description='BRAILLE PATTERN DOTS-356' },
	[0x2835] = { unicodeslot=0x2835, category='so', description='BRAILLE PATTERN DOTS-1356' },
	[0x2836] = { unicodeslot=0x2836, category='so', description='BRAILLE PATTERN DOTS-2356' },
	[0x2837] = { unicodeslot=0x2837, category='so', description='BRAILLE PATTERN DOTS-12356' },
	[0x2838] = { unicodeslot=0x2838, category='so', description='BRAILLE PATTERN DOTS-456' },
	[0x2839] = { unicodeslot=0x2839, category='so', description='BRAILLE PATTERN DOTS-1456' },
	[0x283A] = { unicodeslot=0x283A, category='so', description='BRAILLE PATTERN DOTS-2456' },
	[0x283B] = { unicodeslot=0x283B, category='so', description='BRAILLE PATTERN DOTS-12456' },
	[0x283C] = { unicodeslot=0x283C, category='so', description='BRAILLE PATTERN DOTS-3456' },
	[0x283D] = { unicodeslot=0x283D, category='so', description='BRAILLE PATTERN DOTS-13456' },
	[0x283E] = { unicodeslot=0x283E, category='so', description='BRAILLE PATTERN DOTS-23456' },
	[0x283F] = { unicodeslot=0x283F, category='so', description='BRAILLE PATTERN DOTS-123456' },
	[0x2840] = { unicodeslot=0x2840, category='so', description='BRAILLE PATTERN DOTS-7' },
	[0x2841] = { unicodeslot=0x2841, category='so', description='BRAILLE PATTERN DOTS-17' },
	[0x2842] = { unicodeslot=0x2842, category='so', description='BRAILLE PATTERN DOTS-27' },
	[0x2843] = { unicodeslot=0x2843, category='so', description='BRAILLE PATTERN DOTS-127' },
	[0x2844] = { unicodeslot=0x2844, category='so', description='BRAILLE PATTERN DOTS-37' },
	[0x2845] = { unicodeslot=0x2845, category='so', description='BRAILLE PATTERN DOTS-137' },
	[0x2846] = { unicodeslot=0x2846, category='so', description='BRAILLE PATTERN DOTS-237' },
	[0x2847] = { unicodeslot=0x2847, category='so', description='BRAILLE PATTERN DOTS-1237' },
	[0x2848] = { unicodeslot=0x2848, category='so', description='BRAILLE PATTERN DOTS-47' },
	[0x2849] = { unicodeslot=0x2849, category='so', description='BRAILLE PATTERN DOTS-147' },
	[0x284A] = { unicodeslot=0x284A, category='so', description='BRAILLE PATTERN DOTS-247' },
	[0x284B] = { unicodeslot=0x284B, category='so', description='BRAILLE PATTERN DOTS-1247' },
	[0x284C] = { unicodeslot=0x284C, category='so', description='BRAILLE PATTERN DOTS-347' },
	[0x284D] = { unicodeslot=0x284D, category='so', description='BRAILLE PATTERN DOTS-1347' },
	[0x284E] = { unicodeslot=0x284E, category='so', description='BRAILLE PATTERN DOTS-2347' },
	[0x284F] = { unicodeslot=0x284F, category='so', description='BRAILLE PATTERN DOTS-12347' },
	[0x2850] = { unicodeslot=0x2850, category='so', description='BRAILLE PATTERN DOTS-57' },
	[0x2851] = { unicodeslot=0x2851, category='so', description='BRAILLE PATTERN DOTS-157' },
	[0x2852] = { unicodeslot=0x2852, category='so', description='BRAILLE PATTERN DOTS-257' },
	[0x2853] = { unicodeslot=0x2853, category='so', description='BRAILLE PATTERN DOTS-1257' },
	[0x2854] = { unicodeslot=0x2854, category='so', description='BRAILLE PATTERN DOTS-357' },
	[0x2855] = { unicodeslot=0x2855, category='so', description='BRAILLE PATTERN DOTS-1357' },
	[0x2856] = { unicodeslot=0x2856, category='so', description='BRAILLE PATTERN DOTS-2357' },
	[0x2857] = { unicodeslot=0x2857, category='so', description='BRAILLE PATTERN DOTS-12357' },
	[0x2858] = { unicodeslot=0x2858, category='so', description='BRAILLE PATTERN DOTS-457' },
	[0x2859] = { unicodeslot=0x2859, category='so', description='BRAILLE PATTERN DOTS-1457' },
	[0x285A] = { unicodeslot=0x285A, category='so', description='BRAILLE PATTERN DOTS-2457' },
	[0x285B] = { unicodeslot=0x285B, category='so', description='BRAILLE PATTERN DOTS-12457' },
	[0x285C] = { unicodeslot=0x285C, category='so', description='BRAILLE PATTERN DOTS-3457' },
	[0x285D] = { unicodeslot=0x285D, category='so', description='BRAILLE PATTERN DOTS-13457' },
	[0x285E] = { unicodeslot=0x285E, category='so', description='BRAILLE PATTERN DOTS-23457' },
	[0x285F] = { unicodeslot=0x285F, category='so', description='BRAILLE PATTERN DOTS-123457' },
	[0x2860] = { unicodeslot=0x2860, category='so', description='BRAILLE PATTERN DOTS-67' },
	[0x2861] = { unicodeslot=0x2861, category='so', description='BRAILLE PATTERN DOTS-167' },
	[0x2862] = { unicodeslot=0x2862, category='so', description='BRAILLE PATTERN DOTS-267' },
	[0x2863] = { unicodeslot=0x2863, category='so', description='BRAILLE PATTERN DOTS-1267' },
	[0x2864] = { unicodeslot=0x2864, category='so', description='BRAILLE PATTERN DOTS-367' },
	[0x2865] = { unicodeslot=0x2865, category='so', description='BRAILLE PATTERN DOTS-1367' },
	[0x2866] = { unicodeslot=0x2866, category='so', description='BRAILLE PATTERN DOTS-2367' },
	[0x2867] = { unicodeslot=0x2867, category='so', description='BRAILLE PATTERN DOTS-12367' },
	[0x2868] = { unicodeslot=0x2868, category='so', description='BRAILLE PATTERN DOTS-467' },
	[0x2869] = { unicodeslot=0x2869, category='so', description='BRAILLE PATTERN DOTS-1467' },
	[0x286A] = { unicodeslot=0x286A, category='so', description='BRAILLE PATTERN DOTS-2467' },
	[0x286B] = { unicodeslot=0x286B, category='so', description='BRAILLE PATTERN DOTS-12467' },
	[0x286C] = { unicodeslot=0x286C, category='so', description='BRAILLE PATTERN DOTS-3467' },
	[0x286D] = { unicodeslot=0x286D, category='so', description='BRAILLE PATTERN DOTS-13467' },
	[0x286E] = { unicodeslot=0x286E, category='so', description='BRAILLE PATTERN DOTS-23467' },
	[0x286F] = { unicodeslot=0x286F, category='so', description='BRAILLE PATTERN DOTS-123467' },
	[0x2870] = { unicodeslot=0x2870, category='so', description='BRAILLE PATTERN DOTS-567' },
	[0x2871] = { unicodeslot=0x2871, category='so', description='BRAILLE PATTERN DOTS-1567' },
	[0x2872] = { unicodeslot=0x2872, category='so', description='BRAILLE PATTERN DOTS-2567' },
	[0x2873] = { unicodeslot=0x2873, category='so', description='BRAILLE PATTERN DOTS-12567' },
	[0x2874] = { unicodeslot=0x2874, category='so', description='BRAILLE PATTERN DOTS-3567' },
	[0x2875] = { unicodeslot=0x2875, category='so', description='BRAILLE PATTERN DOTS-13567' },
	[0x2876] = { unicodeslot=0x2876, category='so', description='BRAILLE PATTERN DOTS-23567' },
	[0x2877] = { unicodeslot=0x2877, category='so', description='BRAILLE PATTERN DOTS-123567' },
	[0x2878] = { unicodeslot=0x2878, category='so', description='BRAILLE PATTERN DOTS-4567' },
	[0x2879] = { unicodeslot=0x2879, category='so', description='BRAILLE PATTERN DOTS-14567' },
	[0x287A] = { unicodeslot=0x287A, category='so', description='BRAILLE PATTERN DOTS-24567' },
	[0x287B] = { unicodeslot=0x287B, category='so', description='BRAILLE PATTERN DOTS-124567' },
	[0x287C] = { unicodeslot=0x287C, category='so', description='BRAILLE PATTERN DOTS-34567' },
	[0x287D] = { unicodeslot=0x287D, category='so', description='BRAILLE PATTERN DOTS-134567' },
	[0x287E] = { unicodeslot=0x287E, category='so', description='BRAILLE PATTERN DOTS-234567' },
	[0x287F] = { unicodeslot=0x287F, category='so', description='BRAILLE PATTERN DOTS-1234567' },
	[0x2880] = { unicodeslot=0x2880, category='so', description='BRAILLE PATTERN DOTS-8' },
	[0x2881] = { unicodeslot=0x2881, category='so', description='BRAILLE PATTERN DOTS-18' },
	[0x2882] = { unicodeslot=0x2882, category='so', description='BRAILLE PATTERN DOTS-28' },
	[0x2883] = { unicodeslot=0x2883, category='so', description='BRAILLE PATTERN DOTS-128' },
	[0x2884] = { unicodeslot=0x2884, category='so', description='BRAILLE PATTERN DOTS-38' },
	[0x2885] = { unicodeslot=0x2885, category='so', description='BRAILLE PATTERN DOTS-138' },
	[0x2886] = { unicodeslot=0x2886, category='so', description='BRAILLE PATTERN DOTS-238' },
	[0x2887] = { unicodeslot=0x2887, category='so', description='BRAILLE PATTERN DOTS-1238' },
	[0x2888] = { unicodeslot=0x2888, category='so', description='BRAILLE PATTERN DOTS-48' },
	[0x2889] = { unicodeslot=0x2889, category='so', description='BRAILLE PATTERN DOTS-148' },
	[0x288A] = { unicodeslot=0x288A, category='so', description='BRAILLE PATTERN DOTS-248' },
	[0x288B] = { unicodeslot=0x288B, category='so', description='BRAILLE PATTERN DOTS-1248' },
	[0x288C] = { unicodeslot=0x288C, category='so', description='BRAILLE PATTERN DOTS-348' },
	[0x288D] = { unicodeslot=0x288D, category='so', description='BRAILLE PATTERN DOTS-1348' },
	[0x288E] = { unicodeslot=0x288E, category='so', description='BRAILLE PATTERN DOTS-2348' },
	[0x288F] = { unicodeslot=0x288F, category='so', description='BRAILLE PATTERN DOTS-12348' },
	[0x2890] = { unicodeslot=0x2890, category='so', description='BRAILLE PATTERN DOTS-58' },
	[0x2891] = { unicodeslot=0x2891, category='so', description='BRAILLE PATTERN DOTS-158' },
	[0x2892] = { unicodeslot=0x2892, category='so', description='BRAILLE PATTERN DOTS-258' },
	[0x2893] = { unicodeslot=0x2893, category='so', description='BRAILLE PATTERN DOTS-1258' },
	[0x2894] = { unicodeslot=0x2894, category='so', description='BRAILLE PATTERN DOTS-358' },
	[0x2895] = { unicodeslot=0x2895, category='so', description='BRAILLE PATTERN DOTS-1358' },
	[0x2896] = { unicodeslot=0x2896, category='so', description='BRAILLE PATTERN DOTS-2358' },
	[0x2897] = { unicodeslot=0x2897, category='so', description='BRAILLE PATTERN DOTS-12358' },
	[0x2898] = { unicodeslot=0x2898, category='so', description='BRAILLE PATTERN DOTS-458' },
	[0x2899] = { unicodeslot=0x2899, category='so', description='BRAILLE PATTERN DOTS-1458' },
	[0x289A] = { unicodeslot=0x289A, category='so', description='BRAILLE PATTERN DOTS-2458' },
	[0x289B] = { unicodeslot=0x289B, category='so', description='BRAILLE PATTERN DOTS-12458' },
	[0x289C] = { unicodeslot=0x289C, category='so', description='BRAILLE PATTERN DOTS-3458' },
	[0x289D] = { unicodeslot=0x289D, category='so', description='BRAILLE PATTERN DOTS-13458' },
	[0x289E] = { unicodeslot=0x289E, category='so', description='BRAILLE PATTERN DOTS-23458' },
	[0x289F] = { unicodeslot=0x289F, category='so', description='BRAILLE PATTERN DOTS-123458' },
	[0x28A0] = { unicodeslot=0x28A0, category='so', description='BRAILLE PATTERN DOTS-68' },
	[0x28A1] = { unicodeslot=0x28A1, category='so', description='BRAILLE PATTERN DOTS-168' },
	[0x28A2] = { unicodeslot=0x28A2, category='so', description='BRAILLE PATTERN DOTS-268' },
	[0x28A3] = { unicodeslot=0x28A3, category='so', description='BRAILLE PATTERN DOTS-1268' },
	[0x28A4] = { unicodeslot=0x28A4, category='so', description='BRAILLE PATTERN DOTS-368' },
	[0x28A5] = { unicodeslot=0x28A5, category='so', description='BRAILLE PATTERN DOTS-1368' },
	[0x28A6] = { unicodeslot=0x28A6, category='so', description='BRAILLE PATTERN DOTS-2368' },
	[0x28A7] = { unicodeslot=0x28A7, category='so', description='BRAILLE PATTERN DOTS-12368' },
	[0x28A8] = { unicodeslot=0x28A8, category='so', description='BRAILLE PATTERN DOTS-468' },
	[0x28A9] = { unicodeslot=0x28A9, category='so', description='BRAILLE PATTERN DOTS-1468' },
	[0x28AA] = { unicodeslot=0x28AA, category='so', description='BRAILLE PATTERN DOTS-2468' },
	[0x28AB] = { unicodeslot=0x28AB, category='so', description='BRAILLE PATTERN DOTS-12468' },
	[0x28AC] = { unicodeslot=0x28AC, category='so', description='BRAILLE PATTERN DOTS-3468' },
	[0x28AD] = { unicodeslot=0x28AD, category='so', description='BRAILLE PATTERN DOTS-13468' },
	[0x28AE] = { unicodeslot=0x28AE, category='so', description='BRAILLE PATTERN DOTS-23468' },
	[0x28AF] = { unicodeslot=0x28AF, category='so', description='BRAILLE PATTERN DOTS-123468' },
	[0x28B0] = { unicodeslot=0x28B0, category='so', description='BRAILLE PATTERN DOTS-568' },
	[0x28B1] = { unicodeslot=0x28B1, category='so', description='BRAILLE PATTERN DOTS-1568' },
	[0x28B2] = { unicodeslot=0x28B2, category='so', description='BRAILLE PATTERN DOTS-2568' },
	[0x28B3] = { unicodeslot=0x28B3, category='so', description='BRAILLE PATTERN DOTS-12568' },
	[0x28B4] = { unicodeslot=0x28B4, category='so', description='BRAILLE PATTERN DOTS-3568' },
	[0x28B5] = { unicodeslot=0x28B5, category='so', description='BRAILLE PATTERN DOTS-13568' },
	[0x28B6] = { unicodeslot=0x28B6, category='so', description='BRAILLE PATTERN DOTS-23568' },
	[0x28B7] = { unicodeslot=0x28B7, category='so', description='BRAILLE PATTERN DOTS-123568' },
	[0x28B8] = { unicodeslot=0x28B8, category='so', description='BRAILLE PATTERN DOTS-4568' },
	[0x28B9] = { unicodeslot=0x28B9, category='so', description='BRAILLE PATTERN DOTS-14568' },
	[0x28BA] = { unicodeslot=0x28BA, category='so', description='BRAILLE PATTERN DOTS-24568' },
	[0x28BB] = { unicodeslot=0x28BB, category='so', description='BRAILLE PATTERN DOTS-124568' },
	[0x28BC] = { unicodeslot=0x28BC, category='so', description='BRAILLE PATTERN DOTS-34568' },
	[0x28BD] = { unicodeslot=0x28BD, category='so', description='BRAILLE PATTERN DOTS-134568' },
	[0x28BE] = { unicodeslot=0x28BE, category='so', description='BRAILLE PATTERN DOTS-234568' },
	[0x28BF] = { unicodeslot=0x28BF, category='so', description='BRAILLE PATTERN DOTS-1234568' },
	[0x28C0] = { unicodeslot=0x28C0, category='so', description='BRAILLE PATTERN DOTS-78' },
	[0x28C1] = { unicodeslot=0x28C1, category='so', description='BRAILLE PATTERN DOTS-178' },
	[0x28C2] = { unicodeslot=0x28C2, category='so', description='BRAILLE PATTERN DOTS-278' },
	[0x28C3] = { unicodeslot=0x28C3, category='so', description='BRAILLE PATTERN DOTS-1278' },
	[0x28C4] = { unicodeslot=0x28C4, category='so', description='BRAILLE PATTERN DOTS-378' },
	[0x28C5] = { unicodeslot=0x28C5, category='so', description='BRAILLE PATTERN DOTS-1378' },
	[0x28C6] = { unicodeslot=0x28C6, category='so', description='BRAILLE PATTERN DOTS-2378' },
	[0x28C7] = { unicodeslot=0x28C7, category='so', description='BRAILLE PATTERN DOTS-12378' },
	[0x28C8] = { unicodeslot=0x28C8, category='so', description='BRAILLE PATTERN DOTS-478' },
	[0x28C9] = { unicodeslot=0x28C9, category='so', description='BRAILLE PATTERN DOTS-1478' },
	[0x28CA] = { unicodeslot=0x28CA, category='so', description='BRAILLE PATTERN DOTS-2478' },
	[0x28CB] = { unicodeslot=0x28CB, category='so', description='BRAILLE PATTERN DOTS-12478' },
	[0x28CC] = { unicodeslot=0x28CC, category='so', description='BRAILLE PATTERN DOTS-3478' },
	[0x28CD] = { unicodeslot=0x28CD, category='so', description='BRAILLE PATTERN DOTS-13478' },
	[0x28CE] = { unicodeslot=0x28CE, category='so', description='BRAILLE PATTERN DOTS-23478' },
	[0x28CF] = { unicodeslot=0x28CF, category='so', description='BRAILLE PATTERN DOTS-123478' },
	[0x28D0] = { unicodeslot=0x28D0, category='so', description='BRAILLE PATTERN DOTS-578' },
	[0x28D1] = { unicodeslot=0x28D1, category='so', description='BRAILLE PATTERN DOTS-1578' },
	[0x28D2] = { unicodeslot=0x28D2, category='so', description='BRAILLE PATTERN DOTS-2578' },
	[0x28D3] = { unicodeslot=0x28D3, category='so', description='BRAILLE PATTERN DOTS-12578' },
	[0x28D4] = { unicodeslot=0x28D4, category='so', description='BRAILLE PATTERN DOTS-3578' },
	[0x28D5] = { unicodeslot=0x28D5, category='so', description='BRAILLE PATTERN DOTS-13578' },
	[0x28D6] = { unicodeslot=0x28D6, category='so', description='BRAILLE PATTERN DOTS-23578' },
	[0x28D7] = { unicodeslot=0x28D7, category='so', description='BRAILLE PATTERN DOTS-123578' },
	[0x28D8] = { unicodeslot=0x28D8, category='so', description='BRAILLE PATTERN DOTS-4578' },
	[0x28D9] = { unicodeslot=0x28D9, category='so', description='BRAILLE PATTERN DOTS-14578' },
	[0x28DA] = { unicodeslot=0x28DA, category='so', description='BRAILLE PATTERN DOTS-24578' },
	[0x28DB] = { unicodeslot=0x28DB, category='so', description='BRAILLE PATTERN DOTS-124578' },
	[0x28DC] = { unicodeslot=0x28DC, category='so', description='BRAILLE PATTERN DOTS-34578' },
	[0x28DD] = { unicodeslot=0x28DD, category='so', description='BRAILLE PATTERN DOTS-134578' },
	[0x28DE] = { unicodeslot=0x28DE, category='so', description='BRAILLE PATTERN DOTS-234578' },
	[0x28DF] = { unicodeslot=0x28DF, category='so', description='BRAILLE PATTERN DOTS-1234578' },
	[0x28E0] = { unicodeslot=0x28E0, category='so', description='BRAILLE PATTERN DOTS-678' },
	[0x28E1] = { unicodeslot=0x28E1, category='so', description='BRAILLE PATTERN DOTS-1678' },
	[0x28E2] = { unicodeslot=0x28E2, category='so', description='BRAILLE PATTERN DOTS-2678' },
	[0x28E3] = { unicodeslot=0x28E3, category='so', description='BRAILLE PATTERN DOTS-12678' },
	[0x28E4] = { unicodeslot=0x28E4, category='so', description='BRAILLE PATTERN DOTS-3678' },
	[0x28E5] = { unicodeslot=0x28E5, category='so', description='BRAILLE PATTERN DOTS-13678' },
	[0x28E6] = { unicodeslot=0x28E6, category='so', description='BRAILLE PATTERN DOTS-23678' },
	[0x28E7] = { unicodeslot=0x28E7, category='so', description='BRAILLE PATTERN DOTS-123678' },
	[0x28E8] = { unicodeslot=0x28E8, category='so', description='BRAILLE PATTERN DOTS-4678' },
	[0x28E9] = { unicodeslot=0x28E9, category='so', description='BRAILLE PATTERN DOTS-14678' },
	[0x28EA] = { unicodeslot=0x28EA, category='so', description='BRAILLE PATTERN DOTS-24678' },
	[0x28EB] = { unicodeslot=0x28EB, category='so', description='BRAILLE PATTERN DOTS-124678' },
	[0x28EC] = { unicodeslot=0x28EC, category='so', description='BRAILLE PATTERN DOTS-34678' },
	[0x28ED] = { unicodeslot=0x28ED, category='so', description='BRAILLE PATTERN DOTS-134678' },
	[0x28EE] = { unicodeslot=0x28EE, category='so', description='BRAILLE PATTERN DOTS-234678' },
	[0x28EF] = { unicodeslot=0x28EF, category='so', description='BRAILLE PATTERN DOTS-1234678' },
	[0x28F0] = { unicodeslot=0x28F0, category='so', description='BRAILLE PATTERN DOTS-5678' },
	[0x28F1] = { unicodeslot=0x28F1, category='so', description='BRAILLE PATTERN DOTS-15678' },
	[0x28F2] = { unicodeslot=0x28F2, category='so', description='BRAILLE PATTERN DOTS-25678' },
	[0x28F3] = { unicodeslot=0x28F3, category='so', description='BRAILLE PATTERN DOTS-125678' },
	[0x28F4] = { unicodeslot=0x28F4, category='so', description='BRAILLE PATTERN DOTS-35678' },
	[0x28F5] = { unicodeslot=0x28F5, category='so', description='BRAILLE PATTERN DOTS-135678' },
	[0x28F6] = { unicodeslot=0x28F6, category='so', description='BRAILLE PATTERN DOTS-235678' },
	[0x28F7] = { unicodeslot=0x28F7, category='so', description='BRAILLE PATTERN DOTS-1235678' },
	[0x28F8] = { unicodeslot=0x28F8, category='so', description='BRAILLE PATTERN DOTS-45678' },
	[0x28F9] = { unicodeslot=0x28F9, category='so', description='BRAILLE PATTERN DOTS-145678' },
	[0x28FA] = { unicodeslot=0x28FA, category='so', description='BRAILLE PATTERN DOTS-245678' },
	[0x28FB] = { unicodeslot=0x28FB, category='so', description='BRAILLE PATTERN DOTS-1245678' },
	[0x28FC] = { unicodeslot=0x28FC, category='so', description='BRAILLE PATTERN DOTS-345678' },
	[0x28FD] = { unicodeslot=0x28FD, category='so', description='BRAILLE PATTERN DOTS-1345678' },
	[0x28FE] = { unicodeslot=0x28FE, category='so', description='BRAILLE PATTERN DOTS-2345678' },
	[0x28FF] = { unicodeslot=0x28FF, category='so', description='BRAILLE PATTERN DOTS-12345678' },
	[0x2900] = { unicodeslot=0x2900, category='sm', description='RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE' },
	[0x2901] = { unicodeslot=0x2901, category='sm', description='RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE' },
	[0x2902] = { unicodeslot=0x2902, category='sm', description='LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE' },
	[0x2903] = { unicodeslot=0x2903, category='sm', description='RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE' },
	[0x2904] = { unicodeslot=0x2904, category='sm', description='LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE' },
	[0x2905] = { unicodeslot=0x2905, category='sm', description='RIGHTWARDS TWO-HEADED ARROW FROM BAR' },
	[0x2906] = { unicodeslot=0x2906, category='sm', description='LEFTWARDS DOUBLE ARROW FROM BAR' },
	[0x2907] = { unicodeslot=0x2907, category='sm', description='RIGHTWARDS DOUBLE ARROW FROM BAR' },
	[0x2908] = { unicodeslot=0x2908, category='sm', description='DOWNWARDS ARROW WITH HORIZONTAL STROKE' },
	[0x2909] = { unicodeslot=0x2909, category='sm', description='UPWARDS ARROW WITH HORIZONTAL STROKE' },
	[0x290A] = { unicodeslot=0x290A, category='sm', description='UPWARDS TRIPLE ARROW' },
	[0x290B] = { unicodeslot=0x290B, category='sm', description='DOWNWARDS TRIPLE ARROW' },
	[0x290C] = { unicodeslot=0x290C, category='sm', description='LEFTWARDS DOUBLE DASH ARROW' },
	[0x290D] = { unicodeslot=0x290D, category='sm', description='RIGHTWARDS DOUBLE DASH ARROW' },
	[0x290E] = { unicodeslot=0x290E, category='sm', description='LEFTWARDS TRIPLE DASH ARROW' },
	[0x290F] = { unicodeslot=0x290F, category='sm', description='RIGHTWARDS TRIPLE DASH ARROW' },
	[0x2910] = { unicodeslot=0x2910, category='sm', description='RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW' },
	[0x2911] = { unicodeslot=0x2911, category='sm', description='RIGHTWARDS ARROW WITH DOTTED STEM' },
	[0x2912] = { unicodeslot=0x2912, category='sm', description='UPWARDS ARROW TO BAR' },
	[0x2913] = { unicodeslot=0x2913, category='sm', description='DOWNWARDS ARROW TO BAR' },
	[0x2914] = { unicodeslot=0x2914, category='sm', description='RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE' },
	[0x2915] = { unicodeslot=0x2915, category='sm', description='RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE' },
	[0x2916] = { unicodeslot=0x2916, category='sm', description='RIGHTWARDS TWO-HEADED ARROW WITH TAIL' },
	[0x2917] = { unicodeslot=0x2917, category='sm', description='RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE' },
	[0x2918] = { unicodeslot=0x2918, category='sm', description='RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE' },
	[0x2919] = { unicodeslot=0x2919, category='sm', description='LEFTWARDS ARROW-TAIL' },
	[0x291A] = { unicodeslot=0x291A, category='sm', description='RIGHTWARDS ARROW-TAIL' },
	[0x291B] = { unicodeslot=0x291B, category='sm', description='LEFTWARDS DOUBLE ARROW-TAIL' },
	[0x291C] = { unicodeslot=0x291C, category='sm', description='RIGHTWARDS DOUBLE ARROW-TAIL' },
	[0x291D] = { unicodeslot=0x291D, category='sm', description='LEFTWARDS ARROW TO BLACK DIAMOND' },
	[0x291E] = { unicodeslot=0x291E, category='sm', description='RIGHTWARDS ARROW TO BLACK DIAMOND' },
	[0x291F] = { unicodeslot=0x291F, category='sm', description='LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND' },
	[0x2920] = { unicodeslot=0x2920, category='sm', description='RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND' },
	[0x2921] = { unicodeslot=0x2921, category='sm', description='NORTH WEST AND SOUTH EAST ARROW' },
	[0x2922] = { unicodeslot=0x2922, category='sm', description='NORTH EAST AND SOUTH WEST ARROW' },
	[0x2923] = { unicodeslot=0x2923, category='sm', description='NORTH WEST ARROW WITH HOOK' },
	[0x2924] = { unicodeslot=0x2924, category='sm', description='NORTH EAST ARROW WITH HOOK' },
	[0x2925] = { unicodeslot=0x2925, category='sm', description='SOUTH EAST ARROW WITH HOOK' },
	[0x2926] = { unicodeslot=0x2926, category='sm', description='SOUTH WEST ARROW WITH HOOK' },
	[0x2927] = { unicodeslot=0x2927, category='sm', description='NORTH WEST ARROW AND NORTH EAST ARROW' },
	[0x2928] = { unicodeslot=0x2928, category='sm', description='NORTH EAST ARROW AND SOUTH EAST ARROW' },
	[0x2929] = { unicodeslot=0x2929, category='sm', description='SOUTH EAST ARROW AND SOUTH WEST ARROW' },
	[0x292A] = { unicodeslot=0x292A, category='sm', description='SOUTH WEST ARROW AND NORTH WEST ARROW' },
	[0x292B] = { unicodeslot=0x292B, category='sm', description='RISING DIAGONAL CROSSING FALLING DIAGONAL' },
	[0x292C] = { unicodeslot=0x292C, category='sm', description='FALLING DIAGONAL CROSSING RISING DIAGONAL' },
	[0x292D] = { unicodeslot=0x292D, category='sm', description='SOUTH EAST ARROW CROSSING NORTH EAST ARROW' },
	[0x292E] = { unicodeslot=0x292E, category='sm', description='NORTH EAST ARROW CROSSING SOUTH EAST ARROW' },
	[0x292F] = { unicodeslot=0x292F, category='sm', description='FALLING DIAGONAL CROSSING NORTH EAST ARROW' },
	[0x2930] = { unicodeslot=0x2930, category='sm', description='RISING DIAGONAL CROSSING SOUTH EAST ARROW' },
	[0x2931] = { unicodeslot=0x2931, category='sm', description='NORTH EAST ARROW CROSSING NORTH WEST ARROW' },
	[0x2932] = { unicodeslot=0x2932, category='sm', description='NORTH WEST ARROW CROSSING NORTH EAST ARROW' },
	[0x2933] = { unicodeslot=0x2933, category='sm', description='WAVE ARROW POINTING DIRECTLY RIGHT' },
	[0x2934] = { unicodeslot=0x2934, category='sm', description='ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS' },
	[0x2935] = { unicodeslot=0x2935, category='sm', description='ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS' },
	[0x2936] = { unicodeslot=0x2936, category='sm', description='ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS' },
	[0x2937] = { unicodeslot=0x2937, category='sm', description='ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS' },
	[0x2938] = { unicodeslot=0x2938, category='sm', description='RIGHT-SIDE ARC CLOCKWISE ARROW' },
	[0x2939] = { unicodeslot=0x2939, category='sm', description='LEFT-SIDE ARC ANTICLOCKWISE ARROW' },
	[0x293A] = { unicodeslot=0x293A, category='sm', description='TOP ARC ANTICLOCKWISE ARROW' },
	[0x293B] = { unicodeslot=0x293B, category='sm', description='BOTTOM ARC ANTICLOCKWISE ARROW' },
	[0x293C] = { unicodeslot=0x293C, category='sm', description='TOP ARC CLOCKWISE ARROW WITH MINUS' },
	[0x293D] = { unicodeslot=0x293D, category='sm', description='TOP ARC ANTICLOCKWISE ARROW WITH PLUS' },
	[0x293E] = { unicodeslot=0x293E, category='sm', description='LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW' },
	[0x293F] = { unicodeslot=0x293F, category='sm', description='LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW' },
	[0x2940] = { unicodeslot=0x2940, category='sm', description='ANTICLOCKWISE CLOSED CIRCLE ARROW' },
	[0x2941] = { unicodeslot=0x2941, category='sm', description='CLOCKWISE CLOSED CIRCLE ARROW' },
	[0x2942] = { unicodeslot=0x2942, category='sm', description='RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW' },
	[0x2943] = { unicodeslot=0x2943, category='sm', description='LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW' },
	[0x2944] = { unicodeslot=0x2944, category='sm', description='SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW' },
	[0x2945] = { unicodeslot=0x2945, category='sm', description='RIGHTWARDS ARROW WITH PLUS BELOW' },
	[0x2946] = { unicodeslot=0x2946, category='sm', description='LEFTWARDS ARROW WITH PLUS BELOW' },
	[0x2947] = { unicodeslot=0x2947, category='sm', description='RIGHTWARDS ARROW THROUGH X' },
	[0x2948] = { unicodeslot=0x2948, category='sm', description='LEFT RIGHT ARROW THROUGH SMALL CIRCLE' },
	[0x2949] = { unicodeslot=0x2949, category='sm', description='UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE' },
	[0x294A] = { unicodeslot=0x294A, category='sm', description='LEFT BARB UP RIGHT BARB DOWN HARPOON' },
	[0x294B] = { unicodeslot=0x294B, category='sm', description='LEFT BARB DOWN RIGHT BARB UP HARPOON' },
	[0x294C] = { unicodeslot=0x294C, category='sm', description='UP BARB RIGHT DOWN BARB LEFT HARPOON' },
	[0x294D] = { unicodeslot=0x294D, category='sm', description='UP BARB LEFT DOWN BARB RIGHT HARPOON' },
	[0x294E] = { unicodeslot=0x294E, category='sm', description='LEFT BARB UP RIGHT BARB UP HARPOON' },
	[0x294F] = { unicodeslot=0x294F, category='sm', description='UP BARB RIGHT DOWN BARB RIGHT HARPOON' },
	[0x2950] = { unicodeslot=0x2950, category='sm', description='LEFT BARB DOWN RIGHT BARB DOWN HARPOON' },
	[0x2951] = { unicodeslot=0x2951, category='sm', description='UP BARB LEFT DOWN BARB LEFT HARPOON' },
	[0x2952] = { unicodeslot=0x2952, category='sm', description='LEFTWARDS HARPOON WITH BARB UP TO BAR' },
	[0x2953] = { unicodeslot=0x2953, category='sm', description='RIGHTWARDS HARPOON WITH BARB UP TO BAR' },
	[0x2954] = { unicodeslot=0x2954, category='sm', description='UPWARDS HARPOON WITH BARB RIGHT TO BAR' },
	[0x2955] = { unicodeslot=0x2955, category='sm', description='DOWNWARDS HARPOON WITH BARB RIGHT TO BAR' },
	[0x2956] = { unicodeslot=0x2956, category='sm', description='LEFTWARDS HARPOON WITH BARB DOWN TO BAR' },
	[0x2957] = { unicodeslot=0x2957, category='sm', description='RIGHTWARDS HARPOON WITH BARB DOWN TO BAR' },
	[0x2958] = { unicodeslot=0x2958, category='sm', description='UPWARDS HARPOON WITH BARB LEFT TO BAR' },
	[0x2959] = { unicodeslot=0x2959, category='sm', description='DOWNWARDS HARPOON WITH BARB LEFT TO BAR' },
	[0x295A] = { unicodeslot=0x295A, category='sm', description='LEFTWARDS HARPOON WITH BARB UP FROM BAR' },
	[0x295B] = { unicodeslot=0x295B, category='sm', description='RIGHTWARDS HARPOON WITH BARB UP FROM BAR' },
	[0x295C] = { unicodeslot=0x295C, category='sm', description='UPWARDS HARPOON WITH BARB RIGHT FROM BAR' },
	[0x295D] = { unicodeslot=0x295D, category='sm', description='DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR' },
	[0x295E] = { unicodeslot=0x295E, category='sm', description='LEFTWARDS HARPOON WITH BARB DOWN FROM BAR' },
	[0x295F] = { unicodeslot=0x295F, category='sm', description='RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR' },
	[0x2960] = { unicodeslot=0x2960, category='sm', description='UPWARDS HARPOON WITH BARB LEFT FROM BAR' },
	[0x2961] = { unicodeslot=0x2961, category='sm', description='DOWNWARDS HARPOON WITH BARB LEFT FROM BAR' },
	[0x2962] = { unicodeslot=0x2962, category='sm', description='LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN' },
	[0x2963] = { unicodeslot=0x2963, category='sm', description='UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT' },
	[0x2964] = { unicodeslot=0x2964, category='sm', description='RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN' },
	[0x2965] = { unicodeslot=0x2965, category='sm', description='DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT' },
	[0x2966] = { unicodeslot=0x2966, category='sm', description='LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP' },
	[0x2967] = { unicodeslot=0x2967, category='sm', description='LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN' },
	[0x2968] = { unicodeslot=0x2968, category='sm', description='RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP' },
	[0x2969] = { unicodeslot=0x2969, category='sm', description='RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN' },
	[0x296A] = { unicodeslot=0x296A, category='sm', description='LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH' },
	[0x296B] = { unicodeslot=0x296B, category='sm', description='LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH' },
	[0x296C] = { unicodeslot=0x296C, category='sm', description='RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH' },
	[0x296D] = { unicodeslot=0x296D, category='sm', description='RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH' },
	[0x296E] = { unicodeslot=0x296E, category='sm', description='UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT' },
	[0x296F] = { unicodeslot=0x296F, category='sm', description='DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT' },
	[0x2970] = { unicodeslot=0x2970, category='sm', description='RIGHT DOUBLE ARROW WITH ROUNDED HEAD' },
	[0x2971] = { unicodeslot=0x2971, category='sm', description='EQUALS SIGN ABOVE RIGHTWARDS ARROW' },
	[0x2972] = { unicodeslot=0x2972, category='sm', description='TILDE OPERATOR ABOVE RIGHTWARDS ARROW' },
	[0x2973] = { unicodeslot=0x2973, category='sm', description='LEFTWARDS ARROW ABOVE TILDE OPERATOR' },
	[0x2974] = { unicodeslot=0x2974, category='sm', description='RIGHTWARDS ARROW ABOVE TILDE OPERATOR' },
	[0x2975] = { unicodeslot=0x2975, category='sm', description='RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO' },
	[0x2976] = { unicodeslot=0x2976, category='sm', description='LESS-THAN ABOVE LEFTWARDS ARROW' },
	[0x2977] = { unicodeslot=0x2977, category='sm', description='LEFTWARDS ARROW THROUGH LESS-THAN' },
	[0x2978] = { unicodeslot=0x2978, category='sm', description='GREATER-THAN ABOVE RIGHTWARDS ARROW' },
	[0x2979] = { unicodeslot=0x2979, category='sm', description='SUBSET ABOVE RIGHTWARDS ARROW' },
	[0x297A] = { unicodeslot=0x297A, category='sm', description='LEFTWARDS ARROW THROUGH SUBSET' },
	[0x297B] = { unicodeslot=0x297B, category='sm', description='SUPERSET ABOVE LEFTWARDS ARROW' },
	[0x297C] = { unicodeslot=0x297C, category='sm', description='LEFT FISH TAIL' },
	[0x297D] = { unicodeslot=0x297D, category='sm', description='RIGHT FISH TAIL' },
	[0x297E] = { unicodeslot=0x297E, category='sm', description='UP FISH TAIL' },
	[0x297F] = { unicodeslot=0x297F, category='sm', description='DOWN FISH TAIL' },
	[0x2980] = { unicodeslot=0x2980, category='sm', description='TRIPLE VERTICAL BAR DELIMITER' },
	[0x2981] = { unicodeslot=0x2981, category='sm', description='Z NOTATION SPOT' },
	[0x2982] = { unicodeslot=0x2982, category='sm', description='Z NOTATION TYPE COLON' },
	[0x2983] = { unicodeslot=0x2983, category='ps', description='LEFT WHITE CURLY BRACKET' },
	[0x2984] = { unicodeslot=0x2984, category='pe', description='RIGHT WHITE CURLY BRACKET' },
	[0x2985] = { unicodeslot=0x2985, category='ps', description='LEFT WHITE PARENTHESIS' },
	[0x2986] = { unicodeslot=0x2986, category='pe', description='RIGHT WHITE PARENTHESIS' },
	[0x2987] = { unicodeslot=0x2987, category='ps', description='Z NOTATION LEFT IMAGE BRACKET' },
	[0x2988] = { unicodeslot=0x2988, category='pe', description='Z NOTATION RIGHT IMAGE BRACKET' },
	[0x2989] = { unicodeslot=0x2989, category='ps', description='Z NOTATION LEFT BINDING BRACKET' },
	[0x298A] = { unicodeslot=0x298A, category='pe', description='Z NOTATION RIGHT BINDING BRACKET' },
	[0x298B] = { unicodeslot=0x298B, category='ps', description='LEFT SQUARE BRACKET WITH UNDERBAR' },
	[0x298C] = { unicodeslot=0x298C, category='pe', description='RIGHT SQUARE BRACKET WITH UNDERBAR' },
	[0x298D] = { unicodeslot=0x298D, category='ps', description='LEFT SQUARE BRACKET WITH TICK IN TOP CORNER' },
	[0x298E] = { unicodeslot=0x298E, category='pe', description='RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER' },
	[0x298F] = { unicodeslot=0x298F, category='ps', description='LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER' },
	[0x2990] = { unicodeslot=0x2990, category='pe', description='RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER' },
	[0x2991] = { unicodeslot=0x2991, category='ps', description='LEFT ANGLE BRACKET WITH DOT' },
	[0x2992] = { unicodeslot=0x2992, category='pe', description='RIGHT ANGLE BRACKET WITH DOT' },
	[0x2993] = { unicodeslot=0x2993, category='ps', description='LEFT ARC LESS-THAN BRACKET' },
	[0x2994] = { unicodeslot=0x2994, category='pe', description='RIGHT ARC GREATER-THAN BRACKET' },
	[0x2995] = { unicodeslot=0x2995, category='ps', description='DOUBLE LEFT ARC GREATER-THAN BRACKET' },
	[0x2996] = { unicodeslot=0x2996, category='pe', description='DOUBLE RIGHT ARC LESS-THAN BRACKET' },
	[0x2997] = { unicodeslot=0x2997, category='ps', description='LEFT BLACK TORTOISE SHELL BRACKET' },
	[0x2998] = { unicodeslot=0x2998, category='pe', description='RIGHT BLACK TORTOISE SHELL BRACKET' },
	[0x2999] = { unicodeslot=0x2999, category='sm', description='DOTTED FENCE' },
	[0x299A] = { unicodeslot=0x299A, category='sm', description='VERTICAL ZIGZAG LINE' },
	[0x299B] = { unicodeslot=0x299B, category='sm', description='MEASURED ANGLE OPENING LEFT' },
	[0x299C] = { unicodeslot=0x299C, category='sm', description='RIGHT ANGLE VARIANT WITH SQUARE' },
	[0x299D] = { unicodeslot=0x299D, category='sm', description='MEASURED RIGHT ANGLE WITH DOT' },
	[0x299E] = { unicodeslot=0x299E, category='sm', description='ANGLE WITH S INSIDE' },
	[0x299F] = { unicodeslot=0x299F, category='sm', description='ACUTE ANGLE' },
	[0x29A0] = { unicodeslot=0x29A0, category='sm', description='SPHERICAL ANGLE OPENING LEFT' },
	[0x29A1] = { unicodeslot=0x29A1, category='sm', description='SPHERICAL ANGLE OPENING UP' },
	[0x29A2] = { unicodeslot=0x29A2, category='sm', description='TURNED ANGLE' },
	[0x29A3] = { unicodeslot=0x29A3, category='sm', description='REVERSED ANGLE' },
	[0x29A4] = { unicodeslot=0x29A4, category='sm', description='ANGLE WITH UNDERBAR' },
	[0x29A5] = { unicodeslot=0x29A5, category='sm', description='REVERSED ANGLE WITH UNDERBAR' },
	[0x29A6] = { unicodeslot=0x29A6, category='sm', description='OBLIQUE ANGLE OPENING UP' },
	[0x29A7] = { unicodeslot=0x29A7, category='sm', description='OBLIQUE ANGLE OPENING DOWN' },
	[0x29A8] = { unicodeslot=0x29A8, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT' },
	[0x29A9] = { unicodeslot=0x29A9, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT' },
	[0x29AA] = { unicodeslot=0x29AA, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT' },
	[0x29AB] = { unicodeslot=0x29AB, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT' },
	[0x29AC] = { unicodeslot=0x29AC, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP' },
	[0x29AD] = { unicodeslot=0x29AD, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP' },
	[0x29AE] = { unicodeslot=0x29AE, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN' },
	[0x29AF] = { unicodeslot=0x29AF, category='sm', description='MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN' },
	[0x29B0] = { unicodeslot=0x29B0, category='sm', description='REVERSED EMPTY SET' },
	[0x29B1] = { unicodeslot=0x29B1, category='sm', description='EMPTY SET WITH OVERBAR' },
	[0x29B2] = { unicodeslot=0x29B2, category='sm', description='EMPTY SET WITH SMALL CIRCLE ABOVE' },
	[0x29B3] = { unicodeslot=0x29B3, category='sm', description='EMPTY SET WITH RIGHT ARROW ABOVE' },
	[0x29B4] = { unicodeslot=0x29B4, category='sm', description='EMPTY SET WITH LEFT ARROW ABOVE' },
	[0x29B5] = { unicodeslot=0x29B5, category='sm', description='CIRCLE WITH HORIZONTAL BAR' },
	[0x29B6] = { unicodeslot=0x29B6, category='sm', description='CIRCLED VERTICAL BAR' },
	[0x29B7] = { unicodeslot=0x29B7, category='sm', description='CIRCLED PARALLEL' },
	[0x29B8] = { unicodeslot=0x29B8, category='sm', description='CIRCLED REVERSE SOLIDUS' },
	[0x29B9] = { unicodeslot=0x29B9, category='sm', description='CIRCLED PERPENDICULAR' },
	[0x29BA] = { unicodeslot=0x29BA, category='sm', description='CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR' },
	[0x29BB] = { unicodeslot=0x29BB, category='sm', description='CIRCLE WITH SUPERIMPOSED X' },
	[0x29BC] = { unicodeslot=0x29BC, category='sm', description='CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN' },
	[0x29BD] = { unicodeslot=0x29BD, category='sm', description='UP ARROW THROUGH CIRCLE' },
	[0x29BE] = { unicodeslot=0x29BE, category='sm', description='CIRCLED WHITE BULLET' },
	[0x29BF] = { unicodeslot=0x29BF, category='sm', description='CIRCLED BULLET' },
	[0x29C0] = { unicodeslot=0x29C0, category='sm', description='CIRCLED LESS-THAN' },
	[0x29C1] = { unicodeslot=0x29C1, category='sm', description='CIRCLED GREATER-THAN' },
	[0x29C2] = { unicodeslot=0x29C2, category='sm', description='CIRCLE WITH SMALL CIRCLE TO THE RIGHT' },
	[0x29C3] = { unicodeslot=0x29C3, category='sm', description='CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT' },
	[0x29C4] = { unicodeslot=0x29C4, category='sm', description='SQUARED RISING DIAGONAL SLASH' },
	[0x29C5] = { unicodeslot=0x29C5, category='sm', description='SQUARED FALLING DIAGONAL SLASH' },
	[0x29C6] = { unicodeslot=0x29C6, category='sm', description='SQUARED ASTERISK' },
	[0x29C7] = { unicodeslot=0x29C7, category='sm', description='SQUARED SMALL CIRCLE' },
	[0x29C8] = { unicodeslot=0x29C8, category='sm', description='SQUARED SQUARE' },
	[0x29C9] = { unicodeslot=0x29C9, category='sm', description='TWO JOINED SQUARES' },
	[0x29CA] = { unicodeslot=0x29CA, category='sm', description='TRIANGLE WITH DOT ABOVE' },
	[0x29CB] = { unicodeslot=0x29CB, category='sm', description='TRIANGLE WITH UNDERBAR' },
	[0x29CC] = { unicodeslot=0x29CC, category='sm', description='S IN TRIANGLE' },
	[0x29CD] = { unicodeslot=0x29CD, category='sm', description='TRIANGLE WITH SERIFS AT BOTTOM' },
	[0x29CE] = { unicodeslot=0x29CE, category='sm', description='RIGHT TRIANGLE ABOVE LEFT TRIANGLE' },
	[0x29CF] = { unicodeslot=0x29CF, category='sm', description='LEFT TRIANGLE BESIDE VERTICAL BAR' },
	[0x29D0] = { unicodeslot=0x29D0, category='sm', description='VERTICAL BAR BESIDE RIGHT TRIANGLE' },
	[0x29D1] = { unicodeslot=0x29D1, category='sm', description='BOWTIE WITH LEFT HALF BLACK' },
	[0x29D2] = { unicodeslot=0x29D2, category='sm', description='BOWTIE WITH RIGHT HALF BLACK' },
	[0x29D3] = { unicodeslot=0x29D3, category='sm', description='BLACK BOWTIE' },
	[0x29D4] = { unicodeslot=0x29D4, category='sm', description='TIMES WITH LEFT HALF BLACK' },
	[0x29D5] = { unicodeslot=0x29D5, category='sm', description='TIMES WITH RIGHT HALF BLACK' },
	[0x29D6] = { unicodeslot=0x29D6, category='sm', description='WHITE HOURGLASS' },
	[0x29D7] = { unicodeslot=0x29D7, category='sm', description='BLACK HOURGLASS' },
	[0x29D8] = { unicodeslot=0x29D8, category='ps', description='LEFT WIGGLY FENCE' },
	[0x29D9] = { unicodeslot=0x29D9, category='pe', description='RIGHT WIGGLY FENCE' },
	[0x29DA] = { unicodeslot=0x29DA, category='ps', description='LEFT DOUBLE WIGGLY FENCE' },
	[0x29DB] = { unicodeslot=0x29DB, category='pe', description='RIGHT DOUBLE WIGGLY FENCE' },
	[0x29DC] = { unicodeslot=0x29DC, category='sm', description='INCOMPLETE INFINITY' },
	[0x29DD] = { unicodeslot=0x29DD, category='sm', description='TIE OVER INFINITY' },
	[0x29DE] = { unicodeslot=0x29DE, category='sm', description='INFINITY NEGATED WITH VERTICAL BAR' },
	[0x29DF] = { unicodeslot=0x29DF, category='sm', description='DOUBLE-ENDED MULTIMAP' },
	[0x29E0] = { unicodeslot=0x29E0, category='sm', description='SQUARE WITH CONTOURED OUTLINE' },
	[0x29E1] = { unicodeslot=0x29E1, category='sm', description='INCREASES AS' },
	[0x29E2] = { unicodeslot=0x29E2, category='sm', description='SHUFFLE PRODUCT' },
	[0x29E3] = { unicodeslot=0x29E3, category='sm', description='EQUALS SIGN AND SLANTED PARALLEL' },
	[0x29E4] = { unicodeslot=0x29E4, category='sm', description='EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE' },
	[0x29E5] = { unicodeslot=0x29E5, category='sm', description='IDENTICAL TO AND SLANTED PARALLEL' },
	[0x29E6] = { unicodeslot=0x29E6, category='sm', description='GLEICH STARK' },
	[0x29E7] = { unicodeslot=0x29E7, category='sm', description='THERMODYNAMIC' },
	[0x29E8] = { unicodeslot=0x29E8, category='sm', description='DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK' },
	[0x29E9] = { unicodeslot=0x29E9, category='sm', description='DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK' },
	[0x29EA] = { unicodeslot=0x29EA, category='sm', description='BLACK DIAMOND WITH DOWN ARROW' },
	[0x29EB] = { unicodeslot=0x29EB, category='sm', description='BLACK LOZENGE' },
	[0x29EC] = { unicodeslot=0x29EC, category='sm', description='WHITE CIRCLE WITH DOWN ARROW' },
	[0x29ED] = { unicodeslot=0x29ED, category='sm', description='BLACK CIRCLE WITH DOWN ARROW' },
	[0x29EE] = { unicodeslot=0x29EE, category='sm', description='ERROR-BARRED WHITE SQUARE' },
	[0x29EF] = { unicodeslot=0x29EF, category='sm', description='ERROR-BARRED BLACK SQUARE' },
	[0x29F0] = { unicodeslot=0x29F0, category='sm', description='ERROR-BARRED WHITE DIAMOND' },
	[0x29F1] = { unicodeslot=0x29F1, category='sm', description='ERROR-BARRED BLACK DIAMOND' },
	[0x29F2] = { unicodeslot=0x29F2, category='sm', description='ERROR-BARRED WHITE CIRCLE' },
	[0x29F3] = { unicodeslot=0x29F3, category='sm', description='ERROR-BARRED BLACK CIRCLE' },
	[0x29F4] = { unicodeslot=0x29F4, category='sm', description='RULE-DELAYED' },
	[0x29F5] = { unicodeslot=0x29F5, category='sm', description='REVERSE SOLIDUS OPERATOR' },
	[0x29F6] = { unicodeslot=0x29F6, category='sm', description='SOLIDUS WITH OVERBAR' },
	[0x29F7] = { unicodeslot=0x29F7, category='sm', description='REVERSE SOLIDUS WITH HORIZONTAL STROKE' },
	[0x29F8] = { unicodeslot=0x29F8, category='sm', description='BIG SOLIDUS' },
	[0x29F9] = { unicodeslot=0x29F9, category='sm', description='BIG REVERSE SOLIDUS' },
	[0x29FA] = { unicodeslot=0x29FA, category='sm', description='DOUBLE PLUS' },
	[0x29FB] = { unicodeslot=0x29FB, category='sm', description='TRIPLE PLUS' },
	[0x29FC] = { unicodeslot=0x29FC, category='ps', description='LEFT-POINTING CURVED ANGLE BRACKET' },
	[0x29FD] = { unicodeslot=0x29FD, category='pe', description='RIGHT-POINTING CURVED ANGLE BRACKET' },
	[0x29FE] = { unicodeslot=0x29FE, category='sm', description='TINY' },
	[0x29FF] = { unicodeslot=0x29FF, category='sm', description='MINY' },
	[0x2A00] = { unicodeslot=0x2A00, category='sm', description='N-ARY CIRCLED DOT OPERATOR' },
	[0x2A01] = { unicodeslot=0x2A01, category='sm', description='N-ARY CIRCLED PLUS OPERATOR' },
	[0x2A02] = { unicodeslot=0x2A02, category='sm', description='N-ARY CIRCLED TIMES OPERATOR' },
	[0x2A03] = { unicodeslot=0x2A03, category='sm', description='N-ARY UNION OPERATOR WITH DOT' },
	[0x2A04] = { unicodeslot=0x2A04, category='sm', description='N-ARY UNION OPERATOR WITH PLUS' },
	[0x2A05] = { unicodeslot=0x2A05, category='sm', description='N-ARY SQUARE INTERSECTION OPERATOR' },
	[0x2A06] = { unicodeslot=0x2A06, category='sm', description='N-ARY SQUARE UNION OPERATOR' },
	[0x2A07] = { unicodeslot=0x2A07, category='sm', description='TWO LOGICAL AND OPERATOR' },
	[0x2A08] = { unicodeslot=0x2A08, category='sm', description='TWO LOGICAL OR OPERATOR' },
	[0x2A09] = { unicodeslot=0x2A09, category='sm', description='N-ARY TIMES OPERATOR' },
	[0x2A0A] = { unicodeslot=0x2A0A, category='sm', description='MODULO TWO SUM' },
	[0x2A0B] = { unicodeslot=0x2A0B, category='sm', description='SUMMATION WITH INTEGRAL' },
	[0x2A0C] = { unicodeslot=0x2A0C, category='sm', description='QUADRUPLE INTEGRAL OPERATOR', specials={'compat',0x222B,0x222B,0x222B,0x222B} },
	[0x2A0D] = { unicodeslot=0x2A0D, category='sm', description='FINITE PART INTEGRAL' },
	[0x2A0E] = { unicodeslot=0x2A0E, category='sm', description='INTEGRAL WITH DOUBLE STROKE' },
	[0x2A0F] = { unicodeslot=0x2A0F, category='sm', description='INTEGRAL AVERAGE WITH SLASH' },
	[0x2A10] = { unicodeslot=0x2A10, category='sm', description='CIRCULATION FUNCTION' },
	[0x2A11] = { unicodeslot=0x2A11, category='sm', description='ANTICLOCKWISE INTEGRATION' },
	[0x2A12] = { unicodeslot=0x2A12, category='sm', description='LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE' },
	[0x2A13] = { unicodeslot=0x2A13, category='sm', description='LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE' },
	[0x2A14] = { unicodeslot=0x2A14, category='sm', description='LINE INTEGRATION NOT INCLUDING THE POLE' },
	[0x2A15] = { unicodeslot=0x2A15, category='sm', description='INTEGRAL AROUND A POINT OPERATOR' },
	[0x2A16] = { unicodeslot=0x2A16, category='sm', description='QUATERNION INTEGRAL OPERATOR' },
	[0x2A17] = { unicodeslot=0x2A17, category='sm', description='INTEGRAL WITH LEFTWARDS ARROW WITH HOOK' },
	[0x2A18] = { unicodeslot=0x2A18, category='sm', description='INTEGRAL WITH TIMES SIGN' },
	[0x2A19] = { unicodeslot=0x2A19, category='sm', description='INTEGRAL WITH INTERSECTION' },
	[0x2A1A] = { unicodeslot=0x2A1A, category='sm', description='INTEGRAL WITH UNION' },
	[0x2A1B] = { unicodeslot=0x2A1B, category='sm', description='INTEGRAL WITH OVERBAR' },
	[0x2A1C] = { unicodeslot=0x2A1C, category='sm', description='INTEGRAL WITH UNDERBAR' },
	[0x2A1D] = { unicodeslot=0x2A1D, category='sm', description='JOIN' },
	[0x2A1E] = { unicodeslot=0x2A1E, category='sm', description='LARGE LEFT TRIANGLE OPERATOR' },
	[0x2A1F] = { unicodeslot=0x2A1F, category='sm', description='Z NOTATION SCHEMA COMPOSITION' },
	[0x2A20] = { unicodeslot=0x2A20, category='sm', description='Z NOTATION SCHEMA PIPING' },
	[0x2A21] = { unicodeslot=0x2A21, category='sm', description='Z NOTATION SCHEMA PROJECTION' },
	[0x2A22] = { unicodeslot=0x2A22, category='sm', description='PLUS SIGN WITH SMALL CIRCLE ABOVE' },
	[0x2A23] = { unicodeslot=0x2A23, category='sm', description='PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE' },
	[0x2A24] = { unicodeslot=0x2A24, category='sm', description='PLUS SIGN WITH TILDE ABOVE' },
	[0x2A25] = { unicodeslot=0x2A25, category='sm', description='PLUS SIGN WITH DOT BELOW' },
	[0x2A26] = { unicodeslot=0x2A26, category='sm', description='PLUS SIGN WITH TILDE BELOW' },
	[0x2A27] = { unicodeslot=0x2A27, category='sm', description='PLUS SIGN WITH SUBSCRIPT TWO' },
	[0x2A28] = { unicodeslot=0x2A28, category='sm', description='PLUS SIGN WITH BLACK TRIANGLE' },
	[0x2A29] = { unicodeslot=0x2A29, category='sm', description='MINUS SIGN WITH COMMA ABOVE' },
	[0x2A2A] = { unicodeslot=0x2A2A, category='sm', description='MINUS SIGN WITH DOT BELOW' },
	[0x2A2B] = { unicodeslot=0x2A2B, category='sm', description='MINUS SIGN WITH FALLING DOTS' },
	[0x2A2C] = { unicodeslot=0x2A2C, category='sm', description='MINUS SIGN WITH RISING DOTS' },
	[0x2A2D] = { unicodeslot=0x2A2D, category='sm', description='PLUS SIGN IN LEFT HALF CIRCLE' },
	[0x2A2E] = { unicodeslot=0x2A2E, category='sm', description='PLUS SIGN IN RIGHT HALF CIRCLE' },
	[0x2A2F] = { unicodeslot=0x2A2F, category='sm', description='VECTOR OR CROSS PRODUCT' },
	[0x2A30] = { unicodeslot=0x2A30, category='sm', description='MULTIPLICATION SIGN WITH DOT ABOVE' },
	[0x2A31] = { unicodeslot=0x2A31, category='sm', description='MULTIPLICATION SIGN WITH UNDERBAR' },
	[0x2A32] = { unicodeslot=0x2A32, category='sm', description='SEMIDIRECT PRODUCT WITH BOTTOM CLOSED' },
	[0x2A33] = { unicodeslot=0x2A33, category='sm', description='SMASH PRODUCT' },
	[0x2A34] = { unicodeslot=0x2A34, category='sm', description='MULTIPLICATION SIGN IN LEFT HALF CIRCLE' },
	[0x2A35] = { unicodeslot=0x2A35, category='sm', description='MULTIPLICATION SIGN IN RIGHT HALF CIRCLE' },
	[0x2A36] = { unicodeslot=0x2A36, category='sm', description='CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT' },
	[0x2A37] = { unicodeslot=0x2A37, category='sm', description='MULTIPLICATION SIGN IN DOUBLE CIRCLE' },
	[0x2A38] = { unicodeslot=0x2A38, category='sm', description='CIRCLED DIVISION SIGN' },
	[0x2A39] = { unicodeslot=0x2A39, category='sm', description='PLUS SIGN IN TRIANGLE' },
	[0x2A3A] = { unicodeslot=0x2A3A, category='sm', description='MINUS SIGN IN TRIANGLE' },
	[0x2A3B] = { unicodeslot=0x2A3B, category='sm', description='MULTIPLICATION SIGN IN TRIANGLE' },
	[0x2A3C] = { unicodeslot=0x2A3C, category='sm', description='INTERIOR PRODUCT' },
	[0x2A3D] = { unicodeslot=0x2A3D, category='sm', description='RIGHTHAND INTERIOR PRODUCT' },
	[0x2A3E] = { unicodeslot=0x2A3E, category='sm', description='Z NOTATION RELATIONAL COMPOSITION' },
	[0x2A3F] = { unicodeslot=0x2A3F, category='sm', description='AMALGAMATION OR COPRODUCT' },
	[0x2A40] = { unicodeslot=0x2A40, category='sm', description='INTERSECTION WITH DOT' },
	[0x2A41] = { unicodeslot=0x2A41, category='sm', description='UNION WITH MINUS SIGN' },
	[0x2A42] = { unicodeslot=0x2A42, category='sm', description='UNION WITH OVERBAR' },
	[0x2A43] = { unicodeslot=0x2A43, category='sm', description='INTERSECTION WITH OVERBAR' },
	[0x2A44] = { unicodeslot=0x2A44, category='sm', description='INTERSECTION WITH LOGICAL AND' },
	[0x2A45] = { unicodeslot=0x2A45, category='sm', description='UNION WITH LOGICAL OR' },
	[0x2A46] = { unicodeslot=0x2A46, category='sm', description='UNION ABOVE INTERSECTION' },
	[0x2A47] = { unicodeslot=0x2A47, category='sm', description='INTERSECTION ABOVE UNION' },
	[0x2A48] = { unicodeslot=0x2A48, category='sm', description='UNION ABOVE BAR ABOVE INTERSECTION' },
	[0x2A49] = { unicodeslot=0x2A49, category='sm', description='INTERSECTION ABOVE BAR ABOVE UNION' },
	[0x2A4A] = { unicodeslot=0x2A4A, category='sm', description='UNION BESIDE AND JOINED WITH UNION' },
	[0x2A4B] = { unicodeslot=0x2A4B, category='sm', description='INTERSECTION BESIDE AND JOINED WITH INTERSECTION' },
	[0x2A4C] = { unicodeslot=0x2A4C, category='sm', description='CLOSED UNION WITH SERIFS' },
	[0x2A4D] = { unicodeslot=0x2A4D, category='sm', description='CLOSED INTERSECTION WITH SERIFS' },
	[0x2A4E] = { unicodeslot=0x2A4E, category='sm', description='DOUBLE SQUARE INTERSECTION' },
	[0x2A4F] = { unicodeslot=0x2A4F, category='sm', description='DOUBLE SQUARE UNION' },
	[0x2A50] = { unicodeslot=0x2A50, category='sm', description='CLOSED UNION WITH SERIFS AND SMASH PRODUCT' },
	[0x2A51] = { unicodeslot=0x2A51, category='sm', description='LOGICAL AND WITH DOT ABOVE' },
	[0x2A52] = { unicodeslot=0x2A52, category='sm', description='LOGICAL OR WITH DOT ABOVE' },
	[0x2A53] = { unicodeslot=0x2A53, category='sm', description='DOUBLE LOGICAL AND' },
	[0x2A54] = { unicodeslot=0x2A54, category='sm', description='DOUBLE LOGICAL OR' },
	[0x2A55] = { unicodeslot=0x2A55, category='sm', description='TWO INTERSECTING LOGICAL AND' },
	[0x2A56] = { unicodeslot=0x2A56, category='sm', description='TWO INTERSECTING LOGICAL OR' },
	[0x2A57] = { unicodeslot=0x2A57, category='sm', description='SLOPING LARGE OR' },
	[0x2A58] = { unicodeslot=0x2A58, category='sm', description='SLOPING LARGE AND' },
	[0x2A59] = { unicodeslot=0x2A59, category='sm', description='LOGICAL OR OVERLAPPING LOGICAL AND' },
	[0x2A5A] = { unicodeslot=0x2A5A, category='sm', description='LOGICAL AND WITH MIDDLE STEM' },
	[0x2A5B] = { unicodeslot=0x2A5B, category='sm', description='LOGICAL OR WITH MIDDLE STEM' },
	[0x2A5C] = { unicodeslot=0x2A5C, category='sm', description='LOGICAL AND WITH HORIZONTAL DASH' },
	[0x2A5D] = { unicodeslot=0x2A5D, category='sm', description='LOGICAL OR WITH HORIZONTAL DASH' },
	[0x2A5E] = { unicodeslot=0x2A5E, category='sm', description='LOGICAL AND WITH DOUBLE OVERBAR' },
	[0x2A5F] = { unicodeslot=0x2A5F, category='sm', description='LOGICAL AND WITH UNDERBAR' },
	[0x2A60] = { unicodeslot=0x2A60, category='sm', description='LOGICAL AND WITH DOUBLE UNDERBAR' },
	[0x2A61] = { unicodeslot=0x2A61, category='sm', description='SMALL VEE WITH UNDERBAR' },
	[0x2A62] = { unicodeslot=0x2A62, category='sm', description='LOGICAL OR WITH DOUBLE OVERBAR' },
	[0x2A63] = { unicodeslot=0x2A63, category='sm', description='LOGICAL OR WITH DOUBLE UNDERBAR' },
	[0x2A64] = { unicodeslot=0x2A64, category='sm', description='Z NOTATION DOMAIN ANTIRESTRICTION' },
	[0x2A65] = { unicodeslot=0x2A65, category='sm', description='Z NOTATION RANGE ANTIRESTRICTION' },
	[0x2A66] = { unicodeslot=0x2A66, category='sm', description='EQUALS SIGN WITH DOT BELOW' },
	[0x2A67] = { unicodeslot=0x2A67, category='sm', description='IDENTICAL WITH DOT ABOVE' },
	[0x2A68] = { unicodeslot=0x2A68, category='sm', description='TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE' },
	[0x2A69] = { unicodeslot=0x2A69, category='sm', description='TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE' },
	[0x2A6A] = { unicodeslot=0x2A6A, category='sm', description='TILDE OPERATOR WITH DOT ABOVE' },
	[0x2A6B] = { unicodeslot=0x2A6B, category='sm', description='TILDE OPERATOR WITH RISING DOTS' },
	[0x2A6C] = { unicodeslot=0x2A6C, category='sm', description='SIMILAR MINUS SIMILAR' },
	[0x2A6D] = { unicodeslot=0x2A6D, category='sm', description='CONGRUENT WITH DOT ABOVE' },
	[0x2A6E] = { unicodeslot=0x2A6E, category='sm', description='EQUALS WITH ASTERISK' },
	[0x2A6F] = { unicodeslot=0x2A6F, category='sm', description='ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT' },
	[0x2A70] = { unicodeslot=0x2A70, category='sm', description='APPROXIMATELY EQUAL OR EQUAL TO' },
	[0x2A71] = { unicodeslot=0x2A71, category='sm', description='EQUALS SIGN ABOVE PLUS SIGN' },
	[0x2A72] = { unicodeslot=0x2A72, category='sm', description='PLUS SIGN ABOVE EQUALS SIGN' },
	[0x2A73] = { unicodeslot=0x2A73, category='sm', description='EQUALS SIGN ABOVE TILDE OPERATOR' },
	[0x2A74] = { unicodeslot=0x2A74, category='sm', description='DOUBLE COLON EQUAL', specials={'compat',0x003A,0x003A,0x003D} },
	[0x2A75] = { unicodeslot=0x2A75, category='sm', description='TWO CONSECUTIVE EQUALS SIGNS', specials={'compat',0x003D,0x003D} },
	[0x2A76] = { unicodeslot=0x2A76, category='sm', description='THREE CONSECUTIVE EQUALS SIGNS', specials={'compat',0x003D,0x003D,0x003D} },
	[0x2A77] = { unicodeslot=0x2A77, category='sm', description='EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW' },
	[0x2A78] = { unicodeslot=0x2A78, category='sm', description='EQUIVALENT WITH FOUR DOTS ABOVE' },
	[0x2A79] = { unicodeslot=0x2A79, category='sm', description='LESS-THAN WITH CIRCLE INSIDE' },
	[0x2A7A] = { unicodeslot=0x2A7A, category='sm', description='GREATER-THAN WITH CIRCLE INSIDE' },
	[0x2A7B] = { unicodeslot=0x2A7B, category='sm', description='LESS-THAN WITH QUESTION MARK ABOVE' },
	[0x2A7C] = { unicodeslot=0x2A7C, category='sm', description='GREATER-THAN WITH QUESTION MARK ABOVE' },
	[0x2A7D] = { unicodeslot=0x2A7D, category='sm', description='LESS-THAN OR SLANTED EQUAL TO' },
	[0x2A7E] = { unicodeslot=0x2A7E, category='sm', description='GREATER-THAN OR SLANTED EQUAL TO' },
	[0x2A7F] = { unicodeslot=0x2A7F, category='sm', description='LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE' },
	[0x2A80] = { unicodeslot=0x2A80, category='sm', description='GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE' },
	[0x2A81] = { unicodeslot=0x2A81, category='sm', description='LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE' },
	[0x2A82] = { unicodeslot=0x2A82, category='sm', description='GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE' },
	[0x2A83] = { unicodeslot=0x2A83, category='sm', description='LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT' },
	[0x2A84] = { unicodeslot=0x2A84, category='sm', description='GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT' },
	[0x2A85] = { unicodeslot=0x2A85, category='sm', description='LESS-THAN OR APPROXIMATE' },
	[0x2A86] = { unicodeslot=0x2A86, category='sm', description='GREATER-THAN OR APPROXIMATE' },
	[0x2A87] = { unicodeslot=0x2A87, category='sm', description='LESS-THAN AND SINGLE-LINE NOT EQUAL TO' },
	[0x2A88] = { unicodeslot=0x2A88, category='sm', description='GREATER-THAN AND SINGLE-LINE NOT EQUAL TO' },
	[0x2A89] = { unicodeslot=0x2A89, category='sm', description='LESS-THAN AND NOT APPROXIMATE' },
	[0x2A8A] = { unicodeslot=0x2A8A, category='sm', description='GREATER-THAN AND NOT APPROXIMATE' },
	[0x2A8B] = { unicodeslot=0x2A8B, category='sm', description='LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN' },
	[0x2A8C] = { unicodeslot=0x2A8C, category='sm', description='GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN' },
	[0x2A8D] = { unicodeslot=0x2A8D, category='sm', description='LESS-THAN ABOVE SIMILAR OR EQUAL' },
	[0x2A8E] = { unicodeslot=0x2A8E, category='sm', description='GREATER-THAN ABOVE SIMILAR OR EQUAL' },
	[0x2A8F] = { unicodeslot=0x2A8F, category='sm', description='LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN' },
	[0x2A90] = { unicodeslot=0x2A90, category='sm', description='GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN' },
	[0x2A91] = { unicodeslot=0x2A91, category='sm', description='LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL' },
	[0x2A92] = { unicodeslot=0x2A92, category='sm', description='GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL' },
	[0x2A93] = { unicodeslot=0x2A93, category='sm', description='LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL' },
	[0x2A94] = { unicodeslot=0x2A94, category='sm', description='GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL' },
	[0x2A95] = { unicodeslot=0x2A95, category='sm', description='SLANTED EQUAL TO OR LESS-THAN' },
	[0x2A96] = { unicodeslot=0x2A96, category='sm', description='SLANTED EQUAL TO OR GREATER-THAN' },
	[0x2A97] = { unicodeslot=0x2A97, category='sm', description='SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE' },
	[0x2A98] = { unicodeslot=0x2A98, category='sm', description='SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE' },
	[0x2A99] = { unicodeslot=0x2A99, category='sm', description='DOUBLE-LINE EQUAL TO OR LESS-THAN' },
	[0x2A9A] = { unicodeslot=0x2A9A, category='sm', description='DOUBLE-LINE EQUAL TO OR GREATER-THAN' },
	[0x2A9B] = { unicodeslot=0x2A9B, category='sm', description='DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN' },
	[0x2A9C] = { unicodeslot=0x2A9C, category='sm', description='DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN' },
	[0x2A9D] = { unicodeslot=0x2A9D, category='sm', description='SIMILAR OR LESS-THAN' },
	[0x2A9E] = { unicodeslot=0x2A9E, category='sm', description='SIMILAR OR GREATER-THAN' },
	[0x2A9F] = { unicodeslot=0x2A9F, category='sm', description='SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN' },
	[0x2AA0] = { unicodeslot=0x2AA0, category='sm', description='SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN' },
	[0x2AA1] = { unicodeslot=0x2AA1, category='sm', description='DOUBLE NESTED LESS-THAN' },
	[0x2AA2] = { unicodeslot=0x2AA2, category='sm', description='DOUBLE NESTED GREATER-THAN' },
	[0x2AA3] = { unicodeslot=0x2AA3, category='sm', description='DOUBLE NESTED LESS-THAN WITH UNDERBAR' },
	[0x2AA4] = { unicodeslot=0x2AA4, category='sm', description='GREATER-THAN OVERLAPPING LESS-THAN' },
	[0x2AA5] = { unicodeslot=0x2AA5, category='sm', description='GREATER-THAN BESIDE LESS-THAN' },
	[0x2AA6] = { unicodeslot=0x2AA6, category='sm', description='LESS-THAN CLOSED BY CURVE' },
	[0x2AA7] = { unicodeslot=0x2AA7, category='sm', description='GREATER-THAN CLOSED BY CURVE' },
	[0x2AA8] = { unicodeslot=0x2AA8, category='sm', description='LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL' },
	[0x2AA9] = { unicodeslot=0x2AA9, category='sm', description='GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL' },
	[0x2AAA] = { unicodeslot=0x2AAA, category='sm', description='SMALLER THAN' },
	[0x2AAB] = { unicodeslot=0x2AAB, category='sm', description='LARGER THAN' },
	[0x2AAC] = { unicodeslot=0x2AAC, category='sm', description='SMALLER THAN OR EQUAL TO' },
	[0x2AAD] = { unicodeslot=0x2AAD, category='sm', description='LARGER THAN OR EQUAL TO' },
	[0x2AAE] = { unicodeslot=0x2AAE, category='sm', description='EQUALS SIGN WITH BUMPY ABOVE' },
	[0x2AAF] = { unicodeslot=0x2AAF, category='sm', description='PRECEDES ABOVE SINGLE-LINE EQUALS SIGN' },
	[0x2AB0] = { unicodeslot=0x2AB0, category='sm', description='SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN' },
	[0x2AB1] = { unicodeslot=0x2AB1, category='sm', description='PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO' },
	[0x2AB2] = { unicodeslot=0x2AB2, category='sm', description='SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO' },
	[0x2AB3] = { unicodeslot=0x2AB3, category='sm', description='PRECEDES ABOVE EQUALS SIGN' },
	[0x2AB4] = { unicodeslot=0x2AB4, category='sm', description='SUCCEEDS ABOVE EQUALS SIGN' },
	[0x2AB5] = { unicodeslot=0x2AB5, category='sm', description='PRECEDES ABOVE NOT EQUAL TO' },
	[0x2AB6] = { unicodeslot=0x2AB6, category='sm', description='SUCCEEDS ABOVE NOT EQUAL TO' },
	[0x2AB7] = { unicodeslot=0x2AB7, category='sm', description='PRECEDES ABOVE ALMOST EQUAL TO' },
	[0x2AB8] = { unicodeslot=0x2AB8, category='sm', description='SUCCEEDS ABOVE ALMOST EQUAL TO' },
	[0x2AB9] = { unicodeslot=0x2AB9, category='sm', description='PRECEDES ABOVE NOT ALMOST EQUAL TO' },
	[0x2ABA] = { unicodeslot=0x2ABA, category='sm', description='SUCCEEDS ABOVE NOT ALMOST EQUAL TO' },
	[0x2ABB] = { unicodeslot=0x2ABB, category='sm', description='DOUBLE PRECEDES' },
	[0x2ABC] = { unicodeslot=0x2ABC, category='sm', description='DOUBLE SUCCEEDS' },
	[0x2ABD] = { unicodeslot=0x2ABD, category='sm', description='SUBSET WITH DOT' },
	[0x2ABE] = { unicodeslot=0x2ABE, category='sm', description='SUPERSET WITH DOT' },
	[0x2ABF] = { unicodeslot=0x2ABF, category='sm', description='SUBSET WITH PLUS SIGN BELOW' },
	[0x2AC0] = { unicodeslot=0x2AC0, category='sm', description='SUPERSET WITH PLUS SIGN BELOW' },
	[0x2AC1] = { unicodeslot=0x2AC1, category='sm', description='SUBSET WITH MULTIPLICATION SIGN BELOW' },
	[0x2AC2] = { unicodeslot=0x2AC2, category='sm', description='SUPERSET WITH MULTIPLICATION SIGN BELOW' },
	[0x2AC3] = { unicodeslot=0x2AC3, category='sm', description='SUBSET OF OR EQUAL TO WITH DOT ABOVE' },
	[0x2AC4] = { unicodeslot=0x2AC4, category='sm', description='SUPERSET OF OR EQUAL TO WITH DOT ABOVE' },
	[0x2AC5] = { unicodeslot=0x2AC5, category='sm', description='SUBSET OF ABOVE EQUALS SIGN' },
	[0x2AC6] = { unicodeslot=0x2AC6, category='sm', description='SUPERSET OF ABOVE EQUALS SIGN' },
	[0x2AC7] = { unicodeslot=0x2AC7, category='sm', description='SUBSET OF ABOVE TILDE OPERATOR' },
	[0x2AC8] = { unicodeslot=0x2AC8, category='sm', description='SUPERSET OF ABOVE TILDE OPERATOR' },
	[0x2AC9] = { unicodeslot=0x2AC9, category='sm', description='SUBSET OF ABOVE ALMOST EQUAL TO' },
	[0x2ACA] = { unicodeslot=0x2ACA, category='sm', description='SUPERSET OF ABOVE ALMOST EQUAL TO' },
	[0x2ACB] = { unicodeslot=0x2ACB, category='sm', description='SUBSET OF ABOVE NOT EQUAL TO' },
	[0x2ACC] = { unicodeslot=0x2ACC, category='sm', description='SUPERSET OF ABOVE NOT EQUAL TO' },
	[0x2ACD] = { unicodeslot=0x2ACD, category='sm', description='SQUARE LEFT OPEN BOX OPERATOR' },
	[0x2ACE] = { unicodeslot=0x2ACE, category='sm', description='SQUARE RIGHT OPEN BOX OPERATOR' },
	[0x2ACF] = { unicodeslot=0x2ACF, category='sm', description='CLOSED SUBSET' },
	[0x2AD0] = { unicodeslot=0x2AD0, category='sm', description='CLOSED SUPERSET' },
	[0x2AD1] = { unicodeslot=0x2AD1, category='sm', description='CLOSED SUBSET OR EQUAL TO' },
	[0x2AD2] = { unicodeslot=0x2AD2, category='sm', description='CLOSED SUPERSET OR EQUAL TO' },
	[0x2AD3] = { unicodeslot=0x2AD3, category='sm', description='SUBSET ABOVE SUPERSET' },
	[0x2AD4] = { unicodeslot=0x2AD4, category='sm', description='SUPERSET ABOVE SUBSET' },
	[0x2AD5] = { unicodeslot=0x2AD5, category='sm', description='SUBSET ABOVE SUBSET' },
	[0x2AD6] = { unicodeslot=0x2AD6, category='sm', description='SUPERSET ABOVE SUPERSET' },
	[0x2AD7] = { unicodeslot=0x2AD7, category='sm', description='SUPERSET BESIDE SUBSET' },
	[0x2AD8] = { unicodeslot=0x2AD8, category='sm', description='SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET' },
	[0x2AD9] = { unicodeslot=0x2AD9, category='sm', description='ELEMENT OF OPENING DOWNWARDS' },
	[0x2ADA] = { unicodeslot=0x2ADA, category='sm', description='PITCHFORK WITH TEE TOP' },
	[0x2ADB] = { unicodeslot=0x2ADB, category='sm', description='TRANSVERSAL INTERSECTION' },
	[0x2ADC] = { unicodeslot=0x2ADC, category='sm', description='FORKING', specials={'char',0x2ADD,0x0338} },
	[0x2ADD] = { unicodeslot=0x2ADD, category='sm', description='NONFORKING' },
	[0x2ADE] = { unicodeslot=0x2ADE, category='sm', description='SHORT LEFT TACK' },
	[0x2ADF] = { unicodeslot=0x2ADF, category='sm', description='SHORT DOWN TACK' },
	[0x2AE0] = { unicodeslot=0x2AE0, category='sm', description='SHORT UP TACK' },
	[0x2AE1] = { unicodeslot=0x2AE1, category='sm', description='PERPENDICULAR WITH S' },
	[0x2AE2] = { unicodeslot=0x2AE2, category='sm', description='VERTICAL BAR TRIPLE RIGHT TURNSTILE' },
	[0x2AE3] = { unicodeslot=0x2AE3, category='sm', description='DOUBLE VERTICAL BAR LEFT TURNSTILE' },
	[0x2AE4] = { unicodeslot=0x2AE4, category='sm', description='VERTICAL BAR DOUBLE LEFT TURNSTILE' },
	[0x2AE5] = { unicodeslot=0x2AE5, category='sm', description='DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE' },
	[0x2AE6] = { unicodeslot=0x2AE6, category='sm', description='LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL' },
	[0x2AE7] = { unicodeslot=0x2AE7, category='sm', description='SHORT DOWN TACK WITH OVERBAR' },
	[0x2AE8] = { unicodeslot=0x2AE8, category='sm', description='SHORT UP TACK WITH UNDERBAR' },
	[0x2AE9] = { unicodeslot=0x2AE9, category='sm', description='SHORT UP TACK ABOVE SHORT DOWN TACK' },
	[0x2AEA] = { unicodeslot=0x2AEA, category='sm', description='DOUBLE DOWN TACK' },
	[0x2AEB] = { unicodeslot=0x2AEB, category='sm', description='DOUBLE UP TACK' },
	[0x2AEC] = { unicodeslot=0x2AEC, category='sm', description='DOUBLE STROKE NOT SIGN' },
	[0x2AED] = { unicodeslot=0x2AED, category='sm', description='REVERSED DOUBLE STROKE NOT SIGN' },
	[0x2AEE] = { unicodeslot=0x2AEE, category='sm', description='DOES NOT DIVIDE WITH REVERSED NEGATION SLASH' },
	[0x2AEF] = { unicodeslot=0x2AEF, category='sm', description='VERTICAL LINE WITH CIRCLE ABOVE' },
	[0x2AF0] = { unicodeslot=0x2AF0, category='sm', description='VERTICAL LINE WITH CIRCLE BELOW' },
	[0x2AF1] = { unicodeslot=0x2AF1, category='sm', description='DOWN TACK WITH CIRCLE BELOW' },
	[0x2AF2] = { unicodeslot=0x2AF2, category='sm', description='PARALLEL WITH HORIZONTAL STROKE' },
	[0x2AF3] = { unicodeslot=0x2AF3, category='sm', description='PARALLEL WITH TILDE OPERATOR' },
	[0x2AF4] = { unicodeslot=0x2AF4, category='sm', description='TRIPLE VERTICAL BAR BINARY RELATION' },
	[0x2AF5] = { unicodeslot=0x2AF5, category='sm', description='TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE' },
	[0x2AF6] = { unicodeslot=0x2AF6, category='sm', description='TRIPLE COLON OPERATOR' },
	[0x2AF7] = { unicodeslot=0x2AF7, category='sm', description='TRIPLE NESTED LESS-THAN' },
	[0x2AF8] = { unicodeslot=0x2AF8, category='sm', description='TRIPLE NESTED GREATER-THAN' },
	[0x2AF9] = { unicodeslot=0x2AF9, category='sm', description='DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO' },
	[0x2AFA] = { unicodeslot=0x2AFA, category='sm', description='DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO' },
	[0x2AFB] = { unicodeslot=0x2AFB, category='sm', description='TRIPLE SOLIDUS BINARY RELATION' },
	[0x2AFC] = { unicodeslot=0x2AFC, category='sm', description='LARGE TRIPLE VERTICAL BAR OPERATOR' },
	[0x2AFD] = { unicodeslot=0x2AFD, category='sm', description='DOUBLE SOLIDUS OPERATOR' },
	[0x2AFE] = { unicodeslot=0x2AFE, category='sm', description='WHITE VERTICAL BAR' },
	[0x2AFF] = { unicodeslot=0x2AFF, category='sm', description='N-ARY WHITE VERTICAL BAR' },
	[0x2B00] = { unicodeslot=0x2B00, category='so', description='NORTH EAST WHITE ARROW' },
	[0x2B01] = { unicodeslot=0x2B01, category='so', description='NORTH WEST WHITE ARROW' },
	[0x2B02] = { unicodeslot=0x2B02, category='so', description='SOUTH EAST WHITE ARROW' },
	[0x2B03] = { unicodeslot=0x2B03, category='so', description='SOUTH WEST WHITE ARROW' },
	[0x2B04] = { unicodeslot=0x2B04, category='so', description='LEFT RIGHT WHITE ARROW' },
	[0x2B05] = { unicodeslot=0x2B05, category='so', description='LEFTWARDS BLACK ARROW' },
	[0x2B06] = { unicodeslot=0x2B06, category='so', description='UPWARDS BLACK ARROW' },
	[0x2B07] = { unicodeslot=0x2B07, category='so', description='DOWNWARDS BLACK ARROW' },
	[0x2B08] = { unicodeslot=0x2B08, category='so', description='NORTH EAST BLACK ARROW' },
	[0x2B09] = { unicodeslot=0x2B09, category='so', description='NORTH WEST BLACK ARROW' },
	[0x2B0A] = { unicodeslot=0x2B0A, category='so', description='SOUTH EAST BLACK ARROW' },
	[0x2B0B] = { unicodeslot=0x2B0B, category='so', description='SOUTH WEST BLACK ARROW' },
	[0x2B0C] = { unicodeslot=0x2B0C, category='so', description='LEFT RIGHT BLACK ARROW' },
	[0x2B0D] = { unicodeslot=0x2B0D, category='so', description='UP DOWN BLACK ARROW' },
	[0x2B0E] = { unicodeslot=0x2B0E, category='so', description='RIGHTWARDS ARROW WITH TIP DOWNWARDS' },
	[0x2B0F] = { unicodeslot=0x2B0F, category='so', description='RIGHTWARDS ARROW WITH TIP UPWARDS' },
	[0x2B10] = { unicodeslot=0x2B10, category='so', description='LEFTWARDS ARROW WITH TIP DOWNWARDS' },
	[0x2B11] = { unicodeslot=0x2B11, category='so', description='LEFTWARDS ARROW WITH TIP UPWARDS' },
	[0x2B12] = { unicodeslot=0x2B12, category='so', description='SQUARE WITH TOP HALF BLACK' },
	[0x2B13] = { unicodeslot=0x2B13, category='so', description='SQUARE WITH BOTTOM HALF BLACK' },
	[0x2B14] = { unicodeslot=0x2B14, category='so', description='SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK' },
	[0x2B15] = { unicodeslot=0x2B15, category='so', description='SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK' },
	[0x2B16] = { unicodeslot=0x2B16, category='so', description='DIAMOND WITH LEFT HALF BLACK' },
	[0x2B17] = { unicodeslot=0x2B17, category='so', description='DIAMOND WITH RIGHT HALF BLACK' },
	[0x2B18] = { unicodeslot=0x2B18, category='so', description='DIAMOND WITH TOP HALF BLACK' },
	[0x2B19] = { unicodeslot=0x2B19, category='so', description='DIAMOND WITH BOTTOM HALF BLACK' },
	[0x2B1A] = { unicodeslot=0x2B1A, category='so', description='DOTTED SQUARE' },
	[0x2B20] = { unicodeslot=0x2B20, category='so', description='WHITE PENTAGON' },
	[0x2B21] = { unicodeslot=0x2B21, category='so', description='WHITE HEXAGON' },
	[0x2B22] = { unicodeslot=0x2B22, category='so', description='BLACK HEXAGON' },
	[0x2B23] = { unicodeslot=0x2B23, category='so', description='HORIZONTAL BLACK HEXAGON' },
	[0x2C00] = { unicodeslot=0x2C00, category='lu', description='GLAGOLITIC CAPITAL LETTER AZU', lccode=0x2C30 },
	[0x2C01] = { unicodeslot=0x2C01, category='lu', description='GLAGOLITIC CAPITAL LETTER BUKY', lccode=0x2C31 },
	[0x2C02] = { unicodeslot=0x2C02, category='lu', description='GLAGOLITIC CAPITAL LETTER VEDE', lccode=0x2C32 },
	[0x2C03] = { unicodeslot=0x2C03, category='lu', description='GLAGOLITIC CAPITAL LETTER GLAGOLI', lccode=0x2C33 },
	[0x2C04] = { unicodeslot=0x2C04, category='lu', description='GLAGOLITIC CAPITAL LETTER DOBRO', lccode=0x2C34 },
	[0x2C05] = { unicodeslot=0x2C05, category='lu', description='GLAGOLITIC CAPITAL LETTER YESTU', lccode=0x2C35 },
	[0x2C06] = { unicodeslot=0x2C06, category='lu', description='GLAGOLITIC CAPITAL LETTER ZHIVETE', lccode=0x2C36 },
	[0x2C07] = { unicodeslot=0x2C07, category='lu', description='GLAGOLITIC CAPITAL LETTER DZELO', lccode=0x2C37 },
	[0x2C08] = { unicodeslot=0x2C08, category='lu', description='GLAGOLITIC CAPITAL LETTER ZEMLJA', lccode=0x2C38 },
	[0x2C09] = { unicodeslot=0x2C09, category='lu', description='GLAGOLITIC CAPITAL LETTER IZHE', lccode=0x2C39 },
	[0x2C0A] = { unicodeslot=0x2C0A, category='lu', description='GLAGOLITIC CAPITAL LETTER INITIAL IZHE', lccode=0x2C3A },
	[0x2C0B] = { unicodeslot=0x2C0B, category='lu', description='GLAGOLITIC CAPITAL LETTER I', lccode=0x2C3B },
	[0x2C0C] = { unicodeslot=0x2C0C, category='lu', description='GLAGOLITIC CAPITAL LETTER DJERVI', lccode=0x2C3C },
	[0x2C0D] = { unicodeslot=0x2C0D, category='lu', description='GLAGOLITIC CAPITAL LETTER KAKO', lccode=0x2C3D },
	[0x2C0E] = { unicodeslot=0x2C0E, category='lu', description='GLAGOLITIC CAPITAL LETTER LJUDIJE', lccode=0x2C3E },
	[0x2C0F] = { unicodeslot=0x2C0F, category='lu', description='GLAGOLITIC CAPITAL LETTER MYSLITE', lccode=0x2C3F },
	[0x2C10] = { unicodeslot=0x2C10, category='lu', description='GLAGOLITIC CAPITAL LETTER NASHI', lccode=0x2C40 },
	[0x2C11] = { unicodeslot=0x2C11, category='lu', description='GLAGOLITIC CAPITAL LETTER ONU', lccode=0x2C41 },
	[0x2C12] = { unicodeslot=0x2C12, category='lu', description='GLAGOLITIC CAPITAL LETTER POKOJI', lccode=0x2C42 },
	[0x2C13] = { unicodeslot=0x2C13, category='lu', description='GLAGOLITIC CAPITAL LETTER RITSI', lccode=0x2C43 },
	[0x2C14] = { unicodeslot=0x2C14, category='lu', description='GLAGOLITIC CAPITAL LETTER SLOVO', lccode=0x2C44 },
	[0x2C15] = { unicodeslot=0x2C15, category='lu', description='GLAGOLITIC CAPITAL LETTER TVRIDO', lccode=0x2C45 },
	[0x2C16] = { unicodeslot=0x2C16, category='lu', description='GLAGOLITIC CAPITAL LETTER UKU', lccode=0x2C46 },
	[0x2C17] = { unicodeslot=0x2C17, category='lu', description='GLAGOLITIC CAPITAL LETTER FRITU', lccode=0x2C47 },
	[0x2C18] = { unicodeslot=0x2C18, category='lu', description='GLAGOLITIC CAPITAL LETTER HERU', lccode=0x2C48 },
	[0x2C19] = { unicodeslot=0x2C19, category='lu', description='GLAGOLITIC CAPITAL LETTER OTU', lccode=0x2C49 },
	[0x2C1A] = { unicodeslot=0x2C1A, category='lu', description='GLAGOLITIC CAPITAL LETTER PE', lccode=0x2C4A },
	[0x2C1B] = { unicodeslot=0x2C1B, category='lu', description='GLAGOLITIC CAPITAL LETTER SHTA', lccode=0x2C4B },
	[0x2C1C] = { unicodeslot=0x2C1C, category='lu', description='GLAGOLITIC CAPITAL LETTER TSI', lccode=0x2C4C },
	[0x2C1D] = { unicodeslot=0x2C1D, category='lu', description='GLAGOLITIC CAPITAL LETTER CHRIVI', lccode=0x2C4D },
	[0x2C1E] = { unicodeslot=0x2C1E, category='lu', description='GLAGOLITIC CAPITAL LETTER SHA', lccode=0x2C4E },
	[0x2C1F] = { unicodeslot=0x2C1F, category='lu', description='GLAGOLITIC CAPITAL LETTER YERU', lccode=0x2C4F },
	[0x2C20] = { unicodeslot=0x2C20, category='lu', description='GLAGOLITIC CAPITAL LETTER YERI', lccode=0x2C50 },
	[0x2C21] = { unicodeslot=0x2C21, category='lu', description='GLAGOLITIC CAPITAL LETTER YATI', lccode=0x2C51 },
	[0x2C22] = { unicodeslot=0x2C22, category='lu', description='GLAGOLITIC CAPITAL LETTER SPIDERY HA', lccode=0x2C52 },
	[0x2C23] = { unicodeslot=0x2C23, category='lu', description='GLAGOLITIC CAPITAL LETTER YU', lccode=0x2C53 },
	[0x2C24] = { unicodeslot=0x2C24, category='lu', description='GLAGOLITIC CAPITAL LETTER SMALL YUS', lccode=0x2C54 },
	[0x2C25] = { unicodeslot=0x2C25, category='lu', description='GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL', lccode=0x2C55 },
	[0x2C26] = { unicodeslot=0x2C26, category='lu', description='GLAGOLITIC CAPITAL LETTER YO', lccode=0x2C56 },
	[0x2C27] = { unicodeslot=0x2C27, category='lu', description='GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS', lccode=0x2C57 },
	[0x2C28] = { unicodeslot=0x2C28, category='lu', description='GLAGOLITIC CAPITAL LETTER BIG YUS', lccode=0x2C58 },
	[0x2C29] = { unicodeslot=0x2C29, category='lu', description='GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS', lccode=0x2C59 },
	[0x2C2A] = { unicodeslot=0x2C2A, category='lu', description='GLAGOLITIC CAPITAL LETTER FITA', lccode=0x2C5A },
	[0x2C2B] = { unicodeslot=0x2C2B, category='lu', description='GLAGOLITIC CAPITAL LETTER IZHITSA', lccode=0x2C5B },
	[0x2C2C] = { unicodeslot=0x2C2C, category='lu', description='GLAGOLITIC CAPITAL LETTER SHTAPIC', lccode=0x2C5C },
	[0x2C2D] = { unicodeslot=0x2C2D, category='lu', description='GLAGOLITIC CAPITAL LETTER TROKUTASTI A', lccode=0x2C5D },
	[0x2C2E] = { unicodeslot=0x2C2E, category='lu', description='GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE', lccode=0x2C5E },
	[0x2C30] = { unicodeslot=0x2C30, category='ll', description='GLAGOLITIC SMALL LETTER AZU', uccode=0x2C00 },
	[0x2C31] = { unicodeslot=0x2C31, category='ll', description='GLAGOLITIC SMALL LETTER BUKY', uccode=0x2C01 },
	[0x2C32] = { unicodeslot=0x2C32, category='ll', description='GLAGOLITIC SMALL LETTER VEDE', uccode=0x2C02 },
	[0x2C33] = { unicodeslot=0x2C33, category='ll', description='GLAGOLITIC SMALL LETTER GLAGOLI', uccode=0x2C03 },
	[0x2C34] = { unicodeslot=0x2C34, category='ll', description='GLAGOLITIC SMALL LETTER DOBRO', uccode=0x2C04 },
	[0x2C35] = { unicodeslot=0x2C35, category='ll', description='GLAGOLITIC SMALL LETTER YESTU', uccode=0x2C05 },
	[0x2C36] = { unicodeslot=0x2C36, category='ll', description='GLAGOLITIC SMALL LETTER ZHIVETE', uccode=0x2C06 },
	[0x2C37] = { unicodeslot=0x2C37, category='ll', description='GLAGOLITIC SMALL LETTER DZELO', uccode=0x2C07 },
	[0x2C38] = { unicodeslot=0x2C38, category='ll', description='GLAGOLITIC SMALL LETTER ZEMLJA', uccode=0x2C08 },
	[0x2C39] = { unicodeslot=0x2C39, category='ll', description='GLAGOLITIC SMALL LETTER IZHE', uccode=0x2C09 },
	[0x2C3A] = { unicodeslot=0x2C3A, category='ll', description='GLAGOLITIC SMALL LETTER INITIAL IZHE', uccode=0x2C0A },
	[0x2C3B] = { unicodeslot=0x2C3B, category='ll', description='GLAGOLITIC SMALL LETTER I', uccode=0x2C0B },
	[0x2C3C] = { unicodeslot=0x2C3C, category='ll', description='GLAGOLITIC SMALL LETTER DJERVI', uccode=0x2C0C },
	[0x2C3D] = { unicodeslot=0x2C3D, category='ll', description='GLAGOLITIC SMALL LETTER KAKO', uccode=0x2C0D },
	[0x2C3E] = { unicodeslot=0x2C3E, category='ll', description='GLAGOLITIC SMALL LETTER LJUDIJE', uccode=0x2C0E },
	[0x2C3F] = { unicodeslot=0x2C3F, category='ll', description='GLAGOLITIC SMALL LETTER MYSLITE', uccode=0x2C0F },
	[0x2C40] = { unicodeslot=0x2C40, category='ll', description='GLAGOLITIC SMALL LETTER NASHI', uccode=0x2C10 },
	[0x2C41] = { unicodeslot=0x2C41, category='ll', description='GLAGOLITIC SMALL LETTER ONU', uccode=0x2C11 },
	[0x2C42] = { unicodeslot=0x2C42, category='ll', description='GLAGOLITIC SMALL LETTER POKOJI', uccode=0x2C12 },
	[0x2C43] = { unicodeslot=0x2C43, category='ll', description='GLAGOLITIC SMALL LETTER RITSI', uccode=0x2C13 },
	[0x2C44] = { unicodeslot=0x2C44, category='ll', description='GLAGOLITIC SMALL LETTER SLOVO', uccode=0x2C14 },
	[0x2C45] = { unicodeslot=0x2C45, category='ll', description='GLAGOLITIC SMALL LETTER TVRIDO', uccode=0x2C15 },
	[0x2C46] = { unicodeslot=0x2C46, category='ll', description='GLAGOLITIC SMALL LETTER UKU', uccode=0x2C16 },
	[0x2C47] = { unicodeslot=0x2C47, category='ll', description='GLAGOLITIC SMALL LETTER FRITU', uccode=0x2C17 },
	[0x2C48] = { unicodeslot=0x2C48, category='ll', description='GLAGOLITIC SMALL LETTER HERU', uccode=0x2C18 },
	[0x2C49] = { unicodeslot=0x2C49, category='ll', description='GLAGOLITIC SMALL LETTER OTU', uccode=0x2C19 },
	[0x2C4A] = { unicodeslot=0x2C4A, category='ll', description='GLAGOLITIC SMALL LETTER PE', uccode=0x2C1A },
	[0x2C4B] = { unicodeslot=0x2C4B, category='ll', description='GLAGOLITIC SMALL LETTER SHTA', uccode=0x2C1B },
	[0x2C4C] = { unicodeslot=0x2C4C, category='ll', description='GLAGOLITIC SMALL LETTER TSI', uccode=0x2C1C },
	[0x2C4D] = { unicodeslot=0x2C4D, category='ll', description='GLAGOLITIC SMALL LETTER CHRIVI', uccode=0x2C1D },
	[0x2C4E] = { unicodeslot=0x2C4E, category='ll', description='GLAGOLITIC SMALL LETTER SHA', uccode=0x2C1E },
	[0x2C4F] = { unicodeslot=0x2C4F, category='ll', description='GLAGOLITIC SMALL LETTER YERU', uccode=0x2C1F },
	[0x2C50] = { unicodeslot=0x2C50, category='ll', description='GLAGOLITIC SMALL LETTER YERI', uccode=0x2C20 },
	[0x2C51] = { unicodeslot=0x2C51, category='ll', description='GLAGOLITIC SMALL LETTER YATI', uccode=0x2C21 },
	[0x2C52] = { unicodeslot=0x2C52, category='ll', description='GLAGOLITIC SMALL LETTER SPIDERY HA', uccode=0x2C22 },
	[0x2C53] = { unicodeslot=0x2C53, category='ll', description='GLAGOLITIC SMALL LETTER YU', uccode=0x2C23 },
	[0x2C54] = { unicodeslot=0x2C54, category='ll', description='GLAGOLITIC SMALL LETTER SMALL YUS', uccode=0x2C24 },
	[0x2C55] = { unicodeslot=0x2C55, category='ll', description='GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL', uccode=0x2C25 },
	[0x2C56] = { unicodeslot=0x2C56, category='ll', description='GLAGOLITIC SMALL LETTER YO', uccode=0x2C26 },
	[0x2C57] = { unicodeslot=0x2C57, category='ll', description='GLAGOLITIC SMALL LETTER IOTATED SMALL YUS', uccode=0x2C27 },
	[0x2C58] = { unicodeslot=0x2C58, category='ll', description='GLAGOLITIC SMALL LETTER BIG YUS', uccode=0x2C28 },
	[0x2C59] = { unicodeslot=0x2C59, category='ll', description='GLAGOLITIC SMALL LETTER IOTATED BIG YUS', uccode=0x2C29 },
	[0x2C5A] = { unicodeslot=0x2C5A, category='ll', description='GLAGOLITIC SMALL LETTER FITA', uccode=0x2C2A },
	[0x2C5B] = { unicodeslot=0x2C5B, category='ll', description='GLAGOLITIC SMALL LETTER IZHITSA', uccode=0x2C2B },
	[0x2C5C] = { unicodeslot=0x2C5C, category='ll', description='GLAGOLITIC SMALL LETTER SHTAPIC', uccode=0x2C2C },
	[0x2C5D] = { unicodeslot=0x2C5D, category='ll', description='GLAGOLITIC SMALL LETTER TROKUTASTI A', uccode=0x2C2D },
	[0x2C5E] = { unicodeslot=0x2C5E, category='ll', description='GLAGOLITIC SMALL LETTER LATINATE MYSLITE', uccode=0x2C2E },
	[0x2C60] = { unicodeslot=0x2C60, category='lu', description='LATIN CAPITAL LETTER L WITH DOUBLE BAR', shcode=0x004C, lccode=0x2C61 },
	[0x2C61] = { unicodeslot=0x2C61, category='ll', description='LATIN SMALL LETTER L WITH DOUBLE BAR', shcode=0x006C, uccode=0x2C60 },
	[0x2C62] = { unicodeslot=0x2C62, category='lu', description='LATIN CAPITAL LETTER L WITH MIDDLE TILDE', shcode=0x004C, lccode=0x026B },
	[0x2C63] = { unicodeslot=0x2C63, category='lu', description='LATIN CAPITAL LETTER P WITH STROKE', shcode=0x0050, lccode=0x1D7D },
	[0x2C64] = { unicodeslot=0x2C64, category='lu', description='LATIN CAPITAL LETTER R WITH TAIL', shcode=0x0052, lccode=0x027D },
	[0x2C65] = { unicodeslot=0x2C65, category='ll', description='LATIN SMALL LETTER A WITH STROKE', shcode=0x0061, uccode=0x023A },
	[0x2C66] = { unicodeslot=0x2C66, category='ll', description='LATIN SMALL LETTER T WITH DIAGONAL STROKE', shcode=0x0074, uccode=0x023E },
	[0x2C67] = { unicodeslot=0x2C67, category='lu', description='LATIN CAPITAL LETTER H WITH DESCENDER', shcode=0x0048, lccode=0x2C68 },
	[0x2C68] = { unicodeslot=0x2C68, category='ll', description='LATIN SMALL LETTER H WITH DESCENDER', shcode=0x0068, uccode=0x2C67 },
	[0x2C69] = { unicodeslot=0x2C69, category='lu', description='LATIN CAPITAL LETTER K WITH DESCENDER', shcode=0x004B, lccode=0x2C6A },
	[0x2C6A] = { unicodeslot=0x2C6A, category='ll', description='LATIN SMALL LETTER K WITH DESCENDER', shcode=0x006B, uccode=0x2C69 },
	[0x2C6B] = { unicodeslot=0x2C6B, category='lu', description='LATIN CAPITAL LETTER Z WITH DESCENDER', shcode=0x005A, lccode=0x2C6C },
	[0x2C6C] = { unicodeslot=0x2C6C, category='ll', description='LATIN SMALL LETTER Z WITH DESCENDER', shcode=0x007A, uccode=0x2C6B },
	[0x2C74] = { unicodeslot=0x2C74, category='ll', description='LATIN SMALL LETTER V WITH CURL', shcode=0x0076 },
	[0x2C75] = { unicodeslot=0x2C75, category='lu', description='LATIN CAPITAL LETTER HALF H', lccode=0x2C76 },
	[0x2C76] = { unicodeslot=0x2C76, category='ll', description='LATIN SMALL LETTER HALF H', uccode=0x2C75 },
	[0x2C77] = { unicodeslot=0x2C77, category='ll', description='LATIN SMALL LETTER TAILLESS PHI' },
	[0x2C80] = { unicodeslot=0x2C80, category='lu', description='COPTIC CAPITAL LETTER ALFA', lccode=0x2C81 },
	[0x2C81] = { unicodeslot=0x2C81, category='ll', description='COPTIC SMALL LETTER ALFA', uccode=0x2C80 },
	[0x2C82] = { unicodeslot=0x2C82, category='lu', description='COPTIC CAPITAL LETTER VIDA', lccode=0x2C83 },
	[0x2C83] = { unicodeslot=0x2C83, category='ll', description='COPTIC SMALL LETTER VIDA', uccode=0x2C82 },
	[0x2C84] = { unicodeslot=0x2C84, category='lu', description='COPTIC CAPITAL LETTER GAMMA', lccode=0x2C85 },
	[0x2C85] = { unicodeslot=0x2C85, category='ll', description='COPTIC SMALL LETTER GAMMA', uccode=0x2C84 },
	[0x2C86] = { unicodeslot=0x2C86, category='lu', description='COPTIC CAPITAL LETTER DALDA', lccode=0x2C87 },
	[0x2C87] = { unicodeslot=0x2C87, category='ll', description='COPTIC SMALL LETTER DALDA', uccode=0x2C86 },
	[0x2C88] = { unicodeslot=0x2C88, category='lu', description='COPTIC CAPITAL LETTER EIE', lccode=0x2C89 },
	[0x2C89] = { unicodeslot=0x2C89, category='ll', description='COPTIC SMALL LETTER EIE', uccode=0x2C88 },
	[0x2C8A] = { unicodeslot=0x2C8A, category='lu', description='COPTIC CAPITAL LETTER SOU', lccode=0x2C8B },
	[0x2C8B] = { unicodeslot=0x2C8B, category='ll', description='COPTIC SMALL LETTER SOU', uccode=0x2C8A },
	[0x2C8C] = { unicodeslot=0x2C8C, category='lu', description='COPTIC CAPITAL LETTER ZATA', lccode=0x2C8D },
	[0x2C8D] = { unicodeslot=0x2C8D, category='ll', description='COPTIC SMALL LETTER ZATA', uccode=0x2C8C },
	[0x2C8E] = { unicodeslot=0x2C8E, category='lu', description='COPTIC CAPITAL LETTER HATE', lccode=0x2C8F },
	[0x2C8F] = { unicodeslot=0x2C8F, category='ll', description='COPTIC SMALL LETTER HATE', uccode=0x2C8E },
	[0x2C90] = { unicodeslot=0x2C90, category='lu', description='COPTIC CAPITAL LETTER THETHE', lccode=0x2C91 },
	[0x2C91] = { unicodeslot=0x2C91, category='ll', description='COPTIC SMALL LETTER THETHE', uccode=0x2C90 },
	[0x2C92] = { unicodeslot=0x2C92, category='lu', description='COPTIC CAPITAL LETTER IAUDA', lccode=0x2C93 },
	[0x2C93] = { unicodeslot=0x2C93, category='ll', description='COPTIC SMALL LETTER IAUDA', uccode=0x2C92 },
	[0x2C94] = { unicodeslot=0x2C94, category='lu', description='COPTIC CAPITAL LETTER KAPA', lccode=0x2C95 },
	[0x2C95] = { unicodeslot=0x2C95, category='ll', description='COPTIC SMALL LETTER KAPA', uccode=0x2C94 },
	[0x2C96] = { unicodeslot=0x2C96, category='lu', description='COPTIC CAPITAL LETTER LAULA', lccode=0x2C97 },
	[0x2C97] = { unicodeslot=0x2C97, category='ll', description='COPTIC SMALL LETTER LAULA', uccode=0x2C96 },
	[0x2C98] = { unicodeslot=0x2C98, category='lu', description='COPTIC CAPITAL LETTER MI', lccode=0x2C99 },
	[0x2C99] = { unicodeslot=0x2C99, category='ll', description='COPTIC SMALL LETTER MI', uccode=0x2C98 },
	[0x2C9A] = { unicodeslot=0x2C9A, category='lu', description='COPTIC CAPITAL LETTER NI', lccode=0x2C9B },
	[0x2C9B] = { unicodeslot=0x2C9B, category='ll', description='COPTIC SMALL LETTER NI', uccode=0x2C9A },
	[0x2C9C] = { unicodeslot=0x2C9C, category='lu', description='COPTIC CAPITAL LETTER KSI', lccode=0x2C9D },
	[0x2C9D] = { unicodeslot=0x2C9D, category='ll', description='COPTIC SMALL LETTER KSI', uccode=0x2C9C },
	[0x2C9E] = { unicodeslot=0x2C9E, category='lu', description='COPTIC CAPITAL LETTER O', lccode=0x2C9F },
	[0x2C9F] = { unicodeslot=0x2C9F, category='ll', description='COPTIC SMALL LETTER O', uccode=0x2C9E },
	[0x2CA0] = { unicodeslot=0x2CA0, category='lu', description='COPTIC CAPITAL LETTER PI', lccode=0x2CA1 },
	[0x2CA1] = { unicodeslot=0x2CA1, category='ll', description='COPTIC SMALL LETTER PI', uccode=0x2CA0 },
	[0x2CA2] = { unicodeslot=0x2CA2, category='lu', description='COPTIC CAPITAL LETTER RO', lccode=0x2CA3 },
	[0x2CA3] = { unicodeslot=0x2CA3, category='ll', description='COPTIC SMALL LETTER RO', uccode=0x2CA2 },
	[0x2CA4] = { unicodeslot=0x2CA4, category='lu', description='COPTIC CAPITAL LETTER SIMA', lccode=0x2CA5 },
	[0x2CA5] = { unicodeslot=0x2CA5, category='ll', description='COPTIC SMALL LETTER SIMA', uccode=0x2CA4 },
	[0x2CA6] = { unicodeslot=0x2CA6, category='lu', description='COPTIC CAPITAL LETTER TAU', lccode=0x2CA7 },
	[0x2CA7] = { unicodeslot=0x2CA7, category='ll', description='COPTIC SMALL LETTER TAU', uccode=0x2CA6 },
	[0x2CA8] = { unicodeslot=0x2CA8, category='lu', description='COPTIC CAPITAL LETTER UA', lccode=0x2CA9 },
	[0x2CA9] = { unicodeslot=0x2CA9, category='ll', description='COPTIC SMALL LETTER UA', uccode=0x2CA8 },
	[0x2CAA] = { unicodeslot=0x2CAA, category='lu', description='COPTIC CAPITAL LETTER FI', lccode=0x2CAB },
	[0x2CAB] = { unicodeslot=0x2CAB, category='ll', description='COPTIC SMALL LETTER FI', uccode=0x2CAA },
	[0x2CAC] = { unicodeslot=0x2CAC, category='lu', description='COPTIC CAPITAL LETTER KHI', lccode=0x2CAD },
	[0x2CAD] = { unicodeslot=0x2CAD, category='ll', description='COPTIC SMALL LETTER KHI', uccode=0x2CAC },
	[0x2CAE] = { unicodeslot=0x2CAE, category='lu', description='COPTIC CAPITAL LETTER PSI', lccode=0x2CAF },
	[0x2CAF] = { unicodeslot=0x2CAF, category='ll', description='COPTIC SMALL LETTER PSI', uccode=0x2CAE },
	[0x2CB0] = { unicodeslot=0x2CB0, category='lu', description='COPTIC CAPITAL LETTER OOU', lccode=0x2CB1 },
	[0x2CB1] = { unicodeslot=0x2CB1, category='ll', description='COPTIC SMALL LETTER OOU', uccode=0x2CB0 },
	[0x2CB2] = { unicodeslot=0x2CB2, category='lu', description='COPTIC CAPITAL LETTER DIALECT-P ALEF', lccode=0x2CB3 },
	[0x2CB3] = { unicodeslot=0x2CB3, category='ll', description='COPTIC SMALL LETTER DIALECT-P ALEF', uccode=0x2CB2 },
	[0x2CB4] = { unicodeslot=0x2CB4, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC AIN', lccode=0x2CB5 },
	[0x2CB5] = { unicodeslot=0x2CB5, category='ll', description='COPTIC SMALL LETTER OLD COPTIC AIN', uccode=0x2CB4 },
	[0x2CB6] = { unicodeslot=0x2CB6, category='lu', description='COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE', lccode=0x2CB7 },
	[0x2CB7] = { unicodeslot=0x2CB7, category='ll', description='COPTIC SMALL LETTER CRYPTOGRAMMIC EIE', uccode=0x2CB6 },
	[0x2CB8] = { unicodeslot=0x2CB8, category='lu', description='COPTIC CAPITAL LETTER DIALECT-P KAPA', lccode=0x2CB9 },
	[0x2CB9] = { unicodeslot=0x2CB9, category='ll', description='COPTIC SMALL LETTER DIALECT-P KAPA', uccode=0x2CB8 },
	[0x2CBA] = { unicodeslot=0x2CBA, category='lu', description='COPTIC CAPITAL LETTER DIALECT-P NI', lccode=0x2CBB },
	[0x2CBB] = { unicodeslot=0x2CBB, category='ll', description='COPTIC SMALL LETTER DIALECT-P NI', uccode=0x2CBA },
	[0x2CBC] = { unicodeslot=0x2CBC, category='lu', description='COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI', lccode=0x2CBD },
	[0x2CBD] = { unicodeslot=0x2CBD, category='ll', description='COPTIC SMALL LETTER CRYPTOGRAMMIC NI', uccode=0x2CBC },
	[0x2CBE] = { unicodeslot=0x2CBE, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC OOU', lccode=0x2CBF },
	[0x2CBF] = { unicodeslot=0x2CBF, category='ll', description='COPTIC SMALL LETTER OLD COPTIC OOU', uccode=0x2CBE },
	[0x2CC0] = { unicodeslot=0x2CC0, category='lu', description='COPTIC CAPITAL LETTER SAMPI', lccode=0x2CC1 },
	[0x2CC1] = { unicodeslot=0x2CC1, category='ll', description='COPTIC SMALL LETTER SAMPI', uccode=0x2CC0 },
	[0x2CC2] = { unicodeslot=0x2CC2, category='lu', description='COPTIC CAPITAL LETTER CROSSED SHEI', lccode=0x2CC3 },
	[0x2CC3] = { unicodeslot=0x2CC3, category='ll', description='COPTIC SMALL LETTER CROSSED SHEI', uccode=0x2CC2 },
	[0x2CC4] = { unicodeslot=0x2CC4, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC SHEI', lccode=0x2CC5 },
	[0x2CC5] = { unicodeslot=0x2CC5, category='ll', description='COPTIC SMALL LETTER OLD COPTIC SHEI', uccode=0x2CC4 },
	[0x2CC6] = { unicodeslot=0x2CC6, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC ESH', lccode=0x2CC7 },
	[0x2CC7] = { unicodeslot=0x2CC7, category='ll', description='COPTIC SMALL LETTER OLD COPTIC ESH', uccode=0x2CC6 },
	[0x2CC8] = { unicodeslot=0x2CC8, category='lu', description='COPTIC CAPITAL LETTER AKHMIMIC KHEI', lccode=0x2CC9 },
	[0x2CC9] = { unicodeslot=0x2CC9, category='ll', description='COPTIC SMALL LETTER AKHMIMIC KHEI', uccode=0x2CC8 },
	[0x2CCA] = { unicodeslot=0x2CCA, category='lu', description='COPTIC CAPITAL LETTER DIALECT-P HORI', lccode=0x2CCB },
	[0x2CCB] = { unicodeslot=0x2CCB, category='ll', description='COPTIC SMALL LETTER DIALECT-P HORI', uccode=0x2CCA },
	[0x2CCC] = { unicodeslot=0x2CCC, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC HORI', lccode=0x2CCD },
	[0x2CCD] = { unicodeslot=0x2CCD, category='ll', description='COPTIC SMALL LETTER OLD COPTIC HORI', uccode=0x2CCC },
	[0x2CCE] = { unicodeslot=0x2CCE, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC HA', lccode=0x2CCF },
	[0x2CCF] = { unicodeslot=0x2CCF, category='ll', description='COPTIC SMALL LETTER OLD COPTIC HA', uccode=0x2CCE },
	[0x2CD0] = { unicodeslot=0x2CD0, category='lu', description='COPTIC CAPITAL LETTER L-SHAPED HA', lccode=0x2CD1 },
	[0x2CD1] = { unicodeslot=0x2CD1, category='ll', description='COPTIC SMALL LETTER L-SHAPED HA', uccode=0x2CD0 },
	[0x2CD2] = { unicodeslot=0x2CD2, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC HEI', lccode=0x2CD3 },
	[0x2CD3] = { unicodeslot=0x2CD3, category='ll', description='COPTIC SMALL LETTER OLD COPTIC HEI', uccode=0x2CD2 },
	[0x2CD4] = { unicodeslot=0x2CD4, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC HAT', lccode=0x2CD5 },
	[0x2CD5] = { unicodeslot=0x2CD5, category='ll', description='COPTIC SMALL LETTER OLD COPTIC HAT', uccode=0x2CD4 },
	[0x2CD6] = { unicodeslot=0x2CD6, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC GANGIA', lccode=0x2CD7 },
	[0x2CD7] = { unicodeslot=0x2CD7, category='ll', description='COPTIC SMALL LETTER OLD COPTIC GANGIA', uccode=0x2CD6 },
	[0x2CD8] = { unicodeslot=0x2CD8, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC DJA', lccode=0x2CD9 },
	[0x2CD9] = { unicodeslot=0x2CD9, category='ll', description='COPTIC SMALL LETTER OLD COPTIC DJA', uccode=0x2CD8 },
	[0x2CDA] = { unicodeslot=0x2CDA, category='lu', description='COPTIC CAPITAL LETTER OLD COPTIC SHIMA', lccode=0x2CDB },
	[0x2CDB] = { unicodeslot=0x2CDB, category='ll', description='COPTIC SMALL LETTER OLD COPTIC SHIMA', uccode=0x2CDA },
	[0x2CDC] = { unicodeslot=0x2CDC, category='lu', description='COPTIC CAPITAL LETTER OLD NUBIAN SHIMA', lccode=0x2CDD },
	[0x2CDD] = { unicodeslot=0x2CDD, category='ll', description='COPTIC SMALL LETTER OLD NUBIAN SHIMA', uccode=0x2CDC },
	[0x2CDE] = { unicodeslot=0x2CDE, category='lu', description='COPTIC CAPITAL LETTER OLD NUBIAN NGI', lccode=0x2CDF },
	[0x2CDF] = { unicodeslot=0x2CDF, category='ll', description='COPTIC SMALL LETTER OLD NUBIAN NGI', uccode=0x2CDE },
	[0x2CE0] = { unicodeslot=0x2CE0, category='lu', description='COPTIC CAPITAL LETTER OLD NUBIAN NYI', lccode=0x2CE1 },
	[0x2CE1] = { unicodeslot=0x2CE1, category='ll', description='COPTIC SMALL LETTER OLD NUBIAN NYI', uccode=0x2CE0 },
	[0x2CE2] = { unicodeslot=0x2CE2, category='lu', description='COPTIC CAPITAL LETTER OLD NUBIAN WAU', lccode=0x2CE3 },
	[0x2CE3] = { unicodeslot=0x2CE3, category='ll', description='COPTIC SMALL LETTER OLD NUBIAN WAU', uccode=0x2CE2 },
	[0x2CE4] = { unicodeslot=0x2CE4, category='ll', description='COPTIC SYMBOL KAI' },
	[0x2CE5] = { unicodeslot=0x2CE5, category='so', description='COPTIC SYMBOL MI RO' },
	[0x2CE6] = { unicodeslot=0x2CE6, category='so', description='COPTIC SYMBOL PI RO' },
	[0x2CE7] = { unicodeslot=0x2CE7, category='so', description='COPTIC SYMBOL STAUROS' },
	[0x2CE8] = { unicodeslot=0x2CE8, category='so', description='COPTIC SYMBOL TAU RO' },
	[0x2CE9] = { unicodeslot=0x2CE9, category='so', description='COPTIC SYMBOL KHI RO' },
	[0x2CEA] = { unicodeslot=0x2CEA, category='so', description='COPTIC SYMBOL SHIMA SIMA' },
	[0x2CF9] = { unicodeslot=0x2CF9, category='po', description='COPTIC OLD NUBIAN FULL STOP' },
	[0x2CFA] = { unicodeslot=0x2CFA, category='po', description='COPTIC OLD NUBIAN DIRECT QUESTION MARK' },
	[0x2CFB] = { unicodeslot=0x2CFB, category='po', description='COPTIC OLD NUBIAN INDIRECT QUESTION MARK' },
	[0x2CFC] = { unicodeslot=0x2CFC, category='po', description='COPTIC OLD NUBIAN VERSE DIVIDER' },
	[0x2CFD] = { unicodeslot=0x2CFD, category='no', description='COPTIC FRACTION ONE HALF' },
	[0x2CFE] = { unicodeslot=0x2CFE, category='po', description='COPTIC FULL STOP' },
	[0x2CFF] = { unicodeslot=0x2CFF, category='po', description='COPTIC MORPHOLOGICAL DIVIDER' },
	[0x2D00] = { unicodeslot=0x2D00, category='ll', description='GEORGIAN SMALL LETTER AN', uccode=0x10A0 },
	[0x2D01] = { unicodeslot=0x2D01, category='ll', description='GEORGIAN SMALL LETTER BAN', uccode=0x10A1 },
	[0x2D02] = { unicodeslot=0x2D02, category='ll', description='GEORGIAN SMALL LETTER GAN', uccode=0x10A2 },
	[0x2D03] = { unicodeslot=0x2D03, category='ll', description='GEORGIAN SMALL LETTER DON', uccode=0x10A3 },
	[0x2D04] = { unicodeslot=0x2D04, category='ll', description='GEORGIAN SMALL LETTER EN', uccode=0x10A4 },
	[0x2D05] = { unicodeslot=0x2D05, category='ll', description='GEORGIAN SMALL LETTER VIN', uccode=0x10A5 },
	[0x2D06] = { unicodeslot=0x2D06, category='ll', description='GEORGIAN SMALL LETTER ZEN', uccode=0x10A6 },
	[0x2D07] = { unicodeslot=0x2D07, category='ll', description='GEORGIAN SMALL LETTER TAN', uccode=0x10A7 },
	[0x2D08] = { unicodeslot=0x2D08, category='ll', description='GEORGIAN SMALL LETTER IN', uccode=0x10A8 },
	[0x2D09] = { unicodeslot=0x2D09, category='ll', description='GEORGIAN SMALL LETTER KAN', uccode=0x10A9 },
	[0x2D0A] = { unicodeslot=0x2D0A, category='ll', description='GEORGIAN SMALL LETTER LAS', uccode=0x10AA },
	[0x2D0B] = { unicodeslot=0x2D0B, category='ll', description='GEORGIAN SMALL LETTER MAN', uccode=0x10AB },
	[0x2D0C] = { unicodeslot=0x2D0C, category='ll', description='GEORGIAN SMALL LETTER NAR', uccode=0x10AC },
	[0x2D0D] = { unicodeslot=0x2D0D, category='ll', description='GEORGIAN SMALL LETTER ON', uccode=0x10AD },
	[0x2D0E] = { unicodeslot=0x2D0E, category='ll', description='GEORGIAN SMALL LETTER PAR', uccode=0x10AE },
	[0x2D0F] = { unicodeslot=0x2D0F, category='ll', description='GEORGIAN SMALL LETTER ZHAR', uccode=0x10AF },
	[0x2D10] = { unicodeslot=0x2D10, category='ll', description='GEORGIAN SMALL LETTER RAE', uccode=0x10B0 },
	[0x2D11] = { unicodeslot=0x2D11, category='ll', description='GEORGIAN SMALL LETTER SAN', uccode=0x10B1 },
	[0x2D12] = { unicodeslot=0x2D12, category='ll', description='GEORGIAN SMALL LETTER TAR', uccode=0x10B2 },
	[0x2D13] = { unicodeslot=0x2D13, category='ll', description='GEORGIAN SMALL LETTER UN', uccode=0x10B3 },
	[0x2D14] = { unicodeslot=0x2D14, category='ll', description='GEORGIAN SMALL LETTER PHAR', uccode=0x10B4 },
	[0x2D15] = { unicodeslot=0x2D15, category='ll', description='GEORGIAN SMALL LETTER KHAR', uccode=0x10B5 },
	[0x2D16] = { unicodeslot=0x2D16, category='ll', description='GEORGIAN SMALL LETTER GHAN', uccode=0x10B6 },
	[0x2D17] = { unicodeslot=0x2D17, category='ll', description='GEORGIAN SMALL LETTER QAR', uccode=0x10B7 },
	[0x2D18] = { unicodeslot=0x2D18, category='ll', description='GEORGIAN SMALL LETTER SHIN', uccode=0x10B8 },
	[0x2D19] = { unicodeslot=0x2D19, category='ll', description='GEORGIAN SMALL LETTER CHIN', uccode=0x10B9 },
	[0x2D1A] = { unicodeslot=0x2D1A, category='ll', description='GEORGIAN SMALL LETTER CAN', uccode=0x10BA },
	[0x2D1B] = { unicodeslot=0x2D1B, category='ll', description='GEORGIAN SMALL LETTER JIL', uccode=0x10BB },
	[0x2D1C] = { unicodeslot=0x2D1C, category='ll', description='GEORGIAN SMALL LETTER CIL', uccode=0x10BC },
	[0x2D1D] = { unicodeslot=0x2D1D, category='ll', description='GEORGIAN SMALL LETTER CHAR', uccode=0x10BD },
	[0x2D1E] = { unicodeslot=0x2D1E, category='ll', description='GEORGIAN SMALL LETTER XAN', uccode=0x10BE },
	[0x2D1F] = { unicodeslot=0x2D1F, category='ll', description='GEORGIAN SMALL LETTER JHAN', uccode=0x10BF },
	[0x2D20] = { unicodeslot=0x2D20, category='ll', description='GEORGIAN SMALL LETTER HAE', uccode=0x10C0 },
	[0x2D21] = { unicodeslot=0x2D21, category='ll', description='GEORGIAN SMALL LETTER HE', uccode=0x10C1 },
	[0x2D22] = { unicodeslot=0x2D22, category='ll', description='GEORGIAN SMALL LETTER HIE', uccode=0x10C2 },
	[0x2D23] = { unicodeslot=0x2D23, category='ll', description='GEORGIAN SMALL LETTER WE', uccode=0x10C3 },
	[0x2D24] = { unicodeslot=0x2D24, category='ll', description='GEORGIAN SMALL LETTER HAR', uccode=0x10C4 },
	[0x2D25] = { unicodeslot=0x2D25, category='ll', description='GEORGIAN SMALL LETTER HOE', uccode=0x10C5 },
	[0x2D30] = { unicodeslot=0x2D30, category='lo', description='TIFINAGH LETTER YA' },
	[0x2D31] = { unicodeslot=0x2D31, category='lo', description='TIFINAGH LETTER YAB' },
	[0x2D32] = { unicodeslot=0x2D32, category='lo', description='TIFINAGH LETTER YABH' },
	[0x2D33] = { unicodeslot=0x2D33, category='lo', description='TIFINAGH LETTER YAG' },
	[0x2D34] = { unicodeslot=0x2D34, category='lo', description='TIFINAGH LETTER YAGHH' },
	[0x2D35] = { unicodeslot=0x2D35, category='lo', description='TIFINAGH LETTER BERBER ACADEMY YAJ' },
	[0x2D36] = { unicodeslot=0x2D36, category='lo', description='TIFINAGH LETTER YAJ' },
	[0x2D37] = { unicodeslot=0x2D37, category='lo', description='TIFINAGH LETTER YAD' },
	[0x2D38] = { unicodeslot=0x2D38, category='lo', description='TIFINAGH LETTER YADH' },
	[0x2D39] = { unicodeslot=0x2D39, category='lo', description='TIFINAGH LETTER YADD' },
	[0x2D3A] = { unicodeslot=0x2D3A, category='lo', description='TIFINAGH LETTER YADDH' },
	[0x2D3B] = { unicodeslot=0x2D3B, category='lo', description='TIFINAGH LETTER YEY' },
	[0x2D3C] = { unicodeslot=0x2D3C, category='lo', description='TIFINAGH LETTER YAF' },
	[0x2D3D] = { unicodeslot=0x2D3D, category='lo', description='TIFINAGH LETTER YAK' },
	[0x2D3E] = { unicodeslot=0x2D3E, category='lo', description='TIFINAGH LETTER TUAREG YAK' },
	[0x2D3F] = { unicodeslot=0x2D3F, category='lo', description='TIFINAGH LETTER YAKHH' },
	[0x2D40] = { unicodeslot=0x2D40, category='lo', description='TIFINAGH LETTER YAH' },
	[0x2D41] = { unicodeslot=0x2D41, category='lo', description='TIFINAGH LETTER BERBER ACADEMY YAH' },
	[0x2D42] = { unicodeslot=0x2D42, category='lo', description='TIFINAGH LETTER TUAREG YAH' },
	[0x2D43] = { unicodeslot=0x2D43, category='lo', description='TIFINAGH LETTER YAHH' },
	[0x2D44] = { unicodeslot=0x2D44, category='lo', description='TIFINAGH LETTER YAA' },
	[0x2D45] = { unicodeslot=0x2D45, category='lo', description='TIFINAGH LETTER YAKH' },
	[0x2D46] = { unicodeslot=0x2D46, category='lo', description='TIFINAGH LETTER TUAREG YAKH' },
	[0x2D47] = { unicodeslot=0x2D47, category='lo', description='TIFINAGH LETTER YAQ' },
	[0x2D48] = { unicodeslot=0x2D48, category='lo', description='TIFINAGH LETTER TUAREG YAQ' },
	[0x2D49] = { unicodeslot=0x2D49, category='lo', description='TIFINAGH LETTER YI' },
	[0x2D4A] = { unicodeslot=0x2D4A, category='lo', description='TIFINAGH LETTER YAZH' },
	[0x2D4B] = { unicodeslot=0x2D4B, category='lo', description='TIFINAGH LETTER AHAGGAR YAZH' },
	[0x2D4C] = { unicodeslot=0x2D4C, category='lo', description='TIFINAGH LETTER TUAREG YAZH' },
	[0x2D4D] = { unicodeslot=0x2D4D, category='lo', description='TIFINAGH LETTER YAL' },
	[0x2D4E] = { unicodeslot=0x2D4E, category='lo', description='TIFINAGH LETTER YAM' },
	[0x2D4F] = { unicodeslot=0x2D4F, category='lo', description='TIFINAGH LETTER YAN' },
	[0x2D50] = { unicodeslot=0x2D50, category='lo', description='TIFINAGH LETTER TUAREG YAGN' },
	[0x2D51] = { unicodeslot=0x2D51, category='lo', description='TIFINAGH LETTER TUAREG YANG' },
	[0x2D52] = { unicodeslot=0x2D52, category='lo', description='TIFINAGH LETTER YAP' },
	[0x2D53] = { unicodeslot=0x2D53, category='lo', description='TIFINAGH LETTER YU' },
	[0x2D54] = { unicodeslot=0x2D54, category='lo', description='TIFINAGH LETTER YAR' },
	[0x2D55] = { unicodeslot=0x2D55, category='lo', description='TIFINAGH LETTER YARR' },
	[0x2D56] = { unicodeslot=0x2D56, category='lo', description='TIFINAGH LETTER YAGH' },
	[0x2D57] = { unicodeslot=0x2D57, category='lo', description='TIFINAGH LETTER TUAREG YAGH' },
	[0x2D58] = { unicodeslot=0x2D58, category='lo', description='TIFINAGH LETTER AYER YAGH' },
	[0x2D59] = { unicodeslot=0x2D59, category='lo', description='TIFINAGH LETTER YAS' },
	[0x2D5A] = { unicodeslot=0x2D5A, category='lo', description='TIFINAGH LETTER YASS' },
	[0x2D5B] = { unicodeslot=0x2D5B, category='lo', description='TIFINAGH LETTER YASH' },
	[0x2D5C] = { unicodeslot=0x2D5C, category='lo', description='TIFINAGH LETTER YAT' },
	[0x2D5D] = { unicodeslot=0x2D5D, category='lo', description='TIFINAGH LETTER YATH' },
	[0x2D5E] = { unicodeslot=0x2D5E, category='lo', description='TIFINAGH LETTER YACH' },
	[0x2D5F] = { unicodeslot=0x2D5F, category='lo', description='TIFINAGH LETTER YATT' },
	[0x2D60] = { unicodeslot=0x2D60, category='lo', description='TIFINAGH LETTER YAV' },
	[0x2D61] = { unicodeslot=0x2D61, category='lo', description='TIFINAGH LETTER YAW' },
	[0x2D62] = { unicodeslot=0x2D62, category='lo', description='TIFINAGH LETTER YAY' },
	[0x2D63] = { unicodeslot=0x2D63, category='lo', description='TIFINAGH LETTER YAZ' },
	[0x2D64] = { unicodeslot=0x2D64, category='lo', description='TIFINAGH LETTER TAWELLEMET YAZ' },
	[0x2D65] = { unicodeslot=0x2D65, category='lo', description='TIFINAGH LETTER YAZZ' },
	[0x2D6F] = { unicodeslot=0x2D6F, category='lm', description='TIFINAGH MODIFIER LETTER LABIALIZATION MARK', specials={'super',0x2D61} },
	[0x2D80] = { unicodeslot=0x2D80, category='lo', description='ETHIOPIC SYLLABLE LOA' },
	[0x2D81] = { unicodeslot=0x2D81, category='lo', description='ETHIOPIC SYLLABLE MOA' },
	[0x2D82] = { unicodeslot=0x2D82, category='lo', description='ETHIOPIC SYLLABLE ROA' },
	[0x2D83] = { unicodeslot=0x2D83, category='lo', description='ETHIOPIC SYLLABLE SOA' },
	[0x2D84] = { unicodeslot=0x2D84, category='lo', description='ETHIOPIC SYLLABLE SHOA' },
	[0x2D85] = { unicodeslot=0x2D85, category='lo', description='ETHIOPIC SYLLABLE BOA' },
	[0x2D86] = { unicodeslot=0x2D86, category='lo', description='ETHIOPIC SYLLABLE TOA' },
	[0x2D87] = { unicodeslot=0x2D87, category='lo', description='ETHIOPIC SYLLABLE COA' },
	[0x2D88] = { unicodeslot=0x2D88, category='lo', description='ETHIOPIC SYLLABLE NOA' },
	[0x2D89] = { unicodeslot=0x2D89, category='lo', description='ETHIOPIC SYLLABLE NYOA' },
	[0x2D8A] = { unicodeslot=0x2D8A, category='lo', description='ETHIOPIC SYLLABLE GLOTTAL OA' },
	[0x2D8B] = { unicodeslot=0x2D8B, category='lo', description='ETHIOPIC SYLLABLE ZOA' },
	[0x2D8C] = { unicodeslot=0x2D8C, category='lo', description='ETHIOPIC SYLLABLE DOA' },
	[0x2D8D] = { unicodeslot=0x2D8D, category='lo', description='ETHIOPIC SYLLABLE DDOA' },
	[0x2D8E] = { unicodeslot=0x2D8E, category='lo', description='ETHIOPIC SYLLABLE JOA' },
	[0x2D8F] = { unicodeslot=0x2D8F, category='lo', description='ETHIOPIC SYLLABLE THOA' },
	[0x2D90] = { unicodeslot=0x2D90, category='lo', description='ETHIOPIC SYLLABLE CHOA' },
	[0x2D91] = { unicodeslot=0x2D91, category='lo', description='ETHIOPIC SYLLABLE PHOA' },
	[0x2D92] = { unicodeslot=0x2D92, category='lo', description='ETHIOPIC SYLLABLE POA' },
	[0x2D93] = { unicodeslot=0x2D93, category='lo', description='ETHIOPIC SYLLABLE GGWA' },
	[0x2D94] = { unicodeslot=0x2D94, category='lo', description='ETHIOPIC SYLLABLE GGWI' },
	[0x2D95] = { unicodeslot=0x2D95, category='lo', description='ETHIOPIC SYLLABLE GGWEE' },
	[0x2D96] = { unicodeslot=0x2D96, category='lo', description='ETHIOPIC SYLLABLE GGWE' },
	[0x2DA0] = { unicodeslot=0x2DA0, category='lo', description='ETHIOPIC SYLLABLE SSA' },
	[0x2DA1] = { unicodeslot=0x2DA1, category='lo', description='ETHIOPIC SYLLABLE SSU' },
	[0x2DA2] = { unicodeslot=0x2DA2, category='lo', description='ETHIOPIC SYLLABLE SSI' },
	[0x2DA3] = { unicodeslot=0x2DA3, category='lo', description='ETHIOPIC SYLLABLE SSAA' },
	[0x2DA4] = { unicodeslot=0x2DA4, category='lo', description='ETHIOPIC SYLLABLE SSEE' },
	[0x2DA5] = { unicodeslot=0x2DA5, category='lo', description='ETHIOPIC SYLLABLE SSE' },
	[0x2DA6] = { unicodeslot=0x2DA6, category='lo', description='ETHIOPIC SYLLABLE SSO' },
	[0x2DA8] = { unicodeslot=0x2DA8, category='lo', description='ETHIOPIC SYLLABLE CCA' },
	[0x2DA9] = { unicodeslot=0x2DA9, category='lo', description='ETHIOPIC SYLLABLE CCU' },
	[0x2DAA] = { unicodeslot=0x2DAA, category='lo', description='ETHIOPIC SYLLABLE CCI' },
	[0x2DAB] = { unicodeslot=0x2DAB, category='lo', description='ETHIOPIC SYLLABLE CCAA' },
	[0x2DAC] = { unicodeslot=0x2DAC, category='lo', description='ETHIOPIC SYLLABLE CCEE' },
	[0x2DAD] = { unicodeslot=0x2DAD, category='lo', description='ETHIOPIC SYLLABLE CCE' },
	[0x2DAE] = { unicodeslot=0x2DAE, category='lo', description='ETHIOPIC SYLLABLE CCO' },
	[0x2DB0] = { unicodeslot=0x2DB0, category='lo', description='ETHIOPIC SYLLABLE ZZA' },
	[0x2DB1] = { unicodeslot=0x2DB1, category='lo', description='ETHIOPIC SYLLABLE ZZU' },
	[0x2DB2] = { unicodeslot=0x2DB2, category='lo', description='ETHIOPIC SYLLABLE ZZI' },
	[0x2DB3] = { unicodeslot=0x2DB3, category='lo', description='ETHIOPIC SYLLABLE ZZAA' },
	[0x2DB4] = { unicodeslot=0x2DB4, category='lo', description='ETHIOPIC SYLLABLE ZZEE' },
	[0x2DB5] = { unicodeslot=0x2DB5, category='lo', description='ETHIOPIC SYLLABLE ZZE' },
	[0x2DB6] = { unicodeslot=0x2DB6, category='lo', description='ETHIOPIC SYLLABLE ZZO' },
	[0x2DB8] = { unicodeslot=0x2DB8, category='lo', description='ETHIOPIC SYLLABLE CCHA' },
	[0x2DB9] = { unicodeslot=0x2DB9, category='lo', description='ETHIOPIC SYLLABLE CCHU' },
	[0x2DBA] = { unicodeslot=0x2DBA, category='lo', description='ETHIOPIC SYLLABLE CCHI' },
	[0x2DBB] = { unicodeslot=0x2DBB, category='lo', description='ETHIOPIC SYLLABLE CCHAA' },
	[0x2DBC] = { unicodeslot=0x2DBC, category='lo', description='ETHIOPIC SYLLABLE CCHEE' },
	[0x2DBD] = { unicodeslot=0x2DBD, category='lo', description='ETHIOPIC SYLLABLE CCHE' },
	[0x2DBE] = { unicodeslot=0x2DBE, category='lo', description='ETHIOPIC SYLLABLE CCHO' },
	[0x2DC0] = { unicodeslot=0x2DC0, category='lo', description='ETHIOPIC SYLLABLE QYA' },
	[0x2DC1] = { unicodeslot=0x2DC1, category='lo', description='ETHIOPIC SYLLABLE QYU' },
	[0x2DC2] = { unicodeslot=0x2DC2, category='lo', description='ETHIOPIC SYLLABLE QYI' },
	[0x2DC3] = { unicodeslot=0x2DC3, category='lo', description='ETHIOPIC SYLLABLE QYAA' },
	[0x2DC4] = { unicodeslot=0x2DC4, category='lo', description='ETHIOPIC SYLLABLE QYEE' },
	[0x2DC5] = { unicodeslot=0x2DC5, category='lo', description='ETHIOPIC SYLLABLE QYE' },
	[0x2DC6] = { unicodeslot=0x2DC6, category='lo', description='ETHIOPIC SYLLABLE QYO' },
	[0x2DC8] = { unicodeslot=0x2DC8, category='lo', description='ETHIOPIC SYLLABLE KYA' },
	[0x2DC9] = { unicodeslot=0x2DC9, category='lo', description='ETHIOPIC SYLLABLE KYU' },
	[0x2DCA] = { unicodeslot=0x2DCA, category='lo', description='ETHIOPIC SYLLABLE KYI' },
	[0x2DCB] = { unicodeslot=0x2DCB, category='lo', description='ETHIOPIC SYLLABLE KYAA' },
	[0x2DCC] = { unicodeslot=0x2DCC, category='lo', description='ETHIOPIC SYLLABLE KYEE' },
	[0x2DCD] = { unicodeslot=0x2DCD, category='lo', description='ETHIOPIC SYLLABLE KYE' },
	[0x2DCE] = { unicodeslot=0x2DCE, category='lo', description='ETHIOPIC SYLLABLE KYO' },
	[0x2DD0] = { unicodeslot=0x2DD0, category='lo', description='ETHIOPIC SYLLABLE XYA' },
	[0x2DD1] = { unicodeslot=0x2DD1, category='lo', description='ETHIOPIC SYLLABLE XYU' },
	[0x2DD2] = { unicodeslot=0x2DD2, category='lo', description='ETHIOPIC SYLLABLE XYI' },
	[0x2DD3] = { unicodeslot=0x2DD3, category='lo', description='ETHIOPIC SYLLABLE XYAA' },
	[0x2DD4] = { unicodeslot=0x2DD4, category='lo', description='ETHIOPIC SYLLABLE XYEE' },
	[0x2DD5] = { unicodeslot=0x2DD5, category='lo', description='ETHIOPIC SYLLABLE XYE' },
	[0x2DD6] = { unicodeslot=0x2DD6, category='lo', description='ETHIOPIC SYLLABLE XYO' },
	[0x2DD8] = { unicodeslot=0x2DD8, category='lo', description='ETHIOPIC SYLLABLE GYA' },
	[0x2DD9] = { unicodeslot=0x2DD9, category='lo', description='ETHIOPIC SYLLABLE GYU' },
	[0x2DDA] = { unicodeslot=0x2DDA, category='lo', description='ETHIOPIC SYLLABLE GYI' },
	[0x2DDB] = { unicodeslot=0x2DDB, category='lo', description='ETHIOPIC SYLLABLE GYAA' },
	[0x2DDC] = { unicodeslot=0x2DDC, category='lo', description='ETHIOPIC SYLLABLE GYEE' },
	[0x2DDD] = { unicodeslot=0x2DDD, category='lo', description='ETHIOPIC SYLLABLE GYE' },
	[0x2DDE] = { unicodeslot=0x2DDE, category='lo', description='ETHIOPIC SYLLABLE GYO' },
	[0x2E00] = { unicodeslot=0x2E00, category='po', description='RIGHT ANGLE SUBSTITUTION MARKER' },
	[0x2E01] = { unicodeslot=0x2E01, category='po', description='RIGHT ANGLE DOTTED SUBSTITUTION MARKER' },
	[0x2E02] = { unicodeslot=0x2E02, category='pi', description='LEFT SUBSTITUTION BRACKET' },
	[0x2E03] = { unicodeslot=0x2E03, category='pf', description='RIGHT SUBSTITUTION BRACKET' },
	[0x2E04] = { unicodeslot=0x2E04, category='pi', description='LEFT DOTTED SUBSTITUTION BRACKET' },
	[0x2E05] = { unicodeslot=0x2E05, category='pf', description='RIGHT DOTTED SUBSTITUTION BRACKET' },
	[0x2E06] = { unicodeslot=0x2E06, category='po', description='RAISED INTERPOLATION MARKER' },
	[0x2E07] = { unicodeslot=0x2E07, category='po', description='RAISED DOTTED INTERPOLATION MARKER' },
	[0x2E08] = { unicodeslot=0x2E08, category='po', description='DOTTED TRANSPOSITION MARKER' },
	[0x2E09] = { unicodeslot=0x2E09, category='pi', description='LEFT TRANSPOSITION BRACKET' },
	[0x2E0A] = { unicodeslot=0x2E0A, category='pf', description='RIGHT TRANSPOSITION BRACKET' },
	[0x2E0B] = { unicodeslot=0x2E0B, category='po', description='RAISED SQUARE' },
	[0x2E0C] = { unicodeslot=0x2E0C, category='pi', description='LEFT RAISED OMISSION BRACKET' },
	[0x2E0D] = { unicodeslot=0x2E0D, category='pf', description='RIGHT RAISED OMISSION BRACKET' },
	[0x2E0E] = { unicodeslot=0x2E0E, category='po', description='EDITORIAL CORONIS' },
	[0x2E0F] = { unicodeslot=0x2E0F, category='po', description='PARAGRAPHOS' },
	[0x2E10] = { unicodeslot=0x2E10, category='po', description='FORKED PARAGRAPHOS' },
	[0x2E11] = { unicodeslot=0x2E11, category='po', description='REVERSED FORKED PARAGRAPHOS' },
	[0x2E12] = { unicodeslot=0x2E12, category='po', description='HYPODIASTOLE' },
	[0x2E13] = { unicodeslot=0x2E13, category='po', description='DOTTED OBELOS' },
	[0x2E14] = { unicodeslot=0x2E14, category='po', description='DOWNWARDS ANCORA' },
	[0x2E15] = { unicodeslot=0x2E15, category='po', description='UPWARDS ANCORA' },
	[0x2E16] = { unicodeslot=0x2E16, category='po', description='DOTTED RIGHT-POINTING ANGLE' },
	[0x2E17] = { unicodeslot=0x2E17, category='pd', description='DOUBLE OBLIQUE HYPHEN' },
	[0x2E1C] = { unicodeslot=0x2E1C, category='pi', description='LEFT LOW PARAPHRASE BRACKET' },
	[0x2E1D] = { unicodeslot=0x2E1D, category='pf', description='RIGHT LOW PARAPHRASE BRACKET' },
	[0x2E80] = { unicodeslot=0x2E80, category='so', description='CJK RADICAL REPEAT' },
	[0x2E81] = { unicodeslot=0x2E81, category='so', description='CJK RADICAL CLIFF' },
	[0x2E82] = { unicodeslot=0x2E82, category='so', description='CJK RADICAL SECOND ONE' },
	[0x2E83] = { unicodeslot=0x2E83, category='so', description='CJK RADICAL SECOND TWO' },
	[0x2E84] = { unicodeslot=0x2E84, category='so', description='CJK RADICAL SECOND THREE' },
	[0x2E85] = { unicodeslot=0x2E85, category='so', description='CJK RADICAL PERSON' },
	[0x2E86] = { unicodeslot=0x2E86, category='so', description='CJK RADICAL BOX' },
	[0x2E87] = { unicodeslot=0x2E87, category='so', description='CJK RADICAL TABLE' },
	[0x2E88] = { unicodeslot=0x2E88, category='so', description='CJK RADICAL KNIFE ONE' },
	[0x2E89] = { unicodeslot=0x2E89, category='so', description='CJK RADICAL KNIFE TWO' },
	[0x2E8A] = { unicodeslot=0x2E8A, category='so', description='CJK RADICAL DIVINATION' },
	[0x2E8B] = { unicodeslot=0x2E8B, category='so', description='CJK RADICAL SEAL' },
	[0x2E8C] = { unicodeslot=0x2E8C, category='so', description='CJK RADICAL SMALL ONE' },
	[0x2E8D] = { unicodeslot=0x2E8D, category='so', description='CJK RADICAL SMALL TWO' },
	[0x2E8E] = { unicodeslot=0x2E8E, category='so', description='CJK RADICAL LAME ONE' },
	[0x2E8F] = { unicodeslot=0x2E8F, category='so', description='CJK RADICAL LAME TWO' },
	[0x2E90] = { unicodeslot=0x2E90, category='so', description='CJK RADICAL LAME THREE' },
	[0x2E91] = { unicodeslot=0x2E91, category='so', description='CJK RADICAL LAME FOUR' },
	[0x2E92] = { unicodeslot=0x2E92, category='so', description='CJK RADICAL SNAKE' },
	[0x2E93] = { unicodeslot=0x2E93, category='so', description='CJK RADICAL THREAD' },
	[0x2E94] = { unicodeslot=0x2E94, category='so', description='CJK RADICAL SNOUT ONE' },
	[0x2E95] = { unicodeslot=0x2E95, category='so', description='CJK RADICAL SNOUT TWO' },
	[0x2E96] = { unicodeslot=0x2E96, category='so', description='CJK RADICAL HEART ONE' },
	[0x2E97] = { unicodeslot=0x2E97, category='so', description='CJK RADICAL HEART TWO' },
	[0x2E98] = { unicodeslot=0x2E98, category='so', description='CJK RADICAL HAND' },
	[0x2E99] = { unicodeslot=0x2E99, category='so', description='CJK RADICAL RAP' },
	[0x2E9B] = { unicodeslot=0x2E9B, category='so', description='CJK RADICAL CHOKE' },
	[0x2E9C] = { unicodeslot=0x2E9C, category='so', description='CJK RADICAL SUN' },
	[0x2E9D] = { unicodeslot=0x2E9D, category='so', description='CJK RADICAL MOON' },
	[0x2E9E] = { unicodeslot=0x2E9E, category='so', description='CJK RADICAL DEATH' },
	[0x2E9F] = { unicodeslot=0x2E9F, category='so', description='CJK RADICAL MOTHER', specials={'compat',0x6BCD} },
	[0x2EA0] = { unicodeslot=0x2EA0, category='so', description='CJK RADICAL CIVILIAN' },
	[0x2EA1] = { unicodeslot=0x2EA1, category='so', description='CJK RADICAL WATER ONE' },
	[0x2EA2] = { unicodeslot=0x2EA2, category='so', description='CJK RADICAL WATER TWO' },
	[0x2EA3] = { unicodeslot=0x2EA3, category='so', description='CJK RADICAL FIRE' },
	[0x2EA4] = { unicodeslot=0x2EA4, category='so', description='CJK RADICAL PAW ONE' },
	[0x2EA5] = { unicodeslot=0x2EA5, category='so', description='CJK RADICAL PAW TWO' },
	[0x2EA6] = { unicodeslot=0x2EA6, category='so', description='CJK RADICAL SIMPLIFIED HALF TREE TRUNK' },
	[0x2EA7] = { unicodeslot=0x2EA7, category='so', description='CJK RADICAL COW' },
	[0x2EA8] = { unicodeslot=0x2EA8, category='so', description='CJK RADICAL DOG' },
	[0x2EA9] = { unicodeslot=0x2EA9, category='so', description='CJK RADICAL JADE' },
	[0x2EAA] = { unicodeslot=0x2EAA, category='so', description='CJK RADICAL BOLT OF CLOTH' },
	[0x2EAB] = { unicodeslot=0x2EAB, category='so', description='CJK RADICAL EYE' },
	[0x2EAC] = { unicodeslot=0x2EAC, category='so', description='CJK RADICAL SPIRIT ONE' },
	[0x2EAD] = { unicodeslot=0x2EAD, category='so', description='CJK RADICAL SPIRIT TWO' },
	[0x2EAE] = { unicodeslot=0x2EAE, category='so', description='CJK RADICAL BAMBOO' },
	[0x2EAF] = { unicodeslot=0x2EAF, category='so', description='CJK RADICAL SILK' },
	[0x2EB0] = { unicodeslot=0x2EB0, category='so', description='CJK RADICAL C-SIMPLIFIED SILK' },
	[0x2EB1] = { unicodeslot=0x2EB1, category='so', description='CJK RADICAL NET ONE' },
	[0x2EB2] = { unicodeslot=0x2EB2, category='so', description='CJK RADICAL NET TWO' },
	[0x2EB3] = { unicodeslot=0x2EB3, category='so', description='CJK RADICAL NET THREE' },
	[0x2EB4] = { unicodeslot=0x2EB4, category='so', description='CJK RADICAL NET FOUR' },
	[0x2EB5] = { unicodeslot=0x2EB5, category='so', description='CJK RADICAL MESH' },
	[0x2EB6] = { unicodeslot=0x2EB6, category='so', description='CJK RADICAL SHEEP' },
	[0x2EB7] = { unicodeslot=0x2EB7, category='so', description='CJK RADICAL RAM' },
	[0x2EB8] = { unicodeslot=0x2EB8, category='so', description='CJK RADICAL EWE' },
	[0x2EB9] = { unicodeslot=0x2EB9, category='so', description='CJK RADICAL OLD' },
	[0x2EBA] = { unicodeslot=0x2EBA, category='so', description='CJK RADICAL BRUSH ONE' },
	[0x2EBB] = { unicodeslot=0x2EBB, category='so', description='CJK RADICAL BRUSH TWO' },
	[0x2EBC] = { unicodeslot=0x2EBC, category='so', description='CJK RADICAL MEAT' },
	[0x2EBD] = { unicodeslot=0x2EBD, category='so', description='CJK RADICAL MORTAR' },
	[0x2EBE] = { unicodeslot=0x2EBE, category='so', description='CJK RADICAL GRASS ONE' },
	[0x2EBF] = { unicodeslot=0x2EBF, category='so', description='CJK RADICAL GRASS TWO' },
	[0x2EC0] = { unicodeslot=0x2EC0, category='so', description='CJK RADICAL GRASS THREE' },
	[0x2EC1] = { unicodeslot=0x2EC1, category='so', description='CJK RADICAL TIGER' },
	[0x2EC2] = { unicodeslot=0x2EC2, category='so', description='CJK RADICAL CLOTHES' },
	[0x2EC3] = { unicodeslot=0x2EC3, category='so', description='CJK RADICAL WEST ONE' },
	[0x2EC4] = { unicodeslot=0x2EC4, category='so', description='CJK RADICAL WEST TWO' },
	[0x2EC5] = { unicodeslot=0x2EC5, category='so', description='CJK RADICAL C-SIMPLIFIED SEE' },
	[0x2EC6] = { unicodeslot=0x2EC6, category='so', description='CJK RADICAL SIMPLIFIED HORN' },
	[0x2EC7] = { unicodeslot=0x2EC7, category='so', description='CJK RADICAL HORN' },
	[0x2EC8] = { unicodeslot=0x2EC8, category='so', description='CJK RADICAL C-SIMPLIFIED SPEECH' },
	[0x2EC9] = { unicodeslot=0x2EC9, category='so', description='CJK RADICAL C-SIMPLIFIED SHELL' },
	[0x2ECA] = { unicodeslot=0x2ECA, category='so', description='CJK RADICAL FOOT' },
	[0x2ECB] = { unicodeslot=0x2ECB, category='so', description='CJK RADICAL C-SIMPLIFIED CART' },
	[0x2ECC] = { unicodeslot=0x2ECC, category='so', description='CJK RADICAL SIMPLIFIED WALK' },
	[0x2ECD] = { unicodeslot=0x2ECD, category='so', description='CJK RADICAL WALK ONE' },
	[0x2ECE] = { unicodeslot=0x2ECE, category='so', description='CJK RADICAL WALK TWO' },
	[0x2ECF] = { unicodeslot=0x2ECF, category='so', description='CJK RADICAL CITY' },
	[0x2ED0] = { unicodeslot=0x2ED0, category='so', description='CJK RADICAL C-SIMPLIFIED GOLD' },
	[0x2ED1] = { unicodeslot=0x2ED1, category='so', description='CJK RADICAL LONG ONE' },
	[0x2ED2] = { unicodeslot=0x2ED2, category='so', description='CJK RADICAL LONG TWO' },
	[0x2ED3] = { unicodeslot=0x2ED3, category='so', description='CJK RADICAL C-SIMPLIFIED LONG' },
	[0x2ED4] = { unicodeslot=0x2ED4, category='so', description='CJK RADICAL C-SIMPLIFIED GATE' },
	[0x2ED5] = { unicodeslot=0x2ED5, category='so', description='CJK RADICAL MOUND ONE' },
	[0x2ED6] = { unicodeslot=0x2ED6, category='so', description='CJK RADICAL MOUND TWO' },
	[0x2ED7] = { unicodeslot=0x2ED7, category='so', description='CJK RADICAL RAIN' },
	[0x2ED8] = { unicodeslot=0x2ED8, category='so', description='CJK RADICAL BLUE' },
	[0x2ED9] = { unicodeslot=0x2ED9, category='so', description='CJK RADICAL C-SIMPLIFIED TANNED LEATHER' },
	[0x2EDA] = { unicodeslot=0x2EDA, category='so', description='CJK RADICAL C-SIMPLIFIED LEAF' },
	[0x2EDB] = { unicodeslot=0x2EDB, category='so', description='CJK RADICAL C-SIMPLIFIED WIND' },
	[0x2EDC] = { unicodeslot=0x2EDC, category='so', description='CJK RADICAL C-SIMPLIFIED FLY' },
	[0x2EDD] = { unicodeslot=0x2EDD, category='so', description='CJK RADICAL EAT ONE' },
	[0x2EDE] = { unicodeslot=0x2EDE, category='so', description='CJK RADICAL EAT TWO' },
	[0x2EDF] = { unicodeslot=0x2EDF, category='so', description='CJK RADICAL EAT THREE' },
	[0x2EE0] = { unicodeslot=0x2EE0, category='so', description='CJK RADICAL C-SIMPLIFIED EAT' },
	[0x2EE1] = { unicodeslot=0x2EE1, category='so', description='CJK RADICAL HEAD' },
	[0x2EE2] = { unicodeslot=0x2EE2, category='so', description='CJK RADICAL C-SIMPLIFIED HORSE' },
	[0x2EE3] = { unicodeslot=0x2EE3, category='so', description='CJK RADICAL BONE' },
	[0x2EE4] = { unicodeslot=0x2EE4, category='so', description='CJK RADICAL GHOST' },
	[0x2EE5] = { unicodeslot=0x2EE5, category='so', description='CJK RADICAL C-SIMPLIFIED FISH' },
	[0x2EE6] = { unicodeslot=0x2EE6, category='so', description='CJK RADICAL C-SIMPLIFIED BIRD' },
	[0x2EE7] = { unicodeslot=0x2EE7, category='so', description='CJK RADICAL C-SIMPLIFIED SALT' },
	[0x2EE8] = { unicodeslot=0x2EE8, category='so', description='CJK RADICAL SIMPLIFIED WHEAT' },
	[0x2EE9] = { unicodeslot=0x2EE9, category='so', description='CJK RADICAL SIMPLIFIED YELLOW' },
	[0x2EEA] = { unicodeslot=0x2EEA, category='so', description='CJK RADICAL C-SIMPLIFIED FROG' },
	[0x2EEB] = { unicodeslot=0x2EEB, category='so', description='CJK RADICAL J-SIMPLIFIED EVEN' },
	[0x2EEC] = { unicodeslot=0x2EEC, category='so', description='CJK RADICAL C-SIMPLIFIED EVEN' },
	[0x2EED] = { unicodeslot=0x2EED, category='so', description='CJK RADICAL J-SIMPLIFIED TOOTH' },
	[0x2EEE] = { unicodeslot=0x2EEE, category='so', description='CJK RADICAL C-SIMPLIFIED TOOTH' },
	[0x2EEF] = { unicodeslot=0x2EEF, category='so', description='CJK RADICAL J-SIMPLIFIED DRAGON' },
	[0x2EF0] = { unicodeslot=0x2EF0, category='so', description='CJK RADICAL C-SIMPLIFIED DRAGON' },
	[0x2EF1] = { unicodeslot=0x2EF1, category='so', description='CJK RADICAL TURTLE' },
	[0x2EF2] = { unicodeslot=0x2EF2, category='so', description='CJK RADICAL J-SIMPLIFIED TURTLE' },
	[0x2EF3] = { unicodeslot=0x2EF3, category='so', description='CJK RADICAL C-SIMPLIFIED TURTLE', specials={'compat',0x9F9F} },
	[0x2F00] = { unicodeslot=0x2F00, category='so', description='KANGXI RADICAL ONE', specials={'compat',0x4E00} },
	[0x2F01] = { unicodeslot=0x2F01, category='so', description='KANGXI RADICAL LINE', specials={'compat',0x4E28} },
	[0x2F02] = { unicodeslot=0x2F02, category='so', description='KANGXI RADICAL DOT', specials={'compat',0x4E36} },
	[0x2F03] = { unicodeslot=0x2F03, category='so', description='KANGXI RADICAL SLASH', specials={'compat',0x4E3F} },
	[0x2F04] = { unicodeslot=0x2F04, category='so', description='KANGXI RADICAL SECOND', specials={'compat',0x4E59} },
	[0x2F05] = { unicodeslot=0x2F05, category='so', description='KANGXI RADICAL HOOK', specials={'compat',0x4E85} },
	[0x2F06] = { unicodeslot=0x2F06, category='so', description='KANGXI RADICAL TWO', specials={'compat',0x4E8C} },
	[0x2F07] = { unicodeslot=0x2F07, category='so', description='KANGXI RADICAL LID', specials={'compat',0x4EA0} },
	[0x2F08] = { unicodeslot=0x2F08, category='so', description='KANGXI RADICAL MAN', specials={'compat',0x4EBA} },
	[0x2F09] = { unicodeslot=0x2F09, category='so', description='KANGXI RADICAL LEGS', specials={'compat',0x513F} },
	[0x2F0A] = { unicodeslot=0x2F0A, category='so', description='KANGXI RADICAL ENTER', specials={'compat',0x5165} },
	[0x2F0B] = { unicodeslot=0x2F0B, category='so', description='KANGXI RADICAL EIGHT', specials={'compat',0x516B} },
	[0x2F0C] = { unicodeslot=0x2F0C, category='so', description='KANGXI RADICAL DOWN BOX', specials={'compat',0x5182} },
	[0x2F0D] = { unicodeslot=0x2F0D, category='so', description='KANGXI RADICAL COVER', specials={'compat',0x5196} },
	[0x2F0E] = { unicodeslot=0x2F0E, category='so', description='KANGXI RADICAL ICE', specials={'compat',0x51AB} },
	[0x2F0F] = { unicodeslot=0x2F0F, category='so', description='KANGXI RADICAL TABLE', specials={'compat',0x51E0} },
	[0x2F10] = { unicodeslot=0x2F10, category='so', description='KANGXI RADICAL OPEN BOX', specials={'compat',0x51F5} },
	[0x2F11] = { unicodeslot=0x2F11, category='so', description='KANGXI RADICAL KNIFE', specials={'compat',0x5200} },
	[0x2F12] = { unicodeslot=0x2F12, category='so', description='KANGXI RADICAL POWER', specials={'compat',0x529B} },
	[0x2F13] = { unicodeslot=0x2F13, category='so', description='KANGXI RADICAL WRAP', specials={'compat',0x52F9} },
	[0x2F14] = { unicodeslot=0x2F14, category='so', description='KANGXI RADICAL SPOON', specials={'compat',0x5315} },
	[0x2F15] = { unicodeslot=0x2F15, category='so', description='KANGXI RADICAL RIGHT OPEN BOX', specials={'compat',0x531A} },
	[0x2F16] = { unicodeslot=0x2F16, category='so', description='KANGXI RADICAL HIDING ENCLOSURE', specials={'compat',0x5338} },
	[0x2F17] = { unicodeslot=0x2F17, category='so', description='KANGXI RADICAL TEN', specials={'compat',0x5341} },
	[0x2F18] = { unicodeslot=0x2F18, category='so', description='KANGXI RADICAL DIVIN