/*
 * Author: Matthew Farrellee <matt@cs.wisc.edu>
 */
package birdbath;

import condor.*;

import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;

public class Schedd
{
	private CondorScheddPortType port;

	public Schedd(URL endpoint)
	throws ServiceException
	{
		CondorScheddLocator locator = new CondorScheddLocator();
		port = locator.getcondorSchedd(endpoint);
	}

	public CondorScheddPortType getPort()
	{
		return port;
	}

	public Transaction createTransaction()
	{
		return new Transaction(port);
	}

	public void requestReschedule()
	throws RemoteException
	{
		Status status = port.requestReschedule();
		Utilities.checkAndThrowRemoteException(status);
	}

	public ClassAdStructAttr[] getJobAd(int cluster,
										int job)
	throws RemoteException
	{
		ClassAdStructAndStatus result = port.getJobAd(null, cluster, job);
		Utilities.checkAndThrowRemoteException(result.getStatus());

		return result.getClassAd();
	}

	public ClassAdStructAttr[][] getJobAds(String constraint)
	throws RemoteException
	{
		ClassAdStructArrayAndStatus result = port.getJobAds(null, constraint);
		Utilities.checkAndThrowRemoteException(result.getStatus());

		return result.getClassAdArray();
	}
}
