import birdbath.Transaction;
import condor.FileInfo;
import condor.UniverseType;
import java.io.File;
import java.io.FileOutputStream;
import junit.framework.AssertionFailedError;

public class ScheddTestCase7
	extends AbstractScheddTestCase
{
	protected void runTest()
		throws Throwable
	{
		File testFile = File.createTempFile("Schedd", "TestFile");
		testFile.deleteOnExit();
		FileOutputStream testFileOutput =
			new FileOutputStream(testFile);
		testFileOutput.write("Useless file!".getBytes());
		testFileOutput.close();

		Transaction transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		try
		{
			int cluster = transaction.createCluster();
			int job = transaction.createJob(cluster);

			transaction.sendFile(cluster, job, testFile);

			fail("SendFile() without DeclareFile() should have failed.");
		}
		finally
		{
			transaction.commit();
		}

		//fail("Commit should have failed, because the job is not submitted.");
	}
}
