import birdbath.Transaction;
import condor.FileInfo;
import condor.UniverseType;
import java.io.File;
import java.io.FileOutputStream;
import junit.framework.AssertionFailedError;

public class ScheddTestCase4
	extends AbstractScheddTestCase
{
	protected void runTest()
		throws Throwable
	{
		File testFile = File.createTempFile("Schedd", "TestFile");
		testFile.deleteOnExit();
		FileOutputStream testFileOutput =
			new FileOutputStream(testFile);
		testFileOutput.write("Useless file!".getBytes());
		testFileOutput.close();

		Transaction transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		int cluster;
		int job;
		File[] files = {testFile};

		try
		{
			cluster = transaction.createCluster();
			job = transaction.createJob(cluster);

			transaction.submit(cluster,
							   job,
							   null,
							   UniverseType.VANILLA,
							   "%systemroot%\\system32\\net",
							   "name",
							   "OpSys == \"WINNT50\"",
							   null,
							   files);
		}
		finally
		{
			transaction.commit();
		}

		transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		FileInfo[] spoolFiles;

		try
		{
			spoolFiles = transaction.listSpool(cluster, job);

			assertEquals(files.length, spoolFiles.length);

			transaction.closeSpool(cluster, job);
			transaction.removeJob(cluster, job, "Test completed.");
		}
		finally
		{
			transaction.commit();
		}

		transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		try
		{
			spoolFiles = transaction.listSpool(cluster, job);

			assertEquals(0, spoolFiles.length);
		}
		finally
		{
			transaction.commit();
		}
	}
}
