/*
 * Decompiled with CFR 0.152.
 */
package jnt.scimark2;

import jnt.Bench.Bench;
import jnt.Bench.Target;
import jnt.scimark2.Random;
import jnt.scimark2.kernel;

public class applet
implements Target {
    public double[] execute(Bench bench) {
        double[] dArray = new double[6];
        Random random = new Random(101010);
        double d = 2.0;
        double d2 = 1.0E-5;
        bench.noteStatus("Downloading FFT");
        dArray[1] = kernel.measureFFT(16, d2, random);
        Thread.yield();
        bench.noteStatus("Downloading SOR");
        dArray[2] = kernel.measureSOR(10, d2, random);
        Thread.yield();
        bench.noteStatus("Downloading Monte Carlo");
        dArray[3] = kernel.measureMonteCarlo(d2, random);
        Thread.yield();
        bench.noteStatus("Downloading Sparse Matrix Multplication");
        dArray[4] = kernel.measureSparseMatmult(10, 50, d2, random);
        Thread.yield();
        bench.noteStatus("Downloading LU factorization");
        dArray[5] = kernel.measureLU(10, d2, random);
        Thread.yield();
        bench.noteStatus("benchmarking FFT");
        dArray[1] = kernel.measureFFT(1024, d, random);
        bench.noteStatus("benchmarking SOR");
        dArray[2] = kernel.measureSOR(100, d, random);
        bench.noteStatus("benchmarking Monte Carlo");
        dArray[3] = kernel.measureMonteCarlo(d, random);
        bench.noteStatus("benchmarking Sparse Matrix Multplication");
        dArray[4] = kernel.measureSparseMatmult(1000, 5000, d, random);
        bench.noteStatus("benchmarking LU factorization");
        dArray[5] = kernel.measureLU(100, d, random);
        dArray[0] = (dArray[1] + dArray[2] + dArray[3] + dArray[4] + dArray[5]) / 5.0;
        if (dArray[1] == 0.0 || dArray[5] == 0.0) {
            dArray[5] = 0.0;
            dArray[4] = 0.0;
            dArray[3] = 0.0;
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
        return dArray;
    }
}

