/*
 * Decompiled with CFR 0.152.
 */
package jnt.scimark2;

public class Random {
    int seed = 0;
    private int[] m;
    private int i = 4;
    private int j = 16;
    private final int mdig = 32;
    private final int one = 1;
    private final int m1 = Integer.MAX_VALUE;
    private final int m2 = 65536;
    private double dm1 = 4.656612875245797E-10;
    private boolean haveRange = false;
    private double left = 0.0;
    private double right = 1.0;
    private double width = 1.0;

    public Random() {
        this.initialize((int)System.currentTimeMillis());
    }

    public Random(double d, double d2) {
        this.initialize((int)System.currentTimeMillis());
        this.left = d;
        this.right = d2;
        this.width = d2 - d;
        this.haveRange = true;
    }

    public Random(int n) {
        this.initialize(n);
    }

    public Random(int n, double d, double d2) {
        this.initialize(n);
        this.left = d;
        this.right = d2;
        this.width = d2 - d;
        this.haveRange = true;
    }

    private void initialize(int n) {
        this.seed = n;
        this.m = new int[17];
        int n2 = Math.min(Math.abs(n), Integer.MAX_VALUE);
        if (n2 % 2 == 0) {
            --n2;
        }
        int n3 = 9069;
        int n4 = 0;
        int n5 = n2 % 65536;
        int n6 = n2 / 65536;
        int n7 = 0;
        while (n7 < 17) {
            n2 = n5 * n3;
            n6 = (n2 / 65536 + n5 * n4 + n6 * n3) % 32768;
            n5 = n2 % 65536;
            this.m[n7] = n5 + 65536 * n6;
            ++n7;
        }
        this.i = 4;
        this.j = 16;
    }

    public final synchronized double nextDouble() {
        int n = this.m[this.i] - this.m[this.j];
        if (n < 0) {
            n += Integer.MAX_VALUE;
        }
        this.m[this.j] = n;
        this.i = this.i == 0 ? 16 : --this.i;
        this.j = this.j == 0 ? 16 : --this.j;
        if (this.haveRange) {
            return this.left + this.dm1 * (double)n * this.width;
        }
        return this.dm1 * (double)n;
    }

    public final synchronized void nextDoubles(double[] dArray) {
        int n = dArray.length;
        int n2 = n & 3;
        if (this.haveRange) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (n4 < 0) {
                    n4 += Integer.MAX_VALUE;
                }
                this.m[this.j] = n4;
                this.j = this.j == 0 ? 16 : --this.j;
                dArray[n3] = this.left + this.dm1 * (double)n4 * this.width;
                ++n3;
            }
        } else {
            int n5;
            int n6 = 0;
            while (n6 < n2) {
                n5 = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (n5 < 0) {
                    n5 += Integer.MAX_VALUE;
                }
                this.m[this.j] = n5;
                this.j = this.j == 0 ? 16 : --this.j;
                dArray[n6] = this.dm1 * (double)n5;
                ++n6;
            }
            n5 = n2;
            while (n5 < n) {
                int n7 = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (n7 < 0) {
                    n7 += Integer.MAX_VALUE;
                }
                this.m[this.j] = n7;
                this.j = this.j == 0 ? 16 : --this.j;
                dArray[n5] = this.dm1 * (double)n7;
                n7 = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (n7 < 0) {
                    n7 += Integer.MAX_VALUE;
                }
                this.m[this.j] = n7;
                this.j = this.j == 0 ? 16 : --this.j;
                dArray[n5 + 1] = this.dm1 * (double)n7;
                n7 = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (n7 < 0) {
                    n7 += Integer.MAX_VALUE;
                }
                this.m[this.j] = n7;
                this.j = this.j == 0 ? 16 : --this.j;
                dArray[n5 + 2] = this.dm1 * (double)n7;
                n7 = this.m[this.i] - this.m[this.j];
                this.i = this.i == 0 ? 16 : --this.i;
                if (n7 < 0) {
                    n7 += Integer.MAX_VALUE;
                }
                this.m[this.j] = n7;
                this.j = this.j == 0 ? 16 : --this.j;
                dArray[n5 + 3] = this.dm1 * (double)n7;
                n5 += 4;
            }
        }
    }
}

