/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt42.CallbackSink;
import condor.gahp.gt42.GSIUtils;
import condor.gahp.gt42.GramJobUtils;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.globus.axis.message.addressing.EndpointReferenceType;
import org.globus.exec.client.GramJob;
import org.globus.exec.utils.client.ManagedJobFactoryClientHelper;
import org.ietf.jgss.GSSCredential;

public class Gt42GramJobSubmitHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        String string;
        Integer n;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Integer n2 = null;
        CallbackSink callbackSink = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
            string2 = stringArray[3];
            string3 = stringArray[4];
            if (stringArray[5].length() > 0 && !stringArray[5].equals("NULL")) {
                string4 = stringArray[5];
            }
            string5 = stringArray[6];
            if (stringArray.length > 7 && !stringArray[7].equals("NULL")) {
                n2 = new Integer(stringArray[7]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        if (string4 != null && string4.length() > 0 && (callbackSink = CallbackSink.getCallbackSink(this.gahp, string4)) == null) {
            System.err.println("Unable to find notification sink manager " + string4);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        MyTask myTask = new MyTask(n, string, string5, string2, string3, callbackSink, this.gahp, n2, gSSCredential);
        return new CommandHandlerResponse("S", (Runnable)myTask);
    }

    class MyTask
    implements Runnable {
        public final String factoryAddr;
        public final String factoryType;
        public final String jobRSL;
        public final Integer requestId;
        public final String submitId;
        private CallbackSink callbackSink;
        private boolean fullDelegation;
        private String jobHandle = null;
        private GahpInterface gahp;
        private Integer termTime;
        private GSSCredential proxy;

        public MyTask(Integer n, String string, String string2, String string3, String string4, CallbackSink callbackSink, GahpInterface gahpInterface, Integer n2, GSSCredential gSSCredential) {
            this.factoryAddr = string3;
            this.factoryType = string4;
            this.jobRSL = string2;
            this.requestId = n;
            this.submitId = string;
            this.gahp = gahpInterface;
            this.fullDelegation = true;
            this.callbackSink = callbackSink;
            this.termTime = n2;
            this.proxy = gSSCredential;
        }

        public void run() {
            try {
                this.jobHandle = this.submitJob();
            }
            catch (Exception exception) {
                System.err.println("ERROR Submitting Job: " + exception.getMessage());
                exception.printStackTrace(System.err);
                String string = exception.toString();
                if (string == null) {
                    string = "unknown";
                }
                this.gahp.addResult(this.requestId, new String[]{"1", "NULL", string});
                return;
            }
            this.gahp.addResult(this.requestId, new String[]{"0", this.jobHandle, "NULL"});
        }

        private String submitJob() throws Exception {
            URL uRL = ManagedJobFactoryClientHelper.getServiceURL((String)this.factoryAddr).getURL();
            EndpointReferenceType endpointReferenceType = ManagedJobFactoryClientHelper.getFactoryEndpoint((URL)uRL, (String)this.factoryType);
            GramJob gramJob = new GramJob(this.jobRSL);
            GramJobUtils.setDefaultJobAttributes(gramJob, this.proxy);
            Date date = null;
            if (this.termTime != null) {
                long l = this.termTime.intValue();
                date = new Date(l *= 1000L);
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(10, 12);
                date = calendar.getTime();
            }
            gramJob.setTerminationTime(date);
            gramJob.setDelegationEnabled(false);
            gramJob.submit(endpointReferenceType, true, false, this.submitId);
            String string = gramJob.getHandle();
            if (this.callbackSink != null) {
                this.callbackSink.addJobListener(gramJob, string);
            }
            return string;
        }
    }
}

