/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt42.GSIUtils;
import condor.gahp.gt42.GramJobUtils;
import org.globus.exec.client.GramJob;
import org.ietf.jgss.GSSCredential;

public class Gt42GramJobStartHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n;
        String string = null;
        Object var4_3 = null;
        boolean bl = false;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        StartGramJob startGramJob = new StartGramJob(n, string, bl, this.gahp, gSSCredential);
        return new CommandHandlerResponse("S", (Runnable)startGramJob);
    }

    class StartGramJob
    implements Runnable {
        public final String jobHandle;
        public final Integer requestID;
        private String callbackContact;
        private GahpInterface gahp;
        private boolean fullDelegation;
        private GSSCredential proxy;

        public StartGramJob(Integer n, String string, boolean bl, GahpInterface gahpInterface, GSSCredential gSSCredential) {
            this.jobHandle = string;
            this.requestID = n;
            this.gahp = gahpInterface;
            this.fullDelegation = bl;
            this.proxy = gSSCredential;
        }

        public void run() {
            try {
                this.startJob();
            }
            catch (Exception exception) {
                System.err.println("Error starting job");
                exception.printStackTrace(System.err);
                String string = exception.toString();
                if (string == null) {
                    string = "unknown";
                }
                this.gahp.addResult(this.requestID, new String[]{"1", string});
                return;
            }
            this.gahp.addResult(this.requestID, new String[]{"0", "NULL"});
        }

        private boolean startJob() throws Exception {
            GramJob gramJob = new GramJob();
            gramJob.setHandle(this.jobHandle);
            GramJobUtils.setDefaultJobAttributes(gramJob, this.proxy);
            gramJob.release();
            return true;
        }
    }
}

