/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

/*!
  \class SoTabBoxManip SoTabBoxManip.h Inventor/manips/SoTabBoxManip.h
  \brief The SoTabBoxManip class wraps an SoTabBoxDragger.
  \ingroup manips

  <center>
  <img src="http://doc.coin3d.org/images/Coin/draggers/tabbox.png">
  </center>

  The SoTabBoxManip provides a convenient mechanism for the
  application programmer for setting up an SoTabBoxDragger in the
  scene connected to the relevant fields of an SoTransform node.

  The interaction from the end-user with the manipulator will then
  automatically influence the transformation matrix for the geometry
  following it in the scenegraph.
*/

#include <Inventor/manips/SoTabBoxManip.h>
#include <Inventor/nodes/SoSubNodeP.h>
#include <Inventor/nodes/SoSurroundScale.h>
#include <Inventor/draggers/SoTabBoxDragger.h>

SO_NODE_SOURCE(SoTabBoxManip);

// Doc in superclass.
void
SoTabBoxManip::initClass(void)
{
  SO_NODE_INTERNAL_INIT_CLASS(SoTabBoxManip);
}

/*!
  Constructor sets us up with an SoTabBoxDragger for manipulating a
  transformation.
*/
SoTabBoxManip::SoTabBoxManip(void)
{
  SO_NODE_INTERNAL_CONSTRUCTOR(SoTabBoxManip);

  SoTabBoxDragger *dragger = new SoTabBoxDragger;
  this->setDragger(dragger);

  SoSurroundScale *ss = (SoSurroundScale*) dragger->getPart("surroundScale", TRUE);
  ss->numNodesUpToContainer = 4;
  ss->numNodesUpToReset = 3;
}


/*!
  Protected destructor. (SoHandleBoxManip is automatically destructed
  when it's reference count goes to 0.)
 */
SoTabBoxManip::~SoTabBoxManip()
{
}
