/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_SBCYLINDERPLANEPROJECTOR_H
#define COIN_SBCYLINDERPLANEPROJECTOR_H

#include <Inventor/projectors/SbCylinderSectionProjector.h>


class COIN_DLL_API SbCylinderPlaneProjector : public SbCylinderSectionProjector {
  typedef SbCylinderSectionProjector inherited;

public:
  SbCylinderPlaneProjector(const float edgetol = 0.9f,
                           const SbBool orienttoeye = TRUE);
  SbCylinderPlaneProjector(const SbCylinder & cyl,
                           const float edgetol = 0.9f,
                           const SbBool orienttoeye = TRUE);

  virtual SbProjector * copy(void) const;
  virtual SbVec3f project(const SbVec2f & point);
  virtual SbRotation getRotation(const SbVec3f & point1,
                                 const SbVec3f & point2);

protected:
  SbRotation getRotation(const SbVec3f & point1, const SbBool tol1,
                         const SbVec3f & point2, const SbBool tol2);
};

#endif // !COIN_SBCYLINDERPLANEPROJECTOR_H
