# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import dbus, dbus.glib, gtk, gobject
import dbus.service

from telepathy.interfaces import CHANNEL_TYPE_TEXT, CHANNEL_TYPE_STREAMED_MEDIA, CHANNEL_HANDLER_INTERFACE
from cohoba.common.TelepathyConstants import MISSION_CONTROL_INTERFACE, MISSION_CONTROL_OBJECT_PATH, STREAM_ENGINE_BUS_NAME, STREAM_ENGINE_OBJECT_PATH

from cohoba.common.Utils import global_error_handler
from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.common.TelepathyConversation import TelepathyConversation
from cohoba.technobabble.TelepathyVoipGroup import TelepathyVoipGroup
from cohoba.technobabble.ui.ConversationWindowManager import get_conversation_window_manager
from cohoba.contacts.Contact import Contact

class TechnoBabbleChannelHandler(dbus.service.Object):	
	def __init__(self):
		bus_name = 'org.freedesktop.Telepathy.Cohoba.TechnoBabbleChannelHandler'
		object_path = '/org/freedesktop/Telepathy/Cohoba/TechnoBabbleChannelHandler'
		dbus.service.Object.__init__(self, dbus.service.BusName(bus_name), object_path)
		
		get_proxy_provider().create_proxy(
			MISSION_CONTROL_INTERFACE,
			MISSION_CONTROL_OBJECT_PATH)
		
		self.media_group_ids = {}
		
	@dbus.service.method(CHANNEL_HANDLER_INTERFACE, in_signature='sosouu', out_signature='')
	def HandleChannel(self, conn_name, conn_obj, channel_type, chan_obj, handle_type, handle):
		print 'Handle TechnoBabbleChannelHandler:\n\tconn %r\n\t(obj %r),\n\tchan type %r,\n\tchannel %r,\n\thandle (type %r) %r' % (conn_name, conn_obj, channel_type, chan_obj, handle_type, handle)
		get_proxy_provider().create_proxy(conn_name, conn_obj)
		if channel_type == CHANNEL_TYPE_TEXT:
			contact = Contact(conn_obj, handle, False)
			conv = TelepathyConversation(conn_obj, chan_obj, acknowledge_messages=True)
			window = get_conversation_window_manager().show(conn_obj, contact)
			print 'Adding text conversation to window'
			window.start_text(conv)
				
		elif channel_type == CHANNEL_TYPE_STREAMED_MEDIA:
			group = TelepathyVoipGroup(conn_obj, chan_obj)
			self.media_group_ids[chan_obj] = group.connect('updated', self.on_group_updated, conn_obj, chan_obj)
			
			get_proxy_provider().create_proxy(
				STREAM_ENGINE_BUS_NAME,
				STREAM_ENGINE_OBJECT_PATH)
			stream_engine_iface = get_proxy_provider().get_iface(
				STREAM_ENGINE_OBJECT_PATH,
				CHANNEL_HANDLER_INTERFACE)
			stream_engine_iface.HandleChannel(conn_name, conn_obj, channel_type, chan_obj, handle_type, handle,
				reply_handler=lambda :None,
				error_handler=global_error_handler)

	def on_group_updated(self, group, conn_obj, chan_obj):
		print 'Handler: Group updated:', group, group.other_handle
		if group.other_handle != None:
			group.disconnect(self.media_group_ids[chan_obj])
			del self.media_group_ids[chan_obj]
			
			contact = Contact(conn_obj, group.other_handle, False)
			window = get_conversation_window_manager().show(conn_obj, contact)
			print 'Adding Media to window'
			window.start_media(group)

			print 'Creating text channel'
			contact.action()
