import dbus, dbus.glib
import gtk, gtk.glade, gobject
from os.path import join
import cohoba

from cohoba.houston.ui.AccountsListView import AccountsListView
from cohoba.houston.ui.AccountEditor import AccountEditorManager
from cohoba.houston.AccountList import AccountList

class AccountsWindow(gtk.Window):
	def __init__(self):
		gtk.Window.__init__(self)		
		self.set_property("border_width", 12)
		self.set_property("window_position", gtk.WIN_POS_CENTER)
		
		glade = gtk.glade.XML(join(cohoba.SHARED_DATA_DIR, "accounts.glade"), "accounts_contents")
		# Glade Widgets
		self.add(glade.get_widget("accounts_contents"))
		
		self.accounts = AccountsListView()
		self.accounts.show()
		glade.get_widget("accounts_scroll").add(self.accounts)
		
		self.new = glade.get_widget("new")
		self.remove = glade.get_widget("remove")
		self.close = glade.get_widget("close")
		self.properties = glade.get_widget("properties")
		self.connect_button = glade.get_widget("connect")
		self.disconnect_button = glade.get_widget("disconnect")
		
		self.close.connect("clicked", lambda w: self.destroy())
		self.new.connect("clicked", self.on_new)
		self.remove.connect("clicked", self.on_remove)
		self.properties.connect('clicked', self.on_properties)
		self.connect_button.connect('clicked', self.on_connect)
		self.disconnect_button.connect('clicked', self.on_disconnect)
		self.accounts.get_selection().connect('changed', self.on_selection_changed)
		self.accounts.get_model().connect('row-changed', self.on_row_changed)
				
	def on_new(self, widget):
		AccountEditorManager().show_account_editor()
		
	def on_remove(self, widget):
		self.accounts.remove_selected()
	
	def on_properties(self, widget):
		self.accounts.show_selected_account_editor()
	
	def on_connect(self, widget):
		self.accounts.connect_selected()
		
	def on_disconnect(self, widget):
		self.accounts.disconnect_selected()
	
	def on_selection_changed(self, selection):
		model, iter = selection.get_selected()
		self.update_connect_buttons(iter)
		
	def on_row_changed(self, treemodel, path, iter):
		self.update_connect_buttons(iter)
		
	def update_connect_buttons(self, iter):
		# FIXME: When closing the account editor window, the model is none
		# We should disconnect signals and stuff, i guess
		if self.accounts.get_model() == None:
			return
		if iter == None:
			return
			
		account = self.accounts.get_model()[iter]
		self.connect_button.set_sensitive(account.is_connectable())
		self.disconnect_button.set_sensitive(account.is_connected())
	
