import gobject, dbus

from cohoba.common.DBusProxyProvider import get_proxy_provider
from cohoba.common.Utils import singleton

class NotificationManager(gobject.GObject):
	__gsignals__ = {
		"action" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [gobject.TYPE_STRING]),
	}
	def __init__(self):
		gobject.GObject.__init__(self)
		
		get_proxy_provider().create_proxy('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		self.notify_iface = get_proxy_provider().get_iface('/org/freedesktop/Notifications', 'org.freedesktop.Notifications')
		self.connected_to_sig = False
		
	def show(self, title, content, name="cohoba", image="cohoba", timeout=5000, actions=[]):
		if self.notify_iface != None:
			self.notify_iface.Notify(name, 0, image, title, content, actions, {}, timeout)
			# FIXME: Rather hackish way to detect if the proxy is running. Since only a mthod call triggers
			# Activation, then i first execute the method then connect, which is also racy.
			# No time for a proper fix right now.
			if not self.connected_to_sig:
				self.notify_iface.connect_to_signal('ActionInvoked', self.on_action_invoked)
				self.connected_to_sig = True
	
	def on_action_invoked(self, id, action):
		self.emit('action', action)
		
NotificationManager = singleton(NotificationManager)
