# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gtk, gobject

from telepathy.client.managerregistry import ManagerRegistry

from cohoba.common.Utils import singleton
from cohoba.common.PyListStore import PyListStore
from cohoba.common.Profile import get_profiles_for_protocol

class ProfileList(PyListStore):
	def __init__(self):
		PyListStore.__init__(self)
		
		print "Loading manager registry"
		reg = ManagerRegistry()
		reg.LoadManagers()
		protocols = reg.GetProtos()
		for protocol in protocols:
			print "Supported protocols include %r" % protocol
			managers = reg.GetManagers(protocol)
			profiles = get_profiles_for_protocol(protocol)
			for manager in managers:
				print "Protocol %r supported by %r" % (protocol, manager)
				for profile in profiles:
					self.append(profile(protocol, manager, reg.GetBusName(manager), reg.GetObjectPath(manager), reg.GetParams(manager, protocol)))
	
	def find(self, manager, profile_name):
		for profile in self:
			if profile.manager == manager and profile.name == profile_name:
				return profile
				
ProfileList = singleton(ProfileList)
