import py

class Session(object):
    """
        A Session gets test Items from Collectors, # executes the
        Items and sends the Outcome to the Reporter.
    """
    def __init__(self, config): 
        self._memo = []
        self.config = config 

    def shouldclose(self): 
        return False 

    def header(self, colitems):
        """ setup any neccessary resources. """
        if not self.config.option.nomagic:
            py.magic.invoke(assertion=1)

    def footer(self, colitems):
        """ teardown any resources we know about. """
        py.test.Function.state.teardown_all()
        if not self.config.option.nomagic:
            py.magic.revoke(assertion=1)

    def start(self, colitem): 
        pass 

    def finish(self, colitem, outcome): 
        self._memo.append((colitem, outcome))

    def startiteration(self, colitem, subitems): 
        pass 

    def getitemoutcomepairs(self, cls): 
        return [x for x in self._memo if isinstance(x[1], cls)]

    def warning(self, msg): 
        raise Warning(msg) 

    def main(self, args): 
        """ main loop for running tests. """
        colitems = self._map2colitems(args) 
        try:
            self.header(colitems) 
            try:
                for colitem in colitems: 
                    colitem.option = self.config.option
                    self.runtraced(colitem)
            except KeyboardInterrupt: 
                raise 
            except: 
                self.footer(colitems) 
            else: 
                self.footer(colitems) 
        except Exit, ex:
            pass
        # return [(fspath as string, [names as string])]
        return [(str(item.listchain()[0].fspath), item.listnames())
                for item, outcome in self.getitemoutcomepairs(py.test.Item.Failed)]

    def runtraced(self, colitem):
        if self.shouldclose(): 
            raise Exit, "received external close signal" 

        outcome = None 
        colitem.startcapture() 
        try: 
            self.start(colitem)
            try: 
                try:
                    if colitem._stickyfailure: 
                        raise colitem._stickyfailure 
                    outcome = self.run(colitem) 
                except (KeyboardInterrupt, Exit): 
                    raise 
                except colitem.Outcome, outcome: 
                    if outcome.excinfo is None: 
                        outcome.excinfo = py.code.ExceptionInfo() 
                except: 
                    excinfo = py.code.ExceptionInfo() 
                    outcome = colitem.Failed(excinfo=excinfo) 
                assert (outcome is None or 
                        isinstance(outcome, (list, colitem.Outcome)))
            finally: 
                self.finish(colitem, outcome) 
            if isinstance(outcome, colitem.Failed) and self.config.option.exitfirst:
                py.test.exit("exit on first problem configured.", item=colitem)
        finally: 
            colitem.finishcapture()

    def run(self, colitem): 
        if self.config.option.collectonly and isinstance(colitem, py.test.Item): 
            return 
        if isinstance(colitem, py.test.Item): 
            self.skipbykeyword(colitem)
        res = colitem.run() 
        if res is None: 
            return py.test.Item.Passed() 
        elif not isinstance(res, (list, tuple)): 
            raise TypeError("%r.run() returned neither "
                            "list, tuple nor None: %r" % (colitem, res))
        else: 
            finish = self.startiteration(colitem, res)
            try: 
                for name in res: 
                    obj = colitem.join(name) 
                    assert obj is not None 
                    self.runtraced(obj) 
            finally: 
                if finish: 
                    finish() 
        return res 

    def skipbykeyword(self, colitem): 
        keyword = self.config.option.keyword
        if not keyword: 
            return 
        chain = colitem.listchain()
        for key in filter(None, keyword.split()): 
            eor = key[:1] == '-' 
            if eor: 
                key = key[1:]
            if not (eor ^ self._matchonekeyword(key, chain)): 
                py.test.skip("test not selected by keyword %r" %(keyword,))

    def _matchonekeyword(self, key, chain): 
        for subitem in chain: 
            if subitem.haskeyword(key): 
                return True 
        return False


    def _map2colitems(items): 
        # first convert all path objects into collectors 
        from py.__.test.collect import getfscollector 
        colitems = []
        for item in items: 
            if isinstance(item, (list, tuple)): 
                colitems.extend(Session._map2colitems(item))
            elif not isinstance(item, py.test.collect.Collector): 
                colitems.append(getfscollector(item))
            else:
                colitems.append(item)
        return colitems 
    _map2colitems = staticmethod(_map2colitems) 

class Exit(Exception):
    """ for immediate program exits without tracebacks and reporter/summary. """
    def __init__(self, msg="unknown reason", item=None):
        self.msg = msg 
        Exception.__init__(self, msg)

def exit(msg, item=None): 
    raise Exit(msg=msg, item=item)

