import py
from py.__.rest import directive
from py.__.misc import rest
from py.__.rest.latex import process_rest_file
from shared_helpers import is_on_path

datadir = py.magic.autopath().dirpath().join("data")

def test_graphviz_html():
    if not is_on_path("dot"):
        py.test.skip("graphviz needed")
    directive.BackendStore("html")
    #for reasons that elude me rest.process expects svnwcs???
    if not is_on_path("svn"):
        py.test.skip("svn needed")
    txt = py.path.svnwc(datadir.join("graphviz.txt"))
    html = txt.new(ext="html")
    png = datadir.join("example1.png")
    rest.process(txt)
    assert html.check()
    assert png.check()
    html_content = html.read()
    assert png.basename in html_content
    html.remove()
    png.remove()

def test_graphviz_pdf():
    if is_on_path("dot") or not is_on_path("latex"):
        py.test.skip("graphviz and latex needed")

    directive.BackendStore("latex")
    txt = py.path.local(datadir.join("graphviz.txt"))
    pdf = txt.new(ext="pdf")
    dotpdf = datadir.join("example1.pdf")
    process_rest_file(txt)
    assert pdf.check()
    assert dotpdf.check()
    pdf.remove()
    dotpdf.remove()
   
