import sys
import py
from py.__.misc.simplecapture import SimpleOutErrCapture, callcapture

def test_capturing_simple():
    cap = SimpleOutErrCapture()
    print "hello world"
    print >>sys.stderr, "hello error"
    out, err = cap.reset()
    assert out == "hello world\n"
    assert err == "hello error\n"

def test_capturing_twice_error():
    cap = SimpleOutErrCapture()
    print "hello"
    cap.reset()
    py.test.raises(AttributeError, "cap.reset()")

def test_capturing_modify_sysouterr_in_between():
    oldout = sys.stdout 
    olderr = sys.stderr 
    cap = SimpleOutErrCapture()
    print "hello",
    print >>sys.stderr, "world",
    sys.stdout = py.std.StringIO.StringIO() 
    sys.stderr = py.std.StringIO.StringIO() 
    print "not seen" 
    print >>sys.stderr, "not seen"
    out, err = cap.reset()
    assert out == "hello"
    assert err == "world"
    assert sys.stdout == oldout 
    assert sys.stderr == olderr 

def test_capturing_error_recursive():
    cap = SimpleOutErrCapture()
    cap2 = SimpleOutErrCapture()
    print "hello"
    cap2.reset()
    py.test.raises(AttributeError, "cap2.reset()")

def test_callcapture(): 
    def func(x, y): 
        print x
        print >>py.std.sys.stderr, y
        return 42
   
    res, out, err = callcapture(func, 3, y=4) 
    assert res == 42 
    assert out.startswith("3") 
    assert err.startswith("4") 
    
