import py
import sys

class File(object): 
    def __init__(self, f): 
        assert hasattr(f, 'write')
        assert isinstance(f, file) or not hasattr(f, 'open') 
        self._file = f 

    def __call__(self, msg): 
        print >>self._file, str(msg)

class Path(File): 
    def __init__(self, filename, append=False): 
        mode = append and 'a' or 'w'
        f = open(str(filename), mode, buffering=1)
        super(Path, self).__init__(f) 

def STDOUT(msg): 
    print >>sys.stdout, str(msg) 

def STDERR(msg): 
    print >>sys.stderr, str(msg) 
    
def setconsumer(keywords, consumer): 
    # normalize to tuples 
    if isinstance(keywords, str): 
        keywords = tuple(map(None, keywords.split()))
    elif hasattr(keywords, 'keywords'): 
        keywords = keywords.keywords 
    elif not isinstance(keywords, tuple): 
        raise TypeError("key %r is not a string or tuple" % (keywords,))
    if consumer is not None and not callable(consumer): 
        if not hasattr(consumer, 'write'): 
            raise TypeError("%r should be None, callable or file-like" % (consumer,))
        consumer = File(consumer)
    py.log.Producer.keywords2consumer[keywords] = consumer 

