
import py

def setup_module(mod): 
    mod.tmpdir = py.test.ensuretemp('docdoctest')

def test_doctest_basic(): 
    # XXX get rid of the next line: 
    py.magic.autopath().dirpath('conftest.py').copy(tmpdir.join('conftest.py'))
    tmpdir.ensure('__init__.py')

    xtxt = tmpdir.join('x.txt')
    xtxt.write(py.code.Source("""
        .. 
           >>> from os.path import abspath 

        hello world 

           >>> assert abspath 
           >>> i=3
           >>> print i
           3

        yes yes

            >>> i
            3

        end
    """))
    config, args = py.test.Config.parse([str(xtxt)]) 
    session = config.getsessionclass()(config, py.std.sys.stdout)
    session.main([xtxt]) 
    l = session.getitemoutcomepairs(py.test.Item.Failed)
    assert len(l) == 0 
    l = session.getitemoutcomepairs(py.test.Item.Passed)
    assert len(l) == 2
