//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : tagsmanagementdlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __tagsmanagementdlg__
#define __tagsmanagementdlg__

/**
@file
Subclass of TagsManagementBaseDlg, which is generated by wxFormBuilder.
*/

#include "tagsmanagementbasedlg.h"
#include <wx/filename.h>

/** Implementing TagsManagementBaseDlg */
class TagsManagementDlg : public TagsManagementBaseDlg
{
	long m_itemDb;
	long m_itemPath;

	long IsFileExist(const wxFileName &filename);
	void DoDeleteItem(long item);
	long DoAddItem(const wxFileName &fn, bool isActive);
	void DoLoadPathsTable(const wxFileName &fn);

protected:
	// Handlers for TagsManagementBaseDlg events.
	void OnTagsDbDeSelected( wxListEvent& event );
	void OnTagsDbSelected( wxListEvent& event );
	void OnTagsDbActivated(wxListEvent &event);
	void OnAddDatabase( wxCommandEvent& event );
	void OnRemoveDatabase( wxCommandEvent& event );
	void OnRemoveDatabaseUI( wxUpdateUIEvent& event );
	void OnOk(wxCommandEvent &e);
	void OnSetActive(wxCommandEvent &e);
	void OnFixPaths(wxCommandEvent &e);
	void OnItemRightClick(wxListEvent &e);
	void OnRemoveTagsGeneratedFromPath(wxCommandEvent &e);

public:
	/** Constructor */
	TagsManagementDlg( wxWindow* parent );
	virtual ~TagsManagementDlg();
};

#endif // __tagsmanagementdlg__
