#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/Spacegroups/Symop/Algebra.pm \
               src/lib/perl5/COD/Spacegroups/Symop/Parse.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2017-01-24 16:48:31 +0200 (Tue, 24 Jan 2017) $ 
#$Revision: 4795 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.0.1/tests/shtests/symop_algebra_002.sh $
#------------------------------------------------------------------------------
#*
#  Unit-test the Spacegroups::Symop::Algebra module
#**

use strict;
use warnings;

use COD::Spacegroups::Symop::Algebra qw( symop_translate symop_mul symop_invert );
use COD::Spacegroups::Symop::Parse qw( symop_print );

sub print_symop_inverse
{
    my ($symop1) = @_;

    symop_print( $symop1 );
    print "\n";

    my $symop2 = symop_invert( $symop1 );

    symop_print( $symop2 );
    print "=" x 79, "\n";
}

print_symop_inverse(
    [[ 1, 0, 0, 0.5],
     [ 0,-1, 0, 0  ],
     [ 0, 0,-1, 0  ],
     [ 0, 0, 0, 1  ]],
);

print_symop_inverse(
    [[-1, 0, 0, 0  ],
     [ 0, 1, 0, 0.5],
     [ 0, 0,-1, 0  ],
     [ 0, 0, 0, 1  ]]
);

print_symop_inverse(
    [[-1, 0, 0, 0 ],
     [ 0,-1, 0, 0 ],
     [ 0, 0,-1, 0 ],
     [ 0, 0, 0, 1 ]]
);

END_SCRIPT
