#------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2015-11-12 13:22:42 +0200 (Kt, 12 lapkr. 2015) $ 
#$Revision: 4271 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.3/src/lib/perl5/COD/Serialise.pm $
#------------------------------------------------------------------------

package COD::Serialise;

use strict;
use warnings;

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(
    serialiseHash
    serialiseArray
    serialiseRef
    serialiseScalar
);

my $separator = "#-------------------------\n";

sub serialiseRef
{
    my $ref = shift;
    my $indent = ( scalar(@_) != 0 ? shift : "" ) ;
    if( ref($ref) eq "ARRAY" ) {
        &serialiseArray( $ref, $indent );
    } elsif( ref($ref) eq "HASH" ) {
        &serialiseHash( $ref, $indent );
    } elsif( ref($ref) eq "SCALAR" ) {
        &serialiseScalar( $ref, $indent );
    } else {
        print $ref;
    }
}

sub serialiseHash
{
   my $hash = shift;
   my $indent = ( scalar(@_) != 0 ? shift : "" ) ;

   ## printf STDOUT "\n" unless $indent eq "";
   ## print STDOUT $indent, "{\n";
   print STDOUT "{\n";
   my $old_indent = $indent;
   $indent .= " " x 3;
   foreach my $key ( sort {$a cmp $b} keys %{$hash} ) {
       printf STDOUT "%s%-5s => ", $indent, '"' . $key . '"';
       if( ref $hash->{$key} eq "HASH" ) {
           serialiseHash( $hash->{$key}, $indent );
       } elsif( ref $hash->{$key} eq "ARRAY" ) {
           serialiseArray( $hash->{$key}, $indent );
       } elsif( ref $hash->{$key} eq "SCALAR" ) {
           serialiseScalar( $hash->{$key}, $indent );
       } else {
           if( defined $hash->{$key} ) {
               printf STDOUT "\"%s\",\n", $hash->{$key};
           } else {
               print STDOUT "undef,\n";
           }
       }
   }
   print STDOUT $old_indent, "},\n";
   print STDOUT $separator if $old_indent eq "";
}

sub serialiseArray
{
   my $array = shift;
   my $indent = ( scalar(@_) != 0 ? shift : "" ) ;

   my $isFlat = 1;
   if( int(@{$array}) > 100 ) {
       $isFlat = 0;
   } else {
       foreach my $item ( @{$array} ) {
           if( defined $item && (ref $item or length($item) > 20 )) {
               $isFlat = 0; last;
           }
       }
   }
   my $old_indent = $indent;
   if( $isFlat ) {
       local $" = ", ";
       my @val = map { defined $_ ? "\"$_\"" : "undef" } @{$array};
       print STDOUT "[ @val ],\n";
   } else {
       ## printf STDOUT "\n" unless $indent eq "";
       ## print STDOUT $indent, "[\n";
       print STDOUT "[\n";

       $indent .= " " x 3;
       my $index = 0;
       foreach my $item ( @{$array} ) {
           if( ref $item eq "HASH" ) {
               printf STDOUT "%s# %3d:\n%s", $indent, $index++, $indent;
                   serialiseHash( $item, $indent );
           } elsif( ref $item eq "ARRAY" ) {
               printf STDOUT "%s# %3d:\n%s", $indent, $index++, $indent;
               serialiseArray( $item, $indent );
           } elsif( ref $item eq "SCALAR" ) {
               printf STDOUT "%s# %3d:\n%s", $indent, $index++, $indent;
               serialiseScalar( $item, $indent );
           } else {
               if( defined $item ) {
                   printf STDOUT "%s# %3s:\n%s\"%s\",\n", $indent, $index++,
                   $indent, $item;
               } else {
                   printf STDOUT "%s# %3s:\n%s%s,\n", $indent, $index++,
                   $indent, "undef";
               }
           }
       }
       print STDOUT $old_indent, "],\n";
   }
   print STDOUT $separator if $old_indent eq "";
}

sub serialiseScalar
{
   my $scalar = shift;
   my $indent = ( scalar(@_) != 0 ? shift : "" ) ;

   my $value = $$scalar;

   if( ref $value ) {
       serialiseRef( $value, $indent );
   } else {
       print '\"', $$scalar, '",', "\n";
   }
}

1;
