#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULES='src/lib/perl5/COD/CIF/Tags/Print.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: andrius $
#$Date: 2017-10-25 17:54:33 +0300 (Wed, 25 Oct 2017) $ 
#$Revision: 5655 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.1/tests/shtests/cif_print_loop_001.sh $
#------------------------------------------------------------------------------
#*
#  Unit test for the COD::CIF::Tags::Print::print_loop() subroutine.
#**

use strict;
use warnings;

use COD::CIF::Tags::Print;

# Test the way a properly formed loop is printed
my $data_block =
{
  'tags'   =>   [ '_a', '_b', '_c' ],
  'loops'  => [ [ '_a', '_b', '_c' ] ],
  'inloop' => {
        '_a' => 0,
        '_b' => 0,
        '_c' => 0,
  },
  'values' => {
        '_a' => [ 5, 4, 3, 2, 1 ],
        '_b' => [ 1, 2, 3, 4, 5 ],
        '_c' => [ 3, 3, 2, 3, 3 ],
   }
};

COD::CIF::Tags::Print::print_loop( '_a', 0, $data_block );

END_SCRIPT
