/*
 * This file is part of Cockpit.
 *
 * Copyright (C) 2014 Red Hat, Inc.
 *
 * Cockpit is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * Cockpit is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Cockpit; If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __COCKPIT_WEBCERTIFICATE_H__
#define __COCKPIT_WEBCERTIFICATE_H__

#include <stdbool.h>

char *  cockpit_certificate_locate   (bool missing_ok, char **error);
char *  cockpit_certificate_key_path (const char *certfile);
int     cockpit_certificate_parse    (const char *file, char **cert, char **key);

#endif /* __COCKPIT_WEBCERTIFICATE_H__ */
