/*
*
* capability.c - test program for COBEX, trying to fetch the capability.
*
* Copyright (c) 2004,2005,2006 Fredrik Srensson
*
* History:
* v0.1 - fsn - 06-01-19 - First version
*
* Source:
*
*/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <signal.h>
#include <string.h>

#include "cobex_core.h"
#include "cobex_tools.h"
#include "cobex_serial.h"


// Main routine

int main (int argc, char *argv[]) {
	v24_port_t *UsedPort=NULL;
	static char IRMCSYNC[]={ 0x49, 0x52, 0x4d, 0x43, 0x2d, 0x53, 0x59, 0x4e, 0x43, 0x00 };
	char fsBrowser[]={ 0xf9, 0xec, 0x7b, 0xc4, 0x95, 0x3c, 0x11, 0xd2, 0x98, 0x4e, 0x52, 0x54, 0x00, 0xdc, 0x9e, 0x09, 0x00};
	int rc;

	//char fileName[80];
	char aBuffer[513];
	obex_packet aPacket;

	aPacket.max=512;
	aPacket.buffer=aBuffer;
		
	if (argc != 2) {fprintf (stderr,"ERR: Wrong argc : %d.\n",argc);return COBEX_ERR;}

	// Set up the port
	UsedPort = cobex_openPort(argv[1]);
	ctools_installSignalhandler();
	ctools_setup_state(UsedPort);

	// Do some testing
	if (cobex_testComm(UsedPort)) {
		fputs ("ERR: Comms testing failed.\n",stderr);
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}	

	// Go obex
	if (ctools_connect(UsedPort)) {
		fputs ("ERR: OBEX connect failed.\n",stderr);
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}	

	// Do an obex connect
	obex_opcode_connect( &aPacket );
	obex_hi_target ( &aPacket, IRMCSYNC , 9 );
	cobex_packlgt( &aPacket );

	if (cobex_packet_send(&aPacket, UsedPort) != COBEX_OK) {
		printf ("ERR: Didn't send connect.\n");
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}

	if ( cobex_packet_recieve(&aPacket, UsedPort) != COBEX_OK) {
		printf ("ERR: Didn't recieve response\n");
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}
	
	// Do capability.
	rc=ctools_getFileByType( &aPacket, "x-obex/capability", UsedPort );
	
	if (cobex_response_code(&aPacket) != (OBEX_RESPONSE_OK|OBEX_FINAL_BIT) ) { 
		fprintf (stderr, "ERR: %s \n",
			cobex_respstring(cobex_response_code(&aPacket)) ) ;
	}
			
	// Bye, y'all!

	rc = ctools_disconnect( &aPacket, UsedPort );
	cobex_closePort(UsedPort);

	return rc;
}
