"""
A image instance represents a ISO or virt image we want to track
and repeatedly install.  It differs from a answer-file based installation.

Copyright 2006-2009, Red Hat, Inc and Others
Michael DeHaan <michael.dehaan AT gmail>

This software may be freely redistributed under the terms of the GNU
general public license.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301  USA.
"""

import item_image as image
import utils
import collection
from cexceptions import *
from utils import _
import action_litesync

#--------------------------------------------

class Images(collection.Collection):

    def collection_type(self):
        return "image"

    def factory_produce(self,config,seed_data):
        """
        Return a Distro forged from seed_data
        """
        return image.Image(config).from_datastruct(seed_data)

    def remove(self,name,with_delete=True,with_sync=True,with_triggers=True,recursive=True, logger=None):
        """
        Remove element named 'name' from the collection
        """

        # NOTE: with_delete isn't currently meaningful for repos
        # but is left in for consistancy in the API.  Unused.

        name = name.lower()

        # first see if any Groups use this distro
        if not recursive:
            for v in self.config.systems():
                if v.image is not None and v.image.lower() == name:
                    raise CX(_("removal would orphan system: %s") % v.name)

        obj = self.find(name=name)

        if obj is not None:

            if recursive:
                kids = obj.get_children()
                for k in kids:
                    self.config.api.remove_system(k, recursive=True, logger=logger)

            if with_delete:
                if with_triggers:
                    utils.run_triggers(self.config.api, obj, "/var/lib/cobbler/triggers/delete/image/pre/*", [], logger)
                if with_sync:
                    lite_sync = action_litesync.BootLiteSync(self.config, logger=logger)
                    lite_sync.remove_single_image(name)

            self.lock.acquire()
            try:
                del self.listing[name]
            finally:
                self.lock.release()
            self.config.serialize_delete(self, obj)

            if with_delete:
                if with_triggers:
                    utils.run_triggers(self.config.api, obj, "/var/lib/cobbler/triggers/delete/image/post/*", [], logger)
                    utils.run_triggers(self.config.api, obj, "/var/lib/cobbler/triggers/change/*", [], logger)

            return True

        raise CX(_("cannot delete an object that does not exist: %s") % name)
