/*
 * Time-stamp: <98/11/05 15:20:37 panic>
 * Author:	The C-Mix Project <cmix@diku.dk>
 *         	Peter Holst Andersen <txix@diku.dk>
 *              Arne John Glenstrup  <panic@diku.dk>
 * Contents:	Functions declarations for creating the scene: create_*
 */

#ifndef __CREATE_H
#define __CREATE_H

#include "ray.h"

surfaceT create_simple_surface(myfloat am, myfloat di,
			       myfloat re, myfloat tr, myfloat ref, int specpow);

surfaceT create_color_surface(myfloat am, myfloat di,
			      myfloat re, myfloat tr, myfloat ref, int specpow,
			      myfloat red, myfloat green, myfloat blue);

surfaceT create_special_color_surface(myfloat amred, myfloat amgreen, myfloat amblue,
				      myfloat dired, myfloat digreen, myfloat diblue,
				      myfloat re, myfloat tr, myfloat ref, int specpow);

surfaceT create_checked_surface(surfaceT s1, surfaceT s2, myfloat checksize);

objectT create_disc(myfloat cx, myfloat cy, myfloat cz,
		    myfloat nx, myfloat ny, myfloat nz,
		    myfloat vx, myfloat vy, myfloat vz,
		    myfloat r, int s);

objectT create_square(myfloat cx, myfloat cy, myfloat cz,
		      myfloat nx, myfloat ny, myfloat nz,
		      myfloat vx, myfloat vy, myfloat vz,
		      myfloat r, int s);

objectT create_sphere(myfloat x, myfloat y, myfloat z,
		      myfloat nx, myfloat ny, myfloat nz,
		      myfloat r, int s);

lightT create_light(myfloat r, myfloat g, myfloat b,
		    myfloat x, myfloat y, myfloat z);

#endif
