#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "mtrix.h"
#ifndef __CMIX
#  define __CMIX(X)
#endif

#pragma cmix pure: printstatus()
extern void printstatus(char*, int);
extern char* Malloc(size_t);

vector solve(matrix A, vector B) {
  /* Solve for and return x in the equation Ax = B */
  /* Assumption: det A != 0                        */
  int i, ii, j;
  float e;
  /* create diagonal matrix */
  for (i = 0; i < M; i++) {
    if (A.e[i][i] == 0.0) {          /* if zero in diagonal,      */
      for (ii = i + 1; ii < M; ii++)
	if (A.e[ii][i] != 0) break;  /* find non-zero in column i */
      for (j = i; j < M; j++)        /* and add that row to row i */
	A.e[i][j] += A.e[ii][j];
      B.e[i] += B.e[ii];
    }
    /* create unit in diagonal    */
    e = A.e[i][i];
    for (j = i; j < M; j++) A.e[i][j] /= e; 
    B.e[i] /= e;
    /* create zeros in other rows */
    for (ii = 0; ii < M; ii++)
      if (ii != i) {
	e = A.e[ii][i];
	for (j = i; j < M; j++) A.e[ii][j] -= A.e[i][j] * e;
	B.e[ii] -= B.e[i] * e;
      }
  }
  return B;
}

vector mulMatVec(matrix A, vector x) {
  int i, j;
  vector B;
  for (i = 0; i < M; i++) B.e[i] = 0;
  for (i = 0; i < M; i++)
    for (j = 0; j < M; j++) B.e[i] += A.e[i][j] * x.e[j];
  return B;
}

char* printMatrix(matrix A) {
  int i, j;
  char* s; char ss[14];
  s  = (char*)Malloc(((14 * M + 2) * M + 1) * sizeof(char));
  strcpy(s, "");
  for (i = 0; i < M; i++) {
    for (j = 0; j < M; j++) {
      sprintf(ss,"%9.7g ", A.e[i][j]); strcat(s, ss);
    }
    strcat(s,"\n");
  }
  return s;
}

char* printVector(vector B) {
  int i;
  char* s;
  char ss[14];
  s  = (char*)Malloc(((14 * M + 2) + 1) * sizeof(char));
  strcpy(s, "");
  for (i = 0; i < M; i++) {
    sprintf(ss,"%9.7g ", B.e[i]); strcat(s, ss);
  }
  return s;
}

#define RANDMAX 19999
#define nextrand(s) (s = (s + 1799) % RANDMAX)

matrix makeMatrix(unsigned int seed) {
  int i, j;
  matrix A;
  for (i = 0; i < M; i++)
    for (j = 0; j < M; j++) {
      A.e[i][j] = (float)nextrand(seed) / RANDMAX;
      if (i == j) A.e[i][j] += 42;
    }
  return A;
}

vector makeVector(unsigned int seed) {
  int i;
  vector B;
  for (i = 0; i < M; i++) B.e[i] = (float)nextrand(seed) / RANDMAX;
  return B;
}

vector goal(unsigned int Aseed, int n) {
  int i;
  matrix A;
  vector x, b;
  i = 1;
  A = makeMatrix(Aseed);
  while (i < n) {
    x = makeVector(i * 523 % RANDMAX);
    b = mulMatVec(A, x);
    printstatus("/* solving A * x(i) = b for i = %d */\n", i);
    solve(A, b);
    i++;
  }
  x = makeVector(i * 523 % RANDMAX);
  b = mulMatVec(A, x);
  return solve(A, b);
}
