# pylint: skip-file
"""
Database of known property names
NOTE: this file is automatically generated by the script
python -Bm cmake_format.tools.parse_cmake_help properties
"""
import re


PATTERNS = [
    "(?P<CONFIG>.*)_OUTPUT_NAME",
    "(?P<CONFIG>.*)_POSTFIX",
    "(?P<LANG>.*)_CLANG_TIDY",
    "(?P<LANG>.*)_COMPILER_LAUNCHER",
    "(?P<LANG>.*)_CPPCHECK",
    "(?P<LANG>.*)_CPPLINT",
    "(?P<LANG>.*)_INCLUDE_WHAT_YOU_USE",
    "(?P<LANG>.*)_VISIBILITY_PRESET",
    "ABSTRACT",
    "ADDITIONAL_MAKE_CLEAN_FILES",
    "ADVANCED",
    "ALIASED_TARGET",
    "ALLOW_DUPLICATE_CUSTOM_TARGETS",
    "ANDROID_ANT_ADDITIONAL_OPTIONS",
    "ANDROID_API",
    "ANDROID_API_MIN",
    "ANDROID_ARCH",
    "ANDROID_ASSETS_DIRECTORIES",
    "ANDROID_GUI",
    "ANDROID_JAR_DEPENDENCIES",
    "ANDROID_JAR_DIRECTORIES",
    "ANDROID_JAVA_SOURCE_DIR",
    "ANDROID_NATIVE_LIB_DEPENDENCIES",
    "ANDROID_NATIVE_LIB_DIRECTORIES",
    "ANDROID_PROCESS_MAX",
    "ANDROID_PROGUARD",
    "ANDROID_PROGUARD_CONFIG_PATH",
    "ANDROID_SECURE_PROPS_PATH",
    "ANDROID_SKIP_ANT_STEP",
    "ANDROID_STL_TYPE",
    "ARCHIVE_OUTPUT_DIRECTORY",
    "ARCHIVE_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "ARCHIVE_OUTPUT_NAME",
    "ARCHIVE_OUTPUT_NAME_(?P<CONFIG>.*)",
    "ATTACHED_FILES",
    "ATTACHED_FILES_ON_FAIL",
    "AUTOGEN_BUILD_DIR",
    "AUTOGEN_SOURCE_GROUP",
    "AUTOGEN_TARGETS_FOLDER",
    "AUTOGEN_TARGET_DEPENDS",
    "AUTOMOC",
    "AUTOMOC_COMPILER_PREDEFINES",
    "AUTOMOC_DEPEND_FILTERS",
    "AUTOMOC_MACRO_NAMES",
    "AUTOMOC_MOC_OPTIONS",
    "AUTOMOC_SOURCE_GROUP",
    "AUTOMOC_TARGETS_FOLDER",
    "AUTORCC",
    "AUTORCC_OPTIONS",
    "AUTORCC_OPTIONS",
    "AUTORCC_SOURCE_GROUP",
    "AUTOUIC",
    "AUTOUIC_OPTIONS",
    "AUTOUIC_OPTIONS",
    "AUTOUIC_SEARCH_PATHS",
    "BINARY_DIR",
    "BINARY_DIR",
    "BUILDSYSTEM_TARGETS",
    "BUILD_RPATH",
    "BUILD_WITH_INSTALL_NAME_DIR",
    "BUILD_WITH_INSTALL_RPATH",
    "BUNDLE",
    "BUNDLE_EXTENSION",
    "CACHE_VARIABLES",
    "CLEAN_NO_CUSTOM",
    "CMAKE_CONFIGURE_DEPENDS",
    "CMAKE_CXX_KNOWN_FEATURES",
    "CMAKE_C_KNOWN_FEATURES",
    "COMPATIBLE_INTERFACE_BOOL",
    "COMPATIBLE_INTERFACE_NUMBER_MAX",
    "COMPATIBLE_INTERFACE_NUMBER_MIN",
    "COMPATIBLE_INTERFACE_STRING",
    "COMPILE_DEFINITIONS",
    "COMPILE_DEFINITIONS",
    "COMPILE_DEFINITIONS",
    "COMPILE_DEFINITIONS_(?P<CONFIG>.*)",
    "COMPILE_DEFINITIONS_(?P<CONFIG>.*)",
    "COMPILE_DEFINITIONS_(?P<CONFIG>.*)",
    "COMPILE_FEATURES",
    "COMPILE_FLAGS",
    "COMPILE_FLAGS",
    "COMPILE_OPTIONS",
    "COMPILE_OPTIONS",
    "COMPILE_PDB_NAME",
    "COMPILE_PDB_NAME_(?P<CONFIG>.*)",
    "COMPILE_PDB_OUTPUT_DIRECTORY",
    "COMPILE_PDB_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "COST",
    "CPACK_DESKTOP_SHORTCUTS",
    "CPACK_NEVER_OVERWRITE",
    "CPACK_PERMANENT",
    "CPACK_STARTUP_SHORTCUTS",
    "CPACK_START_MENU_SHORTCUTS",
    "CPACK_WIX_ACL",
    "CROSSCOMPILING_EMULATOR",
    "CUDA_EXTENSIONS",
    "CUDA_PTX_COMPILATION",
    "CUDA_RESOLVE_DEVICE_SYMBOLS",
    "CUDA_SEPARABLE_COMPILATION",
    "CUDA_STANDARD",
    "CUDA_STANDARD_REQUIRED",
    "CXX_EXTENSIONS",
    "CXX_STANDARD",
    "CXX_STANDARD_REQUIRED",
    "C_EXTENSIONS",
    "C_STANDARD",
    "C_STANDARD_REQUIRED",
    "DEBUG_CONFIGURATIONS",
    "DEBUG_POSTFIX",
    "DEFINE_SYMBOL",
    "DEFINITIONS",
    "DEPENDS",
    "DEPLOYMENT_REMOTE_DIRECTORY",
    "DISABLED",
    "DISABLED_FEATURES",
    "ECLIPSE_EXTRA_NATURES",
    "ENABLED_FEATURES",
    "ENABLED_LANGUAGES",
    "ENABLE_EXPORTS",
    "ENVIRONMENT",
    "EXCLUDE_FROM_ALL",
    "EXCLUDE_FROM_ALL",
    "EXCLUDE_FROM_DEFAULT_BUILD",
    "EXCLUDE_FROM_DEFAULT_BUILD_(?P<CONFIG>.*)",
    "EXPORT_NAME",
    "EXTERNAL_OBJECT",
    "EchoString",
    "FAIL_REGULAR_EXPRESSION",
    "FIND_LIBRARY_USE_LIB32_PATHS",
    "FIND_LIBRARY_USE_LIB64_PATHS",
    "FIND_LIBRARY_USE_LIBX32_PATHS",
    "FIND_LIBRARY_USE_OPENBSD_VERSIONING",
    "FIXTURES_CLEANUP",
    "FIXTURES_REQUIRED",
    "FIXTURES_SETUP",
    "FOLDER",
    "FRAMEWORK",
    "FRAMEWORK_VERSION",
    "Fortran_FORMAT",
    "Fortran_FORMAT",
    "Fortran_MODULE_DIRECTORY",
    "GENERATED",
    "GENERATOR_FILE_NAME",
    "GENERATOR_IS_MULTI_CONFIG",
    "GLOBAL_DEPENDS_DEBUG_MODE",
    "GLOBAL_DEPENDS_NO_CYCLES",
    "GNUtoMS",
    "HAS_CXX",
    "HEADER_FILE_ONLY",
    "HELPSTRING",
    "IMPLICIT_DEPENDS_INCLUDE_TRANSFORM",
    "IMPLICIT_DEPENDS_INCLUDE_TRANSFORM",
    "IMPORTED",
    "IMPORTED_CONFIGURATIONS",
    "IMPORTED_IMPLIB",
    "IMPORTED_IMPLIB_(?P<CONFIG>.*)",
    "IMPORTED_LIBNAME",
    "IMPORTED_LIBNAME_(?P<CONFIG>.*)",
    "IMPORTED_LINK_DEPENDENT_LIBRARIES",
    "IMPORTED_LINK_DEPENDENT_LIBRARIES_(?P<CONFIG>.*)",
    "IMPORTED_LINK_INTERFACE_LANGUAGES",
    "IMPORTED_LINK_INTERFACE_LANGUAGES_(?P<CONFIG>.*)",
    "IMPORTED_LINK_INTERFACE_LIBRARIES",
    "IMPORTED_LINK_INTERFACE_LIBRARIES_(?P<CONFIG>.*)",
    "IMPORTED_LINK_INTERFACE_MULTIPLICITY",
    "IMPORTED_LINK_INTERFACE_MULTIPLICITY_(?P<CONFIG>.*)",
    "IMPORTED_LOCATION",
    "IMPORTED_LOCATION_(?P<CONFIG>.*)",
    "IMPORTED_NO_SONAME",
    "IMPORTED_NO_SONAME_(?P<CONFIG>.*)",
    "IMPORTED_OBJECTS",
    "IMPORTED_OBJECTS_(?P<CONFIG>.*)",
    "IMPORTED_SONAME",
    "IMPORTED_SONAME_(?P<CONFIG>.*)",
    "IMPORT_PREFIX",
    "IMPORT_SUFFIX",
    "INCLUDE_DIRECTORIES",
    "INCLUDE_DIRECTORIES",
    "INCLUDE_REGULAR_EXPRESSION",
    "INSTALL_NAME_DIR",
    "INSTALL_RPATH",
    "INSTALL_RPATH_USE_LINK_PATH",
    "INTERFACE_AUTOUIC_OPTIONS",
    "INTERFACE_COMPILE_DEFINITIONS",
    "INTERFACE_COMPILE_FEATURES",
    "INTERFACE_COMPILE_OPTIONS",
    "INTERFACE_INCLUDE_DIRECTORIES",
    "INTERFACE_LINK_LIBRARIES",
    "INTERFACE_POSITION_INDEPENDENT_CODE",
    "INTERFACE_SOURCES",
    "INTERFACE_SYSTEM_INCLUDE_DIRECTORIES",
    "INTERPROCEDURAL_OPTIMIZATION",
    "INTERPROCEDURAL_OPTIMIZATION",
    "INTERPROCEDURAL_OPTIMIZATION_(?P<CONFIG>.*)",
    "INTERPROCEDURAL_OPTIMIZATION_(?P<CONFIG>.*)",
    "IN_TRY_COMPILE",
    "IOS_INSTALL_COMBINED",
    "JOB_POOLS",
    "JOB_POOL_COMPILE",
    "JOB_POOL_LINK",
    "KEEP_EXTENSION",
    "LABELS",
    "LABELS",
    "LABELS",
    "LABELS",
    "LANGUAGE",
    "LIBRARY_OUTPUT_DIRECTORY",
    "LIBRARY_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "LIBRARY_OUTPUT_NAME",
    "LIBRARY_OUTPUT_NAME_(?P<CONFIG>.*)",
    "LINKER_LANGUAGE",
    "LINK_DEPENDS",
    "LINK_DEPENDS_NO_SHARED",
    "LINK_DIRECTORIES",
    "LINK_FLAGS",
    "LINK_FLAGS_(?P<CONFIG>.*)",
    "LINK_INTERFACE_LIBRARIES",
    "LINK_INTERFACE_LIBRARIES_(?P<CONFIG>.*)",
    "LINK_INTERFACE_MULTIPLICITY",
    "LINK_INTERFACE_MULTIPLICITY_(?P<CONFIG>.*)",
    "LINK_LIBRARIES",
    "LINK_SEARCH_END_STATIC",
    "LINK_SEARCH_START_STATIC",
    "LINK_WHAT_YOU_USE",
    "LISTFILE_STACK",
    "LOCATION",
    "LOCATION",
    "LOCATION_(?P<CONFIG>.*)",
    "MACOSX_BUNDLE",
    "MACOSX_BUNDLE_INFO_PLIST",
    "MACOSX_FRAMEWORK_INFO_PLIST",
    "MACOSX_PACKAGE_LOCATION",
    "MACOSX_RPATH",
    "MACROS",
    "MANUALLY_ADDED_DEPENDENCIES",
    "MAP_IMPORTED_CONFIG_(?P<CONFIG>.*)",
    "MEASUREMENT",
    "MODIFIED",
    "NAME",
    "NO_SONAME",
    "NO_SYSTEM_FROM_IMPORTED",
    "OBJECT_DEPENDS",
    "OBJECT_OUTPUTS",
    "OSX_ARCHITECTURES",
    "OSX_ARCHITECTURES_(?P<CONFIG>.*)",
    "OUTPUT_NAME",
    "OUTPUT_NAME_(?P<CONFIG>.*)",
    "PACKAGES_FOUND",
    "PACKAGES_NOT_FOUND",
    "PARENT_DIRECTORY",
    "PASS_REGULAR_EXPRESSION",
    "PDB_NAME",
    "PDB_NAME_(?P<CONFIG>.*)",
    "PDB_OUTPUT_DIRECTORY",
    "PDB_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "POSITION_INDEPENDENT_CODE",
    "POST_INSTALL_SCRIPT",
    "PREDEFINED_TARGETS_FOLDER",
    "PREFIX",
    "PRE_INSTALL_SCRIPT",
    "PRIVATE_HEADER",
    "PROCESSORS",
    "PROJECT_LABEL",
    "PUBLIC_HEADER",
    "REPORT_UNDEFINED_PROPERTIES",
    "REQUIRED_FILES",
    "RESOURCE",
    "RESOURCE_LOCK",
    "RULE_LAUNCH_COMPILE",
    "RULE_LAUNCH_COMPILE",
    "RULE_LAUNCH_COMPILE",
    "RULE_LAUNCH_CUSTOM",
    "RULE_LAUNCH_CUSTOM",
    "RULE_LAUNCH_CUSTOM",
    "RULE_LAUNCH_LINK",
    "RULE_LAUNCH_LINK",
    "RULE_LAUNCH_LINK",
    "RULE_MESSAGES",
    "RUNTIME_OUTPUT_DIRECTORY",
    "RUNTIME_OUTPUT_DIRECTORY_(?P<CONFIG>.*)",
    "RUNTIME_OUTPUT_NAME",
    "RUNTIME_OUTPUT_NAME_(?P<CONFIG>.*)",
    "RUN_SERIAL",
    "SKIP_AUTOGEN",
    "SKIP_AUTOMOC",
    "SKIP_AUTORCC",
    "SKIP_AUTOUIC",
    "SKIP_BUILD_RPATH",
    "SKIP_RETURN_CODE",
    "SOURCES",
    "SOURCE_DIR",
    "SOURCE_DIR",
    "SOVERSION",
    "STATIC_LIBRARY_FLAGS",
    "STATIC_LIBRARY_FLAGS_(?P<CONFIG>.*)",
    "STRINGS",
    "SUBDIRECTORIES",
    "SUFFIX",
    "SYMBOLIC",
    "TARGET_ARCHIVES_MAY_BE_SHARED_LIBS",
    "TARGET_MESSAGES",
    "TARGET_SUPPORTS_SHARED_LIBS",
    "TEST_INCLUDE_FILE",
    "TEST_INCLUDE_FILES",
    "TIMEOUT",
    "TIMEOUT_AFTER_MATCH",
    "TYPE",
    "TYPE",
    "USE_FOLDERS",
    "VALUE",
    "VARIABLES",
    "VERSION",
    "VISIBILITY_INLINES_HIDDEN",
    "VS_CONFIGURATION_TYPE",
    "VS_COPY_TO_OUT_DIR",
    "VS_CSHARP_(?P<tagname>.*)",
    "VS_DEBUGGER_WORKING_DIRECTORY",
    "VS_DEPLOYMENT_CONTENT",
    "VS_DEPLOYMENT_LOCATION",
    "VS_DESKTOP_EXTENSIONS_VERSION",
    "VS_DOTNET_REFERENCEPROP_(?P<refname>.*)_TAG_(?P<tagname>.*)",
    "VS_DOTNET_REFERENCES",
    "VS_DOTNET_REFERENCES_COPY_LOCAL",
    "VS_DOTNET_REFERENCE_(?P<refname>.*)",
    "VS_DOTNET_TARGET_FRAMEWORK_VERSION",
    "VS_GLOBAL_(?P<variable>.*)",
    "VS_GLOBAL_KEYWORD",
    "VS_GLOBAL_PROJECT_TYPES",
    "VS_GLOBAL_ROOTNAMESPACE",
    "VS_GLOBAL_SECTION_POST_(?P<section>.*)",
    "VS_GLOBAL_SECTION_PRE_(?P<section>.*)",
    "VS_INCLUDE_IN_VSIX",
    "VS_IOT_EXTENSIONS_VERSION",
    "VS_IOT_STARTUP_TASK",
    "VS_KEYWORD",
    "VS_MOBILE_EXTENSIONS_VERSION",
    "VS_RESOURCE_GENERATOR",
    "VS_SCC_AUXPATH",
    "VS_SCC_LOCALPATH",
    "VS_SCC_PROJECTNAME",
    "VS_SCC_PROVIDER",
    "VS_SDK_REFERENCES",
    "VS_SHADER_ENTRYPOINT",
    "VS_SHADER_FLAGS",
    "VS_SHADER_MODEL",
    "VS_SHADER_OUTPUT_HEADER_FILE",
    "VS_SHADER_TYPE",
    "VS_SHADER_VARIABLE_NAME",
    "VS_STARTUP_PROJECT",
    "VS_TOOL_OVERRIDE",
    "VS_USER_PROPS",
    "VS_WINDOWS_TARGET_PLATFORM_MIN_VERSION",
    "VS_WINRT_COMPONENT",
    "VS_WINRT_EXTENSIONS",
    "VS_WINRT_REFERENCES",
    "VS_XAML_TYPE",
    "WILL_FAIL",
    "WIN32_EXECUTABLE",
    "WINDOWS_EXPORT_ALL_SYMBOLS",
    "WORKING_DIRECTORY",
    "WRAP_EXCLUDE",
    "XCODE_ATTRIBUTE_(?P<an_attribute>.*)",
    "XCODE_EMIT_EFFECTIVE_PLATFORM_NAME",
    "XCODE_EXPLICIT_FILE_TYPE",
    "XCODE_EXPLICIT_FILE_TYPE",
    "XCODE_FILE_ATTRIBUTES",
    "XCODE_LAST_KNOWN_FILE_TYPE",
    "XCODE_PRODUCT_TYPE",
    "XCTEST",
]


def stripped_patterns():
  regex = re.compile(r"\?P<[\w_]+>")
  return [regex.sub("", pattern) for pattern in PATTERNS]


CASE_SENSITIVE_REGEX = re.compile(
    "|".join(stripped_patterns()))
CASE_INSENSITIVE_REGEX = re.compile(
    "|".join(stripped_patterns()), re.IGNORECASE)
