//##########################################################################
//#                                                                        #
//#                            CLOUDCOMPARE                                #
//#                                                                        #
//#  This program is free software; you can redistribute it and/or modify  #
//#  it under the terms of the GNU General Public License as published by  #
//#  the Free Software Foundation; version 2 of the License.               #
//#                                                                        #
//#  This program is distributed in the hope that it will be useful,       #
//#  but WITHOUT ANY WARRANTY; without even the implied warranty of        #
//#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
//#  GNU General Public License for more details.                          #
//#                                                                        #
//#          COPYRIGHT: EDF R&D / TELECOM ParisTech (ENST-TSI)             #
//#                                                                        #
//##########################################################################

#ifndef CC_PLUGIN_INTERFACE_HEADER
#define CC_PLUGIN_INTERFACE_HEADER

//qCC_db
#include <ccObject.h> //for CC_QT5 def

//Qt
#include <QObject>
#include <QString>
#include <QIcon>

//Qt version
#include <qglobal.h>
#ifndef CC_QT5
	#if (QT_VERSION >= QT_VERSION_CHECK(5, 0, 0))
		#define CC_QT5
	#endif
#endif

class ccExternalFactory;
class ccCommandLineInterface;

//! Plugin type
enum  CC_PLUGIN_TYPE {	CC_STD_PLUGIN               = 1,
						CC_GL_FILTER_PLUGIN         = 2,
						CC_IO_FILTER_PLUGIN         = 4,
};

//! Standard CC plugin interface
/** Version 3.0
**/
class ccPluginInterface
{
public:

	//! Virtual destructor
	virtual ~ccPluginInterface() {}

	//! Returns plugin type (standard or OpenGL filter)
	virtual CC_PLUGIN_TYPE getType() const = 0;

	//! Returns (short) name (for menu entry, etc.)
	virtual QString getName() const = 0;

	//! Returns long name/description (for tooltip, etc.)
	virtual QString getDescription() const = 0;

	//! Returns icon
	/** Should be reimplemented if necessary
	**/
	virtual QIcon getIcon() const { return QIcon(); }

	//! Starts the plugin
	/** Should be reimplemented if necessary.
		Used when 'starting' a plugin from the command line
		(to start a background service, a thread, etc.)
	**/
	virtual bool start() { return true; }

	//! Stops the plugin
	/** Should be reimplemented if necessary.
		Used to stop a plugin previously started (see ccPluginInterface::start).
	**/
	virtual void stop() { }

	//! Returns the plugin's custom object factory (if any)
	/** Plugins may provide a factory to build custom objects.
		This allows qCC_db to properly code and decode the custom
		objects stream in BIN files. Custom objects must inherit the
		ccCustomHObject or ccCustomLeafObject interfaces.
	**/
	virtual ccExternalFactory* getCustomObjectsFactory() const { return 0; }

	//! Optional: registers commands (for the command line mode)
	/** Does nothing by default.
		\warning: don't use keywords that are already used by the main application or other plugins!
			(use a unique prefix for all commands if possible)
	**/
	virtual void registerCommands(ccCommandLineInterface* cmd) {}
};

Q_DECLARE_INTERFACE(ccPluginInterface, "edf.rd.CloudCompare.ccPluginInterface/3.0")

#endif //CC_PLUGIN_INTERFACE_HEADER
