# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# This file is part of clive.
#
# clive is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# clive is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with clive.  If not, see <http://www.gnu.org/licenses/>.
###########################################################################

## The singleton classes

__all__ = ['Singleton']

## The singleton class
class Singleton(object):
    # Inheritable singleton from http://en.wikipedia.org/wiki/Singleton_pattern
    # with some minor changes.
    instances = {}
    def __new__(self, *args, **kwargs):
        if Singleton.instances.get(self) is None:
            self.__original_init__ = self.__init__
            Singleton.instances[self] = object.__new__(self, *args, **kwargs)
        elif self.__init__ == self.__original_init__:
            def nothing(*args, **kwargs): pass
            self.__init__ = nothing
        return Singleton.instances[self]
